{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GtkIconView@ is a widget which displays data in a grid of icons.
-- 
-- \<picture>
--   \<source srcset=\"icon-view-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkIconView\" src=\"icon-view.png\">
-- \<\/picture>
-- 
-- @GtkIconView@ provides an alternative view on a @GtkTreeModel@.
-- It displays the model as a grid of icons with labels. Like
-- t'GI.Gtk.Objects.TreeView.TreeView', it allows to select one or multiple items
-- (depending on the selection mode, see 'GI.Gtk.Objects.IconView.iconViewSetSelectionMode').
-- In addition to selection with the arrow keys, @GtkIconView@ supports
-- rubberband selection, which is controlled by dragging the pointer.
-- 
-- Note that if the tree model is backed by an actual tree store (as
-- opposed to a flat list where the mapping to icons is obvious),
-- @GtkIconView@ will only display the first level of the tree and
-- ignore the tree’s branches.
-- 
-- == CSS nodes
-- 
-- 
-- 	
-- >iconview.view
-- >╰── [rubberband]
-- 
-- 
-- @GtkIconView@ has a single CSS node with name iconview and style class .view.
-- For rubberband selection, a subnode with name rubberband is used.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.IconView
    ( 

-- * Exported types
    IconView(..)                            ,
    IsIconView                              ,
    toIconView                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addAttribute]("GI.Gtk.Interfaces.CellLayout#g:method:addAttribute"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [clear]("GI.Gtk.Interfaces.CellLayout#g:method:clear"), [clearAttributes]("GI.Gtk.Interfaces.CellLayout#g:method:clearAttributes"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createDragIcon]("GI.Gtk.Objects.IconView#g:method:createDragIcon"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [enableModelDragDest]("GI.Gtk.Objects.IconView#g:method:enableModelDragDest"), [enableModelDragSource]("GI.Gtk.Objects.IconView#g:method:enableModelDragSource"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [itemActivated]("GI.Gtk.Objects.IconView#g:method:itemActivated"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [packEnd]("GI.Gtk.Interfaces.CellLayout#g:method:packEnd"), [packStart]("GI.Gtk.Interfaces.CellLayout#g:method:packStart"), [pathIsSelected]("GI.Gtk.Objects.IconView#g:method:pathIsSelected"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [reorder]("GI.Gtk.Interfaces.CellLayout#g:method:reorder"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [scrollToPath]("GI.Gtk.Objects.IconView#g:method:scrollToPath"), [selectAll]("GI.Gtk.Objects.IconView#g:method:selectAll"), [selectPath]("GI.Gtk.Objects.IconView#g:method:selectPath"), [selectedForeach]("GI.Gtk.Objects.IconView#g:method:selectedForeach"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unselectAll]("GI.Gtk.Objects.IconView#g:method:unselectAll"), [unselectPath]("GI.Gtk.Objects.IconView#g:method:unselectPath"), [unsetModelDragDest]("GI.Gtk.Objects.IconView#g:method:unsetModelDragDest"), [unsetModelDragSource]("GI.Gtk.Objects.IconView#g:method:unsetModelDragSource"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getActivateOnSingleClick]("GI.Gtk.Objects.IconView#g:method:getActivateOnSingleClick"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getArea]("GI.Gtk.Interfaces.CellLayout#g:method:getArea"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBorder]("GI.Gtk.Interfaces.Scrollable#g:method:getBorder"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getCellRect]("GI.Gtk.Objects.IconView#g:method:getCellRect"), [getCells]("GI.Gtk.Interfaces.CellLayout#g:method:getCells"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getColumnSpacing]("GI.Gtk.Objects.IconView#g:method:getColumnSpacing"), [getColumns]("GI.Gtk.Objects.IconView#g:method:getColumns"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.IconView#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDestItemAtPos]("GI.Gtk.Objects.IconView#g:method:getDestItemAtPos"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getDragDestItem]("GI.Gtk.Objects.IconView#g:method:getDragDestItem"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:getHadjustment"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:getHscrollPolicy"), [getItemAtPos]("GI.Gtk.Objects.IconView#g:method:getItemAtPos"), [getItemColumn]("GI.Gtk.Objects.IconView#g:method:getItemColumn"), [getItemOrientation]("GI.Gtk.Objects.IconView#g:method:getItemOrientation"), [getItemPadding]("GI.Gtk.Objects.IconView#g:method:getItemPadding"), [getItemRow]("GI.Gtk.Objects.IconView#g:method:getItemRow"), [getItemWidth]("GI.Gtk.Objects.IconView#g:method:getItemWidth"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMargin]("GI.Gtk.Objects.IconView#g:method:getMargin"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMarkupColumn]("GI.Gtk.Objects.IconView#g:method:getMarkupColumn"), [getModel]("GI.Gtk.Objects.IconView#g:method:getModel"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPathAtPos]("GI.Gtk.Objects.IconView#g:method:getPathAtPos"), [getPixbufColumn]("GI.Gtk.Objects.IconView#g:method:getPixbufColumn"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getReorderable]("GI.Gtk.Objects.IconView#g:method:getReorderable"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getRowSpacing]("GI.Gtk.Objects.IconView#g:method:getRowSpacing"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSelectedItems]("GI.Gtk.Objects.IconView#g:method:getSelectedItems"), [getSelectionMode]("GI.Gtk.Objects.IconView#g:method:getSelectionMode"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getSpacing]("GI.Gtk.Objects.IconView#g:method:getSpacing"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTextColumn]("GI.Gtk.Objects.IconView#g:method:getTextColumn"), [getTooltipColumn]("GI.Gtk.Objects.IconView#g:method:getTooltipColumn"), [getTooltipContext]("GI.Gtk.Objects.IconView#g:method:getTooltipContext"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getVadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:getVadjustment"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getVisibleRange]("GI.Gtk.Objects.IconView#g:method:getVisibleRange"), [getVscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:getVscrollPolicy"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setActivateOnSingleClick]("GI.Gtk.Objects.IconView#g:method:setActivateOnSingleClick"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setCellDataFunc]("GI.Gtk.Interfaces.CellLayout#g:method:setCellDataFunc"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setColumnSpacing]("GI.Gtk.Objects.IconView#g:method:setColumnSpacing"), [setColumns]("GI.Gtk.Objects.IconView#g:method:setColumns"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.IconView#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setDragDestItem]("GI.Gtk.Objects.IconView#g:method:setDragDestItem"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:setHadjustment"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:setHscrollPolicy"), [setItemOrientation]("GI.Gtk.Objects.IconView#g:method:setItemOrientation"), [setItemPadding]("GI.Gtk.Objects.IconView#g:method:setItemPadding"), [setItemWidth]("GI.Gtk.Objects.IconView#g:method:setItemWidth"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMargin]("GI.Gtk.Objects.IconView#g:method:setMargin"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMarkupColumn]("GI.Gtk.Objects.IconView#g:method:setMarkupColumn"), [setModel]("GI.Gtk.Objects.IconView#g:method:setModel"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPixbufColumn]("GI.Gtk.Objects.IconView#g:method:setPixbufColumn"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setReorderable]("GI.Gtk.Objects.IconView#g:method:setReorderable"), [setRowSpacing]("GI.Gtk.Objects.IconView#g:method:setRowSpacing"), [setSelectionMode]("GI.Gtk.Objects.IconView#g:method:setSelectionMode"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setSpacing]("GI.Gtk.Objects.IconView#g:method:setSpacing"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTextColumn]("GI.Gtk.Objects.IconView#g:method:setTextColumn"), [setTooltipCell]("GI.Gtk.Objects.IconView#g:method:setTooltipCell"), [setTooltipColumn]("GI.Gtk.Objects.IconView#g:method:setTooltipColumn"), [setTooltipItem]("GI.Gtk.Objects.IconView#g:method:setTooltipItem"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setVadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:setVadjustment"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible"), [setVscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:setVscrollPolicy").

#if defined(ENABLE_OVERLOADING)
    ResolveIconViewMethod                   ,
#endif

-- ** createDragIcon #method:createDragIcon#

#if defined(ENABLE_OVERLOADING)
    IconViewCreateDragIconMethodInfo        ,
#endif
    iconViewCreateDragIcon                  ,


-- ** enableModelDragDest #method:enableModelDragDest#

#if defined(ENABLE_OVERLOADING)
    IconViewEnableModelDragDestMethodInfo   ,
#endif
    iconViewEnableModelDragDest             ,


-- ** enableModelDragSource #method:enableModelDragSource#

#if defined(ENABLE_OVERLOADING)
    IconViewEnableModelDragSourceMethodInfo ,
#endif
    iconViewEnableModelDragSource           ,


-- ** getActivateOnSingleClick #method:getActivateOnSingleClick#

#if defined(ENABLE_OVERLOADING)
    IconViewGetActivateOnSingleClickMethodInfo,
#endif
    iconViewGetActivateOnSingleClick        ,


-- ** getCellRect #method:getCellRect#

#if defined(ENABLE_OVERLOADING)
    IconViewGetCellRectMethodInfo           ,
#endif
    iconViewGetCellRect                     ,


-- ** getColumnSpacing #method:getColumnSpacing#

#if defined(ENABLE_OVERLOADING)
    IconViewGetColumnSpacingMethodInfo      ,
#endif
    iconViewGetColumnSpacing                ,


-- ** getColumns #method:getColumns#

#if defined(ENABLE_OVERLOADING)
    IconViewGetColumnsMethodInfo            ,
#endif
    iconViewGetColumns                      ,


-- ** getCursor #method:getCursor#

#if defined(ENABLE_OVERLOADING)
    IconViewGetCursorMethodInfo             ,
#endif
    iconViewGetCursor                       ,


-- ** getDestItemAtPos #method:getDestItemAtPos#

#if defined(ENABLE_OVERLOADING)
    IconViewGetDestItemAtPosMethodInfo      ,
#endif
    iconViewGetDestItemAtPos                ,


-- ** getDragDestItem #method:getDragDestItem#

#if defined(ENABLE_OVERLOADING)
    IconViewGetDragDestItemMethodInfo       ,
#endif
    iconViewGetDragDestItem                 ,


-- ** getItemAtPos #method:getItemAtPos#

#if defined(ENABLE_OVERLOADING)
    IconViewGetItemAtPosMethodInfo          ,
#endif
    iconViewGetItemAtPos                    ,


-- ** getItemColumn #method:getItemColumn#

#if defined(ENABLE_OVERLOADING)
    IconViewGetItemColumnMethodInfo         ,
#endif
    iconViewGetItemColumn                   ,


-- ** getItemOrientation #method:getItemOrientation#

#if defined(ENABLE_OVERLOADING)
    IconViewGetItemOrientationMethodInfo    ,
#endif
    iconViewGetItemOrientation              ,


-- ** getItemPadding #method:getItemPadding#

#if defined(ENABLE_OVERLOADING)
    IconViewGetItemPaddingMethodInfo        ,
#endif
    iconViewGetItemPadding                  ,


-- ** getItemRow #method:getItemRow#

#if defined(ENABLE_OVERLOADING)
    IconViewGetItemRowMethodInfo            ,
#endif
    iconViewGetItemRow                      ,


-- ** getItemWidth #method:getItemWidth#

#if defined(ENABLE_OVERLOADING)
    IconViewGetItemWidthMethodInfo          ,
#endif
    iconViewGetItemWidth                    ,


-- ** getMargin #method:getMargin#

#if defined(ENABLE_OVERLOADING)
    IconViewGetMarginMethodInfo             ,
#endif
    iconViewGetMargin                       ,


-- ** getMarkupColumn #method:getMarkupColumn#

#if defined(ENABLE_OVERLOADING)
    IconViewGetMarkupColumnMethodInfo       ,
#endif
    iconViewGetMarkupColumn                 ,


-- ** getModel #method:getModel#

#if defined(ENABLE_OVERLOADING)
    IconViewGetModelMethodInfo              ,
#endif
    iconViewGetModel                        ,


-- ** getPathAtPos #method:getPathAtPos#

#if defined(ENABLE_OVERLOADING)
    IconViewGetPathAtPosMethodInfo          ,
#endif
    iconViewGetPathAtPos                    ,


-- ** getPixbufColumn #method:getPixbufColumn#

#if defined(ENABLE_OVERLOADING)
    IconViewGetPixbufColumnMethodInfo       ,
#endif
    iconViewGetPixbufColumn                 ,


-- ** getReorderable #method:getReorderable#

#if defined(ENABLE_OVERLOADING)
    IconViewGetReorderableMethodInfo        ,
#endif
    iconViewGetReorderable                  ,


-- ** getRowSpacing #method:getRowSpacing#

#if defined(ENABLE_OVERLOADING)
    IconViewGetRowSpacingMethodInfo         ,
#endif
    iconViewGetRowSpacing                   ,


-- ** getSelectedItems #method:getSelectedItems#

#if defined(ENABLE_OVERLOADING)
    IconViewGetSelectedItemsMethodInfo      ,
#endif
    iconViewGetSelectedItems                ,


-- ** getSelectionMode #method:getSelectionMode#

#if defined(ENABLE_OVERLOADING)
    IconViewGetSelectionModeMethodInfo      ,
#endif
    iconViewGetSelectionMode                ,


-- ** getSpacing #method:getSpacing#

#if defined(ENABLE_OVERLOADING)
    IconViewGetSpacingMethodInfo            ,
#endif
    iconViewGetSpacing                      ,


-- ** getTextColumn #method:getTextColumn#

#if defined(ENABLE_OVERLOADING)
    IconViewGetTextColumnMethodInfo         ,
#endif
    iconViewGetTextColumn                   ,


-- ** getTooltipColumn #method:getTooltipColumn#

#if defined(ENABLE_OVERLOADING)
    IconViewGetTooltipColumnMethodInfo      ,
#endif
    iconViewGetTooltipColumn                ,


-- ** getTooltipContext #method:getTooltipContext#

#if defined(ENABLE_OVERLOADING)
    IconViewGetTooltipContextMethodInfo     ,
#endif
    iconViewGetTooltipContext               ,


-- ** getVisibleRange #method:getVisibleRange#

#if defined(ENABLE_OVERLOADING)
    IconViewGetVisibleRangeMethodInfo       ,
#endif
    iconViewGetVisibleRange                 ,


-- ** itemActivated #method:itemActivated#

#if defined(ENABLE_OVERLOADING)
    IconViewItemActivatedMethodInfo         ,
#endif
    iconViewItemActivated                   ,


-- ** new #method:new#

    iconViewNew                             ,


-- ** newWithArea #method:newWithArea#

    iconViewNewWithArea                     ,


-- ** newWithModel #method:newWithModel#

    iconViewNewWithModel                    ,


-- ** pathIsSelected #method:pathIsSelected#

#if defined(ENABLE_OVERLOADING)
    IconViewPathIsSelectedMethodInfo        ,
#endif
    iconViewPathIsSelected                  ,


-- ** scrollToPath #method:scrollToPath#

#if defined(ENABLE_OVERLOADING)
    IconViewScrollToPathMethodInfo          ,
#endif
    iconViewScrollToPath                    ,


-- ** selectAll #method:selectAll#

#if defined(ENABLE_OVERLOADING)
    IconViewSelectAllMethodInfo             ,
#endif
    iconViewSelectAll                       ,


-- ** selectPath #method:selectPath#

#if defined(ENABLE_OVERLOADING)
    IconViewSelectPathMethodInfo            ,
#endif
    iconViewSelectPath                      ,


-- ** selectedForeach #method:selectedForeach#

#if defined(ENABLE_OVERLOADING)
    IconViewSelectedForeachMethodInfo       ,
#endif
    iconViewSelectedForeach                 ,


-- ** setActivateOnSingleClick #method:setActivateOnSingleClick#

#if defined(ENABLE_OVERLOADING)
    IconViewSetActivateOnSingleClickMethodInfo,
#endif
    iconViewSetActivateOnSingleClick        ,


-- ** setColumnSpacing #method:setColumnSpacing#

#if defined(ENABLE_OVERLOADING)
    IconViewSetColumnSpacingMethodInfo      ,
#endif
    iconViewSetColumnSpacing                ,


-- ** setColumns #method:setColumns#

#if defined(ENABLE_OVERLOADING)
    IconViewSetColumnsMethodInfo            ,
#endif
    iconViewSetColumns                      ,


-- ** setCursor #method:setCursor#

#if defined(ENABLE_OVERLOADING)
    IconViewSetCursorMethodInfo             ,
#endif
    iconViewSetCursor                       ,


-- ** setDragDestItem #method:setDragDestItem#

#if defined(ENABLE_OVERLOADING)
    IconViewSetDragDestItemMethodInfo       ,
#endif
    iconViewSetDragDestItem                 ,


-- ** setItemOrientation #method:setItemOrientation#

#if defined(ENABLE_OVERLOADING)
    IconViewSetItemOrientationMethodInfo    ,
#endif
    iconViewSetItemOrientation              ,


-- ** setItemPadding #method:setItemPadding#

#if defined(ENABLE_OVERLOADING)
    IconViewSetItemPaddingMethodInfo        ,
#endif
    iconViewSetItemPadding                  ,


-- ** setItemWidth #method:setItemWidth#

#if defined(ENABLE_OVERLOADING)
    IconViewSetItemWidthMethodInfo          ,
#endif
    iconViewSetItemWidth                    ,


-- ** setMargin #method:setMargin#

#if defined(ENABLE_OVERLOADING)
    IconViewSetMarginMethodInfo             ,
#endif
    iconViewSetMargin                       ,


-- ** setMarkupColumn #method:setMarkupColumn#

#if defined(ENABLE_OVERLOADING)
    IconViewSetMarkupColumnMethodInfo       ,
#endif
    iconViewSetMarkupColumn                 ,


-- ** setModel #method:setModel#

#if defined(ENABLE_OVERLOADING)
    IconViewSetModelMethodInfo              ,
#endif
    iconViewSetModel                        ,


-- ** setPixbufColumn #method:setPixbufColumn#

#if defined(ENABLE_OVERLOADING)
    IconViewSetPixbufColumnMethodInfo       ,
#endif
    iconViewSetPixbufColumn                 ,


-- ** setReorderable #method:setReorderable#

#if defined(ENABLE_OVERLOADING)
    IconViewSetReorderableMethodInfo        ,
#endif
    iconViewSetReorderable                  ,


-- ** setRowSpacing #method:setRowSpacing#

#if defined(ENABLE_OVERLOADING)
    IconViewSetRowSpacingMethodInfo         ,
#endif
    iconViewSetRowSpacing                   ,


-- ** setSelectionMode #method:setSelectionMode#

#if defined(ENABLE_OVERLOADING)
    IconViewSetSelectionModeMethodInfo      ,
#endif
    iconViewSetSelectionMode                ,


-- ** setSpacing #method:setSpacing#

#if defined(ENABLE_OVERLOADING)
    IconViewSetSpacingMethodInfo            ,
#endif
    iconViewSetSpacing                      ,


-- ** setTextColumn #method:setTextColumn#

#if defined(ENABLE_OVERLOADING)
    IconViewSetTextColumnMethodInfo         ,
#endif
    iconViewSetTextColumn                   ,


-- ** setTooltipCell #method:setTooltipCell#

#if defined(ENABLE_OVERLOADING)
    IconViewSetTooltipCellMethodInfo        ,
#endif
    iconViewSetTooltipCell                  ,


-- ** setTooltipColumn #method:setTooltipColumn#

#if defined(ENABLE_OVERLOADING)
    IconViewSetTooltipColumnMethodInfo      ,
#endif
    iconViewSetTooltipColumn                ,


-- ** setTooltipItem #method:setTooltipItem#

#if defined(ENABLE_OVERLOADING)
    IconViewSetTooltipItemMethodInfo        ,
#endif
    iconViewSetTooltipItem                  ,


-- ** unselectAll #method:unselectAll#

#if defined(ENABLE_OVERLOADING)
    IconViewUnselectAllMethodInfo           ,
#endif
    iconViewUnselectAll                     ,


-- ** unselectPath #method:unselectPath#

#if defined(ENABLE_OVERLOADING)
    IconViewUnselectPathMethodInfo          ,
#endif
    iconViewUnselectPath                    ,


-- ** unsetModelDragDest #method:unsetModelDragDest#

#if defined(ENABLE_OVERLOADING)
    IconViewUnsetModelDragDestMethodInfo    ,
#endif
    iconViewUnsetModelDragDest              ,


-- ** unsetModelDragSource #method:unsetModelDragSource#

#if defined(ENABLE_OVERLOADING)
    IconViewUnsetModelDragSourceMethodInfo  ,
#endif
    iconViewUnsetModelDragSource            ,




 -- * Properties


-- ** activateOnSingleClick #attr:activateOnSingleClick#
-- | The activate-on-single-click property specifies whether the \"item-activated\" signal
-- will be emitted after a single click.

#if defined(ENABLE_OVERLOADING)
    IconViewActivateOnSingleClickPropertyInfo,
#endif
    constructIconViewActivateOnSingleClick  ,
    getIconViewActivateOnSingleClick        ,
#if defined(ENABLE_OVERLOADING)
    iconViewActivateOnSingleClick           ,
#endif
    setIconViewActivateOnSingleClick        ,


-- ** cellArea #attr:cellArea#
-- | The @GtkCellArea@ used to layout cell renderers for this view.
-- 
-- If no area is specified when creating the icon view with 'GI.Gtk.Objects.IconView.iconViewNewWithArea'
-- a @GtkCellAreaBox@ will be used.

#if defined(ENABLE_OVERLOADING)
    IconViewCellAreaPropertyInfo            ,
#endif
    constructIconViewCellArea               ,
    getIconViewCellArea                     ,
#if defined(ENABLE_OVERLOADING)
    iconViewCellArea                        ,
#endif


-- ** columnSpacing #attr:columnSpacing#
-- | The column-spacing property specifies the space which is inserted between
-- the columns of the icon view.

#if defined(ENABLE_OVERLOADING)
    IconViewColumnSpacingPropertyInfo       ,
#endif
    constructIconViewColumnSpacing          ,
    getIconViewColumnSpacing                ,
#if defined(ENABLE_OVERLOADING)
    iconViewColumnSpacing                   ,
#endif
    setIconViewColumnSpacing                ,


-- ** columns #attr:columns#
-- | The columns property contains the number of the columns in which the
-- items should be displayed. If it is -1, the number of columns will
-- be chosen automatically to fill the available area.

#if defined(ENABLE_OVERLOADING)
    IconViewColumnsPropertyInfo             ,
#endif
    constructIconViewColumns                ,
    getIconViewColumns                      ,
#if defined(ENABLE_OVERLOADING)
    iconViewColumns                         ,
#endif
    setIconViewColumns                      ,


-- ** itemOrientation #attr:itemOrientation#
-- | The item-orientation property specifies how the cells (i.e. the icon and
-- the text) of the item are positioned relative to each other.

#if defined(ENABLE_OVERLOADING)
    IconViewItemOrientationPropertyInfo     ,
#endif
    constructIconViewItemOrientation        ,
    getIconViewItemOrientation              ,
#if defined(ENABLE_OVERLOADING)
    iconViewItemOrientation                 ,
#endif
    setIconViewItemOrientation              ,


-- ** itemPadding #attr:itemPadding#
-- | The item-padding property specifies the padding around each
-- of the icon view\'s item.

#if defined(ENABLE_OVERLOADING)
    IconViewItemPaddingPropertyInfo         ,
#endif
    constructIconViewItemPadding            ,
    getIconViewItemPadding                  ,
#if defined(ENABLE_OVERLOADING)
    iconViewItemPadding                     ,
#endif
    setIconViewItemPadding                  ,


-- ** itemWidth #attr:itemWidth#
-- | The item-width property specifies the width to use for each item.
-- If it is set to -1, the icon view will automatically determine a
-- suitable item size.

#if defined(ENABLE_OVERLOADING)
    IconViewItemWidthPropertyInfo           ,
#endif
    constructIconViewItemWidth              ,
    getIconViewItemWidth                    ,
#if defined(ENABLE_OVERLOADING)
    iconViewItemWidth                       ,
#endif
    setIconViewItemWidth                    ,


-- ** margin #attr:margin#
-- | The margin property specifies the space which is inserted
-- at the edges of the icon view.

#if defined(ENABLE_OVERLOADING)
    IconViewMarginPropertyInfo              ,
#endif
    constructIconViewMargin                 ,
    getIconViewMargin                       ,
#if defined(ENABLE_OVERLOADING)
    iconViewMargin                          ,
#endif
    setIconViewMargin                       ,


-- ** markupColumn #attr:markupColumn#
-- | The [markupColumn](#g:signal:markupColumn) property contains the number of the model column
-- containing markup information to be displayed. The markup column must be
-- of type @G_TYPE_STRING@. If this property and the :text-column property
-- are both set to column numbers, it overrides the text column.
-- If both are set to -1, no texts are displayed.

#if defined(ENABLE_OVERLOADING)
    IconViewMarkupColumnPropertyInfo        ,
#endif
    constructIconViewMarkupColumn           ,
    getIconViewMarkupColumn                 ,
#if defined(ENABLE_OVERLOADING)
    iconViewMarkupColumn                    ,
#endif
    setIconViewMarkupColumn                 ,


-- ** model #attr:model#
-- | The model of the icon view.

#if defined(ENABLE_OVERLOADING)
    IconViewModelPropertyInfo               ,
#endif
    clearIconViewModel                      ,
    constructIconViewModel                  ,
    getIconViewModel                        ,
#if defined(ENABLE_OVERLOADING)
    iconViewModel                           ,
#endif
    setIconViewModel                        ,


-- ** pixbufColumn #attr:pixbufColumn#
-- | The [pixbufColumn](#g:signal:pixbufColumn) property contains the number of the model column
-- containing the pixbufs which are displayed. The pixbuf column must be
-- of type @GDK_TYPE_PIXBUF@. Setting this property to -1 turns off the
-- display of pixbufs.

#if defined(ENABLE_OVERLOADING)
    IconViewPixbufColumnPropertyInfo        ,
#endif
    constructIconViewPixbufColumn           ,
    getIconViewPixbufColumn                 ,
#if defined(ENABLE_OVERLOADING)
    iconViewPixbufColumn                    ,
#endif
    setIconViewPixbufColumn                 ,


-- ** reorderable #attr:reorderable#
-- | The reorderable property specifies if the items can be reordered
-- by DND.

#if defined(ENABLE_OVERLOADING)
    IconViewReorderablePropertyInfo         ,
#endif
    constructIconViewReorderable            ,
    getIconViewReorderable                  ,
#if defined(ENABLE_OVERLOADING)
    iconViewReorderable                     ,
#endif
    setIconViewReorderable                  ,


-- ** rowSpacing #attr:rowSpacing#
-- | The row-spacing property specifies the space which is inserted between
-- the rows of the icon view.

#if defined(ENABLE_OVERLOADING)
    IconViewRowSpacingPropertyInfo          ,
#endif
    constructIconViewRowSpacing             ,
    getIconViewRowSpacing                   ,
#if defined(ENABLE_OVERLOADING)
    iconViewRowSpacing                      ,
#endif
    setIconViewRowSpacing                   ,


-- ** selectionMode #attr:selectionMode#
-- | The [selectionMode](#g:signal:selectionMode) property specifies the selection mode of
-- icon view. If the mode is 'GI.Gtk.Enums.SelectionModeMultiple', rubberband selection
-- is enabled, for the other modes, only keyboard selection is possible.

#if defined(ENABLE_OVERLOADING)
    IconViewSelectionModePropertyInfo       ,
#endif
    constructIconViewSelectionMode          ,
    getIconViewSelectionMode                ,
#if defined(ENABLE_OVERLOADING)
    iconViewSelectionMode                   ,
#endif
    setIconViewSelectionMode                ,


-- ** spacing #attr:spacing#
-- | The spacing property specifies the space which is inserted between
-- the cells (i.e. the icon and the text) of an item.

#if defined(ENABLE_OVERLOADING)
    IconViewSpacingPropertyInfo             ,
#endif
    constructIconViewSpacing                ,
    getIconViewSpacing                      ,
#if defined(ENABLE_OVERLOADING)
    iconViewSpacing                         ,
#endif
    setIconViewSpacing                      ,


-- ** textColumn #attr:textColumn#
-- | The [textColumn](#g:signal:textColumn) property contains the number of the model column
-- containing the texts which are displayed. The text column must be
-- of type @G_TYPE_STRING@. If this property and the :markup-column
-- property are both set to -1, no texts are displayed.

#if defined(ENABLE_OVERLOADING)
    IconViewTextColumnPropertyInfo          ,
#endif
    constructIconViewTextColumn             ,
    getIconViewTextColumn                   ,
#if defined(ENABLE_OVERLOADING)
    iconViewTextColumn                      ,
#endif
    setIconViewTextColumn                   ,


-- ** tooltipColumn #attr:tooltipColumn#
-- | The column of the icon view model which is being used for displaying
-- tooltips on it\'s rows.

#if defined(ENABLE_OVERLOADING)
    IconViewTooltipColumnPropertyInfo       ,
#endif
    constructIconViewTooltipColumn          ,
    getIconViewTooltipColumn                ,
#if defined(ENABLE_OVERLOADING)
    iconViewTooltipColumn                   ,
#endif
    setIconViewTooltipColumn                ,




 -- * Signals


-- ** activateCursorItem #signal:activateCursorItem#

    IconViewActivateCursorItemCallback      ,
#if defined(ENABLE_OVERLOADING)
    IconViewActivateCursorItemSignalInfo    ,
#endif
    afterIconViewActivateCursorItem         ,
    onIconViewActivateCursorItem            ,


-- ** itemActivated #signal:itemActivated#

    IconViewItemActivatedCallback           ,
#if defined(ENABLE_OVERLOADING)
    IconViewItemActivatedSignalInfo         ,
#endif
    afterIconViewItemActivated              ,
    onIconViewItemActivated                 ,


-- ** moveCursor #signal:moveCursor#

    IconViewMoveCursorCallback              ,
#if defined(ENABLE_OVERLOADING)
    IconViewMoveCursorSignalInfo            ,
#endif
    afterIconViewMoveCursor                 ,
    onIconViewMoveCursor                    ,


-- ** selectAll #signal:selectAll#

    IconViewSelectAllCallback               ,
#if defined(ENABLE_OVERLOADING)
    IconViewSelectAllSignalInfo             ,
#endif
    afterIconViewSelectAll                  ,
    onIconViewSelectAll                     ,


-- ** selectCursorItem #signal:selectCursorItem#

    IconViewSelectCursorItemCallback        ,
#if defined(ENABLE_OVERLOADING)
    IconViewSelectCursorItemSignalInfo      ,
#endif
    afterIconViewSelectCursorItem           ,
    onIconViewSelectCursorItem              ,


-- ** selectionChanged #signal:selectionChanged#

    IconViewSelectionChangedCallback        ,
#if defined(ENABLE_OVERLOADING)
    IconViewSelectionChangedSignalInfo      ,
#endif
    afterIconViewSelectionChanged           ,
    onIconViewSelectionChanged              ,


-- ** toggleCursorItem #signal:toggleCursorItem#

    IconViewToggleCursorItemCallback        ,
#if defined(ENABLE_OVERLOADING)
    IconViewToggleCursorItemSignalInfo      ,
#endif
    afterIconViewToggleCursorItem           ,
    onIconViewToggleCursorItem              ,


-- ** unselectAll #signal:unselectAll#

    IconViewUnselectAllCallback             ,
#if defined(ENABLE_OVERLOADING)
    IconViewUnselectAllSignalInfo           ,
#endif
    afterIconViewUnselectAll                ,
    onIconViewUnselectAll                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellEditable as Gtk.CellEditable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellLayout as Gtk.CellLayout
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Scrollable as Gtk.Scrollable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.TreeModel as Gtk.TreeModel
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellArea as Gtk.CellArea
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellAreaContext as Gtk.CellAreaContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellRenderer as Gtk.CellRenderer
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreeIter as Gtk.TreeIter
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreePath as Gtk.TreePath
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellLayout as Gtk.CellLayout
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Scrollable as Gtk.Scrollable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.TreeModel as Gtk.TreeModel
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellArea as Gtk.CellArea
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellRenderer as Gtk.CellRenderer
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreeIter as Gtk.TreeIter
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreePath as Gtk.TreePath

#endif

-- | Memory-managed wrapper type.
newtype IconView = IconView (SP.ManagedPtr IconView)
    deriving (Eq)

instance SP.ManagedPtrNewtype IconView where
    toManagedPtr (IconView p) = p

foreign import ccall "gtk_icon_view_get_type"
    c_gtk_icon_view_get_type :: IO B.Types.GType

instance B.Types.TypedObject IconView where
    glibType = c_gtk_icon_view_get_type

instance B.Types.GObject IconView

-- | Type class for types which can be safely cast to t'IconView', for instance with `toIconView`.
class (SP.GObject o, O.IsDescendantOf IconView o) => IsIconView o
instance (SP.GObject o, O.IsDescendantOf IconView o) => IsIconView o

instance O.HasParentTypes IconView
type instance O.ParentTypes IconView = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.CellLayout.CellLayout, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Scrollable.Scrollable]

-- | Cast to t'IconView', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toIconView :: (MIO.MonadIO m, IsIconView o) => o -> m IconView
toIconView = MIO.liftIO . B.ManagedPtr.unsafeCastTo IconView

-- | Convert t'IconView' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe IconView) where
    gvalueGType_ = c_gtk_icon_view_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr IconView)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr IconView)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject IconView ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveIconViewMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveIconViewMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveIconViewMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveIconViewMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveIconViewMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveIconViewMethod "addAttribute" o = Gtk.CellLayout.CellLayoutAddAttributeMethodInfo
    ResolveIconViewMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveIconViewMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveIconViewMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveIconViewMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveIconViewMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveIconViewMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveIconViewMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveIconViewMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveIconViewMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveIconViewMethod "clear" o = Gtk.CellLayout.CellLayoutClearMethodInfo
    ResolveIconViewMethod "clearAttributes" o = Gtk.CellLayout.CellLayoutClearAttributesMethodInfo
    ResolveIconViewMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveIconViewMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveIconViewMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveIconViewMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveIconViewMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveIconViewMethod "createDragIcon" o = IconViewCreateDragIconMethodInfo
    ResolveIconViewMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveIconViewMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveIconViewMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveIconViewMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveIconViewMethod "enableModelDragDest" o = IconViewEnableModelDragDestMethodInfo
    ResolveIconViewMethod "enableModelDragSource" o = IconViewEnableModelDragSourceMethodInfo
    ResolveIconViewMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveIconViewMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveIconViewMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveIconViewMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveIconViewMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveIconViewMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveIconViewMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveIconViewMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveIconViewMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveIconViewMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveIconViewMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveIconViewMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveIconViewMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveIconViewMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveIconViewMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveIconViewMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveIconViewMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveIconViewMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveIconViewMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveIconViewMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveIconViewMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveIconViewMethod "itemActivated" o = IconViewItemActivatedMethodInfo
    ResolveIconViewMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveIconViewMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveIconViewMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveIconViewMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveIconViewMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveIconViewMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveIconViewMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveIconViewMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveIconViewMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveIconViewMethod "packEnd" o = Gtk.CellLayout.CellLayoutPackEndMethodInfo
    ResolveIconViewMethod "packStart" o = Gtk.CellLayout.CellLayoutPackStartMethodInfo
    ResolveIconViewMethod "pathIsSelected" o = IconViewPathIsSelectedMethodInfo
    ResolveIconViewMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveIconViewMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveIconViewMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveIconViewMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveIconViewMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveIconViewMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveIconViewMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveIconViewMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveIconViewMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveIconViewMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveIconViewMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveIconViewMethod "reorder" o = Gtk.CellLayout.CellLayoutReorderMethodInfo
    ResolveIconViewMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveIconViewMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveIconViewMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveIconViewMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveIconViewMethod "scrollToPath" o = IconViewScrollToPathMethodInfo
    ResolveIconViewMethod "selectAll" o = IconViewSelectAllMethodInfo
    ResolveIconViewMethod "selectPath" o = IconViewSelectPathMethodInfo
    ResolveIconViewMethod "selectedForeach" o = IconViewSelectedForeachMethodInfo
    ResolveIconViewMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveIconViewMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveIconViewMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveIconViewMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveIconViewMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveIconViewMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveIconViewMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveIconViewMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveIconViewMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveIconViewMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveIconViewMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveIconViewMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveIconViewMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveIconViewMethod "unselectAll" o = IconViewUnselectAllMethodInfo
    ResolveIconViewMethod "unselectPath" o = IconViewUnselectPathMethodInfo
    ResolveIconViewMethod "unsetModelDragDest" o = IconViewUnsetModelDragDestMethodInfo
    ResolveIconViewMethod "unsetModelDragSource" o = IconViewUnsetModelDragSourceMethodInfo
    ResolveIconViewMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveIconViewMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveIconViewMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveIconViewMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveIconViewMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveIconViewMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveIconViewMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveIconViewMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveIconViewMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveIconViewMethod "getActivateOnSingleClick" o = IconViewGetActivateOnSingleClickMethodInfo
    ResolveIconViewMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveIconViewMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveIconViewMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveIconViewMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveIconViewMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveIconViewMethod "getArea" o = Gtk.CellLayout.CellLayoutGetAreaMethodInfo
    ResolveIconViewMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveIconViewMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveIconViewMethod "getBorder" o = Gtk.Scrollable.ScrollableGetBorderMethodInfo
    ResolveIconViewMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveIconViewMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveIconViewMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveIconViewMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveIconViewMethod "getCellRect" o = IconViewGetCellRectMethodInfo
    ResolveIconViewMethod "getCells" o = Gtk.CellLayout.CellLayoutGetCellsMethodInfo
    ResolveIconViewMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveIconViewMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveIconViewMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveIconViewMethod "getColumnSpacing" o = IconViewGetColumnSpacingMethodInfo
    ResolveIconViewMethod "getColumns" o = IconViewGetColumnsMethodInfo
    ResolveIconViewMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveIconViewMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveIconViewMethod "getCursor" o = IconViewGetCursorMethodInfo
    ResolveIconViewMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveIconViewMethod "getDestItemAtPos" o = IconViewGetDestItemAtPosMethodInfo
    ResolveIconViewMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveIconViewMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveIconViewMethod "getDragDestItem" o = IconViewGetDragDestItemMethodInfo
    ResolveIconViewMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveIconViewMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveIconViewMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveIconViewMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveIconViewMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveIconViewMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveIconViewMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveIconViewMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveIconViewMethod "getHadjustment" o = Gtk.Scrollable.ScrollableGetHadjustmentMethodInfo
    ResolveIconViewMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveIconViewMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveIconViewMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveIconViewMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveIconViewMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveIconViewMethod "getHscrollPolicy" o = Gtk.Scrollable.ScrollableGetHscrollPolicyMethodInfo
    ResolveIconViewMethod "getItemAtPos" o = IconViewGetItemAtPosMethodInfo
    ResolveIconViewMethod "getItemColumn" o = IconViewGetItemColumnMethodInfo
    ResolveIconViewMethod "getItemOrientation" o = IconViewGetItemOrientationMethodInfo
    ResolveIconViewMethod "getItemPadding" o = IconViewGetItemPaddingMethodInfo
    ResolveIconViewMethod "getItemRow" o = IconViewGetItemRowMethodInfo
    ResolveIconViewMethod "getItemWidth" o = IconViewGetItemWidthMethodInfo
    ResolveIconViewMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveIconViewMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveIconViewMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveIconViewMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveIconViewMethod "getMargin" o = IconViewGetMarginMethodInfo
    ResolveIconViewMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveIconViewMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveIconViewMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveIconViewMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveIconViewMethod "getMarkupColumn" o = IconViewGetMarkupColumnMethodInfo
    ResolveIconViewMethod "getModel" o = IconViewGetModelMethodInfo
    ResolveIconViewMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveIconViewMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveIconViewMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveIconViewMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveIconViewMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveIconViewMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveIconViewMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveIconViewMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveIconViewMethod "getPathAtPos" o = IconViewGetPathAtPosMethodInfo
    ResolveIconViewMethod "getPixbufColumn" o = IconViewGetPixbufColumnMethodInfo
    ResolveIconViewMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveIconViewMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveIconViewMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveIconViewMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveIconViewMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveIconViewMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveIconViewMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveIconViewMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveIconViewMethod "getReorderable" o = IconViewGetReorderableMethodInfo
    ResolveIconViewMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveIconViewMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveIconViewMethod "getRowSpacing" o = IconViewGetRowSpacingMethodInfo
    ResolveIconViewMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveIconViewMethod "getSelectedItems" o = IconViewGetSelectedItemsMethodInfo
    ResolveIconViewMethod "getSelectionMode" o = IconViewGetSelectionModeMethodInfo
    ResolveIconViewMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveIconViewMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveIconViewMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveIconViewMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveIconViewMethod "getSpacing" o = IconViewGetSpacingMethodInfo
    ResolveIconViewMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveIconViewMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveIconViewMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveIconViewMethod "getTextColumn" o = IconViewGetTextColumnMethodInfo
    ResolveIconViewMethod "getTooltipColumn" o = IconViewGetTooltipColumnMethodInfo
    ResolveIconViewMethod "getTooltipContext" o = IconViewGetTooltipContextMethodInfo
    ResolveIconViewMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveIconViewMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveIconViewMethod "getVadjustment" o = Gtk.Scrollable.ScrollableGetVadjustmentMethodInfo
    ResolveIconViewMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveIconViewMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveIconViewMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveIconViewMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveIconViewMethod "getVisibleRange" o = IconViewGetVisibleRangeMethodInfo
    ResolveIconViewMethod "getVscrollPolicy" o = Gtk.Scrollable.ScrollableGetVscrollPolicyMethodInfo
    ResolveIconViewMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveIconViewMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveIconViewMethod "setActivateOnSingleClick" o = IconViewSetActivateOnSingleClickMethodInfo
    ResolveIconViewMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveIconViewMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveIconViewMethod "setCellDataFunc" o = Gtk.CellLayout.CellLayoutSetCellDataFuncMethodInfo
    ResolveIconViewMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveIconViewMethod "setColumnSpacing" o = IconViewSetColumnSpacingMethodInfo
    ResolveIconViewMethod "setColumns" o = IconViewSetColumnsMethodInfo
    ResolveIconViewMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveIconViewMethod "setCursor" o = IconViewSetCursorMethodInfo
    ResolveIconViewMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveIconViewMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveIconViewMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveIconViewMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveIconViewMethod "setDragDestItem" o = IconViewSetDragDestItemMethodInfo
    ResolveIconViewMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveIconViewMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveIconViewMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveIconViewMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveIconViewMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveIconViewMethod "setHadjustment" o = Gtk.Scrollable.ScrollableSetHadjustmentMethodInfo
    ResolveIconViewMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveIconViewMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveIconViewMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveIconViewMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveIconViewMethod "setHscrollPolicy" o = Gtk.Scrollable.ScrollableSetHscrollPolicyMethodInfo
    ResolveIconViewMethod "setItemOrientation" o = IconViewSetItemOrientationMethodInfo
    ResolveIconViewMethod "setItemPadding" o = IconViewSetItemPaddingMethodInfo
    ResolveIconViewMethod "setItemWidth" o = IconViewSetItemWidthMethodInfo
    ResolveIconViewMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveIconViewMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveIconViewMethod "setMargin" o = IconViewSetMarginMethodInfo
    ResolveIconViewMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveIconViewMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveIconViewMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveIconViewMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveIconViewMethod "setMarkupColumn" o = IconViewSetMarkupColumnMethodInfo
    ResolveIconViewMethod "setModel" o = IconViewSetModelMethodInfo
    ResolveIconViewMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveIconViewMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveIconViewMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveIconViewMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveIconViewMethod "setPixbufColumn" o = IconViewSetPixbufColumnMethodInfo
    ResolveIconViewMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveIconViewMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveIconViewMethod "setReorderable" o = IconViewSetReorderableMethodInfo
    ResolveIconViewMethod "setRowSpacing" o = IconViewSetRowSpacingMethodInfo
    ResolveIconViewMethod "setSelectionMode" o = IconViewSetSelectionModeMethodInfo
    ResolveIconViewMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveIconViewMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveIconViewMethod "setSpacing" o = IconViewSetSpacingMethodInfo
    ResolveIconViewMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveIconViewMethod "setTextColumn" o = IconViewSetTextColumnMethodInfo
    ResolveIconViewMethod "setTooltipCell" o = IconViewSetTooltipCellMethodInfo
    ResolveIconViewMethod "setTooltipColumn" o = IconViewSetTooltipColumnMethodInfo
    ResolveIconViewMethod "setTooltipItem" o = IconViewSetTooltipItemMethodInfo
    ResolveIconViewMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveIconViewMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveIconViewMethod "setVadjustment" o = Gtk.Scrollable.ScrollableSetVadjustmentMethodInfo
    ResolveIconViewMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveIconViewMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveIconViewMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveIconViewMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveIconViewMethod "setVscrollPolicy" o = Gtk.Scrollable.ScrollableSetVscrollPolicyMethodInfo
    ResolveIconViewMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveIconViewMethod t IconView, O.OverloadedMethod info IconView p) => OL.IsLabel t (IconView -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveIconViewMethod t IconView, O.OverloadedMethod info IconView p, R.HasField t IconView p) => R.HasField t IconView p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveIconViewMethod t IconView, O.OverloadedMethodInfo info IconView) => OL.IsLabel t (O.MethodProxy info IconView) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal IconView::activate-cursor-item
-- | A [keybinding signal]t'GI.Gtk.Objects.SignalAction.SignalAction'
-- which gets emitted when the user activates the currently
-- focused item.
-- 
-- Applications should not connect to it, but may emit it with
-- @/g_signal_emit_by_name()/@ if they need to control activation
-- programmatically.
-- 
-- The default bindings for this signal are Space, Return and Enter.
type IconViewActivateCursorItemCallback =
    IO Bool
    -- ^ __Returns:__ whether the item was activated

type C_IconViewActivateCursorItemCallback =
    Ptr IconView ->                         -- object
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_IconViewActivateCursorItemCallback`.
foreign import ccall "wrapper"
    mk_IconViewActivateCursorItemCallback :: C_IconViewActivateCursorItemCallback -> IO (FunPtr C_IconViewActivateCursorItemCallback)

wrap_IconViewActivateCursorItemCallback :: 
    GObject a => (a -> IconViewActivateCursorItemCallback) ->
    C_IconViewActivateCursorItemCallback
wrap_IconViewActivateCursorItemCallback gi'cb gi'selfPtr _ = do
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [activateCursorItem](#signal:activateCursorItem) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iconView #activateCursorItem callback
-- @
-- 
-- 
onIconViewActivateCursorItem :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewActivateCursorItemCallback) -> m SignalHandlerId
onIconViewActivateCursorItem obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewActivateCursorItemCallback wrapped
    wrapped'' <- mk_IconViewActivateCursorItemCallback wrapped'
    connectSignalFunPtr obj "activate-cursor-item" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activateCursorItem](#signal:activateCursorItem) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iconView #activateCursorItem callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIconViewActivateCursorItem :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewActivateCursorItemCallback) -> m SignalHandlerId
afterIconViewActivateCursorItem obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewActivateCursorItemCallback wrapped
    wrapped'' <- mk_IconViewActivateCursorItemCallback wrapped'
    connectSignalFunPtr obj "activate-cursor-item" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IconViewActivateCursorItemSignalInfo
instance SignalInfo IconViewActivateCursorItemSignalInfo where
    type HaskellCallbackType IconViewActivateCursorItemSignalInfo = IconViewActivateCursorItemCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IconViewActivateCursorItemCallback cb
        cb'' <- mk_IconViewActivateCursorItemCallback cb'
        connectSignalFunPtr obj "activate-cursor-item" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView::activate-cursor-item"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:signal:activateCursorItem"})

#endif

-- signal IconView::item-activated
-- | The [itemActivated](#g:signal:itemActivated) signal is emitted when the method
-- 'GI.Gtk.Objects.IconView.iconViewItemActivated' is called, when the user double
-- clicks an item with the \"activate-on-single-click\" property set
-- to 'P.False', or when the user single clicks an item when the
-- \"activate-on-single-click\" property set to 'P.True'. It is also
-- emitted when a non-editable item is selected and one of the keys:
-- Space, Return or Enter is pressed.
type IconViewItemActivatedCallback =
    Gtk.TreePath.TreePath
    -- ^ /@path@/: the @GtkTreePath@ for the activated item
    -> IO ()

type C_IconViewItemActivatedCallback =
    Ptr IconView ->                         -- object
    Ptr Gtk.TreePath.TreePath ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_IconViewItemActivatedCallback`.
foreign import ccall "wrapper"
    mk_IconViewItemActivatedCallback :: C_IconViewItemActivatedCallback -> IO (FunPtr C_IconViewItemActivatedCallback)

wrap_IconViewItemActivatedCallback :: 
    GObject a => (a -> IconViewItemActivatedCallback) ->
    C_IconViewItemActivatedCallback
wrap_IconViewItemActivatedCallback gi'cb gi'selfPtr path _ = do
    B.ManagedPtr.withTransient  path $ \path' -> do
        B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  path'


-- | Connect a signal handler for the [itemActivated](#signal:itemActivated) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iconView #itemActivated callback
-- @
-- 
-- 
onIconViewItemActivated :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewItemActivatedCallback) -> m SignalHandlerId
onIconViewItemActivated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewItemActivatedCallback wrapped
    wrapped'' <- mk_IconViewItemActivatedCallback wrapped'
    connectSignalFunPtr obj "item-activated" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [itemActivated](#signal:itemActivated) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iconView #itemActivated callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIconViewItemActivated :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewItemActivatedCallback) -> m SignalHandlerId
afterIconViewItemActivated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewItemActivatedCallback wrapped
    wrapped'' <- mk_IconViewItemActivatedCallback wrapped'
    connectSignalFunPtr obj "item-activated" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IconViewItemActivatedSignalInfo
instance SignalInfo IconViewItemActivatedSignalInfo where
    type HaskellCallbackType IconViewItemActivatedSignalInfo = IconViewItemActivatedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IconViewItemActivatedCallback cb
        cb'' <- mk_IconViewItemActivatedCallback cb'
        connectSignalFunPtr obj "item-activated" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView::item-activated"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:signal:itemActivated"})

#endif

-- signal IconView::move-cursor
-- | The [moveCursor](#g:signal:moveCursor) signal is a
-- [keybinding signal]t'GI.Gtk.Objects.SignalAction.SignalAction'
-- which gets emitted when the user initiates a cursor movement.
-- 
-- Applications should not connect to it, but may emit it with
-- @/g_signal_emit_by_name()/@ if they need to control the cursor
-- programmatically.
-- 
-- The default bindings for this signal include
-- * Arrow keys which move by individual steps
-- * Home\/End keys which move to the first\/last item
-- * PageUp\/PageDown which move by \"pages\"
--   All of these will extend the selection when combined with
--   the Shift modifier.
type IconViewMoveCursorCallback =
    Gtk.Enums.MovementStep
    -- ^ /@step@/: the granularity of the move, as a @GtkMovementStep@
    -> Int32
    -- ^ /@count@/: the number of /@step@/ units to move
    -> Bool
    -- ^ /@extend@/: whether to extend the selection
    -> Bool
    -- ^ /@modify@/: whether to modify the selection
    -> IO Bool
    -- ^ __Returns:__ whether the cursor was moved

type C_IconViewMoveCursorCallback =
    Ptr IconView ->                         -- object
    CUInt ->
    Int32 ->
    CInt ->
    CInt ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_IconViewMoveCursorCallback`.
foreign import ccall "wrapper"
    mk_IconViewMoveCursorCallback :: C_IconViewMoveCursorCallback -> IO (FunPtr C_IconViewMoveCursorCallback)

wrap_IconViewMoveCursorCallback :: 
    GObject a => (a -> IconViewMoveCursorCallback) ->
    C_IconViewMoveCursorCallback
wrap_IconViewMoveCursorCallback gi'cb gi'selfPtr step count extend modify _ = do
    let step' = (toEnum . fromIntegral) step
    let extend' = (/= 0) extend
    let modify' = (/= 0) modify
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  step' count extend' modify'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [moveCursor](#signal:moveCursor) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iconView #moveCursor callback
-- @
-- 
-- 
onIconViewMoveCursor :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewMoveCursorCallback) -> m SignalHandlerId
onIconViewMoveCursor obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewMoveCursorCallback wrapped
    wrapped'' <- mk_IconViewMoveCursorCallback wrapped'
    connectSignalFunPtr obj "move-cursor" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [moveCursor](#signal:moveCursor) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iconView #moveCursor callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIconViewMoveCursor :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewMoveCursorCallback) -> m SignalHandlerId
afterIconViewMoveCursor obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewMoveCursorCallback wrapped
    wrapped'' <- mk_IconViewMoveCursorCallback wrapped'
    connectSignalFunPtr obj "move-cursor" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IconViewMoveCursorSignalInfo
instance SignalInfo IconViewMoveCursorSignalInfo where
    type HaskellCallbackType IconViewMoveCursorSignalInfo = IconViewMoveCursorCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IconViewMoveCursorCallback cb
        cb'' <- mk_IconViewMoveCursorCallback cb'
        connectSignalFunPtr obj "move-cursor" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView::move-cursor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:signal:moveCursor"})

#endif

-- signal IconView::select-all
-- | A [keybinding signal]t'GI.Gtk.Objects.SignalAction.SignalAction'
-- which gets emitted when the user selects all items.
-- 
-- Applications should not connect to it, but may emit it with
-- @/g_signal_emit_by_name()/@ if they need to control selection
-- programmatically.
-- 
-- The default binding for this signal is Ctrl-a.
type IconViewSelectAllCallback =
    IO ()

type C_IconViewSelectAllCallback =
    Ptr IconView ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_IconViewSelectAllCallback`.
foreign import ccall "wrapper"
    mk_IconViewSelectAllCallback :: C_IconViewSelectAllCallback -> IO (FunPtr C_IconViewSelectAllCallback)

wrap_IconViewSelectAllCallback :: 
    GObject a => (a -> IconViewSelectAllCallback) ->
    C_IconViewSelectAllCallback
wrap_IconViewSelectAllCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [selectAll](#signal:selectAll) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iconView #selectAll callback
-- @
-- 
-- 
onIconViewSelectAll :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewSelectAllCallback) -> m SignalHandlerId
onIconViewSelectAll obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewSelectAllCallback wrapped
    wrapped'' <- mk_IconViewSelectAllCallback wrapped'
    connectSignalFunPtr obj "select-all" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [selectAll](#signal:selectAll) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iconView #selectAll callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIconViewSelectAll :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewSelectAllCallback) -> m SignalHandlerId
afterIconViewSelectAll obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewSelectAllCallback wrapped
    wrapped'' <- mk_IconViewSelectAllCallback wrapped'
    connectSignalFunPtr obj "select-all" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IconViewSelectAllSignalInfo
instance SignalInfo IconViewSelectAllSignalInfo where
    type HaskellCallbackType IconViewSelectAllSignalInfo = IconViewSelectAllCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IconViewSelectAllCallback cb
        cb'' <- mk_IconViewSelectAllCallback cb'
        connectSignalFunPtr obj "select-all" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView::select-all"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:signal:selectAll"})

#endif

-- signal IconView::select-cursor-item
-- | A [keybinding signal]t'GI.Gtk.Objects.SignalAction.SignalAction'
-- which gets emitted when the user selects the item that is currently
-- focused.
-- 
-- Applications should not connect to it, but may emit it with
-- @/g_signal_emit_by_name()/@ if they need to control selection
-- programmatically.
-- 
-- There is no default binding for this signal.
type IconViewSelectCursorItemCallback =
    IO ()

type C_IconViewSelectCursorItemCallback =
    Ptr IconView ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_IconViewSelectCursorItemCallback`.
foreign import ccall "wrapper"
    mk_IconViewSelectCursorItemCallback :: C_IconViewSelectCursorItemCallback -> IO (FunPtr C_IconViewSelectCursorItemCallback)

wrap_IconViewSelectCursorItemCallback :: 
    GObject a => (a -> IconViewSelectCursorItemCallback) ->
    C_IconViewSelectCursorItemCallback
wrap_IconViewSelectCursorItemCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [selectCursorItem](#signal:selectCursorItem) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iconView #selectCursorItem callback
-- @
-- 
-- 
onIconViewSelectCursorItem :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewSelectCursorItemCallback) -> m SignalHandlerId
onIconViewSelectCursorItem obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewSelectCursorItemCallback wrapped
    wrapped'' <- mk_IconViewSelectCursorItemCallback wrapped'
    connectSignalFunPtr obj "select-cursor-item" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [selectCursorItem](#signal:selectCursorItem) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iconView #selectCursorItem callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIconViewSelectCursorItem :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewSelectCursorItemCallback) -> m SignalHandlerId
afterIconViewSelectCursorItem obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewSelectCursorItemCallback wrapped
    wrapped'' <- mk_IconViewSelectCursorItemCallback wrapped'
    connectSignalFunPtr obj "select-cursor-item" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IconViewSelectCursorItemSignalInfo
instance SignalInfo IconViewSelectCursorItemSignalInfo where
    type HaskellCallbackType IconViewSelectCursorItemSignalInfo = IconViewSelectCursorItemCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IconViewSelectCursorItemCallback cb
        cb'' <- mk_IconViewSelectCursorItemCallback cb'
        connectSignalFunPtr obj "select-cursor-item" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView::select-cursor-item"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:signal:selectCursorItem"})

#endif

-- signal IconView::selection-changed
-- | The [selectionChanged](#g:signal:selectionChanged) signal is emitted when the selection
-- (i.e. the set of selected items) changes.
type IconViewSelectionChangedCallback =
    IO ()

type C_IconViewSelectionChangedCallback =
    Ptr IconView ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_IconViewSelectionChangedCallback`.
foreign import ccall "wrapper"
    mk_IconViewSelectionChangedCallback :: C_IconViewSelectionChangedCallback -> IO (FunPtr C_IconViewSelectionChangedCallback)

wrap_IconViewSelectionChangedCallback :: 
    GObject a => (a -> IconViewSelectionChangedCallback) ->
    C_IconViewSelectionChangedCallback
wrap_IconViewSelectionChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [selectionChanged](#signal:selectionChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iconView #selectionChanged callback
-- @
-- 
-- 
onIconViewSelectionChanged :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewSelectionChangedCallback) -> m SignalHandlerId
onIconViewSelectionChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewSelectionChangedCallback wrapped
    wrapped'' <- mk_IconViewSelectionChangedCallback wrapped'
    connectSignalFunPtr obj "selection-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [selectionChanged](#signal:selectionChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iconView #selectionChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIconViewSelectionChanged :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewSelectionChangedCallback) -> m SignalHandlerId
afterIconViewSelectionChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewSelectionChangedCallback wrapped
    wrapped'' <- mk_IconViewSelectionChangedCallback wrapped'
    connectSignalFunPtr obj "selection-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IconViewSelectionChangedSignalInfo
instance SignalInfo IconViewSelectionChangedSignalInfo where
    type HaskellCallbackType IconViewSelectionChangedSignalInfo = IconViewSelectionChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IconViewSelectionChangedCallback cb
        cb'' <- mk_IconViewSelectionChangedCallback cb'
        connectSignalFunPtr obj "selection-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView::selection-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:signal:selectionChanged"})

#endif

-- signal IconView::toggle-cursor-item
-- | A [keybinding signal]t'GI.Gtk.Objects.SignalAction.SignalAction'
-- which gets emitted when the user toggles whether the currently
-- focused item is selected or not. The exact effect of this
-- depend on the selection mode.
-- 
-- Applications should not connect to it, but may emit it with
-- @/g_signal_emit_by_name()/@ if they need to control selection
-- programmatically.
-- 
-- There is no default binding for this signal is Ctrl-Space.
type IconViewToggleCursorItemCallback =
    IO ()

type C_IconViewToggleCursorItemCallback =
    Ptr IconView ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_IconViewToggleCursorItemCallback`.
foreign import ccall "wrapper"
    mk_IconViewToggleCursorItemCallback :: C_IconViewToggleCursorItemCallback -> IO (FunPtr C_IconViewToggleCursorItemCallback)

wrap_IconViewToggleCursorItemCallback :: 
    GObject a => (a -> IconViewToggleCursorItemCallback) ->
    C_IconViewToggleCursorItemCallback
wrap_IconViewToggleCursorItemCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [toggleCursorItem](#signal:toggleCursorItem) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iconView #toggleCursorItem callback
-- @
-- 
-- 
onIconViewToggleCursorItem :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewToggleCursorItemCallback) -> m SignalHandlerId
onIconViewToggleCursorItem obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewToggleCursorItemCallback wrapped
    wrapped'' <- mk_IconViewToggleCursorItemCallback wrapped'
    connectSignalFunPtr obj "toggle-cursor-item" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [toggleCursorItem](#signal:toggleCursorItem) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iconView #toggleCursorItem callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIconViewToggleCursorItem :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewToggleCursorItemCallback) -> m SignalHandlerId
afterIconViewToggleCursorItem obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewToggleCursorItemCallback wrapped
    wrapped'' <- mk_IconViewToggleCursorItemCallback wrapped'
    connectSignalFunPtr obj "toggle-cursor-item" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IconViewToggleCursorItemSignalInfo
instance SignalInfo IconViewToggleCursorItemSignalInfo where
    type HaskellCallbackType IconViewToggleCursorItemSignalInfo = IconViewToggleCursorItemCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IconViewToggleCursorItemCallback cb
        cb'' <- mk_IconViewToggleCursorItemCallback cb'
        connectSignalFunPtr obj "toggle-cursor-item" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView::toggle-cursor-item"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:signal:toggleCursorItem"})

#endif

-- signal IconView::unselect-all
-- | A [keybinding signal]t'GI.Gtk.Objects.SignalAction.SignalAction'
-- which gets emitted when the user unselects all items.
-- 
-- Applications should not connect to it, but may emit it with
-- @/g_signal_emit_by_name()/@ if they need to control selection
-- programmatically.
-- 
-- The default binding for this signal is Ctrl-Shift-a.
type IconViewUnselectAllCallback =
    IO ()

type C_IconViewUnselectAllCallback =
    Ptr IconView ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_IconViewUnselectAllCallback`.
foreign import ccall "wrapper"
    mk_IconViewUnselectAllCallback :: C_IconViewUnselectAllCallback -> IO (FunPtr C_IconViewUnselectAllCallback)

wrap_IconViewUnselectAllCallback :: 
    GObject a => (a -> IconViewUnselectAllCallback) ->
    C_IconViewUnselectAllCallback
wrap_IconViewUnselectAllCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [unselectAll](#signal:unselectAll) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iconView #unselectAll callback
-- @
-- 
-- 
onIconViewUnselectAll :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewUnselectAllCallback) -> m SignalHandlerId
onIconViewUnselectAll obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewUnselectAllCallback wrapped
    wrapped'' <- mk_IconViewUnselectAllCallback wrapped'
    connectSignalFunPtr obj "unselect-all" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [unselectAll](#signal:unselectAll) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iconView #unselectAll callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIconViewUnselectAll :: (IsIconView a, MonadIO m) => a -> ((?self :: a) => IconViewUnselectAllCallback) -> m SignalHandlerId
afterIconViewUnselectAll obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconViewUnselectAllCallback wrapped
    wrapped'' <- mk_IconViewUnselectAllCallback wrapped'
    connectSignalFunPtr obj "unselect-all" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IconViewUnselectAllSignalInfo
instance SignalInfo IconViewUnselectAllSignalInfo where
    type HaskellCallbackType IconViewUnselectAllSignalInfo = IconViewUnselectAllCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IconViewUnselectAllCallback cb
        cb'' <- mk_IconViewUnselectAllCallback cb'
        connectSignalFunPtr obj "unselect-all" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView::unselect-all"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:signal:unselectAll"})

#endif

-- VVV Prop "activate-on-single-click"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@activate-on-single-click@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #activateOnSingleClick
-- @
getIconViewActivateOnSingleClick :: (MonadIO m, IsIconView o) => o -> m Bool
getIconViewActivateOnSingleClick obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "activate-on-single-click"

-- | Set the value of the “@activate-on-single-click@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #activateOnSingleClick 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewActivateOnSingleClick :: (MonadIO m, IsIconView o) => o -> Bool -> m ()
setIconViewActivateOnSingleClick obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "activate-on-single-click" val

-- | Construct a t'GValueConstruct' with valid value for the “@activate-on-single-click@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewActivateOnSingleClick :: (IsIconView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructIconViewActivateOnSingleClick val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "activate-on-single-click" val

#if defined(ENABLE_OVERLOADING)
data IconViewActivateOnSingleClickPropertyInfo
instance AttrInfo IconViewActivateOnSingleClickPropertyInfo where
    type AttrAllowedOps IconViewActivateOnSingleClickPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewActivateOnSingleClickPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewActivateOnSingleClickPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint IconViewActivateOnSingleClickPropertyInfo = (~) Bool
    type AttrTransferType IconViewActivateOnSingleClickPropertyInfo = Bool
    type AttrGetType IconViewActivateOnSingleClickPropertyInfo = Bool
    type AttrLabel IconViewActivateOnSingleClickPropertyInfo = "activate-on-single-click"
    type AttrOrigin IconViewActivateOnSingleClickPropertyInfo = IconView
    attrGet = getIconViewActivateOnSingleClick
    attrSet = setIconViewActivateOnSingleClick
    attrPut = setIconViewActivateOnSingleClick
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewActivateOnSingleClick
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.activateOnSingleClick"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:activateOnSingleClick"
        })
#endif

-- VVV Prop "cell-area"
   -- Type: TInterface (Name {namespace = "Gtk", name = "CellArea"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@cell-area@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #cellArea
-- @
getIconViewCellArea :: (MonadIO m, IsIconView o) => o -> m (Maybe Gtk.CellArea.CellArea)
getIconViewCellArea obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "cell-area" Gtk.CellArea.CellArea

-- | Construct a t'GValueConstruct' with valid value for the “@cell-area@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewCellArea :: (IsIconView o, MIO.MonadIO m, Gtk.CellArea.IsCellArea a) => a -> m (GValueConstruct o)
constructIconViewCellArea val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "cell-area" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data IconViewCellAreaPropertyInfo
instance AttrInfo IconViewCellAreaPropertyInfo where
    type AttrAllowedOps IconViewCellAreaPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint IconViewCellAreaPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewCellAreaPropertyInfo = Gtk.CellArea.IsCellArea
    type AttrTransferTypeConstraint IconViewCellAreaPropertyInfo = Gtk.CellArea.IsCellArea
    type AttrTransferType IconViewCellAreaPropertyInfo = Gtk.CellArea.CellArea
    type AttrGetType IconViewCellAreaPropertyInfo = (Maybe Gtk.CellArea.CellArea)
    type AttrLabel IconViewCellAreaPropertyInfo = "cell-area"
    type AttrOrigin IconViewCellAreaPropertyInfo = IconView
    attrGet = getIconViewCellArea
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.CellArea.CellArea v
    attrConstruct = constructIconViewCellArea
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.cellArea"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:cellArea"
        })
#endif

-- VVV Prop "column-spacing"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@column-spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #columnSpacing
-- @
getIconViewColumnSpacing :: (MonadIO m, IsIconView o) => o -> m Int32
getIconViewColumnSpacing obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "column-spacing"

-- | Set the value of the “@column-spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #columnSpacing 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewColumnSpacing :: (MonadIO m, IsIconView o) => o -> Int32 -> m ()
setIconViewColumnSpacing obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "column-spacing" val

-- | Construct a t'GValueConstruct' with valid value for the “@column-spacing@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewColumnSpacing :: (IsIconView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructIconViewColumnSpacing val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "column-spacing" val

#if defined(ENABLE_OVERLOADING)
data IconViewColumnSpacingPropertyInfo
instance AttrInfo IconViewColumnSpacingPropertyInfo where
    type AttrAllowedOps IconViewColumnSpacingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewColumnSpacingPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewColumnSpacingPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint IconViewColumnSpacingPropertyInfo = (~) Int32
    type AttrTransferType IconViewColumnSpacingPropertyInfo = Int32
    type AttrGetType IconViewColumnSpacingPropertyInfo = Int32
    type AttrLabel IconViewColumnSpacingPropertyInfo = "column-spacing"
    type AttrOrigin IconViewColumnSpacingPropertyInfo = IconView
    attrGet = getIconViewColumnSpacing
    attrSet = setIconViewColumnSpacing
    attrPut = setIconViewColumnSpacing
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewColumnSpacing
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.columnSpacing"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:columnSpacing"
        })
#endif

-- VVV Prop "columns"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@columns@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #columns
-- @
getIconViewColumns :: (MonadIO m, IsIconView o) => o -> m Int32
getIconViewColumns obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "columns"

-- | Set the value of the “@columns@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #columns 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewColumns :: (MonadIO m, IsIconView o) => o -> Int32 -> m ()
setIconViewColumns obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "columns" val

-- | Construct a t'GValueConstruct' with valid value for the “@columns@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewColumns :: (IsIconView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructIconViewColumns val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "columns" val

#if defined(ENABLE_OVERLOADING)
data IconViewColumnsPropertyInfo
instance AttrInfo IconViewColumnsPropertyInfo where
    type AttrAllowedOps IconViewColumnsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewColumnsPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewColumnsPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint IconViewColumnsPropertyInfo = (~) Int32
    type AttrTransferType IconViewColumnsPropertyInfo = Int32
    type AttrGetType IconViewColumnsPropertyInfo = Int32
    type AttrLabel IconViewColumnsPropertyInfo = "columns"
    type AttrOrigin IconViewColumnsPropertyInfo = IconView
    attrGet = getIconViewColumns
    attrSet = setIconViewColumns
    attrPut = setIconViewColumns
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewColumns
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.columns"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:columns"
        })
#endif

-- VVV Prop "item-orientation"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Orientation"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@item-orientation@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #itemOrientation
-- @
getIconViewItemOrientation :: (MonadIO m, IsIconView o) => o -> m Gtk.Enums.Orientation
getIconViewItemOrientation obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "item-orientation"

-- | Set the value of the “@item-orientation@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #itemOrientation 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewItemOrientation :: (MonadIO m, IsIconView o) => o -> Gtk.Enums.Orientation -> m ()
setIconViewItemOrientation obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "item-orientation" val

-- | Construct a t'GValueConstruct' with valid value for the “@item-orientation@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewItemOrientation :: (IsIconView o, MIO.MonadIO m) => Gtk.Enums.Orientation -> m (GValueConstruct o)
constructIconViewItemOrientation val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "item-orientation" val

#if defined(ENABLE_OVERLOADING)
data IconViewItemOrientationPropertyInfo
instance AttrInfo IconViewItemOrientationPropertyInfo where
    type AttrAllowedOps IconViewItemOrientationPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewItemOrientationPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewItemOrientationPropertyInfo = (~) Gtk.Enums.Orientation
    type AttrTransferTypeConstraint IconViewItemOrientationPropertyInfo = (~) Gtk.Enums.Orientation
    type AttrTransferType IconViewItemOrientationPropertyInfo = Gtk.Enums.Orientation
    type AttrGetType IconViewItemOrientationPropertyInfo = Gtk.Enums.Orientation
    type AttrLabel IconViewItemOrientationPropertyInfo = "item-orientation"
    type AttrOrigin IconViewItemOrientationPropertyInfo = IconView
    attrGet = getIconViewItemOrientation
    attrSet = setIconViewItemOrientation
    attrPut = setIconViewItemOrientation
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewItemOrientation
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.itemOrientation"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:itemOrientation"
        })
#endif

-- VVV Prop "item-padding"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@item-padding@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #itemPadding
-- @
getIconViewItemPadding :: (MonadIO m, IsIconView o) => o -> m Int32
getIconViewItemPadding obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "item-padding"

-- | Set the value of the “@item-padding@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #itemPadding 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewItemPadding :: (MonadIO m, IsIconView o) => o -> Int32 -> m ()
setIconViewItemPadding obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "item-padding" val

-- | Construct a t'GValueConstruct' with valid value for the “@item-padding@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewItemPadding :: (IsIconView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructIconViewItemPadding val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "item-padding" val

#if defined(ENABLE_OVERLOADING)
data IconViewItemPaddingPropertyInfo
instance AttrInfo IconViewItemPaddingPropertyInfo where
    type AttrAllowedOps IconViewItemPaddingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewItemPaddingPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewItemPaddingPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint IconViewItemPaddingPropertyInfo = (~) Int32
    type AttrTransferType IconViewItemPaddingPropertyInfo = Int32
    type AttrGetType IconViewItemPaddingPropertyInfo = Int32
    type AttrLabel IconViewItemPaddingPropertyInfo = "item-padding"
    type AttrOrigin IconViewItemPaddingPropertyInfo = IconView
    attrGet = getIconViewItemPadding
    attrSet = setIconViewItemPadding
    attrPut = setIconViewItemPadding
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewItemPadding
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.itemPadding"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:itemPadding"
        })
#endif

-- VVV Prop "item-width"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@item-width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #itemWidth
-- @
getIconViewItemWidth :: (MonadIO m, IsIconView o) => o -> m Int32
getIconViewItemWidth obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "item-width"

-- | Set the value of the “@item-width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #itemWidth 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewItemWidth :: (MonadIO m, IsIconView o) => o -> Int32 -> m ()
setIconViewItemWidth obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "item-width" val

-- | Construct a t'GValueConstruct' with valid value for the “@item-width@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewItemWidth :: (IsIconView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructIconViewItemWidth val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "item-width" val

#if defined(ENABLE_OVERLOADING)
data IconViewItemWidthPropertyInfo
instance AttrInfo IconViewItemWidthPropertyInfo where
    type AttrAllowedOps IconViewItemWidthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewItemWidthPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewItemWidthPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint IconViewItemWidthPropertyInfo = (~) Int32
    type AttrTransferType IconViewItemWidthPropertyInfo = Int32
    type AttrGetType IconViewItemWidthPropertyInfo = Int32
    type AttrLabel IconViewItemWidthPropertyInfo = "item-width"
    type AttrOrigin IconViewItemWidthPropertyInfo = IconView
    attrGet = getIconViewItemWidth
    attrSet = setIconViewItemWidth
    attrPut = setIconViewItemWidth
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewItemWidth
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.itemWidth"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:itemWidth"
        })
#endif

-- VVV Prop "margin"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@margin@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #margin
-- @
getIconViewMargin :: (MonadIO m, IsIconView o) => o -> m Int32
getIconViewMargin obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "margin"

-- | Set the value of the “@margin@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #margin 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewMargin :: (MonadIO m, IsIconView o) => o -> Int32 -> m ()
setIconViewMargin obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "margin" val

-- | Construct a t'GValueConstruct' with valid value for the “@margin@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewMargin :: (IsIconView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructIconViewMargin val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "margin" val

#if defined(ENABLE_OVERLOADING)
data IconViewMarginPropertyInfo
instance AttrInfo IconViewMarginPropertyInfo where
    type AttrAllowedOps IconViewMarginPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewMarginPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewMarginPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint IconViewMarginPropertyInfo = (~) Int32
    type AttrTransferType IconViewMarginPropertyInfo = Int32
    type AttrGetType IconViewMarginPropertyInfo = Int32
    type AttrLabel IconViewMarginPropertyInfo = "margin"
    type AttrOrigin IconViewMarginPropertyInfo = IconView
    attrGet = getIconViewMargin
    attrSet = setIconViewMargin
    attrPut = setIconViewMargin
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewMargin
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.margin"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:margin"
        })
#endif

-- VVV Prop "markup-column"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@markup-column@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #markupColumn
-- @
getIconViewMarkupColumn :: (MonadIO m, IsIconView o) => o -> m Int32
getIconViewMarkupColumn obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "markup-column"

-- | Set the value of the “@markup-column@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #markupColumn 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewMarkupColumn :: (MonadIO m, IsIconView o) => o -> Int32 -> m ()
setIconViewMarkupColumn obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "markup-column" val

-- | Construct a t'GValueConstruct' with valid value for the “@markup-column@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewMarkupColumn :: (IsIconView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructIconViewMarkupColumn val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "markup-column" val

#if defined(ENABLE_OVERLOADING)
data IconViewMarkupColumnPropertyInfo
instance AttrInfo IconViewMarkupColumnPropertyInfo where
    type AttrAllowedOps IconViewMarkupColumnPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewMarkupColumnPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewMarkupColumnPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint IconViewMarkupColumnPropertyInfo = (~) Int32
    type AttrTransferType IconViewMarkupColumnPropertyInfo = Int32
    type AttrGetType IconViewMarkupColumnPropertyInfo = Int32
    type AttrLabel IconViewMarkupColumnPropertyInfo = "markup-column"
    type AttrOrigin IconViewMarkupColumnPropertyInfo = IconView
    attrGet = getIconViewMarkupColumn
    attrSet = setIconViewMarkupColumn
    attrPut = setIconViewMarkupColumn
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewMarkupColumn
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.markupColumn"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:markupColumn"
        })
#endif

-- VVV Prop "model"
   -- Type: TInterface (Name {namespace = "Gtk", name = "TreeModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #model
-- @
getIconViewModel :: (MonadIO m, IsIconView o) => o -> m (Maybe Gtk.TreeModel.TreeModel)
getIconViewModel obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "model" Gtk.TreeModel.TreeModel

-- | Set the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #model 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewModel :: (MonadIO m, IsIconView o, Gtk.TreeModel.IsTreeModel a) => o -> a -> m ()
setIconViewModel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "model" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@model@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewModel :: (IsIconView o, MIO.MonadIO m, Gtk.TreeModel.IsTreeModel a) => a -> m (GValueConstruct o)
constructIconViewModel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "model" (P.Just val)

-- | Set the value of the “@model@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #model
-- @
clearIconViewModel :: (MonadIO m, IsIconView o) => o -> m ()
clearIconViewModel obj = liftIO $ B.Properties.setObjectPropertyObject obj "model" (Nothing :: Maybe Gtk.TreeModel.TreeModel)

#if defined(ENABLE_OVERLOADING)
data IconViewModelPropertyInfo
instance AttrInfo IconViewModelPropertyInfo where
    type AttrAllowedOps IconViewModelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint IconViewModelPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewModelPropertyInfo = Gtk.TreeModel.IsTreeModel
    type AttrTransferTypeConstraint IconViewModelPropertyInfo = Gtk.TreeModel.IsTreeModel
    type AttrTransferType IconViewModelPropertyInfo = Gtk.TreeModel.TreeModel
    type AttrGetType IconViewModelPropertyInfo = (Maybe Gtk.TreeModel.TreeModel)
    type AttrLabel IconViewModelPropertyInfo = "model"
    type AttrOrigin IconViewModelPropertyInfo = IconView
    attrGet = getIconViewModel
    attrSet = setIconViewModel
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.TreeModel.TreeModel v
    attrConstruct = constructIconViewModel
    attrClear = clearIconViewModel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.model"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:model"
        })
#endif

-- VVV Prop "pixbuf-column"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@pixbuf-column@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #pixbufColumn
-- @
getIconViewPixbufColumn :: (MonadIO m, IsIconView o) => o -> m Int32
getIconViewPixbufColumn obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "pixbuf-column"

-- | Set the value of the “@pixbuf-column@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #pixbufColumn 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewPixbufColumn :: (MonadIO m, IsIconView o) => o -> Int32 -> m ()
setIconViewPixbufColumn obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "pixbuf-column" val

-- | Construct a t'GValueConstruct' with valid value for the “@pixbuf-column@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewPixbufColumn :: (IsIconView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructIconViewPixbufColumn val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "pixbuf-column" val

#if defined(ENABLE_OVERLOADING)
data IconViewPixbufColumnPropertyInfo
instance AttrInfo IconViewPixbufColumnPropertyInfo where
    type AttrAllowedOps IconViewPixbufColumnPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewPixbufColumnPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewPixbufColumnPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint IconViewPixbufColumnPropertyInfo = (~) Int32
    type AttrTransferType IconViewPixbufColumnPropertyInfo = Int32
    type AttrGetType IconViewPixbufColumnPropertyInfo = Int32
    type AttrLabel IconViewPixbufColumnPropertyInfo = "pixbuf-column"
    type AttrOrigin IconViewPixbufColumnPropertyInfo = IconView
    attrGet = getIconViewPixbufColumn
    attrSet = setIconViewPixbufColumn
    attrPut = setIconViewPixbufColumn
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewPixbufColumn
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.pixbufColumn"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:pixbufColumn"
        })
#endif

-- VVV Prop "reorderable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@reorderable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #reorderable
-- @
getIconViewReorderable :: (MonadIO m, IsIconView o) => o -> m Bool
getIconViewReorderable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "reorderable"

-- | Set the value of the “@reorderable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #reorderable 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewReorderable :: (MonadIO m, IsIconView o) => o -> Bool -> m ()
setIconViewReorderable obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "reorderable" val

-- | Construct a t'GValueConstruct' with valid value for the “@reorderable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewReorderable :: (IsIconView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructIconViewReorderable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "reorderable" val

#if defined(ENABLE_OVERLOADING)
data IconViewReorderablePropertyInfo
instance AttrInfo IconViewReorderablePropertyInfo where
    type AttrAllowedOps IconViewReorderablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewReorderablePropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewReorderablePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint IconViewReorderablePropertyInfo = (~) Bool
    type AttrTransferType IconViewReorderablePropertyInfo = Bool
    type AttrGetType IconViewReorderablePropertyInfo = Bool
    type AttrLabel IconViewReorderablePropertyInfo = "reorderable"
    type AttrOrigin IconViewReorderablePropertyInfo = IconView
    attrGet = getIconViewReorderable
    attrSet = setIconViewReorderable
    attrPut = setIconViewReorderable
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewReorderable
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.reorderable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:reorderable"
        })
#endif

-- VVV Prop "row-spacing"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@row-spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #rowSpacing
-- @
getIconViewRowSpacing :: (MonadIO m, IsIconView o) => o -> m Int32
getIconViewRowSpacing obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "row-spacing"

-- | Set the value of the “@row-spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #rowSpacing 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewRowSpacing :: (MonadIO m, IsIconView o) => o -> Int32 -> m ()
setIconViewRowSpacing obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "row-spacing" val

-- | Construct a t'GValueConstruct' with valid value for the “@row-spacing@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewRowSpacing :: (IsIconView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructIconViewRowSpacing val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "row-spacing" val

#if defined(ENABLE_OVERLOADING)
data IconViewRowSpacingPropertyInfo
instance AttrInfo IconViewRowSpacingPropertyInfo where
    type AttrAllowedOps IconViewRowSpacingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewRowSpacingPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewRowSpacingPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint IconViewRowSpacingPropertyInfo = (~) Int32
    type AttrTransferType IconViewRowSpacingPropertyInfo = Int32
    type AttrGetType IconViewRowSpacingPropertyInfo = Int32
    type AttrLabel IconViewRowSpacingPropertyInfo = "row-spacing"
    type AttrOrigin IconViewRowSpacingPropertyInfo = IconView
    attrGet = getIconViewRowSpacing
    attrSet = setIconViewRowSpacing
    attrPut = setIconViewRowSpacing
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewRowSpacing
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.rowSpacing"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:rowSpacing"
        })
#endif

-- VVV Prop "selection-mode"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SelectionMode"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@selection-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #selectionMode
-- @
getIconViewSelectionMode :: (MonadIO m, IsIconView o) => o -> m Gtk.Enums.SelectionMode
getIconViewSelectionMode obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "selection-mode"

-- | Set the value of the “@selection-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #selectionMode 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewSelectionMode :: (MonadIO m, IsIconView o) => o -> Gtk.Enums.SelectionMode -> m ()
setIconViewSelectionMode obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "selection-mode" val

-- | Construct a t'GValueConstruct' with valid value for the “@selection-mode@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewSelectionMode :: (IsIconView o, MIO.MonadIO m) => Gtk.Enums.SelectionMode -> m (GValueConstruct o)
constructIconViewSelectionMode val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "selection-mode" val

#if defined(ENABLE_OVERLOADING)
data IconViewSelectionModePropertyInfo
instance AttrInfo IconViewSelectionModePropertyInfo where
    type AttrAllowedOps IconViewSelectionModePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewSelectionModePropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewSelectionModePropertyInfo = (~) Gtk.Enums.SelectionMode
    type AttrTransferTypeConstraint IconViewSelectionModePropertyInfo = (~) Gtk.Enums.SelectionMode
    type AttrTransferType IconViewSelectionModePropertyInfo = Gtk.Enums.SelectionMode
    type AttrGetType IconViewSelectionModePropertyInfo = Gtk.Enums.SelectionMode
    type AttrLabel IconViewSelectionModePropertyInfo = "selection-mode"
    type AttrOrigin IconViewSelectionModePropertyInfo = IconView
    attrGet = getIconViewSelectionMode
    attrSet = setIconViewSelectionMode
    attrPut = setIconViewSelectionMode
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewSelectionMode
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.selectionMode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:selectionMode"
        })
#endif

-- VVV Prop "spacing"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #spacing
-- @
getIconViewSpacing :: (MonadIO m, IsIconView o) => o -> m Int32
getIconViewSpacing obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "spacing"

-- | Set the value of the “@spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #spacing 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewSpacing :: (MonadIO m, IsIconView o) => o -> Int32 -> m ()
setIconViewSpacing obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "spacing" val

-- | Construct a t'GValueConstruct' with valid value for the “@spacing@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewSpacing :: (IsIconView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructIconViewSpacing val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "spacing" val

#if defined(ENABLE_OVERLOADING)
data IconViewSpacingPropertyInfo
instance AttrInfo IconViewSpacingPropertyInfo where
    type AttrAllowedOps IconViewSpacingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewSpacingPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewSpacingPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint IconViewSpacingPropertyInfo = (~) Int32
    type AttrTransferType IconViewSpacingPropertyInfo = Int32
    type AttrGetType IconViewSpacingPropertyInfo = Int32
    type AttrLabel IconViewSpacingPropertyInfo = "spacing"
    type AttrOrigin IconViewSpacingPropertyInfo = IconView
    attrGet = getIconViewSpacing
    attrSet = setIconViewSpacing
    attrPut = setIconViewSpacing
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewSpacing
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.spacing"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:spacing"
        })
#endif

-- VVV Prop "text-column"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@text-column@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #textColumn
-- @
getIconViewTextColumn :: (MonadIO m, IsIconView o) => o -> m Int32
getIconViewTextColumn obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "text-column"

-- | Set the value of the “@text-column@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #textColumn 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewTextColumn :: (MonadIO m, IsIconView o) => o -> Int32 -> m ()
setIconViewTextColumn obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "text-column" val

-- | Construct a t'GValueConstruct' with valid value for the “@text-column@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewTextColumn :: (IsIconView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructIconViewTextColumn val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "text-column" val

#if defined(ENABLE_OVERLOADING)
data IconViewTextColumnPropertyInfo
instance AttrInfo IconViewTextColumnPropertyInfo where
    type AttrAllowedOps IconViewTextColumnPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewTextColumnPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewTextColumnPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint IconViewTextColumnPropertyInfo = (~) Int32
    type AttrTransferType IconViewTextColumnPropertyInfo = Int32
    type AttrGetType IconViewTextColumnPropertyInfo = Int32
    type AttrLabel IconViewTextColumnPropertyInfo = "text-column"
    type AttrOrigin IconViewTextColumnPropertyInfo = IconView
    attrGet = getIconViewTextColumn
    attrSet = setIconViewTextColumn
    attrPut = setIconViewTextColumn
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewTextColumn
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.textColumn"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:textColumn"
        })
#endif

-- VVV Prop "tooltip-column"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@tooltip-column@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconView #tooltipColumn
-- @
getIconViewTooltipColumn :: (MonadIO m, IsIconView o) => o -> m Int32
getIconViewTooltipColumn obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "tooltip-column"

-- | Set the value of the “@tooltip-column@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconView [ #tooltipColumn 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconViewTooltipColumn :: (MonadIO m, IsIconView o) => o -> Int32 -> m ()
setIconViewTooltipColumn obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "tooltip-column" val

-- | Construct a t'GValueConstruct' with valid value for the “@tooltip-column@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconViewTooltipColumn :: (IsIconView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructIconViewTooltipColumn val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "tooltip-column" val

#if defined(ENABLE_OVERLOADING)
data IconViewTooltipColumnPropertyInfo
instance AttrInfo IconViewTooltipColumnPropertyInfo where
    type AttrAllowedOps IconViewTooltipColumnPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint IconViewTooltipColumnPropertyInfo = IsIconView
    type AttrSetTypeConstraint IconViewTooltipColumnPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint IconViewTooltipColumnPropertyInfo = (~) Int32
    type AttrTransferType IconViewTooltipColumnPropertyInfo = Int32
    type AttrGetType IconViewTooltipColumnPropertyInfo = Int32
    type AttrLabel IconViewTooltipColumnPropertyInfo = "tooltip-column"
    type AttrOrigin IconViewTooltipColumnPropertyInfo = IconView
    attrGet = getIconViewTooltipColumn
    attrSet = setIconViewTooltipColumn
    attrPut = setIconViewTooltipColumn
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconViewTooltipColumn
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.tooltipColumn"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#g:attr:tooltipColumn"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList IconView
type instance O.AttributeList IconView = IconViewAttributeList
type IconViewAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("activateOnSingleClick", IconViewActivateOnSingleClickPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cellArea", IconViewCellAreaPropertyInfo), '("columnSpacing", IconViewColumnSpacingPropertyInfo), '("columns", IconViewColumnsPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("hadjustment", Gtk.Scrollable.ScrollableHadjustmentPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hscrollPolicy", Gtk.Scrollable.ScrollableHscrollPolicyPropertyInfo), '("itemOrientation", IconViewItemOrientationPropertyInfo), '("itemPadding", IconViewItemPaddingPropertyInfo), '("itemWidth", IconViewItemWidthPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("margin", IconViewMarginPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("markupColumn", IconViewMarkupColumnPropertyInfo), '("model", IconViewModelPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("pixbufColumn", IconViewPixbufColumnPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("reorderable", IconViewReorderablePropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("rowSpacing", IconViewRowSpacingPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("selectionMode", IconViewSelectionModePropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("spacing", IconViewSpacingPropertyInfo), '("textColumn", IconViewTextColumnPropertyInfo), '("tooltipColumn", IconViewTooltipColumnPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("vadjustment", Gtk.Scrollable.ScrollableVadjustmentPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("vscrollPolicy", Gtk.Scrollable.ScrollableVscrollPolicyPropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
iconViewActivateOnSingleClick :: AttrLabelProxy "activateOnSingleClick"
iconViewActivateOnSingleClick = AttrLabelProxy

iconViewCellArea :: AttrLabelProxy "cellArea"
iconViewCellArea = AttrLabelProxy

iconViewColumnSpacing :: AttrLabelProxy "columnSpacing"
iconViewColumnSpacing = AttrLabelProxy

iconViewColumns :: AttrLabelProxy "columns"
iconViewColumns = AttrLabelProxy

iconViewItemOrientation :: AttrLabelProxy "itemOrientation"
iconViewItemOrientation = AttrLabelProxy

iconViewItemPadding :: AttrLabelProxy "itemPadding"
iconViewItemPadding = AttrLabelProxy

iconViewItemWidth :: AttrLabelProxy "itemWidth"
iconViewItemWidth = AttrLabelProxy

iconViewMargin :: AttrLabelProxy "margin"
iconViewMargin = AttrLabelProxy

iconViewMarkupColumn :: AttrLabelProxy "markupColumn"
iconViewMarkupColumn = AttrLabelProxy

iconViewModel :: AttrLabelProxy "model"
iconViewModel = AttrLabelProxy

iconViewPixbufColumn :: AttrLabelProxy "pixbufColumn"
iconViewPixbufColumn = AttrLabelProxy

iconViewReorderable :: AttrLabelProxy "reorderable"
iconViewReorderable = AttrLabelProxy

iconViewRowSpacing :: AttrLabelProxy "rowSpacing"
iconViewRowSpacing = AttrLabelProxy

iconViewSelectionMode :: AttrLabelProxy "selectionMode"
iconViewSelectionMode = AttrLabelProxy

iconViewSpacing :: AttrLabelProxy "spacing"
iconViewSpacing = AttrLabelProxy

iconViewTextColumn :: AttrLabelProxy "textColumn"
iconViewTextColumn = AttrLabelProxy

iconViewTooltipColumn :: AttrLabelProxy "tooltipColumn"
iconViewTooltipColumn = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList IconView = IconViewSignalList
type IconViewSignalList = ('[ '("activateCursorItem", IconViewActivateCursorItemSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("itemActivated", IconViewItemActivatedSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveCursor", IconViewMoveCursorSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("selectAll", IconViewSelectAllSignalInfo), '("selectCursorItem", IconViewSelectCursorItemSignalInfo), '("selectionChanged", IconViewSelectionChangedSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("toggleCursorItem", IconViewToggleCursorItemSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo), '("unselectAll", IconViewUnselectAllSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method IconView::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "IconView" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_new" gtk_icon_view_new :: 
    IO (Ptr IconView)

{-# DEPRECATED iconViewNew ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Creates a new @GtkIconView@ widget
iconViewNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m IconView
    -- ^ __Returns:__ A newly created @GtkIconView@ widget
iconViewNew  = liftIO $ do
    result <- gtk_icon_view_new
    checkUnexpectedReturnNULL "iconViewNew" result
    result' <- (newObject IconView) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method IconView::new_with_area
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "area"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CellArea" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkCellArea` to use to layout cells"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "IconView" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_new_with_area" gtk_icon_view_new_with_area :: 
    Ptr Gtk.CellArea.CellArea ->            -- area : TInterface (Name {namespace = "Gtk", name = "CellArea"})
    IO (Ptr IconView)

{-# DEPRECATED iconViewNewWithArea ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Creates a new @GtkIconView@ widget using the
-- specified /@area@/ to layout cells inside the icons.
iconViewNewWithArea ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.CellArea.IsCellArea a) =>
    a
    -- ^ /@area@/: the @GtkCellArea@ to use to layout cells
    -> m IconView
    -- ^ __Returns:__ A newly created @GtkIconView@ widget
iconViewNewWithArea area = liftIO $ do
    area' <- unsafeManagedPtrCastPtr area
    result <- gtk_icon_view_new_with_area area'
    checkUnexpectedReturnNULL "iconViewNewWithArea" result
    result' <- (newObject IconView) result
    touchManagedPtr area
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method IconView::new_with_model
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The model." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "IconView" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_new_with_model" gtk_icon_view_new_with_model :: 
    Ptr Gtk.TreeModel.TreeModel ->          -- model : TInterface (Name {namespace = "Gtk", name = "TreeModel"})
    IO (Ptr IconView)

{-# DEPRECATED iconViewNewWithModel ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Creates a new @GtkIconView@ widget with the model /@model@/.
iconViewNewWithModel ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeModel.IsTreeModel a) =>
    a
    -- ^ /@model@/: The model.
    -> m IconView
    -- ^ __Returns:__ A newly created @GtkIconView@ widget.
iconViewNewWithModel model = liftIO $ do
    model' <- unsafeManagedPtrCastPtr model
    result <- gtk_icon_view_new_with_model model'
    checkUnexpectedReturnNULL "iconViewNewWithModel" result
    result' <- (newObject IconView) result
    touchManagedPtr model
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method IconView::create_drag_icon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreePath` in @icon_view"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Paintable" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_create_drag_icon" gtk_icon_view_create_drag_icon :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gtk.TreePath.TreePath ->            -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    IO (Ptr Gdk.Paintable.Paintable)

{-# DEPRECATED iconViewCreateDragIcon ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Creates a @GdkPaintable@ representation of the item at /@path@/.
-- This image is used for a drag icon.
iconViewCreateDragIcon ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: a @GtkTreePath@ in /@iconView@/
    -> m (Maybe Gdk.Paintable.Paintable)
    -- ^ __Returns:__ a newly-allocated @GdkPaintable@ of the drag icon.
iconViewCreateDragIcon iconView path = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path' <- unsafeManagedPtrGetPtr path
    result <- gtk_icon_view_create_drag_icon iconView' path'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gdk.Paintable.Paintable) result'
        return result''
    touchManagedPtr iconView
    touchManagedPtr path
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data IconViewCreateDragIconMethodInfo
instance (signature ~ (Gtk.TreePath.TreePath -> m (Maybe Gdk.Paintable.Paintable)), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewCreateDragIconMethodInfo a signature where
    overloadedMethod = iconViewCreateDragIcon

instance O.OverloadedMethodInfo IconViewCreateDragIconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewCreateDragIcon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewCreateDragIcon"
        })


#endif

-- method IconView::enable_model_drag_dest
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "formats"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ContentFormats" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the formats that the drag will support"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "actions"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the bitmask of possible actions for a drag to this\n   widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_enable_model_drag_dest" gtk_icon_view_enable_model_drag_dest :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gdk.ContentFormats.ContentFormats -> -- formats : TInterface (Name {namespace = "Gdk", name = "ContentFormats"})
    CUInt ->                                -- actions : TInterface (Name {namespace = "Gdk", name = "DragAction"})
    IO ()

{-# DEPRECATED iconViewEnableModelDragDest ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Turns /@iconView@/ into a drop destination for automatic DND. Calling this
-- method sets @GtkIconView@:reorderable to 'P.False'.
iconViewEnableModelDragDest ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Gdk.ContentFormats.ContentFormats
    -- ^ /@formats@/: the formats that the drag will support
    -> [Gdk.Flags.DragAction]
    -- ^ /@actions@/: the bitmask of possible actions for a drag to this
    --    widget
    -> m ()
iconViewEnableModelDragDest iconView formats actions = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    formats' <- unsafeManagedPtrGetPtr formats
    let actions' = gflagsToWord actions
    gtk_icon_view_enable_model_drag_dest iconView' formats' actions'
    touchManagedPtr iconView
    touchManagedPtr formats
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewEnableModelDragDestMethodInfo
instance (signature ~ (Gdk.ContentFormats.ContentFormats -> [Gdk.Flags.DragAction] -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewEnableModelDragDestMethodInfo a signature where
    overloadedMethod = iconViewEnableModelDragDest

instance O.OverloadedMethodInfo IconViewEnableModelDragDestMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewEnableModelDragDest",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewEnableModelDragDest"
        })


#endif

-- method IconView::enable_model_drag_source
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start_button_mask"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Mask of allowed buttons to start drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "formats"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ContentFormats" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the formats that the drag will support"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "actions"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the bitmask of possible actions for a drag from this\n   widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_enable_model_drag_source" gtk_icon_view_enable_model_drag_source :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    CUInt ->                                -- start_button_mask : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    Ptr Gdk.ContentFormats.ContentFormats -> -- formats : TInterface (Name {namespace = "Gdk", name = "ContentFormats"})
    CUInt ->                                -- actions : TInterface (Name {namespace = "Gdk", name = "DragAction"})
    IO ()

{-# DEPRECATED iconViewEnableModelDragSource ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Turns /@iconView@/ into a drag source for automatic DND. Calling this
-- method sets @GtkIconView@:reorderable to 'P.False'.
iconViewEnableModelDragSource ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> [Gdk.Flags.ModifierType]
    -- ^ /@startButtonMask@/: Mask of allowed buttons to start drag
    -> Gdk.ContentFormats.ContentFormats
    -- ^ /@formats@/: the formats that the drag will support
    -> [Gdk.Flags.DragAction]
    -- ^ /@actions@/: the bitmask of possible actions for a drag from this
    --    widget
    -> m ()
iconViewEnableModelDragSource iconView startButtonMask formats actions = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    let startButtonMask' = gflagsToWord startButtonMask
    formats' <- unsafeManagedPtrGetPtr formats
    let actions' = gflagsToWord actions
    gtk_icon_view_enable_model_drag_source iconView' startButtonMask' formats' actions'
    touchManagedPtr iconView
    touchManagedPtr formats
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewEnableModelDragSourceMethodInfo
instance (signature ~ ([Gdk.Flags.ModifierType] -> Gdk.ContentFormats.ContentFormats -> [Gdk.Flags.DragAction] -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewEnableModelDragSourceMethodInfo a signature where
    overloadedMethod = iconViewEnableModelDragSource

instance O.OverloadedMethodInfo IconViewEnableModelDragSourceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewEnableModelDragSource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewEnableModelDragSource"
        })


#endif

-- method IconView::get_activate_on_single_click
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_activate_on_single_click" gtk_icon_view_get_activate_on_single_click :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO CInt

{-# DEPRECATED iconViewGetActivateOnSingleClick ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Gets the setting set by 'GI.Gtk.Objects.IconView.iconViewSetActivateOnSingleClick'.
iconViewGetActivateOnSingleClick ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if item-activated will be emitted on a single click
iconViewGetActivateOnSingleClick iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_activate_on_single_click iconView'
    let result' = (/= 0) result
    touchManagedPtr iconView
    return result'

#if defined(ENABLE_OVERLOADING)
data IconViewGetActivateOnSingleClickMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetActivateOnSingleClickMethodInfo a signature where
    overloadedMethod = iconViewGetActivateOnSingleClick

instance O.OverloadedMethodInfo IconViewGetActivateOnSingleClickMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetActivateOnSingleClick",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetActivateOnSingleClick"
        })


#endif

-- method IconView::get_cell_rect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreePath`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cell"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CellRenderer" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCellRenderer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rect"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle to fill with cell rect"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_cell_rect" gtk_icon_view_get_cell_rect :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gtk.TreePath.TreePath ->            -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    Ptr Gtk.CellRenderer.CellRenderer ->    -- cell : TInterface (Name {namespace = "Gtk", name = "CellRenderer"})
    Ptr Gdk.Rectangle.Rectangle ->          -- rect : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO CInt

{-# DEPRECATED iconViewGetCellRect ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Fills the bounding rectangle in widget coordinates for the cell specified by
-- /@path@/ and /@cell@/. If /@cell@/ is 'P.Nothing' the main cell area is used.
-- 
-- This function is only valid if /@iconView@/ is realized.
iconViewGetCellRect ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a, Gtk.CellRenderer.IsCellRenderer b) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: a @GtkTreePath@
    -> Maybe (b)
    -- ^ /@cell@/: a @GtkCellRenderer@
    -> m ((Bool, Gdk.Rectangle.Rectangle))
    -- ^ __Returns:__ 'P.False' if there is no such item, 'P.True' otherwise
iconViewGetCellRect iconView path cell = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path' <- unsafeManagedPtrGetPtr path
    maybeCell <- case cell of
        Nothing -> return FP.nullPtr
        Just jCell -> do
            jCell' <- unsafeManagedPtrCastPtr jCell
            return jCell'
    rect <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle.Rectangle)
    result <- gtk_icon_view_get_cell_rect iconView' path' maybeCell rect
    let result' = (/= 0) result
    rect' <- (wrapBoxed Gdk.Rectangle.Rectangle) rect
    touchManagedPtr iconView
    touchManagedPtr path
    whenJust cell touchManagedPtr
    return (result', rect')

#if defined(ENABLE_OVERLOADING)
data IconViewGetCellRectMethodInfo
instance (signature ~ (Gtk.TreePath.TreePath -> Maybe (b) -> m ((Bool, Gdk.Rectangle.Rectangle))), MonadIO m, IsIconView a, Gtk.CellRenderer.IsCellRenderer b) => O.OverloadedMethod IconViewGetCellRectMethodInfo a signature where
    overloadedMethod = iconViewGetCellRect

instance O.OverloadedMethodInfo IconViewGetCellRectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetCellRect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetCellRect"
        })


#endif

-- method IconView::get_column_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_column_spacing" gtk_icon_view_get_column_spacing :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO Int32

{-# DEPRECATED iconViewGetColumnSpacing ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Returns the value of the [columnSpacing](#g:signal:columnSpacing) property.
iconViewGetColumnSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m Int32
    -- ^ __Returns:__ the space between columns
iconViewGetColumnSpacing iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_column_spacing iconView'
    touchManagedPtr iconView
    return result

#if defined(ENABLE_OVERLOADING)
data IconViewGetColumnSpacingMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetColumnSpacingMethodInfo a signature where
    overloadedMethod = iconViewGetColumnSpacing

instance O.OverloadedMethodInfo IconViewGetColumnSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetColumnSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetColumnSpacing"
        })


#endif

-- method IconView::get_columns
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_columns" gtk_icon_view_get_columns :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO Int32

{-# DEPRECATED iconViewGetColumns ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Returns the value of the [columns](#g:signal:columns) property.
iconViewGetColumns ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m Int32
    -- ^ __Returns:__ the number of columns, or -1
iconViewGetColumns iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_columns iconView'
    touchManagedPtr iconView
    return result

#if defined(ENABLE_OVERLOADING)
data IconViewGetColumnsMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetColumnsMethodInfo a signature where
    overloadedMethod = iconViewGetColumns

instance O.OverloadedMethodInfo IconViewGetColumnsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetColumns",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetColumns"
        })


#endif

-- method IconView::get_cursor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Return location for the current\n  cursor path"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "cell"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CellRenderer" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return location the current\n  focus cell"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_cursor" gtk_icon_view_get_cursor :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr (Ptr Gtk.TreePath.TreePath) ->      -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    Ptr (Ptr Gtk.CellRenderer.CellRenderer) -> -- cell : TInterface (Name {namespace = "Gtk", name = "CellRenderer"})
    IO CInt

{-# DEPRECATED iconViewGetCursor ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Fills in /@path@/ and /@cell@/ with the current cursor path and cell.
-- If the cursor isn’t currently set, then */@path@/ will be 'P.Nothing'.
-- If no cell currently has focus, then */@cell@/ will be 'P.Nothing'.
-- 
-- The returned @GtkTreePath@ must be freed with 'GI.Gtk.Structs.TreePath.treePathFree'.
iconViewGetCursor ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@
    -> m ((Bool, Gtk.TreePath.TreePath, Gtk.CellRenderer.CellRenderer))
    -- ^ __Returns:__ 'P.True' if the cursor is set.
iconViewGetCursor iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path <- callocMem :: IO (Ptr (Ptr Gtk.TreePath.TreePath))
    cell <- callocMem :: IO (Ptr (Ptr Gtk.CellRenderer.CellRenderer))
    result <- gtk_icon_view_get_cursor iconView' path cell
    let result' = (/= 0) result
    path' <- peek path
    path'' <- (wrapBoxed Gtk.TreePath.TreePath) path'
    cell' <- peek cell
    cell'' <- (newObject Gtk.CellRenderer.CellRenderer) cell'
    touchManagedPtr iconView
    freeMem path
    freeMem cell
    return (result', path'', cell'')

#if defined(ENABLE_OVERLOADING)
data IconViewGetCursorMethodInfo
instance (signature ~ (m ((Bool, Gtk.TreePath.TreePath, Gtk.CellRenderer.CellRenderer))), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetCursorMethodInfo a signature where
    overloadedMethod = iconViewGetCursor

instance O.OverloadedMethodInfo IconViewGetCursorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetCursor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetCursor"
        })


#endif

-- method IconView::get_dest_item_at_pos
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "drag_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the position to determine the destination item for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "drag_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the position to determine the destination item for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return location for the path of the item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "pos"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "IconViewDropPosition" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return location for the drop position"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_dest_item_at_pos" gtk_icon_view_get_dest_item_at_pos :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- drag_x : TBasicType TInt
    Int32 ->                                -- drag_y : TBasicType TInt
    Ptr (Ptr Gtk.TreePath.TreePath) ->      -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    Ptr CUInt ->                            -- pos : TInterface (Name {namespace = "Gtk", name = "IconViewDropPosition"})
    IO CInt

{-# DEPRECATED iconViewGetDestItemAtPos ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Determines the destination item for a given position.
iconViewGetDestItemAtPos ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Int32
    -- ^ /@dragX@/: the position to determine the destination item for
    -> Int32
    -- ^ /@dragY@/: the position to determine the destination item for
    -> m ((Bool, Gtk.TreePath.TreePath, Gtk.Enums.IconViewDropPosition))
    -- ^ __Returns:__ whether there is an item at the given position.
iconViewGetDestItemAtPos iconView dragX dragY = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path <- callocMem :: IO (Ptr (Ptr Gtk.TreePath.TreePath))
    pos <- allocMem :: IO (Ptr CUInt)
    result <- gtk_icon_view_get_dest_item_at_pos iconView' dragX dragY path pos
    let result' = (/= 0) result
    path' <- peek path
    path'' <- (wrapBoxed Gtk.TreePath.TreePath) path'
    pos' <- peek pos
    let pos'' = (toEnum . fromIntegral) pos'
    touchManagedPtr iconView
    freeMem path
    freeMem pos
    return (result', path'', pos'')

#if defined(ENABLE_OVERLOADING)
data IconViewGetDestItemAtPosMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ((Bool, Gtk.TreePath.TreePath, Gtk.Enums.IconViewDropPosition))), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetDestItemAtPosMethodInfo a signature where
    overloadedMethod = iconViewGetDestItemAtPos

instance O.OverloadedMethodInfo IconViewGetDestItemAtPosMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetDestItemAtPos",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetDestItemAtPos"
        })


#endif

-- method IconView::get_drag_dest_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Return location for the path of\n  the highlighted item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "pos"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "IconViewDropPosition" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return location for the drop position"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_drag_dest_item" gtk_icon_view_get_drag_dest_item :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr (Ptr Gtk.TreePath.TreePath) ->      -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    Ptr CUInt ->                            -- pos : TInterface (Name {namespace = "Gtk", name = "IconViewDropPosition"})
    IO ()

{-# DEPRECATED iconViewGetDragDestItem ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Gets information about the item that is highlighted for feedback.
iconViewGetDragDestItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m ((Maybe Gtk.TreePath.TreePath, Gtk.Enums.IconViewDropPosition))
iconViewGetDragDestItem iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path <- callocMem :: IO (Ptr (Ptr Gtk.TreePath.TreePath))
    pos <- allocMem :: IO (Ptr CUInt)
    gtk_icon_view_get_drag_dest_item iconView' path pos
    path' <- peek path
    maybePath' <- convertIfNonNull path' $ \path'' -> do
        path''' <- (wrapBoxed Gtk.TreePath.TreePath) path''
        return path'''
    pos' <- peek pos
    let pos'' = (toEnum . fromIntegral) pos'
    touchManagedPtr iconView
    freeMem path
    freeMem pos
    return (maybePath', pos'')

#if defined(ENABLE_OVERLOADING)
data IconViewGetDragDestItemMethodInfo
instance (signature ~ (m ((Maybe Gtk.TreePath.TreePath, Gtk.Enums.IconViewDropPosition))), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetDragDestItemMethodInfo a signature where
    overloadedMethod = iconViewGetDragDestItem

instance O.OverloadedMethodInfo IconViewGetDragDestItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetDragDestItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetDragDestItem"
        })


#endif

-- method IconView::get_item_at_pos
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The x position to be identified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The y position to be identified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return location for the path"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "cell"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CellRenderer" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Return location for the renderer\n  responsible for the cell at (@x, @y)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_item_at_pos" gtk_icon_view_get_item_at_pos :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    Ptr (Ptr Gtk.TreePath.TreePath) ->      -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    Ptr (Ptr Gtk.CellRenderer.CellRenderer) -> -- cell : TInterface (Name {namespace = "Gtk", name = "CellRenderer"})
    IO CInt

{-# DEPRECATED iconViewGetItemAtPos ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Gets the path and cell for the icon at the given position.
iconViewGetItemAtPos ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> Int32
    -- ^ /@x@/: The x position to be identified
    -> Int32
    -- ^ /@y@/: The y position to be identified
    -> m ((Bool, Gtk.TreePath.TreePath, Gtk.CellRenderer.CellRenderer))
    -- ^ __Returns:__ 'P.True' if an item exists at the specified position
iconViewGetItemAtPos iconView x y = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path <- callocMem :: IO (Ptr (Ptr Gtk.TreePath.TreePath))
    cell <- callocMem :: IO (Ptr (Ptr Gtk.CellRenderer.CellRenderer))
    result <- gtk_icon_view_get_item_at_pos iconView' x y path cell
    let result' = (/= 0) result
    path' <- peek path
    path'' <- (wrapBoxed Gtk.TreePath.TreePath) path'
    cell' <- peek cell
    cell'' <- (newObject Gtk.CellRenderer.CellRenderer) cell'
    touchManagedPtr iconView
    freeMem path
    freeMem cell
    return (result', path'', cell'')

#if defined(ENABLE_OVERLOADING)
data IconViewGetItemAtPosMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ((Bool, Gtk.TreePath.TreePath, Gtk.CellRenderer.CellRenderer))), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetItemAtPosMethodInfo a signature where
    overloadedMethod = iconViewGetItemAtPos

instance O.OverloadedMethodInfo IconViewGetItemAtPosMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetItemAtPos",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetItemAtPos"
        })


#endif

-- method IconView::get_item_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkTreePath` of the item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_item_column" gtk_icon_view_get_item_column :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gtk.TreePath.TreePath ->            -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    IO Int32

{-# DEPRECATED iconViewGetItemColumn ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Gets the column in which the item /@path@/ is currently
-- displayed. Column numbers start at 0.
iconViewGetItemColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: the @GtkTreePath@ of the item
    -> m Int32
    -- ^ __Returns:__ The column in which the item is displayed
iconViewGetItemColumn iconView path = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path' <- unsafeManagedPtrGetPtr path
    result <- gtk_icon_view_get_item_column iconView' path'
    touchManagedPtr iconView
    touchManagedPtr path
    return result

#if defined(ENABLE_OVERLOADING)
data IconViewGetItemColumnMethodInfo
instance (signature ~ (Gtk.TreePath.TreePath -> m Int32), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetItemColumnMethodInfo a signature where
    overloadedMethod = iconViewGetItemColumn

instance O.OverloadedMethodInfo IconViewGetItemColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetItemColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetItemColumn"
        })


#endif

-- method IconView::get_item_orientation
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Orientation" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_item_orientation" gtk_icon_view_get_item_orientation :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO CUInt

{-# DEPRECATED iconViewGetItemOrientation ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Returns the value of the [itemOrientation](#g:signal:itemOrientation) property which determines
-- whether the labels are drawn beside the icons instead of below.
iconViewGetItemOrientation ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m Gtk.Enums.Orientation
    -- ^ __Returns:__ the relative position of texts and icons
iconViewGetItemOrientation iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_item_orientation iconView'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr iconView
    return result'

#if defined(ENABLE_OVERLOADING)
data IconViewGetItemOrientationMethodInfo
instance (signature ~ (m Gtk.Enums.Orientation), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetItemOrientationMethodInfo a signature where
    overloadedMethod = iconViewGetItemOrientation

instance O.OverloadedMethodInfo IconViewGetItemOrientationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetItemOrientation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetItemOrientation"
        })


#endif

-- method IconView::get_item_padding
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_item_padding" gtk_icon_view_get_item_padding :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO Int32

{-# DEPRECATED iconViewGetItemPadding ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Returns the value of the [itemPadding](#g:signal:itemPadding) property.
iconViewGetItemPadding ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m Int32
    -- ^ __Returns:__ the padding around items
iconViewGetItemPadding iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_item_padding iconView'
    touchManagedPtr iconView
    return result

#if defined(ENABLE_OVERLOADING)
data IconViewGetItemPaddingMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetItemPaddingMethodInfo a signature where
    overloadedMethod = iconViewGetItemPadding

instance O.OverloadedMethodInfo IconViewGetItemPaddingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetItemPadding",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetItemPadding"
        })


#endif

-- method IconView::get_item_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkTreePath` of the item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_item_row" gtk_icon_view_get_item_row :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gtk.TreePath.TreePath ->            -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    IO Int32

{-# DEPRECATED iconViewGetItemRow ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Gets the row in which the item /@path@/ is currently
-- displayed. Row numbers start at 0.
iconViewGetItemRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: the @GtkTreePath@ of the item
    -> m Int32
    -- ^ __Returns:__ The row in which the item is displayed
iconViewGetItemRow iconView path = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path' <- unsafeManagedPtrGetPtr path
    result <- gtk_icon_view_get_item_row iconView' path'
    touchManagedPtr iconView
    touchManagedPtr path
    return result

#if defined(ENABLE_OVERLOADING)
data IconViewGetItemRowMethodInfo
instance (signature ~ (Gtk.TreePath.TreePath -> m Int32), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetItemRowMethodInfo a signature where
    overloadedMethod = iconViewGetItemRow

instance O.OverloadedMethodInfo IconViewGetItemRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetItemRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetItemRow"
        })


#endif

-- method IconView::get_item_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_item_width" gtk_icon_view_get_item_width :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO Int32

{-# DEPRECATED iconViewGetItemWidth ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Returns the value of the [itemWidth](#g:signal:itemWidth) property.
iconViewGetItemWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m Int32
    -- ^ __Returns:__ the width of a single item, or -1
iconViewGetItemWidth iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_item_width iconView'
    touchManagedPtr iconView
    return result

#if defined(ENABLE_OVERLOADING)
data IconViewGetItemWidthMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetItemWidthMethodInfo a signature where
    overloadedMethod = iconViewGetItemWidth

instance O.OverloadedMethodInfo IconViewGetItemWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetItemWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetItemWidth"
        })


#endif

-- method IconView::get_margin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_margin" gtk_icon_view_get_margin :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO Int32

{-# DEPRECATED iconViewGetMargin ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Returns the value of the [margin](#g:signal:margin) property.
iconViewGetMargin ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m Int32
    -- ^ __Returns:__ the space at the borders
iconViewGetMargin iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_margin iconView'
    touchManagedPtr iconView
    return result

#if defined(ENABLE_OVERLOADING)
data IconViewGetMarginMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetMarginMethodInfo a signature where
    overloadedMethod = iconViewGetMargin

instance O.OverloadedMethodInfo IconViewGetMarginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetMargin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetMargin"
        })


#endif

-- method IconView::get_markup_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_markup_column" gtk_icon_view_get_markup_column :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO Int32

{-# DEPRECATED iconViewGetMarkupColumn ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Returns the column with markup text for /@iconView@/.
iconViewGetMarkupColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> m Int32
    -- ^ __Returns:__ the markup column, or -1 if it’s unset.
iconViewGetMarkupColumn iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_markup_column iconView'
    touchManagedPtr iconView
    return result

#if defined(ENABLE_OVERLOADING)
data IconViewGetMarkupColumnMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetMarkupColumnMethodInfo a signature where
    overloadedMethod = iconViewGetMarkupColumn

instance O.OverloadedMethodInfo IconViewGetMarkupColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetMarkupColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetMarkupColumn"
        })


#endif

-- method IconView::get_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "TreeModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_model" gtk_icon_view_get_model :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO (Ptr Gtk.TreeModel.TreeModel)

{-# DEPRECATED iconViewGetModel ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Returns the model the @GtkIconView@ is based on.  Returns 'P.Nothing' if the
-- model is unset.
iconViewGetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m (Maybe Gtk.TreeModel.TreeModel)
    -- ^ __Returns:__ The currently used @GtkTreeModel@
iconViewGetModel iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_model iconView'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.TreeModel.TreeModel) result'
        return result''
    touchManagedPtr iconView
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data IconViewGetModelMethodInfo
instance (signature ~ (m (Maybe Gtk.TreeModel.TreeModel)), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetModelMethodInfo a signature where
    overloadedMethod = iconViewGetModel

instance O.OverloadedMethodInfo IconViewGetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetModel"
        })


#endif

-- method IconView::get_path_at_pos
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The x position to be identified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The y position to be identified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "TreePath" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_path_at_pos" gtk_icon_view_get_path_at_pos :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    IO (Ptr Gtk.TreePath.TreePath)

{-# DEPRECATED iconViewGetPathAtPos ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Gets the path for the icon at the given position.
iconViewGetPathAtPos ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> Int32
    -- ^ /@x@/: The x position to be identified
    -> Int32
    -- ^ /@y@/: The y position to be identified
    -> m (Maybe Gtk.TreePath.TreePath)
    -- ^ __Returns:__ The @GtkTreePath@ corresponding
    -- to the icon or 'P.Nothing' if no icon exists at that position.
iconViewGetPathAtPos iconView x y = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_path_at_pos iconView' x y
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Gtk.TreePath.TreePath) result'
        return result''
    touchManagedPtr iconView
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data IconViewGetPathAtPosMethodInfo
instance (signature ~ (Int32 -> Int32 -> m (Maybe Gtk.TreePath.TreePath)), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetPathAtPosMethodInfo a signature where
    overloadedMethod = iconViewGetPathAtPos

instance O.OverloadedMethodInfo IconViewGetPathAtPosMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetPathAtPos",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetPathAtPos"
        })


#endif

-- method IconView::get_pixbuf_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_pixbuf_column" gtk_icon_view_get_pixbuf_column :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO Int32

{-# DEPRECATED iconViewGetPixbufColumn ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Returns the column with pixbufs for /@iconView@/.
iconViewGetPixbufColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> m Int32
    -- ^ __Returns:__ the pixbuf column, or -1 if it’s unset.
iconViewGetPixbufColumn iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_pixbuf_column iconView'
    touchManagedPtr iconView
    return result

#if defined(ENABLE_OVERLOADING)
data IconViewGetPixbufColumnMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetPixbufColumnMethodInfo a signature where
    overloadedMethod = iconViewGetPixbufColumn

instance O.OverloadedMethodInfo IconViewGetPixbufColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetPixbufColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetPixbufColumn"
        })


#endif

-- method IconView::get_reorderable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_reorderable" gtk_icon_view_get_reorderable :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO CInt

{-# DEPRECATED iconViewGetReorderable ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Retrieves whether the user can reorder the list via drag-and-drop.
-- See 'GI.Gtk.Objects.IconView.iconViewSetReorderable'.
iconViewGetReorderable ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the list can be reordered.
iconViewGetReorderable iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_reorderable iconView'
    let result' = (/= 0) result
    touchManagedPtr iconView
    return result'

#if defined(ENABLE_OVERLOADING)
data IconViewGetReorderableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetReorderableMethodInfo a signature where
    overloadedMethod = iconViewGetReorderable

instance O.OverloadedMethodInfo IconViewGetReorderableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetReorderable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetReorderable"
        })


#endif

-- method IconView::get_row_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_row_spacing" gtk_icon_view_get_row_spacing :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO Int32

{-# DEPRECATED iconViewGetRowSpacing ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Returns the value of the [rowSpacing](#g:signal:rowSpacing) property.
iconViewGetRowSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m Int32
    -- ^ __Returns:__ the space between rows
iconViewGetRowSpacing iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_row_spacing iconView'
    touchManagedPtr iconView
    return result

#if defined(ENABLE_OVERLOADING)
data IconViewGetRowSpacingMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetRowSpacingMethodInfo a signature where
    overloadedMethod = iconViewGetRowSpacing

instance O.OverloadedMethodInfo IconViewGetRowSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetRowSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetRowSpacing"
        })


#endif

-- method IconView::get_selected_items
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList
--                  (TInterface Name { namespace = "Gtk" , name = "TreePath" }))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_selected_items" gtk_icon_view_get_selected_items :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO (Ptr (GList (Ptr Gtk.TreePath.TreePath)))

{-# DEPRECATED iconViewGetSelectedItems ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Creates a list of paths of all selected items. Additionally, if you are
-- planning on modifying the model after calling this function, you may
-- want to convert the returned list into a list of @GtkTreeRowReferences@.
-- To do this, you can use 'GI.Gtk.Structs.TreeRowReference.treeRowReferenceNew'.
-- 
-- To free the return value, use @g_list_free_full@:
-- 
-- 
-- === /c code/
-- >GtkWidget *icon_view = gtk_icon_view_new ();
-- >// Use icon_view
-- >
-- >GList *list = gtk_icon_view_get_selected_items (GTK_ICON_VIEW (icon_view));
-- >
-- >// use list
-- >
-- >g_list_free_full (list, (GDestroyNotify) gtk_tree_path_free);
iconViewGetSelectedItems ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> m [Gtk.TreePath.TreePath]
    -- ^ __Returns:__ A @GList@ containing a @GtkTreePath@ for each selected row.
iconViewGetSelectedItems iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_selected_items iconView'
    result' <- unpackGList result
    result'' <- mapM (wrapBoxed Gtk.TreePath.TreePath) result'
    g_list_free result
    touchManagedPtr iconView
    return result''

#if defined(ENABLE_OVERLOADING)
data IconViewGetSelectedItemsMethodInfo
instance (signature ~ (m [Gtk.TreePath.TreePath]), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetSelectedItemsMethodInfo a signature where
    overloadedMethod = iconViewGetSelectedItems

instance O.OverloadedMethodInfo IconViewGetSelectedItemsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetSelectedItems",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetSelectedItems"
        })


#endif

-- method IconView::get_selection_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SelectionMode" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_selection_mode" gtk_icon_view_get_selection_mode :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO CUInt

{-# DEPRECATED iconViewGetSelectionMode ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Gets the selection mode of the /@iconView@/.
iconViewGetSelectionMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> m Gtk.Enums.SelectionMode
    -- ^ __Returns:__ the current selection mode
iconViewGetSelectionMode iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_selection_mode iconView'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr iconView
    return result'

#if defined(ENABLE_OVERLOADING)
data IconViewGetSelectionModeMethodInfo
instance (signature ~ (m Gtk.Enums.SelectionMode), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetSelectionModeMethodInfo a signature where
    overloadedMethod = iconViewGetSelectionMode

instance O.OverloadedMethodInfo IconViewGetSelectionModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetSelectionMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetSelectionMode"
        })


#endif

-- method IconView::get_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_spacing" gtk_icon_view_get_spacing :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO Int32

{-# DEPRECATED iconViewGetSpacing ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Returns the value of the [spacing](#g:signal:spacing) property.
iconViewGetSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m Int32
    -- ^ __Returns:__ the space between cells
iconViewGetSpacing iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_spacing iconView'
    touchManagedPtr iconView
    return result

#if defined(ENABLE_OVERLOADING)
data IconViewGetSpacingMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetSpacingMethodInfo a signature where
    overloadedMethod = iconViewGetSpacing

instance O.OverloadedMethodInfo IconViewGetSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetSpacing"
        })


#endif

-- method IconView::get_text_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_text_column" gtk_icon_view_get_text_column :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO Int32

{-# DEPRECATED iconViewGetTextColumn ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Returns the column with text for /@iconView@/.
iconViewGetTextColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> m Int32
    -- ^ __Returns:__ the text column, or -1 if it’s unset.
iconViewGetTextColumn iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_text_column iconView'
    touchManagedPtr iconView
    return result

#if defined(ENABLE_OVERLOADING)
data IconViewGetTextColumnMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetTextColumnMethodInfo a signature where
    overloadedMethod = iconViewGetTextColumn

instance O.OverloadedMethodInfo IconViewGetTextColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetTextColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetTextColumn"
        })


#endif

-- method IconView::get_tooltip_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_tooltip_column" gtk_icon_view_get_tooltip_column :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO Int32

{-# DEPRECATED iconViewGetTooltipColumn ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Returns the column of /@iconView@/’s model which is being used for
-- displaying tooltips on /@iconView@/’s rows.
iconViewGetTooltipColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m Int32
    -- ^ __Returns:__ the index of the tooltip column that is currently being
    -- used, or -1 if this is disabled.
iconViewGetTooltipColumn iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    result <- gtk_icon_view_get_tooltip_column iconView'
    touchManagedPtr iconView
    return result

#if defined(ENABLE_OVERLOADING)
data IconViewGetTooltipColumnMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetTooltipColumnMethodInfo a signature where
    overloadedMethod = iconViewGetTooltipColumn

instance O.OverloadedMethodInfo IconViewGetTooltipColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetTooltipColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetTooltipColumn"
        })


#endif

-- method IconView::get_tooltip_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the x coordinate (relative to widget coordinates)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the y coordinate (relative to widget coordinates)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keyboard_tip"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether this is a keyboard tooltip or not"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to receive a `GtkTreeModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to receive a `GtkTreePath`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to receive a `GtkTreeIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_tooltip_context" gtk_icon_view_get_tooltip_context :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    CInt ->                                 -- keyboard_tip : TBasicType TBoolean
    Ptr (Ptr Gtk.TreeModel.TreeModel) ->    -- model : TInterface (Name {namespace = "Gtk", name = "TreeModel"})
    Ptr (Ptr Gtk.TreePath.TreePath) ->      -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    Ptr Gtk.TreeIter.TreeIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TreeIter"})
    IO CInt

{-# DEPRECATED iconViewGetTooltipContext ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | This function is supposed to be used in a @GtkWidget::query-tooltip@
-- signal handler for @GtkIconView@. The /@x@/, /@y@/ and /@keyboardTip@/ values
-- which are received in the signal handler, should be passed to this
-- function without modification.
-- 
-- The return value indicates whether there is an icon view item at the given
-- coordinates ('P.True') or not ('P.False') for mouse tooltips. For keyboard
-- tooltips the item returned will be the cursor item. When 'P.True', then any of
-- /@model@/, /@path@/ and /@iter@/ which have been provided will be set to point to
-- that row and the corresponding model.
iconViewGetTooltipContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: an @GtkIconView@
    -> Int32
    -- ^ /@x@/: the x coordinate (relative to widget coordinates)
    -> Int32
    -- ^ /@y@/: the y coordinate (relative to widget coordinates)
    -> Bool
    -- ^ /@keyboardTip@/: whether this is a keyboard tooltip or not
    -> m ((Bool, Gtk.TreeModel.TreeModel, Gtk.TreePath.TreePath, Gtk.TreeIter.TreeIter))
    -- ^ __Returns:__ whether or not the given tooltip context points to an item
iconViewGetTooltipContext iconView x y keyboardTip = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    let keyboardTip' = (P.fromIntegral . P.fromEnum) keyboardTip
    model <- callocMem :: IO (Ptr (Ptr Gtk.TreeModel.TreeModel))
    path <- callocMem :: IO (Ptr (Ptr Gtk.TreePath.TreePath))
    iter <- SP.callocBoxedBytes 32 :: IO (Ptr Gtk.TreeIter.TreeIter)
    result <- gtk_icon_view_get_tooltip_context iconView' x y keyboardTip' model path iter
    let result' = (/= 0) result
    model' <- peek model
    model'' <- (newObject Gtk.TreeModel.TreeModel) model'
    path' <- peek path
    path'' <- (wrapBoxed Gtk.TreePath.TreePath) path'
    iter' <- (wrapBoxed Gtk.TreeIter.TreeIter) iter
    touchManagedPtr iconView
    freeMem model
    freeMem path
    return (result', model'', path'', iter')

#if defined(ENABLE_OVERLOADING)
data IconViewGetTooltipContextMethodInfo
instance (signature ~ (Int32 -> Int32 -> Bool -> m ((Bool, Gtk.TreeModel.TreeModel, Gtk.TreePath.TreePath, Gtk.TreeIter.TreeIter))), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetTooltipContextMethodInfo a signature where
    overloadedMethod = iconViewGetTooltipContext

instance O.OverloadedMethodInfo IconViewGetTooltipContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetTooltipContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetTooltipContext"
        })


#endif

-- method IconView::get_visible_range
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start_path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return location for start of region"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "end_path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return location for end of region"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_get_visible_range" gtk_icon_view_get_visible_range :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr (Ptr Gtk.TreePath.TreePath) ->      -- start_path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    Ptr (Ptr Gtk.TreePath.TreePath) ->      -- end_path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    IO CInt

{-# DEPRECATED iconViewGetVisibleRange ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets /@startPath@/ and /@endPath@/ to be the first and last visible path.
-- Note that there may be invisible paths in between.
-- 
-- Both paths should be freed with 'GI.Gtk.Structs.TreePath.treePathFree' after use.
iconViewGetVisibleRange ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@
    -> m ((Bool, Gtk.TreePath.TreePath, Gtk.TreePath.TreePath))
    -- ^ __Returns:__ 'P.True', if valid paths were placed in /@startPath@/ and /@endPath@/
iconViewGetVisibleRange iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    startPath <- callocMem :: IO (Ptr (Ptr Gtk.TreePath.TreePath))
    endPath <- callocMem :: IO (Ptr (Ptr Gtk.TreePath.TreePath))
    result <- gtk_icon_view_get_visible_range iconView' startPath endPath
    let result' = (/= 0) result
    startPath' <- peek startPath
    startPath'' <- (wrapBoxed Gtk.TreePath.TreePath) startPath'
    endPath' <- peek endPath
    endPath'' <- (wrapBoxed Gtk.TreePath.TreePath) endPath'
    touchManagedPtr iconView
    freeMem startPath
    freeMem endPath
    return (result', startPath'', endPath'')

#if defined(ENABLE_OVERLOADING)
data IconViewGetVisibleRangeMethodInfo
instance (signature ~ (m ((Bool, Gtk.TreePath.TreePath, Gtk.TreePath.TreePath))), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewGetVisibleRangeMethodInfo a signature where
    overloadedMethod = iconViewGetVisibleRange

instance O.OverloadedMethodInfo IconViewGetVisibleRangeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewGetVisibleRange",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewGetVisibleRange"
        })


#endif

-- method IconView::item_activated
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The `GtkTreePath` to be activated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_item_activated" gtk_icon_view_item_activated :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gtk.TreePath.TreePath ->            -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    IO ()

{-# DEPRECATED iconViewItemActivated ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Activates the item determined by /@path@/.
iconViewItemActivated ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The @GtkTreePath@ to be activated
    -> m ()
iconViewItemActivated iconView path = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path' <- unsafeManagedPtrGetPtr path
    gtk_icon_view_item_activated iconView' path'
    touchManagedPtr iconView
    touchManagedPtr path
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewItemActivatedMethodInfo
instance (signature ~ (Gtk.TreePath.TreePath -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewItemActivatedMethodInfo a signature where
    overloadedMethod = iconViewItemActivated

instance O.OverloadedMethodInfo IconViewItemActivatedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewItemActivated",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewItemActivated"
        })


#endif

-- method IconView::path_is_selected
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTreePath` to check selection on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_path_is_selected" gtk_icon_view_path_is_selected :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gtk.TreePath.TreePath ->            -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    IO CInt

{-# DEPRECATED iconViewPathIsSelected ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Returns 'P.True' if the icon pointed to by /@path@/ is currently
-- selected. If /@path@/ does not point to a valid location, 'P.False' is returned.
iconViewPathIsSelected ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: A @GtkTreePath@ to check selection on.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@path@/ is selected.
iconViewPathIsSelected iconView path = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path' <- unsafeManagedPtrGetPtr path
    result <- gtk_icon_view_path_is_selected iconView' path'
    let result' = (/= 0) result
    touchManagedPtr iconView
    touchManagedPtr path
    return result'

#if defined(ENABLE_OVERLOADING)
data IconViewPathIsSelectedMethodInfo
instance (signature ~ (Gtk.TreePath.TreePath -> m Bool), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewPathIsSelectedMethodInfo a signature where
    overloadedMethod = iconViewPathIsSelected

instance O.OverloadedMethodInfo IconViewPathIsSelectedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewPathIsSelected",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewPathIsSelected"
        })


#endif

-- method IconView::scroll_to_path
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The path of the item to move to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_align"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether to use alignment arguments, or %FALSE."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row_align"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The vertical alignment of the item specified by @path."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "col_align"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The horizontal alignment of the item specified by @path."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_scroll_to_path" gtk_icon_view_scroll_to_path :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gtk.TreePath.TreePath ->            -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    CInt ->                                 -- use_align : TBasicType TBoolean
    CFloat ->                               -- row_align : TBasicType TFloat
    CFloat ->                               -- col_align : TBasicType TFloat
    IO ()

{-# DEPRECATED iconViewScrollToPath ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Moves the alignments of /@iconView@/ to the position specified by /@path@/.
-- /@rowAlign@/ determines where the row is placed, and /@colAlign@/ determines
-- where /@column@/ is placed.  Both are expected to be between 0.0 and 1.0.
-- 0.0 means left\/top alignment, 1.0 means right\/bottom alignment, 0.5 means
-- center.
-- 
-- If /@useAlign@/ is 'P.False', then the alignment arguments are ignored, and the
-- tree does the minimum amount of work to scroll the item onto the screen.
-- This means that the item will be scrolled to the edge closest to its current
-- position.  If the item is currently visible on the screen, nothing is done.
-- 
-- This function only works if the model is set, and /@path@/ is a valid row on
-- the model. If the model changes before the /@iconView@/ is realized, the
-- centered path will be modified to reflect this change.
iconViewScrollToPath ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The path of the item to move to.
    -> Bool
    -- ^ /@useAlign@/: whether to use alignment arguments, or 'P.False'.
    -> Float
    -- ^ /@rowAlign@/: The vertical alignment of the item specified by /@path@/.
    -> Float
    -- ^ /@colAlign@/: The horizontal alignment of the item specified by /@path@/.
    -> m ()
iconViewScrollToPath iconView path useAlign rowAlign colAlign = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path' <- unsafeManagedPtrGetPtr path
    let useAlign' = (P.fromIntegral . P.fromEnum) useAlign
    let rowAlign' = realToFrac rowAlign
    let colAlign' = realToFrac colAlign
    gtk_icon_view_scroll_to_path iconView' path' useAlign' rowAlign' colAlign'
    touchManagedPtr iconView
    touchManagedPtr path
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewScrollToPathMethodInfo
instance (signature ~ (Gtk.TreePath.TreePath -> Bool -> Float -> Float -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewScrollToPathMethodInfo a signature where
    overloadedMethod = iconViewScrollToPath

instance O.OverloadedMethodInfo IconViewScrollToPathMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewScrollToPath",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewScrollToPath"
        })


#endif

-- method IconView::select_all
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_select_all" gtk_icon_view_select_all :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO ()

{-# DEPRECATED iconViewSelectAll ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Selects all the icons. /@iconView@/ must has its selection mode set
-- to 'GI.Gtk.Enums.SelectionModeMultiple'.
iconViewSelectAll ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> m ()
iconViewSelectAll iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_select_all iconView'
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSelectAllMethodInfo
instance (signature ~ (m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSelectAllMethodInfo a signature where
    overloadedMethod = iconViewSelectAll

instance O.OverloadedMethodInfo IconViewSelectAllMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSelectAll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSelectAll"
        })


#endif

-- method IconView::select_path
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The `GtkTreePath` to be selected."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_select_path" gtk_icon_view_select_path :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gtk.TreePath.TreePath ->            -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    IO ()

{-# DEPRECATED iconViewSelectPath ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Selects the row at /@path@/.
iconViewSelectPath ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The @GtkTreePath@ to be selected.
    -> m ()
iconViewSelectPath iconView path = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path' <- unsafeManagedPtrGetPtr path
    gtk_icon_view_select_path iconView' path'
    touchManagedPtr iconView
    touchManagedPtr path
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSelectPathMethodInfo
instance (signature ~ (Gtk.TreePath.TreePath -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSelectPathMethodInfo a signature where
    overloadedMethod = iconViewSelectPath

instance O.OverloadedMethodInfo IconViewSelectPathMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSelectPath",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSelectPath"
        })


#endif

-- method IconView::selected_foreach
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "IconViewForeachFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The function to call for each selected icon."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data to pass to the function."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_selected_foreach" gtk_icon_view_selected_foreach :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    FunPtr Gtk.Callbacks.C_IconViewForeachFunc -> -- func : TInterface (Name {namespace = "Gtk", name = "IconViewForeachFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

{-# DEPRECATED iconViewSelectedForeach ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Calls a function for each selected icon. Note that the model or
-- selection cannot be modified from within this function.
iconViewSelectedForeach ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> Gtk.Callbacks.IconViewForeachFunc
    -- ^ /@func@/: The function to call for each selected icon.
    -> m ()
iconViewSelectedForeach iconView func = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    func' <- Gtk.Callbacks.mk_IconViewForeachFunc (Gtk.Callbacks.wrap_IconViewForeachFunc Nothing (Gtk.Callbacks.drop_closures_IconViewForeachFunc func))
    let data_ = nullPtr
    gtk_icon_view_selected_foreach iconView' func' data_
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSelectedForeachMethodInfo
instance (signature ~ (Gtk.Callbacks.IconViewForeachFunc -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSelectedForeachMethodInfo a signature where
    overloadedMethod = iconViewSelectedForeach

instance O.OverloadedMethodInfo IconViewSelectedForeachMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSelectedForeach",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSelectedForeach"
        })


#endif

-- method IconView::set_activate_on_single_click
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "single"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE to emit item-activated on a single click"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_activate_on_single_click" gtk_icon_view_set_activate_on_single_click :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    CInt ->                                 -- single : TBasicType TBoolean
    IO ()

{-# DEPRECATED iconViewSetActivateOnSingleClick ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Causes the @GtkIconView@[itemActivated](#g:signal:itemActivated) signal to be emitted on
-- a single click instead of a double click.
iconViewSetActivateOnSingleClick ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Bool
    -- ^ /@single@/: 'P.True' to emit item-activated on a single click
    -> m ()
iconViewSetActivateOnSingleClick iconView single = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    let single' = (P.fromIntegral . P.fromEnum) single
    gtk_icon_view_set_activate_on_single_click iconView' single'
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetActivateOnSingleClickMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetActivateOnSingleClickMethodInfo a signature where
    overloadedMethod = iconViewSetActivateOnSingleClick

instance O.OverloadedMethodInfo IconViewSetActivateOnSingleClickMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetActivateOnSingleClick",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetActivateOnSingleClick"
        })


#endif

-- method IconView::set_column_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column_spacing"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the column spacing" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_column_spacing" gtk_icon_view_set_column_spacing :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- column_spacing : TBasicType TInt
    IO ()

{-# DEPRECATED iconViewSetColumnSpacing ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the [columnSpacing](#g:signal:columnSpacing) property which specifies the space
-- which is inserted between the columns of the icon view.
iconViewSetColumnSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Int32
    -- ^ /@columnSpacing@/: the column spacing
    -> m ()
iconViewSetColumnSpacing iconView columnSpacing = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_set_column_spacing iconView' columnSpacing
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetColumnSpacingMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetColumnSpacingMethodInfo a signature where
    overloadedMethod = iconViewSetColumnSpacing

instance O.OverloadedMethodInfo IconViewSetColumnSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetColumnSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetColumnSpacing"
        })


#endif

-- method IconView::set_columns
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "columns"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of columns"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_columns" gtk_icon_view_set_columns :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- columns : TBasicType TInt
    IO ()

{-# DEPRECATED iconViewSetColumns ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the [columns](#g:signal:columns) property which determines in how
-- many columns the icons are arranged. If /@columns@/ is
-- -1, the number of columns will be chosen automatically
-- to fill the available area.
iconViewSetColumns ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Int32
    -- ^ /@columns@/: the number of columns
    -> m ()
iconViewSetColumns iconView columns = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_set_columns iconView' columns
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetColumnsMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetColumnsMethodInfo a signature where
    overloadedMethod = iconViewSetColumns

instance O.OverloadedMethodInfo IconViewSetColumnsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetColumns",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetColumns"
        })


#endif

-- method IconView::set_cursor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTreePath`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cell"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CellRenderer" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "One of the cell renderers of @icon_view"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start_editing"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if the specified cell should start being edited."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_cursor" gtk_icon_view_set_cursor :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gtk.TreePath.TreePath ->            -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    Ptr Gtk.CellRenderer.CellRenderer ->    -- cell : TInterface (Name {namespace = "Gtk", name = "CellRenderer"})
    CInt ->                                 -- start_editing : TBasicType TBoolean
    IO ()

{-# DEPRECATED iconViewSetCursor ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the current keyboard focus to be at /@path@/, and selects it.  This is
-- useful when you want to focus the user’s attention on a particular item.
-- If /@cell@/ is not 'P.Nothing', then focus is given to the cell specified by
-- it. Additionally, if /@startEditing@/ is 'P.True', then editing should be
-- started in the specified cell.
-- 
-- This function is often followed by @gtk_widget_grab_focus
-- (icon_view)@ in order to give keyboard focus to the widget.
-- Please note that editing can only happen when the widget is realized.
iconViewSetCursor ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a, Gtk.CellRenderer.IsCellRenderer b) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: A @GtkTreePath@
    -> Maybe (b)
    -- ^ /@cell@/: One of the cell renderers of /@iconView@/
    -> Bool
    -- ^ /@startEditing@/: 'P.True' if the specified cell should start being edited.
    -> m ()
iconViewSetCursor iconView path cell startEditing = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path' <- unsafeManagedPtrGetPtr path
    maybeCell <- case cell of
        Nothing -> return FP.nullPtr
        Just jCell -> do
            jCell' <- unsafeManagedPtrCastPtr jCell
            return jCell'
    let startEditing' = (P.fromIntegral . P.fromEnum) startEditing
    gtk_icon_view_set_cursor iconView' path' maybeCell startEditing'
    touchManagedPtr iconView
    touchManagedPtr path
    whenJust cell touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetCursorMethodInfo
instance (signature ~ (Gtk.TreePath.TreePath -> Maybe (b) -> Bool -> m ()), MonadIO m, IsIconView a, Gtk.CellRenderer.IsCellRenderer b) => O.OverloadedMethod IconViewSetCursorMethodInfo a signature where
    overloadedMethod = iconViewSetCursor

instance O.OverloadedMethodInfo IconViewSetCursorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetCursor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetCursor"
        })


#endif

-- method IconView::set_drag_dest_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The path of the item to highlight"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pos"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "IconViewDropPosition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Specifies where to drop, relative to the item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_drag_dest_item" gtk_icon_view_set_drag_dest_item :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gtk.TreePath.TreePath ->            -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    CUInt ->                                -- pos : TInterface (Name {namespace = "Gtk", name = "IconViewDropPosition"})
    IO ()

{-# DEPRECATED iconViewSetDragDestItem ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the item that is highlighted for feedback.
iconViewSetDragDestItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Maybe (Gtk.TreePath.TreePath)
    -- ^ /@path@/: The path of the item to highlight
    -> Gtk.Enums.IconViewDropPosition
    -- ^ /@pos@/: Specifies where to drop, relative to the item
    -> m ()
iconViewSetDragDestItem iconView path pos = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    maybePath <- case path of
        Nothing -> return FP.nullPtr
        Just jPath -> do
            jPath' <- unsafeManagedPtrGetPtr jPath
            return jPath'
    let pos' = (fromIntegral . fromEnum) pos
    gtk_icon_view_set_drag_dest_item iconView' maybePath pos'
    touchManagedPtr iconView
    whenJust path touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetDragDestItemMethodInfo
instance (signature ~ (Maybe (Gtk.TreePath.TreePath) -> Gtk.Enums.IconViewDropPosition -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetDragDestItemMethodInfo a signature where
    overloadedMethod = iconViewSetDragDestItem

instance O.OverloadedMethodInfo IconViewSetDragDestItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetDragDestItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetDragDestItem"
        })


#endif

-- method IconView::set_item_orientation
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "orientation"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Orientation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the relative position of texts and icons"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_item_orientation" gtk_icon_view_set_item_orientation :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    CUInt ->                                -- orientation : TInterface (Name {namespace = "Gtk", name = "Orientation"})
    IO ()

{-# DEPRECATED iconViewSetItemOrientation ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the [itemOrientation](#g:signal:itemOrientation) property which determines whether the labels
-- are drawn beside the icons instead of below.
iconViewSetItemOrientation ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Gtk.Enums.Orientation
    -- ^ /@orientation@/: the relative position of texts and icons
    -> m ()
iconViewSetItemOrientation iconView orientation = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    let orientation' = (fromIntegral . fromEnum) orientation
    gtk_icon_view_set_item_orientation iconView' orientation'
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetItemOrientationMethodInfo
instance (signature ~ (Gtk.Enums.Orientation -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetItemOrientationMethodInfo a signature where
    overloadedMethod = iconViewSetItemOrientation

instance O.OverloadedMethodInfo IconViewSetItemOrientationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetItemOrientation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetItemOrientation"
        })


#endif

-- method IconView::set_item_padding
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "item_padding"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the item padding" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_item_padding" gtk_icon_view_set_item_padding :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- item_padding : TBasicType TInt
    IO ()

{-# DEPRECATED iconViewSetItemPadding ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the @GtkIconView@:item-padding property which specifies the padding
-- around each of the icon view’s items.
iconViewSetItemPadding ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Int32
    -- ^ /@itemPadding@/: the item padding
    -> m ()
iconViewSetItemPadding iconView itemPadding = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_set_item_padding iconView' itemPadding
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetItemPaddingMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetItemPaddingMethodInfo a signature where
    overloadedMethod = iconViewSetItemPadding

instance O.OverloadedMethodInfo IconViewSetItemPaddingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetItemPadding",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetItemPadding"
        })


#endif

-- method IconView::set_item_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "item_width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the width for each item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_item_width" gtk_icon_view_set_item_width :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- item_width : TBasicType TInt
    IO ()

{-# DEPRECATED iconViewSetItemWidth ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the [itemWidth](#g:signal:itemWidth) property which specifies the width
-- to use for each item. If it is set to -1, the icon view will
-- automatically determine a suitable item size.
iconViewSetItemWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Int32
    -- ^ /@itemWidth@/: the width for each item
    -> m ()
iconViewSetItemWidth iconView itemWidth = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_set_item_width iconView' itemWidth
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetItemWidthMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetItemWidthMethodInfo a signature where
    overloadedMethod = iconViewSetItemWidth

instance O.OverloadedMethodInfo IconViewSetItemWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetItemWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetItemWidth"
        })


#endif

-- method IconView::set_margin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "margin"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the margin" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_margin" gtk_icon_view_set_margin :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- margin : TBasicType TInt
    IO ()

{-# DEPRECATED iconViewSetMargin ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the [margin](#g:signal:margin) property which specifies the space
-- which is inserted at the top, bottom, left and right
-- of the icon view.
iconViewSetMargin ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Int32
    -- ^ /@margin@/: the margin
    -> m ()
iconViewSetMargin iconView margin = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_set_margin iconView' margin
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetMarginMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetMarginMethodInfo a signature where
    overloadedMethod = iconViewSetMargin

instance O.OverloadedMethodInfo IconViewSetMarginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetMargin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetMargin"
        })


#endif

-- method IconView::set_markup_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A column in the currently used model, or -1 to display no text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_markup_column" gtk_icon_view_set_markup_column :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- column : TBasicType TInt
    IO ()

{-# DEPRECATED iconViewSetMarkupColumn ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the column with markup information for /@iconView@/ to be
-- /@column@/. The markup column must be of type @G_TYPE_STRING@.
-- If the markup column is set to something, it overrides
-- the text column set by 'GI.Gtk.Objects.IconView.iconViewSetTextColumn'.
iconViewSetMarkupColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> Int32
    -- ^ /@column@/: A column in the currently used model, or -1 to display no text
    -> m ()
iconViewSetMarkupColumn iconView column = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_set_markup_column iconView' column
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetMarkupColumnMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetMarkupColumnMethodInfo a signature where
    overloadedMethod = iconViewSetMarkupColumn

instance O.OverloadedMethodInfo IconViewSetMarkupColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetMarkupColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetMarkupColumn"
        })


#endif

-- method IconView::set_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The model." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_model" gtk_icon_view_set_model :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gtk.TreeModel.TreeModel ->          -- model : TInterface (Name {namespace = "Gtk", name = "TreeModel"})
    IO ()

{-# DEPRECATED iconViewSetModel ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the model for a @GtkIconView@.
-- If the /@iconView@/ already has a model set, it will remove
-- it before setting the new model.  If /@model@/ is 'P.Nothing', then
-- it will unset the old model.
iconViewSetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a, Gtk.TreeModel.IsTreeModel b) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> Maybe (b)
    -- ^ /@model@/: The model.
    -> m ()
iconViewSetModel iconView model = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_icon_view_set_model iconView' maybeModel
    touchManagedPtr iconView
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetModelMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsIconView a, Gtk.TreeModel.IsTreeModel b) => O.OverloadedMethod IconViewSetModelMethodInfo a signature where
    overloadedMethod = iconViewSetModel

instance O.OverloadedMethodInfo IconViewSetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetModel"
        })


#endif

-- method IconView::set_pixbuf_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "A column in the currently used model, or -1 to disable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_pixbuf_column" gtk_icon_view_set_pixbuf_column :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- column : TBasicType TInt
    IO ()

{-# DEPRECATED iconViewSetPixbufColumn ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the column with pixbufs for /@iconView@/ to be /@column@/. The pixbuf
-- column must be of type @GDK_TYPE_PIXBUF@
iconViewSetPixbufColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> Int32
    -- ^ /@column@/: A column in the currently used model, or -1 to disable
    -> m ()
iconViewSetPixbufColumn iconView column = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_set_pixbuf_column iconView' column
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetPixbufColumnMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetPixbufColumnMethodInfo a signature where
    overloadedMethod = iconViewSetPixbufColumn

instance O.OverloadedMethodInfo IconViewSetPixbufColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetPixbufColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetPixbufColumn"
        })


#endif

-- method IconView::set_reorderable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "reorderable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE, if the list of items can be reordered."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_reorderable" gtk_icon_view_set_reorderable :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    CInt ->                                 -- reorderable : TBasicType TBoolean
    IO ()

{-# DEPRECATED iconViewSetReorderable ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | This function is a convenience function to allow you to reorder models that
-- support the @GtkTreeDragSourceIface@ and the @GtkTreeDragDestIface@. Both
-- @GtkTreeStore@ and @GtkListStore@ support these. If /@reorderable@/ is 'P.True', then
-- the user can reorder the model by dragging and dropping rows.  The
-- developer can listen to these changes by connecting to the model\'s
-- row_inserted and row_deleted signals. The reordering is implemented by setting up
-- the icon view as a drag source and destination. Therefore, drag and
-- drop can not be used in a reorderable view for any other purpose.
-- 
-- This function does not give you any degree of control over the order -- any
-- reordering is allowed.  If more control is needed, you should probably
-- handle drag and drop manually.
iconViewSetReorderable ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> Bool
    -- ^ /@reorderable@/: 'P.True', if the list of items can be reordered.
    -> m ()
iconViewSetReorderable iconView reorderable = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    let reorderable' = (P.fromIntegral . P.fromEnum) reorderable
    gtk_icon_view_set_reorderable iconView' reorderable'
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetReorderableMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetReorderableMethodInfo a signature where
    overloadedMethod = iconViewSetReorderable

instance O.OverloadedMethodInfo IconViewSetReorderableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetReorderable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetReorderable"
        })


#endif

-- method IconView::set_row_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row_spacing"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the row spacing" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_row_spacing" gtk_icon_view_set_row_spacing :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- row_spacing : TBasicType TInt
    IO ()

{-# DEPRECATED iconViewSetRowSpacing ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the [rowSpacing](#g:signal:rowSpacing) property which specifies the space
-- which is inserted between the rows of the icon view.
iconViewSetRowSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Int32
    -- ^ /@rowSpacing@/: the row spacing
    -> m ()
iconViewSetRowSpacing iconView rowSpacing = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_set_row_spacing iconView' rowSpacing
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetRowSpacingMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetRowSpacingMethodInfo a signature where
    overloadedMethod = iconViewSetRowSpacing

instance O.OverloadedMethodInfo IconViewSetRowSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetRowSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetRowSpacing"
        })


#endif

-- method IconView::set_selection_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SelectionMode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The selection mode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_selection_mode" gtk_icon_view_set_selection_mode :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    CUInt ->                                -- mode : TInterface (Name {namespace = "Gtk", name = "SelectionMode"})
    IO ()

{-# DEPRECATED iconViewSetSelectionMode ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the selection mode of the /@iconView@/.
iconViewSetSelectionMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> Gtk.Enums.SelectionMode
    -- ^ /@mode@/: The selection mode
    -> m ()
iconViewSetSelectionMode iconView mode = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    let mode' = (fromIntegral . fromEnum) mode
    gtk_icon_view_set_selection_mode iconView' mode'
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetSelectionModeMethodInfo
instance (signature ~ (Gtk.Enums.SelectionMode -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetSelectionModeMethodInfo a signature where
    overloadedMethod = iconViewSetSelectionMode

instance O.OverloadedMethodInfo IconViewSetSelectionModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetSelectionMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetSelectionMode"
        })


#endif

-- method IconView::set_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "spacing"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the spacing" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_spacing" gtk_icon_view_set_spacing :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- spacing : TBasicType TInt
    IO ()

{-# DEPRECATED iconViewSetSpacing ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the [spacing](#g:signal:spacing) property which specifies the space
-- which is inserted between the cells (i.e. the icon and
-- the text) of an item.
iconViewSetSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Int32
    -- ^ /@spacing@/: the spacing
    -> m ()
iconViewSetSpacing iconView spacing = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_set_spacing iconView' spacing
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetSpacingMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetSpacingMethodInfo a signature where
    overloadedMethod = iconViewSetSpacing

instance O.OverloadedMethodInfo IconViewSetSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetSpacing"
        })


#endif

-- method IconView::set_text_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A column in the currently used model, or -1 to display no text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_text_column" gtk_icon_view_set_text_column :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- column : TBasicType TInt
    IO ()

{-# DEPRECATED iconViewSetTextColumn ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the column with text for /@iconView@/ to be /@column@/. The text
-- column must be of type @G_TYPE_STRING@.
iconViewSetTextColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> Int32
    -- ^ /@column@/: A column in the currently used model, or -1 to display no text
    -> m ()
iconViewSetTextColumn iconView column = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_set_text_column iconView' column
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetTextColumnMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetTextColumnMethodInfo a signature where
    overloadedMethod = iconViewSetTextColumn

instance O.OverloadedMethodInfo IconViewSetTextColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetTextColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetTextColumn"
        })


#endif

-- method IconView::set_tooltip_cell
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tooltip"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Tooltip" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTooltip`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreePath`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cell"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CellRenderer" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCellRenderer`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_tooltip_cell" gtk_icon_view_set_tooltip_cell :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gtk.Tooltip.Tooltip ->              -- tooltip : TInterface (Name {namespace = "Gtk", name = "Tooltip"})
    Ptr Gtk.TreePath.TreePath ->            -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    Ptr Gtk.CellRenderer.CellRenderer ->    -- cell : TInterface (Name {namespace = "Gtk", name = "CellRenderer"})
    IO ()

{-# DEPRECATED iconViewSetTooltipCell ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the tip area of /@tooltip@/ to the area which /@cell@/ occupies in
-- the item pointed to by /@path@/. See also 'GI.Gtk.Objects.Tooltip.tooltipSetTipArea'.
-- 
-- See also 'GI.Gtk.Objects.IconView.iconViewSetTooltipColumn' for a simpler alternative.
iconViewSetTooltipCell ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a, Gtk.Tooltip.IsTooltip b, Gtk.CellRenderer.IsCellRenderer c) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> b
    -- ^ /@tooltip@/: a @GtkTooltip@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: a @GtkTreePath@
    -> Maybe (c)
    -- ^ /@cell@/: a @GtkCellRenderer@
    -> m ()
iconViewSetTooltipCell iconView tooltip path cell = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    tooltip' <- unsafeManagedPtrCastPtr tooltip
    path' <- unsafeManagedPtrGetPtr path
    maybeCell <- case cell of
        Nothing -> return FP.nullPtr
        Just jCell -> do
            jCell' <- unsafeManagedPtrCastPtr jCell
            return jCell'
    gtk_icon_view_set_tooltip_cell iconView' tooltip' path' maybeCell
    touchManagedPtr iconView
    touchManagedPtr tooltip
    touchManagedPtr path
    whenJust cell touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetTooltipCellMethodInfo
instance (signature ~ (b -> Gtk.TreePath.TreePath -> Maybe (c) -> m ()), MonadIO m, IsIconView a, Gtk.Tooltip.IsTooltip b, Gtk.CellRenderer.IsCellRenderer c) => O.OverloadedMethod IconViewSetTooltipCellMethodInfo a signature where
    overloadedMethod = iconViewSetTooltipCell

instance O.OverloadedMethodInfo IconViewSetTooltipCellMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetTooltipCell",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetTooltipCell"
        })


#endif

-- method IconView::set_tooltip_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "an integer, which is a valid column number for @icon_view\8217s model"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_tooltip_column" gtk_icon_view_set_tooltip_column :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Int32 ->                                -- column : TBasicType TInt
    IO ()

{-# DEPRECATED iconViewSetTooltipColumn ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | If you only plan to have simple (text-only) tooltips on full items, you
-- can use this function to have @GtkIconView@ handle these automatically
-- for you. /@column@/ should be set to the column in /@iconView@/’s model
-- containing the tooltip texts, or -1 to disable this feature.
-- 
-- When enabled, @GtkWidget:has-tooltip@ will be set to 'P.True' and
-- /@iconView@/ will connect a @GtkWidget::query-tooltip@ signal handler.
-- 
-- Note that the signal handler sets the text with 'GI.Gtk.Objects.Tooltip.tooltipSetMarkup',
-- so &, \<, etc have to be escaped in the text.
iconViewSetTooltipColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Int32
    -- ^ /@column@/: an integer, which is a valid column number for /@iconView@/’s model
    -> m ()
iconViewSetTooltipColumn iconView column = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_set_tooltip_column iconView' column
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetTooltipColumnMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewSetTooltipColumnMethodInfo a signature where
    overloadedMethod = iconViewSetTooltipColumn

instance O.OverloadedMethodInfo IconViewSetTooltipColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetTooltipColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetTooltipColumn"
        })


#endif

-- method IconView::set_tooltip_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tooltip"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Tooltip" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTooltip`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreePath`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_set_tooltip_item" gtk_icon_view_set_tooltip_item :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gtk.Tooltip.Tooltip ->              -- tooltip : TInterface (Name {namespace = "Gtk", name = "Tooltip"})
    Ptr Gtk.TreePath.TreePath ->            -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    IO ()

{-# DEPRECATED iconViewSetTooltipItem ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Sets the tip area of /@tooltip@/ to be the area covered by the item at /@path@/.
-- See also 'GI.Gtk.Objects.IconView.iconViewSetTooltipColumn' for a simpler alternative.
-- See also 'GI.Gtk.Objects.Tooltip.tooltipSetTipArea'.
iconViewSetTooltipItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a, Gtk.Tooltip.IsTooltip b) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> b
    -- ^ /@tooltip@/: a @GtkTooltip@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: a @GtkTreePath@
    -> m ()
iconViewSetTooltipItem iconView tooltip path = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    tooltip' <- unsafeManagedPtrCastPtr tooltip
    path' <- unsafeManagedPtrGetPtr path
    gtk_icon_view_set_tooltip_item iconView' tooltip' path'
    touchManagedPtr iconView
    touchManagedPtr tooltip
    touchManagedPtr path
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewSetTooltipItemMethodInfo
instance (signature ~ (b -> Gtk.TreePath.TreePath -> m ()), MonadIO m, IsIconView a, Gtk.Tooltip.IsTooltip b) => O.OverloadedMethod IconViewSetTooltipItemMethodInfo a signature where
    overloadedMethod = iconViewSetTooltipItem

instance O.OverloadedMethodInfo IconViewSetTooltipItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewSetTooltipItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewSetTooltipItem"
        })


#endif

-- method IconView::unselect_all
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_unselect_all" gtk_icon_view_unselect_all :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO ()

{-# DEPRECATED iconViewUnselectAll ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Unselects all the icons.
iconViewUnselectAll ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> m ()
iconViewUnselectAll iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_unselect_all iconView'
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewUnselectAllMethodInfo
instance (signature ~ (m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewUnselectAllMethodInfo a signature where
    overloadedMethod = iconViewUnselectAll

instance O.OverloadedMethodInfo IconViewUnselectAllMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewUnselectAll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewUnselectAll"
        })


#endif

-- method IconView::unselect_path
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIconView`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The `GtkTreePath` to be unselected."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_unselect_path" gtk_icon_view_unselect_path :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    Ptr Gtk.TreePath.TreePath ->            -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    IO ()

{-# DEPRECATED iconViewUnselectPath ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Unselects the row at /@path@/.
iconViewUnselectPath ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: A @GtkIconView@.
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The @GtkTreePath@ to be unselected.
    -> m ()
iconViewUnselectPath iconView path = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path' <- unsafeManagedPtrGetPtr path
    gtk_icon_view_unselect_path iconView' path'
    touchManagedPtr iconView
    touchManagedPtr path
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewUnselectPathMethodInfo
instance (signature ~ (Gtk.TreePath.TreePath -> m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewUnselectPathMethodInfo a signature where
    overloadedMethod = iconViewUnselectPath

instance O.OverloadedMethodInfo IconViewUnselectPathMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewUnselectPath",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewUnselectPath"
        })


#endif

-- method IconView::unset_model_drag_dest
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_unset_model_drag_dest" gtk_icon_view_unset_model_drag_dest :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO ()

{-# DEPRECATED iconViewUnsetModelDragDest ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Undoes the effect of 'GI.Gtk.Objects.IconView.iconViewEnableModelDragDest'. Calling this
-- method sets @GtkIconView@:reorderable to 'P.False'.
iconViewUnsetModelDragDest ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m ()
iconViewUnsetModelDragDest iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_unset_model_drag_dest iconView'
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewUnsetModelDragDestMethodInfo
instance (signature ~ (m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewUnsetModelDragDestMethodInfo a signature where
    overloadedMethod = iconViewUnsetModelDragDest

instance O.OverloadedMethodInfo IconViewUnsetModelDragDestMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewUnsetModelDragDest",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewUnsetModelDragDest"
        })


#endif

-- method IconView::unset_model_drag_source
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_view_unset_model_drag_source" gtk_icon_view_unset_model_drag_source :: 
    Ptr IconView ->                         -- icon_view : TInterface (Name {namespace = "Gtk", name = "IconView"})
    IO ()

{-# DEPRECATED iconViewUnsetModelDragSource ["(Since version 4.10)","Use t'GI.Gtk.Objects.GridView.GridView' instead"] #-}
-- | Undoes the effect of 'GI.Gtk.Objects.IconView.iconViewEnableModelDragSource'. Calling this
-- method sets @GtkIconView@:reorderable to 'P.False'.
iconViewUnsetModelDragSource ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconView a) =>
    a
    -- ^ /@iconView@/: a @GtkIconView@
    -> m ()
iconViewUnsetModelDragSource iconView = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    gtk_icon_view_unset_model_drag_source iconView'
    touchManagedPtr iconView
    return ()

#if defined(ENABLE_OVERLOADING)
data IconViewUnsetModelDragSourceMethodInfo
instance (signature ~ (m ()), MonadIO m, IsIconView a) => O.OverloadedMethod IconViewUnsetModelDragSourceMethodInfo a signature where
    overloadedMethod = iconViewUnsetModelDragSource

instance O.OverloadedMethodInfo IconViewUnsetModelDragSourceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconView.iconViewUnsetModelDragSource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-IconView.html#v:iconViewUnsetModelDragSource"
        })


#endif


