

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Callbacks
    ( 

 -- * Signals


-- ** AssistantPageFunc #signal:AssistantPageFunc#

    AssistantPageFunc                       ,
    AssistantPageFunc_WithClosures          ,
    C_AssistantPageFunc                     ,
    drop_closures_AssistantPageFunc         ,
    dynamic_AssistantPageFunc               ,
    genClosure_AssistantPageFunc            ,
    mk_AssistantPageFunc                    ,
    noAssistantPageFunc                     ,
    noAssistantPageFunc_WithClosures        ,
    wrap_AssistantPageFunc                  ,


-- ** BuildableParserEndElementFieldCallback #signal:BuildableParserEndElementFieldCallback#

    BuildableParserEndElementFieldCallback  ,
    BuildableParserEndElementFieldCallback_WithClosures,
    C_BuildableParserEndElementFieldCallback,
    drop_closures_BuildableParserEndElementFieldCallback,
    dynamic_BuildableParserEndElementFieldCallback,
    mk_BuildableParserEndElementFieldCallback,
    noBuildableParserEndElementFieldCallback,
    noBuildableParserEndElementFieldCallback_WithClosures,


-- ** BuildableParserErrorFieldCallback #signal:BuildableParserErrorFieldCallback#

    BuildableParserErrorFieldCallback       ,
    BuildableParserErrorFieldCallback_WithClosures,
    C_BuildableParserErrorFieldCallback     ,
    drop_closures_BuildableParserErrorFieldCallback,
    dynamic_BuildableParserErrorFieldCallback,
    genClosure_BuildableParserErrorFieldCallback,
    mk_BuildableParserErrorFieldCallback    ,
    noBuildableParserErrorFieldCallback     ,
    noBuildableParserErrorFieldCallback_WithClosures,
    wrap_BuildableParserErrorFieldCallback  ,


-- ** BuildableParserStartElementFieldCallback #signal:BuildableParserStartElementFieldCallback#

    BuildableParserStartElementFieldCallback,
    BuildableParserStartElementFieldCallback_WithClosures,
    C_BuildableParserStartElementFieldCallback,
    drop_closures_BuildableParserStartElementFieldCallback,
    dynamic_BuildableParserStartElementFieldCallback,
    mk_BuildableParserStartElementFieldCallback,
    noBuildableParserStartElementFieldCallback,
    noBuildableParserStartElementFieldCallback_WithClosures,


-- ** BuildableParserTextFieldCallback #signal:BuildableParserTextFieldCallback#

    BuildableParserTextFieldCallback        ,
    BuildableParserTextFieldCallback_WithClosures,
    C_BuildableParserTextFieldCallback      ,
    drop_closures_BuildableParserTextFieldCallback,
    dynamic_BuildableParserTextFieldCallback,
    mk_BuildableParserTextFieldCallback     ,
    noBuildableParserTextFieldCallback      ,
    noBuildableParserTextFieldCallback_WithClosures,


-- ** CellAllocCallback #signal:CellAllocCallback#

    C_CellAllocCallback                     ,
    CellAllocCallback                       ,
    CellAllocCallback_WithClosures          ,
    drop_closures_CellAllocCallback         ,
    dynamic_CellAllocCallback               ,
    genClosure_CellAllocCallback            ,
    mk_CellAllocCallback                    ,
    noCellAllocCallback                     ,
    noCellAllocCallback_WithClosures        ,
    wrap_CellAllocCallback                  ,


-- ** CellCallback #signal:CellCallback#

    C_CellCallback                          ,
    CellCallback                            ,
    CellCallback_WithClosures               ,
    drop_closures_CellCallback              ,
    dynamic_CellCallback                    ,
    genClosure_CellCallback                 ,
    mk_CellCallback                         ,
    noCellCallback                          ,
    noCellCallback_WithClosures             ,
    wrap_CellCallback                       ,


-- ** CellLayoutDataFunc #signal:CellLayoutDataFunc#

    C_CellLayoutDataFunc                    ,
    CellLayoutDataFunc                      ,
    CellLayoutDataFunc_WithClosures         ,
    drop_closures_CellLayoutDataFunc        ,
    dynamic_CellLayoutDataFunc              ,
    genClosure_CellLayoutDataFunc           ,
    mk_CellLayoutDataFunc                   ,
    noCellLayoutDataFunc                    ,
    noCellLayoutDataFunc_WithClosures       ,
    wrap_CellLayoutDataFunc                 ,


-- ** CustomAllocateFunc #signal:CustomAllocateFunc#

    C_CustomAllocateFunc                    ,
    CustomAllocateFunc                      ,
    dynamic_CustomAllocateFunc              ,
    genClosure_CustomAllocateFunc           ,
    mk_CustomAllocateFunc                   ,
    noCustomAllocateFunc                    ,
    wrap_CustomAllocateFunc                 ,


-- ** CustomFilterFunc #signal:CustomFilterFunc#

    C_CustomFilterFunc                      ,
    CustomFilterFunc                        ,
    CustomFilterFunc_WithClosures           ,
    drop_closures_CustomFilterFunc          ,
    dynamic_CustomFilterFunc                ,
    genClosure_CustomFilterFunc             ,
    mk_CustomFilterFunc                     ,
    noCustomFilterFunc                      ,
    noCustomFilterFunc_WithClosures         ,
    wrap_CustomFilterFunc                   ,


-- ** CustomMeasureFunc #signal:CustomMeasureFunc#

    C_CustomMeasureFunc                     ,
    CustomMeasureFunc                       ,
    dynamic_CustomMeasureFunc               ,
    genClosure_CustomMeasureFunc            ,
    mk_CustomMeasureFunc                    ,
    noCustomMeasureFunc                     ,
    wrap_CustomMeasureFunc                  ,


-- ** CustomRequestModeFunc #signal:CustomRequestModeFunc#

    C_CustomRequestModeFunc                 ,
    CustomRequestModeFunc                   ,
    dynamic_CustomRequestModeFunc           ,
    genClosure_CustomRequestModeFunc        ,
    mk_CustomRequestModeFunc                ,
    noCustomRequestModeFunc                 ,
    wrap_CustomRequestModeFunc              ,


-- ** DrawingAreaDrawFunc #signal:DrawingAreaDrawFunc#

    C_DrawingAreaDrawFunc                   ,
    DrawingAreaDrawFunc                     ,
    DrawingAreaDrawFunc_WithClosures        ,
    drop_closures_DrawingAreaDrawFunc       ,
    dynamic_DrawingAreaDrawFunc             ,
    genClosure_DrawingAreaDrawFunc          ,
    mk_DrawingAreaDrawFunc                  ,
    noDrawingAreaDrawFunc                   ,
    noDrawingAreaDrawFunc_WithClosures      ,
    wrap_DrawingAreaDrawFunc                ,


-- ** EntryCompletionMatchFunc #signal:EntryCompletionMatchFunc#

    C_EntryCompletionMatchFunc              ,
    EntryCompletionMatchFunc                ,
    EntryCompletionMatchFunc_WithClosures   ,
    drop_closures_EntryCompletionMatchFunc  ,
    dynamic_EntryCompletionMatchFunc        ,
    genClosure_EntryCompletionMatchFunc     ,
    mk_EntryCompletionMatchFunc             ,
    noEntryCompletionMatchFunc              ,
    noEntryCompletionMatchFunc_WithClosures ,
    wrap_EntryCompletionMatchFunc           ,


-- ** ExpressionNotify #signal:ExpressionNotify#

    C_ExpressionNotify                      ,
    ExpressionNotify                        ,
    ExpressionNotify_WithClosures           ,
    drop_closures_ExpressionNotify          ,
    dynamic_ExpressionNotify                ,
    genClosure_ExpressionNotify             ,
    mk_ExpressionNotify                     ,
    noExpressionNotify                      ,
    noExpressionNotify_WithClosures         ,
    wrap_ExpressionNotify                   ,


-- ** FlowBoxCreateWidgetFunc #signal:FlowBoxCreateWidgetFunc#

    C_FlowBoxCreateWidgetFunc               ,
    FlowBoxCreateWidgetFunc                 ,
    FlowBoxCreateWidgetFunc_WithClosures    ,
    drop_closures_FlowBoxCreateWidgetFunc   ,
    dynamic_FlowBoxCreateWidgetFunc         ,
    genClosure_FlowBoxCreateWidgetFunc      ,
    mk_FlowBoxCreateWidgetFunc              ,
    noFlowBoxCreateWidgetFunc               ,
    noFlowBoxCreateWidgetFunc_WithClosures  ,
    wrap_FlowBoxCreateWidgetFunc            ,


-- ** FlowBoxFilterFunc #signal:FlowBoxFilterFunc#

    C_FlowBoxFilterFunc                     ,
    FlowBoxFilterFunc                       ,
    FlowBoxFilterFunc_WithClosures          ,
    drop_closures_FlowBoxFilterFunc         ,
    dynamic_FlowBoxFilterFunc               ,
    genClosure_FlowBoxFilterFunc            ,
    mk_FlowBoxFilterFunc                    ,
    noFlowBoxFilterFunc                     ,
    noFlowBoxFilterFunc_WithClosures        ,
    wrap_FlowBoxFilterFunc                  ,


-- ** FlowBoxForeachFunc #signal:FlowBoxForeachFunc#

    C_FlowBoxForeachFunc                    ,
    FlowBoxForeachFunc                      ,
    FlowBoxForeachFunc_WithClosures         ,
    drop_closures_FlowBoxForeachFunc        ,
    dynamic_FlowBoxForeachFunc              ,
    genClosure_FlowBoxForeachFunc           ,
    mk_FlowBoxForeachFunc                   ,
    noFlowBoxForeachFunc                    ,
    noFlowBoxForeachFunc_WithClosures       ,
    wrap_FlowBoxForeachFunc                 ,


-- ** FlowBoxSortFunc #signal:FlowBoxSortFunc#

    C_FlowBoxSortFunc                       ,
    FlowBoxSortFunc                         ,
    FlowBoxSortFunc_WithClosures            ,
    drop_closures_FlowBoxSortFunc           ,
    dynamic_FlowBoxSortFunc                 ,
    genClosure_FlowBoxSortFunc              ,
    mk_FlowBoxSortFunc                      ,
    noFlowBoxSortFunc                       ,
    noFlowBoxSortFunc_WithClosures          ,
    wrap_FlowBoxSortFunc                    ,


-- ** FontFilterFunc #signal:FontFilterFunc#

    C_FontFilterFunc                        ,
    FontFilterFunc                          ,
    FontFilterFunc_WithClosures             ,
    drop_closures_FontFilterFunc            ,
    dynamic_FontFilterFunc                  ,
    genClosure_FontFilterFunc               ,
    mk_FontFilterFunc                       ,
    noFontFilterFunc                        ,
    noFontFilterFunc_WithClosures           ,
    wrap_FontFilterFunc                     ,


-- ** IconViewForeachFunc #signal:IconViewForeachFunc#

    C_IconViewForeachFunc                   ,
    IconViewForeachFunc                     ,
    IconViewForeachFunc_WithClosures        ,
    drop_closures_IconViewForeachFunc       ,
    dynamic_IconViewForeachFunc             ,
    genClosure_IconViewForeachFunc          ,
    mk_IconViewForeachFunc                  ,
    noIconViewForeachFunc                   ,
    noIconViewForeachFunc_WithClosures      ,
    wrap_IconViewForeachFunc                ,


-- ** ListBoxCreateWidgetFunc #signal:ListBoxCreateWidgetFunc#

    C_ListBoxCreateWidgetFunc               ,
    ListBoxCreateWidgetFunc                 ,
    ListBoxCreateWidgetFunc_WithClosures    ,
    drop_closures_ListBoxCreateWidgetFunc   ,
    dynamic_ListBoxCreateWidgetFunc         ,
    genClosure_ListBoxCreateWidgetFunc      ,
    mk_ListBoxCreateWidgetFunc              ,
    noListBoxCreateWidgetFunc               ,
    noListBoxCreateWidgetFunc_WithClosures  ,
    wrap_ListBoxCreateWidgetFunc            ,


-- ** ListBoxFilterFunc #signal:ListBoxFilterFunc#

    C_ListBoxFilterFunc                     ,
    ListBoxFilterFunc                       ,
    ListBoxFilterFunc_WithClosures          ,
    drop_closures_ListBoxFilterFunc         ,
    dynamic_ListBoxFilterFunc               ,
    genClosure_ListBoxFilterFunc            ,
    mk_ListBoxFilterFunc                    ,
    noListBoxFilterFunc                     ,
    noListBoxFilterFunc_WithClosures        ,
    wrap_ListBoxFilterFunc                  ,


-- ** ListBoxForeachFunc #signal:ListBoxForeachFunc#

    C_ListBoxForeachFunc                    ,
    ListBoxForeachFunc                      ,
    ListBoxForeachFunc_WithClosures         ,
    drop_closures_ListBoxForeachFunc        ,
    dynamic_ListBoxForeachFunc              ,
    genClosure_ListBoxForeachFunc           ,
    mk_ListBoxForeachFunc                   ,
    noListBoxForeachFunc                    ,
    noListBoxForeachFunc_WithClosures       ,
    wrap_ListBoxForeachFunc                 ,


-- ** ListBoxSortFunc #signal:ListBoxSortFunc#

    C_ListBoxSortFunc                       ,
    ListBoxSortFunc                         ,
    ListBoxSortFunc_WithClosures            ,
    drop_closures_ListBoxSortFunc           ,
    dynamic_ListBoxSortFunc                 ,
    genClosure_ListBoxSortFunc              ,
    mk_ListBoxSortFunc                      ,
    noListBoxSortFunc                       ,
    noListBoxSortFunc_WithClosures          ,
    wrap_ListBoxSortFunc                    ,


-- ** ListBoxUpdateHeaderFunc #signal:ListBoxUpdateHeaderFunc#

    C_ListBoxUpdateHeaderFunc               ,
    ListBoxUpdateHeaderFunc                 ,
    ListBoxUpdateHeaderFunc_WithClosures    ,
    drop_closures_ListBoxUpdateHeaderFunc   ,
    dynamic_ListBoxUpdateHeaderFunc         ,
    genClosure_ListBoxUpdateHeaderFunc      ,
    mk_ListBoxUpdateHeaderFunc              ,
    noListBoxUpdateHeaderFunc               ,
    noListBoxUpdateHeaderFunc_WithClosures  ,
    wrap_ListBoxUpdateHeaderFunc            ,


-- ** MapListModelMapFunc #signal:MapListModelMapFunc#

    C_MapListModelMapFunc                   ,
    MapListModelMapFunc                     ,
    MapListModelMapFunc_WithClosures        ,
    drop_closures_MapListModelMapFunc       ,
    dynamic_MapListModelMapFunc             ,
    genClosure_MapListModelMapFunc          ,
    mk_MapListModelMapFunc                  ,
    noMapListModelMapFunc                   ,
    noMapListModelMapFunc_WithClosures      ,
    wrap_MapListModelMapFunc                ,


-- ** MenuButtonCreatePopupFunc #signal:MenuButtonCreatePopupFunc#

    C_MenuButtonCreatePopupFunc             ,
    MenuButtonCreatePopupFunc               ,
    MenuButtonCreatePopupFunc_WithClosures  ,
    drop_closures_MenuButtonCreatePopupFunc ,
    dynamic_MenuButtonCreatePopupFunc       ,
    genClosure_MenuButtonCreatePopupFunc    ,
    mk_MenuButtonCreatePopupFunc            ,
    noMenuButtonCreatePopupFunc             ,
    noMenuButtonCreatePopupFunc_WithClosures,
    wrap_MenuButtonCreatePopupFunc          ,


-- ** PageSetupDoneFunc #signal:PageSetupDoneFunc#

    C_PageSetupDoneFunc                     ,
    PageSetupDoneFunc                       ,
    PageSetupDoneFunc_WithClosures          ,
    drop_closures_PageSetupDoneFunc         ,
    dynamic_PageSetupDoneFunc               ,
    genClosure_PageSetupDoneFunc            ,
    mk_PageSetupDoneFunc                    ,
    noPageSetupDoneFunc                     ,
    noPageSetupDoneFunc_WithClosures        ,
    wrap_PageSetupDoneFunc                  ,


-- ** PrintJobCompleteFunc #signal:PrintJobCompleteFunc#

    C_PrintJobCompleteFunc                  ,
    PrintJobCompleteFunc                    ,
    PrintJobCompleteFunc_WithClosures       ,
    drop_closures_PrintJobCompleteFunc      ,
    dynamic_PrintJobCompleteFunc            ,
    genClosure_PrintJobCompleteFunc         ,
    mk_PrintJobCompleteFunc                 ,
    noPrintJobCompleteFunc                  ,
    noPrintJobCompleteFunc_WithClosures     ,
    wrap_PrintJobCompleteFunc               ,


-- ** PrintSettingsFunc #signal:PrintSettingsFunc#

    C_PrintSettingsFunc                     ,
    PrintSettingsFunc                       ,
    PrintSettingsFunc_WithClosures          ,
    drop_closures_PrintSettingsFunc         ,
    dynamic_PrintSettingsFunc               ,
    genClosure_PrintSettingsFunc            ,
    mk_PrintSettingsFunc                    ,
    noPrintSettingsFunc                     ,
    noPrintSettingsFunc_WithClosures        ,
    wrap_PrintSettingsFunc                  ,


-- ** PrinterFunc #signal:PrinterFunc#

    C_PrinterFunc                           ,
    PrinterFunc                             ,
    PrinterFunc_WithClosures                ,
    drop_closures_PrinterFunc               ,
    dynamic_PrinterFunc                     ,
    genClosure_PrinterFunc                  ,
    mk_PrinterFunc                          ,
    noPrinterFunc                           ,
    noPrinterFunc_WithClosures              ,
    wrap_PrinterFunc                        ,


-- ** ScaleFormatValueFunc #signal:ScaleFormatValueFunc#

    C_ScaleFormatValueFunc                  ,
    ScaleFormatValueFunc                    ,
    ScaleFormatValueFunc_WithClosures       ,
    drop_closures_ScaleFormatValueFunc      ,
    dynamic_ScaleFormatValueFunc            ,
    genClosure_ScaleFormatValueFunc         ,
    mk_ScaleFormatValueFunc                 ,
    noScaleFormatValueFunc                  ,
    noScaleFormatValueFunc_WithClosures     ,
    wrap_ScaleFormatValueFunc               ,


-- ** ShortcutFunc #signal:ShortcutFunc#

    C_ShortcutFunc                          ,
    ShortcutFunc                            ,
    ShortcutFunc_WithClosures               ,
    drop_closures_ShortcutFunc              ,
    dynamic_ShortcutFunc                    ,
    genClosure_ShortcutFunc                 ,
    mk_ShortcutFunc                         ,
    noShortcutFunc                          ,
    noShortcutFunc_WithClosures             ,
    wrap_ShortcutFunc                       ,


-- ** TextBufferCommitNotify #signal:TextBufferCommitNotify#

    C_TextBufferCommitNotify                ,
    TextBufferCommitNotify                  ,
    TextBufferCommitNotify_WithClosures     ,
    drop_closures_TextBufferCommitNotify    ,
    dynamic_TextBufferCommitNotify          ,
    genClosure_TextBufferCommitNotify       ,
    mk_TextBufferCommitNotify               ,
    noTextBufferCommitNotify                ,
    noTextBufferCommitNotify_WithClosures   ,
    wrap_TextBufferCommitNotify             ,


-- ** TextCharPredicate #signal:TextCharPredicate#

    C_TextCharPredicate                     ,
    TextCharPredicate                       ,
    TextCharPredicate_WithClosures          ,
    drop_closures_TextCharPredicate         ,
    dynamic_TextCharPredicate               ,
    genClosure_TextCharPredicate            ,
    mk_TextCharPredicate                    ,
    noTextCharPredicate                     ,
    noTextCharPredicate_WithClosures        ,
    wrap_TextCharPredicate                  ,


-- ** TextTagTableForeach #signal:TextTagTableForeach#

    C_TextTagTableForeach                   ,
    TextTagTableForeach                     ,
    TextTagTableForeach_WithClosures        ,
    drop_closures_TextTagTableForeach       ,
    dynamic_TextTagTableForeach             ,
    genClosure_TextTagTableForeach          ,
    mk_TextTagTableForeach                  ,
    noTextTagTableForeach                   ,
    noTextTagTableForeach_WithClosures      ,
    wrap_TextTagTableForeach                ,


-- ** TickCallback #signal:TickCallback#

    C_TickCallback                          ,
    TickCallback                            ,
    TickCallback_WithClosures               ,
    drop_closures_TickCallback              ,
    dynamic_TickCallback                    ,
    genClosure_TickCallback                 ,
    mk_TickCallback                         ,
    noTickCallback                          ,
    noTickCallback_WithClosures             ,
    wrap_TickCallback                       ,


-- ** TreeCellDataFunc #signal:TreeCellDataFunc#

    C_TreeCellDataFunc                      ,
    TreeCellDataFunc                        ,
    TreeCellDataFunc_WithClosures           ,
    drop_closures_TreeCellDataFunc          ,
    dynamic_TreeCellDataFunc                ,
    genClosure_TreeCellDataFunc             ,
    mk_TreeCellDataFunc                     ,
    noTreeCellDataFunc                      ,
    noTreeCellDataFunc_WithClosures         ,
    wrap_TreeCellDataFunc                   ,


-- ** TreeIterCompareFunc #signal:TreeIterCompareFunc#

    C_TreeIterCompareFunc                   ,
    TreeIterCompareFunc                     ,
    TreeIterCompareFunc_WithClosures        ,
    drop_closures_TreeIterCompareFunc       ,
    dynamic_TreeIterCompareFunc             ,
    genClosure_TreeIterCompareFunc          ,
    mk_TreeIterCompareFunc                  ,
    noTreeIterCompareFunc                   ,
    noTreeIterCompareFunc_WithClosures      ,
    wrap_TreeIterCompareFunc                ,


-- ** TreeListModelCreateModelFunc #signal:TreeListModelCreateModelFunc#

    C_TreeListModelCreateModelFunc          ,
    TreeListModelCreateModelFunc            ,
    TreeListModelCreateModelFunc_WithClosures,
    drop_closures_TreeListModelCreateModelFunc,
    dynamic_TreeListModelCreateModelFunc    ,
    genClosure_TreeListModelCreateModelFunc ,
    mk_TreeListModelCreateModelFunc         ,
    noTreeListModelCreateModelFunc          ,
    noTreeListModelCreateModelFunc_WithClosures,
    wrap_TreeListModelCreateModelFunc       ,


-- ** TreeModelFilterModifyFunc #signal:TreeModelFilterModifyFunc#

    C_TreeModelFilterModifyFunc             ,
    TreeModelFilterModifyFunc               ,
    TreeModelFilterModifyFunc_WithClosures  ,
    drop_closures_TreeModelFilterModifyFunc ,
    dynamic_TreeModelFilterModifyFunc       ,
    genClosure_TreeModelFilterModifyFunc    ,
    mk_TreeModelFilterModifyFunc            ,
    noTreeModelFilterModifyFunc             ,
    noTreeModelFilterModifyFunc_WithClosures,
    wrap_TreeModelFilterModifyFunc          ,


-- ** TreeModelFilterVisibleFunc #signal:TreeModelFilterVisibleFunc#

    C_TreeModelFilterVisibleFunc            ,
    TreeModelFilterVisibleFunc              ,
    TreeModelFilterVisibleFunc_WithClosures ,
    drop_closures_TreeModelFilterVisibleFunc,
    dynamic_TreeModelFilterVisibleFunc      ,
    genClosure_TreeModelFilterVisibleFunc   ,
    mk_TreeModelFilterVisibleFunc           ,
    noTreeModelFilterVisibleFunc            ,
    noTreeModelFilterVisibleFunc_WithClosures,
    wrap_TreeModelFilterVisibleFunc         ,


-- ** TreeModelForeachFunc #signal:TreeModelForeachFunc#

    C_TreeModelForeachFunc                  ,
    TreeModelForeachFunc                    ,
    TreeModelForeachFunc_WithClosures       ,
    drop_closures_TreeModelForeachFunc      ,
    dynamic_TreeModelForeachFunc            ,
    genClosure_TreeModelForeachFunc         ,
    mk_TreeModelForeachFunc                 ,
    noTreeModelForeachFunc                  ,
    noTreeModelForeachFunc_WithClosures     ,
    wrap_TreeModelForeachFunc               ,


-- ** TreeSelectionForeachFunc #signal:TreeSelectionForeachFunc#

    C_TreeSelectionForeachFunc              ,
    TreeSelectionForeachFunc                ,
    TreeSelectionForeachFunc_WithClosures   ,
    drop_closures_TreeSelectionForeachFunc  ,
    dynamic_TreeSelectionForeachFunc        ,
    genClosure_TreeSelectionForeachFunc     ,
    mk_TreeSelectionForeachFunc             ,
    noTreeSelectionForeachFunc              ,
    noTreeSelectionForeachFunc_WithClosures ,
    wrap_TreeSelectionForeachFunc           ,


-- ** TreeSelectionFunc #signal:TreeSelectionFunc#

    C_TreeSelectionFunc                     ,
    TreeSelectionFunc                       ,
    TreeSelectionFunc_WithClosures          ,
    drop_closures_TreeSelectionFunc         ,
    dynamic_TreeSelectionFunc               ,
    genClosure_TreeSelectionFunc            ,
    mk_TreeSelectionFunc                    ,
    noTreeSelectionFunc                     ,
    noTreeSelectionFunc_WithClosures        ,
    wrap_TreeSelectionFunc                  ,


-- ** TreeViewColumnDropFunc #signal:TreeViewColumnDropFunc#

    C_TreeViewColumnDropFunc                ,
    TreeViewColumnDropFunc                  ,
    TreeViewColumnDropFunc_WithClosures     ,
    drop_closures_TreeViewColumnDropFunc    ,
    dynamic_TreeViewColumnDropFunc          ,
    genClosure_TreeViewColumnDropFunc       ,
    mk_TreeViewColumnDropFunc               ,
    noTreeViewColumnDropFunc                ,
    noTreeViewColumnDropFunc_WithClosures   ,
    wrap_TreeViewColumnDropFunc             ,


-- ** TreeViewMappingFunc #signal:TreeViewMappingFunc#

    C_TreeViewMappingFunc                   ,
    TreeViewMappingFunc                     ,
    TreeViewMappingFunc_WithClosures        ,
    drop_closures_TreeViewMappingFunc       ,
    dynamic_TreeViewMappingFunc             ,
    genClosure_TreeViewMappingFunc          ,
    mk_TreeViewMappingFunc                  ,
    noTreeViewMappingFunc                   ,
    noTreeViewMappingFunc_WithClosures      ,
    wrap_TreeViewMappingFunc                ,


-- ** TreeViewRowSeparatorFunc #signal:TreeViewRowSeparatorFunc#

    C_TreeViewRowSeparatorFunc              ,
    TreeViewRowSeparatorFunc                ,
    TreeViewRowSeparatorFunc_WithClosures   ,
    drop_closures_TreeViewRowSeparatorFunc  ,
    dynamic_TreeViewRowSeparatorFunc        ,
    genClosure_TreeViewRowSeparatorFunc     ,
    mk_TreeViewRowSeparatorFunc             ,
    noTreeViewRowSeparatorFunc              ,
    noTreeViewRowSeparatorFunc_WithClosures ,
    wrap_TreeViewRowSeparatorFunc           ,


-- ** TreeViewSearchEqualFunc #signal:TreeViewSearchEqualFunc#

    C_TreeViewSearchEqualFunc               ,
    TreeViewSearchEqualFunc                 ,
    TreeViewSearchEqualFunc_WithClosures    ,
    drop_closures_TreeViewSearchEqualFunc   ,
    dynamic_TreeViewSearchEqualFunc         ,
    genClosure_TreeViewSearchEqualFunc      ,
    mk_TreeViewSearchEqualFunc              ,
    noTreeViewSearchEqualFunc               ,
    noTreeViewSearchEqualFunc_WithClosures  ,
    wrap_TreeViewSearchEqualFunc            ,


-- ** WidgetActionActivateFunc #signal:WidgetActionActivateFunc#

    C_WidgetActionActivateFunc              ,
    WidgetActionActivateFunc                ,
    dynamic_WidgetActionActivateFunc        ,
    genClosure_WidgetActionActivateFunc     ,
    mk_WidgetActionActivateFunc             ,
    noWidgetActionActivateFunc              ,
    wrap_WidgetActionActivateFunc           ,


-- ** WidgetClassComputeExpandFieldCallback #signal:WidgetClassComputeExpandFieldCallback#

    C_WidgetClassComputeExpandFieldCallback ,
    WidgetClassComputeExpandFieldCallback   ,
    dynamic_WidgetClassComputeExpandFieldCallback,
    genClosure_WidgetClassComputeExpandFieldCallback,
    mk_WidgetClassComputeExpandFieldCallback,
    noWidgetClassComputeExpandFieldCallback ,
    wrap_WidgetClassComputeExpandFieldCallback,


-- ** WidgetClassContainsFieldCallback #signal:WidgetClassContainsFieldCallback#

    C_WidgetClassContainsFieldCallback      ,
    WidgetClassContainsFieldCallback        ,
    dynamic_WidgetClassContainsFieldCallback,
    genClosure_WidgetClassContainsFieldCallback,
    mk_WidgetClassContainsFieldCallback     ,
    noWidgetClassContainsFieldCallback      ,
    wrap_WidgetClassContainsFieldCallback   ,


-- ** WidgetClassCssChangedFieldCallback #signal:WidgetClassCssChangedFieldCallback#

    C_WidgetClassCssChangedFieldCallback    ,
    WidgetClassCssChangedFieldCallback      ,
    dynamic_WidgetClassCssChangedFieldCallback,
    genClosure_WidgetClassCssChangedFieldCallback,
    mk_WidgetClassCssChangedFieldCallback   ,
    noWidgetClassCssChangedFieldCallback    ,
    wrap_WidgetClassCssChangedFieldCallback ,


-- ** WidgetClassDirectionChangedFieldCallback #signal:WidgetClassDirectionChangedFieldCallback#

    C_WidgetClassDirectionChangedFieldCallback,
    WidgetClassDirectionChangedFieldCallback,
    dynamic_WidgetClassDirectionChangedFieldCallback,
    genClosure_WidgetClassDirectionChangedFieldCallback,
    mk_WidgetClassDirectionChangedFieldCallback,
    noWidgetClassDirectionChangedFieldCallback,
    wrap_WidgetClassDirectionChangedFieldCallback,


-- ** WidgetClassFocusFieldCallback #signal:WidgetClassFocusFieldCallback#

    C_WidgetClassFocusFieldCallback         ,
    WidgetClassFocusFieldCallback           ,
    dynamic_WidgetClassFocusFieldCallback   ,
    genClosure_WidgetClassFocusFieldCallback,
    mk_WidgetClassFocusFieldCallback        ,
    noWidgetClassFocusFieldCallback         ,
    wrap_WidgetClassFocusFieldCallback      ,


-- ** WidgetClassGetRequestModeFieldCallback #signal:WidgetClassGetRequestModeFieldCallback#

    C_WidgetClassGetRequestModeFieldCallback,
    WidgetClassGetRequestModeFieldCallback  ,
    dynamic_WidgetClassGetRequestModeFieldCallback,
    genClosure_WidgetClassGetRequestModeFieldCallback,
    mk_WidgetClassGetRequestModeFieldCallback,
    noWidgetClassGetRequestModeFieldCallback,
    wrap_WidgetClassGetRequestModeFieldCallback,


-- ** WidgetClassGrabFocusFieldCallback #signal:WidgetClassGrabFocusFieldCallback#

    C_WidgetClassGrabFocusFieldCallback     ,
    WidgetClassGrabFocusFieldCallback       ,
    dynamic_WidgetClassGrabFocusFieldCallback,
    genClosure_WidgetClassGrabFocusFieldCallback,
    mk_WidgetClassGrabFocusFieldCallback    ,
    noWidgetClassGrabFocusFieldCallback     ,
    wrap_WidgetClassGrabFocusFieldCallback  ,


-- ** WidgetClassHideFieldCallback #signal:WidgetClassHideFieldCallback#

    C_WidgetClassHideFieldCallback          ,
    WidgetClassHideFieldCallback            ,
    dynamic_WidgetClassHideFieldCallback    ,
    genClosure_WidgetClassHideFieldCallback ,
    mk_WidgetClassHideFieldCallback         ,
    noWidgetClassHideFieldCallback          ,
    wrap_WidgetClassHideFieldCallback       ,


-- ** WidgetClassKeynavFailedFieldCallback #signal:WidgetClassKeynavFailedFieldCallback#

    C_WidgetClassKeynavFailedFieldCallback  ,
    WidgetClassKeynavFailedFieldCallback    ,
    dynamic_WidgetClassKeynavFailedFieldCallback,
    genClosure_WidgetClassKeynavFailedFieldCallback,
    mk_WidgetClassKeynavFailedFieldCallback ,
    noWidgetClassKeynavFailedFieldCallback  ,
    wrap_WidgetClassKeynavFailedFieldCallback,


-- ** WidgetClassMapFieldCallback #signal:WidgetClassMapFieldCallback#

    C_WidgetClassMapFieldCallback           ,
    WidgetClassMapFieldCallback             ,
    dynamic_WidgetClassMapFieldCallback     ,
    genClosure_WidgetClassMapFieldCallback  ,
    mk_WidgetClassMapFieldCallback          ,
    noWidgetClassMapFieldCallback           ,
    wrap_WidgetClassMapFieldCallback        ,


-- ** WidgetClassMeasureFieldCallback #signal:WidgetClassMeasureFieldCallback#

    C_WidgetClassMeasureFieldCallback       ,
    WidgetClassMeasureFieldCallback         ,
    dynamic_WidgetClassMeasureFieldCallback ,
    genClosure_WidgetClassMeasureFieldCallback,
    mk_WidgetClassMeasureFieldCallback      ,
    noWidgetClassMeasureFieldCallback       ,
    wrap_WidgetClassMeasureFieldCallback    ,


-- ** WidgetClassMnemonicActivateFieldCallback #signal:WidgetClassMnemonicActivateFieldCallback#

    C_WidgetClassMnemonicActivateFieldCallback,
    WidgetClassMnemonicActivateFieldCallback,
    dynamic_WidgetClassMnemonicActivateFieldCallback,
    genClosure_WidgetClassMnemonicActivateFieldCallback,
    mk_WidgetClassMnemonicActivateFieldCallback,
    noWidgetClassMnemonicActivateFieldCallback,
    wrap_WidgetClassMnemonicActivateFieldCallback,


-- ** WidgetClassMoveFocusFieldCallback #signal:WidgetClassMoveFocusFieldCallback#

    C_WidgetClassMoveFocusFieldCallback     ,
    WidgetClassMoveFocusFieldCallback       ,
    dynamic_WidgetClassMoveFocusFieldCallback,
    genClosure_WidgetClassMoveFocusFieldCallback,
    mk_WidgetClassMoveFocusFieldCallback    ,
    noWidgetClassMoveFocusFieldCallback     ,
    wrap_WidgetClassMoveFocusFieldCallback  ,


-- ** WidgetClassQueryTooltipFieldCallback #signal:WidgetClassQueryTooltipFieldCallback#

    C_WidgetClassQueryTooltipFieldCallback  ,
    WidgetClassQueryTooltipFieldCallback    ,
    dynamic_WidgetClassQueryTooltipFieldCallback,
    genClosure_WidgetClassQueryTooltipFieldCallback,
    mk_WidgetClassQueryTooltipFieldCallback ,
    noWidgetClassQueryTooltipFieldCallback  ,
    wrap_WidgetClassQueryTooltipFieldCallback,


-- ** WidgetClassRealizeFieldCallback #signal:WidgetClassRealizeFieldCallback#

    C_WidgetClassRealizeFieldCallback       ,
    WidgetClassRealizeFieldCallback         ,
    dynamic_WidgetClassRealizeFieldCallback ,
    genClosure_WidgetClassRealizeFieldCallback,
    mk_WidgetClassRealizeFieldCallback      ,
    noWidgetClassRealizeFieldCallback       ,
    wrap_WidgetClassRealizeFieldCallback    ,


-- ** WidgetClassRootFieldCallback #signal:WidgetClassRootFieldCallback#

    C_WidgetClassRootFieldCallback          ,
    WidgetClassRootFieldCallback            ,
    dynamic_WidgetClassRootFieldCallback    ,
    genClosure_WidgetClassRootFieldCallback ,
    mk_WidgetClassRootFieldCallback         ,
    noWidgetClassRootFieldCallback          ,
    wrap_WidgetClassRootFieldCallback       ,


-- ** WidgetClassSetFocusChildFieldCallback #signal:WidgetClassSetFocusChildFieldCallback#

    C_WidgetClassSetFocusChildFieldCallback ,
    WidgetClassSetFocusChildFieldCallback   ,
    dynamic_WidgetClassSetFocusChildFieldCallback,
    genClosure_WidgetClassSetFocusChildFieldCallback,
    mk_WidgetClassSetFocusChildFieldCallback,
    noWidgetClassSetFocusChildFieldCallback ,
    wrap_WidgetClassSetFocusChildFieldCallback,


-- ** WidgetClassShowFieldCallback #signal:WidgetClassShowFieldCallback#

    C_WidgetClassShowFieldCallback          ,
    WidgetClassShowFieldCallback            ,
    dynamic_WidgetClassShowFieldCallback    ,
    genClosure_WidgetClassShowFieldCallback ,
    mk_WidgetClassShowFieldCallback         ,
    noWidgetClassShowFieldCallback          ,
    wrap_WidgetClassShowFieldCallback       ,


-- ** WidgetClassSizeAllocateFieldCallback #signal:WidgetClassSizeAllocateFieldCallback#

    C_WidgetClassSizeAllocateFieldCallback  ,
    WidgetClassSizeAllocateFieldCallback    ,
    dynamic_WidgetClassSizeAllocateFieldCallback,
    genClosure_WidgetClassSizeAllocateFieldCallback,
    mk_WidgetClassSizeAllocateFieldCallback ,
    noWidgetClassSizeAllocateFieldCallback  ,
    wrap_WidgetClassSizeAllocateFieldCallback,


-- ** WidgetClassSnapshotFieldCallback #signal:WidgetClassSnapshotFieldCallback#

    C_WidgetClassSnapshotFieldCallback      ,
    WidgetClassSnapshotFieldCallback        ,
    dynamic_WidgetClassSnapshotFieldCallback,
    genClosure_WidgetClassSnapshotFieldCallback,
    mk_WidgetClassSnapshotFieldCallback     ,
    noWidgetClassSnapshotFieldCallback      ,
    wrap_WidgetClassSnapshotFieldCallback   ,


-- ** WidgetClassStateFlagsChangedFieldCallback #signal:WidgetClassStateFlagsChangedFieldCallback#

    C_WidgetClassStateFlagsChangedFieldCallback,
    WidgetClassStateFlagsChangedFieldCallback,
    dynamic_WidgetClassStateFlagsChangedFieldCallback,
    genClosure_WidgetClassStateFlagsChangedFieldCallback,
    mk_WidgetClassStateFlagsChangedFieldCallback,
    noWidgetClassStateFlagsChangedFieldCallback,
    wrap_WidgetClassStateFlagsChangedFieldCallback,


-- ** WidgetClassSystemSettingChangedFieldCallback #signal:WidgetClassSystemSettingChangedFieldCallback#

    C_WidgetClassSystemSettingChangedFieldCallback,
    WidgetClassSystemSettingChangedFieldCallback,
    dynamic_WidgetClassSystemSettingChangedFieldCallback,
    genClosure_WidgetClassSystemSettingChangedFieldCallback,
    mk_WidgetClassSystemSettingChangedFieldCallback,
    noWidgetClassSystemSettingChangedFieldCallback,
    wrap_WidgetClassSystemSettingChangedFieldCallback,


-- ** WidgetClassUnmapFieldCallback #signal:WidgetClassUnmapFieldCallback#

    C_WidgetClassUnmapFieldCallback         ,
    WidgetClassUnmapFieldCallback           ,
    dynamic_WidgetClassUnmapFieldCallback   ,
    genClosure_WidgetClassUnmapFieldCallback,
    mk_WidgetClassUnmapFieldCallback        ,
    noWidgetClassUnmapFieldCallback         ,
    wrap_WidgetClassUnmapFieldCallback      ,


-- ** WidgetClassUnrealizeFieldCallback #signal:WidgetClassUnrealizeFieldCallback#

    C_WidgetClassUnrealizeFieldCallback     ,
    WidgetClassUnrealizeFieldCallback       ,
    dynamic_WidgetClassUnrealizeFieldCallback,
    genClosure_WidgetClassUnrealizeFieldCallback,
    mk_WidgetClassUnrealizeFieldCallback    ,
    noWidgetClassUnrealizeFieldCallback     ,
    wrap_WidgetClassUnrealizeFieldCallback  ,


-- ** WidgetClassUnrootFieldCallback #signal:WidgetClassUnrootFieldCallback#

    C_WidgetClassUnrootFieldCallback        ,
    WidgetClassUnrootFieldCallback          ,
    dynamic_WidgetClassUnrootFieldCallback  ,
    genClosure_WidgetClassUnrootFieldCallback,
    mk_WidgetClassUnrootFieldCallback       ,
    noWidgetClassUnrootFieldCallback        ,
    wrap_WidgetClassUnrootFieldCallback     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.KeyFile as GLib.KeyFile
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ObjectClass as GObject.ObjectClass
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Actionable as Gtk.Actionable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellEditable as Gtk.CellEditable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellLayout as Gtk.CellLayout
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Editable as Gtk.Editable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Scrollable as Gtk.Scrollable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.TreeModel as Gtk.TreeModel
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellArea as Gtk.CellArea
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellAreaContext as Gtk.CellAreaContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellRenderer as Gtk.CellRenderer
import {-# SOURCE #-} qualified GI.Gtk.Objects.DrawingArea as Gtk.DrawingArea
import {-# SOURCE #-} qualified GI.Gtk.Objects.EntryCompletion as Gtk.EntryCompletion
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.FlowBox as Gtk.FlowBox
import {-# SOURCE #-} qualified GI.Gtk.Objects.FlowBoxChild as Gtk.FlowBoxChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.IconView as Gtk.IconView
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListBox as Gtk.ListBox
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListBoxRow as Gtk.ListBoxRow
import {-# SOURCE #-} qualified GI.Gtk.Objects.MenuButton as Gtk.MenuButton
import {-# SOURCE #-} qualified GI.Gtk.Objects.PageSetup as Gtk.PageSetup
import {-# SOURCE #-} qualified GI.Gtk.Objects.Popover as Gtk.Popover
import {-# SOURCE #-} qualified GI.Gtk.Objects.PrintJob as Gtk.PrintJob
import {-# SOURCE #-} qualified GI.Gtk.Objects.PrintSettings as Gtk.PrintSettings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Printer as Gtk.Printer
import {-# SOURCE #-} qualified GI.Gtk.Objects.Range as Gtk.Range
import {-# SOURCE #-} qualified GI.Gtk.Objects.Scale as Gtk.Scale
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextBuffer as Gtk.TextBuffer
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextChildAnchor as Gtk.TextChildAnchor
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextMark as Gtk.TextMark
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextTag as Gtk.TextTag
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextTagTable as Gtk.TextTagTable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.TreeSelection as Gtk.TreeSelection
import {-# SOURCE #-} qualified GI.Gtk.Objects.TreeView as Gtk.TreeView
import {-# SOURCE #-} qualified GI.Gtk.Objects.TreeViewColumn as Gtk.TreeViewColumn
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.BuildableParseContext as Gtk.BuildableParseContext
import {-# SOURCE #-} qualified GI.Gtk.Structs.BuildableParser as Gtk.BuildableParser
import {-# SOURCE #-} qualified GI.Gtk.Structs.CssStyleChange as Gtk.CssStyleChange
import {-# SOURCE #-} qualified GI.Gtk.Structs.PageRange as Gtk.PageRange
import {-# SOURCE #-} qualified GI.Gtk.Structs.PaperSize as Gtk.PaperSize
import {-# SOURCE #-} qualified GI.Gtk.Structs.PrintBackend as Gtk.PrintBackend
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import {-# SOURCE #-} qualified GI.Gtk.Structs.TextIter as Gtk.TextIter
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreeIter as Gtk.TreeIter
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreePath as Gtk.TreePath
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Flags as Pango.Flags
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontFace as Pango.FontFace
import qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout
import qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import qualified GI.Pango.Structs.Language as Pango.Language
import qualified GI.Pango.Structs.TabArray as Pango.TabArray

#else
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellLayout as Gtk.CellLayout
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.TreeModel as Gtk.TreeModel
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellRenderer as Gtk.CellRenderer
import {-# SOURCE #-} qualified GI.Gtk.Objects.DrawingArea as Gtk.DrawingArea
import {-# SOURCE #-} qualified GI.Gtk.Objects.EntryCompletion as Gtk.EntryCompletion
import {-# SOURCE #-} qualified GI.Gtk.Objects.FlowBox as Gtk.FlowBox
import {-# SOURCE #-} qualified GI.Gtk.Objects.FlowBoxChild as Gtk.FlowBoxChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.IconView as Gtk.IconView
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListBox as Gtk.ListBox
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListBoxRow as Gtk.ListBoxRow
import {-# SOURCE #-} qualified GI.Gtk.Objects.MenuButton as Gtk.MenuButton
import {-# SOURCE #-} qualified GI.Gtk.Objects.PageSetup as Gtk.PageSetup
import {-# SOURCE #-} qualified GI.Gtk.Objects.PrintJob as Gtk.PrintJob
import {-# SOURCE #-} qualified GI.Gtk.Objects.Printer as Gtk.Printer
import {-# SOURCE #-} qualified GI.Gtk.Objects.Scale as Gtk.Scale
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextBuffer as Gtk.TextBuffer
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextTag as Gtk.TextTag
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.TreeSelection as Gtk.TreeSelection
import {-# SOURCE #-} qualified GI.Gtk.Objects.TreeView as Gtk.TreeView
import {-# SOURCE #-} qualified GI.Gtk.Objects.TreeViewColumn as Gtk.TreeViewColumn
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.BuildableParseContext as Gtk.BuildableParseContext
import {-# SOURCE #-} qualified GI.Gtk.Structs.CssStyleChange as Gtk.CssStyleChange
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreeIter as Gtk.TreeIter
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreePath as Gtk.TreePath
import qualified GI.Pango.Objects.FontFace as Pango.FontFace
import qualified GI.Pango.Objects.FontFamily as Pango.FontFamily

#endif

-- callback WidgetClassUnrootFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassUnrootFieldCallback =
    Ptr Gtk.Widget.Widget ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassUnrootFieldCallback :: FunPtr C_WidgetClassUnrootFieldCallback -> C_WidgetClassUnrootFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassUnrootFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassUnrootFieldCallback
    -> a
    -> m ()
dynamic_WidgetClassUnrootFieldCallback __funPtr widget = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    (__dynamic_C_WidgetClassUnrootFieldCallback __funPtr) widget'
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassUnrootFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassUnrootFieldCallback :: C_WidgetClassUnrootFieldCallback -> IO (FunPtr C_WidgetClassUnrootFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassUnrootFieldCallback =
    Gtk.Widget.Widget
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassUnrootFieldCallback`@.
noWidgetClassUnrootFieldCallback :: Maybe WidgetClassUnrootFieldCallback
noWidgetClassUnrootFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassUnrootFieldCallback :: MonadIO m => WidgetClassUnrootFieldCallback -> m (GClosure C_WidgetClassUnrootFieldCallback)
genClosure_WidgetClassUnrootFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassUnrootFieldCallback Nothing cb
    mk_WidgetClassUnrootFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassUnrootFieldCallback` into a `C_WidgetClassUnrootFieldCallback`.
wrap_WidgetClassUnrootFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassUnrootFieldCallback)) ->
    WidgetClassUnrootFieldCallback ->
    C_WidgetClassUnrootFieldCallback
wrap_WidgetClassUnrootFieldCallback gi'funptrptr gi'cb widget = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    gi'cb  widget'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassUnrealizeFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a widget" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassUnrealizeFieldCallback =
    Ptr Gtk.Widget.Widget ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassUnrealizeFieldCallback :: FunPtr C_WidgetClassUnrealizeFieldCallback -> C_WidgetClassUnrealizeFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassUnrealizeFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassUnrealizeFieldCallback
    -> a
    -- ^ /@widget@/: a widget
    -> m ()
dynamic_WidgetClassUnrealizeFieldCallback __funPtr widget = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    (__dynamic_C_WidgetClassUnrealizeFieldCallback __funPtr) widget'
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassUnrealizeFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassUnrealizeFieldCallback :: C_WidgetClassUnrealizeFieldCallback -> IO (FunPtr C_WidgetClassUnrealizeFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassUnrealizeFieldCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: a widget
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassUnrealizeFieldCallback`@.
noWidgetClassUnrealizeFieldCallback :: Maybe WidgetClassUnrealizeFieldCallback
noWidgetClassUnrealizeFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassUnrealizeFieldCallback :: MonadIO m => WidgetClassUnrealizeFieldCallback -> m (GClosure C_WidgetClassUnrealizeFieldCallback)
genClosure_WidgetClassUnrealizeFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassUnrealizeFieldCallback Nothing cb
    mk_WidgetClassUnrealizeFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassUnrealizeFieldCallback` into a `C_WidgetClassUnrealizeFieldCallback`.
wrap_WidgetClassUnrealizeFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassUnrealizeFieldCallback)) ->
    WidgetClassUnrealizeFieldCallback ->
    C_WidgetClassUnrealizeFieldCallback
wrap_WidgetClassUnrealizeFieldCallback gi'funptrptr gi'cb widget = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    gi'cb  widget'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassUnmapFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a widget" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassUnmapFieldCallback =
    Ptr Gtk.Widget.Widget ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassUnmapFieldCallback :: FunPtr C_WidgetClassUnmapFieldCallback -> C_WidgetClassUnmapFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassUnmapFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassUnmapFieldCallback
    -> a
    -- ^ /@widget@/: a widget
    -> m ()
dynamic_WidgetClassUnmapFieldCallback __funPtr widget = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    (__dynamic_C_WidgetClassUnmapFieldCallback __funPtr) widget'
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassUnmapFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassUnmapFieldCallback :: C_WidgetClassUnmapFieldCallback -> IO (FunPtr C_WidgetClassUnmapFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassUnmapFieldCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: a widget
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassUnmapFieldCallback`@.
noWidgetClassUnmapFieldCallback :: Maybe WidgetClassUnmapFieldCallback
noWidgetClassUnmapFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassUnmapFieldCallback :: MonadIO m => WidgetClassUnmapFieldCallback -> m (GClosure C_WidgetClassUnmapFieldCallback)
genClosure_WidgetClassUnmapFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassUnmapFieldCallback Nothing cb
    mk_WidgetClassUnmapFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassUnmapFieldCallback` into a `C_WidgetClassUnmapFieldCallback`.
wrap_WidgetClassUnmapFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassUnmapFieldCallback)) ->
    WidgetClassUnmapFieldCallback ->
    C_WidgetClassUnmapFieldCallback
wrap_WidgetClassUnmapFieldCallback gi'funptrptr gi'cb widget = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    gi'cb  widget'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassSystemSettingChangedFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "settings"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "SystemSetting" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassSystemSettingChangedFieldCallback =
    Ptr Gtk.Widget.Widget ->
    CUInt ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "settings"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SystemSetting" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassSystemSettingChangedFieldCallback :: FunPtr C_WidgetClassSystemSettingChangedFieldCallback -> C_WidgetClassSystemSettingChangedFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassSystemSettingChangedFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassSystemSettingChangedFieldCallback
    -> a
    -> Gtk.Enums.SystemSetting
    -> m ()
dynamic_WidgetClassSystemSettingChangedFieldCallback __funPtr widget settings = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    let settings' = (fromIntegral . fromEnum) settings
    (__dynamic_C_WidgetClassSystemSettingChangedFieldCallback __funPtr) widget' settings'
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassSystemSettingChangedFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassSystemSettingChangedFieldCallback :: C_WidgetClassSystemSettingChangedFieldCallback -> IO (FunPtr C_WidgetClassSystemSettingChangedFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassSystemSettingChangedFieldCallback =
    Gtk.Widget.Widget
    -> Gtk.Enums.SystemSetting
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassSystemSettingChangedFieldCallback`@.
noWidgetClassSystemSettingChangedFieldCallback :: Maybe WidgetClassSystemSettingChangedFieldCallback
noWidgetClassSystemSettingChangedFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassSystemSettingChangedFieldCallback :: MonadIO m => WidgetClassSystemSettingChangedFieldCallback -> m (GClosure C_WidgetClassSystemSettingChangedFieldCallback)
genClosure_WidgetClassSystemSettingChangedFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassSystemSettingChangedFieldCallback Nothing cb
    mk_WidgetClassSystemSettingChangedFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassSystemSettingChangedFieldCallback` into a `C_WidgetClassSystemSettingChangedFieldCallback`.
wrap_WidgetClassSystemSettingChangedFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassSystemSettingChangedFieldCallback)) ->
    WidgetClassSystemSettingChangedFieldCallback ->
    C_WidgetClassSystemSettingChangedFieldCallback
wrap_WidgetClassSystemSettingChangedFieldCallback gi'funptrptr gi'cb widget settings = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    let settings' = (toEnum . fromIntegral) settings
    gi'cb  widget' settings'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassStateFlagsChangedFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "previous_state_flags"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "StateFlags" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassStateFlagsChangedFieldCallback =
    Ptr Gtk.Widget.Widget ->
    CUInt ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "previous_state_flags"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StateFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassStateFlagsChangedFieldCallback :: FunPtr C_WidgetClassStateFlagsChangedFieldCallback -> C_WidgetClassStateFlagsChangedFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassStateFlagsChangedFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassStateFlagsChangedFieldCallback
    -> a
    -> [Gtk.Flags.StateFlags]
    -> m ()
dynamic_WidgetClassStateFlagsChangedFieldCallback __funPtr widget previousStateFlags = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    let previousStateFlags' = gflagsToWord previousStateFlags
    (__dynamic_C_WidgetClassStateFlagsChangedFieldCallback __funPtr) widget' previousStateFlags'
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassStateFlagsChangedFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassStateFlagsChangedFieldCallback :: C_WidgetClassStateFlagsChangedFieldCallback -> IO (FunPtr C_WidgetClassStateFlagsChangedFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassStateFlagsChangedFieldCallback =
    Gtk.Widget.Widget
    -> [Gtk.Flags.StateFlags]
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassStateFlagsChangedFieldCallback`@.
noWidgetClassStateFlagsChangedFieldCallback :: Maybe WidgetClassStateFlagsChangedFieldCallback
noWidgetClassStateFlagsChangedFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassStateFlagsChangedFieldCallback :: MonadIO m => WidgetClassStateFlagsChangedFieldCallback -> m (GClosure C_WidgetClassStateFlagsChangedFieldCallback)
genClosure_WidgetClassStateFlagsChangedFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassStateFlagsChangedFieldCallback Nothing cb
    mk_WidgetClassStateFlagsChangedFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassStateFlagsChangedFieldCallback` into a `C_WidgetClassStateFlagsChangedFieldCallback`.
wrap_WidgetClassStateFlagsChangedFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassStateFlagsChangedFieldCallback)) ->
    WidgetClassStateFlagsChangedFieldCallback ->
    C_WidgetClassStateFlagsChangedFieldCallback
wrap_WidgetClassStateFlagsChangedFieldCallback gi'funptrptr gi'cb widget previousStateFlags = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    let previousStateFlags' = wordToGFlags previousStateFlags
    gi'cb  widget' previousStateFlags'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassSnapshotFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "snapshot"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "Snapshot" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassSnapshotFieldCallback =
    Ptr Gtk.Widget.Widget ->
    Ptr Gtk.Snapshot.Snapshot ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "snapshot"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Snapshot" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassSnapshotFieldCallback :: FunPtr C_WidgetClassSnapshotFieldCallback -> C_WidgetClassSnapshotFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassSnapshotFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a, Gtk.Snapshot.IsSnapshot b) =>
    FunPtr C_WidgetClassSnapshotFieldCallback
    -> a
    -> b
    -> m ()
dynamic_WidgetClassSnapshotFieldCallback __funPtr widget snapshot = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    snapshot' <- unsafeManagedPtrCastPtr snapshot
    (__dynamic_C_WidgetClassSnapshotFieldCallback __funPtr) widget' snapshot'
    touchManagedPtr widget
    touchManagedPtr snapshot
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassSnapshotFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassSnapshotFieldCallback :: C_WidgetClassSnapshotFieldCallback -> IO (FunPtr C_WidgetClassSnapshotFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassSnapshotFieldCallback =
    Gtk.Widget.Widget
    -> Gtk.Snapshot.Snapshot
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassSnapshotFieldCallback`@.
noWidgetClassSnapshotFieldCallback :: Maybe WidgetClassSnapshotFieldCallback
noWidgetClassSnapshotFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassSnapshotFieldCallback :: MonadIO m => WidgetClassSnapshotFieldCallback -> m (GClosure C_WidgetClassSnapshotFieldCallback)
genClosure_WidgetClassSnapshotFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassSnapshotFieldCallback Nothing cb
    mk_WidgetClassSnapshotFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassSnapshotFieldCallback` into a `C_WidgetClassSnapshotFieldCallback`.
wrap_WidgetClassSnapshotFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassSnapshotFieldCallback)) ->
    WidgetClassSnapshotFieldCallback ->
    C_WidgetClassSnapshotFieldCallback
wrap_WidgetClassSnapshotFieldCallback gi'funptrptr gi'cb widget snapshot = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    snapshot' <- (newObject Gtk.Snapshot.Snapshot) snapshot
    gi'cb  widget' snapshot'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassSizeAllocateFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "width"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "height"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "baseline"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassSizeAllocateFieldCallback =
    Ptr Gtk.Widget.Widget ->
    Int32 ->
    Int32 ->
    Int32 ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "baseline"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassSizeAllocateFieldCallback :: FunPtr C_WidgetClassSizeAllocateFieldCallback -> C_WidgetClassSizeAllocateFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassSizeAllocateFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassSizeAllocateFieldCallback
    -> a
    -> Int32
    -> Int32
    -> Int32
    -> m ()
dynamic_WidgetClassSizeAllocateFieldCallback __funPtr widget width height baseline = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    (__dynamic_C_WidgetClassSizeAllocateFieldCallback __funPtr) widget' width height baseline
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassSizeAllocateFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassSizeAllocateFieldCallback :: C_WidgetClassSizeAllocateFieldCallback -> IO (FunPtr C_WidgetClassSizeAllocateFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassSizeAllocateFieldCallback =
    Gtk.Widget.Widget
    -> Int32
    -> Int32
    -> Int32
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassSizeAllocateFieldCallback`@.
noWidgetClassSizeAllocateFieldCallback :: Maybe WidgetClassSizeAllocateFieldCallback
noWidgetClassSizeAllocateFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassSizeAllocateFieldCallback :: MonadIO m => WidgetClassSizeAllocateFieldCallback -> m (GClosure C_WidgetClassSizeAllocateFieldCallback)
genClosure_WidgetClassSizeAllocateFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassSizeAllocateFieldCallback Nothing cb
    mk_WidgetClassSizeAllocateFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassSizeAllocateFieldCallback` into a `C_WidgetClassSizeAllocateFieldCallback`.
wrap_WidgetClassSizeAllocateFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassSizeAllocateFieldCallback)) ->
    WidgetClassSizeAllocateFieldCallback ->
    C_WidgetClassSizeAllocateFieldCallback
wrap_WidgetClassSizeAllocateFieldCallback gi'funptrptr gi'cb widget width height baseline = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    gi'cb  widget' width height baseline
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassShowFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a widget" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassShowFieldCallback =
    Ptr Gtk.Widget.Widget ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassShowFieldCallback :: FunPtr C_WidgetClassShowFieldCallback -> C_WidgetClassShowFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassShowFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassShowFieldCallback
    -> a
    -- ^ /@widget@/: a widget
    -> m ()
dynamic_WidgetClassShowFieldCallback __funPtr widget = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    (__dynamic_C_WidgetClassShowFieldCallback __funPtr) widget'
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassShowFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassShowFieldCallback :: C_WidgetClassShowFieldCallback -> IO (FunPtr C_WidgetClassShowFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassShowFieldCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: a widget
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassShowFieldCallback`@.
noWidgetClassShowFieldCallback :: Maybe WidgetClassShowFieldCallback
noWidgetClassShowFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassShowFieldCallback :: MonadIO m => WidgetClassShowFieldCallback -> m (GClosure C_WidgetClassShowFieldCallback)
genClosure_WidgetClassShowFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassShowFieldCallback Nothing cb
    mk_WidgetClassShowFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassShowFieldCallback` into a `C_WidgetClassShowFieldCallback`.
wrap_WidgetClassShowFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassShowFieldCallback)) ->
    WidgetClassShowFieldCallback ->
    C_WidgetClassShowFieldCallback
wrap_WidgetClassShowFieldCallback gi'funptrptr gi'cb widget = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    gi'cb  widget'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassSetFocusChildFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a widget" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "child"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "a direct child widget of @widget\n  or `NULL` to unset the focus child"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassSetFocusChildFieldCallback =
    Ptr Gtk.Widget.Widget ->
    Ptr Gtk.Widget.Widget ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a direct child widget of @widget\n  or `NULL` to unset the focus child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassSetFocusChildFieldCallback :: FunPtr C_WidgetClassSetFocusChildFieldCallback -> C_WidgetClassSetFocusChildFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassSetFocusChildFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a, Gtk.Widget.IsWidget b) =>
    FunPtr C_WidgetClassSetFocusChildFieldCallback
    -> a
    -- ^ /@widget@/: a widget
    -> Maybe (b)
    -- ^ /@child@/: a direct child widget of /@widget@/
    --   or @NULL@ to unset the focus child
    -> m ()
dynamic_WidgetClassSetFocusChildFieldCallback __funPtr widget child = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    (__dynamic_C_WidgetClassSetFocusChildFieldCallback __funPtr) widget' maybeChild
    touchManagedPtr widget
    whenJust child touchManagedPtr
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassSetFocusChildFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassSetFocusChildFieldCallback :: C_WidgetClassSetFocusChildFieldCallback -> IO (FunPtr C_WidgetClassSetFocusChildFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassSetFocusChildFieldCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: a widget
    -> Maybe Gtk.Widget.Widget
    -- ^ /@child@/: a direct child widget of /@widget@/
    --   or @NULL@ to unset the focus child
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassSetFocusChildFieldCallback`@.
noWidgetClassSetFocusChildFieldCallback :: Maybe WidgetClassSetFocusChildFieldCallback
noWidgetClassSetFocusChildFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassSetFocusChildFieldCallback :: MonadIO m => WidgetClassSetFocusChildFieldCallback -> m (GClosure C_WidgetClassSetFocusChildFieldCallback)
genClosure_WidgetClassSetFocusChildFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassSetFocusChildFieldCallback Nothing cb
    mk_WidgetClassSetFocusChildFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassSetFocusChildFieldCallback` into a `C_WidgetClassSetFocusChildFieldCallback`.
wrap_WidgetClassSetFocusChildFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassSetFocusChildFieldCallback)) ->
    WidgetClassSetFocusChildFieldCallback ->
    C_WidgetClassSetFocusChildFieldCallback
wrap_WidgetClassSetFocusChildFieldCallback gi'funptrptr gi'cb widget child = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    maybeChild <-
        if child == FP.nullPtr
        then return Nothing
        else do
            child' <- (newObject Gtk.Widget.Widget) child
            return $ Just child'
    gi'cb  widget' maybeChild
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassRootFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassRootFieldCallback =
    Ptr Gtk.Widget.Widget ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassRootFieldCallback :: FunPtr C_WidgetClassRootFieldCallback -> C_WidgetClassRootFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassRootFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassRootFieldCallback
    -> a
    -> m ()
dynamic_WidgetClassRootFieldCallback __funPtr widget = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    (__dynamic_C_WidgetClassRootFieldCallback __funPtr) widget'
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassRootFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassRootFieldCallback :: C_WidgetClassRootFieldCallback -> IO (FunPtr C_WidgetClassRootFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassRootFieldCallback =
    Gtk.Widget.Widget
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassRootFieldCallback`@.
noWidgetClassRootFieldCallback :: Maybe WidgetClassRootFieldCallback
noWidgetClassRootFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassRootFieldCallback :: MonadIO m => WidgetClassRootFieldCallback -> m (GClosure C_WidgetClassRootFieldCallback)
genClosure_WidgetClassRootFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassRootFieldCallback Nothing cb
    mk_WidgetClassRootFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassRootFieldCallback` into a `C_WidgetClassRootFieldCallback`.
wrap_WidgetClassRootFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassRootFieldCallback)) ->
    WidgetClassRootFieldCallback ->
    C_WidgetClassRootFieldCallback
wrap_WidgetClassRootFieldCallback gi'funptrptr gi'cb widget = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    gi'cb  widget'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassRealizeFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a widget" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassRealizeFieldCallback =
    Ptr Gtk.Widget.Widget ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassRealizeFieldCallback :: FunPtr C_WidgetClassRealizeFieldCallback -> C_WidgetClassRealizeFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassRealizeFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassRealizeFieldCallback
    -> a
    -- ^ /@widget@/: a widget
    -> m ()
dynamic_WidgetClassRealizeFieldCallback __funPtr widget = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    (__dynamic_C_WidgetClassRealizeFieldCallback __funPtr) widget'
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassRealizeFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassRealizeFieldCallback :: C_WidgetClassRealizeFieldCallback -> IO (FunPtr C_WidgetClassRealizeFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassRealizeFieldCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: a widget
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassRealizeFieldCallback`@.
noWidgetClassRealizeFieldCallback :: Maybe WidgetClassRealizeFieldCallback
noWidgetClassRealizeFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassRealizeFieldCallback :: MonadIO m => WidgetClassRealizeFieldCallback -> m (GClosure C_WidgetClassRealizeFieldCallback)
genClosure_WidgetClassRealizeFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassRealizeFieldCallback Nothing cb
    mk_WidgetClassRealizeFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassRealizeFieldCallback` into a `C_WidgetClassRealizeFieldCallback`.
wrap_WidgetClassRealizeFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassRealizeFieldCallback)) ->
    WidgetClassRealizeFieldCallback ->
    C_WidgetClassRealizeFieldCallback
wrap_WidgetClassRealizeFieldCallback gi'funptrptr gi'cb widget = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    gi'cb  widget'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassQueryTooltipFieldCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "x"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "y"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "keyboard_tooltip"
          , argType = TBasicType TBoolean
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "tooltip"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "Tooltip" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassQueryTooltipFieldCallback =
    Ptr Gtk.Widget.Widget ->
    Int32 ->
    Int32 ->
    CInt ->
    Ptr Gtk.Tooltip.Tooltip ->
    IO CInt

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keyboard_tooltip"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tooltip"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Tooltip" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassQueryTooltipFieldCallback :: FunPtr C_WidgetClassQueryTooltipFieldCallback -> C_WidgetClassQueryTooltipFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassQueryTooltipFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a, Gtk.Tooltip.IsTooltip b) =>
    FunPtr C_WidgetClassQueryTooltipFieldCallback
    -> a
    -> Int32
    -> Int32
    -> Bool
    -> b
    -> m Bool
dynamic_WidgetClassQueryTooltipFieldCallback __funPtr widget x y keyboardTooltip tooltip = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    let keyboardTooltip' = (P.fromIntegral . P.fromEnum) keyboardTooltip
    tooltip' <- unsafeManagedPtrCastPtr tooltip
    result <- (__dynamic_C_WidgetClassQueryTooltipFieldCallback __funPtr) widget' x y keyboardTooltip' tooltip'
    let result' = (/= 0) result
    touchManagedPtr widget
    touchManagedPtr tooltip
    return result'

-- | Generate a function pointer callable from C code, from a `C_WidgetClassQueryTooltipFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassQueryTooltipFieldCallback :: C_WidgetClassQueryTooltipFieldCallback -> IO (FunPtr C_WidgetClassQueryTooltipFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassQueryTooltipFieldCallback =
    Gtk.Widget.Widget
    -> Int32
    -> Int32
    -> Bool
    -> Gtk.Tooltip.Tooltip
    -> IO Bool

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassQueryTooltipFieldCallback`@.
noWidgetClassQueryTooltipFieldCallback :: Maybe WidgetClassQueryTooltipFieldCallback
noWidgetClassQueryTooltipFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassQueryTooltipFieldCallback :: MonadIO m => WidgetClassQueryTooltipFieldCallback -> m (GClosure C_WidgetClassQueryTooltipFieldCallback)
genClosure_WidgetClassQueryTooltipFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassQueryTooltipFieldCallback Nothing cb
    mk_WidgetClassQueryTooltipFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassQueryTooltipFieldCallback` into a `C_WidgetClassQueryTooltipFieldCallback`.
wrap_WidgetClassQueryTooltipFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassQueryTooltipFieldCallback)) ->
    WidgetClassQueryTooltipFieldCallback ->
    C_WidgetClassQueryTooltipFieldCallback
wrap_WidgetClassQueryTooltipFieldCallback gi'funptrptr gi'cb widget x y keyboardTooltip tooltip = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    let keyboardTooltip' = (/= 0) keyboardTooltip
    tooltip' <- (newObject Gtk.Tooltip.Tooltip) tooltip
    result <- gi'cb  widget' x y keyboardTooltip' tooltip'
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback WidgetClassMoveFocusFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "direction"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "DirectionType" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassMoveFocusFieldCallback =
    Ptr Gtk.Widget.Widget ->
    CUInt ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "direction"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DirectionType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassMoveFocusFieldCallback :: FunPtr C_WidgetClassMoveFocusFieldCallback -> C_WidgetClassMoveFocusFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassMoveFocusFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassMoveFocusFieldCallback
    -> a
    -> Gtk.Enums.DirectionType
    -> m ()
dynamic_WidgetClassMoveFocusFieldCallback __funPtr widget direction = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    let direction' = (fromIntegral . fromEnum) direction
    (__dynamic_C_WidgetClassMoveFocusFieldCallback __funPtr) widget' direction'
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassMoveFocusFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassMoveFocusFieldCallback :: C_WidgetClassMoveFocusFieldCallback -> IO (FunPtr C_WidgetClassMoveFocusFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassMoveFocusFieldCallback =
    Gtk.Widget.Widget
    -> Gtk.Enums.DirectionType
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassMoveFocusFieldCallback`@.
noWidgetClassMoveFocusFieldCallback :: Maybe WidgetClassMoveFocusFieldCallback
noWidgetClassMoveFocusFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassMoveFocusFieldCallback :: MonadIO m => WidgetClassMoveFocusFieldCallback -> m (GClosure C_WidgetClassMoveFocusFieldCallback)
genClosure_WidgetClassMoveFocusFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassMoveFocusFieldCallback Nothing cb
    mk_WidgetClassMoveFocusFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassMoveFocusFieldCallback` into a `C_WidgetClassMoveFocusFieldCallback`.
wrap_WidgetClassMoveFocusFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassMoveFocusFieldCallback)) ->
    WidgetClassMoveFocusFieldCallback ->
    C_WidgetClassMoveFocusFieldCallback
wrap_WidgetClassMoveFocusFieldCallback gi'funptrptr gi'cb widget direction = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    let direction' = (toEnum . fromIntegral) direction
    gi'cb  widget' direction'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassMnemonicActivateFieldCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "true if the signal has been handled"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a widget" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "group_cycling"
          , argType = TBasicType TBoolean
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "true if there are other widgets with the same mnemonic"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassMnemonicActivateFieldCallback =
    Ptr Gtk.Widget.Widget ->
    CInt ->
    IO CInt

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "group_cycling"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "true if there are other widgets with the same mnemonic"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassMnemonicActivateFieldCallback :: FunPtr C_WidgetClassMnemonicActivateFieldCallback -> C_WidgetClassMnemonicActivateFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassMnemonicActivateFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassMnemonicActivateFieldCallback
    -> a
    -- ^ /@widget@/: a widget
    -> Bool
    -- ^ /@groupCycling@/: true if there are other widgets with the same mnemonic
    -> m Bool
    -- ^ __Returns:__ true if the signal has been handled
dynamic_WidgetClassMnemonicActivateFieldCallback __funPtr widget groupCycling = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    let groupCycling' = (P.fromIntegral . P.fromEnum) groupCycling
    result <- (__dynamic_C_WidgetClassMnemonicActivateFieldCallback __funPtr) widget' groupCycling'
    let result' = (/= 0) result
    touchManagedPtr widget
    return result'

-- | Generate a function pointer callable from C code, from a `C_WidgetClassMnemonicActivateFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassMnemonicActivateFieldCallback :: C_WidgetClassMnemonicActivateFieldCallback -> IO (FunPtr C_WidgetClassMnemonicActivateFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassMnemonicActivateFieldCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: a widget
    -> Bool
    -- ^ /@groupCycling@/: true if there are other widgets with the same mnemonic
    -> IO Bool
    -- ^ __Returns:__ true if the signal has been handled

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassMnemonicActivateFieldCallback`@.
noWidgetClassMnemonicActivateFieldCallback :: Maybe WidgetClassMnemonicActivateFieldCallback
noWidgetClassMnemonicActivateFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassMnemonicActivateFieldCallback :: MonadIO m => WidgetClassMnemonicActivateFieldCallback -> m (GClosure C_WidgetClassMnemonicActivateFieldCallback)
genClosure_WidgetClassMnemonicActivateFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassMnemonicActivateFieldCallback Nothing cb
    mk_WidgetClassMnemonicActivateFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassMnemonicActivateFieldCallback` into a `C_WidgetClassMnemonicActivateFieldCallback`.
wrap_WidgetClassMnemonicActivateFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassMnemonicActivateFieldCallback)) ->
    WidgetClassMnemonicActivateFieldCallback ->
    C_WidgetClassMnemonicActivateFieldCallback
wrap_WidgetClassMnemonicActivateFieldCallback gi'funptrptr gi'cb widget groupCycling = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    let groupCycling' = (/= 0) groupCycling
    result <- gi'cb  widget' groupCycling'
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback WidgetClassMeasureFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A `GtkWidget` instance"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "orientation"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "Orientation" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the orientation to measure"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "for_size"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "Size for the opposite of @orientation, i.e.\n  if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is\n  the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL\n  case is analogous. This way, both height-for-width and width-for-height\n  requests can be implemented. If no size is known, -1 can be passed."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "minimum"
          , argType = TBasicType TInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "location to store the minimum size"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "natural"
          , argType = TBasicType TInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "location to store the natural size"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "minimum_baseline"
          , argType = TBasicType TInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "location to store the baseline\n  position for the minimum size, or -1 to report no baseline"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "natural_baseline"
          , argType = TBasicType TInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "location to store the baseline\n  position for the natural size, or -1 to report no baseline"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassMeasureFieldCallback =
    Ptr Gtk.Widget.Widget ->
    CUInt ->
    Int32 ->
    Ptr Int32 ->
    Ptr Int32 ->
    Ptr Int32 ->
    Ptr Int32 ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkWidget` instance"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "orientation"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Orientation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the orientation to measure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "for_size"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Size for the opposite of @orientation, i.e.\n  if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is\n  the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL\n  case is analogous. This way, both height-for-width and width-for-height\n  requests can be implemented. If no size is known, -1 can be passed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "minimum"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the minimum size"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "natural"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the natural size"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "minimum_baseline"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the baseline\n  position for the minimum size, or -1 to report no baseline"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "natural_baseline"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the baseline\n  position for the natural size, or -1 to report no baseline"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassMeasureFieldCallback :: FunPtr C_WidgetClassMeasureFieldCallback -> C_WidgetClassMeasureFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassMeasureFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassMeasureFieldCallback
    -> a
    -- ^ /@widget@/: A @GtkWidget@ instance
    -> Gtk.Enums.Orientation
    -- ^ /@orientation@/: the orientation to measure
    -> Int32
    -- ^ /@forSize@/: Size for the opposite of /@orientation@/, i.e.
    --   if /@orientation@/ is 'GI.Gtk.Enums.OrientationHorizontal', this is
    --   the height the widget should be measured with. The 'GI.Gtk.Enums.OrientationVertical'
    --   case is analogous. This way, both height-for-width and width-for-height
    --   requests can be implemented. If no size is known, -1 can be passed.
    -> m ((Int32, Int32, Int32, Int32))
dynamic_WidgetClassMeasureFieldCallback __funPtr widget orientation forSize = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    let orientation' = (fromIntegral . fromEnum) orientation
    minimum <- allocMem :: IO (Ptr Int32)
    natural <- allocMem :: IO (Ptr Int32)
    minimumBaseline <- allocMem :: IO (Ptr Int32)
    naturalBaseline <- allocMem :: IO (Ptr Int32)
    (__dynamic_C_WidgetClassMeasureFieldCallback __funPtr) widget' orientation' forSize minimum natural minimumBaseline naturalBaseline
    minimum' <- peek minimum
    natural' <- peek natural
    minimumBaseline' <- peek minimumBaseline
    naturalBaseline' <- peek naturalBaseline
    touchManagedPtr widget
    freeMem minimum
    freeMem natural
    freeMem minimumBaseline
    freeMem naturalBaseline
    return (minimum', natural', minimumBaseline', naturalBaseline')

-- | Generate a function pointer callable from C code, from a `C_WidgetClassMeasureFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassMeasureFieldCallback :: C_WidgetClassMeasureFieldCallback -> IO (FunPtr C_WidgetClassMeasureFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassMeasureFieldCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: A @GtkWidget@ instance
    -> Gtk.Enums.Orientation
    -- ^ /@orientation@/: the orientation to measure
    -> Int32
    -- ^ /@forSize@/: Size for the opposite of /@orientation@/, i.e.
    --   if /@orientation@/ is 'GI.Gtk.Enums.OrientationHorizontal', this is
    --   the height the widget should be measured with. The 'GI.Gtk.Enums.OrientationVertical'
    --   case is analogous. This way, both height-for-width and width-for-height
    --   requests can be implemented. If no size is known, -1 can be passed.
    -> IO ((Int32, Int32, Int32, Int32))

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassMeasureFieldCallback`@.
noWidgetClassMeasureFieldCallback :: Maybe WidgetClassMeasureFieldCallback
noWidgetClassMeasureFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassMeasureFieldCallback :: MonadIO m => WidgetClassMeasureFieldCallback -> m (GClosure C_WidgetClassMeasureFieldCallback)
genClosure_WidgetClassMeasureFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassMeasureFieldCallback Nothing cb
    mk_WidgetClassMeasureFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassMeasureFieldCallback` into a `C_WidgetClassMeasureFieldCallback`.
wrap_WidgetClassMeasureFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassMeasureFieldCallback)) ->
    WidgetClassMeasureFieldCallback ->
    C_WidgetClassMeasureFieldCallback
wrap_WidgetClassMeasureFieldCallback gi'funptrptr gi'cb widget orientation forSize minimum natural minimumBaseline naturalBaseline = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    let orientation' = (toEnum . fromIntegral) orientation
    (outminimum, outnatural, outminimumBaseline, outnaturalBaseline) <- gi'cb  widget' orientation' forSize
    poke minimum outminimum
    poke natural outnatural
    poke minimumBaseline outminimumBaseline
    poke naturalBaseline outnaturalBaseline
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassMapFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a widget" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassMapFieldCallback =
    Ptr Gtk.Widget.Widget ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassMapFieldCallback :: FunPtr C_WidgetClassMapFieldCallback -> C_WidgetClassMapFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassMapFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassMapFieldCallback
    -> a
    -- ^ /@widget@/: a widget
    -> m ()
dynamic_WidgetClassMapFieldCallback __funPtr widget = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    (__dynamic_C_WidgetClassMapFieldCallback __funPtr) widget'
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassMapFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassMapFieldCallback :: C_WidgetClassMapFieldCallback -> IO (FunPtr C_WidgetClassMapFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassMapFieldCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: a widget
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassMapFieldCallback`@.
noWidgetClassMapFieldCallback :: Maybe WidgetClassMapFieldCallback
noWidgetClassMapFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassMapFieldCallback :: MonadIO m => WidgetClassMapFieldCallback -> m (GClosure C_WidgetClassMapFieldCallback)
genClosure_WidgetClassMapFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassMapFieldCallback Nothing cb
    mk_WidgetClassMapFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassMapFieldCallback` into a `C_WidgetClassMapFieldCallback`.
wrap_WidgetClassMapFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassMapFieldCallback)) ->
    WidgetClassMapFieldCallback ->
    C_WidgetClassMapFieldCallback
wrap_WidgetClassMapFieldCallback gi'funptrptr gi'cb widget = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    gi'cb  widget'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassKeynavFailedFieldCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "true if stopping keyboard navigation is fine, false\n  if the emitting widget should try to handle the keyboard\n  navigation attempt in its parent widget"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a widget" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "direction"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "DirectionType" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "direction of focus movement"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassKeynavFailedFieldCallback =
    Ptr Gtk.Widget.Widget ->
    CUInt ->
    IO CInt

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "direction"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DirectionType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "direction of focus movement"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassKeynavFailedFieldCallback :: FunPtr C_WidgetClassKeynavFailedFieldCallback -> C_WidgetClassKeynavFailedFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassKeynavFailedFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassKeynavFailedFieldCallback
    -> a
    -- ^ /@widget@/: a widget
    -> Gtk.Enums.DirectionType
    -- ^ /@direction@/: direction of focus movement
    -> m Bool
    -- ^ __Returns:__ true if stopping keyboard navigation is fine, false
    --   if the emitting widget should try to handle the keyboard
    --   navigation attempt in its parent widget
dynamic_WidgetClassKeynavFailedFieldCallback __funPtr widget direction = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    let direction' = (fromIntegral . fromEnum) direction
    result <- (__dynamic_C_WidgetClassKeynavFailedFieldCallback __funPtr) widget' direction'
    let result' = (/= 0) result
    touchManagedPtr widget
    return result'

-- | Generate a function pointer callable from C code, from a `C_WidgetClassKeynavFailedFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassKeynavFailedFieldCallback :: C_WidgetClassKeynavFailedFieldCallback -> IO (FunPtr C_WidgetClassKeynavFailedFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassKeynavFailedFieldCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: a widget
    -> Gtk.Enums.DirectionType
    -- ^ /@direction@/: direction of focus movement
    -> IO Bool
    -- ^ __Returns:__ true if stopping keyboard navigation is fine, false
    --   if the emitting widget should try to handle the keyboard
    --   navigation attempt in its parent widget

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassKeynavFailedFieldCallback`@.
noWidgetClassKeynavFailedFieldCallback :: Maybe WidgetClassKeynavFailedFieldCallback
noWidgetClassKeynavFailedFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassKeynavFailedFieldCallback :: MonadIO m => WidgetClassKeynavFailedFieldCallback -> m (GClosure C_WidgetClassKeynavFailedFieldCallback)
genClosure_WidgetClassKeynavFailedFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassKeynavFailedFieldCallback Nothing cb
    mk_WidgetClassKeynavFailedFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassKeynavFailedFieldCallback` into a `C_WidgetClassKeynavFailedFieldCallback`.
wrap_WidgetClassKeynavFailedFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassKeynavFailedFieldCallback)) ->
    WidgetClassKeynavFailedFieldCallback ->
    C_WidgetClassKeynavFailedFieldCallback
wrap_WidgetClassKeynavFailedFieldCallback gi'funptrptr gi'cb widget direction = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    let direction' = (toEnum . fromIntegral) direction
    result <- gi'cb  widget' direction'
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback WidgetClassHideFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a widget" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassHideFieldCallback =
    Ptr Gtk.Widget.Widget ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassHideFieldCallback :: FunPtr C_WidgetClassHideFieldCallback -> C_WidgetClassHideFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassHideFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassHideFieldCallback
    -> a
    -- ^ /@widget@/: a widget
    -> m ()
dynamic_WidgetClassHideFieldCallback __funPtr widget = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    (__dynamic_C_WidgetClassHideFieldCallback __funPtr) widget'
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassHideFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassHideFieldCallback :: C_WidgetClassHideFieldCallback -> IO (FunPtr C_WidgetClassHideFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassHideFieldCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: a widget
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassHideFieldCallback`@.
noWidgetClassHideFieldCallback :: Maybe WidgetClassHideFieldCallback
noWidgetClassHideFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassHideFieldCallback :: MonadIO m => WidgetClassHideFieldCallback -> m (GClosure C_WidgetClassHideFieldCallback)
genClosure_WidgetClassHideFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassHideFieldCallback Nothing cb
    mk_WidgetClassHideFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassHideFieldCallback` into a `C_WidgetClassHideFieldCallback`.
wrap_WidgetClassHideFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassHideFieldCallback)) ->
    WidgetClassHideFieldCallback ->
    C_WidgetClassHideFieldCallback
wrap_WidgetClassHideFieldCallback gi'funptrptr gi'cb widget = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    gi'cb  widget'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassGrabFocusFieldCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "true if focus is now inside @widget"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a widget" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassGrabFocusFieldCallback =
    Ptr Gtk.Widget.Widget ->
    IO CInt

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassGrabFocusFieldCallback :: FunPtr C_WidgetClassGrabFocusFieldCallback -> C_WidgetClassGrabFocusFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassGrabFocusFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassGrabFocusFieldCallback
    -> a
    -- ^ /@widget@/: a widget
    -> m Bool
    -- ^ __Returns:__ true if focus is now inside /@widget@/
dynamic_WidgetClassGrabFocusFieldCallback __funPtr widget = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    result <- (__dynamic_C_WidgetClassGrabFocusFieldCallback __funPtr) widget'
    let result' = (/= 0) result
    touchManagedPtr widget
    return result'

-- | Generate a function pointer callable from C code, from a `C_WidgetClassGrabFocusFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassGrabFocusFieldCallback :: C_WidgetClassGrabFocusFieldCallback -> IO (FunPtr C_WidgetClassGrabFocusFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassGrabFocusFieldCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: a widget
    -> IO Bool
    -- ^ __Returns:__ true if focus is now inside /@widget@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassGrabFocusFieldCallback`@.
noWidgetClassGrabFocusFieldCallback :: Maybe WidgetClassGrabFocusFieldCallback
noWidgetClassGrabFocusFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassGrabFocusFieldCallback :: MonadIO m => WidgetClassGrabFocusFieldCallback -> m (GClosure C_WidgetClassGrabFocusFieldCallback)
genClosure_WidgetClassGrabFocusFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassGrabFocusFieldCallback Nothing cb
    mk_WidgetClassGrabFocusFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassGrabFocusFieldCallback` into a `C_WidgetClassGrabFocusFieldCallback`.
wrap_WidgetClassGrabFocusFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassGrabFocusFieldCallback)) ->
    WidgetClassGrabFocusFieldCallback ->
    C_WidgetClassGrabFocusFieldCallback
wrap_WidgetClassGrabFocusFieldCallback gi'funptrptr gi'cb widget = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    result <- gi'cb  widget'
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback WidgetClassGetRequestModeFieldCallback
{- Callable
  { returnType =
      Just
        (TInterface Name { namespace = "Gtk" , name = "SizeRequestMode" })
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "The `GtkSizeRequestMode` preferred by @widget."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `GtkWidget` instance"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassGetRequestModeFieldCallback =
    Ptr Gtk.Widget.Widget ->
    IO CUInt

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget` instance"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SizeRequestMode" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassGetRequestModeFieldCallback :: FunPtr C_WidgetClassGetRequestModeFieldCallback -> C_WidgetClassGetRequestModeFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassGetRequestModeFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassGetRequestModeFieldCallback
    -> a
    -- ^ /@widget@/: a @GtkWidget@ instance
    -> m Gtk.Enums.SizeRequestMode
    -- ^ __Returns:__ The @GtkSizeRequestMode@ preferred by /@widget@/.
dynamic_WidgetClassGetRequestModeFieldCallback __funPtr widget = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    result <- (__dynamic_C_WidgetClassGetRequestModeFieldCallback __funPtr) widget'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr widget
    return result'

-- | Generate a function pointer callable from C code, from a `C_WidgetClassGetRequestModeFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassGetRequestModeFieldCallback :: C_WidgetClassGetRequestModeFieldCallback -> IO (FunPtr C_WidgetClassGetRequestModeFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassGetRequestModeFieldCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: a @GtkWidget@ instance
    -> IO Gtk.Enums.SizeRequestMode
    -- ^ __Returns:__ The @GtkSizeRequestMode@ preferred by /@widget@/.

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassGetRequestModeFieldCallback`@.
noWidgetClassGetRequestModeFieldCallback :: Maybe WidgetClassGetRequestModeFieldCallback
noWidgetClassGetRequestModeFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassGetRequestModeFieldCallback :: MonadIO m => WidgetClassGetRequestModeFieldCallback -> m (GClosure C_WidgetClassGetRequestModeFieldCallback)
genClosure_WidgetClassGetRequestModeFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassGetRequestModeFieldCallback Nothing cb
    mk_WidgetClassGetRequestModeFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassGetRequestModeFieldCallback` into a `C_WidgetClassGetRequestModeFieldCallback`.
wrap_WidgetClassGetRequestModeFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassGetRequestModeFieldCallback)) ->
    WidgetClassGetRequestModeFieldCallback ->
    C_WidgetClassGetRequestModeFieldCallback
wrap_WidgetClassGetRequestModeFieldCallback gi'funptrptr gi'cb widget = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    result <- gi'cb  widget'
    maybeReleaseFunPtr gi'funptrptr
    let result' = (fromIntegral . fromEnum) result
    return result'


-- callback WidgetClassFocusFieldCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "direction"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "DirectionType" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassFocusFieldCallback =
    Ptr Gtk.Widget.Widget ->
    CUInt ->
    IO CInt

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "direction"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DirectionType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassFocusFieldCallback :: FunPtr C_WidgetClassFocusFieldCallback -> C_WidgetClassFocusFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassFocusFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassFocusFieldCallback
    -> a
    -> Gtk.Enums.DirectionType
    -> m Bool
dynamic_WidgetClassFocusFieldCallback __funPtr widget direction = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    let direction' = (fromIntegral . fromEnum) direction
    result <- (__dynamic_C_WidgetClassFocusFieldCallback __funPtr) widget' direction'
    let result' = (/= 0) result
    touchManagedPtr widget
    return result'

-- | Generate a function pointer callable from C code, from a `C_WidgetClassFocusFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassFocusFieldCallback :: C_WidgetClassFocusFieldCallback -> IO (FunPtr C_WidgetClassFocusFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassFocusFieldCallback =
    Gtk.Widget.Widget
    -> Gtk.Enums.DirectionType
    -> IO Bool

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassFocusFieldCallback`@.
noWidgetClassFocusFieldCallback :: Maybe WidgetClassFocusFieldCallback
noWidgetClassFocusFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassFocusFieldCallback :: MonadIO m => WidgetClassFocusFieldCallback -> m (GClosure C_WidgetClassFocusFieldCallback)
genClosure_WidgetClassFocusFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassFocusFieldCallback Nothing cb
    mk_WidgetClassFocusFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassFocusFieldCallback` into a `C_WidgetClassFocusFieldCallback`.
wrap_WidgetClassFocusFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassFocusFieldCallback)) ->
    WidgetClassFocusFieldCallback ->
    C_WidgetClassFocusFieldCallback
wrap_WidgetClassFocusFieldCallback gi'funptrptr gi'cb widget direction = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    let direction' = (toEnum . fromIntegral) direction
    result <- gi'cb  widget' direction'
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback WidgetClassDirectionChangedFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "previous_direction"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TextDirection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassDirectionChangedFieldCallback =
    Ptr Gtk.Widget.Widget ->
    CUInt ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "previous_direction"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextDirection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassDirectionChangedFieldCallback :: FunPtr C_WidgetClassDirectionChangedFieldCallback -> C_WidgetClassDirectionChangedFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassDirectionChangedFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassDirectionChangedFieldCallback
    -> a
    -> Gtk.Enums.TextDirection
    -> m ()
dynamic_WidgetClassDirectionChangedFieldCallback __funPtr widget previousDirection = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    let previousDirection' = (fromIntegral . fromEnum) previousDirection
    (__dynamic_C_WidgetClassDirectionChangedFieldCallback __funPtr) widget' previousDirection'
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassDirectionChangedFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassDirectionChangedFieldCallback :: C_WidgetClassDirectionChangedFieldCallback -> IO (FunPtr C_WidgetClassDirectionChangedFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassDirectionChangedFieldCallback =
    Gtk.Widget.Widget
    -> Gtk.Enums.TextDirection
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassDirectionChangedFieldCallback`@.
noWidgetClassDirectionChangedFieldCallback :: Maybe WidgetClassDirectionChangedFieldCallback
noWidgetClassDirectionChangedFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassDirectionChangedFieldCallback :: MonadIO m => WidgetClassDirectionChangedFieldCallback -> m (GClosure C_WidgetClassDirectionChangedFieldCallback)
genClosure_WidgetClassDirectionChangedFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassDirectionChangedFieldCallback Nothing cb
    mk_WidgetClassDirectionChangedFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassDirectionChangedFieldCallback` into a `C_WidgetClassDirectionChangedFieldCallback`.
wrap_WidgetClassDirectionChangedFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassDirectionChangedFieldCallback)) ->
    WidgetClassDirectionChangedFieldCallback ->
    C_WidgetClassDirectionChangedFieldCallback
wrap_WidgetClassDirectionChangedFieldCallback gi'funptrptr gi'cb widget previousDirection = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    let previousDirection' = (toEnum . fromIntegral) previousDirection
    gi'cb  widget' previousDirection'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassCssChangedFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "change"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "CssStyleChange" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassCssChangedFieldCallback =
    Ptr Gtk.Widget.Widget ->
    Ptr Gtk.CssStyleChange.CssStyleChange ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "change"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CssStyleChange" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassCssChangedFieldCallback :: FunPtr C_WidgetClassCssChangedFieldCallback -> C_WidgetClassCssChangedFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassCssChangedFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassCssChangedFieldCallback
    -> a
    -> Gtk.CssStyleChange.CssStyleChange
    -> m ()
dynamic_WidgetClassCssChangedFieldCallback __funPtr widget change = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    change' <- unsafeManagedPtrGetPtr change
    (__dynamic_C_WidgetClassCssChangedFieldCallback __funPtr) widget' change'
    touchManagedPtr widget
    touchManagedPtr change
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassCssChangedFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassCssChangedFieldCallback :: C_WidgetClassCssChangedFieldCallback -> IO (FunPtr C_WidgetClassCssChangedFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassCssChangedFieldCallback =
    Gtk.Widget.Widget
    -> Gtk.CssStyleChange.CssStyleChange
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassCssChangedFieldCallback`@.
noWidgetClassCssChangedFieldCallback :: Maybe WidgetClassCssChangedFieldCallback
noWidgetClassCssChangedFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassCssChangedFieldCallback :: MonadIO m => WidgetClassCssChangedFieldCallback -> m (GClosure C_WidgetClassCssChangedFieldCallback)
genClosure_WidgetClassCssChangedFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassCssChangedFieldCallback Nothing cb
    mk_WidgetClassCssChangedFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassCssChangedFieldCallback` into a `C_WidgetClassCssChangedFieldCallback`.
wrap_WidgetClassCssChangedFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassCssChangedFieldCallback)) ->
    WidgetClassCssChangedFieldCallback ->
    C_WidgetClassCssChangedFieldCallback
wrap_WidgetClassCssChangedFieldCallback gi'funptrptr gi'cb widget change = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    change' <- (newPtr Gtk.CssStyleChange.CssStyleChange) change
    gi'cb  widget' change'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetClassContainsFieldCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "true if @widget contains the point (x, y)"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the widget to query"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "x"
          , argType = TBasicType TDouble
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "X coordinate to test, relative to @widget's origin"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "y"
          , argType = TBasicType TDouble
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "Y coordinate to test, relative to @widget's origin"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassContainsFieldCallback =
    Ptr Gtk.Widget.Widget ->
    CDouble ->
    CDouble ->
    IO CInt

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "X coordinate to test, relative to @widget's origin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Y coordinate to test, relative to @widget's origin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassContainsFieldCallback :: FunPtr C_WidgetClassContainsFieldCallback -> C_WidgetClassContainsFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassContainsFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassContainsFieldCallback
    -> a
    -- ^ /@widget@/: the widget to query
    -> Double
    -- ^ /@x@/: X coordinate to test, relative to /@widget@/\'s origin
    -> Double
    -- ^ /@y@/: Y coordinate to test, relative to /@widget@/\'s origin
    -> m Bool
    -- ^ __Returns:__ true if /@widget@/ contains the point (x, y)
dynamic_WidgetClassContainsFieldCallback __funPtr widget x y = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    let x' = realToFrac x
    let y' = realToFrac y
    result <- (__dynamic_C_WidgetClassContainsFieldCallback __funPtr) widget' x' y'
    let result' = (/= 0) result
    touchManagedPtr widget
    return result'

-- | Generate a function pointer callable from C code, from a `C_WidgetClassContainsFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassContainsFieldCallback :: C_WidgetClassContainsFieldCallback -> IO (FunPtr C_WidgetClassContainsFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassContainsFieldCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: the widget to query
    -> Double
    -- ^ /@x@/: X coordinate to test, relative to /@widget@/\'s origin
    -> Double
    -- ^ /@y@/: Y coordinate to test, relative to /@widget@/\'s origin
    -> IO Bool
    -- ^ __Returns:__ true if /@widget@/ contains the point (x, y)

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassContainsFieldCallback`@.
noWidgetClassContainsFieldCallback :: Maybe WidgetClassContainsFieldCallback
noWidgetClassContainsFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassContainsFieldCallback :: MonadIO m => WidgetClassContainsFieldCallback -> m (GClosure C_WidgetClassContainsFieldCallback)
genClosure_WidgetClassContainsFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassContainsFieldCallback Nothing cb
    mk_WidgetClassContainsFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassContainsFieldCallback` into a `C_WidgetClassContainsFieldCallback`.
wrap_WidgetClassContainsFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassContainsFieldCallback)) ->
    WidgetClassContainsFieldCallback ->
    C_WidgetClassContainsFieldCallback
wrap_WidgetClassContainsFieldCallback gi'funptrptr gi'cb widget x y = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    let x' = realToFrac x
    let y' = realToFrac y
    result <- gi'cb  widget' x' y'
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback WidgetClassComputeExpandFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "hexpand_p"
          , argType = TBasicType TBoolean
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "vexpand_p"
          , argType = TBasicType TBoolean
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetClassComputeExpandFieldCallback =
    Ptr Gtk.Widget.Widget ->
    CInt ->
    CInt ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hexpand_p"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "vexpand_p"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetClassComputeExpandFieldCallback :: FunPtr C_WidgetClassComputeExpandFieldCallback -> C_WidgetClassComputeExpandFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetClassComputeExpandFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetClassComputeExpandFieldCallback
    -> a
    -> Bool
    -> Bool
    -> m ()
dynamic_WidgetClassComputeExpandFieldCallback __funPtr widget hexpandP vexpandP = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    let hexpandP' = (P.fromIntegral . P.fromEnum) hexpandP
    let vexpandP' = (P.fromIntegral . P.fromEnum) vexpandP
    (__dynamic_C_WidgetClassComputeExpandFieldCallback __funPtr) widget' hexpandP' vexpandP'
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetClassComputeExpandFieldCallback`.
foreign import ccall "wrapper"
    mk_WidgetClassComputeExpandFieldCallback :: C_WidgetClassComputeExpandFieldCallback -> IO (FunPtr C_WidgetClassComputeExpandFieldCallback)

-- | /No description available in the introspection data./
type WidgetClassComputeExpandFieldCallback =
    Gtk.Widget.Widget
    -> Bool
    -> Bool
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetClassComputeExpandFieldCallback`@.
noWidgetClassComputeExpandFieldCallback :: Maybe WidgetClassComputeExpandFieldCallback
noWidgetClassComputeExpandFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetClassComputeExpandFieldCallback :: MonadIO m => WidgetClassComputeExpandFieldCallback -> m (GClosure C_WidgetClassComputeExpandFieldCallback)
genClosure_WidgetClassComputeExpandFieldCallback cb = liftIO $ do
    let cb' = wrap_WidgetClassComputeExpandFieldCallback Nothing cb
    mk_WidgetClassComputeExpandFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetClassComputeExpandFieldCallback` into a `C_WidgetClassComputeExpandFieldCallback`.
wrap_WidgetClassComputeExpandFieldCallback :: 
    Maybe (Ptr (FunPtr C_WidgetClassComputeExpandFieldCallback)) ->
    WidgetClassComputeExpandFieldCallback ->
    C_WidgetClassComputeExpandFieldCallback
wrap_WidgetClassComputeExpandFieldCallback gi'funptrptr gi'cb widget hexpandP vexpandP = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    let hexpandP' = (/= 0) hexpandP
    let vexpandP' = (/= 0) vexpandP
    gi'cb  widget' hexpandP' vexpandP'
    maybeReleaseFunPtr gi'funptrptr


-- callback WidgetActionActivateFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the widget to which the action belongs"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "action_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the action name" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "parameter"
          , argType = TVariant
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "parameter for activation"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of the callback functions used for activating\nactions installed with [method@Gtk.WidgetClass.install_action].\n\nThe @parameter must match the @parameter_type of the action."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_WidgetActionActivateFunc =
    Ptr Gtk.Widget.Widget ->
    CString ->
    Ptr GVariant ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to which the action belongs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "action_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the action name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parameter"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "parameter for activation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_WidgetActionActivateFunc :: FunPtr C_WidgetActionActivateFunc -> C_WidgetActionActivateFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_WidgetActionActivateFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_WidgetActionActivateFunc
    -> a
    -- ^ /@widget@/: the widget to which the action belongs
    -> T.Text
    -- ^ /@actionName@/: the action name
    -> Maybe (GVariant)
    -- ^ /@parameter@/: parameter for activation
    -> m ()
dynamic_WidgetActionActivateFunc __funPtr widget actionName parameter = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    actionName' <- textToCString actionName
    maybeParameter <- case parameter of
        Nothing -> return FP.nullPtr
        Just jParameter -> do
            jParameter' <- unsafeManagedPtrGetPtr jParameter
            return jParameter'
    (__dynamic_C_WidgetActionActivateFunc __funPtr) widget' actionName' maybeParameter
    touchManagedPtr widget
    whenJust parameter touchManagedPtr
    freeMem actionName'
    return ()

-- | Generate a function pointer callable from C code, from a `C_WidgetActionActivateFunc`.
foreign import ccall "wrapper"
    mk_WidgetActionActivateFunc :: C_WidgetActionActivateFunc -> IO (FunPtr C_WidgetActionActivateFunc)

-- | The type of the callback functions used for activating
-- actions installed with 'GI.Gtk.Structs.WidgetClass.widgetClassInstallAction'.
-- 
-- The /@parameter@/ must match the /@parameterType@/ of the action.
type WidgetActionActivateFunc =
    Gtk.Widget.Widget
    -- ^ /@widget@/: the widget to which the action belongs
    -> T.Text
    -- ^ /@actionName@/: the action name
    -> Maybe GVariant
    -- ^ /@parameter@/: parameter for activation
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `WidgetActionActivateFunc`@.
noWidgetActionActivateFunc :: Maybe WidgetActionActivateFunc
noWidgetActionActivateFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_WidgetActionActivateFunc :: MonadIO m => WidgetActionActivateFunc -> m (GClosure C_WidgetActionActivateFunc)
genClosure_WidgetActionActivateFunc cb = liftIO $ do
    let cb' = wrap_WidgetActionActivateFunc Nothing cb
    mk_WidgetActionActivateFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `WidgetActionActivateFunc` into a `C_WidgetActionActivateFunc`.
wrap_WidgetActionActivateFunc :: 
    Maybe (Ptr (FunPtr C_WidgetActionActivateFunc)) ->
    WidgetActionActivateFunc ->
    C_WidgetActionActivateFunc
wrap_WidgetActionActivateFunc gi'funptrptr gi'cb widget actionName parameter = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    actionName' <- cstringToText actionName
    maybeParameter <-
        if parameter == FP.nullPtr
        then return Nothing
        else do
            parameter' <- B.GVariant.newGVariantFromPtr parameter
            return $ Just parameter'
    gi'cb  widget' actionName' maybeParameter
    maybeReleaseFunPtr gi'funptrptr


-- callback TreeViewSearchEqualFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%FALSE if the row matches, %TRUE otherwise."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "model"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeModel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the `GtkTreeModel` being searched"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "column"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the search column set by gtk_tree_view_set_search_column()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "key"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the key string to compare with"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "iter"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeIter" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "a `GtkTreeIter` pointing the row of @model that should be compared\n with @key."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "search_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data from gtk_tree_view_set_search_equal_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement."
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function used for checking whether a row in @model matches\na search key string entered by the user. Note the return value\nis reversed from what you would normally expect, though it\nhas some similarity to strcmp() returning 0 for equal strings."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TreeViewSearchEqualFunc =
    Ptr Gtk.TreeModel.TreeModel ->
    Int32 ->
    CString ->
    Ptr Gtk.TreeIter.TreeIter ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkTreeModel` being searched"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the search column set by gtk_tree_view_set_search_column()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the key string to compare with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a `GtkTreeIter` pointing the row of @model that should be compared\n with @key."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "search_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data from gtk_tree_view_set_search_equal_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TreeViewSearchEqualFunc :: FunPtr C_TreeViewSearchEqualFunc -> C_TreeViewSearchEqualFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TreeViewSearchEqualFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeModel.IsTreeModel a) =>
    FunPtr C_TreeViewSearchEqualFunc
    -> a
    -- ^ /@model@/: the @GtkTreeModel@ being searched
    -> Int32
    -- ^ /@column@/: the search column set by 'GI.Gtk.Objects.TreeView.treeViewSetSearchColumn'
    -> T.Text
    -- ^ /@key@/: the key string to compare with
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ pointing the row of /@model@/ that should be compared
    --  with /@key@/.
    -> Ptr ()
    -- ^ /@searchData@/: user data from 'GI.Gtk.Objects.TreeView.treeViewSetSearchEqualFunc'
    -> m Bool
    -- ^ __Returns:__ 'P.False' if the row matches, 'P.True' otherwise.
dynamic_TreeViewSearchEqualFunc __funPtr model column key iter searchData = liftIO $ do
    model' <- unsafeManagedPtrCastPtr model
    key' <- textToCString key
    iter' <- unsafeManagedPtrGetPtr iter
    result <- (__dynamic_C_TreeViewSearchEqualFunc __funPtr) model' column key' iter' searchData
    let result' = (/= 0) result
    touchManagedPtr model
    touchManagedPtr iter
    freeMem key'
    return result'

-- | Generate a function pointer callable from C code, from a `C_TreeViewSearchEqualFunc`.
foreign import ccall "wrapper"
    mk_TreeViewSearchEqualFunc :: C_TreeViewSearchEqualFunc -> IO (FunPtr C_TreeViewSearchEqualFunc)

{-# DEPRECATED TreeViewSearchEqualFunc ["(Since version 4.20)","There is no replacement."] #-}
-- | A function used for checking whether a row in /@model@/ matches
-- a search key string entered by the user. Note the return value
-- is reversed from what you would normally expect, though it
-- has some similarity to @/strcmp()/@ returning 0 for equal strings.
type TreeViewSearchEqualFunc =
    Gtk.TreeModel.TreeModel
    -- ^ /@model@/: the @GtkTreeModel@ being searched
    -> Int32
    -- ^ /@column@/: the search column set by 'GI.Gtk.Objects.TreeView.treeViewSetSearchColumn'
    -> T.Text
    -- ^ /@key@/: the key string to compare with
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ pointing the row of /@model@/ that should be compared
    --  with /@key@/.
    -> IO Bool
    -- ^ __Returns:__ 'P.False' if the row matches, 'P.True' otherwise.

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeViewSearchEqualFunc`@.
noTreeViewSearchEqualFunc :: Maybe TreeViewSearchEqualFunc
noTreeViewSearchEqualFunc = Nothing

-- | A function used for checking whether a row in /@model@/ matches
-- a search key string entered by the user. Note the return value
-- is reversed from what you would normally expect, though it
-- has some similarity to @/strcmp()/@ returning 0 for equal strings.
type TreeViewSearchEqualFunc_WithClosures =
    Gtk.TreeModel.TreeModel
    -- ^ /@model@/: the @GtkTreeModel@ being searched
    -> Int32
    -- ^ /@column@/: the search column set by 'GI.Gtk.Objects.TreeView.treeViewSetSearchColumn'
    -> T.Text
    -- ^ /@key@/: the key string to compare with
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ pointing the row of /@model@/ that should be compared
    --  with /@key@/.
    -> Ptr ()
    -- ^ /@searchData@/: user data from 'GI.Gtk.Objects.TreeView.treeViewSetSearchEqualFunc'
    -> IO Bool
    -- ^ __Returns:__ 'P.False' if the row matches, 'P.True' otherwise.

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeViewSearchEqualFunc_WithClosures`@.
noTreeViewSearchEqualFunc_WithClosures :: Maybe TreeViewSearchEqualFunc_WithClosures
noTreeViewSearchEqualFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TreeViewSearchEqualFunc :: TreeViewSearchEqualFunc -> TreeViewSearchEqualFunc_WithClosures
drop_closures_TreeViewSearchEqualFunc _f model column key iter _ = _f model column key iter

-- | Wrap the callback into a `GClosure`.
genClosure_TreeViewSearchEqualFunc :: MonadIO m => TreeViewSearchEqualFunc -> m (GClosure C_TreeViewSearchEqualFunc)
genClosure_TreeViewSearchEqualFunc cb = liftIO $ do
    let cb' = drop_closures_TreeViewSearchEqualFunc cb
    let cb'' = wrap_TreeViewSearchEqualFunc Nothing cb'
    mk_TreeViewSearchEqualFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TreeViewSearchEqualFunc` into a `C_TreeViewSearchEqualFunc`.
wrap_TreeViewSearchEqualFunc :: 
    Maybe (Ptr (FunPtr C_TreeViewSearchEqualFunc)) ->
    TreeViewSearchEqualFunc_WithClosures ->
    C_TreeViewSearchEqualFunc
wrap_TreeViewSearchEqualFunc gi'funptrptr gi'cb model column key iter searchData = do
    model' <- (newObject Gtk.TreeModel.TreeModel) model
    key' <- cstringToText key
    B.ManagedPtr.withTransient  iter $ \iter' -> do
        result <- gi'cb  model' column key' iter' searchData
        maybeReleaseFunPtr gi'funptrptr
        let result' = (P.fromIntegral . P.fromEnum) result
        return result'


-- callback TreeViewRowSeparatorFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%TRUE if the row is a separator"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "model"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeModel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the `GtkTreeModel`" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "iter"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeIter" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `GtkTreeIter` pointing at a row in @model"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement."
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Function type for determining whether the row pointed to by @iter should\nbe rendered as a separator. A common way to implement this is to have a\nboolean column in the model, whose values the `GtkTreeViewRowSeparatorFunc`\nreturns."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TreeViewRowSeparatorFunc =
    Ptr Gtk.TreeModel.TreeModel ->
    Ptr Gtk.TreeIter.TreeIter ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkTreeModel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeIter` pointing at a row in @model"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TreeViewRowSeparatorFunc :: FunPtr C_TreeViewRowSeparatorFunc -> C_TreeViewRowSeparatorFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TreeViewRowSeparatorFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeModel.IsTreeModel a) =>
    FunPtr C_TreeViewRowSeparatorFunc
    -> a
    -- ^ /@model@/: the @GtkTreeModel@
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ pointing at a row in /@model@/
    -> Ptr ()
    -- ^ /@data@/: user data
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the row is a separator
dynamic_TreeViewRowSeparatorFunc __funPtr model iter data_ = liftIO $ do
    model' <- unsafeManagedPtrCastPtr model
    iter' <- unsafeManagedPtrGetPtr iter
    result <- (__dynamic_C_TreeViewRowSeparatorFunc __funPtr) model' iter' data_
    let result' = (/= 0) result
    touchManagedPtr model
    touchManagedPtr iter
    return result'

-- | Generate a function pointer callable from C code, from a `C_TreeViewRowSeparatorFunc`.
foreign import ccall "wrapper"
    mk_TreeViewRowSeparatorFunc :: C_TreeViewRowSeparatorFunc -> IO (FunPtr C_TreeViewRowSeparatorFunc)

{-# DEPRECATED TreeViewRowSeparatorFunc ["(Since version 4.20)","There is no replacement."] #-}
-- | Function type for determining whether the row pointed to by /@iter@/ should
-- be rendered as a separator. A common way to implement this is to have a
-- boolean column in the model, whose values the @GtkTreeViewRowSeparatorFunc@
-- returns.
type TreeViewRowSeparatorFunc =
    Gtk.TreeModel.TreeModel
    -- ^ /@model@/: the @GtkTreeModel@
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ pointing at a row in /@model@/
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the row is a separator

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeViewRowSeparatorFunc`@.
noTreeViewRowSeparatorFunc :: Maybe TreeViewRowSeparatorFunc
noTreeViewRowSeparatorFunc = Nothing

-- | Function type for determining whether the row pointed to by /@iter@/ should
-- be rendered as a separator. A common way to implement this is to have a
-- boolean column in the model, whose values the @GtkTreeViewRowSeparatorFunc@
-- returns.
type TreeViewRowSeparatorFunc_WithClosures =
    Gtk.TreeModel.TreeModel
    -- ^ /@model@/: the @GtkTreeModel@
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ pointing at a row in /@model@/
    -> Ptr ()
    -- ^ /@data@/: user data
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the row is a separator

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeViewRowSeparatorFunc_WithClosures`@.
noTreeViewRowSeparatorFunc_WithClosures :: Maybe TreeViewRowSeparatorFunc_WithClosures
noTreeViewRowSeparatorFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TreeViewRowSeparatorFunc :: TreeViewRowSeparatorFunc -> TreeViewRowSeparatorFunc_WithClosures
drop_closures_TreeViewRowSeparatorFunc _f model iter _ = _f model iter

-- | Wrap the callback into a `GClosure`.
genClosure_TreeViewRowSeparatorFunc :: MonadIO m => TreeViewRowSeparatorFunc -> m (GClosure C_TreeViewRowSeparatorFunc)
genClosure_TreeViewRowSeparatorFunc cb = liftIO $ do
    let cb' = drop_closures_TreeViewRowSeparatorFunc cb
    let cb'' = wrap_TreeViewRowSeparatorFunc Nothing cb'
    mk_TreeViewRowSeparatorFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TreeViewRowSeparatorFunc` into a `C_TreeViewRowSeparatorFunc`.
wrap_TreeViewRowSeparatorFunc :: 
    Maybe (Ptr (FunPtr C_TreeViewRowSeparatorFunc)) ->
    TreeViewRowSeparatorFunc_WithClosures ->
    C_TreeViewRowSeparatorFunc
wrap_TreeViewRowSeparatorFunc gi'funptrptr gi'cb model iter data_ = do
    model' <- (newObject Gtk.TreeModel.TreeModel) model
    B.ManagedPtr.withTransient  iter $ \iter' -> do
        result <- gi'cb  model' iter' data_
        maybeReleaseFunPtr gi'funptrptr
        let result' = (P.fromIntegral . P.fromEnum) result
        return result'


-- callback TreeViewMappingFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "tree_view"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeView" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A `GtkTreeView`" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "path"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreePath" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The path that\8217s expanded"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement."
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "Function used for gtk_tree_view_map_expanded_rows()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TreeViewMappingFunc =
    Ptr Gtk.TreeView.TreeView ->
    Ptr Gtk.TreePath.TreePath ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "tree_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTreeView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The path that\8217s expanded"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TreeViewMappingFunc :: FunPtr C_TreeViewMappingFunc -> C_TreeViewMappingFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TreeViewMappingFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeView.IsTreeView a) =>
    FunPtr C_TreeViewMappingFunc
    -> a
    -- ^ /@treeView@/: A @GtkTreeView@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The path that’s expanded
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m ()
dynamic_TreeViewMappingFunc __funPtr treeView path userData = liftIO $ do
    treeView' <- unsafeManagedPtrCastPtr treeView
    path' <- unsafeManagedPtrGetPtr path
    (__dynamic_C_TreeViewMappingFunc __funPtr) treeView' path' userData
    touchManagedPtr treeView
    touchManagedPtr path
    return ()

-- | Generate a function pointer callable from C code, from a `C_TreeViewMappingFunc`.
foreign import ccall "wrapper"
    mk_TreeViewMappingFunc :: C_TreeViewMappingFunc -> IO (FunPtr C_TreeViewMappingFunc)

{-# DEPRECATED TreeViewMappingFunc ["(Since version 4.20)","There is no replacement."] #-}
-- | Function used for 'GI.Gtk.Objects.TreeView.treeViewMapExpandedRows'.
type TreeViewMappingFunc =
    Gtk.TreeView.TreeView
    -- ^ /@treeView@/: A @GtkTreeView@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The path that’s expanded
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeViewMappingFunc`@.
noTreeViewMappingFunc :: Maybe TreeViewMappingFunc
noTreeViewMappingFunc = Nothing

-- | Function used for 'GI.Gtk.Objects.TreeView.treeViewMapExpandedRows'.
type TreeViewMappingFunc_WithClosures =
    Gtk.TreeView.TreeView
    -- ^ /@treeView@/: A @GtkTreeView@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The path that’s expanded
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeViewMappingFunc_WithClosures`@.
noTreeViewMappingFunc_WithClosures :: Maybe TreeViewMappingFunc_WithClosures
noTreeViewMappingFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TreeViewMappingFunc :: TreeViewMappingFunc -> TreeViewMappingFunc_WithClosures
drop_closures_TreeViewMappingFunc _f treeView path _ = _f treeView path

-- | Wrap the callback into a `GClosure`.
genClosure_TreeViewMappingFunc :: MonadIO m => TreeViewMappingFunc -> m (GClosure C_TreeViewMappingFunc)
genClosure_TreeViewMappingFunc cb = liftIO $ do
    let cb' = drop_closures_TreeViewMappingFunc cb
    let cb'' = wrap_TreeViewMappingFunc Nothing cb'
    mk_TreeViewMappingFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TreeViewMappingFunc` into a `C_TreeViewMappingFunc`.
wrap_TreeViewMappingFunc :: 
    Maybe (Ptr (FunPtr C_TreeViewMappingFunc)) ->
    TreeViewMappingFunc_WithClosures ->
    C_TreeViewMappingFunc
wrap_TreeViewMappingFunc gi'funptrptr gi'cb treeView path userData = do
    treeView' <- (newObject Gtk.TreeView.TreeView) treeView
    B.ManagedPtr.withTransient  path $ \path' -> do
        gi'cb  treeView' path' userData
        maybeReleaseFunPtr gi'funptrptr


-- callback TreeViewColumnDropFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%TRUE, if @column can be dropped in this spot"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "tree_view"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeView" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A `GtkTreeView`" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "column"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeViewColumn" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The `GtkTreeViewColumn` being dragged"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "prev_column"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeViewColumn" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A `GtkTreeViewColumn` on one side of @column"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "next_column"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeViewColumn" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "A `GtkTreeViewColumn` on the other side of @column"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement."
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Function type for determining whether @column can be dropped in a\nparticular spot (as determined by @prev_column and @next_column).  In\nleft to right locales, @prev_column is on the left of the potential drop\nspot, and @next_column is on the right.  In right to left mode, this is\nreversed.  This function should return %TRUE if the spot is a valid drop\nspot.  Please note that returning %TRUE does not actually indicate that\nthe column drop was made, but is meant only to indicate a possible drop\nspot to the user."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TreeViewColumnDropFunc =
    Ptr Gtk.TreeView.TreeView ->
    Ptr Gtk.TreeViewColumn.TreeViewColumn ->
    Ptr Gtk.TreeViewColumn.TreeViewColumn ->
    Ptr Gtk.TreeViewColumn.TreeViewColumn ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "tree_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTreeView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeViewColumn" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The `GtkTreeViewColumn` being dragged"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "prev_column"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeViewColumn" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTreeViewColumn` on one side of @column"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "next_column"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeViewColumn" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "A `GtkTreeViewColumn` on the other side of @column"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TreeViewColumnDropFunc :: FunPtr C_TreeViewColumnDropFunc -> C_TreeViewColumnDropFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TreeViewColumnDropFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeView.IsTreeView a, Gtk.TreeViewColumn.IsTreeViewColumn b, Gtk.TreeViewColumn.IsTreeViewColumn c, Gtk.TreeViewColumn.IsTreeViewColumn d) =>
    FunPtr C_TreeViewColumnDropFunc
    -> a
    -- ^ /@treeView@/: A @GtkTreeView@
    -> b
    -- ^ /@column@/: The @GtkTreeViewColumn@ being dragged
    -> c
    -- ^ /@prevColumn@/: A @GtkTreeViewColumn@ on one side of /@column@/
    -> d
    -- ^ /@nextColumn@/: A @GtkTreeViewColumn@ on the other side of /@column@/
    -> Ptr ()
    -- ^ /@data@/: user data
    -> m Bool
    -- ^ __Returns:__ 'P.True', if /@column@/ can be dropped in this spot
dynamic_TreeViewColumnDropFunc __funPtr treeView column prevColumn nextColumn data_ = liftIO $ do
    treeView' <- unsafeManagedPtrCastPtr treeView
    column' <- unsafeManagedPtrCastPtr column
    prevColumn' <- unsafeManagedPtrCastPtr prevColumn
    nextColumn' <- unsafeManagedPtrCastPtr nextColumn
    result <- (__dynamic_C_TreeViewColumnDropFunc __funPtr) treeView' column' prevColumn' nextColumn' data_
    let result' = (/= 0) result
    touchManagedPtr treeView
    touchManagedPtr column
    touchManagedPtr prevColumn
    touchManagedPtr nextColumn
    return result'

-- | Generate a function pointer callable from C code, from a `C_TreeViewColumnDropFunc`.
foreign import ccall "wrapper"
    mk_TreeViewColumnDropFunc :: C_TreeViewColumnDropFunc -> IO (FunPtr C_TreeViewColumnDropFunc)

{-# DEPRECATED TreeViewColumnDropFunc ["(Since version 4.20)","There is no replacement."] #-}
-- | Function type for determining whether /@column@/ can be dropped in a
-- particular spot (as determined by /@prevColumn@/ and /@nextColumn@/).  In
-- left to right locales, /@prevColumn@/ is on the left of the potential drop
-- spot, and /@nextColumn@/ is on the right.  In right to left mode, this is
-- reversed.  This function should return 'P.True' if the spot is a valid drop
-- spot.  Please note that returning 'P.True' does not actually indicate that
-- the column drop was made, but is meant only to indicate a possible drop
-- spot to the user.
type TreeViewColumnDropFunc =
    Gtk.TreeView.TreeView
    -- ^ /@treeView@/: A @GtkTreeView@
    -> Gtk.TreeViewColumn.TreeViewColumn
    -- ^ /@column@/: The @GtkTreeViewColumn@ being dragged
    -> Gtk.TreeViewColumn.TreeViewColumn
    -- ^ /@prevColumn@/: A @GtkTreeViewColumn@ on one side of /@column@/
    -> Gtk.TreeViewColumn.TreeViewColumn
    -- ^ /@nextColumn@/: A @GtkTreeViewColumn@ on the other side of /@column@/
    -> IO Bool
    -- ^ __Returns:__ 'P.True', if /@column@/ can be dropped in this spot

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeViewColumnDropFunc`@.
noTreeViewColumnDropFunc :: Maybe TreeViewColumnDropFunc
noTreeViewColumnDropFunc = Nothing

-- | Function type for determining whether /@column@/ can be dropped in a
-- particular spot (as determined by /@prevColumn@/ and /@nextColumn@/).  In
-- left to right locales, /@prevColumn@/ is on the left of the potential drop
-- spot, and /@nextColumn@/ is on the right.  In right to left mode, this is
-- reversed.  This function should return 'P.True' if the spot is a valid drop
-- spot.  Please note that returning 'P.True' does not actually indicate that
-- the column drop was made, but is meant only to indicate a possible drop
-- spot to the user.
type TreeViewColumnDropFunc_WithClosures =
    Gtk.TreeView.TreeView
    -- ^ /@treeView@/: A @GtkTreeView@
    -> Gtk.TreeViewColumn.TreeViewColumn
    -- ^ /@column@/: The @GtkTreeViewColumn@ being dragged
    -> Gtk.TreeViewColumn.TreeViewColumn
    -- ^ /@prevColumn@/: A @GtkTreeViewColumn@ on one side of /@column@/
    -> Gtk.TreeViewColumn.TreeViewColumn
    -- ^ /@nextColumn@/: A @GtkTreeViewColumn@ on the other side of /@column@/
    -> Ptr ()
    -- ^ /@data@/: user data
    -> IO Bool
    -- ^ __Returns:__ 'P.True', if /@column@/ can be dropped in this spot

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeViewColumnDropFunc_WithClosures`@.
noTreeViewColumnDropFunc_WithClosures :: Maybe TreeViewColumnDropFunc_WithClosures
noTreeViewColumnDropFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TreeViewColumnDropFunc :: TreeViewColumnDropFunc -> TreeViewColumnDropFunc_WithClosures
drop_closures_TreeViewColumnDropFunc _f treeView column prevColumn nextColumn _ = _f treeView column prevColumn nextColumn

-- | Wrap the callback into a `GClosure`.
genClosure_TreeViewColumnDropFunc :: MonadIO m => TreeViewColumnDropFunc -> m (GClosure C_TreeViewColumnDropFunc)
genClosure_TreeViewColumnDropFunc cb = liftIO $ do
    let cb' = drop_closures_TreeViewColumnDropFunc cb
    let cb'' = wrap_TreeViewColumnDropFunc Nothing cb'
    mk_TreeViewColumnDropFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TreeViewColumnDropFunc` into a `C_TreeViewColumnDropFunc`.
wrap_TreeViewColumnDropFunc :: 
    Maybe (Ptr (FunPtr C_TreeViewColumnDropFunc)) ->
    TreeViewColumnDropFunc_WithClosures ->
    C_TreeViewColumnDropFunc
wrap_TreeViewColumnDropFunc gi'funptrptr gi'cb treeView column prevColumn nextColumn data_ = do
    treeView' <- (newObject Gtk.TreeView.TreeView) treeView
    column' <- (newObject Gtk.TreeViewColumn.TreeViewColumn) column
    prevColumn' <- (newObject Gtk.TreeViewColumn.TreeViewColumn) prevColumn
    nextColumn' <- (newObject Gtk.TreeViewColumn.TreeViewColumn) nextColumn
    result <- gi'cb  treeView' column' prevColumn' nextColumn' data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback TreeSelectionFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "%TRUE, if the selection state of the row can be toggled"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "selection"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeSelection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A `GtkTreeSelection`"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "model"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeModel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A `GtkTreeModel` being viewed"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "path"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreePath" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The `GtkTreePath` of the row in question"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "path_currently_selected"
          , argType = TBasicType TBoolean
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "%TRUE, if the path is currently selected"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function used by gtk_tree_selection_set_select_function() to filter\nwhether or not a row may be selected. It is called whenever a row's\nstate might change.\n\nA return value of %TRUE indicates to @selection that it is okay to\nchange the selection."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TreeSelectionFunc =
    Ptr Gtk.TreeSelection.TreeSelection ->
    Ptr Gtk.TreeModel.TreeModel ->
    Ptr Gtk.TreePath.TreePath ->
    CInt ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "selection"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeSelection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTreeSelection`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTreeModel` being viewed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The `GtkTreePath` of the row in question"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path_currently_selected"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE, if the path is currently selected"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TreeSelectionFunc :: FunPtr C_TreeSelectionFunc -> C_TreeSelectionFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TreeSelectionFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeSelection.IsTreeSelection a, Gtk.TreeModel.IsTreeModel b) =>
    FunPtr C_TreeSelectionFunc
    -> a
    -- ^ /@selection@/: A @GtkTreeSelection@
    -> b
    -- ^ /@model@/: A @GtkTreeModel@ being viewed
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The @GtkTreePath@ of the row in question
    -> Bool
    -- ^ /@pathCurrentlySelected@/: 'P.True', if the path is currently selected
    -> Ptr ()
    -- ^ /@data@/: user data
    -> m Bool
    -- ^ __Returns:__ 'P.True', if the selection state of the row can be toggled
dynamic_TreeSelectionFunc __funPtr selection model path pathCurrentlySelected data_ = liftIO $ do
    selection' <- unsafeManagedPtrCastPtr selection
    model' <- unsafeManagedPtrCastPtr model
    path' <- unsafeManagedPtrGetPtr path
    let pathCurrentlySelected' = (P.fromIntegral . P.fromEnum) pathCurrentlySelected
    result <- (__dynamic_C_TreeSelectionFunc __funPtr) selection' model' path' pathCurrentlySelected' data_
    let result' = (/= 0) result
    touchManagedPtr selection
    touchManagedPtr model
    touchManagedPtr path
    return result'

-- | Generate a function pointer callable from C code, from a `C_TreeSelectionFunc`.
foreign import ccall "wrapper"
    mk_TreeSelectionFunc :: C_TreeSelectionFunc -> IO (FunPtr C_TreeSelectionFunc)

{-# DEPRECATED TreeSelectionFunc ["(Since version 4.20)","There is no replacement"] #-}
-- | A function used by 'GI.Gtk.Objects.TreeSelection.treeSelectionSetSelectFunction' to filter
-- whether or not a row may be selected. It is called whenever a row\'s
-- state might change.
-- 
-- A return value of 'P.True' indicates to /@selection@/ that it is okay to
-- change the selection.
type TreeSelectionFunc =
    Gtk.TreeSelection.TreeSelection
    -- ^ /@selection@/: A @GtkTreeSelection@
    -> Gtk.TreeModel.TreeModel
    -- ^ /@model@/: A @GtkTreeModel@ being viewed
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The @GtkTreePath@ of the row in question
    -> Bool
    -- ^ /@pathCurrentlySelected@/: 'P.True', if the path is currently selected
    -> IO Bool
    -- ^ __Returns:__ 'P.True', if the selection state of the row can be toggled

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeSelectionFunc`@.
noTreeSelectionFunc :: Maybe TreeSelectionFunc
noTreeSelectionFunc = Nothing

-- | A function used by 'GI.Gtk.Objects.TreeSelection.treeSelectionSetSelectFunction' to filter
-- whether or not a row may be selected. It is called whenever a row\'s
-- state might change.
-- 
-- A return value of 'P.True' indicates to /@selection@/ that it is okay to
-- change the selection.
type TreeSelectionFunc_WithClosures =
    Gtk.TreeSelection.TreeSelection
    -- ^ /@selection@/: A @GtkTreeSelection@
    -> Gtk.TreeModel.TreeModel
    -- ^ /@model@/: A @GtkTreeModel@ being viewed
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The @GtkTreePath@ of the row in question
    -> Bool
    -- ^ /@pathCurrentlySelected@/: 'P.True', if the path is currently selected
    -> Ptr ()
    -- ^ /@data@/: user data
    -> IO Bool
    -- ^ __Returns:__ 'P.True', if the selection state of the row can be toggled

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeSelectionFunc_WithClosures`@.
noTreeSelectionFunc_WithClosures :: Maybe TreeSelectionFunc_WithClosures
noTreeSelectionFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TreeSelectionFunc :: TreeSelectionFunc -> TreeSelectionFunc_WithClosures
drop_closures_TreeSelectionFunc _f selection model path pathCurrentlySelected _ = _f selection model path pathCurrentlySelected

-- | Wrap the callback into a `GClosure`.
genClosure_TreeSelectionFunc :: MonadIO m => TreeSelectionFunc -> m (GClosure C_TreeSelectionFunc)
genClosure_TreeSelectionFunc cb = liftIO $ do
    let cb' = drop_closures_TreeSelectionFunc cb
    let cb'' = wrap_TreeSelectionFunc Nothing cb'
    mk_TreeSelectionFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TreeSelectionFunc` into a `C_TreeSelectionFunc`.
wrap_TreeSelectionFunc :: 
    Maybe (Ptr (FunPtr C_TreeSelectionFunc)) ->
    TreeSelectionFunc_WithClosures ->
    C_TreeSelectionFunc
wrap_TreeSelectionFunc gi'funptrptr gi'cb selection model path pathCurrentlySelected data_ = do
    selection' <- (newObject Gtk.TreeSelection.TreeSelection) selection
    model' <- (newObject Gtk.TreeModel.TreeModel) model
    B.ManagedPtr.withTransient  path $ \path' -> do
        let pathCurrentlySelected' = (/= 0) pathCurrentlySelected
        result <- gi'cb  selection' model' path' pathCurrentlySelected' data_
        maybeReleaseFunPtr gi'funptrptr
        let result' = (P.fromIntegral . P.fromEnum) result
        return result'


-- callback TreeSelectionForeachFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "model"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeModel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The `GtkTreeModel` being viewed"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "path"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreePath" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The `GtkTreePath` of a selected row"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "iter"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeIter" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A `GtkTreeIter` pointing to a selected row"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function used by gtk_tree_selection_selected_foreach() to map all\nselected rows.  It will be called on every selected row in the view."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TreeSelectionForeachFunc =
    Ptr Gtk.TreeModel.TreeModel ->
    Ptr Gtk.TreePath.TreePath ->
    Ptr Gtk.TreeIter.TreeIter ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The `GtkTreeModel` being viewed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The `GtkTreePath` of a selected row"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTreeIter` pointing to a selected row"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TreeSelectionForeachFunc :: FunPtr C_TreeSelectionForeachFunc -> C_TreeSelectionForeachFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TreeSelectionForeachFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeModel.IsTreeModel a) =>
    FunPtr C_TreeSelectionForeachFunc
    -> a
    -- ^ /@model@/: The @GtkTreeModel@ being viewed
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The @GtkTreePath@ of a selected row
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: A @GtkTreeIter@ pointing to a selected row
    -> Ptr ()
    -- ^ /@data@/: user data
    -> m ()
dynamic_TreeSelectionForeachFunc __funPtr model path iter data_ = liftIO $ do
    model' <- unsafeManagedPtrCastPtr model
    path' <- unsafeManagedPtrGetPtr path
    iter' <- unsafeManagedPtrGetPtr iter
    (__dynamic_C_TreeSelectionForeachFunc __funPtr) model' path' iter' data_
    touchManagedPtr model
    touchManagedPtr path
    touchManagedPtr iter
    return ()

-- | Generate a function pointer callable from C code, from a `C_TreeSelectionForeachFunc`.
foreign import ccall "wrapper"
    mk_TreeSelectionForeachFunc :: C_TreeSelectionForeachFunc -> IO (FunPtr C_TreeSelectionForeachFunc)

{-# DEPRECATED TreeSelectionForeachFunc ["(Since version 4.20)","There is no replacement"] #-}
-- | A function used by 'GI.Gtk.Objects.TreeSelection.treeSelectionSelectedForeach' to map all
-- selected rows.  It will be called on every selected row in the view.
type TreeSelectionForeachFunc =
    Gtk.TreeModel.TreeModel
    -- ^ /@model@/: The @GtkTreeModel@ being viewed
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The @GtkTreePath@ of a selected row
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: A @GtkTreeIter@ pointing to a selected row
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeSelectionForeachFunc`@.
noTreeSelectionForeachFunc :: Maybe TreeSelectionForeachFunc
noTreeSelectionForeachFunc = Nothing

-- | A function used by 'GI.Gtk.Objects.TreeSelection.treeSelectionSelectedForeach' to map all
-- selected rows.  It will be called on every selected row in the view.
type TreeSelectionForeachFunc_WithClosures =
    Gtk.TreeModel.TreeModel
    -- ^ /@model@/: The @GtkTreeModel@ being viewed
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The @GtkTreePath@ of a selected row
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: A @GtkTreeIter@ pointing to a selected row
    -> Ptr ()
    -- ^ /@data@/: user data
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeSelectionForeachFunc_WithClosures`@.
noTreeSelectionForeachFunc_WithClosures :: Maybe TreeSelectionForeachFunc_WithClosures
noTreeSelectionForeachFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TreeSelectionForeachFunc :: TreeSelectionForeachFunc -> TreeSelectionForeachFunc_WithClosures
drop_closures_TreeSelectionForeachFunc _f model path iter _ = _f model path iter

-- | Wrap the callback into a `GClosure`.
genClosure_TreeSelectionForeachFunc :: MonadIO m => TreeSelectionForeachFunc -> m (GClosure C_TreeSelectionForeachFunc)
genClosure_TreeSelectionForeachFunc cb = liftIO $ do
    let cb' = drop_closures_TreeSelectionForeachFunc cb
    let cb'' = wrap_TreeSelectionForeachFunc Nothing cb'
    mk_TreeSelectionForeachFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TreeSelectionForeachFunc` into a `C_TreeSelectionForeachFunc`.
wrap_TreeSelectionForeachFunc :: 
    Maybe (Ptr (FunPtr C_TreeSelectionForeachFunc)) ->
    TreeSelectionForeachFunc_WithClosures ->
    C_TreeSelectionForeachFunc
wrap_TreeSelectionForeachFunc gi'funptrptr gi'cb model path iter data_ = do
    model' <- (newObject Gtk.TreeModel.TreeModel) model
    B.ManagedPtr.withTransient  path $ \path' -> do
        B.ManagedPtr.withTransient  iter $ \iter' -> do
            gi'cb  model' path' iter' data_
            maybeReleaseFunPtr gi'funptrptr


-- callback TreeModelForeachFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%TRUE to stop iterating, %FALSE to continue"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "model"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeModel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the `GtkTreeModel` being iterated"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "path"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreePath" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the current `GtkTreePath`"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "iter"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeIter" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the current `GtkTreeIter`"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The user data passed to gtk_tree_model_foreach()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement."
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Type of the callback passed to gtk_tree_model_foreach() to\niterate over the rows in a tree model."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TreeModelForeachFunc =
    Ptr Gtk.TreeModel.TreeModel ->
    Ptr Gtk.TreePath.TreePath ->
    Ptr Gtk.TreeIter.TreeIter ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkTreeModel` being iterated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the current `GtkTreePath`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the current `GtkTreeIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The user data passed to gtk_tree_model_foreach()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TreeModelForeachFunc :: FunPtr C_TreeModelForeachFunc -> C_TreeModelForeachFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TreeModelForeachFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeModel.IsTreeModel a) =>
    FunPtr C_TreeModelForeachFunc
    -> a
    -- ^ /@model@/: the @GtkTreeModel@ being iterated
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: the current @GtkTreePath@
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: the current @GtkTreeIter@
    -> Ptr ()
    -- ^ /@data@/: The user data passed to 'GI.Gtk.Interfaces.TreeModel.treeModelForeach'
    -> m Bool
    -- ^ __Returns:__ 'P.True' to stop iterating, 'P.False' to continue
dynamic_TreeModelForeachFunc __funPtr model path iter data_ = liftIO $ do
    model' <- unsafeManagedPtrCastPtr model
    path' <- unsafeManagedPtrGetPtr path
    iter' <- unsafeManagedPtrGetPtr iter
    result <- (__dynamic_C_TreeModelForeachFunc __funPtr) model' path' iter' data_
    let result' = (/= 0) result
    touchManagedPtr model
    touchManagedPtr path
    touchManagedPtr iter
    return result'

-- | Generate a function pointer callable from C code, from a `C_TreeModelForeachFunc`.
foreign import ccall "wrapper"
    mk_TreeModelForeachFunc :: C_TreeModelForeachFunc -> IO (FunPtr C_TreeModelForeachFunc)

{-# DEPRECATED TreeModelForeachFunc ["(Since version 4.20)","There is no replacement."] #-}
-- | Type of the callback passed to 'GI.Gtk.Interfaces.TreeModel.treeModelForeach' to
-- iterate over the rows in a tree model.
type TreeModelForeachFunc =
    Gtk.TreeModel.TreeModel
    -- ^ /@model@/: the @GtkTreeModel@ being iterated
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: the current @GtkTreePath@
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: the current @GtkTreeIter@
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop iterating, 'P.False' to continue

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeModelForeachFunc`@.
noTreeModelForeachFunc :: Maybe TreeModelForeachFunc
noTreeModelForeachFunc = Nothing

-- | Type of the callback passed to 'GI.Gtk.Interfaces.TreeModel.treeModelForeach' to
-- iterate over the rows in a tree model.
type TreeModelForeachFunc_WithClosures =
    Gtk.TreeModel.TreeModel
    -- ^ /@model@/: the @GtkTreeModel@ being iterated
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: the current @GtkTreePath@
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: the current @GtkTreeIter@
    -> Ptr ()
    -- ^ /@data@/: The user data passed to 'GI.Gtk.Interfaces.TreeModel.treeModelForeach'
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop iterating, 'P.False' to continue

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeModelForeachFunc_WithClosures`@.
noTreeModelForeachFunc_WithClosures :: Maybe TreeModelForeachFunc_WithClosures
noTreeModelForeachFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TreeModelForeachFunc :: TreeModelForeachFunc -> TreeModelForeachFunc_WithClosures
drop_closures_TreeModelForeachFunc _f model path iter _ = _f model path iter

-- | Wrap the callback into a `GClosure`.
genClosure_TreeModelForeachFunc :: MonadIO m => TreeModelForeachFunc -> m (GClosure C_TreeModelForeachFunc)
genClosure_TreeModelForeachFunc cb = liftIO $ do
    let cb' = drop_closures_TreeModelForeachFunc cb
    let cb'' = wrap_TreeModelForeachFunc Nothing cb'
    mk_TreeModelForeachFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TreeModelForeachFunc` into a `C_TreeModelForeachFunc`.
wrap_TreeModelForeachFunc :: 
    Maybe (Ptr (FunPtr C_TreeModelForeachFunc)) ->
    TreeModelForeachFunc_WithClosures ->
    C_TreeModelForeachFunc
wrap_TreeModelForeachFunc gi'funptrptr gi'cb model path iter data_ = do
    model' <- (newObject Gtk.TreeModel.TreeModel) model
    B.ManagedPtr.withTransient  path $ \path' -> do
        B.ManagedPtr.withTransient  iter $ \iter' -> do
            result <- gi'cb  model' path' iter' data_
            maybeReleaseFunPtr gi'funptrptr
            let result' = (P.fromIntegral . P.fromEnum) result
            return result'


-- callback TreeModelFilterVisibleFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "Whether the row indicated by @iter is visible."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "model"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeModel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the child model of the `GtkTreeModelFilter`"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "iter"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeIter" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "a `GtkTreeIter` pointing to the row in @model whose visibility\n  is determined"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data given to gtk_tree_model_filter_set_visible_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function which decides whether the row indicated by @iter is visible."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TreeModelFilterVisibleFunc =
    Ptr Gtk.TreeModel.TreeModel ->
    Ptr Gtk.TreeIter.TreeIter ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child model of the `GtkTreeModelFilter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a `GtkTreeIter` pointing to the row in @model whose visibility\n  is determined"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data given to gtk_tree_model_filter_set_visible_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TreeModelFilterVisibleFunc :: FunPtr C_TreeModelFilterVisibleFunc -> C_TreeModelFilterVisibleFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TreeModelFilterVisibleFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeModel.IsTreeModel a) =>
    FunPtr C_TreeModelFilterVisibleFunc
    -> a
    -- ^ /@model@/: the child model of the @GtkTreeModelFilter@
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ pointing to the row in /@model@/ whose visibility
    --   is determined
    -> Ptr ()
    -- ^ /@data@/: user data given to 'GI.Gtk.Objects.TreeModelFilter.treeModelFilterSetVisibleFunc'
    -> m Bool
    -- ^ __Returns:__ Whether the row indicated by /@iter@/ is visible.
dynamic_TreeModelFilterVisibleFunc __funPtr model iter data_ = liftIO $ do
    model' <- unsafeManagedPtrCastPtr model
    iter' <- unsafeManagedPtrGetPtr iter
    result <- (__dynamic_C_TreeModelFilterVisibleFunc __funPtr) model' iter' data_
    let result' = (/= 0) result
    touchManagedPtr model
    touchManagedPtr iter
    return result'

-- | Generate a function pointer callable from C code, from a `C_TreeModelFilterVisibleFunc`.
foreign import ccall "wrapper"
    mk_TreeModelFilterVisibleFunc :: C_TreeModelFilterVisibleFunc -> IO (FunPtr C_TreeModelFilterVisibleFunc)

{-# DEPRECATED TreeModelFilterVisibleFunc ["(Since version 4.20)","There is no replacement"] #-}
-- | A function which decides whether the row indicated by /@iter@/ is visible.
type TreeModelFilterVisibleFunc =
    Gtk.TreeModel.TreeModel
    -- ^ /@model@/: the child model of the @GtkTreeModelFilter@
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ pointing to the row in /@model@/ whose visibility
    --   is determined
    -> IO Bool
    -- ^ __Returns:__ Whether the row indicated by /@iter@/ is visible.

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeModelFilterVisibleFunc`@.
noTreeModelFilterVisibleFunc :: Maybe TreeModelFilterVisibleFunc
noTreeModelFilterVisibleFunc = Nothing

-- | A function which decides whether the row indicated by /@iter@/ is visible.
type TreeModelFilterVisibleFunc_WithClosures =
    Gtk.TreeModel.TreeModel
    -- ^ /@model@/: the child model of the @GtkTreeModelFilter@
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ pointing to the row in /@model@/ whose visibility
    --   is determined
    -> Ptr ()
    -- ^ /@data@/: user data given to 'GI.Gtk.Objects.TreeModelFilter.treeModelFilterSetVisibleFunc'
    -> IO Bool
    -- ^ __Returns:__ Whether the row indicated by /@iter@/ is visible.

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeModelFilterVisibleFunc_WithClosures`@.
noTreeModelFilterVisibleFunc_WithClosures :: Maybe TreeModelFilterVisibleFunc_WithClosures
noTreeModelFilterVisibleFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TreeModelFilterVisibleFunc :: TreeModelFilterVisibleFunc -> TreeModelFilterVisibleFunc_WithClosures
drop_closures_TreeModelFilterVisibleFunc _f model iter _ = _f model iter

-- | Wrap the callback into a `GClosure`.
genClosure_TreeModelFilterVisibleFunc :: MonadIO m => TreeModelFilterVisibleFunc -> m (GClosure C_TreeModelFilterVisibleFunc)
genClosure_TreeModelFilterVisibleFunc cb = liftIO $ do
    let cb' = drop_closures_TreeModelFilterVisibleFunc cb
    let cb'' = wrap_TreeModelFilterVisibleFunc Nothing cb'
    mk_TreeModelFilterVisibleFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TreeModelFilterVisibleFunc` into a `C_TreeModelFilterVisibleFunc`.
wrap_TreeModelFilterVisibleFunc :: 
    Maybe (Ptr (FunPtr C_TreeModelFilterVisibleFunc)) ->
    TreeModelFilterVisibleFunc_WithClosures ->
    C_TreeModelFilterVisibleFunc
wrap_TreeModelFilterVisibleFunc gi'funptrptr gi'cb model iter data_ = do
    model' <- (newObject Gtk.TreeModel.TreeModel) model
    B.ManagedPtr.withTransient  iter $ \iter' -> do
        result <- gi'cb  model' iter' data_
        maybeReleaseFunPtr gi'funptrptr
        let result' = (P.fromIntegral . P.fromEnum) result
        return result'


-- callback TreeModelFilterModifyFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "model"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeModel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the `GtkTreeModelFilter`"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "iter"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeIter" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "a `GtkTreeIter` pointing to the row whose display values are determined"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "A `GValue` which is already initialized for\n with the correct type for the column @column."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "column"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the column whose display value is determined"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data given to gtk_tree_model_filter_set_modify_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function which calculates display values from raw values in the model.\nIt must fill @value with the display value for the column @column in the\nrow indicated by @iter.\n\nSince this function is called for each data access, it\8217s not a\nparticularly efficient operation."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TreeModelFilterModifyFunc =
    Ptr Gtk.TreeModel.TreeModel ->
    Ptr Gtk.TreeIter.TreeIter ->
    Ptr GValue ->
    Int32 ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkTreeModelFilter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a `GtkTreeIter` pointing to the row whose display values are determined"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A `GValue` which is already initialized for\n with the correct type for the column @column."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the column whose display value is determined"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data given to gtk_tree_model_filter_set_modify_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TreeModelFilterModifyFunc :: FunPtr C_TreeModelFilterModifyFunc -> C_TreeModelFilterModifyFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TreeModelFilterModifyFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeModel.IsTreeModel a) =>
    FunPtr C_TreeModelFilterModifyFunc
    -> a
    -- ^ /@model@/: the @GtkTreeModelFilter@
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ pointing to the row whose display values are determined
    -> GValue
    -- ^ /@value@/: A @GValue@ which is already initialized for
    --  with the correct type for the column /@column@/.
    -> Int32
    -- ^ /@column@/: the column whose display value is determined
    -> Ptr ()
    -- ^ /@data@/: user data given to 'GI.Gtk.Objects.TreeModelFilter.treeModelFilterSetModifyFunc'
    -> m ()
dynamic_TreeModelFilterModifyFunc __funPtr model iter value column data_ = liftIO $ do
    model' <- unsafeManagedPtrCastPtr model
    iter' <- unsafeManagedPtrGetPtr iter
    value' <- unsafeManagedPtrGetPtr value
    (__dynamic_C_TreeModelFilterModifyFunc __funPtr) model' iter' value' column data_
    touchManagedPtr model
    touchManagedPtr iter
    touchManagedPtr value
    return ()

-- | Generate a function pointer callable from C code, from a `C_TreeModelFilterModifyFunc`.
foreign import ccall "wrapper"
    mk_TreeModelFilterModifyFunc :: C_TreeModelFilterModifyFunc -> IO (FunPtr C_TreeModelFilterModifyFunc)

{-# DEPRECATED TreeModelFilterModifyFunc ["(Since version 4.20)","There is no replacement"] #-}
-- | A function which calculates display values from raw values in the model.
-- It must fill /@value@/ with the display value for the column /@column@/ in the
-- row indicated by /@iter@/.
-- 
-- Since this function is called for each data access, it’s not a
-- particularly efficient operation.
type TreeModelFilterModifyFunc =
    Gtk.TreeModel.TreeModel
    -- ^ /@model@/: the @GtkTreeModelFilter@
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ pointing to the row whose display values are determined
    -> GValue
    -- ^ /@value@/: A @GValue@ which is already initialized for
    --  with the correct type for the column /@column@/.
    -> Int32
    -- ^ /@column@/: the column whose display value is determined
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeModelFilterModifyFunc`@.
noTreeModelFilterModifyFunc :: Maybe TreeModelFilterModifyFunc
noTreeModelFilterModifyFunc = Nothing

-- | A function which calculates display values from raw values in the model.
-- It must fill /@value@/ with the display value for the column /@column@/ in the
-- row indicated by /@iter@/.
-- 
-- Since this function is called for each data access, it’s not a
-- particularly efficient operation.
type TreeModelFilterModifyFunc_WithClosures =
    Gtk.TreeModel.TreeModel
    -- ^ /@model@/: the @GtkTreeModelFilter@
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ pointing to the row whose display values are determined
    -> GValue
    -- ^ /@value@/: A @GValue@ which is already initialized for
    --  with the correct type for the column /@column@/.
    -> Int32
    -- ^ /@column@/: the column whose display value is determined
    -> Ptr ()
    -- ^ /@data@/: user data given to 'GI.Gtk.Objects.TreeModelFilter.treeModelFilterSetModifyFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeModelFilterModifyFunc_WithClosures`@.
noTreeModelFilterModifyFunc_WithClosures :: Maybe TreeModelFilterModifyFunc_WithClosures
noTreeModelFilterModifyFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TreeModelFilterModifyFunc :: TreeModelFilterModifyFunc -> TreeModelFilterModifyFunc_WithClosures
drop_closures_TreeModelFilterModifyFunc _f model iter value column _ = _f model iter value column

-- | Wrap the callback into a `GClosure`.
genClosure_TreeModelFilterModifyFunc :: MonadIO m => TreeModelFilterModifyFunc -> m (GClosure C_TreeModelFilterModifyFunc)
genClosure_TreeModelFilterModifyFunc cb = liftIO $ do
    let cb' = drop_closures_TreeModelFilterModifyFunc cb
    let cb'' = wrap_TreeModelFilterModifyFunc Nothing cb'
    mk_TreeModelFilterModifyFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TreeModelFilterModifyFunc` into a `C_TreeModelFilterModifyFunc`.
wrap_TreeModelFilterModifyFunc :: 
    Maybe (Ptr (FunPtr C_TreeModelFilterModifyFunc)) ->
    TreeModelFilterModifyFunc_WithClosures ->
    C_TreeModelFilterModifyFunc
wrap_TreeModelFilterModifyFunc gi'funptrptr gi'cb model iter value column data_ = do
    model' <- (newObject Gtk.TreeModel.TreeModel) model
    B.ManagedPtr.withTransient  iter $ \iter' -> do
        value' <- B.GValue.newGValueFromPtr value
        gi'cb  model' iter' value' column data_
        maybeReleaseFunPtr gi'funptrptr


-- callback TreeListModelCreateModelFunc
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
  , returnMayBeNull = True
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "The model tracking the children of\n  @item or %NULL if @item can never have children"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "item"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The item that is being expanded"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "User data passed when registering the function"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Prototype of the function called to create new child models when\ngtk_tree_list_row_set_expanded() is called.\n\nThis function can return %NULL to indicate that @item is guaranteed to be\na leaf node and will never have children. If it does not have children but\nmay get children later, it should return an empty model that is filled once\nchildren arrive."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TreeListModelCreateModelFunc =
    Ptr GObject.Object.Object ->
    Ptr () ->
    IO (Ptr Gio.ListModel.ListModel)

-- Args: [ Arg
--           { argCName = "item"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The item that is being expanded"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "User data passed when registering the function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TreeListModelCreateModelFunc :: FunPtr C_TreeListModelCreateModelFunc -> C_TreeListModelCreateModelFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TreeListModelCreateModelFunc ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_TreeListModelCreateModelFunc
    -> a
    -- ^ /@item@/: The item that is being expanded
    -> Ptr ()
    -- ^ /@userData@/: User data passed when registering the function
    -> m (Maybe Gio.ListModel.ListModel)
    -- ^ __Returns:__ The model tracking the children of
    --   /@item@/ or 'P.Nothing' if /@item@/ can never have children
dynamic_TreeListModelCreateModelFunc __funPtr item userData = liftIO $ do
    item' <- unsafeManagedPtrCastPtr item
    result <- (__dynamic_C_TreeListModelCreateModelFunc __funPtr) item' userData
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gio.ListModel.ListModel) result'
        return result''
    touchManagedPtr item
    return maybeResult

-- | Generate a function pointer callable from C code, from a `C_TreeListModelCreateModelFunc`.
foreign import ccall "wrapper"
    mk_TreeListModelCreateModelFunc :: C_TreeListModelCreateModelFunc -> IO (FunPtr C_TreeListModelCreateModelFunc)

-- | Prototype of the function called to create new child models when
-- 'GI.Gtk.Objects.TreeListRow.treeListRowSetExpanded' is called.
-- 
-- This function can return 'P.Nothing' to indicate that /@item@/ is guaranteed to be
-- a leaf node and will never have children. If it does not have children but
-- may get children later, it should return an empty model that is filled once
-- children arrive.
type TreeListModelCreateModelFunc =
    GObject.Object.Object
    -- ^ /@item@/: The item that is being expanded
    -> IO (Maybe Gio.ListModel.ListModel)
    -- ^ __Returns:__ The model tracking the children of
    --   /@item@/ or 'P.Nothing' if /@item@/ can never have children

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeListModelCreateModelFunc`@.
noTreeListModelCreateModelFunc :: Maybe TreeListModelCreateModelFunc
noTreeListModelCreateModelFunc = Nothing

-- | Prototype of the function called to create new child models when
-- 'GI.Gtk.Objects.TreeListRow.treeListRowSetExpanded' is called.
-- 
-- This function can return 'P.Nothing' to indicate that /@item@/ is guaranteed to be
-- a leaf node and will never have children. If it does not have children but
-- may get children later, it should return an empty model that is filled once
-- children arrive.
type TreeListModelCreateModelFunc_WithClosures =
    GObject.Object.Object
    -- ^ /@item@/: The item that is being expanded
    -> Ptr ()
    -- ^ /@userData@/: User data passed when registering the function
    -> IO (Maybe Gio.ListModel.ListModel)
    -- ^ __Returns:__ The model tracking the children of
    --   /@item@/ or 'P.Nothing' if /@item@/ can never have children

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeListModelCreateModelFunc_WithClosures`@.
noTreeListModelCreateModelFunc_WithClosures :: Maybe TreeListModelCreateModelFunc_WithClosures
noTreeListModelCreateModelFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TreeListModelCreateModelFunc :: TreeListModelCreateModelFunc -> TreeListModelCreateModelFunc_WithClosures
drop_closures_TreeListModelCreateModelFunc _f item _ = _f item

-- | Wrap the callback into a `GClosure`.
genClosure_TreeListModelCreateModelFunc :: MonadIO m => TreeListModelCreateModelFunc -> m (GClosure C_TreeListModelCreateModelFunc)
genClosure_TreeListModelCreateModelFunc cb = liftIO $ do
    let cb' = drop_closures_TreeListModelCreateModelFunc cb
    let cb'' = wrap_TreeListModelCreateModelFunc Nothing cb'
    mk_TreeListModelCreateModelFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TreeListModelCreateModelFunc` into a `C_TreeListModelCreateModelFunc`.
wrap_TreeListModelCreateModelFunc :: 
    Maybe (Ptr (FunPtr C_TreeListModelCreateModelFunc)) ->
    TreeListModelCreateModelFunc_WithClosures ->
    C_TreeListModelCreateModelFunc
wrap_TreeListModelCreateModelFunc gi'funptrptr gi'cb item userData = do
    item' <- (newObject GObject.Object.Object) item
    result <- gi'cb  item' userData
    maybeReleaseFunPtr gi'funptrptr
    maybeM FP.nullPtr result $ \result' -> do
        result'' <- B.ManagedPtr.disownObject result'
        return result''


-- callback TreeIterCompareFunc
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "a negative integer, zero or a positive integer depending on whether\n  @a sorts before, with or after @b"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "model"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeModel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The `GtkTreeModel` the comparison is within"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "a"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeIter" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A `GtkTreeIter` in @model"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "b"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeIter" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Another `GtkTreeIter` in @model"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "Data passed when the compare func is assigned e.g. by\n gtk_tree_sortable_set_sort_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A GtkTreeIterCompareFunc should return a negative integer, zero, or a positive\ninteger if @a sorts before @b, @a sorts with @b, or @a sorts after @b\nrespectively.\n\nIf two iters compare as equal, their order in the sorted model\nis undefined. In order to ensure that the `GtkTreeSortable` behaves as\nexpected, the GtkTreeIterCompareFunc must define a partial order on\nthe model, i.e. it must be reflexive, antisymmetric and transitive.\n\nFor example, if @model is a product catalogue, then a compare function\nfor the \8220price\8221 column could be one which returns\n`price_of(@a) - price_of(@b)`."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TreeIterCompareFunc =
    Ptr Gtk.TreeModel.TreeModel ->
    Ptr Gtk.TreeIter.TreeIter ->
    Ptr Gtk.TreeIter.TreeIter ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The `GtkTreeModel` the comparison is within"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTreeIter` in @model"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Another `GtkTreeIter` in @model"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Data passed when the compare func is assigned e.g. by\n gtk_tree_sortable_set_sort_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TreeIterCompareFunc :: FunPtr C_TreeIterCompareFunc -> C_TreeIterCompareFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TreeIterCompareFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeModel.IsTreeModel a) =>
    FunPtr C_TreeIterCompareFunc
    -> a
    -- ^ /@model@/: The @GtkTreeModel@ the comparison is within
    -> Gtk.TreeIter.TreeIter
    -- ^ /@a@/: A @GtkTreeIter@ in /@model@/
    -> Gtk.TreeIter.TreeIter
    -- ^ /@b@/: Another @GtkTreeIter@ in /@model@/
    -> Ptr ()
    -- ^ /@userData@/: Data passed when the compare func is assigned e.g. by
    --  'GI.Gtk.Interfaces.TreeSortable.treeSortableSetSortFunc'
    -> m Int32
    -- ^ __Returns:__ a negative integer, zero or a positive integer depending on whether
    --   /@a@/ sorts before, with or after /@b@/
dynamic_TreeIterCompareFunc __funPtr model a b userData = liftIO $ do
    model' <- unsafeManagedPtrCastPtr model
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- (__dynamic_C_TreeIterCompareFunc __funPtr) model' a' b' userData
    touchManagedPtr model
    touchManagedPtr a
    touchManagedPtr b
    return result

-- | Generate a function pointer callable from C code, from a `C_TreeIterCompareFunc`.
foreign import ccall "wrapper"
    mk_TreeIterCompareFunc :: C_TreeIterCompareFunc -> IO (FunPtr C_TreeIterCompareFunc)

{-# DEPRECATED TreeIterCompareFunc ["(Since version 4.20)","There is no replacement"] #-}
-- | A GtkTreeIterCompareFunc should return a negative integer, zero, or a positive
-- integer if /@a@/ sorts before /@b@/, /@a@/ sorts with /@b@/, or /@a@/ sorts after /@b@/
-- respectively.
-- 
-- If two iters compare as equal, their order in the sorted model
-- is undefined. In order to ensure that the @GtkTreeSortable@ behaves as
-- expected, the GtkTreeIterCompareFunc must define a partial order on
-- the model, i.e. it must be reflexive, antisymmetric and transitive.
-- 
-- For example, if /@model@/ is a product catalogue, then a compare function
-- for the “price” column could be one which returns
-- @price_of(\@a) - price_of(\@b)@.
type TreeIterCompareFunc =
    Gtk.TreeModel.TreeModel
    -- ^ /@model@/: The @GtkTreeModel@ the comparison is within
    -> Gtk.TreeIter.TreeIter
    -- ^ /@a@/: A @GtkTreeIter@ in /@model@/
    -> Gtk.TreeIter.TreeIter
    -- ^ /@b@/: Another @GtkTreeIter@ in /@model@/
    -> IO Int32
    -- ^ __Returns:__ a negative integer, zero or a positive integer depending on whether
    --   /@a@/ sorts before, with or after /@b@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeIterCompareFunc`@.
noTreeIterCompareFunc :: Maybe TreeIterCompareFunc
noTreeIterCompareFunc = Nothing

-- | A GtkTreeIterCompareFunc should return a negative integer, zero, or a positive
-- integer if /@a@/ sorts before /@b@/, /@a@/ sorts with /@b@/, or /@a@/ sorts after /@b@/
-- respectively.
-- 
-- If two iters compare as equal, their order in the sorted model
-- is undefined. In order to ensure that the @GtkTreeSortable@ behaves as
-- expected, the GtkTreeIterCompareFunc must define a partial order on
-- the model, i.e. it must be reflexive, antisymmetric and transitive.
-- 
-- For example, if /@model@/ is a product catalogue, then a compare function
-- for the “price” column could be one which returns
-- @price_of(\@a) - price_of(\@b)@.
type TreeIterCompareFunc_WithClosures =
    Gtk.TreeModel.TreeModel
    -- ^ /@model@/: The @GtkTreeModel@ the comparison is within
    -> Gtk.TreeIter.TreeIter
    -- ^ /@a@/: A @GtkTreeIter@ in /@model@/
    -> Gtk.TreeIter.TreeIter
    -- ^ /@b@/: Another @GtkTreeIter@ in /@model@/
    -> Ptr ()
    -- ^ /@userData@/: Data passed when the compare func is assigned e.g. by
    --  'GI.Gtk.Interfaces.TreeSortable.treeSortableSetSortFunc'
    -> IO Int32
    -- ^ __Returns:__ a negative integer, zero or a positive integer depending on whether
    --   /@a@/ sorts before, with or after /@b@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeIterCompareFunc_WithClosures`@.
noTreeIterCompareFunc_WithClosures :: Maybe TreeIterCompareFunc_WithClosures
noTreeIterCompareFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TreeIterCompareFunc :: TreeIterCompareFunc -> TreeIterCompareFunc_WithClosures
drop_closures_TreeIterCompareFunc _f model a b _ = _f model a b

-- | Wrap the callback into a `GClosure`.
genClosure_TreeIterCompareFunc :: MonadIO m => TreeIterCompareFunc -> m (GClosure C_TreeIterCompareFunc)
genClosure_TreeIterCompareFunc cb = liftIO $ do
    let cb' = drop_closures_TreeIterCompareFunc cb
    let cb'' = wrap_TreeIterCompareFunc Nothing cb'
    mk_TreeIterCompareFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TreeIterCompareFunc` into a `C_TreeIterCompareFunc`.
wrap_TreeIterCompareFunc :: 
    Maybe (Ptr (FunPtr C_TreeIterCompareFunc)) ->
    TreeIterCompareFunc_WithClosures ->
    C_TreeIterCompareFunc
wrap_TreeIterCompareFunc gi'funptrptr gi'cb model a b userData = do
    model' <- (newObject Gtk.TreeModel.TreeModel) model
    B.ManagedPtr.withTransient  a $ \a' -> do
        B.ManagedPtr.withTransient  b $ \b' -> do
            result <- gi'cb  model' a' b' userData
            maybeReleaseFunPtr gi'funptrptr
            return result


-- callback TreeCellDataFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "tree_column"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeViewColumn" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A `GtkTreeViewColumn`"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cell"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "CellRenderer" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The `GtkCellRenderer` that is being rendered by @tree_column"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "tree_model"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeModel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The `GtkTreeModel` being rendered"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "iter"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeIter" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A `GtkTreeIter` of the current row rendered"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function to set the properties of a cell instead of just using the\nstraight mapping between the cell and the model.\n\nThis function is useful for customizing the cell renderer. For example,\na function might get an* integer from the @tree_model, and render it to\nthe \8220text\8221 attribute of \8220cell\8221 by converting it to its written equivalent.\n\nSee also: gtk_tree_view_column_set_cell_data_func()"
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TreeCellDataFunc =
    Ptr Gtk.TreeViewColumn.TreeViewColumn ->
    Ptr Gtk.CellRenderer.CellRenderer ->
    Ptr Gtk.TreeModel.TreeModel ->
    Ptr Gtk.TreeIter.TreeIter ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "tree_column"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeViewColumn" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTreeViewColumn`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cell"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CellRenderer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The `GtkCellRenderer` that is being rendered by @tree_column"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tree_model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The `GtkTreeModel` being rendered"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTreeIter` of the current row rendered"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TreeCellDataFunc :: FunPtr C_TreeCellDataFunc -> C_TreeCellDataFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TreeCellDataFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeViewColumn.IsTreeViewColumn a, Gtk.CellRenderer.IsCellRenderer b, Gtk.TreeModel.IsTreeModel c) =>
    FunPtr C_TreeCellDataFunc
    -> a
    -- ^ /@treeColumn@/: A @GtkTreeViewColumn@
    -> b
    -- ^ /@cell@/: The @GtkCellRenderer@ that is being rendered by /@treeColumn@/
    -> c
    -- ^ /@treeModel@/: The @GtkTreeModel@ being rendered
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: A @GtkTreeIter@ of the current row rendered
    -> Ptr ()
    -- ^ /@data@/: user data
    -> m ()
dynamic_TreeCellDataFunc __funPtr treeColumn cell treeModel iter data_ = liftIO $ do
    treeColumn' <- unsafeManagedPtrCastPtr treeColumn
    cell' <- unsafeManagedPtrCastPtr cell
    treeModel' <- unsafeManagedPtrCastPtr treeModel
    iter' <- unsafeManagedPtrGetPtr iter
    (__dynamic_C_TreeCellDataFunc __funPtr) treeColumn' cell' treeModel' iter' data_
    touchManagedPtr treeColumn
    touchManagedPtr cell
    touchManagedPtr treeModel
    touchManagedPtr iter
    return ()

-- | Generate a function pointer callable from C code, from a `C_TreeCellDataFunc`.
foreign import ccall "wrapper"
    mk_TreeCellDataFunc :: C_TreeCellDataFunc -> IO (FunPtr C_TreeCellDataFunc)

{-# DEPRECATED TreeCellDataFunc ["(Since version 4.20)","There is no replacement"] #-}
-- | A function to set the properties of a cell instead of just using the
-- straight mapping between the cell and the model.
-- 
-- This function is useful for customizing the cell renderer. For example,
-- a function might get an* integer from the /@treeModel@/, and render it to
-- the “text” attribute of “cell” by converting it to its written equivalent.
-- 
-- See also: 'GI.Gtk.Objects.TreeViewColumn.treeViewColumnSetCellDataFunc'
type TreeCellDataFunc =
    Gtk.TreeViewColumn.TreeViewColumn
    -- ^ /@treeColumn@/: A @GtkTreeViewColumn@
    -> Gtk.CellRenderer.CellRenderer
    -- ^ /@cell@/: The @GtkCellRenderer@ that is being rendered by /@treeColumn@/
    -> Gtk.TreeModel.TreeModel
    -- ^ /@treeModel@/: The @GtkTreeModel@ being rendered
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: A @GtkTreeIter@ of the current row rendered
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeCellDataFunc`@.
noTreeCellDataFunc :: Maybe TreeCellDataFunc
noTreeCellDataFunc = Nothing

-- | A function to set the properties of a cell instead of just using the
-- straight mapping between the cell and the model.
-- 
-- This function is useful for customizing the cell renderer. For example,
-- a function might get an* integer from the /@treeModel@/, and render it to
-- the “text” attribute of “cell” by converting it to its written equivalent.
-- 
-- See also: 'GI.Gtk.Objects.TreeViewColumn.treeViewColumnSetCellDataFunc'
type TreeCellDataFunc_WithClosures =
    Gtk.TreeViewColumn.TreeViewColumn
    -- ^ /@treeColumn@/: A @GtkTreeViewColumn@
    -> Gtk.CellRenderer.CellRenderer
    -- ^ /@cell@/: The @GtkCellRenderer@ that is being rendered by /@treeColumn@/
    -> Gtk.TreeModel.TreeModel
    -- ^ /@treeModel@/: The @GtkTreeModel@ being rendered
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: A @GtkTreeIter@ of the current row rendered
    -> Ptr ()
    -- ^ /@data@/: user data
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TreeCellDataFunc_WithClosures`@.
noTreeCellDataFunc_WithClosures :: Maybe TreeCellDataFunc_WithClosures
noTreeCellDataFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TreeCellDataFunc :: TreeCellDataFunc -> TreeCellDataFunc_WithClosures
drop_closures_TreeCellDataFunc _f treeColumn cell treeModel iter _ = _f treeColumn cell treeModel iter

-- | Wrap the callback into a `GClosure`.
genClosure_TreeCellDataFunc :: MonadIO m => TreeCellDataFunc -> m (GClosure C_TreeCellDataFunc)
genClosure_TreeCellDataFunc cb = liftIO $ do
    let cb' = drop_closures_TreeCellDataFunc cb
    let cb'' = wrap_TreeCellDataFunc Nothing cb'
    mk_TreeCellDataFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TreeCellDataFunc` into a `C_TreeCellDataFunc`.
wrap_TreeCellDataFunc :: 
    Maybe (Ptr (FunPtr C_TreeCellDataFunc)) ->
    TreeCellDataFunc_WithClosures ->
    C_TreeCellDataFunc
wrap_TreeCellDataFunc gi'funptrptr gi'cb treeColumn cell treeModel iter data_ = do
    treeColumn' <- (newObject Gtk.TreeViewColumn.TreeViewColumn) treeColumn
    cell' <- (newObject Gtk.CellRenderer.CellRenderer) cell
    treeModel' <- (newObject Gtk.TreeModel.TreeModel) treeModel
    B.ManagedPtr.withTransient  iter $ \iter' -> do
        gi'cb  treeColumn' cell' treeModel' iter' data_
        maybeReleaseFunPtr gi'funptrptr


-- callback TickCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "`G_SOURCE_CONTINUE` if the tick callback should continue\n  to be called, `G_SOURCE_REMOVE` if it should be removed"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the widget" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "frame_clock"
          , argType =
              TInterface Name { namespace = "Gdk" , name = "FrameClock" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the frame clock for the widget"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data passed to [method@Gtk.Widget.add_tick_callback]."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Callback type for adding a function to update animations.\n\nSee [method@Gtk.Widget.add_tick_callback]."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TickCallback =
    Ptr Gtk.Widget.Widget ->
    Ptr Gdk.FrameClock.FrameClock ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "frame_clock"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameClock" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the frame clock for the widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data passed to [method@Gtk.Widget.add_tick_callback]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TickCallback :: FunPtr C_TickCallback -> C_TickCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TickCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a, Gdk.FrameClock.IsFrameClock b) =>
    FunPtr C_TickCallback
    -> a
    -- ^ /@widget@/: the widget
    -> b
    -- ^ /@frameClock@/: the frame clock for the widget
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.Gtk.Objects.Widget.widgetAddTickCallback'.
    -> m Bool
    -- ^ __Returns:__ @G_SOURCE_CONTINUE@ if the tick callback should continue
    --   to be called, @G_SOURCE_REMOVE@ if it should be removed
dynamic_TickCallback __funPtr widget frameClock userData = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    frameClock' <- unsafeManagedPtrCastPtr frameClock
    result <- (__dynamic_C_TickCallback __funPtr) widget' frameClock' userData
    let result' = (/= 0) result
    touchManagedPtr widget
    touchManagedPtr frameClock
    return result'

-- | Generate a function pointer callable from C code, from a `C_TickCallback`.
foreign import ccall "wrapper"
    mk_TickCallback :: C_TickCallback -> IO (FunPtr C_TickCallback)

-- | Callback type for adding a function to update animations.
-- 
-- See 'GI.Gtk.Objects.Widget.widgetAddTickCallback'.
type TickCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: the widget
    -> Gdk.FrameClock.FrameClock
    -- ^ /@frameClock@/: the frame clock for the widget
    -> IO Bool
    -- ^ __Returns:__ @G_SOURCE_CONTINUE@ if the tick callback should continue
    --   to be called, @G_SOURCE_REMOVE@ if it should be removed

-- | A convenience synonym for @`Nothing` :: `Maybe` `TickCallback`@.
noTickCallback :: Maybe TickCallback
noTickCallback = Nothing

-- | Callback type for adding a function to update animations.
-- 
-- See 'GI.Gtk.Objects.Widget.widgetAddTickCallback'.
type TickCallback_WithClosures =
    Gtk.Widget.Widget
    -- ^ /@widget@/: the widget
    -> Gdk.FrameClock.FrameClock
    -- ^ /@frameClock@/: the frame clock for the widget
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.Gtk.Objects.Widget.widgetAddTickCallback'.
    -> IO Bool
    -- ^ __Returns:__ @G_SOURCE_CONTINUE@ if the tick callback should continue
    --   to be called, @G_SOURCE_REMOVE@ if it should be removed

-- | A convenience synonym for @`Nothing` :: `Maybe` `TickCallback_WithClosures`@.
noTickCallback_WithClosures :: Maybe TickCallback_WithClosures
noTickCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TickCallback :: TickCallback -> TickCallback_WithClosures
drop_closures_TickCallback _f widget frameClock _ = _f widget frameClock

-- | Wrap the callback into a `GClosure`.
genClosure_TickCallback :: MonadIO m => TickCallback -> m (GClosure C_TickCallback)
genClosure_TickCallback cb = liftIO $ do
    let cb' = drop_closures_TickCallback cb
    let cb'' = wrap_TickCallback Nothing cb'
    mk_TickCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TickCallback` into a `C_TickCallback`.
wrap_TickCallback :: 
    Maybe (Ptr (FunPtr C_TickCallback)) ->
    TickCallback_WithClosures ->
    C_TickCallback
wrap_TickCallback gi'funptrptr gi'cb widget frameClock userData = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    frameClock' <- (newObject Gdk.FrameClock.FrameClock) frameClock
    result <- gi'cb  widget' frameClock' userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback TextTagTableForeach
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "tag"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TextTag" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the `GtkTextTag`" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "data passed to gtk_text_tag_table_foreach()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function used with gtk_text_tag_table_foreach(),\nto iterate over every `GtkTextTag` inside a `GtkTextTagTable`."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TextTagTableForeach =
    Ptr Gtk.TextTag.TextTag ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "tag"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextTag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkTextTag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed to gtk_text_tag_table_foreach()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TextTagTableForeach :: FunPtr C_TextTagTableForeach -> C_TextTagTableForeach

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TextTagTableForeach ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TextTag.IsTextTag a) =>
    FunPtr C_TextTagTableForeach
    -> a
    -- ^ /@tag@/: the @GtkTextTag@
    -> Ptr ()
    -- ^ /@data@/: data passed to 'GI.Gtk.Objects.TextTagTable.textTagTableForeach'
    -> m ()
dynamic_TextTagTableForeach __funPtr tag data_ = liftIO $ do
    tag' <- unsafeManagedPtrCastPtr tag
    (__dynamic_C_TextTagTableForeach __funPtr) tag' data_
    touchManagedPtr tag
    return ()

-- | Generate a function pointer callable from C code, from a `C_TextTagTableForeach`.
foreign import ccall "wrapper"
    mk_TextTagTableForeach :: C_TextTagTableForeach -> IO (FunPtr C_TextTagTableForeach)

-- | A function used with 'GI.Gtk.Objects.TextTagTable.textTagTableForeach',
-- to iterate over every @GtkTextTag@ inside a @GtkTextTagTable@.
type TextTagTableForeach =
    Gtk.TextTag.TextTag
    -- ^ /@tag@/: the @GtkTextTag@
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TextTagTableForeach`@.
noTextTagTableForeach :: Maybe TextTagTableForeach
noTextTagTableForeach = Nothing

-- | A function used with 'GI.Gtk.Objects.TextTagTable.textTagTableForeach',
-- to iterate over every @GtkTextTag@ inside a @GtkTextTagTable@.
type TextTagTableForeach_WithClosures =
    Gtk.TextTag.TextTag
    -- ^ /@tag@/: the @GtkTextTag@
    -> Ptr ()
    -- ^ /@data@/: data passed to 'GI.Gtk.Objects.TextTagTable.textTagTableForeach'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TextTagTableForeach_WithClosures`@.
noTextTagTableForeach_WithClosures :: Maybe TextTagTableForeach_WithClosures
noTextTagTableForeach_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TextTagTableForeach :: TextTagTableForeach -> TextTagTableForeach_WithClosures
drop_closures_TextTagTableForeach _f tag _ = _f tag

-- | Wrap the callback into a `GClosure`.
genClosure_TextTagTableForeach :: MonadIO m => TextTagTableForeach -> m (GClosure C_TextTagTableForeach)
genClosure_TextTagTableForeach cb = liftIO $ do
    let cb' = drop_closures_TextTagTableForeach cb
    let cb'' = wrap_TextTagTableForeach Nothing cb'
    mk_TextTagTableForeach cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TextTagTableForeach` into a `C_TextTagTableForeach`.
wrap_TextTagTableForeach :: 
    Maybe (Ptr (FunPtr C_TextTagTableForeach)) ->
    TextTagTableForeach_WithClosures ->
    C_TextTagTableForeach
wrap_TextTagTableForeach gi'funptrptr gi'cb tag data_ = do
    tag' <- (newObject Gtk.TextTag.TextTag) tag
    gi'cb  tag' data_
    maybeReleaseFunPtr gi'funptrptr


-- callback TextCharPredicate
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%TRUE if the predicate is satisfied, and the iteration should\n  stop, and %FALSE otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "ch"
          , argType = TBasicType TUniChar
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a Unicode code point"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "data passed to the callback"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The predicate function used by gtk_text_iter_forward_find_char() and\ngtk_text_iter_backward_find_char()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TextCharPredicate =
    CInt ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "ch"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode code point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed to the callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TextCharPredicate :: FunPtr C_TextCharPredicate -> C_TextCharPredicate

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TextCharPredicate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TextCharPredicate
    -> Char
    -- ^ /@ch@/: a Unicode code point
    -> Ptr ()
    -- ^ /@userData@/: data passed to the callback
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the predicate is satisfied, and the iteration should
    --   stop, and 'P.False' otherwise
dynamic_TextCharPredicate __funPtr ch userData = liftIO $ do
    let ch' = (P.fromIntegral . SP.ord) ch
    result <- (__dynamic_C_TextCharPredicate __funPtr) ch' userData
    let result' = (/= 0) result
    return result'

-- | Generate a function pointer callable from C code, from a `C_TextCharPredicate`.
foreign import ccall "wrapper"
    mk_TextCharPredicate :: C_TextCharPredicate -> IO (FunPtr C_TextCharPredicate)

-- | The predicate function used by 'GI.Gtk.Structs.TextIter.textIterForwardFindChar' and
-- 'GI.Gtk.Structs.TextIter.textIterBackwardFindChar'.
type TextCharPredicate =
    Char
    -- ^ /@ch@/: a Unicode code point
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the predicate is satisfied, and the iteration should
    --   stop, and 'P.False' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `TextCharPredicate`@.
noTextCharPredicate :: Maybe TextCharPredicate
noTextCharPredicate = Nothing

-- | The predicate function used by 'GI.Gtk.Structs.TextIter.textIterForwardFindChar' and
-- 'GI.Gtk.Structs.TextIter.textIterBackwardFindChar'.
type TextCharPredicate_WithClosures =
    Char
    -- ^ /@ch@/: a Unicode code point
    -> Ptr ()
    -- ^ /@userData@/: data passed to the callback
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the predicate is satisfied, and the iteration should
    --   stop, and 'P.False' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `TextCharPredicate_WithClosures`@.
noTextCharPredicate_WithClosures :: Maybe TextCharPredicate_WithClosures
noTextCharPredicate_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TextCharPredicate :: TextCharPredicate -> TextCharPredicate_WithClosures
drop_closures_TextCharPredicate _f ch _ = _f ch

-- | Wrap the callback into a `GClosure`.
genClosure_TextCharPredicate :: MonadIO m => TextCharPredicate -> m (GClosure C_TextCharPredicate)
genClosure_TextCharPredicate cb = liftIO $ do
    let cb' = drop_closures_TextCharPredicate cb
    let cb'' = wrap_TextCharPredicate Nothing cb'
    mk_TextCharPredicate cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TextCharPredicate` into a `C_TextCharPredicate`.
wrap_TextCharPredicate :: 
    Maybe (Ptr (FunPtr C_TextCharPredicate)) ->
    TextCharPredicate_WithClosures ->
    C_TextCharPredicate
wrap_TextCharPredicate gi'funptrptr gi'cb ch userData = do
    let ch' = (chr . fromIntegral) ch
    result <- gi'cb  ch' userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback TextBufferCommitNotify
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "buffer"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the text buffer being notified"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "flags"
          , argType =
              TInterface
                Name { namespace = "Gtk" , name = "TextBufferNotifyFlags" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the type of commit notification"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "position"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the position of the text operation"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "length"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the length of the text operation in characters"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to the callback"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A notification callback used by [method@Gtk.TextBuffer.add_commit_notify].\n\nYou may not modify the [class@Gtk.TextBuffer] from a\n[callback@Gtk.TextBufferCommitNotify] callback and that is enforced\nby the [class@Gtk.TextBuffer] API.\n\n[callback@Gtk.TextBufferCommitNotify] may be used to be notified about\nchanges to the underlying buffer right before-or-after the changes are\ncommitted to the underlying B-Tree. This is useful if you want to observe\nchanges to the buffer without other signal handlers potentially modifying\nstate on the way to the default signal handler.\n\nWhen @flags is `GTK_TEXT_BUFFER_NOTIFY_BEFORE_INSERT`, `position` is set to\nthe offset in characters from the start of the buffer where the insertion\nwill occur. `length` is set to the number of characters to be inserted.  You\nmay not yet retrieve the text until it has been inserted. You may access the\ntext from `GTK_TEXT_BUFFER_NOTIFY_AFTER_INSERT` using\n[method@Gtk.TextBuffer.get_slice].\n\nWhen @flags is `GTK_TEXT_BUFFER_NOTIFY_AFTER_INSERT`, `position` is set to\noffset in characters where the insertion occurred and `length` is set\nto the number of characters inserted.\n\nWhen @flags is `GTK_TEXT_BUFFER_NOTIFY_BEFORE_DELETE`, `position` is set to\noffset in characters where the deletion will occur and `length` is set\nto the number of characters that will be removed. You may still retrieve\nthe text from this handler using `position` and `length`.\n\nWhen @flags is `GTK_TEXT_BUFFER_NOTIFY_AFTER_DELETE`, `length` is set to\nzero to denote that the delete-range has already been committed to the\nunderlying B-Tree. You may no longer retrieve the text that has been\ndeleted from the [class@Gtk.TextBuffer]."
        , sinceVersion = Just "4.16"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TextBufferCommitNotify =
    Ptr Gtk.TextBuffer.TextBuffer ->
    CUInt ->
    Word32 ->
    Word32 ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the text buffer being notified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "TextBufferNotifyFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the type of commit notification"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position of the text operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the length of the text operation in characters"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to the callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TextBufferCommitNotify :: FunPtr C_TextBufferCommitNotify -> C_TextBufferCommitNotify

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TextBufferCommitNotify ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TextBuffer.IsTextBuffer a) =>
    FunPtr C_TextBufferCommitNotify
    -> a
    -- ^ /@buffer@/: the text buffer being notified
    -> [Gtk.Flags.TextBufferNotifyFlags]
    -- ^ /@flags@/: the type of commit notification
    -> Word32
    -- ^ /@position@/: the position of the text operation
    -> Word32
    -- ^ /@length@/: the length of the text operation in characters
    -> Ptr ()
    -- ^ /@userData@/: user data passed to the callback
    -> m ()
dynamic_TextBufferCommitNotify __funPtr buffer flags position length_ userData = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    let flags' = gflagsToWord flags
    (__dynamic_C_TextBufferCommitNotify __funPtr) buffer' flags' position length_ userData
    touchManagedPtr buffer
    return ()

-- | Generate a function pointer callable from C code, from a `C_TextBufferCommitNotify`.
foreign import ccall "wrapper"
    mk_TextBufferCommitNotify :: C_TextBufferCommitNotify -> IO (FunPtr C_TextBufferCommitNotify)

-- | A notification callback used by 'GI.Gtk.Objects.TextBuffer.textBufferAddCommitNotify'.
-- 
-- You may not modify the t'GI.Gtk.Objects.TextBuffer.TextBuffer' from a
-- [callback/@gtk@/.TextBufferCommitNotify] callback and that is enforced
-- by the t'GI.Gtk.Objects.TextBuffer.TextBuffer' API.
-- 
-- [callback/@gtk@/.TextBufferCommitNotify] may be used to be notified about
-- changes to the underlying buffer right before-or-after the changes are
-- committed to the underlying B-Tree. This is useful if you want to observe
-- changes to the buffer without other signal handlers potentially modifying
-- state on the way to the default signal handler.
-- 
-- When /@flags@/ is @GTK_TEXT_BUFFER_NOTIFY_BEFORE_INSERT@, @position@ is set to
-- the offset in characters from the start of the buffer where the insertion
-- will occur. @length@ is set to the number of characters to be inserted.  You
-- may not yet retrieve the text until it has been inserted. You may access the
-- text from @GTK_TEXT_BUFFER_NOTIFY_AFTER_INSERT@ using
-- 'GI.Gtk.Objects.TextBuffer.textBufferGetSlice'.
-- 
-- When /@flags@/ is @GTK_TEXT_BUFFER_NOTIFY_AFTER_INSERT@, @position@ is set to
-- offset in characters where the insertion occurred and @length@ is set
-- to the number of characters inserted.
-- 
-- When /@flags@/ is @GTK_TEXT_BUFFER_NOTIFY_BEFORE_DELETE@, @position@ is set to
-- offset in characters where the deletion will occur and @length@ is set
-- to the number of characters that will be removed. You may still retrieve
-- the text from this handler using @position@ and @length@.
-- 
-- When /@flags@/ is @GTK_TEXT_BUFFER_NOTIFY_AFTER_DELETE@, @length@ is set to
-- zero to denote that the delete-range has already been committed to the
-- underlying B-Tree. You may no longer retrieve the text that has been
-- deleted from the t'GI.Gtk.Objects.TextBuffer.TextBuffer'.
-- 
-- /Since: 4.16/
type TextBufferCommitNotify =
    Gtk.TextBuffer.TextBuffer
    -- ^ /@buffer@/: the text buffer being notified
    -> [Gtk.Flags.TextBufferNotifyFlags]
    -- ^ /@flags@/: the type of commit notification
    -> Word32
    -- ^ /@position@/: the position of the text operation
    -> Word32
    -- ^ /@length@/: the length of the text operation in characters
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TextBufferCommitNotify`@.
noTextBufferCommitNotify :: Maybe TextBufferCommitNotify
noTextBufferCommitNotify = Nothing

-- | A notification callback used by 'GI.Gtk.Objects.TextBuffer.textBufferAddCommitNotify'.
-- 
-- You may not modify the t'GI.Gtk.Objects.TextBuffer.TextBuffer' from a
-- [callback/@gtk@/.TextBufferCommitNotify] callback and that is enforced
-- by the t'GI.Gtk.Objects.TextBuffer.TextBuffer' API.
-- 
-- [callback/@gtk@/.TextBufferCommitNotify] may be used to be notified about
-- changes to the underlying buffer right before-or-after the changes are
-- committed to the underlying B-Tree. This is useful if you want to observe
-- changes to the buffer without other signal handlers potentially modifying
-- state on the way to the default signal handler.
-- 
-- When /@flags@/ is @GTK_TEXT_BUFFER_NOTIFY_BEFORE_INSERT@, @position@ is set to
-- the offset in characters from the start of the buffer where the insertion
-- will occur. @length@ is set to the number of characters to be inserted.  You
-- may not yet retrieve the text until it has been inserted. You may access the
-- text from @GTK_TEXT_BUFFER_NOTIFY_AFTER_INSERT@ using
-- 'GI.Gtk.Objects.TextBuffer.textBufferGetSlice'.
-- 
-- When /@flags@/ is @GTK_TEXT_BUFFER_NOTIFY_AFTER_INSERT@, @position@ is set to
-- offset in characters where the insertion occurred and @length@ is set
-- to the number of characters inserted.
-- 
-- When /@flags@/ is @GTK_TEXT_BUFFER_NOTIFY_BEFORE_DELETE@, @position@ is set to
-- offset in characters where the deletion will occur and @length@ is set
-- to the number of characters that will be removed. You may still retrieve
-- the text from this handler using @position@ and @length@.
-- 
-- When /@flags@/ is @GTK_TEXT_BUFFER_NOTIFY_AFTER_DELETE@, @length@ is set to
-- zero to denote that the delete-range has already been committed to the
-- underlying B-Tree. You may no longer retrieve the text that has been
-- deleted from the t'GI.Gtk.Objects.TextBuffer.TextBuffer'.
-- 
-- /Since: 4.16/
type TextBufferCommitNotify_WithClosures =
    Gtk.TextBuffer.TextBuffer
    -- ^ /@buffer@/: the text buffer being notified
    -> [Gtk.Flags.TextBufferNotifyFlags]
    -- ^ /@flags@/: the type of commit notification
    -> Word32
    -- ^ /@position@/: the position of the text operation
    -> Word32
    -- ^ /@length@/: the length of the text operation in characters
    -> Ptr ()
    -- ^ /@userData@/: user data passed to the callback
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TextBufferCommitNotify_WithClosures`@.
noTextBufferCommitNotify_WithClosures :: Maybe TextBufferCommitNotify_WithClosures
noTextBufferCommitNotify_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TextBufferCommitNotify :: TextBufferCommitNotify -> TextBufferCommitNotify_WithClosures
drop_closures_TextBufferCommitNotify _f buffer flags position length_ _ = _f buffer flags position length_

-- | Wrap the callback into a `GClosure`.
genClosure_TextBufferCommitNotify :: MonadIO m => TextBufferCommitNotify -> m (GClosure C_TextBufferCommitNotify)
genClosure_TextBufferCommitNotify cb = liftIO $ do
    let cb' = drop_closures_TextBufferCommitNotify cb
    let cb'' = wrap_TextBufferCommitNotify Nothing cb'
    mk_TextBufferCommitNotify cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TextBufferCommitNotify` into a `C_TextBufferCommitNotify`.
wrap_TextBufferCommitNotify :: 
    Maybe (Ptr (FunPtr C_TextBufferCommitNotify)) ->
    TextBufferCommitNotify_WithClosures ->
    C_TextBufferCommitNotify
wrap_TextBufferCommitNotify gi'funptrptr gi'cb buffer flags position length_ userData = do
    buffer' <- (newObject Gtk.TextBuffer.TextBuffer) buffer
    let flags' = wordToGFlags flags
    gi'cb  buffer' flags' position length_ userData
    maybeReleaseFunPtr gi'funptrptr


-- callback ShortcutFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "true if the action was successful"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The widget passed to the activation"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "args"
          , argType = TVariant
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "The arguments passed to the activation"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The user data provided when activating the action"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText = Just "Type for shortcuts based on user callbacks."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ShortcutFunc =
    Ptr Gtk.Widget.Widget ->
    Ptr GVariant ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The widget passed to the activation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "args"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The arguments passed to the activation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The user data provided when activating the action"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ShortcutFunc :: FunPtr C_ShortcutFunc -> C_ShortcutFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ShortcutFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_ShortcutFunc
    -> a
    -- ^ /@widget@/: The widget passed to the activation
    -> Maybe (GVariant)
    -- ^ /@args@/: The arguments passed to the activation
    -> Ptr ()
    -- ^ /@userData@/: The user data provided when activating the action
    -> m Bool
    -- ^ __Returns:__ true if the action was successful
dynamic_ShortcutFunc __funPtr widget args userData = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    maybeArgs <- case args of
        Nothing -> return FP.nullPtr
        Just jArgs -> do
            jArgs' <- unsafeManagedPtrGetPtr jArgs
            return jArgs'
    result <- (__dynamic_C_ShortcutFunc __funPtr) widget' maybeArgs userData
    let result' = (/= 0) result
    touchManagedPtr widget
    whenJust args touchManagedPtr
    return result'

-- | Generate a function pointer callable from C code, from a `C_ShortcutFunc`.
foreign import ccall "wrapper"
    mk_ShortcutFunc :: C_ShortcutFunc -> IO (FunPtr C_ShortcutFunc)

-- | Type for shortcuts based on user callbacks.
type ShortcutFunc =
    Gtk.Widget.Widget
    -- ^ /@widget@/: The widget passed to the activation
    -> Maybe GVariant
    -- ^ /@args@/: The arguments passed to the activation
    -> IO Bool
    -- ^ __Returns:__ true if the action was successful

-- | A convenience synonym for @`Nothing` :: `Maybe` `ShortcutFunc`@.
noShortcutFunc :: Maybe ShortcutFunc
noShortcutFunc = Nothing

-- | Type for shortcuts based on user callbacks.
type ShortcutFunc_WithClosures =
    Gtk.Widget.Widget
    -- ^ /@widget@/: The widget passed to the activation
    -> Maybe GVariant
    -- ^ /@args@/: The arguments passed to the activation
    -> Ptr ()
    -- ^ /@userData@/: The user data provided when activating the action
    -> IO Bool
    -- ^ __Returns:__ true if the action was successful

-- | A convenience synonym for @`Nothing` :: `Maybe` `ShortcutFunc_WithClosures`@.
noShortcutFunc_WithClosures :: Maybe ShortcutFunc_WithClosures
noShortcutFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ShortcutFunc :: ShortcutFunc -> ShortcutFunc_WithClosures
drop_closures_ShortcutFunc _f widget args _ = _f widget args

-- | Wrap the callback into a `GClosure`.
genClosure_ShortcutFunc :: MonadIO m => ShortcutFunc -> m (GClosure C_ShortcutFunc)
genClosure_ShortcutFunc cb = liftIO $ do
    let cb' = drop_closures_ShortcutFunc cb
    let cb'' = wrap_ShortcutFunc Nothing cb'
    mk_ShortcutFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ShortcutFunc` into a `C_ShortcutFunc`.
wrap_ShortcutFunc :: 
    Maybe (Ptr (FunPtr C_ShortcutFunc)) ->
    ShortcutFunc_WithClosures ->
    C_ShortcutFunc
wrap_ShortcutFunc gi'funptrptr gi'cb widget args userData = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    maybeArgs <-
        if args == FP.nullPtr
        then return Nothing
        else do
            args' <- B.GVariant.newGVariantFromPtr args
            return $ Just args'
    result <- gi'cb  widget' maybeArgs userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback ScaleFormatValueFunc
{- Callable
  { returnType = Just (TBasicType TUTF8)
  , returnMayBeNull = False
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "A newly allocated string describing a textual representation\n  of the given numerical value."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "scale"
          , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The `GtkScale`" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TBasicType TDouble
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The numeric value to format"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Function that formats the value of a scale.\n\nSee [method@Gtk.Scale.set_format_value_func]."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ScaleFormatValueFunc =
    Ptr Gtk.Scale.Scale ->
    CDouble ->
    Ptr () ->
    IO CString

-- Args: [ Arg
--           { argCName = "scale"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The `GtkScale`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The numeric value to format"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ScaleFormatValueFunc :: FunPtr C_ScaleFormatValueFunc -> C_ScaleFormatValueFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ScaleFormatValueFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Scale.IsScale a) =>
    FunPtr C_ScaleFormatValueFunc
    -> a
    -- ^ /@scale@/: The @GtkScale@
    -> Double
    -- ^ /@value@/: The numeric value to format
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m T.Text
    -- ^ __Returns:__ A newly allocated string describing a textual representation
    --   of the given numerical value.
dynamic_ScaleFormatValueFunc __funPtr scale value userData = liftIO $ do
    scale' <- unsafeManagedPtrCastPtr scale
    let value' = realToFrac value
    result <- (__dynamic_C_ScaleFormatValueFunc __funPtr) scale' value' userData
    checkUnexpectedReturnNULL "scaleFormatValueFunc" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr scale
    return result'

-- | Generate a function pointer callable from C code, from a `C_ScaleFormatValueFunc`.
foreign import ccall "wrapper"
    mk_ScaleFormatValueFunc :: C_ScaleFormatValueFunc -> IO (FunPtr C_ScaleFormatValueFunc)

-- | Function that formats the value of a scale.
-- 
-- See 'GI.Gtk.Objects.Scale.scaleSetFormatValueFunc'.
type ScaleFormatValueFunc =
    Gtk.Scale.Scale
    -- ^ /@scale@/: The @GtkScale@
    -> Double
    -- ^ /@value@/: The numeric value to format
    -> IO T.Text
    -- ^ __Returns:__ A newly allocated string describing a textual representation
    --   of the given numerical value.

-- | A convenience synonym for @`Nothing` :: `Maybe` `ScaleFormatValueFunc`@.
noScaleFormatValueFunc :: Maybe ScaleFormatValueFunc
noScaleFormatValueFunc = Nothing

-- | Function that formats the value of a scale.
-- 
-- See 'GI.Gtk.Objects.Scale.scaleSetFormatValueFunc'.
type ScaleFormatValueFunc_WithClosures =
    Gtk.Scale.Scale
    -- ^ /@scale@/: The @GtkScale@
    -> Double
    -- ^ /@value@/: The numeric value to format
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO T.Text
    -- ^ __Returns:__ A newly allocated string describing a textual representation
    --   of the given numerical value.

-- | A convenience synonym for @`Nothing` :: `Maybe` `ScaleFormatValueFunc_WithClosures`@.
noScaleFormatValueFunc_WithClosures :: Maybe ScaleFormatValueFunc_WithClosures
noScaleFormatValueFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ScaleFormatValueFunc :: ScaleFormatValueFunc -> ScaleFormatValueFunc_WithClosures
drop_closures_ScaleFormatValueFunc _f scale value _ = _f scale value

-- | Wrap the callback into a `GClosure`.
genClosure_ScaleFormatValueFunc :: MonadIO m => ScaleFormatValueFunc -> m (GClosure C_ScaleFormatValueFunc)
genClosure_ScaleFormatValueFunc cb = liftIO $ do
    let cb' = drop_closures_ScaleFormatValueFunc cb
    let cb'' = wrap_ScaleFormatValueFunc Nothing cb'
    mk_ScaleFormatValueFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ScaleFormatValueFunc` into a `C_ScaleFormatValueFunc`.
wrap_ScaleFormatValueFunc :: 
    Maybe (Ptr (FunPtr C_ScaleFormatValueFunc)) ->
    ScaleFormatValueFunc_WithClosures ->
    C_ScaleFormatValueFunc
wrap_ScaleFormatValueFunc gi'funptrptr gi'cb scale value userData = do
    scale' <- (newObject Gtk.Scale.Scale) scale
    let value' = realToFrac value
    result <- gi'cb  scale' value' userData
    maybeReleaseFunPtr gi'funptrptr
    result' <- textToCString result
    return result'


-- callback PrinterFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "%TRUE to stop the enumeration, %FALSE to continue"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "printer"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "Printer" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to gtk_enumerate_printers()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of function passed to gtk_enumerate_printers().\n\nNote that you need to ref @printer, if you want to keep\na reference to it after the function has returned."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PrinterFunc =
    Ptr Gtk.Printer.Printer ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to gtk_enumerate_printers()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PrinterFunc :: FunPtr C_PrinterFunc -> C_PrinterFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PrinterFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Printer.IsPrinter a) =>
    FunPtr C_PrinterFunc
    -> a
    -- ^ /@printer@/: a @GtkPrinter@
    -> Ptr ()
    -- ^ /@data@/: user data passed to 'GI.Gtk.Functions.enumeratePrinters'
    -> m Bool
    -- ^ __Returns:__ 'P.True' to stop the enumeration, 'P.False' to continue
dynamic_PrinterFunc __funPtr printer data_ = liftIO $ do
    printer' <- unsafeManagedPtrCastPtr printer
    result <- (__dynamic_C_PrinterFunc __funPtr) printer' data_
    let result' = (/= 0) result
    touchManagedPtr printer
    return result'

-- | Generate a function pointer callable from C code, from a `C_PrinterFunc`.
foreign import ccall "wrapper"
    mk_PrinterFunc :: C_PrinterFunc -> IO (FunPtr C_PrinterFunc)

-- | The type of function passed to 'GI.Gtk.Functions.enumeratePrinters'.
-- 
-- Note that you need to ref /@printer@/, if you want to keep
-- a reference to it after the function has returned.
type PrinterFunc =
    Gtk.Printer.Printer
    -- ^ /@printer@/: a @GtkPrinter@
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop the enumeration, 'P.False' to continue

-- | A convenience synonym for @`Nothing` :: `Maybe` `PrinterFunc`@.
noPrinterFunc :: Maybe PrinterFunc
noPrinterFunc = Nothing

-- | The type of function passed to 'GI.Gtk.Functions.enumeratePrinters'.
-- 
-- Note that you need to ref /@printer@/, if you want to keep
-- a reference to it after the function has returned.
type PrinterFunc_WithClosures =
    Gtk.Printer.Printer
    -- ^ /@printer@/: a @GtkPrinter@
    -> Ptr ()
    -- ^ /@data@/: user data passed to 'GI.Gtk.Functions.enumeratePrinters'
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop the enumeration, 'P.False' to continue

-- | A convenience synonym for @`Nothing` :: `Maybe` `PrinterFunc_WithClosures`@.
noPrinterFunc_WithClosures :: Maybe PrinterFunc_WithClosures
noPrinterFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PrinterFunc :: PrinterFunc -> PrinterFunc_WithClosures
drop_closures_PrinterFunc _f printer _ = _f printer

-- | Wrap the callback into a `GClosure`.
genClosure_PrinterFunc :: MonadIO m => PrinterFunc -> m (GClosure C_PrinterFunc)
genClosure_PrinterFunc cb = liftIO $ do
    let cb' = drop_closures_PrinterFunc cb
    let cb'' = wrap_PrinterFunc Nothing cb'
    mk_PrinterFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PrinterFunc` into a `C_PrinterFunc`.
wrap_PrinterFunc :: 
    Maybe (Ptr (FunPtr C_PrinterFunc)) ->
    PrinterFunc_WithClosures ->
    C_PrinterFunc
wrap_PrinterFunc gi'funptrptr gi'cb printer data_ = do
    printer' <- (newObject Gtk.Printer.Printer) printer
    result <- gi'cb  printer' data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback PrintSettingsFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "key"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the setting key" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the setting value" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "The user data provided with the function"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Function called by [method@Gtk.PrintSettings.foreach] on every key/value pair\ninside a [class@Gtk.PrintSettings]."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PrintSettingsFunc =
    CString ->
    CString ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "key"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the setting key" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the setting value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The user data provided with the function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PrintSettingsFunc :: FunPtr C_PrintSettingsFunc -> C_PrintSettingsFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PrintSettingsFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PrintSettingsFunc
    -> T.Text
    -- ^ /@key@/: the setting key
    -> T.Text
    -- ^ /@value@/: the setting value
    -> Ptr ()
    -- ^ /@userData@/: The user data provided with the function
    -> m ()
dynamic_PrintSettingsFunc __funPtr key value userData = liftIO $ do
    key' <- textToCString key
    value' <- textToCString value
    (__dynamic_C_PrintSettingsFunc __funPtr) key' value' userData
    freeMem key'
    freeMem value'
    return ()

-- | Generate a function pointer callable from C code, from a `C_PrintSettingsFunc`.
foreign import ccall "wrapper"
    mk_PrintSettingsFunc :: C_PrintSettingsFunc -> IO (FunPtr C_PrintSettingsFunc)

-- | Function called by 'GI.Gtk.Objects.PrintSettings.printSettingsForeach' on every key\/value pair
-- inside a t'GI.Gtk.Objects.PrintSettings.PrintSettings'.
type PrintSettingsFunc =
    T.Text
    -- ^ /@key@/: the setting key
    -> T.Text
    -- ^ /@value@/: the setting value
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PrintSettingsFunc`@.
noPrintSettingsFunc :: Maybe PrintSettingsFunc
noPrintSettingsFunc = Nothing

-- | Function called by 'GI.Gtk.Objects.PrintSettings.printSettingsForeach' on every key\/value pair
-- inside a t'GI.Gtk.Objects.PrintSettings.PrintSettings'.
type PrintSettingsFunc_WithClosures =
    T.Text
    -- ^ /@key@/: the setting key
    -> T.Text
    -- ^ /@value@/: the setting value
    -> Ptr ()
    -- ^ /@userData@/: The user data provided with the function
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PrintSettingsFunc_WithClosures`@.
noPrintSettingsFunc_WithClosures :: Maybe PrintSettingsFunc_WithClosures
noPrintSettingsFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PrintSettingsFunc :: PrintSettingsFunc -> PrintSettingsFunc_WithClosures
drop_closures_PrintSettingsFunc _f key value _ = _f key value

-- | Wrap the callback into a `GClosure`.
genClosure_PrintSettingsFunc :: MonadIO m => PrintSettingsFunc -> m (GClosure C_PrintSettingsFunc)
genClosure_PrintSettingsFunc cb = liftIO $ do
    let cb' = drop_closures_PrintSettingsFunc cb
    let cb'' = wrap_PrintSettingsFunc Nothing cb'
    mk_PrintSettingsFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PrintSettingsFunc` into a `C_PrintSettingsFunc`.
wrap_PrintSettingsFunc :: 
    Maybe (Ptr (FunPtr C_PrintSettingsFunc)) ->
    PrintSettingsFunc_WithClosures ->
    C_PrintSettingsFunc
wrap_PrintSettingsFunc gi'funptrptr gi'cb key value userData = do
    key' <- cstringToText key
    value' <- cstringToText value
    gi'cb  key' value' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback PrintJobCompleteFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "print_job"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "PrintJob" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the `GtkPrintJob`" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data that has been passed to gtk_print_job_send()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = 1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "error"
          , argType = TError
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "a `GError` that contains error information if the sending\n  of the print job failed, otherwise %NULL"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of callback that is passed to gtk_print_job_send().\n\nIt is called when the print job has been completely sent."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PrintJobCompleteFunc =
    Ptr Gtk.PrintJob.PrintJob ->
    Ptr () ->
    Ptr GError ->
    IO ()

-- Args: [ Arg
--           { argCName = "print_job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data that has been passed to gtk_print_job_send()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = 1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a `GError` that contains error information if the sending\n  of the print job failed, otherwise %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PrintJobCompleteFunc :: FunPtr C_PrintJobCompleteFunc -> C_PrintJobCompleteFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PrintJobCompleteFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.PrintJob.IsPrintJob a) =>
    FunPtr C_PrintJobCompleteFunc
    -> a
    -- ^ /@printJob@/: the @GtkPrintJob@
    -> Ptr ()
    -- ^ /@userData@/: user data that has been passed to 'GI.Gtk.Objects.PrintJob.printJobSend'
    -> GError
    -- ^ /@error@/: a @GError@ that contains error information if the sending
    --   of the print job failed, otherwise 'P.Nothing'
    -> m ()
dynamic_PrintJobCompleteFunc __funPtr printJob userData error_ = liftIO $ do
    printJob' <- unsafeManagedPtrCastPtr printJob
    error_' <- unsafeManagedPtrGetPtr error_
    (__dynamic_C_PrintJobCompleteFunc __funPtr) printJob' userData error_'
    touchManagedPtr printJob
    touchManagedPtr error_
    return ()

-- | Generate a function pointer callable from C code, from a `C_PrintJobCompleteFunc`.
foreign import ccall "wrapper"
    mk_PrintJobCompleteFunc :: C_PrintJobCompleteFunc -> IO (FunPtr C_PrintJobCompleteFunc)

-- | The type of callback that is passed to 'GI.Gtk.Objects.PrintJob.printJobSend'.
-- 
-- It is called when the print job has been completely sent.
type PrintJobCompleteFunc =
    Gtk.PrintJob.PrintJob
    -- ^ /@printJob@/: the @GtkPrintJob@
    -> GError
    -- ^ /@error@/: a @GError@ that contains error information if the sending
    --   of the print job failed, otherwise 'P.Nothing'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PrintJobCompleteFunc`@.
noPrintJobCompleteFunc :: Maybe PrintJobCompleteFunc
noPrintJobCompleteFunc = Nothing

-- | The type of callback that is passed to 'GI.Gtk.Objects.PrintJob.printJobSend'.
-- 
-- It is called when the print job has been completely sent.
type PrintJobCompleteFunc_WithClosures =
    Gtk.PrintJob.PrintJob
    -- ^ /@printJob@/: the @GtkPrintJob@
    -> Ptr ()
    -- ^ /@userData@/: user data that has been passed to 'GI.Gtk.Objects.PrintJob.printJobSend'
    -> GError
    -- ^ /@error@/: a @GError@ that contains error information if the sending
    --   of the print job failed, otherwise 'P.Nothing'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PrintJobCompleteFunc_WithClosures`@.
noPrintJobCompleteFunc_WithClosures :: Maybe PrintJobCompleteFunc_WithClosures
noPrintJobCompleteFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PrintJobCompleteFunc :: PrintJobCompleteFunc -> PrintJobCompleteFunc_WithClosures
drop_closures_PrintJobCompleteFunc _f printJob _ error_ = _f printJob error_

-- | Wrap the callback into a `GClosure`.
genClosure_PrintJobCompleteFunc :: MonadIO m => PrintJobCompleteFunc -> m (GClosure C_PrintJobCompleteFunc)
genClosure_PrintJobCompleteFunc cb = liftIO $ do
    let cb' = drop_closures_PrintJobCompleteFunc cb
    let cb'' = wrap_PrintJobCompleteFunc Nothing cb'
    mk_PrintJobCompleteFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PrintJobCompleteFunc` into a `C_PrintJobCompleteFunc`.
wrap_PrintJobCompleteFunc :: 
    Maybe (Ptr (FunPtr C_PrintJobCompleteFunc)) ->
    PrintJobCompleteFunc_WithClosures ->
    C_PrintJobCompleteFunc
wrap_PrintJobCompleteFunc gi'funptrptr gi'cb printJob userData error_ = do
    printJob' <- (newObject Gtk.PrintJob.PrintJob) printJob
    error_' <- (newBoxed GError) error_
    gi'cb  printJob' userData error_'
    maybeReleaseFunPtr gi'funptrptr


-- callback PageSetupDoneFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "page_setup"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "PageSetup" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the `GtkPageSetup` that has been passed to\n  gtk_print_run_page_setup_dialog_async()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "user data that has been passed to\n  gtk_print_run_page_setup_dialog_async()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of function that is passed to\ngtk_print_run_page_setup_dialog_async().\n\nThis function will be called when the page setup dialog\nis dismissed, and also serves as destroy notify for @data."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PageSetupDoneFunc =
    Ptr Gtk.PageSetup.PageSetup ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "page_setup"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PageSetup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the `GtkPageSetup` that has been passed to\n  gtk_print_run_page_setup_dialog_async()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "user data that has been passed to\n  gtk_print_run_page_setup_dialog_async()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PageSetupDoneFunc :: FunPtr C_PageSetupDoneFunc -> C_PageSetupDoneFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PageSetupDoneFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.PageSetup.IsPageSetup a) =>
    FunPtr C_PageSetupDoneFunc
    -> a
    -- ^ /@pageSetup@/: the @GtkPageSetup@ that has been passed to
    --   'GI.Gtk.Functions.printRunPageSetupDialogAsync'
    -> Ptr ()
    -- ^ /@data@/: user data that has been passed to
    --   'GI.Gtk.Functions.printRunPageSetupDialogAsync'
    -> m ()
dynamic_PageSetupDoneFunc __funPtr pageSetup data_ = liftIO $ do
    pageSetup' <- unsafeManagedPtrCastPtr pageSetup
    (__dynamic_C_PageSetupDoneFunc __funPtr) pageSetup' data_
    touchManagedPtr pageSetup
    return ()

-- | Generate a function pointer callable from C code, from a `C_PageSetupDoneFunc`.
foreign import ccall "wrapper"
    mk_PageSetupDoneFunc :: C_PageSetupDoneFunc -> IO (FunPtr C_PageSetupDoneFunc)

-- | The type of function that is passed to
-- 'GI.Gtk.Functions.printRunPageSetupDialogAsync'.
-- 
-- This function will be called when the page setup dialog
-- is dismissed, and also serves as destroy notify for /@data@/.
type PageSetupDoneFunc =
    Gtk.PageSetup.PageSetup
    -- ^ /@pageSetup@/: the @GtkPageSetup@ that has been passed to
    --   'GI.Gtk.Functions.printRunPageSetupDialogAsync'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PageSetupDoneFunc`@.
noPageSetupDoneFunc :: Maybe PageSetupDoneFunc
noPageSetupDoneFunc = Nothing

-- | The type of function that is passed to
-- 'GI.Gtk.Functions.printRunPageSetupDialogAsync'.
-- 
-- This function will be called when the page setup dialog
-- is dismissed, and also serves as destroy notify for /@data@/.
type PageSetupDoneFunc_WithClosures =
    Gtk.PageSetup.PageSetup
    -- ^ /@pageSetup@/: the @GtkPageSetup@ that has been passed to
    --   'GI.Gtk.Functions.printRunPageSetupDialogAsync'
    -> Ptr ()
    -- ^ /@data@/: user data that has been passed to
    --   'GI.Gtk.Functions.printRunPageSetupDialogAsync'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PageSetupDoneFunc_WithClosures`@.
noPageSetupDoneFunc_WithClosures :: Maybe PageSetupDoneFunc_WithClosures
noPageSetupDoneFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PageSetupDoneFunc :: PageSetupDoneFunc -> PageSetupDoneFunc_WithClosures
drop_closures_PageSetupDoneFunc _f pageSetup _ = _f pageSetup

-- | Wrap the callback into a `GClosure`.
genClosure_PageSetupDoneFunc :: MonadIO m => PageSetupDoneFunc -> m (GClosure C_PageSetupDoneFunc)
genClosure_PageSetupDoneFunc cb = liftIO $ do
    let cb' = drop_closures_PageSetupDoneFunc cb
    let cb'' = wrap_PageSetupDoneFunc Nothing cb'
    mk_PageSetupDoneFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PageSetupDoneFunc` into a `C_PageSetupDoneFunc`.
wrap_PageSetupDoneFunc :: 
    Maybe (Ptr (FunPtr C_PageSetupDoneFunc)) ->
    PageSetupDoneFunc_WithClosures ->
    C_PageSetupDoneFunc
wrap_PageSetupDoneFunc gi'funptrptr gi'cb pageSetup data_ = do
    pageSetup' <- (newObject Gtk.PageSetup.PageSetup) pageSetup
    gi'cb  pageSetup' data_
    maybeReleaseFunPtr gi'funptrptr


-- callback MenuButtonCreatePopupFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "menu_button"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "MenuButton" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the `GtkMenuButton`"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "User data passed to gtk_menu_button_set_create_popup_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "User-provided callback function to create a popup for a\n`GtkMenuButton` on demand.\n\nThis function is called when the popup of @menu_button is shown,\nbut none has been provided via [method@Gtk.MenuButton.set_popover]\nor [method@Gtk.MenuButton.set_menu_model]."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_MenuButtonCreatePopupFunc =
    Ptr Gtk.MenuButton.MenuButton ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "menu_button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MenuButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkMenuButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "User data passed to gtk_menu_button_set_create_popup_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_MenuButtonCreatePopupFunc :: FunPtr C_MenuButtonCreatePopupFunc -> C_MenuButtonCreatePopupFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_MenuButtonCreatePopupFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.MenuButton.IsMenuButton a) =>
    FunPtr C_MenuButtonCreatePopupFunc
    -> a
    -- ^ /@menuButton@/: the @GtkMenuButton@
    -> Ptr ()
    -- ^ /@userData@/: User data passed to 'GI.Gtk.Objects.MenuButton.menuButtonSetCreatePopupFunc'
    -> m ()
dynamic_MenuButtonCreatePopupFunc __funPtr menuButton userData = liftIO $ do
    menuButton' <- unsafeManagedPtrCastPtr menuButton
    (__dynamic_C_MenuButtonCreatePopupFunc __funPtr) menuButton' userData
    touchManagedPtr menuButton
    return ()

-- | Generate a function pointer callable from C code, from a `C_MenuButtonCreatePopupFunc`.
foreign import ccall "wrapper"
    mk_MenuButtonCreatePopupFunc :: C_MenuButtonCreatePopupFunc -> IO (FunPtr C_MenuButtonCreatePopupFunc)

-- | User-provided callback function to create a popup for a
-- @GtkMenuButton@ on demand.
-- 
-- This function is called when the popup of /@menuButton@/ is shown,
-- but none has been provided via 'GI.Gtk.Objects.MenuButton.menuButtonSetPopover'
-- or 'GI.Gtk.Objects.MenuButton.menuButtonSetMenuModel'.
type MenuButtonCreatePopupFunc =
    Gtk.MenuButton.MenuButton
    -- ^ /@menuButton@/: the @GtkMenuButton@
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `MenuButtonCreatePopupFunc`@.
noMenuButtonCreatePopupFunc :: Maybe MenuButtonCreatePopupFunc
noMenuButtonCreatePopupFunc = Nothing

-- | User-provided callback function to create a popup for a
-- @GtkMenuButton@ on demand.
-- 
-- This function is called when the popup of /@menuButton@/ is shown,
-- but none has been provided via 'GI.Gtk.Objects.MenuButton.menuButtonSetPopover'
-- or 'GI.Gtk.Objects.MenuButton.menuButtonSetMenuModel'.
type MenuButtonCreatePopupFunc_WithClosures =
    Gtk.MenuButton.MenuButton
    -- ^ /@menuButton@/: the @GtkMenuButton@
    -> Ptr ()
    -- ^ /@userData@/: User data passed to 'GI.Gtk.Objects.MenuButton.menuButtonSetCreatePopupFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `MenuButtonCreatePopupFunc_WithClosures`@.
noMenuButtonCreatePopupFunc_WithClosures :: Maybe MenuButtonCreatePopupFunc_WithClosures
noMenuButtonCreatePopupFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_MenuButtonCreatePopupFunc :: MenuButtonCreatePopupFunc -> MenuButtonCreatePopupFunc_WithClosures
drop_closures_MenuButtonCreatePopupFunc _f menuButton _ = _f menuButton

-- | Wrap the callback into a `GClosure`.
genClosure_MenuButtonCreatePopupFunc :: MonadIO m => MenuButtonCreatePopupFunc -> m (GClosure C_MenuButtonCreatePopupFunc)
genClosure_MenuButtonCreatePopupFunc cb = liftIO $ do
    let cb' = drop_closures_MenuButtonCreatePopupFunc cb
    let cb'' = wrap_MenuButtonCreatePopupFunc Nothing cb'
    mk_MenuButtonCreatePopupFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `MenuButtonCreatePopupFunc` into a `C_MenuButtonCreatePopupFunc`.
wrap_MenuButtonCreatePopupFunc :: 
    Maybe (Ptr (FunPtr C_MenuButtonCreatePopupFunc)) ->
    MenuButtonCreatePopupFunc_WithClosures ->
    C_MenuButtonCreatePopupFunc
wrap_MenuButtonCreatePopupFunc gi'funptrptr gi'cb menuButton userData = do
    menuButton' <- (newObject Gtk.MenuButton.MenuButton) menuButton
    gi'cb  menuButton' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback MapListModelMapFunc
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "GObject" , name = "Object" })
  , returnMayBeNull = False
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText = Just "The item to map to" , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "item"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The item to map" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "User function that is called to map an @item of the original model to\nan item expected by the map model.\n\nThe returned items must conform to the item type of the model they are\nused with."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_MapListModelMapFunc =
    Ptr GObject.Object.Object ->
    Ptr () ->
    IO (Ptr GObject.Object.Object)

-- Args: [ Arg
--           { argCName = "item"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The item to map" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GObject" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_MapListModelMapFunc :: FunPtr C_MapListModelMapFunc -> C_MapListModelMapFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_MapListModelMapFunc ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_MapListModelMapFunc
    -> a
    -- ^ /@item@/: The item to map
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m GObject.Object.Object
    -- ^ __Returns:__ The item to map to
dynamic_MapListModelMapFunc __funPtr item userData = liftIO $ do
    item' <- B.ManagedPtr.disownObject item
    result <- (__dynamic_C_MapListModelMapFunc __funPtr) item' userData
    checkUnexpectedReturnNULL "mapListModelMapFunc" result
    result' <- (wrapObject GObject.Object.Object) result
    touchManagedPtr item
    return result'

-- | Generate a function pointer callable from C code, from a `C_MapListModelMapFunc`.
foreign import ccall "wrapper"
    mk_MapListModelMapFunc :: C_MapListModelMapFunc -> IO (FunPtr C_MapListModelMapFunc)

-- | User function that is called to map an /@item@/ of the original model to
-- an item expected by the map model.
-- 
-- The returned items must conform to the item type of the model they are
-- used with.
type MapListModelMapFunc =
    GObject.Object.Object
    -- ^ /@item@/: The item to map
    -> IO GObject.Object.Object
    -- ^ __Returns:__ The item to map to

-- | A convenience synonym for @`Nothing` :: `Maybe` `MapListModelMapFunc`@.
noMapListModelMapFunc :: Maybe MapListModelMapFunc
noMapListModelMapFunc = Nothing

-- | User function that is called to map an /@item@/ of the original model to
-- an item expected by the map model.
-- 
-- The returned items must conform to the item type of the model they are
-- used with.
type MapListModelMapFunc_WithClosures =
    GObject.Object.Object
    -- ^ /@item@/: The item to map
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO GObject.Object.Object
    -- ^ __Returns:__ The item to map to

-- | A convenience synonym for @`Nothing` :: `Maybe` `MapListModelMapFunc_WithClosures`@.
noMapListModelMapFunc_WithClosures :: Maybe MapListModelMapFunc_WithClosures
noMapListModelMapFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_MapListModelMapFunc :: MapListModelMapFunc -> MapListModelMapFunc_WithClosures
drop_closures_MapListModelMapFunc _f item _ = _f item

-- | Wrap the callback into a `GClosure`.
genClosure_MapListModelMapFunc :: MonadIO m => MapListModelMapFunc -> m (GClosure C_MapListModelMapFunc)
genClosure_MapListModelMapFunc cb = liftIO $ do
    let cb' = drop_closures_MapListModelMapFunc cb
    let cb'' = wrap_MapListModelMapFunc Nothing cb'
    mk_MapListModelMapFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `MapListModelMapFunc` into a `C_MapListModelMapFunc`.
wrap_MapListModelMapFunc :: 
    Maybe (Ptr (FunPtr C_MapListModelMapFunc)) ->
    MapListModelMapFunc_WithClosures ->
    C_MapListModelMapFunc
wrap_MapListModelMapFunc gi'funptrptr gi'cb item userData = do
    item' <- (wrapObject GObject.Object.Object) item
    result <- gi'cb  item' userData
    maybeReleaseFunPtr gi'funptrptr
    result' <- B.ManagedPtr.disownObject result
    return result'


-- callback ListBoxUpdateHeaderFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "row"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the row to update" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "before"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the row before @row, or %NULL if it is first"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Whenever @row changes or which row is before @row changes this\nis called, which lets you update the header on @row.\n\nYou may remove or set a new one via [method@Gtk.ListBoxRow.set_header]\nor just change the state of the current header widget."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ListBoxUpdateHeaderFunc =
    Ptr Gtk.ListBoxRow.ListBoxRow ->
    Ptr Gtk.ListBoxRow.ListBoxRow ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the row to update" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "before"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the row before @row, or %NULL if it is first"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ListBoxUpdateHeaderFunc :: FunPtr C_ListBoxUpdateHeaderFunc -> C_ListBoxUpdateHeaderFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ListBoxUpdateHeaderFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.ListBoxRow.IsListBoxRow a, Gtk.ListBoxRow.IsListBoxRow b) =>
    FunPtr C_ListBoxUpdateHeaderFunc
    -> a
    -- ^ /@row@/: the row to update
    -> Maybe (b)
    -- ^ /@before@/: the row before /@row@/, or 'P.Nothing' if it is first
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m ()
dynamic_ListBoxUpdateHeaderFunc __funPtr row before userData = liftIO $ do
    row' <- unsafeManagedPtrCastPtr row
    maybeBefore <- case before of
        Nothing -> return FP.nullPtr
        Just jBefore -> do
            jBefore' <- unsafeManagedPtrCastPtr jBefore
            return jBefore'
    (__dynamic_C_ListBoxUpdateHeaderFunc __funPtr) row' maybeBefore userData
    touchManagedPtr row
    whenJust before touchManagedPtr
    return ()

-- | Generate a function pointer callable from C code, from a `C_ListBoxUpdateHeaderFunc`.
foreign import ccall "wrapper"
    mk_ListBoxUpdateHeaderFunc :: C_ListBoxUpdateHeaderFunc -> IO (FunPtr C_ListBoxUpdateHeaderFunc)

-- | Whenever /@row@/ changes or which row is before /@row@/ changes this
-- is called, which lets you update the header on /@row@/.
-- 
-- You may remove or set a new one via 'GI.Gtk.Objects.ListBoxRow.listBoxRowSetHeader'
-- or just change the state of the current header widget.
type ListBoxUpdateHeaderFunc =
    Gtk.ListBoxRow.ListBoxRow
    -- ^ /@row@/: the row to update
    -> Maybe Gtk.ListBoxRow.ListBoxRow
    -- ^ /@before@/: the row before /@row@/, or 'P.Nothing' if it is first
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ListBoxUpdateHeaderFunc`@.
noListBoxUpdateHeaderFunc :: Maybe ListBoxUpdateHeaderFunc
noListBoxUpdateHeaderFunc = Nothing

-- | Whenever /@row@/ changes or which row is before /@row@/ changes this
-- is called, which lets you update the header on /@row@/.
-- 
-- You may remove or set a new one via 'GI.Gtk.Objects.ListBoxRow.listBoxRowSetHeader'
-- or just change the state of the current header widget.
type ListBoxUpdateHeaderFunc_WithClosures =
    Gtk.ListBoxRow.ListBoxRow
    -- ^ /@row@/: the row to update
    -> Maybe Gtk.ListBoxRow.ListBoxRow
    -- ^ /@before@/: the row before /@row@/, or 'P.Nothing' if it is first
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ListBoxUpdateHeaderFunc_WithClosures`@.
noListBoxUpdateHeaderFunc_WithClosures :: Maybe ListBoxUpdateHeaderFunc_WithClosures
noListBoxUpdateHeaderFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ListBoxUpdateHeaderFunc :: ListBoxUpdateHeaderFunc -> ListBoxUpdateHeaderFunc_WithClosures
drop_closures_ListBoxUpdateHeaderFunc _f row before _ = _f row before

-- | Wrap the callback into a `GClosure`.
genClosure_ListBoxUpdateHeaderFunc :: MonadIO m => ListBoxUpdateHeaderFunc -> m (GClosure C_ListBoxUpdateHeaderFunc)
genClosure_ListBoxUpdateHeaderFunc cb = liftIO $ do
    let cb' = drop_closures_ListBoxUpdateHeaderFunc cb
    let cb'' = wrap_ListBoxUpdateHeaderFunc Nothing cb'
    mk_ListBoxUpdateHeaderFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ListBoxUpdateHeaderFunc` into a `C_ListBoxUpdateHeaderFunc`.
wrap_ListBoxUpdateHeaderFunc :: 
    Maybe (Ptr (FunPtr C_ListBoxUpdateHeaderFunc)) ->
    ListBoxUpdateHeaderFunc_WithClosures ->
    C_ListBoxUpdateHeaderFunc
wrap_ListBoxUpdateHeaderFunc gi'funptrptr gi'cb row before userData = do
    row' <- (newObject Gtk.ListBoxRow.ListBoxRow) row
    maybeBefore <-
        if before == FP.nullPtr
        then return Nothing
        else do
            before' <- (newObject Gtk.ListBoxRow.ListBoxRow) before
            return $ Just before'
    gi'cb  row' maybeBefore userData
    maybeReleaseFunPtr gi'funptrptr


-- callback ListBoxSortFunc
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "< 0 if @row1 should be before @row2, 0 if they are\n  equal and > 0 otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "row1"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the first row" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "row2"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the second row" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "Compare two rows to determine which should be first."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ListBoxSortFunc =
    Ptr Gtk.ListBoxRow.ListBoxRow ->
    Ptr Gtk.ListBoxRow.ListBoxRow ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "row1"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the first row" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row2"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the second row" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ListBoxSortFunc :: FunPtr C_ListBoxSortFunc -> C_ListBoxSortFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ListBoxSortFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.ListBoxRow.IsListBoxRow a, Gtk.ListBoxRow.IsListBoxRow b) =>
    FunPtr C_ListBoxSortFunc
    -> a
    -- ^ /@row1@/: the first row
    -> b
    -- ^ /@row2@/: the second row
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m Int32
    -- ^ __Returns:__ \< 0 if /@row1@/ should be before /@row2@/, 0 if they are
    --   equal and > 0 otherwise
dynamic_ListBoxSortFunc __funPtr row1 row2 userData = liftIO $ do
    row1' <- unsafeManagedPtrCastPtr row1
    row2' <- unsafeManagedPtrCastPtr row2
    result <- (__dynamic_C_ListBoxSortFunc __funPtr) row1' row2' userData
    touchManagedPtr row1
    touchManagedPtr row2
    return result

-- | Generate a function pointer callable from C code, from a `C_ListBoxSortFunc`.
foreign import ccall "wrapper"
    mk_ListBoxSortFunc :: C_ListBoxSortFunc -> IO (FunPtr C_ListBoxSortFunc)

-- | Compare two rows to determine which should be first.
type ListBoxSortFunc =
    Gtk.ListBoxRow.ListBoxRow
    -- ^ /@row1@/: the first row
    -> Gtk.ListBoxRow.ListBoxRow
    -- ^ /@row2@/: the second row
    -> IO Int32
    -- ^ __Returns:__ \< 0 if /@row1@/ should be before /@row2@/, 0 if they are
    --   equal and > 0 otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `ListBoxSortFunc`@.
noListBoxSortFunc :: Maybe ListBoxSortFunc
noListBoxSortFunc = Nothing

-- | Compare two rows to determine which should be first.
type ListBoxSortFunc_WithClosures =
    Gtk.ListBoxRow.ListBoxRow
    -- ^ /@row1@/: the first row
    -> Gtk.ListBoxRow.ListBoxRow
    -- ^ /@row2@/: the second row
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO Int32
    -- ^ __Returns:__ \< 0 if /@row1@/ should be before /@row2@/, 0 if they are
    --   equal and > 0 otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `ListBoxSortFunc_WithClosures`@.
noListBoxSortFunc_WithClosures :: Maybe ListBoxSortFunc_WithClosures
noListBoxSortFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ListBoxSortFunc :: ListBoxSortFunc -> ListBoxSortFunc_WithClosures
drop_closures_ListBoxSortFunc _f row1 row2 _ = _f row1 row2

-- | Wrap the callback into a `GClosure`.
genClosure_ListBoxSortFunc :: MonadIO m => ListBoxSortFunc -> m (GClosure C_ListBoxSortFunc)
genClosure_ListBoxSortFunc cb = liftIO $ do
    let cb' = drop_closures_ListBoxSortFunc cb
    let cb'' = wrap_ListBoxSortFunc Nothing cb'
    mk_ListBoxSortFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ListBoxSortFunc` into a `C_ListBoxSortFunc`.
wrap_ListBoxSortFunc :: 
    Maybe (Ptr (FunPtr C_ListBoxSortFunc)) ->
    ListBoxSortFunc_WithClosures ->
    C_ListBoxSortFunc
wrap_ListBoxSortFunc gi'funptrptr gi'cb row1 row2 userData = do
    row1' <- (newObject Gtk.ListBoxRow.ListBoxRow) row1
    row2' <- (newObject Gtk.ListBoxRow.ListBoxRow) row2
    result <- gi'cb  row1' row2' userData
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback ListBoxForeachFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "box"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "ListBox" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "row"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `GtkListBoxRow`" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function used by gtk_list_box_selected_foreach().\n\nIt will be called on every selected child of the @box."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ListBoxForeachFunc =
    Ptr Gtk.ListBox.ListBox ->
    Ptr Gtk.ListBoxRow.ListBoxRow ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBoxRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ListBoxForeachFunc :: FunPtr C_ListBoxForeachFunc -> C_ListBoxForeachFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ListBoxForeachFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.ListBox.IsListBox a, Gtk.ListBoxRow.IsListBoxRow b) =>
    FunPtr C_ListBoxForeachFunc
    -> a
    -- ^ /@box@/: a @GtkListBox@
    -> b
    -- ^ /@row@/: a @GtkListBoxRow@
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m ()
dynamic_ListBoxForeachFunc __funPtr box row userData = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    row' <- unsafeManagedPtrCastPtr row
    (__dynamic_C_ListBoxForeachFunc __funPtr) box' row' userData
    touchManagedPtr box
    touchManagedPtr row
    return ()

-- | Generate a function pointer callable from C code, from a `C_ListBoxForeachFunc`.
foreign import ccall "wrapper"
    mk_ListBoxForeachFunc :: C_ListBoxForeachFunc -> IO (FunPtr C_ListBoxForeachFunc)

-- | A function used by 'GI.Gtk.Objects.ListBox.listBoxSelectedForeach'.
-- 
-- It will be called on every selected child of the /@box@/.
type ListBoxForeachFunc =
    Gtk.ListBox.ListBox
    -- ^ /@box@/: a @GtkListBox@
    -> Gtk.ListBoxRow.ListBoxRow
    -- ^ /@row@/: a @GtkListBoxRow@
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ListBoxForeachFunc`@.
noListBoxForeachFunc :: Maybe ListBoxForeachFunc
noListBoxForeachFunc = Nothing

-- | A function used by 'GI.Gtk.Objects.ListBox.listBoxSelectedForeach'.
-- 
-- It will be called on every selected child of the /@box@/.
type ListBoxForeachFunc_WithClosures =
    Gtk.ListBox.ListBox
    -- ^ /@box@/: a @GtkListBox@
    -> Gtk.ListBoxRow.ListBoxRow
    -- ^ /@row@/: a @GtkListBoxRow@
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ListBoxForeachFunc_WithClosures`@.
noListBoxForeachFunc_WithClosures :: Maybe ListBoxForeachFunc_WithClosures
noListBoxForeachFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ListBoxForeachFunc :: ListBoxForeachFunc -> ListBoxForeachFunc_WithClosures
drop_closures_ListBoxForeachFunc _f box row _ = _f box row

-- | Wrap the callback into a `GClosure`.
genClosure_ListBoxForeachFunc :: MonadIO m => ListBoxForeachFunc -> m (GClosure C_ListBoxForeachFunc)
genClosure_ListBoxForeachFunc cb = liftIO $ do
    let cb' = drop_closures_ListBoxForeachFunc cb
    let cb'' = wrap_ListBoxForeachFunc Nothing cb'
    mk_ListBoxForeachFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ListBoxForeachFunc` into a `C_ListBoxForeachFunc`.
wrap_ListBoxForeachFunc :: 
    Maybe (Ptr (FunPtr C_ListBoxForeachFunc)) ->
    ListBoxForeachFunc_WithClosures ->
    C_ListBoxForeachFunc
wrap_ListBoxForeachFunc gi'funptrptr gi'cb box row userData = do
    box' <- (newObject Gtk.ListBox.ListBox) box
    row' <- (newObject Gtk.ListBoxRow.ListBoxRow) row
    gi'cb  box' row' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback ListBoxFilterFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "%TRUE if the row should be visible, %FALSE otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "row"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the row that may be filtered"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Will be called whenever the row changes or is added and lets you control\nif the row should be visible or not."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ListBoxFilterFunc =
    Ptr Gtk.ListBoxRow.ListBoxRow ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the row that may be filtered"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ListBoxFilterFunc :: FunPtr C_ListBoxFilterFunc -> C_ListBoxFilterFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ListBoxFilterFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.ListBoxRow.IsListBoxRow a) =>
    FunPtr C_ListBoxFilterFunc
    -> a
    -- ^ /@row@/: the row that may be filtered
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the row should be visible, 'P.False' otherwise
dynamic_ListBoxFilterFunc __funPtr row userData = liftIO $ do
    row' <- unsafeManagedPtrCastPtr row
    result <- (__dynamic_C_ListBoxFilterFunc __funPtr) row' userData
    let result' = (/= 0) result
    touchManagedPtr row
    return result'

-- | Generate a function pointer callable from C code, from a `C_ListBoxFilterFunc`.
foreign import ccall "wrapper"
    mk_ListBoxFilterFunc :: C_ListBoxFilterFunc -> IO (FunPtr C_ListBoxFilterFunc)

-- | Will be called whenever the row changes or is added and lets you control
-- if the row should be visible or not.
type ListBoxFilterFunc =
    Gtk.ListBoxRow.ListBoxRow
    -- ^ /@row@/: the row that may be filtered
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the row should be visible, 'P.False' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `ListBoxFilterFunc`@.
noListBoxFilterFunc :: Maybe ListBoxFilterFunc
noListBoxFilterFunc = Nothing

-- | Will be called whenever the row changes or is added and lets you control
-- if the row should be visible or not.
type ListBoxFilterFunc_WithClosures =
    Gtk.ListBoxRow.ListBoxRow
    -- ^ /@row@/: the row that may be filtered
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the row should be visible, 'P.False' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `ListBoxFilterFunc_WithClosures`@.
noListBoxFilterFunc_WithClosures :: Maybe ListBoxFilterFunc_WithClosures
noListBoxFilterFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ListBoxFilterFunc :: ListBoxFilterFunc -> ListBoxFilterFunc_WithClosures
drop_closures_ListBoxFilterFunc _f row _ = _f row

-- | Wrap the callback into a `GClosure`.
genClosure_ListBoxFilterFunc :: MonadIO m => ListBoxFilterFunc -> m (GClosure C_ListBoxFilterFunc)
genClosure_ListBoxFilterFunc cb = liftIO $ do
    let cb' = drop_closures_ListBoxFilterFunc cb
    let cb'' = wrap_ListBoxFilterFunc Nothing cb'
    mk_ListBoxFilterFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ListBoxFilterFunc` into a `C_ListBoxFilterFunc`.
wrap_ListBoxFilterFunc :: 
    Maybe (Ptr (FunPtr C_ListBoxFilterFunc)) ->
    ListBoxFilterFunc_WithClosures ->
    C_ListBoxFilterFunc
wrap_ListBoxFilterFunc gi'funptrptr gi'cb row userData = do
    row' <- (newObject Gtk.ListBoxRow.ListBoxRow) row
    result <- gi'cb  row' userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback ListBoxCreateWidgetFunc
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
  , returnMayBeNull = False
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText = Just "a `GtkWidget` that represents @item"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "item"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the item from the model for which to create a widget for"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Called for list boxes that are bound to a `GListModel` with\ngtk_list_box_bind_model() for each item that gets added to the model.\n\nIf the widget returned is not a #GtkListBoxRow widget, then the widget\nwill be inserted as the child of an intermediate #GtkListBoxRow."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ListBoxCreateWidgetFunc =
    Ptr GObject.Object.Object ->
    Ptr () ->
    IO (Ptr Gtk.Widget.Widget)

-- Args: [ Arg
--           { argCName = "item"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the item from the model for which to create a widget for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ListBoxCreateWidgetFunc :: FunPtr C_ListBoxCreateWidgetFunc -> C_ListBoxCreateWidgetFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ListBoxCreateWidgetFunc ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_ListBoxCreateWidgetFunc
    -> a
    -- ^ /@item@/: the item from the model for which to create a widget for
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m Gtk.Widget.Widget
    -- ^ __Returns:__ a @GtkWidget@ that represents /@item@/
dynamic_ListBoxCreateWidgetFunc __funPtr item userData = liftIO $ do
    item' <- unsafeManagedPtrCastPtr item
    result <- (__dynamic_C_ListBoxCreateWidgetFunc __funPtr) item' userData
    checkUnexpectedReturnNULL "listBoxCreateWidgetFunc" result
    result' <- (wrapObject Gtk.Widget.Widget) result
    touchManagedPtr item
    return result'

-- | Generate a function pointer callable from C code, from a `C_ListBoxCreateWidgetFunc`.
foreign import ccall "wrapper"
    mk_ListBoxCreateWidgetFunc :: C_ListBoxCreateWidgetFunc -> IO (FunPtr C_ListBoxCreateWidgetFunc)

-- | Called for list boxes that are bound to a @GListModel@ with
-- 'GI.Gtk.Objects.ListBox.listBoxBindModel' for each item that gets added to the model.
-- 
-- If the widget returned is not a t'GI.Gtk.Objects.ListBoxRow.ListBoxRow' widget, then the widget
-- will be inserted as the child of an intermediate t'GI.Gtk.Objects.ListBoxRow.ListBoxRow'.
type ListBoxCreateWidgetFunc =
    GObject.Object.Object
    -- ^ /@item@/: the item from the model for which to create a widget for
    -> IO Gtk.Widget.Widget
    -- ^ __Returns:__ a @GtkWidget@ that represents /@item@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `ListBoxCreateWidgetFunc`@.
noListBoxCreateWidgetFunc :: Maybe ListBoxCreateWidgetFunc
noListBoxCreateWidgetFunc = Nothing

-- | Called for list boxes that are bound to a @GListModel@ with
-- 'GI.Gtk.Objects.ListBox.listBoxBindModel' for each item that gets added to the model.
-- 
-- If the widget returned is not a t'GI.Gtk.Objects.ListBoxRow.ListBoxRow' widget, then the widget
-- will be inserted as the child of an intermediate t'GI.Gtk.Objects.ListBoxRow.ListBoxRow'.
type ListBoxCreateWidgetFunc_WithClosures =
    GObject.Object.Object
    -- ^ /@item@/: the item from the model for which to create a widget for
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO Gtk.Widget.Widget
    -- ^ __Returns:__ a @GtkWidget@ that represents /@item@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `ListBoxCreateWidgetFunc_WithClosures`@.
noListBoxCreateWidgetFunc_WithClosures :: Maybe ListBoxCreateWidgetFunc_WithClosures
noListBoxCreateWidgetFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ListBoxCreateWidgetFunc :: ListBoxCreateWidgetFunc -> ListBoxCreateWidgetFunc_WithClosures
drop_closures_ListBoxCreateWidgetFunc _f item _ = _f item

-- | Wrap the callback into a `GClosure`.
genClosure_ListBoxCreateWidgetFunc :: MonadIO m => ListBoxCreateWidgetFunc -> m (GClosure C_ListBoxCreateWidgetFunc)
genClosure_ListBoxCreateWidgetFunc cb = liftIO $ do
    let cb' = drop_closures_ListBoxCreateWidgetFunc cb
    let cb'' = wrap_ListBoxCreateWidgetFunc Nothing cb'
    mk_ListBoxCreateWidgetFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ListBoxCreateWidgetFunc` into a `C_ListBoxCreateWidgetFunc`.
wrap_ListBoxCreateWidgetFunc :: 
    Maybe (Ptr (FunPtr C_ListBoxCreateWidgetFunc)) ->
    ListBoxCreateWidgetFunc_WithClosures ->
    C_ListBoxCreateWidgetFunc
wrap_ListBoxCreateWidgetFunc gi'funptrptr gi'cb item userData = do
    item' <- (newObject GObject.Object.Object) item
    result <- gi'cb  item' userData
    maybeReleaseFunPtr gi'funptrptr
    result' <- B.ManagedPtr.disownObject result
    return result'


-- callback IconViewForeachFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "icon_view"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "IconView" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "path"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreePath" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The `GtkTreePath` of a selected row"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement."
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function used by gtk_icon_view_selected_foreach() to map all\nselected rows.\n\nIt will be called on every selected row in the view."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_IconViewForeachFunc =
    Ptr Gtk.IconView.IconView ->
    Ptr Gtk.TreePath.TreePath ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "icon_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The `GtkTreePath` of a selected row"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_IconViewForeachFunc :: FunPtr C_IconViewForeachFunc -> C_IconViewForeachFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_IconViewForeachFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.IconView.IsIconView a) =>
    FunPtr C_IconViewForeachFunc
    -> a
    -- ^ /@iconView@/: a @GtkIconView@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The @GtkTreePath@ of a selected row
    -> Ptr ()
    -- ^ /@data@/: user data
    -> m ()
dynamic_IconViewForeachFunc __funPtr iconView path data_ = liftIO $ do
    iconView' <- unsafeManagedPtrCastPtr iconView
    path' <- unsafeManagedPtrGetPtr path
    (__dynamic_C_IconViewForeachFunc __funPtr) iconView' path' data_
    touchManagedPtr iconView
    touchManagedPtr path
    return ()

-- | Generate a function pointer callable from C code, from a `C_IconViewForeachFunc`.
foreign import ccall "wrapper"
    mk_IconViewForeachFunc :: C_IconViewForeachFunc -> IO (FunPtr C_IconViewForeachFunc)

{-# DEPRECATED IconViewForeachFunc ["(Since version 4.20)","There is no replacement."] #-}
-- | A function used by 'GI.Gtk.Objects.IconView.iconViewSelectedForeach' to map all
-- selected rows.
-- 
-- It will be called on every selected row in the view.
type IconViewForeachFunc =
    Gtk.IconView.IconView
    -- ^ /@iconView@/: a @GtkIconView@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The @GtkTreePath@ of a selected row
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `IconViewForeachFunc`@.
noIconViewForeachFunc :: Maybe IconViewForeachFunc
noIconViewForeachFunc = Nothing

-- | A function used by 'GI.Gtk.Objects.IconView.iconViewSelectedForeach' to map all
-- selected rows.
-- 
-- It will be called on every selected row in the view.
type IconViewForeachFunc_WithClosures =
    Gtk.IconView.IconView
    -- ^ /@iconView@/: a @GtkIconView@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: The @GtkTreePath@ of a selected row
    -> Ptr ()
    -- ^ /@data@/: user data
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `IconViewForeachFunc_WithClosures`@.
noIconViewForeachFunc_WithClosures :: Maybe IconViewForeachFunc_WithClosures
noIconViewForeachFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_IconViewForeachFunc :: IconViewForeachFunc -> IconViewForeachFunc_WithClosures
drop_closures_IconViewForeachFunc _f iconView path _ = _f iconView path

-- | Wrap the callback into a `GClosure`.
genClosure_IconViewForeachFunc :: MonadIO m => IconViewForeachFunc -> m (GClosure C_IconViewForeachFunc)
genClosure_IconViewForeachFunc cb = liftIO $ do
    let cb' = drop_closures_IconViewForeachFunc cb
    let cb'' = wrap_IconViewForeachFunc Nothing cb'
    mk_IconViewForeachFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `IconViewForeachFunc` into a `C_IconViewForeachFunc`.
wrap_IconViewForeachFunc :: 
    Maybe (Ptr (FunPtr C_IconViewForeachFunc)) ->
    IconViewForeachFunc_WithClosures ->
    C_IconViewForeachFunc
wrap_IconViewForeachFunc gi'funptrptr gi'cb iconView path data_ = do
    iconView' <- (newObject Gtk.IconView.IconView) iconView
    B.ManagedPtr.withTransient  path $ \path' -> do
        gi'cb  iconView' path' data_
        maybeReleaseFunPtr gi'funptrptr


-- callback FontFilterFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%TRUE if the font should be displayed"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "family"
          , argType =
              TInterface Name { namespace = "Pango" , name = "FontFamily" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `PangoFontFamily`"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "face"
          , argType =
              TInterface Name { namespace = "Pango" , name = "FontFace" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `PangoFontFace` belonging to @family"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data passed to gtk_font_chooser_set_filter_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of function that is used for deciding what fonts get\nshown in a `GtkFontChooser`.\n\nSee [method@Gtk.FontChooser.set_filter_func]."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontFilterFunc =
    Ptr Pango.FontFamily.FontFamily ->
    Ptr Pango.FontFace.FontFace ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "family"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontFamily" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontFamily`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "face"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontFace" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontFace` belonging to @family"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data passed to gtk_font_chooser_set_filter_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontFilterFunc :: FunPtr C_FontFilterFunc -> C_FontFilterFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontFilterFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Pango.FontFamily.IsFontFamily a, Pango.FontFace.IsFontFace b) =>
    FunPtr C_FontFilterFunc
    -> a
    -- ^ /@family@/: a @PangoFontFamily@
    -> b
    -- ^ /@face@/: a @PangoFontFace@ belonging to /@family@/
    -> Ptr ()
    -- ^ /@data@/: user data passed to 'GI.Gtk.Interfaces.FontChooser.fontChooserSetFilterFunc'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the font should be displayed
dynamic_FontFilterFunc __funPtr family face data_ = liftIO $ do
    family' <- unsafeManagedPtrCastPtr family
    face' <- unsafeManagedPtrCastPtr face
    result <- (__dynamic_C_FontFilterFunc __funPtr) family' face' data_
    let result' = (/= 0) result
    touchManagedPtr family
    touchManagedPtr face
    return result'

-- | Generate a function pointer callable from C code, from a `C_FontFilterFunc`.
foreign import ccall "wrapper"
    mk_FontFilterFunc :: C_FontFilterFunc -> IO (FunPtr C_FontFilterFunc)

{-# DEPRECATED FontFilterFunc ["(Since version 4.20)","There is no replacement"] #-}
-- | The type of function that is used for deciding what fonts get
-- shown in a @GtkFontChooser@.
-- 
-- See 'GI.Gtk.Interfaces.FontChooser.fontChooserSetFilterFunc'.
type FontFilterFunc =
    Pango.FontFamily.FontFamily
    -- ^ /@family@/: a @PangoFontFamily@
    -> Pango.FontFace.FontFace
    -- ^ /@face@/: a @PangoFontFace@ belonging to /@family@/
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the font should be displayed

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontFilterFunc`@.
noFontFilterFunc :: Maybe FontFilterFunc
noFontFilterFunc = Nothing

-- | The type of function that is used for deciding what fonts get
-- shown in a @GtkFontChooser@.
-- 
-- See 'GI.Gtk.Interfaces.FontChooser.fontChooserSetFilterFunc'.
type FontFilterFunc_WithClosures =
    Pango.FontFamily.FontFamily
    -- ^ /@family@/: a @PangoFontFamily@
    -> Pango.FontFace.FontFace
    -- ^ /@face@/: a @PangoFontFace@ belonging to /@family@/
    -> Ptr ()
    -- ^ /@data@/: user data passed to 'GI.Gtk.Interfaces.FontChooser.fontChooserSetFilterFunc'
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the font should be displayed

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontFilterFunc_WithClosures`@.
noFontFilterFunc_WithClosures :: Maybe FontFilterFunc_WithClosures
noFontFilterFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontFilterFunc :: FontFilterFunc -> FontFilterFunc_WithClosures
drop_closures_FontFilterFunc _f family face _ = _f family face

-- | Wrap the callback into a `GClosure`.
genClosure_FontFilterFunc :: MonadIO m => FontFilterFunc -> m (GClosure C_FontFilterFunc)
genClosure_FontFilterFunc cb = liftIO $ do
    let cb' = drop_closures_FontFilterFunc cb
    let cb'' = wrap_FontFilterFunc Nothing cb'
    mk_FontFilterFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontFilterFunc` into a `C_FontFilterFunc`.
wrap_FontFilterFunc :: 
    Maybe (Ptr (FunPtr C_FontFilterFunc)) ->
    FontFilterFunc_WithClosures ->
    C_FontFilterFunc
wrap_FontFilterFunc gi'funptrptr gi'cb family face data_ = do
    family' <- (newObject Pango.FontFamily.FontFamily) family
    face' <- (newObject Pango.FontFace.FontFace) face
    result <- gi'cb  family' face' data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback FlowBoxSortFunc
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "< 0 if @child1 should be before @child2, 0 if\n  they are equal, and > 0 otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "child1"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "FlowBoxChild" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the first child" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "child2"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "FlowBoxChild" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the second child" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function to compare two children to determine which\nshould come first."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FlowBoxSortFunc =
    Ptr Gtk.FlowBoxChild.FlowBoxChild ->
    Ptr Gtk.FlowBoxChild.FlowBoxChild ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "child1"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FlowBoxChild" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the first child" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child2"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FlowBoxChild" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the second child" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FlowBoxSortFunc :: FunPtr C_FlowBoxSortFunc -> C_FlowBoxSortFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FlowBoxSortFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.FlowBoxChild.IsFlowBoxChild a, Gtk.FlowBoxChild.IsFlowBoxChild b) =>
    FunPtr C_FlowBoxSortFunc
    -> a
    -- ^ /@child1@/: the first child
    -> b
    -- ^ /@child2@/: the second child
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m Int32
    -- ^ __Returns:__ \< 0 if /@child1@/ should be before /@child2@/, 0 if
    --   they are equal, and > 0 otherwise
dynamic_FlowBoxSortFunc __funPtr child1 child2 userData = liftIO $ do
    child1' <- unsafeManagedPtrCastPtr child1
    child2' <- unsafeManagedPtrCastPtr child2
    result <- (__dynamic_C_FlowBoxSortFunc __funPtr) child1' child2' userData
    touchManagedPtr child1
    touchManagedPtr child2
    return result

-- | Generate a function pointer callable from C code, from a `C_FlowBoxSortFunc`.
foreign import ccall "wrapper"
    mk_FlowBoxSortFunc :: C_FlowBoxSortFunc -> IO (FunPtr C_FlowBoxSortFunc)

-- | A function to compare two children to determine which
-- should come first.
type FlowBoxSortFunc =
    Gtk.FlowBoxChild.FlowBoxChild
    -- ^ /@child1@/: the first child
    -> Gtk.FlowBoxChild.FlowBoxChild
    -- ^ /@child2@/: the second child
    -> IO Int32
    -- ^ __Returns:__ \< 0 if /@child1@/ should be before /@child2@/, 0 if
    --   they are equal, and > 0 otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FlowBoxSortFunc`@.
noFlowBoxSortFunc :: Maybe FlowBoxSortFunc
noFlowBoxSortFunc = Nothing

-- | A function to compare two children to determine which
-- should come first.
type FlowBoxSortFunc_WithClosures =
    Gtk.FlowBoxChild.FlowBoxChild
    -- ^ /@child1@/: the first child
    -> Gtk.FlowBoxChild.FlowBoxChild
    -- ^ /@child2@/: the second child
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO Int32
    -- ^ __Returns:__ \< 0 if /@child1@/ should be before /@child2@/, 0 if
    --   they are equal, and > 0 otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FlowBoxSortFunc_WithClosures`@.
noFlowBoxSortFunc_WithClosures :: Maybe FlowBoxSortFunc_WithClosures
noFlowBoxSortFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FlowBoxSortFunc :: FlowBoxSortFunc -> FlowBoxSortFunc_WithClosures
drop_closures_FlowBoxSortFunc _f child1 child2 _ = _f child1 child2

-- | Wrap the callback into a `GClosure`.
genClosure_FlowBoxSortFunc :: MonadIO m => FlowBoxSortFunc -> m (GClosure C_FlowBoxSortFunc)
genClosure_FlowBoxSortFunc cb = liftIO $ do
    let cb' = drop_closures_FlowBoxSortFunc cb
    let cb'' = wrap_FlowBoxSortFunc Nothing cb'
    mk_FlowBoxSortFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FlowBoxSortFunc` into a `C_FlowBoxSortFunc`.
wrap_FlowBoxSortFunc :: 
    Maybe (Ptr (FunPtr C_FlowBoxSortFunc)) ->
    FlowBoxSortFunc_WithClosures ->
    C_FlowBoxSortFunc
wrap_FlowBoxSortFunc gi'funptrptr gi'cb child1 child2 userData = do
    child1' <- (newObject Gtk.FlowBoxChild.FlowBoxChild) child1
    child2' <- (newObject Gtk.FlowBoxChild.FlowBoxChild) child2
    result <- gi'cb  child1' child2' userData
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback FlowBoxForeachFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "box"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "FlowBox" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `GtkFlowBox`" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "child"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "FlowBoxChild" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `GtkFlowBoxChild`"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function used by gtk_flow_box_selected_foreach().\n\nIt will be called on every selected child of the @box."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FlowBoxForeachFunc =
    Ptr Gtk.FlowBox.FlowBox ->
    Ptr Gtk.FlowBoxChild.FlowBoxChild ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FlowBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFlowBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FlowBoxChild" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFlowBoxChild`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FlowBoxForeachFunc :: FunPtr C_FlowBoxForeachFunc -> C_FlowBoxForeachFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FlowBoxForeachFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.FlowBox.IsFlowBox a, Gtk.FlowBoxChild.IsFlowBoxChild b) =>
    FunPtr C_FlowBoxForeachFunc
    -> a
    -- ^ /@box@/: a @GtkFlowBox@
    -> b
    -- ^ /@child@/: a @GtkFlowBoxChild@
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m ()
dynamic_FlowBoxForeachFunc __funPtr box child userData = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    child' <- unsafeManagedPtrCastPtr child
    (__dynamic_C_FlowBoxForeachFunc __funPtr) box' child' userData
    touchManagedPtr box
    touchManagedPtr child
    return ()

-- | Generate a function pointer callable from C code, from a `C_FlowBoxForeachFunc`.
foreign import ccall "wrapper"
    mk_FlowBoxForeachFunc :: C_FlowBoxForeachFunc -> IO (FunPtr C_FlowBoxForeachFunc)

-- | A function used by 'GI.Gtk.Objects.FlowBox.flowBoxSelectedForeach'.
-- 
-- It will be called on every selected child of the /@box@/.
type FlowBoxForeachFunc =
    Gtk.FlowBox.FlowBox
    -- ^ /@box@/: a @GtkFlowBox@
    -> Gtk.FlowBoxChild.FlowBoxChild
    -- ^ /@child@/: a @GtkFlowBoxChild@
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `FlowBoxForeachFunc`@.
noFlowBoxForeachFunc :: Maybe FlowBoxForeachFunc
noFlowBoxForeachFunc = Nothing

-- | A function used by 'GI.Gtk.Objects.FlowBox.flowBoxSelectedForeach'.
-- 
-- It will be called on every selected child of the /@box@/.
type FlowBoxForeachFunc_WithClosures =
    Gtk.FlowBox.FlowBox
    -- ^ /@box@/: a @GtkFlowBox@
    -> Gtk.FlowBoxChild.FlowBoxChild
    -- ^ /@child@/: a @GtkFlowBoxChild@
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `FlowBoxForeachFunc_WithClosures`@.
noFlowBoxForeachFunc_WithClosures :: Maybe FlowBoxForeachFunc_WithClosures
noFlowBoxForeachFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FlowBoxForeachFunc :: FlowBoxForeachFunc -> FlowBoxForeachFunc_WithClosures
drop_closures_FlowBoxForeachFunc _f box child _ = _f box child

-- | Wrap the callback into a `GClosure`.
genClosure_FlowBoxForeachFunc :: MonadIO m => FlowBoxForeachFunc -> m (GClosure C_FlowBoxForeachFunc)
genClosure_FlowBoxForeachFunc cb = liftIO $ do
    let cb' = drop_closures_FlowBoxForeachFunc cb
    let cb'' = wrap_FlowBoxForeachFunc Nothing cb'
    mk_FlowBoxForeachFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FlowBoxForeachFunc` into a `C_FlowBoxForeachFunc`.
wrap_FlowBoxForeachFunc :: 
    Maybe (Ptr (FunPtr C_FlowBoxForeachFunc)) ->
    FlowBoxForeachFunc_WithClosures ->
    C_FlowBoxForeachFunc
wrap_FlowBoxForeachFunc gi'funptrptr gi'cb box child userData = do
    box' <- (newObject Gtk.FlowBox.FlowBox) box
    child' <- (newObject Gtk.FlowBoxChild.FlowBoxChild) child
    gi'cb  box' child' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback FlowBoxFilterFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "%TRUE if the row should be visible, %FALSE otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "child"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "FlowBoxChild" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `GtkFlowBoxChild` that may be filtered"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function that will be called whenever a child changes\nor is added.\n\nIt lets you control if the child should be visible or not."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FlowBoxFilterFunc =
    Ptr Gtk.FlowBoxChild.FlowBoxChild ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FlowBoxChild" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFlowBoxChild` that may be filtered"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FlowBoxFilterFunc :: FunPtr C_FlowBoxFilterFunc -> C_FlowBoxFilterFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FlowBoxFilterFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.FlowBoxChild.IsFlowBoxChild a) =>
    FunPtr C_FlowBoxFilterFunc
    -> a
    -- ^ /@child@/: a @GtkFlowBoxChild@ that may be filtered
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the row should be visible, 'P.False' otherwise
dynamic_FlowBoxFilterFunc __funPtr child userData = liftIO $ do
    child' <- unsafeManagedPtrCastPtr child
    result <- (__dynamic_C_FlowBoxFilterFunc __funPtr) child' userData
    let result' = (/= 0) result
    touchManagedPtr child
    return result'

-- | Generate a function pointer callable from C code, from a `C_FlowBoxFilterFunc`.
foreign import ccall "wrapper"
    mk_FlowBoxFilterFunc :: C_FlowBoxFilterFunc -> IO (FunPtr C_FlowBoxFilterFunc)

-- | A function that will be called whenever a child changes
-- or is added.
-- 
-- It lets you control if the child should be visible or not.
type FlowBoxFilterFunc =
    Gtk.FlowBoxChild.FlowBoxChild
    -- ^ /@child@/: a @GtkFlowBoxChild@ that may be filtered
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the row should be visible, 'P.False' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FlowBoxFilterFunc`@.
noFlowBoxFilterFunc :: Maybe FlowBoxFilterFunc
noFlowBoxFilterFunc = Nothing

-- | A function that will be called whenever a child changes
-- or is added.
-- 
-- It lets you control if the child should be visible or not.
type FlowBoxFilterFunc_WithClosures =
    Gtk.FlowBoxChild.FlowBoxChild
    -- ^ /@child@/: a @GtkFlowBoxChild@ that may be filtered
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the row should be visible, 'P.False' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `FlowBoxFilterFunc_WithClosures`@.
noFlowBoxFilterFunc_WithClosures :: Maybe FlowBoxFilterFunc_WithClosures
noFlowBoxFilterFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FlowBoxFilterFunc :: FlowBoxFilterFunc -> FlowBoxFilterFunc_WithClosures
drop_closures_FlowBoxFilterFunc _f child _ = _f child

-- | Wrap the callback into a `GClosure`.
genClosure_FlowBoxFilterFunc :: MonadIO m => FlowBoxFilterFunc -> m (GClosure C_FlowBoxFilterFunc)
genClosure_FlowBoxFilterFunc cb = liftIO $ do
    let cb' = drop_closures_FlowBoxFilterFunc cb
    let cb'' = wrap_FlowBoxFilterFunc Nothing cb'
    mk_FlowBoxFilterFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FlowBoxFilterFunc` into a `C_FlowBoxFilterFunc`.
wrap_FlowBoxFilterFunc :: 
    Maybe (Ptr (FunPtr C_FlowBoxFilterFunc)) ->
    FlowBoxFilterFunc_WithClosures ->
    C_FlowBoxFilterFunc
wrap_FlowBoxFilterFunc gi'funptrptr gi'cb child userData = do
    child' <- (newObject Gtk.FlowBoxChild.FlowBoxChild) child
    result <- gi'cb  child' userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback FlowBoxCreateWidgetFunc
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
  , returnMayBeNull = False
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText = Just "a `GtkWidget` that represents @item"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "item"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the item from the model for which to create a widget for"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data from gtk_flow_box_bind_model()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Called for flow boxes that are bound to a `GListModel`.\n\nThis function is called for each item that gets added to the model."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FlowBoxCreateWidgetFunc =
    Ptr GObject.Object.Object ->
    Ptr () ->
    IO (Ptr Gtk.Widget.Widget)

-- Args: [ Arg
--           { argCName = "item"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the item from the model for which to create a widget for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data from gtk_flow_box_bind_model()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FlowBoxCreateWidgetFunc :: FunPtr C_FlowBoxCreateWidgetFunc -> C_FlowBoxCreateWidgetFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FlowBoxCreateWidgetFunc ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_FlowBoxCreateWidgetFunc
    -> a
    -- ^ /@item@/: the item from the model for which to create a widget for
    -> Ptr ()
    -- ^ /@userData@/: user data from 'GI.Gtk.Objects.FlowBox.flowBoxBindModel'
    -> m Gtk.Widget.Widget
    -- ^ __Returns:__ a @GtkWidget@ that represents /@item@/
dynamic_FlowBoxCreateWidgetFunc __funPtr item userData = liftIO $ do
    item' <- unsafeManagedPtrCastPtr item
    result <- (__dynamic_C_FlowBoxCreateWidgetFunc __funPtr) item' userData
    checkUnexpectedReturnNULL "flowBoxCreateWidgetFunc" result
    result' <- (wrapObject Gtk.Widget.Widget) result
    touchManagedPtr item
    return result'

-- | Generate a function pointer callable from C code, from a `C_FlowBoxCreateWidgetFunc`.
foreign import ccall "wrapper"
    mk_FlowBoxCreateWidgetFunc :: C_FlowBoxCreateWidgetFunc -> IO (FunPtr C_FlowBoxCreateWidgetFunc)

-- | Called for flow boxes that are bound to a @GListModel@.
-- 
-- This function is called for each item that gets added to the model.
type FlowBoxCreateWidgetFunc =
    GObject.Object.Object
    -- ^ /@item@/: the item from the model for which to create a widget for
    -> IO Gtk.Widget.Widget
    -- ^ __Returns:__ a @GtkWidget@ that represents /@item@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `FlowBoxCreateWidgetFunc`@.
noFlowBoxCreateWidgetFunc :: Maybe FlowBoxCreateWidgetFunc
noFlowBoxCreateWidgetFunc = Nothing

-- | Called for flow boxes that are bound to a @GListModel@.
-- 
-- This function is called for each item that gets added to the model.
type FlowBoxCreateWidgetFunc_WithClosures =
    GObject.Object.Object
    -- ^ /@item@/: the item from the model for which to create a widget for
    -> Ptr ()
    -- ^ /@userData@/: user data from 'GI.Gtk.Objects.FlowBox.flowBoxBindModel'
    -> IO Gtk.Widget.Widget
    -- ^ __Returns:__ a @GtkWidget@ that represents /@item@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `FlowBoxCreateWidgetFunc_WithClosures`@.
noFlowBoxCreateWidgetFunc_WithClosures :: Maybe FlowBoxCreateWidgetFunc_WithClosures
noFlowBoxCreateWidgetFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FlowBoxCreateWidgetFunc :: FlowBoxCreateWidgetFunc -> FlowBoxCreateWidgetFunc_WithClosures
drop_closures_FlowBoxCreateWidgetFunc _f item _ = _f item

-- | Wrap the callback into a `GClosure`.
genClosure_FlowBoxCreateWidgetFunc :: MonadIO m => FlowBoxCreateWidgetFunc -> m (GClosure C_FlowBoxCreateWidgetFunc)
genClosure_FlowBoxCreateWidgetFunc cb = liftIO $ do
    let cb' = drop_closures_FlowBoxCreateWidgetFunc cb
    let cb'' = wrap_FlowBoxCreateWidgetFunc Nothing cb'
    mk_FlowBoxCreateWidgetFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FlowBoxCreateWidgetFunc` into a `C_FlowBoxCreateWidgetFunc`.
wrap_FlowBoxCreateWidgetFunc :: 
    Maybe (Ptr (FunPtr C_FlowBoxCreateWidgetFunc)) ->
    FlowBoxCreateWidgetFunc_WithClosures ->
    C_FlowBoxCreateWidgetFunc
wrap_FlowBoxCreateWidgetFunc gi'funptrptr gi'cb item userData = do
    item' <- (newObject GObject.Object.Object) item
    result <- gi'cb  item' userData
    maybeReleaseFunPtr gi'funptrptr
    result' <- B.ManagedPtr.disownObject result
    return result'


-- callback ExpressionNotify
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "data passed to gtk_expression_watch()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Callback called by gtk_expression_watch() when the\nexpression value changes."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ExpressionNotify =
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed to gtk_expression_watch()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ExpressionNotify :: FunPtr C_ExpressionNotify -> C_ExpressionNotify

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ExpressionNotify ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ExpressionNotify
    -> Ptr ()
    -- ^ /@userData@/: data passed to 'GI.Gtk.Objects.Expression.expressionWatch'
    -> m ()
dynamic_ExpressionNotify __funPtr userData = liftIO $ do
    (__dynamic_C_ExpressionNotify __funPtr) userData
    return ()

-- | Generate a function pointer callable from C code, from a `C_ExpressionNotify`.
foreign import ccall "wrapper"
    mk_ExpressionNotify :: C_ExpressionNotify -> IO (FunPtr C_ExpressionNotify)

-- | Callback called by 'GI.Gtk.Objects.Expression.expressionWatch' when the
-- expression value changes.
type ExpressionNotify =
    IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ExpressionNotify`@.
noExpressionNotify :: Maybe ExpressionNotify
noExpressionNotify = Nothing

-- | Callback called by 'GI.Gtk.Objects.Expression.expressionWatch' when the
-- expression value changes.
type ExpressionNotify_WithClosures =
    Ptr ()
    -- ^ /@userData@/: data passed to 'GI.Gtk.Objects.Expression.expressionWatch'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ExpressionNotify_WithClosures`@.
noExpressionNotify_WithClosures :: Maybe ExpressionNotify_WithClosures
noExpressionNotify_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ExpressionNotify :: ExpressionNotify -> ExpressionNotify_WithClosures
drop_closures_ExpressionNotify _f _ = _f 

-- | Wrap the callback into a `GClosure`.
genClosure_ExpressionNotify :: MonadIO m => ExpressionNotify -> m (GClosure C_ExpressionNotify)
genClosure_ExpressionNotify cb = liftIO $ do
    let cb' = drop_closures_ExpressionNotify cb
    let cb'' = wrap_ExpressionNotify Nothing cb'
    mk_ExpressionNotify cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ExpressionNotify` into a `C_ExpressionNotify`.
wrap_ExpressionNotify :: 
    Maybe (Ptr (FunPtr C_ExpressionNotify)) ->
    ExpressionNotify_WithClosures ->
    C_ExpressionNotify
wrap_ExpressionNotify gi'funptrptr gi'cb userData = do
    gi'cb  userData
    maybeReleaseFunPtr gi'funptrptr


-- callback EntryCompletionMatchFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%TRUE if @iter should be displayed as a possible completion\n  for @key"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "completion"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "EntryCompletion" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the `GtkEntryCompletion`"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "key"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the string to match, normalized and case-folded"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "iter"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeIter" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `GtkTreeIter` indicating the row to match"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data given to gtk_entry_completion_set_match_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function which decides whether the row indicated by @iter matches\na given @key, and should be displayed as a possible completion for @key.\n\nNote that @key is normalized and case-folded (see g_utf8_normalize()\nand g_utf8_casefold()). If this is not appropriate, match functions\nhave access to the unmodified key via\n`gtk_editable_get_text (GTK_EDITABLE (gtk_entry_completion_get_entry ()))`."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_EntryCompletionMatchFunc =
    Ptr Gtk.EntryCompletion.EntryCompletion ->
    CString ->
    Ptr Gtk.TreeIter.TreeIter ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "completion"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EntryCompletion" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkEntryCompletion`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the string to match, normalized and case-folded"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeIter` indicating the row to match"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data given to gtk_entry_completion_set_match_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_EntryCompletionMatchFunc :: FunPtr C_EntryCompletionMatchFunc -> C_EntryCompletionMatchFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_EntryCompletionMatchFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.EntryCompletion.IsEntryCompletion a) =>
    FunPtr C_EntryCompletionMatchFunc
    -> a
    -- ^ /@completion@/: the @GtkEntryCompletion@
    -> T.Text
    -- ^ /@key@/: the string to match, normalized and case-folded
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ indicating the row to match
    -> Ptr ()
    -- ^ /@userData@/: user data given to 'GI.Gtk.Objects.EntryCompletion.entryCompletionSetMatchFunc'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@iter@/ should be displayed as a possible completion
    --   for /@key@/
dynamic_EntryCompletionMatchFunc __funPtr completion key iter userData = liftIO $ do
    completion' <- unsafeManagedPtrCastPtr completion
    key' <- textToCString key
    iter' <- unsafeManagedPtrGetPtr iter
    result <- (__dynamic_C_EntryCompletionMatchFunc __funPtr) completion' key' iter' userData
    let result' = (/= 0) result
    touchManagedPtr completion
    touchManagedPtr iter
    freeMem key'
    return result'

-- | Generate a function pointer callable from C code, from a `C_EntryCompletionMatchFunc`.
foreign import ccall "wrapper"
    mk_EntryCompletionMatchFunc :: C_EntryCompletionMatchFunc -> IO (FunPtr C_EntryCompletionMatchFunc)

{-# DEPRECATED EntryCompletionMatchFunc ["(Since version 4.20)","There is no replacement"] #-}
-- | A function which decides whether the row indicated by /@iter@/ matches
-- a given /@key@/, and should be displayed as a possible completion for /@key@/.
-- 
-- Note that /@key@/ is normalized and case-folded (see 'GI.GLib.Functions.utf8Normalize'
-- and 'GI.GLib.Functions.utf8Casefold'). If this is not appropriate, match functions
-- have access to the unmodified key via
-- @gtk_editable_get_text (GTK_EDITABLE (gtk_entry_completion_get_entry ()))@.
type EntryCompletionMatchFunc =
    Gtk.EntryCompletion.EntryCompletion
    -- ^ /@completion@/: the @GtkEntryCompletion@
    -> T.Text
    -- ^ /@key@/: the string to match, normalized and case-folded
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ indicating the row to match
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if /@iter@/ should be displayed as a possible completion
    --   for /@key@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `EntryCompletionMatchFunc`@.
noEntryCompletionMatchFunc :: Maybe EntryCompletionMatchFunc
noEntryCompletionMatchFunc = Nothing

-- | A function which decides whether the row indicated by /@iter@/ matches
-- a given /@key@/, and should be displayed as a possible completion for /@key@/.
-- 
-- Note that /@key@/ is normalized and case-folded (see 'GI.GLib.Functions.utf8Normalize'
-- and 'GI.GLib.Functions.utf8Casefold'). If this is not appropriate, match functions
-- have access to the unmodified key via
-- @gtk_editable_get_text (GTK_EDITABLE (gtk_entry_completion_get_entry ()))@.
type EntryCompletionMatchFunc_WithClosures =
    Gtk.EntryCompletion.EntryCompletion
    -- ^ /@completion@/: the @GtkEntryCompletion@
    -> T.Text
    -- ^ /@key@/: the string to match, normalized and case-folded
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ indicating the row to match
    -> Ptr ()
    -- ^ /@userData@/: user data given to 'GI.Gtk.Objects.EntryCompletion.entryCompletionSetMatchFunc'
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if /@iter@/ should be displayed as a possible completion
    --   for /@key@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `EntryCompletionMatchFunc_WithClosures`@.
noEntryCompletionMatchFunc_WithClosures :: Maybe EntryCompletionMatchFunc_WithClosures
noEntryCompletionMatchFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_EntryCompletionMatchFunc :: EntryCompletionMatchFunc -> EntryCompletionMatchFunc_WithClosures
drop_closures_EntryCompletionMatchFunc _f completion key iter _ = _f completion key iter

-- | Wrap the callback into a `GClosure`.
genClosure_EntryCompletionMatchFunc :: MonadIO m => EntryCompletionMatchFunc -> m (GClosure C_EntryCompletionMatchFunc)
genClosure_EntryCompletionMatchFunc cb = liftIO $ do
    let cb' = drop_closures_EntryCompletionMatchFunc cb
    let cb'' = wrap_EntryCompletionMatchFunc Nothing cb'
    mk_EntryCompletionMatchFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `EntryCompletionMatchFunc` into a `C_EntryCompletionMatchFunc`.
wrap_EntryCompletionMatchFunc :: 
    Maybe (Ptr (FunPtr C_EntryCompletionMatchFunc)) ->
    EntryCompletionMatchFunc_WithClosures ->
    C_EntryCompletionMatchFunc
wrap_EntryCompletionMatchFunc gi'funptrptr gi'cb completion key iter userData = do
    completion' <- (newObject Gtk.EntryCompletion.EntryCompletion) completion
    key' <- cstringToText key
    B.ManagedPtr.withTransient  iter $ \iter' -> do
        result <- gi'cb  completion' key' iter' userData
        maybeReleaseFunPtr gi'funptrptr
        let result' = (P.fromIntegral . P.fromEnum) result
        return result'


-- callback DrawingAreaDrawFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "drawing_area"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "DrawingArea" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the `GtkDrawingArea` to redraw"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cr"
          , argType =
              TInterface Name { namespace = "cairo" , name = "Context" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the context to draw to"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "width"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the actual width of the contents. This value will be at least\n  as wide as GtkDrawingArea:width."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "height"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the actual height of the contents. This value will be at least\n  as wide as GtkDrawingArea:height."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Whenever @drawing_area needs to redraw, this function will be called.\n\nThis function should exclusively redraw the contents of the drawing area\nand must not call any widget functions that cause changes."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DrawingAreaDrawFunc =
    Ptr Gtk.DrawingArea.DrawingArea ->
    Ptr Cairo.Context.Context ->
    Int32 ->
    Int32 ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "drawing_area"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DrawingArea" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkDrawingArea` to redraw"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the context to draw to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the actual width of the contents. This value will be at least\n  as wide as GtkDrawingArea:width."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the actual height of the contents. This value will be at least\n  as wide as GtkDrawingArea:height."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DrawingAreaDrawFunc :: FunPtr C_DrawingAreaDrawFunc -> C_DrawingAreaDrawFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DrawingAreaDrawFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.DrawingArea.IsDrawingArea a) =>
    FunPtr C_DrawingAreaDrawFunc
    -> a
    -- ^ /@drawingArea@/: the @GtkDrawingArea@ to redraw
    -> Cairo.Context.Context
    -- ^ /@cr@/: the context to draw to
    -> Int32
    -- ^ /@width@/: the actual width of the contents. This value will be at least
    --   as wide as GtkDrawingArea:width.
    -> Int32
    -- ^ /@height@/: the actual height of the contents. This value will be at least
    --   as wide as GtkDrawingArea:height.
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m ()
dynamic_DrawingAreaDrawFunc __funPtr drawingArea cr width height userData = liftIO $ do
    drawingArea' <- unsafeManagedPtrCastPtr drawingArea
    cr' <- unsafeManagedPtrGetPtr cr
    (__dynamic_C_DrawingAreaDrawFunc __funPtr) drawingArea' cr' width height userData
    touchManagedPtr drawingArea
    touchManagedPtr cr
    return ()

-- | Generate a function pointer callable from C code, from a `C_DrawingAreaDrawFunc`.
foreign import ccall "wrapper"
    mk_DrawingAreaDrawFunc :: C_DrawingAreaDrawFunc -> IO (FunPtr C_DrawingAreaDrawFunc)

-- | Whenever /@drawingArea@/ needs to redraw, this function will be called.
-- 
-- This function should exclusively redraw the contents of the drawing area
-- and must not call any widget functions that cause changes.
type DrawingAreaDrawFunc =
    Gtk.DrawingArea.DrawingArea
    -- ^ /@drawingArea@/: the @GtkDrawingArea@ to redraw
    -> Cairo.Context.Context
    -- ^ /@cr@/: the context to draw to
    -> Int32
    -- ^ /@width@/: the actual width of the contents. This value will be at least
    --   as wide as GtkDrawingArea:width.
    -> Int32
    -- ^ /@height@/: the actual height of the contents. This value will be at least
    --   as wide as GtkDrawingArea:height.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DrawingAreaDrawFunc`@.
noDrawingAreaDrawFunc :: Maybe DrawingAreaDrawFunc
noDrawingAreaDrawFunc = Nothing

-- | Whenever /@drawingArea@/ needs to redraw, this function will be called.
-- 
-- This function should exclusively redraw the contents of the drawing area
-- and must not call any widget functions that cause changes.
type DrawingAreaDrawFunc_WithClosures =
    Gtk.DrawingArea.DrawingArea
    -- ^ /@drawingArea@/: the @GtkDrawingArea@ to redraw
    -> Cairo.Context.Context
    -- ^ /@cr@/: the context to draw to
    -> Int32
    -- ^ /@width@/: the actual width of the contents. This value will be at least
    --   as wide as GtkDrawingArea:width.
    -> Int32
    -- ^ /@height@/: the actual height of the contents. This value will be at least
    --   as wide as GtkDrawingArea:height.
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DrawingAreaDrawFunc_WithClosures`@.
noDrawingAreaDrawFunc_WithClosures :: Maybe DrawingAreaDrawFunc_WithClosures
noDrawingAreaDrawFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DrawingAreaDrawFunc :: DrawingAreaDrawFunc -> DrawingAreaDrawFunc_WithClosures
drop_closures_DrawingAreaDrawFunc _f drawingArea cr width height _ = _f drawingArea cr width height

-- | Wrap the callback into a `GClosure`.
genClosure_DrawingAreaDrawFunc :: MonadIO m => DrawingAreaDrawFunc -> m (GClosure C_DrawingAreaDrawFunc)
genClosure_DrawingAreaDrawFunc cb = liftIO $ do
    let cb' = drop_closures_DrawingAreaDrawFunc cb
    let cb'' = wrap_DrawingAreaDrawFunc Nothing cb'
    mk_DrawingAreaDrawFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DrawingAreaDrawFunc` into a `C_DrawingAreaDrawFunc`.
wrap_DrawingAreaDrawFunc :: 
    Maybe (Ptr (FunPtr C_DrawingAreaDrawFunc)) ->
    DrawingAreaDrawFunc_WithClosures ->
    C_DrawingAreaDrawFunc
wrap_DrawingAreaDrawFunc gi'funptrptr gi'cb drawingArea cr width height userData = do
    drawingArea' <- (newObject Gtk.DrawingArea.DrawingArea) drawingArea
    B.ManagedPtr.withTransient  cr $ \cr' -> do
        gi'cb  drawingArea' cr' width height userData
        maybeReleaseFunPtr gi'funptrptr


-- callback CustomRequestModeFunc
{- Callable
  { returnType =
      Just
        (TInterface Name { namespace = "Gtk" , name = "SizeRequestMode" })
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "the size request mode"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the widget to be queried"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "Queries a widget for its preferred size request mode."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CustomRequestModeFunc =
    Ptr Gtk.Widget.Widget ->
    IO CUInt

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to be queried"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SizeRequestMode" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CustomRequestModeFunc :: FunPtr C_CustomRequestModeFunc -> C_CustomRequestModeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CustomRequestModeFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_CustomRequestModeFunc
    -> a
    -- ^ /@widget@/: the widget to be queried
    -> m Gtk.Enums.SizeRequestMode
    -- ^ __Returns:__ the size request mode
dynamic_CustomRequestModeFunc __funPtr widget = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    result <- (__dynamic_C_CustomRequestModeFunc __funPtr) widget'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr widget
    return result'

-- | Generate a function pointer callable from C code, from a `C_CustomRequestModeFunc`.
foreign import ccall "wrapper"
    mk_CustomRequestModeFunc :: C_CustomRequestModeFunc -> IO (FunPtr C_CustomRequestModeFunc)

-- | Queries a widget for its preferred size request mode.
type CustomRequestModeFunc =
    Gtk.Widget.Widget
    -- ^ /@widget@/: the widget to be queried
    -> IO Gtk.Enums.SizeRequestMode
    -- ^ __Returns:__ the size request mode

-- | A convenience synonym for @`Nothing` :: `Maybe` `CustomRequestModeFunc`@.
noCustomRequestModeFunc :: Maybe CustomRequestModeFunc
noCustomRequestModeFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_CustomRequestModeFunc :: MonadIO m => CustomRequestModeFunc -> m (GClosure C_CustomRequestModeFunc)
genClosure_CustomRequestModeFunc cb = liftIO $ do
    let cb' = wrap_CustomRequestModeFunc Nothing cb
    mk_CustomRequestModeFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `CustomRequestModeFunc` into a `C_CustomRequestModeFunc`.
wrap_CustomRequestModeFunc :: 
    Maybe (Ptr (FunPtr C_CustomRequestModeFunc)) ->
    CustomRequestModeFunc ->
    C_CustomRequestModeFunc
wrap_CustomRequestModeFunc gi'funptrptr gi'cb widget = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    result <- gi'cb  widget'
    maybeReleaseFunPtr gi'funptrptr
    let result' = (fromIntegral . fromEnum) result
    return result'


-- callback CustomMeasureFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the widget to be measured"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "orientation"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "Orientation" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the direction to be measured"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "for_size"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the size to be measured for"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "minimum"
          , argType = TBasicType TInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the measured minimum size of the widget"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "natural"
          , argType = TBasicType TInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the measured natural size of the widget"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "minimum_baseline"
          , argType = TBasicType TInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the measured minimum baseline of the widget"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "natural_baseline"
          , argType = TBasicType TInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the measured natural baseline of the widget"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function to be used by `GtkCustomLayout` to measure a widget."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CustomMeasureFunc =
    Ptr Gtk.Widget.Widget ->
    CUInt ->
    Int32 ->
    Ptr Int32 ->
    Ptr Int32 ->
    Ptr Int32 ->
    Ptr Int32 ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to be measured"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "orientation"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Orientation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the direction to be measured"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "for_size"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the size to be measured for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "minimum"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the measured minimum size of the widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "natural"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the measured natural size of the widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "minimum_baseline"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the measured minimum baseline of the widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "natural_baseline"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the measured natural baseline of the widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CustomMeasureFunc :: FunPtr C_CustomMeasureFunc -> C_CustomMeasureFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CustomMeasureFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_CustomMeasureFunc
    -> a
    -- ^ /@widget@/: the widget to be measured
    -> Gtk.Enums.Orientation
    -- ^ /@orientation@/: the direction to be measured
    -> Int32
    -- ^ /@forSize@/: the size to be measured for
    -> m ((Int32, Int32, Int32, Int32))
dynamic_CustomMeasureFunc __funPtr widget orientation forSize = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    let orientation' = (fromIntegral . fromEnum) orientation
    minimum <- allocMem :: IO (Ptr Int32)
    natural <- allocMem :: IO (Ptr Int32)
    minimumBaseline <- allocMem :: IO (Ptr Int32)
    naturalBaseline <- allocMem :: IO (Ptr Int32)
    (__dynamic_C_CustomMeasureFunc __funPtr) widget' orientation' forSize minimum natural minimumBaseline naturalBaseline
    minimum' <- peek minimum
    natural' <- peek natural
    minimumBaseline' <- peek minimumBaseline
    naturalBaseline' <- peek naturalBaseline
    touchManagedPtr widget
    freeMem minimum
    freeMem natural
    freeMem minimumBaseline
    freeMem naturalBaseline
    return (minimum', natural', minimumBaseline', naturalBaseline')

-- | Generate a function pointer callable from C code, from a `C_CustomMeasureFunc`.
foreign import ccall "wrapper"
    mk_CustomMeasureFunc :: C_CustomMeasureFunc -> IO (FunPtr C_CustomMeasureFunc)

-- | A function to be used by @GtkCustomLayout@ to measure a widget.
type CustomMeasureFunc =
    Gtk.Widget.Widget
    -- ^ /@widget@/: the widget to be measured
    -> Gtk.Enums.Orientation
    -- ^ /@orientation@/: the direction to be measured
    -> Int32
    -- ^ /@forSize@/: the size to be measured for
    -> IO ((Int32, Int32, Int32, Int32))

-- | A convenience synonym for @`Nothing` :: `Maybe` `CustomMeasureFunc`@.
noCustomMeasureFunc :: Maybe CustomMeasureFunc
noCustomMeasureFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_CustomMeasureFunc :: MonadIO m => CustomMeasureFunc -> m (GClosure C_CustomMeasureFunc)
genClosure_CustomMeasureFunc cb = liftIO $ do
    let cb' = wrap_CustomMeasureFunc Nothing cb
    mk_CustomMeasureFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `CustomMeasureFunc` into a `C_CustomMeasureFunc`.
wrap_CustomMeasureFunc :: 
    Maybe (Ptr (FunPtr C_CustomMeasureFunc)) ->
    CustomMeasureFunc ->
    C_CustomMeasureFunc
wrap_CustomMeasureFunc gi'funptrptr gi'cb widget orientation forSize minimum natural minimumBaseline naturalBaseline = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    let orientation' = (toEnum . fromIntegral) orientation
    (outminimum, outnatural, outminimumBaseline, outnaturalBaseline) <- gi'cb  widget' orientation' forSize
    poke minimum outminimum
    poke natural outnatural
    poke minimumBaseline outminimumBaseline
    poke naturalBaseline outnaturalBaseline
    maybeReleaseFunPtr gi'funptrptr


-- callback CustomFilterFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "true to keep the item around"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "item"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the item to be matched"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "User function that is called to determine if the @item should be matched.\n\nIf the filter matches the item, this function must return true.\nIf the item should be filtered out, false must be returned."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CustomFilterFunc =
    Ptr GObject.Object.Object ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "item"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the item to be matched"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CustomFilterFunc :: FunPtr C_CustomFilterFunc -> C_CustomFilterFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CustomFilterFunc ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_CustomFilterFunc
    -> a
    -- ^ /@item@/: the item to be matched
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m Bool
    -- ^ __Returns:__ true to keep the item around
dynamic_CustomFilterFunc __funPtr item userData = liftIO $ do
    item' <- unsafeManagedPtrCastPtr item
    result <- (__dynamic_C_CustomFilterFunc __funPtr) item' userData
    let result' = (/= 0) result
    touchManagedPtr item
    return result'

-- | Generate a function pointer callable from C code, from a `C_CustomFilterFunc`.
foreign import ccall "wrapper"
    mk_CustomFilterFunc :: C_CustomFilterFunc -> IO (FunPtr C_CustomFilterFunc)

-- | User function that is called to determine if the /@item@/ should be matched.
-- 
-- If the filter matches the item, this function must return true.
-- If the item should be filtered out, false must be returned.
type CustomFilterFunc =
    GObject.Object.Object
    -- ^ /@item@/: the item to be matched
    -> IO Bool
    -- ^ __Returns:__ true to keep the item around

-- | A convenience synonym for @`Nothing` :: `Maybe` `CustomFilterFunc`@.
noCustomFilterFunc :: Maybe CustomFilterFunc
noCustomFilterFunc = Nothing

-- | User function that is called to determine if the /@item@/ should be matched.
-- 
-- If the filter matches the item, this function must return true.
-- If the item should be filtered out, false must be returned.
type CustomFilterFunc_WithClosures =
    GObject.Object.Object
    -- ^ /@item@/: the item to be matched
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO Bool
    -- ^ __Returns:__ true to keep the item around

-- | A convenience synonym for @`Nothing` :: `Maybe` `CustomFilterFunc_WithClosures`@.
noCustomFilterFunc_WithClosures :: Maybe CustomFilterFunc_WithClosures
noCustomFilterFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_CustomFilterFunc :: CustomFilterFunc -> CustomFilterFunc_WithClosures
drop_closures_CustomFilterFunc _f item _ = _f item

-- | Wrap the callback into a `GClosure`.
genClosure_CustomFilterFunc :: MonadIO m => CustomFilterFunc -> m (GClosure C_CustomFilterFunc)
genClosure_CustomFilterFunc cb = liftIO $ do
    let cb' = drop_closures_CustomFilterFunc cb
    let cb'' = wrap_CustomFilterFunc Nothing cb'
    mk_CustomFilterFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `CustomFilterFunc` into a `C_CustomFilterFunc`.
wrap_CustomFilterFunc :: 
    Maybe (Ptr (FunPtr C_CustomFilterFunc)) ->
    CustomFilterFunc_WithClosures ->
    C_CustomFilterFunc
wrap_CustomFilterFunc gi'funptrptr gi'cb item userData = do
    item' <- (newObject GObject.Object.Object) item
    result <- gi'cb  item' userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback CustomAllocateFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "widget"
          , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the widget to allocate"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "width"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the new width of the widget"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "height"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the new height of the widget"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "baseline"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the new baseline of the widget, or -1"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function to be used by `GtkCustomLayout` to allocate a widget."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CustomAllocateFunc =
    Ptr Gtk.Widget.Widget ->
    Int32 ->
    Int32 ->
    Int32 ->
    IO ()

-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to allocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new width of the widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new height of the widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "baseline"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new baseline of the widget, or -1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CustomAllocateFunc :: FunPtr C_CustomAllocateFunc -> C_CustomAllocateFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CustomAllocateFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    FunPtr C_CustomAllocateFunc
    -> a
    -- ^ /@widget@/: the widget to allocate
    -> Int32
    -- ^ /@width@/: the new width of the widget
    -> Int32
    -- ^ /@height@/: the new height of the widget
    -> Int32
    -- ^ /@baseline@/: the new baseline of the widget, or -1
    -> m ()
dynamic_CustomAllocateFunc __funPtr widget width height baseline = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    (__dynamic_C_CustomAllocateFunc __funPtr) widget' width height baseline
    touchManagedPtr widget
    return ()

-- | Generate a function pointer callable from C code, from a `C_CustomAllocateFunc`.
foreign import ccall "wrapper"
    mk_CustomAllocateFunc :: C_CustomAllocateFunc -> IO (FunPtr C_CustomAllocateFunc)

-- | A function to be used by @GtkCustomLayout@ to allocate a widget.
type CustomAllocateFunc =
    Gtk.Widget.Widget
    -- ^ /@widget@/: the widget to allocate
    -> Int32
    -- ^ /@width@/: the new width of the widget
    -> Int32
    -- ^ /@height@/: the new height of the widget
    -> Int32
    -- ^ /@baseline@/: the new baseline of the widget, or -1
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `CustomAllocateFunc`@.
noCustomAllocateFunc :: Maybe CustomAllocateFunc
noCustomAllocateFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_CustomAllocateFunc :: MonadIO m => CustomAllocateFunc -> m (GClosure C_CustomAllocateFunc)
genClosure_CustomAllocateFunc cb = liftIO $ do
    let cb' = wrap_CustomAllocateFunc Nothing cb
    mk_CustomAllocateFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `CustomAllocateFunc` into a `C_CustomAllocateFunc`.
wrap_CustomAllocateFunc :: 
    Maybe (Ptr (FunPtr C_CustomAllocateFunc)) ->
    CustomAllocateFunc ->
    C_CustomAllocateFunc
wrap_CustomAllocateFunc gi'funptrptr gi'cb widget width height baseline = do
    widget' <- (newObject Gtk.Widget.Widget) widget
    gi'cb  widget' width height baseline
    maybeReleaseFunPtr gi'funptrptr


-- callback CellLayoutDataFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "cell_layout"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "CellLayout" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `GtkCellLayout`" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cell"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "CellRenderer" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the cell renderer whose value is to be set"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "tree_model"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeModel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the model" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "iter"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "TreeIter" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "a `GtkTreeIter` indicating the row to set the value for"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data passed to gtk_cell_layout_set_cell_data_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function which should set the value of @cell_layout\8217s cell renderer(s)\nas appropriate."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CellLayoutDataFunc =
    Ptr Gtk.CellLayout.CellLayout ->
    Ptr Gtk.CellRenderer.CellRenderer ->
    Ptr Gtk.TreeModel.TreeModel ->
    Ptr Gtk.TreeIter.TreeIter ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "cell_layout"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CellLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCellLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cell"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CellRenderer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the cell renderer whose value is to be set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tree_model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the model" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GtkTreeIter` indicating the row to set the value for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data passed to gtk_cell_layout_set_cell_data_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CellLayoutDataFunc :: FunPtr C_CellLayoutDataFunc -> C_CellLayoutDataFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CellLayoutDataFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.CellLayout.IsCellLayout a, Gtk.CellRenderer.IsCellRenderer b, Gtk.TreeModel.IsTreeModel c) =>
    FunPtr C_CellLayoutDataFunc
    -> a
    -- ^ /@cellLayout@/: a @GtkCellLayout@
    -> b
    -- ^ /@cell@/: the cell renderer whose value is to be set
    -> c
    -- ^ /@treeModel@/: the model
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ indicating the row to set the value for
    -> Ptr ()
    -- ^ /@data@/: user data passed to 'GI.Gtk.Interfaces.CellLayout.cellLayoutSetCellDataFunc'
    -> m ()
dynamic_CellLayoutDataFunc __funPtr cellLayout cell treeModel iter data_ = liftIO $ do
    cellLayout' <- unsafeManagedPtrCastPtr cellLayout
    cell' <- unsafeManagedPtrCastPtr cell
    treeModel' <- unsafeManagedPtrCastPtr treeModel
    iter' <- unsafeManagedPtrGetPtr iter
    (__dynamic_C_CellLayoutDataFunc __funPtr) cellLayout' cell' treeModel' iter' data_
    touchManagedPtr cellLayout
    touchManagedPtr cell
    touchManagedPtr treeModel
    touchManagedPtr iter
    return ()

-- | Generate a function pointer callable from C code, from a `C_CellLayoutDataFunc`.
foreign import ccall "wrapper"
    mk_CellLayoutDataFunc :: C_CellLayoutDataFunc -> IO (FunPtr C_CellLayoutDataFunc)

{-# DEPRECATED CellLayoutDataFunc ["(Since version 4.20)","There is no replacement"] #-}
-- | A function which should set the value of /@cellLayout@/’s cell renderer(s)
-- as appropriate.
type CellLayoutDataFunc =
    Gtk.CellLayout.CellLayout
    -- ^ /@cellLayout@/: a @GtkCellLayout@
    -> Gtk.CellRenderer.CellRenderer
    -- ^ /@cell@/: the cell renderer whose value is to be set
    -> Gtk.TreeModel.TreeModel
    -- ^ /@treeModel@/: the model
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ indicating the row to set the value for
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `CellLayoutDataFunc`@.
noCellLayoutDataFunc :: Maybe CellLayoutDataFunc
noCellLayoutDataFunc = Nothing

-- | A function which should set the value of /@cellLayout@/’s cell renderer(s)
-- as appropriate.
type CellLayoutDataFunc_WithClosures =
    Gtk.CellLayout.CellLayout
    -- ^ /@cellLayout@/: a @GtkCellLayout@
    -> Gtk.CellRenderer.CellRenderer
    -- ^ /@cell@/: the cell renderer whose value is to be set
    -> Gtk.TreeModel.TreeModel
    -- ^ /@treeModel@/: the model
    -> Gtk.TreeIter.TreeIter
    -- ^ /@iter@/: a @GtkTreeIter@ indicating the row to set the value for
    -> Ptr ()
    -- ^ /@data@/: user data passed to 'GI.Gtk.Interfaces.CellLayout.cellLayoutSetCellDataFunc'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `CellLayoutDataFunc_WithClosures`@.
noCellLayoutDataFunc_WithClosures :: Maybe CellLayoutDataFunc_WithClosures
noCellLayoutDataFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_CellLayoutDataFunc :: CellLayoutDataFunc -> CellLayoutDataFunc_WithClosures
drop_closures_CellLayoutDataFunc _f cellLayout cell treeModel iter _ = _f cellLayout cell treeModel iter

-- | Wrap the callback into a `GClosure`.
genClosure_CellLayoutDataFunc :: MonadIO m => CellLayoutDataFunc -> m (GClosure C_CellLayoutDataFunc)
genClosure_CellLayoutDataFunc cb = liftIO $ do
    let cb' = drop_closures_CellLayoutDataFunc cb
    let cb'' = wrap_CellLayoutDataFunc Nothing cb'
    mk_CellLayoutDataFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `CellLayoutDataFunc` into a `C_CellLayoutDataFunc`.
wrap_CellLayoutDataFunc :: 
    Maybe (Ptr (FunPtr C_CellLayoutDataFunc)) ->
    CellLayoutDataFunc_WithClosures ->
    C_CellLayoutDataFunc
wrap_CellLayoutDataFunc gi'funptrptr gi'cb cellLayout cell treeModel iter data_ = do
    cellLayout' <- (newObject Gtk.CellLayout.CellLayout) cellLayout
    cell' <- (newObject Gtk.CellRenderer.CellRenderer) cell
    treeModel' <- (newObject Gtk.TreeModel.TreeModel) treeModel
    B.ManagedPtr.withTransient  iter $ \iter' -> do
        gi'cb  cellLayout' cell' treeModel' iter' data_
        maybeReleaseFunPtr gi'funptrptr


-- callback CellCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%TRUE to stop iterating over cells."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "renderer"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "CellRenderer" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the cell renderer to operate on"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user-supplied data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of the callback functions used for iterating over\nthe cell renderers of a `GtkCellArea`, see gtk_cell_area_foreach()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CellCallback =
    Ptr Gtk.CellRenderer.CellRenderer ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "renderer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CellRenderer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the cell renderer to operate on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user-supplied data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CellCallback :: FunPtr C_CellCallback -> C_CellCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CellCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.CellRenderer.IsCellRenderer a) =>
    FunPtr C_CellCallback
    -> a
    -- ^ /@renderer@/: the cell renderer to operate on
    -> Ptr ()
    -- ^ /@data@/: user-supplied data
    -> m Bool
    -- ^ __Returns:__ 'P.True' to stop iterating over cells.
dynamic_CellCallback __funPtr renderer data_ = liftIO $ do
    renderer' <- unsafeManagedPtrCastPtr renderer
    result <- (__dynamic_C_CellCallback __funPtr) renderer' data_
    let result' = (/= 0) result
    touchManagedPtr renderer
    return result'

-- | Generate a function pointer callable from C code, from a `C_CellCallback`.
foreign import ccall "wrapper"
    mk_CellCallback :: C_CellCallback -> IO (FunPtr C_CellCallback)

{-# DEPRECATED CellCallback ["(Since version 4.20)","There is no replacement"] #-}
-- | The type of the callback functions used for iterating over
-- the cell renderers of a @GtkCellArea@, see 'GI.Gtk.Objects.CellArea.cellAreaForeach'.
type CellCallback =
    Gtk.CellRenderer.CellRenderer
    -- ^ /@renderer@/: the cell renderer to operate on
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop iterating over cells.

-- | A convenience synonym for @`Nothing` :: `Maybe` `CellCallback`@.
noCellCallback :: Maybe CellCallback
noCellCallback = Nothing

-- | The type of the callback functions used for iterating over
-- the cell renderers of a @GtkCellArea@, see 'GI.Gtk.Objects.CellArea.cellAreaForeach'.
type CellCallback_WithClosures =
    Gtk.CellRenderer.CellRenderer
    -- ^ /@renderer@/: the cell renderer to operate on
    -> Ptr ()
    -- ^ /@data@/: user-supplied data
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop iterating over cells.

-- | A convenience synonym for @`Nothing` :: `Maybe` `CellCallback_WithClosures`@.
noCellCallback_WithClosures :: Maybe CellCallback_WithClosures
noCellCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_CellCallback :: CellCallback -> CellCallback_WithClosures
drop_closures_CellCallback _f renderer _ = _f renderer

-- | Wrap the callback into a `GClosure`.
genClosure_CellCallback :: MonadIO m => CellCallback -> m (GClosure C_CellCallback)
genClosure_CellCallback cb = liftIO $ do
    let cb' = drop_closures_CellCallback cb
    let cb'' = wrap_CellCallback Nothing cb'
    mk_CellCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `CellCallback` into a `C_CellCallback`.
wrap_CellCallback :: 
    Maybe (Ptr (FunPtr C_CellCallback)) ->
    CellCallback_WithClosures ->
    C_CellCallback
wrap_CellCallback gi'funptrptr gi'cb renderer data_ = do
    renderer' <- (newObject Gtk.CellRenderer.CellRenderer) renderer
    result <- gi'cb  renderer' data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback CellAllocCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%TRUE to stop iterating over cells."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "renderer"
          , argType =
              TInterface Name { namespace = "Gtk" , name = "CellRenderer" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the cell renderer to operate on"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cell_area"
          , argType =
              TInterface Name { namespace = "Gdk" , name = "Rectangle" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the area allocated to @renderer inside the rectangle\n  provided to gtk_cell_area_foreach_alloc()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cell_background"
          , argType =
              TInterface Name { namespace = "Gdk" , name = "Rectangle" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the background area for @renderer inside the\n  background area provided to gtk_cell_area_foreach_alloc()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user-supplied data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "4.20"
          , deprecationMessage = Just "There is no replacement"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of the callback functions used for iterating over the\ncell renderers and their allocated areas inside a `GtkCellArea`,\nsee gtk_cell_area_foreach_alloc()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CellAllocCallback =
    Ptr Gtk.CellRenderer.CellRenderer ->
    Ptr Gdk.Rectangle.Rectangle ->
    Ptr Gdk.Rectangle.Rectangle ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "renderer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CellRenderer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the cell renderer to operate on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cell_area"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the area allocated to @renderer inside the rectangle\n  provided to gtk_cell_area_foreach_alloc()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cell_background"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the background area for @renderer inside the\n  background area provided to gtk_cell_area_foreach_alloc()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user-supplied data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CellAllocCallback :: FunPtr C_CellAllocCallback -> C_CellAllocCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CellAllocCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.CellRenderer.IsCellRenderer a) =>
    FunPtr C_CellAllocCallback
    -> a
    -- ^ /@renderer@/: the cell renderer to operate on
    -> Gdk.Rectangle.Rectangle
    -- ^ /@cellArea@/: the area allocated to /@renderer@/ inside the rectangle
    --   provided to 'GI.Gtk.Objects.CellArea.cellAreaForeachAlloc'.
    -> Gdk.Rectangle.Rectangle
    -- ^ /@cellBackground@/: the background area for /@renderer@/ inside the
    --   background area provided to 'GI.Gtk.Objects.CellArea.cellAreaForeachAlloc'.
    -> Ptr ()
    -- ^ /@data@/: user-supplied data
    -> m Bool
    -- ^ __Returns:__ 'P.True' to stop iterating over cells.
dynamic_CellAllocCallback __funPtr renderer cellArea cellBackground data_ = liftIO $ do
    renderer' <- unsafeManagedPtrCastPtr renderer
    cellArea' <- unsafeManagedPtrGetPtr cellArea
    cellBackground' <- unsafeManagedPtrGetPtr cellBackground
    result <- (__dynamic_C_CellAllocCallback __funPtr) renderer' cellArea' cellBackground' data_
    let result' = (/= 0) result
    touchManagedPtr renderer
    touchManagedPtr cellArea
    touchManagedPtr cellBackground
    return result'

-- | Generate a function pointer callable from C code, from a `C_CellAllocCallback`.
foreign import ccall "wrapper"
    mk_CellAllocCallback :: C_CellAllocCallback -> IO (FunPtr C_CellAllocCallback)

{-# DEPRECATED CellAllocCallback ["(Since version 4.20)","There is no replacement"] #-}
-- | The type of the callback functions used for iterating over the
-- cell renderers and their allocated areas inside a @GtkCellArea@,
-- see 'GI.Gtk.Objects.CellArea.cellAreaForeachAlloc'.
type CellAllocCallback =
    Gtk.CellRenderer.CellRenderer
    -- ^ /@renderer@/: the cell renderer to operate on
    -> Gdk.Rectangle.Rectangle
    -- ^ /@cellArea@/: the area allocated to /@renderer@/ inside the rectangle
    --   provided to 'GI.Gtk.Objects.CellArea.cellAreaForeachAlloc'.
    -> Gdk.Rectangle.Rectangle
    -- ^ /@cellBackground@/: the background area for /@renderer@/ inside the
    --   background area provided to 'GI.Gtk.Objects.CellArea.cellAreaForeachAlloc'.
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop iterating over cells.

-- | A convenience synonym for @`Nothing` :: `Maybe` `CellAllocCallback`@.
noCellAllocCallback :: Maybe CellAllocCallback
noCellAllocCallback = Nothing

-- | The type of the callback functions used for iterating over the
-- cell renderers and their allocated areas inside a @GtkCellArea@,
-- see 'GI.Gtk.Objects.CellArea.cellAreaForeachAlloc'.
type CellAllocCallback_WithClosures =
    Gtk.CellRenderer.CellRenderer
    -- ^ /@renderer@/: the cell renderer to operate on
    -> Gdk.Rectangle.Rectangle
    -- ^ /@cellArea@/: the area allocated to /@renderer@/ inside the rectangle
    --   provided to 'GI.Gtk.Objects.CellArea.cellAreaForeachAlloc'.
    -> Gdk.Rectangle.Rectangle
    -- ^ /@cellBackground@/: the background area for /@renderer@/ inside the
    --   background area provided to 'GI.Gtk.Objects.CellArea.cellAreaForeachAlloc'.
    -> Ptr ()
    -- ^ /@data@/: user-supplied data
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop iterating over cells.

-- | A convenience synonym for @`Nothing` :: `Maybe` `CellAllocCallback_WithClosures`@.
noCellAllocCallback_WithClosures :: Maybe CellAllocCallback_WithClosures
noCellAllocCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_CellAllocCallback :: CellAllocCallback -> CellAllocCallback_WithClosures
drop_closures_CellAllocCallback _f renderer cellArea cellBackground _ = _f renderer cellArea cellBackground

-- | Wrap the callback into a `GClosure`.
genClosure_CellAllocCallback :: MonadIO m => CellAllocCallback -> m (GClosure C_CellAllocCallback)
genClosure_CellAllocCallback cb = liftIO $ do
    let cb' = drop_closures_CellAllocCallback cb
    let cb'' = wrap_CellAllocCallback Nothing cb'
    mk_CellAllocCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `CellAllocCallback` into a `C_CellAllocCallback`.
wrap_CellAllocCallback :: 
    Maybe (Ptr (FunPtr C_CellAllocCallback)) ->
    CellAllocCallback_WithClosures ->
    C_CellAllocCallback
wrap_CellAllocCallback gi'funptrptr gi'cb renderer cellArea cellBackground data_ = do
    renderer' <- (newObject Gtk.CellRenderer.CellRenderer) renderer
    B.ManagedPtr.withTransient  cellArea $ \cellArea' -> do
        B.ManagedPtr.withTransient  cellBackground $ \cellBackground' -> do
            result <- gi'cb  renderer' cellArea' cellBackground' data_
            maybeReleaseFunPtr gi'funptrptr
            let result' = (P.fromIntegral . P.fromEnum) result
            return result'


-- callback BuildableParserTextFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "context"
          , argType =
              TInterface
                Name { namespace = "Gtk" , name = "BuildableParseContext" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "text"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "text_len"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BuildableParserTextFieldCallback =
    Ptr Gtk.BuildableParseContext.BuildableParseContext ->
    CString ->
    FCT.CSize ->
    Ptr () ->
    Ptr (Ptr GError) ->
    IO ()

-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "BuildableParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text_len"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BuildableParserTextFieldCallback :: FunPtr C_BuildableParserTextFieldCallback -> C_BuildableParserTextFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BuildableParserTextFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_BuildableParserTextFieldCallback
    -> Gtk.BuildableParseContext.BuildableParseContext
    -> T.Text
    -> FCT.CSize
    -> Ptr ()
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_BuildableParserTextFieldCallback __funPtr context text textLen userData = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    text' <- textToCString text
    onException (do
        propagateGError $ (__dynamic_C_BuildableParserTextFieldCallback __funPtr) context' text' textLen userData
        touchManagedPtr context
        freeMem text'
        return ()
     ) (do
        freeMem text'
     )

-- | Generate a function pointer callable from C code, from a `C_BuildableParserTextFieldCallback`.
foreign import ccall "wrapper"
    mk_BuildableParserTextFieldCallback :: C_BuildableParserTextFieldCallback -> IO (FunPtr C_BuildableParserTextFieldCallback)

-- | /No description available in the introspection data./
type BuildableParserTextFieldCallback =
    Gtk.BuildableParseContext.BuildableParseContext
    -> T.Text
    -> FCT.CSize
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `BuildableParserTextFieldCallback`@.
noBuildableParserTextFieldCallback :: Maybe BuildableParserTextFieldCallback
noBuildableParserTextFieldCallback = Nothing

-- | /No description available in the introspection data./
type BuildableParserTextFieldCallback_WithClosures =
    Gtk.BuildableParseContext.BuildableParseContext
    -> T.Text
    -> FCT.CSize
    -> Ptr ()
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `BuildableParserTextFieldCallback_WithClosures`@.
noBuildableParserTextFieldCallback_WithClosures :: Maybe BuildableParserTextFieldCallback_WithClosures
noBuildableParserTextFieldCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_BuildableParserTextFieldCallback :: BuildableParserTextFieldCallback -> BuildableParserTextFieldCallback_WithClosures
drop_closures_BuildableParserTextFieldCallback _f context text textLen _ = _f context text textLen

-- No Haskell->C wrapper generated since the function throws.

-- callback BuildableParserStartElementFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "context"
          , argType =
              TInterface
                Name { namespace = "Gtk" , name = "BuildableParseContext" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "element_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "attribute_names"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "attribute_values"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BuildableParserStartElementFieldCallback =
    Ptr Gtk.BuildableParseContext.BuildableParseContext ->
    CString ->
    CString ->
    CString ->
    Ptr () ->
    Ptr (Ptr GError) ->
    IO ()

-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "BuildableParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "element_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attribute_names"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attribute_values"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BuildableParserStartElementFieldCallback :: FunPtr C_BuildableParserStartElementFieldCallback -> C_BuildableParserStartElementFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BuildableParserStartElementFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_BuildableParserStartElementFieldCallback
    -> Gtk.BuildableParseContext.BuildableParseContext
    -> T.Text
    -> T.Text
    -> T.Text
    -> Ptr ()
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_BuildableParserStartElementFieldCallback __funPtr context elementName attributeNames attributeValues userData = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    elementName' <- textToCString elementName
    attributeNames' <- textToCString attributeNames
    attributeValues' <- textToCString attributeValues
    onException (do
        propagateGError $ (__dynamic_C_BuildableParserStartElementFieldCallback __funPtr) context' elementName' attributeNames' attributeValues' userData
        touchManagedPtr context
        freeMem elementName'
        freeMem attributeNames'
        freeMem attributeValues'
        return ()
     ) (do
        freeMem elementName'
        freeMem attributeNames'
        freeMem attributeValues'
     )

-- | Generate a function pointer callable from C code, from a `C_BuildableParserStartElementFieldCallback`.
foreign import ccall "wrapper"
    mk_BuildableParserStartElementFieldCallback :: C_BuildableParserStartElementFieldCallback -> IO (FunPtr C_BuildableParserStartElementFieldCallback)

-- | /No description available in the introspection data./
type BuildableParserStartElementFieldCallback =
    Gtk.BuildableParseContext.BuildableParseContext
    -> T.Text
    -> T.Text
    -> T.Text
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `BuildableParserStartElementFieldCallback`@.
noBuildableParserStartElementFieldCallback :: Maybe BuildableParserStartElementFieldCallback
noBuildableParserStartElementFieldCallback = Nothing

-- | /No description available in the introspection data./
type BuildableParserStartElementFieldCallback_WithClosures =
    Gtk.BuildableParseContext.BuildableParseContext
    -> T.Text
    -> T.Text
    -> T.Text
    -> Ptr ()
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `BuildableParserStartElementFieldCallback_WithClosures`@.
noBuildableParserStartElementFieldCallback_WithClosures :: Maybe BuildableParserStartElementFieldCallback_WithClosures
noBuildableParserStartElementFieldCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_BuildableParserStartElementFieldCallback :: BuildableParserStartElementFieldCallback -> BuildableParserStartElementFieldCallback_WithClosures
drop_closures_BuildableParserStartElementFieldCallback _f context elementName attributeNames attributeValues _ = _f context elementName attributeNames attributeValues

-- No Haskell->C wrapper generated since the function throws.

-- callback BuildableParserErrorFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "context"
          , argType =
              TInterface
                Name { namespace = "Gtk" , name = "BuildableParseContext" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "error"
          , argType = TError
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BuildableParserErrorFieldCallback =
    Ptr Gtk.BuildableParseContext.BuildableParseContext ->
    Ptr GError ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "BuildableParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BuildableParserErrorFieldCallback :: FunPtr C_BuildableParserErrorFieldCallback -> C_BuildableParserErrorFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BuildableParserErrorFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_BuildableParserErrorFieldCallback
    -> Gtk.BuildableParseContext.BuildableParseContext
    -> GError
    -> Ptr ()
    -> m ()
dynamic_BuildableParserErrorFieldCallback __funPtr context error_ userData = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    error_' <- unsafeManagedPtrGetPtr error_
    (__dynamic_C_BuildableParserErrorFieldCallback __funPtr) context' error_' userData
    touchManagedPtr context
    touchManagedPtr error_
    return ()

-- | Generate a function pointer callable from C code, from a `C_BuildableParserErrorFieldCallback`.
foreign import ccall "wrapper"
    mk_BuildableParserErrorFieldCallback :: C_BuildableParserErrorFieldCallback -> IO (FunPtr C_BuildableParserErrorFieldCallback)

-- | /No description available in the introspection data./
type BuildableParserErrorFieldCallback =
    Gtk.BuildableParseContext.BuildableParseContext
    -> GError
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BuildableParserErrorFieldCallback`@.
noBuildableParserErrorFieldCallback :: Maybe BuildableParserErrorFieldCallback
noBuildableParserErrorFieldCallback = Nothing

-- | /No description available in the introspection data./
type BuildableParserErrorFieldCallback_WithClosures =
    Gtk.BuildableParseContext.BuildableParseContext
    -> GError
    -> Ptr ()
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BuildableParserErrorFieldCallback_WithClosures`@.
noBuildableParserErrorFieldCallback_WithClosures :: Maybe BuildableParserErrorFieldCallback_WithClosures
noBuildableParserErrorFieldCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_BuildableParserErrorFieldCallback :: BuildableParserErrorFieldCallback -> BuildableParserErrorFieldCallback_WithClosures
drop_closures_BuildableParserErrorFieldCallback _f context error_ _ = _f context error_

-- | Wrap the callback into a `GClosure`.
genClosure_BuildableParserErrorFieldCallback :: MonadIO m => BuildableParserErrorFieldCallback -> m (GClosure C_BuildableParserErrorFieldCallback)
genClosure_BuildableParserErrorFieldCallback cb = liftIO $ do
    let cb' = drop_closures_BuildableParserErrorFieldCallback cb
    let cb'' = wrap_BuildableParserErrorFieldCallback Nothing cb'
    mk_BuildableParserErrorFieldCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `BuildableParserErrorFieldCallback` into a `C_BuildableParserErrorFieldCallback`.
wrap_BuildableParserErrorFieldCallback :: 
    Maybe (Ptr (FunPtr C_BuildableParserErrorFieldCallback)) ->
    BuildableParserErrorFieldCallback_WithClosures ->
    C_BuildableParserErrorFieldCallback
wrap_BuildableParserErrorFieldCallback gi'funptrptr gi'cb context error_ userData = do
    context' <- (newPtr Gtk.BuildableParseContext.BuildableParseContext) context
    error_' <- (newBoxed GError) error_
    gi'cb  context' error_' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback BuildableParserEndElementFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "context"
          , argType =
              TInterface
                Name { namespace = "Gtk" , name = "BuildableParseContext" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "element_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BuildableParserEndElementFieldCallback =
    Ptr Gtk.BuildableParseContext.BuildableParseContext ->
    CString ->
    Ptr () ->
    Ptr (Ptr GError) ->
    IO ()

-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "BuildableParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "element_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BuildableParserEndElementFieldCallback :: FunPtr C_BuildableParserEndElementFieldCallback -> C_BuildableParserEndElementFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BuildableParserEndElementFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_BuildableParserEndElementFieldCallback
    -> Gtk.BuildableParseContext.BuildableParseContext
    -> T.Text
    -> Ptr ()
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_BuildableParserEndElementFieldCallback __funPtr context elementName userData = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    elementName' <- textToCString elementName
    onException (do
        propagateGError $ (__dynamic_C_BuildableParserEndElementFieldCallback __funPtr) context' elementName' userData
        touchManagedPtr context
        freeMem elementName'
        return ()
     ) (do
        freeMem elementName'
     )

-- | Generate a function pointer callable from C code, from a `C_BuildableParserEndElementFieldCallback`.
foreign import ccall "wrapper"
    mk_BuildableParserEndElementFieldCallback :: C_BuildableParserEndElementFieldCallback -> IO (FunPtr C_BuildableParserEndElementFieldCallback)

-- | /No description available in the introspection data./
type BuildableParserEndElementFieldCallback =
    Gtk.BuildableParseContext.BuildableParseContext
    -> T.Text
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `BuildableParserEndElementFieldCallback`@.
noBuildableParserEndElementFieldCallback :: Maybe BuildableParserEndElementFieldCallback
noBuildableParserEndElementFieldCallback = Nothing

-- | /No description available in the introspection data./
type BuildableParserEndElementFieldCallback_WithClosures =
    Gtk.BuildableParseContext.BuildableParseContext
    -> T.Text
    -> Ptr ()
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `BuildableParserEndElementFieldCallback_WithClosures`@.
noBuildableParserEndElementFieldCallback_WithClosures :: Maybe BuildableParserEndElementFieldCallback_WithClosures
noBuildableParserEndElementFieldCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_BuildableParserEndElementFieldCallback :: BuildableParserEndElementFieldCallback -> BuildableParserEndElementFieldCallback_WithClosures
drop_closures_BuildableParserEndElementFieldCallback _f context elementName _ = _f context elementName

-- No Haskell->C wrapper generated since the function throws.

-- callback AssistantPageFunc
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "The next page number"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "current_page"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The page number used to calculate the next page."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Type of callback used to calculate the next page in a `GtkAssistant`.\n\nIt\8217s called both for computing the next page when the user presses the\n\8220forward\8221 button and for handling the behavior of the \8220last\8221 button.\n\nSee [method@Gtk.Assistant.set_forward_page_func]."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_AssistantPageFunc =
    Int32 ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "current_page"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The page number used to calculate the next page."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_AssistantPageFunc :: FunPtr C_AssistantPageFunc -> C_AssistantPageFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_AssistantPageFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_AssistantPageFunc
    -> Int32
    -- ^ /@currentPage@/: The page number used to calculate the next page.
    -> Ptr ()
    -- ^ /@data@/: user data.
    -> m Int32
    -- ^ __Returns:__ The next page number
dynamic_AssistantPageFunc __funPtr currentPage data_ = liftIO $ do
    result <- (__dynamic_C_AssistantPageFunc __funPtr) currentPage data_
    return result

-- | Generate a function pointer callable from C code, from a `C_AssistantPageFunc`.
foreign import ccall "wrapper"
    mk_AssistantPageFunc :: C_AssistantPageFunc -> IO (FunPtr C_AssistantPageFunc)

-- | Type of callback used to calculate the next page in a @GtkAssistant@.
-- 
-- It’s called both for computing the next page when the user presses the
-- “forward” button and for handling the behavior of the “last” button.
-- 
-- See 'GI.Gtk.Objects.Assistant.assistantSetForwardPageFunc'.
type AssistantPageFunc =
    Int32
    -- ^ /@currentPage@/: The page number used to calculate the next page.
    -> IO Int32
    -- ^ __Returns:__ The next page number

-- | A convenience synonym for @`Nothing` :: `Maybe` `AssistantPageFunc`@.
noAssistantPageFunc :: Maybe AssistantPageFunc
noAssistantPageFunc = Nothing

-- | Type of callback used to calculate the next page in a @GtkAssistant@.
-- 
-- It’s called both for computing the next page when the user presses the
-- “forward” button and for handling the behavior of the “last” button.
-- 
-- See 'GI.Gtk.Objects.Assistant.assistantSetForwardPageFunc'.
type AssistantPageFunc_WithClosures =
    Int32
    -- ^ /@currentPage@/: The page number used to calculate the next page.
    -> Ptr ()
    -- ^ /@data@/: user data.
    -> IO Int32
    -- ^ __Returns:__ The next page number

-- | A convenience synonym for @`Nothing` :: `Maybe` `AssistantPageFunc_WithClosures`@.
noAssistantPageFunc_WithClosures :: Maybe AssistantPageFunc_WithClosures
noAssistantPageFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_AssistantPageFunc :: AssistantPageFunc -> AssistantPageFunc_WithClosures
drop_closures_AssistantPageFunc _f currentPage _ = _f currentPage

-- | Wrap the callback into a `GClosure`.
genClosure_AssistantPageFunc :: MonadIO m => AssistantPageFunc -> m (GClosure C_AssistantPageFunc)
genClosure_AssistantPageFunc cb = liftIO $ do
    let cb' = drop_closures_AssistantPageFunc cb
    let cb'' = wrap_AssistantPageFunc Nothing cb'
    mk_AssistantPageFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `AssistantPageFunc` into a `C_AssistantPageFunc`.
wrap_AssistantPageFunc :: 
    Maybe (Ptr (FunPtr C_AssistantPageFunc)) ->
    AssistantPageFunc_WithClosures ->
    C_AssistantPageFunc
wrap_AssistantPageFunc gi'funptrptr gi'cb currentPage data_ = do
    result <- gi'cb  currentPage data_
    maybeReleaseFunPtr gi'funptrptr
    return result



