{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Determines whether to include items by comparing strings to a fixed search term.
-- 
-- The strings are obtained from the items by evaluating an expression
-- set with 'GI.Gtk.Objects.StringFilter.stringFilterSetExpression', and they are
-- compared against a search term set with 'GI.Gtk.Objects.StringFilter.stringFilterSetSearch'.
-- 
-- @GtkStringFilter@ has several different modes of comparison - it
-- can match the whole string, just a prefix, or any substring. Use
-- 'GI.Gtk.Objects.StringFilter.stringFilterSetMatchMode' choose a mode.
-- 
-- It is also possible to make case-insensitive comparisons, with
-- 'GI.Gtk.Objects.StringFilter.stringFilterSetIgnoreCase'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.StringFilter
    ( 

-- * Exported types
    StringFilter(..)                        ,
    IsStringFilter                          ,
    toStringFilter                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.Filter#g:method:changed"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [match]("GI.Gtk.Objects.Filter#g:method:match"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getExpression]("GI.Gtk.Objects.StringFilter#g:method:getExpression"), [getIgnoreCase]("GI.Gtk.Objects.StringFilter#g:method:getIgnoreCase"), [getMatchMode]("GI.Gtk.Objects.StringFilter#g:method:getMatchMode"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSearch]("GI.Gtk.Objects.StringFilter#g:method:getSearch"), [getStrictness]("GI.Gtk.Objects.Filter#g:method:getStrictness").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setExpression]("GI.Gtk.Objects.StringFilter#g:method:setExpression"), [setIgnoreCase]("GI.Gtk.Objects.StringFilter#g:method:setIgnoreCase"), [setMatchMode]("GI.Gtk.Objects.StringFilter#g:method:setMatchMode"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSearch]("GI.Gtk.Objects.StringFilter#g:method:setSearch").

#if defined(ENABLE_OVERLOADING)
    ResolveStringFilterMethod               ,
#endif

-- ** getExpression #method:getExpression#

#if defined(ENABLE_OVERLOADING)
    StringFilterGetExpressionMethodInfo     ,
#endif
    stringFilterGetExpression               ,


-- ** getIgnoreCase #method:getIgnoreCase#

#if defined(ENABLE_OVERLOADING)
    StringFilterGetIgnoreCaseMethodInfo     ,
#endif
    stringFilterGetIgnoreCase               ,


-- ** getMatchMode #method:getMatchMode#

#if defined(ENABLE_OVERLOADING)
    StringFilterGetMatchModeMethodInfo      ,
#endif
    stringFilterGetMatchMode                ,


-- ** getSearch #method:getSearch#

#if defined(ENABLE_OVERLOADING)
    StringFilterGetSearchMethodInfo         ,
#endif
    stringFilterGetSearch                   ,


-- ** new #method:new#

    stringFilterNew                         ,


-- ** setExpression #method:setExpression#

#if defined(ENABLE_OVERLOADING)
    StringFilterSetExpressionMethodInfo     ,
#endif
    stringFilterSetExpression               ,


-- ** setIgnoreCase #method:setIgnoreCase#

#if defined(ENABLE_OVERLOADING)
    StringFilterSetIgnoreCaseMethodInfo     ,
#endif
    stringFilterSetIgnoreCase               ,


-- ** setMatchMode #method:setMatchMode#

#if defined(ENABLE_OVERLOADING)
    StringFilterSetMatchModeMethodInfo      ,
#endif
    stringFilterSetMatchMode                ,


-- ** setSearch #method:setSearch#

#if defined(ENABLE_OVERLOADING)
    StringFilterSetSearchMethodInfo         ,
#endif
    stringFilterSetSearch                   ,




 -- * Properties


-- ** expression #attr:expression#
-- | The expression to evaluate on each item to get a
-- string to compare with.

#if defined(ENABLE_OVERLOADING)
    StringFilterExpressionPropertyInfo      ,
#endif
    clearStringFilterExpression             ,
    constructStringFilterExpression         ,
    getStringFilterExpression               ,
    setStringFilterExpression               ,
#if defined(ENABLE_OVERLOADING)
    stringFilterExpression                  ,
#endif


-- ** ignoreCase #attr:ignoreCase#
-- | If matching is case sensitive.

#if defined(ENABLE_OVERLOADING)
    StringFilterIgnoreCasePropertyInfo      ,
#endif
    constructStringFilterIgnoreCase         ,
    getStringFilterIgnoreCase               ,
    setStringFilterIgnoreCase               ,
#if defined(ENABLE_OVERLOADING)
    stringFilterIgnoreCase                  ,
#endif


-- ** matchMode #attr:matchMode#
-- | If exact matches are necessary or if substrings are allowed.

#if defined(ENABLE_OVERLOADING)
    StringFilterMatchModePropertyInfo       ,
#endif
    constructStringFilterMatchMode          ,
    getStringFilterMatchMode                ,
    setStringFilterMatchMode                ,
#if defined(ENABLE_OVERLOADING)
    stringFilterMatchMode                   ,
#endif


-- ** search #attr:search#
-- | The search term.

#if defined(ENABLE_OVERLOADING)
    StringFilterSearchPropertyInfo          ,
#endif
    clearStringFilterSearch                 ,
    constructStringFilterSearch             ,
    getStringFilterSearch                   ,
    setStringFilterSearch                   ,
#if defined(ENABLE_OVERLOADING)
    stringFilterSearch                      ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter
import {-# SOURCE #-} qualified GI.Gtk.Structs.ExpressionWatch as Gtk.ExpressionWatch

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter

#endif

-- | Memory-managed wrapper type.
newtype StringFilter = StringFilter (SP.ManagedPtr StringFilter)
    deriving (Eq)

instance SP.ManagedPtrNewtype StringFilter where
    toManagedPtr (StringFilter p) = p

foreign import ccall "gtk_string_filter_get_type"
    c_gtk_string_filter_get_type :: IO B.Types.GType

instance B.Types.TypedObject StringFilter where
    glibType = c_gtk_string_filter_get_type

instance B.Types.GObject StringFilter

-- | Type class for types which can be safely cast to t'StringFilter', for instance with `toStringFilter`.
class (SP.GObject o, O.IsDescendantOf StringFilter o) => IsStringFilter o
instance (SP.GObject o, O.IsDescendantOf StringFilter o) => IsStringFilter o

instance O.HasParentTypes StringFilter
type instance O.ParentTypes StringFilter = '[Gtk.Filter.Filter, GObject.Object.Object]

-- | Cast to t'StringFilter', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toStringFilter :: (MIO.MonadIO m, IsStringFilter o) => o -> m StringFilter
toStringFilter = MIO.liftIO . B.ManagedPtr.unsafeCastTo StringFilter

-- | Convert t'StringFilter' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe StringFilter) where
    gvalueGType_ = c_gtk_string_filter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr StringFilter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr StringFilter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject StringFilter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveStringFilterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveStringFilterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveStringFilterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveStringFilterMethod "changed" o = Gtk.Filter.FilterChangedMethodInfo
    ResolveStringFilterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveStringFilterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveStringFilterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveStringFilterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveStringFilterMethod "match" o = Gtk.Filter.FilterMatchMethodInfo
    ResolveStringFilterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveStringFilterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveStringFilterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveStringFilterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveStringFilterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveStringFilterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveStringFilterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveStringFilterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveStringFilterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveStringFilterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveStringFilterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveStringFilterMethod "getExpression" o = StringFilterGetExpressionMethodInfo
    ResolveStringFilterMethod "getIgnoreCase" o = StringFilterGetIgnoreCaseMethodInfo
    ResolveStringFilterMethod "getMatchMode" o = StringFilterGetMatchModeMethodInfo
    ResolveStringFilterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveStringFilterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveStringFilterMethod "getSearch" o = StringFilterGetSearchMethodInfo
    ResolveStringFilterMethod "getStrictness" o = Gtk.Filter.FilterGetStrictnessMethodInfo
    ResolveStringFilterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveStringFilterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveStringFilterMethod "setExpression" o = StringFilterSetExpressionMethodInfo
    ResolveStringFilterMethod "setIgnoreCase" o = StringFilterSetIgnoreCaseMethodInfo
    ResolveStringFilterMethod "setMatchMode" o = StringFilterSetMatchModeMethodInfo
    ResolveStringFilterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveStringFilterMethod "setSearch" o = StringFilterSetSearchMethodInfo
    ResolveStringFilterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveStringFilterMethod t StringFilter, O.OverloadedMethod info StringFilter p) => OL.IsLabel t (StringFilter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveStringFilterMethod t StringFilter, O.OverloadedMethod info StringFilter p, R.HasField t StringFilter p) => R.HasField t StringFilter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveStringFilterMethod t StringFilter, O.OverloadedMethodInfo info StringFilter) => OL.IsLabel t (O.MethodProxy info StringFilter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "expression"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Expression"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@expression@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stringFilter #expression
-- @
getStringFilterExpression :: (MonadIO m, IsStringFilter o) => o -> m (Maybe Gtk.Expression.Expression)
getStringFilterExpression obj = MIO.liftIO $ B.Properties.getObjectPropertyIsGValueInstance obj "expression"

-- | Set the value of the “@expression@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stringFilter [ #expression 'Data.GI.Base.Attributes.:=' value ]
-- @
setStringFilterExpression :: (MonadIO m, IsStringFilter o, Gtk.Expression.IsExpression a) => o -> a -> m ()
setStringFilterExpression obj val = MIO.liftIO $ do
    val' <- Gtk.Expression.toExpression val
    B.Properties.setObjectPropertyIsGValueInstance obj "expression" (Just val')

-- | Construct a t'GValueConstruct' with valid value for the “@expression@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStringFilterExpression :: (IsStringFilter o, MIO.MonadIO m, Gtk.Expression.IsExpression a) => a -> m (GValueConstruct o)
constructStringFilterExpression val = MIO.liftIO $ do
    val' <- Gtk.Expression.toExpression val
    MIO.liftIO $ B.Properties.constructObjectPropertyIsGValueInstance "expression" (P.Just val')

-- | Set the value of the “@expression@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #expression
-- @
clearStringFilterExpression :: (MonadIO m, IsStringFilter o) => o -> m ()
clearStringFilterExpression obj = liftIO $ B.Properties.setObjectPropertyIsGValueInstance obj "expression" (Nothing :: Maybe Gtk.Expression.Expression)

#if defined(ENABLE_OVERLOADING)
data StringFilterExpressionPropertyInfo
instance AttrInfo StringFilterExpressionPropertyInfo where
    type AttrAllowedOps StringFilterExpressionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint StringFilterExpressionPropertyInfo = IsStringFilter
    type AttrSetTypeConstraint StringFilterExpressionPropertyInfo = (~) Gtk.Expression.Expression
    type AttrTransferTypeConstraint StringFilterExpressionPropertyInfo = (~) Gtk.Expression.Expression
    type AttrTransferType StringFilterExpressionPropertyInfo = Gtk.Expression.Expression
    type AttrGetType StringFilterExpressionPropertyInfo = (Maybe Gtk.Expression.Expression)
    type AttrLabel StringFilterExpressionPropertyInfo = "expression"
    type AttrOrigin StringFilterExpressionPropertyInfo = StringFilter
    attrGet = getStringFilterExpression
    attrSet = setStringFilterExpression
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructStringFilterExpression
    attrClear = clearStringFilterExpression
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringFilter.expression"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringFilter.html#g:attr:expression"
        })
#endif

-- VVV Prop "ignore-case"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@ignore-case@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stringFilter #ignoreCase
-- @
getStringFilterIgnoreCase :: (MonadIO m, IsStringFilter o) => o -> m Bool
getStringFilterIgnoreCase obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "ignore-case"

-- | Set the value of the “@ignore-case@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stringFilter [ #ignoreCase 'Data.GI.Base.Attributes.:=' value ]
-- @
setStringFilterIgnoreCase :: (MonadIO m, IsStringFilter o) => o -> Bool -> m ()
setStringFilterIgnoreCase obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "ignore-case" val

-- | Construct a t'GValueConstruct' with valid value for the “@ignore-case@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStringFilterIgnoreCase :: (IsStringFilter o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructStringFilterIgnoreCase val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "ignore-case" val

#if defined(ENABLE_OVERLOADING)
data StringFilterIgnoreCasePropertyInfo
instance AttrInfo StringFilterIgnoreCasePropertyInfo where
    type AttrAllowedOps StringFilterIgnoreCasePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint StringFilterIgnoreCasePropertyInfo = IsStringFilter
    type AttrSetTypeConstraint StringFilterIgnoreCasePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint StringFilterIgnoreCasePropertyInfo = (~) Bool
    type AttrTransferType StringFilterIgnoreCasePropertyInfo = Bool
    type AttrGetType StringFilterIgnoreCasePropertyInfo = Bool
    type AttrLabel StringFilterIgnoreCasePropertyInfo = "ignore-case"
    type AttrOrigin StringFilterIgnoreCasePropertyInfo = StringFilter
    attrGet = getStringFilterIgnoreCase
    attrSet = setStringFilterIgnoreCase
    attrPut = setStringFilterIgnoreCase
    attrTransfer _ v = do
        return v
    attrConstruct = constructStringFilterIgnoreCase
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringFilter.ignoreCase"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringFilter.html#g:attr:ignoreCase"
        })
#endif

-- VVV Prop "match-mode"
   -- Type: TInterface (Name {namespace = "Gtk", name = "StringFilterMatchMode"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@match-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stringFilter #matchMode
-- @
getStringFilterMatchMode :: (MonadIO m, IsStringFilter o) => o -> m Gtk.Enums.StringFilterMatchMode
getStringFilterMatchMode obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "match-mode"

-- | Set the value of the “@match-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stringFilter [ #matchMode 'Data.GI.Base.Attributes.:=' value ]
-- @
setStringFilterMatchMode :: (MonadIO m, IsStringFilter o) => o -> Gtk.Enums.StringFilterMatchMode -> m ()
setStringFilterMatchMode obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "match-mode" val

-- | Construct a t'GValueConstruct' with valid value for the “@match-mode@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStringFilterMatchMode :: (IsStringFilter o, MIO.MonadIO m) => Gtk.Enums.StringFilterMatchMode -> m (GValueConstruct o)
constructStringFilterMatchMode val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "match-mode" val

#if defined(ENABLE_OVERLOADING)
data StringFilterMatchModePropertyInfo
instance AttrInfo StringFilterMatchModePropertyInfo where
    type AttrAllowedOps StringFilterMatchModePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint StringFilterMatchModePropertyInfo = IsStringFilter
    type AttrSetTypeConstraint StringFilterMatchModePropertyInfo = (~) Gtk.Enums.StringFilterMatchMode
    type AttrTransferTypeConstraint StringFilterMatchModePropertyInfo = (~) Gtk.Enums.StringFilterMatchMode
    type AttrTransferType StringFilterMatchModePropertyInfo = Gtk.Enums.StringFilterMatchMode
    type AttrGetType StringFilterMatchModePropertyInfo = Gtk.Enums.StringFilterMatchMode
    type AttrLabel StringFilterMatchModePropertyInfo = "match-mode"
    type AttrOrigin StringFilterMatchModePropertyInfo = StringFilter
    attrGet = getStringFilterMatchMode
    attrSet = setStringFilterMatchMode
    attrPut = setStringFilterMatchMode
    attrTransfer _ v = do
        return v
    attrConstruct = constructStringFilterMatchMode
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringFilter.matchMode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringFilter.html#g:attr:matchMode"
        })
#endif

-- VVV Prop "search"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@search@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stringFilter #search
-- @
getStringFilterSearch :: (MonadIO m, IsStringFilter o) => o -> m (Maybe T.Text)
getStringFilterSearch obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "search"

-- | Set the value of the “@search@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stringFilter [ #search 'Data.GI.Base.Attributes.:=' value ]
-- @
setStringFilterSearch :: (MonadIO m, IsStringFilter o) => o -> T.Text -> m ()
setStringFilterSearch obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "search" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@search@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStringFilterSearch :: (IsStringFilter o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructStringFilterSearch val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "search" (P.Just val)

-- | Set the value of the “@search@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #search
-- @
clearStringFilterSearch :: (MonadIO m, IsStringFilter o) => o -> m ()
clearStringFilterSearch obj = liftIO $ B.Properties.setObjectPropertyString obj "search" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data StringFilterSearchPropertyInfo
instance AttrInfo StringFilterSearchPropertyInfo where
    type AttrAllowedOps StringFilterSearchPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint StringFilterSearchPropertyInfo = IsStringFilter
    type AttrSetTypeConstraint StringFilterSearchPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint StringFilterSearchPropertyInfo = (~) T.Text
    type AttrTransferType StringFilterSearchPropertyInfo = T.Text
    type AttrGetType StringFilterSearchPropertyInfo = (Maybe T.Text)
    type AttrLabel StringFilterSearchPropertyInfo = "search"
    type AttrOrigin StringFilterSearchPropertyInfo = StringFilter
    attrGet = getStringFilterSearch
    attrSet = setStringFilterSearch
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructStringFilterSearch
    attrClear = clearStringFilterSearch
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringFilter.search"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringFilter.html#g:attr:search"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList StringFilter
type instance O.AttributeList StringFilter = StringFilterAttributeList
type StringFilterAttributeList = ('[ '("expression", StringFilterExpressionPropertyInfo), '("ignoreCase", StringFilterIgnoreCasePropertyInfo), '("matchMode", StringFilterMatchModePropertyInfo), '("search", StringFilterSearchPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
stringFilterExpression :: AttrLabelProxy "expression"
stringFilterExpression = AttrLabelProxy

stringFilterIgnoreCase :: AttrLabelProxy "ignoreCase"
stringFilterIgnoreCase = AttrLabelProxy

stringFilterMatchMode :: AttrLabelProxy "matchMode"
stringFilterMatchMode = AttrLabelProxy

stringFilterSearch :: AttrLabelProxy "search"
stringFilterSearch = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList StringFilter = StringFilterSignalList
type StringFilterSignalList = ('[ '("changed", Gtk.Filter.FilterChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method StringFilter::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "expression"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expression" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the expression to evaluate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "StringFilter" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_filter_new" gtk_string_filter_new :: 
    Ptr Gtk.Expression.Expression ->        -- expression : TInterface (Name {namespace = "Gtk", name = "Expression"})
    IO (Ptr StringFilter)

-- | Creates a new string filter.
-- 
-- You will want to set up the filter by providing a string to search for
-- and by providing a property to look up on the item.
stringFilterNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Expression.IsExpression a) =>
    Maybe (a)
    -- ^ /@expression@/: the expression to evaluate
    -> m StringFilter
    -- ^ __Returns:__ a new @GtkStringFilter@
stringFilterNew expression = liftIO $ do
    maybeExpression <- case expression of
        Nothing -> return FP.nullPtr
        Just jExpression -> do
            jExpression' <- B.ManagedPtr.disownManagedPtr jExpression
            return jExpression'
    result <- gtk_string_filter_new maybeExpression
    checkUnexpectedReturnNULL "stringFilterNew" result
    result' <- (wrapObject StringFilter) result
    whenJust expression touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method StringFilter::get_expression
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Expression" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_filter_get_expression" gtk_string_filter_get_expression :: 
    Ptr StringFilter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringFilter"})
    IO (Ptr Gtk.Expression.Expression)

-- | Gets the expression that the string filter uses to
-- obtain strings from items.
stringFilterGetExpression ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringFilter a) =>
    a
    -- ^ /@self@/: a string filter
    -> m (Maybe Gtk.Expression.Expression)
    -- ^ __Returns:__ the expression
stringFilterGetExpression self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_string_filter_get_expression self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Gtk.Expression.Expression) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data StringFilterGetExpressionMethodInfo
instance (signature ~ (m (Maybe Gtk.Expression.Expression)), MonadIO m, IsStringFilter a) => O.OverloadedMethod StringFilterGetExpressionMethodInfo a signature where
    overloadedMethod = stringFilterGetExpression

instance O.OverloadedMethodInfo StringFilterGetExpressionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringFilter.stringFilterGetExpression",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringFilter.html#v:stringFilterGetExpression"
        })


#endif

-- method StringFilter::get_ignore_case
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_filter_get_ignore_case" gtk_string_filter_get_ignore_case :: 
    Ptr StringFilter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringFilter"})
    IO CInt

-- | Returns whether the filter ignores case differences.
stringFilterGetIgnoreCase ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringFilter a) =>
    a
    -- ^ /@self@/: a string filter
    -> m Bool
    -- ^ __Returns:__ true if the filter ignores case
stringFilterGetIgnoreCase self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_string_filter_get_ignore_case self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data StringFilterGetIgnoreCaseMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsStringFilter a) => O.OverloadedMethod StringFilterGetIgnoreCaseMethodInfo a signature where
    overloadedMethod = stringFilterGetIgnoreCase

instance O.OverloadedMethodInfo StringFilterGetIgnoreCaseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringFilter.stringFilterGetIgnoreCase",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringFilter.html#v:stringFilterGetIgnoreCase"
        })


#endif

-- method StringFilter::get_match_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "StringFilterMatchMode" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_filter_get_match_mode" gtk_string_filter_get_match_mode :: 
    Ptr StringFilter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringFilter"})
    IO CUInt

-- | Returns the match mode that the filter is using.
stringFilterGetMatchMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringFilter a) =>
    a
    -- ^ /@self@/: a string filter
    -> m Gtk.Enums.StringFilterMatchMode
    -- ^ __Returns:__ the match mode of the filter
stringFilterGetMatchMode self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_string_filter_get_match_mode self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data StringFilterGetMatchModeMethodInfo
instance (signature ~ (m Gtk.Enums.StringFilterMatchMode), MonadIO m, IsStringFilter a) => O.OverloadedMethod StringFilterGetMatchModeMethodInfo a signature where
    overloadedMethod = stringFilterGetMatchMode

instance O.OverloadedMethodInfo StringFilterGetMatchModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringFilter.stringFilterGetMatchMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringFilter.html#v:stringFilterGetMatchMode"
        })


#endif

-- method StringFilter::get_search
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_filter_get_search" gtk_string_filter_get_search :: 
    Ptr StringFilter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringFilter"})
    IO CString

-- | Gets the search term.
stringFilterGetSearch ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringFilter a) =>
    a
    -- ^ /@self@/: a string filter
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the search term
stringFilterGetSearch self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_string_filter_get_search self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data StringFilterGetSearchMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsStringFilter a) => O.OverloadedMethod StringFilterGetSearchMethodInfo a signature where
    overloadedMethod = stringFilterGetSearch

instance O.OverloadedMethodInfo StringFilterGetSearchMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringFilter.stringFilterGetSearch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringFilter.html#v:stringFilterGetSearch"
        })


#endif

-- method StringFilter::set_expression
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "expression"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expression" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the expression" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_filter_set_expression" gtk_string_filter_set_expression :: 
    Ptr StringFilter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringFilter"})
    Ptr Gtk.Expression.Expression ->        -- expression : TInterface (Name {namespace = "Gtk", name = "Expression"})
    IO ()

-- | Sets the expression that the string filter uses to
-- obtain strings from items.
-- 
-- The expression must have a value type of @G_TYPE_STRING@.
stringFilterSetExpression ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringFilter a, Gtk.Expression.IsExpression b) =>
    a
    -- ^ /@self@/: a string filter
    -> Maybe (b)
    -- ^ /@expression@/: the expression
    -> m ()
stringFilterSetExpression self expression = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeExpression <- case expression of
        Nothing -> return FP.nullPtr
        Just jExpression -> do
            jExpression' <- unsafeManagedPtrCastPtr jExpression
            return jExpression'
    gtk_string_filter_set_expression self' maybeExpression
    touchManagedPtr self
    whenJust expression touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data StringFilterSetExpressionMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsStringFilter a, Gtk.Expression.IsExpression b) => O.OverloadedMethod StringFilterSetExpressionMethodInfo a signature where
    overloadedMethod = stringFilterSetExpression

instance O.OverloadedMethodInfo StringFilterSetExpressionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringFilter.stringFilterSetExpression",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringFilter.html#v:stringFilterSetExpression"
        })


#endif

-- method StringFilter::set_ignore_case
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ignore_case"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to ignore case"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_filter_set_ignore_case" gtk_string_filter_set_ignore_case :: 
    Ptr StringFilter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringFilter"})
    CInt ->                                 -- ignore_case : TBasicType TBoolean
    IO ()

-- | Sets whether the filter ignores case differences.
stringFilterSetIgnoreCase ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringFilter a) =>
    a
    -- ^ /@self@/: a string filter
    -> Bool
    -- ^ /@ignoreCase@/: true to ignore case
    -> m ()
stringFilterSetIgnoreCase self ignoreCase = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let ignoreCase' = (P.fromIntegral . P.fromEnum) ignoreCase
    gtk_string_filter_set_ignore_case self' ignoreCase'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StringFilterSetIgnoreCaseMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsStringFilter a) => O.OverloadedMethod StringFilterSetIgnoreCaseMethodInfo a signature where
    overloadedMethod = stringFilterSetIgnoreCase

instance O.OverloadedMethodInfo StringFilterSetIgnoreCaseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringFilter.stringFilterSetIgnoreCase",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringFilter.html#v:stringFilterSetIgnoreCase"
        })


#endif

-- method StringFilter::set_match_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "StringFilterMatchMode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new match mode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_filter_set_match_mode" gtk_string_filter_set_match_mode :: 
    Ptr StringFilter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringFilter"})
    CUInt ->                                -- mode : TInterface (Name {namespace = "Gtk", name = "StringFilterMatchMode"})
    IO ()

-- | Sets the match mode for the filter.
stringFilterSetMatchMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringFilter a) =>
    a
    -- ^ /@self@/: a string filter
    -> Gtk.Enums.StringFilterMatchMode
    -- ^ /@mode@/: the new match mode
    -> m ()
stringFilterSetMatchMode self mode = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let mode' = (fromIntegral . fromEnum) mode
    gtk_string_filter_set_match_mode self' mode'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StringFilterSetMatchModeMethodInfo
instance (signature ~ (Gtk.Enums.StringFilterMatchMode -> m ()), MonadIO m, IsStringFilter a) => O.OverloadedMethod StringFilterSetMatchModeMethodInfo a signature where
    overloadedMethod = stringFilterSetMatchMode

instance O.OverloadedMethodInfo StringFilterSetMatchModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringFilter.stringFilterSetMatchMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringFilter.html#v:stringFilterSetMatchMode"
        })


#endif

-- method StringFilter::set_search
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "search"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to search for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_filter_set_search" gtk_string_filter_set_search :: 
    Ptr StringFilter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringFilter"})
    CString ->                              -- search : TBasicType TUTF8
    IO ()

-- | Sets the string to search for.
stringFilterSetSearch ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringFilter a) =>
    a
    -- ^ /@self@/: a string filter
    -> Maybe (T.Text)
    -- ^ /@search@/: the string to search for
    -> m ()
stringFilterSetSearch self search = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeSearch <- case search of
        Nothing -> return FP.nullPtr
        Just jSearch -> do
            jSearch' <- textToCString jSearch
            return jSearch'
    gtk_string_filter_set_search self' maybeSearch
    touchManagedPtr self
    freeMem maybeSearch
    return ()

#if defined(ENABLE_OVERLOADING)
data StringFilterSetSearchMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsStringFilter a) => O.OverloadedMethod StringFilterSetSearchMethodInfo a signature where
    overloadedMethod = stringFilterSetSearch

instance O.OverloadedMethodInfo StringFilterSetSearchMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringFilter.stringFilterSetSearch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringFilter.html#v:stringFilterSetSearch"
        })


#endif


