{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The integration point for media playback inside GTK.
-- 
-- GTK provides an implementation of the @GtkMediaStream@ interface that
-- is called t'GI.Gtk.Objects.MediaFile.MediaFile'.
-- 
-- Apart from application-facing API for stream playback, @GtkMediaStream@
-- has a number of APIs that are only useful for implementations and should
-- not be used in applications:
-- t'GI.Gtk.Objects.MediaStream.MediaStream'.@/prepared/@(),
-- t'GI.Gtk.Objects.MediaStream.MediaStream'.@/unprepared/@(),
-- 'GI.Gtk.Objects.MediaStream.mediaStreamUpdate',
-- t'GI.Gtk.Objects.MediaStream.MediaStream'.@/ended/@(),
-- 'GI.Gtk.Objects.MediaStream.mediaStreamSeekSuccess',
-- 'GI.Gtk.Objects.MediaStream.mediaStreamSeekFailed',
-- 'GI.Gtk.Objects.MediaStream.mediaStreamGerror',
-- t'GI.Gtk.Objects.MediaStream.MediaStream'.@/error/@(),
-- t'GI.Gtk.Objects.MediaStream.MediaStream'.@/error_valist/@().

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.MediaStream
    ( 

-- * Exported types
    MediaStream(..)                         ,
    IsMediaStream                           ,
    toMediaStream                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [computeConcreteSize]("GI.Gdk.Interfaces.Paintable#g:method:computeConcreteSize"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [gerror]("GI.Gtk.Objects.MediaStream#g:method:gerror"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasAudio]("GI.Gtk.Objects.MediaStream#g:method:hasAudio"), [hasVideo]("GI.Gtk.Objects.MediaStream#g:method:hasVideo"), [invalidateContents]("GI.Gdk.Interfaces.Paintable#g:method:invalidateContents"), [invalidateSize]("GI.Gdk.Interfaces.Paintable#g:method:invalidateSize"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isPrepared]("GI.Gtk.Objects.MediaStream#g:method:isPrepared"), [isSeekable]("GI.Gtk.Objects.MediaStream#g:method:isSeekable"), [isSeeking]("GI.Gtk.Objects.MediaStream#g:method:isSeeking"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [pause]("GI.Gtk.Objects.MediaStream#g:method:pause"), [play]("GI.Gtk.Objects.MediaStream#g:method:play"), [realize]("GI.Gtk.Objects.MediaStream#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [seek]("GI.Gtk.Objects.MediaStream#g:method:seek"), [seekFailed]("GI.Gtk.Objects.MediaStream#g:method:seekFailed"), [seekSuccess]("GI.Gtk.Objects.MediaStream#g:method:seekSuccess"), [snapshot]("GI.Gdk.Interfaces.Paintable#g:method:snapshot"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [streamEnded]("GI.Gtk.Objects.MediaStream#g:method:streamEnded"), [streamPrepared]("GI.Gtk.Objects.MediaStream#g:method:streamPrepared"), [streamUnprepared]("GI.Gtk.Objects.MediaStream#g:method:streamUnprepared"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unrealize]("GI.Gtk.Objects.MediaStream#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [update]("GI.Gtk.Objects.MediaStream#g:method:update"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCurrentImage]("GI.Gdk.Interfaces.Paintable#g:method:getCurrentImage"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDuration]("GI.Gtk.Objects.MediaStream#g:method:getDuration"), [getEnded]("GI.Gtk.Objects.MediaStream#g:method:getEnded"), [getError]("GI.Gtk.Objects.MediaStream#g:method:getError"), [getFlags]("GI.Gdk.Interfaces.Paintable#g:method:getFlags"), [getIntrinsicAspectRatio]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicAspectRatio"), [getIntrinsicHeight]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicHeight"), [getIntrinsicWidth]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicWidth"), [getLoop]("GI.Gtk.Objects.MediaStream#g:method:getLoop"), [getMuted]("GI.Gtk.Objects.MediaStream#g:method:getMuted"), [getPlaying]("GI.Gtk.Objects.MediaStream#g:method:getPlaying"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getTimestamp]("GI.Gtk.Objects.MediaStream#g:method:getTimestamp"), [getVolume]("GI.Gtk.Objects.MediaStream#g:method:getVolume").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setLoop]("GI.Gtk.Objects.MediaStream#g:method:setLoop"), [setMuted]("GI.Gtk.Objects.MediaStream#g:method:setMuted"), [setPlaying]("GI.Gtk.Objects.MediaStream#g:method:setPlaying"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setVolume]("GI.Gtk.Objects.MediaStream#g:method:setVolume").

#if defined(ENABLE_OVERLOADING)
    ResolveMediaStreamMethod                ,
#endif

-- ** gerror #method:gerror#

#if defined(ENABLE_OVERLOADING)
    MediaStreamGerrorMethodInfo             ,
#endif
    mediaStreamGerror                       ,


-- ** getDuration #method:getDuration#

#if defined(ENABLE_OVERLOADING)
    MediaStreamGetDurationMethodInfo        ,
#endif
    mediaStreamGetDuration                  ,


-- ** getEnded #method:getEnded#

#if defined(ENABLE_OVERLOADING)
    MediaStreamGetEndedMethodInfo           ,
#endif
    mediaStreamGetEnded                     ,


-- ** getError #method:getError#

#if defined(ENABLE_OVERLOADING)
    MediaStreamGetErrorMethodInfo           ,
#endif
    mediaStreamGetError                     ,


-- ** getLoop #method:getLoop#

#if defined(ENABLE_OVERLOADING)
    MediaStreamGetLoopMethodInfo            ,
#endif
    mediaStreamGetLoop                      ,


-- ** getMuted #method:getMuted#

#if defined(ENABLE_OVERLOADING)
    MediaStreamGetMutedMethodInfo           ,
#endif
    mediaStreamGetMuted                     ,


-- ** getPlaying #method:getPlaying#

#if defined(ENABLE_OVERLOADING)
    MediaStreamGetPlayingMethodInfo         ,
#endif
    mediaStreamGetPlaying                   ,


-- ** getTimestamp #method:getTimestamp#

#if defined(ENABLE_OVERLOADING)
    MediaStreamGetTimestampMethodInfo       ,
#endif
    mediaStreamGetTimestamp                 ,


-- ** getVolume #method:getVolume#

#if defined(ENABLE_OVERLOADING)
    MediaStreamGetVolumeMethodInfo          ,
#endif
    mediaStreamGetVolume                    ,


-- ** hasAudio #method:hasAudio#

#if defined(ENABLE_OVERLOADING)
    MediaStreamHasAudioMethodInfo           ,
#endif
    mediaStreamHasAudio                     ,


-- ** hasVideo #method:hasVideo#

#if defined(ENABLE_OVERLOADING)
    MediaStreamHasVideoMethodInfo           ,
#endif
    mediaStreamHasVideo                     ,


-- ** isPrepared #method:isPrepared#

#if defined(ENABLE_OVERLOADING)
    MediaStreamIsPreparedMethodInfo         ,
#endif
    mediaStreamIsPrepared                   ,


-- ** isSeekable #method:isSeekable#

#if defined(ENABLE_OVERLOADING)
    MediaStreamIsSeekableMethodInfo         ,
#endif
    mediaStreamIsSeekable                   ,


-- ** isSeeking #method:isSeeking#

#if defined(ENABLE_OVERLOADING)
    MediaStreamIsSeekingMethodInfo          ,
#endif
    mediaStreamIsSeeking                    ,


-- ** pause #method:pause#

#if defined(ENABLE_OVERLOADING)
    MediaStreamPauseMethodInfo              ,
#endif
    mediaStreamPause                        ,


-- ** play #method:play#

#if defined(ENABLE_OVERLOADING)
    MediaStreamPlayMethodInfo               ,
#endif
    mediaStreamPlay                         ,


-- ** realize #method:realize#

#if defined(ENABLE_OVERLOADING)
    MediaStreamRealizeMethodInfo            ,
#endif
    mediaStreamRealize                      ,


-- ** seek #method:seek#

#if defined(ENABLE_OVERLOADING)
    MediaStreamSeekMethodInfo               ,
#endif
    mediaStreamSeek                         ,


-- ** seekFailed #method:seekFailed#

#if defined(ENABLE_OVERLOADING)
    MediaStreamSeekFailedMethodInfo         ,
#endif
    mediaStreamSeekFailed                   ,


-- ** seekSuccess #method:seekSuccess#

#if defined(ENABLE_OVERLOADING)
    MediaStreamSeekSuccessMethodInfo        ,
#endif
    mediaStreamSeekSuccess                  ,


-- ** setLoop #method:setLoop#

#if defined(ENABLE_OVERLOADING)
    MediaStreamSetLoopMethodInfo            ,
#endif
    mediaStreamSetLoop                      ,


-- ** setMuted #method:setMuted#

#if defined(ENABLE_OVERLOADING)
    MediaStreamSetMutedMethodInfo           ,
#endif
    mediaStreamSetMuted                     ,


-- ** setPlaying #method:setPlaying#

#if defined(ENABLE_OVERLOADING)
    MediaStreamSetPlayingMethodInfo         ,
#endif
    mediaStreamSetPlaying                   ,


-- ** setVolume #method:setVolume#

#if defined(ENABLE_OVERLOADING)
    MediaStreamSetVolumeMethodInfo          ,
#endif
    mediaStreamSetVolume                    ,


-- ** streamEnded #method:streamEnded#

#if defined(ENABLE_OVERLOADING)
    MediaStreamStreamEndedMethodInfo        ,
#endif
    mediaStreamStreamEnded                  ,


-- ** streamPrepared #method:streamPrepared#

#if defined(ENABLE_OVERLOADING)
    MediaStreamStreamPreparedMethodInfo     ,
#endif
    mediaStreamStreamPrepared               ,


-- ** streamUnprepared #method:streamUnprepared#

#if defined(ENABLE_OVERLOADING)
    MediaStreamStreamUnpreparedMethodInfo   ,
#endif
    mediaStreamStreamUnprepared             ,


-- ** unrealize #method:unrealize#

#if defined(ENABLE_OVERLOADING)
    MediaStreamUnrealizeMethodInfo          ,
#endif
    mediaStreamUnrealize                    ,


-- ** update #method:update#

#if defined(ENABLE_OVERLOADING)
    MediaStreamUpdateMethodInfo             ,
#endif
    mediaStreamUpdate                       ,




 -- * Properties


-- ** duration #attr:duration#
-- | The stream\'s duration in microseconds or 0 if unknown.

#if defined(ENABLE_OVERLOADING)
    MediaStreamDurationPropertyInfo         ,
#endif
    getMediaStreamDuration                  ,
#if defined(ENABLE_OVERLOADING)
    mediaStreamDuration                     ,
#endif


-- ** ended #attr:ended#
-- | Set when playback has finished.

#if defined(ENABLE_OVERLOADING)
    MediaStreamEndedPropertyInfo            ,
#endif
    getMediaStreamEnded                     ,
#if defined(ENABLE_OVERLOADING)
    mediaStreamEnded                        ,
#endif


-- ** error #attr:error#
-- | 'P.Nothing' for a properly working stream or the @GError@
-- that the stream is in.

#if defined(ENABLE_OVERLOADING)
    MediaStreamErrorPropertyInfo            ,
#endif
    getMediaStreamError                     ,
#if defined(ENABLE_OVERLOADING)
    mediaStreamError                        ,
#endif


-- ** hasAudio #attr:hasAudio#
-- | Whether the stream contains audio.

#if defined(ENABLE_OVERLOADING)
    MediaStreamHasAudioPropertyInfo         ,
#endif
    getMediaStreamHasAudio                  ,


-- ** hasVideo #attr:hasVideo#
-- | Whether the stream contains video.

#if defined(ENABLE_OVERLOADING)
    MediaStreamHasVideoPropertyInfo         ,
#endif
    getMediaStreamHasVideo                  ,


-- ** loop #attr:loop#
-- | Try to restart the media from the beginning once it ended.

#if defined(ENABLE_OVERLOADING)
    MediaStreamLoopPropertyInfo             ,
#endif
    constructMediaStreamLoop                ,
    getMediaStreamLoop                      ,
#if defined(ENABLE_OVERLOADING)
    mediaStreamLoop                         ,
#endif
    setMediaStreamLoop                      ,


-- ** muted #attr:muted#
-- | Whether the audio stream should be muted.

#if defined(ENABLE_OVERLOADING)
    MediaStreamMutedPropertyInfo            ,
#endif
    constructMediaStreamMuted               ,
    getMediaStreamMuted                     ,
#if defined(ENABLE_OVERLOADING)
    mediaStreamMuted                        ,
#endif
    setMediaStreamMuted                     ,


-- ** playing #attr:playing#
-- | Whether the stream is currently playing.

#if defined(ENABLE_OVERLOADING)
    MediaStreamPlayingPropertyInfo          ,
#endif
    constructMediaStreamPlaying             ,
    getMediaStreamPlaying                   ,
#if defined(ENABLE_OVERLOADING)
    mediaStreamPlaying                      ,
#endif
    setMediaStreamPlaying                   ,


-- ** prepared #attr:prepared#
-- | Whether the stream has finished initializing and existence of
-- audio and video is known.

#if defined(ENABLE_OVERLOADING)
    MediaStreamPreparedPropertyInfo         ,
#endif
    getMediaStreamPrepared                  ,
#if defined(ENABLE_OVERLOADING)
    mediaStreamPrepared                     ,
#endif


-- ** seekable #attr:seekable#
-- | Set unless the stream is known to not support seeking.

#if defined(ENABLE_OVERLOADING)
    MediaStreamSeekablePropertyInfo         ,
#endif
    getMediaStreamSeekable                  ,
#if defined(ENABLE_OVERLOADING)
    mediaStreamSeekable                     ,
#endif


-- ** seeking #attr:seeking#
-- | Set while a seek is in progress.

#if defined(ENABLE_OVERLOADING)
    MediaStreamSeekingPropertyInfo          ,
#endif
    getMediaStreamSeeking                   ,
#if defined(ENABLE_OVERLOADING)
    mediaStreamSeeking                      ,
#endif


-- ** timestamp #attr:timestamp#
-- | The current presentation timestamp in microseconds.

#if defined(ENABLE_OVERLOADING)
    MediaStreamTimestampPropertyInfo        ,
#endif
    getMediaStreamTimestamp                 ,
#if defined(ENABLE_OVERLOADING)
    mediaStreamTimestamp                    ,
#endif


-- ** volume #attr:volume#
-- | Volume of the audio stream.

#if defined(ENABLE_OVERLOADING)
    MediaStreamVolumePropertyInfo           ,
#endif
    constructMediaStreamVolume              ,
    getMediaStreamVolume                    ,
#if defined(ENABLE_OVERLOADING)
    mediaStreamVolume                       ,
#endif
    setMediaStreamVolume                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Surface as Gdk.Surface

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Surface as Gdk.Surface

#endif

-- | Memory-managed wrapper type.
newtype MediaStream = MediaStream (SP.ManagedPtr MediaStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype MediaStream where
    toManagedPtr (MediaStream p) = p

foreign import ccall "gtk_media_stream_get_type"
    c_gtk_media_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject MediaStream where
    glibType = c_gtk_media_stream_get_type

instance B.Types.GObject MediaStream

-- | Type class for types which can be safely cast to t'MediaStream', for instance with `toMediaStream`.
class (SP.GObject o, O.IsDescendantOf MediaStream o) => IsMediaStream o
instance (SP.GObject o, O.IsDescendantOf MediaStream o) => IsMediaStream o

instance O.HasParentTypes MediaStream
type instance O.ParentTypes MediaStream = '[GObject.Object.Object, Gdk.Paintable.Paintable]

-- | Cast to t'MediaStream', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toMediaStream :: (MIO.MonadIO m, IsMediaStream o) => o -> m MediaStream
toMediaStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo MediaStream

-- | Convert t'MediaStream' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MediaStream) where
    gvalueGType_ = c_gtk_media_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MediaStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MediaStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MediaStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMediaStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMediaStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMediaStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMediaStreamMethod "computeConcreteSize" o = Gdk.Paintable.PaintableComputeConcreteSizeMethodInfo
    ResolveMediaStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMediaStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMediaStreamMethod "gerror" o = MediaStreamGerrorMethodInfo
    ResolveMediaStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMediaStreamMethod "hasAudio" o = MediaStreamHasAudioMethodInfo
    ResolveMediaStreamMethod "hasVideo" o = MediaStreamHasVideoMethodInfo
    ResolveMediaStreamMethod "invalidateContents" o = Gdk.Paintable.PaintableInvalidateContentsMethodInfo
    ResolveMediaStreamMethod "invalidateSize" o = Gdk.Paintable.PaintableInvalidateSizeMethodInfo
    ResolveMediaStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMediaStreamMethod "isPrepared" o = MediaStreamIsPreparedMethodInfo
    ResolveMediaStreamMethod "isSeekable" o = MediaStreamIsSeekableMethodInfo
    ResolveMediaStreamMethod "isSeeking" o = MediaStreamIsSeekingMethodInfo
    ResolveMediaStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMediaStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMediaStreamMethod "pause" o = MediaStreamPauseMethodInfo
    ResolveMediaStreamMethod "play" o = MediaStreamPlayMethodInfo
    ResolveMediaStreamMethod "realize" o = MediaStreamRealizeMethodInfo
    ResolveMediaStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMediaStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMediaStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMediaStreamMethod "seek" o = MediaStreamSeekMethodInfo
    ResolveMediaStreamMethod "seekFailed" o = MediaStreamSeekFailedMethodInfo
    ResolveMediaStreamMethod "seekSuccess" o = MediaStreamSeekSuccessMethodInfo
    ResolveMediaStreamMethod "snapshot" o = Gdk.Paintable.PaintableSnapshotMethodInfo
    ResolveMediaStreamMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMediaStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMediaStreamMethod "streamEnded" o = MediaStreamStreamEndedMethodInfo
    ResolveMediaStreamMethod "streamPrepared" o = MediaStreamStreamPreparedMethodInfo
    ResolveMediaStreamMethod "streamUnprepared" o = MediaStreamStreamUnpreparedMethodInfo
    ResolveMediaStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMediaStreamMethod "unrealize" o = MediaStreamUnrealizeMethodInfo
    ResolveMediaStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMediaStreamMethod "update" o = MediaStreamUpdateMethodInfo
    ResolveMediaStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMediaStreamMethod "getCurrentImage" o = Gdk.Paintable.PaintableGetCurrentImageMethodInfo
    ResolveMediaStreamMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMediaStreamMethod "getDuration" o = MediaStreamGetDurationMethodInfo
    ResolveMediaStreamMethod "getEnded" o = MediaStreamGetEndedMethodInfo
    ResolveMediaStreamMethod "getError" o = MediaStreamGetErrorMethodInfo
    ResolveMediaStreamMethod "getFlags" o = Gdk.Paintable.PaintableGetFlagsMethodInfo
    ResolveMediaStreamMethod "getIntrinsicAspectRatio" o = Gdk.Paintable.PaintableGetIntrinsicAspectRatioMethodInfo
    ResolveMediaStreamMethod "getIntrinsicHeight" o = Gdk.Paintable.PaintableGetIntrinsicHeightMethodInfo
    ResolveMediaStreamMethod "getIntrinsicWidth" o = Gdk.Paintable.PaintableGetIntrinsicWidthMethodInfo
    ResolveMediaStreamMethod "getLoop" o = MediaStreamGetLoopMethodInfo
    ResolveMediaStreamMethod "getMuted" o = MediaStreamGetMutedMethodInfo
    ResolveMediaStreamMethod "getPlaying" o = MediaStreamGetPlayingMethodInfo
    ResolveMediaStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMediaStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMediaStreamMethod "getTimestamp" o = MediaStreamGetTimestampMethodInfo
    ResolveMediaStreamMethod "getVolume" o = MediaStreamGetVolumeMethodInfo
    ResolveMediaStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMediaStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMediaStreamMethod "setLoop" o = MediaStreamSetLoopMethodInfo
    ResolveMediaStreamMethod "setMuted" o = MediaStreamSetMutedMethodInfo
    ResolveMediaStreamMethod "setPlaying" o = MediaStreamSetPlayingMethodInfo
    ResolveMediaStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMediaStreamMethod "setVolume" o = MediaStreamSetVolumeMethodInfo
    ResolveMediaStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMediaStreamMethod t MediaStream, O.OverloadedMethod info MediaStream p) => OL.IsLabel t (MediaStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMediaStreamMethod t MediaStream, O.OverloadedMethod info MediaStream p, R.HasField t MediaStream p) => R.HasField t MediaStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMediaStreamMethod t MediaStream, O.OverloadedMethodInfo info MediaStream) => OL.IsLabel t (O.MethodProxy info MediaStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "duration"
   -- Type: TBasicType TInt64
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@duration@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaStream #duration
-- @
getMediaStreamDuration :: (MonadIO m, IsMediaStream o) => o -> m Int64
getMediaStreamDuration obj = MIO.liftIO $ B.Properties.getObjectPropertyInt64 obj "duration"

#if defined(ENABLE_OVERLOADING)
data MediaStreamDurationPropertyInfo
instance AttrInfo MediaStreamDurationPropertyInfo where
    type AttrAllowedOps MediaStreamDurationPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MediaStreamDurationPropertyInfo = IsMediaStream
    type AttrSetTypeConstraint MediaStreamDurationPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MediaStreamDurationPropertyInfo = (~) ()
    type AttrTransferType MediaStreamDurationPropertyInfo = ()
    type AttrGetType MediaStreamDurationPropertyInfo = Int64
    type AttrLabel MediaStreamDurationPropertyInfo = "duration"
    type AttrOrigin MediaStreamDurationPropertyInfo = MediaStream
    attrGet = getMediaStreamDuration
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.duration"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#g:attr:duration"
        })
#endif

-- VVV Prop "ended"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@ended@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaStream #ended
-- @
getMediaStreamEnded :: (MonadIO m, IsMediaStream o) => o -> m Bool
getMediaStreamEnded obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "ended"

#if defined(ENABLE_OVERLOADING)
data MediaStreamEndedPropertyInfo
instance AttrInfo MediaStreamEndedPropertyInfo where
    type AttrAllowedOps MediaStreamEndedPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MediaStreamEndedPropertyInfo = IsMediaStream
    type AttrSetTypeConstraint MediaStreamEndedPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MediaStreamEndedPropertyInfo = (~) ()
    type AttrTransferType MediaStreamEndedPropertyInfo = ()
    type AttrGetType MediaStreamEndedPropertyInfo = Bool
    type AttrLabel MediaStreamEndedPropertyInfo = "ended"
    type AttrOrigin MediaStreamEndedPropertyInfo = MediaStream
    attrGet = getMediaStreamEnded
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.ended"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#g:attr:ended"
        })
#endif

-- VVV Prop "error"
   -- Type: TError
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@error@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaStream #error
-- @
getMediaStreamError :: (MonadIO m, IsMediaStream o) => o -> m (Maybe GError)
getMediaStreamError obj = MIO.liftIO $ B.Properties.getObjectPropertyGError obj "error"

#if defined(ENABLE_OVERLOADING)
data MediaStreamErrorPropertyInfo
instance AttrInfo MediaStreamErrorPropertyInfo where
    type AttrAllowedOps MediaStreamErrorPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MediaStreamErrorPropertyInfo = IsMediaStream
    type AttrSetTypeConstraint MediaStreamErrorPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MediaStreamErrorPropertyInfo = (~) ()
    type AttrTransferType MediaStreamErrorPropertyInfo = ()
    type AttrGetType MediaStreamErrorPropertyInfo = (Maybe GError)
    type AttrLabel MediaStreamErrorPropertyInfo = "error"
    type AttrOrigin MediaStreamErrorPropertyInfo = MediaStream
    attrGet = getMediaStreamError
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.error"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#g:attr:error"
        })
#endif

-- VVV Prop "has-audio"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@has-audio@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaStream #hasAudio
-- @
getMediaStreamHasAudio :: (MonadIO m, IsMediaStream o) => o -> m Bool
getMediaStreamHasAudio obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-audio"

#if defined(ENABLE_OVERLOADING)
data MediaStreamHasAudioPropertyInfo
instance AttrInfo MediaStreamHasAudioPropertyInfo where
    type AttrAllowedOps MediaStreamHasAudioPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MediaStreamHasAudioPropertyInfo = IsMediaStream
    type AttrSetTypeConstraint MediaStreamHasAudioPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MediaStreamHasAudioPropertyInfo = (~) ()
    type AttrTransferType MediaStreamHasAudioPropertyInfo = ()
    type AttrGetType MediaStreamHasAudioPropertyInfo = Bool
    type AttrLabel MediaStreamHasAudioPropertyInfo = "has-audio"
    type AttrOrigin MediaStreamHasAudioPropertyInfo = MediaStream
    attrGet = getMediaStreamHasAudio
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.hasAudio"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#g:attr:hasAudio"
        })
#endif

-- VVV Prop "has-video"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@has-video@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaStream #hasVideo
-- @
getMediaStreamHasVideo :: (MonadIO m, IsMediaStream o) => o -> m Bool
getMediaStreamHasVideo obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-video"

#if defined(ENABLE_OVERLOADING)
data MediaStreamHasVideoPropertyInfo
instance AttrInfo MediaStreamHasVideoPropertyInfo where
    type AttrAllowedOps MediaStreamHasVideoPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MediaStreamHasVideoPropertyInfo = IsMediaStream
    type AttrSetTypeConstraint MediaStreamHasVideoPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MediaStreamHasVideoPropertyInfo = (~) ()
    type AttrTransferType MediaStreamHasVideoPropertyInfo = ()
    type AttrGetType MediaStreamHasVideoPropertyInfo = Bool
    type AttrLabel MediaStreamHasVideoPropertyInfo = "has-video"
    type AttrOrigin MediaStreamHasVideoPropertyInfo = MediaStream
    attrGet = getMediaStreamHasVideo
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.hasVideo"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#g:attr:hasVideo"
        })
#endif

-- VVV Prop "loop"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@loop@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaStream #loop
-- @
getMediaStreamLoop :: (MonadIO m, IsMediaStream o) => o -> m Bool
getMediaStreamLoop obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "loop"

-- | Set the value of the “@loop@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' mediaStream [ #loop 'Data.GI.Base.Attributes.:=' value ]
-- @
setMediaStreamLoop :: (MonadIO m, IsMediaStream o) => o -> Bool -> m ()
setMediaStreamLoop obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "loop" val

-- | Construct a t'GValueConstruct' with valid value for the “@loop@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMediaStreamLoop :: (IsMediaStream o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructMediaStreamLoop val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "loop" val

#if defined(ENABLE_OVERLOADING)
data MediaStreamLoopPropertyInfo
instance AttrInfo MediaStreamLoopPropertyInfo where
    type AttrAllowedOps MediaStreamLoopPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint MediaStreamLoopPropertyInfo = IsMediaStream
    type AttrSetTypeConstraint MediaStreamLoopPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint MediaStreamLoopPropertyInfo = (~) Bool
    type AttrTransferType MediaStreamLoopPropertyInfo = Bool
    type AttrGetType MediaStreamLoopPropertyInfo = Bool
    type AttrLabel MediaStreamLoopPropertyInfo = "loop"
    type AttrOrigin MediaStreamLoopPropertyInfo = MediaStream
    attrGet = getMediaStreamLoop
    attrSet = setMediaStreamLoop
    attrPut = setMediaStreamLoop
    attrTransfer _ v = do
        return v
    attrConstruct = constructMediaStreamLoop
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.loop"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#g:attr:loop"
        })
#endif

-- VVV Prop "muted"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@muted@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaStream #muted
-- @
getMediaStreamMuted :: (MonadIO m, IsMediaStream o) => o -> m Bool
getMediaStreamMuted obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "muted"

-- | Set the value of the “@muted@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' mediaStream [ #muted 'Data.GI.Base.Attributes.:=' value ]
-- @
setMediaStreamMuted :: (MonadIO m, IsMediaStream o) => o -> Bool -> m ()
setMediaStreamMuted obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "muted" val

-- | Construct a t'GValueConstruct' with valid value for the “@muted@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMediaStreamMuted :: (IsMediaStream o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructMediaStreamMuted val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "muted" val

#if defined(ENABLE_OVERLOADING)
data MediaStreamMutedPropertyInfo
instance AttrInfo MediaStreamMutedPropertyInfo where
    type AttrAllowedOps MediaStreamMutedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint MediaStreamMutedPropertyInfo = IsMediaStream
    type AttrSetTypeConstraint MediaStreamMutedPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint MediaStreamMutedPropertyInfo = (~) Bool
    type AttrTransferType MediaStreamMutedPropertyInfo = Bool
    type AttrGetType MediaStreamMutedPropertyInfo = Bool
    type AttrLabel MediaStreamMutedPropertyInfo = "muted"
    type AttrOrigin MediaStreamMutedPropertyInfo = MediaStream
    attrGet = getMediaStreamMuted
    attrSet = setMediaStreamMuted
    attrPut = setMediaStreamMuted
    attrTransfer _ v = do
        return v
    attrConstruct = constructMediaStreamMuted
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.muted"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#g:attr:muted"
        })
#endif

-- VVV Prop "playing"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@playing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaStream #playing
-- @
getMediaStreamPlaying :: (MonadIO m, IsMediaStream o) => o -> m Bool
getMediaStreamPlaying obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "playing"

-- | Set the value of the “@playing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' mediaStream [ #playing 'Data.GI.Base.Attributes.:=' value ]
-- @
setMediaStreamPlaying :: (MonadIO m, IsMediaStream o) => o -> Bool -> m ()
setMediaStreamPlaying obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "playing" val

-- | Construct a t'GValueConstruct' with valid value for the “@playing@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMediaStreamPlaying :: (IsMediaStream o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructMediaStreamPlaying val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "playing" val

#if defined(ENABLE_OVERLOADING)
data MediaStreamPlayingPropertyInfo
instance AttrInfo MediaStreamPlayingPropertyInfo where
    type AttrAllowedOps MediaStreamPlayingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint MediaStreamPlayingPropertyInfo = IsMediaStream
    type AttrSetTypeConstraint MediaStreamPlayingPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint MediaStreamPlayingPropertyInfo = (~) Bool
    type AttrTransferType MediaStreamPlayingPropertyInfo = Bool
    type AttrGetType MediaStreamPlayingPropertyInfo = Bool
    type AttrLabel MediaStreamPlayingPropertyInfo = "playing"
    type AttrOrigin MediaStreamPlayingPropertyInfo = MediaStream
    attrGet = getMediaStreamPlaying
    attrSet = setMediaStreamPlaying
    attrPut = setMediaStreamPlaying
    attrTransfer _ v = do
        return v
    attrConstruct = constructMediaStreamPlaying
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.playing"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#g:attr:playing"
        })
#endif

-- VVV Prop "prepared"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@prepared@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaStream #prepared
-- @
getMediaStreamPrepared :: (MonadIO m, IsMediaStream o) => o -> m Bool
getMediaStreamPrepared obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "prepared"

#if defined(ENABLE_OVERLOADING)
data MediaStreamPreparedPropertyInfo
instance AttrInfo MediaStreamPreparedPropertyInfo where
    type AttrAllowedOps MediaStreamPreparedPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MediaStreamPreparedPropertyInfo = IsMediaStream
    type AttrSetTypeConstraint MediaStreamPreparedPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MediaStreamPreparedPropertyInfo = (~) ()
    type AttrTransferType MediaStreamPreparedPropertyInfo = ()
    type AttrGetType MediaStreamPreparedPropertyInfo = Bool
    type AttrLabel MediaStreamPreparedPropertyInfo = "prepared"
    type AttrOrigin MediaStreamPreparedPropertyInfo = MediaStream
    attrGet = getMediaStreamPrepared
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.prepared"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#g:attr:prepared"
        })
#endif

-- VVV Prop "seekable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@seekable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaStream #seekable
-- @
getMediaStreamSeekable :: (MonadIO m, IsMediaStream o) => o -> m Bool
getMediaStreamSeekable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "seekable"

#if defined(ENABLE_OVERLOADING)
data MediaStreamSeekablePropertyInfo
instance AttrInfo MediaStreamSeekablePropertyInfo where
    type AttrAllowedOps MediaStreamSeekablePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MediaStreamSeekablePropertyInfo = IsMediaStream
    type AttrSetTypeConstraint MediaStreamSeekablePropertyInfo = (~) ()
    type AttrTransferTypeConstraint MediaStreamSeekablePropertyInfo = (~) ()
    type AttrTransferType MediaStreamSeekablePropertyInfo = ()
    type AttrGetType MediaStreamSeekablePropertyInfo = Bool
    type AttrLabel MediaStreamSeekablePropertyInfo = "seekable"
    type AttrOrigin MediaStreamSeekablePropertyInfo = MediaStream
    attrGet = getMediaStreamSeekable
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.seekable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#g:attr:seekable"
        })
#endif

-- VVV Prop "seeking"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@seeking@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaStream #seeking
-- @
getMediaStreamSeeking :: (MonadIO m, IsMediaStream o) => o -> m Bool
getMediaStreamSeeking obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "seeking"

#if defined(ENABLE_OVERLOADING)
data MediaStreamSeekingPropertyInfo
instance AttrInfo MediaStreamSeekingPropertyInfo where
    type AttrAllowedOps MediaStreamSeekingPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MediaStreamSeekingPropertyInfo = IsMediaStream
    type AttrSetTypeConstraint MediaStreamSeekingPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MediaStreamSeekingPropertyInfo = (~) ()
    type AttrTransferType MediaStreamSeekingPropertyInfo = ()
    type AttrGetType MediaStreamSeekingPropertyInfo = Bool
    type AttrLabel MediaStreamSeekingPropertyInfo = "seeking"
    type AttrOrigin MediaStreamSeekingPropertyInfo = MediaStream
    attrGet = getMediaStreamSeeking
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.seeking"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#g:attr:seeking"
        })
#endif

-- VVV Prop "timestamp"
   -- Type: TBasicType TInt64
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@timestamp@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaStream #timestamp
-- @
getMediaStreamTimestamp :: (MonadIO m, IsMediaStream o) => o -> m Int64
getMediaStreamTimestamp obj = MIO.liftIO $ B.Properties.getObjectPropertyInt64 obj "timestamp"

#if defined(ENABLE_OVERLOADING)
data MediaStreamTimestampPropertyInfo
instance AttrInfo MediaStreamTimestampPropertyInfo where
    type AttrAllowedOps MediaStreamTimestampPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MediaStreamTimestampPropertyInfo = IsMediaStream
    type AttrSetTypeConstraint MediaStreamTimestampPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MediaStreamTimestampPropertyInfo = (~) ()
    type AttrTransferType MediaStreamTimestampPropertyInfo = ()
    type AttrGetType MediaStreamTimestampPropertyInfo = Int64
    type AttrLabel MediaStreamTimestampPropertyInfo = "timestamp"
    type AttrOrigin MediaStreamTimestampPropertyInfo = MediaStream
    attrGet = getMediaStreamTimestamp
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.timestamp"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#g:attr:timestamp"
        })
#endif

-- VVV Prop "volume"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@volume@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaStream #volume
-- @
getMediaStreamVolume :: (MonadIO m, IsMediaStream o) => o -> m Double
getMediaStreamVolume obj = MIO.liftIO $ B.Properties.getObjectPropertyDouble obj "volume"

-- | Set the value of the “@volume@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' mediaStream [ #volume 'Data.GI.Base.Attributes.:=' value ]
-- @
setMediaStreamVolume :: (MonadIO m, IsMediaStream o) => o -> Double -> m ()
setMediaStreamVolume obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyDouble obj "volume" val

-- | Construct a t'GValueConstruct' with valid value for the “@volume@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMediaStreamVolume :: (IsMediaStream o, MIO.MonadIO m) => Double -> m (GValueConstruct o)
constructMediaStreamVolume val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyDouble "volume" val

#if defined(ENABLE_OVERLOADING)
data MediaStreamVolumePropertyInfo
instance AttrInfo MediaStreamVolumePropertyInfo where
    type AttrAllowedOps MediaStreamVolumePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint MediaStreamVolumePropertyInfo = IsMediaStream
    type AttrSetTypeConstraint MediaStreamVolumePropertyInfo = (~) Double
    type AttrTransferTypeConstraint MediaStreamVolumePropertyInfo = (~) Double
    type AttrTransferType MediaStreamVolumePropertyInfo = Double
    type AttrGetType MediaStreamVolumePropertyInfo = Double
    type AttrLabel MediaStreamVolumePropertyInfo = "volume"
    type AttrOrigin MediaStreamVolumePropertyInfo = MediaStream
    attrGet = getMediaStreamVolume
    attrSet = setMediaStreamVolume
    attrPut = setMediaStreamVolume
    attrTransfer _ v = do
        return v
    attrConstruct = constructMediaStreamVolume
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.volume"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#g:attr:volume"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MediaStream
type instance O.AttributeList MediaStream = MediaStreamAttributeList
type MediaStreamAttributeList = ('[ '("duration", MediaStreamDurationPropertyInfo), '("ended", MediaStreamEndedPropertyInfo), '("error", MediaStreamErrorPropertyInfo), '("hasAudio", MediaStreamHasAudioPropertyInfo), '("hasVideo", MediaStreamHasVideoPropertyInfo), '("loop", MediaStreamLoopPropertyInfo), '("muted", MediaStreamMutedPropertyInfo), '("playing", MediaStreamPlayingPropertyInfo), '("prepared", MediaStreamPreparedPropertyInfo), '("seekable", MediaStreamSeekablePropertyInfo), '("seeking", MediaStreamSeekingPropertyInfo), '("timestamp", MediaStreamTimestampPropertyInfo), '("volume", MediaStreamVolumePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
mediaStreamDuration :: AttrLabelProxy "duration"
mediaStreamDuration = AttrLabelProxy

mediaStreamEnded :: AttrLabelProxy "ended"
mediaStreamEnded = AttrLabelProxy

mediaStreamError :: AttrLabelProxy "error"
mediaStreamError = AttrLabelProxy

mediaStreamLoop :: AttrLabelProxy "loop"
mediaStreamLoop = AttrLabelProxy

mediaStreamMuted :: AttrLabelProxy "muted"
mediaStreamMuted = AttrLabelProxy

mediaStreamPlaying :: AttrLabelProxy "playing"
mediaStreamPlaying = AttrLabelProxy

mediaStreamPrepared :: AttrLabelProxy "prepared"
mediaStreamPrepared = AttrLabelProxy

mediaStreamSeekable :: AttrLabelProxy "seekable"
mediaStreamSeekable = AttrLabelProxy

mediaStreamSeeking :: AttrLabelProxy "seeking"
mediaStreamSeeking = AttrLabelProxy

mediaStreamTimestamp :: AttrLabelProxy "timestamp"
mediaStreamTimestamp = AttrLabelProxy

mediaStreamVolume :: AttrLabelProxy "volume"
mediaStreamVolume = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MediaStream = MediaStreamSignalList
type MediaStreamSignalList = ('[ '("invalidateContents", Gdk.Paintable.PaintableInvalidateContentsSignalInfo), '("invalidateSize", Gdk.Paintable.PaintableInvalidateSizeSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MediaStream::gerror
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GError` to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_gerror" gtk_media_stream_gerror :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    Ptr GError ->                           -- error : TError
    IO ()

-- | Sets /@self@/ into an error state.
-- 
-- This will pause the stream (you can check for an error
-- via 'GI.Gtk.Objects.MediaStream.mediaStreamGetError' in your
-- GtkMediaStream.@/pause()/@ implementation), abort pending
-- seeks and mark the stream as prepared.
-- 
-- if the stream is already in an error state, this call
-- will be ignored and the existing error will be retained.
-- 
-- To unset an error, the stream must be reset via a call to
-- t'GI.Gtk.Objects.MediaStream.MediaStream'.@/unprepared/@().
mediaStreamGerror ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> GError
    -- ^ /@error@/: the @GError@ to set
    -> m ()
mediaStreamGerror self error_ = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    error_' <- B.ManagedPtr.disownBoxed error_
    gtk_media_stream_gerror self' error_'
    touchManagedPtr self
    touchManagedPtr error_
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamGerrorMethodInfo
instance (signature ~ (GError -> m ()), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamGerrorMethodInfo a signature where
    overloadedMethod = mediaStreamGerror

instance O.OverloadedMethodInfo MediaStreamGerrorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamGerror",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamGerror"
        })


#endif

-- method MediaStream::get_duration
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_get_duration" gtk_media_stream_get_duration :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO Int64

-- | Gets the duration of the stream.
-- 
-- If the duration is not known, 0 will be returned.
mediaStreamGetDuration ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m Int64
    -- ^ __Returns:__ the duration of the stream or 0 if not known.
mediaStreamGetDuration self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_stream_get_duration self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data MediaStreamGetDurationMethodInfo
instance (signature ~ (m Int64), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamGetDurationMethodInfo a signature where
    overloadedMethod = mediaStreamGetDuration

instance O.OverloadedMethodInfo MediaStreamGetDurationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamGetDuration",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamGetDuration"
        })


#endif

-- method MediaStream::get_ended
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_get_ended" gtk_media_stream_get_ended :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO CInt

-- | Returns whether the streams playback is finished.
mediaStreamGetEnded ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if playback is finished
mediaStreamGetEnded self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_stream_get_ended self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data MediaStreamGetEndedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamGetEndedMethodInfo a signature where
    overloadedMethod = mediaStreamGetEnded

instance O.OverloadedMethodInfo MediaStreamGetEndedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamGetEnded",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamGetEnded"
        })


#endif

-- method MediaStream::get_error
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TError
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_get_error" gtk_media_stream_get_error :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO (Ptr GError)

-- | If the stream is in an error state, returns the @GError@
-- explaining that state.
-- 
-- Any type of error can be reported here depending on the
-- implementation of the media stream.
-- 
-- A media stream in an error cannot be operated on, calls
-- like 'GI.Gtk.Objects.MediaStream.mediaStreamPlay' or
-- 'GI.Gtk.Objects.MediaStream.mediaStreamSeek' will not have any effect.
-- 
-- @GtkMediaStream@ itself does not provide a way to unset
-- an error, but implementations may provide options. For example,
-- a t'GI.Gtk.Objects.MediaFile.MediaFile' will unset errors when a new source is
-- set, e.g. with 'GI.Gtk.Objects.MediaFile.mediaFileSetFile'.
mediaStreamGetError ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m (Maybe GError)
    -- ^ __Returns:__ 'P.Nothing' if not in an
    --   error state or the @GError@ of the stream
mediaStreamGetError self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_stream_get_error self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed GError) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MediaStreamGetErrorMethodInfo
instance (signature ~ (m (Maybe GError)), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamGetErrorMethodInfo a signature where
    overloadedMethod = mediaStreamGetError

instance O.OverloadedMethodInfo MediaStreamGetErrorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamGetError",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamGetError"
        })


#endif

-- method MediaStream::get_loop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_get_loop" gtk_media_stream_get_loop :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO CInt

-- | Returns whether the stream is set to loop.
-- 
-- See 'GI.Gtk.Objects.MediaStream.mediaStreamSetLoop' for details.
mediaStreamGetLoop ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the stream should loop
mediaStreamGetLoop self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_stream_get_loop self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data MediaStreamGetLoopMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamGetLoopMethodInfo a signature where
    overloadedMethod = mediaStreamGetLoop

instance O.OverloadedMethodInfo MediaStreamGetLoopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamGetLoop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamGetLoop"
        })


#endif

-- method MediaStream::get_muted
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_get_muted" gtk_media_stream_get_muted :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO CInt

-- | Returns whether the audio for the stream is muted.
-- 
-- See 'GI.Gtk.Objects.MediaStream.mediaStreamSetMuted' for details.
mediaStreamGetMuted ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the stream is muted
mediaStreamGetMuted self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_stream_get_muted self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data MediaStreamGetMutedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamGetMutedMethodInfo a signature where
    overloadedMethod = mediaStreamGetMuted

instance O.OverloadedMethodInfo MediaStreamGetMutedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamGetMuted",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamGetMuted"
        })


#endif

-- method MediaStream::get_playing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_get_playing" gtk_media_stream_get_playing :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO CInt

-- | Return whether the stream is currently playing.
mediaStreamGetPlaying ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the stream is playing
mediaStreamGetPlaying self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_stream_get_playing self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data MediaStreamGetPlayingMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamGetPlayingMethodInfo a signature where
    overloadedMethod = mediaStreamGetPlaying

instance O.OverloadedMethodInfo MediaStreamGetPlayingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamGetPlaying",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamGetPlaying"
        })


#endif

-- method MediaStream::get_timestamp
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_get_timestamp" gtk_media_stream_get_timestamp :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO Int64

-- | Returns the current presentation timestamp in microseconds.
mediaStreamGetTimestamp ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m Int64
    -- ^ __Returns:__ the timestamp in microseconds
mediaStreamGetTimestamp self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_stream_get_timestamp self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data MediaStreamGetTimestampMethodInfo
instance (signature ~ (m Int64), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamGetTimestampMethodInfo a signature where
    overloadedMethod = mediaStreamGetTimestamp

instance O.OverloadedMethodInfo MediaStreamGetTimestampMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamGetTimestamp",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamGetTimestamp"
        })


#endif

-- method MediaStream::get_volume
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_get_volume" gtk_media_stream_get_volume :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO CDouble

-- | Returns the volume of the audio for the stream.
-- 
-- See 'GI.Gtk.Objects.MediaStream.mediaStreamSetVolume' for details.
mediaStreamGetVolume ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m Double
    -- ^ __Returns:__ volume of the stream from 0.0 to 1.0
mediaStreamGetVolume self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_stream_get_volume self'
    let result' = realToFrac result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data MediaStreamGetVolumeMethodInfo
instance (signature ~ (m Double), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamGetVolumeMethodInfo a signature where
    overloadedMethod = mediaStreamGetVolume

instance O.OverloadedMethodInfo MediaStreamGetVolumeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamGetVolume",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamGetVolume"
        })


#endif

-- method MediaStream::has_audio
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_has_audio" gtk_media_stream_has_audio :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO CInt

-- | Returns whether the stream has audio.
mediaStreamHasAudio ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the stream has audio
mediaStreamHasAudio self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_stream_has_audio self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data MediaStreamHasAudioMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamHasAudioMethodInfo a signature where
    overloadedMethod = mediaStreamHasAudio

instance O.OverloadedMethodInfo MediaStreamHasAudioMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamHasAudio",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamHasAudio"
        })


#endif

-- method MediaStream::has_video
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_has_video" gtk_media_stream_has_video :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO CInt

-- | Returns whether the stream has video.
mediaStreamHasVideo ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the stream has video
mediaStreamHasVideo self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_stream_has_video self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data MediaStreamHasVideoMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamHasVideoMethodInfo a signature where
    overloadedMethod = mediaStreamHasVideo

instance O.OverloadedMethodInfo MediaStreamHasVideoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamHasVideo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamHasVideo"
        })


#endif

-- method MediaStream::is_prepared
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_is_prepared" gtk_media_stream_is_prepared :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO CInt

-- | Returns whether the stream has finished initializing.
-- 
-- At this point the existence of audio and video is known.
mediaStreamIsPrepared ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the stream is prepared
mediaStreamIsPrepared self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_stream_is_prepared self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data MediaStreamIsPreparedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamIsPreparedMethodInfo a signature where
    overloadedMethod = mediaStreamIsPrepared

instance O.OverloadedMethodInfo MediaStreamIsPreparedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamIsPrepared",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamIsPrepared"
        })


#endif

-- method MediaStream::is_seekable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_is_seekable" gtk_media_stream_is_seekable :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO CInt

-- | Checks if a stream may be seekable.
-- 
-- This is meant to be a hint. Streams may not allow seeking even if
-- this function returns 'P.True'. However, if this function returns
-- 'P.False', streams are guaranteed to not be seekable and user interfaces
-- may hide controls that allow seeking.
-- 
-- It is allowed to call 'GI.Gtk.Objects.MediaStream.mediaStreamSeek' on a non-seekable
-- stream, though it will not do anything.
mediaStreamIsSeekable ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the stream may support seeking
mediaStreamIsSeekable self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_stream_is_seekable self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data MediaStreamIsSeekableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamIsSeekableMethodInfo a signature where
    overloadedMethod = mediaStreamIsSeekable

instance O.OverloadedMethodInfo MediaStreamIsSeekableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamIsSeekable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamIsSeekable"
        })


#endif

-- method MediaStream::is_seeking
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_is_seeking" gtk_media_stream_is_seeking :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO CInt

-- | Checks if there is currently a seek operation going on.
mediaStreamIsSeeking ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if a seek operation is ongoing.
mediaStreamIsSeeking self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_media_stream_is_seeking self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data MediaStreamIsSeekingMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamIsSeekingMethodInfo a signature where
    overloadedMethod = mediaStreamIsSeeking

instance O.OverloadedMethodInfo MediaStreamIsSeekingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamIsSeeking",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamIsSeeking"
        })


#endif

-- method MediaStream::pause
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_pause" gtk_media_stream_pause :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO ()

-- | Pauses playback of the stream.
-- 
-- If the stream is not playing, do nothing.
mediaStreamPause ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m ()
mediaStreamPause self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_media_stream_pause self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamPauseMethodInfo
instance (signature ~ (m ()), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamPauseMethodInfo a signature where
    overloadedMethod = mediaStreamPause

instance O.OverloadedMethodInfo MediaStreamPauseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamPause",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamPause"
        })


#endif

-- method MediaStream::play
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_play" gtk_media_stream_play :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO ()

-- | Starts playing the stream.
-- 
-- If the stream is in error or already playing, do nothing.
mediaStreamPlay ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m ()
mediaStreamPlay self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_media_stream_play self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamPlayMethodInfo
instance (signature ~ (m ()), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamPlayMethodInfo a signature where
    overloadedMethod = mediaStreamPlay

instance O.OverloadedMethodInfo MediaStreamPlayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamPlay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamPlay"
        })


#endif

-- method MediaStream::realize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "surface"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Surface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkSurface`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_realize" gtk_media_stream_realize :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    Ptr Gdk.Surface.Surface ->              -- surface : TInterface (Name {namespace = "Gdk", name = "Surface"})
    IO ()

-- | Called by users to attach the media stream to a @GdkSurface@ they manage.
-- 
-- The stream can then access the resources of /@surface@/ for its
-- rendering purposes. In particular, media streams might want to
-- create a @GdkGLContext@ or sync to the @GdkFrameClock@.
-- 
-- Whoever calls this function is responsible for calling
-- 'GI.Gtk.Objects.MediaStream.mediaStreamUnrealize' before either the stream
-- or /@surface@/ get destroyed.
-- 
-- Multiple calls to this function may happen from different
-- users of the video, even with the same /@surface@/. Each of these
-- calls must be followed by its own call to
-- 'GI.Gtk.Objects.MediaStream.mediaStreamUnrealize'.
-- 
-- It is not required to call this function to make a media stream work.
mediaStreamRealize ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a, Gdk.Surface.IsSurface b) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> b
    -- ^ /@surface@/: a @GdkSurface@
    -> m ()
mediaStreamRealize self surface = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    surface' <- unsafeManagedPtrCastPtr surface
    gtk_media_stream_realize self' surface'
    touchManagedPtr self
    touchManagedPtr surface
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamRealizeMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsMediaStream a, Gdk.Surface.IsSurface b) => O.OverloadedMethod MediaStreamRealizeMethodInfo a signature where
    overloadedMethod = mediaStreamRealize

instance O.OverloadedMethodInfo MediaStreamRealizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamRealize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamRealize"
        })


#endif

-- method MediaStream::seek
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "timestamp to seek to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_seek" gtk_media_stream_seek :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    Int64 ->                                -- timestamp : TBasicType TInt64
    IO ()

-- | Start a seek operation on /@self@/ to /@timestamp@/.
-- 
-- If /@timestamp@/ is out of range, it will be clamped.
-- 
-- Seek operations may not finish instantly. While a
-- seek operation is in process, the [MediaStream:seeking]("GI.Gtk.Objects.MediaStream#g:attr:seeking")
-- property will be set.
-- 
-- When calling 'GI.Gtk.Objects.MediaStream.mediaStreamSeek' during an
-- ongoing seek operation, the new seek will override
-- any pending seek.
mediaStreamSeek ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> Int64
    -- ^ /@timestamp@/: timestamp to seek to.
    -> m ()
mediaStreamSeek self timestamp = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_media_stream_seek self' timestamp
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamSeekMethodInfo
instance (signature ~ (Int64 -> m ()), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamSeekMethodInfo a signature where
    overloadedMethod = mediaStreamSeek

instance O.OverloadedMethodInfo MediaStreamSeekMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamSeek",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamSeek"
        })


#endif

-- method MediaStream::seek_failed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_seek_failed" gtk_media_stream_seek_failed :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO ()

-- | Ends a seek operation started via GtkMediaStream.@/seek()/@ as a failure.
-- 
-- This will not cause an error on the stream and will assume that
-- playback continues as if no seek had happened.
-- 
-- See 'GI.Gtk.Objects.MediaStream.mediaStreamSeekSuccess' for the other way of
-- ending a seek.
mediaStreamSeekFailed ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m ()
mediaStreamSeekFailed self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_media_stream_seek_failed self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamSeekFailedMethodInfo
instance (signature ~ (m ()), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamSeekFailedMethodInfo a signature where
    overloadedMethod = mediaStreamSeekFailed

instance O.OverloadedMethodInfo MediaStreamSeekFailedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamSeekFailed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamSeekFailed"
        })


#endif

-- method MediaStream::seek_success
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_seek_success" gtk_media_stream_seek_success :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO ()

-- | Ends a seek operation started via GtkMediaStream.@/seek()/@ successfully.
-- 
-- This function will unset the GtkMediaStream:ended property
-- if it was set.
-- 
-- See 'GI.Gtk.Objects.MediaStream.mediaStreamSeekFailed' for the other way of
-- ending a seek.
mediaStreamSeekSuccess ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m ()
mediaStreamSeekSuccess self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_media_stream_seek_success self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamSeekSuccessMethodInfo
instance (signature ~ (m ()), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamSeekSuccessMethodInfo a signature where
    overloadedMethod = mediaStreamSeekSuccess

instance O.OverloadedMethodInfo MediaStreamSeekSuccessMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamSeekSuccess",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamSeekSuccess"
        })


#endif

-- method MediaStream::set_loop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "loop"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if the stream should loop"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_set_loop" gtk_media_stream_set_loop :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    CInt ->                                 -- loop : TBasicType TBoolean
    IO ()

-- | Sets whether the stream should loop.
-- 
-- In this case, it will attempt to restart playback
-- from the beginning instead of stopping at the end.
-- 
-- Not all streams may support looping, in particular
-- non-seekable streams. Those streams will ignore the
-- loop setting and just end.
mediaStreamSetLoop ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> Bool
    -- ^ /@loop@/: 'P.True' if the stream should loop
    -> m ()
mediaStreamSetLoop self loop = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let loop' = (P.fromIntegral . P.fromEnum) loop
    gtk_media_stream_set_loop self' loop'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamSetLoopMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamSetLoopMethodInfo a signature where
    overloadedMethod = mediaStreamSetLoop

instance O.OverloadedMethodInfo MediaStreamSetLoopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamSetLoop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamSetLoop"
        })


#endif

-- method MediaStream::set_muted
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "muted"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if the stream should be muted"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_set_muted" gtk_media_stream_set_muted :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    CInt ->                                 -- muted : TBasicType TBoolean
    IO ()

-- | Sets whether the audio stream should be muted.
-- 
-- Muting a stream will cause no audio to be played, but it
-- does not modify the volume. This means that muting and
-- then unmuting the stream will restore the volume settings.
-- 
-- If the stream has no audio, calling this function will
-- still work but it will not have an audible effect.
mediaStreamSetMuted ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> Bool
    -- ^ /@muted@/: 'P.True' if the stream should be muted
    -> m ()
mediaStreamSetMuted self muted = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let muted' = (P.fromIntegral . P.fromEnum) muted
    gtk_media_stream_set_muted self' muted'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamSetMutedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamSetMutedMethodInfo a signature where
    overloadedMethod = mediaStreamSetMuted

instance O.OverloadedMethodInfo MediaStreamSetMutedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamSetMuted",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamSetMuted"
        })


#endif

-- method MediaStream::set_playing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "playing"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to start or pause playback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_set_playing" gtk_media_stream_set_playing :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    CInt ->                                 -- playing : TBasicType TBoolean
    IO ()

-- | Starts or pauses playback of the stream.
mediaStreamSetPlaying ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> Bool
    -- ^ /@playing@/: whether to start or pause playback
    -> m ()
mediaStreamSetPlaying self playing = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let playing' = (P.fromIntegral . P.fromEnum) playing
    gtk_media_stream_set_playing self' playing'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamSetPlayingMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamSetPlayingMethodInfo a signature where
    overloadedMethod = mediaStreamSetPlaying

instance O.OverloadedMethodInfo MediaStreamSetPlayingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamSetPlaying",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamSetPlaying"
        })


#endif

-- method MediaStream::set_volume
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "volume"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "New volume of the stream from 0.0 to 1.0"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_set_volume" gtk_media_stream_set_volume :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    CDouble ->                              -- volume : TBasicType TDouble
    IO ()

-- | Sets the volume of the audio stream.
-- 
-- This function call will work even if the stream is muted.
-- 
-- The given /@volume@/ should range from 0.0 for silence to 1.0
-- for as loud as possible. Values outside of this range will
-- be clamped to the nearest value.
-- 
-- If the stream has no audio or is muted, calling this function
-- will still work but it will not have an immediate audible effect.
-- When the stream is unmuted, the new volume setting will take effect.
mediaStreamSetVolume ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> Double
    -- ^ /@volume@/: New volume of the stream from 0.0 to 1.0
    -> m ()
mediaStreamSetVolume self volume = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let volume' = realToFrac volume
    gtk_media_stream_set_volume self' volume'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamSetVolumeMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamSetVolumeMethodInfo a signature where
    overloadedMethod = mediaStreamSetVolume

instance O.OverloadedMethodInfo MediaStreamSetVolumeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamSetVolume",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamSetVolume"
        })


#endif

-- method MediaStream::stream_ended
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_stream_ended" gtk_media_stream_stream_ended :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO ()

-- | Pauses the media stream and marks it as ended.
-- 
-- This is a hint only, calls to 'GI.Gtk.Objects.MediaStream.mediaStreamPlay'
-- may still happen.
-- 
-- The media stream must be prepared when this function is called.
-- 
-- /Since: 4.4/
mediaStreamStreamEnded ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m ()
mediaStreamStreamEnded self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_media_stream_stream_ended self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamStreamEndedMethodInfo
instance (signature ~ (m ()), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamStreamEndedMethodInfo a signature where
    overloadedMethod = mediaStreamStreamEnded

instance O.OverloadedMethodInfo MediaStreamStreamEndedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamStreamEnded",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamStreamEnded"
        })


#endif

-- method MediaStream::stream_prepared
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "has_audio"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if the stream should advertise audio support"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "has_video"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if the stream should advertise video support"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "seekable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if the stream should advertise seekability"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "duration"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The duration of the stream or 0 if unknown"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_stream_prepared" gtk_media_stream_stream_prepared :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    CInt ->                                 -- has_audio : TBasicType TBoolean
    CInt ->                                 -- has_video : TBasicType TBoolean
    CInt ->                                 -- seekable : TBasicType TBoolean
    Int64 ->                                -- duration : TBasicType TInt64
    IO ()

-- | Called by @GtkMediaStream@ implementations to advertise the stream
-- being ready to play and providing details about the stream.
-- 
-- Note that the arguments are hints. If the stream implementation
-- cannot determine the correct values, it is better to err on the
-- side of caution and return 'P.True'. User interfaces will use those
-- values to determine what controls to show.
-- 
-- This function may not be called again until the stream has been
-- reset via 'GI.Gtk.Objects.MediaStream.mediaStreamStreamUnprepared'.
-- 
-- /Since: 4.4/
mediaStreamStreamPrepared ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> Bool
    -- ^ /@hasAudio@/: 'P.True' if the stream should advertise audio support
    -> Bool
    -- ^ /@hasVideo@/: 'P.True' if the stream should advertise video support
    -> Bool
    -- ^ /@seekable@/: 'P.True' if the stream should advertise seekability
    -> Int64
    -- ^ /@duration@/: The duration of the stream or 0 if unknown
    -> m ()
mediaStreamStreamPrepared self hasAudio hasVideo seekable duration = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let hasAudio' = (P.fromIntegral . P.fromEnum) hasAudio
    let hasVideo' = (P.fromIntegral . P.fromEnum) hasVideo
    let seekable' = (P.fromIntegral . P.fromEnum) seekable
    gtk_media_stream_stream_prepared self' hasAudio' hasVideo' seekable' duration
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamStreamPreparedMethodInfo
instance (signature ~ (Bool -> Bool -> Bool -> Int64 -> m ()), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamStreamPreparedMethodInfo a signature where
    overloadedMethod = mediaStreamStreamPrepared

instance O.OverloadedMethodInfo MediaStreamStreamPreparedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamStreamPrepared",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamStreamPrepared"
        })


#endif

-- method MediaStream::stream_unprepared
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_stream_unprepared" gtk_media_stream_stream_unprepared :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO ()

-- | Resets a given media stream implementation.
-- 
-- 'GI.Gtk.Objects.MediaStream.mediaStreamStreamPrepared' can then be called again.
-- 
-- This function will also reset any error state the stream was in.
-- 
-- /Since: 4.4/
mediaStreamStreamUnprepared ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> m ()
mediaStreamStreamUnprepared self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_media_stream_stream_unprepared self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamStreamUnpreparedMethodInfo
instance (signature ~ (m ()), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamStreamUnpreparedMethodInfo a signature where
    overloadedMethod = mediaStreamStreamUnprepared

instance O.OverloadedMethodInfo MediaStreamStreamUnpreparedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamStreamUnprepared",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamStreamUnprepared"
        })


#endif

-- method MediaStream::unrealize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream` previously realized"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "surface"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Surface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GdkSurface` the stream was realized with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_unrealize" gtk_media_stream_unrealize :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    Ptr Gdk.Surface.Surface ->              -- surface : TInterface (Name {namespace = "Gdk", name = "Surface"})
    IO ()

-- | Undoes a previous call to 'GI.Gtk.Objects.MediaStream.mediaStreamRealize'.
-- 
-- This causes the stream to release all resources it had
-- allocated from /@surface@/.
mediaStreamUnrealize ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a, Gdk.Surface.IsSurface b) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@ previously realized
    -> b
    -- ^ /@surface@/: the @GdkSurface@ the stream was realized with
    -> m ()
mediaStreamUnrealize self surface = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    surface' <- unsafeManagedPtrCastPtr surface
    gtk_media_stream_unrealize self' surface'
    touchManagedPtr self
    touchManagedPtr surface
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamUnrealizeMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsMediaStream a, Gdk.Surface.IsSurface b) => O.OverloadedMethod MediaStreamUnrealizeMethodInfo a signature where
    overloadedMethod = mediaStreamUnrealize

instance O.OverloadedMethodInfo MediaStreamUnrealizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamUnrealize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamUnrealize"
        })


#endif

-- method MediaStream::update
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new timestamp" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_stream_update" gtk_media_stream_update :: 
    Ptr MediaStream ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    Int64 ->                                -- timestamp : TBasicType TInt64
    IO ()

-- | Media stream implementations should regularly call this
-- function to update the timestamp reported by the stream.
-- 
-- It is up to implementations to call this at the frequency
-- they deem appropriate.
-- 
-- The media stream must be prepared when this function is called.
mediaStreamUpdate ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaStream a) =>
    a
    -- ^ /@self@/: a @GtkMediaStream@
    -> Int64
    -- ^ /@timestamp@/: the new timestamp
    -> m ()
mediaStreamUpdate self timestamp = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_media_stream_update self' timestamp
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaStreamUpdateMethodInfo
instance (signature ~ (Int64 -> m ()), MonadIO m, IsMediaStream a) => O.OverloadedMethod MediaStreamUpdateMethodInfo a signature where
    overloadedMethod = mediaStreamUpdate

instance O.OverloadedMethodInfo MediaStreamUpdateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaStream.mediaStreamUpdate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MediaStream.html#v:mediaStreamUpdate"
        })


#endif


