{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GtkAssistant@ is used to represent a complex as a series of steps.
-- 
-- \<picture>
--   \<source srcset=\"assistant-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkAssistant\" src=\"assistant.png\">
-- \<\/picture>
-- 
-- Each step consists of one or more pages. @GtkAssistant@ guides the user
-- through the pages, and controls the page flow to collect the data needed
-- for the operation.
-- 
-- @GtkAssistant@ handles which buttons to show and to make sensitive based
-- on page sequence knowledge and the t'GI.Gtk.Enums.AssistantPageType' of each
-- page in addition to state information like the *completed* and *committed*
-- page statuses.
-- 
-- If you have a case that doesn’t quite fit in @GtkAssistant@s way of
-- handling buttons, you can use the 'GI.Gtk.Enums.AssistantPageTypeCustom' page
-- type and handle buttons yourself.
-- 
-- @GtkAssistant@ maintains a @GtkAssistantPage@ object for each added
-- child, which holds additional per-child properties. You
-- obtain the @GtkAssistantPage@ for a child with 'GI.Gtk.Objects.Assistant.assistantGetPage'.
-- 
-- = GtkAssistant as GtkBuildable
-- 
-- The @GtkAssistant@ implementation of the @GtkBuildable@ interface
-- exposes the /@actionArea@/ as internal children with the name
-- “action_area”.
-- 
-- To add pages to an assistant in @GtkBuilder@, simply add it as a
-- child to the @GtkAssistant@ object. If you need to set per-object
-- properties, create a @GtkAssistantPage@ object explicitly, and
-- set the child widget as a property on it.
-- 
-- = CSS nodes
-- 
-- @GtkAssistant@ has a single CSS node with the name window and style
-- class .assistant.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Assistant
    ( 

-- * Exported types
    Assistant(..)                           ,
    IsAssistant                             ,
    toAssistant                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addActionWidget]("GI.Gtk.Objects.Assistant#g:method:addActionWidget"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [appendPage]("GI.Gtk.Objects.Assistant#g:method:appendPage"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [close]("GI.Gtk.Objects.Window#g:method:close"), [commit]("GI.Gtk.Objects.Assistant#g:method:commit"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [destroy]("GI.Gtk.Objects.Window#g:method:destroy"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [fullscreen]("GI.Gtk.Objects.Window#g:method:fullscreen"), [fullscreenOnMonitor]("GI.Gtk.Objects.Window#g:method:fullscreenOnMonitor"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasGroup]("GI.Gtk.Objects.Window#g:method:hasGroup"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [insertPage]("GI.Gtk.Objects.Assistant#g:method:insertPage"), [isActive]("GI.Gtk.Objects.Window#g:method:isActive"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isFullscreen]("GI.Gtk.Objects.Window#g:method:isFullscreen"), [isMaximized]("GI.Gtk.Objects.Window#g:method:isMaximized"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isSuspended]("GI.Gtk.Objects.Window#g:method:isSuspended"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [maximize]("GI.Gtk.Objects.Window#g:method:maximize"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [minimize]("GI.Gtk.Objects.Window#g:method:minimize"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [nextPage]("GI.Gtk.Objects.Assistant#g:method:nextPage"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [prependPage]("GI.Gtk.Objects.Assistant#g:method:prependPage"), [present]("GI.Gtk.Objects.Window#g:method:present"), [presentWithTime]("GI.Gtk.Objects.Window#g:method:presentWithTime"), [previousPage]("GI.Gtk.Objects.Assistant#g:method:previousPage"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeActionWidget]("GI.Gtk.Objects.Assistant#g:method:removeActionWidget"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removePage]("GI.Gtk.Objects.Assistant#g:method:removePage"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unfullscreen]("GI.Gtk.Objects.Window#g:method:unfullscreen"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unmaximize]("GI.Gtk.Objects.Window#g:method:unmaximize"), [unminimize]("GI.Gtk.Objects.Window#g:method:unminimize"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateButtonsState]("GI.Gtk.Objects.Assistant#g:method:updateButtonsState"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getApplication]("GI.Gtk.Objects.Window#g:method:getApplication"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.Window#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCurrentPage]("GI.Gtk.Objects.Assistant#g:method:getCurrentPage"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDecorated]("GI.Gtk.Objects.Window#g:method:getDecorated"), [getDefaultSize]("GI.Gtk.Objects.Window#g:method:getDefaultSize"), [getDefaultWidget]("GI.Gtk.Objects.Window#g:method:getDefaultWidget"), [getDeletable]("GI.Gtk.Objects.Window#g:method:getDeletable"), [getDestroyWithParent]("GI.Gtk.Objects.Window#g:method:getDestroyWithParent"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocus]("GI.Gtk.Objects.Window#g:method:getFocus"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusVisible]("GI.Gtk.Objects.Window#g:method:getFocusVisible"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getGravity]("GI.Gtk.Objects.Window#g:method:getGravity"), [getGroup]("GI.Gtk.Objects.Window#g:method:getGroup"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHandleMenubarAccel]("GI.Gtk.Objects.Window#g:method:getHandleMenubarAccel"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHideOnClose]("GI.Gtk.Objects.Window#g:method:getHideOnClose"), [getIconName]("GI.Gtk.Objects.Window#g:method:getIconName"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMnemonicsVisible]("GI.Gtk.Objects.Window#g:method:getMnemonicsVisible"), [getModal]("GI.Gtk.Objects.Window#g:method:getModal"), [getNPages]("GI.Gtk.Objects.Assistant#g:method:getNPages"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getNthPage]("GI.Gtk.Objects.Assistant#g:method:getNthPage"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPage]("GI.Gtk.Objects.Assistant#g:method:getPage"), [getPageComplete]("GI.Gtk.Objects.Assistant#g:method:getPageComplete"), [getPageTitle]("GI.Gtk.Objects.Assistant#g:method:getPageTitle"), [getPageType]("GI.Gtk.Objects.Assistant#g:method:getPageType"), [getPages]("GI.Gtk.Objects.Assistant#g:method:getPages"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRenderer]("GI.Gtk.Interfaces.Native#g:method:getRenderer"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getResizable]("GI.Gtk.Objects.Window#g:method:getResizable"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getSurface]("GI.Gtk.Interfaces.Native#g:method:getSurface"), [getSurfaceTransform]("GI.Gtk.Interfaces.Native#g:method:getSurfaceTransform"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTitle]("GI.Gtk.Objects.Window#g:method:getTitle"), [getTitlebar]("GI.Gtk.Objects.Window#g:method:getTitlebar"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getTransientFor]("GI.Gtk.Objects.Window#g:method:getTransientFor"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setApplication]("GI.Gtk.Objects.Window#g:method:setApplication"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.Window#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCurrentPage]("GI.Gtk.Objects.Assistant#g:method:setCurrentPage"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDecorated]("GI.Gtk.Objects.Window#g:method:setDecorated"), [setDefaultSize]("GI.Gtk.Objects.Window#g:method:setDefaultSize"), [setDefaultWidget]("GI.Gtk.Objects.Window#g:method:setDefaultWidget"), [setDeletable]("GI.Gtk.Objects.Window#g:method:setDeletable"), [setDestroyWithParent]("GI.Gtk.Objects.Window#g:method:setDestroyWithParent"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setDisplay]("GI.Gtk.Objects.Window#g:method:setDisplay"), [setFocus]("GI.Gtk.Objects.Window#g:method:setFocus"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusVisible]("GI.Gtk.Objects.Window#g:method:setFocusVisible"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setForwardPageFunc]("GI.Gtk.Objects.Assistant#g:method:setForwardPageFunc"), [setGravity]("GI.Gtk.Objects.Window#g:method:setGravity"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHandleMenubarAccel]("GI.Gtk.Objects.Window#g:method:setHandleMenubarAccel"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHideOnClose]("GI.Gtk.Objects.Window#g:method:setHideOnClose"), [setIconName]("GI.Gtk.Objects.Window#g:method:setIconName"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMnemonicsVisible]("GI.Gtk.Objects.Window#g:method:setMnemonicsVisible"), [setModal]("GI.Gtk.Objects.Window#g:method:setModal"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setPageComplete]("GI.Gtk.Objects.Assistant#g:method:setPageComplete"), [setPageTitle]("GI.Gtk.Objects.Assistant#g:method:setPageTitle"), [setPageType]("GI.Gtk.Objects.Assistant#g:method:setPageType"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setResizable]("GI.Gtk.Objects.Window#g:method:setResizable"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStartupId]("GI.Gtk.Objects.Window#g:method:setStartupId"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTitle]("GI.Gtk.Objects.Window#g:method:setTitle"), [setTitlebar]("GI.Gtk.Objects.Window#g:method:setTitlebar"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setTransientFor]("GI.Gtk.Objects.Window#g:method:setTransientFor"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveAssistantMethod                  ,
#endif

-- ** addActionWidget #method:addActionWidget#

#if defined(ENABLE_OVERLOADING)
    AssistantAddActionWidgetMethodInfo      ,
#endif
    assistantAddActionWidget                ,


-- ** appendPage #method:appendPage#

#if defined(ENABLE_OVERLOADING)
    AssistantAppendPageMethodInfo           ,
#endif
    assistantAppendPage                     ,


-- ** commit #method:commit#

#if defined(ENABLE_OVERLOADING)
    AssistantCommitMethodInfo               ,
#endif
    assistantCommit                         ,


-- ** getCurrentPage #method:getCurrentPage#

#if defined(ENABLE_OVERLOADING)
    AssistantGetCurrentPageMethodInfo       ,
#endif
    assistantGetCurrentPage                 ,


-- ** getNPages #method:getNPages#

#if defined(ENABLE_OVERLOADING)
    AssistantGetNPagesMethodInfo            ,
#endif
    assistantGetNPages                      ,


-- ** getNthPage #method:getNthPage#

#if defined(ENABLE_OVERLOADING)
    AssistantGetNthPageMethodInfo           ,
#endif
    assistantGetNthPage                     ,


-- ** getPage #method:getPage#

#if defined(ENABLE_OVERLOADING)
    AssistantGetPageMethodInfo              ,
#endif
    assistantGetPage                        ,


-- ** getPageComplete #method:getPageComplete#

#if defined(ENABLE_OVERLOADING)
    AssistantGetPageCompleteMethodInfo      ,
#endif
    assistantGetPageComplete                ,


-- ** getPageTitle #method:getPageTitle#

#if defined(ENABLE_OVERLOADING)
    AssistantGetPageTitleMethodInfo         ,
#endif
    assistantGetPageTitle                   ,


-- ** getPageType #method:getPageType#

#if defined(ENABLE_OVERLOADING)
    AssistantGetPageTypeMethodInfo          ,
#endif
    assistantGetPageType                    ,


-- ** getPages #method:getPages#

#if defined(ENABLE_OVERLOADING)
    AssistantGetPagesMethodInfo             ,
#endif
    assistantGetPages                       ,


-- ** insertPage #method:insertPage#

#if defined(ENABLE_OVERLOADING)
    AssistantInsertPageMethodInfo           ,
#endif
    assistantInsertPage                     ,


-- ** new #method:new#

    assistantNew                            ,


-- ** nextPage #method:nextPage#

#if defined(ENABLE_OVERLOADING)
    AssistantNextPageMethodInfo             ,
#endif
    assistantNextPage                       ,


-- ** prependPage #method:prependPage#

#if defined(ENABLE_OVERLOADING)
    AssistantPrependPageMethodInfo          ,
#endif
    assistantPrependPage                    ,


-- ** previousPage #method:previousPage#

#if defined(ENABLE_OVERLOADING)
    AssistantPreviousPageMethodInfo         ,
#endif
    assistantPreviousPage                   ,


-- ** removeActionWidget #method:removeActionWidget#

#if defined(ENABLE_OVERLOADING)
    AssistantRemoveActionWidgetMethodInfo   ,
#endif
    assistantRemoveActionWidget             ,


-- ** removePage #method:removePage#

#if defined(ENABLE_OVERLOADING)
    AssistantRemovePageMethodInfo           ,
#endif
    assistantRemovePage                     ,


-- ** setCurrentPage #method:setCurrentPage#

#if defined(ENABLE_OVERLOADING)
    AssistantSetCurrentPageMethodInfo       ,
#endif
    assistantSetCurrentPage                 ,


-- ** setForwardPageFunc #method:setForwardPageFunc#

#if defined(ENABLE_OVERLOADING)
    AssistantSetForwardPageFuncMethodInfo   ,
#endif
    assistantSetForwardPageFunc             ,


-- ** setPageComplete #method:setPageComplete#

#if defined(ENABLE_OVERLOADING)
    AssistantSetPageCompleteMethodInfo      ,
#endif
    assistantSetPageComplete                ,


-- ** setPageTitle #method:setPageTitle#

#if defined(ENABLE_OVERLOADING)
    AssistantSetPageTitleMethodInfo         ,
#endif
    assistantSetPageTitle                   ,


-- ** setPageType #method:setPageType#

#if defined(ENABLE_OVERLOADING)
    AssistantSetPageTypeMethodInfo          ,
#endif
    assistantSetPageType                    ,


-- ** updateButtonsState #method:updateButtonsState#

#if defined(ENABLE_OVERLOADING)
    AssistantUpdateButtonsStateMethodInfo   ,
#endif
    assistantUpdateButtonsState             ,




 -- * Properties


-- ** pages #attr:pages#
-- | @GListModel@ containing the pages.

#if defined(ENABLE_OVERLOADING)
    AssistantPagesPropertyInfo              ,
#endif
#if defined(ENABLE_OVERLOADING)
    assistantPages                          ,
#endif
    getAssistantPages                       ,


-- ** useHeaderBar #attr:useHeaderBar#
-- | 'P.True' if the assistant uses a @GtkHeaderBar@ for action buttons
-- instead of the action-area.
-- 
-- For technical reasons, this property is declared as an integer
-- property, but you should only set it to 'P.True' or 'P.False'.

#if defined(ENABLE_OVERLOADING)
    AssistantUseHeaderBarPropertyInfo       ,
#endif
#if defined(ENABLE_OVERLOADING)
    assistantUseHeaderBar                   ,
#endif
    constructAssistantUseHeaderBar          ,
    getAssistantUseHeaderBar                ,




 -- * Signals


-- ** apply #signal:apply#

    AssistantApplyCallback                  ,
#if defined(ENABLE_OVERLOADING)
    AssistantApplySignalInfo                ,
#endif
    afterAssistantApply                     ,
    onAssistantApply                        ,


-- ** cancel #signal:cancel#

    AssistantCancelCallback                 ,
#if defined(ENABLE_OVERLOADING)
    AssistantCancelSignalInfo               ,
#endif
    afterAssistantCancel                    ,
    onAssistantCancel                       ,


-- ** close #signal:close#

    AssistantCloseCallback                  ,
#if defined(ENABLE_OVERLOADING)
    AssistantCloseSignalInfo                ,
#endif
    afterAssistantClose                     ,
    onAssistantClose                        ,


-- ** escape #signal:escape#

    AssistantEscapeCallback                 ,
#if defined(ENABLE_OVERLOADING)
    AssistantEscapeSignalInfo               ,
#endif
    afterAssistantEscape                    ,
    onAssistantEscape                       ,


-- ** prepare #signal:prepare#

    AssistantPrepareCallback                ,
#if defined(ENABLE_OVERLOADING)
    AssistantPrepareSignalInfo              ,
#endif
    afterAssistantPrepare                   ,
    onAssistantPrepare                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.AssistantPage as Gtk.AssistantPage
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.AssistantPage as Gtk.AssistantPage
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window

#endif

-- | Memory-managed wrapper type.
newtype Assistant = Assistant (SP.ManagedPtr Assistant)
    deriving (Eq)

instance SP.ManagedPtrNewtype Assistant where
    toManagedPtr (Assistant p) = p

foreign import ccall "gtk_assistant_get_type"
    c_gtk_assistant_get_type :: IO B.Types.GType

instance B.Types.TypedObject Assistant where
    glibType = c_gtk_assistant_get_type

instance B.Types.GObject Assistant

-- | Type class for types which can be safely cast to t'Assistant', for instance with `toAssistant`.
class (SP.GObject o, O.IsDescendantOf Assistant o) => IsAssistant o
instance (SP.GObject o, O.IsDescendantOf Assistant o) => IsAssistant o

instance O.HasParentTypes Assistant
type instance O.ParentTypes Assistant = '[Gtk.Window.Window, Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Native.Native, Gtk.Root.Root, Gtk.ShortcutManager.ShortcutManager]

-- | Cast to t'Assistant', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toAssistant :: (MIO.MonadIO m, IsAssistant o) => o -> m Assistant
toAssistant = MIO.liftIO . B.ManagedPtr.unsafeCastTo Assistant

-- | Convert t'Assistant' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Assistant) where
    gvalueGType_ = c_gtk_assistant_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Assistant)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Assistant)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Assistant ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveAssistantMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAssistantMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveAssistantMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveAssistantMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveAssistantMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveAssistantMethod "addActionWidget" o = AssistantAddActionWidgetMethodInfo
    ResolveAssistantMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveAssistantMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveAssistantMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveAssistantMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveAssistantMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveAssistantMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveAssistantMethod "appendPage" o = AssistantAppendPageMethodInfo
    ResolveAssistantMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveAssistantMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveAssistantMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveAssistantMethod "close" o = Gtk.Window.WindowCloseMethodInfo
    ResolveAssistantMethod "commit" o = AssistantCommitMethodInfo
    ResolveAssistantMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveAssistantMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveAssistantMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveAssistantMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveAssistantMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveAssistantMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveAssistantMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveAssistantMethod "destroy" o = Gtk.Window.WindowDestroyMethodInfo
    ResolveAssistantMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveAssistantMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveAssistantMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveAssistantMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveAssistantMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveAssistantMethod "fullscreen" o = Gtk.Window.WindowFullscreenMethodInfo
    ResolveAssistantMethod "fullscreenOnMonitor" o = Gtk.Window.WindowFullscreenOnMonitorMethodInfo
    ResolveAssistantMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveAssistantMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveAssistantMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveAssistantMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveAssistantMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveAssistantMethod "hasGroup" o = Gtk.Window.WindowHasGroupMethodInfo
    ResolveAssistantMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveAssistantMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveAssistantMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveAssistantMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveAssistantMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveAssistantMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveAssistantMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveAssistantMethod "insertPage" o = AssistantInsertPageMethodInfo
    ResolveAssistantMethod "isActive" o = Gtk.Window.WindowIsActiveMethodInfo
    ResolveAssistantMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveAssistantMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveAssistantMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveAssistantMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveAssistantMethod "isFullscreen" o = Gtk.Window.WindowIsFullscreenMethodInfo
    ResolveAssistantMethod "isMaximized" o = Gtk.Window.WindowIsMaximizedMethodInfo
    ResolveAssistantMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveAssistantMethod "isSuspended" o = Gtk.Window.WindowIsSuspendedMethodInfo
    ResolveAssistantMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveAssistantMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveAssistantMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveAssistantMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveAssistantMethod "maximize" o = Gtk.Window.WindowMaximizeMethodInfo
    ResolveAssistantMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveAssistantMethod "minimize" o = Gtk.Window.WindowMinimizeMethodInfo
    ResolveAssistantMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveAssistantMethod "nextPage" o = AssistantNextPageMethodInfo
    ResolveAssistantMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveAssistantMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveAssistantMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveAssistantMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveAssistantMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveAssistantMethod "prependPage" o = AssistantPrependPageMethodInfo
    ResolveAssistantMethod "present" o = Gtk.Window.WindowPresentMethodInfo
    ResolveAssistantMethod "presentWithTime" o = Gtk.Window.WindowPresentWithTimeMethodInfo
    ResolveAssistantMethod "previousPage" o = AssistantPreviousPageMethodInfo
    ResolveAssistantMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveAssistantMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveAssistantMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveAssistantMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveAssistantMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveAssistantMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveAssistantMethod "removeActionWidget" o = AssistantRemoveActionWidgetMethodInfo
    ResolveAssistantMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveAssistantMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveAssistantMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveAssistantMethod "removePage" o = AssistantRemovePageMethodInfo
    ResolveAssistantMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveAssistantMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveAssistantMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveAssistantMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveAssistantMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveAssistantMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveAssistantMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveAssistantMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveAssistantMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveAssistantMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveAssistantMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveAssistantMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveAssistantMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveAssistantMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveAssistantMethod "unfullscreen" o = Gtk.Window.WindowUnfullscreenMethodInfo
    ResolveAssistantMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveAssistantMethod "unmaximize" o = Gtk.Window.WindowUnmaximizeMethodInfo
    ResolveAssistantMethod "unminimize" o = Gtk.Window.WindowUnminimizeMethodInfo
    ResolveAssistantMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveAssistantMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveAssistantMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveAssistantMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveAssistantMethod "updateButtonsState" o = AssistantUpdateButtonsStateMethodInfo
    ResolveAssistantMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveAssistantMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveAssistantMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveAssistantMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveAssistantMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveAssistantMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveAssistantMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveAssistantMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveAssistantMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveAssistantMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveAssistantMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveAssistantMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveAssistantMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveAssistantMethod "getApplication" o = Gtk.Window.WindowGetApplicationMethodInfo
    ResolveAssistantMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveAssistantMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveAssistantMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveAssistantMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveAssistantMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveAssistantMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveAssistantMethod "getChild" o = Gtk.Window.WindowGetChildMethodInfo
    ResolveAssistantMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveAssistantMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveAssistantMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveAssistantMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveAssistantMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveAssistantMethod "getCurrentPage" o = AssistantGetCurrentPageMethodInfo
    ResolveAssistantMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveAssistantMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveAssistantMethod "getDecorated" o = Gtk.Window.WindowGetDecoratedMethodInfo
    ResolveAssistantMethod "getDefaultSize" o = Gtk.Window.WindowGetDefaultSizeMethodInfo
    ResolveAssistantMethod "getDefaultWidget" o = Gtk.Window.WindowGetDefaultWidgetMethodInfo
    ResolveAssistantMethod "getDeletable" o = Gtk.Window.WindowGetDeletableMethodInfo
    ResolveAssistantMethod "getDestroyWithParent" o = Gtk.Window.WindowGetDestroyWithParentMethodInfo
    ResolveAssistantMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveAssistantMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveAssistantMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveAssistantMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveAssistantMethod "getFocus" o = Gtk.Window.WindowGetFocusMethodInfo
    ResolveAssistantMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveAssistantMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveAssistantMethod "getFocusVisible" o = Gtk.Window.WindowGetFocusVisibleMethodInfo
    ResolveAssistantMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveAssistantMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveAssistantMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveAssistantMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveAssistantMethod "getGravity" o = Gtk.Window.WindowGetGravityMethodInfo
    ResolveAssistantMethod "getGroup" o = Gtk.Window.WindowGetGroupMethodInfo
    ResolveAssistantMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveAssistantMethod "getHandleMenubarAccel" o = Gtk.Window.WindowGetHandleMenubarAccelMethodInfo
    ResolveAssistantMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveAssistantMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveAssistantMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveAssistantMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveAssistantMethod "getHideOnClose" o = Gtk.Window.WindowGetHideOnCloseMethodInfo
    ResolveAssistantMethod "getIconName" o = Gtk.Window.WindowGetIconNameMethodInfo
    ResolveAssistantMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveAssistantMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveAssistantMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveAssistantMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveAssistantMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveAssistantMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveAssistantMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveAssistantMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveAssistantMethod "getMnemonicsVisible" o = Gtk.Window.WindowGetMnemonicsVisibleMethodInfo
    ResolveAssistantMethod "getModal" o = Gtk.Window.WindowGetModalMethodInfo
    ResolveAssistantMethod "getNPages" o = AssistantGetNPagesMethodInfo
    ResolveAssistantMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveAssistantMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveAssistantMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveAssistantMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveAssistantMethod "getNthPage" o = AssistantGetNthPageMethodInfo
    ResolveAssistantMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveAssistantMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveAssistantMethod "getPage" o = AssistantGetPageMethodInfo
    ResolveAssistantMethod "getPageComplete" o = AssistantGetPageCompleteMethodInfo
    ResolveAssistantMethod "getPageTitle" o = AssistantGetPageTitleMethodInfo
    ResolveAssistantMethod "getPageType" o = AssistantGetPageTypeMethodInfo
    ResolveAssistantMethod "getPages" o = AssistantGetPagesMethodInfo
    ResolveAssistantMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveAssistantMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveAssistantMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveAssistantMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveAssistantMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveAssistantMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveAssistantMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveAssistantMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveAssistantMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveAssistantMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveAssistantMethod "getRenderer" o = Gtk.Native.NativeGetRendererMethodInfo
    ResolveAssistantMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveAssistantMethod "getResizable" o = Gtk.Window.WindowGetResizableMethodInfo
    ResolveAssistantMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveAssistantMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveAssistantMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveAssistantMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveAssistantMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveAssistantMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveAssistantMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveAssistantMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveAssistantMethod "getSurface" o = Gtk.Native.NativeGetSurfaceMethodInfo
    ResolveAssistantMethod "getSurfaceTransform" o = Gtk.Native.NativeGetSurfaceTransformMethodInfo
    ResolveAssistantMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveAssistantMethod "getTitle" o = Gtk.Window.WindowGetTitleMethodInfo
    ResolveAssistantMethod "getTitlebar" o = Gtk.Window.WindowGetTitlebarMethodInfo
    ResolveAssistantMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveAssistantMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveAssistantMethod "getTransientFor" o = Gtk.Window.WindowGetTransientForMethodInfo
    ResolveAssistantMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveAssistantMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveAssistantMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveAssistantMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveAssistantMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveAssistantMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveAssistantMethod "setApplication" o = Gtk.Window.WindowSetApplicationMethodInfo
    ResolveAssistantMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveAssistantMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveAssistantMethod "setChild" o = Gtk.Window.WindowSetChildMethodInfo
    ResolveAssistantMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveAssistantMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveAssistantMethod "setCurrentPage" o = AssistantSetCurrentPageMethodInfo
    ResolveAssistantMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveAssistantMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveAssistantMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveAssistantMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveAssistantMethod "setDecorated" o = Gtk.Window.WindowSetDecoratedMethodInfo
    ResolveAssistantMethod "setDefaultSize" o = Gtk.Window.WindowSetDefaultSizeMethodInfo
    ResolveAssistantMethod "setDefaultWidget" o = Gtk.Window.WindowSetDefaultWidgetMethodInfo
    ResolveAssistantMethod "setDeletable" o = Gtk.Window.WindowSetDeletableMethodInfo
    ResolveAssistantMethod "setDestroyWithParent" o = Gtk.Window.WindowSetDestroyWithParentMethodInfo
    ResolveAssistantMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveAssistantMethod "setDisplay" o = Gtk.Window.WindowSetDisplayMethodInfo
    ResolveAssistantMethod "setFocus" o = Gtk.Window.WindowSetFocusMethodInfo
    ResolveAssistantMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveAssistantMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveAssistantMethod "setFocusVisible" o = Gtk.Window.WindowSetFocusVisibleMethodInfo
    ResolveAssistantMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveAssistantMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveAssistantMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveAssistantMethod "setForwardPageFunc" o = AssistantSetForwardPageFuncMethodInfo
    ResolveAssistantMethod "setGravity" o = Gtk.Window.WindowSetGravityMethodInfo
    ResolveAssistantMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveAssistantMethod "setHandleMenubarAccel" o = Gtk.Window.WindowSetHandleMenubarAccelMethodInfo
    ResolveAssistantMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveAssistantMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveAssistantMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveAssistantMethod "setHideOnClose" o = Gtk.Window.WindowSetHideOnCloseMethodInfo
    ResolveAssistantMethod "setIconName" o = Gtk.Window.WindowSetIconNameMethodInfo
    ResolveAssistantMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveAssistantMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveAssistantMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveAssistantMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveAssistantMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveAssistantMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveAssistantMethod "setMnemonicsVisible" o = Gtk.Window.WindowSetMnemonicsVisibleMethodInfo
    ResolveAssistantMethod "setModal" o = Gtk.Window.WindowSetModalMethodInfo
    ResolveAssistantMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveAssistantMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveAssistantMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveAssistantMethod "setPageComplete" o = AssistantSetPageCompleteMethodInfo
    ResolveAssistantMethod "setPageTitle" o = AssistantSetPageTitleMethodInfo
    ResolveAssistantMethod "setPageType" o = AssistantSetPageTypeMethodInfo
    ResolveAssistantMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveAssistantMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveAssistantMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveAssistantMethod "setResizable" o = Gtk.Window.WindowSetResizableMethodInfo
    ResolveAssistantMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveAssistantMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveAssistantMethod "setStartupId" o = Gtk.Window.WindowSetStartupIdMethodInfo
    ResolveAssistantMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveAssistantMethod "setTitle" o = Gtk.Window.WindowSetTitleMethodInfo
    ResolveAssistantMethod "setTitlebar" o = Gtk.Window.WindowSetTitlebarMethodInfo
    ResolveAssistantMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveAssistantMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveAssistantMethod "setTransientFor" o = Gtk.Window.WindowSetTransientForMethodInfo
    ResolveAssistantMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveAssistantMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveAssistantMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveAssistantMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveAssistantMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAssistantMethod t Assistant, O.OverloadedMethod info Assistant p) => OL.IsLabel t (Assistant -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAssistantMethod t Assistant, O.OverloadedMethod info Assistant p, R.HasField t Assistant p) => R.HasField t Assistant p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAssistantMethod t Assistant, O.OverloadedMethodInfo info Assistant) => OL.IsLabel t (O.MethodProxy info Assistant) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Assistant::apply
{-# DEPRECATED AssistantApplyCallback ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Emitted when the apply button is clicked.
-- 
-- The default behavior of the @GtkAssistant@ is to switch to the page
-- after the current page, unless the current page is the last one.
-- 
-- A handler for the [apply](#g:signal:apply) signal should carry out the actions for
-- which the wizard has collected data. If the action takes a long time
-- to complete, you might consider putting a page of type
-- 'GI.Gtk.Enums.AssistantPageTypeProgress' after the confirmation page and handle
-- this operation within the [Assistant::prepare]("GI.Gtk.Objects.Assistant#g:signal:prepare") signal of
-- the progress page.
type AssistantApplyCallback =
    IO ()

type C_AssistantApplyCallback =
    Ptr Assistant ->                        -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_AssistantApplyCallback`.
foreign import ccall "wrapper"
    mk_AssistantApplyCallback :: C_AssistantApplyCallback -> IO (FunPtr C_AssistantApplyCallback)

wrap_AssistantApplyCallback :: 
    GObject a => (a -> AssistantApplyCallback) ->
    C_AssistantApplyCallback
wrap_AssistantApplyCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [apply](#signal:apply) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' assistant #apply callback
-- @
-- 
-- 
onAssistantApply :: (IsAssistant a, MonadIO m) => a -> ((?self :: a) => AssistantApplyCallback) -> m SignalHandlerId
onAssistantApply obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AssistantApplyCallback wrapped
    wrapped'' <- mk_AssistantApplyCallback wrapped'
    connectSignalFunPtr obj "apply" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [apply](#signal:apply) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' assistant #apply callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterAssistantApply :: (IsAssistant a, MonadIO m) => a -> ((?self :: a) => AssistantApplyCallback) -> m SignalHandlerId
afterAssistantApply obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AssistantApplyCallback wrapped
    wrapped'' <- mk_AssistantApplyCallback wrapped'
    connectSignalFunPtr obj "apply" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data AssistantApplySignalInfo
instance SignalInfo AssistantApplySignalInfo where
    type HaskellCallbackType AssistantApplySignalInfo = AssistantApplyCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_AssistantApplyCallback cb
        cb'' <- mk_AssistantApplyCallback cb'
        connectSignalFunPtr obj "apply" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant::apply"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#g:signal:apply"})

#endif

-- signal Assistant::cancel
{-# DEPRECATED AssistantCancelCallback ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Emitted when then the cancel button is clicked.
type AssistantCancelCallback =
    IO ()

type C_AssistantCancelCallback =
    Ptr Assistant ->                        -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_AssistantCancelCallback`.
foreign import ccall "wrapper"
    mk_AssistantCancelCallback :: C_AssistantCancelCallback -> IO (FunPtr C_AssistantCancelCallback)

wrap_AssistantCancelCallback :: 
    GObject a => (a -> AssistantCancelCallback) ->
    C_AssistantCancelCallback
wrap_AssistantCancelCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [cancel](#signal:cancel) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' assistant #cancel callback
-- @
-- 
-- 
onAssistantCancel :: (IsAssistant a, MonadIO m) => a -> ((?self :: a) => AssistantCancelCallback) -> m SignalHandlerId
onAssistantCancel obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AssistantCancelCallback wrapped
    wrapped'' <- mk_AssistantCancelCallback wrapped'
    connectSignalFunPtr obj "cancel" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [cancel](#signal:cancel) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' assistant #cancel callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterAssistantCancel :: (IsAssistant a, MonadIO m) => a -> ((?self :: a) => AssistantCancelCallback) -> m SignalHandlerId
afterAssistantCancel obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AssistantCancelCallback wrapped
    wrapped'' <- mk_AssistantCancelCallback wrapped'
    connectSignalFunPtr obj "cancel" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data AssistantCancelSignalInfo
instance SignalInfo AssistantCancelSignalInfo where
    type HaskellCallbackType AssistantCancelSignalInfo = AssistantCancelCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_AssistantCancelCallback cb
        cb'' <- mk_AssistantCancelCallback cb'
        connectSignalFunPtr obj "cancel" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant::cancel"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#g:signal:cancel"})

#endif

-- signal Assistant::close
{-# DEPRECATED AssistantCloseCallback ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Emitted either when the close button of a summary page is clicked,
-- or when the apply button in the last page in the flow (of type
-- 'GI.Gtk.Enums.AssistantPageTypeConfirm') is clicked.
type AssistantCloseCallback =
    IO ()

type C_AssistantCloseCallback =
    Ptr Assistant ->                        -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_AssistantCloseCallback`.
foreign import ccall "wrapper"
    mk_AssistantCloseCallback :: C_AssistantCloseCallback -> IO (FunPtr C_AssistantCloseCallback)

wrap_AssistantCloseCallback :: 
    GObject a => (a -> AssistantCloseCallback) ->
    C_AssistantCloseCallback
wrap_AssistantCloseCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [close](#signal:close) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' assistant #close callback
-- @
-- 
-- 
onAssistantClose :: (IsAssistant a, MonadIO m) => a -> ((?self :: a) => AssistantCloseCallback) -> m SignalHandlerId
onAssistantClose obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AssistantCloseCallback wrapped
    wrapped'' <- mk_AssistantCloseCallback wrapped'
    connectSignalFunPtr obj "close" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [close](#signal:close) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' assistant #close callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterAssistantClose :: (IsAssistant a, MonadIO m) => a -> ((?self :: a) => AssistantCloseCallback) -> m SignalHandlerId
afterAssistantClose obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AssistantCloseCallback wrapped
    wrapped'' <- mk_AssistantCloseCallback wrapped'
    connectSignalFunPtr obj "close" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data AssistantCloseSignalInfo
instance SignalInfo AssistantCloseSignalInfo where
    type HaskellCallbackType AssistantCloseSignalInfo = AssistantCloseCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_AssistantCloseCallback cb
        cb'' <- mk_AssistantCloseCallback cb'
        connectSignalFunPtr obj "close" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant::close"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#g:signal:close"})

#endif

-- signal Assistant::escape
{-# DEPRECATED AssistantEscapeCallback ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | The action signal for the Escape binding.
type AssistantEscapeCallback =
    IO ()

type C_AssistantEscapeCallback =
    Ptr Assistant ->                        -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_AssistantEscapeCallback`.
foreign import ccall "wrapper"
    mk_AssistantEscapeCallback :: C_AssistantEscapeCallback -> IO (FunPtr C_AssistantEscapeCallback)

wrap_AssistantEscapeCallback :: 
    GObject a => (a -> AssistantEscapeCallback) ->
    C_AssistantEscapeCallback
wrap_AssistantEscapeCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [escape](#signal:escape) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' assistant #escape callback
-- @
-- 
-- 
onAssistantEscape :: (IsAssistant a, MonadIO m) => a -> ((?self :: a) => AssistantEscapeCallback) -> m SignalHandlerId
onAssistantEscape obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AssistantEscapeCallback wrapped
    wrapped'' <- mk_AssistantEscapeCallback wrapped'
    connectSignalFunPtr obj "escape" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [escape](#signal:escape) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' assistant #escape callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterAssistantEscape :: (IsAssistant a, MonadIO m) => a -> ((?self :: a) => AssistantEscapeCallback) -> m SignalHandlerId
afterAssistantEscape obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AssistantEscapeCallback wrapped
    wrapped'' <- mk_AssistantEscapeCallback wrapped'
    connectSignalFunPtr obj "escape" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data AssistantEscapeSignalInfo
instance SignalInfo AssistantEscapeSignalInfo where
    type HaskellCallbackType AssistantEscapeSignalInfo = AssistantEscapeCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_AssistantEscapeCallback cb
        cb'' <- mk_AssistantEscapeCallback cb'
        connectSignalFunPtr obj "escape" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant::escape"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#g:signal:escape"})

#endif

-- signal Assistant::prepare
{-# DEPRECATED AssistantPrepareCallback ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Emitted when a new page is set as the assistant\'s current page,
-- before making the new page visible.
-- 
-- A handler for this signal can do any preparations which are
-- necessary before showing /@page@/.
type AssistantPrepareCallback =
    Gtk.Widget.Widget
    -- ^ /@page@/: the current page
    -> IO ()

type C_AssistantPrepareCallback =
    Ptr Assistant ->                        -- object
    Ptr Gtk.Widget.Widget ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_AssistantPrepareCallback`.
foreign import ccall "wrapper"
    mk_AssistantPrepareCallback :: C_AssistantPrepareCallback -> IO (FunPtr C_AssistantPrepareCallback)

wrap_AssistantPrepareCallback :: 
    GObject a => (a -> AssistantPrepareCallback) ->
    C_AssistantPrepareCallback
wrap_AssistantPrepareCallback gi'cb gi'selfPtr page _ = do
    page' <- (newObject Gtk.Widget.Widget) page
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  page'


-- | Connect a signal handler for the [prepare](#signal:prepare) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' assistant #prepare callback
-- @
-- 
-- 
onAssistantPrepare :: (IsAssistant a, MonadIO m) => a -> ((?self :: a) => AssistantPrepareCallback) -> m SignalHandlerId
onAssistantPrepare obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AssistantPrepareCallback wrapped
    wrapped'' <- mk_AssistantPrepareCallback wrapped'
    connectSignalFunPtr obj "prepare" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [prepare](#signal:prepare) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' assistant #prepare callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterAssistantPrepare :: (IsAssistant a, MonadIO m) => a -> ((?self :: a) => AssistantPrepareCallback) -> m SignalHandlerId
afterAssistantPrepare obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AssistantPrepareCallback wrapped
    wrapped'' <- mk_AssistantPrepareCallback wrapped'
    connectSignalFunPtr obj "prepare" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data AssistantPrepareSignalInfo
instance SignalInfo AssistantPrepareSignalInfo where
    type HaskellCallbackType AssistantPrepareSignalInfo = AssistantPrepareCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_AssistantPrepareCallback cb
        cb'' <- mk_AssistantPrepareCallback cb'
        connectSignalFunPtr obj "prepare" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant::prepare"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#g:signal:prepare"})

#endif

-- VVV Prop "pages"
   -- Type: TInterface (Name {namespace = "Gio", name = "ListModel"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@pages@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' assistant #pages
-- @
getAssistantPages :: (MonadIO m, IsAssistant o) => o -> m (Maybe Gio.ListModel.ListModel)
getAssistantPages obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "pages" Gio.ListModel.ListModel

#if defined(ENABLE_OVERLOADING)
data AssistantPagesPropertyInfo
instance AttrInfo AssistantPagesPropertyInfo where
    type AttrAllowedOps AssistantPagesPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AssistantPagesPropertyInfo = IsAssistant
    type AttrSetTypeConstraint AssistantPagesPropertyInfo = (~) ()
    type AttrTransferTypeConstraint AssistantPagesPropertyInfo = (~) ()
    type AttrTransferType AssistantPagesPropertyInfo = ()
    type AttrGetType AssistantPagesPropertyInfo = (Maybe Gio.ListModel.ListModel)
    type AttrLabel AssistantPagesPropertyInfo = "pages"
    type AttrOrigin AssistantPagesPropertyInfo = Assistant
    attrGet = getAssistantPages
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.pages"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#g:attr:pages"
        })
#endif

-- VVV Prop "use-header-bar"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@use-header-bar@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' assistant #useHeaderBar
-- @
getAssistantUseHeaderBar :: (MonadIO m, IsAssistant o) => o -> m Int32
getAssistantUseHeaderBar obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "use-header-bar"

-- | Construct a t'GValueConstruct' with valid value for the “@use-header-bar@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAssistantUseHeaderBar :: (IsAssistant o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructAssistantUseHeaderBar val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "use-header-bar" val

#if defined(ENABLE_OVERLOADING)
data AssistantUseHeaderBarPropertyInfo
instance AttrInfo AssistantUseHeaderBarPropertyInfo where
    type AttrAllowedOps AssistantUseHeaderBarPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint AssistantUseHeaderBarPropertyInfo = IsAssistant
    type AttrSetTypeConstraint AssistantUseHeaderBarPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint AssistantUseHeaderBarPropertyInfo = (~) Int32
    type AttrTransferType AssistantUseHeaderBarPropertyInfo = Int32
    type AttrGetType AssistantUseHeaderBarPropertyInfo = Int32
    type AttrLabel AssistantUseHeaderBarPropertyInfo = "use-header-bar"
    type AttrOrigin AssistantUseHeaderBarPropertyInfo = Assistant
    attrGet = getAssistantUseHeaderBar
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructAssistantUseHeaderBar
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.useHeaderBar"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#g:attr:useHeaderBar"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Assistant
type instance O.AttributeList Assistant = AssistantAttributeList
type AssistantAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("application", Gtk.Window.WindowApplicationPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", Gtk.Window.WindowChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("decorated", Gtk.Window.WindowDecoratedPropertyInfo), '("defaultHeight", Gtk.Window.WindowDefaultHeightPropertyInfo), '("defaultWidget", Gtk.Window.WindowDefaultWidgetPropertyInfo), '("defaultWidth", Gtk.Window.WindowDefaultWidthPropertyInfo), '("deletable", Gtk.Window.WindowDeletablePropertyInfo), '("destroyWithParent", Gtk.Window.WindowDestroyWithParentPropertyInfo), '("display", Gtk.Window.WindowDisplayPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusVisible", Gtk.Window.WindowFocusVisiblePropertyInfo), '("focusWidget", Gtk.Window.WindowFocusWidgetPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("fullscreened", Gtk.Window.WindowFullscreenedPropertyInfo), '("gravity", Gtk.Window.WindowGravityPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("handleMenubarAccel", Gtk.Window.WindowHandleMenubarAccelPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hideOnClose", Gtk.Window.WindowHideOnClosePropertyInfo), '("iconName", Gtk.Window.WindowIconNamePropertyInfo), '("isActive", Gtk.Window.WindowIsActivePropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("maximized", Gtk.Window.WindowMaximizedPropertyInfo), '("mnemonicsVisible", Gtk.Window.WindowMnemonicsVisiblePropertyInfo), '("modal", Gtk.Window.WindowModalPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("pages", AssistantPagesPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("resizable", Gtk.Window.WindowResizablePropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("startupId", Gtk.Window.WindowStartupIdPropertyInfo), '("suspended", Gtk.Window.WindowSuspendedPropertyInfo), '("title", Gtk.Window.WindowTitlePropertyInfo), '("titlebar", Gtk.Window.WindowTitlebarPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("transientFor", Gtk.Window.WindowTransientForPropertyInfo), '("useHeaderBar", AssistantUseHeaderBarPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
assistantPages :: AttrLabelProxy "pages"
assistantPages = AttrLabelProxy

assistantUseHeaderBar :: AttrLabelProxy "useHeaderBar"
assistantUseHeaderBar = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Assistant = AssistantSignalList
type AssistantSignalList = ('[ '("activateDefault", Gtk.Window.WindowActivateDefaultSignalInfo), '("activateFocus", Gtk.Window.WindowActivateFocusSignalInfo), '("apply", AssistantApplySignalInfo), '("cancel", AssistantCancelSignalInfo), '("close", AssistantCloseSignalInfo), '("closeRequest", Gtk.Window.WindowCloseRequestSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("enableDebugging", Gtk.Window.WindowEnableDebuggingSignalInfo), '("escape", AssistantEscapeSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("keysChanged", Gtk.Window.WindowKeysChangedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("prepare", AssistantPrepareSignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Assistant::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Assistant" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_new" gtk_assistant_new :: 
    IO (Ptr Assistant)

{-# DEPRECATED assistantNew ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Creates a new @GtkAssistant@.
assistantNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Assistant
    -- ^ __Returns:__ a newly created @GtkAssistant@
assistantNew  = liftIO $ do
    result <- gtk_assistant_new
    checkUnexpectedReturnNULL "assistantNew" result
    result' <- (newObject Assistant) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Assistant::add_action_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_add_action_widget" gtk_assistant_add_action_widget :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

{-# DEPRECATED assistantAddActionWidget ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Adds a widget to the action area of a @GtkAssistant@.
assistantAddActionWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> b
    -- ^ /@child@/: a @GtkWidget@
    -> m ()
assistantAddActionWidget assistant child = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    child' <- unsafeManagedPtrCastPtr child
    gtk_assistant_add_action_widget assistant' child'
    touchManagedPtr assistant
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data AssistantAddActionWidgetMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) => O.OverloadedMethod AssistantAddActionWidgetMethodInfo a signature where
    overloadedMethod = assistantAddActionWidget

instance O.OverloadedMethodInfo AssistantAddActionWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantAddActionWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantAddActionWidget"
        })


#endif

-- method Assistant::append_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_append_page" gtk_assistant_append_page :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Ptr Gtk.Widget.Widget ->                -- page : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO Int32

{-# DEPRECATED assistantAppendPage ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Appends a page to the /@assistant@/.
assistantAppendPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> b
    -- ^ /@page@/: a @GtkWidget@
    -> m Int32
    -- ^ __Returns:__ the index (starting at 0) of the inserted page
assistantAppendPage assistant page = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    page' <- unsafeManagedPtrCastPtr page
    result <- gtk_assistant_append_page assistant' page'
    touchManagedPtr assistant
    touchManagedPtr page
    return result

#if defined(ENABLE_OVERLOADING)
data AssistantAppendPageMethodInfo
instance (signature ~ (b -> m Int32), MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) => O.OverloadedMethod AssistantAppendPageMethodInfo a signature where
    overloadedMethod = assistantAppendPage

instance O.OverloadedMethodInfo AssistantAppendPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantAppendPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantAppendPage"
        })


#endif

-- method Assistant::commit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_commit" gtk_assistant_commit :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    IO ()

{-# DEPRECATED assistantCommit ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Erases the visited page history.
-- 
-- GTK will then hide the back button on the current page,
-- and removes the cancel button from subsequent pages.
-- 
-- Use this when the information provided up to the current
-- page is hereafter deemed permanent and cannot be modified
-- or undone. For example, showing a progress page to track
-- a long-running, unreversible operation after the user has
-- clicked apply on a confirmation page.
assistantCommit ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> m ()
assistantCommit assistant = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    gtk_assistant_commit assistant'
    touchManagedPtr assistant
    return ()

#if defined(ENABLE_OVERLOADING)
data AssistantCommitMethodInfo
instance (signature ~ (m ()), MonadIO m, IsAssistant a) => O.OverloadedMethod AssistantCommitMethodInfo a signature where
    overloadedMethod = assistantCommit

instance O.OverloadedMethodInfo AssistantCommitMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantCommit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantCommit"
        })


#endif

-- method Assistant::get_current_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_get_current_page" gtk_assistant_get_current_page :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    IO Int32

{-# DEPRECATED assistantGetCurrentPage ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Returns the page number of the current page.
assistantGetCurrentPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> m Int32
    -- ^ __Returns:__ The index (starting from 0) of the current
    --   page in the /@assistant@/, or -1 if the /@assistant@/ has no pages,
    --   or no current page
assistantGetCurrentPage assistant = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    result <- gtk_assistant_get_current_page assistant'
    touchManagedPtr assistant
    return result

#if defined(ENABLE_OVERLOADING)
data AssistantGetCurrentPageMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsAssistant a) => O.OverloadedMethod AssistantGetCurrentPageMethodInfo a signature where
    overloadedMethod = assistantGetCurrentPage

instance O.OverloadedMethodInfo AssistantGetCurrentPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantGetCurrentPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantGetCurrentPage"
        })


#endif

-- method Assistant::get_n_pages
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_get_n_pages" gtk_assistant_get_n_pages :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    IO Int32

{-# DEPRECATED assistantGetNPages ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Returns the number of pages in the /@assistant@/
assistantGetNPages ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> m Int32
    -- ^ __Returns:__ the number of pages in the /@assistant@/
assistantGetNPages assistant = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    result <- gtk_assistant_get_n_pages assistant'
    touchManagedPtr assistant
    return result

#if defined(ENABLE_OVERLOADING)
data AssistantGetNPagesMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsAssistant a) => O.OverloadedMethod AssistantGetNPagesMethodInfo a signature where
    overloadedMethod = assistantGetNPages

instance O.OverloadedMethodInfo AssistantGetNPagesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantGetNPages",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantGetNPages"
        })


#endif

-- method Assistant::get_nth_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the index of a page in the @assistant,\n  or -1 to get the last page"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_get_nth_page" gtk_assistant_get_nth_page :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Int32 ->                                -- page_num : TBasicType TInt
    IO (Ptr Gtk.Widget.Widget)

{-# DEPRECATED assistantGetNthPage ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Returns the child widget contained in page number /@pageNum@/.
assistantGetNthPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> Int32
    -- ^ /@pageNum@/: the index of a page in the /@assistant@/,
    --   or -1 to get the last page
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget, or 'P.Nothing'
    --   if /@pageNum@/ is out of bounds
assistantGetNthPage assistant pageNum = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    result <- gtk_assistant_get_nth_page assistant' pageNum
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr assistant
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AssistantGetNthPageMethodInfo
instance (signature ~ (Int32 -> m (Maybe Gtk.Widget.Widget)), MonadIO m, IsAssistant a) => O.OverloadedMethod AssistantGetNthPageMethodInfo a signature where
    overloadedMethod = assistantGetNthPage

instance O.OverloadedMethodInfo AssistantGetNthPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantGetNthPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantGetNthPage"
        })


#endif

-- method Assistant::get_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a child of @assistant"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "AssistantPage" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_get_page" gtk_assistant_get_page :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO (Ptr Gtk.AssistantPage.AssistantPage)

{-# DEPRECATED assistantGetPage ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Returns the @GtkAssistantPage@ object for /@child@/.
assistantGetPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> b
    -- ^ /@child@/: a child of /@assistant@/
    -> m Gtk.AssistantPage.AssistantPage
    -- ^ __Returns:__ the @GtkAssistantPage@ for /@child@/
assistantGetPage assistant child = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_assistant_get_page assistant' child'
    checkUnexpectedReturnNULL "assistantGetPage" result
    result' <- (newObject Gtk.AssistantPage.AssistantPage) result
    touchManagedPtr assistant
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
data AssistantGetPageMethodInfo
instance (signature ~ (b -> m Gtk.AssistantPage.AssistantPage), MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) => O.OverloadedMethod AssistantGetPageMethodInfo a signature where
    overloadedMethod = assistantGetPage

instance O.OverloadedMethodInfo AssistantGetPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantGetPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantGetPage"
        })


#endif

-- method Assistant::get_page_complete
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a page of @assistant"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_get_page_complete" gtk_assistant_get_page_complete :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Ptr Gtk.Widget.Widget ->                -- page : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO CInt

{-# DEPRECATED assistantGetPageComplete ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Gets whether /@page@/ is complete.
assistantGetPageComplete ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> b
    -- ^ /@page@/: a page of /@assistant@/
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@page@/ is complete.
assistantGetPageComplete assistant page = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    page' <- unsafeManagedPtrCastPtr page
    result <- gtk_assistant_get_page_complete assistant' page'
    let result' = (/= 0) result
    touchManagedPtr assistant
    touchManagedPtr page
    return result'

#if defined(ENABLE_OVERLOADING)
data AssistantGetPageCompleteMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) => O.OverloadedMethod AssistantGetPageCompleteMethodInfo a signature where
    overloadedMethod = assistantGetPageComplete

instance O.OverloadedMethodInfo AssistantGetPageCompleteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantGetPageComplete",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantGetPageComplete"
        })


#endif

-- method Assistant::get_page_title
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a page of @assistant"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_get_page_title" gtk_assistant_get_page_title :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Ptr Gtk.Widget.Widget ->                -- page : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO CString

{-# DEPRECATED assistantGetPageTitle ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Gets the title for /@page@/.
assistantGetPageTitle ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> b
    -- ^ /@page@/: a page of /@assistant@/
    -> m T.Text
    -- ^ __Returns:__ the title for /@page@/
assistantGetPageTitle assistant page = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    page' <- unsafeManagedPtrCastPtr page
    result <- gtk_assistant_get_page_title assistant' page'
    checkUnexpectedReturnNULL "assistantGetPageTitle" result
    result' <- cstringToText result
    touchManagedPtr assistant
    touchManagedPtr page
    return result'

#if defined(ENABLE_OVERLOADING)
data AssistantGetPageTitleMethodInfo
instance (signature ~ (b -> m T.Text), MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) => O.OverloadedMethod AssistantGetPageTitleMethodInfo a signature where
    overloadedMethod = assistantGetPageTitle

instance O.OverloadedMethodInfo AssistantGetPageTitleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantGetPageTitle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantGetPageTitle"
        })


#endif

-- method Assistant::get_page_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a page of @assistant"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "AssistantPageType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_get_page_type" gtk_assistant_get_page_type :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Ptr Gtk.Widget.Widget ->                -- page : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO CUInt

{-# DEPRECATED assistantGetPageType ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Gets the page type of /@page@/.
assistantGetPageType ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> b
    -- ^ /@page@/: a page of /@assistant@/
    -> m Gtk.Enums.AssistantPageType
    -- ^ __Returns:__ the page type of /@page@/
assistantGetPageType assistant page = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    page' <- unsafeManagedPtrCastPtr page
    result <- gtk_assistant_get_page_type assistant' page'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr assistant
    touchManagedPtr page
    return result'

#if defined(ENABLE_OVERLOADING)
data AssistantGetPageTypeMethodInfo
instance (signature ~ (b -> m Gtk.Enums.AssistantPageType), MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) => O.OverloadedMethod AssistantGetPageTypeMethodInfo a signature where
    overloadedMethod = assistantGetPageType

instance O.OverloadedMethodInfo AssistantGetPageTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantGetPageType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantGetPageType"
        })


#endif

-- method Assistant::get_pages
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_get_pages" gtk_assistant_get_pages :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    IO (Ptr Gio.ListModel.ListModel)

{-# DEPRECATED assistantGetPages ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Gets a list model of the assistant pages.
assistantGetPages ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> m Gio.ListModel.ListModel
    -- ^ __Returns:__ A list model of the pages.
assistantGetPages assistant = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    result <- gtk_assistant_get_pages assistant'
    checkUnexpectedReturnNULL "assistantGetPages" result
    result' <- (wrapObject Gio.ListModel.ListModel) result
    touchManagedPtr assistant
    return result'

#if defined(ENABLE_OVERLOADING)
data AssistantGetPagesMethodInfo
instance (signature ~ (m Gio.ListModel.ListModel), MonadIO m, IsAssistant a) => O.OverloadedMethod AssistantGetPagesMethodInfo a signature where
    overloadedMethod = assistantGetPages

instance O.OverloadedMethodInfo AssistantGetPagesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantGetPages",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantGetPages"
        })


#endif

-- method Assistant::insert_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the index (starting at 0) at which to insert the page,\n  or -1 to append the page to the @assistant"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_insert_page" gtk_assistant_insert_page :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Ptr Gtk.Widget.Widget ->                -- page : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Int32 ->                                -- position : TBasicType TInt
    IO Int32

{-# DEPRECATED assistantInsertPage ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Inserts a page in the /@assistant@/ at a given position.
assistantInsertPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> b
    -- ^ /@page@/: a @GtkWidget@
    -> Int32
    -- ^ /@position@/: the index (starting at 0) at which to insert the page,
    --   or -1 to append the page to the /@assistant@/
    -> m Int32
    -- ^ __Returns:__ the index (starting from 0) of the inserted page
assistantInsertPage assistant page position = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    page' <- unsafeManagedPtrCastPtr page
    result <- gtk_assistant_insert_page assistant' page' position
    touchManagedPtr assistant
    touchManagedPtr page
    return result

#if defined(ENABLE_OVERLOADING)
data AssistantInsertPageMethodInfo
instance (signature ~ (b -> Int32 -> m Int32), MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) => O.OverloadedMethod AssistantInsertPageMethodInfo a signature where
    overloadedMethod = assistantInsertPage

instance O.OverloadedMethodInfo AssistantInsertPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantInsertPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantInsertPage"
        })


#endif

-- method Assistant::next_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_next_page" gtk_assistant_next_page :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    IO ()

{-# DEPRECATED assistantNextPage ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Navigate to the next page.
-- 
-- It is a programming error to call this function when
-- there is no next page.
-- 
-- This function is for use when creating pages of the
-- 'GI.Gtk.Enums.AssistantPageTypeCustom' type.
assistantNextPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> m ()
assistantNextPage assistant = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    gtk_assistant_next_page assistant'
    touchManagedPtr assistant
    return ()

#if defined(ENABLE_OVERLOADING)
data AssistantNextPageMethodInfo
instance (signature ~ (m ()), MonadIO m, IsAssistant a) => O.OverloadedMethod AssistantNextPageMethodInfo a signature where
    overloadedMethod = assistantNextPage

instance O.OverloadedMethodInfo AssistantNextPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantNextPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantNextPage"
        })


#endif

-- method Assistant::prepend_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_prepend_page" gtk_assistant_prepend_page :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Ptr Gtk.Widget.Widget ->                -- page : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO Int32

{-# DEPRECATED assistantPrependPage ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Prepends a page to the /@assistant@/.
assistantPrependPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> b
    -- ^ /@page@/: a @GtkWidget@
    -> m Int32
    -- ^ __Returns:__ the index (starting at 0) of the inserted page
assistantPrependPage assistant page = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    page' <- unsafeManagedPtrCastPtr page
    result <- gtk_assistant_prepend_page assistant' page'
    touchManagedPtr assistant
    touchManagedPtr page
    return result

#if defined(ENABLE_OVERLOADING)
data AssistantPrependPageMethodInfo
instance (signature ~ (b -> m Int32), MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) => O.OverloadedMethod AssistantPrependPageMethodInfo a signature where
    overloadedMethod = assistantPrependPage

instance O.OverloadedMethodInfo AssistantPrependPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantPrependPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantPrependPage"
        })


#endif

-- method Assistant::previous_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_previous_page" gtk_assistant_previous_page :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    IO ()

{-# DEPRECATED assistantPreviousPage ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Navigate to the previous visited page.
-- 
-- It is a programming error to call this function when
-- no previous page is available.
-- 
-- This function is for use when creating pages of the
-- 'GI.Gtk.Enums.AssistantPageTypeCustom' type.
assistantPreviousPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> m ()
assistantPreviousPage assistant = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    gtk_assistant_previous_page assistant'
    touchManagedPtr assistant
    return ()

#if defined(ENABLE_OVERLOADING)
data AssistantPreviousPageMethodInfo
instance (signature ~ (m ()), MonadIO m, IsAssistant a) => O.OverloadedMethod AssistantPreviousPageMethodInfo a signature where
    overloadedMethod = assistantPreviousPage

instance O.OverloadedMethodInfo AssistantPreviousPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantPreviousPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantPreviousPage"
        })


#endif

-- method Assistant::remove_action_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_remove_action_widget" gtk_assistant_remove_action_widget :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

{-# DEPRECATED assistantRemoveActionWidget ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Removes a widget from the action area of a @GtkAssistant@.
assistantRemoveActionWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> b
    -- ^ /@child@/: a @GtkWidget@
    -> m ()
assistantRemoveActionWidget assistant child = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    child' <- unsafeManagedPtrCastPtr child
    gtk_assistant_remove_action_widget assistant' child'
    touchManagedPtr assistant
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data AssistantRemoveActionWidgetMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) => O.OverloadedMethod AssistantRemoveActionWidgetMethodInfo a signature where
    overloadedMethod = assistantRemoveActionWidget

instance O.OverloadedMethodInfo AssistantRemoveActionWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantRemoveActionWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantRemoveActionWidget"
        })


#endif

-- method Assistant::remove_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the index of a page in the @assistant,\n  or -1 to remove the last page"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_remove_page" gtk_assistant_remove_page :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Int32 ->                                -- page_num : TBasicType TInt
    IO ()

{-# DEPRECATED assistantRemovePage ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Removes the /@pageNum@/’s page from /@assistant@/.
assistantRemovePage ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> Int32
    -- ^ /@pageNum@/: the index of a page in the /@assistant@/,
    --   or -1 to remove the last page
    -> m ()
assistantRemovePage assistant pageNum = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    gtk_assistant_remove_page assistant' pageNum
    touchManagedPtr assistant
    return ()

#if defined(ENABLE_OVERLOADING)
data AssistantRemovePageMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsAssistant a) => O.OverloadedMethod AssistantRemovePageMethodInfo a signature where
    overloadedMethod = assistantRemovePage

instance O.OverloadedMethodInfo AssistantRemovePageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantRemovePage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantRemovePage"
        })


#endif

-- method Assistant::set_current_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "index of the page to switch to, starting from 0.\n  If negative, the last page will be used. If greater\n  than the number of pages in the @assistant, nothing\n  will be done."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_set_current_page" gtk_assistant_set_current_page :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Int32 ->                                -- page_num : TBasicType TInt
    IO ()

{-# DEPRECATED assistantSetCurrentPage ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Switches the page to /@pageNum@/.
-- 
-- Note that this will only be necessary in custom buttons,
-- as the /@assistant@/ flow can be set with
-- 'GI.Gtk.Objects.Assistant.assistantSetForwardPageFunc'.
assistantSetCurrentPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> Int32
    -- ^ /@pageNum@/: index of the page to switch to, starting from 0.
    --   If negative, the last page will be used. If greater
    --   than the number of pages in the /@assistant@/, nothing
    --   will be done.
    -> m ()
assistantSetCurrentPage assistant pageNum = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    gtk_assistant_set_current_page assistant' pageNum
    touchManagedPtr assistant
    return ()

#if defined(ENABLE_OVERLOADING)
data AssistantSetCurrentPageMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsAssistant a) => O.OverloadedMethod AssistantSetCurrentPageMethodInfo a signature where
    overloadedMethod = assistantSetCurrentPage

instance O.OverloadedMethodInfo AssistantSetCurrentPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantSetCurrentPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantSetCurrentPage"
        })


#endif

-- method Assistant::set_forward_page_func
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page_func"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AssistantPageFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the `GtkAssistantPageFunc`, or %NULL\n  to use the default one"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data for @page_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notifier for @data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_set_forward_page_func" gtk_assistant_set_forward_page_func :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    FunPtr Gtk.Callbacks.C_AssistantPageFunc -> -- page_func : TInterface (Name {namespace = "Gtk", name = "AssistantPageFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

{-# DEPRECATED assistantSetForwardPageFunc ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Sets the page forwarding function to be /@pageFunc@/.
-- 
-- This function will be used to determine what will be
-- the next page when the user presses the forward button.
-- Setting /@pageFunc@/ to 'P.Nothing' will make the assistant to
-- use the default forward function, which just goes to the
-- next visible page.
assistantSetForwardPageFunc ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> Maybe (Gtk.Callbacks.AssistantPageFunc)
    -- ^ /@pageFunc@/: the @GtkAssistantPageFunc@, or 'P.Nothing'
    --   to use the default one
    -> m ()
assistantSetForwardPageFunc assistant pageFunc = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    maybePageFunc <- case pageFunc of
        Nothing -> return FP.nullFunPtr
        Just jPageFunc -> do
            jPageFunc' <- Gtk.Callbacks.mk_AssistantPageFunc (Gtk.Callbacks.wrap_AssistantPageFunc Nothing (Gtk.Callbacks.drop_closures_AssistantPageFunc jPageFunc))
            return jPageFunc'
    let data_ = castFunPtrToPtr maybePageFunc
    let destroy = SP.safeFreeFunPtrPtr
    gtk_assistant_set_forward_page_func assistant' maybePageFunc data_ destroy
    touchManagedPtr assistant
    return ()

#if defined(ENABLE_OVERLOADING)
data AssistantSetForwardPageFuncMethodInfo
instance (signature ~ (Maybe (Gtk.Callbacks.AssistantPageFunc) -> m ()), MonadIO m, IsAssistant a) => O.OverloadedMethod AssistantSetForwardPageFuncMethodInfo a signature where
    overloadedMethod = assistantSetForwardPageFunc

instance O.OverloadedMethodInfo AssistantSetForwardPageFuncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantSetForwardPageFunc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantSetForwardPageFunc"
        })


#endif

-- method Assistant::set_page_complete
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a page of @assistant"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "complete"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the completeness status of the page"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_set_page_complete" gtk_assistant_set_page_complete :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Ptr Gtk.Widget.Widget ->                -- page : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CInt ->                                 -- complete : TBasicType TBoolean
    IO ()

{-# DEPRECATED assistantSetPageComplete ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Sets whether /@page@/ contents are complete.
-- 
-- This will make /@assistant@/ update the buttons state
-- to be able to continue the task.
assistantSetPageComplete ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> b
    -- ^ /@page@/: a page of /@assistant@/
    -> Bool
    -- ^ /@complete@/: the completeness status of the page
    -> m ()
assistantSetPageComplete assistant page complete = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    page' <- unsafeManagedPtrCastPtr page
    let complete' = (P.fromIntegral . P.fromEnum) complete
    gtk_assistant_set_page_complete assistant' page' complete'
    touchManagedPtr assistant
    touchManagedPtr page
    return ()

#if defined(ENABLE_OVERLOADING)
data AssistantSetPageCompleteMethodInfo
instance (signature ~ (b -> Bool -> m ()), MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) => O.OverloadedMethod AssistantSetPageCompleteMethodInfo a signature where
    overloadedMethod = assistantSetPageComplete

instance O.OverloadedMethodInfo AssistantSetPageCompleteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantSetPageComplete",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantSetPageComplete"
        })


#endif

-- method Assistant::set_page_title
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a page of @assistant"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "title"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new title for @page"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_set_page_title" gtk_assistant_set_page_title :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Ptr Gtk.Widget.Widget ->                -- page : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CString ->                              -- title : TBasicType TUTF8
    IO ()

{-# DEPRECATED assistantSetPageTitle ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Sets a title for /@page@/.
-- 
-- The title is displayed in the header area of the assistant
-- when /@page@/ is the current page.
assistantSetPageTitle ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> b
    -- ^ /@page@/: a page of /@assistant@/
    -> T.Text
    -- ^ /@title@/: the new title for /@page@/
    -> m ()
assistantSetPageTitle assistant page title = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    page' <- unsafeManagedPtrCastPtr page
    title' <- textToCString title
    gtk_assistant_set_page_title assistant' page' title'
    touchManagedPtr assistant
    touchManagedPtr page
    freeMem title'
    return ()

#if defined(ENABLE_OVERLOADING)
data AssistantSetPageTitleMethodInfo
instance (signature ~ (b -> T.Text -> m ()), MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) => O.OverloadedMethod AssistantSetPageTitleMethodInfo a signature where
    overloadedMethod = assistantSetPageTitle

instance O.OverloadedMethodInfo AssistantSetPageTitleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantSetPageTitle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantSetPageTitle"
        })


#endif

-- method Assistant::set_page_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a page of @assistant"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AssistantPageType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new type for @page"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_set_page_type" gtk_assistant_set_page_type :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    Ptr Gtk.Widget.Widget ->                -- page : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CUInt ->                                -- type : TInterface (Name {namespace = "Gtk", name = "AssistantPageType"})
    IO ()

{-# DEPRECATED assistantSetPageType ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Sets the page type for /@page@/.
-- 
-- The page type determines the page behavior in the /@assistant@/.
assistantSetPageType ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> b
    -- ^ /@page@/: a page of /@assistant@/
    -> Gtk.Enums.AssistantPageType
    -- ^ /@type@/: the new type for /@page@/
    -> m ()
assistantSetPageType assistant page type_ = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    page' <- unsafeManagedPtrCastPtr page
    let type_' = (fromIntegral . fromEnum) type_
    gtk_assistant_set_page_type assistant' page' type_'
    touchManagedPtr assistant
    touchManagedPtr page
    return ()

#if defined(ENABLE_OVERLOADING)
data AssistantSetPageTypeMethodInfo
instance (signature ~ (b -> Gtk.Enums.AssistantPageType -> m ()), MonadIO m, IsAssistant a, Gtk.Widget.IsWidget b) => O.OverloadedMethod AssistantSetPageTypeMethodInfo a signature where
    overloadedMethod = assistantSetPageType

instance O.OverloadedMethodInfo AssistantSetPageTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantSetPageType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantSetPageType"
        })


#endif

-- method Assistant::update_buttons_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "assistant"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Assistant" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistant`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_update_buttons_state" gtk_assistant_update_buttons_state :: 
    Ptr Assistant ->                        -- assistant : TInterface (Name {namespace = "Gtk", name = "Assistant"})
    IO ()

{-# DEPRECATED assistantUpdateButtonsState ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Forces /@assistant@/ to recompute the buttons state.
-- 
-- GTK automatically takes care of this in most situations,
-- e.g. when the user goes to a different page, or when the
-- visibility or completeness of a page changes.
-- 
-- One situation where it can be necessary to call this
-- function is when changing a value on the current page
-- affects the future page flow of the assistant.
assistantUpdateButtonsState ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistant a) =>
    a
    -- ^ /@assistant@/: a @GtkAssistant@
    -> m ()
assistantUpdateButtonsState assistant = liftIO $ do
    assistant' <- unsafeManagedPtrCastPtr assistant
    gtk_assistant_update_buttons_state assistant'
    touchManagedPtr assistant
    return ()

#if defined(ENABLE_OVERLOADING)
data AssistantUpdateButtonsStateMethodInfo
instance (signature ~ (m ()), MonadIO m, IsAssistant a) => O.OverloadedMethod AssistantUpdateButtonsStateMethodInfo a signature where
    overloadedMethod = assistantUpdateButtonsState

instance O.OverloadedMethodInfo AssistantUpdateButtonsStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Assistant.assistantUpdateButtonsState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Assistant.html#v:assistantUpdateButtonsState"
        })


#endif


