{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The type of item used by @GtkTreeListModel@.
-- 
-- It allows navigating the model as a tree and modify the state of rows.
-- 
-- @GtkTreeListRow@ instances are created by a @GtkTreeListModel@ only
-- when the [TreeListModel:passthrough]("GI.Gtk.Objects.TreeListModel#g:attr:passthrough") property is not set.
-- 
-- There are various support objects that can make use of @GtkTreeListRow@
-- objects, such as the t'GI.Gtk.Objects.TreeExpander.TreeExpander' widget that allows displaying
-- an icon to expand or collapse a row or t'GI.Gtk.Objects.TreeListRowSorter.TreeListRowSorter' that
-- makes it possible to sort trees properly.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.TreeListRow
    ( 

-- * Exported types
    TreeListRow(..)                         ,
    IsTreeListRow                           ,
    toTreeListRow                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isExpandable]("GI.Gtk.Objects.TreeListRow#g:method:isExpandable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getChildRow]("GI.Gtk.Objects.TreeListRow#g:method:getChildRow"), [getChildren]("GI.Gtk.Objects.TreeListRow#g:method:getChildren"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDepth]("GI.Gtk.Objects.TreeListRow#g:method:getDepth"), [getExpanded]("GI.Gtk.Objects.TreeListRow#g:method:getExpanded"), [getItem]("GI.Gtk.Objects.TreeListRow#g:method:getItem"), [getParent]("GI.Gtk.Objects.TreeListRow#g:method:getParent"), [getPosition]("GI.Gtk.Objects.TreeListRow#g:method:getPosition"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setExpanded]("GI.Gtk.Objects.TreeListRow#g:method:setExpanded"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveTreeListRowMethod                ,
#endif

-- ** getChildRow #method:getChildRow#

#if defined(ENABLE_OVERLOADING)
    TreeListRowGetChildRowMethodInfo        ,
#endif
    treeListRowGetChildRow                  ,


-- ** getChildren #method:getChildren#

#if defined(ENABLE_OVERLOADING)
    TreeListRowGetChildrenMethodInfo        ,
#endif
    treeListRowGetChildren                  ,


-- ** getDepth #method:getDepth#

#if defined(ENABLE_OVERLOADING)
    TreeListRowGetDepthMethodInfo           ,
#endif
    treeListRowGetDepth                     ,


-- ** getExpanded #method:getExpanded#

#if defined(ENABLE_OVERLOADING)
    TreeListRowGetExpandedMethodInfo        ,
#endif
    treeListRowGetExpanded                  ,


-- ** getItem #method:getItem#

#if defined(ENABLE_OVERLOADING)
    TreeListRowGetItemMethodInfo            ,
#endif
    treeListRowGetItem                      ,


-- ** getParent #method:getParent#

#if defined(ENABLE_OVERLOADING)
    TreeListRowGetParentMethodInfo          ,
#endif
    treeListRowGetParent                    ,


-- ** getPosition #method:getPosition#

#if defined(ENABLE_OVERLOADING)
    TreeListRowGetPositionMethodInfo        ,
#endif
    treeListRowGetPosition                  ,


-- ** isExpandable #method:isExpandable#

#if defined(ENABLE_OVERLOADING)
    TreeListRowIsExpandableMethodInfo       ,
#endif
    treeListRowIsExpandable                 ,


-- ** setExpanded #method:setExpanded#

#if defined(ENABLE_OVERLOADING)
    TreeListRowSetExpandedMethodInfo        ,
#endif
    treeListRowSetExpanded                  ,




 -- * Properties


-- ** children #attr:children#
-- | The model holding the row\'s children.

#if defined(ENABLE_OVERLOADING)
    TreeListRowChildrenPropertyInfo         ,
#endif
    getTreeListRowChildren                  ,
#if defined(ENABLE_OVERLOADING)
    treeListRowChildren                     ,
#endif


-- ** depth #attr:depth#
-- | The depth in the tree of this row.

#if defined(ENABLE_OVERLOADING)
    TreeListRowDepthPropertyInfo            ,
#endif
    getTreeListRowDepth                     ,
#if defined(ENABLE_OVERLOADING)
    treeListRowDepth                        ,
#endif


-- ** expandable #attr:expandable#
-- | If this row can ever be expanded.

#if defined(ENABLE_OVERLOADING)
    TreeListRowExpandablePropertyInfo       ,
#endif
    getTreeListRowExpandable                ,
#if defined(ENABLE_OVERLOADING)
    treeListRowExpandable                   ,
#endif


-- ** expanded #attr:expanded#
-- | If this row is currently expanded.

#if defined(ENABLE_OVERLOADING)
    TreeListRowExpandedPropertyInfo         ,
#endif
    constructTreeListRowExpanded            ,
    getTreeListRowExpanded                  ,
    setTreeListRowExpanded                  ,
#if defined(ENABLE_OVERLOADING)
    treeListRowExpanded                     ,
#endif


-- ** item #attr:item#
-- | The item held in this row.

#if defined(ENABLE_OVERLOADING)
    TreeListRowItemPropertyInfo             ,
#endif
    getTreeListRowItem                      ,
#if defined(ENABLE_OVERLOADING)
    treeListRowItem                         ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel

#endif

-- | Memory-managed wrapper type.
newtype TreeListRow = TreeListRow (SP.ManagedPtr TreeListRow)
    deriving (Eq)

instance SP.ManagedPtrNewtype TreeListRow where
    toManagedPtr (TreeListRow p) = p

foreign import ccall "gtk_tree_list_row_get_type"
    c_gtk_tree_list_row_get_type :: IO B.Types.GType

instance B.Types.TypedObject TreeListRow where
    glibType = c_gtk_tree_list_row_get_type

instance B.Types.GObject TreeListRow

-- | Type class for types which can be safely cast to t'TreeListRow', for instance with `toTreeListRow`.
class (SP.GObject o, O.IsDescendantOf TreeListRow o) => IsTreeListRow o
instance (SP.GObject o, O.IsDescendantOf TreeListRow o) => IsTreeListRow o

instance O.HasParentTypes TreeListRow
type instance O.ParentTypes TreeListRow = '[GObject.Object.Object]

-- | Cast to t'TreeListRow', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toTreeListRow :: (MIO.MonadIO m, IsTreeListRow o) => o -> m TreeListRow
toTreeListRow = MIO.liftIO . B.ManagedPtr.unsafeCastTo TreeListRow

-- | Convert t'TreeListRow' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TreeListRow) where
    gvalueGType_ = c_gtk_tree_list_row_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TreeListRow)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TreeListRow)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TreeListRow ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveTreeListRowMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTreeListRowMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTreeListRowMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTreeListRowMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTreeListRowMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTreeListRowMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTreeListRowMethod "isExpandable" o = TreeListRowIsExpandableMethodInfo
    ResolveTreeListRowMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTreeListRowMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTreeListRowMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTreeListRowMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTreeListRowMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTreeListRowMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTreeListRowMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTreeListRowMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTreeListRowMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTreeListRowMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTreeListRowMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTreeListRowMethod "getChildRow" o = TreeListRowGetChildRowMethodInfo
    ResolveTreeListRowMethod "getChildren" o = TreeListRowGetChildrenMethodInfo
    ResolveTreeListRowMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTreeListRowMethod "getDepth" o = TreeListRowGetDepthMethodInfo
    ResolveTreeListRowMethod "getExpanded" o = TreeListRowGetExpandedMethodInfo
    ResolveTreeListRowMethod "getItem" o = TreeListRowGetItemMethodInfo
    ResolveTreeListRowMethod "getParent" o = TreeListRowGetParentMethodInfo
    ResolveTreeListRowMethod "getPosition" o = TreeListRowGetPositionMethodInfo
    ResolveTreeListRowMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTreeListRowMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTreeListRowMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTreeListRowMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTreeListRowMethod "setExpanded" o = TreeListRowSetExpandedMethodInfo
    ResolveTreeListRowMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTreeListRowMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTreeListRowMethod t TreeListRow, O.OverloadedMethod info TreeListRow p) => OL.IsLabel t (TreeListRow -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTreeListRowMethod t TreeListRow, O.OverloadedMethod info TreeListRow p, R.HasField t TreeListRow p) => R.HasField t TreeListRow p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTreeListRowMethod t TreeListRow, O.OverloadedMethodInfo info TreeListRow) => OL.IsLabel t (O.MethodProxy info TreeListRow) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "children"
   -- Type: TInterface (Name {namespace = "Gio", name = "ListModel"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@children@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' treeListRow #children
-- @
getTreeListRowChildren :: (MonadIO m, IsTreeListRow o) => o -> m (Maybe Gio.ListModel.ListModel)
getTreeListRowChildren obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "children" Gio.ListModel.ListModel

#if defined(ENABLE_OVERLOADING)
data TreeListRowChildrenPropertyInfo
instance AttrInfo TreeListRowChildrenPropertyInfo where
    type AttrAllowedOps TreeListRowChildrenPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TreeListRowChildrenPropertyInfo = IsTreeListRow
    type AttrSetTypeConstraint TreeListRowChildrenPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TreeListRowChildrenPropertyInfo = (~) ()
    type AttrTransferType TreeListRowChildrenPropertyInfo = ()
    type AttrGetType TreeListRowChildrenPropertyInfo = (Maybe Gio.ListModel.ListModel)
    type AttrLabel TreeListRowChildrenPropertyInfo = "children"
    type AttrOrigin TreeListRowChildrenPropertyInfo = TreeListRow
    attrGet = getTreeListRowChildren
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRow.children"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRow.html#g:attr:children"
        })
#endif

-- VVV Prop "depth"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@depth@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' treeListRow #depth
-- @
getTreeListRowDepth :: (MonadIO m, IsTreeListRow o) => o -> m Word32
getTreeListRowDepth obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "depth"

#if defined(ENABLE_OVERLOADING)
data TreeListRowDepthPropertyInfo
instance AttrInfo TreeListRowDepthPropertyInfo where
    type AttrAllowedOps TreeListRowDepthPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint TreeListRowDepthPropertyInfo = IsTreeListRow
    type AttrSetTypeConstraint TreeListRowDepthPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TreeListRowDepthPropertyInfo = (~) ()
    type AttrTransferType TreeListRowDepthPropertyInfo = ()
    type AttrGetType TreeListRowDepthPropertyInfo = Word32
    type AttrLabel TreeListRowDepthPropertyInfo = "depth"
    type AttrOrigin TreeListRowDepthPropertyInfo = TreeListRow
    attrGet = getTreeListRowDepth
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRow.depth"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRow.html#g:attr:depth"
        })
#endif

-- VVV Prop "expandable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@expandable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' treeListRow #expandable
-- @
getTreeListRowExpandable :: (MonadIO m, IsTreeListRow o) => o -> m Bool
getTreeListRowExpandable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "expandable"

#if defined(ENABLE_OVERLOADING)
data TreeListRowExpandablePropertyInfo
instance AttrInfo TreeListRowExpandablePropertyInfo where
    type AttrAllowedOps TreeListRowExpandablePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint TreeListRowExpandablePropertyInfo = IsTreeListRow
    type AttrSetTypeConstraint TreeListRowExpandablePropertyInfo = (~) ()
    type AttrTransferTypeConstraint TreeListRowExpandablePropertyInfo = (~) ()
    type AttrTransferType TreeListRowExpandablePropertyInfo = ()
    type AttrGetType TreeListRowExpandablePropertyInfo = Bool
    type AttrLabel TreeListRowExpandablePropertyInfo = "expandable"
    type AttrOrigin TreeListRowExpandablePropertyInfo = TreeListRow
    attrGet = getTreeListRowExpandable
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRow.expandable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRow.html#g:attr:expandable"
        })
#endif

-- VVV Prop "expanded"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@expanded@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' treeListRow #expanded
-- @
getTreeListRowExpanded :: (MonadIO m, IsTreeListRow o) => o -> m Bool
getTreeListRowExpanded obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "expanded"

-- | Set the value of the “@expanded@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' treeListRow [ #expanded 'Data.GI.Base.Attributes.:=' value ]
-- @
setTreeListRowExpanded :: (MonadIO m, IsTreeListRow o) => o -> Bool -> m ()
setTreeListRowExpanded obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "expanded" val

-- | Construct a t'GValueConstruct' with valid value for the “@expanded@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTreeListRowExpanded :: (IsTreeListRow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructTreeListRowExpanded val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "expanded" val

#if defined(ENABLE_OVERLOADING)
data TreeListRowExpandedPropertyInfo
instance AttrInfo TreeListRowExpandedPropertyInfo where
    type AttrAllowedOps TreeListRowExpandedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TreeListRowExpandedPropertyInfo = IsTreeListRow
    type AttrSetTypeConstraint TreeListRowExpandedPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint TreeListRowExpandedPropertyInfo = (~) Bool
    type AttrTransferType TreeListRowExpandedPropertyInfo = Bool
    type AttrGetType TreeListRowExpandedPropertyInfo = Bool
    type AttrLabel TreeListRowExpandedPropertyInfo = "expanded"
    type AttrOrigin TreeListRowExpandedPropertyInfo = TreeListRow
    attrGet = getTreeListRowExpanded
    attrSet = setTreeListRowExpanded
    attrTransfer _ v = do
        return v
    attrConstruct = constructTreeListRowExpanded
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRow.expanded"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRow.html#g:attr:expanded"
        })
#endif

-- VVV Prop "item"
   -- Type: TInterface (Name {namespace = "GObject", name = "Object"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@item@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' treeListRow #item
-- @
getTreeListRowItem :: (MonadIO m, IsTreeListRow o) => o -> m (Maybe GObject.Object.Object)
getTreeListRowItem obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "item" GObject.Object.Object

#if defined(ENABLE_OVERLOADING)
data TreeListRowItemPropertyInfo
instance AttrInfo TreeListRowItemPropertyInfo where
    type AttrAllowedOps TreeListRowItemPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TreeListRowItemPropertyInfo = IsTreeListRow
    type AttrSetTypeConstraint TreeListRowItemPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TreeListRowItemPropertyInfo = (~) ()
    type AttrTransferType TreeListRowItemPropertyInfo = ()
    type AttrGetType TreeListRowItemPropertyInfo = (Maybe GObject.Object.Object)
    type AttrLabel TreeListRowItemPropertyInfo = "item"
    type AttrOrigin TreeListRowItemPropertyInfo = TreeListRow
    attrGet = getTreeListRowItem
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRow.item"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRow.html#g:attr:item"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TreeListRow
type instance O.AttributeList TreeListRow = TreeListRowAttributeList
type TreeListRowAttributeList = ('[ '("children", TreeListRowChildrenPropertyInfo), '("depth", TreeListRowDepthPropertyInfo), '("expandable", TreeListRowExpandablePropertyInfo), '("expanded", TreeListRowExpandedPropertyInfo), '("item", TreeListRowItemPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
treeListRowChildren :: AttrLabelProxy "children"
treeListRowChildren = AttrLabelProxy

treeListRowDepth :: AttrLabelProxy "depth"
treeListRowDepth = AttrLabelProxy

treeListRowExpandable :: AttrLabelProxy "expandable"
treeListRowExpandable = AttrLabelProxy

treeListRowExpanded :: AttrLabelProxy "expanded"
treeListRowExpanded = AttrLabelProxy

treeListRowItem :: AttrLabelProxy "item"
treeListRowItem = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TreeListRow = TreeListRowSignalList
type TreeListRowSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method TreeListRow::get_child_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeListRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeListRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "position of the child to get"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "TreeListRow" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_list_row_get_child_row" gtk_tree_list_row_get_child_row :: 
    Ptr TreeListRow ->                      -- self : TInterface (Name {namespace = "Gtk", name = "TreeListRow"})
    Word32 ->                               -- position : TBasicType TUInt
    IO (Ptr TreeListRow)

-- | If /@self@/ is not expanded or /@position@/ is greater than the
-- number of children, 'P.Nothing' is returned.
treeListRowGetChildRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeListRow a) =>
    a
    -- ^ /@self@/: a @GtkTreeListRow@
    -> Word32
    -- ^ /@position@/: position of the child to get
    -> m (Maybe TreeListRow)
    -- ^ __Returns:__ the child in /@position@/
treeListRowGetChildRow self position = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_list_row_get_child_row self' position
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject TreeListRow) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeListRowGetChildRowMethodInfo
instance (signature ~ (Word32 -> m (Maybe TreeListRow)), MonadIO m, IsTreeListRow a) => O.OverloadedMethod TreeListRowGetChildRowMethodInfo a signature where
    overloadedMethod = treeListRowGetChildRow

instance O.OverloadedMethodInfo TreeListRowGetChildRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRow.treeListRowGetChildRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRow.html#v:treeListRowGetChildRow"
        })


#endif

-- method TreeListRow::get_children
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeListRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeListRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_list_row_get_children" gtk_tree_list_row_get_children :: 
    Ptr TreeListRow ->                      -- self : TInterface (Name {namespace = "Gtk", name = "TreeListRow"})
    IO (Ptr Gio.ListModel.ListModel)

-- | If the row is expanded, gets the model holding the children of /@self@/.
-- 
-- This model is the model created by the
-- [callback/@gtk@/.TreeListModelCreateModelFunc]
-- and contains the original items, no matter what value
-- [TreeListModel:passthrough]("GI.Gtk.Objects.TreeListModel#g:attr:passthrough") is set to.
treeListRowGetChildren ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeListRow a) =>
    a
    -- ^ /@self@/: a @GtkTreeListRow@
    -> m (Maybe Gio.ListModel.ListModel)
    -- ^ __Returns:__ The model containing the children
treeListRowGetChildren self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_list_row_get_children self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.ListModel.ListModel) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeListRowGetChildrenMethodInfo
instance (signature ~ (m (Maybe Gio.ListModel.ListModel)), MonadIO m, IsTreeListRow a) => O.OverloadedMethod TreeListRowGetChildrenMethodInfo a signature where
    overloadedMethod = treeListRowGetChildren

instance O.OverloadedMethodInfo TreeListRowGetChildrenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRow.treeListRowGetChildren",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRow.html#v:treeListRowGetChildren"
        })


#endif

-- method TreeListRow::get_depth
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeListRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeListRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_list_row_get_depth" gtk_tree_list_row_get_depth :: 
    Ptr TreeListRow ->                      -- self : TInterface (Name {namespace = "Gtk", name = "TreeListRow"})
    IO Word32

-- | Gets the depth of this row.
-- 
-- Rows that correspond to items in the root model have a depth
-- of zero, rows corresponding to items of models of direct children
-- of the root model have a depth of 1 and so on.
-- 
-- The depth of a row never changes until the row is removed from its model
-- at which point it will forever return 0.
treeListRowGetDepth ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeListRow a) =>
    a
    -- ^ /@self@/: a @GtkTreeListRow@
    -> m Word32
    -- ^ __Returns:__ The depth of this row
treeListRowGetDepth self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_list_row_get_depth self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data TreeListRowGetDepthMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsTreeListRow a) => O.OverloadedMethod TreeListRowGetDepthMethodInfo a signature where
    overloadedMethod = treeListRowGetDepth

instance O.OverloadedMethodInfo TreeListRowGetDepthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRow.treeListRowGetDepth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRow.html#v:treeListRowGetDepth"
        })


#endif

-- method TreeListRow::get_expanded
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeListRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeListRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_list_row_get_expanded" gtk_tree_list_row_get_expanded :: 
    Ptr TreeListRow ->                      -- self : TInterface (Name {namespace = "Gtk", name = "TreeListRow"})
    IO CInt

-- | Gets if a row is currently expanded.
treeListRowGetExpanded ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeListRow a) =>
    a
    -- ^ /@self@/: a @GtkTreeListRow@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the row is expanded
treeListRowGetExpanded self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_list_row_get_expanded self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data TreeListRowGetExpandedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTreeListRow a) => O.OverloadedMethod TreeListRowGetExpandedMethodInfo a signature where
    overloadedMethod = treeListRowGetExpanded

instance O.OverloadedMethodInfo TreeListRowGetExpandedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRow.treeListRowGetExpanded",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRow.html#v:treeListRowGetExpanded"
        })


#endif

-- method TreeListRow::get_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeListRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeListRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GObject" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_list_row_get_item" gtk_tree_list_row_get_item :: 
    Ptr TreeListRow ->                      -- self : TInterface (Name {namespace = "Gtk", name = "TreeListRow"})
    IO (Ptr GObject.Object.Object)

-- | Gets the item corresponding to this row,
treeListRowGetItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeListRow a) =>
    a
    -- ^ /@self@/: a @GtkTreeListRow@
    -> m (Maybe GObject.Object.Object)
    -- ^ __Returns:__ The item
    --   of this row. This function is only marked as nullable for backwards
    --   compatibility reasons.
treeListRowGetItem self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_list_row_get_item self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject GObject.Object.Object) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeListRowGetItemMethodInfo
instance (signature ~ (m (Maybe GObject.Object.Object)), MonadIO m, IsTreeListRow a) => O.OverloadedMethod TreeListRowGetItemMethodInfo a signature where
    overloadedMethod = treeListRowGetItem

instance O.OverloadedMethodInfo TreeListRowGetItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRow.treeListRowGetItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRow.html#v:treeListRowGetItem"
        })


#endif

-- method TreeListRow::get_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeListRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeListRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "TreeListRow" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_list_row_get_parent" gtk_tree_list_row_get_parent :: 
    Ptr TreeListRow ->                      -- self : TInterface (Name {namespace = "Gtk", name = "TreeListRow"})
    IO (Ptr TreeListRow)

-- | Gets the row representing the parent for /@self@/.
-- 
-- That is the row that would need to be collapsed
-- to make this row disappear.
-- 
-- If /@self@/ is a row corresponding to the root model,
-- 'P.Nothing' is returned.
-- 
-- The value returned by this function never changes
-- until the row is removed from its model at which point
-- it will forever return 'P.Nothing'.
treeListRowGetParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeListRow a) =>
    a
    -- ^ /@self@/: a @GtkTreeListRow@
    -> m (Maybe TreeListRow)
    -- ^ __Returns:__ The parent of /@self@/
treeListRowGetParent self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_list_row_get_parent self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject TreeListRow) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeListRowGetParentMethodInfo
instance (signature ~ (m (Maybe TreeListRow)), MonadIO m, IsTreeListRow a) => O.OverloadedMethod TreeListRowGetParentMethodInfo a signature where
    overloadedMethod = treeListRowGetParent

instance O.OverloadedMethodInfo TreeListRowGetParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRow.treeListRowGetParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRow.html#v:treeListRowGetParent"
        })


#endif

-- method TreeListRow::get_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeListRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeListRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_list_row_get_position" gtk_tree_list_row_get_position :: 
    Ptr TreeListRow ->                      -- self : TInterface (Name {namespace = "Gtk", name = "TreeListRow"})
    IO Word32

-- | Returns the position in the @GtkTreeListModel@ that /@self@/ occupies
-- at the moment.
treeListRowGetPosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeListRow a) =>
    a
    -- ^ /@self@/: a @GtkTreeListRow@
    -> m Word32
    -- ^ __Returns:__ The position in the model
treeListRowGetPosition self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_list_row_get_position self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data TreeListRowGetPositionMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsTreeListRow a) => O.OverloadedMethod TreeListRowGetPositionMethodInfo a signature where
    overloadedMethod = treeListRowGetPosition

instance O.OverloadedMethodInfo TreeListRowGetPositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRow.treeListRowGetPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRow.html#v:treeListRowGetPosition"
        })


#endif

-- method TreeListRow::is_expandable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeListRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeListRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_list_row_is_expandable" gtk_tree_list_row_is_expandable :: 
    Ptr TreeListRow ->                      -- self : TInterface (Name {namespace = "Gtk", name = "TreeListRow"})
    IO CInt

-- | Checks if a row can be expanded.
-- 
-- This does not mean that the row is actually expanded,
-- this can be checked with 'GI.Gtk.Objects.TreeListRow.treeListRowGetExpanded'.
-- 
-- If a row is expandable never changes until the row is removed
-- from its model at which point it will forever return 'P.False'.
treeListRowIsExpandable ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeListRow a) =>
    a
    -- ^ /@self@/: a @GtkTreeListRow@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the row is expandable
treeListRowIsExpandable self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_list_row_is_expandable self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data TreeListRowIsExpandableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTreeListRow a) => O.OverloadedMethod TreeListRowIsExpandableMethodInfo a signature where
    overloadedMethod = treeListRowIsExpandable

instance O.OverloadedMethodInfo TreeListRowIsExpandableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRow.treeListRowIsExpandable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRow.html#v:treeListRowIsExpandable"
        })


#endif

-- method TreeListRow::set_expanded
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeListRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeListRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "expanded"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if the row should be expanded"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_list_row_set_expanded" gtk_tree_list_row_set_expanded :: 
    Ptr TreeListRow ->                      -- self : TInterface (Name {namespace = "Gtk", name = "TreeListRow"})
    CInt ->                                 -- expanded : TBasicType TBoolean
    IO ()

-- | Expands or collapses a row.
-- 
-- If a row is expanded, the model of calling the
-- [callback/@gtk@/.TreeListModelCreateModelFunc] for the row\'s
-- item will be inserted after this row. If a row is collapsed,
-- those items will be removed from the model.
-- 
-- If the row is not expandable, this function does nothing.
treeListRowSetExpanded ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeListRow a) =>
    a
    -- ^ /@self@/: a @GtkTreeListRow@
    -> Bool
    -- ^ /@expanded@/: 'P.True' if the row should be expanded
    -> m ()
treeListRowSetExpanded self expanded = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let expanded' = (P.fromIntegral . P.fromEnum) expanded
    gtk_tree_list_row_set_expanded self' expanded'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeListRowSetExpandedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTreeListRow a) => O.OverloadedMethod TreeListRowSetExpandedMethodInfo a signature where
    overloadedMethod = treeListRowSetExpanded

instance O.OverloadedMethodInfo TreeListRowSetExpandedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRow.treeListRowSetExpanded",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRow.html#v:treeListRowSetExpanded"
        })


#endif


