{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Determines whether to include items with a callback.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.CustomFilter
    ( 

-- * Exported types
    CustomFilter(..)                        ,
    IsCustomFilter                          ,
    toCustomFilter                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.Filter#g:method:changed"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [match]("GI.Gtk.Objects.Filter#g:method:match"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStrictness]("GI.Gtk.Objects.Filter#g:method:getStrictness").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setFilterFunc]("GI.Gtk.Objects.CustomFilter#g:method:setFilterFunc"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveCustomFilterMethod               ,
#endif

-- ** new #method:new#

    customFilterNew                         ,


-- ** setFilterFunc #method:setFilterFunc#

#if defined(ENABLE_OVERLOADING)
    CustomFilterSetFilterFuncMethodInfo     ,
#endif
    customFilterSetFilterFunc               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter

#endif

-- | Memory-managed wrapper type.
newtype CustomFilter = CustomFilter (SP.ManagedPtr CustomFilter)
    deriving (Eq)

instance SP.ManagedPtrNewtype CustomFilter where
    toManagedPtr (CustomFilter p) = p

foreign import ccall "gtk_custom_filter_get_type"
    c_gtk_custom_filter_get_type :: IO B.Types.GType

instance B.Types.TypedObject CustomFilter where
    glibType = c_gtk_custom_filter_get_type

instance B.Types.GObject CustomFilter

-- | Type class for types which can be safely cast to t'CustomFilter', for instance with `toCustomFilter`.
class (SP.GObject o, O.IsDescendantOf CustomFilter o) => IsCustomFilter o
instance (SP.GObject o, O.IsDescendantOf CustomFilter o) => IsCustomFilter o

instance O.HasParentTypes CustomFilter
type instance O.ParentTypes CustomFilter = '[Gtk.Filter.Filter, GObject.Object.Object]

-- | Cast to t'CustomFilter', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCustomFilter :: (MIO.MonadIO m, IsCustomFilter o) => o -> m CustomFilter
toCustomFilter = MIO.liftIO . B.ManagedPtr.unsafeCastTo CustomFilter

-- | Convert t'CustomFilter' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe CustomFilter) where
    gvalueGType_ = c_gtk_custom_filter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr CustomFilter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr CustomFilter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject CustomFilter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCustomFilterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCustomFilterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCustomFilterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCustomFilterMethod "changed" o = Gtk.Filter.FilterChangedMethodInfo
    ResolveCustomFilterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCustomFilterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCustomFilterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCustomFilterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCustomFilterMethod "match" o = Gtk.Filter.FilterMatchMethodInfo
    ResolveCustomFilterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCustomFilterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCustomFilterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveCustomFilterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCustomFilterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCustomFilterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCustomFilterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCustomFilterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCustomFilterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveCustomFilterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCustomFilterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCustomFilterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCustomFilterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCustomFilterMethod "getStrictness" o = Gtk.Filter.FilterGetStrictnessMethodInfo
    ResolveCustomFilterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCustomFilterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCustomFilterMethod "setFilterFunc" o = CustomFilterSetFilterFuncMethodInfo
    ResolveCustomFilterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCustomFilterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCustomFilterMethod t CustomFilter, O.OverloadedMethod info CustomFilter p) => OL.IsLabel t (CustomFilter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCustomFilterMethod t CustomFilter, O.OverloadedMethod info CustomFilter p, R.HasField t CustomFilter p) => R.HasField t CustomFilter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCustomFilterMethod t CustomFilter, O.OverloadedMethodInfo info CustomFilter) => OL.IsLabel t (O.MethodProxy info CustomFilter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList CustomFilter
type instance O.AttributeList CustomFilter = CustomFilterAttributeList
type CustomFilterAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList CustomFilter = CustomFilterSignalList
type CustomFilterSignalList = ('[ '("changed", Gtk.Filter.FilterChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method CustomFilter::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "match_func"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CustomFilterFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to filter items"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 1
--           , argDestroy = 2
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @match_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notify for @user_data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "CustomFilter" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_custom_filter_new" gtk_custom_filter_new :: 
    FunPtr Gtk.Callbacks.C_CustomFilterFunc -> -- match_func : TInterface (Name {namespace = "Gtk", name = "CustomFilterFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- user_destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO (Ptr CustomFilter)

-- | Creates a new filter using the given function to filter items.
-- 
-- If /@matchFunc@/ is @NULL@, the filter matches all items.
-- 
-- If the filter func changes its filtering behavior,
-- 'GI.Gtk.Objects.Filter.filterChanged' needs to be called.
customFilterNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Gtk.Callbacks.CustomFilterFunc)
    -- ^ /@matchFunc@/: function to filter items
    -> m CustomFilter
    -- ^ __Returns:__ a new @GtkCustomFilter@
customFilterNew matchFunc = liftIO $ do
    maybeMatchFunc <- case matchFunc of
        Nothing -> return FP.nullFunPtr
        Just jMatchFunc -> do
            jMatchFunc' <- Gtk.Callbacks.mk_CustomFilterFunc (Gtk.Callbacks.wrap_CustomFilterFunc Nothing (Gtk.Callbacks.drop_closures_CustomFilterFunc jMatchFunc))
            return jMatchFunc'
    let userData = castFunPtrToPtr maybeMatchFunc
    let userDestroy = SP.safeFreeFunPtrPtr
    result <- gtk_custom_filter_new maybeMatchFunc userData userDestroy
    checkUnexpectedReturnNULL "customFilterNew" result
    result' <- (wrapObject CustomFilter) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method CustomFilter::set_filter_func
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CustomFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a custom filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "match_func"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CustomFilterFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to filter items"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @match_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notify for @user_data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_custom_filter_set_filter_func" gtk_custom_filter_set_filter_func :: 
    Ptr CustomFilter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "CustomFilter"})
    FunPtr Gtk.Callbacks.C_CustomFilterFunc -> -- match_func : TInterface (Name {namespace = "Gtk", name = "CustomFilterFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- user_destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Sets the function used for filtering items.
-- 
-- If /@matchFunc@/ is @NULL@, the filter matches all items.
-- 
-- If the filter func changes its filtering behavior,
-- 'GI.Gtk.Objects.Filter.filterChanged' needs to be called.
-- 
-- If a previous function was set, its /@userDestroy@/
-- will be called.
customFilterSetFilterFunc ::
    (B.CallStack.HasCallStack, MonadIO m, IsCustomFilter a) =>
    a
    -- ^ /@self@/: a custom filter
    -> Maybe (Gtk.Callbacks.CustomFilterFunc)
    -- ^ /@matchFunc@/: function to filter items
    -> m ()
customFilterSetFilterFunc self matchFunc = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeMatchFunc <- case matchFunc of
        Nothing -> return FP.nullFunPtr
        Just jMatchFunc -> do
            jMatchFunc' <- Gtk.Callbacks.mk_CustomFilterFunc (Gtk.Callbacks.wrap_CustomFilterFunc Nothing (Gtk.Callbacks.drop_closures_CustomFilterFunc jMatchFunc))
            return jMatchFunc'
    let userData = castFunPtrToPtr maybeMatchFunc
    let userDestroy = SP.safeFreeFunPtrPtr
    gtk_custom_filter_set_filter_func self' maybeMatchFunc userData userDestroy
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CustomFilterSetFilterFuncMethodInfo
instance (signature ~ (Maybe (Gtk.Callbacks.CustomFilterFunc) -> m ()), MonadIO m, IsCustomFilter a) => O.OverloadedMethod CustomFilterSetFilterFuncMethodInfo a signature where
    overloadedMethod = customFilterSetFilterFunc

instance O.OverloadedMethodInfo CustomFilterSetFilterFuncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CustomFilter.customFilterSetFilterFunc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CustomFilter.html#v:customFilterSetFilterFunc"
        })


#endif


