{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A GL based renderer.
-- 
-- See t'GI.Gsk.Objects.Renderer.Renderer'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.NglRenderer
    ( 

-- * Exported types
    NglRenderer(..)                         ,
    IsNglRenderer                           ,
    toNglRenderer                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isRealized]("GI.Gsk.Objects.Renderer#g:method:isRealized"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [realize]("GI.Gsk.Objects.Renderer#g:method:realize"), [realizeForDisplay]("GI.Gsk.Objects.Renderer#g:method:realizeForDisplay"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [render]("GI.Gsk.Objects.Renderer#g:method:render"), [renderTexture]("GI.Gsk.Objects.Renderer#g:method:renderTexture"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unrealize]("GI.Gsk.Objects.Renderer#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSurface]("GI.Gsk.Objects.Renderer#g:method:getSurface").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveNglRendererMethod                ,
#endif

-- ** new #method:new#

    nglRendererNew                          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Objects.Renderer as Gsk.Renderer

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gsk.Objects.Renderer as Gsk.Renderer

#endif

-- | Memory-managed wrapper type.
newtype NglRenderer = NglRenderer (SP.ManagedPtr NglRenderer)
    deriving (Eq)

instance SP.ManagedPtrNewtype NglRenderer where
    toManagedPtr (NglRenderer p) = p

foreign import ccall "gsk_ngl_renderer_get_type"
    c_gsk_ngl_renderer_get_type :: IO B.Types.GType

instance B.Types.TypedObject NglRenderer where
    glibType = c_gsk_ngl_renderer_get_type

instance B.Types.GObject NglRenderer

-- | Type class for types which can be safely cast to t'NglRenderer', for instance with `toNglRenderer`.
class (SP.GObject o, O.IsDescendantOf NglRenderer o) => IsNglRenderer o
instance (SP.GObject o, O.IsDescendantOf NglRenderer o) => IsNglRenderer o

instance O.HasParentTypes NglRenderer
type instance O.ParentTypes NglRenderer = '[Gsk.Renderer.Renderer, GObject.Object.Object]

-- | Cast to t'NglRenderer', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toNglRenderer :: (MIO.MonadIO m, IsNglRenderer o) => o -> m NglRenderer
toNglRenderer = MIO.liftIO . B.ManagedPtr.unsafeCastTo NglRenderer

-- | Convert t'NglRenderer' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe NglRenderer) where
    gvalueGType_ = c_gsk_ngl_renderer_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr NglRenderer)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr NglRenderer)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject NglRenderer ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveNglRendererMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveNglRendererMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveNglRendererMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveNglRendererMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveNglRendererMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveNglRendererMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveNglRendererMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveNglRendererMethod "isRealized" o = Gsk.Renderer.RendererIsRealizedMethodInfo
    ResolveNglRendererMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveNglRendererMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveNglRendererMethod "realize" o = Gsk.Renderer.RendererRealizeMethodInfo
    ResolveNglRendererMethod "realizeForDisplay" o = Gsk.Renderer.RendererRealizeForDisplayMethodInfo
    ResolveNglRendererMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveNglRendererMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveNglRendererMethod "render" o = Gsk.Renderer.RendererRenderMethodInfo
    ResolveNglRendererMethod "renderTexture" o = Gsk.Renderer.RendererRenderTextureMethodInfo
    ResolveNglRendererMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveNglRendererMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveNglRendererMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveNglRendererMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveNglRendererMethod "unrealize" o = Gsk.Renderer.RendererUnrealizeMethodInfo
    ResolveNglRendererMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveNglRendererMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveNglRendererMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveNglRendererMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveNglRendererMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveNglRendererMethod "getSurface" o = Gsk.Renderer.RendererGetSurfaceMethodInfo
    ResolveNglRendererMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveNglRendererMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveNglRendererMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveNglRendererMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveNglRendererMethod t NglRenderer, O.OverloadedMethod info NglRenderer p) => OL.IsLabel t (NglRenderer -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveNglRendererMethod t NglRenderer, O.OverloadedMethod info NglRenderer p, R.HasField t NglRenderer p) => R.HasField t NglRenderer p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveNglRendererMethod t NglRenderer, O.OverloadedMethodInfo info NglRenderer) => OL.IsLabel t (O.MethodProxy info NglRenderer) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList NglRenderer
type instance O.AttributeList NglRenderer = NglRendererAttributeList
type NglRendererAttributeList = ('[ '("realized", Gsk.Renderer.RendererRealizedPropertyInfo), '("surface", Gsk.Renderer.RendererSurfacePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList NglRenderer = NglRendererSignalList
type NglRendererSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method NglRenderer::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "NglRenderer" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_ngl_renderer_new" gsk_ngl_renderer_new :: 
    IO (Ptr NglRenderer)

{-# DEPRECATED nglRendererNew ["(Since version 4.18)","Use 'GI.Gsk.Objects.GLRenderer.gLRendererNew'"] #-}
-- | Same as 'GI.Gsk.Objects.GLRenderer.gLRendererNew'.
nglRendererNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m NglRenderer
    -- ^ __Returns:__ a GL renderer
nglRendererNew  = liftIO $ do
    result <- gsk_ngl_renderer_new
    checkUnexpectedReturnNULL "nglRendererNew" result
    result' <- (wrapObject NglRenderer) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


