{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The shadow parameters in a shadow node.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Structs.Shadow
    ( 

-- * Exported types
    Shadow(..)                              ,
    newZeroShadow                           ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveShadowMethod                     ,
#endif



 -- * Properties


-- ** color #attr:color#
-- | the color of the shadow

    getShadowColor                          ,
#if defined(ENABLE_OVERLOADING)
    shadow_color                            ,
#endif


-- ** dx #attr:dx#
-- | the horizontal offset of the shadow

    getShadowDx                             ,
    setShadowDx                             ,
#if defined(ENABLE_OVERLOADING)
    shadow_dx                               ,
#endif


-- ** dy #attr:dy#
-- | the vertical offset of the shadow

    getShadowDy                             ,
    setShadowDy                             ,
#if defined(ENABLE_OVERLOADING)
    shadow_dy                               ,
#endif


-- ** radius #attr:radius#
-- | the radius of the shadow

    getShadowRadius                         ,
    setShadowRadius                         ,
#if defined(ENABLE_OVERLOADING)
    shadow_radius                           ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA

#else
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA

#endif

-- | Memory-managed wrapper type.
newtype Shadow = Shadow (SP.ManagedPtr Shadow)
    deriving (Eq)

instance SP.ManagedPtrNewtype Shadow where
    toManagedPtr (Shadow p) = p

instance BoxedPtr Shadow where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 28 >=> B.ManagedPtr.wrapPtr Shadow)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr Shadow where
    boxedPtrCalloc = callocBytes 28


-- | Construct a t'Shadow' struct initialized to zero.
newZeroShadow :: MonadIO m => m Shadow
newZeroShadow = liftIO $ boxedPtrCalloc >>= wrapPtr Shadow

instance tag ~ 'AttrSet => Constructible Shadow tag where
    new _ attrs = do
        o <- newZeroShadow
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@color@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shadow #color
-- @
getShadowColor :: MonadIO m => Shadow -> m Gdk.RGBA.RGBA
getShadowColor s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.RGBA.RGBA)
    val' <- (newBoxed Gdk.RGBA.RGBA) val
    return val'

#if defined(ENABLE_OVERLOADING)
data ShadowColorFieldInfo
instance AttrInfo ShadowColorFieldInfo where
    type AttrBaseTypeConstraint ShadowColorFieldInfo = (~) Shadow
    type AttrAllowedOps ShadowColorFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint ShadowColorFieldInfo = (~) (Ptr Gdk.RGBA.RGBA)
    type AttrTransferTypeConstraint ShadowColorFieldInfo = (~)(Ptr Gdk.RGBA.RGBA)
    type AttrTransferType ShadowColorFieldInfo = (Ptr Gdk.RGBA.RGBA)
    type AttrGetType ShadowColorFieldInfo = Gdk.RGBA.RGBA
    type AttrLabel ShadowColorFieldInfo = "color"
    type AttrOrigin ShadowColorFieldInfo = Shadow
    attrGet = getShadowColor
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Shadow.color"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Shadow.html#g:attr:color"
        })

shadow_color :: AttrLabelProxy "color"
shadow_color = AttrLabelProxy

#endif


-- | Get the value of the “@dx@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shadow #dx
-- @
getShadowDx :: MonadIO m => Shadow -> m Float
getShadowDx s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@dx@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shadow [ #dx 'Data.GI.Base.Attributes.:=' value ]
-- @
setShadowDx :: MonadIO m => Shadow -> Float -> m ()
setShadowDx s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 16) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data ShadowDxFieldInfo
instance AttrInfo ShadowDxFieldInfo where
    type AttrBaseTypeConstraint ShadowDxFieldInfo = (~) Shadow
    type AttrAllowedOps ShadowDxFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ShadowDxFieldInfo = (~) Float
    type AttrTransferTypeConstraint ShadowDxFieldInfo = (~)Float
    type AttrTransferType ShadowDxFieldInfo = Float
    type AttrGetType ShadowDxFieldInfo = Float
    type AttrLabel ShadowDxFieldInfo = "dx"
    type AttrOrigin ShadowDxFieldInfo = Shadow
    attrGet = getShadowDx
    attrSet = setShadowDx
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Shadow.dx"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Shadow.html#g:attr:dx"
        })

shadow_dx :: AttrLabelProxy "dx"
shadow_dx = AttrLabelProxy

#endif


-- | Get the value of the “@dy@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shadow #dy
-- @
getShadowDy :: MonadIO m => Shadow -> m Float
getShadowDy s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@dy@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shadow [ #dy 'Data.GI.Base.Attributes.:=' value ]
-- @
setShadowDy :: MonadIO m => Shadow -> Float -> m ()
setShadowDy s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 20) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data ShadowDyFieldInfo
instance AttrInfo ShadowDyFieldInfo where
    type AttrBaseTypeConstraint ShadowDyFieldInfo = (~) Shadow
    type AttrAllowedOps ShadowDyFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ShadowDyFieldInfo = (~) Float
    type AttrTransferTypeConstraint ShadowDyFieldInfo = (~)Float
    type AttrTransferType ShadowDyFieldInfo = Float
    type AttrGetType ShadowDyFieldInfo = Float
    type AttrLabel ShadowDyFieldInfo = "dy"
    type AttrOrigin ShadowDyFieldInfo = Shadow
    attrGet = getShadowDy
    attrSet = setShadowDy
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Shadow.dy"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Shadow.html#g:attr:dy"
        })

shadow_dy :: AttrLabelProxy "dy"
shadow_dy = AttrLabelProxy

#endif


-- | Get the value of the “@radius@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shadow #radius
-- @
getShadowRadius :: MonadIO m => Shadow -> m Float
getShadowRadius s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@radius@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shadow [ #radius 'Data.GI.Base.Attributes.:=' value ]
-- @
setShadowRadius :: MonadIO m => Shadow -> Float -> m ()
setShadowRadius s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 24) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data ShadowRadiusFieldInfo
instance AttrInfo ShadowRadiusFieldInfo where
    type AttrBaseTypeConstraint ShadowRadiusFieldInfo = (~) Shadow
    type AttrAllowedOps ShadowRadiusFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ShadowRadiusFieldInfo = (~) Float
    type AttrTransferTypeConstraint ShadowRadiusFieldInfo = (~)Float
    type AttrTransferType ShadowRadiusFieldInfo = Float
    type AttrGetType ShadowRadiusFieldInfo = Float
    type AttrLabel ShadowRadiusFieldInfo = "radius"
    type AttrOrigin ShadowRadiusFieldInfo = Shadow
    attrGet = getShadowRadius
    attrSet = setShadowRadius
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.Shadow.radius"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-Shadow.html#g:attr:radius"
        })

shadow_radius :: AttrLabelProxy "radius"
shadow_radius = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Shadow
type instance O.AttributeList Shadow = ShadowAttributeList
type ShadowAttributeList = ('[ '("color", ShadowColorFieldInfo), '("dx", ShadowDxFieldInfo), '("dy", ShadowDyFieldInfo), '("radius", ShadowRadiusFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveShadowMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveShadowMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveShadowMethod t Shadow, O.OverloadedMethod info Shadow p) => OL.IsLabel t (Shadow -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveShadowMethod t Shadow, O.OverloadedMethod info Shadow p, R.HasField t Shadow p) => R.HasField t Shadow p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveShadowMethod t Shadow, O.OverloadedMethodInfo info Shadow) => OL.IsLabel t (O.MethodProxy info Shadow) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


