

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Enums
    ( 

 -- * Enumerations


-- ** BlendMode #enum:BlendMode#

    BlendMode(..)                           ,


-- ** Corner #enum:Corner#

    Corner(..)                              ,


-- ** FillRule #enum:FillRule#

    FillRule(..)                            ,


-- ** GLUniformType #enum:GLUniformType#

    GLUniformType(..)                       ,


-- ** LineCap #enum:LineCap#

    LineCap(..)                             ,


-- ** LineJoin #enum:LineJoin#

    LineJoin(..)                            ,


-- ** MaskMode #enum:MaskMode#

    MaskMode(..)                            ,


-- ** PathDirection #enum:PathDirection#

    PathDirection(..)                       ,


-- ** PathIntersection #enum:PathIntersection#

    PathIntersection(..)                    ,


-- ** PathOperation #enum:PathOperation#

    PathOperation(..)                       ,


-- ** RenderNodeType #enum:RenderNodeType#

    RenderNodeType(..)                      ,


-- ** ScalingFilter #enum:ScalingFilter#

    ScalingFilter(..)                       ,


-- ** SerializationError #enum:SerializationError#

    SerializationError(..)                  ,
    catchSerializationError                 ,
    handleSerializationError                ,


-- ** TransformCategory #enum:TransformCategory#

    TransformCategory(..)                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Enum TransformCategory
-- | The categories of matrices relevant for GSK and GTK.
-- 
-- Note that any category includes matrices of all later categories.
-- So if you want to for example check if a matrix is a 2D matrix,
-- @category >= GSK_TRANSFORM_CATEGORY_2D@ is the way to do this.
-- 
-- Also keep in mind that rounding errors may cause matrices to not
-- conform to their categories. Otherwise, matrix operations done via
-- multiplication will not worsen categories. So for the matrix
-- multiplication @C = A * B@, @category(C) = MIN (category(A), category(B))@.
data TransformCategory = 
      TransformCategoryUnknown
    -- ^ The category of the matrix has not been
    --   determined.
    | TransformCategoryAny
    -- ^ Analyzing the matrix concluded that it does
    --   not fit in any other category.
    | TransformCategory3d
    -- ^ The matrix is a 3D matrix. This means that
    --   the w column (the last column) has the values (0, 0, 0, 1).
    | TransformCategory2d
    -- ^ The matrix is a 2D matrix. This is equivalent
    --   to 'GI.Graphene.Structs.Matrix.matrixIs2d' returning 'P.True'. In particular, this
    --   means that Cairo can deal with the matrix.
    | TransformCategory2dAffine
    -- ^ The matrix is a combination of 2D scale
    --   and 2D translation operations. In particular, this means that any
    --   rectangle can be transformed exactly using this matrix.
    | TransformCategory2dTranslate
    -- ^ The matrix is a 2D translation.
    | TransformCategoryIdentity
    -- ^ The matrix is the identity matrix.
    | AnotherTransformCategory Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TransformCategory where
    fromEnum TransformCategoryUnknown = 0
    fromEnum TransformCategoryAny = 1
    fromEnum TransformCategory3d = 2
    fromEnum TransformCategory2d = 3
    fromEnum TransformCategory2dAffine = 4
    fromEnum TransformCategory2dTranslate = 5
    fromEnum TransformCategoryIdentity = 6
    fromEnum (AnotherTransformCategory k) = k

    toEnum 0 = TransformCategoryUnknown
    toEnum 1 = TransformCategoryAny
    toEnum 2 = TransformCategory3d
    toEnum 3 = TransformCategory2d
    toEnum 4 = TransformCategory2dAffine
    toEnum 5 = TransformCategory2dTranslate
    toEnum 6 = TransformCategoryIdentity
    toEnum k = AnotherTransformCategory k

instance P.Ord TransformCategory where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TransformCategory = '[]
instance O.HasParentTypes TransformCategory

foreign import ccall "gsk_transform_category_get_type" c_gsk_transform_category_get_type :: 
    IO GType

instance B.Types.TypedObject TransformCategory where
    glibType = c_gsk_transform_category_get_type

instance B.Types.BoxedEnum TransformCategory

-- Enum SerializationError
-- | Errors that can happen during (de)serialization.
data SerializationError = 
      SerializationErrorUnsupportedFormat
    -- ^ The format can not be identified
    | SerializationErrorUnsupportedVersion
    -- ^ The version of the data is not
    --   understood
    | SerializationErrorInvalidData
    -- ^ The given data may not exist in
    --   a proper serialization
    | AnotherSerializationError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SerializationError where
    fromEnum SerializationErrorUnsupportedFormat = 0
    fromEnum SerializationErrorUnsupportedVersion = 1
    fromEnum SerializationErrorInvalidData = 2
    fromEnum (AnotherSerializationError k) = k

    toEnum 0 = SerializationErrorUnsupportedFormat
    toEnum 1 = SerializationErrorUnsupportedVersion
    toEnum 2 = SerializationErrorInvalidData
    toEnum k = AnotherSerializationError k

instance P.Ord SerializationError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass SerializationError where
    gerrorClassDomain _ = "gsk-serialization-error-quark"

-- | Catch exceptions of type `SerializationError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchSerializationError ::
    IO a ->
    (SerializationError -> GErrorMessage -> IO a) ->
    IO a
catchSerializationError = catchGErrorJustDomain

-- | Handle exceptions of type `SerializationError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleSerializationError ::
    (SerializationError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleSerializationError = handleGErrorJustDomain

type instance O.ParentTypes SerializationError = '[]
instance O.HasParentTypes SerializationError

foreign import ccall "gsk_serialization_error_get_type" c_gsk_serialization_error_get_type :: 
    IO GType

instance B.Types.TypedObject SerializationError where
    glibType = c_gsk_serialization_error_get_type

instance B.Types.BoxedEnum SerializationError

-- Enum ScalingFilter
-- | The filters used when scaling texture data.
-- 
-- The actual implementation of each filter is deferred to the
-- rendering pipeline.
data ScalingFilter = 
      ScalingFilterLinear
    -- ^ linear interpolation filter
    | ScalingFilterNearest
    -- ^ nearest neighbor interpolation filter
    | ScalingFilterTrilinear
    -- ^ linear interpolation along each axis,
    --   plus mipmap generation, with linear interpolation along the mipmap
    --   levels
    | AnotherScalingFilter Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ScalingFilter where
    fromEnum ScalingFilterLinear = 0
    fromEnum ScalingFilterNearest = 1
    fromEnum ScalingFilterTrilinear = 2
    fromEnum (AnotherScalingFilter k) = k

    toEnum 0 = ScalingFilterLinear
    toEnum 1 = ScalingFilterNearest
    toEnum 2 = ScalingFilterTrilinear
    toEnum k = AnotherScalingFilter k

instance P.Ord ScalingFilter where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ScalingFilter = '[]
instance O.HasParentTypes ScalingFilter

foreign import ccall "gsk_scaling_filter_get_type" c_gsk_scaling_filter_get_type :: 
    IO GType

instance B.Types.TypedObject ScalingFilter where
    glibType = c_gsk_scaling_filter_get_type

instance B.Types.BoxedEnum ScalingFilter

-- Enum RenderNodeType
-- | The type of a node determines what the node is rendering.
data RenderNodeType = 
      RenderNodeTypeNotARenderNode
    -- ^ Error type. No node will ever have this type.
    | RenderNodeTypeContainerNode
    -- ^ A node containing a stack of children
    | RenderNodeTypeCairoNode
    -- ^ A node drawing a @cairo_surface_t@
    | RenderNodeTypeColorNode
    -- ^ A node drawing a single color rectangle
    | RenderNodeTypeLinearGradientNode
    -- ^ A node drawing a linear gradient
    | RenderNodeTypeRepeatingLinearGradientNode
    -- ^ A node drawing a repeating linear gradient
    | RenderNodeTypeRadialGradientNode
    -- ^ A node drawing a radial gradient
    | RenderNodeTypeRepeatingRadialGradientNode
    -- ^ A node drawing a repeating radial gradient
    | RenderNodeTypeConicGradientNode
    -- ^ A node drawing a conic gradient
    | RenderNodeTypeBorderNode
    -- ^ A node stroking a border around an area
    | RenderNodeTypeTextureNode
    -- ^ A node drawing a @GdkTexture@
    | RenderNodeTypeInsetShadowNode
    -- ^ A node drawing an inset shadow
    | RenderNodeTypeOutsetShadowNode
    -- ^ A node drawing an outset shadow
    | RenderNodeTypeTransformNode
    -- ^ A node that renders its child after applying a matrix transform
    | RenderNodeTypeOpacityNode
    -- ^ A node that changes the opacity of its child
    | RenderNodeTypeColorMatrixNode
    -- ^ A node that applies a color matrix to every pixel
    | RenderNodeTypeRepeatNode
    -- ^ A node that repeats the child\'s contents
    | RenderNodeTypeClipNode
    -- ^ A node that clips its child to a rectangular area
    | RenderNodeTypeRoundedClipNode
    -- ^ A node that clips its child to a rounded rectangle
    | RenderNodeTypeShadowNode
    -- ^ A node that draws a shadow below its child
    | RenderNodeTypeBlendNode
    -- ^ A node that blends two children together
    | RenderNodeTypeCrossFadeNode
    -- ^ A node that cross-fades between two children
    | RenderNodeTypeTextNode
    -- ^ A node containing a glyph string
    | RenderNodeTypeBlurNode
    -- ^ A node that applies a blur
    | RenderNodeTypeDebugNode
    -- ^ Debug information that does not affect the rendering
    | RenderNodeTypeGlShaderNode
    -- ^ A node that uses OpenGL fragment shaders to render
    | RenderNodeTypeTextureScaleNode
    -- ^ A node drawing a @GdkTexture@ scaled and filtered.
    -- 
    -- /Since: 4.10/
    | RenderNodeTypeMaskNode
    -- ^ A node that masks one child with another.
    -- 
    -- /Since: 4.10/
    | RenderNodeTypeFillNode
    -- ^ A node that fills a path.
    -- 
    -- /Since: 4.14/
    | RenderNodeTypeStrokeNode
    -- ^ A node that strokes a path.
    -- 
    -- /Since: 4.14/
    | RenderNodeTypeSubsurfaceNode
    -- ^ A node that possibly redirects part of the scene graph to a subsurface.
    -- 
    -- /Since: 4.14/
    | RenderNodeTypeComponentTransferNode
    -- ^ A node that applies some function to each color component.
    -- 
    -- /Since: 4.20/
    | AnotherRenderNodeType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum RenderNodeType where
    fromEnum RenderNodeTypeNotARenderNode = 0
    fromEnum RenderNodeTypeContainerNode = 1
    fromEnum RenderNodeTypeCairoNode = 2
    fromEnum RenderNodeTypeColorNode = 3
    fromEnum RenderNodeTypeLinearGradientNode = 4
    fromEnum RenderNodeTypeRepeatingLinearGradientNode = 5
    fromEnum RenderNodeTypeRadialGradientNode = 6
    fromEnum RenderNodeTypeRepeatingRadialGradientNode = 7
    fromEnum RenderNodeTypeConicGradientNode = 8
    fromEnum RenderNodeTypeBorderNode = 9
    fromEnum RenderNodeTypeTextureNode = 10
    fromEnum RenderNodeTypeInsetShadowNode = 11
    fromEnum RenderNodeTypeOutsetShadowNode = 12
    fromEnum RenderNodeTypeTransformNode = 13
    fromEnum RenderNodeTypeOpacityNode = 14
    fromEnum RenderNodeTypeColorMatrixNode = 15
    fromEnum RenderNodeTypeRepeatNode = 16
    fromEnum RenderNodeTypeClipNode = 17
    fromEnum RenderNodeTypeRoundedClipNode = 18
    fromEnum RenderNodeTypeShadowNode = 19
    fromEnum RenderNodeTypeBlendNode = 20
    fromEnum RenderNodeTypeCrossFadeNode = 21
    fromEnum RenderNodeTypeTextNode = 22
    fromEnum RenderNodeTypeBlurNode = 23
    fromEnum RenderNodeTypeDebugNode = 24
    fromEnum RenderNodeTypeGlShaderNode = 25
    fromEnum RenderNodeTypeTextureScaleNode = 26
    fromEnum RenderNodeTypeMaskNode = 27
    fromEnum RenderNodeTypeFillNode = 28
    fromEnum RenderNodeTypeStrokeNode = 29
    fromEnum RenderNodeTypeSubsurfaceNode = 30
    fromEnum RenderNodeTypeComponentTransferNode = 31
    fromEnum (AnotherRenderNodeType k) = k

    toEnum 0 = RenderNodeTypeNotARenderNode
    toEnum 1 = RenderNodeTypeContainerNode
    toEnum 2 = RenderNodeTypeCairoNode
    toEnum 3 = RenderNodeTypeColorNode
    toEnum 4 = RenderNodeTypeLinearGradientNode
    toEnum 5 = RenderNodeTypeRepeatingLinearGradientNode
    toEnum 6 = RenderNodeTypeRadialGradientNode
    toEnum 7 = RenderNodeTypeRepeatingRadialGradientNode
    toEnum 8 = RenderNodeTypeConicGradientNode
    toEnum 9 = RenderNodeTypeBorderNode
    toEnum 10 = RenderNodeTypeTextureNode
    toEnum 11 = RenderNodeTypeInsetShadowNode
    toEnum 12 = RenderNodeTypeOutsetShadowNode
    toEnum 13 = RenderNodeTypeTransformNode
    toEnum 14 = RenderNodeTypeOpacityNode
    toEnum 15 = RenderNodeTypeColorMatrixNode
    toEnum 16 = RenderNodeTypeRepeatNode
    toEnum 17 = RenderNodeTypeClipNode
    toEnum 18 = RenderNodeTypeRoundedClipNode
    toEnum 19 = RenderNodeTypeShadowNode
    toEnum 20 = RenderNodeTypeBlendNode
    toEnum 21 = RenderNodeTypeCrossFadeNode
    toEnum 22 = RenderNodeTypeTextNode
    toEnum 23 = RenderNodeTypeBlurNode
    toEnum 24 = RenderNodeTypeDebugNode
    toEnum 25 = RenderNodeTypeGlShaderNode
    toEnum 26 = RenderNodeTypeTextureScaleNode
    toEnum 27 = RenderNodeTypeMaskNode
    toEnum 28 = RenderNodeTypeFillNode
    toEnum 29 = RenderNodeTypeStrokeNode
    toEnum 30 = RenderNodeTypeSubsurfaceNode
    toEnum 31 = RenderNodeTypeComponentTransferNode
    toEnum k = AnotherRenderNodeType k

instance P.Ord RenderNodeType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes RenderNodeType = '[]
instance O.HasParentTypes RenderNodeType

foreign import ccall "gsk_render_node_type_get_type" c_gsk_render_node_type_get_type :: 
    IO GType

instance B.Types.TypedObject RenderNodeType where
    glibType = c_gsk_render_node_type_get_type

instance B.Types.BoxedEnum RenderNodeType

-- Enum PathOperation
-- | Describes the segments of a @GskPath@.
-- 
-- More values may be added in the future.
-- 
-- /Since: 4.14/
data PathOperation = 
      PathOperationMove
    -- ^ A move-to operation, with 1 point describing the target point.
    | PathOperationClose
    -- ^ A close operation ending the current contour with a line back
    --   to the starting point. Two points describe the start and end of the line.
    | PathOperationLine
    -- ^ A line-to operation, with 2 points describing the start and
    --   end point of a straight line.
    | PathOperationQuad
    -- ^ A curve-to operation describing a quadratic Bézier curve
    --   with 3 points describing the start point, the control point and the end
    --   point of the curve.
    | PathOperationCubic
    -- ^ A curve-to operation describing a cubic Bézier curve with 4
    --   points describing the start point, the two control points and the end point
    --   of the curve.
    | PathOperationConic
    -- ^ A rational quadratic Bézier curve with 3 points describing
    --   the start point, control point and end point of the curve. A weight for the
    --   curve will be passed, too.
    | AnotherPathOperation Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PathOperation where
    fromEnum PathOperationMove = 0
    fromEnum PathOperationClose = 1
    fromEnum PathOperationLine = 2
    fromEnum PathOperationQuad = 3
    fromEnum PathOperationCubic = 4
    fromEnum PathOperationConic = 5
    fromEnum (AnotherPathOperation k) = k

    toEnum 0 = PathOperationMove
    toEnum 1 = PathOperationClose
    toEnum 2 = PathOperationLine
    toEnum 3 = PathOperationQuad
    toEnum 4 = PathOperationCubic
    toEnum 5 = PathOperationConic
    toEnum k = AnotherPathOperation k

instance P.Ord PathOperation where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PathOperation = '[]
instance O.HasParentTypes PathOperation

foreign import ccall "gsk_path_operation_get_type" c_gsk_path_operation_get_type :: 
    IO GType

instance B.Types.TypedObject PathOperation where
    glibType = c_gsk_path_operation_get_type

instance B.Types.BoxedEnum PathOperation

-- Enum PathIntersection
-- | The values of this enumeration classify intersections
-- between paths.
-- 
-- /Since: 4.20/
data PathIntersection = 
      PathIntersectionNone
    -- ^ No intersection
    | PathIntersectionNormal
    -- ^ A normal intersection, where the two paths
    --   cross each other
    | PathIntersectionStart
    -- ^ The start of a segment where the two paths coincide
    | PathIntersectionEnd
    -- ^ The end of a segment where the two paths coincide
    | AnotherPathIntersection Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PathIntersection where
    fromEnum PathIntersectionNone = 0
    fromEnum PathIntersectionNormal = 1
    fromEnum PathIntersectionStart = 2
    fromEnum PathIntersectionEnd = 3
    fromEnum (AnotherPathIntersection k) = k

    toEnum 0 = PathIntersectionNone
    toEnum 1 = PathIntersectionNormal
    toEnum 2 = PathIntersectionStart
    toEnum 3 = PathIntersectionEnd
    toEnum k = AnotherPathIntersection k

instance P.Ord PathIntersection where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PathIntersection = '[]
instance O.HasParentTypes PathIntersection

foreign import ccall "gsk_path_intersection_get_type" c_gsk_path_intersection_get_type :: 
    IO GType

instance B.Types.TypedObject PathIntersection where
    glibType = c_gsk_path_intersection_get_type

instance B.Types.BoxedEnum PathIntersection

-- Enum PathDirection
-- | Used to pick one of the four tangents at a given point on the path.
-- 
-- Note that the directions for /@gSKPATHFROMSTART@/\//@gSKPATHTOEND@/ and
-- /@gSKPATHTOSTART@/\//@gSKPATHFROMEND@/ will coincide for smooth points.
-- Only sharp turns will exhibit four different directions.
-- 
-- \<picture>
--   \<source srcset=\"directions-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"Path Tangents\" src=\"directions-light.png\">
-- \<\/picture>
-- 
-- /Since: 4.14/
data PathDirection = 
      PathDirectionFromStart
    -- ^ The tangent in path direction of the incoming side
    --   of the path
    | PathDirectionToStart
    -- ^ The tangent against path direction of the incoming side
    --   of the path
    | PathDirectionToEnd
    -- ^ The tangent in path direction of the outgoing side
    --   of the path
    | PathDirectionFromEnd
    -- ^ The tangent against path direction of the outgoing
    --   side of the path
    | AnotherPathDirection Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PathDirection where
    fromEnum PathDirectionFromStart = 0
    fromEnum PathDirectionToStart = 1
    fromEnum PathDirectionToEnd = 2
    fromEnum PathDirectionFromEnd = 3
    fromEnum (AnotherPathDirection k) = k

    toEnum 0 = PathDirectionFromStart
    toEnum 1 = PathDirectionToStart
    toEnum 2 = PathDirectionToEnd
    toEnum 3 = PathDirectionFromEnd
    toEnum k = AnotherPathDirection k

instance P.Ord PathDirection where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PathDirection = '[]
instance O.HasParentTypes PathDirection

foreign import ccall "gsk_path_direction_get_type" c_gsk_path_direction_get_type :: 
    IO GType

instance B.Types.TypedObject PathDirection where
    glibType = c_gsk_path_direction_get_type

instance B.Types.BoxedEnum PathDirection

-- Enum MaskMode
-- | The mask modes available for mask nodes.
-- 
-- /Since: 4.10/
data MaskMode = 
      MaskModeAlpha
    -- ^ Use the alpha channel of the mask
    | MaskModeInvertedAlpha
    -- ^ Use the inverted alpha channel of the mask
    | MaskModeLuminance
    -- ^ Use the luminance of the mask,
    --     multiplied by mask alpha
    | MaskModeInvertedLuminance
    -- ^ Use the inverted luminance of the mask,
    --     multiplied by mask alpha
    | AnotherMaskMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum MaskMode where
    fromEnum MaskModeAlpha = 0
    fromEnum MaskModeInvertedAlpha = 1
    fromEnum MaskModeLuminance = 2
    fromEnum MaskModeInvertedLuminance = 3
    fromEnum (AnotherMaskMode k) = k

    toEnum 0 = MaskModeAlpha
    toEnum 1 = MaskModeInvertedAlpha
    toEnum 2 = MaskModeLuminance
    toEnum 3 = MaskModeInvertedLuminance
    toEnum k = AnotherMaskMode k

instance P.Ord MaskMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes MaskMode = '[]
instance O.HasParentTypes MaskMode

foreign import ccall "gsk_mask_mode_get_type" c_gsk_mask_mode_get_type :: 
    IO GType

instance B.Types.TypedObject MaskMode where
    glibType = c_gsk_mask_mode_get_type

instance B.Types.BoxedEnum MaskMode

-- Enum LineJoin
-- | Specifies how to render the junction of two lines when stroking.
-- 
-- The default line join style is @GSK_LINE_JOIN_MITER@.
-- 
-- New entries may be added in future versions.
-- 
-- \<figure>
--   \<picture>
--     \<source srcset=\"join-dark.png\" media=\"(prefers-color-scheme: dark)\">
--     \<img alt=\"Line Join Styles\" src=\"join-light.png\">
--   \<\/picture>
--   \<figcaption>GSK_LINE_JOINT_MITER, GSK_LINE_JOINT_ROUND, GSK_LINE_JOIN_BEVEL\<\/figcaption>
-- \<\/figure>
-- 
-- /Since: 4.14/
data LineJoin = 
      LineJoinMiter
    -- ^ Use a sharp angled corner
    | LineJoinRound
    -- ^ Use a round join, the center of the circle is
    --   the join point
    | LineJoinBevel
    -- ^ use a cut-off join, the join is cut off at half
    --   the line width from the joint point
    | AnotherLineJoin Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum LineJoin where
    fromEnum LineJoinMiter = 0
    fromEnum LineJoinRound = 1
    fromEnum LineJoinBevel = 2
    fromEnum (AnotherLineJoin k) = k

    toEnum 0 = LineJoinMiter
    toEnum 1 = LineJoinRound
    toEnum 2 = LineJoinBevel
    toEnum k = AnotherLineJoin k

instance P.Ord LineJoin where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes LineJoin = '[]
instance O.HasParentTypes LineJoin

foreign import ccall "gsk_line_join_get_type" c_gsk_line_join_get_type :: 
    IO GType

instance B.Types.TypedObject LineJoin where
    glibType = c_gsk_line_join_get_type

instance B.Types.BoxedEnum LineJoin

-- Enum LineCap
-- | Specifies how to render the start and end points of contours or
-- dashes when stroking.
-- 
-- The default line cap style is @GSK_LINE_CAP_BUTT@.
-- 
-- New entries may be added in future versions.
-- 
-- \<figure>
--   \<picture>
--     \<source srcset=\"caps-dark.png\" media=\"(prefers-color-scheme: dark)\">
--     \<img alt=\"Line Cap Styles\" src=\"caps-light.png\">
--   \<\/picture>
--   \<figcaption>GSK_LINE_CAP_BUTT, GSK_LINE_CAP_ROUND, GSK_LINE_CAP_SQUARE\<\/figcaption>
-- \<\/figure>
-- 
-- /Since: 4.14/
data LineCap = 
      LineCapButt
    -- ^ Start and stop the line exactly at the start
    --   and end point
    | LineCapRound
    -- ^ Use a round ending, the center of the circle
    --   is the start or end point
    | LineCapSquare
    -- ^ use squared ending, the center of the square
    --   is the start or end point
    | AnotherLineCap Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum LineCap where
    fromEnum LineCapButt = 0
    fromEnum LineCapRound = 1
    fromEnum LineCapSquare = 2
    fromEnum (AnotherLineCap k) = k

    toEnum 0 = LineCapButt
    toEnum 1 = LineCapRound
    toEnum 2 = LineCapSquare
    toEnum k = AnotherLineCap k

instance P.Ord LineCap where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes LineCap = '[]
instance O.HasParentTypes LineCap

foreign import ccall "gsk_line_cap_get_type" c_gsk_line_cap_get_type :: 
    IO GType

instance B.Types.TypedObject LineCap where
    glibType = c_gsk_line_cap_get_type

instance B.Types.BoxedEnum LineCap

-- Enum GLUniformType
{-# DEPRECATED GLUniformType ["(Since version 4.16)"] #-}
-- | Defines the types of the uniforms that @GskGLShaders@ declare.
-- 
-- It defines both what the type is called in the GLSL shader
-- code, and what the corresponding C type is on the Gtk side.
data GLUniformType = 
      GLUniformTypeNone
    -- ^ No type, used for uninitialized or unspecified values.
    | GLUniformTypeFloat
    -- ^ A float uniform
    | GLUniformTypeInt
    -- ^ A GLSL int \/ gint32 uniform
    | GLUniformTypeUint
    -- ^ A GLSL uint \/ guint32 uniform
    | GLUniformTypeBool
    -- ^ A GLSL bool \/ gboolean uniform
    | GLUniformTypeVec2
    -- ^ A GLSL vec2 \/ graphene_vec2_t uniform
    | GLUniformTypeVec3
    -- ^ A GLSL vec3 \/ graphene_vec3_t uniform
    | GLUniformTypeVec4
    -- ^ A GLSL vec4 \/ graphene_vec4_t uniform
    | AnotherGLUniformType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum GLUniformType where
    fromEnum GLUniformTypeNone = 0
    fromEnum GLUniformTypeFloat = 1
    fromEnum GLUniformTypeInt = 2
    fromEnum GLUniformTypeUint = 3
    fromEnum GLUniformTypeBool = 4
    fromEnum GLUniformTypeVec2 = 5
    fromEnum GLUniformTypeVec3 = 6
    fromEnum GLUniformTypeVec4 = 7
    fromEnum (AnotherGLUniformType k) = k

    toEnum 0 = GLUniformTypeNone
    toEnum 1 = GLUniformTypeFloat
    toEnum 2 = GLUniformTypeInt
    toEnum 3 = GLUniformTypeUint
    toEnum 4 = GLUniformTypeBool
    toEnum 5 = GLUniformTypeVec2
    toEnum 6 = GLUniformTypeVec3
    toEnum 7 = GLUniformTypeVec4
    toEnum k = AnotherGLUniformType k

instance P.Ord GLUniformType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes GLUniformType = '[]
instance O.HasParentTypes GLUniformType

foreign import ccall "gsk_gl_uniform_type_get_type" c_gsk_gl_uniform_type_get_type :: 
    IO GType

instance B.Types.TypedObject GLUniformType where
    glibType = c_gsk_gl_uniform_type_get_type

instance B.Types.BoxedEnum GLUniformType

-- Enum FillRule
-- | Specifies how paths are filled.
-- 
-- Whether or not a point is included in the fill is determined by taking
-- a ray from that point to infinity and looking at intersections with the
-- path. The ray can be in any direction, as long as it doesn\'t pass through
-- the end point of a segment or have a tricky intersection such as
-- intersecting tangent to the path.
-- 
-- (Note that filling is not actually implemented in this way. This
-- is just a description of the rule that is applied.)
-- 
-- New entries may be added in future versions.
-- 
-- /Since: 4.14/
data FillRule = 
      FillRuleWinding
    -- ^ If the path crosses the ray from
    --   left-to-right, counts +1. If the path crosses the ray
    --   from right to left, counts -1. (Left and right are determined
    --   from the perspective of looking along the ray from the starting
    --   point.) If the total count is non-zero, the point will be filled.
    | FillRuleEvenOdd
    -- ^ Counts the total number of
    --   intersections, without regard to the orientation of the contour. If
    --   the total number of intersections is odd, the point will be
    --   filled.
    | AnotherFillRule Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FillRule where
    fromEnum FillRuleWinding = 0
    fromEnum FillRuleEvenOdd = 1
    fromEnum (AnotherFillRule k) = k

    toEnum 0 = FillRuleWinding
    toEnum 1 = FillRuleEvenOdd
    toEnum k = AnotherFillRule k

instance P.Ord FillRule where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FillRule = '[]
instance O.HasParentTypes FillRule

foreign import ccall "gsk_fill_rule_get_type" c_gsk_fill_rule_get_type :: 
    IO GType

instance B.Types.TypedObject FillRule where
    glibType = c_gsk_fill_rule_get_type

instance B.Types.BoxedEnum FillRule

-- Enum Corner
-- | The corner indices used by @GskRoundedRect@.
data Corner = 
      CornerTopLeft
    -- ^ The top left corner
    | CornerTopRight
    -- ^ The top right corner
    | CornerBottomRight
    -- ^ The bottom right corner
    | CornerBottomLeft
    -- ^ The bottom left corner
    | AnotherCorner Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Corner where
    fromEnum CornerTopLeft = 0
    fromEnum CornerTopRight = 1
    fromEnum CornerBottomRight = 2
    fromEnum CornerBottomLeft = 3
    fromEnum (AnotherCorner k) = k

    toEnum 0 = CornerTopLeft
    toEnum 1 = CornerTopRight
    toEnum 2 = CornerBottomRight
    toEnum 3 = CornerBottomLeft
    toEnum k = AnotherCorner k

instance P.Ord Corner where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Corner = '[]
instance O.HasParentTypes Corner

foreign import ccall "gsk_corner_get_type" c_gsk_corner_get_type :: 
    IO GType

instance B.Types.TypedObject Corner where
    glibType = c_gsk_corner_get_type

instance B.Types.BoxedEnum Corner

-- Enum BlendMode
-- | The blend modes available for render nodes.
-- 
-- The implementation of each blend mode is deferred to the
-- rendering pipeline.
-- 
-- See \<https:\/\/www.w3.org\/TR\/compositing-1\/@/blending/@> for more information
-- on blending and blend modes.
data BlendMode = 
      BlendModeDefault
    -- ^ The default blend mode, which specifies no blending
    | BlendModeMultiply
    -- ^ The source color is multiplied by the destination
    --   and replaces the destination
    | BlendModeScreen
    -- ^ Multiplies the complements of the destination and source
    --   color values, then complements the result.
    | BlendModeOverlay
    -- ^ Multiplies or screens the colors, depending on the
    --   destination color value. This is the inverse of hard-list
    | BlendModeDarken
    -- ^ Selects the darker of the destination and source colors
    | BlendModeLighten
    -- ^ Selects the lighter of the destination and source colors
    | BlendModeColorDodge
    -- ^ Brightens the destination color to reflect the source color
    | BlendModeColorBurn
    -- ^ Darkens the destination color to reflect the source color
    | BlendModeHardLight
    -- ^ Multiplies or screens the colors, depending on the source color value
    | BlendModeSoftLight
    -- ^ Darkens or lightens the colors, depending on the source color value
    | BlendModeDifference
    -- ^ Subtracts the darker of the two constituent colors from the lighter color
    | BlendModeExclusion
    -- ^ Produces an effect similar to that of the difference mode but lower in contrast
    | BlendModeColor
    -- ^ Creates a color with the hue and saturation of the source color and the luminosity of the destination color
    | BlendModeHue
    -- ^ Creates a color with the hue of the source color and the saturation and luminosity of the destination color
    | BlendModeSaturation
    -- ^ Creates a color with the saturation of the source color and the hue and luminosity of the destination color
    | BlendModeLuminosity
    -- ^ Creates a color with the luminosity of the source color and the hue and saturation of the destination color
    | AnotherBlendMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BlendMode where
    fromEnum BlendModeDefault = 0
    fromEnum BlendModeMultiply = 1
    fromEnum BlendModeScreen = 2
    fromEnum BlendModeOverlay = 3
    fromEnum BlendModeDarken = 4
    fromEnum BlendModeLighten = 5
    fromEnum BlendModeColorDodge = 6
    fromEnum BlendModeColorBurn = 7
    fromEnum BlendModeHardLight = 8
    fromEnum BlendModeSoftLight = 9
    fromEnum BlendModeDifference = 10
    fromEnum BlendModeExclusion = 11
    fromEnum BlendModeColor = 12
    fromEnum BlendModeHue = 13
    fromEnum BlendModeSaturation = 14
    fromEnum BlendModeLuminosity = 15
    fromEnum (AnotherBlendMode k) = k

    toEnum 0 = BlendModeDefault
    toEnum 1 = BlendModeMultiply
    toEnum 2 = BlendModeScreen
    toEnum 3 = BlendModeOverlay
    toEnum 4 = BlendModeDarken
    toEnum 5 = BlendModeLighten
    toEnum 6 = BlendModeColorDodge
    toEnum 7 = BlendModeColorBurn
    toEnum 8 = BlendModeHardLight
    toEnum 9 = BlendModeSoftLight
    toEnum 10 = BlendModeDifference
    toEnum 11 = BlendModeExclusion
    toEnum 12 = BlendModeColor
    toEnum 13 = BlendModeHue
    toEnum 14 = BlendModeSaturation
    toEnum 15 = BlendModeLuminosity
    toEnum k = AnotherBlendMode k

instance P.Ord BlendMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes BlendMode = '[]
instance O.HasParentTypes BlendMode

foreign import ccall "gsk_blend_mode_get_type" c_gsk_blend_mode_get_type :: 
    IO GType

instance B.Types.TypedObject BlendMode where
    glibType = c_gsk_blend_mode_get_type

instance B.Types.BoxedEnum BlendMode


