{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.ClosureNotifyData
    ( 

-- * Exported types
    ClosureNotifyData(..)                   ,
    newZeroClosureNotifyData                ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveClosureNotifyDataMethod          ,
#endif



 -- * Properties


-- ** data #attr:data#
-- | /No description available in the introspection data./

    clearClosureNotifyDataData              ,
#if defined(ENABLE_OVERLOADING)
    closureNotifyData_data                  ,
#endif
    getClosureNotifyDataData                ,
    setClosureNotifyDataData                ,


-- ** notify #attr:notify#
-- | /No description available in the introspection data./

    clearClosureNotifyDataNotify            ,
#if defined(ENABLE_OVERLOADING)
    closureNotifyData_notify                ,
#endif
    getClosureNotifyDataNotify              ,
    setClosureNotifyDataNotify              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Callbacks as GObject.Callbacks

#else
import qualified GI.GObject.Callbacks as GObject.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype ClosureNotifyData = ClosureNotifyData (SP.ManagedPtr ClosureNotifyData)
    deriving (Eq)

instance SP.ManagedPtrNewtype ClosureNotifyData where
    toManagedPtr (ClosureNotifyData p) = p

instance BoxedPtr ClosureNotifyData where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr ClosureNotifyData)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr ClosureNotifyData where
    boxedPtrCalloc = callocBytes 16


-- | Construct a t'ClosureNotifyData' struct initialized to zero.
newZeroClosureNotifyData :: MonadIO m => m ClosureNotifyData
newZeroClosureNotifyData = liftIO $ boxedPtrCalloc >>= wrapPtr ClosureNotifyData

instance tag ~ 'AttrSet => Constructible ClosureNotifyData tag where
    new _ attrs = do
        o <- newZeroClosureNotifyData
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' closureNotifyData #data
-- @
getClosureNotifyDataData :: MonadIO m => ClosureNotifyData -> m (Ptr ())
getClosureNotifyDataData s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr ())
    return val

-- | Set the value of the “@data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' closureNotifyData [ #data 'Data.GI.Base.Attributes.:=' value ]
-- @
setClosureNotifyDataData :: MonadIO m => ClosureNotifyData -> Ptr () -> m ()
setClosureNotifyDataData s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr ())

-- | Set the value of the “@data@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #data
-- @
clearClosureNotifyDataData :: MonadIO m => ClosureNotifyData -> m ()
clearClosureNotifyDataData s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data ClosureNotifyDataDataFieldInfo
instance AttrInfo ClosureNotifyDataDataFieldInfo where
    type AttrBaseTypeConstraint ClosureNotifyDataDataFieldInfo = (~) ClosureNotifyData
    type AttrAllowedOps ClosureNotifyDataDataFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ClosureNotifyDataDataFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint ClosureNotifyDataDataFieldInfo = (~)(Ptr ())
    type AttrTransferType ClosureNotifyDataDataFieldInfo = (Ptr ())
    type AttrGetType ClosureNotifyDataDataFieldInfo = Ptr ()
    type AttrLabel ClosureNotifyDataDataFieldInfo = "data"
    type AttrOrigin ClosureNotifyDataDataFieldInfo = ClosureNotifyData
    attrGet = getClosureNotifyDataData
    attrSet = setClosureNotifyDataData
    attrConstruct = undefined
    attrClear = clearClosureNotifyDataData
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ClosureNotifyData.data"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ClosureNotifyData.html#g:attr:data"
        })

closureNotifyData_data :: AttrLabelProxy "data"
closureNotifyData_data = AttrLabelProxy

#endif


-- | Get the value of the “@notify@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' closureNotifyData #notify
-- @
getClosureNotifyDataNotify :: MonadIO m => ClosureNotifyData -> m (Maybe GObject.Callbacks.ClosureNotify)
getClosureNotifyDataNotify s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (FunPtr GObject.Callbacks.C_ClosureNotify)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_ClosureNotify val'
        return val''
    return result

-- | Set the value of the “@notify@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' closureNotifyData [ #notify 'Data.GI.Base.Attributes.:=' value ]
-- @
setClosureNotifyDataNotify :: MonadIO m => ClosureNotifyData -> FunPtr GObject.Callbacks.C_ClosureNotify -> m ()
setClosureNotifyDataNotify s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FunPtr GObject.Callbacks.C_ClosureNotify)

-- | Set the value of the “@notify@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #notify
-- @
clearClosureNotifyDataNotify :: MonadIO m => ClosureNotifyData -> m ()
clearClosureNotifyDataNotify s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_ClosureNotify)

#if defined(ENABLE_OVERLOADING)
data ClosureNotifyDataNotifyFieldInfo
instance AttrInfo ClosureNotifyDataNotifyFieldInfo where
    type AttrBaseTypeConstraint ClosureNotifyDataNotifyFieldInfo = (~) ClosureNotifyData
    type AttrAllowedOps ClosureNotifyDataNotifyFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ClosureNotifyDataNotifyFieldInfo = (~) (FunPtr GObject.Callbacks.C_ClosureNotify)
    type AttrTransferTypeConstraint ClosureNotifyDataNotifyFieldInfo = (~)GObject.Callbacks.ClosureNotify
    type AttrTransferType ClosureNotifyDataNotifyFieldInfo = (FunPtr GObject.Callbacks.C_ClosureNotify)
    type AttrGetType ClosureNotifyDataNotifyFieldInfo = Maybe GObject.Callbacks.ClosureNotify
    type AttrLabel ClosureNotifyDataNotifyFieldInfo = "notify"
    type AttrOrigin ClosureNotifyDataNotifyFieldInfo = ClosureNotifyData
    attrGet = getClosureNotifyDataNotify
    attrSet = setClosureNotifyDataNotify
    attrConstruct = undefined
    attrClear = clearClosureNotifyDataNotify
    attrTransfer _ v = do
        GObject.Callbacks.mk_ClosureNotify (GObject.Callbacks.wrap_ClosureNotify Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ClosureNotifyData.notify"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ClosureNotifyData.html#g:attr:notify"
        })

closureNotifyData_notify :: AttrLabelProxy "notify"
closureNotifyData_notify = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ClosureNotifyData
type instance O.AttributeList ClosureNotifyData = ClosureNotifyDataAttributeList
type ClosureNotifyDataAttributeList = ('[ '("data", ClosureNotifyDataDataFieldInfo), '("notify", ClosureNotifyDataNotifyFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveClosureNotifyDataMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveClosureNotifyDataMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveClosureNotifyDataMethod t ClosureNotifyData, O.OverloadedMethod info ClosureNotifyData p) => OL.IsLabel t (ClosureNotifyData -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveClosureNotifyDataMethod t ClosureNotifyData, O.OverloadedMethod info ClosureNotifyData p, R.HasField t ClosureNotifyData p) => R.HasField t ClosureNotifyData p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveClosureNotifyDataMethod t ClosureNotifyData, O.OverloadedMethodInfo info ClosureNotifyData) => OL.IsLabel t (O.MethodProxy info ClosureNotifyData) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


