{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A set of functions used to perform memory allocation. The same t'GI.GLib.Structs.MemVTable.MemVTable' must
-- be used for all allocations in the same program; a call to 'GI.GLib.Functions.memSetVtable',
-- if it exists, should be prior to any use of GLib.
-- 
-- This functions related to this has been deprecated in 2.46, and no longer work.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.MemVTable
    ( 

-- * Exported types
    MemVTable(..)                           ,
    newZeroMemVTable                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveMemVTableMethod                  ,
#endif



 -- * Properties


-- ** calloc #attr:calloc#
-- | function to use for allocating zero-filled memory.

    clearMemVTableCalloc                    ,
    getMemVTableCalloc                      ,
#if defined(ENABLE_OVERLOADING)
    memVTable_calloc                        ,
#endif
    setMemVTableCalloc                      ,


-- ** free #attr:free#
-- | function to use to free memory.

    clearMemVTableFree                      ,
    getMemVTableFree                        ,
#if defined(ENABLE_OVERLOADING)
    memVTable_free                          ,
#endif
    setMemVTableFree                        ,


-- ** malloc #attr:malloc#
-- | function to use for allocating memory.

    clearMemVTableMalloc                    ,
    getMemVTableMalloc                      ,
#if defined(ENABLE_OVERLOADING)
    memVTable_malloc                        ,
#endif
    setMemVTableMalloc                      ,


-- ** realloc #attr:realloc#
-- | function to use for reallocating memory.

    clearMemVTableRealloc                   ,
    getMemVTableRealloc                     ,
#if defined(ENABLE_OVERLOADING)
    memVTable_realloc                       ,
#endif
    setMemVTableRealloc                     ,


-- ** tryMalloc #attr:tryMalloc#
-- | function to use for allocating memory without a default error handler.

    clearMemVTableTryMalloc                 ,
    getMemVTableTryMalloc                   ,
#if defined(ENABLE_OVERLOADING)
    memVTable_tryMalloc                     ,
#endif
    setMemVTableTryMalloc                   ,


-- ** tryRealloc #attr:tryRealloc#
-- | function to use for reallocating memory without a default error handler.

    clearMemVTableTryRealloc                ,
    getMemVTableTryRealloc                  ,
#if defined(ENABLE_OVERLOADING)
    memVTable_tryRealloc                    ,
#endif
    setMemVTableTryRealloc                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype MemVTable = MemVTable (SP.ManagedPtr MemVTable)
    deriving (Eq)

instance SP.ManagedPtrNewtype MemVTable where
    toManagedPtr (MemVTable p) = p

instance BoxedPtr MemVTable where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 48 >=> B.ManagedPtr.wrapPtr MemVTable)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr MemVTable where
    boxedPtrCalloc = callocBytes 48


-- | Construct a t'MemVTable' struct initialized to zero.
newZeroMemVTable :: MonadIO m => m MemVTable
newZeroMemVTable = liftIO $ boxedPtrCalloc >>= wrapPtr MemVTable

instance tag ~ 'AttrSet => Constructible MemVTable tag where
    new _ attrs = do
        o <- newZeroMemVTable
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@malloc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memVTable #malloc
-- @
getMemVTableMalloc :: MonadIO m => MemVTable -> m (Maybe GLib.Callbacks.MemVTableMallocFieldCallback)
getMemVTableMalloc s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (FunPtr GLib.Callbacks.C_MemVTableMallocFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_MemVTableMallocFieldCallback val'
        return val''
    return result

-- | Set the value of the “@malloc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' memVTable [ #malloc 'Data.GI.Base.Attributes.:=' value ]
-- @
setMemVTableMalloc :: MonadIO m => MemVTable -> FunPtr GLib.Callbacks.C_MemVTableMallocFieldCallback -> m ()
setMemVTableMalloc s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FunPtr GLib.Callbacks.C_MemVTableMallocFieldCallback)

-- | Set the value of the “@malloc@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #malloc
-- @
clearMemVTableMalloc :: MonadIO m => MemVTable -> m ()
clearMemVTableMalloc s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_MemVTableMallocFieldCallback)

#if defined(ENABLE_OVERLOADING)
data MemVTableMallocFieldInfo
instance AttrInfo MemVTableMallocFieldInfo where
    type AttrBaseTypeConstraint MemVTableMallocFieldInfo = (~) MemVTable
    type AttrAllowedOps MemVTableMallocFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint MemVTableMallocFieldInfo = (~) (FunPtr GLib.Callbacks.C_MemVTableMallocFieldCallback)
    type AttrTransferTypeConstraint MemVTableMallocFieldInfo = (~)GLib.Callbacks.MemVTableMallocFieldCallback
    type AttrTransferType MemVTableMallocFieldInfo = (FunPtr GLib.Callbacks.C_MemVTableMallocFieldCallback)
    type AttrGetType MemVTableMallocFieldInfo = Maybe GLib.Callbacks.MemVTableMallocFieldCallback
    type AttrLabel MemVTableMallocFieldInfo = "malloc"
    type AttrOrigin MemVTableMallocFieldInfo = MemVTable
    attrGet = getMemVTableMalloc
    attrSet = setMemVTableMalloc
    attrConstruct = undefined
    attrClear = clearMemVTableMalloc
    attrTransfer _ v = do
        GLib.Callbacks.mk_MemVTableMallocFieldCallback (GLib.Callbacks.wrap_MemVTableMallocFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MemVTable.malloc"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MemVTable.html#g:attr:malloc"
        })

memVTable_malloc :: AttrLabelProxy "malloc"
memVTable_malloc = AttrLabelProxy

#endif


-- | Get the value of the “@realloc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memVTable #realloc
-- @
getMemVTableRealloc :: MonadIO m => MemVTable -> m (Maybe GLib.Callbacks.MemVTableReallocFieldCallback)
getMemVTableRealloc s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (FunPtr GLib.Callbacks.C_MemVTableReallocFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_MemVTableReallocFieldCallback val'
        return val''
    return result

-- | Set the value of the “@realloc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' memVTable [ #realloc 'Data.GI.Base.Attributes.:=' value ]
-- @
setMemVTableRealloc :: MonadIO m => MemVTable -> FunPtr GLib.Callbacks.C_MemVTableReallocFieldCallback -> m ()
setMemVTableRealloc s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FunPtr GLib.Callbacks.C_MemVTableReallocFieldCallback)

-- | Set the value of the “@realloc@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #realloc
-- @
clearMemVTableRealloc :: MonadIO m => MemVTable -> m ()
clearMemVTableRealloc s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_MemVTableReallocFieldCallback)

#if defined(ENABLE_OVERLOADING)
data MemVTableReallocFieldInfo
instance AttrInfo MemVTableReallocFieldInfo where
    type AttrBaseTypeConstraint MemVTableReallocFieldInfo = (~) MemVTable
    type AttrAllowedOps MemVTableReallocFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint MemVTableReallocFieldInfo = (~) (FunPtr GLib.Callbacks.C_MemVTableReallocFieldCallback)
    type AttrTransferTypeConstraint MemVTableReallocFieldInfo = (~)GLib.Callbacks.MemVTableReallocFieldCallback
    type AttrTransferType MemVTableReallocFieldInfo = (FunPtr GLib.Callbacks.C_MemVTableReallocFieldCallback)
    type AttrGetType MemVTableReallocFieldInfo = Maybe GLib.Callbacks.MemVTableReallocFieldCallback
    type AttrLabel MemVTableReallocFieldInfo = "realloc"
    type AttrOrigin MemVTableReallocFieldInfo = MemVTable
    attrGet = getMemVTableRealloc
    attrSet = setMemVTableRealloc
    attrConstruct = undefined
    attrClear = clearMemVTableRealloc
    attrTransfer _ v = do
        GLib.Callbacks.mk_MemVTableReallocFieldCallback (GLib.Callbacks.wrap_MemVTableReallocFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MemVTable.realloc"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MemVTable.html#g:attr:realloc"
        })

memVTable_realloc :: AttrLabelProxy "realloc"
memVTable_realloc = AttrLabelProxy

#endif


-- | Get the value of the “@free@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memVTable #free
-- @
getMemVTableFree :: MonadIO m => MemVTable -> m (Maybe GLib.Callbacks.MemVTableFreeFieldCallback)
getMemVTableFree s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (FunPtr GLib.Callbacks.C_MemVTableFreeFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_MemVTableFreeFieldCallback val'
        return val''
    return result

-- | Set the value of the “@free@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' memVTable [ #free 'Data.GI.Base.Attributes.:=' value ]
-- @
setMemVTableFree :: MonadIO m => MemVTable -> FunPtr GLib.Callbacks.C_MemVTableFreeFieldCallback -> m ()
setMemVTableFree s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: FunPtr GLib.Callbacks.C_MemVTableFreeFieldCallback)

-- | Set the value of the “@free@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #free
-- @
clearMemVTableFree :: MonadIO m => MemVTable -> m ()
clearMemVTableFree s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_MemVTableFreeFieldCallback)

#if defined(ENABLE_OVERLOADING)
data MemVTableFreeFieldInfo
instance AttrInfo MemVTableFreeFieldInfo where
    type AttrBaseTypeConstraint MemVTableFreeFieldInfo = (~) MemVTable
    type AttrAllowedOps MemVTableFreeFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint MemVTableFreeFieldInfo = (~) (FunPtr GLib.Callbacks.C_MemVTableFreeFieldCallback)
    type AttrTransferTypeConstraint MemVTableFreeFieldInfo = (~)GLib.Callbacks.MemVTableFreeFieldCallback
    type AttrTransferType MemVTableFreeFieldInfo = (FunPtr GLib.Callbacks.C_MemVTableFreeFieldCallback)
    type AttrGetType MemVTableFreeFieldInfo = Maybe GLib.Callbacks.MemVTableFreeFieldCallback
    type AttrLabel MemVTableFreeFieldInfo = "free"
    type AttrOrigin MemVTableFreeFieldInfo = MemVTable
    attrGet = getMemVTableFree
    attrSet = setMemVTableFree
    attrConstruct = undefined
    attrClear = clearMemVTableFree
    attrTransfer _ v = do
        GLib.Callbacks.mk_MemVTableFreeFieldCallback (GLib.Callbacks.wrap_MemVTableFreeFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MemVTable.free"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MemVTable.html#g:attr:free"
        })

memVTable_free :: AttrLabelProxy "free"
memVTable_free = AttrLabelProxy

#endif


-- | Get the value of the “@calloc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memVTable #calloc
-- @
getMemVTableCalloc :: MonadIO m => MemVTable -> m (Maybe GLib.Callbacks.MemVTableCallocFieldCallback)
getMemVTableCalloc s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (FunPtr GLib.Callbacks.C_MemVTableCallocFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_MemVTableCallocFieldCallback val'
        return val''
    return result

-- | Set the value of the “@calloc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' memVTable [ #calloc 'Data.GI.Base.Attributes.:=' value ]
-- @
setMemVTableCalloc :: MonadIO m => MemVTable -> FunPtr GLib.Callbacks.C_MemVTableCallocFieldCallback -> m ()
setMemVTableCalloc s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: FunPtr GLib.Callbacks.C_MemVTableCallocFieldCallback)

-- | Set the value of the “@calloc@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #calloc
-- @
clearMemVTableCalloc :: MonadIO m => MemVTable -> m ()
clearMemVTableCalloc s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_MemVTableCallocFieldCallback)

#if defined(ENABLE_OVERLOADING)
data MemVTableCallocFieldInfo
instance AttrInfo MemVTableCallocFieldInfo where
    type AttrBaseTypeConstraint MemVTableCallocFieldInfo = (~) MemVTable
    type AttrAllowedOps MemVTableCallocFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint MemVTableCallocFieldInfo = (~) (FunPtr GLib.Callbacks.C_MemVTableCallocFieldCallback)
    type AttrTransferTypeConstraint MemVTableCallocFieldInfo = (~)GLib.Callbacks.MemVTableCallocFieldCallback
    type AttrTransferType MemVTableCallocFieldInfo = (FunPtr GLib.Callbacks.C_MemVTableCallocFieldCallback)
    type AttrGetType MemVTableCallocFieldInfo = Maybe GLib.Callbacks.MemVTableCallocFieldCallback
    type AttrLabel MemVTableCallocFieldInfo = "calloc"
    type AttrOrigin MemVTableCallocFieldInfo = MemVTable
    attrGet = getMemVTableCalloc
    attrSet = setMemVTableCalloc
    attrConstruct = undefined
    attrClear = clearMemVTableCalloc
    attrTransfer _ v = do
        GLib.Callbacks.mk_MemVTableCallocFieldCallback (GLib.Callbacks.wrap_MemVTableCallocFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MemVTable.calloc"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MemVTable.html#g:attr:calloc"
        })

memVTable_calloc :: AttrLabelProxy "calloc"
memVTable_calloc = AttrLabelProxy

#endif


-- | Get the value of the “@try_malloc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memVTable #tryMalloc
-- @
getMemVTableTryMalloc :: MonadIO m => MemVTable -> m (Maybe GLib.Callbacks.MemVTableTryMallocFieldCallback)
getMemVTableTryMalloc s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (FunPtr GLib.Callbacks.C_MemVTableTryMallocFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_MemVTableTryMallocFieldCallback val'
        return val''
    return result

-- | Set the value of the “@try_malloc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' memVTable [ #tryMalloc 'Data.GI.Base.Attributes.:=' value ]
-- @
setMemVTableTryMalloc :: MonadIO m => MemVTable -> FunPtr GLib.Callbacks.C_MemVTableTryMallocFieldCallback -> m ()
setMemVTableTryMalloc s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: FunPtr GLib.Callbacks.C_MemVTableTryMallocFieldCallback)

-- | Set the value of the “@try_malloc@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #tryMalloc
-- @
clearMemVTableTryMalloc :: MonadIO m => MemVTable -> m ()
clearMemVTableTryMalloc s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_MemVTableTryMallocFieldCallback)

#if defined(ENABLE_OVERLOADING)
data MemVTableTryMallocFieldInfo
instance AttrInfo MemVTableTryMallocFieldInfo where
    type AttrBaseTypeConstraint MemVTableTryMallocFieldInfo = (~) MemVTable
    type AttrAllowedOps MemVTableTryMallocFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint MemVTableTryMallocFieldInfo = (~) (FunPtr GLib.Callbacks.C_MemVTableTryMallocFieldCallback)
    type AttrTransferTypeConstraint MemVTableTryMallocFieldInfo = (~)GLib.Callbacks.MemVTableTryMallocFieldCallback
    type AttrTransferType MemVTableTryMallocFieldInfo = (FunPtr GLib.Callbacks.C_MemVTableTryMallocFieldCallback)
    type AttrGetType MemVTableTryMallocFieldInfo = Maybe GLib.Callbacks.MemVTableTryMallocFieldCallback
    type AttrLabel MemVTableTryMallocFieldInfo = "try_malloc"
    type AttrOrigin MemVTableTryMallocFieldInfo = MemVTable
    attrGet = getMemVTableTryMalloc
    attrSet = setMemVTableTryMalloc
    attrConstruct = undefined
    attrClear = clearMemVTableTryMalloc
    attrTransfer _ v = do
        GLib.Callbacks.mk_MemVTableTryMallocFieldCallback (GLib.Callbacks.wrap_MemVTableTryMallocFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MemVTable.tryMalloc"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MemVTable.html#g:attr:tryMalloc"
        })

memVTable_tryMalloc :: AttrLabelProxy "tryMalloc"
memVTable_tryMalloc = AttrLabelProxy

#endif


-- | Get the value of the “@try_realloc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memVTable #tryRealloc
-- @
getMemVTableTryRealloc :: MonadIO m => MemVTable -> m (Maybe GLib.Callbacks.MemVTableTryReallocFieldCallback)
getMemVTableTryRealloc s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO (FunPtr GLib.Callbacks.C_MemVTableTryReallocFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_MemVTableTryReallocFieldCallback val'
        return val''
    return result

-- | Set the value of the “@try_realloc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' memVTable [ #tryRealloc 'Data.GI.Base.Attributes.:=' value ]
-- @
setMemVTableTryRealloc :: MonadIO m => MemVTable -> FunPtr GLib.Callbacks.C_MemVTableTryReallocFieldCallback -> m ()
setMemVTableTryRealloc s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: FunPtr GLib.Callbacks.C_MemVTableTryReallocFieldCallback)

-- | Set the value of the “@try_realloc@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #tryRealloc
-- @
clearMemVTableTryRealloc :: MonadIO m => MemVTable -> m ()
clearMemVTableTryRealloc s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_MemVTableTryReallocFieldCallback)

#if defined(ENABLE_OVERLOADING)
data MemVTableTryReallocFieldInfo
instance AttrInfo MemVTableTryReallocFieldInfo where
    type AttrBaseTypeConstraint MemVTableTryReallocFieldInfo = (~) MemVTable
    type AttrAllowedOps MemVTableTryReallocFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint MemVTableTryReallocFieldInfo = (~) (FunPtr GLib.Callbacks.C_MemVTableTryReallocFieldCallback)
    type AttrTransferTypeConstraint MemVTableTryReallocFieldInfo = (~)GLib.Callbacks.MemVTableTryReallocFieldCallback
    type AttrTransferType MemVTableTryReallocFieldInfo = (FunPtr GLib.Callbacks.C_MemVTableTryReallocFieldCallback)
    type AttrGetType MemVTableTryReallocFieldInfo = Maybe GLib.Callbacks.MemVTableTryReallocFieldCallback
    type AttrLabel MemVTableTryReallocFieldInfo = "try_realloc"
    type AttrOrigin MemVTableTryReallocFieldInfo = MemVTable
    attrGet = getMemVTableTryRealloc
    attrSet = setMemVTableTryRealloc
    attrConstruct = undefined
    attrClear = clearMemVTableTryRealloc
    attrTransfer _ v = do
        GLib.Callbacks.mk_MemVTableTryReallocFieldCallback (GLib.Callbacks.wrap_MemVTableTryReallocFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MemVTable.tryRealloc"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MemVTable.html#g:attr:tryRealloc"
        })

memVTable_tryRealloc :: AttrLabelProxy "tryRealloc"
memVTable_tryRealloc = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MemVTable
type instance O.AttributeList MemVTable = MemVTableAttributeList
type MemVTableAttributeList = ('[ '("malloc", MemVTableMallocFieldInfo), '("realloc", MemVTableReallocFieldInfo), '("free", MemVTableFreeFieldInfo), '("calloc", MemVTableCallocFieldInfo), '("tryMalloc", MemVTableTryMallocFieldInfo), '("tryRealloc", MemVTableTryReallocFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveMemVTableMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMemVTableMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMemVTableMethod t MemVTable, O.OverloadedMethod info MemVTable p) => OL.IsLabel t (MemVTable -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMemVTableMethod t MemVTable, O.OverloadedMethod info MemVTable p, R.HasField t MemVTable p) => R.HasField t MemVTable p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMemVTableMethod t MemVTable, O.OverloadedMethodInfo info MemVTable) => OL.IsLabel t (O.MethodProxy info MemVTable) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


