{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The t'GI.GLib.Structs.HookList.HookList' struct represents a list of hook functions.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.HookList
    ( 

-- * Exported types
    HookList(..)                            ,
    newZeroHookList                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [clear]("GI.GLib.Structs.HookList#g:method:clear"), [init]("GI.GLib.Structs.HookList#g:method:init"), [invoke]("GI.GLib.Structs.HookList#g:method:invoke"), [invokeCheck]("GI.GLib.Structs.HookList#g:method:invokeCheck"), [marshal]("GI.GLib.Structs.HookList#g:method:marshal"), [marshalCheck]("GI.GLib.Structs.HookList#g:method:marshalCheck").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveHookListMethod                   ,
#endif

-- ** clear #method:clear#

#if defined(ENABLE_OVERLOADING)
    HookListClearMethodInfo                 ,
#endif
    hookListClear                           ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    HookListInitMethodInfo                  ,
#endif
    hookListInit                            ,


-- ** invoke #method:invoke#

#if defined(ENABLE_OVERLOADING)
    HookListInvokeMethodInfo                ,
#endif
    hookListInvoke                          ,


-- ** invokeCheck #method:invokeCheck#

#if defined(ENABLE_OVERLOADING)
    HookListInvokeCheckMethodInfo           ,
#endif
    hookListInvokeCheck                     ,


-- ** marshal #method:marshal#

#if defined(ENABLE_OVERLOADING)
    HookListMarshalMethodInfo               ,
#endif
    hookListMarshal                         ,


-- ** marshalCheck #method:marshalCheck#

#if defined(ENABLE_OVERLOADING)
    HookListMarshalCheckMethodInfo          ,
#endif
    hookListMarshalCheck                    ,




 -- * Properties


-- ** dummy3 #attr:dummy3#
-- | unused

    clearHookListDummy3                     ,
    getHookListDummy3                       ,
#if defined(ENABLE_OVERLOADING)
    hookList_dummy3                         ,
#endif
    setHookListDummy3                       ,


-- ** finalizeHook #attr:finalizeHook#
-- | the function to call to finalize a t'GI.GLib.Structs.Hook.Hook' element.
--     The default behaviour is to call the hooks /@destroy@/ function

    clearHookListFinalizeHook               ,
    getHookListFinalizeHook                 ,
#if defined(ENABLE_OVERLOADING)
    hookList_finalizeHook                   ,
#endif
    setHookListFinalizeHook                 ,


-- ** hookSize #attr:hookSize#
-- | the size of the t'GI.GLib.Structs.HookList.HookList' elements, in bytes

    getHookListHookSize                     ,
#if defined(ENABLE_OVERLOADING)
    hookList_hookSize                       ,
#endif
    setHookListHookSize                     ,


-- ** hooks #attr:hooks#
-- | the first t'GI.GLib.Structs.Hook.Hook' element in the list

    clearHookListHooks                      ,
    getHookListHooks                        ,
#if defined(ENABLE_OVERLOADING)
    hookList_hooks                          ,
#endif
    setHookListHooks                        ,


-- ** isSetup #attr:isSetup#
-- | 1 if the t'GI.GLib.Structs.HookList.HookList' has been initialized

    getHookListIsSetup                      ,
#if defined(ENABLE_OVERLOADING)
    hookList_isSetup                        ,
#endif
    setHookListIsSetup                      ,


-- ** seqId #attr:seqId#
-- | the next free t'GI.GLib.Structs.Hook.Hook' id

    getHookListSeqId                        ,
#if defined(ENABLE_OVERLOADING)
    hookList_seqId                          ,
#endif
    setHookListSeqId                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Structs.Hook as GLib.Hook

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Structs.Hook as GLib.Hook

#endif

-- | Memory-managed wrapper type.
newtype HookList = HookList (SP.ManagedPtr HookList)
    deriving (Eq)

instance SP.ManagedPtrNewtype HookList where
    toManagedPtr (HookList p) = p

instance BoxedPtr HookList where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 56 >=> B.ManagedPtr.wrapPtr HookList)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr HookList where
    boxedPtrCalloc = callocBytes 56


-- | Construct a t'HookList' struct initialized to zero.
newZeroHookList :: MonadIO m => m HookList
newZeroHookList = liftIO $ boxedPtrCalloc >>= wrapPtr HookList

instance tag ~ 'AttrSet => Constructible HookList tag where
    new _ attrs = do
        o <- newZeroHookList
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@seq_id@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' hookList #seqId
-- @
getHookListSeqId :: MonadIO m => HookList -> m FCT.CULong
getHookListSeqId s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO FCT.CULong
    return val

-- | Set the value of the “@seq_id@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' hookList [ #seqId 'Data.GI.Base.Attributes.:=' value ]
-- @
setHookListSeqId :: MonadIO m => HookList -> FCT.CULong -> m ()
setHookListSeqId s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FCT.CULong)

#if defined(ENABLE_OVERLOADING)
data HookListSeqIdFieldInfo
instance AttrInfo HookListSeqIdFieldInfo where
    type AttrBaseTypeConstraint HookListSeqIdFieldInfo = (~) HookList
    type AttrAllowedOps HookListSeqIdFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint HookListSeqIdFieldInfo = (~) FCT.CULong
    type AttrTransferTypeConstraint HookListSeqIdFieldInfo = (~)FCT.CULong
    type AttrTransferType HookListSeqIdFieldInfo = FCT.CULong
    type AttrGetType HookListSeqIdFieldInfo = FCT.CULong
    type AttrLabel HookListSeqIdFieldInfo = "seq_id"
    type AttrOrigin HookListSeqIdFieldInfo = HookList
    attrGet = getHookListSeqId
    attrSet = setHookListSeqId
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HookList.seqId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HookList.html#g:attr:seqId"
        })

hookList_seqId :: AttrLabelProxy "seqId"
hookList_seqId = AttrLabelProxy

#endif


-- | Get the value of the “@hook_size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' hookList #hookSize
-- @
getHookListHookSize :: MonadIO m => HookList -> m Word32
getHookListHookSize s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Word32
    return val

-- | Set the value of the “@hook_size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' hookList [ #hookSize 'Data.GI.Base.Attributes.:=' value ]
-- @
setHookListHookSize :: MonadIO m => HookList -> Word32 -> m ()
setHookListHookSize s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data HookListHookSizeFieldInfo
instance AttrInfo HookListHookSizeFieldInfo where
    type AttrBaseTypeConstraint HookListHookSizeFieldInfo = (~) HookList
    type AttrAllowedOps HookListHookSizeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint HookListHookSizeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint HookListHookSizeFieldInfo = (~)Word32
    type AttrTransferType HookListHookSizeFieldInfo = Word32
    type AttrGetType HookListHookSizeFieldInfo = Word32
    type AttrLabel HookListHookSizeFieldInfo = "hook_size"
    type AttrOrigin HookListHookSizeFieldInfo = HookList
    attrGet = getHookListHookSize
    attrSet = setHookListHookSize
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HookList.hookSize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HookList.html#g:attr:hookSize"
        })

hookList_hookSize :: AttrLabelProxy "hookSize"
hookList_hookSize = AttrLabelProxy

#endif


-- | Get the value of the “@is_setup@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' hookList #isSetup
-- @
getHookListIsSetup :: MonadIO m => HookList -> m Word32
getHookListIsSetup s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Word32
    return val

-- | Set the value of the “@is_setup@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' hookList [ #isSetup 'Data.GI.Base.Attributes.:=' value ]
-- @
setHookListIsSetup :: MonadIO m => HookList -> Word32 -> m ()
setHookListIsSetup s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data HookListIsSetupFieldInfo
instance AttrInfo HookListIsSetupFieldInfo where
    type AttrBaseTypeConstraint HookListIsSetupFieldInfo = (~) HookList
    type AttrAllowedOps HookListIsSetupFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint HookListIsSetupFieldInfo = (~) Word32
    type AttrTransferTypeConstraint HookListIsSetupFieldInfo = (~)Word32
    type AttrTransferType HookListIsSetupFieldInfo = Word32
    type AttrGetType HookListIsSetupFieldInfo = Word32
    type AttrLabel HookListIsSetupFieldInfo = "is_setup"
    type AttrOrigin HookListIsSetupFieldInfo = HookList
    attrGet = getHookListIsSetup
    attrSet = setHookListIsSetup
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HookList.isSetup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HookList.html#g:attr:isSetup"
        })

hookList_isSetup :: AttrLabelProxy "isSetup"
hookList_isSetup = AttrLabelProxy

#endif


-- | Get the value of the “@hooks@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' hookList #hooks
-- @
getHookListHooks :: MonadIO m => HookList -> m (Maybe GLib.Hook.Hook)
getHookListHooks s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (Ptr GLib.Hook.Hook)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newPtr GLib.Hook.Hook) val'
        return val''
    return result

-- | Set the value of the “@hooks@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' hookList [ #hooks 'Data.GI.Base.Attributes.:=' value ]
-- @
setHookListHooks :: MonadIO m => HookList -> Ptr GLib.Hook.Hook -> m ()
setHookListHooks s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Ptr GLib.Hook.Hook)

-- | Set the value of the “@hooks@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #hooks
-- @
clearHookListHooks :: MonadIO m => HookList -> m ()
clearHookListHooks s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: Ptr GLib.Hook.Hook)

#if defined(ENABLE_OVERLOADING)
data HookListHooksFieldInfo
instance AttrInfo HookListHooksFieldInfo where
    type AttrBaseTypeConstraint HookListHooksFieldInfo = (~) HookList
    type AttrAllowedOps HookListHooksFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint HookListHooksFieldInfo = (~) (Ptr GLib.Hook.Hook)
    type AttrTransferTypeConstraint HookListHooksFieldInfo = (~)(Ptr GLib.Hook.Hook)
    type AttrTransferType HookListHooksFieldInfo = (Ptr GLib.Hook.Hook)
    type AttrGetType HookListHooksFieldInfo = Maybe GLib.Hook.Hook
    type AttrLabel HookListHooksFieldInfo = "hooks"
    type AttrOrigin HookListHooksFieldInfo = HookList
    attrGet = getHookListHooks
    attrSet = setHookListHooks
    attrConstruct = undefined
    attrClear = clearHookListHooks
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HookList.hooks"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HookList.html#g:attr:hooks"
        })

hookList_hooks :: AttrLabelProxy "hooks"
hookList_hooks = AttrLabelProxy

#endif


-- | Get the value of the “@dummy3@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' hookList #dummy3
-- @
getHookListDummy3 :: MonadIO m => HookList -> m (Ptr ())
getHookListDummy3 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (Ptr ())
    return val

-- | Set the value of the “@dummy3@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' hookList [ #dummy3 'Data.GI.Base.Attributes.:=' value ]
-- @
setHookListDummy3 :: MonadIO m => HookList -> Ptr () -> m ()
setHookListDummy3 s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Ptr ())

-- | Set the value of the “@dummy3@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #dummy3
-- @
clearHookListDummy3 :: MonadIO m => HookList -> m ()
clearHookListDummy3 s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data HookListDummy3FieldInfo
instance AttrInfo HookListDummy3FieldInfo where
    type AttrBaseTypeConstraint HookListDummy3FieldInfo = (~) HookList
    type AttrAllowedOps HookListDummy3FieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint HookListDummy3FieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint HookListDummy3FieldInfo = (~)(Ptr ())
    type AttrTransferType HookListDummy3FieldInfo = (Ptr ())
    type AttrGetType HookListDummy3FieldInfo = Ptr ()
    type AttrLabel HookListDummy3FieldInfo = "dummy3"
    type AttrOrigin HookListDummy3FieldInfo = HookList
    attrGet = getHookListDummy3
    attrSet = setHookListDummy3
    attrConstruct = undefined
    attrClear = clearHookListDummy3
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HookList.dummy3"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HookList.html#g:attr:dummy3"
        })

hookList_dummy3 :: AttrLabelProxy "dummy3"
hookList_dummy3 = AttrLabelProxy

#endif


-- | Get the value of the “@finalize_hook@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' hookList #finalizeHook
-- @
getHookListFinalizeHook :: MonadIO m => HookList -> m (Maybe GLib.Callbacks.HookFinalizeFunc)
getHookListFinalizeHook s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (FunPtr GLib.Callbacks.C_HookFinalizeFunc)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_HookFinalizeFunc val'
        return val''
    return result

-- | Set the value of the “@finalize_hook@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' hookList [ #finalizeHook 'Data.GI.Base.Attributes.:=' value ]
-- @
setHookListFinalizeHook :: MonadIO m => HookList -> FunPtr GLib.Callbacks.C_HookFinalizeFunc -> m ()
setHookListFinalizeHook s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: FunPtr GLib.Callbacks.C_HookFinalizeFunc)

-- | Set the value of the “@finalize_hook@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #finalizeHook
-- @
clearHookListFinalizeHook :: MonadIO m => HookList -> m ()
clearHookListFinalizeHook s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_HookFinalizeFunc)

#if defined(ENABLE_OVERLOADING)
data HookListFinalizeHookFieldInfo
instance AttrInfo HookListFinalizeHookFieldInfo where
    type AttrBaseTypeConstraint HookListFinalizeHookFieldInfo = (~) HookList
    type AttrAllowedOps HookListFinalizeHookFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint HookListFinalizeHookFieldInfo = (~) (FunPtr GLib.Callbacks.C_HookFinalizeFunc)
    type AttrTransferTypeConstraint HookListFinalizeHookFieldInfo = (~)GLib.Callbacks.HookFinalizeFunc
    type AttrTransferType HookListFinalizeHookFieldInfo = (FunPtr GLib.Callbacks.C_HookFinalizeFunc)
    type AttrGetType HookListFinalizeHookFieldInfo = Maybe GLib.Callbacks.HookFinalizeFunc
    type AttrLabel HookListFinalizeHookFieldInfo = "finalize_hook"
    type AttrOrigin HookListFinalizeHookFieldInfo = HookList
    attrGet = getHookListFinalizeHook
    attrSet = setHookListFinalizeHook
    attrConstruct = undefined
    attrClear = clearHookListFinalizeHook
    attrTransfer _ v = do
        GLib.Callbacks.mk_HookFinalizeFunc (GLib.Callbacks.wrap_HookFinalizeFunc Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HookList.finalizeHook"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HookList.html#g:attr:finalizeHook"
        })

hookList_finalizeHook :: AttrLabelProxy "finalizeHook"
hookList_finalizeHook = AttrLabelProxy

#endif


-- XXX Skipped attribute for "HookList:dummy"
-- Not implemented: Don't know how to unpack C array of type TCArray False 2 (-1) (TBasicType TPtr)

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList HookList
type instance O.AttributeList HookList = HookListAttributeList
type HookListAttributeList = ('[ '("seqId", HookListSeqIdFieldInfo), '("hookSize", HookListHookSizeFieldInfo), '("isSetup", HookListIsSetupFieldInfo), '("hooks", HookListHooksFieldInfo), '("dummy3", HookListDummy3FieldInfo), '("finalizeHook", HookListFinalizeHookFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method HookList::clear
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "hook_list"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "HookList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GHookList" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_hook_list_clear" g_hook_list_clear :: 
    Ptr HookList ->                         -- hook_list : TInterface (Name {namespace = "GLib", name = "HookList"})
    IO ()

-- | Removes all the t'GI.GLib.Structs.Hook.Hook' elements from a t'GI.GLib.Structs.HookList.HookList'.
hookListClear ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    HookList
    -- ^ /@hookList@/: a t'GI.GLib.Structs.HookList.HookList'
    -> m ()
hookListClear hookList = liftIO $ do
    hookList' <- unsafeManagedPtrGetPtr hookList
    g_hook_list_clear hookList'
    touchManagedPtr hookList
    return ()

#if defined(ENABLE_OVERLOADING)
data HookListClearMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod HookListClearMethodInfo HookList signature where
    overloadedMethod = hookListClear

instance O.OverloadedMethodInfo HookListClearMethodInfo HookList where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HookList.hookListClear",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HookList.html#v:hookListClear"
        })


#endif

-- method HookList::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "hook_list"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "HookList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GHookList" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hook_size"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the size of each element in the #GHookList,\n    typically `sizeof (GHook)`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_hook_list_init" g_hook_list_init :: 
    Ptr HookList ->                         -- hook_list : TInterface (Name {namespace = "GLib", name = "HookList"})
    Word32 ->                               -- hook_size : TBasicType TUInt
    IO ()

-- | Initializes a t'GI.GLib.Structs.HookList.HookList'.
-- This must be called before the t'GI.GLib.Structs.HookList.HookList' is used.
hookListInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    HookList
    -- ^ /@hookList@/: a t'GI.GLib.Structs.HookList.HookList'
    -> Word32
    -- ^ /@hookSize@/: the size of each element in the t'GI.GLib.Structs.HookList.HookList',
    --     typically @sizeof (GHook)@.
    -> m ()
hookListInit hookList hookSize = liftIO $ do
    hookList' <- unsafeManagedPtrGetPtr hookList
    g_hook_list_init hookList' hookSize
    touchManagedPtr hookList
    return ()

#if defined(ENABLE_OVERLOADING)
data HookListInitMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m) => O.OverloadedMethod HookListInitMethodInfo HookList signature where
    overloadedMethod = hookListInit

instance O.OverloadedMethodInfo HookListInitMethodInfo HookList where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HookList.hookListInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HookList.html#v:hookListInit"
        })


#endif

-- method HookList::invoke
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "hook_list"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "HookList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GHookList" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "may_recurse"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "%TRUE if functions which are already running\n    (e.g. in another thread) can be called. If set to %FALSE,\n    these are skipped"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_hook_list_invoke" g_hook_list_invoke :: 
    Ptr HookList ->                         -- hook_list : TInterface (Name {namespace = "GLib", name = "HookList"})
    CInt ->                                 -- may_recurse : TBasicType TBoolean
    IO ()

-- | Calls all of the t'GI.GLib.Structs.Hook.Hook' functions in a t'GI.GLib.Structs.HookList.HookList'.
hookListInvoke ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    HookList
    -- ^ /@hookList@/: a t'GI.GLib.Structs.HookList.HookList'
    -> Bool
    -- ^ /@mayRecurse@/: 'P.True' if functions which are already running
    --     (e.g. in another thread) can be called. If set to 'P.False',
    --     these are skipped
    -> m ()
hookListInvoke hookList mayRecurse = liftIO $ do
    hookList' <- unsafeManagedPtrGetPtr hookList
    let mayRecurse' = (P.fromIntegral . P.fromEnum) mayRecurse
    g_hook_list_invoke hookList' mayRecurse'
    touchManagedPtr hookList
    return ()

#if defined(ENABLE_OVERLOADING)
data HookListInvokeMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m) => O.OverloadedMethod HookListInvokeMethodInfo HookList signature where
    overloadedMethod = hookListInvoke

instance O.OverloadedMethodInfo HookListInvokeMethodInfo HookList where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HookList.hookListInvoke",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HookList.html#v:hookListInvoke"
        })


#endif

-- method HookList::invoke_check
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "hook_list"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "HookList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GHookList" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "may_recurse"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "%TRUE if functions which are already running\n    (e.g. in another thread) can be called. If set to %FALSE,\n    these are skipped"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_hook_list_invoke_check" g_hook_list_invoke_check :: 
    Ptr HookList ->                         -- hook_list : TInterface (Name {namespace = "GLib", name = "HookList"})
    CInt ->                                 -- may_recurse : TBasicType TBoolean
    IO ()

-- | Calls all of the t'GI.GLib.Structs.Hook.Hook' functions in a t'GI.GLib.Structs.HookList.HookList'.
-- Any function which returns 'P.False' is removed from the t'GI.GLib.Structs.HookList.HookList'.
hookListInvokeCheck ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    HookList
    -- ^ /@hookList@/: a t'GI.GLib.Structs.HookList.HookList'
    -> Bool
    -- ^ /@mayRecurse@/: 'P.True' if functions which are already running
    --     (e.g. in another thread) can be called. If set to 'P.False',
    --     these are skipped
    -> m ()
hookListInvokeCheck hookList mayRecurse = liftIO $ do
    hookList' <- unsafeManagedPtrGetPtr hookList
    let mayRecurse' = (P.fromIntegral . P.fromEnum) mayRecurse
    g_hook_list_invoke_check hookList' mayRecurse'
    touchManagedPtr hookList
    return ()

#if defined(ENABLE_OVERLOADING)
data HookListInvokeCheckMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m) => O.OverloadedMethod HookListInvokeCheckMethodInfo HookList signature where
    overloadedMethod = hookListInvokeCheck

instance O.OverloadedMethodInfo HookListInvokeCheckMethodInfo HookList where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HookList.hookListInvokeCheck",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HookList.html#v:hookListInvokeCheck"
        })


#endif

-- method HookList::marshal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "hook_list"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "HookList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GHookList" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "may_recurse"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "%TRUE if hooks which are currently running\n    (e.g. in another thread) are considered valid. If set to %FALSE,\n    these are skipped"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshaller"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "HookMarshaller" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the function to call for each #GHook"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @marshaller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_hook_list_marshal" g_hook_list_marshal :: 
    Ptr HookList ->                         -- hook_list : TInterface (Name {namespace = "GLib", name = "HookList"})
    CInt ->                                 -- may_recurse : TBasicType TBoolean
    FunPtr GLib.Callbacks.C_HookMarshaller -> -- marshaller : TInterface (Name {namespace = "GLib", name = "HookMarshaller"})
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | Calls a function on each valid t'GI.GLib.Structs.Hook.Hook'.
hookListMarshal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    HookList
    -- ^ /@hookList@/: a t'GI.GLib.Structs.HookList.HookList'
    -> Bool
    -- ^ /@mayRecurse@/: 'P.True' if hooks which are currently running
    --     (e.g. in another thread) are considered valid. If set to 'P.False',
    --     these are skipped
    -> GLib.Callbacks.HookMarshaller
    -- ^ /@marshaller@/: the function to call for each t'GI.GLib.Structs.Hook.Hook'
    -> m ()
hookListMarshal hookList mayRecurse marshaller = liftIO $ do
    hookList' <- unsafeManagedPtrGetPtr hookList
    let mayRecurse' = (P.fromIntegral . P.fromEnum) mayRecurse
    marshaller' <- GLib.Callbacks.mk_HookMarshaller (GLib.Callbacks.wrap_HookMarshaller Nothing marshaller)
    let marshalData = nullPtr
    g_hook_list_marshal hookList' mayRecurse' marshaller' marshalData
    safeFreeFunPtr $ castFunPtrToPtr marshaller'
    touchManagedPtr hookList
    return ()

#if defined(ENABLE_OVERLOADING)
data HookListMarshalMethodInfo
instance (signature ~ (Bool -> GLib.Callbacks.HookMarshaller -> m ()), MonadIO m) => O.OverloadedMethod HookListMarshalMethodInfo HookList signature where
    overloadedMethod = hookListMarshal

instance O.OverloadedMethodInfo HookListMarshalMethodInfo HookList where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HookList.hookListMarshal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HookList.html#v:hookListMarshal"
        })


#endif

-- method HookList::marshal_check
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "hook_list"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "HookList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GHookList" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "may_recurse"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "%TRUE if hooks which are currently running\n    (e.g. in another thread) are considered valid. If set to %FALSE,\n    these are skipped"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshaller"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "HookCheckMarshaller" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the function to call for each #GHook"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @marshaller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_hook_list_marshal_check" g_hook_list_marshal_check :: 
    Ptr HookList ->                         -- hook_list : TInterface (Name {namespace = "GLib", name = "HookList"})
    CInt ->                                 -- may_recurse : TBasicType TBoolean
    FunPtr GLib.Callbacks.C_HookCheckMarshaller -> -- marshaller : TInterface (Name {namespace = "GLib", name = "HookCheckMarshaller"})
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | Calls a function on each valid t'GI.GLib.Structs.Hook.Hook' and destroys it if the
-- function returns 'P.False'.
hookListMarshalCheck ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    HookList
    -- ^ /@hookList@/: a t'GI.GLib.Structs.HookList.HookList'
    -> Bool
    -- ^ /@mayRecurse@/: 'P.True' if hooks which are currently running
    --     (e.g. in another thread) are considered valid. If set to 'P.False',
    --     these are skipped
    -> GLib.Callbacks.HookCheckMarshaller
    -- ^ /@marshaller@/: the function to call for each t'GI.GLib.Structs.Hook.Hook'
    -> m ()
hookListMarshalCheck hookList mayRecurse marshaller = liftIO $ do
    hookList' <- unsafeManagedPtrGetPtr hookList
    let mayRecurse' = (P.fromIntegral . P.fromEnum) mayRecurse
    marshaller' <- GLib.Callbacks.mk_HookCheckMarshaller (GLib.Callbacks.wrap_HookCheckMarshaller Nothing marshaller)
    let marshalData = nullPtr
    g_hook_list_marshal_check hookList' mayRecurse' marshaller' marshalData
    safeFreeFunPtr $ castFunPtrToPtr marshaller'
    touchManagedPtr hookList
    return ()

#if defined(ENABLE_OVERLOADING)
data HookListMarshalCheckMethodInfo
instance (signature ~ (Bool -> GLib.Callbacks.HookCheckMarshaller -> m ()), MonadIO m) => O.OverloadedMethod HookListMarshalCheckMethodInfo HookList signature where
    overloadedMethod = hookListMarshalCheck

instance O.OverloadedMethodInfo HookListMarshalCheckMethodInfo HookList where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.HookList.hookListMarshalCheck",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-HookList.html#v:hookListMarshalCheck"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveHookListMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveHookListMethod "clear" o = HookListClearMethodInfo
    ResolveHookListMethod "init" o = HookListInitMethodInfo
    ResolveHookListMethod "invoke" o = HookListInvokeMethodInfo
    ResolveHookListMethod "invokeCheck" o = HookListInvokeCheckMethodInfo
    ResolveHookListMethod "marshal" o = HookListMarshalMethodInfo
    ResolveHookListMethod "marshalCheck" o = HookListMarshalCheckMethodInfo
    ResolveHookListMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveHookListMethod t HookList, O.OverloadedMethod info HookList p) => OL.IsLabel t (HookList -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveHookListMethod t HookList, O.OverloadedMethod info HookList p, R.HasField t HookList p) => R.HasField t HookList p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveHookListMethod t HookList, O.OverloadedMethodInfo info HookList) => OL.IsLabel t (O.MethodProxy info HookList) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


