{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkPixbuf.Objects.PixbufNonAnim
    ( 

-- * Exported types
    PixbufNonAnim(..)                       ,
    IsPixbufNonAnim                         ,
    toPixbufNonAnim                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isStaticImage]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:isStaticImage"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getHeight]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:getHeight"), [getIter]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:getIter"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStaticImage]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:getStaticImage"), [getWidth]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:getWidth").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolvePixbufNonAnimMethod              ,
#endif

-- ** new #method:new#

    pixbufNonAnimNew                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GdkPixbuf.Callbacks as GdkPixbuf.Callbacks
import {-# SOURCE #-} qualified GI.GdkPixbuf.Enums as GdkPixbuf.Enums
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.PixbufAnimation as GdkPixbuf.PixbufAnimation
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.PixbufAnimationIter as GdkPixbuf.PixbufAnimationIter
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufFormat as GdkPixbuf.PixbufFormat
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufModulePattern as GdkPixbuf.PixbufModulePattern
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.PixbufAnimation as GdkPixbuf.PixbufAnimation

#endif

-- | Memory-managed wrapper type.
newtype PixbufNonAnim = PixbufNonAnim (SP.ManagedPtr PixbufNonAnim)
    deriving (Eq)

instance SP.ManagedPtrNewtype PixbufNonAnim where
    toManagedPtr (PixbufNonAnim p) = p

foreign import ccall "gdk_pixbuf_non_anim_get_type"
    c_gdk_pixbuf_non_anim_get_type :: IO B.Types.GType

instance B.Types.TypedObject PixbufNonAnim where
    glibType = c_gdk_pixbuf_non_anim_get_type

instance B.Types.GObject PixbufNonAnim

-- | Type class for types which can be safely cast to t'PixbufNonAnim', for instance with `toPixbufNonAnim`.
class (SP.GObject o, O.IsDescendantOf PixbufNonAnim o) => IsPixbufNonAnim o
instance (SP.GObject o, O.IsDescendantOf PixbufNonAnim o) => IsPixbufNonAnim o

instance O.HasParentTypes PixbufNonAnim
type instance O.ParentTypes PixbufNonAnim = '[GdkPixbuf.PixbufAnimation.PixbufAnimation, GObject.Object.Object]

-- | Cast to t'PixbufNonAnim', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toPixbufNonAnim :: (MIO.MonadIO m, IsPixbufNonAnim o) => o -> m PixbufNonAnim
toPixbufNonAnim = MIO.liftIO . B.ManagedPtr.unsafeCastTo PixbufNonAnim

-- | Convert t'PixbufNonAnim' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PixbufNonAnim) where
    gvalueGType_ = c_gdk_pixbuf_non_anim_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr PixbufNonAnim)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr PixbufNonAnim)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject PixbufNonAnim ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolvePixbufNonAnimMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePixbufNonAnimMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePixbufNonAnimMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePixbufNonAnimMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePixbufNonAnimMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePixbufNonAnimMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePixbufNonAnimMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePixbufNonAnimMethod "isStaticImage" o = GdkPixbuf.PixbufAnimation.PixbufAnimationIsStaticImageMethodInfo
    ResolvePixbufNonAnimMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePixbufNonAnimMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePixbufNonAnimMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePixbufNonAnimMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePixbufNonAnimMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePixbufNonAnimMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePixbufNonAnimMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePixbufNonAnimMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePixbufNonAnimMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePixbufNonAnimMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePixbufNonAnimMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePixbufNonAnimMethod "getHeight" o = GdkPixbuf.PixbufAnimation.PixbufAnimationGetHeightMethodInfo
    ResolvePixbufNonAnimMethod "getIter" o = GdkPixbuf.PixbufAnimation.PixbufAnimationGetIterMethodInfo
    ResolvePixbufNonAnimMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePixbufNonAnimMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePixbufNonAnimMethod "getStaticImage" o = GdkPixbuf.PixbufAnimation.PixbufAnimationGetStaticImageMethodInfo
    ResolvePixbufNonAnimMethod "getWidth" o = GdkPixbuf.PixbufAnimation.PixbufAnimationGetWidthMethodInfo
    ResolvePixbufNonAnimMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePixbufNonAnimMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePixbufNonAnimMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePixbufNonAnimMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePixbufNonAnimMethod t PixbufNonAnim, O.OverloadedMethod info PixbufNonAnim p) => OL.IsLabel t (PixbufNonAnim -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePixbufNonAnimMethod t PixbufNonAnim, O.OverloadedMethod info PixbufNonAnim p, R.HasField t PixbufNonAnim p) => R.HasField t PixbufNonAnim p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePixbufNonAnimMethod t PixbufNonAnim, O.OverloadedMethodInfo info PixbufNonAnim) => OL.IsLabel t (O.MethodProxy info PixbufNonAnim) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PixbufNonAnim
type instance O.AttributeList PixbufNonAnim = PixbufNonAnimAttributeList
type PixbufNonAnimAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList PixbufNonAnim = PixbufNonAnimSignalList
type PixbufNonAnimSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method PixbufNonAnim::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "pixbuf"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GdkPixbuf" , name = "PixbufNonAnim" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_non_anim_new" gdk_pixbuf_non_anim_new :: 
    Ptr GdkPixbuf.Pixbuf.Pixbuf ->          -- pixbuf : TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"})
    IO (Ptr PixbufNonAnim)

-- | /No description available in the introspection data./
pixbufNonAnimNew ::
    (B.CallStack.HasCallStack, MonadIO m, GdkPixbuf.Pixbuf.IsPixbuf a) =>
    a
    -> m PixbufNonAnim
pixbufNonAnimNew pixbuf = liftIO $ do
    pixbuf' <- unsafeManagedPtrCastPtr pixbuf
    result <- gdk_pixbuf_non_anim_new pixbuf'
    checkUnexpectedReturnNULL "pixbufNonAnimNew" result
    result' <- (wrapObject PixbufNonAnim) result
    touchManagedPtr pixbuf
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


