{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Provides content for the clipboard or for drag-and-drop operations
-- in a number of formats.
-- 
-- To create a @GdkContentProvider@, use 'GI.Gdk.Objects.ContentProvider.contentProviderNewForValue'
-- or 'GI.Gdk.Objects.ContentProvider.contentProviderNewForBytes'.
-- 
-- GDK knows how to handle common text and image formats out-of-the-box. See
-- t'GI.Gdk.Objects.ContentSerializer.ContentSerializer' and t'GI.Gdk.Objects.ContentDeserializer.ContentDeserializer' if you want
-- to add support for application-specific data formats.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.ContentProvider
    ( 

-- * Exported types
    ContentProvider(..)                     ,
    IsContentProvider                       ,
    toContentProvider                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [contentChanged]("GI.Gdk.Objects.ContentProvider#g:method:contentChanged"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refFormats]("GI.Gdk.Objects.ContentProvider#g:method:refFormats"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [refStorableFormats]("GI.Gdk.Objects.ContentProvider#g:method:refStorableFormats"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure"), [writeMimeTypeAsync]("GI.Gdk.Objects.ContentProvider#g:method:writeMimeTypeAsync"), [writeMimeTypeFinish]("GI.Gdk.Objects.ContentProvider#g:method:writeMimeTypeFinish").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getValue]("GI.Gdk.Objects.ContentProvider#g:method:getValue").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveContentProviderMethod            ,
#endif

-- ** contentChanged #method:contentChanged#

#if defined(ENABLE_OVERLOADING)
    ContentProviderContentChangedMethodInfo ,
#endif
    contentProviderContentChanged           ,


-- ** getValue #method:getValue#

#if defined(ENABLE_OVERLOADING)
    ContentProviderGetValueMethodInfo       ,
#endif
    contentProviderGetValue                 ,


-- ** newForBytes #method:newForBytes#

    contentProviderNewForBytes              ,


-- ** newForValue #method:newForValue#

    contentProviderNewForValue              ,


-- ** newUnion #method:newUnion#

    contentProviderNewUnion                 ,


-- ** refFormats #method:refFormats#

#if defined(ENABLE_OVERLOADING)
    ContentProviderRefFormatsMethodInfo     ,
#endif
    contentProviderRefFormats               ,


-- ** refStorableFormats #method:refStorableFormats#

#if defined(ENABLE_OVERLOADING)
    ContentProviderRefStorableFormatsMethodInfo,
#endif
    contentProviderRefStorableFormats       ,


-- ** writeMimeTypeAsync #method:writeMimeTypeAsync#

#if defined(ENABLE_OVERLOADING)
    ContentProviderWriteMimeTypeAsyncMethodInfo,
#endif
    contentProviderWriteMimeTypeAsync       ,


-- ** writeMimeTypeFinish #method:writeMimeTypeFinish#

#if defined(ENABLE_OVERLOADING)
    ContentProviderWriteMimeTypeFinishMethodInfo,
#endif
    contentProviderWriteMimeTypeFinish      ,




 -- * Properties


-- ** formats #attr:formats#
-- | The possible formats that the provider can provide its data in.

#if defined(ENABLE_OVERLOADING)
    ContentProviderFormatsPropertyInfo      ,
#endif
#if defined(ENABLE_OVERLOADING)
    contentProviderFormats                  ,
#endif
    getContentProviderFormats               ,


-- ** storableFormats #attr:storableFormats#
-- | The subset of formats that clipboard managers should store this provider\'s data in.

#if defined(ENABLE_OVERLOADING)
    ContentProviderStorableFormatsPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    contentProviderStorableFormats          ,
#endif
    getContentProviderStorableFormats       ,




 -- * Signals


-- ** contentChanged #signal:contentChanged#

    ContentProviderContentChangedCallback   ,
#if defined(ENABLE_OVERLOADING)
    ContentProviderContentChangedSignalInfo ,
#endif
    afterContentProviderContentChanged      ,
    onContentProviderContentChanged         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#else
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#endif

-- | Memory-managed wrapper type.
newtype ContentProvider = ContentProvider (SP.ManagedPtr ContentProvider)
    deriving (Eq)

instance SP.ManagedPtrNewtype ContentProvider where
    toManagedPtr (ContentProvider p) = p

foreign import ccall "gdk_content_provider_get_type"
    c_gdk_content_provider_get_type :: IO B.Types.GType

instance B.Types.TypedObject ContentProvider where
    glibType = c_gdk_content_provider_get_type

instance B.Types.GObject ContentProvider

-- | Type class for types which can be safely cast to t'ContentProvider', for instance with `toContentProvider`.
class (SP.GObject o, O.IsDescendantOf ContentProvider o) => IsContentProvider o
instance (SP.GObject o, O.IsDescendantOf ContentProvider o) => IsContentProvider o

instance O.HasParentTypes ContentProvider
type instance O.ParentTypes ContentProvider = '[GObject.Object.Object]

-- | Cast to t'ContentProvider', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toContentProvider :: (MIO.MonadIO m, IsContentProvider o) => o -> m ContentProvider
toContentProvider = MIO.liftIO . B.ManagedPtr.unsafeCastTo ContentProvider

-- | Convert t'ContentProvider' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ContentProvider) where
    gvalueGType_ = c_gdk_content_provider_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ContentProvider)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ContentProvider)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ContentProvider ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveContentProviderMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveContentProviderMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveContentProviderMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveContentProviderMethod "contentChanged" o = ContentProviderContentChangedMethodInfo
    ResolveContentProviderMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveContentProviderMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveContentProviderMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveContentProviderMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveContentProviderMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveContentProviderMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveContentProviderMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveContentProviderMethod "refFormats" o = ContentProviderRefFormatsMethodInfo
    ResolveContentProviderMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveContentProviderMethod "refStorableFormats" o = ContentProviderRefStorableFormatsMethodInfo
    ResolveContentProviderMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveContentProviderMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveContentProviderMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveContentProviderMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveContentProviderMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveContentProviderMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveContentProviderMethod "writeMimeTypeAsync" o = ContentProviderWriteMimeTypeAsyncMethodInfo
    ResolveContentProviderMethod "writeMimeTypeFinish" o = ContentProviderWriteMimeTypeFinishMethodInfo
    ResolveContentProviderMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveContentProviderMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveContentProviderMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveContentProviderMethod "getValue" o = ContentProviderGetValueMethodInfo
    ResolveContentProviderMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveContentProviderMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveContentProviderMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveContentProviderMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveContentProviderMethod t ContentProvider, O.OverloadedMethod info ContentProvider p) => OL.IsLabel t (ContentProvider -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveContentProviderMethod t ContentProvider, O.OverloadedMethod info ContentProvider p, R.HasField t ContentProvider p) => R.HasField t ContentProvider p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveContentProviderMethod t ContentProvider, O.OverloadedMethodInfo info ContentProvider) => OL.IsLabel t (O.MethodProxy info ContentProvider) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal ContentProvider::content-changed
-- | Emitted whenever the content provided by this provider has changed.
type ContentProviderContentChangedCallback =
    IO ()

type C_ContentProviderContentChangedCallback =
    Ptr ContentProvider ->                  -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ContentProviderContentChangedCallback`.
foreign import ccall "wrapper"
    mk_ContentProviderContentChangedCallback :: C_ContentProviderContentChangedCallback -> IO (FunPtr C_ContentProviderContentChangedCallback)

wrap_ContentProviderContentChangedCallback :: 
    GObject a => (a -> ContentProviderContentChangedCallback) ->
    C_ContentProviderContentChangedCallback
wrap_ContentProviderContentChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [contentChanged](#signal:contentChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' contentProvider #contentChanged callback
-- @
-- 
-- 
onContentProviderContentChanged :: (IsContentProvider a, MonadIO m) => a -> ((?self :: a) => ContentProviderContentChangedCallback) -> m SignalHandlerId
onContentProviderContentChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ContentProviderContentChangedCallback wrapped
    wrapped'' <- mk_ContentProviderContentChangedCallback wrapped'
    connectSignalFunPtr obj "content-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [contentChanged](#signal:contentChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' contentProvider #contentChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterContentProviderContentChanged :: (IsContentProvider a, MonadIO m) => a -> ((?self :: a) => ContentProviderContentChangedCallback) -> m SignalHandlerId
afterContentProviderContentChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ContentProviderContentChangedCallback wrapped
    wrapped'' <- mk_ContentProviderContentChangedCallback wrapped'
    connectSignalFunPtr obj "content-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ContentProviderContentChangedSignalInfo
instance SignalInfo ContentProviderContentChangedSignalInfo where
    type HaskellCallbackType ContentProviderContentChangedSignalInfo = ContentProviderContentChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ContentProviderContentChangedCallback cb
        cb'' <- mk_ContentProviderContentChangedCallback cb'
        connectSignalFunPtr obj "content-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentProvider::content-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentProvider.html#g:signal:contentChanged"})

#endif

-- VVV Prop "formats"
   -- Type: TInterface (Name {namespace = "Gdk", name = "ContentFormats"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@formats@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' contentProvider #formats
-- @
getContentProviderFormats :: (MonadIO m, IsContentProvider o) => o -> m (Maybe Gdk.ContentFormats.ContentFormats)
getContentProviderFormats obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "formats" Gdk.ContentFormats.ContentFormats

#if defined(ENABLE_OVERLOADING)
data ContentProviderFormatsPropertyInfo
instance AttrInfo ContentProviderFormatsPropertyInfo where
    type AttrAllowedOps ContentProviderFormatsPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ContentProviderFormatsPropertyInfo = IsContentProvider
    type AttrSetTypeConstraint ContentProviderFormatsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ContentProviderFormatsPropertyInfo = (~) ()
    type AttrTransferType ContentProviderFormatsPropertyInfo = ()
    type AttrGetType ContentProviderFormatsPropertyInfo = (Maybe Gdk.ContentFormats.ContentFormats)
    type AttrLabel ContentProviderFormatsPropertyInfo = "formats"
    type AttrOrigin ContentProviderFormatsPropertyInfo = ContentProvider
    attrGet = getContentProviderFormats
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentProvider.formats"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentProvider.html#g:attr:formats"
        })
#endif

-- VVV Prop "storable-formats"
   -- Type: TInterface (Name {namespace = "Gdk", name = "ContentFormats"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@storable-formats@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' contentProvider #storableFormats
-- @
getContentProviderStorableFormats :: (MonadIO m, IsContentProvider o) => o -> m (Maybe Gdk.ContentFormats.ContentFormats)
getContentProviderStorableFormats obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "storable-formats" Gdk.ContentFormats.ContentFormats

#if defined(ENABLE_OVERLOADING)
data ContentProviderStorableFormatsPropertyInfo
instance AttrInfo ContentProviderStorableFormatsPropertyInfo where
    type AttrAllowedOps ContentProviderStorableFormatsPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ContentProviderStorableFormatsPropertyInfo = IsContentProvider
    type AttrSetTypeConstraint ContentProviderStorableFormatsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ContentProviderStorableFormatsPropertyInfo = (~) ()
    type AttrTransferType ContentProviderStorableFormatsPropertyInfo = ()
    type AttrGetType ContentProviderStorableFormatsPropertyInfo = (Maybe Gdk.ContentFormats.ContentFormats)
    type AttrLabel ContentProviderStorableFormatsPropertyInfo = "storable-formats"
    type AttrOrigin ContentProviderStorableFormatsPropertyInfo = ContentProvider
    attrGet = getContentProviderStorableFormats
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentProvider.storableFormats"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentProvider.html#g:attr:storableFormats"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ContentProvider
type instance O.AttributeList ContentProvider = ContentProviderAttributeList
type ContentProviderAttributeList = ('[ '("formats", ContentProviderFormatsPropertyInfo), '("storableFormats", ContentProviderStorableFormatsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
contentProviderFormats :: AttrLabelProxy "formats"
contentProviderFormats = AttrLabelProxy

contentProviderStorableFormats :: AttrLabelProxy "storableFormats"
contentProviderStorableFormats = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ContentProvider = ContentProviderSignalList
type ContentProviderSignalList = ('[ '("contentChanged", ContentProviderContentChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ContentProvider::new_for_bytes
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "mime_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the mime type" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes"
--           , argType = TInterface Name { namespace = "GLib" , name = "Bytes" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GBytes` with the data for @mime_type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ContentProvider" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_provider_new_for_bytes" gdk_content_provider_new_for_bytes :: 
    CString ->                              -- mime_type : TBasicType TUTF8
    Ptr GLib.Bytes.Bytes ->                 -- bytes : TInterface (Name {namespace = "GLib", name = "Bytes"})
    IO (Ptr ContentProvider)

-- | Create a content provider that provides the given /@bytes@/ as data for
-- the given /@mimeType@/.
contentProviderNewForBytes ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@mimeType@/: the mime type
    -> GLib.Bytes.Bytes
    -- ^ /@bytes@/: a @GBytes@ with the data for /@mimeType@/
    -> m ContentProvider
    -- ^ __Returns:__ a new @GdkContentProvider@
contentProviderNewForBytes mimeType bytes = liftIO $ do
    mimeType' <- textToCString mimeType
    bytes' <- unsafeManagedPtrGetPtr bytes
    result <- gdk_content_provider_new_for_bytes mimeType' bytes'
    checkUnexpectedReturnNULL "contentProviderNewForBytes" result
    result' <- (wrapObject ContentProvider) result
    touchManagedPtr bytes
    freeMem mimeType'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ContentProvider::new_for_value
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GValue`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ContentProvider" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_provider_new_for_value" gdk_content_provider_new_for_value :: 
    Ptr GValue ->                           -- value : TGValue
    IO (Ptr ContentProvider)

-- | Create a content provider that provides the given /@value@/.
contentProviderNewForValue ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GValue
    -- ^ /@value@/: a @GValue@
    -> m ContentProvider
    -- ^ __Returns:__ a new @GdkContentProvider@
contentProviderNewForValue value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    result <- gdk_content_provider_new_for_value value'
    checkUnexpectedReturnNULL "contentProviderNewForValue" result
    result' <- (wrapObject ContentProvider) result
    touchManagedPtr value
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ContentProvider::new_union
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "providers"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 1
--                 (TInterface Name { namespace = "Gdk" , name = "ContentProvider" })
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "\n  The `GdkContentProvider`s to present the union of"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "n_providers"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of providers"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_providers"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of providers"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ContentProvider" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_provider_new_union" gdk_content_provider_new_union :: 
    Ptr (Ptr ContentProvider) ->            -- providers : TCArray False (-1) 1 (TInterface (Name {namespace = "Gdk", name = "ContentProvider"}))
    FCT.CSize ->                            -- n_providers : TBasicType TSize
    IO (Ptr ContentProvider)

-- | Creates a content provider that represents all the given /@providers@/.
-- 
-- Whenever data needs to be written, the union provider will try the given
-- /@providers@/ in the given order and the first one supporting a format will
-- be chosen to provide it.
-- 
-- This allows an easy way to support providing data in different formats.
-- For example, an image may be provided by its file and by the image
-- contents with a call such as
-- 
-- === /c code/
-- >gdk_content_provider_new_union ((GdkContentProvider *[2]) {
-- >                                  gdk_content_provider_new_typed (G_TYPE_FILE, file),
-- >                                  gdk_content_provider_new_typed (GDK_TYPE_TEXTURE, texture)
-- >                                }, 2);
contentProviderNewUnion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([ContentProvider])
    -- ^ /@providers@/: 
    --   The @GdkContentProvider@s to present the union of
    -> m ContentProvider
    -- ^ __Returns:__ a new @GdkContentProvider@
contentProviderNewUnion providers = liftIO $ do
    let nProviders = case providers of
            Nothing -> 0
            Just jProviders -> fromIntegral $ P.length jProviders
    maybeProviders <- case providers of
        Nothing -> return FP.nullPtr
        Just jProviders -> do
            jProviders' <- mapM B.ManagedPtr.disownObject jProviders
            jProviders'' <- packPtrArray jProviders'
            return jProviders''
    result <- gdk_content_provider_new_union maybeProviders nProviders
    checkUnexpectedReturnNULL "contentProviderNewUnion" result
    result' <- (wrapObject ContentProvider) result
    whenJust providers (mapM_ touchManagedPtr)
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ContentProvider::content_changed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "provider"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ContentProvider" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentProvider`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_provider_content_changed" gdk_content_provider_content_changed :: 
    Ptr ContentProvider ->                  -- provider : TInterface (Name {namespace = "Gdk", name = "ContentProvider"})
    IO ()

-- | Emits the [contentChanged](#g:signal:contentChanged) signal.
contentProviderContentChanged ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentProvider a) =>
    a
    -- ^ /@provider@/: a @GdkContentProvider@
    -> m ()
contentProviderContentChanged provider = liftIO $ do
    provider' <- unsafeManagedPtrCastPtr provider
    gdk_content_provider_content_changed provider'
    touchManagedPtr provider
    return ()

#if defined(ENABLE_OVERLOADING)
data ContentProviderContentChangedMethodInfo
instance (signature ~ (m ()), MonadIO m, IsContentProvider a) => O.OverloadedMethod ContentProviderContentChangedMethodInfo a signature where
    overloadedMethod = contentProviderContentChanged

instance O.OverloadedMethodInfo ContentProviderContentChangedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentProvider.contentProviderContentChanged",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentProvider.html#v:contentProviderContentChanged"
        })


#endif

-- method ContentProvider::get_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "provider"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ContentProvider" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentProvider`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GValue` to fill"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gdk_content_provider_get_value" gdk_content_provider_get_value :: 
    Ptr ContentProvider ->                  -- provider : TInterface (Name {namespace = "Gdk", name = "ContentProvider"})
    Ptr GValue ->                           -- value : TGValue
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Gets the contents of /@provider@/ stored in /@value@/.
-- 
-- The /@value@/ will have been initialized to the @GType@ the value should be
-- provided in. This given @GType@ does not need to be listed in the formats
-- returned by 'GI.Gdk.Objects.ContentProvider.contentProviderRefFormats'. However, if the
-- given @GType@ is not supported, this operation can fail and
-- @G_IO_ERROR_NOT_SUPPORTED@ will be reported.
contentProviderGetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentProvider a) =>
    a
    -- ^ /@provider@/: a @GdkContentProvider@
    -> GValue
    -- ^ /@value@/: the @GValue@ to fill
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
contentProviderGetValue provider value = liftIO $ do
    provider' <- unsafeManagedPtrCastPtr provider
    value' <- unsafeManagedPtrGetPtr value
    onException (do
        _ <- propagateGError $ gdk_content_provider_get_value provider' value'
        touchManagedPtr provider
        touchManagedPtr value
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data ContentProviderGetValueMethodInfo
instance (signature ~ (GValue -> m ()), MonadIO m, IsContentProvider a) => O.OverloadedMethod ContentProviderGetValueMethodInfo a signature where
    overloadedMethod = contentProviderGetValue

instance O.OverloadedMethodInfo ContentProviderGetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentProvider.contentProviderGetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentProvider.html#v:contentProviderGetValue"
        })


#endif

-- method ContentProvider::ref_formats
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "provider"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ContentProvider" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentProvider`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ContentFormats" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_provider_ref_formats" gdk_content_provider_ref_formats :: 
    Ptr ContentProvider ->                  -- provider : TInterface (Name {namespace = "Gdk", name = "ContentProvider"})
    IO (Ptr Gdk.ContentFormats.ContentFormats)

-- | Gets the formats that the provider can provide its current contents in.
contentProviderRefFormats ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentProvider a) =>
    a
    -- ^ /@provider@/: a @GdkContentProvider@
    -> m Gdk.ContentFormats.ContentFormats
    -- ^ __Returns:__ The formats of the provider
contentProviderRefFormats provider = liftIO $ do
    provider' <- unsafeManagedPtrCastPtr provider
    result <- gdk_content_provider_ref_formats provider'
    checkUnexpectedReturnNULL "contentProviderRefFormats" result
    result' <- (wrapBoxed Gdk.ContentFormats.ContentFormats) result
    touchManagedPtr provider
    return result'

#if defined(ENABLE_OVERLOADING)
data ContentProviderRefFormatsMethodInfo
instance (signature ~ (m Gdk.ContentFormats.ContentFormats), MonadIO m, IsContentProvider a) => O.OverloadedMethod ContentProviderRefFormatsMethodInfo a signature where
    overloadedMethod = contentProviderRefFormats

instance O.OverloadedMethodInfo ContentProviderRefFormatsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentProvider.contentProviderRefFormats",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentProvider.html#v:contentProviderRefFormats"
        })


#endif

-- method ContentProvider::ref_storable_formats
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "provider"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ContentProvider" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentProvider`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ContentFormats" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_provider_ref_storable_formats" gdk_content_provider_ref_storable_formats :: 
    Ptr ContentProvider ->                  -- provider : TInterface (Name {namespace = "Gdk", name = "ContentProvider"})
    IO (Ptr Gdk.ContentFormats.ContentFormats)

-- | Gets the formats that the provider suggests other applications to store
-- the data in.
-- 
-- An example of such an application would be a clipboard manager.
-- 
-- This can be assumed to be a subset of 'GI.Gdk.Objects.ContentProvider.contentProviderRefFormats'.
contentProviderRefStorableFormats ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentProvider a) =>
    a
    -- ^ /@provider@/: a @GdkContentProvider@
    -> m Gdk.ContentFormats.ContentFormats
    -- ^ __Returns:__ The storable formats of the provider
contentProviderRefStorableFormats provider = liftIO $ do
    provider' <- unsafeManagedPtrCastPtr provider
    result <- gdk_content_provider_ref_storable_formats provider'
    checkUnexpectedReturnNULL "contentProviderRefStorableFormats" result
    result' <- (wrapBoxed Gdk.ContentFormats.ContentFormats) result
    touchManagedPtr provider
    return result'

#if defined(ENABLE_OVERLOADING)
data ContentProviderRefStorableFormatsMethodInfo
instance (signature ~ (m Gdk.ContentFormats.ContentFormats), MonadIO m, IsContentProvider a) => O.OverloadedMethod ContentProviderRefStorableFormatsMethodInfo a signature where
    overloadedMethod = contentProviderRefStorableFormats

instance O.OverloadedMethodInfo ContentProviderRefStorableFormatsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentProvider.contentProviderRefStorableFormats",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentProvider.html#v:contentProviderRefStorableFormats"
        })


#endif

-- method ContentProvider::write_mime_type_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "provider"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ContentProvider" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentProvider`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mime_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the mime type to provide the data in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "OutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GOutputStream` to write to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "I/O priority of the request."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional `GCancellable` object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "callback to call when the request is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 6
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_content_provider_write_mime_type_async" gdk_content_provider_write_mime_type_async :: 
    Ptr ContentProvider ->                  -- provider : TInterface (Name {namespace = "Gdk", name = "ContentProvider"})
    CString ->                              -- mime_type : TBasicType TUTF8
    Ptr Gio.OutputStream.OutputStream ->    -- stream : TInterface (Name {namespace = "Gio", name = "OutputStream"})
    Int32 ->                                -- io_priority : TBasicType TInt
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronously writes the contents of /@provider@/ to /@stream@/ in the given
-- /@mimeType@/.
-- 
-- The given mime type does not need to be listed in the formats returned by
-- 'GI.Gdk.Objects.ContentProvider.contentProviderRefFormats'. However, if the given @GType@ is
-- not supported, @G_IO_ERROR_NOT_SUPPORTED@ will be reported.
-- 
-- The given /@stream@/ will not be closed.
contentProviderWriteMimeTypeAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentProvider a, Gio.OutputStream.IsOutputStream b, Gio.Cancellable.IsCancellable c) =>
    a
    -- ^ /@provider@/: a @GdkContentProvider@
    -> T.Text
    -- ^ /@mimeType@/: the mime type to provide the data in
    -> b
    -- ^ /@stream@/: the @GOutputStream@ to write to
    -> Int32
    -- ^ /@ioPriority@/: I\/O priority of the request.
    -> Maybe (c)
    -- ^ /@cancellable@/: optional @GCancellable@ object, 'P.Nothing' to ignore.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: callback to call when the request is satisfied
    -> m ()
contentProviderWriteMimeTypeAsync provider mimeType stream ioPriority cancellable callback = liftIO $ do
    provider' <- unsafeManagedPtrCastPtr provider
    mimeType' <- textToCString mimeType
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    gdk_content_provider_write_mime_type_async provider' mimeType' stream' ioPriority maybeCancellable maybeCallback userData
    touchManagedPtr provider
    touchManagedPtr stream
    whenJust cancellable touchManagedPtr
    freeMem mimeType'
    return ()

#if defined(ENABLE_OVERLOADING)
data ContentProviderWriteMimeTypeAsyncMethodInfo
instance (signature ~ (T.Text -> b -> Int32 -> Maybe (c) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsContentProvider a, Gio.OutputStream.IsOutputStream b, Gio.Cancellable.IsCancellable c) => O.OverloadedMethod ContentProviderWriteMimeTypeAsyncMethodInfo a signature where
    overloadedMethod = contentProviderWriteMimeTypeAsync

instance O.OverloadedMethodInfo ContentProviderWriteMimeTypeAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentProvider.contentProviderWriteMimeTypeAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentProvider.html#v:contentProviderWriteMimeTypeAsync"
        })


#endif

-- method ContentProvider::write_mime_type_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "provider"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ContentProvider" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkContentProvider`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GAsyncResult`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gdk_content_provider_write_mime_type_finish" gdk_content_provider_write_mime_type_finish :: 
    Ptr ContentProvider ->                  -- provider : TInterface (Name {namespace = "Gdk", name = "ContentProvider"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Finishes an asynchronous write operation.
-- 
-- See 'GI.Gdk.Objects.ContentProvider.contentProviderWriteMimeTypeAsync'.
contentProviderWriteMimeTypeFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsContentProvider a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@provider@/: a @GdkContentProvider@
    -> b
    -- ^ /@result@/: a @GAsyncResult@
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
contentProviderWriteMimeTypeFinish provider result_ = liftIO $ do
    provider' <- unsafeManagedPtrCastPtr provider
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ gdk_content_provider_write_mime_type_finish provider' result_'
        touchManagedPtr provider
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data ContentProviderWriteMimeTypeFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsContentProvider a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod ContentProviderWriteMimeTypeFinishMethodInfo a signature where
    overloadedMethod = contentProviderWriteMimeTypeFinish

instance O.OverloadedMethodInfo ContentProviderWriteMimeTypeFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.ContentProvider.contentProviderWriteMimeTypeFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-ContentProvider.html#v:contentProviderWriteMimeTypeFinish"
        })


#endif


