{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A server which represents a sharing of a set of
-- 	@/DbusmenuMenuitems/@ across DBus to a t'GI.Dbusmenu.Objects.Client.Client'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Dbusmenu.Objects.Server
    ( 

-- * Exported types
    Server(..)                              ,
    IsServer                                ,
    toServer                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getIconPaths]("GI.Dbusmenu.Objects.Server#g:method:getIconPaths"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStatus]("GI.Dbusmenu.Objects.Server#g:method:getStatus"), [getTextDirection]("GI.Dbusmenu.Objects.Server#g:method:getTextDirection").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setIconPaths]("GI.Dbusmenu.Objects.Server#g:method:setIconPaths"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRoot]("GI.Dbusmenu.Objects.Server#g:method:setRoot"), [setStatus]("GI.Dbusmenu.Objects.Server#g:method:setStatus"), [setTextDirection]("GI.Dbusmenu.Objects.Server#g:method:setTextDirection").

#if defined(ENABLE_OVERLOADING)
    ResolveServerMethod                     ,
#endif

-- ** getIconPaths #method:getIconPaths#

#if defined(ENABLE_OVERLOADING)
    ServerGetIconPathsMethodInfo            ,
#endif
    serverGetIconPaths                      ,


-- ** getStatus #method:getStatus#

#if defined(ENABLE_OVERLOADING)
    ServerGetStatusMethodInfo               ,
#endif
    serverGetStatus                         ,


-- ** getTextDirection #method:getTextDirection#

#if defined(ENABLE_OVERLOADING)
    ServerGetTextDirectionMethodInfo        ,
#endif
    serverGetTextDirection                  ,


-- ** new #method:new#

    serverNew                               ,


-- ** setIconPaths #method:setIconPaths#

#if defined(ENABLE_OVERLOADING)
    ServerSetIconPathsMethodInfo            ,
#endif
    serverSetIconPaths                      ,


-- ** setRoot #method:setRoot#

#if defined(ENABLE_OVERLOADING)
    ServerSetRootMethodInfo                 ,
#endif
    serverSetRoot                           ,


-- ** setStatus #method:setStatus#

#if defined(ENABLE_OVERLOADING)
    ServerSetStatusMethodInfo               ,
#endif
    serverSetStatus                         ,


-- ** setTextDirection #method:setTextDirection#

#if defined(ENABLE_OVERLOADING)
    ServerSetTextDirectionMethodInfo        ,
#endif
    serverSetTextDirection                  ,




 -- * Properties


-- ** dbusObject #attr:dbusObject#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ServerDbusObjectPropertyInfo            ,
#endif
    constructServerDbusObject               ,
    getServerDbusObject                     ,
#if defined(ENABLE_OVERLOADING)
    serverDbusObject                        ,
#endif


-- ** rootNode #attr:rootNode#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ServerRootNodePropertyInfo              ,
#endif
    clearServerRootNode                     ,
    constructServerRootNode                 ,
    getServerRootNode                       ,
#if defined(ENABLE_OVERLOADING)
    serverRootNode                          ,
#endif
    setServerRootNode                       ,


-- ** version #attr:version#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    ServerVersionPropertyInfo               ,
#endif
    getServerVersion                        ,
#if defined(ENABLE_OVERLOADING)
    serverVersion                           ,
#endif




 -- * Signals


-- ** itemActivationRequested #signal:itemActivationRequested#

    ServerItemActivationRequestedCallback   ,
#if defined(ENABLE_OVERLOADING)
    ServerItemActivationRequestedSignalInfo ,
#endif
    afterServerItemActivationRequested      ,
    onServerItemActivationRequested         ,


-- ** itemPropertyUpdated #signal:itemPropertyUpdated#

    ServerItemPropertyUpdatedCallback       ,
#if defined(ENABLE_OVERLOADING)
    ServerItemPropertyUpdatedSignalInfo     ,
#endif
    afterServerItemPropertyUpdated          ,
    onServerItemPropertyUpdated             ,


-- ** itemUpdated #signal:itemUpdated#

    ServerItemUpdatedCallback               ,
#if defined(ENABLE_OVERLOADING)
    ServerItemUpdatedSignalInfo             ,
#endif
    afterServerItemUpdated                  ,
    onServerItemUpdated                     ,


-- ** layoutUpdated #signal:layoutUpdated#

    ServerLayoutUpdatedCallback             ,
#if defined(ENABLE_OVERLOADING)
    ServerLayoutUpdatedSignalInfo           ,
#endif
    afterServerLayoutUpdated                ,
    onServerLayoutUpdated                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Dbusmenu.Enums as Dbusmenu.Enums
import {-# SOURCE #-} qualified GI.Dbusmenu.Objects.Menuitem as Dbusmenu.Menuitem
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import {-# SOURCE #-} qualified GI.Dbusmenu.Enums as Dbusmenu.Enums
import {-# SOURCE #-} qualified GI.Dbusmenu.Objects.Menuitem as Dbusmenu.Menuitem
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype Server = Server (SP.ManagedPtr Server)
    deriving (Eq)

instance SP.ManagedPtrNewtype Server where
    toManagedPtr (Server p) = p

foreign import ccall "dbusmenu_server_get_type"
    c_dbusmenu_server_get_type :: IO B.Types.GType

instance B.Types.TypedObject Server where
    glibType = c_dbusmenu_server_get_type

instance B.Types.GObject Server

-- | Type class for types which can be safely cast to t'Server', for instance with `toServer`.
class (SP.GObject o, O.IsDescendantOf Server o) => IsServer o
instance (SP.GObject o, O.IsDescendantOf Server o) => IsServer o

instance O.HasParentTypes Server
type instance O.ParentTypes Server = '[GObject.Object.Object]

-- | Cast to t'Server', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toServer :: (MIO.MonadIO m, IsServer o) => o -> m Server
toServer = MIO.liftIO . B.ManagedPtr.unsafeCastTo Server

-- | Convert t'Server' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Server) where
    gvalueGType_ = c_dbusmenu_server_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Server)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Server)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Server ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveServerMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveServerMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveServerMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveServerMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveServerMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveServerMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveServerMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveServerMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveServerMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveServerMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveServerMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveServerMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveServerMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveServerMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveServerMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveServerMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveServerMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveServerMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveServerMethod "getIconPaths" o = ServerGetIconPathsMethodInfo
    ResolveServerMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveServerMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveServerMethod "getStatus" o = ServerGetStatusMethodInfo
    ResolveServerMethod "getTextDirection" o = ServerGetTextDirectionMethodInfo
    ResolveServerMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveServerMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveServerMethod "setIconPaths" o = ServerSetIconPathsMethodInfo
    ResolveServerMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveServerMethod "setRoot" o = ServerSetRootMethodInfo
    ResolveServerMethod "setStatus" o = ServerSetStatusMethodInfo
    ResolveServerMethod "setTextDirection" o = ServerSetTextDirectionMethodInfo
    ResolveServerMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveServerMethod t Server, O.OverloadedMethod info Server p) => OL.IsLabel t (Server -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveServerMethod t Server, O.OverloadedMethod info Server p, R.HasField t Server p) => R.HasField t Server p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveServerMethod t Server, O.OverloadedMethodInfo info Server) => OL.IsLabel t (O.MethodProxy info Server) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Server::item-activation-requested
-- | This is signaled when a menuitem under this server
-- 		sends its activate signal.
type ServerItemActivationRequestedCallback =
    Int32
    -- ^ /@arg1@/: The ID of the parent for this update.
    -> Word32
    -- ^ /@arg2@/: The timestamp of when the event happened
    -> IO ()

type C_ServerItemActivationRequestedCallback =
    Ptr Server ->                           -- object
    Int32 ->
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ServerItemActivationRequestedCallback`.
foreign import ccall "wrapper"
    mk_ServerItemActivationRequestedCallback :: C_ServerItemActivationRequestedCallback -> IO (FunPtr C_ServerItemActivationRequestedCallback)

wrap_ServerItemActivationRequestedCallback :: 
    GObject a => (a -> ServerItemActivationRequestedCallback) ->
    C_ServerItemActivationRequestedCallback
wrap_ServerItemActivationRequestedCallback gi'cb gi'selfPtr arg1 arg2 _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1 arg2


-- | Connect a signal handler for the [itemActivationRequested](#signal:itemActivationRequested) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' server #itemActivationRequested callback
-- @
-- 
-- 
onServerItemActivationRequested :: (IsServer a, MonadIO m) => a -> ((?self :: a) => ServerItemActivationRequestedCallback) -> m SignalHandlerId
onServerItemActivationRequested obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ServerItemActivationRequestedCallback wrapped
    wrapped'' <- mk_ServerItemActivationRequestedCallback wrapped'
    connectSignalFunPtr obj "item-activation-requested" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [itemActivationRequested](#signal:itemActivationRequested) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' server #itemActivationRequested callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterServerItemActivationRequested :: (IsServer a, MonadIO m) => a -> ((?self :: a) => ServerItemActivationRequestedCallback) -> m SignalHandlerId
afterServerItemActivationRequested obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ServerItemActivationRequestedCallback wrapped
    wrapped'' <- mk_ServerItemActivationRequestedCallback wrapped'
    connectSignalFunPtr obj "item-activation-requested" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ServerItemActivationRequestedSignalInfo
instance SignalInfo ServerItemActivationRequestedSignalInfo where
    type HaskellCallbackType ServerItemActivationRequestedSignalInfo = ServerItemActivationRequestedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ServerItemActivationRequestedCallback cb
        cb'' <- mk_ServerItemActivationRequestedCallback cb'
        connectSignalFunPtr obj "item-activation-requested" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Server::item-activation-requested"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Server.html#g:signal:itemActivationRequested"})

#endif

-- signal Server::item-property-updated
-- | /No description available in the introspection data./
type ServerItemPropertyUpdatedCallback =
    Int32
    -> T.Text
    -> GVariant
    -> IO ()

type C_ServerItemPropertyUpdatedCallback =
    Ptr Server ->                           -- object
    Int32 ->
    CString ->
    Ptr GVariant ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ServerItemPropertyUpdatedCallback`.
foreign import ccall "wrapper"
    mk_ServerItemPropertyUpdatedCallback :: C_ServerItemPropertyUpdatedCallback -> IO (FunPtr C_ServerItemPropertyUpdatedCallback)

wrap_ServerItemPropertyUpdatedCallback :: 
    GObject a => (a -> ServerItemPropertyUpdatedCallback) ->
    C_ServerItemPropertyUpdatedCallback
wrap_ServerItemPropertyUpdatedCallback gi'cb gi'selfPtr object p0 p1 _ = do
    p0' <- cstringToText p0
    p1' <- B.GVariant.newGVariantFromPtr p1
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  object p0' p1'


-- | Connect a signal handler for the [itemPropertyUpdated](#signal:itemPropertyUpdated) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' server #itemPropertyUpdated callback
-- @
-- 
-- 
onServerItemPropertyUpdated :: (IsServer a, MonadIO m) => a -> ((?self :: a) => ServerItemPropertyUpdatedCallback) -> m SignalHandlerId
onServerItemPropertyUpdated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ServerItemPropertyUpdatedCallback wrapped
    wrapped'' <- mk_ServerItemPropertyUpdatedCallback wrapped'
    connectSignalFunPtr obj "item-property-updated" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [itemPropertyUpdated](#signal:itemPropertyUpdated) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' server #itemPropertyUpdated callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterServerItemPropertyUpdated :: (IsServer a, MonadIO m) => a -> ((?self :: a) => ServerItemPropertyUpdatedCallback) -> m SignalHandlerId
afterServerItemPropertyUpdated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ServerItemPropertyUpdatedCallback wrapped
    wrapped'' <- mk_ServerItemPropertyUpdatedCallback wrapped'
    connectSignalFunPtr obj "item-property-updated" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ServerItemPropertyUpdatedSignalInfo
instance SignalInfo ServerItemPropertyUpdatedSignalInfo where
    type HaskellCallbackType ServerItemPropertyUpdatedSignalInfo = ServerItemPropertyUpdatedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ServerItemPropertyUpdatedCallback cb
        cb'' <- mk_ServerItemPropertyUpdatedCallback cb'
        connectSignalFunPtr obj "item-property-updated" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Server::item-property-updated"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Server.html#g:signal:itemPropertyUpdated"})

#endif

-- signal Server::item-updated
-- | /No description available in the introspection data./
type ServerItemUpdatedCallback =
    Int32
    -> IO ()

type C_ServerItemUpdatedCallback =
    Ptr Server ->                           -- object
    Int32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ServerItemUpdatedCallback`.
foreign import ccall "wrapper"
    mk_ServerItemUpdatedCallback :: C_ServerItemUpdatedCallback -> IO (FunPtr C_ServerItemUpdatedCallback)

wrap_ServerItemUpdatedCallback :: 
    GObject a => (a -> ServerItemUpdatedCallback) ->
    C_ServerItemUpdatedCallback
wrap_ServerItemUpdatedCallback gi'cb gi'selfPtr object _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  object


-- | Connect a signal handler for the [itemUpdated](#signal:itemUpdated) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' server #itemUpdated callback
-- @
-- 
-- 
onServerItemUpdated :: (IsServer a, MonadIO m) => a -> ((?self :: a) => ServerItemUpdatedCallback) -> m SignalHandlerId
onServerItemUpdated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ServerItemUpdatedCallback wrapped
    wrapped'' <- mk_ServerItemUpdatedCallback wrapped'
    connectSignalFunPtr obj "item-updated" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [itemUpdated](#signal:itemUpdated) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' server #itemUpdated callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterServerItemUpdated :: (IsServer a, MonadIO m) => a -> ((?self :: a) => ServerItemUpdatedCallback) -> m SignalHandlerId
afterServerItemUpdated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ServerItemUpdatedCallback wrapped
    wrapped'' <- mk_ServerItemUpdatedCallback wrapped'
    connectSignalFunPtr obj "item-updated" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ServerItemUpdatedSignalInfo
instance SignalInfo ServerItemUpdatedSignalInfo where
    type HaskellCallbackType ServerItemUpdatedSignalInfo = ServerItemUpdatedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ServerItemUpdatedCallback cb
        cb'' <- mk_ServerItemUpdatedCallback cb'
        connectSignalFunPtr obj "item-updated" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Server::item-updated"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Server.html#g:signal:itemUpdated"})

#endif

-- signal Server::layout-updated
-- | This signal is emitted any time the layout of the
-- 		menuitems under this server is changed.
type ServerLayoutUpdatedCallback =
    Word32
    -- ^ /@arg1@/: A revision number representing which revision the update
    -- 		       represents itself as.
    -> Int32
    -- ^ /@arg2@/: The ID of the parent for this update.
    -> IO ()

type C_ServerLayoutUpdatedCallback =
    Ptr Server ->                           -- object
    Word32 ->
    Int32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ServerLayoutUpdatedCallback`.
foreign import ccall "wrapper"
    mk_ServerLayoutUpdatedCallback :: C_ServerLayoutUpdatedCallback -> IO (FunPtr C_ServerLayoutUpdatedCallback)

wrap_ServerLayoutUpdatedCallback :: 
    GObject a => (a -> ServerLayoutUpdatedCallback) ->
    C_ServerLayoutUpdatedCallback
wrap_ServerLayoutUpdatedCallback gi'cb gi'selfPtr arg1 arg2 _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1 arg2


-- | Connect a signal handler for the [layoutUpdated](#signal:layoutUpdated) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' server #layoutUpdated callback
-- @
-- 
-- 
onServerLayoutUpdated :: (IsServer a, MonadIO m) => a -> ((?self :: a) => ServerLayoutUpdatedCallback) -> m SignalHandlerId
onServerLayoutUpdated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ServerLayoutUpdatedCallback wrapped
    wrapped'' <- mk_ServerLayoutUpdatedCallback wrapped'
    connectSignalFunPtr obj "layout-updated" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [layoutUpdated](#signal:layoutUpdated) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' server #layoutUpdated callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterServerLayoutUpdated :: (IsServer a, MonadIO m) => a -> ((?self :: a) => ServerLayoutUpdatedCallback) -> m SignalHandlerId
afterServerLayoutUpdated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ServerLayoutUpdatedCallback wrapped
    wrapped'' <- mk_ServerLayoutUpdatedCallback wrapped'
    connectSignalFunPtr obj "layout-updated" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ServerLayoutUpdatedSignalInfo
instance SignalInfo ServerLayoutUpdatedSignalInfo where
    type HaskellCallbackType ServerLayoutUpdatedSignalInfo = ServerLayoutUpdatedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ServerLayoutUpdatedCallback cb
        cb'' <- mk_ServerLayoutUpdatedCallback cb'
        connectSignalFunPtr obj "layout-updated" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Server::layout-updated"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Server.html#g:signal:layoutUpdated"})

#endif

-- VVV Prop "dbus-object"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@dbus-object@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' server #dbusObject
-- @
getServerDbusObject :: (MonadIO m, IsServer o) => o -> m (Maybe T.Text)
getServerDbusObject obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "dbus-object"

-- | Construct a t'GValueConstruct' with valid value for the “@dbus-object@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructServerDbusObject :: (IsServer o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructServerDbusObject val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "dbus-object" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ServerDbusObjectPropertyInfo
instance AttrInfo ServerDbusObjectPropertyInfo where
    type AttrAllowedOps ServerDbusObjectPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ServerDbusObjectPropertyInfo = IsServer
    type AttrSetTypeConstraint ServerDbusObjectPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ServerDbusObjectPropertyInfo = (~) T.Text
    type AttrTransferType ServerDbusObjectPropertyInfo = T.Text
    type AttrGetType ServerDbusObjectPropertyInfo = (Maybe T.Text)
    type AttrLabel ServerDbusObjectPropertyInfo = "dbus-object"
    type AttrOrigin ServerDbusObjectPropertyInfo = Server
    attrGet = getServerDbusObject
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructServerDbusObject
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Server.dbusObject"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Server.html#g:attr:dbusObject"
        })
#endif

-- VVV Prop "root-node"
   -- Type: TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@root-node@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' server #rootNode
-- @
getServerRootNode :: (MonadIO m, IsServer o) => o -> m (Maybe Dbusmenu.Menuitem.Menuitem)
getServerRootNode obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "root-node" Dbusmenu.Menuitem.Menuitem

-- | Set the value of the “@root-node@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' server [ #rootNode 'Data.GI.Base.Attributes.:=' value ]
-- @
setServerRootNode :: (MonadIO m, IsServer o, Dbusmenu.Menuitem.IsMenuitem a) => o -> a -> m ()
setServerRootNode obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "root-node" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@root-node@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructServerRootNode :: (IsServer o, MIO.MonadIO m, Dbusmenu.Menuitem.IsMenuitem a) => a -> m (GValueConstruct o)
constructServerRootNode val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "root-node" (P.Just val)

-- | Set the value of the “@root-node@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #rootNode
-- @
clearServerRootNode :: (MonadIO m, IsServer o) => o -> m ()
clearServerRootNode obj = liftIO $ B.Properties.setObjectPropertyObject obj "root-node" (Nothing :: Maybe Dbusmenu.Menuitem.Menuitem)

#if defined(ENABLE_OVERLOADING)
data ServerRootNodePropertyInfo
instance AttrInfo ServerRootNodePropertyInfo where
    type AttrAllowedOps ServerRootNodePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ServerRootNodePropertyInfo = IsServer
    type AttrSetTypeConstraint ServerRootNodePropertyInfo = Dbusmenu.Menuitem.IsMenuitem
    type AttrTransferTypeConstraint ServerRootNodePropertyInfo = Dbusmenu.Menuitem.IsMenuitem
    type AttrTransferType ServerRootNodePropertyInfo = Dbusmenu.Menuitem.Menuitem
    type AttrGetType ServerRootNodePropertyInfo = (Maybe Dbusmenu.Menuitem.Menuitem)
    type AttrLabel ServerRootNodePropertyInfo = "root-node"
    type AttrOrigin ServerRootNodePropertyInfo = Server
    attrGet = getServerRootNode
    attrSet = setServerRootNode
    attrTransfer _ v = do
        unsafeCastTo Dbusmenu.Menuitem.Menuitem v
    attrConstruct = constructServerRootNode
    attrClear = clearServerRootNode
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Server.rootNode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Server.html#g:attr:rootNode"
        })
#endif

-- VVV Prop "version"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@version@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' server #version
-- @
getServerVersion :: (MonadIO m, IsServer o) => o -> m Word32
getServerVersion obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "version"

#if defined(ENABLE_OVERLOADING)
data ServerVersionPropertyInfo
instance AttrInfo ServerVersionPropertyInfo where
    type AttrAllowedOps ServerVersionPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ServerVersionPropertyInfo = IsServer
    type AttrSetTypeConstraint ServerVersionPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ServerVersionPropertyInfo = (~) ()
    type AttrTransferType ServerVersionPropertyInfo = ()
    type AttrGetType ServerVersionPropertyInfo = Word32
    type AttrLabel ServerVersionPropertyInfo = "version"
    type AttrOrigin ServerVersionPropertyInfo = Server
    attrGet = getServerVersion
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Server.version"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Server.html#g:attr:version"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Server
type instance O.AttributeList Server = ServerAttributeList
type ServerAttributeList = ('[ '("dbusObject", ServerDbusObjectPropertyInfo), '("rootNode", ServerRootNodePropertyInfo), '("version", ServerVersionPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
serverDbusObject :: AttrLabelProxy "dbusObject"
serverDbusObject = AttrLabelProxy

serverRootNode :: AttrLabelProxy "rootNode"
serverRootNode = AttrLabelProxy

serverVersion :: AttrLabelProxy "version"
serverVersion = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Server = ServerSignalList
type ServerSignalList = ('[ '("itemActivationRequested", ServerItemActivationRequestedSignalInfo), '("itemPropertyUpdated", ServerItemPropertyUpdatedSignalInfo), '("itemUpdated", ServerItemUpdatedSignalInfo), '("layoutUpdated", ServerLayoutUpdatedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Server::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "object"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The object name to show for this menu structure\n\t\ton DBus.  May be NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Dbusmenu" , name = "Server" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_server_new" dbusmenu_server_new :: 
    CString ->                              -- object : TBasicType TUTF8
    IO (Ptr Server)

-- | Creates a new t'GI.Dbusmenu.Objects.Server.Server' object with a specific object
-- 	path on DBus.  If /@object@/ is set to NULL the default object
-- 	name of \"\/com\/canonical\/dbusmenu\" will be used.
-- 
-- 	Return value: A brand new t'GI.Dbusmenu.Objects.Server.Server'
serverNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@object@/: The object name to show for this menu structure
    -- 		on DBus.  May be NULL.
    -> m Server
serverNew object = liftIO $ do
    object' <- textToCString object
    result <- dbusmenu_server_new object'
    checkUnexpectedReturnNULL "serverNew" result
    result' <- (wrapObject Server) result
    freeMem object'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Server::get_icon_paths
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "server"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Server" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuServer to get the icon paths from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_server_get_icon_paths" dbusmenu_server_get_icon_paths :: 
    Ptr Server ->                           -- server : TInterface (Name {namespace = "Dbusmenu", name = "Server"})
    IO (Ptr CString)

-- | Gets the stored and exported icon paths from the server.
serverGetIconPaths ::
    (B.CallStack.HasCallStack, MonadIO m, IsServer a) =>
    a
    -- ^ /@server@/: The t'GI.Dbusmenu.Objects.Server.Server' to get the icon paths from
    -> m [T.Text]
    -- ^ __Returns:__ A NULL-terminated list of icon paths with
    --   memory managed by the server.  Duplicate if you want
    --   to keep them.
serverGetIconPaths server = liftIO $ do
    server' <- unsafeManagedPtrCastPtr server
    result <- dbusmenu_server_get_icon_paths server'
    checkUnexpectedReturnNULL "serverGetIconPaths" result
    result' <- unpackZeroTerminatedUTF8CArray result
    touchManagedPtr server
    return result'

#if defined(ENABLE_OVERLOADING)
data ServerGetIconPathsMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m, IsServer a) => O.OverloadedMethod ServerGetIconPathsMethodInfo a signature where
    overloadedMethod = serverGetIconPaths

instance O.OverloadedMethodInfo ServerGetIconPathsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Server.serverGetIconPaths",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Server.html#v:serverGetIconPaths"
        })


#endif

-- method Server::get_status
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "server"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Server" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuServer to get the status from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Dbusmenu" , name = "Status" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_server_get_status" dbusmenu_server_get_status :: 
    Ptr Server ->                           -- server : TInterface (Name {namespace = "Dbusmenu", name = "Server"})
    IO CUInt

-- | Gets the current statust hat the server is sending out over
-- 	DBus.
-- 
-- 	Return value: The current status the server is sending
serverGetStatus ::
    (B.CallStack.HasCallStack, MonadIO m, IsServer a) =>
    a
    -- ^ /@server@/: The t'GI.Dbusmenu.Objects.Server.Server' to get the status from
    -> m Dbusmenu.Enums.Status
serverGetStatus server = liftIO $ do
    server' <- unsafeManagedPtrCastPtr server
    result <- dbusmenu_server_get_status server'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr server
    return result'

#if defined(ENABLE_OVERLOADING)
data ServerGetStatusMethodInfo
instance (signature ~ (m Dbusmenu.Enums.Status), MonadIO m, IsServer a) => O.OverloadedMethod ServerGetStatusMethodInfo a signature where
    overloadedMethod = serverGetStatus

instance O.OverloadedMethodInfo ServerGetStatusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Server.serverGetStatus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Server.html#v:serverGetStatus"
        })


#endif

-- method Server::get_text_direction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "server"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Server" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuServer object to get the text direction from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Dbusmenu" , name = "TextDirection" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_server_get_text_direction" dbusmenu_server_get_text_direction :: 
    Ptr Server ->                           -- server : TInterface (Name {namespace = "Dbusmenu", name = "Server"})
    IO CUInt

-- | Returns the value of the text direction that is being exported
-- 	over DBus for this server.  It should relate to the direction
-- 	of the labels and other text fields that are being exported by
-- 	this server.
-- 
-- 	Return value: Text direction exported for this server.
serverGetTextDirection ::
    (B.CallStack.HasCallStack, MonadIO m, IsServer a) =>
    a
    -- ^ /@server@/: The t'GI.Dbusmenu.Objects.Server.Server' object to get the text direction from
    -> m Dbusmenu.Enums.TextDirection
serverGetTextDirection server = liftIO $ do
    server' <- unsafeManagedPtrCastPtr server
    result <- dbusmenu_server_get_text_direction server'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr server
    return result'

#if defined(ENABLE_OVERLOADING)
data ServerGetTextDirectionMethodInfo
instance (signature ~ (m Dbusmenu.Enums.TextDirection), MonadIO m, IsServer a) => O.OverloadedMethod ServerGetTextDirectionMethodInfo a signature where
    overloadedMethod = serverGetTextDirection

instance O.OverloadedMethodInfo ServerGetTextDirectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Server.serverGetTextDirection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Server.html#v:serverGetTextDirection"
        })


#endif

-- method Server::set_icon_paths
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "server"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Server" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuServer to set the icon paths on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icon_paths"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_server_set_icon_paths" dbusmenu_server_set_icon_paths :: 
    Ptr Server ->                           -- server : TInterface (Name {namespace = "Dbusmenu", name = "Server"})
    Ptr CString ->                          -- icon_paths : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

-- | Sets the icon paths for the server.  This will replace previously
-- 	set icon theme paths.
serverSetIconPaths ::
    (B.CallStack.HasCallStack, MonadIO m, IsServer a) =>
    a
    -- ^ /@server@/: The t'GI.Dbusmenu.Objects.Server.Server' to set the icon paths on
    -> [T.Text]
    -> m ()
serverSetIconPaths server iconPaths = liftIO $ do
    server' <- unsafeManagedPtrCastPtr server
    iconPaths' <- packZeroTerminatedUTF8CArray iconPaths
    dbusmenu_server_set_icon_paths server' iconPaths'
    touchManagedPtr server
    mapZeroTerminatedCArray freeMem iconPaths'
    freeMem iconPaths'
    return ()

#if defined(ENABLE_OVERLOADING)
data ServerSetIconPathsMethodInfo
instance (signature ~ ([T.Text] -> m ()), MonadIO m, IsServer a) => O.OverloadedMethod ServerSetIconPathsMethodInfo a signature where
    overloadedMethod = serverSetIconPaths

instance O.OverloadedMethodInfo ServerSetIconPathsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Server.serverSetIconPaths",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Server.html#v:serverSetIconPaths"
        })


#endif

-- method Server::set_root
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Server" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuServer object to set the root on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The new root #DbusmenuMenuitem tree"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_server_set_root" dbusmenu_server_set_root :: 
    Ptr Server ->                           -- self : TInterface (Name {namespace = "Dbusmenu", name = "Server"})
    Ptr Dbusmenu.Menuitem.Menuitem ->       -- root : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO ()

-- | This function contains all of the t'GI.GObject.Structs.Value.Value' wrapping
-- 	required to set the property [Server:rootNode]("GI.Dbusmenu.Objects.Server#g:attr:rootNode")
-- 	on the server /@self@/.
serverSetRoot ::
    (B.CallStack.HasCallStack, MonadIO m, IsServer a, Dbusmenu.Menuitem.IsMenuitem b) =>
    a
    -- ^ /@self@/: The t'GI.Dbusmenu.Objects.Server.Server' object to set the root on
    -> b
    -- ^ /@root@/: The new root t'GI.Dbusmenu.Objects.Menuitem.Menuitem' tree
    -> m ()
serverSetRoot self root = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    root' <- unsafeManagedPtrCastPtr root
    dbusmenu_server_set_root self' root'
    touchManagedPtr self
    touchManagedPtr root
    return ()

#if defined(ENABLE_OVERLOADING)
data ServerSetRootMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsServer a, Dbusmenu.Menuitem.IsMenuitem b) => O.OverloadedMethod ServerSetRootMethodInfo a signature where
    overloadedMethod = serverSetRoot

instance O.OverloadedMethodInfo ServerSetRootMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Server.serverSetRoot",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Server.html#v:serverSetRoot"
        })


#endif

-- method Server::set_status
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "server"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Server" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuServer to set the status on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "status"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Status" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Status value to set on the server"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_server_set_status" dbusmenu_server_set_status :: 
    Ptr Server ->                           -- server : TInterface (Name {namespace = "Dbusmenu", name = "Server"})
    CUInt ->                                -- status : TInterface (Name {namespace = "Dbusmenu", name = "Status"})
    IO ()

-- | Changes the status of the server.
serverSetStatus ::
    (B.CallStack.HasCallStack, MonadIO m, IsServer a) =>
    a
    -- ^ /@server@/: The t'GI.Dbusmenu.Objects.Server.Server' to set the status on
    -> Dbusmenu.Enums.Status
    -- ^ /@status@/: Status value to set on the server
    -> m ()
serverSetStatus server status = liftIO $ do
    server' <- unsafeManagedPtrCastPtr server
    let status' = (fromIntegral . fromEnum) status
    dbusmenu_server_set_status server' status'
    touchManagedPtr server
    return ()

#if defined(ENABLE_OVERLOADING)
data ServerSetStatusMethodInfo
instance (signature ~ (Dbusmenu.Enums.Status -> m ()), MonadIO m, IsServer a) => O.OverloadedMethod ServerSetStatusMethodInfo a signature where
    overloadedMethod = serverSetStatus

instance O.OverloadedMethodInfo ServerSetStatusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Server.serverSetStatus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Server.html#v:serverSetStatus"
        })


#endif

-- method Server::set_text_direction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "server"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Server" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuServer object to set the text direction on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dir"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "TextDirection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Direction of the text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_server_set_text_direction" dbusmenu_server_set_text_direction :: 
    Ptr Server ->                           -- server : TInterface (Name {namespace = "Dbusmenu", name = "Server"})
    CUInt ->                                -- dir : TInterface (Name {namespace = "Dbusmenu", name = "TextDirection"})
    IO ()

-- | Sets the text direction that should be exported over DBus for
-- 	this server.  If the value is set to @/DBUSMENU_TEXT_DIRECTION_NONE/@
-- 	the default detection will be used for setting the value and
-- 	exported over DBus.
serverSetTextDirection ::
    (B.CallStack.HasCallStack, MonadIO m, IsServer a) =>
    a
    -- ^ /@server@/: The t'GI.Dbusmenu.Objects.Server.Server' object to set the text direction on
    -> Dbusmenu.Enums.TextDirection
    -- ^ /@dir@/: Direction of the text
    -> m ()
serverSetTextDirection server dir = liftIO $ do
    server' <- unsafeManagedPtrCastPtr server
    let dir' = (fromIntegral . fromEnum) dir
    dbusmenu_server_set_text_direction server' dir'
    touchManagedPtr server
    return ()

#if defined(ENABLE_OVERLOADING)
data ServerSetTextDirectionMethodInfo
instance (signature ~ (Dbusmenu.Enums.TextDirection -> m ()), MonadIO m, IsServer a) => O.OverloadedMethod ServerSetTextDirectionMethodInfo a signature where
    overloadedMethod = serverSetTextDirection

instance O.OverloadedMethodInfo ServerSetTextDirectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Server.serverSetTextDirection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.14/docs/GI-Dbusmenu-Objects-Server.html#v:serverSetTextDirection"
        })


#endif


