// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	monitoringv1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1alpha1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// PrometheusAgentLister helps list PrometheusAgents.
// All objects returned here must be treated as read-only.
type PrometheusAgentLister interface {
	// List lists all PrometheusAgents in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*monitoringv1alpha1.PrometheusAgent, err error)
	// PrometheusAgents returns an object that can list and get PrometheusAgents.
	PrometheusAgents(namespace string) PrometheusAgentNamespaceLister
	PrometheusAgentListerExpansion
}

// prometheusAgentLister implements the PrometheusAgentLister interface.
type prometheusAgentLister struct {
	listers.ResourceIndexer[*monitoringv1alpha1.PrometheusAgent]
}

// NewPrometheusAgentLister returns a new PrometheusAgentLister.
func NewPrometheusAgentLister(indexer cache.Indexer) PrometheusAgentLister {
	return &prometheusAgentLister{listers.New[*monitoringv1alpha1.PrometheusAgent](indexer, monitoringv1alpha1.Resource("prometheusagent"))}
}

// PrometheusAgents returns an object that can list and get PrometheusAgents.
func (s *prometheusAgentLister) PrometheusAgents(namespace string) PrometheusAgentNamespaceLister {
	return prometheusAgentNamespaceLister{listers.NewNamespaced[*monitoringv1alpha1.PrometheusAgent](s.ResourceIndexer, namespace)}
}

// PrometheusAgentNamespaceLister helps list and get PrometheusAgents.
// All objects returned here must be treated as read-only.
type PrometheusAgentNamespaceLister interface {
	// List lists all PrometheusAgents in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*monitoringv1alpha1.PrometheusAgent, err error)
	// Get retrieves the PrometheusAgent from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*monitoringv1alpha1.PrometheusAgent, error)
	PrometheusAgentNamespaceListerExpansion
}

// prometheusAgentNamespaceLister implements the PrometheusAgentNamespaceLister
// interface.
type prometheusAgentNamespaceLister struct {
	listers.ResourceIndexer[*monitoringv1alpha1.PrometheusAgent]
}
