/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, fec, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_fec_ldpc_encoder = R"doc()doc";


static const char* __doc_gr_fec_ldpc_encoder_ldpc_encoder_0 = R"doc()doc";


static const char* __doc_gr_fec_ldpc_encoder_ldpc_encoder_1 = R"doc()doc";


static const char* __doc_gr_fec_ldpc_encoder_make = R"doc()doc";


static const char* __doc_gr_fec_ldpc_encoder_rate = R"doc(Returns the rate of the code. For every 1 input bit, there are r output bits, so the rate is 1/r. Used for setting things like the encoder block's relative rate.


This function MUST be reimplemented by the child class.)doc";


static const char* __doc_gr_fec_ldpc_encoder_set_frame_size = R"doc(Updates the size of the frame to encode.


The child class MUST implement this function and interpret how the  information affects the block's behavior. It should also provide bounds checks.)doc";


static const char* __doc_gr_fec_ldpc_encoder_get_output_size = R"doc(Returns the output size in items that the encoder object produces after encoding a full frame. Often, this number is the number of bits in the outputted frame if the input format is unpacked. If the block produces packed bytes, then this value should be the number of bytes (number of bits / 8) per frame produced. This value is generally something like R*get_input_size() for a 1/R rate code.


The child class MUST implement this function.)doc";


static const char* __doc_gr_fec_ldpc_encoder_get_input_size = R"doc(Returns the input size in items that the encoder object uses to encode a full frame. Often, this number is the number of bits per frame if the input format is unpacked. If the block expects packed bytes, then this value should be the number of bytes (number of bits / 8) per input frame.


The child class MUST implement this function.)doc";
