/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, fec, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_fec_ber_bf = R"doc(BER block in FECAPI.

This block measures the bit error rate between two streams of packed data. It compares the bits of each streams and counts the number of incorrect bits between them. It outputs the log of the bit error rate, so a value of -X is 10^{-X} bit errors.


When the  is set to false (default), it is in streaming mode. This means that the output is constantly producing the current value of the BER. In this mode, there is a single output BER calculation per chunk of bytes passed to it, so there is no exact timing between calculations of BER. In this mode, the other two parameters to the constructor are ignored.


When  is true, the block is in test mode. This mode is used in the ber_curve_gen example and for other offline analysis of BER curves. Here, the block waits until at least  are observed and then produces a BER calculation. The parameter  helps make sure that the simulation is controlled. If the BER calculation drops below the  setting, the block will exit and simply return the set limit; the real BER is therefore some amount lower than this.


Note that this block takes in data as packed bytes with 8-bits per byte used. It outputs a stream of floats as the log-scale BER.

Constructor Specific Documentation:

Calculate the BER between two streams of data.

Args:
    test_mode : false for normal streaming mode (default); true for test mode.
    berminerrors : the block needs to observe this many errors before outputting a result. Only valid when test_mode=true.
    ber_limit : if the BER calculation falls below this limit, produce this value and exit. Only valid when test_mode=true.)doc";


static const char* __doc_gr_fec_ber_bf_ber_bf_0 = R"doc()doc";


static const char* __doc_gr_fec_ber_bf_ber_bf_1 = R"doc()doc";


static const char* __doc_gr_fec_ber_bf_total_errors = R"doc(Get total number of errors counter value.)doc";


static const char* __doc_gr_fec_ber_bf_make = R"doc(BER block in FECAPI.

This block measures the bit error rate between two streams of packed data. It compares the bits of each streams and counts the number of incorrect bits between them. It outputs the log of the bit error rate, so a value of -X is 10^{-X} bit errors.


When the  is set to false (default), it is in streaming mode. This means that the output is constantly producing the current value of the BER. In this mode, there is a single output BER calculation per chunk of bytes passed to it, so there is no exact timing between calculations of BER. In this mode, the other two parameters to the constructor are ignored.


When  is true, the block is in test mode. This mode is used in the ber_curve_gen example and for other offline analysis of BER curves. Here, the block waits until at least  are observed and then produces a BER calculation. The parameter  helps make sure that the simulation is controlled. If the BER calculation drops below the  setting, the block will exit and simply return the set limit; the real BER is therefore some amount lower than this.


Note that this block takes in data as packed bytes with 8-bits per byte used. It outputs a stream of floats as the log-scale BER.

Constructor Specific Documentation:

Calculate the BER between two streams of data.

Args:
    test_mode : false for normal streaming mode (default); true for test mode.
    berminerrors : the block needs to observe this many errors before outputting a result. Only valid when test_mode=true.
    ber_limit : if the BER calculation falls below this limit, produce this value and exit. Only valid when test_mode=true.)doc";
