/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_ofdm_serializer_vcc = R"doc(Serializes complex modulations symbols from OFDM sub-carriers.

This is the inverse block to the carrier_allocator_cvc. It outputs the complex data symbols as a tagged stream, discarding the pilot symbols.


If given, two different tags are parsed: The first key () specifies the number of OFDM symbols in the frame at the input. The second key () specifies the number of complex symbols that are coded into this frame. If given, this second key is then used at the output, otherwise,  is used. If both are given, the packet length specifies the maximum number of output items, and the frame length specifies the exact number of consumed input items.


It is possible to correct a carrier offset in this function by passing another tag with said offset.


Input: Complex vectors of length  Output: Complex scalars, in the same order as specified in occupied_carriers.

Constructor Specific Documentation:



Args:
    fft_len : FFT length
    occupied_carriers : See ofdm_carrier_allocator_cvc.
    len_tag_key : The key of the tag identifying the length of the input frame in OFDM symbols.
    packet_len_tag_key : The key of the tag identifying the number of complex symbols in this packet.
    symbols_skipped : If the first symbol is not allocated as in [0], set this
    carr_offset_key : When this block should correct a carrier offset, specify the tag key of the offset here (not necessary if following an ofdm_frame_equalizer_vcvc)
    input_is_shifted : If the input has the DC carrier on index 0 (i.e. it is not FFT shifted), set this to false)doc";


static const char* __doc_gr_digital_ofdm_serializer_vcc_ofdm_serializer_vcc = R"doc()doc";


static const char* __doc_gr_digital_ofdm_serializer_vcc_make_0 = R"doc()doc";


static const char* __doc_gr_digital_ofdm_serializer_vcc_make_1 = R"doc()doc";
