/* controls.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from controls.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 * Copyright (C) 2020 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 * Copyright (C) 2023-2025 Ben Corby <bcorby@new-ms.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't
 * match them self.
 *
 * grep -ne '[^][~)(}{_!$ "-](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 * grep -ne ' $' *.vala
 *
 */

#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <gsk/gsk.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <graphene-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef gboolean (*CheckDuplicate) (guint i, gpointer user_data);

#define TYPE_CONTROLS (controls_get_type ())
#define CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTROLS, Controls))
#define CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTROLS, ControlsClass))
#define IS_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTROLS))
#define IS_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTROLS))
#define CONTROLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTROLS, ControlsClass))

typedef struct _Controls Controls;
typedef struct _ControlsClass ControlsClass;
typedef struct _ControlsPrivate ControlsPrivate;

#define TYPE_CONTROLS_GRID (controls_grid_get_type ())
#define CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTROLS_GRID, ControlsGrid))
#define CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTROLS_GRID, ControlsGridClass))
#define IS_CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTROLS_GRID))
#define IS_CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTROLS_GRID))
#define CONTROLS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTROLS_GRID, ControlsGridClass))

typedef struct _ControlsGrid ControlsGrid;
typedef struct _ControlsGridClass ControlsGridClass;
enum  {
	CONTROLS_0_PROPERTY,
	CONTROLS_NUM_PROPERTIES
};
static GParamSpec* controls_properties[CONTROLS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
#define WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_PROPERTIES, WormProperties))
#define WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_PROPERTIES, WormPropertiesClass))
#define IS_WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_PROPERTIES))
#define IS_WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_PROPERTIES))
#define WORM_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_PROPERTIES, WormPropertiesClass))

typedef struct _WormProperties WormProperties;
typedef struct _WormPropertiesClass WormPropertiesClass;
typedef struct _Block1Data Block1Data;
typedef struct _WormPrivate WormPrivate;

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;

#define TYPE_WORM_POSITIONS (worm_positions_get_type ())
#define WORM_POSITIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_POSITIONS, WormPositions))
#define WORM_POSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_POSITIONS, WormPositionsClass))
#define IS_WORM_POSITIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_POSITIONS))
#define IS_WORM_POSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_POSITIONS))
#define WORM_POSITIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_POSITIONS, WormPositionsClass))

typedef struct _WormPositions WormPositions;
typedef struct _WormPositionsClass WormPositionsClass;
typedef struct _ControlsGridPrivate ControlsGridPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef gboolean (*KeypressHandlerFunction) (guint a, guint b, gboolean* remove_handler, gpointer user_data);
enum  {
	CONTROLS_ADD_KEYPRESS_HANDLER_SIGNAL,
	CONTROLS_NUM_SIGNALS
};
static guint controls_signals[CONTROLS_NUM_SIGNALS] = {0};

#define TYPE_ARROW (arrow_get_type ())
#define ARROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ARROW, Arrow))
#define ARROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ARROW, ArrowClass))
#define IS_ARROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ARROW))
#define IS_ARROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ARROW))
#define ARROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ARROW, ArrowClass))

typedef struct _Arrow Arrow;
typedef struct _ArrowClass ArrowClass;
typedef struct _ArrowPrivate ArrowPrivate;
typedef enum  {
	ARROW_EDIRECTION_up,
	ARROW_EDIRECTION_down,
	ARROW_EDIRECTION_left,
	ARROW_EDIRECTION_right
} ArroweDirection;

#define ARROW_TYPE_EDIRECTION (arrow_edirection_get_type ())
enum  {
	ARROW_0_PROPERTY,
	ARROW_DIRECTION_PROPERTY,
	ARROW_NUM_PROPERTIES
};
static GParamSpec* arrow_properties[ARROW_NUM_PROPERTIES];

#define ARROW_TYPE_XY (arrow_xy_get_type ())
typedef struct _Arrowxy Arrowxy;
#define _gsk_path_unref0(var) ((var == NULL) ? NULL : (var = (gsk_path_unref (var), NULL)))
#define _gsk_path_builder_unref0(var) ((var == NULL) ? NULL : (var = (gsk_path_builder_unref (var), NULL)))

#define TYPE_COLOUR_WHEEL (colour_wheel_get_type ())
#define COLOUR_WHEEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLOUR_WHEEL, ColourWheel))
#define COLOUR_WHEEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLOUR_WHEEL, ColourWheelClass))
#define IS_COLOUR_WHEEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLOUR_WHEEL))
#define IS_COLOUR_WHEEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLOUR_WHEEL))
#define COLOUR_WHEEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLOUR_WHEEL, ColourWheelClass))

typedef struct _ColourWheel ColourWheel;
typedef struct _ColourWheelClass ColourWheelClass;

#define TYPE_OVERLAY_MESSAGE (overlay_message_get_type ())
#define OVERLAY_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OVERLAY_MESSAGE, OverlayMessage))
#define OVERLAY_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OVERLAY_MESSAGE, OverlayMessageClass))
#define IS_OVERLAY_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OVERLAY_MESSAGE))
#define IS_OVERLAY_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OVERLAY_MESSAGE))
#define OVERLAY_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OVERLAY_MESSAGE, OverlayMessageClass))

typedef struct _OverlayMessage OverlayMessage;
typedef struct _OverlayMessageClass OverlayMessageClass;
enum  {
	CONTROLS_GRID_0_PROPERTY,
	CONTROLS_GRID_NUM_PROPERTIES
};
static GParamSpec* controls_grid_properties[CONTROLS_GRID_NUM_PROPERTIES];
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef void (*ColourWheelResultFunction) (gint r, gpointer user_data);
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
typedef struct _OverlayMessagePrivate OverlayMessagePrivate;
enum  {
	OVERLAY_MESSAGE_0_PROPERTY,
	OVERLAY_MESSAGE_TEXT_PROPERTY,
	OVERLAY_MESSAGE_WIDTH_PROPERTY,
	OVERLAY_MESSAGE_NUM_PROPERTIES
};
static GParamSpec* overlay_message_properties[OVERLAY_MESSAGE_NUM_PROPERTIES];
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

struct _Controls {
	GtkBox parent_instance;
	ControlsPrivate * priv;
	GeeList* worm_settings;
};

struct _ControlsClass {
	GtkBoxClass parent_class;
};

struct _ControlsPrivate {
	GtkBox* grids_box;
	GtkButton* button;
	GeeLinkedList* grids;
};

struct _Block1Data {
	int _ref_count_;
	Controls* self;
	GeeLinkedList* worms;
	GeeHashMap* worms_props;
};

struct _Position {
	guint8 x;
	guint8 y;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gint rounds_to_stay_still;
	gboolean is_stopped;
	Position warp_position;
	gboolean warp_bonus;
	WormPositions* list;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _ControlsGrid {
	GtkBox parent_instance;
	ControlsGridPrivate * priv;
	Controls* controls;
	WormProperties* worm_props;
	gulong external_handler;
};

struct _ControlsGridClass {
	GtkBoxClass parent_class;
};

struct _Arrow {
	GtkWidget parent_instance;
	ArrowPrivate * priv;
};

struct _ArrowClass {
	GtkWidgetClass parent_class;
};

struct _ArrowPrivate {
	ArroweDirection _direction;
	CheckDuplicate check_duplicate;
	gpointer check_duplicate_target;
};

struct _Arrowxy {
	gdouble x;
	gdouble y;
};

struct _ControlsGridPrivate {
	GtkOverlay* overlay;
	GtkGrid* grid;
	GtkButton* name_label;
	Arrow* arrow_up;
	Arrow* arrow_down;
	Arrow* arrow_left;
	Arrow* arrow_right;
	GtkButton* move_up_button;
	GtkButton* move_down_button;
	GtkButton* move_left_button;
	GtkButton* move_right_button;
	ColourWheel* wheel;
	gulong up_handler;
	gulong down_handler;
	gulong left_handler;
	gulong right_handler;
	gulong color_handler;
	OverlayMessage* key_press_message;
	gboolean duplicate[4];
};

struct _Block2Data {
	int _ref_count_;
	ControlsGrid* self;
	gchar* player_id;
	Controls* controls;
	WormProperties* worm_props;
	GeeHashMap* worms_props;
};

struct _OverlayMessage {
	GtkWidget parent_instance;
	OverlayMessagePrivate * priv;
};

struct _OverlayMessageClass {
	GtkWidgetClass parent_class;
};

struct _OverlayMessagePrivate {
	gchar* _text;
	gint _width;
};

static gint Controls_private_offset;
static gpointer controls_parent_class = NULL;
static gint Arrow_private_offset;
static gpointer arrow_parent_class = NULL;
static gint ControlsGrid_private_offset;
static gpointer controls_grid_parent_class = NULL;
static gint OverlayMessage_private_offset;
static gpointer overlay_message_parent_class = NULL;

VALA_EXTERN GType controls_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Controls, g_object_unref)
VALA_EXTERN GType controls_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ControlsGrid, g_object_unref)
VALA_EXTERN GType worm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Worm, g_object_unref)
VALA_EXTERN GType worm_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormProperties, g_object_unref)
VALA_EXTERN void controls_prepare (Controls* self,
                       GeeLinkedList* worms,
                       GeeHashMap* worms_props,
                       GeeList* worm_settings);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN GType position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Position* position_dup (const Position* self);
VALA_EXTERN void position_free (Position* self);
VALA_EXTERN GType worm_positions_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormPositions, g_object_unref)
VALA_EXTERN gint worm_get_id (Worm* self);
VALA_EXTERN ControlsGrid* controls_grid_new (Controls* controls,
                                 gint worm_id,
                                 WormProperties* worm_props,
                                 GeeHashMap* worms_props);
VALA_EXTERN ControlsGrid* controls_grid_construct (GType object_type,
                                       Controls* controls,
                                       gint worm_id,
                                       WormProperties* worm_props,
                                       GeeHashMap* worms_props);
static void controls_check_for_duplicates (Controls* self,
                                    guint key,
                                    GHashTable** encountered_keys,
                                    GHashTable** duplicate_keys);
VALA_EXTERN guint worm_properties_get_up (WormProperties* self);
VALA_EXTERN guint worm_properties_get_down (WormProperties* self);
VALA_EXTERN guint worm_properties_get_left (WormProperties* self);
VALA_EXTERN guint worm_properties_get_right (WormProperties* self);
static void ____lambda34_ (Block1Data* _data1_);
VALA_EXTERN void controls_grid_mark_duplicated_keys (ControlsGrid* self,
                                         GHashTable* duplicate_keys);
static void _____lambda34__g_object_notify (GObject* _sender,
                                     GParamSpec* pspec,
                                     gpointer self);
VALA_EXTERN void controls_clean (Controls* self);
VALA_EXTERN void controls_grid_disconnect_stuff (ControlsGrid* self);
VALA_EXTERN Controls* controls_new (void);
VALA_EXTERN Controls* controls_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__POINTER_POINTER (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static void controls_finalize (GObject * obj);
static GType controls_get_type_once (void);
VALA_EXTERN GType arrow_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Arrow, g_object_unref)
VALA_EXTERN GType arrow_edirection_get_type (void) G_GNUC_CONST ;
static void arrow_real_snapshot (GtkWidget* base,
                          GtkSnapshot* s);
static GType arrow_xy_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static Arrowxy* arrow_xy_dup (const Arrowxy* self);
static void arrow_xy_free (Arrowxy* self);
VALA_EXTERN ArroweDirection arrow_get_direction (Arrow* self);
VALA_EXTERN void arrow_SetCheckDuplicate (Arrow* self,
                              CheckDuplicate f,
                              gpointer f_target);
VALA_EXTERN Arrow* arrow_new (void);
VALA_EXTERN Arrow* arrow_construct (GType object_type);
VALA_EXTERN void arrow_set_direction (Arrow* self,
                          ArroweDirection value);
static void arrow_finalize (GObject * obj);
static GType arrow_get_type_once (void);
static void _vala_arrow_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec);
static void _vala_arrow_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec);
VALA_EXTERN GType colour_wheel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ColourWheel, g_object_unref)
VALA_EXTERN GType overlay_message_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OverlayMessage, g_object_unref)
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda15_ (Block2Data* _data2_);
VALA_EXTERN void get_worm_pango_color (gint color,
                           gboolean bright,
                           PangoColor* c);
VALA_EXTERN gint worm_properties_get_color (WormProperties* self);
static void ___lambda15__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean __lambda16_ (ControlsGrid* self,
                      guint i);
static gboolean ___lambda16__check_duplicate (guint i,
                                       gpointer self);
static gboolean __lambda17_ (ControlsGrid* self,
                      guint i);
static gboolean ___lambda17__check_duplicate (guint i,
                                       gpointer self);
static gboolean __lambda18_ (ControlsGrid* self,
                      guint i);
static gboolean ___lambda18__check_duplicate (guint i,
                                       gpointer self);
static gboolean __lambda19_ (ControlsGrid* self,
                      guint i);
static gboolean ___lambda19__check_duplicate (guint i,
                                       gpointer self);
static void __lambda20_ (Block2Data* _data2_);
static void controls_grid_configure_label (guint key_value,
                                    GtkLabel* label);
static void ___lambda20__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda21_ (Block2Data* _data2_);
static void ___lambda21__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda22_ (Block2Data* _data2_);
static void ___lambda22__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda23_ (Block2Data* _data2_);
static void ___lambda23__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda24_ (Block2Data* _data2_);
VALA_EXTERN void colour_wheel_do_select_segment (ColourWheel* self,
                                     gint current_selection,
                                     ColourWheelResultFunction result_function,
                                     gpointer result_function_target);
static void ____lambda25_ (Block2Data* _data2_,
                    gint c);
static void controls_grid_swap_color (ControlsGrid* self,
                               GeeHashMap* worms_props,
                               gint c);
static void _____lambda25__colour_wheel_result_function (gint r,
                                                  gpointer self);
static void ___lambda24__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda26_ (Block2Data* _data2_);
VALA_EXTERN OverlayMessage* overlay_message_new (const gchar* text,
                                     gint width);
VALA_EXTERN OverlayMessage* overlay_message_construct (GType object_type,
                                           const gchar* text,
                                           gint width);
static gboolean ___lambda27_ (ControlsGrid* self,
                       guint keyval,
                       guint keycode,
                       gboolean* remove_handler);
VALA_EXTERN void worm_properties_set_up (WormProperties* self,
                             guint value);
VALA_EXTERN gint worm_properties_get_raw_up (WormProperties* self);
VALA_EXTERN void worm_properties_set_raw_up (WormProperties* self,
                                 gint value);
static gboolean ____lambda27__keypress_handler_function (guint a,
                                                  guint b,
                                                  gboolean* remove_handler,
                                                  gpointer self);
static void ___lambda26__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda28_ (Block2Data* _data2_);
static gboolean ___lambda29_ (ControlsGrid* self,
                       guint keyval,
                       guint keycode,
                       gboolean* remove_handler);
VALA_EXTERN void worm_properties_set_down (WormProperties* self,
                               guint value);
VALA_EXTERN gint worm_properties_get_raw_down (WormProperties* self);
VALA_EXTERN void worm_properties_set_raw_down (WormProperties* self,
                                   gint value);
static gboolean ____lambda29__keypress_handler_function (guint a,
                                                  guint b,
                                                  gboolean* remove_handler,
                                                  gpointer self);
static void ___lambda28__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda30_ (Block2Data* _data2_);
static gboolean ___lambda31_ (ControlsGrid* self,
                       guint keyval,
                       guint keycode,
                       gboolean* remove_handler);
VALA_EXTERN void worm_properties_set_left (WormProperties* self,
                               guint value);
VALA_EXTERN gint worm_properties_get_raw_left (WormProperties* self);
VALA_EXTERN void worm_properties_set_raw_left (WormProperties* self,
                                   gint value);
static gboolean ____lambda31__keypress_handler_function (guint a,
                                                  guint b,
                                                  gboolean* remove_handler,
                                                  gpointer self);
static void ___lambda30__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda32_ (Block2Data* _data2_);
static gboolean ___lambda33_ (ControlsGrid* self,
                       guint keyval,
                       guint keycode,
                       gboolean* remove_handler);
VALA_EXTERN void worm_properties_set_right (WormProperties* self,
                                guint value);
VALA_EXTERN gint worm_properties_get_raw_right (WormProperties* self);
VALA_EXTERN void worm_properties_set_raw_right (WormProperties* self,
                                    gint value);
static gboolean ____lambda33__keypress_handler_function (guint a,
                                                  guint b,
                                                  gboolean* remove_handler,
                                                  gpointer self);
static void ___lambda32__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
VALA_EXTERN void worm_properties_set_color (WormProperties* self,
                                gint value);
static void controls_grid_set_duplicate_class (ControlsGrid* self,
                                        gboolean duplicate,
                                        GtkLabel* label);
static void controls_grid_finalize (GObject * obj);
static GType controls_grid_get_type_once (void);
static void overlay_message_real_snapshot (GtkWidget* base,
                                    GtkSnapshot* snapshot);
static gint overlay_message_calculate_font_size (OverlayMessage* self,
                                          const gchar* text,
                                          gint target_width,
                                          gdouble* width,
                                          gdouble* height);
VALA_EXTERN const gchar* overlay_message_get_text (OverlayMessage* self);
VALA_EXTERN gint overlay_message_get_width (OverlayMessage* self);
static void overlay_message_draw_text_font_size (OverlayMessage* self,
                                          GtkSnapshot* snapshot,
                                          gint x,
                                          gint y,
                                          const gchar* text,
                                          gint font_size);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self);
static void overlay_message_get_text_offsets (OverlayMessage* self,
                                       const gchar* text,
                                       gint font_size,
                                       gint* x_offset,
                                       gint* y_offset);
VALA_EXTERN void overlay_message_set_text (OverlayMessage* self,
                               const gchar* value);
VALA_EXTERN void overlay_message_set_width (OverlayMessage* self,
                                gint value);
static void overlay_message_finalize (GObject * obj);
static GType overlay_message_get_type_once (void);
static void _vala_overlay_message_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_overlay_message_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
controls_get_instance_private (Controls* self)
{
	return G_STRUCT_MEMBER_P (self, Controls_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Controls* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->worms);
		_g_object_unref0 (_data1_->worms_props);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
____lambda34_ (Block1Data* _data1_)
{
	Controls* self;
	GHashTable* _duplicate_keys = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _encountered_keys = NULL;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	self = _data1_->self;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, NULL);
	_duplicate_keys = _tmp2_;
	_tmp3_ = g_direct_hash;
	_tmp4_ = g_direct_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, NULL, NULL);
	_encountered_keys = _tmp5_;
	{
		GeeLinkedList* _worm_list = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _worm_index = 0;
		_worm_list = _data1_->worms;
		_tmp6_ = _worm_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_worm_size = _tmp8_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp11_;
			gpointer _tmp12_;
			Worm* _tmp13_;
			_worm_index = _worm_index + 1;
			_tmp9_ = _worm_index;
			_tmp10_ = _worm_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _worm_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _worm_index);
			worm = (Worm*) _tmp12_;
			_tmp13_ = worm;
			if (_tmp13_->is_human) {
				WormProperties* worm_prop = NULL;
				Worm* _tmp14_;
				gpointer _tmp15_;
				WormProperties* _tmp16_;
				guint _tmp17_;
				guint _tmp18_;
				WormProperties* _tmp19_;
				guint _tmp20_;
				guint _tmp21_;
				WormProperties* _tmp22_;
				guint _tmp23_;
				guint _tmp24_;
				WormProperties* _tmp25_;
				guint _tmp26_;
				guint _tmp27_;
				_tmp14_ = worm;
				_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _data1_->worms_props, _tmp14_);
				worm_prop = (WormProperties*) _tmp15_;
				_tmp16_ = worm_prop;
				_tmp17_ = worm_properties_get_up (_tmp16_);
				_tmp18_ = _tmp17_;
				controls_check_for_duplicates (self, _tmp18_, &_encountered_keys, &_duplicate_keys);
				_tmp19_ = worm_prop;
				_tmp20_ = worm_properties_get_down (_tmp19_);
				_tmp21_ = _tmp20_;
				controls_check_for_duplicates (self, _tmp21_, &_encountered_keys, &_duplicate_keys);
				_tmp22_ = worm_prop;
				_tmp23_ = worm_properties_get_left (_tmp22_);
				_tmp24_ = _tmp23_;
				controls_check_for_duplicates (self, _tmp24_, &_encountered_keys, &_duplicate_keys);
				_tmp25_ = worm_prop;
				_tmp26_ = worm_properties_get_right (_tmp25_);
				_tmp27_ = _tmp26_;
				controls_check_for_duplicates (self, _tmp27_, &_encountered_keys, &_duplicate_keys);
				_g_object_unref0 (worm_prop);
			}
			_g_object_unref0 (worm);
		}
	}
	{
		GeeLinkedList* __grid_list = NULL;
		GeeLinkedList* _tmp28_;
		gint __grid_size = 0;
		GeeLinkedList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint __grid_index = 0;
		_tmp28_ = self->priv->grids;
		__grid_list = _tmp28_;
		_tmp29_ = __grid_list;
		_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		__grid_size = _tmp31_;
		__grid_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			ControlsGrid* _grid = NULL;
			GeeLinkedList* _tmp34_;
			gpointer _tmp35_;
			ControlsGrid* _tmp36_;
			GHashTable* _tmp37_;
			__grid_index = __grid_index + 1;
			_tmp32_ = __grid_index;
			_tmp33_ = __grid_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = __grid_list;
			_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, __grid_index);
			_grid = (ControlsGrid*) _tmp35_;
			_tmp36_ = _grid;
			_tmp37_ = _duplicate_keys;
			controls_grid_mark_duplicated_keys (_tmp36_, _tmp37_);
			_g_object_unref0 (_grid);
		}
	}
	_g_hash_table_unref0 (_encountered_keys);
	_g_hash_table_unref0 (_duplicate_keys);
}

static void
_____lambda34__g_object_notify (GObject* _sender,
                                GParamSpec* pspec,
                                gpointer self)
{
	____lambda34_ (self);
}

void
controls_prepare (Controls* self,
                  GeeLinkedList* worms,
                  GeeHashMap* worms_props,
                  GeeList* worm_settings)
{
	Block1Data* _data1_;
	GeeLinkedList* _tmp0_;
	GeeHashMap* _tmp1_;
	GtkButton* _tmp11_;
	GHashTable* duplicate_keys = NULL;
	GHashFunc _tmp14_;
	GEqualFunc _tmp15_;
	GHashTable* _tmp16_;
	GHashTable* encountered_keys = NULL;
	GHashFunc _tmp17_;
	GEqualFunc _tmp18_;
	GHashTable* _tmp19_;
	GeeList* _tmp65_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worms != NULL);
	g_return_if_fail (worms_props != NULL);
	g_return_if_fail (worm_settings != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (worms);
	_g_object_unref0 (_data1_->worms);
	_data1_->worms = _tmp0_;
	_tmp1_ = _g_object_ref0 (worms_props);
	_g_object_unref0 (_data1_->worms_props);
	_data1_->worms_props = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			GtkBox* _tmp3_;
			GtkWidget* _tmp4_;
			GtkWidget* child = NULL;
			GtkBox* _tmp5_;
			GtkWidget* _tmp6_;
			GtkWidget* _tmp7_;
			GtkBox* _tmp8_;
			GtkWidget* _tmp9_;
			GtkWidget* _tmp10_;
			if (!_tmp2_) {
			}
			_tmp2_ = FALSE;
			_tmp3_ = self->priv->grids_box;
			_tmp4_ = gtk_widget_get_last_child ((GtkWidget*) _tmp3_);
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = self->priv->grids_box;
			_tmp6_ = gtk_widget_get_last_child ((GtkWidget*) _tmp5_);
			_tmp7_ = _g_object_ref0 (_tmp6_);
			child = _tmp7_;
			_tmp8_ = self->priv->grids_box;
			_tmp9_ = child;
			gtk_box_remove (_tmp8_, _tmp9_);
			_tmp10_ = child;
			g_signal_emit_by_name (_tmp10_, "destroy");
			_g_object_unref0 (child);
		}
	}
	_tmp11_ = self->priv->button;
	if (gtk_widget_has_css_class ((GtkWidget*) _tmp11_, "play")) {
		GtkButton* _tmp12_;
		GtkButton* _tmp13_;
		_tmp12_ = self->priv->button;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp12_, "play");
		_tmp13_ = self->priv->button;
		gtk_widget_add_css_class ((GtkWidget*) _tmp13_, "pill");
	}
	_tmp14_ = g_direct_hash;
	_tmp15_ = g_direct_equal;
	_tmp16_ = g_hash_table_new_full (_tmp14_, _tmp15_, NULL, NULL);
	duplicate_keys = _tmp16_;
	_tmp17_ = g_direct_hash;
	_tmp18_ = g_direct_equal;
	_tmp19_ = g_hash_table_new_full (_tmp17_, _tmp18_, NULL, NULL);
	encountered_keys = _tmp19_;
	{
		GeeLinkedList* _worm_list = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _worm_index = 0;
		_worm_list = _data1_->worms;
		_tmp20_ = _worm_list;
		_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_worm_size = _tmp22_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp25_;
			gpointer _tmp26_;
			Worm* _tmp27_;
			_worm_index = _worm_index + 1;
			_tmp23_ = _worm_index;
			_tmp24_ = _worm_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _worm_list;
			_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _worm_index);
			worm = (Worm*) _tmp26_;
			_tmp27_ = worm;
			if (_tmp27_->is_human) {
				WormProperties* worm_prop = NULL;
				Worm* _tmp28_;
				gpointer _tmp29_;
				ControlsGrid* grid = NULL;
				Worm* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				WormProperties* _tmp33_;
				ControlsGrid* _tmp34_;
				GtkBox* _tmp35_;
				ControlsGrid* _tmp36_;
				GeeLinkedList* _tmp37_;
				ControlsGrid* _tmp38_;
				WormProperties* _tmp39_;
				guint _tmp40_;
				guint _tmp41_;
				WormProperties* _tmp42_;
				guint _tmp43_;
				guint _tmp44_;
				WormProperties* _tmp45_;
				guint _tmp46_;
				guint _tmp47_;
				WormProperties* _tmp48_;
				guint _tmp49_;
				guint _tmp50_;
				_tmp28_ = worm;
				_tmp29_ = gee_abstract_map_get ((GeeAbstractMap*) _data1_->worms_props, _tmp28_);
				worm_prop = (WormProperties*) _tmp29_;
				_tmp30_ = worm;
				_tmp31_ = worm_get_id (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = worm_prop;
				_tmp34_ = controls_grid_new (self, _tmp32_, _tmp33_, _data1_->worms_props);
				g_object_ref_sink (_tmp34_);
				grid = _tmp34_;
				_tmp35_ = self->priv->grids_box;
				_tmp36_ = grid;
				gtk_box_append (_tmp35_, (GtkWidget*) _tmp36_);
				_tmp37_ = self->priv->grids;
				_tmp38_ = grid;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, _tmp38_);
				_tmp39_ = worm_prop;
				_tmp40_ = worm_properties_get_up (_tmp39_);
				_tmp41_ = _tmp40_;
				controls_check_for_duplicates (self, _tmp41_, &encountered_keys, &duplicate_keys);
				_tmp42_ = worm_prop;
				_tmp43_ = worm_properties_get_down (_tmp42_);
				_tmp44_ = _tmp43_;
				controls_check_for_duplicates (self, _tmp44_, &encountered_keys, &duplicate_keys);
				_tmp45_ = worm_prop;
				_tmp46_ = worm_properties_get_left (_tmp45_);
				_tmp47_ = _tmp46_;
				controls_check_for_duplicates (self, _tmp47_, &encountered_keys, &duplicate_keys);
				_tmp48_ = worm_prop;
				_tmp49_ = worm_properties_get_right (_tmp48_);
				_tmp50_ = _tmp49_;
				controls_check_for_duplicates (self, _tmp50_, &encountered_keys, &duplicate_keys);
				_g_object_unref0 (grid);
				_g_object_unref0 (worm_prop);
			}
			_g_object_unref0 (worm);
		}
	}
	{
		GeeLinkedList* _grid_list = NULL;
		GeeLinkedList* _tmp51_;
		gint _grid_size = 0;
		GeeLinkedList* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _grid_index = 0;
		_tmp51_ = self->priv->grids;
		_grid_list = _tmp51_;
		_tmp52_ = _grid_list;
		_tmp53_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp52_);
		_tmp54_ = _tmp53_;
		_grid_size = _tmp54_;
		_grid_index = -1;
		while (TRUE) {
			gint _tmp55_;
			gint _tmp56_;
			ControlsGrid* grid = NULL;
			GeeLinkedList* _tmp57_;
			gpointer _tmp58_;
			ControlsGrid* _tmp59_;
			ControlsGrid* _tmp60_;
			WormProperties* _tmp61_;
			gulong _tmp62_;
			ControlsGrid* _tmp63_;
			GHashTable* _tmp64_;
			_grid_index = _grid_index + 1;
			_tmp55_ = _grid_index;
			_tmp56_ = _grid_size;
			if (!(_tmp55_ < _tmp56_)) {
				break;
			}
			_tmp57_ = _grid_list;
			_tmp58_ = gee_abstract_list_get ((GeeAbstractList*) _tmp57_, _grid_index);
			grid = (ControlsGrid*) _tmp58_;
			_tmp59_ = grid;
			_tmp60_ = grid;
			_tmp61_ = _tmp60_->worm_props;
			_tmp62_ = g_signal_connect_data ((GObject*) _tmp61_, "notify", (GCallback) _____lambda34__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
			_tmp59_->external_handler = _tmp62_;
			_tmp63_ = grid;
			_tmp64_ = duplicate_keys;
			controls_grid_mark_duplicated_keys (_tmp63_, _tmp64_);
			_g_object_unref0 (grid);
		}
	}
	_tmp65_ = _g_object_ref0 (worm_settings);
	_g_object_unref0 (self->worm_settings);
	self->worm_settings = _tmp65_;
	_g_hash_table_unref0 (encountered_keys);
	_g_hash_table_unref0 (duplicate_keys);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
controls_check_for_duplicates (Controls* self,
                               guint key,
                               GHashTable** encountered_keys,
                               GHashTable** duplicate_keys)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*encountered_keys != NULL);
	g_return_if_fail (*duplicate_keys != NULL);
	if (g_hash_table_contains (*encountered_keys, (gpointer) ((guintptr) key))) {
		g_hash_table_add (*duplicate_keys, (gpointer) ((guintptr) key));
	} else {
		g_hash_table_add (*encountered_keys, (gpointer) ((guintptr) key));
	}
}

void
controls_clean (Controls* self)
{
	GeeLinkedList* _tmp12_;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _grid_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _grid_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _grid_index = 0;
		_tmp0_ = self->priv->grids;
		_grid_list = _tmp0_;
		_tmp1_ = _grid_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_grid_size = _tmp3_;
		_grid_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ControlsGrid* grid = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			ControlsGrid* _tmp8_;
			WormProperties* _tmp9_;
			ControlsGrid* _tmp10_;
			ControlsGrid* _tmp11_;
			_grid_index = _grid_index + 1;
			_tmp4_ = _grid_index;
			_tmp5_ = _grid_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _grid_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _grid_index);
			grid = (ControlsGrid*) _tmp7_;
			_tmp8_ = grid;
			_tmp9_ = _tmp8_->worm_props;
			_tmp10_ = grid;
			g_signal_handler_disconnect ((GObject*) _tmp9_, _tmp10_->external_handler);
			_tmp11_ = grid;
			controls_grid_disconnect_stuff (_tmp11_);
			_g_object_unref0 (grid);
		}
	}
	_tmp12_ = self->priv->grids;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp12_);
}

Controls*
controls_construct (GType object_type)
{
	Controls * self = NULL;
	self = (Controls*) g_object_new (object_type, NULL);
	return self;
}

Controls*
controls_new (void)
{
	return controls_construct (TYPE_CONTROLS);
}

static void
g_cclosure_user_marshal_VOID__POINTER_POINTER (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__POINTER_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}

static void
controls_class_init (ControlsClass * klass,
                     gpointer klass_data)
{
	controls_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Controls_private_offset);
	G_OBJECT_CLASS (klass)->finalize = controls_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/controls.ui");
	controls_signals[CONTROLS_ADD_KEYPRESS_HANDLER_SIGNAL] = g_signal_new ("add-keypress-handler", TYPE_CONTROLS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_POINTER, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_POINTER);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grids_box", FALSE, Controls_private_offset + G_STRUCT_OFFSET (ControlsPrivate, grids_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button", FALSE, Controls_private_offset + G_STRUCT_OFFSET (ControlsPrivate, button));
}

static void
controls_instance_init (Controls * self,
                        gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = controls_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (TYPE_CONTROLS_GRID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->grids = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
controls_finalize (GObject * obj)
{
	Controls * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTROLS, Controls);
	_g_object_unref0 (self->priv->grids);
	_g_object_unref0 (self->worm_settings);
	G_OBJECT_CLASS (controls_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
controls_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ControlsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) controls_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Controls), 0, (GInstanceInitFunc) controls_instance_init, NULL };
	GType controls_type_id;
	controls_type_id = g_type_register_static (gtk_box_get_type (), "Controls", &g_define_type_info, 0);
	Controls_private_offset = g_type_add_instance_private (controls_type_id, sizeof (ControlsPrivate));
	return controls_type_id;
}

GType
controls_get_type (void)
{
	static gsize controls_type_id__once = 0;
	if (g_once_init_enter (&controls_type_id__once)) {
		GType controls_type_id;
		controls_type_id = controls_get_type_once ();
		g_once_init_leave (&controls_type_id__once, controls_type_id);
	}
	return controls_type_id__once;
}

static inline gpointer
arrow_get_instance_private (Arrow* self)
{
	return G_STRUCT_MEMBER_P (self, Arrow_private_offset);
}

 G_GNUC_NO_INLINE static GType
arrow_edirection_get_type_once (void)
{
	static const GEnumValue values[] = {{ARROW_EDIRECTION_up, "ARROW_EDIRECTION_up", "up"}, {ARROW_EDIRECTION_down, "ARROW_EDIRECTION_down", "down"}, {ARROW_EDIRECTION_left, "ARROW_EDIRECTION_left", "left"}, {ARROW_EDIRECTION_right, "ARROW_EDIRECTION_right", "right"}, {0, NULL, NULL}};
	GType arrow_edirection_type_id;
	arrow_edirection_type_id = g_enum_register_static ("ArroweDirection", values);
	return arrow_edirection_type_id;
}

GType
arrow_edirection_get_type (void)
{
	static gsize arrow_edirection_type_id__once = 0;
	if (g_once_init_enter (&arrow_edirection_type_id__once)) {
		GType arrow_edirection_type_id;
		arrow_edirection_type_id = arrow_edirection_get_type_once ();
		g_once_init_leave (&arrow_edirection_type_id__once, arrow_edirection_type_id);
	}
	return arrow_edirection_type_id__once;
}

static void
arrow_real_snapshot (GtkWidget* base,
                     GtkSnapshot* s)
{
	Arrow * self;
	GskPathBuilder* path = NULL;
	GskPathBuilder* _tmp0_;
	gdouble width = 0.0;
	gdouble height = 0.0;
	Arrowxy a[7] = {0};
	ArroweDirection _tmp1_;
	GdkRGBA c = {0};
	gboolean _tmp42_ = FALSE;
	CheckDuplicate _tmp43_;
	gpointer _tmp43__target;
	GskPathBuilder* _tmp48_;
	GskPath* _tmp49_;
	GskPath* _tmp50_;
	GdkRGBA _tmp51_;
	self = (Arrow*) base;
	g_return_if_fail (s != NULL);
	_tmp0_ = gsk_path_builder_new ();
	path = _tmp0_;
	width = (gdouble) gtk_widget_get_width ((GtkWidget*) self);
	height = (gdouble) gtk_widget_get_height ((GtkWidget*) self);
	_tmp1_ = self->priv->_direction;
	switch (_tmp1_) {
		default:
		case ARROW_EDIRECTION_up:
		{
			Arrowxy _tmp2_ = {0};
			Arrowxy _tmp3_ = {0};
			Arrowxy _tmp4_ = {0};
			Arrowxy _tmp5_ = {0};
			Arrowxy _tmp6_ = {0};
			Arrowxy _tmp7_ = {0};
			Arrowxy _tmp8_ = {0};
			Arrowxy _tmp9_[7] = {0};
			memset (&_tmp2_, 0, sizeof (Arrowxy));
			_tmp2_.x = (gdouble) 0;
			_tmp2_.y = height / 2;
			memset (&_tmp3_, 0, sizeof (Arrowxy));
			_tmp3_.x = width / 2;
			_tmp3_.y = (gdouble) 0;
			memset (&_tmp4_, 0, sizeof (Arrowxy));
			_tmp4_.x = width;
			_tmp4_.y = height / 2;
			memset (&_tmp5_, 0, sizeof (Arrowxy));
			_tmp5_.x = (width * 2) / 3;
			_tmp5_.y = height / 2;
			memset (&_tmp6_, 0, sizeof (Arrowxy));
			_tmp6_.x = (width * 2) / 3;
			_tmp6_.y = height;
			memset (&_tmp7_, 0, sizeof (Arrowxy));
			_tmp7_.x = width / 3;
			_tmp7_.y = height;
			memset (&_tmp8_, 0, sizeof (Arrowxy));
			_tmp8_.x = width / 3;
			_tmp8_.y = height / 2;
			_tmp9_[0] = _tmp2_;
			_tmp9_[1] = _tmp3_;
			_tmp9_[2] = _tmp4_;
			_tmp9_[3] = _tmp5_;
			_tmp9_[4] = _tmp6_;
			_tmp9_[5] = _tmp7_;
			_tmp9_[6] = _tmp8_;
			memcpy (a, _tmp9_, 7 * sizeof (Arrowxy));
			break;
		}
		case ARROW_EDIRECTION_down:
		{
			Arrowxy _tmp10_ = {0};
			Arrowxy _tmp11_ = {0};
			Arrowxy _tmp12_ = {0};
			Arrowxy _tmp13_ = {0};
			Arrowxy _tmp14_ = {0};
			Arrowxy _tmp15_ = {0};
			Arrowxy _tmp16_ = {0};
			Arrowxy _tmp17_[7] = {0};
			memset (&_tmp10_, 0, sizeof (Arrowxy));
			_tmp10_.x = (gdouble) 0;
			_tmp10_.y = height / 2;
			memset (&_tmp11_, 0, sizeof (Arrowxy));
			_tmp11_.x = width / 2;
			_tmp11_.y = height;
			memset (&_tmp12_, 0, sizeof (Arrowxy));
			_tmp12_.x = width;
			_tmp12_.y = height / 2;
			memset (&_tmp13_, 0, sizeof (Arrowxy));
			_tmp13_.x = (width * 2) / 3;
			_tmp13_.y = height / 2;
			memset (&_tmp14_, 0, sizeof (Arrowxy));
			_tmp14_.x = (width * 2) / 3;
			_tmp14_.y = (gdouble) 0;
			memset (&_tmp15_, 0, sizeof (Arrowxy));
			_tmp15_.x = width / 3;
			_tmp15_.y = (gdouble) 0;
			memset (&_tmp16_, 0, sizeof (Arrowxy));
			_tmp16_.x = width / 3;
			_tmp16_.y = height / 2;
			_tmp17_[0] = _tmp10_;
			_tmp17_[1] = _tmp11_;
			_tmp17_[2] = _tmp12_;
			_tmp17_[3] = _tmp13_;
			_tmp17_[4] = _tmp14_;
			_tmp17_[5] = _tmp15_;
			_tmp17_[6] = _tmp16_;
			memcpy (a, _tmp17_, 7 * sizeof (Arrowxy));
			break;
		}
		case ARROW_EDIRECTION_left:
		{
			Arrowxy _tmp18_ = {0};
			Arrowxy _tmp19_ = {0};
			Arrowxy _tmp20_ = {0};
			Arrowxy _tmp21_ = {0};
			Arrowxy _tmp22_ = {0};
			Arrowxy _tmp23_ = {0};
			Arrowxy _tmp24_ = {0};
			Arrowxy _tmp25_[7] = {0};
			memset (&_tmp18_, 0, sizeof (Arrowxy));
			_tmp18_.x = width / 2;
			_tmp18_.y = (gdouble) 0;
			memset (&_tmp19_, 0, sizeof (Arrowxy));
			_tmp19_.x = (gdouble) 0;
			_tmp19_.y = height / 2;
			memset (&_tmp20_, 0, sizeof (Arrowxy));
			_tmp20_.x = width / 2;
			_tmp20_.y = height;
			memset (&_tmp21_, 0, sizeof (Arrowxy));
			_tmp21_.x = width / 2;
			_tmp21_.y = (height * 2) / 3;
			memset (&_tmp22_, 0, sizeof (Arrowxy));
			_tmp22_.x = width;
			_tmp22_.y = (height * 2) / 3;
			memset (&_tmp23_, 0, sizeof (Arrowxy));
			_tmp23_.x = width;
			_tmp23_.y = height / 3;
			memset (&_tmp24_, 0, sizeof (Arrowxy));
			_tmp24_.x = width / 2;
			_tmp24_.y = height / 3;
			_tmp25_[0] = _tmp18_;
			_tmp25_[1] = _tmp19_;
			_tmp25_[2] = _tmp20_;
			_tmp25_[3] = _tmp21_;
			_tmp25_[4] = _tmp22_;
			_tmp25_[5] = _tmp23_;
			_tmp25_[6] = _tmp24_;
			memcpy (a, _tmp25_, 7 * sizeof (Arrowxy));
			break;
		}
		case ARROW_EDIRECTION_right:
		{
			Arrowxy _tmp26_ = {0};
			Arrowxy _tmp27_ = {0};
			Arrowxy _tmp28_ = {0};
			Arrowxy _tmp29_ = {0};
			Arrowxy _tmp30_ = {0};
			Arrowxy _tmp31_ = {0};
			Arrowxy _tmp32_ = {0};
			Arrowxy _tmp33_[7] = {0};
			memset (&_tmp26_, 0, sizeof (Arrowxy));
			_tmp26_.x = width / 2;
			_tmp26_.y = (gdouble) 0;
			memset (&_tmp27_, 0, sizeof (Arrowxy));
			_tmp27_.x = width;
			_tmp27_.y = height / 2;
			memset (&_tmp28_, 0, sizeof (Arrowxy));
			_tmp28_.x = width / 2;
			_tmp28_.y = height;
			memset (&_tmp29_, 0, sizeof (Arrowxy));
			_tmp29_.x = width / 2;
			_tmp29_.y = (height * 2) / 3;
			memset (&_tmp30_, 0, sizeof (Arrowxy));
			_tmp30_.x = (gdouble) 0;
			_tmp30_.y = (height * 2) / 3;
			memset (&_tmp31_, 0, sizeof (Arrowxy));
			_tmp31_.x = (gdouble) 0;
			_tmp31_.y = height / 3;
			memset (&_tmp32_, 0, sizeof (Arrowxy));
			_tmp32_.x = width / 2;
			_tmp32_.y = height / 3;
			_tmp33_[0] = _tmp26_;
			_tmp33_[1] = _tmp27_;
			_tmp33_[2] = _tmp28_;
			_tmp33_[3] = _tmp29_;
			_tmp33_[4] = _tmp30_;
			_tmp33_[5] = _tmp31_;
			_tmp33_[6] = _tmp32_;
			memcpy (a, _tmp33_, 7 * sizeof (Arrowxy));
			break;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp34_ = FALSE;
			_tmp34_ = TRUE;
			while (TRUE) {
				if (!_tmp34_) {
					gint _tmp35_;
					_tmp35_ = i;
					i = _tmp35_ + 1;
				}
				_tmp34_ = FALSE;
				if (!(i < 7)) {
					break;
				}
				if (i == 0) {
					GskPathBuilder* _tmp36_;
					Arrowxy _tmp37_;
					Arrowxy _tmp38_;
					_tmp36_ = path;
					_tmp37_ = a[0];
					_tmp38_ = a[0];
					gsk_path_builder_move_to (_tmp36_, (gfloat) _tmp37_.x, (gfloat) _tmp38_.y);
				} else {
					GskPathBuilder* _tmp39_;
					Arrowxy _tmp40_;
					Arrowxy _tmp41_;
					_tmp39_ = path;
					_tmp40_ = a[i];
					_tmp41_ = a[i];
					gsk_path_builder_line_to (_tmp39_, (gfloat) _tmp40_.x, (gfloat) _tmp41_.y);
				}
			}
		}
	}
	_tmp43_ = self->priv->check_duplicate;
	_tmp43__target = self->priv->check_duplicate_target;
	if (_tmp43_ != NULL) {
		CheckDuplicate _tmp44_;
		gpointer _tmp44__target;
		ArroweDirection _tmp45_;
		_tmp44_ = self->priv->check_duplicate;
		_tmp44__target = self->priv->check_duplicate_target;
		_tmp45_ = self->priv->_direction;
		_tmp42_ = _tmp44_ ((guint) _tmp45_, _tmp44__target);
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		GdkRGBA _tmp46_ = {0};
		_tmp46_.red = 0.75f;
		_tmp46_.green = 0.f;
		_tmp46_.blue = 0.f;
		_tmp46_.alpha = 1.f;
		c = _tmp46_;
	} else {
		GdkRGBA _tmp47_ = {0};
		_tmp47_.red = 0.2890625f;
		_tmp47_.green = 0.5625f;
		_tmp47_.blue = 0.84765625f;
		_tmp47_.alpha = 1.f;
		c = _tmp47_;
	}
	_tmp48_ = path;
	_tmp49_ = gsk_path_builder_to_path (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = c;
	gtk_snapshot_append_fill (s, _tmp50_, GSK_FILL_RULE_EVEN_ODD, &_tmp51_);
	_gsk_path_unref0 (_tmp50_);
	_gsk_path_builder_unref0 (path);
}

void
arrow_SetCheckDuplicate (Arrow* self,
                         CheckDuplicate f,
                         gpointer f_target)
{
	g_return_if_fail (self != NULL);
	self->priv->check_duplicate = f;
	self->priv->check_duplicate_target = f_target;
}

Arrow*
arrow_construct (GType object_type)
{
	Arrow * self = NULL;
	self = (Arrow*) g_object_new (object_type, NULL);
	return self;
}

Arrow*
arrow_new (void)
{
	return arrow_construct (TYPE_ARROW);
}

ArroweDirection
arrow_get_direction (Arrow* self)
{
	ArroweDirection result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_direction;
	return result;
}

void
arrow_set_direction (Arrow* self,
                     ArroweDirection value)
{
	ArroweDirection old_value;
	g_return_if_fail (self != NULL);
	old_value = arrow_get_direction (self);
	if (old_value != value) {
		self->priv->_direction = value;
		g_object_notify_by_pspec ((GObject *) self, arrow_properties[ARROW_DIRECTION_PROPERTY]);
	}
}

static Arrowxy*
arrow_xy_dup (const Arrowxy* self)
{
	Arrowxy* dup;
	dup = g_new0 (Arrowxy, 1);
	memcpy (dup, self, sizeof (Arrowxy));
	return dup;
}

static void
arrow_xy_free (Arrowxy* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
arrow_xy_get_type_once (void)
{
	GType arrow_xy_type_id;
	arrow_xy_type_id = g_boxed_type_register_static ("Arrowxy", (GBoxedCopyFunc) arrow_xy_dup, (GBoxedFreeFunc) arrow_xy_free);
	return arrow_xy_type_id;
}

static GType
arrow_xy_get_type (void)
{
	static gsize arrow_xy_type_id__once = 0;
	if (g_once_init_enter (&arrow_xy_type_id__once)) {
		GType arrow_xy_type_id;
		arrow_xy_type_id = arrow_xy_get_type_once ();
		g_once_init_leave (&arrow_xy_type_id__once, arrow_xy_type_id);
	}
	return arrow_xy_type_id__once;
}

static void
arrow_class_init (ArrowClass * klass,
                  gpointer klass_data)
{
	arrow_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Arrow_private_offset);
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) arrow_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_arrow_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_arrow_set_property;
	G_OBJECT_CLASS (klass)->finalize = arrow_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ARROW_DIRECTION_PROPERTY, arrow_properties[ARROW_DIRECTION_PROPERTY] = g_param_spec_enum ("direction", "direction", "direction", ARROW_TYPE_EDIRECTION, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/arrow.ui");
}

static void
arrow_instance_init (Arrow * self,
                     gpointer klass)
{
	self->priv = arrow_get_instance_private (self);
	self->priv->check_duplicate = NULL;
	self->priv->check_duplicate_target = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
arrow_finalize (GObject * obj)
{
	Arrow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ARROW, Arrow);
	G_OBJECT_CLASS (arrow_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
arrow_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ArrowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) arrow_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Arrow), 0, (GInstanceInitFunc) arrow_instance_init, NULL };
	GType arrow_type_id;
	arrow_type_id = g_type_register_static (gtk_widget_get_type (), "Arrow", &g_define_type_info, 0);
	Arrow_private_offset = g_type_add_instance_private (arrow_type_id, sizeof (ArrowPrivate));
	return arrow_type_id;
}

GType
arrow_get_type (void)
{
	static gsize arrow_type_id__once = 0;
	if (g_once_init_enter (&arrow_type_id__once)) {
		GType arrow_type_id;
		arrow_type_id = arrow_get_type_once ();
		g_once_init_leave (&arrow_type_id__once, arrow_type_id);
	}
	return arrow_type_id__once;
}

static void
_vala_arrow_get_property (GObject * object,
                          guint property_id,
                          GValue * value,
                          GParamSpec * pspec)
{
	Arrow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ARROW, Arrow);
	switch (property_id) {
		case ARROW_DIRECTION_PROPERTY:
		g_value_set_enum (value, arrow_get_direction (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_arrow_set_property (GObject * object,
                          guint property_id,
                          const GValue * value,
                          GParamSpec * pspec)
{
	Arrow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ARROW, Arrow);
	switch (property_id) {
		case ARROW_DIRECTION_PROPERTY:
		arrow_set_direction (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
controls_grid_get_instance_private (ControlsGrid* self)
{
	return G_STRUCT_MEMBER_P (self, ControlsGrid_private_offset);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ControlsGrid* self;
		self = _data2_->self;
		_g_free0 (_data2_->player_id);
		_g_object_unref0 (_data2_->controls);
		_g_object_unref0 (_data2_->worm_props);
		_g_object_unref0 (_data2_->worms_props);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
__lambda15_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	PangoColor color = {0};
	gint _tmp0_;
	gint _tmp1_;
	GtkButton* _tmp2_;
	GtkWidget* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	self = _data2_->self;
	memset (&color, 0, sizeof (PangoColor));
	_tmp0_ = worm_properties_get_color (_data2_->worm_props);
	_tmp1_ = _tmp0_;
	get_worm_pango_color (_tmp1_, TRUE, &color);
	_tmp2_ = self->priv->name_label;
	_tmp3_ = gtk_button_get_child (_tmp2_);
	_tmp4_ = pango_color_to_string (&color);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = string_to_string (_data2_->player_id);
	_tmp8_ = g_strconcat ("<b><span font-family=\"Sans\" color=\"", _tmp6_, "\" size=\"x-large\">", _tmp7_, "</span></b>", NULL);
	_tmp9_ = _tmp8_;
	gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel), _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp5_);
}

static void
___lambda15__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda15_ (self);
}

static gboolean
__lambda16_ (ControlsGrid* self,
             guint i)
{
	gboolean _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->duplicate[i];
	result = _tmp0_;
	return result;
}

static gboolean
___lambda16__check_duplicate (guint i,
                              gpointer self)
{
	gboolean result;
	result = __lambda16_ ((ControlsGrid*) self, i);
	return result;
}

static gboolean
__lambda17_ (ControlsGrid* self,
             guint i)
{
	gboolean _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->duplicate[i];
	result = _tmp0_;
	return result;
}

static gboolean
___lambda17__check_duplicate (guint i,
                              gpointer self)
{
	gboolean result;
	result = __lambda17_ ((ControlsGrid*) self, i);
	return result;
}

static gboolean
__lambda18_ (ControlsGrid* self,
             guint i)
{
	gboolean _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->duplicate[i];
	result = _tmp0_;
	return result;
}

static gboolean
___lambda18__check_duplicate (guint i,
                              gpointer self)
{
	gboolean result;
	result = __lambda18_ ((ControlsGrid*) self, i);
	return result;
}

static gboolean
__lambda19_ (ControlsGrid* self,
             guint i)
{
	gboolean _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->duplicate[i];
	result = _tmp0_;
	return result;
}

static gboolean
___lambda19__check_duplicate (guint i,
                              gpointer self)
{
	gboolean result;
	result = __lambda19_ ((ControlsGrid*) self, i);
	return result;
}

static void
__lambda20_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	guint _tmp0_;
	guint _tmp1_;
	GtkButton* _tmp2_;
	GtkWidget* _tmp3_;
	self = _data2_->self;
	_tmp0_ = worm_properties_get_up (_data2_->worm_props);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->move_up_button;
	_tmp3_ = gtk_button_get_child (_tmp2_);
	controls_grid_configure_label (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel));
}

static void
___lambda20__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda20_ (self);
}

static void
__lambda21_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	guint _tmp0_;
	guint _tmp1_;
	GtkButton* _tmp2_;
	GtkWidget* _tmp3_;
	self = _data2_->self;
	_tmp0_ = worm_properties_get_down (_data2_->worm_props);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->move_down_button;
	_tmp3_ = gtk_button_get_child (_tmp2_);
	controls_grid_configure_label (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel));
}

static void
___lambda21__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda21_ (self);
}

static void
__lambda22_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	guint _tmp0_;
	guint _tmp1_;
	GtkButton* _tmp2_;
	GtkWidget* _tmp3_;
	self = _data2_->self;
	_tmp0_ = worm_properties_get_left (_data2_->worm_props);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->move_left_button;
	_tmp3_ = gtk_button_get_child (_tmp2_);
	controls_grid_configure_label (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel));
}

static void
___lambda22__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda22_ (self);
}

static void
__lambda23_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	guint _tmp0_;
	guint _tmp1_;
	GtkButton* _tmp2_;
	GtkWidget* _tmp3_;
	self = _data2_->self;
	_tmp0_ = worm_properties_get_right (_data2_->worm_props);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->move_right_button;
	_tmp3_ = gtk_button_get_child (_tmp2_);
	controls_grid_configure_label (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel));
}

static void
___lambda23__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda23_ (self);
}

static void
____lambda25_ (Block2Data* _data2_,
               gint c)
{
	ControlsGrid* self;
	GtkOverlay* _tmp0_;
	ColourWheel* _tmp1_;
	self = _data2_->self;
	if (c != -1) {
		controls_grid_swap_color (self, _data2_->worms_props, c);
	}
	_tmp0_ = self->priv->overlay;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->wheel;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
}

static void
_____lambda25__colour_wheel_result_function (gint r,
                                             gpointer self)
{
	____lambda25_ (self, r);
}

static void
__lambda24_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	OverlayMessage* _tmp0_;
	self = _data2_->self;
	_tmp0_ = self->priv->key_press_message;
	if (NULL == _tmp0_) {
		GtkOverlay* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->overlay;
		_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			GtkOverlay* _tmp4_;
			ColourWheel* _tmp5_;
			ColourWheel* _tmp6_;
			WormProperties* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			_tmp4_ = self->priv->overlay;
			gtk_widget_set_visible ((GtkWidget*) _tmp4_, FALSE);
			_tmp5_ = self->priv->wheel;
			gtk_widget_set_visible ((GtkWidget*) _tmp5_, TRUE);
			_tmp6_ = self->priv->wheel;
			_tmp7_ = self->worm_props;
			_tmp8_ = worm_properties_get_color (_tmp7_);
			_tmp9_ = _tmp8_;
			colour_wheel_do_select_segment (_tmp6_, _tmp9_, _____lambda25__colour_wheel_result_function, _data2_);
		} else {
			GtkOverlay* _tmp10_;
			ColourWheel* _tmp11_;
			_tmp10_ = self->priv->overlay;
			gtk_widget_set_visible ((GtkWidget*) _tmp10_, TRUE);
			_tmp11_ = self->priv->wheel;
			gtk_widget_set_visible ((GtkWidget*) _tmp11_, FALSE);
		}
	}
}

static void
___lambda24__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda24_ (self);
}

static gboolean
___lambda27_ (ControlsGrid* self,
              guint keyval,
              guint keycode,
              gboolean* remove_handler)
{
	gboolean _vala_remove_handler = FALSE;
	WormProperties* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	WormProperties* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkOverlay* _tmp8_;
	OverlayMessage* _tmp9_;
	gboolean result;
	_vala_remove_handler = TRUE;
	_tmp0_ = self->worm_props;
	_tmp1_ = worm_properties_get_up (_tmp0_);
	_tmp2_ = _tmp1_;
	if (keyval != _tmp2_) {
		WormProperties* _tmp3_;
		_tmp3_ = self->worm_props;
		worm_properties_set_up (_tmp3_, keyval);
	}
	_tmp4_ = self->worm_props;
	_tmp5_ = worm_properties_get_raw_up (_tmp4_);
	_tmp6_ = _tmp5_;
	if (keycode != ((guint) _tmp6_)) {
		WormProperties* _tmp7_;
		_tmp7_ = self->worm_props;
		worm_properties_set_raw_up (_tmp7_, (gint) keycode);
	}
	_tmp8_ = self->priv->overlay;
	_tmp9_ = self->priv->key_press_message;
	gtk_overlay_remove_overlay (_tmp8_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (self->priv->key_press_message);
	self->priv->key_press_message = NULL;
	result = TRUE;
	if (remove_handler) {
		*remove_handler = _vala_remove_handler;
	}
	return result;
}

static gboolean
____lambda27__keypress_handler_function (guint a,
                                         guint b,
                                         gboolean* remove_handler,
                                         gpointer self)
{
	gboolean result;
	result = ___lambda27_ ((ControlsGrid*) self, a, b, remove_handler);
	return result;
}

static void
__lambda26_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	gboolean _tmp0_ = FALSE;
	ColourWheel* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data2_->self;
	_tmp1_ = self->priv->wheel;
	_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		OverlayMessage* _tmp4_;
		_tmp4_ = self->priv->key_press_message;
		_tmp0_ = NULL == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkGrid* _tmp5_;
		OverlayMessage* _tmp6_;
		GtkOverlay* _tmp7_;
		OverlayMessage* _tmp8_;
		_tmp5_ = self->priv->grid;
		_tmp6_ = overlay_message_new (_ ("Press a key for up."), gtk_widget_get_width ((GtkWidget*) _tmp5_));
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->key_press_message);
		self->priv->key_press_message = _tmp6_;
		_tmp7_ = self->priv->overlay;
		_tmp8_ = self->priv->key_press_message;
		gtk_overlay_add_overlay (_tmp7_, (GtkWidget*) _tmp8_);
		g_signal_emit (_data2_->controls, controls_signals[CONTROLS_ADD_KEYPRESS_HANDLER_SIGNAL], 0, ____lambda27__keypress_handler_function, self);
	}
}

static void
___lambda26__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda26_ (self);
}

static gboolean
___lambda29_ (ControlsGrid* self,
              guint keyval,
              guint keycode,
              gboolean* remove_handler)
{
	gboolean _vala_remove_handler = FALSE;
	WormProperties* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	WormProperties* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkOverlay* _tmp8_;
	OverlayMessage* _tmp9_;
	gboolean result;
	_vala_remove_handler = TRUE;
	_tmp0_ = self->worm_props;
	_tmp1_ = worm_properties_get_down (_tmp0_);
	_tmp2_ = _tmp1_;
	if (keyval != _tmp2_) {
		WormProperties* _tmp3_;
		_tmp3_ = self->worm_props;
		worm_properties_set_down (_tmp3_, keyval);
	}
	_tmp4_ = self->worm_props;
	_tmp5_ = worm_properties_get_raw_down (_tmp4_);
	_tmp6_ = _tmp5_;
	if (keycode != ((guint) _tmp6_)) {
		WormProperties* _tmp7_;
		_tmp7_ = self->worm_props;
		worm_properties_set_raw_down (_tmp7_, (gint) keycode);
	}
	_tmp8_ = self->priv->overlay;
	_tmp9_ = self->priv->key_press_message;
	gtk_overlay_remove_overlay (_tmp8_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (self->priv->key_press_message);
	self->priv->key_press_message = NULL;
	result = TRUE;
	if (remove_handler) {
		*remove_handler = _vala_remove_handler;
	}
	return result;
}

static gboolean
____lambda29__keypress_handler_function (guint a,
                                         guint b,
                                         gboolean* remove_handler,
                                         gpointer self)
{
	gboolean result;
	result = ___lambda29_ ((ControlsGrid*) self, a, b, remove_handler);
	return result;
}

static void
__lambda28_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	gboolean _tmp0_ = FALSE;
	ColourWheel* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data2_->self;
	_tmp1_ = self->priv->wheel;
	_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		OverlayMessage* _tmp4_;
		_tmp4_ = self->priv->key_press_message;
		_tmp0_ = NULL == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkGrid* _tmp5_;
		OverlayMessage* _tmp6_;
		GtkOverlay* _tmp7_;
		OverlayMessage* _tmp8_;
		_tmp5_ = self->priv->grid;
		_tmp6_ = overlay_message_new (_ ("Press a key for down."), gtk_widget_get_width ((GtkWidget*) _tmp5_));
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->key_press_message);
		self->priv->key_press_message = _tmp6_;
		_tmp7_ = self->priv->overlay;
		_tmp8_ = self->priv->key_press_message;
		gtk_overlay_add_overlay (_tmp7_, (GtkWidget*) _tmp8_);
		g_signal_emit (_data2_->controls, controls_signals[CONTROLS_ADD_KEYPRESS_HANDLER_SIGNAL], 0, ____lambda29__keypress_handler_function, self);
	}
}

static void
___lambda28__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda28_ (self);
}

static gboolean
___lambda31_ (ControlsGrid* self,
              guint keyval,
              guint keycode,
              gboolean* remove_handler)
{
	gboolean _vala_remove_handler = FALSE;
	WormProperties* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	WormProperties* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkOverlay* _tmp8_;
	OverlayMessage* _tmp9_;
	gboolean result;
	_vala_remove_handler = TRUE;
	_tmp0_ = self->worm_props;
	_tmp1_ = worm_properties_get_left (_tmp0_);
	_tmp2_ = _tmp1_;
	if (keyval != _tmp2_) {
		WormProperties* _tmp3_;
		_tmp3_ = self->worm_props;
		worm_properties_set_left (_tmp3_, keyval);
	}
	_tmp4_ = self->worm_props;
	_tmp5_ = worm_properties_get_raw_left (_tmp4_);
	_tmp6_ = _tmp5_;
	if (keycode != ((guint) _tmp6_)) {
		WormProperties* _tmp7_;
		_tmp7_ = self->worm_props;
		worm_properties_set_raw_left (_tmp7_, (gint) keycode);
	}
	_tmp8_ = self->priv->overlay;
	_tmp9_ = self->priv->key_press_message;
	gtk_overlay_remove_overlay (_tmp8_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (self->priv->key_press_message);
	self->priv->key_press_message = NULL;
	result = TRUE;
	if (remove_handler) {
		*remove_handler = _vala_remove_handler;
	}
	return result;
}

static gboolean
____lambda31__keypress_handler_function (guint a,
                                         guint b,
                                         gboolean* remove_handler,
                                         gpointer self)
{
	gboolean result;
	result = ___lambda31_ ((ControlsGrid*) self, a, b, remove_handler);
	return result;
}

static void
__lambda30_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	gboolean _tmp0_ = FALSE;
	ColourWheel* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data2_->self;
	_tmp1_ = self->priv->wheel;
	_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		OverlayMessage* _tmp4_;
		_tmp4_ = self->priv->key_press_message;
		_tmp0_ = NULL == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkGrid* _tmp5_;
		OverlayMessage* _tmp6_;
		GtkOverlay* _tmp7_;
		OverlayMessage* _tmp8_;
		_tmp5_ = self->priv->grid;
		_tmp6_ = overlay_message_new (_ ("Press a key for left."), gtk_widget_get_width ((GtkWidget*) _tmp5_));
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->key_press_message);
		self->priv->key_press_message = _tmp6_;
		_tmp7_ = self->priv->overlay;
		_tmp8_ = self->priv->key_press_message;
		gtk_overlay_add_overlay (_tmp7_, (GtkWidget*) _tmp8_);
		g_signal_emit (_data2_->controls, controls_signals[CONTROLS_ADD_KEYPRESS_HANDLER_SIGNAL], 0, ____lambda31__keypress_handler_function, self);
	}
}

static void
___lambda30__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda30_ (self);
}

static gboolean
___lambda33_ (ControlsGrid* self,
              guint keyval,
              guint keycode,
              gboolean* remove_handler)
{
	gboolean _vala_remove_handler = FALSE;
	WormProperties* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	WormProperties* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkOverlay* _tmp8_;
	OverlayMessage* _tmp9_;
	gboolean result;
	_vala_remove_handler = TRUE;
	_tmp0_ = self->worm_props;
	_tmp1_ = worm_properties_get_right (_tmp0_);
	_tmp2_ = _tmp1_;
	if (keyval != _tmp2_) {
		WormProperties* _tmp3_;
		_tmp3_ = self->worm_props;
		worm_properties_set_right (_tmp3_, keyval);
	}
	_tmp4_ = self->worm_props;
	_tmp5_ = worm_properties_get_raw_right (_tmp4_);
	_tmp6_ = _tmp5_;
	if (keycode != ((guint) _tmp6_)) {
		WormProperties* _tmp7_;
		_tmp7_ = self->worm_props;
		worm_properties_set_raw_right (_tmp7_, (gint) keycode);
	}
	_tmp8_ = self->priv->overlay;
	_tmp9_ = self->priv->key_press_message;
	gtk_overlay_remove_overlay (_tmp8_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (self->priv->key_press_message);
	self->priv->key_press_message = NULL;
	result = TRUE;
	if (remove_handler) {
		*remove_handler = _vala_remove_handler;
	}
	return result;
}

static gboolean
____lambda33__keypress_handler_function (guint a,
                                         guint b,
                                         gboolean* remove_handler,
                                         gpointer self)
{
	gboolean result;
	result = ___lambda33_ ((ControlsGrid*) self, a, b, remove_handler);
	return result;
}

static void
__lambda32_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	gboolean _tmp0_ = FALSE;
	ColourWheel* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data2_->self;
	_tmp1_ = self->priv->wheel;
	_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		OverlayMessage* _tmp4_;
		_tmp4_ = self->priv->key_press_message;
		_tmp0_ = NULL == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkGrid* _tmp5_;
		OverlayMessage* _tmp6_;
		GtkOverlay* _tmp7_;
		OverlayMessage* _tmp8_;
		_tmp5_ = self->priv->grid;
		_tmp6_ = overlay_message_new (_ ("Press a key for right."), gtk_widget_get_width ((GtkWidget*) _tmp5_));
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->key_press_message);
		self->priv->key_press_message = _tmp6_;
		_tmp7_ = self->priv->overlay;
		_tmp8_ = self->priv->key_press_message;
		gtk_overlay_add_overlay (_tmp7_, (GtkWidget*) _tmp8_);
		g_signal_emit (_data2_->controls, controls_signals[CONTROLS_ADD_KEYPRESS_HANDLER_SIGNAL], 0, ____lambda33__keypress_handler_function, self);
	}
}

static void
___lambda32__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda32_ (self);
}

ControlsGrid*
controls_grid_construct (GType object_type,
                         Controls* controls,
                         gint worm_id,
                         WormProperties* worm_props,
                         GeeHashMap* worms_props)
{
	ControlsGrid * self = NULL;
	Block2Data* _data2_;
	Controls* _tmp0_;
	WormProperties* _tmp1_;
	GeeHashMap* _tmp2_;
	Controls* _tmp3_;
	WormProperties* _tmp4_;
	gchar* _tmp5_;
	gulong _tmp6_;
	PangoColor color = {0};
	gint _tmp7_;
	gint _tmp8_;
	GtkButton* _tmp9_;
	GtkWidget* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	Arrow* _tmp17_;
	Arrow* _tmp18_;
	Arrow* _tmp19_;
	Arrow* _tmp20_;
	gulong _tmp21_;
	gulong _tmp22_;
	gulong _tmp23_;
	gulong _tmp24_;
	guint _tmp25_;
	guint _tmp26_;
	GtkButton* _tmp27_;
	GtkWidget* _tmp28_;
	guint _tmp29_;
	guint _tmp30_;
	GtkButton* _tmp31_;
	GtkWidget* _tmp32_;
	guint _tmp33_;
	guint _tmp34_;
	GtkButton* _tmp35_;
	GtkWidget* _tmp36_;
	guint _tmp37_;
	guint _tmp38_;
	GtkButton* _tmp39_;
	GtkWidget* _tmp40_;
	GtkButton* _tmp41_;
	GtkButton* _tmp42_;
	GtkButton* _tmp43_;
	GtkButton* _tmp44_;
	GtkButton* _tmp45_;
	g_return_val_if_fail (controls != NULL, NULL);
	g_return_val_if_fail (worm_props != NULL, NULL);
	g_return_val_if_fail (worms_props != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (controls);
	_g_object_unref0 (_data2_->controls);
	_data2_->controls = _tmp0_;
	_tmp1_ = _g_object_ref0 (worm_props);
	_g_object_unref0 (_data2_->worm_props);
	_data2_->worm_props = _tmp1_;
	_tmp2_ = _g_object_ref0 (worms_props);
	_g_object_unref0 (_data2_->worms_props);
	_data2_->worms_props = _tmp2_;
	self = (ControlsGrid*) g_object_new (object_type, NULL);
	_data2_->self = g_object_ref (self);
	_tmp3_ = _g_object_ref0 (_data2_->controls);
	_g_object_unref0 (self->controls);
	self->controls = _tmp3_;
	_tmp4_ = _g_object_ref0 (_data2_->worm_props);
	_g_object_unref0 (self->worm_props);
	self->worm_props = _tmp4_;
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 10);
	_tmp5_ = g_strdup_printf (_ ("Player %d"), worm_id + 1);
	_data2_->player_id = _tmp5_;
	_tmp6_ = g_signal_connect_data ((GObject*) _data2_->worm_props, "notify::color", (GCallback) ___lambda15__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	self->priv->color_handler = _tmp6_;
	memset (&color, 0, sizeof (PangoColor));
	_tmp7_ = worm_properties_get_color (_data2_->worm_props);
	_tmp8_ = _tmp7_;
	get_worm_pango_color (_tmp8_, TRUE, &color);
	_tmp9_ = self->priv->name_label;
	_tmp10_ = gtk_button_get_child (_tmp9_);
	_tmp11_ = pango_color_to_string (&color);
	_tmp12_ = _tmp11_;
	_tmp13_ = string_to_string (_tmp12_);
	_tmp14_ = string_to_string (_data2_->player_id);
	_tmp15_ = g_strconcat ("<b><span font-family=\"Sans\" color=\"", _tmp13_, "\" size=\"x-large\">", _tmp14_, "</span></b>", NULL);
	_tmp16_ = _tmp15_;
	gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_label_get_type (), GtkLabel), _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp12_);
	_tmp17_ = self->priv->arrow_up;
	arrow_SetCheckDuplicate (_tmp17_, ___lambda16__check_duplicate, self);
	_tmp18_ = self->priv->arrow_down;
	arrow_SetCheckDuplicate (_tmp18_, ___lambda17__check_duplicate, self);
	_tmp19_ = self->priv->arrow_left;
	arrow_SetCheckDuplicate (_tmp19_, ___lambda18__check_duplicate, self);
	_tmp20_ = self->priv->arrow_right;
	arrow_SetCheckDuplicate (_tmp20_, ___lambda19__check_duplicate, self);
	_tmp21_ = g_signal_connect_data ((GObject*) _data2_->worm_props, "notify::up", (GCallback) ___lambda20__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	self->priv->up_handler = _tmp21_;
	_tmp22_ = g_signal_connect_data ((GObject*) _data2_->worm_props, "notify::down", (GCallback) ___lambda21__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	self->priv->down_handler = _tmp22_;
	_tmp23_ = g_signal_connect_data ((GObject*) _data2_->worm_props, "notify::left", (GCallback) ___lambda22__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	self->priv->left_handler = _tmp23_;
	_tmp24_ = g_signal_connect_data ((GObject*) _data2_->worm_props, "notify::right", (GCallback) ___lambda23__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	self->priv->right_handler = _tmp24_;
	_tmp25_ = worm_properties_get_up (_data2_->worm_props);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->move_up_button;
	_tmp28_ = gtk_button_get_child (_tmp27_);
	controls_grid_configure_label (_tmp26_, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_label_get_type (), GtkLabel));
	_tmp29_ = worm_properties_get_down (_data2_->worm_props);
	_tmp30_ = _tmp29_;
	_tmp31_ = self->priv->move_down_button;
	_tmp32_ = gtk_button_get_child (_tmp31_);
	controls_grid_configure_label (_tmp30_, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_label_get_type (), GtkLabel));
	_tmp33_ = worm_properties_get_left (_data2_->worm_props);
	_tmp34_ = _tmp33_;
	_tmp35_ = self->priv->move_left_button;
	_tmp36_ = gtk_button_get_child (_tmp35_);
	controls_grid_configure_label (_tmp34_, G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_label_get_type (), GtkLabel));
	_tmp37_ = worm_properties_get_right (_data2_->worm_props);
	_tmp38_ = _tmp37_;
	_tmp39_ = self->priv->move_right_button;
	_tmp40_ = gtk_button_get_child (_tmp39_);
	controls_grid_configure_label (_tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_label_get_type (), GtkLabel));
	_tmp41_ = self->priv->name_label;
	g_signal_connect_data (_tmp41_, "clicked", (GCallback) ___lambda24__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp42_ = self->priv->move_up_button;
	g_signal_connect_data (_tmp42_, "clicked", (GCallback) ___lambda26__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp43_ = self->priv->move_down_button;
	g_signal_connect_data (_tmp43_, "clicked", (GCallback) ___lambda28__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp44_ = self->priv->move_left_button;
	g_signal_connect_data (_tmp44_, "clicked", (GCallback) ___lambda30__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp45_ = self->priv->move_right_button;
	g_signal_connect_data (_tmp45_, "clicked", (GCallback) ___lambda32__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}

ControlsGrid*
controls_grid_new (Controls* controls,
                   gint worm_id,
                   WormProperties* worm_props,
                   GeeHashMap* worms_props)
{
	return controls_grid_construct (TYPE_CONTROLS_GRID, controls, worm_id, worm_props, worms_props);
}

static void
controls_grid_swap_color (ControlsGrid* self,
                          GeeHashMap* worms_props,
                          gint c)
{
	WormProperties* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worms_props != NULL);
	_tmp0_ = self->worm_props;
	_tmp1_ = worm_properties_get_color (_tmp0_);
	_tmp2_ = _tmp1_;
	if (c != _tmp2_) {
		WormProperties* _tmp19_;
		{
			GeeMapIterator* i = NULL;
			GeeMapIterator* _tmp3_;
			_tmp3_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) worms_props);
			i = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					GeeMapIterator* _tmp5_;
					GeeMapIterator* _tmp6_;
					gpointer _tmp7_;
					WormProperties* _tmp8_;
					gint _tmp9_;
					gint _tmp10_;
					gboolean _tmp11_;
					if (!_tmp4_) {
					}
					_tmp4_ = FALSE;
					_tmp5_ = i;
					if (!gee_map_iterator_next (_tmp5_)) {
						break;
					}
					_tmp6_ = i;
					_tmp7_ = gee_map_iterator_get_value (_tmp6_);
					_tmp8_ = (WormProperties*) _tmp7_;
					_tmp9_ = worm_properties_get_color (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = _tmp10_ == c;
					_g_object_unref0 (_tmp8_);
					if (_tmp11_) {
						GeeMapIterator* _tmp12_;
						gpointer _tmp13_;
						WormProperties* _tmp14_;
						WormProperties* _tmp15_;
						gint _tmp16_;
						gint _tmp17_;
						WormProperties* _tmp18_;
						_tmp12_ = i;
						_tmp13_ = gee_map_iterator_get_value (_tmp12_);
						_tmp14_ = (WormProperties*) _tmp13_;
						_tmp15_ = self->worm_props;
						_tmp16_ = worm_properties_get_color (_tmp15_);
						_tmp17_ = _tmp16_;
						worm_properties_set_color (_tmp14_, _tmp17_);
						_g_object_unref0 (_tmp14_);
						_tmp18_ = self->worm_props;
						worm_properties_set_color (_tmp18_, c);
						_g_object_unref0 (i);
						return;
					}
				}
			}
			_g_object_unref0 (i);
		}
		_tmp19_ = self->worm_props;
		worm_properties_set_color (_tmp19_, (gint) c);
	}
}

void
controls_grid_mark_duplicated_keys (ControlsGrid* self,
                                    GHashTable* duplicate_keys)
{
	gboolean d = FALSE;
	WormProperties* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean _tmp3_;
	WormProperties* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	gboolean _tmp8_;
	WormProperties* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	gboolean _tmp13_;
	WormProperties* _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	gboolean _tmp18_;
	WormProperties* _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	GtkButton* _tmp23_;
	GtkWidget* _tmp24_;
	WormProperties* _tmp25_;
	guint _tmp26_;
	guint _tmp27_;
	GtkButton* _tmp28_;
	GtkWidget* _tmp29_;
	WormProperties* _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	GtkButton* _tmp33_;
	GtkWidget* _tmp34_;
	WormProperties* _tmp35_;
	guint _tmp36_;
	guint _tmp37_;
	GtkButton* _tmp38_;
	GtkWidget* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (duplicate_keys != NULL);
	_tmp0_ = self->worm_props;
	_tmp1_ = worm_properties_get_up (_tmp0_);
	_tmp2_ = _tmp1_;
	d = g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp2_));
	_tmp3_ = self->priv->duplicate[0];
	if (d != _tmp3_) {
		Arrow* _tmp4_;
		self->priv->duplicate[0] = d;
		_tmp4_ = self->priv->arrow_up;
		gtk_widget_queue_draw ((GtkWidget*) _tmp4_);
	}
	_tmp5_ = self->worm_props;
	_tmp6_ = worm_properties_get_down (_tmp5_);
	_tmp7_ = _tmp6_;
	d = g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp7_));
	_tmp8_ = self->priv->duplicate[1];
	if (d != _tmp8_) {
		Arrow* _tmp9_;
		self->priv->duplicate[1] = d;
		_tmp9_ = self->priv->arrow_down;
		gtk_widget_queue_draw ((GtkWidget*) _tmp9_);
	}
	_tmp10_ = self->worm_props;
	_tmp11_ = worm_properties_get_left (_tmp10_);
	_tmp12_ = _tmp11_;
	d = g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp12_));
	_tmp13_ = self->priv->duplicate[2];
	if (d != _tmp13_) {
		Arrow* _tmp14_;
		self->priv->duplicate[2] = d;
		_tmp14_ = self->priv->arrow_left;
		gtk_widget_queue_draw ((GtkWidget*) _tmp14_);
	}
	_tmp15_ = self->worm_props;
	_tmp16_ = worm_properties_get_right (_tmp15_);
	_tmp17_ = _tmp16_;
	d = g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp17_));
	_tmp18_ = self->priv->duplicate[3];
	if (d != _tmp18_) {
		Arrow* _tmp19_;
		self->priv->duplicate[3] = d;
		_tmp19_ = self->priv->arrow_right;
		gtk_widget_queue_draw ((GtkWidget*) _tmp19_);
	}
	_tmp20_ = self->worm_props;
	_tmp21_ = worm_properties_get_up (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = self->priv->move_up_button;
	_tmp24_ = gtk_button_get_child (_tmp23_);
	controls_grid_set_duplicate_class (self, g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp22_)), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_label_get_type (), GtkLabel));
	_tmp25_ = self->worm_props;
	_tmp26_ = worm_properties_get_down (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = self->priv->move_down_button;
	_tmp29_ = gtk_button_get_child (_tmp28_);
	controls_grid_set_duplicate_class (self, g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp27_)), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_label_get_type (), GtkLabel));
	_tmp30_ = self->worm_props;
	_tmp31_ = worm_properties_get_left (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = self->priv->move_left_button;
	_tmp34_ = gtk_button_get_child (_tmp33_);
	controls_grid_set_duplicate_class (self, g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp32_)), G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_label_get_type (), GtkLabel));
	_tmp35_ = self->worm_props;
	_tmp36_ = worm_properties_get_right (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = self->priv->move_right_button;
	_tmp39_ = gtk_button_get_child (_tmp38_);
	controls_grid_set_duplicate_class (self, g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp37_)), G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_label_get_type (), GtkLabel));
}

static void
controls_grid_set_duplicate_class (ControlsGrid* self,
                                   gboolean duplicate,
                                   GtkLabel* label)
{
	PangoAttrList* _tmp0_;
	PangoAttrList* _tmp1_;
	PangoAttrList* _tmp2_;
	PangoAttrList* _tmp3_;
	PangoAttribute* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = pango_attr_list_new ();
	_tmp1_ = _tmp0_;
	gtk_label_set_attributes (label, _tmp1_);
	_pango_attr_list_unref0 (_tmp1_);
	_tmp2_ = gtk_label_get_attributes (label);
	_tmp3_ = _tmp2_;
	_tmp4_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	pango_attr_list_insert (_tmp3_, _tmp4_);
	if (duplicate) {
		PangoAttrList* _tmp5_;
		PangoAttrList* _tmp6_;
		PangoAttribute* _tmp7_;
		_tmp5_ = gtk_label_get_attributes (label);
		_tmp6_ = _tmp5_;
		_tmp7_ = pango_attr_foreground_new ((guint16) 0xffff, (guint16) 0, (guint16) 0);
		pango_attr_list_insert (_tmp6_, _tmp7_);
	} else {
		PangoAttrList* _tmp8_;
		PangoAttrList* _tmp9_;
		PangoAttribute* _tmp10_;
		_tmp8_ = gtk_label_get_attributes (label);
		_tmp9_ = _tmp8_;
		_tmp10_ = pango_attr_foreground_new ((guint16) 0xffff, (guint16) 0xffff, (guint16) 0xffff);
		pango_attr_list_insert (_tmp9_, _tmp10_);
	}
}

void
controls_grid_disconnect_stuff (ControlsGrid* self)
{
	WormProperties* _tmp0_;
	WormProperties* _tmp1_;
	WormProperties* _tmp2_;
	WormProperties* _tmp3_;
	WormProperties* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->worm_props;
	g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->up_handler);
	_tmp1_ = self->worm_props;
	g_signal_handler_disconnect ((GObject*) _tmp1_, self->priv->down_handler);
	_tmp2_ = self->worm_props;
	g_signal_handler_disconnect ((GObject*) _tmp2_, self->priv->left_handler);
	_tmp3_ = self->worm_props;
	g_signal_handler_disconnect ((GObject*) _tmp3_, self->priv->right_handler);
	_tmp4_ = self->worm_props;
	g_signal_handler_disconnect ((GObject*) _tmp4_, self->priv->color_handler);
}

static void
controls_grid_configure_label (guint key_value,
                               GtkLabel* label)
{
	gchar* key_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (label != NULL);
	_tmp0_ = gdk_keyval_name (key_value);
	_tmp1_ = g_strdup (_tmp0_);
	key_name = _tmp1_;
	_tmp2_ = key_name;
	if (g_strcmp0 (_tmp2_, "Up") == 0) {
		PangoAttrList* _tmp3_;
		PangoAttrList* _tmp4_;
		PangoAttrList* _tmp7_;
		PangoAttrList* _tmp8_;
		PangoAttribute* _tmp9_;
		PangoAttrList* _tmp10_;
		PangoAttrList* _tmp11_;
		PangoAttribute* _tmp12_;
		_tmp3_ = gtk_label_get_attributes (label);
		_tmp4_ = _tmp3_;
		if (_tmp4_ == NULL) {
			PangoAttrList* _tmp5_;
			PangoAttrList* _tmp6_;
			_tmp5_ = pango_attr_list_new ();
			_tmp6_ = _tmp5_;
			gtk_label_set_attributes (label, _tmp6_);
			_pango_attr_list_unref0 (_tmp6_);
		}
		_tmp7_ = gtk_label_get_attributes (label);
		_tmp8_ = _tmp7_;
		_tmp9_ = pango_attr_scale_new (PANGO_SCALE_X_LARGE);
		pango_attr_list_insert (_tmp8_, _tmp9_);
		_tmp10_ = gtk_label_get_attributes (label);
		_tmp11_ = _tmp10_;
		_tmp12_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
		pango_attr_list_insert (_tmp11_, _tmp12_);
		gtk_label_set_text (label, "↑");
	} else {
		const gchar* _tmp13_;
		_tmp13_ = key_name;
		if (g_strcmp0 (_tmp13_, "Down") == 0) {
			PangoAttrList* _tmp14_;
			PangoAttrList* _tmp15_;
			PangoAttrList* _tmp18_;
			PangoAttrList* _tmp19_;
			PangoAttribute* _tmp20_;
			PangoAttrList* _tmp21_;
			PangoAttrList* _tmp22_;
			PangoAttribute* _tmp23_;
			_tmp14_ = gtk_label_get_attributes (label);
			_tmp15_ = _tmp14_;
			if (_tmp15_ == NULL) {
				PangoAttrList* _tmp16_;
				PangoAttrList* _tmp17_;
				_tmp16_ = pango_attr_list_new ();
				_tmp17_ = _tmp16_;
				gtk_label_set_attributes (label, _tmp17_);
				_pango_attr_list_unref0 (_tmp17_);
			}
			_tmp18_ = gtk_label_get_attributes (label);
			_tmp19_ = _tmp18_;
			_tmp20_ = pango_attr_scale_new (PANGO_SCALE_X_LARGE);
			pango_attr_list_insert (_tmp19_, _tmp20_);
			_tmp21_ = gtk_label_get_attributes (label);
			_tmp22_ = _tmp21_;
			_tmp23_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
			pango_attr_list_insert (_tmp22_, _tmp23_);
			gtk_label_set_text (label, "↓");
		} else {
			const gchar* _tmp24_;
			_tmp24_ = key_name;
			if (g_strcmp0 (_tmp24_, "Left") == 0) {
				PangoAttrList* _tmp25_;
				PangoAttrList* _tmp26_;
				PangoAttrList* _tmp29_;
				PangoAttrList* _tmp30_;
				PangoAttribute* _tmp31_;
				PangoAttrList* _tmp32_;
				PangoAttrList* _tmp33_;
				PangoAttribute* _tmp34_;
				_tmp25_ = gtk_label_get_attributes (label);
				_tmp26_ = _tmp25_;
				if (_tmp26_ == NULL) {
					PangoAttrList* _tmp27_;
					PangoAttrList* _tmp28_;
					_tmp27_ = pango_attr_list_new ();
					_tmp28_ = _tmp27_;
					gtk_label_set_attributes (label, _tmp28_);
					_pango_attr_list_unref0 (_tmp28_);
				}
				_tmp29_ = gtk_label_get_attributes (label);
				_tmp30_ = _tmp29_;
				_tmp31_ = pango_attr_scale_new (PANGO_SCALE_X_LARGE);
				pango_attr_list_insert (_tmp30_, _tmp31_);
				_tmp32_ = gtk_label_get_attributes (label);
				_tmp33_ = _tmp32_;
				_tmp34_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
				pango_attr_list_insert (_tmp33_, _tmp34_);
				gtk_label_set_text (label, "←");
			} else {
				const gchar* _tmp35_;
				_tmp35_ = key_name;
				if (g_strcmp0 (_tmp35_, "Right") == 0) {
					PangoAttrList* _tmp36_;
					PangoAttrList* _tmp37_;
					PangoAttrList* _tmp40_;
					PangoAttrList* _tmp41_;
					PangoAttribute* _tmp42_;
					PangoAttrList* _tmp43_;
					PangoAttrList* _tmp44_;
					PangoAttribute* _tmp45_;
					_tmp36_ = gtk_label_get_attributes (label);
					_tmp37_ = _tmp36_;
					if (_tmp37_ == NULL) {
						PangoAttrList* _tmp38_;
						PangoAttrList* _tmp39_;
						_tmp38_ = pango_attr_list_new ();
						_tmp39_ = _tmp38_;
						gtk_label_set_attributes (label, _tmp39_);
						_pango_attr_list_unref0 (_tmp39_);
					}
					_tmp40_ = gtk_label_get_attributes (label);
					_tmp41_ = _tmp40_;
					_tmp42_ = pango_attr_scale_new (PANGO_SCALE_X_LARGE);
					pango_attr_list_insert (_tmp41_, _tmp42_);
					_tmp43_ = gtk_label_get_attributes (label);
					_tmp44_ = _tmp43_;
					_tmp45_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
					pango_attr_list_insert (_tmp44_, _tmp45_);
					gtk_label_set_text (label, "→");
				} else {
					gboolean _tmp46_ = FALSE;
					const gchar* _tmp47_;
					_tmp47_ = key_name;
					if (_tmp47_ == NULL) {
						_tmp46_ = TRUE;
					} else {
						const gchar* _tmp48_;
						_tmp48_ = key_name;
						_tmp46_ = g_strcmp0 (_tmp48_, "") == 0;
					}
					if (_tmp46_) {
						gtk_label_set_attributes (label, NULL);
						gtk_label_set_text (label, "");
					} else {
						gchar* _tmp49_;
						gchar* _tmp50_;
						const gchar* _tmp51_;
						gtk_label_set_attributes (label, NULL);
						_tmp49_ = gtk_accelerator_get_label (key_value, 0);
						_tmp50_ = _tmp49_;
						_tmp51_ = string_to_string (_tmp50_);
						gtk_label_set_text (label, _tmp51_);
						_g_free0 (_tmp50_);
					}
				}
			}
		}
	}
	_g_free0 (key_name);
}

static void
controls_grid_class_init (ControlsGridClass * klass,
                          gpointer klass_data)
{
	controls_grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ControlsGrid_private_offset);
	G_OBJECT_CLASS (klass)->finalize = controls_grid_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/controls-grid.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_up", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_up));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_down", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_down));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_left", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_left));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_right", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_right));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_up_button", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_up_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_down_button", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_down_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_left_button", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_left_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_right_button", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_right_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "wheel", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, wheel));
}

static void
controls_grid_instance_init (ControlsGrid * self,
                             gpointer klass)
{
	self->priv = controls_grid_get_instance_private (self);
	g_type_ensure (TYPE_ARROW);
	g_type_ensure (TYPE_ARROW);
	g_type_ensure (TYPE_ARROW);
	g_type_ensure (TYPE_ARROW);
	g_type_ensure (TYPE_COLOUR_WHEEL);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
controls_grid_finalize (GObject * obj)
{
	ControlsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTROLS_GRID, ControlsGrid);
	_g_object_unref0 (self->controls);
	_g_object_unref0 (self->worm_props);
	_g_object_unref0 (self->priv->key_press_message);
	G_OBJECT_CLASS (controls_grid_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
controls_grid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ControlsGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) controls_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ControlsGrid), 0, (GInstanceInitFunc) controls_grid_instance_init, NULL };
	GType controls_grid_type_id;
	controls_grid_type_id = g_type_register_static (gtk_box_get_type (), "ControlsGrid", &g_define_type_info, 0);
	ControlsGrid_private_offset = g_type_add_instance_private (controls_grid_type_id, sizeof (ControlsGridPrivate));
	return controls_grid_type_id;
}

GType
controls_grid_get_type (void)
{
	static gsize controls_grid_type_id__once = 0;
	if (g_once_init_enter (&controls_grid_type_id__once)) {
		GType controls_grid_type_id;
		controls_grid_type_id = controls_grid_get_type_once ();
		g_once_init_leave (&controls_grid_type_id__once, controls_grid_type_id);
	}
	return controls_grid_type_id__once;
}

static inline gpointer
overlay_message_get_instance_private (OverlayMessage* self)
{
	return G_STRUCT_MEMBER_P (self, OverlayMessage_private_offset);
}

OverlayMessage*
overlay_message_construct (GType object_type,
                           const gchar* text,
                           gint width)
{
	OverlayMessage * self = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	self = (OverlayMessage*) g_object_new (object_type, "text", text, "width", width, NULL);
	return self;
}

OverlayMessage*
overlay_message_new (const gchar* text,
                     gint width)
{
	return overlay_message_construct (TYPE_OVERLAY_MESSAGE, text, width);
}

static void
overlay_message_real_snapshot (GtkWidget* base,
                               GtkSnapshot* snapshot)
{
	OverlayMessage * self;
	static const gfloat PIby2 = 1.570796326794896619231321691639751442f;
	static const gint border = 20;
	gdouble text_width = 0.0;
	gdouble text_height = 0.0;
	gint font_size = 0;
	const gchar* _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gint _tmp4_;
	gfloat background_width = 0.0F;
	gfloat background_height = 0.0F;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	gfloat _tmp5_ = 0.0F;
	gfloat arc_radius = 0.0F;
	GskPathBuilder* background = NULL;
	GskPathBuilder* _tmp6_;
	GskPath* _tmp7_;
	GskPath* _tmp8_;
	GdkRGBA _tmp9_ = {0};
	const gchar* _tmp10_;
	self = (OverlayMessage*) base;
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = self->priv->_text;
	_tmp1_ = self->priv->_width;
	_tmp4_ = overlay_message_calculate_font_size (self, _tmp0_, _tmp1_ - border, &_tmp2_, &_tmp3_);
	text_width = _tmp2_;
	text_height = _tmp3_;
	font_size = _tmp4_;
	background_width = ((gfloat) text_width) + border;
	background_height = ((gfloat) text_height) + border;
	x = (gtk_widget_get_width ((GtkWidget*) self) - background_width) / 2;
	y = (gtk_widget_get_height ((GtkWidget*) self) - background_height) / 2;
	if (background_width < background_height) {
		_tmp5_ = background_width / 2;
	} else {
		_tmp5_ = background_height / 2;
	}
	arc_radius = _tmp5_;
	_tmp6_ = gsk_path_builder_new ();
	background = _tmp6_;
	gsk_path_builder_move_to (background, (x + background_width) - arc_radius, y + 0);
	gsk_path_builder_svg_arc_to (background, arc_radius, arc_radius, PIby2, FALSE, TRUE, x + background_width, y + arc_radius);
	gsk_path_builder_line_to (background, x + background_width, (y + background_height) - arc_radius);
	gsk_path_builder_svg_arc_to (background, arc_radius, arc_radius, PIby2, FALSE, TRUE, (x + background_width) - arc_radius, y + background_height);
	gsk_path_builder_line_to (background, x + arc_radius, y + background_height);
	gsk_path_builder_svg_arc_to (background, arc_radius, arc_radius, PIby2, FALSE, TRUE, x + 0, (y + background_height) - arc_radius);
	gsk_path_builder_line_to (background, x + 0, y + arc_radius);
	gsk_path_builder_svg_arc_to (background, arc_radius, arc_radius, PIby2, FALSE, TRUE, x + arc_radius, y + 0);
	_tmp7_ = gsk_path_builder_to_path (background);
	_tmp8_ = _tmp7_;
	_tmp9_.red = 0.0f;
	_tmp9_.green = 0.0f;
	_tmp9_.blue = 0.0f;
	_tmp9_.alpha = 0.9f;
	gtk_snapshot_append_fill (snapshot, _tmp8_, GSK_FILL_RULE_EVEN_ODD, &_tmp9_);
	_gsk_path_unref0 (_tmp8_);
	_tmp10_ = self->priv->_text;
	overlay_message_draw_text_font_size (self, snapshot, (gint) (x + ((background_width - text_width) / 2)), (gint) (y + ((background_height - text_height) / 2)), _tmp10_, font_size);
	_gsk_path_builder_unref0 (background);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static PangoFontDescription*
_vala_PangoFontDescription_copy (PangoFontDescription* self)
{
	return g_boxed_copy (pango_font_description_get_type (), self);
}

static gpointer
__vala_PangoFontDescription_copy0 (gpointer self)
{
	return self ? _vala_PangoFontDescription_copy (self) : NULL;
}

static gint
overlay_message_calculate_font_size (OverlayMessage* self,
                                     const gchar* text,
                                     gint target_width,
                                     gdouble* width,
                                     gdouble* height)
{
	gdouble _vala_width = 0.0;
	gdouble _vala_height = 0.0;
	gboolean rush_size_steps = FALSE;
	gint fail_count = 0;
	gint last_font_size = 0;
	gint target_font_size = 0;
	guint target_width_diff = 0U;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (text != NULL, 0);
	rush_size_steps = TRUE;
	fail_count = 0;
	last_font_size = 1;
	target_font_size = 1;
	_vala_width = (gdouble) 0;
	_vala_height = (gdouble) 0;
	target_width_diff = G_MAXUINT;
	{
		gint font_size = 0;
		font_size = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				PangoLayout* layout = NULL;
				PangoLayout* _tmp1_;
				PangoFontDescription* _tmp2_ = NULL;
				PangoLayout* _tmp3_;
				PangoFontDescription* _tmp4_;
				PangoFontDescription* font = NULL;
				PangoFontDescription* _tmp9_;
				PangoFontDescription* _tmp10_;
				PangoLayout* _tmp11_;
				PangoFontDescription* _tmp12_;
				PangoLayout* _tmp13_;
				PangoRectangle a = {0};
				PangoRectangle b = {0};
				PangoLayout* _tmp14_;
				PangoRectangle _tmp15_ = {0};
				PangoRectangle _tmp16_ = {0};
				gint width_diff = 0;
				PangoRectangle _tmp17_;
				gboolean _tmp18_ = FALSE;
				if (!_tmp0_) {
				}
				_tmp0_ = FALSE;
				if (!(font_size < 128)) {
					break;
				}
				_tmp1_ = gtk_widget_create_pango_layout ((GtkWidget*) self, text);
				layout = _tmp1_;
				_tmp3_ = layout;
				_tmp4_ = pango_layout_get_font_description (_tmp3_);
				if (NULL == _tmp4_) {
					PangoFontDescription* _tmp5_;
					_tmp5_ = pango_font_description_from_string ("Sans Bold 1pt");
					__vala_PangoFontDescription_free0 (_tmp2_);
					_tmp2_ = _tmp5_;
				} else {
					PangoLayout* _tmp6_;
					PangoFontDescription* _tmp7_;
					PangoFontDescription* _tmp8_;
					_tmp6_ = layout;
					_tmp7_ = pango_layout_get_font_description (_tmp6_);
					_tmp8_ = pango_font_description_copy (_tmp7_);
					__vala_PangoFontDescription_free0 (_tmp2_);
					_tmp2_ = _tmp8_;
				}
				_tmp9_ = __vala_PangoFontDescription_copy0 (_tmp2_);
				font = _tmp9_;
				_tmp10_ = font;
				pango_font_description_set_size (_tmp10_, PANGO_SCALE * font_size);
				_tmp11_ = layout;
				_tmp12_ = font;
				pango_layout_set_font_description (_tmp11_, _tmp12_);
				_tmp13_ = layout;
				pango_layout_set_text (_tmp13_, text, -1);
				_tmp14_ = layout;
				pango_layout_get_extents (_tmp14_, &_tmp15_, &_tmp16_);
				a = _tmp15_;
				b = _tmp16_;
				_tmp17_ = a;
				width_diff = target_width - ((gint) (_tmp17_.width / PANGO_SCALE));
				if (width_diff > 0) {
					_tmp18_ = ((guint) width_diff) < target_width_diff;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					PangoRectangle _tmp19_;
					PangoRectangle _tmp20_;
					target_width_diff = (guint) width_diff;
					target_font_size = font_size;
					_tmp19_ = a;
					_vala_width = (gdouble) (_tmp19_.width / PANGO_SCALE);
					_tmp20_ = a;
					_vala_height = (gdouble) (_tmp20_.height / PANGO_SCALE);
					if (!rush_size_steps) {
						fail_count = 0;
					}
				} else {
					if (rush_size_steps) {
						rush_size_steps = FALSE;
						font_size = last_font_size + 1;
						fail_count = 0;
					} else {
						if (fail_count > 2) {
							__vala_PangoFontDescription_free0 (font);
							__vala_PangoFontDescription_free0 (_tmp2_);
							_g_object_unref0 (layout);
							break;
						} else {
							gint _tmp21_;
							_tmp21_ = fail_count;
							fail_count = _tmp21_ + 1;
						}
					}
				}
				if (rush_size_steps) {
					last_font_size = font_size;
					font_size *= 2;
				} else {
					gint _tmp22_;
					_tmp22_ = font_size;
					font_size = _tmp22_ + 1;
				}
				__vala_PangoFontDescription_free0 (font);
				__vala_PangoFontDescription_free0 (_tmp2_);
				_g_object_unref0 (layout);
			}
		}
	}
	result = target_font_size;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	return result;
}

static void
overlay_message_draw_text_font_size (OverlayMessage* self,
                                     GtkSnapshot* snapshot,
                                     gint x,
                                     gint y,
                                     const gchar* text,
                                     gint font_size)
{
	gint x_offset = 0;
	gint y_offset = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	graphene_point_t _tmp2_ = {0};
	PangoLayout* layout = NULL;
	PangoLayout* _tmp3_;
	PangoLayout* _tmp4_;
	PangoFontDescription* _tmp5_ = NULL;
	PangoLayout* _tmp6_;
	PangoFontDescription* _tmp7_;
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp12_;
	PangoLayout* _tmp13_;
	PangoLayout* _tmp14_;
	PangoLayout* _tmp15_;
	GdkRGBA _tmp16_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (snapshot != NULL);
	g_return_if_fail (text != NULL);
	overlay_message_get_text_offsets (self, text, font_size, &_tmp0_, &_tmp1_);
	x_offset = _tmp0_;
	y_offset = _tmp1_;
	_tmp2_.x = (gfloat) (x - x_offset);
	_tmp2_.y = (gfloat) (y - y_offset);
	gtk_snapshot_translate (snapshot, &_tmp2_);
	_tmp3_ = gtk_widget_create_pango_layout ((GtkWidget*) self, text);
	layout = _tmp3_;
	_tmp4_ = layout;
	pango_layout_set_alignment (_tmp4_, 1);
	_tmp6_ = layout;
	_tmp7_ = pango_layout_get_font_description (_tmp6_);
	if (NULL == _tmp7_) {
		PangoFontDescription* _tmp8_;
		_tmp8_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (_tmp5_);
		_tmp5_ = _tmp8_;
	} else {
		PangoLayout* _tmp9_;
		PangoFontDescription* _tmp10_;
		PangoFontDescription* _tmp11_;
		_tmp9_ = layout;
		_tmp10_ = pango_layout_get_font_description (_tmp9_);
		_tmp11_ = pango_font_description_copy (_tmp10_);
		__vala_PangoFontDescription_free0 (_tmp5_);
		_tmp5_ = _tmp11_;
	}
	_tmp12_ = __vala_PangoFontDescription_copy0 (_tmp5_);
	font = _tmp12_;
	pango_font_description_set_size (font, PANGO_SCALE * font_size);
	_tmp13_ = layout;
	pango_layout_set_font_description (_tmp13_, font);
	_tmp14_ = layout;
	pango_layout_set_text (_tmp14_, text, -1);
	_tmp15_ = layout;
	_tmp16_.red = (gfloat) 1;
	_tmp16_.green = (gfloat) 1;
	_tmp16_.blue = (gfloat) 1;
	_tmp16_.alpha = (gfloat) 1;
	gtk_snapshot_append_layout (snapshot, _tmp15_, &_tmp16_);
	__vala_PangoFontDescription_free0 (font);
	__vala_PangoFontDescription_free0 (_tmp5_);
	_g_object_unref0 (layout);
}

static void
overlay_message_get_text_offsets (OverlayMessage* self,
                                  const gchar* text,
                                  gint font_size,
                                  gint* x_offset,
                                  gint* y_offset)
{
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	PangoFontDescription* _tmp1_ = NULL;
	PangoLayout* _tmp2_;
	PangoFontDescription* _tmp3_;
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp8_;
	PangoLayout* _tmp9_;
	PangoLayout* _tmp10_;
	PangoRectangle a = {0};
	PangoRectangle b = {0};
	PangoLayout* _tmp11_;
	PangoRectangle _tmp12_ = {0};
	PangoRectangle _tmp13_ = {0};
	PangoRectangle _tmp14_;
	PangoRectangle _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = gtk_widget_create_pango_layout ((GtkWidget*) self, text);
	layout = _tmp0_;
	_tmp2_ = layout;
	_tmp3_ = pango_layout_get_font_description (_tmp2_);
	if (NULL == _tmp3_) {
		PangoFontDescription* _tmp4_;
		_tmp4_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (_tmp1_);
		_tmp1_ = _tmp4_;
	} else {
		PangoLayout* _tmp5_;
		PangoFontDescription* _tmp6_;
		PangoFontDescription* _tmp7_;
		_tmp5_ = layout;
		_tmp6_ = pango_layout_get_font_description (_tmp5_);
		_tmp7_ = pango_font_description_copy (_tmp6_);
		__vala_PangoFontDescription_free0 (_tmp1_);
		_tmp1_ = _tmp7_;
	}
	_tmp8_ = __vala_PangoFontDescription_copy0 (_tmp1_);
	font = _tmp8_;
	pango_font_description_set_size (font, PANGO_SCALE * font_size);
	_tmp9_ = layout;
	pango_layout_set_font_description (_tmp9_, font);
	_tmp10_ = layout;
	pango_layout_set_text (_tmp10_, text, -1);
	_tmp11_ = layout;
	pango_layout_get_extents (_tmp11_, &_tmp12_, &_tmp13_);
	a = _tmp12_;
	b = _tmp13_;
	_tmp14_ = a;
	_vala_x_offset = _tmp14_.x / PANGO_SCALE;
	_tmp15_ = a;
	_vala_y_offset = _tmp15_.y / PANGO_SCALE;
	__vala_PangoFontDescription_free0 (font);
	__vala_PangoFontDescription_free0 (_tmp1_);
	_g_object_unref0 (layout);
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
}

const gchar*
overlay_message_get_text (OverlayMessage* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

void
overlay_message_set_text (OverlayMessage* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = overlay_message_get_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, overlay_message_properties[OVERLAY_MESSAGE_TEXT_PROPERTY]);
	}
}

gint
overlay_message_get_width (OverlayMessage* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_width;
	return result;
}

void
overlay_message_set_width (OverlayMessage* self,
                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = overlay_message_get_width (self);
	if (old_value != value) {
		self->priv->_width = value;
		g_object_notify_by_pspec ((GObject *) self, overlay_message_properties[OVERLAY_MESSAGE_WIDTH_PROPERTY]);
	}
}

static void
overlay_message_class_init (OverlayMessageClass * klass,
                            gpointer klass_data)
{
	overlay_message_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &OverlayMessage_private_offset);
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) overlay_message_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_overlay_message_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_overlay_message_set_property;
	G_OBJECT_CLASS (klass)->finalize = overlay_message_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), OVERLAY_MESSAGE_TEXT_PROPERTY, overlay_message_properties[OVERLAY_MESSAGE_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OVERLAY_MESSAGE_WIDTH_PROPERTY, overlay_message_properties[OVERLAY_MESSAGE_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
overlay_message_instance_init (OverlayMessage * self,
                               gpointer klass)
{
	self->priv = overlay_message_get_instance_private (self);
}

static void
overlay_message_finalize (GObject * obj)
{
	OverlayMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OVERLAY_MESSAGE, OverlayMessage);
	_g_free0 (self->priv->_text);
	G_OBJECT_CLASS (overlay_message_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
overlay_message_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OverlayMessageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) overlay_message_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OverlayMessage), 0, (GInstanceInitFunc) overlay_message_instance_init, NULL };
	GType overlay_message_type_id;
	overlay_message_type_id = g_type_register_static (gtk_widget_get_type (), "OverlayMessage", &g_define_type_info, 0);
	OverlayMessage_private_offset = g_type_add_instance_private (overlay_message_type_id, sizeof (OverlayMessagePrivate));
	return overlay_message_type_id;
}

GType
overlay_message_get_type (void)
{
	static gsize overlay_message_type_id__once = 0;
	if (g_once_init_enter (&overlay_message_type_id__once)) {
		GType overlay_message_type_id;
		overlay_message_type_id = overlay_message_get_type_once ();
		g_once_init_leave (&overlay_message_type_id__once, overlay_message_type_id);
	}
	return overlay_message_type_id__once;
}

static void
_vala_overlay_message_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	OverlayMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_OVERLAY_MESSAGE, OverlayMessage);
	switch (property_id) {
		case OVERLAY_MESSAGE_TEXT_PROPERTY:
		g_value_set_string (value, overlay_message_get_text (self));
		break;
		case OVERLAY_MESSAGE_WIDTH_PROPERTY:
		g_value_set_int (value, overlay_message_get_width (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_overlay_message_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	OverlayMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_OVERLAY_MESSAGE, OverlayMessage);
	switch (property_id) {
		case OVERLAY_MESSAGE_TEXT_PROPERTY:
		overlay_message_set_text (self, g_value_get_string (value));
		break;
		case OVERLAY_MESSAGE_WIDTH_PROPERTY:
		overlay_message_set_width (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

