/* gnome-mahjongg.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gnome-mahjongg.vala, do not modify */

/* SPDX-FileCopyrightText: 2010-2025 Mahjongg Contributors*/
/* SPDX-FileCopyrightText: 2010-2013 Robert Ancell*/
/* SPDX-License-Identifier: GPL-2.0-or-later*/

#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <locale.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MAHJONGG (mahjongg_get_type ())
#define MAHJONGG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAHJONGG, Mahjongg))
#define MAHJONGG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAHJONGG, MahjonggClass))
#define IS_MAHJONGG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAHJONGG))
#define IS_MAHJONGG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAHJONGG))
#define MAHJONGG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAHJONGG, MahjonggClass))

typedef struct _Mahjongg Mahjongg;
typedef struct _MahjonggClass MahjonggClass;
typedef struct _MahjonggPrivate MahjonggPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_GAME_SAVE (game_save_get_type ())
#define GAME_SAVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_SAVE, GameSave))
#define GAME_SAVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_SAVE, GameSaveClass))
#define IS_GAME_SAVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_SAVE))
#define IS_GAME_SAVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_SAVE))
#define GAME_SAVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_SAVE, GameSaveClass))

typedef struct _GameSave GameSave;
typedef struct _GameSaveClass GameSaveClass;

#define TYPE_MAPS (maps_get_type ())
#define MAPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAPS, Maps))
#define MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAPS, MapsClass))
#define IS_MAPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAPS))
#define IS_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAPS))
#define MAPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAPS, MapsClass))

typedef struct _Maps Maps;
typedef struct _MapsClass MapsClass;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
enum  {
	MAHJONGG_0_PROPERTY,
	MAHJONGG_NUM_PROPERTIES
};
static GParamSpec* mahjongg_properties[MAHJONGG_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
typedef void (*GSimpleActionChangeStateCallback) (GSimpleAction* action, GVariant* value, gpointer user_data);
#define _game_unref0(var) ((var == NULL) ? NULL : (var = (game_unref (var), NULL)))
#define _game_save_unref0(var) ((var == NULL) ? NULL : (var = (game_save_unref (var), NULL)))
#define _maps_unref0(var) ((var == NULL) ? NULL : (var = (maps_unref (var), NULL)))
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAHJONGG_WINDOW (mahjongg_window_get_type ())
#define MAHJONGG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAHJONGG_WINDOW, MahjonggWindow))
#define MAHJONGG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAHJONGG_WINDOW, MahjonggWindowClass))
#define IS_MAHJONGG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAHJONGG_WINDOW))
#define IS_MAHJONGG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAHJONGG_WINDOW))
#define MAHJONGG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAHJONGG_WINDOW, MahjonggWindowClass))

typedef struct _MahjonggWindow MahjonggWindow;
typedef struct _MahjonggWindowClass MahjonggWindowClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;
typedef struct _MapPrivate MapPrivate;
typedef struct _HistoryEntryPrivate HistoryEntryPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _MahjonggMovedCbData MahjonggMovedCbData;

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
typedef struct _MahjonggLayoutCbData MahjonggLayoutCbData;
typedef struct _GameSavePrivate GameSavePrivate;
#define _map_unref0(var) ((var == NULL) ? NULL : (var = (map_unref (var), NULL)))

#define TYPE_RULES_DIALOG (rules_dialog_get_type ())
#define RULES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RULES_DIALOG, RulesDialog))
#define RULES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RULES_DIALOG, RulesDialogClass))
#define IS_RULES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RULES_DIALOG))
#define IS_RULES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RULES_DIALOG))
#define RULES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RULES_DIALOG, RulesDialogClass))

typedef struct _RulesDialog RulesDialog;
typedef struct _RulesDialogClass RulesDialogClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

struct _Mahjongg {
	AdwApplication parent_instance;
	MahjonggPrivate * priv;
};

struct _MahjonggClass {
	AdwApplicationClass parent_class;
};

struct _MahjonggPrivate {
	Game* game;
	GameSave* game_save;
	Maps* maps;
	History* history;
	GSettings* settings;
};

struct _Game {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GamePrivate * priv;
	Map* map;
};

struct _GameClass {
	GTypeClass parent_class;
	void (*finalize) (Game *self);
};

struct _Map {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MapPrivate * priv;
	gchar* name;
	gchar* score_name;
	gint h_overhang;
	gint v_overhang;
};

struct _MapClass {
	GTypeClass parent_class;
	void (*finalize) (Map *self);
};

struct _HistoryEntry {
	GObject parent_instance;
	HistoryEntryPrivate * priv;
	GDateTime* date;
	gchar* name;
	guint duration;
	gchar* player;
	guint rank;
};

struct _HistoryEntryClass {
	GObjectClass parent_class;
};

struct _MahjonggMovedCbData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Mahjongg* self;
	GSimpleAction* hint_action;
	GAction* _tmp0_;
	GSimpleAction* undo_action;
	GAction* _tmp1_;
	GSimpleAction* redo_action;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	Game* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GSimpleAction* _tmp7_;
	Game* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GSimpleAction* _tmp11_;
	Game* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	Game* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GSimpleAction* pause_action;
	GAction* _tmp18_;
	GSimpleAction* _tmp19_;
	Game* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	Game* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	GDateTime* date;
	GDateTime* _tmp26_;
	guint duration;
	Game* _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	gchar* player;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	HistoryEntry* completed_entry;
	History* _tmp32_;
	GDateTime* _tmp33_;
	Game* _tmp34_;
	Map* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	HistoryEntry* _tmp38_;
	GameSave* _tmp39_;
	HistoryEntry* _tmp40_;
	const gchar* _tmp41_;
	HistoryEntry* _tmp42_;
	Game* _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	gboolean can_shuffle;
	Game* _tmp46_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	const gchar* _tmp49_;
	AdwAlertDialog* dialog;
	gchar* _tmp50_;
	AdwAlertDialog* _tmp51_;
	AdwAlertDialog* _tmp52_;
	AdwAlertDialog* _tmp53_;
	AdwAlertDialog* _tmp54_;
	AdwAlertDialog* _tmp55_;
	AdwAlertDialog* _tmp56_;
	gchar* resp_id;
	AdwAlertDialog* _tmp57_;
	GtkWindow* _tmp58_;
	GtkWindow* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	GQuark _tmp65_;
	GameSave* _tmp66_;
};

struct _MahjonggLayoutCbData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Mahjongg* self;
	GSimpleAction* action;
	GVariant* variant;
	gchar* layout;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	Game* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	AdwAlertDialog* dialog;
	gchar* _tmp10_;
	AdwAlertDialog* _tmp11_;
	AdwAlertDialog* _tmp12_;
	AdwAlertDialog* _tmp13_;
	AdwAlertDialog* _tmp14_;
	gchar* resp_id;
	AdwAlertDialog* _tmp15_;
	GtkWindow* _tmp16_;
	GtkWindow* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	GSettings* _tmp21_;
	const gchar* _tmp22_;
	GSettings* _tmp23_;
	gboolean rotate_map;
};

struct _GameSave {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameSavePrivate * priv;
	Map* map;
	gdouble clock;
	gint move;
	gint32 seed;
};

struct _GameSaveClass {
	GTypeClass parent_class;
	void (*finalize) (GameSave *self);
};

static gint Mahjongg_private_offset;
static gpointer mahjongg_parent_class = NULL;

VALA_EXTERN GType mahjongg_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Mahjongg, g_object_unref)
VALA_EXTERN gpointer game_ref (gpointer instance);
VALA_EXTERN void game_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_game (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_game (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_game (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_game (const GValue* value);
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, game_unref)
VALA_EXTERN gpointer game_save_ref (gpointer instance);
VALA_EXTERN void game_save_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_game_save (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_game_save (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_game_save (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_game_save (const GValue* value);
VALA_EXTERN GType game_save_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameSave, game_save_unref)
VALA_EXTERN gpointer maps_ref (gpointer instance);
VALA_EXTERN void maps_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_maps (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_maps (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_maps (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_maps (const GValue* value);
VALA_EXTERN GType maps_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Maps, maps_unref)
VALA_EXTERN gpointer history_ref (gpointer instance);
VALA_EXTERN void history_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_history (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_history (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_history (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_history (const GValue* value);
VALA_EXTERN GType history_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (History, history_unref)
static void mahjongg_new_game_cb (Mahjongg* self);
static void _mahjongg_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void mahjongg_undo_cb (Mahjongg* self);
static void _mahjongg_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void mahjongg_redo_cb (Mahjongg* self);
static void _mahjongg_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void mahjongg_hint_cb (Mahjongg* self);
static void _mahjongg_hint_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void mahjongg_pause_cb (Mahjongg* self);
static void _mahjongg_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void mahjongg_restart_game_cb (Mahjongg* self);
static void _mahjongg_restart_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void mahjongg_scores_cb (Mahjongg* self);
static void _mahjongg_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void mahjongg_layout_cb (Mahjongg* self,
                         GSimpleAction* action,
                         GVariant* variant);
static void _mahjongg_layout_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                               GVariant* value,
                                                               gpointer self);
static void mahjongg_layout_progression_cb (Mahjongg* self,
                                     GSimpleAction* action,
                                     GVariant* variant);
static void _mahjongg_layout_progression_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                           GVariant* value,
                                                                           gpointer self);
static void mahjongg_background_color_cb (Mahjongg* self,
                                   GSimpleAction* action,
                                   GVariant* variant);
static void _mahjongg_background_color_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                         GVariant* value,
                                                                         gpointer self);
static void mahjongg_theme_cb (Mahjongg* self,
                        GSimpleAction* action,
                        GVariant* variant);
static void _mahjongg_theme_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                              GVariant* value,
                                                              gpointer self);
static void mahjongg_rules_cb (Mahjongg* self);
static void _mahjongg_rules_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void mahjongg_about_cb (Mahjongg* self);
static void _mahjongg_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
VALA_EXTERN Mahjongg* mahjongg_new (void);
VALA_EXTERN Mahjongg* mahjongg_construct (GType object_type);
static void mahjongg_real_startup (GApplication* base);
static void mahjongg_create_window (Mahjongg* self);
VALA_EXTERN Maps* maps_new (void);
VALA_EXTERN Maps* maps_construct (GType object_type);
VALA_EXTERN gboolean maps_load (Maps* self);
VALA_EXTERN History* history_new (const gchar* filename);
VALA_EXTERN History* history_construct (GType object_type,
                            const gchar* filename);
VALA_EXTERN void history_load (History* self);
VALA_EXTERN MahjonggWindow* mahjongg_window_new (GtkApplication* application,
                                     GSettings* settings,
                                     Maps* maps);
VALA_EXTERN MahjonggWindow* mahjongg_window_construct (GType object_type,
                                           GtkApplication* application,
                                           GSettings* settings,
                                           Maps* maps);
VALA_EXTERN GType mahjongg_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MahjonggWindow, g_object_unref)
VALA_EXTERN GameSave* game_save_new (const gchar* filename);
VALA_EXTERN GameSave* game_save_construct (GType object_type,
                               const gchar* filename);
static void mahjongg_new_game (Mahjongg* self,
                        gboolean rotate_map,
                        gboolean restore);
static gint mahjongg_real_handle_local_options (GApplication* base,
                                         GVariantDict* options);
static void mahjongg_real_activate (GApplication* base);
static void mahjongg_real_shutdown (GApplication* base);
VALA_EXTERN void game_destroy_timers (Game* self);
VALA_EXTERN void game_save_write (GameSave* self,
                      Game* game);
static gboolean mahjongg_attempt_move_cb (Mahjongg* self);
VALA_EXTERN gboolean game_get_paused (Game* self);
VALA_EXTERN void game_set_paused (Game* self,
                      gboolean value);
static void mahjongg_moved_cb_data_free (gpointer _data);
static void mahjongg_moved_cb (Mahjongg* self,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_);
static void mahjongg_moved_cb_finish (Mahjongg* self,
                               GAsyncResult* _res_);
static gboolean mahjongg_moved_cb_co (MahjonggMovedCbData* _data_);
VALA_EXTERN guint game_get_moves_left (Game* self);
VALA_EXTERN gboolean game_get_can_undo (Game* self);
VALA_EXTERN gboolean game_get_can_redo (Game* self);
VALA_EXTERN gboolean game_get_inspecting (Game* self);
VALA_EXTERN gboolean game_get_started (Game* self);
VALA_EXTERN gboolean game_get_complete (Game* self);
VALA_EXTERN gdouble game_get_elapsed (Game* self);
VALA_EXTERN GType history_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryEntry, g_object_unref)
VALA_EXTERN HistoryEntry* history_add (History* self,
                           GDateTime* date,
                           const gchar* name,
                           guint duration,
                           const gchar* player);
VALA_EXTERN gpointer map_ref (gpointer instance);
VALA_EXTERN void map_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_map (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags);
VALA_EXTERN void value_set_map (GValue* value,
                    gpointer v_object);
VALA_EXTERN void value_take_map (GValue* value,
                     gpointer v_object);
VALA_EXTERN gpointer value_get_map (const GValue* value);
VALA_EXTERN GType map_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Map, map_unref)
VALA_EXTERN void game_save_delete (GameSave* self);
static void mahjongg_show_scores (Mahjongg* self,
                           const gchar* selected_layout,
                           HistoryEntry* completed_entry);
VALA_EXTERN gboolean game_get_can_move (Game* self);
VALA_EXTERN gboolean game_get_can_shuffle (Game* self);
static void mahjongg_moved_cb_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_);
static void mahjongg_shuffle_cb (Mahjongg* self);
static void mahjongg_paused_changed_cb (Mahjongg* self);
VALA_EXTERN ScoreDialog* score_dialog_new (History* history,
                               Maps* maps,
                               const gchar* selected_layout,
                               HistoryEntry* completed_entry);
VALA_EXTERN ScoreDialog* score_dialog_construct (GType object_type,
                                     History* history,
                                     Maps* maps,
                                     const gchar* selected_layout,
                                     HistoryEntry* completed_entry);
VALA_EXTERN GType score_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScoreDialog, g_object_unref)
static void _mahjongg_layout_cb_data_free (gpointer _data);
static void _mahjongg_layout_cb (Mahjongg* self,
                          GSimpleAction* action,
                          GVariant* variant,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
static void _mahjongg_layout_cb_finish (Mahjongg* self,
                                 GAsyncResult* _res_);
static gboolean _mahjongg_layout_cb_co (MahjonggLayoutCbData* _data_);
static void _mahjongg_layout_cb_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_);
VALA_EXTERN void game_show_hint (Game* self);
VALA_EXTERN void game_shuffle_remaining (Game* self);
VALA_EXTERN void game_restart (Game* self);
VALA_EXTERN void game_redo (Game* self);
VALA_EXTERN void game_undo (Game* self);
static Map* mahjongg_next_map (Mahjongg* self,
                        gboolean rotate_map);
VALA_EXTERN Map* maps_get_map_by_name (Maps* self,
                           const gchar* name);
VALA_EXTERN Map* maps_get_map_at_position (Maps* self,
                               gint position);
VALA_EXTERN Map* maps_get_next_map (Maps* self,
                        Map* map);
VALA_EXTERN Map* maps_get_random_map (Maps* self);
VALA_EXTERN gboolean game_save_load (GameSave* self,
                         Maps* maps);
VALA_EXTERN Game* game_new (Map* map);
VALA_EXTERN Game* game_construct (GType object_type,
                      Map* map);
VALA_EXTERN void mahjongg_window_new_game (MahjonggWindow* self,
                               Game* game,
                               gboolean rotate_map);
static gboolean _mahjongg_attempt_move_cb_game_attempt_move (Game* _sender,
                                                      gpointer self);
static void _mahjongg_moved_cb_game_moved (Game* _sender,
                                    gpointer self);
static void _mahjongg_paused_changed_cb_game_paused_changed (Game* _sender,
                                                      gpointer self);
VALA_EXTERN void game_restore (Game* self,
                   GameSave* save);
VALA_EXTERN void game_generate (Game* self,
                    gint32 seed);
VALA_EXTERN RulesDialog* rules_dialog_new (void);
VALA_EXTERN RulesDialog* rules_dialog_construct (GType object_type);
VALA_EXTERN GType rules_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RulesDialog, g_object_unref)
static gint mahjongg_main (gchar** args,
                    gint args_length1);
VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
static void mahjongg_finalize (GObject * obj);
static GType mahjongg_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GOptionEntry MAHJONGG_OPTION_ENTRIES[2] = {{"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Print release version and exit"), NULL}, {NULL}};
static const GActionEntry MAHJONGG_ACTION_ENTRIES[14] = {{"new-game", _mahjongg_new_game_cb_gsimple_action_activate_callback}, {"undo", _mahjongg_undo_cb_gsimple_action_activate_callback}, {"redo", _mahjongg_redo_cb_gsimple_action_activate_callback}, {"hint", _mahjongg_hint_cb_gsimple_action_activate_callback}, {"pause", _mahjongg_pause_cb_gsimple_action_activate_callback}, {"restart-game", _mahjongg_restart_game_cb_gsimple_action_activate_callback}, {"scores", _mahjongg_scores_cb_gsimple_action_activate_callback}, {"layout", NULL, "s", "''", _mahjongg_layout_cb_gsimple_action_change_state_callback}, {"layout-progression", NULL, "s", "''", _mahjongg_layout_progression_cb_gsimple_action_change_state_callback}, {"background-color", NULL, "s", "''", _mahjongg_background_color_cb_gsimple_action_change_state_callback}, {"theme", NULL, "s", "''", _mahjongg_theme_cb_gsimple_action_change_state_callback}, {"rules", _mahjongg_rules_cb_gsimple_action_activate_callback}, {"about", _mahjongg_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};

static inline gpointer
mahjongg_get_instance_private (Mahjongg* self)
{
	return G_STRUCT_MEMBER_P (self, Mahjongg_private_offset);
}

static void
_mahjongg_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	mahjongg_new_game_cb ((Mahjongg*) self);
}

static void
_mahjongg_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	mahjongg_undo_cb ((Mahjongg*) self);
}

static void
_mahjongg_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	mahjongg_redo_cb ((Mahjongg*) self);
}

static void
_mahjongg_hint_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	mahjongg_hint_cb ((Mahjongg*) self);
}

static void
_mahjongg_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
	mahjongg_pause_cb ((Mahjongg*) self);
}

static void
_mahjongg_restart_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	mahjongg_restart_game_cb ((Mahjongg*) self);
}

static void
_mahjongg_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	mahjongg_scores_cb ((Mahjongg*) self);
}

static void
_mahjongg_layout_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                          GVariant* value,
                                                          gpointer self)
{
	mahjongg_layout_cb ((Mahjongg*) self, action, value);
}

static void
_mahjongg_layout_progression_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                      GVariant* value,
                                                                      gpointer self)
{
	mahjongg_layout_progression_cb ((Mahjongg*) self, action, value);
}

static void
_mahjongg_background_color_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                    GVariant* value,
                                                                    gpointer self)
{
	mahjongg_background_color_cb ((Mahjongg*) self, action, value);
}

static void
_mahjongg_theme_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                         GVariant* value,
                                                         gpointer self)
{
	mahjongg_theme_cb ((Mahjongg*) self, action, value);
}

static void
_mahjongg_rules_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
	mahjongg_rules_cb ((Mahjongg*) self);
}

static void
_mahjongg_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
	mahjongg_about_cb ((Mahjongg*) self);
}

static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	g_application_quit ((GApplication*) self);
}

Mahjongg*
mahjongg_construct (GType object_type)
{
	Mahjongg * self = NULL;
	self = (Mahjongg*) g_object_new (object_type, "application-id", APP_ID, "resource-base-path", "/org/gnome/Mahjongg", NULL);
	g_application_add_main_option_entries ((GApplication*) self, MAHJONGG_OPTION_ENTRIES);
	return self;
}

Mahjongg*
mahjongg_new (void)
{
	return mahjongg_construct (TYPE_MAHJONGG);
}

static void
mahjongg_real_startup (GApplication* base)
{
	Mahjongg * self;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GSettings* _tmp30_;
	GSettings* _tmp31_;
	self = (Mahjongg*) base;
	G_APPLICATION_CLASS (mahjongg_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	g_action_map_add_action_entries ((GActionMap*) self, MAHJONGG_ACTION_ENTRIES, (gint) G_N_ELEMENTS (MAHJONGG_ACTION_ENTRIES), self);
	_tmp0_ = g_strdup ("<Primary>n");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp2_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = g_strdup ("<Primary>r");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.restart-game", _tmp5_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = g_strdup ("<Primary>p");
	_tmp7_ = g_strdup ("Pause");
	_tmp8_ = g_new0 (gchar*, 2 + 1);
	_tmp8_[0] = _tmp6_;
	_tmp8_[1] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.pause", _tmp9_);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = g_strdup ("<Primary>h");
	_tmp11_ = g_new0 (gchar*, 1 + 1);
	_tmp11_[0] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.hint", _tmp12_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = g_strdup ("<Primary>z");
	_tmp14_ = g_new0 (gchar*, 1 + 1);
	_tmp14_[0] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp15_);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	_tmp16_ = g_strdup ("<Shift><Primary>z");
	_tmp17_ = g_new0 (gchar*, 1 + 1);
	_tmp17_[0] = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp18__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp18_);
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
	_tmp19_ = g_strdup ("F1");
	_tmp20_ = g_new0 (gchar*, 1 + 1);
	_tmp20_[0] = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp21__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.rules", _tmp21_);
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
	_tmp22_ = g_strdup ("<Primary>q");
	_tmp23_ = g_new0 (gchar*, 1 + 1);
	_tmp23_[0] = _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp24__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp24_);
	_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
	_tmp25_ = g_strdup ("<Primary>w");
	_tmp26_ = g_new0 (gchar*, 1 + 1);
	_tmp26_[0] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "window.close", _tmp27_);
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	_tmp28_ = g_application_get_application_id ((GApplication*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_settings_new (_tmp29_);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp30_;
	_tmp31_ = self->priv->settings;
	g_settings_delay (_tmp31_);
}

static void
mahjongg_create_window (Mahjongg* self)
{
	Maps* _tmp0_;
	Maps* _tmp1_;
	gchar* history_path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	History* _tmp5_;
	History* _tmp6_;
	GSettings* _tmp7_;
	Maps* _tmp8_;
	MahjonggWindow* _tmp9_;
	MahjonggWindow* _tmp10_;
	gchar* layout = NULL;
	GSettings* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	GSimpleAction* layout_action = NULL;
	GAction* _tmp17_;
	GSimpleAction* _tmp18_;
	const gchar* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	gchar* layout_progression = NULL;
	GSettings* _tmp22_;
	gchar* _tmp23_;
	GSimpleAction* layout_progression_action = NULL;
	GAction* _tmp24_;
	GSimpleAction* _tmp25_;
	const gchar* _tmp26_;
	GVariant* _tmp27_;
	GVariant* _tmp28_;
	gchar* background_color = NULL;
	GSettings* _tmp29_;
	gchar* _tmp30_;
	GSimpleAction* background_color_action = NULL;
	GAction* _tmp31_;
	GSimpleAction* _tmp32_;
	const gchar* _tmp33_;
	GVariant* _tmp34_;
	GVariant* _tmp35_;
	gchar* theme = NULL;
	GSettings* _tmp36_;
	gchar* _tmp37_;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	const gchar* _tmp40_;
	GSimpleAction* theme_action = NULL;
	GAction* _tmp51_;
	const gchar* _tmp52_;
	GVariant* _tmp53_;
	GVariant* _tmp54_;
	gchar* save_path = NULL;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	GameSave* _tmp57_;
	gboolean rotate_map = FALSE;
	const gchar* _tmp58_;
	gboolean restore = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = maps_new ();
	_maps_unref0 (self->priv->maps);
	self->priv->maps = _tmp0_;
	_tmp1_ = self->priv->maps;
	maps_load (_tmp1_);
	_tmp2_ = g_get_user_data_dir ();
	_tmp3_ = g_build_filename (_tmp2_, "gnome-mahjongg", "history", NULL);
	history_path = _tmp3_;
	_tmp4_ = history_path;
	_tmp5_ = history_new (_tmp4_);
	_history_unref0 (self->priv->history);
	self->priv->history = _tmp5_;
	_tmp6_ = self->priv->history;
	history_load (_tmp6_);
	_tmp7_ = self->priv->settings;
	_tmp8_ = self->priv->maps;
	_tmp9_ = mahjongg_window_new ((GtkApplication*) self, _tmp7_, _tmp8_);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->settings;
	_tmp12_ = g_settings_get_string (_tmp11_, "mapset");
	layout = _tmp12_;
	_tmp13_ = layout;
	if (g_strcmp0 (_tmp13_, "Difficult") == 0) {
		gchar* _tmp14_;
		GSettings* _tmp15_;
		const gchar* _tmp16_;
		_tmp14_ = g_strdup ("Taipei");
		_g_free0 (layout);
		layout = _tmp14_;
		_tmp15_ = self->priv->settings;
		_tmp16_ = layout;
		g_settings_set_string (_tmp15_, "mapset", _tmp16_);
	}
	_tmp17_ = g_action_map_lookup_action ((GActionMap*) self, "layout");
	layout_action = G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp17_) : NULL;
	_tmp18_ = layout_action;
	_tmp19_ = layout;
	_tmp20_ = g_variant_new_string (_tmp19_);
	g_variant_ref_sink (_tmp20_);
	_tmp21_ = _tmp20_;
	g_simple_action_set_state (_tmp18_, _tmp21_);
	_g_variant_unref0 (_tmp21_);
	_tmp22_ = self->priv->settings;
	_tmp23_ = g_settings_get_string (_tmp22_, "map-rotation");
	layout_progression = _tmp23_;
	_tmp24_ = g_action_map_lookup_action ((GActionMap*) self, "layout-progression");
	layout_progression_action = G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp24_) : NULL;
	_tmp25_ = layout_progression_action;
	_tmp26_ = layout_progression;
	_tmp27_ = g_variant_new_string (_tmp26_);
	g_variant_ref_sink (_tmp27_);
	_tmp28_ = _tmp27_;
	g_simple_action_set_state (_tmp25_, _tmp28_);
	_g_variant_unref0 (_tmp28_);
	_tmp29_ = self->priv->settings;
	_tmp30_ = g_settings_get_string (_tmp29_, "background-color");
	background_color = _tmp30_;
	_tmp31_ = g_action_map_lookup_action ((GActionMap*) self, "background-color");
	background_color_action = G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp31_) : NULL;
	_tmp32_ = background_color_action;
	_tmp33_ = background_color;
	_tmp34_ = g_variant_new_string (_tmp33_);
	g_variant_ref_sink (_tmp34_);
	_tmp35_ = _tmp34_;
	g_simple_action_set_state (_tmp32_, _tmp35_);
	_g_variant_unref0 (_tmp35_);
	_tmp36_ = self->priv->settings;
	_tmp37_ = g_settings_get_string (_tmp36_, "tileset");
	theme = _tmp37_;
	_tmp40_ = theme;
	if (g_strcmp0 (_tmp40_, "postmodern.svg") == 0) {
		_tmp39_ = TRUE;
	} else {
		const gchar* _tmp41_;
		_tmp41_ = theme;
		_tmp39_ = g_strcmp0 (_tmp41_, "smooth.png") == 0;
	}
	if (_tmp39_) {
		_tmp38_ = TRUE;
	} else {
		const gchar* _tmp42_;
		_tmp42_ = theme;
		_tmp38_ = g_strcmp0 (_tmp42_, "educational.png") == 0;
	}
	if (_tmp38_) {
		const gchar* _tmp43_;
		gchar** _tmp44_;
		gchar** _tmp45_;
		gchar** _tmp46_;
		gint _tmp46__length1;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		GSettings* _tmp49_;
		const gchar* _tmp50_;
		_tmp43_ = theme;
		_tmp45_ = _tmp44_ = g_strsplit (_tmp43_, ".", 0);
		_tmp46_ = _tmp45_;
		_tmp46__length1 = _vala_array_length (_tmp44_);
		_tmp47_ = _tmp46_[0];
		_tmp48_ = g_strdup (_tmp47_);
		_g_free0 (theme);
		theme = _tmp48_;
		_tmp46_ = (_vala_array_free (_tmp46_, _tmp46__length1, (GDestroyNotify) g_free), NULL);
		_tmp49_ = self->priv->settings;
		_tmp50_ = theme;
		g_settings_set_string (_tmp49_, "tileset", _tmp50_);
	}
	_tmp51_ = g_action_map_lookup_action ((GActionMap*) self, "theme");
	theme_action = G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp51_) : NULL;
	_tmp52_ = theme;
	_tmp53_ = g_variant_new_string (_tmp52_);
	g_variant_ref_sink (_tmp53_);
	_tmp54_ = _tmp53_;
	g_simple_action_set_state (theme_action, _tmp54_);
	_g_variant_unref0 (_tmp54_);
	_tmp55_ = g_get_user_data_dir ();
	_tmp56_ = g_build_filename (_tmp55_, "gnome-mahjongg", "gamesave", NULL);
	save_path = _tmp56_;
	_tmp57_ = game_save_new (save_path);
	_game_save_unref0 (self->priv->game_save);
	self->priv->game_save = _tmp57_;
	_tmp58_ = layout_progression;
	rotate_map = g_strcmp0 (_tmp58_, "random") == 0;
	restore = TRUE;
	mahjongg_new_game (self, rotate_map, restore);
	_g_free0 (save_path);
	_g_free0 (theme);
	_g_free0 (background_color);
	_g_free0 (layout_progression);
	_g_free0 (layout);
	_g_free0 (history_path);
}

static gint
mahjongg_real_handle_local_options (GApplication* base,
                                    GVariantDict* options)
{
	Mahjongg * self;
	gint result;
	self = (Mahjongg*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "%1$s %2$s\n", "gnome-mahjongg", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	result = -1;
	return result;
}

static void
mahjongg_real_activate (GApplication* base)
{
	Mahjongg * self;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	self = (Mahjongg*) base;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		mahjongg_create_window (self);
	}
	_tmp2_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp3_ = _tmp2_;
	gtk_window_present (_tmp3_);
}

static void
mahjongg_real_shutdown (GApplication* base)
{
	Mahjongg * self;
	Game* _tmp0_;
	GSettings* _tmp4_;
	self = (Mahjongg*) base;
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		GameSave* _tmp2_;
		Game* _tmp3_;
		_tmp1_ = self->priv->game;
		game_destroy_timers (_tmp1_);
		_tmp2_ = self->priv->game_save;
		_tmp3_ = self->priv->game;
		game_save_write (_tmp2_, _tmp3_);
	}
	_tmp4_ = self->priv->settings;
	g_settings_apply (_tmp4_);
	G_APPLICATION_CLASS (mahjongg_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
}

static gboolean
mahjongg_attempt_move_cb (Mahjongg* self)
{
	Game* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Game* _tmp3_;
		_tmp3_ = self->priv->game;
		game_set_paused (_tmp3_, FALSE);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static void
mahjongg_moved_cb_data_free (gpointer _data)
{
	MahjonggMovedCbData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MahjonggMovedCbData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
mahjongg_moved_cb (Mahjongg* self,
                   GAsyncReadyCallback _callback_,
                   gpointer _user_data_)
{
	MahjonggMovedCbData* _data_;
	Mahjongg* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MahjonggMovedCbData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mahjongg_moved_cb_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mahjongg_moved_cb_co (_data_);
}

static void
mahjongg_moved_cb_finish (Mahjongg* self,
                          GAsyncResult* _res_)
{
	MahjonggMovedCbData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mahjongg_moved_cb_ready (GObject* source_object,
                         GAsyncResult* _res_,
                         gpointer _user_data_)
{
	MahjonggMovedCbData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mahjongg_moved_cb_co (_data_);
}

static gboolean
mahjongg_moved_cb_co (MahjonggMovedCbData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_action_map_lookup_action ((GActionMap*) _data_->self, "hint");
	_data_->hint_action = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _data_->_tmp0_) : NULL;
	_data_->_tmp1_ = g_action_map_lookup_action ((GActionMap*) _data_->self, "undo");
	_data_->undo_action = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, g_simple_action_get_type ()) ? ((GSimpleAction*) _data_->_tmp1_) : NULL;
	_data_->_tmp2_ = g_action_map_lookup_action ((GActionMap*) _data_->self, "redo");
	_data_->redo_action = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _data_->_tmp2_) : NULL;
	_data_->_tmp3_ = _data_->hint_action;
	_data_->_tmp4_ = _data_->self->priv->game;
	_data_->_tmp5_ = game_get_moves_left (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	g_simple_action_set_enabled (_data_->_tmp3_, _data_->_tmp6_ > ((guint) 0));
	_data_->_tmp7_ = _data_->undo_action;
	_data_->_tmp8_ = _data_->self->priv->game;
	_data_->_tmp9_ = game_get_can_undo (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	g_simple_action_set_enabled (_data_->_tmp7_, _data_->_tmp10_);
	_data_->_tmp11_ = _data_->redo_action;
	_data_->_tmp12_ = _data_->self->priv->game;
	_data_->_tmp13_ = game_get_can_redo (_data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	g_simple_action_set_enabled (_data_->_tmp11_, _data_->_tmp14_);
	_data_->_tmp15_ = _data_->self->priv->game;
	_data_->_tmp16_ = game_get_inspecting (_data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	if (_data_->_tmp17_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = g_action_map_lookup_action ((GActionMap*) _data_->self, "pause");
	_data_->pause_action = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp18_, g_simple_action_get_type ()) ? ((GSimpleAction*) _data_->_tmp18_) : NULL;
	_data_->_tmp19_ = _data_->pause_action;
	_data_->_tmp20_ = _data_->self->priv->game;
	_data_->_tmp21_ = game_get_started (_data_->_tmp20_);
	_data_->_tmp22_ = _data_->_tmp21_;
	g_simple_action_set_enabled (_data_->_tmp19_, _data_->_tmp22_);
	_data_->_tmp23_ = _data_->self->priv->game;
	_data_->_tmp24_ = game_get_complete (_data_->_tmp23_);
	_data_->_tmp25_ = _data_->_tmp24_;
	if (_data_->_tmp25_) {
		_data_->_tmp26_ = g_date_time_new_now_local ();
		_data_->date = _data_->_tmp26_;
		_data_->_tmp27_ = _data_->self->priv->game;
		_data_->_tmp28_ = game_get_elapsed (_data_->_tmp27_);
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->duration = (guint) _data_->_tmp29_;
		_data_->_tmp30_ = g_get_real_name ();
		_data_->_tmp31_ = g_strdup (_data_->_tmp30_);
		_data_->player = _data_->_tmp31_;
		_data_->_tmp32_ = _data_->self->priv->history;
		_data_->_tmp33_ = _data_->date;
		_data_->_tmp34_ = _data_->self->priv->game;
		_data_->_tmp35_ = _data_->_tmp34_->map;
		_data_->_tmp36_ = _data_->_tmp35_->score_name;
		_data_->_tmp37_ = _data_->player;
		_data_->_tmp38_ = history_add (_data_->_tmp32_, _data_->_tmp33_, _data_->_tmp36_, _data_->duration, _data_->_tmp37_);
		_data_->completed_entry = _data_->_tmp38_;
		_data_->_tmp39_ = _data_->self->priv->game_save;
		game_save_delete (_data_->_tmp39_);
		_data_->_tmp40_ = _data_->completed_entry;
		_data_->_tmp41_ = _data_->_tmp40_->name;
		_data_->_tmp42_ = _data_->completed_entry;
		mahjongg_show_scores (_data_->self, _data_->_tmp41_, _data_->_tmp42_);
		_g_object_unref0 (_data_->completed_entry);
		_g_free0 (_data_->player);
		_g_date_time_unref0 (_data_->date);
	} else {
		_data_->_tmp43_ = _data_->self->priv->game;
		_data_->_tmp44_ = game_get_can_move (_data_->_tmp43_);
		_data_->_tmp45_ = _data_->_tmp44_;
		if (!_data_->_tmp45_) {
			static GQuark _tmp64_label0 = 0;
			static GQuark _tmp64_label1 = 0;
			static GQuark _tmp64_label2 = 0;
			_data_->_tmp46_ = _data_->self->priv->game;
			_data_->_tmp47_ = game_get_can_shuffle (_data_->_tmp46_);
			_data_->_tmp48_ = _data_->_tmp47_;
			_data_->can_shuffle = _data_->_tmp48_;
			if (_data_->can_shuffle) {
				_data_->_tmp49_ = _ ("You can undo your moves and try to find a solution, or reshuffle the r" \
"emaining tiles.");
			} else {
				_data_->_tmp49_ = _ ("You can undo your moves and try to find a solution, or start a new gam" \
"e.");
			}
			_data_->_tmp50_ = g_strdup ("continue");
			_data_->_tmp51_ = NULL;
			_data_->_tmp51_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("No Moves Left"), _data_->_tmp49_);
			adw_alert_dialog_set_default_response (_data_->_tmp51_, _data_->_tmp50_);
			_g_free0 (_data_->_tmp50_);
			g_object_ref_sink (_data_->_tmp51_);
			_data_->dialog = _data_->_tmp51_;
			_data_->_tmp52_ = _data_->dialog;
			adw_alert_dialog_add_response (_data_->_tmp52_, "quit", _ ("_Quit"));
			_data_->_tmp53_ = _data_->dialog;
			adw_alert_dialog_set_response_appearance (_data_->_tmp53_, "quit", ADW_RESPONSE_DESTRUCTIVE);
			_data_->_tmp54_ = _data_->dialog;
			adw_alert_dialog_add_response (_data_->_tmp54_, "new_game", _ ("_New Game"));
			if (_data_->can_shuffle) {
				_data_->_tmp55_ = _data_->dialog;
				adw_alert_dialog_add_response (_data_->_tmp55_, "reshuffle", _ ("_Reshuffle"));
			}
			_data_->_tmp56_ = _data_->dialog;
			adw_alert_dialog_add_response (_data_->_tmp56_, "continue", _ ("_Continue"));
			_data_->_tmp57_ = _data_->dialog;
			_data_->_tmp58_ = gtk_application_get_active_window ((GtkApplication*) _data_->self);
			_data_->_tmp59_ = _data_->_tmp58_;
			_data_->_state_ = 1;
			adw_alert_dialog_choose (_data_->_tmp57_, (GtkWidget*) _data_->_tmp59_, NULL, mahjongg_moved_cb_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp60_ = adw_alert_dialog_choose_finish (_data_->_tmp57_, _data_->_res_);
			_data_->_tmp61_ = g_strdup (_data_->_tmp60_);
			_data_->resp_id = _data_->_tmp61_;
			_data_->_tmp62_ = _data_->resp_id;
			_data_->_tmp65_ = 0U;
			_data_->_tmp63_ = _data_->_tmp62_;
			_data_->_tmp65_ = (NULL == _data_->_tmp63_) ? 0 : g_quark_from_string (_data_->_tmp63_);
			if (_data_->_tmp65_ == ((0 != _tmp64_label0) ? _tmp64_label0 : (_tmp64_label0 = g_quark_from_static_string ("reshuffle")))) {
				switch (0) {
					default:
					{
						mahjongg_shuffle_cb (_data_->self);
						break;
					}
				}
			} else if (_data_->_tmp65_ == ((0 != _tmp64_label1) ? _tmp64_label1 : (_tmp64_label1 = g_quark_from_static_string ("new_game")))) {
				switch (0) {
					default:
					{
						mahjongg_new_game (_data_->self, TRUE, FALSE);
						break;
					}
				}
			} else if (_data_->_tmp65_ == ((0 != _tmp64_label2) ? _tmp64_label2 : (_tmp64_label2 = g_quark_from_static_string ("quit")))) {
				switch (0) {
					default:
					{
						_data_->_tmp66_ = _data_->self->priv->game_save;
						game_save_delete (_data_->_tmp66_);
						g_application_quit ((GApplication*) _data_->self);
						break;
					}
				}
			} else {
				switch (0) {
					default:
					{
						break;
					}
				}
			}
			_g_free0 (_data_->resp_id);
			_g_object_unref0 (_data_->dialog);
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mahjongg_paused_changed_cb (Mahjongg* self)
{
	GSimpleAction* hint_action = NULL;
	GAction* _tmp0_;
	GSimpleAction* undo_action = NULL;
	GAction* _tmp1_;
	GSimpleAction* redo_action = NULL;
	GAction* _tmp2_;
	Game* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "hint");
	hint_action = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL;
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	undo_action = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp1_) : NULL;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
	redo_action = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL;
	_tmp3_ = self->priv->game;
	_tmp4_ = game_get_paused (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		GSimpleAction* _tmp6_;
		GSimpleAction* _tmp7_;
		GSimpleAction* _tmp8_;
		_tmp6_ = hint_action;
		g_simple_action_set_enabled (_tmp6_, FALSE);
		_tmp7_ = undo_action;
		g_simple_action_set_enabled (_tmp7_, FALSE);
		_tmp8_ = redo_action;
		g_simple_action_set_enabled (_tmp8_, FALSE);
	} else {
		GSimpleAction* _tmp9_;
		Game* _tmp10_;
		guint _tmp11_;
		guint _tmp12_;
		GSimpleAction* _tmp13_;
		Game* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		GSimpleAction* _tmp17_;
		Game* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp9_ = hint_action;
		_tmp10_ = self->priv->game;
		_tmp11_ = game_get_moves_left (_tmp10_);
		_tmp12_ = _tmp11_;
		g_simple_action_set_enabled (_tmp9_, _tmp12_ > ((guint) 0));
		_tmp13_ = undo_action;
		_tmp14_ = self->priv->game;
		_tmp15_ = game_get_can_undo (_tmp14_);
		_tmp16_ = _tmp15_;
		g_simple_action_set_enabled (_tmp13_, _tmp16_);
		_tmp17_ = redo_action;
		_tmp18_ = self->priv->game;
		_tmp19_ = game_get_can_redo (_tmp18_);
		_tmp20_ = _tmp19_;
		g_simple_action_set_enabled (_tmp17_, _tmp20_);
	}
}

static void
mahjongg_show_scores (Mahjongg* self,
                      const gchar* selected_layout,
                      HistoryEntry* completed_entry)
{
	History* _tmp0_;
	Maps* _tmp1_;
	ScoreDialog* _tmp2_;
	ScoreDialog* _tmp3_;
	GtkWindow* _tmp4_;
	GtkWindow* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selected_layout != NULL);
	_tmp0_ = self->priv->history;
	_tmp1_ = self->priv->maps;
	_tmp2_ = score_dialog_new (_tmp0_, _tmp1_, selected_layout, completed_entry);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp5_ = _tmp4_;
	adw_dialog_present ((AdwDialog*) _tmp3_, (GtkWidget*) _tmp5_);
	_g_object_unref0 (_tmp3_);
}

static void
_mahjongg_layout_cb_data_free (gpointer _data)
{
	MahjonggLayoutCbData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->action);
	_g_variant_unref0 (_data_->variant);
	_g_object_unref0 (_data_->self);
	g_slice_free (MahjonggLayoutCbData, _data_);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
_mahjongg_layout_cb (Mahjongg* self,
                     GSimpleAction* action,
                     GVariant* variant,
                     GAsyncReadyCallback _callback_,
                     gpointer _user_data_)
{
	MahjonggLayoutCbData* _data_;
	Mahjongg* _tmp0_;
	GSimpleAction* _tmp1_;
	GVariant* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (variant != NULL);
	_data_ = g_slice_new0 (MahjonggLayoutCbData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _mahjongg_layout_cb_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (action);
	_g_object_unref0 (_data_->action);
	_data_->action = _tmp1_;
	_tmp2_ = _g_variant_ref0 (variant);
	_g_variant_unref0 (_data_->variant);
	_data_->variant = _tmp2_;
	_mahjongg_layout_cb_co (_data_);
}

static void
_mahjongg_layout_cb_finish (Mahjongg* self,
                            GAsyncResult* _res_)
{
	MahjonggLayoutCbData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_mahjongg_layout_cb_ready (GObject* source_object,
                           GAsyncResult* _res_,
                           gpointer _user_data_)
{
	MahjonggLayoutCbData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_mahjongg_layout_cb_co (_data_);
}

static gboolean
_mahjongg_layout_cb_co (MahjonggLayoutCbData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_variant_get_string (_data_->variant, NULL);
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->layout = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->settings;
	_data_->_tmp3_ = g_settings_get_string (_data_->_tmp2_, "mapset");
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->layout;
	_data_->_tmp6_ = g_strcmp0 (_data_->_tmp4_, _data_->_tmp5_) != 0;
	_g_free0 (_data_->_tmp4_);
	if (_data_->_tmp6_) {
		_data_->_tmp7_ = _data_->self->priv->game;
		_data_->_tmp8_ = game_get_started (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		if (_data_->_tmp9_) {
			_data_->_tmp10_ = g_strdup ("cancel");
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Change Layout?"), _ ("This will end your current game."));
			adw_alert_dialog_set_default_response (_data_->_tmp11_, _data_->_tmp10_);
			_g_free0 (_data_->_tmp10_);
			g_object_ref_sink (_data_->_tmp11_);
			_data_->dialog = _data_->_tmp11_;
			_data_->_tmp12_ = _data_->dialog;
			adw_alert_dialog_add_response (_data_->_tmp12_, "cancel", _ ("_Cancel"));
			_data_->_tmp13_ = _data_->dialog;
			adw_alert_dialog_add_response (_data_->_tmp13_, "change_layout", _ ("Change _Layout"));
			_data_->_tmp14_ = _data_->dialog;
			adw_alert_dialog_set_response_appearance (_data_->_tmp14_, "change_layout", ADW_RESPONSE_DESTRUCTIVE);
			_data_->_tmp15_ = _data_->dialog;
			_data_->_tmp16_ = gtk_application_get_active_window ((GtkApplication*) _data_->self);
			_data_->_tmp17_ = _data_->_tmp16_;
			_data_->_state_ = 1;
			adw_alert_dialog_choose (_data_->_tmp15_, (GtkWidget*) _data_->_tmp17_, NULL, _mahjongg_layout_cb_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp18_ = adw_alert_dialog_choose_finish (_data_->_tmp15_, _data_->_res_);
			_data_->_tmp19_ = g_strdup (_data_->_tmp18_);
			_data_->resp_id = _data_->_tmp19_;
			_data_->_tmp20_ = _data_->resp_id;
			if (g_strcmp0 (_data_->_tmp20_, "change_layout") != 0) {
				_g_free0 (_data_->resp_id);
				_g_object_unref0 (_data_->dialog);
				_g_free0 (_data_->layout);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_free0 (_data_->resp_id);
			_g_object_unref0 (_data_->dialog);
		}
		_data_->_tmp21_ = _data_->self->priv->settings;
		_data_->_tmp22_ = _data_->layout;
		g_settings_set_string (_data_->_tmp21_, "mapset", _data_->_tmp22_);
		_data_->_tmp23_ = _data_->self->priv->settings;
		g_settings_apply (_data_->_tmp23_);
		_data_->rotate_map = FALSE;
		mahjongg_new_game (_data_->self, _data_->rotate_map, FALSE);
	}
	g_simple_action_set_state (_data_->action, _data_->variant);
	_g_free0 (_data_->layout);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mahjongg_layout_cb (Mahjongg* self,
                    GSimpleAction* action,
                    GVariant* variant)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (variant != NULL);
	_mahjongg_layout_cb (self, action, variant, NULL, NULL);
}

static void
mahjongg_layout_progression_cb (Mahjongg* self,
                                GSimpleAction* action,
                                GVariant* variant)
{
	gchar* layout_progression = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (variant != NULL);
	_tmp0_ = g_variant_get_string (variant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	layout_progression = _tmp1_;
	g_simple_action_set_state (action, variant);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_string (_tmp2_, "map-rotation");
	_tmp4_ = _tmp3_;
	_tmp5_ = layout_progression;
	_tmp6_ = g_strcmp0 (_tmp4_, _tmp5_) != 0;
	_g_free0 (_tmp4_);
	if (_tmp6_) {
		GSettings* _tmp7_;
		const gchar* _tmp8_;
		GSettings* _tmp9_;
		_tmp7_ = self->priv->settings;
		_tmp8_ = layout_progression;
		g_settings_set_string (_tmp7_, "map-rotation", _tmp8_);
		_tmp9_ = self->priv->settings;
		g_settings_apply (_tmp9_);
	}
	_g_free0 (layout_progression);
}

static void
mahjongg_background_color_cb (Mahjongg* self,
                              GSimpleAction* action,
                              GVariant* variant)
{
	gchar* background_color = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (variant != NULL);
	_tmp0_ = g_variant_get_string (variant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	background_color = _tmp1_;
	g_simple_action_set_state (action, variant);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_string (_tmp2_, "background-color");
	_tmp4_ = _tmp3_;
	_tmp5_ = background_color;
	_tmp6_ = g_strcmp0 (_tmp4_, _tmp5_) != 0;
	_g_free0 (_tmp4_);
	if (_tmp6_) {
		GSettings* _tmp7_;
		const gchar* _tmp8_;
		GSettings* _tmp9_;
		_tmp7_ = self->priv->settings;
		_tmp8_ = background_color;
		g_settings_set_string (_tmp7_, "background-color", _tmp8_);
		_tmp9_ = self->priv->settings;
		g_settings_apply (_tmp9_);
	}
	_g_free0 (background_color);
}

static void
mahjongg_theme_cb (Mahjongg* self,
                   GSimpleAction* action,
                   GVariant* variant)
{
	gchar* theme = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (variant != NULL);
	_tmp0_ = g_variant_get_string (variant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	theme = _tmp1_;
	g_simple_action_set_state (action, variant);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_string (_tmp2_, "tileset");
	_tmp4_ = _tmp3_;
	_tmp5_ = theme;
	_tmp6_ = g_strcmp0 (_tmp4_, _tmp5_) != 0;
	_g_free0 (_tmp4_);
	if (_tmp6_) {
		GSettings* _tmp7_;
		const gchar* _tmp8_;
		GSettings* _tmp9_;
		_tmp7_ = self->priv->settings;
		_tmp8_ = theme;
		g_settings_set_string (_tmp7_, "tileset", _tmp8_);
		_tmp9_ = self->priv->settings;
		g_settings_apply (_tmp9_);
	}
	_g_free0 (theme);
}

static void
mahjongg_hint_cb (Mahjongg* self)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	game_show_hint (_tmp0_);
}

static void
mahjongg_shuffle_cb (Mahjongg* self)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	game_shuffle_remaining (_tmp0_);
}

static void
mahjongg_about_cb (Mahjongg* self)
{
	AdwAboutDialog* about_dialog = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gchar* _tmp35_;
	AdwAboutDialog* _tmp36_ = NULL;
	AdwAboutDialog* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar** _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	GtkWindow* _tmp43_;
	GtkWindow* _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_application_get_resource_base_path ((GApplication*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "/metainfo.xml", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup ("Copyright \302\251 1998\342\200\2232025 Mahjongg Contributors\n" \
"Copyright \302\251 1998\342\200\2232008 Free Software Foundation, Inc.");
	_tmp5_ = g_strdup ("Francisco Bustamante");
	_tmp6_ = g_strdup ("Max Watson");
	_tmp7_ = g_strdup ("Heinz Hempe");
	_tmp8_ = g_strdup ("Michael Meeks");
	_tmp9_ = g_strdup ("Philippe Chavin");
	_tmp10_ = g_strdup ("Callum McKenzie");
	_tmp11_ = g_strdup ("Robert Ancell");
	_tmp12_ = g_strdup ("Michael Catanzaro");
	_tmp13_ = g_strdup ("Mario Wenzel");
	_tmp14_ = g_strdup ("Arnaud Bonatti");
	_tmp15_ = g_strdup ("Jeremy Bicha");
	_tmp16_ = g_strdup ("Alberto Ruiz");
	_tmp17_ = g_strdup ("Günther Wagner");
	_tmp18_ = g_strdup ("Mathias Bonn");
	_tmp19_ = g_strdup ("K Davis");
	_tmp20_ = g_strdup ("François Godin");
	_tmp21_ = g_new0 (gchar*, 16 + 1);
	_tmp21_[0] = _tmp5_;
	_tmp21_[1] = _tmp6_;
	_tmp21_[2] = _tmp7_;
	_tmp21_[3] = _tmp8_;
	_tmp21_[4] = _tmp9_;
	_tmp21_[5] = _tmp10_;
	_tmp21_[6] = _tmp11_;
	_tmp21_[7] = _tmp12_;
	_tmp21_[8] = _tmp13_;
	_tmp21_[9] = _tmp14_;
	_tmp21_[10] = _tmp15_;
	_tmp21_[11] = _tmp16_;
	_tmp21_[12] = _tmp17_;
	_tmp21_[13] = _tmp18_;
	_tmp21_[14] = _tmp19_;
	_tmp21_[15] = _tmp20_;
	_tmp22_ = g_strdup ("Jonathan Buzzard");
	_tmp23_ = g_strdup ("Jaye Evins");
	_tmp24_ = g_strdup ("Richard Hoelscher");
	_tmp25_ = g_strdup ("Gonzalo Odiard");
	_tmp26_ = g_strdup ("Max Watson");
	_tmp27_ = g_strdup ("Jakub Steiner");
	_tmp28_ = g_strdup ("Rossano Rossi");
	_tmp29_ = g_strdup ("Tobias Bernard");
	_tmp30_ = g_new0 (gchar*, 8 + 1);
	_tmp30_[0] = _tmp22_;
	_tmp30_[1] = _tmp23_;
	_tmp30_[2] = _tmp24_;
	_tmp30_[3] = _tmp25_;
	_tmp30_[4] = _tmp26_;
	_tmp30_[5] = _tmp27_;
	_tmp30_[6] = _tmp28_;
	_tmp30_[7] = _tmp29_;
	_tmp31_ = g_strdup ("Tiffany Antopolski");
	_tmp32_ = g_strdup ("Chris Beiser");
	_tmp33_ = g_strdup ("Andre Klapper");
	_tmp34_ = g_new0 (gchar*, 3 + 1);
	_tmp34_[0] = _tmp31_;
	_tmp34_[1] = _tmp32_;
	_tmp34_[2] = _tmp33_;
	_tmp35_ = g_strdup (_ ("translator-credits"));
	_tmp36_ = (AdwAboutDialog*) adw_about_dialog_new_from_appdata (_tmp3_, VERSION);
	adw_about_dialog_set_copyright (_tmp36_, _tmp4_);
	_g_free0 (_tmp4_);
	adw_about_dialog_set_developers (_tmp36_, _tmp21_);
	_tmp21_ = (_vala_array_free (_tmp21_, 16, (GDestroyNotify) g_free), NULL);
	adw_about_dialog_set_artists (_tmp36_, _tmp30_);
	_tmp30_ = (_vala_array_free (_tmp30_, 8, (GDestroyNotify) g_free), NULL);
	adw_about_dialog_set_documenters (_tmp36_, _tmp34_);
	_tmp34_ = (_vala_array_free (_tmp34_, 3, (GDestroyNotify) g_free), NULL);
	adw_about_dialog_set_translator_credits (_tmp36_, _tmp35_);
	_g_free0 (_tmp35_);
	g_object_ref_sink (_tmp36_);
	_tmp37_ = _tmp36_;
	_g_free0 (_tmp3_);
	about_dialog = _tmp37_;
	_tmp38_ = g_strdup ("Rexford Newbould");
	_tmp39_ = g_strdup ("Krzysztof Foltman");
	_tmp40_ = g_strdup ("Sapphire Becker");
	_tmp41_ = g_new0 (gchar*, 3 + 1);
	_tmp41_[0] = _tmp38_;
	_tmp41_[1] = _tmp39_;
	_tmp41_[2] = _tmp40_;
	_tmp42_ = _tmp41_;
	_tmp42__length1 = 3;
	adw_about_dialog_add_credit_section (about_dialog, _ ("Layouts by"), _tmp42_);
	_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
	_tmp43_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp44_ = _tmp43_;
	adw_dialog_present ((AdwDialog*) about_dialog, (GtkWidget*) _tmp44_);
	_g_object_unref0 (about_dialog);
}

static void
mahjongg_pause_cb (Mahjongg* self)
{
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	game_set_paused (_tmp0_, !_tmp3_);
}

static void
mahjongg_scores_cb (Mahjongg* self)
{
	Game* _tmp0_;
	Map* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->map;
	_tmp2_ = _tmp1_->score_name;
	mahjongg_show_scores (self, _tmp2_, NULL);
}

static void
mahjongg_new_game_cb (Mahjongg* self)
{
	g_return_if_fail (self != NULL);
	mahjongg_new_game (self, TRUE, FALSE);
}

static void
mahjongg_restart_game_cb (Mahjongg* self)
{
	Game* _tmp0_;
	GameSave* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	game_restart (_tmp0_);
	_tmp1_ = self->priv->game_save;
	game_save_delete (_tmp1_);
}

static void
mahjongg_redo_cb (Mahjongg* self)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	game_redo (_tmp0_);
}

static void
mahjongg_undo_cb (Mahjongg* self)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	game_undo (_tmp0_);
}

static Map*
mahjongg_next_map (Mahjongg* self,
                   gboolean rotate_map)
{
	Map* map = NULL;
	Maps* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	Map* _tmp4_;
	Map* _tmp5_;
	Map* _tmp6_;
	GSettings* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	Map* _tmp22_;
	const gchar* _tmp23_;
	gboolean _tmp24_;
	Map* _tmp34_;
	Map* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->maps;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "mapset");
	_tmp3_ = _tmp2_;
	_tmp4_ = maps_get_map_by_name (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	map = _tmp5_;
	_tmp6_ = map;
	if (_tmp6_ == NULL) {
		Maps* _tmp7_;
		Map* _tmp8_;
		_tmp7_ = self->priv->maps;
		_tmp8_ = maps_get_map_at_position (_tmp7_, 0);
		map = _tmp8_;
	}
	if (rotate_map) {
		GSettings* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GQuark _tmp13_ = 0U;
		static GQuark _tmp12_label0 = 0;
		static GQuark _tmp12_label1 = 0;
		_tmp9_ = self->priv->settings;
		_tmp10_ = g_settings_get_string (_tmp9_, "map-rotation");
		_tmp11_ = _tmp10_;
		_tmp13_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
		g_free (_tmp11_);
		if (_tmp13_ == ((0 != _tmp12_label0) ? _tmp12_label0 : (_tmp12_label0 = g_quark_from_static_string ("sequential")))) {
			switch (0) {
				default:
				{
					Maps* _tmp14_;
					Map* _tmp15_;
					Map* _tmp16_;
					_tmp14_ = self->priv->maps;
					_tmp15_ = map;
					_tmp16_ = maps_get_next_map (_tmp14_, _tmp15_);
					map = _tmp16_;
					break;
				}
			}
		} else if (_tmp13_ == ((0 != _tmp12_label1) ? _tmp12_label1 : (_tmp12_label1 = g_quark_from_static_string ("random")))) {
			switch (0) {
				default:
				{
					Maps* _tmp17_;
					Map* _tmp18_;
					_tmp17_ = self->priv->maps;
					_tmp18_ = maps_get_random_map (_tmp17_);
					map = _tmp18_;
					break;
				}
			}
		}
	}
	_tmp19_ = self->priv->settings;
	_tmp20_ = g_settings_get_string (_tmp19_, "mapset");
	_tmp21_ = _tmp20_;
	_tmp22_ = map;
	_tmp23_ = _tmp22_->name;
	_tmp24_ = g_strcmp0 (_tmp21_, _tmp23_) != 0;
	_g_free0 (_tmp21_);
	if (_tmp24_) {
		GSimpleAction* layout_action = NULL;
		GAction* _tmp25_;
		GSimpleAction* _tmp26_;
		Map* _tmp27_;
		const gchar* _tmp28_;
		GVariant* _tmp29_;
		GVariant* _tmp30_;
		GSettings* _tmp31_;
		Map* _tmp32_;
		const gchar* _tmp33_;
		_tmp25_ = g_action_map_lookup_action ((GActionMap*) self, "layout");
		layout_action = G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp25_) : NULL;
		_tmp26_ = layout_action;
		_tmp27_ = map;
		_tmp28_ = _tmp27_->name;
		_tmp29_ = g_variant_new_string (_tmp28_);
		g_variant_ref_sink (_tmp29_);
		_tmp30_ = _tmp29_;
		g_simple_action_set_state (_tmp26_, _tmp30_);
		_g_variant_unref0 (_tmp30_);
		_tmp31_ = self->priv->settings;
		_tmp32_ = map;
		_tmp33_ = _tmp32_->name;
		g_settings_set_string (_tmp31_, "mapset", _tmp33_);
	}
	_tmp34_ = map;
	result = _tmp34_;
	return result;
}

static gpointer
_map_ref0 (gpointer self)
{
	return self ? map_ref (self) : NULL;
}

static gboolean
_mahjongg_attempt_move_cb_game_attempt_move (Game* _sender,
                                             gpointer self)
{
	gboolean result;
	result = mahjongg_attempt_move_cb ((Mahjongg*) self);
	return result;
}

static void
_mahjongg_moved_cb_game_moved (Game* _sender,
                               gpointer self)
{
	mahjongg_moved_cb ((Mahjongg*) self, NULL, NULL);
}

static void
_mahjongg_paused_changed_cb_game_paused_changed (Game* _sender,
                                                 gpointer self)
{
	mahjongg_paused_changed_cb ((Mahjongg*) self);
}

static void
mahjongg_new_game (Mahjongg* self,
                   gboolean rotate_map,
                   gboolean restore)
{
	MahjonggWindow* window = NULL;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	MahjonggWindow* _tmp2_;
	Map* map = NULL;
	Map* _tmp9_;
	Game* _tmp12_;
	Map* _tmp14_;
	Game* _tmp15_;
	MahjonggWindow* _tmp16_;
	Game* _tmp17_;
	Game* _tmp18_;
	Game* _tmp19_;
	Game* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (IS_MAHJONGG_WINDOW (_tmp1_) ? ((MahjonggWindow*) _tmp1_) : NULL);
	window = _tmp2_;
	map = NULL;
	if (restore) {
		GameSave* _tmp3_;
		Maps* _tmp4_;
		GameSave* _tmp5_;
		Map* _tmp6_;
		Map* _tmp7_;
		_tmp3_ = self->priv->game_save;
		_tmp4_ = self->priv->maps;
		restore = game_save_load (_tmp3_, _tmp4_);
		_tmp5_ = self->priv->game_save;
		_tmp6_ = _tmp5_->map;
		_tmp7_ = _map_ref0 (_tmp6_);
		_map_unref0 (map);
		map = _tmp7_;
	} else {
		GameSave* _tmp8_;
		_tmp8_ = self->priv->game_save;
		game_save_delete (_tmp8_);
	}
	_tmp9_ = map;
	if (_tmp9_ == NULL) {
		Map* _tmp10_;
		Map* _tmp11_;
		_tmp10_ = mahjongg_next_map (self, rotate_map);
		_tmp11_ = _map_ref0 (_tmp10_);
		_map_unref0 (map);
		map = _tmp11_;
	}
	_tmp12_ = self->priv->game;
	if (_tmp12_ != NULL) {
		Game* _tmp13_;
		_tmp13_ = self->priv->game;
		game_destroy_timers (_tmp13_);
	}
	_tmp14_ = map;
	_tmp15_ = game_new (_tmp14_);
	_game_unref0 (self->priv->game);
	self->priv->game = _tmp15_;
	_tmp16_ = window;
	_tmp17_ = self->priv->game;
	mahjongg_window_new_game (_tmp16_, _tmp17_, rotate_map);
	_tmp18_ = self->priv->game;
	g_signal_connect_object (_tmp18_, "attempt-move", (GCallback) _mahjongg_attempt_move_cb_game_attempt_move, self, 0);
	_tmp19_ = self->priv->game;
	g_signal_connect_object (_tmp19_, "moved", (GCallback) _mahjongg_moved_cb_game_moved, self, 0);
	_tmp20_ = self->priv->game;
	g_signal_connect_object (_tmp20_, "paused-changed", (GCallback) _mahjongg_paused_changed_cb_game_paused_changed, self, 0);
	if (restore) {
		Game* _tmp21_;
		GameSave* _tmp22_;
		_tmp21_ = self->priv->game;
		_tmp22_ = self->priv->game_save;
		game_restore (_tmp21_, _tmp22_);
	} else {
		Game* _tmp23_;
		_tmp23_ = self->priv->game;
		game_generate (_tmp23_, (gint32) -1);
	}
	_map_unref0 (map);
	_g_object_unref0 (window);
}

static void
mahjongg_rules_cb (Mahjongg* self)
{
	RulesDialog* _tmp0_;
	RulesDialog* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = rules_dialog_new ();
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp3_ = _tmp2_;
	adw_dialog_present ((AdwDialog*) _tmp1_, (GtkWidget*) _tmp3_);
	_g_object_unref0 (_tmp1_);
}

static gint
mahjongg_main (gchar** args,
               gint args_length1)
{
	Mahjongg* app = NULL;
	Mahjongg* _tmp0_;
	gint _result_ = 0;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name (_ ("Mahjongg"));
	g_type_ensure (TYPE_GAME_VIEW);
	_tmp0_ = mahjongg_new ();
	app = _tmp0_;
	_result_ = g_application_run ((GApplication*) app, (gint) args_length1, args);
	g_settings_sync ();
	result = _result_;
	_g_object_unref0 (app);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return mahjongg_main (argv, argc);
}

static void
mahjongg_class_init (MahjonggClass * klass,
                     gpointer klass_data)
{
	mahjongg_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Mahjongg_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) mahjongg_real_startup;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) mahjongg_real_handle_local_options;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) mahjongg_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) mahjongg_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = mahjongg_finalize;
}

static void
mahjongg_instance_init (Mahjongg * self,
                        gpointer klass)
{
	self->priv = mahjongg_get_instance_private (self);
}

static void
mahjongg_finalize (GObject * obj)
{
	Mahjongg * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAHJONGG, Mahjongg);
	_game_unref0 (self->priv->game);
	_game_save_unref0 (self->priv->game_save);
	_maps_unref0 (self->priv->maps);
	_history_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (mahjongg_parent_class)->finalize (obj);
}

static GType
mahjongg_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MahjonggClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mahjongg_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mahjongg), 0, (GInstanceInitFunc) mahjongg_instance_init, NULL };
	GType mahjongg_type_id;
	mahjongg_type_id = g_type_register_static (adw_application_get_type (), "Mahjongg", &g_define_type_info, 0);
	Mahjongg_private_offset = g_type_add_instance_private (mahjongg_type_id, sizeof (MahjonggPrivate));
	return mahjongg_type_id;
}

GType
mahjongg_get_type (void)
{
	static volatile gsize mahjongg_type_id__once = 0;
	if (g_once_init_enter (&mahjongg_type_id__once)) {
		GType mahjongg_type_id;
		mahjongg_type_id = mahjongg_get_type_once ();
		g_once_init_leave (&mahjongg_type_id__once, mahjongg_type_id);
	}
	return mahjongg_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

