/* snapshot.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from snapshot.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GAMES_SNAPSHOT_0_PROPERTY,
	GAMES_SNAPSHOT_PATH_PROPERTY,
	GAMES_SNAPSHOT_PLATFORM_PROPERTY,
	GAMES_SNAPSHOT_CORE_PROPERTY,
	GAMES_SNAPSHOT_IS_AUTOMATIC_PROPERTY,
	GAMES_SNAPSHOT_NAME_PROPERTY,
	GAMES_SNAPSHOT_CREATION_DATE_PROPERTY,
	GAMES_SNAPSHOT_SCREENSHOT_ASPECT_RATIO_PROPERTY,
	GAMES_SNAPSHOT_NUM_PROPERTIES
};
static GParamSpec* games_snapshot_properties[GAMES_SNAPSHOT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))

struct _GamesSnapshotPrivate {
	gchar* _path;
	GamesPlatform* _platform;
	gchar* _core;
	gboolean _is_automatic;
	gchar* _name;
	GDateTime* _creation_date;
	gdouble _screenshot_aspect_ratio;
};

static gint GamesSnapshot_private_offset;
static gpointer games_snapshot_parent_class = NULL;

static void games_snapshot_load_keyfile (GamesSnapshot* self);
static void games_snapshot_real_load_metadata (GamesSnapshot* self,
                                        GKeyFile* keyfile,
                                        GError** error);
static void games_snapshot_real_save_metadata (GamesSnapshot* self,
                                        GKeyFile* keyfile);
static void games_snapshot_finalize (GObject * obj);
static GType games_snapshot_get_type_once (void);
static void _vala_games_snapshot_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_games_snapshot_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
games_snapshot_get_instance_private (GamesSnapshot* self)
{
	return G_STRUCT_MEMBER_P (self, GamesSnapshot_private_offset);
}

GamesSnapshot*
games_snapshot_load (GamesPlatform* platform,
                     const gchar* core_id,
                     const gchar* path)
{
	GType type = 0UL;
	GamesSnapshot* snapshot = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GamesSnapshot* _tmp2_;
	GamesSnapshot* result;
	g_return_val_if_fail (platform != NULL, NULL);
	g_return_val_if_fail (core_id != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	type = games_platform_get_snapshot_type (platform);
	_tmp0_ = g_object_new (type, "path", path, "platform", platform, "core", core_id, NULL, NULL);
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
	_tmp2_ = GAMES_IS_SNAPSHOT (_tmp1_) ? ((GamesSnapshot*) _tmp1_) : NULL;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_tmp1_);
	}
	snapshot = _tmp2_;
	games_snapshot_load_keyfile (snapshot);
	result = snapshot;
	return result;
}

static void
games_snapshot_load_keyfile (GamesSnapshot* self)
{
	gchar* metadata_file_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* metadata_file = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_path;
	_tmp1_ = g_build_filename (_tmp0_, "metadata", NULL);
	metadata_file_path = _tmp1_;
	_tmp2_ = metadata_file_path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	metadata_file = _tmp3_;
	_tmp4_ = metadata_file;
	if (!g_file_query_exists (_tmp4_, NULL)) {
		_g_object_unref0 (metadata_file);
		_g_free0 (metadata_file_path);
		return;
	}
	_tmp5_ = g_key_file_new ();
	keyfile = _tmp5_;
	{
		GKeyFile* _tmp6_;
		const gchar* _tmp7_;
		GKeyFile* _tmp8_;
		_tmp6_ = keyfile;
		_tmp7_ = metadata_file_path;
		g_key_file_load_from_file (_tmp6_, _tmp7_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = keyfile;
		games_snapshot_load_metadata (self, _tmp8_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = self->priv->_path;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("snapshot.vala:44: Failed to load metadata for snapshot at %s: %s", _tmp9_, _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (keyfile);
		_g_object_unref0 (metadata_file);
		_g_free0 (metadata_file_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_key_file_unref0 (keyfile);
	_g_object_unref0 (metadata_file);
	_g_free0 (metadata_file_path);
}

gchar*
games_snapshot_get_snapshot_path (GamesSnapshot* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	_tmp1_ = g_build_filename (_tmp0_, "snapshot", NULL);
	result = _tmp1_;
	return result;
}

gchar*
games_snapshot_get_save_ram_path (GamesSnapshot* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	_tmp1_ = g_build_filename (_tmp0_, "save", NULL);
	result = _tmp1_;
	return result;
}

gchar*
games_snapshot_get_screenshot_path (GamesSnapshot* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	_tmp1_ = g_build_filename (_tmp0_, "screenshot", NULL);
	result = _tmp1_;
	return result;
}

gchar*
games_snapshot_get_save_directory_path (GamesSnapshot* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	_tmp1_ = g_build_filename (_tmp0_, "save-dir", NULL);
	result = _tmp1_;
	return result;
}

gboolean
games_snapshot_has_media_data (GamesSnapshot* self)
{
	gchar* media_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_path;
	_tmp1_ = g_build_filename (_tmp0_, "media", NULL);
	media_path = _tmp1_;
	result = g_file_test (media_path, G_FILE_TEST_EXISTS);
	_g_free0 (media_path);
	return result;
}

gint
games_snapshot_get_media_data (GamesSnapshot* self,
                               GError** error)
{
	gchar* media_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* contents = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gint media_number = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_path;
	_tmp1_ = g_build_filename (_tmp0_, "media", NULL);
	media_path = _tmp1_;
	_tmp2_ = media_path;
	if (!g_file_test (_tmp2_, G_FILE_TEST_EXISTS)) {
		const gchar* _tmp3_;
		GError* _tmp4_;
		gint _tmp5_ = -1;
		_tmp3_ = self->priv->_path;
		_tmp4_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_ACCES, "Snapshot at %s does not contain media file", _tmp3_);
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (media_path);
		return _tmp5_;
	}
	_tmp6_ = media_path;
	g_file_get_contents (_tmp6_, &_tmp7_, NULL, &_inner_error0_);
	_g_free0 (contents);
	contents = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp8_ = -1;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (contents);
		_g_free0 (media_path);
		return _tmp8_;
	}
	media_number = atoi (contents);
	result = media_number;
	_g_free0 (contents);
	_g_free0 (media_path);
	return result;
}

void
games_snapshot_set_media_data (GamesSnapshot* self,
                               GamesMediaSet* media_set,
                               GError** error)
{
	gchar* media_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* contents = NULL;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (media_set != NULL);
	_tmp0_ = self->priv->_path;
	_tmp1_ = g_build_filename (_tmp0_, "media", NULL);
	media_path = _tmp1_;
	_tmp2_ = games_media_set_get_selected_media_number (media_set);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	contents = _tmp4_;
	_tmp5_ = strlen (contents);
	_tmp6_ = _tmp5_;
	g_file_set_contents (media_path, contents, (gssize) _tmp6_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (contents);
		_g_free0 (media_path);
		return;
	}
	_g_free0 (contents);
	_g_free0 (media_path);
}

static void
games_snapshot_real_load_metadata (GamesSnapshot* self,
                                   GKeyFile* keyfile,
                                   GError** error)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gchar* creation_date_str = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GTimeZone* _tmp6_;
	GTimeZone* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (keyfile != NULL);
	_tmp0_ = g_key_file_get_boolean (keyfile, "Metadata", "Automatic", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	games_snapshot_set_is_automatic (self, _tmp0_);
	_tmp1_ = self->priv->_is_automatic;
	if (_tmp1_) {
		games_snapshot_set_name (self, NULL);
	} else {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp3_ = g_key_file_get_string (keyfile, "Metadata", "Name", &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		games_snapshot_set_name (self, _tmp2_);
		_g_free0 (_tmp2_);
	}
	_tmp4_ = g_key_file_get_string (keyfile, "Metadata", "Creation Date", &_inner_error0_);
	creation_date_str = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp5_ = creation_date_str;
	_tmp6_ = g_time_zone_new_local ();
	_tmp7_ = _tmp6_;
	_tmp8_ = g_date_time_new_from_iso8601 (_tmp5_, _tmp7_);
	_tmp9_ = _tmp8_;
	games_snapshot_set_creation_date (self, _tmp9_);
	_g_date_time_unref0 (_tmp9_);
	_g_time_zone_unref0 (_tmp7_);
	if (g_key_file_has_group (keyfile, "Screenshot")) {
		gdouble _tmp10_ = 0.0;
		_tmp10_ = g_key_file_get_double (keyfile, "Screenshot", "Aspect Ratio", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (creation_date_str);
				return;
			} else {
				_g_free0 (creation_date_str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		games_snapshot_set_screenshot_aspect_ratio (self, _tmp10_);
	} else {
		games_snapshot_set_screenshot_aspect_ratio (self, (gdouble) 0);
	}
	_g_free0 (creation_date_str);
}

void
games_snapshot_load_metadata (GamesSnapshot* self,
                              GKeyFile* keyfile,
                              GError** error)
{
	GamesSnapshotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GAMES_SNAPSHOT_GET_CLASS (self);
	if (_klass_->load_metadata) {
		_klass_->load_metadata (self, keyfile, error);
	}
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static void
games_snapshot_real_save_metadata (GamesSnapshot* self,
                                   GKeyFile* keyfile)
{
	gboolean _tmp0_;
	const gchar* _tmp1_;
	GDateTime* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GamesPlatform* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gdouble _tmp10_;
	g_return_if_fail (keyfile != NULL);
	_tmp0_ = self->priv->_is_automatic;
	g_key_file_set_boolean (keyfile, "Metadata", "Automatic", _tmp0_);
	_tmp1_ = self->priv->_name;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_name;
		g_key_file_set_string (keyfile, "Metadata", "Name", _tmp2_);
	}
	_tmp3_ = self->priv->_creation_date;
	_tmp4_ = g_date_time_to_string (_tmp3_);
	_tmp5_ = _tmp4_;
	g_key_file_set_string (keyfile, "Metadata", "Creation Date", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->_platform;
	_tmp7_ = games_platform_get_uid_prefix (_tmp6_);
	_tmp8_ = _tmp7_;
	g_key_file_set_string (keyfile, "Metadata", "Platform", _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->priv->_core;
	g_key_file_set_string (keyfile, "Metadata", "Core", _tmp9_);
	_tmp10_ = self->priv->_screenshot_aspect_ratio;
	g_key_file_set_double (keyfile, "Screenshot", "Aspect Ratio", _tmp10_);
}

void
games_snapshot_save_metadata (GamesSnapshot* self,
                              GKeyFile* keyfile)
{
	GamesSnapshotClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GAMES_SNAPSHOT_GET_CLASS (self);
	if (_klass_->save_metadata) {
		_klass_->save_metadata (self, keyfile);
	}
}

void
games_snapshot_write_metadata (GamesSnapshot* self,
                               GError** error)
{
	gchar* metadata_file_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* metadata_file = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GKeyFile* metadata = NULL;
	GKeyFile* _tmp4_;
	GFile* _tmp5_;
	GKeyFile* _tmp7_;
	GKeyFile* _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_path;
	_tmp1_ = g_build_filename (_tmp0_, "metadata", NULL);
	metadata_file_path = _tmp1_;
	_tmp2_ = metadata_file_path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	metadata_file = _tmp3_;
	_tmp4_ = g_key_file_new ();
	metadata = _tmp4_;
	_tmp5_ = metadata_file;
	if (g_file_query_exists (_tmp5_, NULL)) {
		GFile* _tmp6_;
		_tmp6_ = metadata_file;
		g_file_delete (_tmp6_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_key_file_unref0 (metadata);
			_g_object_unref0 (metadata_file);
			_g_free0 (metadata_file_path);
			return;
		}
	}
	_tmp7_ = metadata;
	games_snapshot_save_metadata (self, _tmp7_);
	_tmp8_ = metadata;
	_tmp9_ = metadata_file_path;
	g_key_file_save_to_file (_tmp8_, _tmp9_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_key_file_unref0 (metadata);
		_g_object_unref0 (metadata_file);
		_g_free0 (metadata_file_path);
		return;
	}
	_g_key_file_unref0 (metadata);
	_g_object_unref0 (metadata_file);
	_g_free0 (metadata_file_path);
}

void
games_snapshot_delete_from_disk (GamesSnapshot* self)
{
	GFile* snapshot_dir = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	snapshot_dir = _tmp1_;
	{
		gchar** _tmp2_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = g_new0 (gchar*, 0 + 1);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 0;
		games_file_operations_delete_files (snapshot_dir, _tmp3_, (gint) 0, &_inner_error0_);
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = self->priv->_path;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("snapshot.vala:146: Failed to delete snapshot at %s: %s", _tmp4_, _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (snapshot_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (snapshot_dir);
}

GamesSnapshot*
games_snapshot_create_empty (GamesGame* game,
                             const gchar* core_id,
                             const gchar* path,
                             GError** error)
{
	guint32 random = 0U;
	gchar* cache_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* tmp_path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GFile* dir = NULL;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* save_dir = NULL;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GamesPlatform* _tmp15_;
	GamesPlatform* _tmp16_;
	const gchar* _tmp17_;
	GamesSnapshot* _tmp18_;
	GError* _inner_error0_ = NULL;
	GamesSnapshot* result;
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (core_id != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	random = g_random_int ();
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	cache_path = _tmp1_;
	_tmp2_ = cache_path;
	_tmp3_ = g_strdup_printf ("%u", random);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("snapshot-", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_build_filename (_tmp2_, "gnome-games", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	tmp_path = _tmp8_;
	_tmp9_ = tmp_path;
	_tmp10_ = g_file_new_for_path (_tmp9_);
	dir = _tmp10_;
	_tmp11_ = dir;
	g_file_make_directory (_tmp11_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dir);
		_g_free0 (tmp_path);
		_g_free0 (cache_path);
		return NULL;
	}
	_tmp12_ = dir;
	_tmp13_ = g_file_get_child (_tmp12_, "save-dir");
	save_dir = _tmp13_;
	_tmp14_ = save_dir;
	g_file_make_directory (_tmp14_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (save_dir);
		_g_object_unref0 (dir);
		_g_free0 (tmp_path);
		_g_free0 (cache_path);
		return NULL;
	}
	_tmp15_ = games_game_get_platform (game);
	_tmp16_ = _tmp15_;
	_tmp17_ = tmp_path;
	_tmp18_ = games_snapshot_load (_tmp16_, core_id, _tmp17_);
	result = _tmp18_;
	_g_object_unref0 (save_dir);
	_g_object_unref0 (dir);
	_g_free0 (tmp_path);
	_g_free0 (cache_path);
	return result;
}

GamesSnapshot*
games_snapshot_move_to (GamesSnapshot* self,
                        const gchar* dest_path,
                        GError** error)
{
	GFile* current_dir = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* dest_dir = NULL;
	GFile* _tmp2_;
	gchar* dest = NULL;
	gchar* _tmp3_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GamesPlatform* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GamesSnapshot* _tmp14_;
	GError* _inner_error0_ = NULL;
	GamesSnapshot* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dest_path != NULL, NULL);
	_tmp0_ = self->priv->_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	current_dir = _tmp1_;
	_tmp2_ = g_file_new_for_path (dest_path);
	dest_dir = _tmp2_;
	_tmp3_ = g_strdup (dest_path);
	dest = _tmp3_;
	while (TRUE) {
		GFile* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		GFile* _tmp8_;
		_tmp4_ = dest_dir;
		if (!g_file_query_exists (_tmp4_, NULL)) {
			break;
		}
		_tmp5_ = dest;
		_tmp6_ = g_strconcat (_tmp5_, "_", NULL);
		_g_free0 (dest);
		dest = _tmp6_;
		_tmp7_ = dest;
		_tmp8_ = g_file_new_for_path (_tmp7_);
		_g_object_unref0 (dest_dir);
		dest_dir = _tmp8_;
	}
	_tmp9_ = current_dir;
	_tmp10_ = dest_dir;
	g_file_move (_tmp9_, _tmp10_, G_FILE_COPY_ALL_METADATA, NULL, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (dest);
		_g_object_unref0 (dest_dir);
		_g_object_unref0 (current_dir);
		return NULL;
	}
	_tmp11_ = self->priv->_platform;
	_tmp12_ = self->priv->_core;
	_tmp13_ = dest;
	_tmp14_ = games_snapshot_load (_tmp11_, _tmp12_, _tmp13_);
	result = _tmp14_;
	_g_free0 (dest);
	_g_object_unref0 (dest_dir);
	_g_object_unref0 (current_dir);
	return result;
}

void
games_snapshot_copy_save_dir_to (GamesSnapshot* self,
                                 const gchar* dest,
                                 GError** error)
{
	GFile* save_dir_file = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* dest_file = NULL;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dest != NULL);
	_tmp0_ = games_snapshot_get_save_directory_path (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	save_dir_file = _tmp3_;
	_tmp4_ = g_file_new_for_path (dest);
	dest_file = _tmp4_;
	games_file_operations_copy_contents (save_dir_file, dest_file, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest_file);
		_g_object_unref0 (save_dir_file);
		return;
	}
	_g_object_unref0 (dest_file);
	_g_object_unref0 (save_dir_file);
}

gint
games_snapshot_compare (GamesSnapshot* s1,
                        GamesSnapshot* s2)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint result;
	g_return_val_if_fail (s1 != NULL, 0);
	g_return_val_if_fail (s2 != NULL, 0);
	_tmp0_ = s1->priv->_path;
	_tmp1_ = s2->priv->_path;
	if (g_strcmp0 (_tmp0_, _tmp1_) < 0) {
		result = 1;
		return result;
	}
	_tmp2_ = s1->priv->_path;
	_tmp3_ = s2->priv->_path;
	if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
		result = 0;
		return result;
	}
	result = -1;
	return result;
}

GamesSnapshot*
games_snapshot_construct (GType object_type)
{
	GamesSnapshot * self = NULL;
	self = (GamesSnapshot*) g_object_new (object_type, NULL);
	return self;
}

GamesSnapshot*
games_snapshot_new (void)
{
	return games_snapshot_construct (GAMES_TYPE_SNAPSHOT);
}

const gchar*
games_snapshot_get_path (GamesSnapshot* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	result = _tmp0_;
	return result;
}

static void
games_snapshot_set_path (GamesSnapshot* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_snapshot_get_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_path);
		self->priv->_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_snapshot_properties[GAMES_SNAPSHOT_PATH_PROPERTY]);
	}
}

GamesPlatform*
games_snapshot_get_platform (GamesSnapshot* self)
{
	GamesPlatform* result;
	GamesPlatform* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_platform;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_snapshot_set_platform (GamesSnapshot* self,
                             GamesPlatform* value)
{
	GamesPlatform* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_snapshot_get_platform (self);
	if (old_value != value) {
		GamesPlatform* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_platform);
		self->priv->_platform = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_snapshot_properties[GAMES_SNAPSHOT_PLATFORM_PROPERTY]);
	}
}

const gchar*
games_snapshot_get_core (GamesSnapshot* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_core;
	result = _tmp0_;
	return result;
}

static void
games_snapshot_set_core (GamesSnapshot* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_snapshot_get_core (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_core);
		self->priv->_core = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_snapshot_properties[GAMES_SNAPSHOT_CORE_PROPERTY]);
	}
}

gboolean
games_snapshot_get_is_automatic (GamesSnapshot* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_automatic;
	return result;
}

void
games_snapshot_set_is_automatic (GamesSnapshot* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = games_snapshot_get_is_automatic (self);
	if (old_value != value) {
		self->priv->_is_automatic = value;
		g_object_notify_by_pspec ((GObject *) self, games_snapshot_properties[GAMES_SNAPSHOT_IS_AUTOMATIC_PROPERTY]);
	}
}

const gchar*
games_snapshot_get_name (GamesSnapshot* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
games_snapshot_set_name (GamesSnapshot* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_snapshot_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_snapshot_properties[GAMES_SNAPSHOT_NAME_PROPERTY]);
	}
}

GDateTime*
games_snapshot_get_creation_date (GamesSnapshot* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_creation_date;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
games_snapshot_set_creation_date (GamesSnapshot* self,
                                  GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_snapshot_get_creation_date (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_creation_date);
		self->priv->_creation_date = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_snapshot_properties[GAMES_SNAPSHOT_CREATION_DATE_PROPERTY]);
	}
}

gdouble
games_snapshot_get_screenshot_aspect_ratio (GamesSnapshot* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_screenshot_aspect_ratio;
	return result;
}

void
games_snapshot_set_screenshot_aspect_ratio (GamesSnapshot* self,
                                            gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = games_snapshot_get_screenshot_aspect_ratio (self);
	if (old_value != value) {
		self->priv->_screenshot_aspect_ratio = value;
		g_object_notify_by_pspec ((GObject *) self, games_snapshot_properties[GAMES_SNAPSHOT_SCREENSHOT_ASPECT_RATIO_PROPERTY]);
	}
}

static void
games_snapshot_class_init (GamesSnapshotClass * klass,
                           gpointer klass_data)
{
	games_snapshot_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesSnapshot_private_offset);
	((GamesSnapshotClass *) klass)->load_metadata = (void (*) (GamesSnapshot*, GKeyFile*, GError**)) games_snapshot_real_load_metadata;
	((GamesSnapshotClass *) klass)->save_metadata = (void (*) (GamesSnapshot*, GKeyFile*)) games_snapshot_real_save_metadata;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_snapshot_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_snapshot_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_snapshot_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SNAPSHOT_PATH_PROPERTY, games_snapshot_properties[GAMES_SNAPSHOT_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SNAPSHOT_PLATFORM_PROPERTY, games_snapshot_properties[GAMES_SNAPSHOT_PLATFORM_PROPERTY] = g_param_spec_object ("platform", "platform", "platform", GAMES_TYPE_PLATFORM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SNAPSHOT_CORE_PROPERTY, games_snapshot_properties[GAMES_SNAPSHOT_CORE_PROPERTY] = g_param_spec_string ("core", "core", "core", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SNAPSHOT_IS_AUTOMATIC_PROPERTY, games_snapshot_properties[GAMES_SNAPSHOT_IS_AUTOMATIC_PROPERTY] = g_param_spec_boolean ("is-automatic", "is-automatic", "is-automatic", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SNAPSHOT_NAME_PROPERTY, games_snapshot_properties[GAMES_SNAPSHOT_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SNAPSHOT_CREATION_DATE_PROPERTY, games_snapshot_properties[GAMES_SNAPSHOT_CREATION_DATE_PROPERTY] = g_param_spec_boxed ("creation-date", "creation-date", "creation-date", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SNAPSHOT_SCREENSHOT_ASPECT_RATIO_PROPERTY, games_snapshot_properties[GAMES_SNAPSHOT_SCREENSHOT_ASPECT_RATIO_PROPERTY] = g_param_spec_double ("screenshot-aspect-ratio", "screenshot-aspect-ratio", "screenshot-aspect-ratio", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
games_snapshot_instance_init (GamesSnapshot * self,
                              gpointer klass)
{
	self->priv = games_snapshot_get_instance_private (self);
}

static void
games_snapshot_finalize (GObject * obj)
{
	GamesSnapshot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_SNAPSHOT, GamesSnapshot);
	_g_free0 (self->priv->_path);
	_g_object_unref0 (self->priv->_platform);
	_g_free0 (self->priv->_core);
	_g_free0 (self->priv->_name);
	_g_date_time_unref0 (self->priv->_creation_date);
	G_OBJECT_CLASS (games_snapshot_parent_class)->finalize (obj);
}

static GType
games_snapshot_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesSnapshotClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_snapshot_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSnapshot), 0, (GInstanceInitFunc) games_snapshot_instance_init, NULL };
	GType games_snapshot_type_id;
	games_snapshot_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesSnapshot", &g_define_type_info, 0);
	GamesSnapshot_private_offset = g_type_add_instance_private (games_snapshot_type_id, sizeof (GamesSnapshotPrivate));
	return games_snapshot_type_id;
}

GType
games_snapshot_get_type (void)
{
	static volatile gsize games_snapshot_type_id__once = 0;
	if (g_once_init_enter (&games_snapshot_type_id__once)) {
		GType games_snapshot_type_id;
		games_snapshot_type_id = games_snapshot_get_type_once ();
		g_once_init_leave (&games_snapshot_type_id__once, games_snapshot_type_id);
	}
	return games_snapshot_type_id__once;
}

static void
_vala_games_snapshot_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	GamesSnapshot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_SNAPSHOT, GamesSnapshot);
	switch (property_id) {
		case GAMES_SNAPSHOT_PATH_PROPERTY:
		g_value_set_string (value, games_snapshot_get_path (self));
		break;
		case GAMES_SNAPSHOT_PLATFORM_PROPERTY:
		g_value_set_object (value, games_snapshot_get_platform (self));
		break;
		case GAMES_SNAPSHOT_CORE_PROPERTY:
		g_value_set_string (value, games_snapshot_get_core (self));
		break;
		case GAMES_SNAPSHOT_IS_AUTOMATIC_PROPERTY:
		g_value_set_boolean (value, games_snapshot_get_is_automatic (self));
		break;
		case GAMES_SNAPSHOT_NAME_PROPERTY:
		g_value_set_string (value, games_snapshot_get_name (self));
		break;
		case GAMES_SNAPSHOT_CREATION_DATE_PROPERTY:
		g_value_set_boxed (value, games_snapshot_get_creation_date (self));
		break;
		case GAMES_SNAPSHOT_SCREENSHOT_ASPECT_RATIO_PROPERTY:
		g_value_set_double (value, games_snapshot_get_screenshot_aspect_ratio (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_snapshot_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	GamesSnapshot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_SNAPSHOT, GamesSnapshot);
	switch (property_id) {
		case GAMES_SNAPSHOT_PATH_PROPERTY:
		games_snapshot_set_path (self, g_value_get_string (value));
		break;
		case GAMES_SNAPSHOT_PLATFORM_PROPERTY:
		games_snapshot_set_platform (self, g_value_get_object (value));
		break;
		case GAMES_SNAPSHOT_CORE_PROPERTY:
		games_snapshot_set_core (self, g_value_get_string (value));
		break;
		case GAMES_SNAPSHOT_IS_AUTOMATIC_PROPERTY:
		games_snapshot_set_is_automatic (self, g_value_get_boolean (value));
		break;
		case GAMES_SNAPSHOT_NAME_PROPERTY:
		games_snapshot_set_name (self, g_value_get_string (value));
		break;
		case GAMES_SNAPSHOT_CREATION_DATE_PROPERTY:
		games_snapshot_set_creation_date (self, g_value_get_boxed (value));
		break;
		case GAMES_SNAPSHOT_SCREENSHOT_ASPECT_RATIO_PROPERTY:
		games_snapshot_set_screenshot_aspect_ratio (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

