/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "calls-emergency-call-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_id,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Calls.EmergencyCalls
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CallsDBusEmergencyCalls
 * @title: CallsDBusEmergencyCalls
 * @short_description: Generated C code for the org.gnome.Calls.EmergencyCalls D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Calls-EmergencyCalls.top_of_page">org.gnome.Calls.EmergencyCalls</link> D-Bus interface in C.
 */

enum
{
  CALLS_DBUS__EMERGENCY_CALLS_EMERGENCY_NUMBERS_CHANGED,
};

static unsigned CALLS_DBUS__EMERGENCY_CALLS_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.gnome.Calls.EmergencyCalls ---- */

static const _ExtendedGDBusArgInfo _calls_dbus_emergency_calls_method_info_get_emergency_contacts_OUT_ARG_contacts =
{
  {
    -1,
    (gchar *) "contacts",
    (gchar *) "a(ssia{sv})",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _calls_dbus_emergency_calls_method_info_get_emergency_contacts_OUT_ARG_pointers[] =
{
  &_calls_dbus_emergency_calls_method_info_get_emergency_contacts_OUT_ARG_contacts.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _calls_dbus_emergency_calls_method_info_get_emergency_contacts =
{
  {
    -1,
    (gchar *) "GetEmergencyContacts",
    NULL,
    (GDBusArgInfo **) &_calls_dbus_emergency_calls_method_info_get_emergency_contacts_OUT_ARG_pointers,
    NULL
  },
  "handle-get-emergency-contacts",
  FALSE
};

static const _ExtendedGDBusArgInfo _calls_dbus_emergency_calls_method_info_call_emergency_contact_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _calls_dbus_emergency_calls_method_info_call_emergency_contact_IN_ARG_pointers[] =
{
  &_calls_dbus_emergency_calls_method_info_call_emergency_contact_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _calls_dbus_emergency_calls_method_info_call_emergency_contact =
{
  {
    -1,
    (gchar *) "CallEmergencyContact",
    (GDBusArgInfo **) &_calls_dbus_emergency_calls_method_info_call_emergency_contact_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-call-emergency-contact",
  FALSE
};

static const GDBusMethodInfo * const _calls_dbus_emergency_calls_method_info_pointers[] =
{
  &_calls_dbus_emergency_calls_method_info_get_emergency_contacts.parent_struct,
  &_calls_dbus_emergency_calls_method_info_call_emergency_contact.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _calls_dbus_emergency_calls_signal_info_emergency_numbers_changed =
{
  {
    -1,
    (gchar *) "EmergencyNumbersChanged",
    NULL,
    NULL
  },
  "emergency-numbers-changed"
};

static const GDBusSignalInfo * const _calls_dbus_emergency_calls_signal_info_pointers[] =
{
  &_calls_dbus_emergency_calls_signal_info_emergency_numbers_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _calls_dbus_emergency_calls_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Calls.EmergencyCalls",
    (GDBusMethodInfo **) &_calls_dbus_emergency_calls_method_info_pointers,
    (GDBusSignalInfo **) &_calls_dbus_emergency_calls_signal_info_pointers,
    NULL,
    NULL
  },
  "emergency-calls",
};


/**
 * calls_dbus_emergency_calls_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Calls-EmergencyCalls.top_of_page">org.gnome.Calls.EmergencyCalls</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
calls_dbus_emergency_calls_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_calls_dbus_emergency_calls_interface_info.parent_struct;
}

/**
 * calls_dbus_emergency_calls_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #CallsDBusEmergencyCalls interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
calls_dbus_emergency_calls_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
calls_dbus_emergency_calls_signal_marshal_emergency_numbers_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
calls_dbus_emergency_calls_method_marshal_get_emergency_contacts (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
calls_dbus_emergency_calls_method_marshal_call_emergency_contact (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * CallsDBusEmergencyCalls:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Calls-EmergencyCalls.top_of_page">org.gnome.Calls.EmergencyCalls</link>.
 */

/**
 * CallsDBusEmergencyCallsIface:
 * @parent_iface: The parent interface.
 * @handle_call_emergency_contact: Handler for the #CallsDBusEmergencyCalls::handle-call-emergency-contact signal.
 * @handle_get_emergency_contacts: Handler for the #CallsDBusEmergencyCalls::handle-get-emergency-contacts signal.
 * @emergency_numbers_changed: Handler for the #CallsDBusEmergencyCalls::emergency-numbers-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Calls-EmergencyCalls.top_of_page">org.gnome.Calls.EmergencyCalls</link>.
 */

typedef CallsDBusEmergencyCallsIface CallsDBusEmergencyCallsInterface;
G_DEFINE_INTERFACE (CallsDBusEmergencyCalls, calls_dbus_emergency_calls, G_TYPE_OBJECT)

static void
calls_dbus_emergency_calls_default_init (CallsDBusEmergencyCallsIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * CallsDBusEmergencyCalls::handle-get-emergency-contacts:
   * @object: A #CallsDBusEmergencyCalls.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Calls-EmergencyCalls.GetEmergencyContacts">GetEmergencyContacts()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call calls_dbus_emergency_calls_complete_get_emergency_contacts() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-emergency-contacts",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CallsDBusEmergencyCallsIface, handle_get_emergency_contacts),
    g_signal_accumulator_true_handled,
    NULL,
      calls_dbus_emergency_calls_method_marshal_get_emergency_contacts,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * CallsDBusEmergencyCalls::handle-call-emergency-contact:
   * @object: A #CallsDBusEmergencyCalls.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Calls-EmergencyCalls.CallEmergencyContact">CallEmergencyContact()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call calls_dbus_emergency_calls_complete_call_emergency_contact() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-call-emergency-contact",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CallsDBusEmergencyCallsIface, handle_call_emergency_contact),
    g_signal_accumulator_true_handled,
    NULL,
      calls_dbus_emergency_calls_method_marshal_call_emergency_contact,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * CallsDBusEmergencyCalls::emergency-numbers-changed:
   * @object: A #CallsDBusEmergencyCalls.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Calls-EmergencyCalls.EmergencyNumbersChanged">"EmergencyNumbersChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  CALLS_DBUS__EMERGENCY_CALLS_SIGNALS[CALLS_DBUS__EMERGENCY_CALLS_EMERGENCY_NUMBERS_CHANGED] =
    g_signal_new ("emergency-numbers-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (CallsDBusEmergencyCallsIface, emergency_numbers_changed),
      NULL,
      NULL,
      calls_dbus_emergency_calls_signal_marshal_emergency_numbers_changed,
      G_TYPE_NONE,
      0);

}

/**
 * calls_dbus_emergency_calls_emit_emergency_numbers_changed:
 * @object: A #CallsDBusEmergencyCalls.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Calls-EmergencyCalls.EmergencyNumbersChanged">"EmergencyNumbersChanged"</link> D-Bus signal.
 */
void
calls_dbus_emergency_calls_emit_emergency_numbers_changed (
    CallsDBusEmergencyCalls *object)
{
  g_signal_emit (object, CALLS_DBUS__EMERGENCY_CALLS_SIGNALS[CALLS_DBUS__EMERGENCY_CALLS_EMERGENCY_NUMBERS_CHANGED], 0);
}

/**
 * calls_dbus_emergency_calls_call_get_emergency_contacts:
 * @proxy: A #CallsDBusEmergencyCallsProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Calls-EmergencyCalls.GetEmergencyContacts">GetEmergencyContacts()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call calls_dbus_emergency_calls_call_get_emergency_contacts_finish() to get the result of the operation.
 *
 * See calls_dbus_emergency_calls_call_get_emergency_contacts_sync() for the synchronous, blocking version of this method.
 */
void
calls_dbus_emergency_calls_call_get_emergency_contacts (
    CallsDBusEmergencyCalls *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetEmergencyContacts",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * calls_dbus_emergency_calls_call_get_emergency_contacts_finish:
 * @proxy: A #CallsDBusEmergencyCallsProxy.
 * @out_contacts: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to calls_dbus_emergency_calls_call_get_emergency_contacts().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with calls_dbus_emergency_calls_call_get_emergency_contacts().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
calls_dbus_emergency_calls_call_get_emergency_contacts_finish (
    CallsDBusEmergencyCalls *proxy,
    GVariant **out_contacts,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ssia{sv}))",
                 out_contacts);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * calls_dbus_emergency_calls_call_get_emergency_contacts_sync:
 * @proxy: A #CallsDBusEmergencyCallsProxy.
 * @out_contacts: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Calls-EmergencyCalls.GetEmergencyContacts">GetEmergencyContacts()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See calls_dbus_emergency_calls_call_get_emergency_contacts() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
calls_dbus_emergency_calls_call_get_emergency_contacts_sync (
    CallsDBusEmergencyCalls *proxy,
    GVariant **out_contacts,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetEmergencyContacts",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ssia{sv}))",
                 out_contacts);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * calls_dbus_emergency_calls_call_call_emergency_contact:
 * @proxy: A #CallsDBusEmergencyCallsProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Calls-EmergencyCalls.CallEmergencyContact">CallEmergencyContact()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call calls_dbus_emergency_calls_call_call_emergency_contact_finish() to get the result of the operation.
 *
 * See calls_dbus_emergency_calls_call_call_emergency_contact_sync() for the synchronous, blocking version of this method.
 */
void
calls_dbus_emergency_calls_call_call_emergency_contact (
    CallsDBusEmergencyCalls *proxy,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CallEmergencyContact",
    g_variant_new ("(s)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * calls_dbus_emergency_calls_call_call_emergency_contact_finish:
 * @proxy: A #CallsDBusEmergencyCallsProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to calls_dbus_emergency_calls_call_call_emergency_contact().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with calls_dbus_emergency_calls_call_call_emergency_contact().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
calls_dbus_emergency_calls_call_call_emergency_contact_finish (
    CallsDBusEmergencyCalls *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * calls_dbus_emergency_calls_call_call_emergency_contact_sync:
 * @proxy: A #CallsDBusEmergencyCallsProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Calls-EmergencyCalls.CallEmergencyContact">CallEmergencyContact()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See calls_dbus_emergency_calls_call_call_emergency_contact() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
calls_dbus_emergency_calls_call_call_emergency_contact_sync (
    CallsDBusEmergencyCalls *proxy,
    const gchar *arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CallEmergencyContact",
    g_variant_new ("(s)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * calls_dbus_emergency_calls_complete_get_emergency_contacts:
 * @object: A #CallsDBusEmergencyCalls.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @contacts: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Calls-EmergencyCalls.GetEmergencyContacts">GetEmergencyContacts()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
calls_dbus_emergency_calls_complete_get_emergency_contacts (
    CallsDBusEmergencyCalls *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *contacts)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(ssia{sv}))",
                   contacts));
}

/**
 * calls_dbus_emergency_calls_complete_call_emergency_contact:
 * @object: A #CallsDBusEmergencyCalls.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Calls-EmergencyCalls.CallEmergencyContact">CallEmergencyContact()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
calls_dbus_emergency_calls_complete_call_emergency_contact (
    CallsDBusEmergencyCalls *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * CallsDBusEmergencyCallsProxy:
 *
 * The #CallsDBusEmergencyCallsProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CallsDBusEmergencyCallsProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CallsDBusEmergencyCallsProxy.
 */

struct _CallsDBusEmergencyCallsProxyPrivate
{
  GData *qdata;
};

static void calls_dbus_emergency_calls_proxy_iface_init (CallsDBusEmergencyCallsIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CallsDBusEmergencyCallsProxy, calls_dbus_emergency_calls_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (CallsDBusEmergencyCallsProxy)
                         G_IMPLEMENT_INTERFACE (CALLS_DBUS_TYPE_EMERGENCY_CALLS, calls_dbus_emergency_calls_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CallsDBusEmergencyCallsProxy, calls_dbus_emergency_calls_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CALLS_DBUS_TYPE_EMERGENCY_CALLS, calls_dbus_emergency_calls_proxy_iface_init))

#endif
static void
calls_dbus_emergency_calls_proxy_finalize (GObject *object)
{
  CallsDBusEmergencyCallsProxy *proxy = CALLS_DBUS_EMERGENCY_CALLS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (calls_dbus_emergency_calls_proxy_parent_class)->finalize (object);
}

static void
calls_dbus_emergency_calls_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
calls_dbus_emergency_calls_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
calls_dbus_emergency_calls_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_calls_dbus_emergency_calls_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CALLS_DBUS_TYPE_EMERGENCY_CALLS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CALLS_DBUS_TYPE_EMERGENCY_CALLS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
calls_dbus_emergency_calls_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  CallsDBusEmergencyCallsProxy *proxy = CALLS_DBUS_EMERGENCY_CALLS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_calls_dbus_emergency_calls_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_calls_dbus_emergency_calls_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
calls_dbus_emergency_calls_proxy_init (CallsDBusEmergencyCallsProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = calls_dbus_emergency_calls_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CALLS_DBUS_TYPE_EMERGENCY_CALLS_PROXY, CallsDBusEmergencyCallsProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), calls_dbus_emergency_calls_interface_info ());
}

static void
calls_dbus_emergency_calls_proxy_class_init (CallsDBusEmergencyCallsProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = calls_dbus_emergency_calls_proxy_finalize;
  gobject_class->get_property = calls_dbus_emergency_calls_proxy_get_property;
  gobject_class->set_property = calls_dbus_emergency_calls_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = calls_dbus_emergency_calls_proxy_g_signal;
  proxy_class->g_properties_changed = calls_dbus_emergency_calls_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CallsDBusEmergencyCallsProxyPrivate));
#endif
}

static void
calls_dbus_emergency_calls_proxy_iface_init (CallsDBusEmergencyCallsIface *iface G_GNUC_UNUSED)
{
}

/**
 * calls_dbus_emergency_calls_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Calls-EmergencyCalls.top_of_page">org.gnome.Calls.EmergencyCalls</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call calls_dbus_emergency_calls_proxy_new_finish() to get the result of the operation.
 *
 * See calls_dbus_emergency_calls_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
calls_dbus_emergency_calls_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CALLS_DBUS_TYPE_EMERGENCY_CALLS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Calls.EmergencyCalls", NULL);
}

/**
 * calls_dbus_emergency_calls_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to calls_dbus_emergency_calls_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with calls_dbus_emergency_calls_proxy_new().
 *
 * Returns: (transfer full) (type CallsDBusEmergencyCallsProxy): The constructed proxy object or %NULL if @error is set.
 */
CallsDBusEmergencyCalls *
calls_dbus_emergency_calls_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CALLS_DBUS_EMERGENCY_CALLS (ret);
  else
    return NULL;
}

/**
 * calls_dbus_emergency_calls_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Calls-EmergencyCalls.top_of_page">org.gnome.Calls.EmergencyCalls</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See calls_dbus_emergency_calls_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CallsDBusEmergencyCallsProxy): The constructed proxy object or %NULL if @error is set.
 */
CallsDBusEmergencyCalls *
calls_dbus_emergency_calls_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CALLS_DBUS_TYPE_EMERGENCY_CALLS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Calls.EmergencyCalls", NULL);
  if (ret != NULL)
    return CALLS_DBUS_EMERGENCY_CALLS (ret);
  else
    return NULL;
}


/**
 * calls_dbus_emergency_calls_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like calls_dbus_emergency_calls_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call calls_dbus_emergency_calls_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See calls_dbus_emergency_calls_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
calls_dbus_emergency_calls_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CALLS_DBUS_TYPE_EMERGENCY_CALLS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Calls.EmergencyCalls", NULL);
}

/**
 * calls_dbus_emergency_calls_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to calls_dbus_emergency_calls_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with calls_dbus_emergency_calls_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type CallsDBusEmergencyCallsProxy): The constructed proxy object or %NULL if @error is set.
 */
CallsDBusEmergencyCalls *
calls_dbus_emergency_calls_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CALLS_DBUS_EMERGENCY_CALLS (ret);
  else
    return NULL;
}

/**
 * calls_dbus_emergency_calls_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like calls_dbus_emergency_calls_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See calls_dbus_emergency_calls_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CallsDBusEmergencyCallsProxy): The constructed proxy object or %NULL if @error is set.
 */
CallsDBusEmergencyCalls *
calls_dbus_emergency_calls_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CALLS_DBUS_TYPE_EMERGENCY_CALLS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Calls.EmergencyCalls", NULL);
  if (ret != NULL)
    return CALLS_DBUS_EMERGENCY_CALLS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * CallsDBusEmergencyCallsSkeleton:
 *
 * The #CallsDBusEmergencyCallsSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CallsDBusEmergencyCallsSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CallsDBusEmergencyCallsSkeleton.
 */

struct _CallsDBusEmergencyCallsSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_calls_dbus_emergency_calls_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  CallsDBusEmergencyCallsSkeleton *skeleton = CALLS_DBUS_EMERGENCY_CALLS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CALLS_DBUS_TYPE_EMERGENCY_CALLS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CALLS_DBUS_TYPE_EMERGENCY_CALLS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_calls_dbus_emergency_calls_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  CallsDBusEmergencyCallsSkeleton *skeleton = CALLS_DBUS_EMERGENCY_CALLS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_calls_dbus_emergency_calls_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_calls_dbus_emergency_calls_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  CallsDBusEmergencyCallsSkeleton *skeleton = CALLS_DBUS_EMERGENCY_CALLS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_calls_dbus_emergency_calls_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _calls_dbus_emergency_calls_skeleton_vtable =
{
  _calls_dbus_emergency_calls_skeleton_handle_method_call,
  _calls_dbus_emergency_calls_skeleton_handle_get_property,
  _calls_dbus_emergency_calls_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
calls_dbus_emergency_calls_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return calls_dbus_emergency_calls_interface_info ();
}

static GDBusInterfaceVTable *
calls_dbus_emergency_calls_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_calls_dbus_emergency_calls_skeleton_vtable;
}

static GVariant *
calls_dbus_emergency_calls_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  CallsDBusEmergencyCallsSkeleton *skeleton = CALLS_DBUS_EMERGENCY_CALLS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_calls_dbus_emergency_calls_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _calls_dbus_emergency_calls_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _calls_dbus_emergency_calls_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _calls_dbus_emergency_calls_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Calls.EmergencyCalls", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
calls_dbus_emergency_calls_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_calls_dbus_emergency_calls_on_signal_emergency_numbers_changed (
    CallsDBusEmergencyCalls *object)
{
  CallsDBusEmergencyCallsSkeleton *skeleton = CALLS_DBUS_EMERGENCY_CALLS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Calls.EmergencyCalls", "EmergencyNumbersChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void calls_dbus_emergency_calls_skeleton_iface_init (CallsDBusEmergencyCallsIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CallsDBusEmergencyCallsSkeleton, calls_dbus_emergency_calls_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (CallsDBusEmergencyCallsSkeleton)
                         G_IMPLEMENT_INTERFACE (CALLS_DBUS_TYPE_EMERGENCY_CALLS, calls_dbus_emergency_calls_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CallsDBusEmergencyCallsSkeleton, calls_dbus_emergency_calls_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CALLS_DBUS_TYPE_EMERGENCY_CALLS, calls_dbus_emergency_calls_skeleton_iface_init))

#endif
static void
calls_dbus_emergency_calls_skeleton_finalize (GObject *object)
{
  CallsDBusEmergencyCallsSkeleton *skeleton = CALLS_DBUS_EMERGENCY_CALLS_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (calls_dbus_emergency_calls_skeleton_parent_class)->finalize (object);
}

static void
calls_dbus_emergency_calls_skeleton_init (CallsDBusEmergencyCallsSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = calls_dbus_emergency_calls_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CALLS_DBUS_TYPE_EMERGENCY_CALLS_SKELETON, CallsDBusEmergencyCallsSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
calls_dbus_emergency_calls_skeleton_class_init (CallsDBusEmergencyCallsSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = calls_dbus_emergency_calls_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = calls_dbus_emergency_calls_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = calls_dbus_emergency_calls_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = calls_dbus_emergency_calls_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = calls_dbus_emergency_calls_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CallsDBusEmergencyCallsSkeletonPrivate));
#endif
}

static void
calls_dbus_emergency_calls_skeleton_iface_init (CallsDBusEmergencyCallsIface *iface)
{
  iface->emergency_numbers_changed = _calls_dbus_emergency_calls_on_signal_emergency_numbers_changed;
}

/**
 * calls_dbus_emergency_calls_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Calls-EmergencyCalls.top_of_page">org.gnome.Calls.EmergencyCalls</link>.
 *
 * Returns: (transfer full) (type CallsDBusEmergencyCallsSkeleton): The skeleton object.
 */
CallsDBusEmergencyCalls *
calls_dbus_emergency_calls_skeleton_new (void)
{
  return CALLS_DBUS_EMERGENCY_CALLS (g_object_new (CALLS_DBUS_TYPE_EMERGENCY_CALLS_SKELETON, NULL));
}

