/* math-popover.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from math-popover.vala, do not modify */

/*
 * Copyright (C) 2021 Robert Roth
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "calculator.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <adwaita.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MATH_POPOVER (math_popover_get_type ())
#define MATH_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_POPOVER, MathPopover))
#define MATH_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_POPOVER, MathPopoverClass))
#define IS_MATH_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_POPOVER))
#define IS_MATH_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_POPOVER))
#define MATH_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_POPOVER, MathPopoverClass))

typedef struct _MathPopover MathPopover;
typedef struct _MathPopoverClass MathPopoverClass;
typedef struct _MathPopoverPrivate MathPopoverPrivate;
enum  {
	MATH_POPOVER_0_PROPERTY,
	MATH_POPOVER_T_TYPE,
	MATH_POPOVER_T_DUP_FUNC,
	MATH_POPOVER_T_DESTROY_FUNC,
	MATH_POPOVER_NAME_ENTRY_PROPERTY,
	MATH_POPOVER_ADD_BUTTON_PROPERTY,
	MATH_POPOVER_ERROR_LABEL_PROPERTY,
	MATH_POPOVER_NUM_PROPERTIES
};
static GParamSpec* math_popover_properties[MATH_POPOVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;

#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;
enum  {
	MATH_POPOVER_ITEM_EDITED_SIGNAL,
	MATH_POPOVER_ITEM_DELETED_SIGNAL,
	MATH_POPOVER_NUM_SIGNALS
};
static guint math_popover_signals[MATH_POPOVER_NUM_SIGNALS] = {0};

struct _MathPopover {
	GtkPopover parent_instance;
	MathPopoverPrivate * priv;
	MathEquation* equation;
	GListStore* model;
};

struct _MathPopoverClass {
	GtkPopoverClass parent_class;
	gboolean (*is_deletable) (MathPopover* self, gconstpointer item);
	gboolean (*is_editable) (MathPopover* self, gconstpointer item);
	gchar* (*get_item_text) (MathPopover* self, gconstpointer item);
	gint (*get_item_index) (MathPopover* self, gconstpointer item);
	gchar* (*validate_name) (MathPopover* self, const gchar* name);
	GtkEntry* (*get_name_entry) (MathPopover* self);
	GtkButton* (*get_add_button) (MathPopover* self);
	GtkLabel* (*get_error_label) (MathPopover* self);
};

struct _MathPopoverPrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	GCompareDataFunc compare_func;
	gpointer compare_func_target;
	GDestroyNotify compare_func_target_destroy_notify;
	gulong changed_handler;
};

static gint MathPopover_private_offset;
static gpointer math_popover_parent_class = NULL;
VALA_EXTERN gchar** math_popover_RESERVED_VARIABLE_NAMES;
VALA_EXTERN gint math_popover_RESERVED_VARIABLE_NAMES_length1;
gchar** math_popover_RESERVED_VARIABLE_NAMES = NULL;
gint math_popover_RESERVED_VARIABLE_NAMES_length1 = 0;
VALA_EXTERN gchar** math_popover_OPERATORS;
VALA_EXTERN gint math_popover_OPERATORS_length1;
gchar** math_popover_OPERATORS = NULL;
gint math_popover_OPERATORS_length1 = 0;

VALA_EXTERN GType math_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathPopover, g_object_unref)
VALA_EXTERN gboolean math_popover_is_deletable (MathPopover* self,
                                    gconstpointer item);
VALA_EXTERN gboolean math_popover_is_editable (MathPopover* self,
                                   gconstpointer item);
VALA_EXTERN gchar* math_popover_get_item_text (MathPopover* self,
                                   gconstpointer item);
VALA_EXTERN gint math_popover_get_item_index (MathPopover* self,
                                  gconstpointer item);
VALA_EXTERN gchar* math_popover_validate_name (MathPopover* self,
                                   const gchar* name);
VALA_EXTERN MathPopover* math_popover_construct (GType object_type,
                                     GType t_type,
                                     GBoxedCopyFunc t_dup_func,
                                     GDestroyNotify t_destroy_func,
                                     MathEquation* equation,
                                     GListStore* model,
                                     GCompareDataFunc compare_func,
                                     gpointer compare_func_target);
VALA_EXTERN GtkEntry* math_popover_get_name_entry (MathPopover* self);
static void math_popover_name_entry_changed_cb (MathPopover* self,
                                         GtkEditable* editable);
static void _math_popover_name_entry_changed_cb_gtk_editable_changed (GtkEditable* _sender,
                                                               gpointer self);
VALA_EXTERN GtkButton* math_popover_get_add_button (MathPopover* self);
VALA_EXTERN GtkLabel* math_popover_get_error_label (MathPopover* self);
VALA_EXTERN void math_popover_item_added_cb (MathPopover* self,
                                 gconstpointer item);
VALA_EXTERN void math_popover_item_edited_cb (MathPopover* self,
                                  gconstpointer item);
VALA_EXTERN void math_popover_item_deleted_cb (MathPopover* self,
                                   gconstpointer item);
VALA_EXTERN void math_popover_close_popover (MathPopover* self);
VALA_EXTERN GType math_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathWindow, g_object_unref)
VALA_EXTERN GType math_display_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathDisplay, g_object_unref)
VALA_EXTERN MathDisplay* math_window_get_display (MathWindow* self);
VALA_EXTERN void math_display_grab_focus (MathDisplay* self);
static gboolean math_popover_real_is_deletable (MathPopover* self,
                                         gconstpointer item);
static gboolean math_popover_real_is_editable (MathPopover* self,
                                        gconstpointer item);
static gchar* math_popover_real_get_item_text (MathPopover* self,
                                        gconstpointer item);
static gint math_popover_real_get_item_index (MathPopover* self,
                                       gconstpointer item);
static gchar* math_popover_real_validate_name (MathPopover* self,
                                        const gchar* name);
VALA_EXTERN GtkWidget* math_popover_make_item_row (MathPopover* self,
                                       gconstpointer item);
static void math_popover_save_function_cb (MathPopover* self,
                                    GtkWidget* widget);
static void _math_popover_save_function_cb_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self);
static void math_popover_delete_function_cb (MathPopover* self,
                                      GtkWidget* widget);
static void _math_popover_delete_function_cb_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
VALA_EXTERN GtkWidget* math_popover_make_category_row (MathPopover* self,
                                           const gchar* name,
                                           GtkListBox** submenu);
static void math_popover_finalize (GObject * obj);
static GType math_popover_get_type_once (void);
static void _vala_math_popover_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_math_popover_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
math_popover_get_instance_private (MathPopover* self)
{
	return G_STRUCT_MEMBER_P (self, MathPopover_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_math_popover_name_entry_changed_cb_gtk_editable_changed (GtkEditable* _sender,
                                                          gpointer self)
{
	math_popover_name_entry_changed_cb ((MathPopover*) self, _sender);
}

MathPopover*
math_popover_construct (GType object_type,
                        GType t_type,
                        GBoxedCopyFunc t_dup_func,
                        GDestroyNotify t_destroy_func,
                        MathEquation* equation,
                        GListStore* model,
                        GCompareDataFunc compare_func,
                        gpointer compare_func_target)
{
	MathPopover * self = NULL;
	MathEquation* _tmp0_;
	GListStore* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	gulong _tmp6_;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	self = (MathPopover*) g_object_new (object_type, "t-type", t_type, "t-dup-func", t_dup_func, "t-destroy-func", t_destroy_func, NULL);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	_tmp0_ = _g_object_ref0 (equation);
	_g_object_unref0 (self->equation);
	self->equation = _tmp0_;
	_tmp1_ = _g_object_ref0 (model);
	_g_object_unref0 (self->model);
	self->model = _tmp1_;
	(self->priv->compare_func_target_destroy_notify == NULL) ? NULL : (self->priv->compare_func_target_destroy_notify (self->priv->compare_func_target), NULL);
	self->priv->compare_func = NULL;
	self->priv->compare_func_target = NULL;
	self->priv->compare_func_target_destroy_notify = NULL;
	self->priv->compare_func = compare_func;
	self->priv->compare_func_target = compare_func_target;
	self->priv->compare_func_target_destroy_notify = NULL;
	_tmp2_ = math_popover_get_name_entry (self);
	_tmp3_ = _tmp2_;
	gtk_editable_set_enable_undo ((GtkEditable*) _tmp3_, FALSE);
	_tmp4_ = math_popover_get_name_entry (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_signal_connect_object ((GtkEditable*) _tmp5_, "changed", (GCallback) _math_popover_name_entry_changed_cb_gtk_editable_changed, self, 0);
	self->priv->changed_handler = _tmp6_;
	return self;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
math_popover_name_entry_changed_cb (MathPopover* self,
                                    GtkEditable* editable)
{
	GtkEntry* entry = NULL;
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	gint cursor = 0;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkEntry* _tmp6_;
	gchar* _error_ = NULL;
	GtkEntry* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp14_;
	gboolean _tmp19_ = FALSE;
	GtkEntry* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	const gchar* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkWidget* _tmp31_;
	GtkWidget* _tmp32_;
	const gchar* _tmp33_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (editable, gtk_entry_get_type ()) ? ((GtkEntry*) editable) : NULL);
	entry = _tmp0_;
	_tmp1_ = entry;
	g_signal_handler_block (_tmp1_, self->priv->changed_handler);
	cursor = gtk_editable_get_position (editable);
	_tmp2_ = gtk_editable_get_text (editable);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, " ", "_");
	_tmp5_ = _tmp4_;
	gtk_editable_set_text (editable, _tmp5_);
	_g_free0 (_tmp5_);
	gtk_editable_set_position (editable, cursor);
	_tmp6_ = entry;
	g_signal_handler_unblock (_tmp6_, self->priv->changed_handler);
	_error_ = NULL;
	_tmp7_ = entry;
	_tmp8_ = gtk_editable_get_text ((GtkEditable*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (g_strcmp0 (_tmp9_, "") != 0) {
		GtkEntry* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp10_ = entry;
		_tmp11_ = gtk_editable_get_text ((GtkEditable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = math_popover_validate_name (self, _tmp12_);
		_g_free0 (_error_);
		_error_ = _tmp13_;
	}
	_tmp14_ = _error_;
	if (_tmp14_ != NULL) {
		GtkEntry* _tmp15_;
		GtkEntry* _tmp16_;
		_tmp15_ = math_popover_get_name_entry (self);
		_tmp16_ = _tmp15_;
		gtk_widget_add_css_class ((GtkWidget*) _tmp16_, "error");
	} else {
		GtkEntry* _tmp17_;
		GtkEntry* _tmp18_;
		_tmp17_ = math_popover_get_name_entry (self);
		_tmp18_ = _tmp17_;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp18_, "error");
	}
	_tmp20_ = entry;
	_tmp21_ = gtk_editable_get_text ((GtkEditable*) _tmp20_);
	_tmp22_ = _tmp21_;
	if (g_strcmp0 (_tmp22_, "") != 0) {
		const gchar* _tmp23_;
		_tmp23_ = _error_;
		_tmp19_ = _tmp23_ == NULL;
	} else {
		_tmp19_ = FALSE;
	}
	_tmp24_ = math_popover_get_add_button (self);
	_tmp25_ = _tmp24_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, _tmp19_);
	_tmp26_ = math_popover_get_error_label (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = _error_;
	gtk_label_set_label (_tmp27_, _tmp28_);
	_tmp29_ = math_popover_get_error_label (self);
	_tmp30_ = _tmp29_;
	_tmp31_ = gtk_widget_get_parent ((GtkWidget*) _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _error_;
	gtk_revealer_set_reveal_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_revealer_get_type (), GtkRevealer), _tmp33_ != NULL);
	_g_free0 (_error_);
	_g_object_unref0 (entry);
}

void
math_popover_item_added_cb (MathPopover* self,
                            gconstpointer item)
{
	GListStore* _tmp0_;
	GCompareDataFunc _tmp1_;
	gpointer _tmp1__target;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->model;
	_tmp1_ = self->priv->compare_func;
	_tmp1__target = self->priv->compare_func_target;
	g_list_store_insert_sorted (_tmp0_, G_TYPE_CHECK_INSTANCE_TYPE (item, G_TYPE_OBJECT) ? ((GObject*) item) : NULL, _tmp1_, _tmp1__target);
}

void
math_popover_item_edited_cb (MathPopover* self,
                             gconstpointer item)
{
	g_return_if_fail (self != NULL);
	math_popover_item_deleted_cb (self, item);
	math_popover_item_added_cb (self, item);
}

void
math_popover_item_deleted_cb (MathPopover* self,
                              gconstpointer item)
{
	gint position = 0;
	g_return_if_fail (self != NULL);
	position = math_popover_get_item_index (self, item);
	if (position >= 0) {
		GListStore* _tmp0_;
		_tmp0_ = self->model;
		g_list_store_remove (_tmp0_, (guint) position);
	}
}

void
math_popover_close_popover (MathPopover* self)
{
	GtkRoot* _tmp0_;
	GtkRoot* _tmp1_;
	MathDisplay* _tmp2_;
	MathDisplay* _tmp3_;
	g_return_if_fail (self != NULL);
	gtk_popover_popdown ((GtkPopover*) self);
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_window_get_display (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_MATH_WINDOW, MathWindow));
	_tmp3_ = _tmp2_;
	math_display_grab_focus (_tmp3_);
}

static gboolean
math_popover_real_is_deletable (MathPopover* self,
                                gconstpointer item)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `math_popover_is_deletable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
math_popover_is_deletable (MathPopover* self,
                           gconstpointer item)
{
	MathPopoverClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = MATH_POPOVER_GET_CLASS (self);
	if (_klass_->is_deletable) {
		return _klass_->is_deletable (self, item);
	}
	return FALSE;
}

static gboolean
math_popover_real_is_editable (MathPopover* self,
                               gconstpointer item)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `math_popover_is_editable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
math_popover_is_editable (MathPopover* self,
                          gconstpointer item)
{
	MathPopoverClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = MATH_POPOVER_GET_CLASS (self);
	if (_klass_->is_editable) {
		return _klass_->is_editable (self, item);
	}
	return FALSE;
}

static gchar*
math_popover_real_get_item_text (MathPopover* self,
                                 gconstpointer item)
{
	g_critical ("Type `%s' does not implement abstract method `math_popover_get_item_text'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
math_popover_get_item_text (MathPopover* self,
                            gconstpointer item)
{
	MathPopoverClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = MATH_POPOVER_GET_CLASS (self);
	if (_klass_->get_item_text) {
		return _klass_->get_item_text (self, item);
	}
	return NULL;
}

static gint
math_popover_real_get_item_index (MathPopover* self,
                                  gconstpointer item)
{
	gint _tmp0_ = 0;
	g_critical ("Type `%s' does not implement abstract method `math_popover_get_item_index'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gint
math_popover_get_item_index (MathPopover* self,
                             gconstpointer item)
{
	MathPopoverClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = MATH_POPOVER_GET_CLASS (self);
	if (_klass_->get_item_index) {
		return _klass_->get_item_index (self, item);
	}
	return -1;
}

static gchar*
math_popover_real_validate_name (MathPopover* self,
                                 const gchar* name)
{
	g_critical ("Type `%s' does not implement abstract method `math_popover_validate_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
math_popover_validate_name (MathPopover* self,
                            const gchar* name)
{
	MathPopoverClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = MATH_POPOVER_GET_CLASS (self);
	if (_klass_->validate_name) {
		return _klass_->validate_name (self, name);
	}
	return NULL;
}

static void
_math_popover_save_function_cb_gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self)
{
	math_popover_save_function_cb ((MathPopover*) self, _sender);
}

static void
_math_popover_delete_function_cb_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	math_popover_delete_function_cb ((MathPopover*) self, _sender);
}

GtkWidget*
math_popover_make_item_row (MathPopover* self,
                            gconstpointer item)
{
	GtkBox* hbox = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkLabel* label = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkBox* _tmp19_;
	GtkLabel* _tmp20_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp0_);
	hbox = _tmp0_;
	_tmp1_ = hbox;
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_FILL);
	_tmp2_ = math_popover_get_item_text (self, item);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("\u200E", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	label = _tmp7_;
	_tmp8_ = label;
	if (gtk_widget_get_direction ((GtkWidget*) _tmp8_) == GTK_TEXT_DIR_RTL) {
		GtkLabel* _tmp9_;
		_tmp9_ = label;
		gtk_label_set_justify (_tmp9_, GTK_JUSTIFY_RIGHT);
	}
	_tmp10_ = label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp10_, 10);
	_tmp11_ = label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp11_, 8);
	_tmp12_ = label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp12_, 4);
	_tmp13_ = label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp13_, 4);
	_tmp14_ = label;
	gtk_label_set_use_markup (_tmp14_, TRUE);
	_tmp15_ = label;
	gtk_label_set_xalign (_tmp15_, (gfloat) 0);
	_tmp16_ = label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp16_, TRUE);
	_tmp17_ = label;
	gtk_label_set_wrap (_tmp17_, TRUE);
	_tmp18_ = label;
	gtk_label_set_wrap_mode (_tmp18_, PANGO_WRAP_WORD_CHAR);
	_tmp19_ = hbox;
	_tmp20_ = label;
	gtk_box_append (_tmp19_, (GtkWidget*) _tmp20_);
	if (math_popover_is_editable (self, item)) {
		GtkButton* button = NULL;
		GtkButton* _tmp21_;
		GtkButton* _tmp22_;
		GtkButton* _tmp23_;
		GtkButton* _tmp24_;
		GObject* _tmp25_;
		GtkButton* _tmp26_;
		GtkButton* _tmp27_;
		GtkBox* _tmp28_;
		GtkButton* _tmp29_;
		_tmp21_ = (GtkButton*) gtk_button_new_from_icon_name ("document-edit-symbolic");
		g_object_ref_sink (_tmp21_);
		button = _tmp21_;
		_tmp22_ = button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp22_, _ ("Edit"));
		_tmp23_ = button;
		gtk_button_set_has_frame (_tmp23_, FALSE);
		_tmp24_ = button;
		_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, G_TYPE_OBJECT) ? ((GObject*) item) : NULL);
		g_object_set_data_full ((GObject*) _tmp24_, "object", _tmp25_, g_object_unref);
		_tmp26_ = button;
		g_signal_connect_object (_tmp26_, "clicked", (GCallback) _math_popover_save_function_cb_gtk_button_clicked, self, 0);
		_tmp27_ = button;
		gtk_widget_set_halign ((GtkWidget*) _tmp27_, GTK_ALIGN_END);
		_tmp28_ = hbox;
		_tmp29_ = button;
		gtk_box_append (_tmp28_, (GtkWidget*) _tmp29_);
		_g_object_unref0 (button);
	}
	if (math_popover_is_deletable (self, item)) {
		GtkButton* button = NULL;
		GtkButton* _tmp30_;
		GtkButton* _tmp31_;
		GtkButton* _tmp32_;
		GtkButton* _tmp33_;
		GObject* _tmp34_;
		GtkButton* _tmp35_;
		GtkButton* _tmp36_;
		GtkBox* _tmp37_;
		GtkButton* _tmp38_;
		_tmp30_ = (GtkButton*) gtk_button_new_from_icon_name ("user-trash-symbolic");
		g_object_ref_sink (_tmp30_);
		button = _tmp30_;
		_tmp31_ = button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp31_, _ ("Delete"));
		_tmp32_ = button;
		gtk_button_set_has_frame (_tmp32_, FALSE);
		_tmp33_ = button;
		_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, G_TYPE_OBJECT) ? ((GObject*) item) : NULL);
		g_object_set_data_full ((GObject*) _tmp33_, "object", _tmp34_, g_object_unref);
		_tmp35_ = button;
		g_signal_connect_object (_tmp35_, "clicked", (GCallback) _math_popover_delete_function_cb_gtk_button_clicked, self, 0);
		_tmp36_ = button;
		gtk_widget_set_halign ((GtkWidget*) _tmp36_, GTK_ALIGN_END);
		_tmp37_ = hbox;
		_tmp38_ = button;
		gtk_box_append (_tmp37_, (GtkWidget*) _tmp38_);
		_g_object_unref0 (button);
	}
	result = (GtkWidget*) hbox;
	_g_object_unref0 (label);
	return result;
}

GtkWidget*
math_popover_make_category_row (MathPopover* self,
                                const gchar* name,
                                GtkListBox** submenu)
{
	GtkListBox* _vala_submenu = NULL;
	GtkBox* category_row = NULL;
	GtkBox* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkImage* forward_arrow = NULL;
	GtkImage* _tmp3_;
	GtkListBox* _tmp4_;
	GtkCenterBox* back_button = NULL;
	GtkCenterBox* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp0_);
	category_row = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (name);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_box_append (category_row, (GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name ("go-next-symbolic");
	g_object_ref_sink (_tmp3_);
	forward_arrow = _tmp3_;
	gtk_widget_set_halign ((GtkWidget*) forward_arrow, GTK_ALIGN_END);
	gtk_widget_set_hexpand ((GtkWidget*) forward_arrow, TRUE);
	gtk_widget_add_css_class ((GtkWidget*) forward_arrow, "forward-arrow");
	gtk_box_append (category_row, (GtkWidget*) forward_arrow);
	_tmp4_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (_vala_submenu);
	_vala_submenu = _tmp4_;
	gtk_list_box_set_selection_mode (_vala_submenu, GTK_SELECTION_NONE);
	_tmp5_ = (GtkCenterBox*) gtk_center_box_new ();
	g_object_ref_sink (_tmp5_);
	back_button = _tmp5_;
	gtk_widget_add_css_class ((GtkWidget*) back_button, "back-button");
	_tmp6_ = (GtkLabel*) gtk_label_new (name);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	gtk_center_box_set_center_widget (back_button, (GtkWidget*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("go-previous-symbolic");
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	gtk_center_box_set_start_widget (back_button, (GtkWidget*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = gtk_center_box_get_start_widget (back_button);
	_tmp11_ = _tmp10_;
	gtk_widget_add_css_class (_tmp11_, "back-arrow");
	gtk_list_box_append (_vala_submenu, (GtkWidget*) back_button);
	result = (GtkWidget*) category_row;
	_g_object_unref0 (back_button);
	_g_object_unref0 (forward_arrow);
	if (submenu) {
		*submenu = _vala_submenu;
	} else {
		_g_object_unref0 (_vala_submenu);
	}
	return result;
}

static void
math_popover_save_function_cb (MathPopover* self,
                               GtkWidget* widget)
{
	gconstpointer _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = g_object_get_data ((GObject*) widget, "object");
	g_signal_emit (self, math_popover_signals[MATH_POPOVER_ITEM_EDITED_SIGNAL], 0, (gconstpointer) ((GObject*) _tmp0_));
}

static void
math_popover_delete_function_cb (MathPopover* self,
                                 GtkWidget* widget)
{
	gconstpointer _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = g_object_get_data ((GObject*) widget, "object");
	g_signal_emit (self, math_popover_signals[MATH_POPOVER_ITEM_DELETED_SIGNAL], 0, (gconstpointer) ((GObject*) _tmp0_));
}

GtkEntry*
math_popover_get_name_entry (MathPopover* self)
{
	MathPopoverClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = MATH_POPOVER_GET_CLASS (self);
	if (_klass_->get_name_entry) {
		return _klass_->get_name_entry (self);
	}
	return NULL;
}

GtkButton*
math_popover_get_add_button (MathPopover* self)
{
	MathPopoverClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = MATH_POPOVER_GET_CLASS (self);
	if (_klass_->get_add_button) {
		return _klass_->get_add_button (self);
	}
	return NULL;
}

GtkLabel*
math_popover_get_error_label (MathPopover* self)
{
	MathPopoverClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = MATH_POPOVER_GET_CLASS (self);
	if (_klass_->get_error_label) {
		return _klass_->get_error_label (self);
	}
	return NULL;
}

static void
math_popover_class_init (MathPopoverClass * klass,
                         gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	math_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathPopover_private_offset);
	((MathPopoverClass *) klass)->is_deletable = (gboolean (*) (MathPopover*, gconstpointer)) math_popover_real_is_deletable;
	((MathPopoverClass *) klass)->is_editable = (gboolean (*) (MathPopover*, gconstpointer)) math_popover_real_is_editable;
	((MathPopoverClass *) klass)->get_item_text = (gchar* (*) (MathPopover*, gconstpointer)) math_popover_real_get_item_text;
	((MathPopoverClass *) klass)->get_item_index = (gint (*) (MathPopover*, gconstpointer)) math_popover_real_get_item_index;
	((MathPopoverClass *) klass)->validate_name = (gchar* (*) (MathPopover*, const gchar*)) math_popover_real_validate_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_popover_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_popover_set_property;
	G_OBJECT_CLASS (klass)->finalize = math_popover_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_POPOVER_T_TYPE, g_param_spec_gtype ("t-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_POPOVER_T_DUP_FUNC, g_param_spec_pointer ("t-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_POPOVER_T_DESTROY_FUNC, g_param_spec_pointer ("t-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_POPOVER_NAME_ENTRY_PROPERTY, math_popover_properties[MATH_POPOVER_NAME_ENTRY_PROPERTY] = g_param_spec_object ("name-entry", "name-entry", "name-entry", gtk_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_POPOVER_ADD_BUTTON_PROPERTY, math_popover_properties[MATH_POPOVER_ADD_BUTTON_PROPERTY] = g_param_spec_object ("add-button", "add-button", "add-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_POPOVER_ERROR_LABEL_PROPERTY, math_popover_properties[MATH_POPOVER_ERROR_LABEL_PROPERTY] = g_param_spec_object ("error-label", "error-label", "error-label", gtk_label_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	math_popover_signals[MATH_POPOVER_ITEM_EDITED_SIGNAL] = g_signal_new ("item-edited", TYPE_MATH_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	math_popover_signals[MATH_POPOVER_ITEM_DELETED_SIGNAL] = g_signal_new ("item-deleted", TYPE_MATH_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	_tmp0_ = g_strdup ("_");
	_tmp1_ = g_strdup ("rand");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	math_popover_RESERVED_VARIABLE_NAMES = _tmp2_;
	math_popover_RESERVED_VARIABLE_NAMES_length1 = 2;
	_tmp3_ = g_strdup ("mod");
	_tmp4_ = g_strdup ("and");
	_tmp5_ = g_strdup ("nand");
	_tmp6_ = g_strdup ("or");
	_tmp7_ = g_strdup ("nor");
	_tmp8_ = g_strdup ("xor");
	_tmp9_ = g_strdup ("xnor");
	_tmp10_ = g_strdup ("nxor");
	_tmp11_ = g_strdup ("not");
	_tmp12_ = g_strdup (_ ("in"));
	_tmp13_ = g_strdup (_ ("to"));
	_tmp14_ = g_new0 (gchar*, 11 + 1);
	_tmp14_[0] = _tmp3_;
	_tmp14_[1] = _tmp4_;
	_tmp14_[2] = _tmp5_;
	_tmp14_[3] = _tmp6_;
	_tmp14_[4] = _tmp7_;
	_tmp14_[5] = _tmp8_;
	_tmp14_[6] = _tmp9_;
	_tmp14_[7] = _tmp10_;
	_tmp14_[8] = _tmp11_;
	_tmp14_[9] = _tmp12_;
	_tmp14_[10] = _tmp13_;
	math_popover_OPERATORS = _tmp14_;
	math_popover_OPERATORS_length1 = 11;
}

static void
math_popover_instance_init (MathPopover * self,
                            gpointer klass)
{
	self->priv = math_popover_get_instance_private (self);
}

static void
math_popover_finalize (GObject * obj)
{
	MathPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_POPOVER, MathPopover);
	_g_object_unref0 (self->equation);
	_g_object_unref0 (self->model);
	(self->priv->compare_func_target_destroy_notify == NULL) ? NULL : (self->priv->compare_func_target_destroy_notify (self->priv->compare_func_target), NULL);
	self->priv->compare_func = NULL;
	self->priv->compare_func_target = NULL;
	self->priv->compare_func_target_destroy_notify = NULL;
	G_OBJECT_CLASS (math_popover_parent_class)->finalize (obj);
}

static GType
math_popover_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathPopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathPopover), 0, (GInstanceInitFunc) math_popover_instance_init, NULL };
	GType math_popover_type_id;
	math_popover_type_id = g_type_register_static (gtk_popover_get_type (), "MathPopover", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	MathPopover_private_offset = g_type_add_instance_private (math_popover_type_id, sizeof (MathPopoverPrivate));
	return math_popover_type_id;
}

GType
math_popover_get_type (void)
{
	static volatile gsize math_popover_type_id__once = 0;
	if (g_once_init_enter (&math_popover_type_id__once)) {
		GType math_popover_type_id;
		math_popover_type_id = math_popover_get_type_once ();
		g_once_init_leave (&math_popover_type_id__once, math_popover_type_id);
	}
	return math_popover_type_id__once;
}

static void
_vala_math_popover_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	MathPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_POPOVER, MathPopover);
	switch (property_id) {
		case MATH_POPOVER_T_TYPE:
		g_value_set_gtype (value, self->priv->t_type);
		break;
		case MATH_POPOVER_T_DUP_FUNC:
		g_value_set_pointer (value, self->priv->t_dup_func);
		break;
		case MATH_POPOVER_T_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->t_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_math_popover_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	MathPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_POPOVER, MathPopover);
	switch (property_id) {
		case MATH_POPOVER_T_TYPE:
		self->priv->t_type = g_value_get_gtype (value);
		break;
		case MATH_POPOVER_T_DUP_FUNC:
		self->priv->t_dup_func = g_value_get_pointer (value);
		break;
		case MATH_POPOVER_T_DESTROY_FUNC:
		self->priv->t_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

