// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        v6.30.2
// source: cluster.proto

package gitalypb

import (
	raftpb "go.etcd.io/raft/v3/raftpb"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ReplicaType indicates whether a replica is a voter or learner in the Raft cluster
type ReplicaID_ReplicaType int32

const (
	// REPLICA_TYPE_UNSPECIFIED.
	ReplicaID_REPLICA_TYPE_UNSPECIFIED ReplicaID_ReplicaType = 0
	// REPLICA_TYPE_VOTER indicates a replica that can participate in Raft elections and voting.
	ReplicaID_REPLICA_TYPE_VOTER ReplicaID_ReplicaType = 1
	// REPLICA_TYPE_LEARNER indicates a replica that receives updates but cannot vote.
	ReplicaID_REPLICA_TYPE_LEARNER ReplicaID_ReplicaType = 2
)

// Enum value maps for ReplicaID_ReplicaType.
var (
	ReplicaID_ReplicaType_name = map[int32]string{
		0: "REPLICA_TYPE_UNSPECIFIED",
		1: "REPLICA_TYPE_VOTER",
		2: "REPLICA_TYPE_LEARNER",
	}
	ReplicaID_ReplicaType_value = map[string]int32{
		"REPLICA_TYPE_UNSPECIFIED": 0,
		"REPLICA_TYPE_VOTER":       1,
		"REPLICA_TYPE_LEARNER":     2,
	}
)

func (x ReplicaID_ReplicaType) Enum() *ReplicaID_ReplicaType {
	p := new(ReplicaID_ReplicaType)
	*p = x
	return p
}

func (x ReplicaID_ReplicaType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReplicaID_ReplicaType) Descriptor() protoreflect.EnumDescriptor {
	return file_cluster_proto_enumTypes[0].Descriptor()
}

func (ReplicaID_ReplicaType) Type() protoreflect.EnumType {
	return &file_cluster_proto_enumTypes[0]
}

func (x ReplicaID_ReplicaType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReplicaID_ReplicaType.Descriptor instead.
func (ReplicaID_ReplicaType) EnumDescriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{2, 0}
}

// RaftEntry encapsulates critical data for replication using etcd/raft library.
// It has a request ID allowing the primary to track when the action is
// effectively applied.
type RaftEntry struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// id is the unique identifier for the Raft message. This ID is generated by
	// an in-memory event registry. Raft uses this ID to track the commit status
	// of a log entry.
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// data represents packed and serialized log data.
	Data          *RaftEntry_LogData `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftEntry) Reset() {
	*x = RaftEntry{}
	mi := &file_cluster_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftEntry) ProtoMessage() {}

func (x *RaftEntry) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftEntry.ProtoReflect.Descriptor instead.
func (*RaftEntry) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *RaftEntry) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *RaftEntry) GetData() *RaftEntry_LogData {
	if x != nil {
		return x.Data
	}
	return nil
}

// RaftPartitionKey is a globally-unique identifier for a replicated partition.
// The replica which minted the partition is responsible for computing the RaftPartitionKey,
// which is a hash of the storage name and partition ID. The key is then consumed
// as-is by other replicas wishing to store the partition.
type RaftPartitionKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// value is the SHA256 digest of the storage name and partition ID of the
	// newly-minted partition.
	Value         string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftPartitionKey) Reset() {
	*x = RaftPartitionKey{}
	mi := &file_cluster_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftPartitionKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftPartitionKey) ProtoMessage() {}

func (x *RaftPartitionKey) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftPartitionKey.ProtoReflect.Descriptor instead.
func (*RaftPartitionKey) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *RaftPartitionKey) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// ReplicaID uniquely identifies a replica in the Raft cluster.
// It combines partition information with node-specific details.
type ReplicaID struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// partition_key identifies which partition this replica belongs to.
	PartitionKey *RaftPartitionKey `protobuf:"bytes,1,opt,name=partition_key,json=partitionKey,proto3" json:"partition_key,omitempty"`
	// member_id is the unique identifier assigned by etcd/raft.
	MemberId uint64 `protobuf:"varint,2,opt,name=member_id,json=memberId,proto3" json:"member_id,omitempty"`
	// storage_name is the name of the storage where this replica is hosted.
	StorageName string `protobuf:"bytes,3,opt,name=storage_name,json=storageName,proto3" json:"storage_name,omitempty"`
	// metadata contains replica information.
	Metadata *ReplicaID_Metadata `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// type indicates whether the replica is learner or voter.
	Type          ReplicaID_ReplicaType `protobuf:"varint,5,opt,name=type,proto3,enum=gitaly.ReplicaID_ReplicaType" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReplicaID) Reset() {
	*x = ReplicaID{}
	mi := &file_cluster_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicaID) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicaID) ProtoMessage() {}

func (x *ReplicaID) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicaID.ProtoReflect.Descriptor instead.
func (*ReplicaID) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *ReplicaID) GetPartitionKey() *RaftPartitionKey {
	if x != nil {
		return x.PartitionKey
	}
	return nil
}

func (x *ReplicaID) GetMemberId() uint64 {
	if x != nil {
		return x.MemberId
	}
	return 0
}

func (x *ReplicaID) GetStorageName() string {
	if x != nil {
		return x.StorageName
	}
	return ""
}

func (x *ReplicaID) GetMetadata() *ReplicaID_Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ReplicaID) GetType() ReplicaID_ReplicaType {
	if x != nil {
		return x.Type
	}
	return ReplicaID_REPLICA_TYPE_UNSPECIFIED
}

// RaftMessageRequest is a request for the SendMessage RPC. It serves as a
// wrapper for raftpb.Message. etcd/raft's state machines on each member emit
// this message. Since Gitaly employs multi-raft, routing metadata is attached
// to ensure the message reaches the correct Raft group inside the receiving
// Gitaly server.
type RaftMessageRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// cluster_id is the identifier of the Raft cluster to which this message belongs.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// replica_id uniquely identifies a replica in the Raft cluster.
	ReplicaId *ReplicaID `protobuf:"bytes,2,opt,name=replica_id,json=replicaId,proto3" json:"replica_id,omitempty"`
	// message is the Raft message to be delivered.
	Message       *raftpb.Message `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftMessageRequest) Reset() {
	*x = RaftMessageRequest{}
	mi := &file_cluster_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftMessageRequest) ProtoMessage() {}

func (x *RaftMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftMessageRequest.ProtoReflect.Descriptor instead.
func (*RaftMessageRequest) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *RaftMessageRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *RaftMessageRequest) GetReplicaId() *ReplicaID {
	if x != nil {
		return x.ReplicaId
	}
	return nil
}

func (x *RaftMessageRequest) GetMessage() *raftpb.Message {
	if x != nil {
		return x.Message
	}
	return nil
}

// RaftMessageResponse represents a response to the SendMessage RPC.
type RaftMessageResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftMessageResponse) Reset() {
	*x = RaftMessageResponse{}
	mi := &file_cluster_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftMessageResponse) ProtoMessage() {}

func (x *RaftMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftMessageResponse.ProtoReflect.Descriptor instead.
func (*RaftMessageResponse) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{4}
}

// RaftSnapshotMessageRequest is the input to SendSnapshot RPC.
type RaftSnapshotMessageRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to RaftSnapshotPayload:
	//
	//	*RaftSnapshotMessageRequest_RaftMsg
	//	*RaftSnapshotMessageRequest_Chunk
	RaftSnapshotPayload isRaftSnapshotMessageRequest_RaftSnapshotPayload `protobuf_oneof:"raft_snapshot_payload"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *RaftSnapshotMessageRequest) Reset() {
	*x = RaftSnapshotMessageRequest{}
	mi := &file_cluster_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftSnapshotMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftSnapshotMessageRequest) ProtoMessage() {}

func (x *RaftSnapshotMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftSnapshotMessageRequest.ProtoReflect.Descriptor instead.
func (*RaftSnapshotMessageRequest) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *RaftSnapshotMessageRequest) GetRaftSnapshotPayload() isRaftSnapshotMessageRequest_RaftSnapshotPayload {
	if x != nil {
		return x.RaftSnapshotPayload
	}
	return nil
}

func (x *RaftSnapshotMessageRequest) GetRaftMsg() *RaftMessageRequest {
	if x != nil {
		if x, ok := x.RaftSnapshotPayload.(*RaftSnapshotMessageRequest_RaftMsg); ok {
			return x.RaftMsg
		}
	}
	return nil
}

func (x *RaftSnapshotMessageRequest) GetChunk() []byte {
	if x != nil {
		if x, ok := x.RaftSnapshotPayload.(*RaftSnapshotMessageRequest_Chunk); ok {
			return x.Chunk
		}
	}
	return nil
}

type isRaftSnapshotMessageRequest_RaftSnapshotPayload interface {
	isRaftSnapshotMessageRequest_RaftSnapshotPayload()
}

type RaftSnapshotMessageRequest_RaftMsg struct {
	// raft_msg is a wrapper for raftpb.Message
	RaftMsg *RaftMessageRequest `protobuf:"bytes,1,opt,name=raft_msg,json=raftMsg,proto3,oneof"`
}

type RaftSnapshotMessageRequest_Chunk struct {
	// chunk of snapshot data
	Chunk []byte `protobuf:"bytes,2,opt,name=chunk,proto3,oneof"`
}

func (*RaftSnapshotMessageRequest_RaftMsg) isRaftSnapshotMessageRequest_RaftSnapshotPayload() {}

func (*RaftSnapshotMessageRequest_Chunk) isRaftSnapshotMessageRequest_RaftSnapshotPayload() {}

// RaftSnapshotMessageResponse is the response to SendSnapshot RPC.
type RaftSnapshotMessageResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// destination is where the snapshot is saved.
	Destination string `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// snapshot_size is the snapshot size in bytes.
	SnapshotSize  uint64 `protobuf:"varint,2,opt,name=snapshot_size,json=snapshotSize,proto3" json:"snapshot_size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftSnapshotMessageResponse) Reset() {
	*x = RaftSnapshotMessageResponse{}
	mi := &file_cluster_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftSnapshotMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftSnapshotMessageResponse) ProtoMessage() {}

func (x *RaftSnapshotMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftSnapshotMessageResponse.ProtoReflect.Descriptor instead.
func (*RaftSnapshotMessageResponse) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *RaftSnapshotMessageResponse) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *RaftSnapshotMessageResponse) GetSnapshotSize() uint64 {
	if x != nil {
		return x.SnapshotSize
	}
	return 0
}

// JoinClusterRequest is sent by the leader to a new node to join a specific partition.
type JoinClusterRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// partition_key identifies which partition the new node should join.
	PartitionKey *RaftPartitionKey `protobuf:"bytes,1,opt,name=partition_key,json=partitionKey,proto3" json:"partition_key,omitempty"`
	// leader_id is the Member ID of the current Raft group leader
	LeaderId uint64 `protobuf:"varint,2,opt,name=leader_id,json=leaderId,proto3" json:"leader_id,omitempty"`
	// member_id is the unique Raft member ID assigned by the leader for this replica.
	MemberId uint64 `protobuf:"varint,3,opt,name=member_id,json=memberId,proto3" json:"member_id,omitempty"`
	// term is logical time in the Raft cluster
	Term uint64 `protobuf:"varint,4,opt,name=term,proto3" json:"term,omitempty"`
	// index refers to the position of a log entry
	Index uint64 `protobuf:"varint,5,opt,name=index,proto3" json:"index,omitempty"`
	// storage_name is the name of the storage where the replica should be created.
	StorageName string `protobuf:"bytes,6,opt,name=storage_name,json=storageName,proto3" json:"storage_name,omitempty"`
	// relative_path is the path within the storage where the partition data is located.
	RelativePath string `protobuf:"bytes,7,opt,name=relative_path,json=relativePath,proto3" json:"relative_path,omitempty"`
	// replicas contains the current list of all cluster members for routing table initialization.
	Replicas      []*ReplicaID `protobuf:"bytes,8,rep,name=replicas,proto3" json:"replicas,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JoinClusterRequest) Reset() {
	*x = JoinClusterRequest{}
	mi := &file_cluster_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JoinClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JoinClusterRequest) ProtoMessage() {}

func (x *JoinClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JoinClusterRequest.ProtoReflect.Descriptor instead.
func (*JoinClusterRequest) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *JoinClusterRequest) GetPartitionKey() *RaftPartitionKey {
	if x != nil {
		return x.PartitionKey
	}
	return nil
}

func (x *JoinClusterRequest) GetLeaderId() uint64 {
	if x != nil {
		return x.LeaderId
	}
	return 0
}

func (x *JoinClusterRequest) GetMemberId() uint64 {
	if x != nil {
		return x.MemberId
	}
	return 0
}

func (x *JoinClusterRequest) GetTerm() uint64 {
	if x != nil {
		return x.Term
	}
	return 0
}

func (x *JoinClusterRequest) GetIndex() uint64 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *JoinClusterRequest) GetStorageName() string {
	if x != nil {
		return x.StorageName
	}
	return ""
}

func (x *JoinClusterRequest) GetRelativePath() string {
	if x != nil {
		return x.RelativePath
	}
	return ""
}

func (x *JoinClusterRequest) GetReplicas() []*ReplicaID {
	if x != nil {
		return x.Replicas
	}
	return nil
}

// JoinClusterResponse indicates the result of the join operation.
type JoinClusterResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JoinClusterResponse) Reset() {
	*x = JoinClusterResponse{}
	mi := &file_cluster_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JoinClusterResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JoinClusterResponse) ProtoMessage() {}

func (x *JoinClusterResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JoinClusterResponse.ProtoReflect.Descriptor instead.
func (*JoinClusterResponse) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{8}
}

// RaftClusterInfoRequest is the request for the GetClusterInfo RPC.
type RaftClusterInfoRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// cluster_id is the identifier of the Raft cluster to query.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// partition_key is an optional filter to get information about a specific partition.
	// If not provided, returns information about all partitions.
	PartitionKey *RaftPartitionKey `protobuf:"bytes,2,opt,name=partition_key,json=partitionKey,proto3" json:"partition_key,omitempty"`
	// include_replica_details determines whether to include detailed replica state information.
	IncludeReplicaDetails bool `protobuf:"varint,3,opt,name=include_replica_details,json=includeReplicaDetails,proto3" json:"include_replica_details,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *RaftClusterInfoRequest) Reset() {
	*x = RaftClusterInfoRequest{}
	mi := &file_cluster_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftClusterInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftClusterInfoRequest) ProtoMessage() {}

func (x *RaftClusterInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftClusterInfoRequest.ProtoReflect.Descriptor instead.
func (*RaftClusterInfoRequest) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *RaftClusterInfoRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *RaftClusterInfoRequest) GetPartitionKey() *RaftPartitionKey {
	if x != nil {
		return x.PartitionKey
	}
	return nil
}

func (x *RaftClusterInfoRequest) GetIncludeReplicaDetails() bool {
	if x != nil {
		return x.IncludeReplicaDetails
	}
	return false
}

// RaftClusterInfoResponse is the response for the GetClusterInfo streaming RPC.
// Each response message contains information about a single partition.
type RaftClusterInfoResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// cluster_id is the identifier of the Raft cluster.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// partition_key identifies the partition this response describes.
	PartitionKey *RaftPartitionKey `protobuf:"bytes,2,opt,name=partition_key,json=partitionKey,proto3" json:"partition_key,omitempty"`
	// replicas contains information about all replicas in this partition.
	Replicas []*RaftClusterInfoResponse_ReplicaStatus `protobuf:"bytes,3,rep,name=replicas,proto3" json:"replicas,omitempty"`
	// leader_id is the member ID of the current leader, 0 if no leader.
	LeaderId uint64 `protobuf:"varint,4,opt,name=leader_id,json=leaderId,proto3" json:"leader_id,omitempty"`
	// term is the current Raft term for this partition.
	Term uint64 `protobuf:"varint,5,opt,name=term,proto3" json:"term,omitempty"`
	// index is the current Raft log index for this partition.
	Index uint64 `protobuf:"varint,6,opt,name=index,proto3" json:"index,omitempty"`
	// relative_path is the repository path for backward compatibility.
	RelativePath  string `protobuf:"bytes,7,opt,name=relative_path,json=relativePath,proto3" json:"relative_path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftClusterInfoResponse) Reset() {
	*x = RaftClusterInfoResponse{}
	mi := &file_cluster_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftClusterInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftClusterInfoResponse) ProtoMessage() {}

func (x *RaftClusterInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftClusterInfoResponse.ProtoReflect.Descriptor instead.
func (*RaftClusterInfoResponse) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *RaftClusterInfoResponse) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *RaftClusterInfoResponse) GetPartitionKey() *RaftPartitionKey {
	if x != nil {
		return x.PartitionKey
	}
	return nil
}

func (x *RaftClusterInfoResponse) GetReplicas() []*RaftClusterInfoResponse_ReplicaStatus {
	if x != nil {
		return x.Replicas
	}
	return nil
}

func (x *RaftClusterInfoResponse) GetLeaderId() uint64 {
	if x != nil {
		return x.LeaderId
	}
	return 0
}

func (x *RaftClusterInfoResponse) GetTerm() uint64 {
	if x != nil {
		return x.Term
	}
	return 0
}

func (x *RaftClusterInfoResponse) GetIndex() uint64 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *RaftClusterInfoResponse) GetRelativePath() string {
	if x != nil {
		return x.RelativePath
	}
	return ""
}

// LogData contains serialized log data, including the log entry itself
// and all attached files in the log entry's directory. These data are
// exchanged at the Transport layer before sending and after receiving
// messages. They remain transparent to the core Raft engine.
type RaftEntry_LogData struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// local_path is the path to the staging log entry directory. Before the
	// request is sent to other nodes, this whole directory of the entry is
	// serialized. So, this field is only relevant to the primary node who
	// issues the request.
	LocalPath []byte `protobuf:"bytes,1,opt,name=local_path,json=localPath,proto3" json:"local_path,omitempty"`
	// packed is the serialized form of the log entry data. Transport
	// implementations populates this field before sending out messages to other
	// members of a Raft group.
	Packed        []byte `protobuf:"bytes,2,opt,name=packed,proto3" json:"packed,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftEntry_LogData) Reset() {
	*x = RaftEntry_LogData{}
	mi := &file_cluster_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftEntry_LogData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftEntry_LogData) ProtoMessage() {}

func (x *RaftEntry_LogData) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftEntry_LogData.ProtoReflect.Descriptor instead.
func (*RaftEntry_LogData) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{0, 0}
}

func (x *RaftEntry_LogData) GetLocalPath() []byte {
	if x != nil {
		return x.LocalPath
	}
	return nil
}

func (x *RaftEntry_LogData) GetPacked() []byte {
	if x != nil {
		return x.Packed
	}
	return nil
}

// Metadata contains routing information for the replica.
type ReplicaID_Metadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// address is the network address of the replica.
	Address       string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReplicaID_Metadata) Reset() {
	*x = ReplicaID_Metadata{}
	mi := &file_cluster_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicaID_Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicaID_Metadata) ProtoMessage() {}

func (x *ReplicaID_Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicaID_Metadata.ProtoReflect.Descriptor instead.
func (*ReplicaID_Metadata) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ReplicaID_Metadata) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// ReplicaStatus contains status information about a single replica.
type RaftClusterInfoResponse_ReplicaStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// replica_id uniquely identifies the replica.
	ReplicaId *ReplicaID `protobuf:"bytes,1,opt,name=replica_id,json=replicaId,proto3" json:"replica_id,omitempty"`
	// is_leader indicates whether this replica is currently the leader.
	IsLeader bool `protobuf:"varint,2,opt,name=is_leader,json=isLeader,proto3" json:"is_leader,omitempty"`
	// is_healthy indicates whether the replica is reachable and functioning.
	IsHealthy bool `protobuf:"varint,3,opt,name=is_healthy,json=isHealthy,proto3" json:"is_healthy,omitempty"`
	// last_index is the index of the last log entry this replica has.
	LastIndex uint64 `protobuf:"varint,4,opt,name=last_index,json=lastIndex,proto3" json:"last_index,omitempty"`
	// match_index is the highest log index known to be replicated on this replica.
	MatchIndex uint64 `protobuf:"varint,5,opt,name=match_index,json=matchIndex,proto3" json:"match_index,omitempty"`
	// state represents the Raft state of this replica (follower, candidate, leader).
	State         string `protobuf:"bytes,6,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RaftClusterInfoResponse_ReplicaStatus) Reset() {
	*x = RaftClusterInfoResponse_ReplicaStatus{}
	mi := &file_cluster_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaftClusterInfoResponse_ReplicaStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftClusterInfoResponse_ReplicaStatus) ProtoMessage() {}

func (x *RaftClusterInfoResponse_ReplicaStatus) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftClusterInfoResponse_ReplicaStatus.ProtoReflect.Descriptor instead.
func (*RaftClusterInfoResponse_ReplicaStatus) Descriptor() ([]byte, []int) {
	return file_cluster_proto_rawDescGZIP(), []int{10, 0}
}

func (x *RaftClusterInfoResponse_ReplicaStatus) GetReplicaId() *ReplicaID {
	if x != nil {
		return x.ReplicaId
	}
	return nil
}

func (x *RaftClusterInfoResponse_ReplicaStatus) GetIsLeader() bool {
	if x != nil {
		return x.IsLeader
	}
	return false
}

func (x *RaftClusterInfoResponse_ReplicaStatus) GetIsHealthy() bool {
	if x != nil {
		return x.IsHealthy
	}
	return false
}

func (x *RaftClusterInfoResponse_ReplicaStatus) GetLastIndex() uint64 {
	if x != nil {
		return x.LastIndex
	}
	return 0
}

func (x *RaftClusterInfoResponse_ReplicaStatus) GetMatchIndex() uint64 {
	if x != nil {
		return x.MatchIndex
	}
	return 0
}

func (x *RaftClusterInfoResponse_ReplicaStatus) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

var File_cluster_proto protoreflect.FileDescriptor

var file_cluster_proto_rawDesc = string([]byte{
	0x0a, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x06, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x1a, 0x0a, 0x6c, 0x69, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x11, 0x72, 0x61, 0x66, 0x74, 0x70, 0x62, 0x2f, 0x72, 0x61, 0x66, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8c, 0x01, 0x0a, 0x09, 0x52, 0x61, 0x66, 0x74, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x2d, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61, 0x66, 0x74,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4c, 0x6f, 0x67, 0x44, 0x61, 0x74, 0x61, 0x52, 0x04, 0x64,
	0x61, 0x74, 0x61, 0x1a, 0x40, 0x0a, 0x07, 0x4c, 0x6f, 0x67, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1d,
	0x0a, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x12, 0x16, 0x0a,
	0x06, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x70,
	0x61, 0x63, 0x6b, 0x65, 0x64, 0x22, 0x28, 0x0a, 0x10, 0x52, 0x61, 0x66, 0x74, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0xfa, 0x02, 0x0a, 0x09, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49, 0x44, 0x12, 0x3d, 0x0a,
	0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61,
	0x66, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0c,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x1b, 0x0a, 0x09,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x08, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49,
	0x44, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x31, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x49, 0x44, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x24, 0x0a, 0x08, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x5d, 0x0a,
	0x0b, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18,
	0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45,
	0x50, 0x4c, 0x49, 0x43, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x56, 0x4f, 0x54, 0x45, 0x52,
	0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x4c, 0x45, 0x41, 0x52, 0x4e, 0x45, 0x52, 0x10, 0x02, 0x22, 0x90, 0x01, 0x0a,
	0x12, 0x52, 0x61, 0x66, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x30, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49, 0x44, 0x52, 0x09, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x72, 0x61, 0x66, 0x74, 0x70, 0x62, 0x2e, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22,
	0x15, 0x0a, 0x13, 0x52, 0x61, 0x66, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x86, 0x01, 0x0a, 0x1a, 0x52, 0x61, 0x66, 0x74, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x08, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x6d, 0x73,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79,
	0x2e, 0x52, 0x61, 0x66, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x72, 0x61, 0x66, 0x74, 0x4d, 0x73, 0x67, 0x12, 0x16,
	0x0a, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52,
	0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x42, 0x17, 0x0a, 0x15, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22,
	0x64, 0x0a, 0x1b, 0x52, 0x61, 0x66, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xb4, 0x02, 0x0a, 0x12, 0x4a, 0x6f, 0x69, 0x6e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x0d,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61, 0x66,
	0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0c, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x6c,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08,
	0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x72, 0x6d, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x04, 0x74, 0x65, 0x72, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x27, 0x0a, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0x88, 0xc6, 0x2c, 0x01, 0x52, 0x0b, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x2d, 0x0a,
	0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x49, 0x44, 0x52, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x22, 0x15, 0x0a, 0x13,
	0x4a, 0x6f, 0x69, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0xae, 0x01, 0x0a, 0x16, 0x52, 0x61, 0x66, 0x74, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x3d, 0x0a,
	0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61,
	0x66, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0c,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x36, 0x0a, 0x17,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x22, 0x84, 0x04, 0x0a, 0x17, 0x52, 0x61, 0x66, 0x74, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x3d, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e,
	0x52, 0x61, 0x66, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x49,
	0x0a, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61, 0x66, 0x74, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x6c, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x72, 0x6d, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x74, 0x65, 0x72, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x50, 0x61, 0x74, 0x68, 0x1a, 0xd3, 0x01, 0x0a, 0x0d, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x30, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x69,
	0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49, 0x44, 0x52, 0x09,
	0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x73, 0x5f,
	0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x69, 0x73,
	0x4c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73, 0x5f, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x73, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x6c, 0x61, 0x73, 0x74, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x32, 0xf7, 0x02, 0x0a, 0x0b,
	0x52, 0x61, 0x66, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x52, 0x0a, 0x0b, 0x53,
	0x65, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1a, 0x2e, 0x67, 0x69, 0x74,
	0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61, 0x66, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e,
	0x52, 0x61, 0x66, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x08, 0xfa, 0x97, 0x28, 0x04, 0x08, 0x01, 0x10, 0x02, 0x28, 0x01, 0x12,
	0x63, 0x0a, 0x0c, 0x53, 0x65, 0x6e, 0x64, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12,
	0x22, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61, 0x66, 0x74, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x52, 0x61, 0x66,
	0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x08, 0xfa, 0x97, 0x28, 0x04, 0x08, 0x01,
	0x10, 0x02, 0x28, 0x01, 0x12, 0x50, 0x0a, 0x0b, 0x4a, 0x6f, 0x69, 0x6e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x1a, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x4a, 0x6f, 0x69,
	0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1b, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x4a, 0x6f, 0x69, 0x6e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x08, 0xfa, 0x97,
	0x28, 0x04, 0x08, 0x01, 0x10, 0x02, 0x12, 0x5d, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1e, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c,
	0x79, 0x2e, 0x52, 0x61, 0x66, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c,
	0x79, 0x2e, 0x52, 0x61, 0x66, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x08, 0xfa, 0x97, 0x28, 0x04, 0x08,
	0x02, 0x10, 0x02, 0x30, 0x01, 0x42, 0x34, 0x5a, 0x32, 0x67, 0x69, 0x74, 0x6c, 0x61, 0x62, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x69, 0x74, 0x6c, 0x61, 0x62, 0x2d, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x69, 0x74, 0x61, 0x6c, 0x79, 0x2f, 0x76, 0x31, 0x36, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x2f, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
})

var (
	file_cluster_proto_rawDescOnce sync.Once
	file_cluster_proto_rawDescData []byte
)

func file_cluster_proto_rawDescGZIP() []byte {
	file_cluster_proto_rawDescOnce.Do(func() {
		file_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_cluster_proto_rawDesc), len(file_cluster_proto_rawDesc)))
	})
	return file_cluster_proto_rawDescData
}

var file_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_cluster_proto_goTypes = []any{
	(ReplicaID_ReplicaType)(0),                    // 0: gitaly.ReplicaID.ReplicaType
	(*RaftEntry)(nil),                             // 1: gitaly.RaftEntry
	(*RaftPartitionKey)(nil),                      // 2: gitaly.RaftPartitionKey
	(*ReplicaID)(nil),                             // 3: gitaly.ReplicaID
	(*RaftMessageRequest)(nil),                    // 4: gitaly.RaftMessageRequest
	(*RaftMessageResponse)(nil),                   // 5: gitaly.RaftMessageResponse
	(*RaftSnapshotMessageRequest)(nil),            // 6: gitaly.RaftSnapshotMessageRequest
	(*RaftSnapshotMessageResponse)(nil),           // 7: gitaly.RaftSnapshotMessageResponse
	(*JoinClusterRequest)(nil),                    // 8: gitaly.JoinClusterRequest
	(*JoinClusterResponse)(nil),                   // 9: gitaly.JoinClusterResponse
	(*RaftClusterInfoRequest)(nil),                // 10: gitaly.RaftClusterInfoRequest
	(*RaftClusterInfoResponse)(nil),               // 11: gitaly.RaftClusterInfoResponse
	(*RaftEntry_LogData)(nil),                     // 12: gitaly.RaftEntry.LogData
	(*ReplicaID_Metadata)(nil),                    // 13: gitaly.ReplicaID.Metadata
	(*RaftClusterInfoResponse_ReplicaStatus)(nil), // 14: gitaly.RaftClusterInfoResponse.ReplicaStatus
	(*raftpb.Message)(nil),                        // 15: raftpb.Message
}
var file_cluster_proto_depIdxs = []int32{
	12, // 0: gitaly.RaftEntry.data:type_name -> gitaly.RaftEntry.LogData
	2,  // 1: gitaly.ReplicaID.partition_key:type_name -> gitaly.RaftPartitionKey
	13, // 2: gitaly.ReplicaID.metadata:type_name -> gitaly.ReplicaID.Metadata
	0,  // 3: gitaly.ReplicaID.type:type_name -> gitaly.ReplicaID.ReplicaType
	3,  // 4: gitaly.RaftMessageRequest.replica_id:type_name -> gitaly.ReplicaID
	15, // 5: gitaly.RaftMessageRequest.message:type_name -> raftpb.Message
	4,  // 6: gitaly.RaftSnapshotMessageRequest.raft_msg:type_name -> gitaly.RaftMessageRequest
	2,  // 7: gitaly.JoinClusterRequest.partition_key:type_name -> gitaly.RaftPartitionKey
	3,  // 8: gitaly.JoinClusterRequest.replicas:type_name -> gitaly.ReplicaID
	2,  // 9: gitaly.RaftClusterInfoRequest.partition_key:type_name -> gitaly.RaftPartitionKey
	2,  // 10: gitaly.RaftClusterInfoResponse.partition_key:type_name -> gitaly.RaftPartitionKey
	14, // 11: gitaly.RaftClusterInfoResponse.replicas:type_name -> gitaly.RaftClusterInfoResponse.ReplicaStatus
	3,  // 12: gitaly.RaftClusterInfoResponse.ReplicaStatus.replica_id:type_name -> gitaly.ReplicaID
	4,  // 13: gitaly.RaftService.SendMessage:input_type -> gitaly.RaftMessageRequest
	6,  // 14: gitaly.RaftService.SendSnapshot:input_type -> gitaly.RaftSnapshotMessageRequest
	8,  // 15: gitaly.RaftService.JoinCluster:input_type -> gitaly.JoinClusterRequest
	10, // 16: gitaly.RaftService.GetClusterInfo:input_type -> gitaly.RaftClusterInfoRequest
	5,  // 17: gitaly.RaftService.SendMessage:output_type -> gitaly.RaftMessageResponse
	7,  // 18: gitaly.RaftService.SendSnapshot:output_type -> gitaly.RaftSnapshotMessageResponse
	9,  // 19: gitaly.RaftService.JoinCluster:output_type -> gitaly.JoinClusterResponse
	11, // 20: gitaly.RaftService.GetClusterInfo:output_type -> gitaly.RaftClusterInfoResponse
	17, // [17:21] is the sub-list for method output_type
	13, // [13:17] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_cluster_proto_init() }
func file_cluster_proto_init() {
	if File_cluster_proto != nil {
		return
	}
	file_lint_proto_init()
	file_cluster_proto_msgTypes[5].OneofWrappers = []any{
		(*RaftSnapshotMessageRequest_RaftMsg)(nil),
		(*RaftSnapshotMessageRequest_Chunk)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_cluster_proto_rawDesc), len(file_cluster_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_cluster_proto_goTypes,
		DependencyIndexes: file_cluster_proto_depIdxs,
		EnumInfos:         file_cluster_proto_enumTypes,
		MessageInfos:      file_cluster_proto_msgTypes,
	}.Build()
	File_cluster_proto = out.File
	file_cluster_proto_goTypes = nil
	file_cluster_proto_depIdxs = nil
}
