/* gitg-repository.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-repository.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <glib.h>
#include <libgit2-glib/ggit.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_REPOSITORY_0_PROPERTY,
	GITG_REPOSITORY_NAME_PROPERTY,
	GITG_REPOSITORY_STAGE_PROPERTY,
	GITG_REPOSITORY_NUM_PROPERTIES
};
static GParamSpec* gitg_repository_properties[GITG_REPOSITORY_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _GitgRepositoryPrivate {
	GHashTable* d_refs;
	GitgStage* d_stage;
};

static gint GitgRepository_private_offset;
static gpointer gitg_repository_parent_class = NULL;

static void gitg_repository_ensure_refs_add (GitgRepository* self,
                                      GgitOId* id,
                                      GitgRef* r);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void gitg_repository_ensure_refs (GitgRepository* self);
static guint _ggit_oid_hash_ghash_func (gconstpointer key);
static gboolean _ggit_oid_equal_gequal_func (gconstpointer a,
                                      gconstpointer b);
static void _vala_GgitOId_free (GgitOId* self);
static void __vala_GgitOId_free0_ (gpointer var);
static void __g_slist_free__g_object_unref0_0_ (gpointer var);
static gint ___lambda30_ (GitgRepository* self,
                   const gchar* name);
static gint ____lambda30__ggit_references_name_callback (const gchar* name,
                                                  gpointer self);
VALA_EXTERN GitgStage* gitg_stage_new (GitgRepository* repository);
VALA_EXTERN GitgStage* gitg_stage_construct (GType object_type,
                                 GitgRepository* repository);
static void gitg_repository_finalize (GObject * obj);
static GType gitg_repository_get_type_once (void);
static void _vala_gitg_repository_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
gitg_repository_get_instance_private (GitgRepository* self)
{
	return G_STRUCT_MEMBER_P (self, GitgRepository_private_offset);
}

GitgRepository*
gitg_repository_construct (GType object_type,
                           GFile* location,
                           GFile* workdir,
                           GError** error)
{
	GitgRepository * self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (location != NULL, NULL);
	self = (GitgRepository*) g_object_new (object_type, "location", location, "workdir", workdir, NULL);
	g_initable_init (G_TYPE_CHECK_INSTANCE_CAST (self, g_initable_get_type (), GInitable), NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}

GitgRepository*
gitg_repository_new (GFile* location,
                     GFile* workdir,
                     GError** error)
{
	return gitg_repository_construct (GITG_TYPE_REPOSITORY, location, workdir, error);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GgitOId*
_vala_GgitOId_copy (GgitOId* self)
{
	return g_boxed_copy (ggit_oid_get_type (), self);
}

static gpointer
__vala_GgitOId_copy0 (gpointer self)
{
	return self ? _vala_GgitOId_copy (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
gitg_repository_ensure_refs_add (GitgRepository* self,
                                 GgitOId* id,
                                 GitgRef* r)
{
	GSList* refs = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	if (id == NULL) {
		return;
	}
	_tmp0_ = self->priv->d_refs;
	_tmp2_ = g_hash_table_lookup_extended (_tmp0_, id, NULL, &_tmp1_);
	refs = (GSList*) _tmp1_;
	if (_tmp2_) {
		GitgRef* _tmp3_;
		_tmp3_ = _g_object_ref0 (r);
		refs = g_slist_append (refs, _tmp3_);
	} else {
		GSList* nrefs = NULL;
		GitgRef* _tmp4_;
		GHashTable* _tmp5_;
		GgitOId* _tmp6_;
		GSList* _tmp7_;
		nrefs = NULL;
		_tmp4_ = _g_object_ref0 (r);
		nrefs = g_slist_append (nrefs, _tmp4_);
		_tmp5_ = self->priv->d_refs;
		_tmp6_ = __vala_GgitOId_copy0 (id);
		_tmp7_ = nrefs;
		nrefs = NULL;
		g_hash_table_insert (_tmp5_, _tmp6_, _tmp7_);
		(nrefs == NULL) ? NULL : (nrefs = (_g_slist_free__g_object_unref0_ (nrefs), NULL));
	}
}

void
gitg_repository_clear_refs_cache (GitgRepository* self)
{
	g_return_if_fail (self != NULL);
	_g_hash_table_unref0 (self->priv->d_refs);
	self->priv->d_refs = NULL;
}

static guint
_ggit_oid_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = ggit_oid_hash (key);
	return result;
}

static gboolean
_ggit_oid_equal_gequal_func (gconstpointer a,
                             gconstpointer b)
{
	gboolean result;
	result = ggit_oid_equal (a, (GgitOId*) b);
	return result;
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

static void
__vala_GgitOId_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL));
}

static void
__g_slist_free__g_object_unref0_0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL));
}

static gint
___lambda30_ (GitgRepository* self,
              const gchar* name)
{
	GitgRef* r = NULL;
	GitgRef* _tmp4_;
	GgitOId* id = NULL;
	GitgRef* _tmp5_;
	GgitOId* _tmp6_;
	GgitOId* _tmp7_;
	GgitOId* _tmp8_;
	GitgRef* _tmp9_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (name != NULL, 0);
	{
		GitgRef* _tmp0_ = NULL;
		GitgRef* _tmp1_;
		GitgRef* _tmp2_;
		_tmp1_ = gitg_repository_lookup_reference (self, name, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (r);
		r = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = 0;
		_g_object_unref0 (r);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp3_ = -1;
		_g_object_unref0 (r);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	_tmp4_ = r;
	if (_tmp4_ == NULL) {
		result = 0;
		_g_object_unref0 (r);
		return result;
	}
	_tmp5_ = r;
	_tmp6_ = ggit_ref_get_target ((GgitRef*) _tmp5_);
	id = _tmp6_;
	_tmp7_ = id;
	if (_tmp7_ == NULL) {
		result = 0;
		__vala_GgitOId_free0 (id);
		_g_object_unref0 (r);
		return result;
	}
	_tmp8_ = id;
	_tmp9_ = r;
	gitg_repository_ensure_refs_add (self, _tmp8_, _tmp9_);
	{
		GgitTag* tag = NULL;
		GgitOId* _tmp10_;
		gpointer _tmp11_;
		GgitTag* _tmp12_;
		GgitOId* _tmp13_;
		GgitOId* _tmp14_;
		_tmp10_ = id;
		_tmp11_ = gitg_repository_lookup (self, ggit_tag_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp10_, &_inner_error0_);
		tag = (GgitTag*) _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp12_ = tag;
		_tmp13_ = ggit_tag_get_target_id (_tmp12_);
		__vala_GgitOId_free0 (id);
		id = _tmp13_;
		_tmp14_ = id;
		if (_tmp14_ != NULL) {
			GgitOId* _tmp15_;
			GitgRef* _tmp16_;
			_tmp15_ = id;
			_tmp16_ = r;
			gitg_repository_ensure_refs_add (self, _tmp15_, _tmp16_);
		}
		_g_object_unref0 (tag);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp17_ = -1;
		__vala_GgitOId_free0 (id);
		_g_object_unref0 (r);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp17_;
	}
	result = 0;
	__vala_GgitOId_free0 (id);
	_g_object_unref0 (r);
	return result;
}

static gint
____lambda30__ggit_references_name_callback (const gchar* name,
                                             gpointer self)
{
	gint result;
	result = ___lambda30_ ((GitgRepository*) self, name);
	return result;
}

static void
gitg_repository_ensure_refs (GitgRepository* self)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_refs;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_hash_table_new_full (_ggit_oid_hash_ghash_func, _ggit_oid_equal_gequal_func, __vala_GgitOId_free0_, __g_slist_free__g_object_unref0_0_);
	_g_hash_table_unref0 (self->priv->d_refs);
	self->priv->d_refs = _tmp1_;
	{
		ggit_repository_references_foreach_name ((GgitRepository*) self, ____lambda30__ggit_references_name_callback, self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

GSList*
gitg_repository_refs_for_id (GitgRepository* self,
                             GgitOId* id)
{
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	gitg_repository_ensure_refs (self);
	_tmp0_ = self->priv->d_refs;
	_tmp1_ = g_hash_table_lookup (_tmp0_, id);
	result = (GSList*) _tmp1_;
	return result;
}

gpointer
gitg_repository_lookup (GitgRepository* self,
                        GType t_type,
                        GBoxedCopyFunc t_dup_func,
                        GDestroyNotify t_destroy_func,
                        GgitOId* id,
                        GError** error)
{
	GgitObject* _tmp0_ = NULL;
	GgitObject* _tmp1_;
	gpointer _tmp2_;
	GError* _inner_error0_ = NULL;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp1_ = ggit_repository_lookup (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), id, t_type, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = ((((gconstpointer) _tmp0_) != NULL) && (t_dup_func != NULL)) ? t_dup_func ((gpointer) ((gconstpointer) _tmp0_)) : ((gpointer) ((gconstpointer) _tmp0_));
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

GitgRef*
gitg_repository_lookup_reference (GitgRepository* self,
                                  const gchar* name,
                                  GError** error)
{
	GgitRef* _tmp0_ = NULL;
	GgitRef* _tmp1_;
	GitgRef* _tmp2_;
	GError* _inner_error0_ = NULL;
	GitgRef* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp1_ = ggit_repository_lookup_reference (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), name, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _g_object_ref0 (GITG_IS_REF (_tmp0_) ? ((GitgRef*) _tmp0_) : NULL);
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

GitgRef*
gitg_repository_lookup_reference_dwim (GitgRepository* self,
                                       const gchar* short_name,
                                       GError** error)
{
	GgitRef* _tmp0_ = NULL;
	GgitRef* _tmp1_;
	GitgRef* _tmp2_;
	GError* _inner_error0_ = NULL;
	GitgRef* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (short_name != NULL, NULL);
	_tmp1_ = ggit_repository_lookup_reference_dwim (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), short_name, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _g_object_ref0 (GITG_IS_REF (_tmp0_) ? ((GitgRef*) _tmp0_) : NULL);
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

GitgBranch*
gitg_repository_create_branch (GitgRepository* self,
                               const gchar* name,
                               GgitObject* obj,
                               GgitCreateFlags flags,
                               GError** error)
{
	GgitBranch* _tmp0_ = NULL;
	GgitBranch* _tmp1_;
	GitgBranch* _tmp2_;
	GError* _inner_error0_ = NULL;
	GitgBranch* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (obj != NULL, NULL);
	_tmp1_ = ggit_repository_create_branch (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), name, obj, flags, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _g_object_ref0 (GITG_IS_BRANCH (_tmp0_) ? ((GitgBranch*) _tmp0_) : NULL);
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

GitgRef*
gitg_repository_create_reference (GitgRepository* self,
                                  const gchar* name,
                                  GgitOId* oid,
                                  const gchar* message,
                                  GError** error)
{
	GgitRef* _tmp0_ = NULL;
	GgitRef* _tmp1_;
	GitgRef* _tmp2_;
	GError* _inner_error0_ = NULL;
	GitgRef* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (oid != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	_tmp1_ = ggit_repository_create_reference (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), name, oid, message, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _g_object_ref0 (GITG_IS_REF (_tmp0_) ? ((GitgRef*) _tmp0_) : NULL);
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

GitgRef*
gitg_repository_create_symbolic_reference (GitgRepository* self,
                                           const gchar* name,
                                           const gchar* target,
                                           const gchar* message,
                                           GError** error)
{
	GgitRef* _tmp0_ = NULL;
	GgitRef* _tmp1_;
	GitgRef* _tmp2_;
	GError* _inner_error0_ = NULL;
	GitgRef* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	_tmp1_ = ggit_repository_create_symbolic_reference (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), name, target, message, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _g_object_ref0 (GITG_IS_REF (_tmp0_) ? ((GitgRef*) _tmp0_) : NULL);
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

GitgRef*
gitg_repository_get_head (GitgRepository* self,
                          GError** error)
{
	GgitRef* _tmp0_ = NULL;
	GgitRef* _tmp1_;
	GitgRef* _tmp2_;
	GError* _inner_error0_ = NULL;
	GitgRef* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = ggit_repository_get_head (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_repository_get_type (), GgitRepository), &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _g_object_ref0 (GITG_IS_REF (_tmp0_) ? ((GitgRef*) _tmp0_) : NULL);
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

GitgRepository*
gitg_repository_init_repository (GFile* location,
                                 gboolean is_bare,
                                 GError** error)
{
	GgitRepository* _tmp0_ = NULL;
	GgitRepository* _tmp1_;
	GitgRepository* _tmp2_;
	GError* _inner_error0_ = NULL;
	GitgRepository* result;
	g_return_val_if_fail (location != NULL, NULL);
	_tmp1_ = ggit_repository_init_repository (location, is_bare, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _g_object_ref0 (GITG_IS_REPOSITORY (_tmp0_) ? ((GitgRepository*) _tmp0_) : NULL);
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

GgitSignature*
gitg_repository_get_signature_with_environment (GitgRepository* self,
                                                GeeMap* env,
                                                const gchar* envname,
                                                GError** error)
{
	gchar* user = NULL;
	gchar* email = NULL;
	GDateTime* date = NULL;
	gchar* nameenv = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* emailenv = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* dateenv = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp9_;
	const gchar* _tmp12_;
	GDateTime* _tmp20_;
	GgitConfig* _tmp22_ = NULL;
	GgitConfig* _tmp23_;
	GgitConfig* conf = NULL;
	GgitConfig* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp30_;
	const gchar* _tmp35_ = NULL;
	const gchar* _tmp36_;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp39_;
	GgitSignature* _tmp41_ = NULL;
	GDateTime* _tmp42_;
	GgitSignature* _tmp43_;
	GgitSignature* _tmp44_;
	GError* _inner_error0_ = NULL;
	GgitSignature* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (env != NULL, NULL);
	g_return_val_if_fail (envname != NULL, NULL);
	user = NULL;
	email = NULL;
	date = NULL;
	_tmp0_ = string_to_string (envname);
	_tmp1_ = g_strconcat ("GIT_", _tmp0_, "_NAME", NULL);
	nameenv = _tmp1_;
	_tmp2_ = string_to_string (envname);
	_tmp3_ = g_strconcat ("GIT_", _tmp2_, "_EMAIL", NULL);
	emailenv = _tmp3_;
	_tmp4_ = string_to_string (envname);
	_tmp5_ = g_strconcat ("GIT_", _tmp4_, "_DATE", NULL);
	dateenv = _tmp5_;
	_tmp6_ = nameenv;
	if (gee_map_has_key (env, _tmp6_)) {
		const gchar* _tmp7_;
		gpointer _tmp8_;
		_tmp7_ = nameenv;
		_tmp8_ = gee_map_get (env, _tmp7_);
		_g_free0 (user);
		user = (gchar*) _tmp8_;
	}
	_tmp9_ = emailenv;
	if (gee_map_has_key (env, _tmp9_)) {
		const gchar* _tmp10_;
		gpointer _tmp11_;
		_tmp10_ = emailenv;
		_tmp11_ = gee_map_get (env, _tmp10_);
		_g_free0 (email);
		email = (gchar*) _tmp11_;
	}
	_tmp12_ = dateenv;
	if (gee_map_has_key (env, _tmp12_)) {
		{
			GDateTime* _tmp13_ = NULL;
			const gchar* _tmp14_;
			gpointer _tmp15_;
			gchar* _tmp16_;
			GDateTime* _tmp17_;
			GDateTime* _tmp18_;
			GDateTime* _tmp19_;
			_tmp14_ = dateenv;
			_tmp15_ = gee_map_get (env, _tmp14_);
			_tmp16_ = (gchar*) _tmp15_;
			_tmp17_ = gitg_date_parse (_tmp16_, &_inner_error0_);
			_tmp18_ = _tmp17_;
			_g_free0 (_tmp16_);
			_tmp13_ = _tmp18_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp19_ = _tmp13_;
			_tmp13_ = NULL;
			_g_date_time_unref0 (date);
			date = _tmp19_;
			_g_date_time_unref0 (_tmp13_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (dateenv);
			_g_free0 (emailenv);
			_g_free0 (nameenv);
			_g_date_time_unref0 (date);
			_g_free0 (email);
			_g_free0 (user);
			return NULL;
		}
	}
	_tmp20_ = date;
	if (_tmp20_ == NULL) {
		GDateTime* _tmp21_;
		_tmp21_ = g_date_time_new_now_local ();
		_g_date_time_unref0 (date);
		date = _tmp21_;
	}
	_tmp23_ = ggit_repository_get_config ((GgitRepository*) self, &_inner_error0_);
	_tmp22_ = _tmp23_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (dateenv);
		_g_free0 (emailenv);
		_g_free0 (nameenv);
		_g_date_time_unref0 (date);
		_g_free0 (email);
		_g_free0 (user);
		return NULL;
	}
	_tmp24_ = ggit_config_snapshot (_tmp22_, &_inner_error0_);
	conf = _tmp24_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp22_);
		_g_free0 (dateenv);
		_g_free0 (emailenv);
		_g_free0 (nameenv);
		_g_date_time_unref0 (date);
		_g_free0 (email);
		_g_free0 (user);
		return NULL;
	}
	_tmp25_ = user;
	if (_tmp25_ == NULL) {
		{
			const gchar* _tmp26_ = NULL;
			GgitConfig* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp27_ = conf;
			_tmp28_ = ggit_config_get_string (_tmp27_, "user.name", &_inner_error0_);
			_tmp26_ = _tmp28_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp29_ = g_strdup (_tmp26_);
			_g_free0 (user);
			user = _tmp29_;
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (conf);
			_g_object_unref0 (_tmp22_);
			_g_free0 (dateenv);
			_g_free0 (emailenv);
			_g_free0 (nameenv);
			_g_date_time_unref0 (date);
			_g_free0 (email);
			_g_free0 (user);
			return NULL;
		}
	}
	_tmp30_ = email;
	if (_tmp30_ == NULL) {
		{
			const gchar* _tmp31_ = NULL;
			GgitConfig* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp32_ = conf;
			_tmp33_ = ggit_config_get_string (_tmp32_, "user.email", &_inner_error0_);
			_tmp31_ = _tmp33_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp34_ = g_strdup (_tmp31_);
			_g_free0 (email);
			email = _tmp34_;
		}
		goto __finally2;
		__catch2_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (conf);
			_g_object_unref0 (_tmp22_);
			_g_free0 (dateenv);
			_g_free0 (emailenv);
			_g_free0 (nameenv);
			_g_date_time_unref0 (date);
			_g_free0 (email);
			_g_free0 (user);
			return NULL;
		}
	}
	_tmp36_ = user;
	if (_tmp36_ != NULL) {
		const gchar* _tmp37_;
		_tmp37_ = user;
		_tmp35_ = _tmp37_;
	} else {
		_tmp35_ = "";
	}
	_tmp39_ = email;
	if (_tmp39_ != NULL) {
		const gchar* _tmp40_;
		_tmp40_ = email;
		_tmp38_ = _tmp40_;
	} else {
		_tmp38_ = "";
	}
	_tmp42_ = date;
	_tmp43_ = ggit_signature_new (_tmp35_, _tmp38_, _tmp42_, &_inner_error0_);
	_tmp41_ = _tmp43_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (conf);
		_g_object_unref0 (_tmp22_);
		_g_free0 (dateenv);
		_g_free0 (emailenv);
		_g_free0 (nameenv);
		_g_date_time_unref0 (date);
		_g_free0 (email);
		_g_free0 (user);
		return NULL;
	}
	_tmp44_ = _tmp41_;
	_tmp41_ = NULL;
	result = _tmp44_;
	_g_object_unref0 (_tmp41_);
	_g_object_unref0 (conf);
	_g_object_unref0 (_tmp22_);
	_g_free0 (dateenv);
	_g_free0 (emailenv);
	_g_free0 (nameenv);
	_g_date_time_unref0 (date);
	_g_free0 (email);
	_g_free0 (user);
	return result;
}

gchar*
gitg_repository_get_name (GitgRepository* self)
{
	gchar* result;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gboolean _tmp4_;
	GFile* f = NULL;
	GFile* _tmp9_;
	gchar* _tmp10_ = NULL;
	GFile* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	g_object_get ((GgitRepository*) self, "workdir", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		GFile* _tmp5_;
		GFile* _tmp6_;
		g_object_get ((GgitRepository*) self, "workdir", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp6_;
	} else {
		GFile* _tmp7_;
		GFile* _tmp8_;
		_tmp7_ = ggit_repository_get_location ((GgitRepository*) self);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp8_;
	}
	_tmp9_ = _g_object_ref0 (_tmp0_);
	f = _tmp9_;
	_tmp11_ = f;
	if (_tmp11_ != NULL) {
		GFile* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = f;
		_tmp13_ = g_file_get_basename (_tmp12_);
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp13_;
	} else {
		_g_free0 (_tmp10_);
		_tmp10_ = NULL;
	}
	result = _tmp10_;
	_g_object_unref0 (f);
	_g_object_unref0 (_tmp0_);
	return result;
}

GitgStage*
gitg_repository_get_stage (GitgRepository* self)
{
	GitgStage* result;
	GitgStage* _tmp0_;
	GitgStage* _tmp2_;
	GitgStage* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_stage;
	if (_tmp0_ == NULL) {
		GitgStage* _tmp1_;
		_tmp1_ = gitg_stage_new (self);
		_g_object_unref0 (self->priv->d_stage);
		self->priv->d_stage = _tmp1_;
	}
	_tmp2_ = self->priv->d_stage;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
gitg_repository_class_init (GitgRepositoryClass * klass,
                            gpointer klass_data)
{
	gitg_repository_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgRepository_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_get_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_NAME_PROPERTY, gitg_repository_properties[GITG_REPOSITORY_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_STAGE_PROPERTY, gitg_repository_properties[GITG_REPOSITORY_STAGE_PROPERTY] = g_param_spec_object ("stage", "stage", "stage", GITG_TYPE_STAGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_repository_instance_init (GitgRepository * self,
                               gpointer klass)
{
	self->priv = gitg_repository_get_instance_private (self);
}

static void
gitg_repository_finalize (GObject * obj)
{
	GitgRepository * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY, GitgRepository);
	_g_hash_table_unref0 (self->priv->d_refs);
	_g_object_unref0 (self->priv->d_stage);
	G_OBJECT_CLASS (gitg_repository_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_repository_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepository), 0, (GInstanceInitFunc) gitg_repository_instance_init, NULL };
	GType gitg_repository_type_id;
	gitg_repository_type_id = g_type_register_static (ggit_repository_get_type (), "GitgRepository", &g_define_type_info, 0);
	GitgRepository_private_offset = g_type_add_instance_private (gitg_repository_type_id, sizeof (GitgRepositoryPrivate));
	return gitg_repository_type_id;
}

GType
gitg_repository_get_type (void)
{
	static gsize gitg_repository_type_id__once = 0;
	if (g_once_init_enter (&gitg_repository_type_id__once)) {
		GType gitg_repository_type_id;
		gitg_repository_type_id = gitg_repository_get_type_once ();
		g_once_init_leave (&gitg_repository_type_id__once, gitg_repository_type_id);
	}
	return gitg_repository_type_id__once;
}

static void
_vala_gitg_repository_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GitgRepository * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY, GitgRepository);
	switch (property_id) {
		case GITG_REPOSITORY_NAME_PROPERTY:
		g_value_take_string (value, gitg_repository_get_name (self));
		break;
		case GITG_REPOSITORY_STAGE_PROPERTY:
		g_value_take_object (value, gitg_repository_get_stage (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

