static const char* vignette_cl_source =
"__kernel void vignette_cl (__global const float4 *in,                         \n"
"                           __global       float4 *out,                        \n"
"                                          float4 color,                       \n"
"                                          float  scale,                       \n"
"                                          float  cost,                        \n"
"                                          float  sint,                        \n"
"                                          int    roi_x,                       \n"
"                                          int    roi_y,                       \n"
"                                          int    midx,                        \n"
"                                          int    midy,                        \n"
"                                          int    o_shape,                     \n"
"                                          float  gamma,                       \n"
"                                          float  length,                      \n"
"                                          float  radius0,                     \n"
"                                          float  rdiff)                       \n"
"{                                                                             \n"
"  int gidx = get_global_id(0);                                                \n"
"  int gidy = get_global_id(1);                                                \n"
"  int gid = gidx + gidy * get_global_size(0);                                 \n"
"  float strength = 0.0f;                                                      \n"
"  float u,v,costy,sinty;                                                      \n"
"  int x,y;                                                                    \n"
"  x = gidx + roi_x;                                                           \n"
"  y = gidy + roi_y;                                                           \n"
"  sinty = sint * (y-midy) - midx;                                             \n"
"  costy = cost * (y-midy) + midy;                                             \n"
"                                                                              \n"
"  u = cost * (x-midx) - sinty;                                                \n"
"  v = sint * (x-midx) + costy;                                                \n"
"                                                                              \n"
"  if (length == 0.0f)                                                         \n"
"    strength = 0.0f;                                                          \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      switch (o_shape)                                                        \n"
"        {                                                                     \n"
"          case 0:                                                             \n"
"          strength = hypot ((u-midx) / scale, v-midy);                        \n"
"          break;                                                              \n"
"                                                                              \n"
"          case 1:                                                             \n"
"          strength = fmax (fabs(u-midx)/scale, fabs(v-midy));                 \n"
"          break;                                                              \n"
"                                                                              \n"
"          case 2:                                                             \n"
"          strength = fabs (u-midx) / scale + fabs(v-midy);                    \n"
"          break;                                                              \n"
"                                                                              \n"
"          case 3:                                                             \n"
"          strength = fabs(v-midy);                                            \n"
"          break;                                                              \n"
"                                                                              \n"
"          case 4:                                                             \n"
"          strength = fabs (u-midx) / scale;                                   \n"
"          break;                                                              \n"
"        }                                                                     \n"
"      strength /= length;                                                     \n"
"      strength = (strength-radius0) / rdiff;                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (strength < 0.0f) strength = 0.0f;                                       \n"
"  if (strength > 1.0f) strength = 1.0f;                                       \n"
"                                                                              \n"
"  if (gamma > 1.9999f && gamma < 2.0001f)                                     \n"
"    strength *= strength;                                                     \n"
"  else if (gamma != 1.0f)                                                     \n"
"    strength = pow(strength, gamma);                                          \n"
"                                                                              \n"
"  out[gid] = in[gid]*(1.0f-strength) + color * strength;                      \n"
"}                                                                             \n"
;
