/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-nvme-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_nvme_status_to_string(FuNvmeStatus val)
{
    if (val == FU_NVME_STATUS_SUCCESS)
        return "success";
    if (val == FU_NVME_STATUS_INVALID_OPCODE)
        return "invalid-opcode";
    if (val == FU_NVME_STATUS_INVALID_FIELD)
        return "invalid-field";
    if (val == FU_NVME_STATUS_CMDID_CONFLICT)
        return "cmdid-conflict";
    if (val == FU_NVME_STATUS_DATA_XFER_ERROR)
        return "data-xfer-error";
    if (val == FU_NVME_STATUS_POWER_LOSS)
        return "power-loss";
    if (val == FU_NVME_STATUS_INTERNAL)
        return "internal";
    if (val == FU_NVME_STATUS_ABORT_REQ)
        return "abort-req";
    if (val == FU_NVME_STATUS_ABORT_QUEUE)
        return "abort-queue";
    if (val == FU_NVME_STATUS_FUSED_FAIL)
        return "fused-fail";
    if (val == FU_NVME_STATUS_FUSED_MISSING)
        return "fused-missing";
    if (val == FU_NVME_STATUS_INVALID_NS)
        return "invalid-ns";
    if (val == FU_NVME_STATUS_CMD_SEQ_ERROR)
        return "cmd-seq-error";
    if (val == FU_NVME_STATUS_SGL_INVALID_LAST)
        return "sgl-invalid-last";
    if (val == FU_NVME_STATUS_SGL_INVALID_COUNT)
        return "sgl-invalid-count";
    if (val == FU_NVME_STATUS_SGL_INVALID_DATA)
        return "sgl-invalid-data";
    if (val == FU_NVME_STATUS_SGL_INVALID_METADATA)
        return "sgl-invalid-metadata";
    if (val == FU_NVME_STATUS_SGL_INVALID_TYPE)
        return "sgl-invalid-type";
    if (val == FU_NVME_STATUS_SGL_INVALID_OFFSET)
        return "sgl-invalid-offset";
    if (val == FU_NVME_STATUS_SGL_INVALID_SUBTYPE)
        return "sgl-invalid-subtype";
    if (val == FU_NVME_STATUS_SANITIZE_FAILED)
        return "sanitize-failed";
    if (val == FU_NVME_STATUS_SANITIZE_IN_PROGRESS)
        return "sanitize-in-progress";
    if (val == FU_NVME_STATUS_NS_WRITE_PROTECTED)
        return "ns-write-protected";
    if (val == FU_NVME_STATUS_LBA_RANGE)
        return "lba-range";
    if (val == FU_NVME_STATUS_CAP_EXCEEDED)
        return "cap-exceeded";
    if (val == FU_NVME_STATUS_NS_NOT_READY)
        return "ns-not-ready";
    if (val == FU_NVME_STATUS_RESERVATION_CONFLICT)
        return "reservation-conflict";
    if (val == FU_NVME_STATUS_CQ_INVALID)
        return "cq-invalid";
    if (val == FU_NVME_STATUS_QID_INVALID)
        return "qid-invalid";
    if (val == FU_NVME_STATUS_QUEUE_SIZE)
        return "queue-size";
    if (val == FU_NVME_STATUS_ABORT_LIMIT)
        return "abort-limit";
    if (val == FU_NVME_STATUS_ABORT_MISSING)
        return "abort-missing";
    if (val == FU_NVME_STATUS_ASYNC_LIMIT)
        return "async-limit";
    if (val == FU_NVME_STATUS_FIRMWARE_SLOT)
        return "firmware-slot";
    if (val == FU_NVME_STATUS_FIRMWARE_IMAGE)
        return "firmware-image";
    if (val == FU_NVME_STATUS_INVALID_VECTOR)
        return "invalid-vector";
    if (val == FU_NVME_STATUS_INVALID_LOG_PAGE)
        return "invalid-log-page";
    if (val == FU_NVME_STATUS_INVALID_FORMAT)
        return "invalid-format";
    if (val == FU_NVME_STATUS_FW_NEEDS_CONV_RESET)
        return "fw-needs-conv-reset";
    if (val == FU_NVME_STATUS_INVALID_QUEUE)
        return "invalid-queue";
    if (val == FU_NVME_STATUS_FEATURE_NOT_SAVEABLE)
        return "feature-not-saveable";
    if (val == FU_NVME_STATUS_FEATURE_NOT_CHANGEABLE)
        return "feature-not-changeable";
    if (val == FU_NVME_STATUS_FEATURE_NOT_PER_NS)
        return "feature-not-per-ns";
    if (val == FU_NVME_STATUS_FW_NEEDS_SUBSYS_RESET)
        return "fw-needs-subsys-reset";
    if (val == FU_NVME_STATUS_FW_NEEDS_RESET)
        return "fw-needs-reset";
    if (val == FU_NVME_STATUS_FW_NEEDS_MAX_TIME)
        return "fw-needs-max-time";
    if (val == FU_NVME_STATUS_FW_ACTIVATE_PROHIBITED)
        return "fw-activate-prohibited";
    if (val == FU_NVME_STATUS_OVERLAPPING_RANGE)
        return "overlapping-range";
    if (val == FU_NVME_STATUS_NS_INSUFFICENT_CAP)
        return "ns-insufficent-cap";
    if (val == FU_NVME_STATUS_NS_ID_UNAVAILABLE)
        return "ns-id-unavailable";
    if (val == FU_NVME_STATUS_NS_ALREADY_ATTACHED)
        return "ns-already-attached";
    if (val == FU_NVME_STATUS_NS_IS_PRIVATE)
        return "ns-is-private";
    if (val == FU_NVME_STATUS_NS_NOT_ATTACHED)
        return "ns-not-attached";
    if (val == FU_NVME_STATUS_THIN_PROV_NOT_SUPP)
        return "thin-prov-not-supp";
    if (val == FU_NVME_STATUS_CTRL_LIST_INVALID)
        return "ctrl-list-invalid";
    if (val == FU_NVME_STATUS_BP_WRITE_PROHIBITED)
        return "bp-write-prohibited";
    if (val == FU_NVME_STATUS_BAD_ATTRIBUTES)
        return "bad-attributes";
    if (val == FU_NVME_STATUS_INVALID_PI)
        return "invalid-pi";
    if (val == FU_NVME_STATUS_READ_ONLY)
        return "read-only";
    if (val == FU_NVME_STATUS_ONCS_NOT_SUPPORTED)
        return "oncs-not-supported";
    if (val == FU_NVME_STATUS_DISCOVERY_RESTART)
        return "discovery-restart";
    if (val == FU_NVME_STATUS_AUTH_REQUIRED)
        return "auth-required";
    if (val == FU_NVME_STATUS_WRITE_FAULT)
        return "write-fault";
    if (val == FU_NVME_STATUS_READ_ERROR)
        return "read-error";
    if (val == FU_NVME_STATUS_GUARD_CHECK)
        return "guard-check";
    if (val == FU_NVME_STATUS_APPTAG_CHECK)
        return "apptag-check";
    if (val == FU_NVME_STATUS_REFTAG_CHECK)
        return "reftag-check";
    if (val == FU_NVME_STATUS_COMPARE_FAILED)
        return "compare-failed";
    if (val == FU_NVME_STATUS_ACCESS_DENIED)
        return "access-denied";
    if (val == FU_NVME_STATUS_UNWRITTEN_BLOCK)
        return "unwritten-block";
    if (val == FU_NVME_STATUS_ANA_PERSISTENT_LOSS)
        return "ana-persistent-loss";
    if (val == FU_NVME_STATUS_ANA_INACCESSIBLE)
        return "ana-inaccessible";
    if (val == FU_NVME_STATUS_ANA_TRANSITION)
        return "ana-transition";
    if (val == FU_NVME_STATUS_DNR)
        return "dnr";
    return NULL;
}
/**
 * fu_struct_nvme_id_ctrl_ref: (skip):
 **/
FuStructNvmeIdCtrl *
fu_struct_nvme_id_ctrl_ref(FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_nvme_id_ctrl_unref: (skip):
 **/
void
fu_struct_nvme_id_ctrl_unref(FuStructNvmeIdCtrl *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructNvmeIdCtrl refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_nvme_id_ctrl_new_internal: (skip):
 **/
static FuStructNvmeIdCtrl *
fu_struct_nvme_id_ctrl_new_internal(void)
{
    FuStructNvmeIdCtrl *st = g_new0(FuStructNvmeIdCtrl, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_nvme_id_ctrl_get_vid: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_vid(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_ssvid: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_ssvid(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_sn: (skip):
 **/
gchar *
fu_struct_nvme_id_ctrl_get_sn(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 4, 20, NULL);
}
/**
 * fu_struct_nvme_id_ctrl_get_mn: (skip):
 **/
gchar *
fu_struct_nvme_id_ctrl_get_mn(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 24, 40, NULL);
}
/**
 * fu_struct_nvme_id_ctrl_get_fr: (skip):
 **/
gchar *
fu_struct_nvme_id_ctrl_get_fr(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 64, 8, NULL);
}
/**
 * fu_struct_nvme_id_ctrl_get_rab: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_rab(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[72];
}
/**
 * fu_struct_nvme_id_ctrl_get_ieee: (skip):
 **/
const guint8 *
fu_struct_nvme_id_ctrl_get_ieee(const FuStructNvmeIdCtrl *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 3;
    return st->buf->data + 73;
}
/**
 * fu_struct_nvme_id_ctrl_get_cmic: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_cmic(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[76];
}
/**
 * fu_struct_nvme_id_ctrl_get_mdts: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_mdts(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[77];
}
/**
 * fu_struct_nvme_id_ctrl_get_cntlid: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_cntlid(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 78, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_ver: (skip):
 **/
guint32
fu_struct_nvme_id_ctrl_get_ver(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 80, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_rtd3r: (skip):
 **/
guint32
fu_struct_nvme_id_ctrl_get_rtd3r(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 84, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_rtd3e: (skip):
 **/
guint32
fu_struct_nvme_id_ctrl_get_rtd3e(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 88, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_oaes: (skip):
 **/
guint32
fu_struct_nvme_id_ctrl_get_oaes(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 92, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_ctratt: (skip):
 **/
guint32
fu_struct_nvme_id_ctrl_get_ctratt(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 96, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_cntrltype: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_cntrltype(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[111];
}
/**
 * fu_struct_nvme_id_ctrl_get_fguid: (skip):
 **/
const fwupd_guid_t *
fu_struct_nvme_id_ctrl_get_fguid(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 112);
}
/**
 * fu_struct_nvme_id_ctrl_get_crdt1: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_crdt1(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 128, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_crdt2: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_crdt2(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 130, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_crdt3: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_crdt3(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 132, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_oacs: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_oacs(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 256, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_acl: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_acl(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[258];
}
/**
 * fu_struct_nvme_id_ctrl_get_aerl: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_aerl(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[259];
}
/**
 * fu_struct_nvme_id_ctrl_get_frmw: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_frmw(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[260];
}
/**
 * fu_struct_nvme_id_ctrl_get_lpa: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_lpa(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[261];
}
/**
 * fu_struct_nvme_id_ctrl_get_elpe: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_elpe(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[262];
}
/**
 * fu_struct_nvme_id_ctrl_get_npss: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_npss(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[263];
}
/**
 * fu_struct_nvme_id_ctrl_get_avscc: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_avscc(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[264];
}
/**
 * fu_struct_nvme_id_ctrl_get_apsta: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_apsta(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[265];
}
/**
 * fu_struct_nvme_id_ctrl_get_wctemp: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_wctemp(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 266, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_cctemp: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_cctemp(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 268, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_mtfa: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_mtfa(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 270, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_hmpre: (skip):
 **/
guint32
fu_struct_nvme_id_ctrl_get_hmpre(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 272, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_hmmin: (skip):
 **/
guint32
fu_struct_nvme_id_ctrl_get_hmmin(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 276, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_tnvmcap: (skip):
 **/
const guint8 *
fu_struct_nvme_id_ctrl_get_tnvmcap(const FuStructNvmeIdCtrl *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 16;
    return st->buf->data + 280;
}
/**
 * fu_struct_nvme_id_ctrl_get_unvmcap: (skip):
 **/
const guint8 *
fu_struct_nvme_id_ctrl_get_unvmcap(const FuStructNvmeIdCtrl *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 16;
    return st->buf->data + 296;
}
/**
 * fu_struct_nvme_id_ctrl_get_rpmbs: (skip):
 **/
guint32
fu_struct_nvme_id_ctrl_get_rpmbs(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 312, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_edstt: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_edstt(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 316, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_dsto: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_dsto(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[318];
}
/**
 * fu_struct_nvme_id_ctrl_get_fwug: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_fwug(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[319];
}
/**
 * fu_struct_nvme_id_ctrl_get_kas: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_kas(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 320, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_hctma: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_hctma(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 322, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_mntmt: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_mntmt(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 324, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_mxtmt: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_mxtmt(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 326, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_sanicap: (skip):
 **/
guint32
fu_struct_nvme_id_ctrl_get_sanicap(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 328, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_hmminds: (skip):
 **/
guint32
fu_struct_nvme_id_ctrl_get_hmminds(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 332, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_hmmaxd: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_hmmaxd(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 336, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_nvmsetidmax: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_nvmsetidmax(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 338, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_endgidmax: (skip):
 **/
guint16
fu_struct_nvme_id_ctrl_get_endgidmax(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 340, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_anatt: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_anatt(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[342];
}
/**
 * fu_struct_nvme_id_ctrl_get_anacap: (skip):
 **/
guint8
fu_struct_nvme_id_ctrl_get_anacap(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[343];
}
/**
 * fu_struct_nvme_id_ctrl_get_anagrpmax: (skip):
 **/
guint32
fu_struct_nvme_id_ctrl_get_anagrpmax(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 344, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_nvme_id_ctrl_get_nanagrpid: (skip):
 **/
guint32
fu_struct_nvme_id_ctrl_get_nanagrpid(const FuStructNvmeIdCtrl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 348, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_nvme_id_ctrl_to_string: (skip):
 **/
static gchar *
fu_struct_nvme_id_ctrl_to_string(const FuStructNvmeIdCtrl *st)
{
    g_autoptr(GString) str = g_string_new("FuStructNvmeIdCtrl:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  vid: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_vid(st));
    g_string_append_printf(str, "  ssvid: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_ssvid(st));
    {
        g_autofree gchar *tmp = fu_struct_nvme_id_ctrl_get_sn(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  sn: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_nvme_id_ctrl_get_mn(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  mn: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_nvme_id_ctrl_get_fr(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  fr: %s\n", tmp);
    }
    g_string_append_printf(str, "  rab: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_rab(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_nvme_id_ctrl_get_ieee(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  ieee: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  cmic: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_cmic(st));
    g_string_append_printf(str, "  mdts: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_mdts(st));
    g_string_append_printf(str, "  cntlid: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_cntlid(st));
    g_string_append_printf(str, "  ver: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_ver(st));
    g_string_append_printf(str, "  rtd3r: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_rtd3r(st));
    g_string_append_printf(str, "  rtd3e: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_rtd3e(st));
    g_string_append_printf(str, "  oaes: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_oaes(st));
    g_string_append_printf(str, "  ctratt: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_ctratt(st));
    g_string_append_printf(str, "  cntrltype: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_cntrltype(st));
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_nvme_id_ctrl_get_fguid(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  fguid: %s\n", tmp);
    }
    g_string_append_printf(str, "  crdt1: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_crdt1(st));
    g_string_append_printf(str, "  crdt2: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_crdt2(st));
    g_string_append_printf(str, "  crdt3: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_crdt3(st));
    g_string_append_printf(str, "  oacs: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_oacs(st));
    g_string_append_printf(str, "  acl: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_acl(st));
    g_string_append_printf(str, "  aerl: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_aerl(st));
    g_string_append_printf(str, "  frmw: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_frmw(st));
    g_string_append_printf(str, "  lpa: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_lpa(st));
    g_string_append_printf(str, "  elpe: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_elpe(st));
    g_string_append_printf(str, "  npss: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_npss(st));
    g_string_append_printf(str, "  avscc: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_avscc(st));
    g_string_append_printf(str, "  apsta: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_apsta(st));
    g_string_append_printf(str, "  wctemp: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_wctemp(st));
    g_string_append_printf(str, "  cctemp: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_cctemp(st));
    g_string_append_printf(str, "  mtfa: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_mtfa(st));
    g_string_append_printf(str, "  hmpre: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_hmpre(st));
    g_string_append_printf(str, "  hmmin: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_hmmin(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_nvme_id_ctrl_get_tnvmcap(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  tnvmcap: 0x%s\n", tmp->str);
    }
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_nvme_id_ctrl_get_unvmcap(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  unvmcap: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  rpmbs: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_rpmbs(st));
    g_string_append_printf(str, "  edstt: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_edstt(st));
    g_string_append_printf(str, "  dsto: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_dsto(st));
    g_string_append_printf(str, "  fwug: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_fwug(st));
    g_string_append_printf(str, "  kas: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_kas(st));
    g_string_append_printf(str, "  hctma: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_hctma(st));
    g_string_append_printf(str, "  mntmt: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_mntmt(st));
    g_string_append_printf(str, "  mxtmt: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_mxtmt(st));
    g_string_append_printf(str, "  sanicap: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_sanicap(st));
    g_string_append_printf(str, "  hmminds: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_hmminds(st));
    g_string_append_printf(str, "  hmmaxd: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_hmmaxd(st));
    g_string_append_printf(str, "  nvmsetidmax: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_nvmsetidmax(st));
    g_string_append_printf(str, "  endgidmax: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_endgidmax(st));
    g_string_append_printf(str, "  anatt: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_anatt(st));
    g_string_append_printf(str, "  anacap: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_anacap(st));
    g_string_append_printf(str, "  anagrpmax: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_anagrpmax(st));
    g_string_append_printf(str, "  nanagrpid: 0x%x\n",
                           (guint) fu_struct_nvme_id_ctrl_get_nanagrpid(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_nvme_id_ctrl_validate_internal(FuStructNvmeIdCtrl *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_nvme_id_ctrl_parse_internal(FuStructNvmeIdCtrl *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_nvme_id_ctrl_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_nvme_id_ctrl_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_nvme_id_ctrl_parse: (skip):
 **/
FuStructNvmeIdCtrl *
fu_struct_nvme_id_ctrl_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructNvmeIdCtrl) st = fu_struct_nvme_id_ctrl_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4096, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructNvmeIdCtrl: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4096);
    if (!fu_struct_nvme_id_ctrl_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_nvme_fw_slot_info_log_ref: (skip):
 **/
FuStructNvmeFwSlotInfoLog *
fu_struct_nvme_fw_slot_info_log_ref(FuStructNvmeFwSlotInfoLog *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_nvme_fw_slot_info_log_unref: (skip):
 **/
void
fu_struct_nvme_fw_slot_info_log_unref(FuStructNvmeFwSlotInfoLog *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructNvmeFwSlotInfoLog refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_nvme_fw_slot_info_log_new_internal: (skip):
 **/
static FuStructNvmeFwSlotInfoLog *
fu_struct_nvme_fw_slot_info_log_new_internal(void)
{
    FuStructNvmeFwSlotInfoLog *st = g_new0(FuStructNvmeFwSlotInfoLog, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_nvme_fw_slot_info_log_get_afi: (skip):
 **/
guint8
fu_struct_nvme_fw_slot_info_log_get_afi(const FuStructNvmeFwSlotInfoLog *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_nvme_fw_slot_info_log_get_frs: (skip):
 **/
guint64
fu_struct_nvme_fw_slot_info_log_get_frs(const FuStructNvmeFwSlotInfoLog *st, guint idx)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 8 + (sizeof(guint64) * idx),
                                        G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_nvme_fw_slot_info_log_to_string: (skip):
 **/
static gchar *
fu_struct_nvme_fw_slot_info_log_to_string(const FuStructNvmeFwSlotInfoLog *st)
{
    g_autoptr(GString) str = g_string_new("FuStructNvmeFwSlotInfoLog:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  afi: 0x%x\n",
                           (guint) fu_struct_nvme_fw_slot_info_log_get_afi(st));
    for (guint i = 0; i < 7; i++) {
        g_string_append_printf(str, "  frs[%u]: 0x%x\n",
                               i, (guint) fu_struct_nvme_fw_slot_info_log_get_frs(st, i));
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_nvme_fw_slot_info_log_validate_internal(FuStructNvmeFwSlotInfoLog *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_nvme_fw_slot_info_log_parse_internal(FuStructNvmeFwSlotInfoLog *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_nvme_fw_slot_info_log_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_nvme_fw_slot_info_log_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_nvme_fw_slot_info_log_parse: (skip):
 **/
FuStructNvmeFwSlotInfoLog *
fu_struct_nvme_fw_slot_info_log_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructNvmeFwSlotInfoLog) st = fu_struct_nvme_fw_slot_info_log_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 512, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructNvmeFwSlotInfoLog: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 512);
    if (!fu_struct_nvme_fw_slot_info_log_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
