/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-logitech-rallysystem-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_usb_cmd_id_to_string(FuUsbCmdId val)
{
    if (val == FU_USB_CMD_ID_INIT)
        return "init";
    if (val == FU_USB_CMD_ID_FIRMWARE_DOWNLOAD)
        return "firmware-download";
    if (val == FU_USB_CMD_ID_READ_VERSION)
        return "read-version";
    return NULL;
}

static const gchar *
fu_usb_cmd_status_to_string(FuUsbCmdStatus val)
{
    if (val == FU_USB_CMD_STATUS_OK)
        return "ok";
    if (val == FU_USB_CMD_STATUS_REQ)
        return "req";
    if (val == FU_USB_CMD_STATUS_INIT_REQ)
        return "init-req";
    if (val == FU_USB_CMD_STATUS_INIT_REQ_ACK)
        return "init-req-ack";
    return NULL;
}

static const gchar *
fu_usb_image_state_to_string(FuUsbImageState val)
{
    if (val == FU_USB_IMAGE_STATE_NEW)
        return "new";
    if (val == FU_USB_IMAGE_STATE_VALID)
        return "valid";
    if (val == FU_USB_IMAGE_STATE_INVALID)
        return "invalid";
    return NULL;
}
/**
 * fu_struct_audio_serial_number_ref: (skip):
 **/
FuStructAudioSerialNumber *
fu_struct_audio_serial_number_ref(FuStructAudioSerialNumber *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_audio_serial_number_unref: (skip):
 **/
void
fu_struct_audio_serial_number_unref(FuStructAudioSerialNumber *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAudioSerialNumber refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_audio_serial_number_new_internal: (skip):
 **/
static FuStructAudioSerialNumber *
fu_struct_audio_serial_number_new_internal(void)
{
    FuStructAudioSerialNumber *st = g_new0(FuStructAudioSerialNumber, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_audio_serial_number_get_mac_address: (skip):
 **/
const guint8 *
fu_struct_audio_serial_number_get_mac_address(const FuStructAudioSerialNumber *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 6;
    return st->buf->data + 0;
}
/**
 * fu_struct_audio_serial_number_get_pid: (skip):
 **/
guint16
fu_struct_audio_serial_number_get_pid(const FuStructAudioSerialNumber *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_audio_serial_number_get_year: (skip):
 **/
guint16
fu_struct_audio_serial_number_get_year(const FuStructAudioSerialNumber *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_audio_serial_number_get_month: (skip):
 **/
guint8
fu_struct_audio_serial_number_get_month(const FuStructAudioSerialNumber *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[10];
}
/**
 * fu_struct_audio_serial_number_get_day: (skip):
 **/
guint8
fu_struct_audio_serial_number_get_day(const FuStructAudioSerialNumber *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[11];
}

/* setters */
/**
 * fu_struct_audio_serial_number_to_string: (skip):
 **/
static gchar *
fu_struct_audio_serial_number_to_string(const FuStructAudioSerialNumber *st)
{
    g_autoptr(GString) str = g_string_new("FuStructAudioSerialNumber:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_audio_serial_number_get_mac_address(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  mac_address: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_audio_serial_number_get_pid(st));
    g_string_append_printf(str, "  year: 0x%x\n",
                           (guint) fu_struct_audio_serial_number_get_year(st));
    g_string_append_printf(str, "  month: 0x%x\n",
                           (guint) fu_struct_audio_serial_number_get_month(st));
    g_string_append_printf(str, "  day: 0x%x\n",
                           (guint) fu_struct_audio_serial_number_get_day(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_audio_serial_number_validate_internal(FuStructAudioSerialNumber *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_audio_serial_number_parse_internal(FuStructAudioSerialNumber *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_audio_serial_number_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_audio_serial_number_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_audio_serial_number_parse: (skip):
 **/
FuStructAudioSerialNumber *
fu_struct_audio_serial_number_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructAudioSerialNumber) st = fu_struct_audio_serial_number_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 12, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructAudioSerialNumber: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 12);
    if (!fu_struct_audio_serial_number_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_usb_init_request_ref: (skip):
 **/
FuStructUsbInitRequest *
fu_struct_usb_init_request_ref(FuStructUsbInitRequest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_usb_init_request_unref: (skip):
 **/
void
fu_struct_usb_init_request_unref(FuStructUsbInitRequest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructUsbInitRequest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_usb_init_request_new_internal: (skip):
 **/
static FuStructUsbInitRequest *
fu_struct_usb_init_request_new_internal(void)
{
    FuStructUsbInitRequest *st = g_new0(FuStructUsbInitRequest, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_usb_init_request_set_id: (skip):
 **/
static void
fu_struct_usb_init_request_set_id(FuStructUsbInitRequest *st, FuUsbCmdId value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_usb_init_request_set_status: (skip):
 **/
static void
fu_struct_usb_init_request_set_status(FuStructUsbInitRequest *st, FuUsbCmdStatus value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_usb_init_request_set_len: (skip):
 **/
static void
fu_struct_usb_init_request_set_len(FuStructUsbInitRequest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_usb_init_request_new: (skip):
 **/
FuStructUsbInitRequest *
fu_struct_usb_init_request_new(void)
{
    FuStructUsbInitRequest *st = fu_struct_usb_init_request_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_usb_init_request_set_id(st, FU_USB_CMD_ID_INIT);
    fu_struct_usb_init_request_set_status(st, FU_USB_CMD_STATUS_INIT_REQ);
    fu_struct_usb_init_request_set_len(st, 0);
    return st;
}
/**
 * fu_struct_usb_init_response_ref: (skip):
 **/
FuStructUsbInitResponse *
fu_struct_usb_init_response_ref(FuStructUsbInitResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_usb_init_response_unref: (skip):
 **/
void
fu_struct_usb_init_response_unref(FuStructUsbInitResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructUsbInitResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_usb_init_response_new_internal: (skip):
 **/
static FuStructUsbInitResponse *
fu_struct_usb_init_response_new_internal(void)
{
    FuStructUsbInitResponse *st = g_new0(FuStructUsbInitResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_usb_init_response_get_id: (skip):
 **/
static FuUsbCmdId
fu_struct_usb_init_response_get_id(const FuStructUsbInitResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_usb_init_response_get_status: (skip):
 **/
static FuUsbCmdStatus
fu_struct_usb_init_response_get_status(const FuStructUsbInitResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_usb_init_response_get_len: (skip):
 **/
static guint32
fu_struct_usb_init_response_get_len(const FuStructUsbInitResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_usb_init_response_to_string: (skip):
 **/
static gchar *
fu_struct_usb_init_response_to_string(const FuStructUsbInitResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructUsbInitResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_usb_init_response_validate_internal(FuStructUsbInitResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_usb_init_response_get_id(st) != FU_USB_CMD_ID_INIT) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructUsbInitResponse.id was not valid, "
                    "expected 'FuUsbCmdId' and got '%s'",
                    fu_usb_cmd_id_to_string(fu_struct_usb_init_response_get_id(st)));
        return FALSE;
    }
    if (fu_struct_usb_init_response_get_status(st) != FU_USB_CMD_STATUS_INIT_REQ_ACK) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructUsbInitResponse.status was not valid, "
                    "expected 'FuUsbCmdStatus' and got '%s'",
                    fu_usb_cmd_status_to_string(fu_struct_usb_init_response_get_status(st)));
        return FALSE;
    }
    if (fu_struct_usb_init_response_get_len(st) != 0) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructUsbInitResponse.len was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0,
                    (guint) fu_struct_usb_init_response_get_len(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_usb_init_response_parse_internal(FuStructUsbInitResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_usb_init_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_usb_init_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_usb_init_response_parse: (skip):
 **/
FuStructUsbInitResponse *
fu_struct_usb_init_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructUsbInitResponse) st = fu_struct_usb_init_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructUsbInitResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 8);
    if (!fu_struct_usb_init_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_usb_firmware_download_request_ref: (skip):
 **/
FuStructUsbFirmwareDownloadRequest *
fu_struct_usb_firmware_download_request_ref(FuStructUsbFirmwareDownloadRequest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_usb_firmware_download_request_unref: (skip):
 **/
void
fu_struct_usb_firmware_download_request_unref(FuStructUsbFirmwareDownloadRequest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructUsbFirmwareDownloadRequest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_usb_firmware_download_request_new_internal: (skip):
 **/
static FuStructUsbFirmwareDownloadRequest *
fu_struct_usb_firmware_download_request_new_internal(void)
{
    FuStructUsbFirmwareDownloadRequest *st = g_new0(FuStructUsbFirmwareDownloadRequest, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_usb_firmware_download_request_set_id: (skip):
 **/
static void
fu_struct_usb_firmware_download_request_set_id(FuStructUsbFirmwareDownloadRequest *st, FuUsbCmdId value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_usb_firmware_download_request_set_status: (skip):
 **/
static void
fu_struct_usb_firmware_download_request_set_status(FuStructUsbFirmwareDownloadRequest *st, FuUsbCmdStatus value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_usb_firmware_download_request_set_len: (skip):
 **/
void
fu_struct_usb_firmware_download_request_set_len(FuStructUsbFirmwareDownloadRequest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_usb_firmware_download_request_set_fw_version: (skip):
 **/
gboolean
fu_struct_usb_firmware_download_request_set_fw_version(FuStructUsbFirmwareDownloadRequest *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 8, 0x0, 16);
        return TRUE;
    }
    len = strlen(value);
    if (len > 16) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructUsbFirmwareDownloadRequest.fw_version (0x%x bytes)",
                    value, (guint) len, (guint) 16);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 8, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_usb_firmware_download_request_new: (skip):
 **/
FuStructUsbFirmwareDownloadRequest *
fu_struct_usb_firmware_download_request_new(void)
{
    FuStructUsbFirmwareDownloadRequest *st = fu_struct_usb_firmware_download_request_new_internal();
    st->buf = g_byte_array_sized_new(24);
    fu_byte_array_set_size(st->buf, 24, 0x0);
    fu_struct_usb_firmware_download_request_set_id(st, FU_USB_CMD_ID_FIRMWARE_DOWNLOAD);
    fu_struct_usb_firmware_download_request_set_status(st, FU_USB_CMD_STATUS_REQ);
    return st;
}
/**
 * fu_struct_usb_firmware_download_response_ref: (skip):
 **/
FuStructUsbFirmwareDownloadResponse *
fu_struct_usb_firmware_download_response_ref(FuStructUsbFirmwareDownloadResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_usb_firmware_download_response_unref: (skip):
 **/
void
fu_struct_usb_firmware_download_response_unref(FuStructUsbFirmwareDownloadResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructUsbFirmwareDownloadResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_usb_firmware_download_response_new_internal: (skip):
 **/
static FuStructUsbFirmwareDownloadResponse *
fu_struct_usb_firmware_download_response_new_internal(void)
{
    FuStructUsbFirmwareDownloadResponse *st = g_new0(FuStructUsbFirmwareDownloadResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_usb_firmware_download_response_get_id: (skip):
 **/
static FuUsbCmdId
fu_struct_usb_firmware_download_response_get_id(const FuStructUsbFirmwareDownloadResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_usb_firmware_download_response_get_status: (skip):
 **/
static FuUsbCmdStatus
fu_struct_usb_firmware_download_response_get_status(const FuStructUsbFirmwareDownloadResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_usb_firmware_download_response_get_len: (skip):
 **/
guint32
fu_struct_usb_firmware_download_response_get_len(const FuStructUsbFirmwareDownloadResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_usb_firmware_download_response_to_string: (skip):
 **/
static gchar *
fu_struct_usb_firmware_download_response_to_string(const FuStructUsbFirmwareDownloadResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructUsbFirmwareDownloadResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  len: 0x%x\n",
                           (guint) fu_struct_usb_firmware_download_response_get_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_usb_firmware_download_response_validate_internal(FuStructUsbFirmwareDownloadResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_usb_firmware_download_response_get_id(st) != FU_USB_CMD_ID_FIRMWARE_DOWNLOAD) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructUsbFirmwareDownloadResponse.id was not valid, "
                    "expected 'FuUsbCmdId' and got '%s'",
                    fu_usb_cmd_id_to_string(fu_struct_usb_firmware_download_response_get_id(st)));
        return FALSE;
    }
    if (fu_struct_usb_firmware_download_response_get_status(st) != FU_USB_CMD_STATUS_OK) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructUsbFirmwareDownloadResponse.status was not valid, "
                    "expected 'FuUsbCmdStatus' and got '%s'",
                    fu_usb_cmd_status_to_string(fu_struct_usb_firmware_download_response_get_status(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_usb_firmware_download_response_parse_internal(FuStructUsbFirmwareDownloadResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_usb_firmware_download_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_usb_firmware_download_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_usb_firmware_download_response_parse: (skip):
 **/
FuStructUsbFirmwareDownloadResponse *
fu_struct_usb_firmware_download_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructUsbFirmwareDownloadResponse) st = fu_struct_usb_firmware_download_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructUsbFirmwareDownloadResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 8);
    if (!fu_struct_usb_firmware_download_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_usb_read_version_request_ref: (skip):
 **/
FuStructUsbReadVersionRequest *
fu_struct_usb_read_version_request_ref(FuStructUsbReadVersionRequest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_usb_read_version_request_unref: (skip):
 **/
void
fu_struct_usb_read_version_request_unref(FuStructUsbReadVersionRequest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructUsbReadVersionRequest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_usb_read_version_request_new_internal: (skip):
 **/
static FuStructUsbReadVersionRequest *
fu_struct_usb_read_version_request_new_internal(void)
{
    FuStructUsbReadVersionRequest *st = g_new0(FuStructUsbReadVersionRequest, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_usb_read_version_request_set_id: (skip):
 **/
static void
fu_struct_usb_read_version_request_set_id(FuStructUsbReadVersionRequest *st, FuUsbCmdId value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_usb_read_version_request_set_status: (skip):
 **/
static void
fu_struct_usb_read_version_request_set_status(FuStructUsbReadVersionRequest *st, FuUsbCmdStatus value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_usb_read_version_request_set_len: (skip):
 **/
static void
fu_struct_usb_read_version_request_set_len(FuStructUsbReadVersionRequest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_usb_read_version_request_new: (skip):
 **/
FuStructUsbReadVersionRequest *
fu_struct_usb_read_version_request_new(void)
{
    FuStructUsbReadVersionRequest *st = fu_struct_usb_read_version_request_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_usb_read_version_request_set_id(st, FU_USB_CMD_ID_READ_VERSION);
    fu_struct_usb_read_version_request_set_status(st, FU_USB_CMD_STATUS_REQ);
    fu_struct_usb_read_version_request_set_len(st, 0);
    return st;
}
/**
 * fu_struct_usb_read_version_response_ref: (skip):
 **/
FuStructUsbReadVersionResponse *
fu_struct_usb_read_version_response_ref(FuStructUsbReadVersionResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_usb_read_version_response_unref: (skip):
 **/
void
fu_struct_usb_read_version_response_unref(FuStructUsbReadVersionResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructUsbReadVersionResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_usb_read_version_response_new_internal: (skip):
 **/
static FuStructUsbReadVersionResponse *
fu_struct_usb_read_version_response_new_internal(void)
{
    FuStructUsbReadVersionResponse *st = g_new0(FuStructUsbReadVersionResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_usb_read_version_response_get_fw_version: (skip):
 **/
gchar *
fu_struct_usb_read_version_response_get_fw_version(const FuStructUsbReadVersionResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 16, NULL);
}
/**
 * fu_struct_usb_read_version_response_get_img_state: (skip):
 **/
FuUsbImageState
fu_struct_usb_read_version_response_get_img_state(const FuStructUsbReadVersionResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_usb_read_version_response_to_string: (skip):
 **/
static gchar *
fu_struct_usb_read_version_response_to_string(const FuStructUsbReadVersionResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructUsbReadVersionResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_usb_read_version_response_get_fw_version(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  fw_version: %s\n", tmp);
    }
    {
        const gchar *tmp = fu_usb_image_state_to_string(fu_struct_usb_read_version_response_get_img_state(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  img_state: 0x%x [%s]\n", (guint) fu_struct_usb_read_version_response_get_img_state(st), tmp);
        } else {
            g_string_append_printf(str, "  img_state: 0x%x\n", (guint) fu_struct_usb_read_version_response_get_img_state(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_usb_read_version_response_validate_internal(FuStructUsbReadVersionResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_usb_read_version_response_parse_internal(FuStructUsbReadVersionResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_usb_read_version_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_usb_read_version_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_usb_read_version_response_parse: (skip):
 **/
FuStructUsbReadVersionResponse *
fu_struct_usb_read_version_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructUsbReadVersionResponse) st = fu_struct_usb_read_version_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 20, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructUsbReadVersionResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 20);
    if (!fu_struct_usb_read_version_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_usb_progress_response_ref: (skip):
 **/
FuStructUsbProgressResponse *
fu_struct_usb_progress_response_ref(FuStructUsbProgressResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_usb_progress_response_unref: (skip):
 **/
void
fu_struct_usb_progress_response_unref(FuStructUsbProgressResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructUsbProgressResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_usb_progress_response_new_internal: (skip):
 **/
static FuStructUsbProgressResponse *
fu_struct_usb_progress_response_new_internal(void)
{
    FuStructUsbProgressResponse *st = g_new0(FuStructUsbProgressResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_usb_progress_response_get_completed: (skip):
 **/
guint32
fu_struct_usb_progress_response_get_completed(const FuStructUsbProgressResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_usb_progress_response_to_string: (skip):
 **/
static gchar *
fu_struct_usb_progress_response_to_string(const FuStructUsbProgressResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructUsbProgressResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  completed: 0x%x\n",
                           (guint) fu_struct_usb_progress_response_get_completed(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_usb_progress_response_validate_internal(FuStructUsbProgressResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_usb_progress_response_parse_internal(FuStructUsbProgressResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_usb_progress_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_usb_progress_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_usb_progress_response_parse: (skip):
 **/
FuStructUsbProgressResponse *
fu_struct_usb_progress_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructUsbProgressResponse) st = fu_struct_usb_progress_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructUsbProgressResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_struct_usb_progress_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
