/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-ccgx-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_ccgx_image_type_to_string(FuCcgxImageType val)
{
    if (val == FU_CCGX_IMAGE_TYPE_UNKNOWN)
        return "unknown";
    if (val == FU_CCGX_IMAGE_TYPE_SINGLE)
        return "single";
    if (val == FU_CCGX_IMAGE_TYPE_DUAL_SYMMETRIC)
        return "dual-symmetric";
    if (val == FU_CCGX_IMAGE_TYPE_DUAL_ASYMMETRIC)
        return "dual-asymmetric";
    if (val == FU_CCGX_IMAGE_TYPE_DUAL_ASYMMETRIC_VARIABLE)
        return "dual-asymmetric-variable";
    return NULL;
}
FuCcgxImageType
fu_ccgx_image_type_from_string(const gchar *val)
{
    if (g_strcmp0(val, "unknown") == 0)
        return FU_CCGX_IMAGE_TYPE_UNKNOWN;
    if (g_strcmp0(val, "single") == 0)
        return FU_CCGX_IMAGE_TYPE_SINGLE;
    if (g_strcmp0(val, "dual-symmetric") == 0)
        return FU_CCGX_IMAGE_TYPE_DUAL_SYMMETRIC;
    if (g_strcmp0(val, "dual-asymmetric") == 0)
        return FU_CCGX_IMAGE_TYPE_DUAL_ASYMMETRIC;
    if (g_strcmp0(val, "dual-asymmetric-variable") == 0)
        return FU_CCGX_IMAGE_TYPE_DUAL_ASYMMETRIC_VARIABLE;
    return FU_CCGX_IMAGE_TYPE_UNKNOWN;
}

const gchar *
fu_ccgx_fw_mode_to_string(FuCcgxFwMode val)
{
    if (val == FU_CCGX_FW_MODE_BOOT)
        return "boot";
    if (val == FU_CCGX_FW_MODE_FW1)
        return "fw1";
    if (val == FU_CCGX_FW_MODE_FW2)
        return "fw2";
    return NULL;
}

const gchar *
fu_ccgx_pd_resp_to_string(FuCcgxPdResp val)
{
    if (val == FU_CCGX_PD_RESP_NO_RESPONSE)
        return "no-response";
    if (val == FU_CCGX_PD_RESP_SUCCESS)
        return "success";
    if (val == FU_CCGX_PD_RESP_FLASH_DATA_AVAILABLE)
        return "flash-data-available";
    if (val == FU_CCGX_PD_RESP_INVALID_COMMAND)
        return "invalid-command";
    if (val == FU_CCGX_PD_RESP_COLLISION_DETECTED)
        return "collision-detected";
    if (val == FU_CCGX_PD_RESP_FLASH_UPDATE_FAILED)
        return "flash-update-failed";
    if (val == FU_CCGX_PD_RESP_INVALID_FW)
        return "invalid-fw";
    if (val == FU_CCGX_PD_RESP_INVALID_ARGUMENTS)
        return "invalid-arguments";
    if (val == FU_CCGX_PD_RESP_NOT_SUPPORTED)
        return "not-supported";
    if (val == FU_CCGX_PD_RESP_TRANSACTION_FAILED)
        return "transaction-failed";
    if (val == FU_CCGX_PD_RESP_PD_COMMAND_FAILED)
        return "pd-command-failed";
    if (val == FU_CCGX_PD_RESP_UNDEFINED)
        return "undefined";
    if (val == FU_CCGX_PD_RESP_RA_DETECT)
        return "ra-detect";
    if (val == FU_CCGX_PD_RESP_RA_REMOVED)
        return "ra-removed";
    if (val == FU_CCGX_PD_RESP_RESET_COMPLETE)
        return "reset-complete";
    if (val == FU_CCGX_PD_RESP_MESSAGE_QUEUE_OVERFLOW)
        return "message-queue-overflow";
    if (val == FU_CCGX_PD_RESP_OVER_CURRENT_DETECTED)
        return "over-current-detected";
    if (val == FU_CCGX_PD_RESP_OVER_VOLTAGE_DETECTED)
        return "over-voltage-detected";
    if (val == FU_CCGX_PD_RESP_TYPE_C_CONNECTED)
        return "type-c-connected";
    if (val == FU_CCGX_PD_RESP_TYPE_C_DISCONNECTED)
        return "type-c-disconnected";
    if (val == FU_CCGX_PD_RESP_PD_CONTRACT_ESTABLISHED)
        return "pd-contract-established";
    if (val == FU_CCGX_PD_RESP_DR_SWAP)
        return "dr-swap";
    if (val == FU_CCGX_PD_RESP_PR_SWAP)
        return "pr-swap";
    if (val == FU_CCGX_PD_RESP_VCON_SWAP)
        return "vcon-swap";
    if (val == FU_CCGX_PD_RESP_PS_RDY)
        return "ps-rdy";
    if (val == FU_CCGX_PD_RESP_GOTOMIN)
        return "gotomin";
    if (val == FU_CCGX_PD_RESP_ACCEPT_MESSAGE)
        return "accept-message";
    if (val == FU_CCGX_PD_RESP_REJECT_MESSAGE)
        return "reject-message";
    if (val == FU_CCGX_PD_RESP_WAIT_MESSAGE)
        return "wait-message";
    if (val == FU_CCGX_PD_RESP_HARD_RESET)
        return "hard-reset";
    if (val == FU_CCGX_PD_RESP_VDM_RECEIVED)
        return "vdm-received";
    if (val == FU_CCGX_PD_RESP_SRC_CAP_RCVD)
        return "src-cap-rcvd";
    if (val == FU_CCGX_PD_RESP_SINK_CAP_RCVD)
        return "sink-cap-rcvd";
    if (val == FU_CCGX_PD_RESP_DP_ALTERNATE_MODE)
        return "dp-alternate-mode";
    if (val == FU_CCGX_PD_RESP_DP_DEVICE_NONNECTED)
        return "dp-device-nonnected";
    if (val == FU_CCGX_PD_RESP_DP_DEVICE_NOT_CONNECTED)
        return "dp-device-not-connected";
    if (val == FU_CCGX_PD_RESP_DP_SID_NOT_FOUND)
        return "dp-sid-not-found";
    if (val == FU_CCGX_PD_RESP_MULTIPLE_SVID_DISCOVERED)
        return "multiple-svid-discovered";
    if (val == FU_CCGX_PD_RESP_DP_FUNCTION_NOT_SUPPORTED)
        return "dp-function-not-supported";
    if (val == FU_CCGX_PD_RESP_DP_PORT_CONFIG_NOT_SUPPORTED)
        return "dp-port-config-not-supported";
    if (val == FU_CCGX_PD_RESP_HARD_RESET_SENT)
        return "hard-reset-sent";
    if (val == FU_CCGX_PD_RESP_SOFT_RESET_SENT)
        return "soft-reset-sent";
    if (val == FU_CCGX_PD_RESP_CABLE_RESET_SENT)
        return "cable-reset-sent";
    if (val == FU_CCGX_PD_RESP_SOURCE_DISABLED_STATE_ENTERED)
        return "source-disabled-state-entered";
    if (val == FU_CCGX_PD_RESP_SENDER_RESPONSE_TIMER_TIMEOUT)
        return "sender-response-timer-timeout";
    if (val == FU_CCGX_PD_RESP_NO_VDM_RESPONSE_RECEIVED)
        return "no-vdm-response-received";
    return NULL;
}






/**
 * fu_struct_ccgx_metadata_hdr_ref: (skip):
 **/
FuStructCcgxMetadataHdr *
fu_struct_ccgx_metadata_hdr_ref(FuStructCcgxMetadataHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ccgx_metadata_hdr_unref: (skip):
 **/
void
fu_struct_ccgx_metadata_hdr_unref(FuStructCcgxMetadataHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCcgxMetadataHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ccgx_metadata_hdr_new_internal: (skip):
 **/
static FuStructCcgxMetadataHdr *
fu_struct_ccgx_metadata_hdr_new_internal(void)
{
    FuStructCcgxMetadataHdr *st = g_new0(FuStructCcgxMetadataHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ccgx_metadata_hdr_get_fw_checksum: (skip):
 **/
guint8
fu_struct_ccgx_metadata_hdr_get_fw_checksum(const FuStructCcgxMetadataHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_ccgx_metadata_hdr_get_fw_entry: (skip):
 **/
guint32
fu_struct_ccgx_metadata_hdr_get_fw_entry(const FuStructCcgxMetadataHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 1, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_metadata_hdr_get_last_boot_row: (skip):
 **/
guint16
fu_struct_ccgx_metadata_hdr_get_last_boot_row(const FuStructCcgxMetadataHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 5, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_metadata_hdr_get_fw_size: (skip):
 **/
guint32
fu_struct_ccgx_metadata_hdr_get_fw_size(const FuStructCcgxMetadataHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 9, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_metadata_hdr_get_metadata_valid: (skip):
 **/
guint16
fu_struct_ccgx_metadata_hdr_get_metadata_valid(const FuStructCcgxMetadataHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 22, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_metadata_hdr_get_boot_seq: (skip):
 **/
guint32
fu_struct_ccgx_metadata_hdr_get_boot_seq(const FuStructCcgxMetadataHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 28, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ccgx_metadata_hdr_set_fw_checksum: (skip):
 **/
void
fu_struct_ccgx_metadata_hdr_set_fw_checksum(FuStructCcgxMetadataHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_ccgx_metadata_hdr_set_fw_entry: (skip):
 **/
void
fu_struct_ccgx_metadata_hdr_set_fw_entry(FuStructCcgxMetadataHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 1, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_metadata_hdr_set_last_boot_row: (skip):
 **/
void
fu_struct_ccgx_metadata_hdr_set_last_boot_row(FuStructCcgxMetadataHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 5, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_metadata_hdr_set_fw_size: (skip):
 **/
void
fu_struct_ccgx_metadata_hdr_set_fw_size(FuStructCcgxMetadataHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 9, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_metadata_hdr_set_metadata_valid: (skip):
 **/
void
fu_struct_ccgx_metadata_hdr_set_metadata_valid(FuStructCcgxMetadataHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 22, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_metadata_hdr_set_boot_seq: (skip):
 **/
void
fu_struct_ccgx_metadata_hdr_set_boot_seq(FuStructCcgxMetadataHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_metadata_hdr_new: (skip):
 **/
FuStructCcgxMetadataHdr *
fu_struct_ccgx_metadata_hdr_new(void)
{
    FuStructCcgxMetadataHdr *st = fu_struct_ccgx_metadata_hdr_new_internal();
    st->buf = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st->buf, 32, 0x0);
    fu_struct_ccgx_metadata_hdr_set_metadata_valid(st, 0x4359);
    return st;
}
/**
 * fu_struct_ccgx_metadata_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_ccgx_metadata_hdr_to_string(const FuStructCcgxMetadataHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructCcgxMetadataHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  fw_checksum: 0x%x\n",
                           (guint) fu_struct_ccgx_metadata_hdr_get_fw_checksum(st));
    g_string_append_printf(str, "  fw_entry: 0x%x\n",
                           (guint) fu_struct_ccgx_metadata_hdr_get_fw_entry(st));
    g_string_append_printf(str, "  last_boot_row: 0x%x\n",
                           (guint) fu_struct_ccgx_metadata_hdr_get_last_boot_row(st));
    g_string_append_printf(str, "  fw_size: 0x%x\n",
                           (guint) fu_struct_ccgx_metadata_hdr_get_fw_size(st));
    g_string_append_printf(str, "  metadata_valid: 0x%x\n",
                           (guint) fu_struct_ccgx_metadata_hdr_get_metadata_valid(st));
    g_string_append_printf(str, "  boot_seq: 0x%x\n",
                           (guint) fu_struct_ccgx_metadata_hdr_get_boot_seq(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ccgx_metadata_hdr_validate_internal(FuStructCcgxMetadataHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ccgx_metadata_hdr_parse_internal(FuStructCcgxMetadataHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ccgx_metadata_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ccgx_metadata_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_ccgx_metadata_hdr_parse: (skip):
 **/
static FuStructCcgxMetadataHdr *
fu_struct_ccgx_metadata_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructCcgxMetadataHdr) st = fu_struct_ccgx_metadata_hdr_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 32, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructCcgxMetadataHdr: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 32);
    if (!fu_struct_ccgx_metadata_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ccgx_metadata_hdr_parse_bytes: (skip):
 **/
FuStructCcgxMetadataHdr *
fu_struct_ccgx_metadata_hdr_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ccgx_metadata_hdr_parse(buf, bufsz, offset, error);
}
