/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-ilitek-its-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"


/**
 * fu_struct_ilitek_its_hid_res_ref: (skip):
 **/
FuStructIlitekItsHidRes *
fu_struct_ilitek_its_hid_res_ref(FuStructIlitekItsHidRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ilitek_its_hid_res_unref: (skip):
 **/
void
fu_struct_ilitek_its_hid_res_unref(FuStructIlitekItsHidRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIlitekItsHidRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIlitekItsHidRes *
fu_struct_ilitek_its_hid_res_new_internal(void)
{
    FuStructIlitekItsHidRes *st = g_new0(FuStructIlitekItsHidRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ilitek_its_hid_res_get_report_id: (skip):
 **/
static guint8
fu_struct_ilitek_its_hid_res_get_report_id(const FuStructIlitekItsHidRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_ilitek_its_hid_res_get_res_size_supported_id: (skip):
 **/
static guint8
fu_struct_ilitek_its_hid_res_get_res_size_supported_id(const FuStructIlitekItsHidRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_ilitek_its_hid_res_get_cmd: (skip):
 **/
guint8
fu_struct_ilitek_its_hid_res_get_cmd(const FuStructIlitekItsHidRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_ilitek_its_hid_res_get_read_len: (skip):
 **/
guint8
fu_struct_ilitek_its_hid_res_get_read_len(const FuStructIlitekItsHidRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_ilitek_its_hid_res_get_data: (skip):
 **/
const guint8 *
fu_struct_ilitek_its_hid_res_get_data(const FuStructIlitekItsHidRes *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 60;
    return st->buf->data + 4;
}

/* setters */
/**
 * fu_struct_ilitek_its_hid_res_to_string: (skip):
 **/
static gchar *
fu_struct_ilitek_its_hid_res_to_string(const FuStructIlitekItsHidRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIlitekItsHidRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  cmd: 0x%x\n",
                           (guint) fu_struct_ilitek_its_hid_res_get_cmd(st));
    g_string_append_printf(str, "  read_len: 0x%x\n",
                           (guint) fu_struct_ilitek_its_hid_res_get_read_len(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_ilitek_its_hid_res_get_data(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  data: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ilitek_its_hid_res_validate_internal(FuStructIlitekItsHidRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_ilitek_its_hid_res_get_report_id(st) != 0x03) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructIlitekItsHidRes.report_id was not valid");
        return FALSE;
    }
    if (fu_struct_ilitek_its_hid_res_get_res_size_supported_id(st) != 0xA3) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructIlitekItsHidRes.res_size_supported_id was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_ilitek_its_hid_res_parse_internal(FuStructIlitekItsHidRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ilitek_its_hid_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ilitek_its_hid_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_ilitek_its_hid_res_parse: (skip):
 **/
FuStructIlitekItsHidRes *
fu_struct_ilitek_its_hid_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructIlitekItsHidRes) st = fu_struct_ilitek_its_hid_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 64, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructIlitekItsHidRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 64);
    if (!fu_struct_ilitek_its_hid_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ilitek_its_hid_cmd_ref: (skip):
 **/
FuStructIlitekItsHidCmd *
fu_struct_ilitek_its_hid_cmd_ref(FuStructIlitekItsHidCmd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ilitek_its_hid_cmd_unref: (skip):
 **/
void
fu_struct_ilitek_its_hid_cmd_unref(FuStructIlitekItsHidCmd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIlitekItsHidCmd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIlitekItsHidCmd *
fu_struct_ilitek_its_hid_cmd_new_internal(void)
{
    FuStructIlitekItsHidCmd *st = g_new0(FuStructIlitekItsHidCmd, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ilitek_its_hid_cmd_get_write_len: (skip):
 **/
guint8
fu_struct_ilitek_its_hid_cmd_get_write_len(const FuStructIlitekItsHidCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_ilitek_its_hid_cmd_get_read_len: (skip):
 **/
guint8
fu_struct_ilitek_its_hid_cmd_get_read_len(const FuStructIlitekItsHidCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_ilitek_its_hid_cmd_get_cmd: (skip):
 **/
FuIlitekItsCmd
fu_struct_ilitek_its_hid_cmd_get_cmd(const FuStructIlitekItsHidCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_ilitek_its_hid_cmd_get_data: (skip):
 **/
const guint8 *
fu_struct_ilitek_its_hid_cmd_get_data(const FuStructIlitekItsHidCmd *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 59;
    return st->buf->data + 5;
}

/* setters */
/**
 * fu_struct_ilitek_its_hid_cmd_set_report_id: (skip):
 **/
static void
fu_struct_ilitek_its_hid_cmd_set_report_id(FuStructIlitekItsHidCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_ilitek_its_hid_cmd_set_res_size_supported_id: (skip):
 **/
static void
fu_struct_ilitek_its_hid_cmd_set_res_size_supported_id(FuStructIlitekItsHidCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_ilitek_its_hid_cmd_set_write_len: (skip):
 **/
void
fu_struct_ilitek_its_hid_cmd_set_write_len(FuStructIlitekItsHidCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_ilitek_its_hid_cmd_set_read_len: (skip):
 **/
void
fu_struct_ilitek_its_hid_cmd_set_read_len(FuStructIlitekItsHidCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_ilitek_its_hid_cmd_set_cmd: (skip):
 **/
void
fu_struct_ilitek_its_hid_cmd_set_cmd(FuStructIlitekItsHidCmd *st, FuIlitekItsCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_ilitek_its_hid_cmd_set_data: (skip):
 **/
gboolean
fu_struct_ilitek_its_hid_cmd_set_data(FuStructIlitekItsHidCmd *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 5, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_ilitek_its_hid_cmd_new: (skip):
 **/
FuStructIlitekItsHidCmd *
fu_struct_ilitek_its_hid_cmd_new(void)
{
    FuStructIlitekItsHidCmd *st = fu_struct_ilitek_its_hid_cmd_new_internal();
    st->buf = g_byte_array_sized_new(64);
    fu_byte_array_set_size(st->buf, 64, 0x0);
    fu_struct_ilitek_its_hid_cmd_set_report_id(st, 0x03);
    fu_struct_ilitek_its_hid_cmd_set_res_size_supported_id(st, 0xA3);
    fu_struct_ilitek_its_hid_cmd_set_write_len(st, 0);
    fu_struct_ilitek_its_hid_cmd_set_read_len(st, 0);
    return st;
}
/**
 * fu_struct_ilitek_its_long_hid_cmd_ref: (skip):
 **/
FuStructIlitekItsLongHidCmd *
fu_struct_ilitek_its_long_hid_cmd_ref(FuStructIlitekItsLongHidCmd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ilitek_its_long_hid_cmd_unref: (skip):
 **/
void
fu_struct_ilitek_its_long_hid_cmd_unref(FuStructIlitekItsLongHidCmd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIlitekItsLongHidCmd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIlitekItsLongHidCmd *
fu_struct_ilitek_its_long_hid_cmd_new_internal(void)
{
    FuStructIlitekItsLongHidCmd *st = g_new0(FuStructIlitekItsLongHidCmd, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ilitek_its_long_hid_cmd_get_write_len: (skip):
 **/
guint16
fu_struct_ilitek_its_long_hid_cmd_get_write_len(const FuStructIlitekItsLongHidCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ilitek_its_long_hid_cmd_get_read_len: (skip):
 **/
guint16
fu_struct_ilitek_its_long_hid_cmd_get_read_len(const FuStructIlitekItsLongHidCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ilitek_its_long_hid_cmd_get_cmd: (skip):
 **/
FuIlitekItsCmd
fu_struct_ilitek_its_long_hid_cmd_get_cmd(const FuStructIlitekItsLongHidCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_ilitek_its_long_hid_cmd_get_data: (skip):
 **/
const guint8 *
fu_struct_ilitek_its_long_hid_cmd_get_data(const FuStructIlitekItsLongHidCmd *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 1024;
    return st->buf->data + 7;
}

/* setters */
/**
 * fu_struct_ilitek_its_long_hid_cmd_set_report_id: (skip):
 **/
static void
fu_struct_ilitek_its_long_hid_cmd_set_report_id(FuStructIlitekItsLongHidCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_ilitek_its_long_hid_cmd_set_res_size_supported_id: (skip):
 **/
static void
fu_struct_ilitek_its_long_hid_cmd_set_res_size_supported_id(FuStructIlitekItsLongHidCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_ilitek_its_long_hid_cmd_set_write_len: (skip):
 **/
void
fu_struct_ilitek_its_long_hid_cmd_set_write_len(FuStructIlitekItsLongHidCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ilitek_its_long_hid_cmd_set_read_len: (skip):
 **/
void
fu_struct_ilitek_its_long_hid_cmd_set_read_len(FuStructIlitekItsLongHidCmd *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ilitek_its_long_hid_cmd_set_cmd: (skip):
 **/
void
fu_struct_ilitek_its_long_hid_cmd_set_cmd(FuStructIlitekItsLongHidCmd *st, FuIlitekItsCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_ilitek_its_long_hid_cmd_set_data: (skip):
 **/
gboolean
fu_struct_ilitek_its_long_hid_cmd_set_data(FuStructIlitekItsLongHidCmd *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 7, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_ilitek_its_long_hid_cmd_new: (skip):
 **/
FuStructIlitekItsLongHidCmd *
fu_struct_ilitek_its_long_hid_cmd_new(void)
{
    FuStructIlitekItsLongHidCmd *st = fu_struct_ilitek_its_long_hid_cmd_new_internal();
    st->buf = g_byte_array_sized_new(1031);
    fu_byte_array_set_size(st->buf, 1031, 0x0);
    fu_struct_ilitek_its_long_hid_cmd_set_report_id(st, 0x08);
    fu_struct_ilitek_its_long_hid_cmd_set_res_size_supported_id(st, 0xA3);
    fu_struct_ilitek_its_long_hid_cmd_set_write_len(st, 0);
    fu_struct_ilitek_its_long_hid_cmd_set_read_len(st, 0);
    return st;
}
/**
 * fu_struct_ilitek_its_fwid_ref: (skip):
 **/
FuStructIlitekItsFwid *
fu_struct_ilitek_its_fwid_ref(FuStructIlitekItsFwid *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ilitek_its_fwid_unref: (skip):
 **/
void
fu_struct_ilitek_its_fwid_unref(FuStructIlitekItsFwid *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIlitekItsFwid refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIlitekItsFwid *
fu_struct_ilitek_its_fwid_new_internal(void)
{
    FuStructIlitekItsFwid *st = g_new0(FuStructIlitekItsFwid, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ilitek_its_fwid_get_customer_id: (skip):
 **/
guint16
fu_struct_ilitek_its_fwid_get_customer_id(const FuStructIlitekItsFwid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ilitek_its_fwid_get_fwid: (skip):
 **/
guint16
fu_struct_ilitek_its_fwid_get_fwid(const FuStructIlitekItsFwid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ilitek_its_fwid_to_string: (skip):
 **/
static gchar *
fu_struct_ilitek_its_fwid_to_string(const FuStructIlitekItsFwid *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIlitekItsFwid:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  customer_id: 0x%x\n",
                           (guint) fu_struct_ilitek_its_fwid_get_customer_id(st));
    g_string_append_printf(str, "  fwid: 0x%x\n",
                           (guint) fu_struct_ilitek_its_fwid_get_fwid(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ilitek_its_fwid_validate_internal(FuStructIlitekItsFwid *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ilitek_its_fwid_parse_internal(FuStructIlitekItsFwid *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ilitek_its_fwid_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ilitek_its_fwid_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_ilitek_its_fwid_parse: (skip):
 **/
FuStructIlitekItsFwid *
fu_struct_ilitek_its_fwid_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructIlitekItsFwid) st = fu_struct_ilitek_its_fwid_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructIlitekItsFwid: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_struct_ilitek_its_fwid_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ilitek_its_sensor_id_ref: (skip):
 **/
FuStructIlitekItsSensorId *
fu_struct_ilitek_its_sensor_id_ref(FuStructIlitekItsSensorId *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ilitek_its_sensor_id_unref: (skip):
 **/
void
fu_struct_ilitek_its_sensor_id_unref(FuStructIlitekItsSensorId *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIlitekItsSensorId refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIlitekItsSensorId *
fu_struct_ilitek_its_sensor_id_new_internal(void)
{
    FuStructIlitekItsSensorId *st = g_new0(FuStructIlitekItsSensorId, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ilitek_its_sensor_id_get_header: (skip):
 **/
static guint16
fu_struct_ilitek_its_sensor_id_get_header(const FuStructIlitekItsSensorId *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ilitek_its_sensor_id_get_sensor_id: (skip):
 **/
guint8
fu_struct_ilitek_its_sensor_id_get_sensor_id(const FuStructIlitekItsSensorId *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}

/* setters */
/**
 * fu_struct_ilitek_its_sensor_id_to_string: (skip):
 **/
static gchar *
fu_struct_ilitek_its_sensor_id_to_string(const FuStructIlitekItsSensorId *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIlitekItsSensorId:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  sensor_id: 0x%x\n",
                           (guint) fu_struct_ilitek_its_sensor_id_get_sensor_id(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ilitek_its_sensor_id_validate_internal(FuStructIlitekItsSensorId *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_ilitek_its_sensor_id_get_header(st) != 0xa55a) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructIlitekItsSensorId.header was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0xa55a,
                    (guint) fu_struct_ilitek_its_sensor_id_get_header(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_ilitek_its_sensor_id_parse_internal(FuStructIlitekItsSensorId *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ilitek_its_sensor_id_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ilitek_its_sensor_id_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_ilitek_its_sensor_id_parse: (skip):
 **/
FuStructIlitekItsSensorId *
fu_struct_ilitek_its_sensor_id_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructIlitekItsSensorId) st = fu_struct_ilitek_its_sensor_id_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructIlitekItsSensorId: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 3);
    if (!fu_struct_ilitek_its_sensor_id_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ilitek_its_mcu_version_ref: (skip):
 **/
FuStructIlitekItsMcuVersion *
fu_struct_ilitek_its_mcu_version_ref(FuStructIlitekItsMcuVersion *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ilitek_its_mcu_version_unref: (skip):
 **/
void
fu_struct_ilitek_its_mcu_version_unref(FuStructIlitekItsMcuVersion *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIlitekItsMcuVersion refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIlitekItsMcuVersion *
fu_struct_ilitek_its_mcu_version_new_internal(void)
{
    FuStructIlitekItsMcuVersion *st = g_new0(FuStructIlitekItsMcuVersion, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ilitek_its_mcu_version_get_ic_name: (skip):
 **/
guint16
fu_struct_ilitek_its_mcu_version_get_ic_name(const FuStructIlitekItsMcuVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ilitek_its_mcu_version_get_data_flash_addr: (skip):
 **/
guint32
fu_struct_ilitek_its_mcu_version_get_data_flash_addr(const FuStructIlitekItsMcuVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ilitek_its_mcu_version_get_data_flash_size: (skip):
 **/
guint8
fu_struct_ilitek_its_mcu_version_get_data_flash_size(const FuStructIlitekItsMcuVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_ilitek_its_mcu_version_get_module_name: (skip):
 **/
gchar *
fu_struct_ilitek_its_mcu_version_get_module_name(const FuStructIlitekItsMcuVersion *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 6, 26, NULL);
}

/* setters */
/**
 * fu_struct_ilitek_its_mcu_version_to_string: (skip):
 **/
static gchar *
fu_struct_ilitek_its_mcu_version_to_string(const FuStructIlitekItsMcuVersion *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIlitekItsMcuVersion:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  ic_name: 0x%x\n",
                           (guint) fu_struct_ilitek_its_mcu_version_get_ic_name(st));
    g_string_append_printf(str, "  data_flash_addr: 0x%x\n",
                           (guint) fu_struct_ilitek_its_mcu_version_get_data_flash_addr(st));
    g_string_append_printf(str, "  data_flash_size: 0x%x\n",
                           (guint) fu_struct_ilitek_its_mcu_version_get_data_flash_size(st));
    {
        g_autofree gchar *tmp = fu_struct_ilitek_its_mcu_version_get_module_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  module_name: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ilitek_its_mcu_version_validate_internal(FuStructIlitekItsMcuVersion *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ilitek_its_mcu_version_parse_internal(FuStructIlitekItsMcuVersion *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ilitek_its_mcu_version_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ilitek_its_mcu_version_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_ilitek_its_mcu_version_parse: (skip):
 **/
FuStructIlitekItsMcuVersion *
fu_struct_ilitek_its_mcu_version_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructIlitekItsMcuVersion) st = fu_struct_ilitek_its_mcu_version_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 32, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructIlitekItsMcuVersion: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 32);
    if (!fu_struct_ilitek_its_mcu_version_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ilitek_its_mcu_info_ref: (skip):
 **/
FuStructIlitekItsMcuInfo *
fu_struct_ilitek_its_mcu_info_ref(FuStructIlitekItsMcuInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ilitek_its_mcu_info_unref: (skip):
 **/
void
fu_struct_ilitek_its_mcu_info_unref(FuStructIlitekItsMcuInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIlitekItsMcuInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIlitekItsMcuInfo *
fu_struct_ilitek_its_mcu_info_new_internal(void)
{
    FuStructIlitekItsMcuInfo *st = g_new0(FuStructIlitekItsMcuInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ilitek_its_mcu_info_get_ic_name: (skip):
 **/
gchar *
fu_struct_ilitek_its_mcu_info_get_ic_name(const FuStructIlitekItsMcuInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 5, NULL);
}
/**
 * fu_struct_ilitek_its_mcu_info_get_mm_addr: (skip):
 **/
guint32
fu_struct_ilitek_its_mcu_info_get_mm_addr(const FuStructIlitekItsMcuInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 7, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ilitek_its_mcu_info_get_module_name: (skip):
 **/
gchar *
fu_struct_ilitek_its_mcu_info_get_module_name(const FuStructIlitekItsMcuInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 10, 18, NULL);
}

/* setters */
/**
 * fu_struct_ilitek_its_mcu_info_to_string: (skip):
 **/
static gchar *
fu_struct_ilitek_its_mcu_info_to_string(const FuStructIlitekItsMcuInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIlitekItsMcuInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_ilitek_its_mcu_info_get_ic_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ic_name: %s\n", tmp);
    }
    g_string_append_printf(str, "  mm_addr: 0x%x\n",
                           (guint) fu_struct_ilitek_its_mcu_info_get_mm_addr(st));
    {
        g_autofree gchar *tmp = fu_struct_ilitek_its_mcu_info_get_module_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  module_name: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ilitek_its_mcu_info_validate_internal(FuStructIlitekItsMcuInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ilitek_its_mcu_info_parse_internal(FuStructIlitekItsMcuInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ilitek_its_mcu_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ilitek_its_mcu_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_ilitek_its_mcu_info_parse: (skip):
 **/
FuStructIlitekItsMcuInfo *
fu_struct_ilitek_its_mcu_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructIlitekItsMcuInfo) st = fu_struct_ilitek_its_mcu_info_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 28, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructIlitekItsMcuInfo: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 28);
    if (!fu_struct_ilitek_its_mcu_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ilitek_its_block_info_ref: (skip):
 **/
FuStructIlitekItsBlockInfo *
fu_struct_ilitek_its_block_info_ref(FuStructIlitekItsBlockInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ilitek_its_block_info_unref: (skip):
 **/
void
fu_struct_ilitek_its_block_info_unref(FuStructIlitekItsBlockInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIlitekItsBlockInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIlitekItsBlockInfo *
fu_struct_ilitek_its_block_info_new_internal(void)
{
    FuStructIlitekItsBlockInfo *st = g_new0(FuStructIlitekItsBlockInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ilitek_its_block_info_get_addr: (skip):
 **/
guint32
fu_struct_ilitek_its_block_info_get_addr(const FuStructIlitekItsBlockInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 0, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ilitek_its_block_info_to_string: (skip):
 **/
static gchar *
fu_struct_ilitek_its_block_info_to_string(const FuStructIlitekItsBlockInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIlitekItsBlockInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  addr: 0x%x\n",
                           (guint) fu_struct_ilitek_its_block_info_get_addr(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ilitek_its_block_info_validate_internal(FuStructIlitekItsBlockInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/**
 * fu_struct_ilitek_its_mm_info_ref: (skip):
 **/
FuStructIlitekItsMmInfo *
fu_struct_ilitek_its_mm_info_ref(FuStructIlitekItsMmInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ilitek_its_mm_info_unref: (skip):
 **/
void
fu_struct_ilitek_its_mm_info_unref(FuStructIlitekItsMmInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIlitekItsMmInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructIlitekItsMmInfo *
fu_struct_ilitek_its_mm_info_new_internal(void)
{
    FuStructIlitekItsMmInfo *st = g_new0(FuStructIlitekItsMmInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ilitek_its_mm_info_get_mapping_ver: (skip):
 **/
guint32
fu_struct_ilitek_its_mm_info_get_mapping_ver(const FuStructIlitekItsMmInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ilitek_its_mm_info_get_protocol_ver: (skip):
 **/
guint32
fu_struct_ilitek_its_mm_info_get_protocol_ver(const FuStructIlitekItsMmInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 3, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ilitek_its_mm_info_get_ic_name: (skip):
 **/
const guint8 *
fu_struct_ilitek_its_mm_info_get_ic_name(const FuStructIlitekItsMmInfo *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 6;
    return st->buf->data + 6;
}
/**
 * fu_struct_ilitek_its_mm_info_get_tuning_ver: (skip):
 **/
guint32
fu_struct_ilitek_its_mm_info_get_tuning_ver(const FuStructIlitekItsMmInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ilitek_its_mm_info_get_fw_ver: (skip):
 **/
guint32
fu_struct_ilitek_its_mm_info_get_fw_ver(const FuStructIlitekItsMmInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ilitek_its_mm_info_get_fwid: (skip):
 **/
guint16
fu_struct_ilitek_its_mm_info_get_fwid(const FuStructIlitekItsMmInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 44, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ilitek_its_mm_info_get_block_num: (skip):
 **/
guint8
fu_struct_ilitek_its_mm_info_get_block_num(const FuStructIlitekItsMmInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[80];
}
/**
 * fu_struct_ilitek_its_mm_info_get_blocks: (skip):
 **/
FuStructIlitekItsBlockInfo *
fu_struct_ilitek_its_mm_info_get_blocks(const FuStructIlitekItsMmInfo *st, guint idx)
{
    g_autoptr(FuStructIlitekItsBlockInfo) st_tmp = fu_struct_ilitek_its_block_info_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    g_return_val_if_fail(idx < 10, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf,
                        st->buf->data
                            + FU_STRUCT_ILITEK_ITS_MM_INFO_OFFSET_BLOCKS
                            + (FU_STRUCT_ILITEK_ITS_BLOCK_INFO_SIZE * idx),
                        3);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_ilitek_its_mm_info_get_end_addr: (skip):
 **/
guint32
fu_struct_ilitek_its_mm_info_get_end_addr(const FuStructIlitekItsMmInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 123, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ilitek_its_mm_info_to_string: (skip):
 **/
static gchar *
fu_struct_ilitek_its_mm_info_to_string(const FuStructIlitekItsMmInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIlitekItsMmInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  mapping_ver: 0x%x\n",
                           (guint) fu_struct_ilitek_its_mm_info_get_mapping_ver(st));
    g_string_append_printf(str, "  protocol_ver: 0x%x\n",
                           (guint) fu_struct_ilitek_its_mm_info_get_protocol_ver(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_ilitek_its_mm_info_get_ic_name(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  ic_name: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  tuning_ver: 0x%x\n",
                           (guint) fu_struct_ilitek_its_mm_info_get_tuning_ver(st));
    g_string_append_printf(str, "  fw_ver: 0x%x\n",
                           (guint) fu_struct_ilitek_its_mm_info_get_fw_ver(st));
    g_string_append_printf(str, "  fwid: 0x%x\n",
                           (guint) fu_struct_ilitek_its_mm_info_get_fwid(st));
    g_string_append_printf(str, "  block_num: 0x%x\n",
                           (guint) fu_struct_ilitek_its_mm_info_get_block_num(st));
    for (guint i = 0; i < 10; i++) {
        g_autoptr(FuStructIlitekItsBlockInfo) st_tmp = fu_struct_ilitek_its_mm_info_get_blocks(st, i);
        g_autofree gchar *tmp = fu_struct_ilitek_its_block_info_to_string(st_tmp);
        g_string_append_printf(str, "  blocks[%u]: %s\n", i, tmp);
    }
    g_string_append_printf(str, "  end_addr: 0x%x\n",
                           (guint) fu_struct_ilitek_its_mm_info_get_end_addr(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ilitek_its_mm_info_validate_internal(FuStructIlitekItsMmInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x54,
            .len = 30,
        };
        FuStructIlitekItsBlockInfo st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_ilitek_its_block_info_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_ilitek_its_mm_info_parse_internal(FuStructIlitekItsMmInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ilitek_its_mm_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ilitek_its_mm_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_ilitek_its_mm_info_parse: (skip):
 **/
static FuStructIlitekItsMmInfo *
fu_struct_ilitek_its_mm_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructIlitekItsMmInfo) st = fu_struct_ilitek_its_mm_info_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 128, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructIlitekItsMmInfo: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 128);
    if (!fu_struct_ilitek_its_mm_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ilitek_its_mm_info_parse_bytes: (skip):
 **/
FuStructIlitekItsMmInfo *
fu_struct_ilitek_its_mm_info_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ilitek_its_mm_info_parse(buf, bufsz, offset, error);
}
