//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PHttpChannelChild.h"
#include "mozilla/AntiTrackingIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/FeaturePolicyUtils.h"
#include "mozilla/dom/FetchIPCTypes.h"
#include "mozilla/dom/NavigationAPIIPCUtils.h"
#include "mozilla/dom/PropertyBagUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/ServiceWorkerIPCUtils.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/dom/WorkerIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/TransportSecurityInfoUtils.h"
#include "mozilla/ipc/URIUtils.h"
#include "mozilla/net/CacheInfoIPCTypes.h"
#include "mozilla/net/ClassOfService.h"
#include "mozilla/net/NeckoMessageUtils.h"
#include "nsDOMNavigationTiming.h"
#include "nsDocShellLoadState.h"
#include "nsHttp.h"
#include "nsHttpHeaderArray.h"
#include "nsHttpResponseHead.h"
#include "nsIPropertyBag2.h"
#include "nsIReferrerInfo.h"
#include "nsITransportSecurityInfo.h"

#include "mozilla/net/PNeckoChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


MOZ_IMPLICIT PHttpChannelChild::PHttpChannelChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PHttpChannelChild);
}

PHttpChannelChild::~PHttpChannelChild()
{
    MOZ_COUNT_DTOR(PHttpChannelChild);
}

auto PHttpChannelChild::ActorAlloc() -> void
{
    AddRef();
}

auto PHttpChannelChild::ActorDealloc() -> void
{
    Release();
}

auto PHttpChannelChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PHttpChannelChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PHttpChannelChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PHttpChannelChild::Manager() const -> PNeckoChild*
{
    return static_cast<PNeckoChild*>(IProtocol::Manager());
}

auto PHttpChannelChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PHttpChannelChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PHttpChannelChild::SendSetClassOfService(const ClassOfService& cos) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_SetClassOfService(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), cos);
    // Sentinel = 'cos'
    ((&(writer__)))->WriteSentinel(41746758);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_SetClassOfService", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelChild::SendSuspend() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_Suspend(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_Suspend", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelChild::SendResume() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_Resume(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_Resume", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelChild::SendCancel(
        const nsresult& status,
        const uint32_t& requestBlockingReason,
        const nsACString& aReason,
        const mozilla::Maybe<nsCString>& logString) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_Cancel(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), status);
    // Sentinel = 'status'
    ((&(writer__)))->WriteSentinel(154731173);
    IPC::WriteParam((&(writer__)), requestBlockingReason);
    // Sentinel = 'requestBlockingReason'
    ((&(writer__)))->WriteSentinel(1599867035);
    IPC::WriteParam((&(writer__)), aReason);
    // Sentinel = 'aReason'
    ((&(writer__)))->WriteSentinel(180093642);
    IPC::WriteParam((&(writer__)), logString);
    // Sentinel = 'logString'
    ((&(writer__)))->WriteSentinel(312083386);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_Cancel", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelChild::SendRedirect2Verify(
        const nsresult& result,
        const RequestHeaderTuples& changedHeaders,
        const uint32_t& sourceRequestBlockingReason,
        const mozilla::Maybe<ChildLoadInfoForwarderArgs>& targetLoadInfoForwarder,
        const uint32_t& loadFlags,
        nsIReferrerInfo* referrerInfo,
        nsIURI* apiRedirectTo,
        const mozilla::Maybe<CorsPreflightArgs>& corsPreflightArgs) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_Redirect2Verify(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), result);
    // Sentinel = 'result'
    ((&(writer__)))->WriteSentinel(153223840);
    IPC::WriteParam((&(writer__)), changedHeaders);
    // Sentinel = 'changedHeaders'
    ((&(writer__)))->WriteSentinel(688522631);
    IPC::WriteParam((&(writer__)), sourceRequestBlockingReason);
    // Sentinel = 'sourceRequestBlockingReason'
    ((&(writer__)))->WriteSentinel(2614692620);
    IPC::WriteParam((&(writer__)), targetLoadInfoForwarder);
    // Sentinel = 'targetLoadInfoForwarder'
    ((&(writer__)))->WriteSentinel(1854474560);
    IPC::WriteParam((&(writer__)), loadFlags);
    // Sentinel = 'loadFlags'
    ((&(writer__)))->WriteSentinel(297665422);
    IPC::WriteParam((&(writer__)), referrerInfo);
    // Sentinel = 'referrerInfo'
    ((&(writer__)))->WriteSentinel(540214506);
    IPC::WriteParam((&(writer__)), apiRedirectTo);
    // Sentinel = 'apiRedirectTo'
    ((&(writer__)))->WriteSentinel(606143792);
    IPC::WriteParam((&(writer__)), corsPreflightArgs);
    // Sentinel = 'corsPreflightArgs'
    ((&(writer__)))->WriteSentinel(1048250090);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_Redirect2Verify", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelChild::SendDocumentChannelCleanup(const bool& clearCacheEntry) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_DocumentChannelCleanup(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), clearCacheEntry);
    // Sentinel = 'clearCacheEntry'
    ((&(writer__)))->WriteSentinel(779486702);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_DocumentChannelCleanup", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelChild::SendRemoveCorsPreflightCacheEntry(
        nsIURI* uri,
        const PrincipalInfo& requestingPrincipal,
        const OriginAttributes& originAttributes) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_RemoveCorsPreflightCacheEntry(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), uri);
    // Sentinel = 'uri'
    ((&(writer__)))->WriteSentinel(45023569);
    IPC::WriteParam((&(writer__)), requestingPrincipal);
    // Sentinel = 'requestingPrincipal'
    ((&(writer__)))->WriteSentinel(1344079850);
    IPC::WriteParam((&(writer__)), originAttributes);
    // Sentinel = 'originAttributes'
    ((&(writer__)))->WriteSentinel(947259056);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_RemoveCorsPreflightCacheEntry", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelChild::SendSetCookies(
        const nsACString& baseDomain,
        const OriginAttributes& attrs,
        nsIURI* host,
        const bool& fromHttp,
        const bool& isThirdParty,
        mozilla::Span<CookieStruct const> cookies) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_SetCookies(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), baseDomain);
    // Sentinel = 'baseDomain'
    ((&(writer__)))->WriteSentinel(360449012);
    IPC::WriteParam((&(writer__)), attrs);
    // Sentinel = 'attrs'
    ((&(writer__)))->WriteSentinel(107807279);
    IPC::WriteParam((&(writer__)), host);
    // Sentinel = 'host'
    ((&(writer__)))->WriteSentinel(72024511);
    IPC::WriteParam((&(writer__)), fromHttp);
    // Sentinel = 'fromHttp'
    ((&(writer__)))->WriteSentinel(249889621);
    IPC::WriteParam((&(writer__)), isThirdParty);
    // Sentinel = 'isThirdParty'
    ((&(writer__)))->WriteSentinel(526517480);
    IPC::WriteParam((&(writer__)), cookies);
    // Sentinel = 'cookies'
    ((&(writer__)))->WriteSentinel(195363566);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_SetCookies", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelChild::SendDeletingChannel() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_DeletingChannel(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_DeletingChannel", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelChild::SendOpenOriginalCacheInputStream() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_OpenOriginalCacheInputStream(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_OpenOriginalCacheInputStream", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelChild::SendBytesRead(const int32_t& count) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_BytesRead(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), count);
    // Sentinel = 'count'
    ((&(writer__)))->WriteSentinel(106889770);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_BytesRead", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelChild::Send__delete__(PHttpChannelChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PHttpChannelChild::SendSetPriority(const int16_t& priority) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_SetPriority(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), priority);
    // Sentinel = 'priority'
    ((&(writer__)))->WriteSentinel(262865795);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_SetPriority", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PHttpChannelChild::OnMessageReceived(const Message& msg__) -> PHttpChannelChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PHttpChannel::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PHttpChannel::Msg_FailedAsyncOpen__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_FailedAsyncOpen", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__status = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__status) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& status = *maybe__status;
            // Sentinel = 'status'
            if ((!(((&(reader__)))->ReadSentinel(154731173)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvFailedAsyncOpen(std::move(status));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_OnStartRequestSent__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_OnStartRequestSent", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvOnStartRequestSent();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_Redirect1Begin__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_Redirect1Begin", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__registrarId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__registrarId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& registrarId = *maybe__registrarId;
            // Sentinel = 'registrarId'
            if ((!(((&(reader__)))->ReadSentinel(464585857)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__newOriginalUri = IPC::ReadParam<RefPtr<nsIURI>>((&(reader__)));
            if (!maybe__newOriginalUri) {
                FatalError("Error deserializing 'nsIURI'");
                return MsgValueError;

            }
            auto& newOriginalUri = *maybe__newOriginalUri;
            // Sentinel = 'newOriginalUri'
            if ((!(((&(reader__)))->ReadSentinel(719127984)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsIURI'");
                return MsgValueError;
            }
            auto maybe__newLoadFlags = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__newLoadFlags) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& newLoadFlags = *maybe__newLoadFlags;
            // Sentinel = 'newLoadFlags'
            if ((!(((&(reader__)))->ReadSentinel(516293816)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__redirectFlags = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__redirectFlags) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& redirectFlags = *maybe__redirectFlags;
            // Sentinel = 'redirectFlags'
            if ((!(((&(reader__)))->ReadSentinel(620889408)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__loadInfoForwarder = IPC::ReadParam<ParentLoadInfoForwarderArgs>((&(reader__)));
            if (!maybe__loadInfoForwarder) {
                FatalError("Error deserializing 'ParentLoadInfoForwarderArgs'");
                return MsgValueError;

            }
            auto& loadInfoForwarder = *maybe__loadInfoForwarder;
            // Sentinel = 'loadInfoForwarder'
            if ((!(((&(reader__)))->ReadSentinel(1020528345)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ParentLoadInfoForwarderArgs'");
                return MsgValueError;
            }
            auto maybe__responseHead = IPC::ReadParam<nsHttpResponseHead>((&(reader__)));
            if (!maybe__responseHead) {
                FatalError("Error deserializing 'nsHttpResponseHead'");
                return MsgValueError;

            }
            auto& responseHead = *maybe__responseHead;
            // Sentinel = 'responseHead'
            if ((!(((&(reader__)))->ReadSentinel(549651682)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsHttpResponseHead'");
                return MsgValueError;
            }
            auto maybe__securityInfo = IPC::ReadParam<RefPtr<nsITransportSecurityInfo>>((&(reader__)));
            if (!maybe__securityInfo) {
                FatalError("Error deserializing 'nsITransportSecurityInfo'");
                return MsgValueError;

            }
            auto& securityInfo = *maybe__securityInfo;
            // Sentinel = 'securityInfo'
            if ((!(((&(reader__)))->ReadSentinel(552535301)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsITransportSecurityInfo'");
                return MsgValueError;
            }
            auto maybe__channelId = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__channelId) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& channelId = *maybe__channelId;
            // Sentinel = 'channelId'
            if ((!(((&(reader__)))->ReadSentinel(301138823)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__oldPeerAddr = IPC::ReadParam<NetAddr>((&(reader__)));
            if (!maybe__oldPeerAddr) {
                FatalError("Error deserializing 'NetAddr'");
                return MsgValueError;

            }
            auto& oldPeerAddr = *maybe__oldPeerAddr;
            // Sentinel = 'oldPeerAddr'
            if ((!(((&(reader__)))->ReadSentinel(433128519)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NetAddr'");
                return MsgValueError;
            }
            auto maybe__timing = IPC::ReadParam<ResourceTimingStructArgs>((&(reader__)));
            if (!maybe__timing) {
                FatalError("Error deserializing 'ResourceTimingStructArgs'");
                return MsgValueError;

            }
            auto& timing = *maybe__timing;
            // Sentinel = 'timing'
            if ((!(((&(reader__)))->ReadSentinel(150798985)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ResourceTimingStructArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvRedirect1Begin(std::move(registrarId), newOriginalUri, std::move(newLoadFlags), std::move(redirectFlags), std::move(loadInfoForwarder), std::move(responseHead), securityInfo, std::move(channelId), std::move(oldPeerAddr), std::move(timing));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_Redirect3Complete__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_Redirect3Complete", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvRedirect3Complete();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_RedirectFailed__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_RedirectFailed", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__status = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__status) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& status = *maybe__status;
            // Sentinel = 'status'
            if ((!(((&(reader__)))->ReadSentinel(154731173)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvRedirectFailed(std::move(status));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_ReportSecurityMessage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_ReportSecurityMessage", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__messageTag = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__messageTag) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& messageTag = *maybe__messageTag;
            // Sentinel = 'messageTag'
            if ((!(((&(reader__)))->ReadSentinel(379061250)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__messageCategory = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__messageCategory) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& messageCategory = *maybe__messageCategory;
            // Sentinel = 'messageCategory'
            if ((!(((&(reader__)))->ReadSentinel(816252452)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvReportSecurityMessage(std::move(messageTag), std::move(messageCategory));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_ReportLNAToConsole__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_ReportLNAToConsole", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__peerAddr = IPC::ReadParam<NetAddr>((&(reader__)));
            if (!maybe__peerAddr) {
                FatalError("Error deserializing 'NetAddr'");
                return MsgValueError;

            }
            auto& peerAddr = *maybe__peerAddr;
            // Sentinel = 'peerAddr'
            if ((!(((&(reader__)))->ReadSentinel(239928104)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NetAddr'");
                return MsgValueError;
            }
            auto maybe__messageType = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__messageType) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& messageType = *maybe__messageType;
            // Sentinel = 'messageType'
            if ((!(((&(reader__)))->ReadSentinel(458818696)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__promptAction = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__promptAction) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& promptAction = *maybe__promptAction;
            // Sentinel = 'promptAction'
            if ((!(((&(reader__)))->ReadSentinel(550831361)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__topLevelSite = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__topLevelSite) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& topLevelSite = *maybe__topLevelSite;
            // Sentinel = 'topLevelSite'
            if ((!(((&(reader__)))->ReadSentinel(536675553)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvReportLNAToConsole(std::move(peerAddr), std::move(messageType), std::move(promptAction), std::move(topLevelSite));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_DeleteSelf__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_DeleteSelf", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeleteSelf();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_LogBlockedCORSRequest__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_LogBlockedCORSRequest", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__message = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__message) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& message = *maybe__message;
            // Sentinel = 'message'
            if ((!(((&(reader__)))->ReadSentinel(197198566)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__category = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__category) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& category = *maybe__category;
            // Sentinel = 'category'
            if ((!(((&(reader__)))->ReadSentinel(247333727)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__isWarning = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__isWarning) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& isWarning = *maybe__isWarning;
            // Sentinel = 'isWarning'
            if ((!(((&(reader__)))->ReadSentinel(308872115)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvLogBlockedCORSRequest(std::move(message), std::move(category), std::move(isWarning));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_LogMimeTypeMismatch__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_LogMimeTypeMismatch", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__messageName = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__messageName) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& messageName = *maybe__messageName;
            // Sentinel = 'messageName'
            if ((!(((&(reader__)))->ReadSentinel(452133991)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__warning = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__warning) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& warning = *maybe__warning;
            // Sentinel = 'warning'
            if ((!(((&(reader__)))->ReadSentinel(201196279)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__url = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__url) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& url = *maybe__url;
            // Sentinel = 'url'
            if ((!(((&(reader__)))->ReadSentinel(45220180)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__contentType = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__contentType) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& contentType = *maybe__contentType;
            // Sentinel = 'contentType'
            if ((!(((&(reader__)))->ReadSentinel(465241246)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvLogMimeTypeMismatch(std::move(messageName), std::move(warning), std::move(url), std::move(contentType));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_OriginalCacheInputStreamAvailable__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_OriginalCacheInputStreamAvailable", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__stream = IPC::ReadParam<mozilla::Maybe<IPCStream>>((&(reader__)));
            if (!maybe__stream) {
                FatalError("Error deserializing 'IPCStream?'");
                return MsgValueError;

            }
            auto& stream = *maybe__stream;
            // Sentinel = 'stream'
            if ((!(((&(reader__)))->ReadSentinel(153223821)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IPCStream?'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvOriginalCacheInputStreamAvailable(std::move(stream));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_SetPriority__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_SetPriority", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__priority = IPC::ReadParam<int16_t>((&(reader__)));
            if (!maybe__priority) {
                FatalError("Error deserializing 'int16_t'");
                return MsgValueError;

            }
            auto& priority = *maybe__priority;
            // Sentinel = 'priority'
            if ((!(((&(reader__)))->ReadSentinel(262865795)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int16_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetPriority(std::move(priority));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PHttpChannelChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PHttpChannelChild::Result
{
    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PHttpChannelChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PHttpChannel'
    (aWriter)->WriteSentinel(492962986);
}

auto ParamTraits<::mozilla::net::PHttpChannelChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PHttpChannel actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PHttpChannel'
    if ((!((aReader)->ReadSentinel(492962986)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PHttpChannel actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PHttpChannelMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PHttpChannel)");

        return {};
    }
    return static_cast<::mozilla::net::PHttpChannelChild*>(actor);
}

} // namespace IPC
