// Generated from libavfilter/opencl/xfade.cl
const char *ff_source_xfade_cl =
"/*\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"const sampler_t sampler = (CLK_NORMALIZED_COORDS_FALSE |\n"
"                           CLK_FILTER_NEAREST);\n"
"\n"
"__kernel void fade(__write_only image2d_t dst,\n"
"                   __read_only  image2d_t src1,\n"
"                   __read_only  image2d_t src2,\n"
"                   float progress)\n"
"{\n"
"    int2  p = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    float4 val1 = read_imagef(src1, sampler, p);\n"
"    float4 val2 = read_imagef(src2, sampler, p);\n"
"\n"
"    write_imagef(dst, p, mix(val2, val1, progress));\n"
"}\n"
"\n"
"__kernel void wipeleft(__write_only image2d_t dst,\n"
"                       __read_only  image2d_t src1,\n"
"                       __read_only  image2d_t src2,\n"
"                       float progress)\n"
"{\n"
"    int   s = (int)(get_image_dim(src1).x * progress);\n"
"    int2  p = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    float4 val1 = read_imagef(src1, sampler, p);\n"
"    float4 val2 = read_imagef(src2, sampler, p);\n"
"\n"
"    write_imagef(dst, p, p.x > s ? val2 : val1);\n"
"}\n"
"\n"
"__kernel void wiperight(__write_only image2d_t dst,\n"
"                        __read_only  image2d_t src1,\n"
"                        __read_only  image2d_t src2,\n"
"                        float progress)\n"
"{\n"
"    int   s = (int)(get_image_dim(src1).x * (1.f - progress));\n"
"    int2  p = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    float4 val1 = read_imagef(src1, sampler, p);\n"
"    float4 val2 = read_imagef(src2, sampler, p);\n"
"\n"
"    write_imagef(dst, p, p.x > s ? val1 : val2);\n"
"}\n"
"\n"
"__kernel void wipeup(__write_only image2d_t dst,\n"
"                     __read_only  image2d_t src1,\n"
"                     __read_only  image2d_t src2,\n"
"                     float progress)\n"
"{\n"
"    int   s = (int)(get_image_dim(src1).y * progress);\n"
"    int2  p = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    float4 val1 = read_imagef(src1, sampler, p);\n"
"    float4 val2 = read_imagef(src2, sampler, p);\n"
"\n"
"    write_imagef(dst, p, p.y > s ? val2 : val1);\n"
"}\n"
"\n"
"__kernel void wipedown(__write_only image2d_t dst,\n"
"                       __read_only  image2d_t src1,\n"
"                       __read_only  image2d_t src2,\n"
"                       float progress)\n"
"{\n"
"    int   s = (int)(get_image_dim(src1).y * (1.f - progress));\n"
"    int2  p = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    float4 val1 = read_imagef(src1, sampler, p);\n"
"    float4 val2 = read_imagef(src2, sampler, p);\n"
"\n"
"    write_imagef(dst, p, p.y > s ? val1 : val2);\n"
"}\n"
"\n"
"void slide(__write_only image2d_t dst,\n"
"           __read_only  image2d_t src1,\n"
"           __read_only  image2d_t src2,\n"
"           float progress,\n"
"           int2 direction)\n"
"{\n"
"    int   w = get_image_dim(src1).x;\n"
"    int   h = get_image_dim(src1).y;\n"
"    int2 wh = (int2)(w, h);\n"
"    int2 uv = (int2)(get_global_id(0), get_global_id(1));\n"
"    int2 pi = (int2)(progress * w, progress * h);\n"
"    int2 p = uv + pi * direction;\n"
"    int2 f = p % wh;\n"
"\n"
"    f = f + (int2)(w, h) * (int2)(f.x < 0, f.y < 0);\n"
"    float4 val1 = read_imagef(src1, sampler, f);\n"
"    float4 val2 = read_imagef(src2, sampler, f);\n"
"    write_imagef(dst, uv, mix(val1, val2, (p.y >= 0) * (h > p.y) * (p.x >= 0) * (w > p.x)));\n"
"}\n"
"\n"
"__kernel void slidedown(__write_only image2d_t dst,\n"
"                        __read_only  image2d_t src1,\n"
"                        __read_only  image2d_t src2,\n"
"                        float progress)\n"
"{\n"
"    int2 direction = (int2)(0, 1);\n"
"    slide(dst, src1, src2, progress, direction);\n"
"}\n"
"\n"
"__kernel void slideup(__write_only image2d_t dst,\n"
"                      __read_only  image2d_t src1,\n"
"                      __read_only  image2d_t src2,\n"
"                      float progress)\n"
"{\n"
"    int2 direction = (int2)(0, -1);\n"
"    slide(dst, src1, src2, progress, direction);\n"
"}\n"
"\n"
"__kernel void slideleft(__write_only image2d_t dst,\n"
"                        __read_only  image2d_t src1,\n"
"                        __read_only  image2d_t src2,\n"
"                        float progress)\n"
"{\n"
"    int2 direction = (int2)(-1, 0);\n"
"    slide(dst, src1, src2, progress, direction);\n"
"}\n"
"\n"
"__kernel void slideright(__write_only image2d_t dst,\n"
"                         __read_only  image2d_t src1,\n"
"                         __read_only  image2d_t src2,\n"
"                         float progress)\n"
"{\n"
"    int2 direction = (int2)(1, 0);\n"
"    slide(dst, src1, src2, progress, direction);\n"
"}\n"
;
