
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "tabmodel_wrapper.h"

// Wrappers providing overrides
#include "tabtreemodel_wrapper.h"
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_TabModel_Type = nullptr;
static PyTypeObject *Sbk_TabModel_TypeF(void)
{
    return _Sbk_TabModel_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void TabModelWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::TabModel::Roles >("TabModel::Roles");
}

void TabModelWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

TabModelWrapper::TabModelWrapper(::BrowserWindow * window, ::QObject * parent) : TabModel(window, parent)
{
}

::QModelIndex TabModelWrapper::buddy(const ::QModelIndex & index) const
{
    static const char *funcName = "buddy";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::buddy(index);
    }
    return TabTreeModelWrapper::sbk_o_buddy("TabModel", funcName, gil, pyOverride, index);
}

bool TabModelWrapper::canDropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent) const
{
    static const char *funcName = "canDropMimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabModel::canDropMimeData(data, action, row, column, parent);
    }
    return TabTreeModelWrapper::sbk_o_canDropMimeData("TabModel", funcName, gil, pyOverride, data, action, row, column, parent);
}

bool TabModelWrapper::canFetchMore(const ::QModelIndex & parent) const
{
    static const char *funcName = "canFetchMore";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::canFetchMore(parent);
    }
    return TabTreeModelWrapper::sbk_o_canFetchMore("TabModel", funcName, gil, pyOverride, parent);
}

void TabModelWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("TabModel", funcName, gil, pyOverride, event);
}

bool TabModelWrapper::clearItemData(const ::QModelIndex & index)
{
    static const char *funcName = "clearItemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::clearItemData(index);
    }
    return TabTreeModelWrapper::sbk_o_canFetchMore("TabModel", funcName, gil, pyOverride, index);
}

void TabModelWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("TabModel", funcName, gil, pyOverride, signal);
}

void TabModelWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("TabModel", funcName, gil, pyOverride, event);
}

::QVariant TabModelWrapper::data(const ::QModelIndex & index, int role) const
{
    static const char *funcName = "data";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabModel::data(index, role);
    }
    return TabTreeModelWrapper::sbk_o_data("TabModel", funcName, gil, pyOverride, index, role);
}

void TabModelWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("TabModel", funcName, gil, pyOverride, signal);
}

bool TabModelWrapper::dropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent)
{
    static const char *funcName = "dropMimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabModel::dropMimeData(data, action, row, column, parent);
    }
    return TabTreeModelWrapper::sbk_o_canDropMimeData("TabModel", funcName, gil, pyOverride, data, action, row, column, parent);
}

bool TabModelWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("TabModel", funcName, gil, pyOverride, event);
}

bool TabModelWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("TabModel", funcName, gil, pyOverride, watched, event);
}

void TabModelWrapper::fetchMore(const ::QModelIndex & parent)
{
    static const char *funcName = "fetchMore";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::fetchMore(parent);
    }
    TabTreeModelWrapper::sbk_o_fetchMore("TabModel", funcName, gil, pyOverride, parent);
}

::QFlags<Qt::ItemFlag> TabModelWrapper::flags(const ::QModelIndex & index) const
{
    static const char *funcName = "flags";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabModel::flags(index);
    }
    return TabTreeModelWrapper::sbk_o_flags("TabModel", funcName, gil, pyOverride, index);
}

::QVariant TabModelWrapper::headerData(int section, ::Qt::Orientation orientation, int role) const
{
    static const char *funcName = "headerData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::headerData(section, orientation, role);
    }
    return TabTreeModelWrapper::sbk_o_headerData("TabModel", funcName, gil, pyOverride, section, orientation, role);
}

::QModelIndex TabModelWrapper::index(int row, int column, const ::QModelIndex & parent) const
{
    static const char *funcName = "index";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractListModel::index(row, column, parent);
    }
    return TabTreeModelWrapper::sbk_o_index("TabModel", funcName, gil, pyOverride, row, column, parent);
}

bool TabModelWrapper::insertColumns(int column, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "insertColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::insertColumns(column, count, parent);
    }
    return TabTreeModelWrapper::sbk_o_insertColumns("TabModel", funcName, gil, pyOverride, column, count, parent);
}

bool TabModelWrapper::insertRows(int row, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "insertRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::insertRows(row, count, parent);
    }
    return TabTreeModelWrapper::sbk_o_insertColumns("TabModel", funcName, gil, pyOverride, row, count, parent);
}

::QMap<int,QVariant> TabModelWrapper::itemData(const ::QModelIndex & index) const
{
    static const char *funcName = "itemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::itemData(index);
    }
    return TabTreeModelWrapper::sbk_o_itemData("TabModel", funcName, gil, pyOverride, index);
}

::QList<QModelIndex> TabModelWrapper::match(const ::QModelIndex & start, int role, const ::QVariant & value, int hits, ::QFlags<Qt::MatchFlag> flags) const
{
    static const char *funcName = "match";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::match(start, role, value, hits, flags);
    }
    return TabTreeModelWrapper::sbk_o_match("TabModel", funcName, gil, pyOverride, start, role, value, hits, flags);
}

::QMimeData * TabModelWrapper::mimeData(const ::QList<QModelIndex> & indexes) const
{
    static const char *funcName = "mimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabModel::mimeData(indexes);
    }
    return TabTreeModelWrapper::sbk_o_mimeData("TabModel", funcName, gil, pyOverride, indexes);
}

::QStringList TabModelWrapper::mimeTypes() const
{
    static const char *funcName = "mimeTypes";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabModel::mimeTypes();
    }
    return TabTreeModelWrapper::sbk_o_mimeTypes("TabModel", funcName, gil, pyOverride);
}

bool TabModelWrapper::moveColumns(const ::QModelIndex & sourceParent, int sourceColumn, int count, const ::QModelIndex & destinationParent, int destinationChild)
{
    static const char *funcName = "moveColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
    }
    return TabTreeModelWrapper::sbk_o_moveColumns("TabModel", funcName, gil, pyOverride, sourceParent, sourceColumn, count, destinationParent, destinationChild);
}

bool TabModelWrapper::moveRows(const ::QModelIndex & sourceParent, int sourceRow, int count, const ::QModelIndex & destinationParent, int destinationChild)
{
    static const char *funcName = "moveRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
    }
    return TabTreeModelWrapper::sbk_o_moveColumns("TabModel", funcName, gil, pyOverride, sourceParent, sourceRow, count, destinationParent, destinationChild);
}

void TabModelWrapper::multiData(const ::QModelIndex & index, ::QModelRoleDataSpan roleDataSpan) const
{
    static const char *funcName = "multiData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::multiData(index, roleDataSpan);
    }
    TabTreeModelWrapper::sbk_o_multiData("TabModel", funcName, gil, pyOverride, index, roleDataSpan);
}

bool TabModelWrapper::removeColumns(int column, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "removeColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::removeColumns(column, count, parent);
    }
    return TabTreeModelWrapper::sbk_o_insertColumns("TabModel", funcName, gil, pyOverride, column, count, parent);
}

bool TabModelWrapper::removeRows(int row, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "removeRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::removeRows(row, count, parent);
    }
    return TabTreeModelWrapper::sbk_o_insertColumns("TabModel", funcName, gil, pyOverride, row, count, parent);
}

void TabModelWrapper::resetInternalData()
{
    static const char *funcName = "resetInternalData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::resetInternalData();
    }
    WebViewWrapper::sbk_o_closeView("TabModel", funcName, gil, pyOverride);
}

void TabModelWrapper::revert()
{
    static const char *funcName = "revert";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::revert();
    }
    WebViewWrapper::sbk_o_closeView("TabModel", funcName, gil, pyOverride);
}

::QHash<int,QByteArray> TabModelWrapper::roleNames() const
{
    static const char *funcName = "roleNames";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::roleNames();
    }
    return TabTreeModelWrapper::sbk_o_roleNames("TabModel", funcName, gil, pyOverride);
}

int TabModelWrapper::rowCount(const ::QModelIndex & parent) const
{
    static const char *funcName = "rowCount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabModel::rowCount(parent);
    }
    return TabTreeModelWrapper::sbk_o_columnCount("TabModel", funcName, gil, pyOverride, parent);
}

bool TabModelWrapper::setData(const ::QModelIndex & index, const ::QVariant & value, int role)
{
    static const char *funcName = "setData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::setData(index, value, role);
    }
    return TabTreeModelWrapper::sbk_o_setData("TabModel", funcName, gil, pyOverride, index, value, role);
}

bool TabModelWrapper::setHeaderData(int section, ::Qt::Orientation orientation, const ::QVariant & value, int role)
{
    static const char *funcName = "setHeaderData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::setHeaderData(section, orientation, value, role);
    }
    return TabTreeModelWrapper::sbk_o_setHeaderData("TabModel", funcName, gil, pyOverride, section, orientation, value, role);
}

bool TabModelWrapper::setItemData(const ::QModelIndex & index, const ::QMap<int,QVariant> & roles)
{
    static const char *funcName = "setItemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::setItemData(index, roles);
    }
    return TabTreeModelWrapper::sbk_o_setItemData("TabModel", funcName, gil, pyOverride, index, roles);
}

::QModelIndex TabModelWrapper::sibling(int row, int column, const ::QModelIndex & idx) const
{
    static const char *funcName = "sibling";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractListModel::sibling(row, column, idx);
    }
    return TabTreeModelWrapper::sbk_o_index("TabModel", funcName, gil, pyOverride, row, column, idx);
}

void TabModelWrapper::sort(int column, ::Qt::SortOrder order)
{
    static const char *funcName = "sort";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::sort(column, order);
    }
    TabTreeModelWrapper::sbk_o_sort("TabModel", funcName, gil, pyOverride, column, order);
}

::QSize TabModelWrapper::span(const ::QModelIndex & index) const
{
    static const char *funcName = "span";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::span(index);
    }
    return TabTreeModelWrapper::sbk_o_span("TabModel", funcName, gil, pyOverride, index);
}

bool TabModelWrapper::submit()
{
    static const char *funcName = "submit";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::submit();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("TabModel", funcName, gil, pyOverride);
}

::QFlags<Qt::DropAction> TabModelWrapper::supportedDragActions() const
{
    static const char *funcName = "supportedDragActions";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::supportedDragActions();
    }
    return TabTreeModelWrapper::sbk_o_supportedDragActions("TabModel", funcName, gil, pyOverride);
}

::QFlags<Qt::DropAction> TabModelWrapper::supportedDropActions() const
{
    static const char *funcName = "supportedDropActions";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabModel::supportedDropActions();
    }
    return TabTreeModelWrapper::sbk_o_supportedDragActions("TabModel", funcName, gil, pyOverride);
}

void TabModelWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabModel_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("TabModel", funcName, gil, pyOverride, event);
}

const QMetaObject *TabModelWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return TabModel::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int TabModelWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = TabModel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *TabModelWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< TabModelWrapper *>(this));
    }
    return TabModel::qt_metacast(_clname);
}

TabModelWrapper::~TabModelWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_TabModel_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_TabModel_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::TabModel >()))
        return -1;

    TabModelWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:TabModel", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: TabModel::TabModel(BrowserWindow*,QObject*=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // TabModel(BrowserWindow*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
            overloadId = 0; // TabModel(BrowserWindow*,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::BrowserWindow *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QObject *cppArg1 = nullptr;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // TabModel(BrowserWindow*,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) TabModelWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new TabModelWrapper(cppArg0, cppArg1);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< TabModel >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);
    };


    return 1;
}

static PyObject *Sbk_TabModelFunc_canDropMimeData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabModelWrapper *>(reinterpret_cast< ::TabModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "canDropMimeData", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::canDropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)const->bool
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_DropAction_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[4])))) {
        overloadId = 0; // canDropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "canDropMimeData", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMimeData *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::DropAction cppArg1{Qt::IgnoreAction};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::QModelIndex cppArg4_local;
        ::QModelIndex *cppArg4 = &cppArg4_local;
        if (pythonToCpp[4].isValue())
            pythonToCpp[4](pyArgs[4], &cppArg4_local);
        else
            pythonToCpp[4](pyArgs[4], &cppArg4);


        if (Shiboken::Errors::occurred() == nullptr) {
            // canDropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const TabModelWrapper *>(cppSelf)->::TabModel::canDropMimeData(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4)
                : const_cast<const TabModelWrapper *>(cppSelf)->canDropMimeData(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabModelFunc_data(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabModelWrapper *>(reinterpret_cast< ::TabModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "data", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);

    if (PyArg_ParseTuple(args, "|OO:data", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::data(QModelIndex,int=)const->QVariant
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // data(QModelIndex,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // data(QModelIndex,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "data", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"role", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "data", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1 = Qt::DisplayRole;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // data(QModelIndex,int)const
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const TabModelWrapper *>(cppSelf)->::TabModel::data(*cppArg0, cppArg1)
                : const_cast<const TabModelWrapper *>(cppSelf)->data(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabModelFunc_dropMimeData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabModelWrapper *>(reinterpret_cast< ::TabModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "dropMimeData", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::dropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)->bool
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_DropAction_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[4])))) {
        overloadId = 0; // dropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "dropMimeData", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMimeData *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::DropAction cppArg1{Qt::IgnoreAction};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::QModelIndex cppArg4_local;
        ::QModelIndex *cppArg4 = &cppArg4_local;
        if (pythonToCpp[4].isValue())
            pythonToCpp[4](pyArgs[4], &cppArg4_local);
        else
            pythonToCpp[4](pyArgs[4], &cppArg4);


        if (Shiboken::Errors::occurred() == nullptr) {
            // dropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::TabModel::dropMimeData(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4)
                : cppSelf->dropMimeData(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabModelFunc_flags(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabModelWrapper *>(reinterpret_cast< ::TabModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::flags(QModelIndex)const->QFlags<Qt::ItemFlag>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // flags(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "flags", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // flags(QModelIndex)const
            QFlags<Qt::ItemFlag> cppResult = QFlags<Qt::ItemFlag>(Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const TabModelWrapper *>(cppSelf)->::TabModel::flags(*cppArg0)
                : const_cast<const TabModelWrapper *>(cppSelf)->flags(*cppArg0));
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_ItemFlag_IDX])))->flagsConverter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabModelFunc_mimeData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabModelWrapper *>(reinterpret_cast< ::TabModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::mimeData(QList<QModelIndex>)const->QMimeData*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QModelIndex_IDX], (pyArg)))) {
        overloadId = 0; // mimeData(QList<QModelIndex>)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mimeData", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);

    // Call function/method
    {
        ::QList<QModelIndex> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mimeData(QList<QModelIndex>)const
            QMimeData * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const TabModelWrapper *>(cppSelf)->::TabModel::mimeData(cppArg0)
                : const_cast<const TabModelWrapper *>(cppSelf)->mimeData(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabModelFunc_mimeTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabModelWrapper *>(reinterpret_cast< ::TabModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // mimeTypes()const
        QStringList cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const TabModelWrapper *>(cppSelf)->::TabModel::mimeTypes()
            : const_cast<const TabModelWrapper *>(cppSelf)->mimeTypes();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabModelFunc_rowCount(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabModelWrapper *>(reinterpret_cast< ::TabModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "rowCount", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);

    if (PyArg_ParseTuple(args, "|O:rowCount", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::rowCount(const QModelIndex&=)const->int
    if (numArgs == 0) {
        overloadId = 0; // rowCount(QModelIndex)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0])))) {
        overloadId = 0; // rowCount(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "rowCount", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "rowCount", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local = QModelIndex();
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }

        if (Shiboken::Errors::occurred() == nullptr) {
            // rowCount(QModelIndex)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const TabModelWrapper *>(cppSelf)->::TabModel::rowCount(*cppArg0)
                : const_cast<const TabModelWrapper *>(cppSelf)->rowCount(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabModelFunc_supportedDropActions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabModelWrapper *>(reinterpret_cast< ::TabModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // supportedDropActions()const
        QFlags<Qt::DropAction> cppResult = QFlags<Qt::DropAction>(Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const TabModelWrapper *>(cppSelf)->::TabModel::supportedDropActions()
            : const_cast<const TabModelWrapper *>(cppSelf)->supportedDropActions());
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_DropAction_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabModelFunc_tab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabModelWrapper *>(reinterpret_cast< ::TabModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabModel::tab(QModelIndex)const->WebTab*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // tab(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tab", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // tab(QModelIndex)const
            WebTab * cppResult = const_cast<const TabModelWrapper *>(cppSelf)->tab(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), cppResult);
            // Ownership transferences (return value heuristics).
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabModelFunc_tabIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabModelWrapper *>(reinterpret_cast< ::TabModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabModel::tabIndex(WebTab*)const->QModelIndex
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), (pyArg)))) {
        overloadId = 0; // tabIndex(WebTab*)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tabIndex", errInfo, SbkPyFalkonTypeStructs[SBK_TabModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::WebTab *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tabIndex(WebTab*)const
            QModelIndex cppResult = const_cast<const TabModelWrapper *>(cppSelf)->tabIndex(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_TabModel_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_TabModel_EnumFlagInfo[] = {
    "Roles:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_TabModel_methods[] = {
    {"canDropMimeData", reinterpret_cast<PyCFunction>(Sbk_TabModelFunc_canDropMimeData), METH_VARARGS, nullptr},
    {"data", reinterpret_cast<PyCFunction>(Sbk_TabModelFunc_data), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"dropMimeData", reinterpret_cast<PyCFunction>(Sbk_TabModelFunc_dropMimeData), METH_VARARGS, nullptr},
    {"flags", reinterpret_cast<PyCFunction>(Sbk_TabModelFunc_flags), METH_O, nullptr},
    {"mimeData", reinterpret_cast<PyCFunction>(Sbk_TabModelFunc_mimeData), METH_O, nullptr},
    {"mimeTypes", reinterpret_cast<PyCFunction>(Sbk_TabModelFunc_mimeTypes), METH_NOARGS, nullptr},
    {"rowCount", reinterpret_cast<PyCFunction>(Sbk_TabModelFunc_rowCount), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"supportedDropActions", reinterpret_cast<PyCFunction>(Sbk_TabModelFunc_supportedDropActions), METH_NOARGS, nullptr},
    {"tab", reinterpret_cast<PyCFunction>(Sbk_TabModelFunc_tab), METH_O, nullptr},
    {"tabIndex", reinterpret_cast<PyCFunction>(Sbk_TabModelFunc_tabIndex), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_TabModel_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::TabModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabModel_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<TabModelWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_TabModel_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_TabModel_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_TabModel_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_TabModel_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_TabModel_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_TabModel_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_TabModel_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_TabModel_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_TabModel_spec = {
    "1:PyFalkon.TabModel",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_TabModel_slots
};

} //extern "C"

static void *Sbk_TabModel_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::TabModel *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_TabModel_Roles(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::TabModel::Roles>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::TabModel::Roles *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_TabModel_Roles_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabModel_Roles_IDX])))
        return Enum_PythonToCpp_TabModel_Roles;
    return {};
}

static PyObject *TabModel_Roles_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::TabModel::Roles>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::TabModel::Roles *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void TabModel_PythonToCpp_TabModel_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_TabModel_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_TabModel_PythonToCpp_TabModel_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_TabModel_TypeF()))
        return TabModel_PythonToCpp_TabModel_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *TabModel_PTR_CppToPython_TabModel(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::TabModel *>(const_cast<void *>(cppIn)), Sbk_TabModel_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *TabModel_SignatureStrings[] = {
    "PyFalkon.TabModel(self,window:PyFalkon.BrowserWindow,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.TabModel.canDropMimeData(self,data:PySide6.QtCore.QMimeData,action:PySide6.QtCore.Qt.DropAction,row:int,column:int,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->bool",
    "PyFalkon.TabModel.data(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],role:int=Qt.DisplayRole)->QVariant",
    "PyFalkon.TabModel.dropMimeData(self,data:PySide6.QtCore.QMimeData,action:PySide6.QtCore.Qt.DropAction,row:int,column:int,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->bool",
    "PyFalkon.TabModel.flags(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->PySide6.QtCore.Qt.ItemFlag",
    "PyFalkon.TabModel.mimeData(self,indexes:QList[PySide6.QtCore.QModelIndex])->PySide6.QtCore.QMimeData",
    "PyFalkon.TabModel.mimeTypes(self)->QStringList",
    "PyFalkon.TabModel.rowCount(self,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]=QModelIndex())->int",
    "PyFalkon.TabModel.supportedDropActions(self)->PySide6.QtCore.Qt.DropAction",
    "PyFalkon.TabModel.tab(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->PyFalkon.WebTab",
    "PyFalkon.TabModel.tabIndex(self,tab:PyFalkon.WebTab)->PySide6.QtCore.QModelIndex",
    nullptr}; // Sentinel
#else
static constexpr size_t TabModel_SignatureByteSize = 341;
static constexpr uint8_t TabModel_SignatureBytes[341] = {
    0x78, 0xda, 0xdd, 0x52, 0x3b, 0x4f, 0xc3, 0x30, 0x10, 0xde, 0xfb, 0x2b, 0x18, 0x5b, 0x29, 0x64,
    0x64, 0x88, 0x54, 0x24, 0x68, 0x55, 0xa9, 0x12, 0x15, 0x09, 0x2d, 0x74, 0x40, 0x0c, 0x4e, 0x7c,
    0xad, 0x0c, 0x8e, 0x6d, 0xd9, 0x17, 0x95, 0xfc, 0x7b, 0xce, 0x49, 0x1f, 0x90, 0x98, 0x4e, 0x74,
    0x61, 0xb3, 0x7d, 0xe7, 0xef, 0x71, 0xdf, 0xa5, 0xf5, 0x8c, 0xc9, 0x0f, 0xad, 0xe2, 0x15, 0xcb,
    0x17, 0x9a, 0x83, 0x1c, 0x3a, 0x90, 0x9b, 0x68, 0x27, 0x14, 0xd7, 0xbb, 0x24, 0x3d, 0x54, 0xef,
    0xad, 0xde, 0x39, 0xb0, 0xeb, 0xe6, 0x39, 0x32, 0xcc, 0x82, 0x42, 0xaa, 0x2e, 0x05, 0x87, 0x9b,
    0x38, 0xc3, 0x89, 0xb6, 0x10, 0x67, 0x8f, 0xf9, 0x3b, 0x14, 0x38, 0x56, 0x95, 0x94, 0x06, 0xed,
    0x68, 0x90, 0x76, 0xb1, 0xe3, 0x82, 0xa9, 0xa9, 0xd5, 0x66, 0x21, 0x4a, 0x98, 0x32, 0x64, 0x2d,
    0x17, 0xa7, 0x53, 0x0f, 0xeb, 0xd0, 0x12, 0xb1, 0x02, 0x85, 0x56, 0xbd, 0x3a, 0xc6, 0x1e, 0xe8,
    0xae, 0x29, 0x46, 0x24, 0x2e, 0x11, 0x0a, 0xa3, 0x42, 0xcb, 0xaa, 0x54, 0xcd, 0x71, 0x2f, 0x11,
    0x6b, 0x23, 0xd4, 0x36, 0x7e, 0x56, 0xd4, 0xf6, 0xda, 0xe3, 0xf0, 0x9a, 0xe6, 0x8a, 0xc3, 0x67,
    0x74, 0xd5, 0xad, 0xa5, 0x60, 0x9d, 0x70, 0x48, 0x18, 0xa7, 0xae, 0xb7, 0xd1, 0xf5, 0x6d, 0xae,
    0xb5, 0x0c, 0x18, 0xe3, 0x47, 0x37, 0xc2, 0x77, 0xfe, 0x31, 0x2f, 0x19, 0x94, 0xe0, 0x6d, 0x8d,
    0xbd, 0x6f, 0xe1, 0x8c, 0x64, 0xf5, 0x13, 0x3d, 0x91, 0x9e, 0xec, 0x85, 0x59, 0xc1, 0x14, 0x86,
    0x34, 0xfd, 0xcb, 0x49, 0x6f, 0x24, 0xdb, 0xba, 0xcb, 0x8d, 0x9a, 0x88, 0xfb, 0x03, 0x98, 0x23,
    0x94, 0x33, 0xe2, 0x0d, 0xc8, 0x29, 0x7f, 0x0c, 0xb8, 0x51, 0x04, 0x2e, 0xc9, 0x1e, 0x08, 0xf8,
    0x8c, 0x98, 0x10, 0xcd, 0x21, 0x87, 0x5f, 0x48, 0x56, 0xb5, 0x81, 0xd6, 0xb7, 0x4f, 0x7d, 0x89,
    0x96, 0x4c, 0x7b, 0x96, 0x40, 0x3b, 0x85, 0x34, 0xd1, 0x95, 0xc2, 0x56, 0xd3, 0x45, 0xf2, 0x19,
    0x7f, 0xfb, 0x32, 0x1c, 0x91, 0x22, 0x11, 0x5c, 0x41, 0x57, 0x19, 0xa3, 0x2d, 0x02, 0x3f, 0xad,
    0xd0, 0xd1, 0xc3, 0xb9, 0x3d, 0x0b, 0x40, 0x21, 0xcb, 0x2f, 0x9c, 0xfa, 0x9e, 0x71, 0x0d, 0x39,
    0x91, 0x86, 0x15, 0xb4, 0x7e, 0x1b, 0x19, 0x74, 0x4b, 0x3a, 0x7f, 0x42, 0xa1, 0x1e, 0x39, 0x06,
    0x5f, 0xe0, 0x29, 0xf6, 0xf3
};
#endif

PyTypeObject *init_TabModel(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_TabModel_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_TabModel_IDX].type;

    Shiboken::AutoDecRef Sbk_TabModel_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QAbstractListModel_IDX]))));

    _Sbk_TabModel_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "TabModel",
        "TabModel*",
        &Sbk_TabModel_spec,
        &Shiboken::callCppDestructor< TabModel >,
        Sbk_TabModel_Type_bases.object(),
        0);
    auto *pyType = Sbk_TabModel_TypeF(); // references _Sbk_TabModel_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, TabModel_SignatureStrings);
#else
    InitSignatureBytes(pyType, TabModel_SignatureBytes, TabModel_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_TabModel_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_TabModel_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        TabModel_PythonToCpp_TabModel_PTR,
        is_TabModel_PythonToCpp_TabModel_PTR_Convertible,
        TabModel_PTR_CppToPython_TabModel);

    Shiboken::Conversions::registerConverterName(converter, "TabModel");
    Shiboken::Conversions::registerConverterName(converter, "TabModel*");
    Shiboken::Conversions::registerConverterName(converter, "TabModel&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::TabModel).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(TabModelWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_TabModel_TypeF(), &Sbk_TabModel_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_TabModel_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Roles'.
    const char *Roles_Initializer[] = {
        "WebTabRole",
        "TitleRole",
        "IconRole",
        "PinnedRole",
        "RestoredRole",
        "CurrentTabRole",
        "LoadingRole",
        "AudioPlayingRole",
        "AudioMutedRole",
        "BackgroundActivityRole",
        nullptr};
    // "uint16_t" used instead of "unsigned int"
    constexpr uint16_t Roles_InitializerValues[] = {
        uint16_t(TabModel::Roles::WebTabRole),            //  0x0101  257
        uint16_t(TabModel::Roles::TitleRole),             //  0x0102  258
        uint16_t(TabModel::Roles::IconRole),              //  0x0103  259
        uint16_t(TabModel::Roles::PinnedRole),            //  0x0104  260
        uint16_t(TabModel::Roles::RestoredRole),          //  0x0105  261
        uint16_t(TabModel::Roles::CurrentTabRole),        //  0x0106  262
        uint16_t(TabModel::Roles::LoadingRole),           //  0x0107  263
        uint16_t(TabModel::Roles::AudioPlayingRole),      //  0x0108  264
        uint16_t(TabModel::Roles::AudioMutedRole),        //  0x0109  265
        uint16_t(TabModel::Roles::BackgroundActivityRole) //  0x010a  266
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_TabModel_TypeF(),
        "1:PyFalkon.TabModel.Roles",
        Roles_Initializer, Roles_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_TabModel_Roles_IDX].type = EType;
    // Register converter for enum 'TabModel::Roles'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            TabModel_Roles_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_TabModel_Roles,
            is_Enum_PythonToCpp_TabModel_Roles_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "TabModel::Roles");
        Shiboken::Conversions::registerConverterAlias(converter, "Roles");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Roles' enum.

    TabModelWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::TabModel::staticMetaObject, sizeof(TabModelWrapper));

    return pyType;
}
