
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "delayedfilewatcher_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_DelayedFileWatcher_Type = nullptr;
static PyTypeObject *Sbk_DelayedFileWatcher_TypeF(void)
{
    return _Sbk_DelayedFileWatcher_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void DelayedFileWatcherWrapper::pysideInitQtMetaTypes()
{
}

void DelayedFileWatcherWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

DelayedFileWatcherWrapper::DelayedFileWatcherWrapper(::QObject * parent) : DelayedFileWatcher(parent)
{
}

DelayedFileWatcherWrapper::DelayedFileWatcherWrapper(const ::QStringList & paths, ::QObject * parent) : DelayedFileWatcher(paths, parent)
{
}

void DelayedFileWatcherWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DelayedFileWatcher_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("DelayedFileWatcher", funcName, gil, pyOverride, event);
}

void DelayedFileWatcherWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DelayedFileWatcher_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("DelayedFileWatcher", funcName, gil, pyOverride, signal);
}

void DelayedFileWatcherWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DelayedFileWatcher_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("DelayedFileWatcher", funcName, gil, pyOverride, event);
}

void DelayedFileWatcherWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DelayedFileWatcher_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("DelayedFileWatcher", funcName, gil, pyOverride, signal);
}

bool DelayedFileWatcherWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DelayedFileWatcher_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("DelayedFileWatcher", funcName, gil, pyOverride, event);
}

bool DelayedFileWatcherWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DelayedFileWatcher_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("DelayedFileWatcher", funcName, gil, pyOverride, watched, event);
}

void DelayedFileWatcherWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DelayedFileWatcher_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("DelayedFileWatcher", funcName, gil, pyOverride, event);
}

const QMetaObject *DelayedFileWatcherWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return DelayedFileWatcher::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int DelayedFileWatcherWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = DelayedFileWatcher::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *DelayedFileWatcherWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< DelayedFileWatcherWrapper *>(this));
    }
    return DelayedFileWatcher::qt_metacast(_clname);
}

DelayedFileWatcherWrapper::~DelayedFileWatcherWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_DelayedFileWatcher_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_DelayedFileWatcher_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::DelayedFileWatcher >()))
        return -1;

    DelayedFileWatcherWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:DelayedFileWatcher", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: DelayedFileWatcher::DelayedFileWatcher(QObject*=)
    // 1: DelayedFileWatcher::DelayedFileWatcher(QStringList,QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // DelayedFileWatcher(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // DelayedFileWatcher(QStringList,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
            overloadId = 1; // DelayedFileWatcher(QStringList,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // DelayedFileWatcher(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DelayedFileWatcher_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_DelayedFileWatcher_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // DelayedFileWatcher(QObject *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DelayedFileWatcher_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // DelayedFileWatcher(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) DelayedFileWatcherWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new DelayedFileWatcherWrapper(cppArg0);
                }

                // Ownership transferences (constructor heuristics).
                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // DelayedFileWatcher(const QStringList &paths, QObject *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DelayedFileWatcher_IDX]);
                }
            }
            ::QStringList cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // DelayedFileWatcher(QStringList,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) DelayedFileWatcherWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new DelayedFileWatcherWrapper(cppArg0, cppArg1);
                }

                // Ownership transferences (constructor heuristics).
                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< DelayedFileWatcher >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DelayedFileWatcher_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DelayedFileWatcher_IDX]);
    };


    return 1;
}


static const char *Sbk_DelayedFileWatcher_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_DelayedFileWatcher_methods[] = {
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_DelayedFileWatcher_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::DelayedFileWatcher *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DelayedFileWatcher_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<DelayedFileWatcherWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_DelayedFileWatcher_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_DelayedFileWatcher_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_DelayedFileWatcher_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_DelayedFileWatcher_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_DelayedFileWatcher_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_DelayedFileWatcher_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_DelayedFileWatcher_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_DelayedFileWatcher_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_DelayedFileWatcher_spec = {
    "1:PyFalkon.DelayedFileWatcher",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_DelayedFileWatcher_slots
};

} //extern "C"

static void *Sbk_DelayedFileWatcher_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::DelayedFileWatcher *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void DelayedFileWatcher_PythonToCpp_DelayedFileWatcher_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_DelayedFileWatcher_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_DelayedFileWatcher_PythonToCpp_DelayedFileWatcher_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_DelayedFileWatcher_TypeF()))
        return DelayedFileWatcher_PythonToCpp_DelayedFileWatcher_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *DelayedFileWatcher_PTR_CppToPython_DelayedFileWatcher(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::DelayedFileWatcher *>(const_cast<void *>(cppIn)), Sbk_DelayedFileWatcher_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *DelayedFileWatcher_SignatureStrings[] = {
    "1:PyFalkon.DelayedFileWatcher(self,parent:PySide6.QtCore.QObject=nullptr)",
    "0:PyFalkon.DelayedFileWatcher(self,paths:QStringList,parent:PySide6.QtCore.QObject=nullptr)",
    nullptr}; // Sentinel
#else
static constexpr size_t DelayedFileWatcher_SignatureByteSize = 102;
static constexpr uint8_t DelayedFileWatcher_SignatureBytes[102] = {
    0x78, 0xda, 0x33, 0xb4, 0x0a, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x73, 0x49, 0xcd,
    0x49, 0xac, 0x4c, 0x4d, 0x71, 0xcb, 0xcc, 0x49, 0x0d, 0x4f, 0x2c, 0x49, 0xce, 0x48, 0x2d, 0xd2,
    0x28, 0x4e, 0xcd, 0x49, 0xd3, 0x29, 0x48, 0x2c, 0x4a, 0xcd, 0x2b, 0x01, 0xaa, 0x0b, 0xce, 0x4c,
    0x49, 0x35, 0xd3, 0x0b, 0x2c, 0x71, 0xce, 0x2f, 0x4a, 0xd5, 0x0b, 0xf4, 0x4f, 0xca, 0x4a, 0x4d,
    0x2e, 0xb1, 0xcd, 0x2b, 0xcd, 0xc9, 0x29, 0x28, 0x29, 0xd2, 0xe4, 0x32, 0x20, 0xc6, 0xa4, 0x92,
    0x8c, 0x62, 0xab, 0xc0, 0xe0, 0x92, 0xa2, 0xcc, 0xbc, 0x74, 0x9f, 0xcc, 0xe2, 0x12, 0x62, 0xcd,
    0x06, 0x00, 0xc4, 0xb2, 0x3c, 0xa2
};
#endif

PyTypeObject *init_DelayedFileWatcher(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_DelayedFileWatcher_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_DelayedFileWatcher_IDX].type;

    Shiboken::AutoDecRef Sbk_DelayedFileWatcher_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFileSystemWatcher_IDX]))));

    _Sbk_DelayedFileWatcher_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "DelayedFileWatcher",
        "DelayedFileWatcher*",
        &Sbk_DelayedFileWatcher_spec,
        &Shiboken::callCppDestructor< DelayedFileWatcher >,
        Sbk_DelayedFileWatcher_Type_bases.object(),
        0);
    auto *pyType = Sbk_DelayedFileWatcher_TypeF(); // references _Sbk_DelayedFileWatcher_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, DelayedFileWatcher_SignatureStrings);
#else
    InitSignatureBytes(pyType, DelayedFileWatcher_SignatureBytes, DelayedFileWatcher_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_DelayedFileWatcher_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_DelayedFileWatcher_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        DelayedFileWatcher_PythonToCpp_DelayedFileWatcher_PTR,
        is_DelayedFileWatcher_PythonToCpp_DelayedFileWatcher_PTR_Convertible,
        DelayedFileWatcher_PTR_CppToPython_DelayedFileWatcher);

    Shiboken::Conversions::registerConverterName(converter, "DelayedFileWatcher");
    Shiboken::Conversions::registerConverterName(converter, "DelayedFileWatcher*");
    Shiboken::Conversions::registerConverterName(converter, "DelayedFileWatcher&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::DelayedFileWatcher).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(DelayedFileWatcherWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_DelayedFileWatcher_TypeF(), &Sbk_DelayedFileWatcher_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::DelayedFileWatcher::staticMetaObject);
    DelayedFileWatcherWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::DelayedFileWatcher::staticMetaObject, sizeof(DelayedFileWatcherWrapper));

    return pyType;
}
