/* ResticInstance.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ResticInstance.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include "deja.h"

#define RESTIC_INSTANCE_ERROR_OUT_OF_SPACE -1
#define RESTIC_INSTANCE_ERROR_GENERIC 1
#define RESTIC_INSTANCE_ERROR_GO_RUNTIME 2
#define RESTIC_INSTANCE_ERROR_INVALID_SOURCE_DATA 3
#define RESTIC_INSTANCE_ERROR_NO_REPOSITORY 10
#define RESTIC_INSTANCE_ERROR_ALREADY_LOCKED 11
#define RESTIC_INSTANCE_ERROR_BAD_PASSWORD 12
#define RESTIC_INSTANCE_ERROR_CANCELED 130
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_TOOL_INSTANCE (tool_instance_get_type ())
#define TOOL_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOOL_INSTANCE, ToolInstance))
#define TOOL_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOOL_INSTANCE, ToolInstanceClass))
#define IS_TOOL_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOOL_INSTANCE))
#define IS_TOOL_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOOL_INSTANCE))
#define TOOL_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOOL_INSTANCE, ToolInstanceClass))

typedef struct _ToolInstance ToolInstance;
typedef struct _ToolInstanceClass ToolInstanceClass;
typedef struct _ToolInstancePrivate ToolInstancePrivate;

#define TYPE_RESTIC_INSTANCE (restic_instance_get_type ())
#define RESTIC_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESTIC_INSTANCE, ResticInstance))
#define RESTIC_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RESTIC_INSTANCE, ResticInstanceClass))
#define IS_RESTIC_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESTIC_INSTANCE))
#define IS_RESTIC_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RESTIC_INSTANCE))
#define RESTIC_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RESTIC_INSTANCE, ResticInstanceClass))

typedef struct _ResticInstance ResticInstance;
typedef struct _ResticInstanceClass ResticInstanceClass;
typedef struct _ResticInstancePrivate ResticInstancePrivate;
enum  {
	RESTIC_INSTANCE_0_PROPERTY,
	RESTIC_INSTANCE_NUM_PROPERTIES
};
static GParamSpec* restic_instance_properties[RESTIC_INSTANCE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
enum  {
	RESTIC_INSTANCE_MESSAGE_SIGNAL,
	RESTIC_INSTANCE_FATAL_ERROR_SIGNAL,
	RESTIC_INSTANCE_NUM_SIGNALS
};
static guint restic_instance_signals[RESTIC_INSTANCE_NUM_SIGNALS] = {0};

struct _ToolInstance {
	GObject parent_instance;
	ToolInstancePrivate * priv;
};

struct _ToolInstanceClass {
	GObjectClass parent_class;
	gchar* (*_name) (ToolInstance* self);
	void (*_send_error) (ToolInstance* self, GError* e);
	gboolean (*_process_line) (ToolInstance* self, const gchar* stanza, const gchar* line, gboolean* loggable, GError** error);
	void (*_edit_envp) (ToolInstance* self, GList* envp);
};

struct _ResticInstance {
	ToolInstance parent_instance;
	ResticInstancePrivate * priv;
};

struct _ResticInstanceClass {
	ToolInstanceClass parent_class;
};

struct _ResticInstancePrivate {
	gchar* stray_fatal_message;
	gchar* stray_message;
	gboolean had_per_item_errors;
	gboolean had_exit_error;
};

static gint ResticInstance_private_offset;
static gpointer restic_instance_parent_class = NULL;

VALA_EXTERN GType tool_instance_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType restic_instance_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* _tool_instance_name (ToolInstance* self);
VALA_EXTERN void _tool_instance_send_error (ToolInstance* self,
                                GError* e);
VALA_EXTERN void _tool_instance_edit_envp (ToolInstance* self,
                               GList* envp);
VALA_EXTERN gboolean _tool_instance_process_line (ToolInstance* self,
                                      const gchar* stanza,
                                      const gchar* line,
                                      gboolean* loggable,
                                      GError** error);
static gchar* restic_instance_real__name (ToolInstance* base);
static void restic_instance_real__send_error (ToolInstance* base,
                                       GError* e);
static void restic_instance_real__edit_envp (ToolInstance* base,
                                      GList* envp);
static gboolean restic_instance_real__process_line (ToolInstance* base,
                                             const gchar* stanza,
                                             const gchar* line,
                                             gboolean* loggable,
                                             GError** error);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void restic_instance_handle_exit_error (ResticInstance* self,
                                        JsonReader* reader);
static void _vala_JsonNode_free (JsonNode* self);
static void restic_instance_process_exit_error (ResticInstance* self,
                                         gint code,
                                         const gchar* message);
static void restic_instance_handle_exit (ResticInstance* self,
                                  gint code);
VALA_EXTERN ResticInstance* restic_instance_new (void);
VALA_EXTERN ResticInstance* restic_instance_construct (GType object_type);
VALA_EXTERN ToolInstance* tool_instance_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static GObject * restic_instance_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _restic_instance_handle_exit_tool_instance_exited (ToolInstance* _sender,
                                                        gint code,
                                                        gpointer self);
static void restic_instance_finalize (GObject * obj);
static GType restic_instance_get_type_once (void);

static inline gpointer
restic_instance_get_instance_private (ResticInstance* self)
{
	return G_STRUCT_MEMBER_P (self, ResticInstance_private_offset);
}

static gchar*
restic_instance_real__name (ToolInstance* base)
{
	ResticInstance * self;
	gchar* _tmp0_;
	gchar* result;
	self = (ResticInstance*) base;
	_tmp0_ = g_strdup ("restic");
	result = _tmp0_;
	return result;
}

static void
restic_instance_real__send_error (ToolInstance* base,
                                  GError* e)
{
	ResticInstance * self;
	const gchar* _tmp0_;
	self = (ResticInstance*) base;
	g_return_if_fail (e != NULL);
	_tmp0_ = e->message;
	g_signal_emit (self, restic_instance_signals[RESTIC_INSTANCE_FATAL_ERROR_SIGNAL], 0, RESTIC_INSTANCE_ERROR_GENERIC, _tmp0_);
}

static void
restic_instance_real__edit_envp (ToolInstance* base,
                                 GList* envp)
{
	ResticInstance * self;
	gchar* new_path = NULL;
	gchar* _tmp0_;
	gchar* cur_path = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	self = (ResticInstance*) base;
	_tmp0_ = g_strdup (PKG_LIBEXEC_DIR);
	new_path = _tmp0_;
	_tmp1_ = g_getenv ("PATH");
	_tmp2_ = g_strdup (_tmp1_);
	cur_path = _tmp2_;
	_tmp4_ = cur_path;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = cur_path;
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = new_path;
		_tmp7_ = cur_path;
		_tmp8_ = g_strconcat (":", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp6_, _tmp9_, NULL);
		_g_free0 (new_path);
		new_path = _tmp10_;
		_g_free0 (_tmp9_);
	}
	_tmp11_ = new_path;
	_tmp12_ = g_strconcat ("PATH=", _tmp11_, NULL);
	envp = g_list_append (envp, _tmp12_);
	_g_free0 (cur_path);
	_g_free0 (new_path);
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static gboolean
restic_instance_real__process_line (ToolInstance* base,
                                    const gchar* stanza,
                                    const gchar* line,
                                    gboolean* loggable,
                                    GError** error)
{
	ResticInstance * self;
	gboolean _vala_loggable = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean is_stanza = FALSE;
	JsonParser* parser = NULL;
	JsonParser* _tmp5_;
	JsonParser* _tmp6_;
	JsonNode* root = NULL;
	JsonParser* _tmp8_;
	JsonNode* _tmp9_;
	JsonNode* _tmp10_;
	JsonReader* reader = NULL;
	JsonNode* _tmp11_;
	JsonReader* _tmp12_;
	gchar* msgid = NULL;
	JsonReader* _tmp13_;
	JsonReader* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ResticInstance*) base;
	g_return_val_if_fail (stanza != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_vala_loggable = TRUE;
	if (g_str_has_prefix (line, "{")) {
		_tmp1_ = g_str_has_suffix (line, "}");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (g_str_has_prefix (line, "[")) {
			_tmp2_ = g_str_has_suffix (line, "]");
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	is_stanza = _tmp0_;
	if (!is_stanza) {
		if (g_str_has_prefix (line, "Fatal: ")) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup (line);
			_g_free0 (self->priv->stray_fatal_message);
			self->priv->stray_fatal_message = _tmp3_;
		} else {
			gchar* _tmp4_;
			_tmp4_ = g_strdup (line);
			_g_free0 (self->priv->stray_message);
			self->priv->stray_message = _tmp4_;
		}
		result = TRUE;
		if (loggable) {
			*loggable = _vala_loggable;
		}
		return result;
	}
	_tmp5_ = json_parser_new_immutable ();
	parser = _tmp5_;
	_tmp6_ = parser;
	json_parser_load_from_data (_tmp6_, line, (gssize) -1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (parser);
		return _tmp7_;
	}
	_tmp8_ = parser;
	_tmp9_ = json_parser_get_root (_tmp8_);
	_tmp10_ = __vala_JsonNode_copy0 (_tmp9_);
	root = _tmp10_;
	_tmp11_ = root;
	_tmp12_ = json_reader_new (_tmp11_);
	reader = _tmp12_;
	msgid = NULL;
	_tmp13_ = reader;
	if (json_reader_read_member (_tmp13_, "message_type")) {
		JsonReader* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = reader;
		_tmp15_ = json_reader_get_string_value (_tmp14_);
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (msgid);
		msgid = _tmp16_;
	}
	_tmp17_ = reader;
	json_reader_end_member (_tmp17_);
	_tmp18_ = msgid;
	if (g_strcmp0 (_tmp18_, "status") == 0) {
		_vala_loggable = FALSE;
	}
	_tmp19_ = msgid;
	if (g_strcmp0 (_tmp19_, "error") == 0) {
		self->priv->had_per_item_errors = TRUE;
	}
	_tmp20_ = msgid;
	if (g_strcmp0 (_tmp20_, "exit_error") == 0) {
		JsonReader* _tmp21_;
		_tmp21_ = reader;
		restic_instance_handle_exit_error (self, _tmp21_);
	} else {
		const gchar* _tmp22_;
		JsonReader* _tmp23_;
		_tmp22_ = msgid;
		_tmp23_ = reader;
		g_signal_emit (self, restic_instance_signals[RESTIC_INSTANCE_MESSAGE_SIGNAL], 0, _tmp22_, _tmp23_);
	}
	result = TRUE;
	_g_free0 (msgid);
	_g_object_unref0 (reader);
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (parser);
	if (loggable) {
		*loggable = _vala_loggable;
	}
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
restic_instance_process_exit_error (ResticInstance* self,
                                    gint code,
                                    const gchar* message)
{
	gboolean _tmp0_ = FALSE;
	gchar* user_message = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	self->priv->had_exit_error = TRUE;
	if (code == RESTIC_INSTANCE_ERROR_INVALID_SOURCE_DATA) {
		return;
	}
	if (code == RESTIC_INSTANCE_ERROR_GENERIC) {
		_tmp0_ = self->priv->had_per_item_errors;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	if (g_str_has_suffix (message, ": no space left on device")) {
		code = RESTIC_INSTANCE_ERROR_OUT_OF_SPACE;
	}
	_tmp1_ = g_strdup (message);
	user_message = _tmp1_;
	_tmp2_ = user_message;
	if (g_str_has_prefix (_tmp2_, "Fatal: ")) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = user_message;
		_tmp4_ = string_substring (_tmp3_, (glong) 7, (glong) -1);
		_g_free0 (user_message);
		user_message = _tmp4_;
	}
	_tmp5_ = user_message;
	g_signal_emit (self, restic_instance_signals[RESTIC_INSTANCE_FATAL_ERROR_SIGNAL], 0, code, _tmp5_);
	_g_free0 (user_message);
}

static void
restic_instance_handle_exit_error (ResticInstance* self,
                                   JsonReader* reader)
{
	gint32 code = 0;
	gchar* message = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (reader != NULL);
	json_reader_read_member (reader, "code");
	code = (gint32) json_reader_get_int_value (reader);
	json_reader_end_member (reader);
	json_reader_read_member (reader, "message");
	_tmp0_ = json_reader_get_string_value (reader);
	_tmp1_ = g_strdup (_tmp0_);
	message = _tmp1_;
	_tmp2_ = message;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (message);
		message = _tmp3_;
	}
	json_reader_end_member (reader);
	_tmp4_ = message;
	restic_instance_process_exit_error (self, (gint) code, _tmp4_);
	_g_free0 (message);
}

static void
restic_instance_handle_exit (ResticInstance* self,
                             gint code)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (code == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->had_exit_error;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->stray_fatal_message;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->stray_fatal_message;
		restic_instance_process_exit_error (self, code, _tmp2_);
	} else {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->stray_message;
		if (_tmp3_ != NULL) {
			const gchar* _tmp4_;
			_tmp4_ = self->priv->stray_message;
			restic_instance_process_exit_error (self, code, _tmp4_);
		} else {
			restic_instance_process_exit_error (self, code, _ ("Failed with an unknown error."));
		}
	}
}

ResticInstance*
restic_instance_construct (GType object_type)
{
	ResticInstance * self = NULL;
	self = (ResticInstance*) tool_instance_construct (object_type);
	return self;
}

ResticInstance*
restic_instance_new (void)
{
	return restic_instance_construct (TYPE_RESTIC_INSTANCE);
}

static void
g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_OBJECT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
_restic_instance_handle_exit_tool_instance_exited (ToolInstance* _sender,
                                                   gint code,
                                                   gpointer self)
{
	restic_instance_handle_exit ((ResticInstance*) self, code);
}

static GObject *
restic_instance_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ResticInstance * self;
	parent_class = G_OBJECT_CLASS (restic_instance_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RESTIC_INSTANCE, ResticInstance);
	g_signal_connect_object ((ToolInstance*) self, "exited", (GCallback) _restic_instance_handle_exit_tool_instance_exited, self, 0);
	return obj;
}

static void
restic_instance_class_init (ResticInstanceClass * klass,
                            gpointer klass_data)
{
	restic_instance_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ResticInstance_private_offset);
	((ToolInstanceClass *) klass)->_name = (gchar* (*) (ToolInstance*)) restic_instance_real__name;
	((ToolInstanceClass *) klass)->_send_error = (void (*) (ToolInstance*, GError*)) restic_instance_real__send_error;
	((ToolInstanceClass *) klass)->_edit_envp = (void (*) (ToolInstance*, GList*)) restic_instance_real__edit_envp;
	((ToolInstanceClass *) klass)->_process_line = (gboolean (*) (ToolInstance*, const gchar*, const gchar*, gboolean*, GError**)) restic_instance_real__process_line;
	G_OBJECT_CLASS (klass)->constructor = restic_instance_constructor;
	G_OBJECT_CLASS (klass)->finalize = restic_instance_finalize;
	restic_instance_signals[RESTIC_INSTANCE_MESSAGE_SIGNAL] = g_signal_new ("message", TYPE_RESTIC_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, json_reader_get_type ());
	restic_instance_signals[RESTIC_INSTANCE_FATAL_ERROR_SIGNAL] = g_signal_new ("fatal-error", TYPE_RESTIC_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_STRING, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_STRING);
}

static void
restic_instance_instance_init (ResticInstance * self,
                               gpointer klass)
{
	self->priv = restic_instance_get_instance_private (self);
	self->priv->stray_fatal_message = NULL;
	self->priv->stray_message = NULL;
	self->priv->had_per_item_errors = FALSE;
	self->priv->had_exit_error = FALSE;
}

static void
restic_instance_finalize (GObject * obj)
{
	ResticInstance * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RESTIC_INSTANCE, ResticInstance);
	_g_free0 (self->priv->stray_fatal_message);
	_g_free0 (self->priv->stray_message);
	G_OBJECT_CLASS (restic_instance_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
restic_instance_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ResticInstanceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) restic_instance_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ResticInstance), 0, (GInstanceInitFunc) restic_instance_instance_init, NULL };
	GType restic_instance_type_id;
	restic_instance_type_id = g_type_register_static (TYPE_TOOL_INSTANCE, "ResticInstance", &g_define_type_info, 0);
	ResticInstance_private_offset = g_type_add_instance_private (restic_instance_type_id, sizeof (ResticInstancePrivate));
	return restic_instance_type_id;
}

GType
restic_instance_get_type (void)
{
	static gsize restic_instance_type_id__once = 0;
	if (g_once_init_enter (&restic_instance_type_id__once)) {
		GType restic_instance_type_id;
		restic_instance_type_id = restic_instance_get_type_once ();
		g_once_init_leave (&restic_instance_type_id__once, restic_instance_type_id);
	}
	return restic_instance_type_id__once;
}

