/*
 * // Copyright (c) Radzivon Bartoshyk 6/2025. All rights reserved.
 * //
 * // Redistribution and use in source and binary forms, with or without modification,
 * // are permitted provided that the following conditions are met:
 * //
 * // 1.  Redistributions of source code must retain the above copyright notice, this
 * // list of conditions and the following disclaimer.
 * //
 * // 2.  Redistributions in binary form must reproduce the above copyright notice,
 * // this list of conditions and the following disclaimer in the documentation
 * // and/or other materials provided with the distribution.
 * //
 * // 3.  Neither the name of the copyright holder nor the names of its
 * // contributors may be used to endorse or promote products derived from
 * // this software without specific prior written permission.
 * //
 * // THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * // AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * // IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * // DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * // FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * // DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * // SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * // CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * // OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * // OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

pub(crate) static LOG2P1_EXACT: [u64; 53] = [
    0x3ff0000000000000,
    0x4008000000000000,
    0x401c000000000000,
    0x402e000000000000,
    0x403f000000000000,
    0x404f800000000000,
    0x405fc00000000000,
    0x406fe00000000000,
    0x407ff00000000000,
    0x408ff80000000000,
    0x409ffc0000000000,
    0x40affe0000000000,
    0x40bfff0000000000,
    0x40cfff8000000000,
    0x40dfffc000000000,
    0x40efffe000000000,
    0x40fffff000000000,
    0x410ffff800000000,
    0x411ffffc00000000,
    0x412ffffe00000000,
    0x413fffff00000000,
    0x414fffff80000000,
    0x415fffffc0000000,
    0x416fffffe0000000,
    0x417ffffff0000000,
    0x418ffffff8000000,
    0x419ffffffc000000,
    0x41affffffe000000,
    0x41bfffffff000000,
    0x41cfffffff800000,
    0x41dfffffffc00000,
    0x41efffffffe00000,
    0x41fffffffff00000,
    0x420ffffffff80000,
    0x421ffffffffc0000,
    0x422ffffffffe0000,
    0x423fffffffff0000,
    0x424fffffffff8000,
    0x425fffffffffc000,
    0x426fffffffffe000,
    0x427ffffffffff000,
    0x428ffffffffff800,
    0x429ffffffffffc00,
    0x42affffffffffe00,
    0x42bfffffffffff00,
    0x42cfffffffffff80,
    0x42dfffffffffffc0,
    0x42efffffffffffe0,
    0x42fffffffffffff0,
    0x430ffffffffffff8,
    0x431ffffffffffffc,
    0x432ffffffffffffe,
    0x433fffffffffffff,
];

/* For 362 <= i <= 724, r[i] = LOG2P1_INVERSE[i-362] is a 10-bit approximation of
1/x[i], where i*2^-9 <= x[i] < (i+1)*2^-9.
More precisely r[i] is a 10-bit value such that r[i]*y-1 is representable
exactly on 53 bits for any y, i*2^-9 <= y < (i+1)*2^-9.
Moreover |r[i]*y-1| <= 0.00212097167968735. */

pub(crate) static LOG2P1_INVERSE: [u64; 363] = [
    0x3ff6980000000000,
    0x3ff6880000000000,
    0x3ff6780000000000,
    0x3ff6680000000000,
    0x3ff6580000000000,
    0x3ff6480000000000,
    0x3ff6380000000000,
    0x3ff6300000000000,
    0x3ff6200000000000,
    0x3ff6100000000000,
    0x3ff6000000000000,
    0x3ff5f00000000000,
    0x3ff5e00000000000,
    0x3ff5d00000000000,
    0x3ff5c00000000000,
    0x3ff5b00000000000,
    0x3ff5a80000000000,
    0x3ff5980000000000,
    0x3ff5880000000000,
    0x3ff5780000000000,
    0x3ff5680000000000,
    0x3ff5600000000000,
    0x3ff5500000000000,
    0x3ff5400000000000,
    0x3ff5300000000000,
    0x3ff5200000000000,
    0x3ff5180000000000,
    0x3ff5080000000000,
    0x3ff4f80000000000,
    0x3ff4f00000000000,
    0x3ff4e00000000000,
    0x3ff4d00000000000,
    0x3ff4c00000000000,
    0x3ff4b80000000000,
    0x3ff4a80000000000,
    0x3ff4a00000000000,
    0x3ff4900000000000,
    0x3ff4800000000000,
    0x3ff4780000000000,
    0x3ff4680000000000,
    0x3ff4580000000000,
    0x3ff4500000000000,
    0x3ff4400000000000,
    0x3ff4300000000000,
    0x3ff4280000000000,
    0x3ff4180000000000,
    0x3ff4100000000000,
    0x3ff4000000000000,
    0x3ff3f80000000000,
    0x3ff3e80000000000,
    0x3ff3e00000000000,
    0x3ff3d00000000000,
    0x3ff3c00000000000,
    0x3ff3b80000000000,
    0x3ff3a80000000000,
    0x3ff3a00000000000,
    0x3ff3900000000000,
    0x3ff3880000000000,
    0x3ff3780000000000,
    0x3ff3700000000000,
    0x3ff3600000000000,
    0x3ff3580000000000,
    0x3ff3500000000000,
    0x3ff3400000000000,
    0x3ff3380000000000,
    0x3ff3280000000000,
    0x3ff3200000000000,
    0x3ff3100000000000,
    0x3ff3080000000000,
    0x3ff3000000000000,
    0x3ff2f00000000000,
    0x3ff2e80000000000,
    0x3ff2d80000000000,
    0x3ff2d00000000000,
    0x3ff2c80000000000,
    0x3ff2b80000000000,
    0x3ff2b00000000000,
    0x3ff2a00000000000,
    0x3ff2980000000000,
    0x3ff2900000000000,
    0x3ff2800000000000,
    0x3ff2780000000000,
    0x3ff2700000000000,
    0x3ff2600000000000,
    0x3ff2580000000000,
    0x3ff2500000000000,
    0x3ff2400000000000,
    0x3ff2380000000000,
    0x3ff2300000000000,
    0x3ff2280000000000,
    0x3ff2180000000000,
    0x3ff2100000000000,
    0x3ff2080000000000,
    0x3ff2000000000000,
    0x3ff1f00000000000,
    0x3ff1e80000000000,
    0x3ff1e00000000000,
    0x3ff1d00000000000,
    0x3ff1c80000000000,
    0x3ff1c00000000000,
    0x3ff1b80000000000,
    0x3ff1b00000000000,
    0x3ff1a00000000000,
    0x3ff1980000000000,
    0x3ff1900000000000,
    0x3ff1880000000000,
    0x3ff1800000000000,
    0x3ff1700000000000,
    0x3ff1680000000000,
    0x3ff1600000000000,
    0x3ff1580000000000,
    0x3ff1500000000000,
    0x3ff1400000000000,
    0x3ff1380000000000,
    0x3ff1300000000000,
    0x3ff1280000000000,
    0x3ff1200000000000,
    0x3ff1180000000000,
    0x3ff1100000000000,
    0x3ff1000000000000,
    0x3ff0f80000000000,
    0x3ff0f00000000000,
    0x3ff0e80000000000,
    0x3ff0e00000000000,
    0x3ff0d80000000000,
    0x3ff0d00000000000,
    0x3ff0c80000000000,
    0x3ff0c00000000000,
    0x3ff0b00000000000,
    0x3ff0a80000000000,
    0x3ff0a00000000000,
    0x3ff0980000000000,
    0x3ff0900000000000,
    0x3ff0880000000000,
    0x3ff0800000000000,
    0x3ff0780000000000,
    0x3ff0700000000000,
    0x3ff0680000000000,
    0x3ff0600000000000,
    0x3ff0580000000000,
    0x3ff0500000000000,
    0x3ff0480000000000,
    0x3ff0400000000000,
    0x3ff0380000000000,
    0x3ff0300000000000,
    0x3ff0280000000000,
    0x3ff0200000000000,
    0x3ff0180000000000,
    0x3ff0100000000000,
    0x3ff0080000000000,
    0x3feff80000000000,
    0x3fefe80000000000,
    0x3fefd80000000000,
    0x3fefc80000000000,
    0x3fefb80000000000,
    0x3fefa80000000000,
    0x3fef980000000000,
    0x3fef880000000000,
    0x3fef780000000000,
    0x3fef680000000000,
    0x3fef580000000000,
    0x3fef500000000000,
    0x3fef400000000000,
    0x3fef300000000000,
    0x3fef200000000000,
    0x3fef100000000000,
    0x3fef000000000000,
    0x3feef00000000000,
    0x3feee00000000000,
    0x3feed00000000000,
    0x3feec80000000000,
    0x3feeb80000000000,
    0x3feea80000000000,
    0x3fee980000000000,
    0x3fee880000000000,
    0x3fee780000000000,
    0x3fee700000000000,
    0x3fee600000000000,
    0x3fee500000000000,
    0x3fee400000000000,
    0x3fee300000000000,
    0x3fee280000000000,
    0x3fee180000000000,
    0x3fee080000000000,
    0x3fedf80000000000,
    0x3fedf00000000000,
    0x3fede00000000000,
    0x3fedd00000000000,
    0x3fedc00000000000,
    0x3fedb80000000000,
    0x3feda80000000000,
    0x3fed980000000000,
    0x3fed900000000000,
    0x3fed800000000000,
    0x3fed700000000000,
    0x3fed600000000000,
    0x3fed580000000000,
    0x3fed480000000000,
    0x3fed380000000000,
    0x3fed300000000000,
    0x3fed200000000000,
    0x3fed100000000000,
    0x3fed080000000000,
    0x3fecf80000000000,
    0x3fece80000000000,
    0x3fece00000000000,
    0x3fecd00000000000,
    0x3fecc80000000000,
    0x3fecb80000000000,
    0x3feca80000000000,
    0x3feca00000000000,
    0x3fec900000000000,
    0x3fec880000000000,
    0x3fec780000000000,
    0x3fec680000000000,
    0x3fec600000000000,
    0x3fec500000000000,
    0x3fec480000000000,
    0x3fec380000000000,
    0x3fec300000000000,
    0x3fec200000000000,
    0x3fec180000000000,
    0x3fec080000000000,
    0x3febf80000000000,
    0x3febf00000000000,
    0x3febe00000000000,
    0x3febd80000000000,
    0x3febc80000000000,
    0x3febc00000000000,
    0x3febb00000000000,
    0x3feba80000000000,
    0x3feb980000000000,
    0x3feb900000000000,
    0x3feb800000000000,
    0x3feb780000000000,
    0x3feb680000000000,
    0x3feb600000000000,
    0x3feb580000000000,
    0x3feb480000000000,
    0x3feb400000000000,
    0x3feb300000000000,
    0x3feb280000000000,
    0x3feb180000000000,
    0x3feb100000000000,
    0x3feb000000000000,
    0x3feaf80000000000,
    0x3feaf00000000000,
    0x3feae00000000000,
    0x3fead80000000000,
    0x3feac80000000000,
    0x3feac00000000000,
    0x3feab80000000000,
    0x3feaa80000000000,
    0x3feaa00000000000,
    0x3fea900000000000,
    0x3fea880000000000,
    0x3fea800000000000,
    0x3fea700000000000,
    0x3fea680000000000,
    0x3fea600000000000,
    0x3fea500000000000,
    0x3fea480000000000,
    0x3fea400000000000,
    0x3fea300000000000,
    0x3fea280000000000,
    0x3fea200000000000,
    0x3fea100000000000,
    0x3fea080000000000,
    0x3fea000000000000,
    0x3fe9f00000000000,
    0x3fe9e80000000000,
    0x3fe9e00000000000,
    0x3fe9d00000000000,
    0x3fe9c80000000000,
    0x3fe9c00000000000,
    0x3fe9b00000000000,
    0x3fe9a80000000000,
    0x3fe9a00000000000,
    0x3fe9980000000000,
    0x3fe9880000000000,
    0x3fe9800000000000,
    0x3fe9780000000000,
    0x3fe9680000000000,
    0x3fe9600000000000,
    0x3fe9580000000000,
    0x3fe9500000000000,
    0x3fe9400000000000,
    0x3fe9380000000000,
    0x3fe9300000000000,
    0x3fe9280000000000,
    0x3fe9200000000000,
    0x3fe9100000000000,
    0x3fe9080000000000,
    0x3fe9000000000000,
    0x3fe8f80000000000,
    0x3fe8e80000000000,
    0x3fe8e00000000000,
    0x3fe8d80000000000,
    0x3fe8d00000000000,
    0x3fe8c80000000000,
    0x3fe8b80000000000,
    0x3fe8b00000000000,
    0x3fe8a80000000000,
    0x3fe8a00000000000,
    0x3fe8980000000000,
    0x3fe8880000000000,
    0x3fe8800000000000,
    0x3fe8780000000000,
    0x3fe8700000000000,
    0x3fe8680000000000,
    0x3fe8600000000000,
    0x3fe8500000000000,
    0x3fe8480000000000,
    0x3fe8400000000000,
    0x3fe8380000000000,
    0x3fe8300000000000,
    0x3fe8280000000000,
    0x3fe8200000000000,
    0x3fe8100000000000,
    0x3fe8080000000000,
    0x3fe8000000000000,
    0x3fe7f80000000000,
    0x3fe7f00000000000,
    0x3fe7e80000000000,
    0x3fe7e00000000000,
    0x3fe7d80000000000,
    0x3fe7c80000000000,
    0x3fe7c00000000000,
    0x3fe7b80000000000,
    0x3fe7b00000000000,
    0x3fe7a80000000000,
    0x3fe7a00000000000,
    0x3fe7980000000000,
    0x3fe7900000000000,
    0x3fe7880000000000,
    0x3fe7800000000000,
    0x3fe7780000000000,
    0x3fe7700000000000,
    0x3fe7600000000000,
    0x3fe7580000000000,
    0x3fe7500000000000,
    0x3fe7480000000000,
    0x3fe7400000000000,
    0x3fe7380000000000,
    0x3fe7300000000000,
    0x3fe7280000000000,
    0x3fe7200000000000,
    0x3fe7180000000000,
    0x3fe7100000000000,
    0x3fe7080000000000,
    0x3fe7000000000000,
    0x3fe6f80000000000,
    0x3fe6f00000000000,
    0x3fe6e80000000000,
    0x3fe6e00000000000,
    0x3fe6d80000000000,
    0x3fe6d00000000000,
    0x3fe6c80000000000,
    0x3fe6c00000000000,
    0x3fe6b80000000000,
    0x3fe6b00000000000,
    0x3fe6a80000000000,
    0x3fe6a00000000000,
];

pub(crate) static LOG2P1_LOG_DD_INVERSE: [(u64, u64); 363] = [
    (0xbd13c7ca90bc04b2, 0xbfd615ddb4bec000),
    (0xbd3527d18f7738fa, 0xbfd5e87b20c29000),
    (0x3d339ae8f873fa41, 0xbfd5baf846aa2000),
    (0xbd2791f30a795215, 0xbfd58d54f86e0000),
    (0x3d11e64778df4a62, 0xbfd55f9107a44000),
    (0xbd3df83b7d931501, 0xbfd531ac457ee000),
    (0x3d2a68c8f16f9b5d, 0xbfd503a682cb2000),
    (0xbd234d7aaf04d104, 0xbfd4ec9732600000),
    (0x3d3d7c92cd9ad824, 0xbfd4be5f95778000),
    (0x3d38bccffe1a0f8c, 0xbfd4900680401000),
    (0x3d13d82f484c84cc, 0xbfd4618bc21c6000),
    (0x3d3fb129931715ad, 0xbfd432ef2a04f000),
    (0xbd3f8ef43049f7d3, 0xbfd404308686a000),
    (0xbd3c3e1cd9a395e3, 0xbfd3d54fa5c1f000),
    (0xbd37a71cbcd735d0, 0xbfd3a64c55694000),
    (0x3d3e9436ac53b023, 0xbfd3772662bfe000),
    (0x3d3b07de4ea1a54a, 0xbfd35f865c933000),
    (0xbd36217dc2a3e08b, 0xbfd3302c16586000),
    (0xbd342f568b75fcac, 0xbfd300aead063000),
    (0xbd360c61f7088353, 0xbfd2d10dec508000),
    (0x3d30dbbf51f3aadc, 0xbfd2a1499f763000),
    (0xbd3a8d7ad24c13f0, 0xbfd2895a13de8000),
    (0xbd38e7bc224ea3e3, 0xbfd2596010df7000),
    (0x3d3a6976f5eb0963, 0xbfd22941fbcf8000),
    (0xbd27946c040cbe77, 0xbfd1f8ff9e48a000),
    (0x3d381410e5c62aff, 0xbfd1c898c169a000),
    (0x3d32dd466dc55e2d, 0xbfd1b05791f08000),
    (0x3d3a8a8ba74a2684, 0xbfd17fb98e151000),
    (0x3d3e97a65dfc9794, 0xbfd14ef67f887000),
    (0x3d3d3e8499d67123, 0xbfd136870293b000),
    (0x3d34ab9d817d52cd, 0xbfd1058bf9ae5000),
    (0xbd3d2c81f640e1e6, 0xbfd0d46b579ab000),
    (0xbd0c6bee7ef4030e, 0xbfd0a324e2739000),
    (0xbd3ebc1d40c5a329, 0xbfd08a73667c5000),
    (0x3d30e866bcd236ad, 0xbfd058f3c703f000),
    (0xbcf036b89ef42d7f, 0xbfd0402594b4d000),
    (0xbcdcc68d52e01203, 0xbfd00e6c45ad5000),
    (0x3d0d572aab993c87, 0xbfcfb9186d5e4000),
    (0x3d3f75fd6a526efe, 0xbfcf871b28956000),
    (0x3d3f454f1417e41f, 0xbfcf22e5e72f2000),
    (0x3d23d45330fdca4d, 0xbfcebe61f4dd8000),
    (0x3d26805b80e8e6ff, 0xbfce8c0252aa6000),
    (0x3d3a342c2af0003c, 0xbfce27076e2b0000),
    (0xbd38fac1a628ccc6, 0xbfcdc1bca0abe000),
    (0x3d15105fc364c784, 0xbfcd8ef91af32000),
    (0x3d383270128aaa5f, 0xbfcd293581b6c000),
    (0xbd2771239a07d55b, 0xbfccf6354e09c000),
    (0x3d27794f689f8434, 0xbfcc8ff7c79aa000),
    (0xbd20929decb454fc, 0xbfcc5cba543ae000),
    (0xbd2386a947c378b5, 0xbfcbf601bb0e4000),
    (0xbd39ac53f39d121c, 0xbfcbc286742d8000),
    (0x3d34b722ec011f31, 0xbfcb5b519e8fc000),
    (0x3cba4e633fcd9066, 0xbfcaf3c94e80c000),
    (0x3d3b68f5395f139d, 0xbfcabfe5ae462000),
    (0xbd3b99c8ca1d9abb, 0xbfca57df28244000),
    (0x3d3539cd91dc9f0b, 0xbfca23bc1fe2c000),
    (0x3d21f2a8a1ce0ffc, 0xbfc9bb362e7e0000),
    (0xbcf93b564dd44000, 0xbfc986d322818000),
    (0xbd37bc6abddeff46, 0xbfc91dcc8c340000),
    (0xbd3a8154b13d72d5, 0xbfc8e928de886000),
    (0xbd322120401202fc, 0xbfc87fa06520c000),
    (0x3d3d8daadf4e2bd2, 0xbfc84abb75866000),
    (0x3d302a52f9201ce8, 0xbfc815c0a1436000),
    (0x3d2bdb9072534a58, 0xbfc7ab890210e000),
    (0xbd0274903479e3d1, 0xbfc7764c128f2000),
    (0xbd34ea64f6a95bef, 0xbfc70b8f97a1a000),
    (0x3d3bc6e557134767, 0xbfc6d60fe719e000),
    (0xbd3aa1bdbfc6c785, 0xbfc66acd4272a000),
    (0xbd2d5ec0ab8163af, 0xbfc6350a28aaa000),
    (0x3d38586f183bebf2, 0xbfc5ff3070a7a000),
    (0xbcf0ba68b7555d4a, 0xbfc59338d9982000),
    (0xbd3add94dda647e8, 0xbfc55d1ad4232000),
    (0x3d3e9bf2fafeaf27, 0xbfc4f099f4a24000),
    (0x3d34354bb3f219e5, 0xbfc4ba36f39a6000),
    (0xbd1eea52723f6369, 0xbfc483bccce6e000),
    (0x3d210047081f849d, 0xbfc41682bf728000),
    (0xbd28a72a62b8c13f, 0xbfc3dfc2b0ecc000),
    (0xbd3ee8779b2d8abc, 0xbfc371fc201e8000),
    (0xbd3c9ecca2fe72a5, 0xbfc33af575770000),
    (0x3cd680b5ce3ecb05, 0xbfc303d718e48000),
    (0x3d35b967f4471dfc, 0xbfc29552f8200000),
    (0xbd35a3854f176449, 0xbfc25ded0abc6000),
    (0x3d24d20ab840e7f6, 0xbfc2266f190a6000),
    (0xbd2e80a41811a396, 0xbfc1b72ad52f6000),
    (0xbd2843fad093c8dc, 0xbfc17f6458fca000),
    (0xbd1563451027c750, 0xbfc1478584674000),
    (0xbd3cb2cd2ee2f482, 0xbfc0d77e7cd08000),
    (0x3d28f3057157d1a8, 0xbfc09f561ee72000),
    (0x3d2a47579cdc0a3d, 0xbfc0671512ca6000),
    (0x3d15a8fa5ce00e5d, 0xbfc02ebb42bf4000),
    (0x3d010987e897ed01, 0xbfbf7b79fec38000),
    (0x3d3d599e83368e91, 0xbfbf0a30c0118000),
    (0xbd34677489c50e97, 0xbfbe98b549670000),
    (0x3d2a342c2af0003c, 0xbfbe27076e2b0000),
    (0x3d29454379135713, 0xbfbd4313d66cc000),
    (0xbd33e14db50dd743, 0xbfbcd0cdbf8c0000),
    (0xbd1d0c57585fbe06, 0xbfbc5e548f5bc000),
    (0x3d325ef7bc3987e7, 0xbfbb78c82bb10000),
    (0xbd0ff22c18f84a5e, 0xbfbb05b49bee4000),
    (0xbd3563650bd22a9c, 0xbfba926d3a4ac000),
    (0xbd3cd4176df97bcb, 0xbfba1ef1d8060000),
    (0x3d28a64826787061, 0xbfb9ab4246204000),
    (0xbd3b20f5acb42a66, 0xbfb8c345d6318000),
    (0x3d37d5cd246977c9, 0xbfb84ef898e84000),
    (0xbd32cc844480c89b, 0xbfb7da766d7b0000),
    (0x3cfecbc035c4256a, 0xbfb765bf23a6c000),
    (0x3d34b4641b664613, 0xbfb6f0d28ae58000),
    (0xbd30c3b1dee9c4f8, 0xbfb60658a9374000),
    (0xbd3c284f5722abaa, 0xbfb590cafdf00000),
    (0xbd383f69278e686a, 0xbfb51b073f060000),
    (0x3d2f7fe1308973e2, 0xbfb4a50d3aa1c000),
    (0xbd1bc0eeea7c9acd, 0xbfb42edcbea64000),
    (0xbd31d09299837610, 0xbfb341d7961bc000),
    (0xbd3e1ee2ca657021, 0xbfb2cb0283f5c000),
    (0xbd3416f8fb69a701, 0xbfb253f62f0a0000),
    (0xbd39444f5e9e8981, 0xbfb1dcb263db0000),
    (0x3d147c5e768fa309, 0xbfb16536eea38000),
    (0x3d3901f46d48abb4, 0xbfb0ed839b554000),
    (0x3d3b8ecfe4b59987, 0xbfb0759835990000),
    (0x3d2d599e83368e91, 0xbfaf0a30c0118000),
    (0x3d2fea4664629e86, 0xbfae19070c278000),
    (0xbd16a423c78a64b0, 0xbfad276b8adb0000),
    (0xbd2f2ccc9abf8388, 0xbfac355dd0920000),
    (0x3d1c827ae5d6704c, 0xbfab42dd71198000),
    (0x3d36e584a0402925, 0xbfaa4fe9ffa40000),
    (0x3d2c148297c5feb8, 0xbfa95c830ec90000),
    (0x3d12623a134ac693, 0xbfa868a830840000),
    (0x3d3181dce586af09, 0xbfa77458f6330000),
    (0x3d2b2b739570ad39, 0xbfa58a5bafc90000),
    (0xbd211c78a56fd247, 0xbfa494acc34d8000),
    (0xbd3eafd480ad9015, 0xbfa39e87b9fe8000),
    (0x3d278ce77a9163fe, 0xbfa2a7ec22150000),
    (0x3d33401e9ae889bb, 0xbfa1b0d989240000),
    (0x3d2e89896f022783, 0xbfa0b94f7c198000),
    (0xbd2980267c7e09e4, 0xbf9f829b0e780000),
    (0xbd2e61f1658cfb9a, 0xbf9d91a66c540000),
    (0x3d3b9a010ae6922a, 0xbf9b9fc027b00000),
    (0x3d2d75d97ec7c410, 0xbf99ace7551d0000),
    (0x3d33b955b602ace4, 0xbf97b91b07d60000),
    (0x3d263bb6216d87d8, 0xbf95c45a51b90000),
    (0x3d36a2c432d6a40b, 0xbf93cea443470000),
    (0x3d14193a83fcc7a6, 0xbf91d7f7eb9f0000),
    (0xbcdf1e7cf6d3a69c, 0xbf8fc0a8b0fc0000),
    (0xbd1c25e097bd9771, 0xbf8bcf712c740000),
    (0x3d3eb1245b5da1f5, 0xbf87dc475f820000),
    (0x3d2609c1ff29a114, 0xbf83e7295d260000),
    (0xbd19e23f0dda40e4, 0xbf7fe02a6b100000),
    (0xbd0749d3c2d23a07, 0xbf77ee11ebd80000),
    (0xbd20bc04a086b56a, 0xbf6ff00aa2b00000),
    (0x3d33bc661d61c5eb, 0xbf5ff802a9b00000),
    (0x3d356224cd5f35f8, 0x3f50020055600000),
    (0x3d285c0696a70c0c, 0x3f68090482880000),
    (0x3d1e3871df070002, 0x3f740c8a74780000),
    (0xbd3d805512588560, 0x3f7c189cbb100000),
    (0x3d3e3d1238c4ea00, 0x3f82145e939e0000),
    (0xbd38073eeaf8eaf3, 0x3f861e77e8b60000),
    (0xbd3f73bc4d6d3472, 0x3f8a2a9c6c180000),
    (0xbd39de88a3da281a, 0x3f8e38ce30340000),
    (0x3d3fdbe5fed4b393, 0x3f912487a5500000),
    (0x3d2710cb130895fc, 0x3f932db0ea130000),
    (0x3d2ab259d2d7f253, 0x3f9537e3f45f0000),
    (0x3d07abf389596542, 0x3f963d6178690000),
    (0xbd2aa0ba325a0c34, 0x3f98492528c90000),
    (0xbd2de0709f2d03c9, 0x3f9a55f548c60000),
    (0xbd35439ce030a687, 0x3f9c63d2ec150000),
    (0xbd28d75149774d47, 0x3f9e72bf28140000),
    (0xbd3dddc7f461c516, 0x3fa0415d89e78000),
    (0xbd32b98a9a4168fd, 0x3fa149e3e4008000),
    (0x3d283e9ae021b67b, 0x3fa252f32f8d0000),
    (0x3d38357d5ef9eb35, 0x3fa35c8bfaa10000),
    (0x3d3748ed3f6e378e, 0x3fa3e18c1ca08000),
    (0xbd2d9150f73be773, 0x3fa4ebf4334a0000),
    (0xbd20485a8012494c, 0x3fa5f6e730790000),
    (0xbd2888df11fd5ce7, 0x3fa70265a5510000),
    (0xbd399dc16f28bf45, 0x3fa80e7023d90000),
    (0xbd19d7c53f76ca96, 0x3fa91b073efd8000),
    (0xbd30c22e4ec4d90d, 0x3fa9a187b5740000),
    (0x3d20fc1a353bb42e, 0x3faaaef2d0fb0000),
    (0xbd17bf868c317c2a, 0x3fabbcebfc690000),
    (0x3d3965c36e09f5fe, 0x3faccb73cddd8000),
    (0xbd21b1ac64d9e42f, 0x3fadda8adc680000),
    (0xbd30f25c74676689, 0x3fae624c4a0b8000),
    (0xbd3d6eb0dd5610d3, 0x3faf723b51800000),
    (0x3d1111c05cf1d753, 0x3fb0415d89e74000),
    (0x3d2c2da80974d976, 0x3fb0c9e615ac4000),
    (0xbd37cf69284a3465, 0x3fb10e45b3cb0000),
    (0x3d3566d154f930b3, 0x3fb1973bd1464000),
    (0x3d349d8cfc10c7bf, 0x3fb2207b5c784000),
    (0x3d37a48ba8b1cb41, 0x3fb2aa04a4470000),
    (0x3d08081edd77c860, 0x3fb2eee507b40000),
    (0x3d37141128f1faca, 0x3fb378dd7f748000),
    (0x3d26fd84aa8157c0, 0x3fb403207b414000),
    (0x3d3fad46e8d26ab7, 0x3fb4485e03dbc000),
    (0xbcf53a2582f4e1ef, 0x3fb4d3115d208000),
    (0x3d0c1d740c53c72e, 0x3fb55e10050e0000),
    (0x3d31cb7ce1d17171, 0x3fb5e95a4d978000),
    (0xbd2179957ed63c4e, 0x3fb62f1be7d78000),
    (0x3d0daf3cc08926ae, 0x3fb6bad83c188000),
    (0xbd3126d16e1e21d2, 0x3fb746e100228000),
    (0x3d069b5794b69fb7, 0x3fb78d02263d8000),
    (0xbd3c0fe460d20041, 0x3fb8197e2f410000),
    (0x3d3c28c0af9bd6df, 0x3fb8a6477a91c000),
    (0xbd222f39be67f7aa, 0x3fb8ecc933aec000),
    (0xbcf8bcc1732093ce, 0x3fb97a07024cc000),
    (0xbd0a9ce6c9ad51bf, 0x3fba0792e9278000),
    (0xbd0e42b6b94407c8, 0x3fba4e7640b1c000),
    (0xbd3573b209c31904, 0x3fbadc77ee5b0000),
    (0xbceff64eea137079, 0x3fbb23965a530000),
    (0xbd368ba835459b8e, 0x3fbbb20e936d8000),
    (0x3d3cb1121d1930dd, 0x3fbc40d6425a4000),
    (0x3d2646d1c65aacd3, 0x3fbc885801bc4000),
    (0x3d336433b5efbeed, 0x3fbd179788218000),
    (0x3d30e239cc185469, 0x3fbd5f5565920000),
    (0xbd324750412e9a74, 0x3fbdef0d8d468000),
    (0xbd32c1c59bc77bfa, 0x3fbe7f1691a34000),
    (0x3d311fcba80cdd10, 0x3fbec739830a0000),
    (0x3d176a6c9ea8b04e, 0x3fbf57bc7d900000),
    (0xbd08f351fa48a730, 0x3fbfa01c9db58000),
    (0x3d03f9651cff9dfe, 0x3fc0188d2ecf6000),
    (0x3d381a9cf169fc5c, 0x3fc03cdc0a51e000),
    (0xbd27e5dd7009902c, 0x3fc08598b59e4000),
    (0xbd345519d7032129, 0x3fc0aa0691268000),
    (0xbd3e09b441ae86c5, 0x3fc0f301717d0000),
    (0xbd2cf5fdd94f6509, 0x3fc13c2605c3a000),
    (0x3d2ec2d2a9009e3d, 0x3fc160c8024b2000),
    (0xbd31ac38dde3b366, 0x3fc1aa2b7e240000),
    (0xbd315c1c39192af9, 0x3fc1ceed09854000),
    (0xbd3b3a1e7f50c701, 0x3fc2188fd9808000),
    (0x3d100d238fd3df5c, 0x3fc23d712a49c000),
    (0x3d37494e359302e6, 0x3fc28753bc11a000),
    (0xbd1d3466d0c6c8a8, 0x3fc2ac55095f6000),
    (0x3d352b302160f40d, 0x3fc2f677cbbc0000),
    (0x3d3f098ee3a50810, 0x3fc31b994d3a4000),
    (0xbd3fd3a0afb9691b, 0x3fc365fcb015a000),
    (0xbd370ef0545c17f9, 0x3fc38b3e9e028000),
    (0x3d13fb2f85096c4b, 0x3fc3d5e3126bc000),
    (0x3d319713c0cae559, 0x3fc3fb45a5992000),
    (0xbd116282c85a0884, 0x3fc420b327410000),
    (0xbd1249cd0790841a, 0x3fc46baf0f9f6000),
    (0xbd353e43558124c4, 0x3fc4913d8333c000),
    (0x3d0c79b60ae1ff0f, 0x3fc4dc7b897bc000),
    (0x3d348a05ff36a25b, 0x3fc5022b292f6000),
    (0x3d2746fee5c8d0d8, 0x3fc54dabc2610000),
    (0x3d39baa7a6b887f6, 0x3fc5737cc9018000),
    (0xbd127023eb68981c, 0x3fc5bf406b544000),
    (0xbd31ce0bf3b290ea, 0x3fc5e533144c2000),
    (0xbd371456c988f814, 0x3fc60b3100b0a000),
    (0xbd398c1d34f0f462, 0x3fc6574ebe8c2000),
    (0xbd311e8830a706d3, 0x3fc67d6e9d786000),
    (0xbcdc73fafd9b2dca, 0x3fc6c9d07d204000),
    (0x3d3577390d31ef0f, 0x3fc6f0128b756000),
    (0x3ce51b157cec3838, 0x3fc716600c914000),
    (0xbd25e77dc7c5f3e1, 0x3fc7631d82936000),
    (0x3d38e67be3dbaf3f, 0x3fc7898d85444000),
    (0xbd24c06b17c301d7, 0x3fc7d6903caf6000),
    (0xbd158bebf457b7d2, 0x3fc7fd22ff59a000),
    (0x3d1e0ddb9a631e83, 0x3fc823c16551a000),
    (0x3d3328eb42f9af75, 0x3fc871213750e000),
    (0xbd296b37380cbe9e, 0x3fc897e2b17b2000),
    (0xbd073d54aae92cd1, 0x3fc8beafeb390000),
    (0xbd1935f57718d7ca, 0x3fc90c6db9fcc000),
    (0x3d33115c3abd47da, 0x3fc9335e5d594000),
    (0x3d07f22858a0ff6f, 0x3fc95a5adcf70000),
    (0x3d3470fa3efec390, 0x3fc9a8778deba000),
    (0x3d3d862f10c414e3, 0x3fc9cf97cdce0000),
    (0xbd3337d94bcd3f43, 0x3fc9f6c40708a000),
    (0x3d360a77c81f7171, 0x3fca454082e6a000),
    (0xbd3f63b7f037b0c6, 0x3fca6c90d44b8000),
    (0xbd28724350562169, 0x3fca93ed3c8ae000),
    (0x3d37a8d5ae54f550, 0x3fcae2ca6f672000),
    (0xbd22e72d5c3998ed, 0x3fcb0a4b48fc2000),
    (0x3d3c794e562a63cb, 0x3fcb31d8575bc000),
    (0x3d1e90683b9cd768, 0x3fcb811730b82000),
    (0x3d3a32e7f44432da, 0x3fcba8c90ae4a000),
    (0xbd2d4bc4595412b6, 0x3fcbd087383be000),
    (0xbd292e0ee55c7ac6, 0x3fcc2028ab180000),
    (0x3d39a294d5e44e76, 0x3fcc480c0005c000),
    (0x3d3ee138d3a69d43, 0x3fcc6ffbc6f00000),
    (0x3d23b161a8c6e6c5, 0x3fcc97f8079d4000),
    (0xbd29e0aba2099515, 0x3fcce816157f2000),
    (0xbd084a7e75b6f6e4, 0x3fcd1037f2656000),
    (0xbd373650b38932bc, 0x3fcd386668720000),
    (0xbd375f280234bf51, 0x3fcd88e93fb30000),
    (0x3d32806a847527e6, 0x3fcdb13db0d48000),
    (0xbd302ec669c756eb, 0x3fcdd99edaf6e000),
    (0xbd252b00adb91424, 0x3fce020cc6236000),
    (0xbd3fdbdbb13f7c18, 0x3fce530effe72000),
    (0xbd0d5eee23793649, 0x3fce7ba35eb78000),
    (0x3d35e91663732a36, 0x3fcea4449f04a000),
    (0xbd3bec63a3e75640, 0x3fceccf2c8fea000),
    (0xbcca211565bb8e11, 0x3fcef5ade4dd0000),
    (0xbd3bae49f1df7b5e, 0x3fcf474b134e0000),
    (0xbd10819516673e23, 0x3fcf702d36778000),
    (0xbd390d04cd7cc834, 0x3fcf991c6cb3c000),
    (0x3d34bba46f1cf6a0, 0x3fcfc218be620000),
    (0x3d31cd8d688b9e18, 0x3fd00a1c6adda000),
    (0x3d3a43dcfade85ae, 0x3fd01eae5626c000),
    (0x3cf89ff8a966395c, 0x3fd03346e0106000),
    (0x3d2dbdf10d397f3c, 0x3fd047e60cde8000),
    (0x3d2ad0f1c77ccb58, 0x3fd05c8be0d96000),
    (0x3d3e5d513f45fe7b, 0x3fd085eb8f8ae000),
    (0x3d3b50a1e1734342, 0x3fd09aa572e6c000),
    (0x3d23c7c3f528d80a, 0x3fd0af660eb9e000),
    (0x3d27188b163ceae9, 0x3fd0c42d67616000),
    (0x3d1ee8c88753fa35, 0x3fd0d8fb813eb000),
    (0xbd2f1fbddfdfd686, 0x3fd102ac0a35d000),
    (0x3d31ef78ce2d07f2, 0x3fd1178e8227e000),
    (0x3d13b2948a11f797, 0x3fd12c77cd007000),
    (0x3d3e0c07824daaf5, 0x3fd14167ef367000),
    (0xbcee75adfb6aba25, 0x3fd1565eed456000),
    (0xbd323299042d74bf, 0x3fd16b5ccbad0000),
    (0x3d27d2f73ad1aa14, 0x3fd1956d3b9bc000),
    (0x3d29f60a9616f7a0, 0x3fd1aa7fd638d000),
    (0xbd31ac89575c2125, 0x3fd1bf99635a7000),
    (0x3d222a667c42e56d, 0x3fd1d4b9e796c000),
    (0xbd382eaed3c8b65e, 0x3fd1e9e16788a000),
    (0x3d3e9d5b513ff0c1, 0x3fd1ff0fe7cf4000),
    (0xbd3caf0428b728a3, 0x3fd214456d0ec000),
    (0xbd36dbe448a2e522, 0x3fd23ec5991ec000),
    (0x3d3b1d7ac0ef77f2, 0x3fd25410494e5000),
    (0xbd31b61f10522625, 0x3fd269621134e000),
    (0xbd2b198800b4bda7, 0x3fd27ebaf58d9000),
    (0xbd3210c2b730e28b, 0x3fd2941afb187000),
    (0xbd22058e557285cf, 0x3fd2a982269a4000),
    (0x3d2a9cfa4a5004f4, 0x3fd2bef07cdc9000),
    (0xbd288d0ddcd54196, 0x3fd2d46602add000),
    (0xbd38aed2541e6e2e, 0x3fd2ff66b04eb000),
    (0xbd28e27ad3213cb8, 0x3fd314f1e1d36000),
    (0x3d04f928139af5d6, 0x3fd32a8456512000),
    (0xbd317c73556e291d, 0x3fd3401e12aed000),
    (0xbd2ba99b8964f0e8, 0x3fd355bf1bd83000),
    (0x3d116ecdb0f177c8, 0x3fd36b6776be1000),
    (0xbd2a71e493a0702b, 0x3fd3811728565000),
    (0xbd05839c5663663d, 0x3fd396ce359bc000),
    (0xbd2d0befbc02be4a, 0x3fd3ac8ca38e6000),
    (0x3d183b54b606bd5c, 0x3fd3c25277333000),
    (0xbd222c7c2a9d37a4, 0x3fd3d81fb5947000),
    (0xbd3f067c297f2c3f, 0x3fd3edf463c17000),
    (0xbd3ce379226de3ec, 0x3fd419b423d5f000),
    (0x3d3906440f7d3354, 0x3fd42f9f3ff62000),
    (0xbd06e95892923d88, 0x3fd44591e053a000),
    (0xbd0d9120e7d0a853, 0x3fd45b8c0a17e000),
    (0x3d306c18fb4c14c5, 0x3fd4718dc271c000),
    (0x3d3dc1b8465cf25f, 0x3fd487970e958000),
    (0x3d307b334daf4b9a, 0x3fd49da7f3bcc000),
    (0xbd165b4681052b9f, 0x3fd4b3c077268000),
    (0xbd2e20891b0ad8a4, 0x3fd4c9e09e173000),
    (0xbd34d692a1e44788, 0x3fd4e0086dd8c000),
    (0xbd3fc158cb3124b9, 0x3fd4f637ebbaa000),
    (0xbd3a0e6b7e827c2c, 0x3fd50c6f1d11c000),
    (0x3d2ebe708164c759, 0x3fd522ae0738a000),
    (0x3d27ec02e45547ce, 0x3fd538f4af8f7000),
    (0x3d1a8954c0910952, 0x3fd54f431b7be000),
    (0x3d14c5fd2badc774, 0x3fd5659950695000),
    (0x3d1fadedee5d40ef, 0x3fd57bf753c8d000),
    (0xbd369bf5a7a56f34, 0x3fd5925d2b113000),
    (0xbcf7c79b0af7ecf8, 0x3fd5a8cadbbee000),
    (0xbd227023eb68981c, 0x3fd5bf406b544000),
    (0xbd0a0b2a08a465dc, 0x3fd5d5bddf596000),
    (0x3d36b71a1229d17f, 0x3fd5ec433d5c3000),
    (0x3d1ebe9176df3f65, 0x3fd602d08af09000),
    (0xbd2f08ad603c488e, 0x3fd61965cdb03000),
    (0xbd2db623e731ae00, 0x3fd630030b3ab000),
];
