/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// CAIssuerApplyConfiguration represents a declarative configuration of the CAIssuer type for use
// with apply.
type CAIssuerApplyConfiguration struct {
	SecretName             *string  `json:"secretName,omitempty"`
	CRLDistributionPoints  []string `json:"crlDistributionPoints,omitempty"`
	OCSPServers            []string `json:"ocspServers,omitempty"`
	IssuingCertificateURLs []string `json:"issuingCertificateURLs,omitempty"`
}

// CAIssuerApplyConfiguration constructs a declarative configuration of the CAIssuer type for use with
// apply.
func CAIssuer() *CAIssuerApplyConfiguration {
	return &CAIssuerApplyConfiguration{}
}

// WithSecretName sets the SecretName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecretName field is set to the value of the last call.
func (b *CAIssuerApplyConfiguration) WithSecretName(value string) *CAIssuerApplyConfiguration {
	b.SecretName = &value
	return b
}

// WithCRLDistributionPoints adds the given value to the CRLDistributionPoints field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the CRLDistributionPoints field.
func (b *CAIssuerApplyConfiguration) WithCRLDistributionPoints(values ...string) *CAIssuerApplyConfiguration {
	for i := range values {
		b.CRLDistributionPoints = append(b.CRLDistributionPoints, values[i])
	}
	return b
}

// WithOCSPServers adds the given value to the OCSPServers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the OCSPServers field.
func (b *CAIssuerApplyConfiguration) WithOCSPServers(values ...string) *CAIssuerApplyConfiguration {
	for i := range values {
		b.OCSPServers = append(b.OCSPServers, values[i])
	}
	return b
}

// WithIssuingCertificateURLs adds the given value to the IssuingCertificateURLs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the IssuingCertificateURLs field.
func (b *CAIssuerApplyConfiguration) WithIssuingCertificateURLs(values ...string) *CAIssuerApplyConfiguration {
	for i := range values {
		b.IssuingCertificateURLs = append(b.IssuingCertificateURLs, values[i])
	}
	return b
}
