#include <cstring>
#include <limits>

#include "CompletionModel.h"
#include "Quality.h"
#include "clang/Sema/CodeCompleteConsumer.h"
#include "llvm/ADT/bit.h"

#define BIT(X) (1LL << X)

namespace clang {
namespace clangd {

using SymbolCategory_type = clang::clangd::SymbolQualitySignals::SymbolCategory;
using ContextKind_type = clang::CodeCompletionContext::Kind;
using Scope_type = clang::clangd::SymbolRelevanceSignals::AccessibleScope;

uint32_t Example::OrderEncode(float F) {
  static_assert(std::numeric_limits<float>::is_iec559, "");
  constexpr uint32_t TopBit = ~(~uint32_t{0} >> 1);

  // Get the bits of the float. Endianness is the same as for integers.
  uint32_t U = llvm::bit_cast<uint32_t>(F);
  std::memcpy(&U, &F, sizeof(U));
  // IEEE 754 floats compare like sign-magnitude integers.
  if (U & TopBit)    // Negative float.
    return 0 - U;    // Map onto the low half of integers, order reversed.
  return U + TopBit; // Positive floats map onto the high half of integers.
}

namespace {
LLVM_ATTRIBUTE_NOINLINE float EvaluateTree0(const Example& E) {
  t0_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t0_n244;
  t0_n1: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t0_n237;
  t0_n2: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t0_n88;
  t0_n3: if (E.getNumReferences() >= 3343638400 /*52191.5*/) goto t0_n65;
  t0_n4: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t0_n40;
  t0_n5: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t0_n15;
  t0_n6: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t0_n10;
  t0_n7: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t0_n9;
  t0_n8: return 0.04381459951400757f;
  t0_n9: return -0.07934795320034027f;
  t0_n10: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t0_n14;
  t0_n11: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t0_n13;
  t0_n12: return 0.08100750297307968f;
  t0_n13: return 0.16864584386348724f;
  t0_n14: return 0.1547447293996811f;
  t0_n15: if (E.getNumReferences() >= 3290980352 /*673.5*/) goto t0_n31;
  t0_n16: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t0_n22;
  t0_n17: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t0_n19;
  t0_n18: return -0.17401087284088135f;
  t0_n19: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t0_n21;
  t0_n20: return 0.058513566851615906f;
  t0_n21: return -0.08097416162490845f;
  t0_n22: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t0_n28;
  t0_n23: if (E.getNumReferences() >= 3248226304 /*19.5*/) goto t0_n25;
  t0_n24: return -0.06604892760515213f;
  t0_n25: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t0_n27;
  t0_n26: return 0.01976003311574459f;
  t0_n27: return 0.14826877415180206f;
  t0_n28: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t0_n30;
  t0_n29: return -0.15115617215633392f;
  t0_n30: return -0.07294262945652008f;
  t0_n31: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t0_n37;
  t0_n32: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t0_n36;
  t0_n33: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t0_n35;
  t0_n34: return -0.035924121737480164f;
  t0_n35: return 0.10752751678228378f;
  t0_n36: return -0.09618733078241348f;
  t0_n37: if (E.getNumReferences() >= 3332892672 /*21492.0*/) goto t0_n39;
  t0_n38: return 0.12352735549211502f;
  t0_n39: return 0.17493310570716858f;
  t0_n40: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t0_n48;
  t0_n41: if (E.getNumReferences() >= 3307436032 /*2615.5*/) goto t0_n47;
  t0_n42: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t0_n44;
  t0_n43: return -0.12128043919801712f;
  t0_n44: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t0_n46;
  t0_n45: return 0.14435838162899017f;
  t0_n46: return -0.015689551830291748f;
  t0_n47: return 0.14758464694023132f;
  t0_n48: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t0_n60;
  t0_n49: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t0_n59;
  t0_n50: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t0_n54;
  t0_n51: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t0_n53;
  t0_n52: return 0.0826253741979599f;
  t0_n53: return 0.1444838047027588f;
  t0_n54: if (E.getNumReferences() >= 3332389376 /*20509.0*/) goto t0_n58;
  t0_n55: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t0_n57;
  t0_n56: return 0.0436660572886467f;
  t0_n57: return -0.036370277404785156f;
  t0_n58: return 0.1600474864244461f;
  t0_n59: return -0.1922399252653122f;
  t0_n60: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t0_n64;
  t0_n61: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t0_n63;
  t0_n62: return 0.17966283857822418f;
  t0_n63: return 0.09564231336116791f;
  t0_n64: return 0.17903363704681396f;
  t0_n65: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t0_n81;
  t0_n66: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t0_n78;
  t0_n67: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t0_n75;
  t0_n68: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t0_n72;
  t0_n69: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t0_n71;
  t0_n70: return 0.16343006491661072f;
  t0_n71: return 0.059975720942020416f;
  t0_n72: if (E.getNumReferences() >= 3359831936 /*199646.0*/) goto t0_n74;
  t0_n73: return 0.1975041776895523f;
  t0_n74: return 0.17443816363811493f;
  t0_n75: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t0_n77;
  t0_n76: return 0.039421748369932175f;
  t0_n77: return 0.19089017808437347f;
  t0_n78: if (E.getNumReferences() >= 3348712704 /*78490.0*/) goto t0_n80;
  t0_n79: return 0.09394174814224243f;
  t0_n80: return 0.1935829222202301f;
  t0_n81: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t0_n83;
  t0_n82: return 0.11955298483371735f;
  t0_n83: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t0_n87;
  t0_n84: if (E.getNumReferences() >= 3352594624 /*108817.5*/) goto t0_n86;
  t0_n85: return 0.17330411076545715f;
  t0_n86: return 0.1923811435699463f;
  t0_n87: return 0.196611225605011f;
  t0_n88: if (E.getFileProximityDistanceCost() >= 3256745984 /*39.5*/) goto t0_n158;
  t0_n89: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t0_n141;
  t0_n90: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t0_n122;
  t0_n91: if (E.getSymbolScopeDistanceCost() >= 3239051264 /*9.0*/) goto t0_n115;
  t0_n92: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t0_n104;
  t0_n93: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t0_n101;
  t0_n94: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t0_n98;
  t0_n95: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t0_n97;
  t0_n96: return 0.15734350681304932f;
  t0_n97: return 0.1247122511267662f;
  t0_n98: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t0_n100;
  t0_n99: return 0.18153995275497437f;
  t0_n100: return 0.1647741198539734f;
  t0_n101: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t0_n103;
  t0_n102: return 0.11501937359571457f;
  t0_n103: return 0.18159659206867218f;
  t0_n104: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t0_n110;
  t0_n105: if (E.getNumReferences() >= 3260416000 /*53.5*/) goto t0_n109;
  t0_n106: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t0_n108;
  t0_n107: return 0.18379583954811096f;
  t0_n108: return 0.1939573884010315f;
  t0_n109: return 0.19570596516132355f;
  t0_n110: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t0_n112;
  t0_n111: return 0.0991196259856224f;
  t0_n112: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t0_n114;
  t0_n113: return 0.18978017568588257f;
  t0_n114: return -0.20000000298023224f;
  t0_n115: if (E.getNumReferences() >= 3239575552 /*9.5*/) goto t0_n121;
  t0_n116: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t0_n118;
  t0_n117: return 0.10526332259178162f;
  t0_n118: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t0_n120;
  t0_n119: return 0.18847665190696716f;
  t0_n120: return 0.17364506423473358f;
  t0_n121: return 0.19471041858196259f;
  t0_n122: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t0_n132;
  t0_n123: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t0_n125;
  t0_n124: return 0.17943941056728363f;
  t0_n125: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t0_n129;
  t0_n126: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t0_n128;
  t0_n127: return 0.15801025927066803f;
  t0_n128: return 0.19034187495708466f;
  t0_n129: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t0_n131;
  t0_n130: return 0.19942399859428406f;
  t0_n131: return 0.1800059676170349f;
  t0_n132: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t0_n138;
  t0_n133: if (E.getNumReferences() >= 3332434432 /*20597.0*/) goto t0_n137;
  t0_n134: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t0_n136;
  t0_n135: return 0.1020292416214943f;
  t0_n136: return 0.18616393208503723f;
  t0_n137: return 0.19419915974140167f;
  t0_n138: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t0_n140;
  t0_n139: return 0.18478761613368988f;
  t0_n140: return 0.19306901097297668f;
  t0_n141: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t0_n157;
  t0_n142: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t0_n154;
  t0_n143: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t0_n149;
  t0_n144: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t0_n146;
  t0_n145: return 0.06863135099411011f;
  t0_n146: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t0_n148;
  t0_n147: return 0.09177519381046295f;
  t0_n148: return 0.16046667098999023f;
  t0_n149: if (E.getNumReferences() >= 3352510912 /*108163.5*/) goto t0_n153;
  t0_n150: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t0_n152;
  t0_n151: return 0.15973368287086487f;
  t0_n152: return 0.18605412542819977f;
  t0_n153: return -0.20000000298023224f;
  t0_n154: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t0_n156;
  t0_n155: return 0.1514042168855667f;
  t0_n156: return 0.1834273636341095f;
  t0_n157: return 0.19761313498020172f;
  t0_n158: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t0_n194;
  t0_n159: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t0_n161;
  t0_n160: return -0.1932513415813446f;
  t0_n161: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t0_n177;
  t0_n162: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t0_n166;
  t0_n163: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t0_n165;
  t0_n164: return -0.048965923488140106f;
  t0_n165: return 0.06573343276977539f;
  t0_n166: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t0_n176;
  t0_n167: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t0_n173;
  t0_n168: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t0_n170;
  t0_n169: return 0.03787053003907204f;
  t0_n170: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t0_n172;
  t0_n171: return 0.07951510697603226f;
  t0_n172: return 0.14633552730083466f;
  t0_n173: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t0_n175;
  t0_n174: return 0.1372806280851364f;
  t0_n175: return 0.19920119643211365f;
  t0_n176: return 0.14596906304359436f;
  t0_n177: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t0_n193;
  t0_n178: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t0_n188;
  t0_n179: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t0_n181;
  t0_n180: return 0.06330600380897522f;
  t0_n181: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t0_n187;
  t0_n182: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t0_n186;
  t0_n183: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t0_n185;
  t0_n184: return 0.14506708085536957f;
  t0_n185: return 0.1656939536333084f;
  t0_n186: return 0.10698114335536957f;
  t0_n187: return 0.1838480830192566f;
  t0_n188: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t0_n192;
  t0_n189: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t0_n191;
  t0_n190: return 0.1837356984615326f;
  t0_n191: return 0.13489769399166107f;
  t0_n192: return 0.1969956010580063f;
  t0_n193: return -0.19370104372501373f;
  t0_n194: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t0_n208;
  t0_n195: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t0_n205;
  t0_n196: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t0_n200;
  t0_n197: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t0_n199;
  t0_n198: return -0.19911359250545502f;
  t0_n199: return 0.008813080377876759f;
  t0_n200: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t0_n202;
  t0_n201: return 0.04461604356765747f;
  t0_n202: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t0_n204;
  t0_n203: return 0.19722077250480652f;
  t0_n204: return -0.15700146555900574f;
  t0_n205: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t0_n207;
  t0_n206: return 0.15436846017837524f;
  t0_n207: return 0.19539889693260193f;
  t0_n208: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t0_n232;
  t0_n209: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t0_n229;
  t0_n210: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t0_n216;
  t0_n211: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t0_n213;
  t0_n212: return -0.04543353617191315f;
  t0_n213: if (E.getFractionNameInContext() >= 3179562052 /*0.06458333134651184*/) goto t0_n215;
  t0_n214: return 0.09861121326684952f;
  t0_n215: return 0.17618303000926971f;
  t0_n216: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t0_n228;
  t0_n217: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t0_n219;
  t0_n218: return 0.13875418901443481f;
  t0_n219: if (E.getScope() & (BIT(Scope_type::FunctionScope)|BIT(Scope_type::GlobalScope))) goto t0_n221;
  t0_n220: return -0.13945826888084412f;
  t0_n221: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t0_n223;
  t0_n222: return -8.339667692780495e-05f;
  t0_n223: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t0_n227;
  t0_n224: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression))) goto t0_n226;
  t0_n225: return 0.06480171531438828f;
  t0_n226: return 0.16269299387931824f;
  t0_n227: return 0.09486537426710129f;
  t0_n228: return 0.17932546138763428f;
  t0_n229: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t0_n231;
  t0_n230: return 0.14165668189525604f;
  t0_n231: return 0.18670964241027832f;
  t0_n232: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t0_n236;
  t0_n233: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t0_n235;
  t0_n234: return 0.17782676219940186f;
  t0_n235: return 0.1604052633047104f;
  t0_n236: return 0.18952670693397522f;
  t0_n237: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t0_n243;
  t0_n238: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t0_n240;
  t0_n239: return 0.15890617668628693f;
  t0_n240: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t0_n242;
  t0_n241: return 0.1965150088071823f;
  t0_n242: return 0.14942441880702972f;
  t0_n243: return 0.19869807362556458f;
  t0_n244: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t0_n246;
  t0_n245: return 0.006307594478130341f;
  t0_n246: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t0_n254;
  t0_n247: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t0_n253;
  t0_n248: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t0_n250;
  t0_n249: return 0.19164785742759705f;
  t0_n250: if (E.getFractionNameInContext() >= 3190796208 /*0.1715686321258545*/) goto t0_n252;
  t0_n251: return 0.19516006112098694f;
  t0_n252: return 0.19298601150512695f;
  t0_n253: return -0.10492532700300217f;
  t0_n254: return 0.1970273107290268f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree1(const Example& E) {
  t1_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t1_n244;
  t1_n1: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t1_n237;
  t1_n2: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t1_n88;
  t1_n3: if (E.getNumReferences() >= 3343638400 /*52191.5*/) goto t1_n65;
  t1_n4: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t1_n36;
  t1_n5: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t1_n15;
  t1_n6: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t1_n10;
  t1_n7: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t1_n9;
  t1_n8: return 0.05864229425787926f;
  t1_n9: return -0.10569842904806137f;
  t1_n10: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t1_n14;
  t1_n11: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t1_n13;
  t1_n12: return 0.09925279021263123f;
  t1_n13: return 0.15963847935199738f;
  t1_n14: return 0.1503359079360962f;
  t1_n15: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t1_n31;
  t1_n16: if (E.getNumReferences() >= 3248226304 /*19.5*/) goto t1_n22;
  t1_n17: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t1_n21;
  t1_n18: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t1_n20;
  t1_n19: return -0.16126444935798645f;
  t1_n20: return -0.09174440056085587f;
  t1_n21: return 0.05892568081617355f;
  t1_n22: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t1_n26;
  t1_n23: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t1_n25;
  t1_n24: return -0.10753640532493591f;
  t1_n25: return 0.12494514882564545f;
  t1_n26: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t1_n30;
  t1_n27: if (E.getNumReferences() >= 3290980352 /*673.5*/) goto t1_n29;
  t1_n28: return 0.028882766142487526f;
  t1_n29: return 0.1169862225651741f;
  t1_n30: return 0.15312351286411285f;
  t1_n31: if (E.getNumReferences() >= 3290931200 /*670.5*/) goto t1_n33;
  t1_n32: return -0.15785080194473267f;
  t1_n33: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t1_n35;
  t1_n34: return -0.11045386642217636f;
  t1_n35: return 0.14530658721923828f;
  t1_n36: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t1_n44;
  t1_n37: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t1_n39;
  t1_n38: return -0.13928842544555664f;
  t1_n39: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t1_n41;
  t1_n40: return 0.14791369438171387f;
  t1_n41: if (E.getNumReferences() >= 3307436032 /*2615.5*/) goto t1_n43;
  t1_n42: return 0.010207350365817547f;
  t1_n43: return 0.1492609828710556f;
  t1_n44: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t1_n60;
  t1_n45: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t1_n59;
  t1_n46: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t1_n50;
  t1_n47: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t1_n49;
  t1_n48: return 0.0861087366938591f;
  t1_n49: return 0.1448994129896164f;
  t1_n50: if (E.getNumReferences() >= 3332389376 /*20509.0*/) goto t1_n58;
  t1_n51: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t1_n53;
  t1_n52: return 0.014164520427584648f;
  t1_n53: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t1_n55;
  t1_n54: return -0.0015365395229309797f;
  t1_n55: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t1_n57;
  t1_n56: return 0.17775259912014008f;
  t1_n57: return 0.15263903141021729f;
  t1_n58: return 0.15500111877918243f;
  t1_n59: return -0.1689857840538025f;
  t1_n60: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t1_n64;
  t1_n61: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t1_n63;
  t1_n62: return 0.1693732887506485f;
  t1_n63: return 0.11021314561367035f;
  t1_n64: return 0.1651707887649536f;
  t1_n65: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t1_n81;
  t1_n66: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t1_n78;
  t1_n67: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t1_n73;
  t1_n68: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t1_n72;
  t1_n69: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t1_n71;
  t1_n70: return 0.15608295798301697f;
  t1_n71: return 0.06868483871221542f;
  t1_n72: return 0.16499853134155273f;
  t1_n73: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t1_n77;
  t1_n74: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t1_n76;
  t1_n75: return -0.02576316148042679f;
  t1_n76: return 0.09417004138231277f;
  t1_n77: return 0.16653694212436676f;
  t1_n78: if (E.getNumReferences() >= 3348712704 /*78490.0*/) goto t1_n80;
  t1_n79: return 0.10624748468399048f;
  t1_n80: return 0.17000022530555725f;
  t1_n81: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t1_n83;
  t1_n82: return 0.12199915200471878f;
  t1_n83: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t1_n87;
  t1_n84: if (E.getNumReferences() >= 3352594624 /*108817.5*/) goto t1_n86;
  t1_n85: return 0.1616566777229309f;
  t1_n86: return 0.16865934431552887f;
  t1_n87: return 0.1725209802389145f;
  t1_n88: if (E.getFileProximityDistanceCost() >= 3256745984 /*39.5*/) goto t1_n170;
  t1_n89: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t1_n153;
  t1_n90: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t1_n130;
  t1_n91: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t1_n105;
  t1_n92: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t1_n102;
  t1_n93: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t1_n101;
  t1_n94: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t1_n98;
  t1_n95: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t1_n97;
  t1_n96: return 0.14982688426971436f;
  t1_n97: return 0.13161303102970123f;
  t1_n98: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t1_n100;
  t1_n99: return 0.16417934000492096f;
  t1_n100: return 0.1307990849018097f;
  t1_n101: return 0.1607930213212967f;
  t1_n102: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t1_n104;
  t1_n103: return 0.16888529062271118f;
  t1_n104: return 0.1604202538728714f;
  t1_n105: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t1_n125;
  t1_n106: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t1_n112;
  t1_n107: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t1_n109;
  t1_n108: return 0.12190522253513336f;
  t1_n109: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Statement))) goto t1_n111;
  t1_n110: return 0.04777759313583374f;
  t1_n111: return 0.16579733788967133f;
  t1_n112: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t1_n120;
  t1_n113: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t1_n119;
  t1_n114: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t1_n116;
  t1_n115: return 0.1560467630624771f;
  t1_n116: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t1_n118;
  t1_n117: return 0.15392252802848816f;
  t1_n118: return 0.16860151290893555f;
  t1_n119: return 0.17147164046764374f;
  t1_n120: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t1_n124;
  t1_n121: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t1_n123;
  t1_n122: return 0.1692265123128891f;
  t1_n123: return 0.1711229532957077f;
  t1_n124: return 0.16357260942459106f;
  t1_n125: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t1_n127;
  t1_n126: return 0.15169982612133026f;
  t1_n127: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t1_n129;
  t1_n128: return 0.16702626645565033f;
  t1_n129: return -0.175074964761734f;
  t1_n130: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t1_n150;
  t1_n131: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t1_n149;
  t1_n132: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t1_n144;
  t1_n133: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t1_n141;
  t1_n134: if (E.getNumReferences() >= 3348072384 /*73487.5*/) goto t1_n138;
  t1_n135: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t1_n137;
  t1_n136: return 0.16471685469150543f;
  t1_n137: return 0.15898099541664124f;
  t1_n138: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t1_n140;
  t1_n139: return 0.17276112735271454f;
  t1_n140: return 0.16352130472660065f;
  t1_n141: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t1_n143;
  t1_n142: return 0.13886868953704834f;
  t1_n143: return 0.16449801623821259f;
  t1_n144: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t1_n146;
  t1_n145: return 0.17154660820960999f;
  t1_n146: if (E.getNumReferences() >= 3316067328 /*5349.5*/) goto t1_n148;
  t1_n147: return 0.1671976000070572f;
  t1_n148: return 0.1694512814283371f;
  t1_n149: return 0.1682843267917633f;
  t1_n150: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t1_n152;
  t1_n151: return 0.16732017695903778f;
  t1_n152: return 0.1706983745098114f;
  t1_n153: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t1_n169;
  t1_n154: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t1_n160;
  t1_n155: if (E.getSymbolScopeDistanceCost() >= 3239051264 /*9.0*/) goto t1_n159;
  t1_n156: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t1_n158;
  t1_n157: return 0.08604030311107635f;
  t1_n158: return 0.14936451613903046f;
  t1_n159: return 0.1562318503856659f;
  t1_n160: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t1_n168;
  t1_n161: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t1_n163;
  t1_n162: return 0.10557645559310913f;
  t1_n163: if (E.getNumReferences() >= 3358365376 /*176731.0*/) goto t1_n167;
  t1_n164: if (E.getNumReferences() >= 3318322176 /*6450.5*/) goto t1_n166;
  t1_n165: return 0.152414470911026f;
  t1_n166: return 0.16552692651748657f;
  t1_n167: return -0.16779406368732452f;
  t1_n168: return 0.16632699966430664f;
  t1_n169: return 0.17045937478542328f;
  t1_n170: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t1_n208;
  t1_n171: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t1_n173;
  t1_n172: return -0.16870714724063873f;
  t1_n173: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t1_n191;
  t1_n174: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t1_n178;
  t1_n175: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t1_n177;
  t1_n176: return -0.07798636704683304f;
  t1_n177: return 0.08636608719825745f;
  t1_n178: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t1_n188;
  t1_n179: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t1_n185;
  t1_n180: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t1_n182;
  t1_n181: return 0.04533401504158974f;
  t1_n182: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t1_n184;
  t1_n183: return 0.10128161311149597f;
  t1_n184: return 0.1477314680814743f;
  t1_n185: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t1_n187;
  t1_n186: return 0.14149019122123718f;
  t1_n187: return 0.16968144476413727f;
  t1_n188: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression))) goto t1_n190;
  t1_n189: return 0.151018425822258f;
  t1_n190: return 0.16072402894496918f;
  t1_n191: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t1_n207;
  t1_n192: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t1_n202;
  t1_n193: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t1_n195;
  t1_n194: return 0.08147435635328293f;
  t1_n195: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t1_n201;
  t1_n196: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t1_n200;
  t1_n197: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t1_n199;
  t1_n198: return 0.14504404366016388f;
  t1_n199: return 0.15743094682693481f;
  t1_n200: return 0.12245187908411026f;
  t1_n201: return 0.16542880237102509f;
  t1_n202: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t1_n206;
  t1_n203: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t1_n205;
  t1_n204: return 0.15487730503082275f;
  t1_n205: return 0.16630683839321136f;
  t1_n206: return 0.16949501633644104f;
  t1_n207: return -0.1698521226644516f;
  t1_n208: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t1_n220;
  t1_n209: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t1_n217;
  t1_n210: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t1_n212;
  t1_n211: return -0.09946514666080475f;
  t1_n212: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t1_n214;
  t1_n213: return 0.03577881306409836f;
  t1_n214: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t1_n216;
  t1_n215: return 0.16909195482730865f;
  t1_n216: return -0.15543821454048157f;
  t1_n217: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t1_n219;
  t1_n218: return 0.13251914083957672f;
  t1_n219: return 0.16929800808429718f;
  t1_n220: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t1_n232;
  t1_n221: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t1_n225;
  t1_n222: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t1_n224;
  t1_n223: return 0.1044926792383194f;
  t1_n224: return 0.14694420993328094f;
  t1_n225: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t1_n231;
  t1_n226: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t1_n228;
  t1_n227: return -0.044721461832523346f;
  t1_n228: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t1_n230;
  t1_n229: return 0.13720722496509552f;
  t1_n230: return 0.16553179919719696f;
  t1_n231: return 0.16303226351737976f;
  t1_n232: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t1_n236;
  t1_n233: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t1_n235;
  t1_n234: return 0.16340629756450653f;
  t1_n235: return 0.15127478539943695f;
  t1_n236: return 0.16704440116882324f;
  t1_n237: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t1_n243;
  t1_n238: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t1_n240;
  t1_n239: return 0.15209516882896423f;
  t1_n240: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t1_n242;
  t1_n241: return 0.1707134246826172f;
  t1_n242: return 0.1531279981136322f;
  t1_n243: return 0.1713443547487259f;
  t1_n244: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t1_n246;
  t1_n245: return 0.02058301866054535f;
  t1_n246: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t1_n254;
  t1_n247: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t1_n251;
  t1_n248: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t1_n250;
  t1_n249: return 0.16857142746448517f;
  t1_n250: return -0.13122344017028809f;
  t1_n251: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t1_n253;
  t1_n252: return 0.16965043544769287f;
  t1_n253: return 0.16884683072566986f;
  t1_n254: return 0.17080119252204895f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree2(const Example& E) {
  t2_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t2_n244;
  t2_n1: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t2_n237;
  t2_n2: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t2_n92;
  t2_n3: if (E.getNumReferences() >= 3343638400 /*52191.5*/) goto t2_n69;
  t2_n4: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t2_n36;
  t2_n5: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t2_n15;
  t2_n6: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t2_n10;
  t2_n7: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t2_n9;
  t2_n8: return 0.046585436910390854f;
  t2_n9: return -0.08026197552680969f;
  t2_n10: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t2_n14;
  t2_n11: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t2_n13;
  t2_n12: return 0.07915130257606506f;
  t2_n13: return 0.13851292431354523f;
  t2_n14: return 0.12804220616817474f;
  t2_n15: if (E.getNumReferences() >= 3290980352 /*673.5*/) goto t2_n27;
  t2_n16: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t2_n26;
  t2_n17: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t2_n21;
  t2_n18: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t2_n20;
  t2_n19: return -0.14198435842990875f;
  t2_n20: return 0.05377653241157532f;
  t2_n21: if (E.getNumReferences() >= 3248226304 /*19.5*/) goto t2_n23;
  t2_n22: return -0.07909336686134338f;
  t2_n23: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t2_n25;
  t2_n24: return 0.026040226221084595f;
  t2_n25: return 0.13231100142002106f;
  t2_n26: return -0.14052613079547882f;
  t2_n27: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t2_n33;
  t2_n28: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t2_n32;
  t2_n29: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t2_n31;
  t2_n30: return -0.056663040071725845f;
  t2_n31: return 0.10488138347864151f;
  t2_n32: return -0.0789332166314125f;
  t2_n33: if (E.getNumReferences() >= 3332892672 /*21492.0*/) goto t2_n35;
  t2_n34: return 0.1106741651892662f;
  t2_n35: return 0.14635606110095978f;
  t2_n36: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t2_n44;
  t2_n37: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t2_n39;
  t2_n38: return -0.12101104110479355f;
  t2_n39: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t2_n41;
  t2_n40: return 0.12934809923171997f;
  t2_n41: if (E.getNumReferences() >= 3307436032 /*2615.5*/) goto t2_n43;
  t2_n42: return 0.0067842998541891575f;
  t2_n43: return 0.13125552237033844f;
  t2_n44: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t2_n64;
  t2_n45: if (E.getFractionNameInContext() >= 3177856917 /*0.057189542800188065*/) goto t2_n53;
  t2_n46: if (E.getNumReferences() >= 3236954112 /*7.5*/) goto t2_n48;
  t2_n47: return 0.006239415146410465f;
  t2_n48: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t2_n50;
  t2_n49: return 0.15282219648361206f;
  t2_n50: if (E.getNumReferences() >= 3332389376 /*20509.0*/) goto t2_n52;
  t2_n51: return 0.07543952763080597f;
  t2_n52: return 0.1397043913602829f;
  t2_n53: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t2_n57;
  t2_n54: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t2_n56;
  t2_n55: return 0.1287938803434372f;
  t2_n56: return -0.1471850723028183f;
  t2_n57: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t2_n61;
  t2_n58: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t2_n60;
  t2_n59: return 0.09584422409534454f;
  t2_n60: return 0.005734036210924387f;
  t2_n61: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t2_n63;
  t2_n62: return -0.05343735218048096f;
  t2_n63: return 0.15033230185508728f;
  t2_n64: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t2_n68;
  t2_n65: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t2_n67;
  t2_n66: return 0.15294736623764038f;
  t2_n67: return 0.09703253954648972f;
  t2_n68: return 0.14814265072345734f;
  t2_n69: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t2_n85;
  t2_n70: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t2_n82;
  t2_n71: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t2_n77;
  t2_n72: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t2_n76;
  t2_n73: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t2_n75;
  t2_n74: return 0.13854600489139557f;
  t2_n75: return 0.05823113024234772f;
  t2_n76: return 0.1471627652645111f;
  t2_n77: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t2_n81;
  t2_n78: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t2_n80;
  t2_n79: return -0.028328537940979004f;
  t2_n80: return 0.08673255890607834f;
  t2_n81: return 0.14768977463245392f;
  t2_n82: if (E.getNumReferences() >= 3348712704 /*78490.0*/) goto t2_n84;
  t2_n83: return 0.08953730762004852f;
  t2_n84: return 0.15202684700489044f;
  t2_n85: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t2_n87;
  t2_n86: return 0.10249080508947372f;
  t2_n87: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t2_n91;
  t2_n88: if (E.getNumReferences() >= 3352594624 /*108817.5*/) goto t2_n90;
  t2_n89: return 0.14352184534072876f;
  t2_n90: return 0.1506611406803131f;
  t2_n91: return 0.15508578717708588f;
  t2_n92: if (E.getFileProximityDistanceCost() >= 3256745984 /*39.5*/) goto t2_n170;
  t2_n93: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t2_n153;
  t2_n94: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t2_n130;
  t2_n95: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t2_n107;
  t2_n96: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t2_n104;
  t2_n97: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t2_n103;
  t2_n98: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t2_n100;
  t2_n99: return 0.12745007872581482f;
  t2_n100: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t2_n102;
  t2_n101: return 0.1455935537815094f;
  t2_n102: return 0.11362037062644958f;
  t2_n103: return 0.14222349226474762f;
  t2_n104: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t2_n106;
  t2_n105: return 0.15041328966617584f;
  t2_n106: return 0.14176741242408752f;
  t2_n107: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t2_n127;
  t2_n108: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t2_n114;
  t2_n109: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t2_n111;
  t2_n110: return 0.10420667380094528f;
  t2_n111: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Statement))) goto t2_n113;
  t2_n112: return 0.021743804216384888f;
  t2_n113: return 0.14680303633213043f;
  t2_n114: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t2_n122;
  t2_n115: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t2_n121;
  t2_n116: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t2_n118;
  t2_n117: return 0.13810108602046967f;
  t2_n118: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t2_n120;
  t2_n119: return 0.1365198940038681f;
  t2_n120: return 0.15012964606285095f;
  t2_n121: return 0.151300311088562f;
  t2_n122: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t2_n126;
  t2_n123: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t2_n125;
  t2_n124: return 0.1500474214553833f;
  t2_n125: return 0.15244720876216888f;
  t2_n126: return 0.144512340426445f;
  t2_n127: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t2_n129;
  t2_n128: return 0.13484029471874237f;
  t2_n129: return 0.14781226217746735f;
  t2_n130: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t2_n150;
  t2_n131: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t2_n149;
  t2_n132: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t2_n144;
  t2_n133: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t2_n141;
  t2_n134: if (E.getNumReferences() >= 3348072384 /*73487.5*/) goto t2_n138;
  t2_n135: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t2_n137;
  t2_n136: return 0.1464795470237732f;
  t2_n137: return 0.1409185230731964f;
  t2_n138: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t2_n140;
  t2_n139: return 0.15495337545871735f;
  t2_n140: return 0.14671483635902405f;
  t2_n141: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t2_n143;
  t2_n142: return 0.12058647722005844f;
  t2_n143: return 0.14545537531375885f;
  t2_n144: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t2_n146;
  t2_n145: return 0.15395553410053253f;
  t2_n146: if (E.getNumReferences() >= 3316067328 /*5349.5*/) goto t2_n148;
  t2_n147: return 0.14815135300159454f;
  t2_n148: return 0.15047454833984375f;
  t2_n149: return 0.14929066598415375f;
  t2_n150: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t2_n152;
  t2_n151: return 0.14835670590400696f;
  t2_n152: return 0.1516115516424179f;
  t2_n153: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t2_n169;
  t2_n154: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t2_n160;
  t2_n155: if (E.getSymbolScopeDistanceCost() >= 3239051264 /*9.0*/) goto t2_n159;
  t2_n156: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t2_n158;
  t2_n157: return 0.07251094281673431f;
  t2_n158: return 0.13211779296398163f;
  t2_n159: return 0.13767579197883606f;
  t2_n160: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t2_n168;
  t2_n161: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t2_n163;
  t2_n162: return 0.09247835725545883f;
  t2_n163: if (E.getNumReferences() >= 3358365376 /*176731.0*/) goto t2_n167;
  t2_n164: if (E.getNumReferences() >= 3318322176 /*6450.5*/) goto t2_n166;
  t2_n165: return 0.1341649442911148f;
  t2_n166: return 0.14664432406425476f;
  t2_n167: return -0.1486622542142868f;
  t2_n168: return 0.14859846234321594f;
  t2_n169: return 0.15215343236923218f;
  t2_n170: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t2_n208;
  t2_n171: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t2_n173;
  t2_n172: return -0.14995400607585907f;
  t2_n173: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t2_n191;
  t2_n174: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t2_n178;
  t2_n175: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t2_n177;
  t2_n176: return -0.06677867472171783f;
  t2_n177: return 0.07573500275611877f;
  t2_n178: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t2_n188;
  t2_n179: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t2_n185;
  t2_n180: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t2_n182;
  t2_n181: return 0.04241118207573891f;
  t2_n182: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t2_n184;
  t2_n183: return 0.0906544104218483f;
  t2_n184: return 0.13016828894615173f;
  t2_n185: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t2_n187;
  t2_n186: return 0.1250816136598587f;
  t2_n187: return 0.15090744197368622f;
  t2_n188: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression))) goto t2_n190;
  t2_n189: return 0.1378934383392334f;
  t2_n190: return 0.1413843184709549f;
  t2_n191: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t2_n207;
  t2_n192: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t2_n202;
  t2_n193: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t2_n195;
  t2_n194: return 0.06974995136260986f;
  t2_n195: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t2_n201;
  t2_n196: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t2_n200;
  t2_n197: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t2_n199;
  t2_n198: return 0.12677161395549774f;
  t2_n199: return 0.13914361596107483f;
  t2_n200: return 0.10487604886293411f;
  t2_n201: return 0.14650315046310425f;
  t2_n202: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t2_n206;
  t2_n203: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t2_n205;
  t2_n204: return 0.13627324998378754f;
  t2_n205: return 0.14791250228881836f;
  t2_n206: return 0.15074218809604645f;
  t2_n207: return -0.1516505777835846f;
  t2_n208: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t2_n220;
  t2_n209: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t2_n217;
  t2_n210: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t2_n212;
  t2_n211: return -0.09102858603000641f;
  t2_n212: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t2_n214;
  t2_n213: return 0.02203204482793808f;
  t2_n214: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t2_n216;
  t2_n215: return 0.15040287375450134f;
  t2_n216: return -0.14173327386379242f;
  t2_n217: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t2_n219;
  t2_n218: return 0.11469417065382004f;
  t2_n219: return 0.1504640132188797f;
  t2_n220: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t2_n232;
  t2_n221: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t2_n225;
  t2_n222: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t2_n224;
  t2_n223: return 0.09050043672323227f;
  t2_n224: return 0.1292455792427063f;
  t2_n225: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t2_n231;
  t2_n226: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t2_n228;
  t2_n227: return -0.04138435050845146f;
  t2_n228: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t2_n230;
  t2_n229: return 0.12220322340726852f;
  t2_n230: return 0.14674684405326843f;
  t2_n231: return 0.14500021934509277f;
  t2_n232: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t2_n236;
  t2_n233: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t2_n235;
  t2_n234: return 0.14494916796684265f;
  t2_n235: return 0.13270336389541626f;
  t2_n236: return 0.1485733985900879f;
  t2_n237: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t2_n243;
  t2_n238: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t2_n240;
  t2_n239: return 0.13365139067173004f;
  t2_n240: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t2_n242;
  t2_n241: return 0.15242359042167664f;
  t2_n242: return 0.1332457959651947f;
  t2_n243: return 0.15301726758480072f;
  t2_n244: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t2_n246;
  t2_n245: return 0.0189053937792778f;
  t2_n246: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t2_n254;
  t2_n247: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t2_n251;
  t2_n248: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t2_n250;
  t2_n249: return 0.1502094715833664f;
  t2_n250: return -0.11232098937034607f;
  t2_n251: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t2_n253;
  t2_n252: return 0.15126243233680725f;
  t2_n253: return 0.15046553313732147f;
  t2_n254: return 0.15229535102844238f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree3(const Example& E) {
  t3_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t3_n244;
  t3_n1: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t3_n237;
  t3_n2: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t3_n98;
  t3_n3: if (E.getNumReferences() >= 3343638400 /*52191.5*/) goto t3_n75;
  t3_n4: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t3_n36;
  t3_n5: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t3_n13;
  t3_n6: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t3_n10;
  t3_n7: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t3_n9;
  t3_n8: return 0.03923378139734268f;
  t3_n9: return -0.06926216185092926f;
  t3_n10: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t3_n12;
  t3_n11: return 0.07563339918851852f;
  t3_n12: return 0.11524554342031479f;
  t3_n13: if (E.getNumReferences() >= 3290980352 /*673.5*/) goto t3_n25;
  t3_n14: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t3_n18;
  t3_n15: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t3_n17;
  t3_n16: return -0.1375555396080017f;
  t3_n17: return -0.047991134226322174f;
  t3_n18: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t3_n24;
  t3_n19: if (E.getNumReferences() >= 3248226304 /*19.5*/) goto t3_n21;
  t3_n20: return -0.06922228634357452f;
  t3_n21: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t3_n23;
  t3_n22: return 0.024068892002105713f;
  t3_n23: return 0.11967655271291733f;
  t3_n24: return -0.11717651039361954f;
  t3_n25: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t3_n33;
  t3_n26: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t3_n32;
  t3_n27: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t3_n31;
  t3_n28: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t3_n30;
  t3_n29: return -0.04981289058923721f;
  t3_n30: return 0.090534508228302f;
  t3_n31: return -0.07225030660629272f;
  t3_n32: return 0.13320574164390564f;
  t3_n33: if (E.getNumReferences() >= 3332892672 /*21492.0*/) goto t3_n35;
  t3_n34: return 0.09868115186691284f;
  t3_n35: return 0.13387064635753632f;
  t3_n36: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t3_n44;
  t3_n37: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t3_n39;
  t3_n38: return -0.10744839906692505f;
  t3_n39: if (E.getNumReferences() >= 3307436032 /*2615.5*/) goto t3_n43;
  t3_n40: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t3_n42;
  t3_n41: return 0.11521003395318985f;
  t3_n42: return 0.005204482469707727f;
  t3_n43: return 0.1198052391409874f;
  t3_n44: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t3_n66;
  t3_n45: if (E.getFractionNameInContext() >= 3177025848 /*0.05409356951713562*/) goto t3_n55;
  t3_n46: if (E.getNumReferences() >= 3242721280 /*12.5*/) goto t3_n52;
  t3_n47: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t3_n51;
  t3_n48: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t3_n50;
  t3_n49: return 0.06424921751022339f;
  t3_n50: return -0.0016738876001909375f;
  t3_n51: return -0.1457492709159851f;
  t3_n52: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t3_n54;
  t3_n53: return 0.13960492610931396f;
  t3_n54: return 0.09588909894227982f;
  t3_n55: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t3_n59;
  t3_n56: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t3_n58;
  t3_n57: return 0.11726795136928558f;
  t3_n58: return -0.13461798429489136f;
  t3_n59: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t3_n63;
  t3_n60: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t3_n62;
  t3_n61: return 0.08398263901472092f;
  t3_n62: return -0.00013325239706318825f;
  t3_n63: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t3_n65;
  t3_n64: return -0.05175580084323883f;
  t3_n65: return 0.13521228730678558f;
  t3_n66: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t3_n72;
  t3_n67: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t3_n69;
  t3_n68: return 0.14159318804740906f;
  t3_n69: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t3_n71;
  t3_n70: return 0.13354851305484772f;
  t3_n71: return 0.07254661619663239f;
  t3_n72: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t3_n74;
  t3_n73: return 0.11944756656885147f;
  t3_n74: return 0.1405000239610672f;
  t3_n75: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t3_n91;
  t3_n76: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t3_n88;
  t3_n77: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t3_n83;
  t3_n78: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t3_n82;
  t3_n79: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t3_n81;
  t3_n80: return 0.1259843409061432f;
  t3_n81: return 0.05297345295548439f;
  t3_n82: return 0.134999617934227f;
  t3_n83: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t3_n87;
  t3_n84: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t3_n86;
  t3_n85: return -0.028413616120815277f;
  t3_n86: return 0.0757773369550705f;
  t3_n87: return 0.1352328360080719f;
  t3_n88: if (E.getNumReferences() >= 3348712704 /*78490.0*/) goto t3_n90;
  t3_n89: return 0.0798695757985115f;
  t3_n90: return 0.14022508263587952f;
  t3_n91: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t3_n93;
  t3_n92: return 0.09002068638801575f;
  t3_n93: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t3_n97;
  t3_n94: if (E.getNumReferences() >= 3352594624 /*108817.5*/) goto t3_n96;
  t3_n95: return 0.1312221884727478f;
  t3_n96: return 0.13870957493782043f;
  t3_n97: return 0.14349539577960968f;
  t3_n98: if (E.getFileProximityDistanceCost() >= 3256745984 /*39.5*/) goto t3_n172;
  t3_n99: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t3_n155;
  t3_n100: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t3_n132;
  t3_n101: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t3_n109;
  t3_n102: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t3_n106;
  t3_n103: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t3_n105;
  t3_n104: return 0.11798160523176193f;
  t3_n105: return 0.12928789854049683f;
  t3_n106: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t3_n108;
  t3_n107: return 0.13794782757759094f;
  t3_n108: return 0.12899604439735413f;
  t3_n109: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t3_n129;
  t3_n110: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t3_n116;
  t3_n111: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t3_n113;
  t3_n112: return 0.09215444326400757f;
  t3_n113: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Statement))) goto t3_n115;
  t3_n114: return 0.018928291276097298f;
  t3_n115: return 0.13420186936855316f;
  t3_n116: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t3_n124;
  t3_n117: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t3_n123;
  t3_n118: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t3_n120;
  t3_n119: return 0.12529897689819336f;
  t3_n120: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t3_n122;
  t3_n121: return 0.12508316338062286f;
  t3_n122: return 0.13786378502845764f;
  t3_n123: return 0.13811492919921875f;
  t3_n124: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t3_n128;
  t3_n125: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t3_n127;
  t3_n126: return 0.13723386824131012f;
  t3_n127: return 0.1401970386505127f;
  t3_n128: return 0.13127586245536804f;
  t3_n129: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t3_n131;
  t3_n130: return 0.12205123901367188f;
  t3_n131: return 0.13521887362003326f;
  t3_n132: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t3_n152;
  t3_n133: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t3_n151;
  t3_n134: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t3_n146;
  t3_n135: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t3_n143;
  t3_n136: if (E.getNumReferences() >= 3348072384 /*73487.5*/) goto t3_n140;
  t3_n137: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t3_n139;
  t3_n138: return 0.1341373324394226f;
  t3_n139: return 0.12846247851848602f;
  t3_n140: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t3_n142;
  t3_n141: return 0.143375962972641f;
  t3_n142: return 0.13550786674022675f;
  t3_n143: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t3_n145;
  t3_n144: return 0.10716212540864944f;
  t3_n145: return 0.13256163895130157f;
  t3_n146: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t3_n148;
  t3_n147: return 0.14199858903884888f;
  t3_n148: if (E.getNumReferences() >= 3317256192 /*5930.0*/) goto t3_n150;
  t3_n149: return 0.13554522395133972f;
  t3_n150: return 0.13807246088981628f;
  t3_n151: return 0.13682542741298676f;
  t3_n152: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t3_n154;
  t3_n153: return 0.13570816814899445f;
  t3_n154: return 0.13902103900909424f;
  t3_n155: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t3_n171;
  t3_n156: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t3_n162;
  t3_n157: if (E.getSymbolScopeDistanceCost() >= 3239051264 /*9.0*/) goto t3_n161;
  t3_n158: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t3_n160;
  t3_n159: return 0.06314817816019058f;
  t3_n160: return 0.11961252987384796f;
  t3_n161: return 0.12444785982370377f;
  t3_n162: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t3_n170;
  t3_n163: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t3_n165;
  t3_n164: return 0.08089909702539444f;
  t3_n165: if (E.getNumReferences() >= 3358365376 /*176731.0*/) goto t3_n169;
  t3_n166: if (E.getNumReferences() >= 3318322176 /*6450.5*/) goto t3_n168;
  t3_n167: return 0.12116461247205734f;
  t3_n168: return 0.1339026838541031f;
  t3_n169: return -0.1364395171403885f;
  t3_n170: return 0.13692551851272583f;
  t3_n171: return 0.14038771390914917f;
  t3_n172: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t3_n208;
  t3_n173: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t3_n175;
  t3_n174: return -0.13776852190494537f;
  t3_n175: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t3_n191;
  t3_n176: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t3_n180;
  t3_n177: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t3_n179;
  t3_n178: return -0.058771226555109024f;
  t3_n179: return 0.06741133332252502f;
  t3_n180: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t3_n190;
  t3_n181: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t3_n187;
  t3_n182: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t3_n184;
  t3_n183: return 0.03722731024026871f;
  t3_n184: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t3_n186;
  t3_n185: return 0.08181355893611908f;
  t3_n186: return 0.11761044710874557f;
  t3_n187: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t3_n189;
  t3_n188: return 0.08910182863473892f;
  t3_n189: return 0.1396014243364334f;
  t3_n190: return 0.12793539464473724f;
  t3_n191: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t3_n207;
  t3_n192: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t3_n202;
  t3_n193: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t3_n195;
  t3_n194: return 0.0601702556014061f;
  t3_n195: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t3_n201;
  t3_n196: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t3_n200;
  t3_n197: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t3_n199;
  t3_n198: return 0.11347981542348862f;
  t3_n199: return 0.12639573216438293f;
  t3_n200: return 0.0928204357624054f;
  t3_n201: return 0.13379442691802979f;
  t3_n202: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t3_n206;
  t3_n203: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t3_n205;
  t3_n204: return 0.12333247810602188f;
  t3_n205: return 0.13546068966388702f;
  t3_n206: return 0.13851186633110046f;
  t3_n207: return -0.13949863612651825f;
  t3_n208: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t3_n220;
  t3_n209: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t3_n217;
  t3_n210: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t3_n212;
  t3_n211: return -0.08323707431554794f;
  t3_n212: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t3_n214;
  t3_n213: return 0.02088886871933937f;
  t3_n214: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t3_n216;
  t3_n215: return 0.1381932944059372f;
  t3_n216: return -0.13304990530014038f;
  t3_n217: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t3_n219;
  t3_n218: return 0.10189694166183472f;
  t3_n219: return 0.1381164938211441f;
  t3_n220: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t3_n232;
  t3_n221: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t3_n225;
  t3_n222: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t3_n224;
  t3_n223: return 0.07897063344717026f;
  t3_n224: return 0.11651987582445145f;
  t3_n225: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t3_n231;
  t3_n226: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t3_n228;
  t3_n227: return -0.03606373816728592f;
  t3_n228: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t3_n230;
  t3_n229: return 0.10936389118432999f;
  t3_n230: return 0.13415446877479553f;
  t3_n231: return 0.13259655237197876f;
  t3_n232: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t3_n236;
  t3_n233: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t3_n235;
  t3_n234: return 0.13253413140773773f;
  t3_n235: return 0.1200137659907341f;
  t3_n236: return 0.136396124958992f;
  t3_n237: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t3_n243;
  t3_n238: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t3_n240;
  t3_n239: return 0.12059909105300903f;
  t3_n240: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t3_n242;
  t3_n241: return 0.14043724536895752f;
  t3_n242: return 0.12053101509809494f;
  t3_n243: return 0.14106890559196472f;
  t3_n244: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t3_n246;
  t3_n245: return 0.017146291211247444f;
  t3_n246: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t3_n254;
  t3_n247: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t3_n251;
  t3_n248: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t3_n250;
  t3_n249: return 0.13809612393379211f;
  t3_n250: return -0.09687822312116623f;
  t3_n251: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t3_n253;
  t3_n252: return 0.1392662674188614f;
  t3_n253: return 0.1384020298719406f;
  t3_n254: return 0.14027617871761322f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree4(const Example& E) {
  t4_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t4_n244;
  t4_n1: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t4_n237;
  t4_n2: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t4_n100;
  t4_n3: if (E.getNumReferences() >= 3343638400 /*52191.5*/) goto t4_n77;
  t4_n4: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t4_n42;
  t4_n5: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t4_n17;
  t4_n6: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t4_n14;
  t4_n7: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t4_n13;
  t4_n8: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t4_n10;
  t4_n9: return -0.0039026245940476656f;
  t4_n10: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t4_n12;
  t4_n11: return 0.0292171873152256f;
  t4_n12: return 0.1009465679526329f;
  t4_n13: return -0.0604998841881752f;
  t4_n14: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t4_n16;
  t4_n15: return 0.06604607403278351f;
  t4_n16: return 0.10512399673461914f;
  t4_n17: if (E.getNumReferences() >= 3290980352 /*673.5*/) goto t4_n31;
  t4_n18: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t4_n24;
  t4_n19: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t4_n21;
  t4_n20: return -0.12901060283184052f;
  t4_n21: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t4_n23;
  t4_n22: return 0.048817507922649384f;
  t4_n23: return -0.061059415340423584f;
  t4_n24: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t4_n30;
  t4_n25: if (E.getNumReferences() >= 3248226304 /*19.5*/) goto t4_n27;
  t4_n26: return -0.0613226443529129f;
  t4_n27: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t4_n29;
  t4_n28: return 0.020388251170516014f;
  t4_n29: return 0.10966802388429642f;
  t4_n30: return -0.10738255828619003f;
  t4_n31: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t4_n39;
  t4_n32: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t4_n38;
  t4_n33: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t4_n35;
  t4_n34: return -0.06717780977487564f;
  t4_n35: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t4_n37;
  t4_n36: return -0.03535696119070053f;
  t4_n37: return 0.0649673193693161f;
  t4_n38: return 0.12601225078105927f;
  t4_n39: if (E.getNumReferences() >= 3332892672 /*21492.0*/) goto t4_n41;
  t4_n40: return 0.08869346976280212f;
  t4_n41: return 0.1248442754149437f;
  t4_n42: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t4_n50;
  t4_n43: if (E.getNumReferences() >= 3307436032 /*2615.5*/) goto t4_n49;
  t4_n44: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t4_n46;
  t4_n45: return -0.09852996468544006f;
  t4_n46: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t4_n48;
  t4_n47: return 0.09921697527170181f;
  t4_n48: return -0.0021524596959352493f;
  t4_n49: return 0.11546836793422699f;
  t4_n50: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t4_n68;
  t4_n51: if (E.getFractionNameInContext() >= 3177856917 /*0.057189542800188065*/) goto t4_n57;
  t4_n52: if (E.getNumReferences() >= 3236954112 /*7.5*/) goto t4_n54;
  t4_n53: return 0.000680825556628406f;
  t4_n54: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t4_n56;
  t4_n55: return 0.12783223390579224f;
  t4_n56: return 0.08461324870586395f;
  t4_n57: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t4_n61;
  t4_n58: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t4_n60;
  t4_n59: return 0.10816715657711029f;
  t4_n60: return -0.12507084012031555f;
  t4_n61: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t4_n65;
  t4_n62: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t4_n64;
  t4_n63: return 0.07378796488046646f;
  t4_n64: return 0.010963642038404942f;
  t4_n65: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t4_n67;
  t4_n66: return -0.04847811162471771f;
  t4_n67: return 0.12381131947040558f;
  t4_n68: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t4_n74;
  t4_n69: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t4_n71;
  t4_n70: return 0.13345526158809662f;
  t4_n71: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t4_n73;
  t4_n72: return 0.12494406849145889f;
  t4_n73: return 0.06688376516103745f;
  t4_n74: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t4_n76;
  t4_n75: return 0.10966937243938446f;
  t4_n76: return 0.131972536444664f;
  t4_n77: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t4_n93;
  t4_n78: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t4_n90;
  t4_n79: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t4_n85;
  t4_n80: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t4_n84;
  t4_n81: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t4_n83;
  t4_n82: return 0.11612967401742935f;
  t4_n83: return 0.046420253813266754f;
  t4_n84: return 0.12601648271083832f;
  t4_n85: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t4_n89;
  t4_n86: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t4_n88;
  t4_n87: return -0.024922605603933334f;
  t4_n88: return 0.06578359007835388f;
  t4_n89: return 0.1261170506477356f;
  t4_n90: if (E.getNumReferences() >= 3348712704 /*78490.0*/) goto t4_n92;
  t4_n91: return 0.07471520453691483f;
  t4_n92: return 0.1319267302751541f;
  t4_n93: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t4_n95;
  t4_n94: return 0.07883468270301819f;
  t4_n95: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel))) goto t4_n99;
  t4_n96: if (E.getNumReferences() >= 3364454096 /*281590.5*/) goto t4_n98;
  t4_n97: return 0.12681595981121063f;
  t4_n98: return 0.13269546627998352f;
  t4_n99: return 0.13991065323352814f;
  t4_n100: if (E.getFileProximityDistanceCost() >= 3256745984 /*39.5*/) goto t4_n172;
  t4_n101: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t4_n155;
  t4_n102: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t4_n134;
  t4_n103: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t4_n111;
  t4_n104: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t4_n108;
  t4_n105: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t4_n107;
  t4_n106: return 0.10796602070331573f;
  t4_n107: return 0.1202448382973671f;
  t4_n108: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t4_n110;
  t4_n109: return 0.1290421485900879f;
  t4_n110: return 0.11950986087322235f;
  t4_n111: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t4_n131;
  t4_n112: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t4_n118;
  t4_n113: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t4_n115;
  t4_n114: return 0.0817975178360939f;
  t4_n115: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t4_n117;
  t4_n116: return -0.22471219301223755f;
  t4_n117: return 0.12516458332538605f;
  t4_n118: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t4_n126;
  t4_n119: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t4_n125;
  t4_n120: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t4_n122;
  t4_n121: return 0.11542798578739166f;
  t4_n122: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t4_n124;
  t4_n123: return 0.11523205041885376f;
  t4_n124: return 0.12905703485012054f;
  t4_n125: return 0.1289408951997757f;
  t4_n126: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t4_n130;
  t4_n127: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t4_n129;
  t4_n128: return 0.1279810667037964f;
  t4_n129: return 0.13146726787090302f;
  t4_n130: return 0.1215856671333313f;
  t4_n131: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t4_n133;
  t4_n132: return 0.11235614120960236f;
  t4_n133: return 0.1261405348777771f;
  t4_n134: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t4_n152;
  t4_n135: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t4_n151;
  t4_n136: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t4_n146;
  t4_n137: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t4_n143;
  t4_n138: if (E.getNumReferences() >= 3348072384 /*73487.5*/) goto t4_n142;
  t4_n139: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t4_n141;
  t4_n140: return 0.12506374716758728f;
  t4_n141: return 0.11906753480434418f;
  t4_n142: return 0.13390423357486725f;
  t4_n143: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t4_n145;
  t4_n144: return 0.09634672850370407f;
  t4_n145: return 0.12310579419136047f;
  t4_n146: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t4_n148;
  t4_n147: return 0.1334737092256546f;
  t4_n148: if (E.getNumReferences() >= 3317256192 /*5930.0*/) goto t4_n150;
  t4_n149: return 0.12648600339889526f;
  t4_n150: return 0.12938199937343597f;
  t4_n151: return 0.12807393074035645f;
  t4_n152: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t4_n154;
  t4_n153: return 0.13225343823432922f;
  t4_n154: return 0.12733213603496552f;
  t4_n155: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t4_n171;
  t4_n156: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t4_n162;
  t4_n157: if (E.getSymbolScopeDistanceCost() >= 3239051264 /*9.0*/) goto t4_n161;
  t4_n158: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t4_n160;
  t4_n159: return 0.053574319928884506f;
  t4_n160: return 0.11103085428476334f;
  t4_n161: return 0.11490809172391891f;
  t4_n162: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t4_n170;
  t4_n163: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t4_n165;
  t4_n164: return 0.07258813083171844f;
  t4_n165: if (E.getNumReferences() >= 3358365376 /*176731.0*/) goto t4_n169;
  t4_n166: if (E.getNumReferences() >= 3318322176 /*6450.5*/) goto t4_n168;
  t4_n167: return 0.11101918667554855f;
  t4_n168: return 0.12466850876808167f;
  t4_n169: return -0.12790387868881226f;
  t4_n170: return 0.12822479009628296f;
  t4_n171: return 0.13216887414455414f;
  t4_n172: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t4_n208;
  t4_n173: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t4_n175;
  t4_n174: return -0.12925612926483154f;
  t4_n175: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t4_n191;
  t4_n176: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t4_n180;
  t4_n177: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t4_n179;
  t4_n178: return -0.05188321694731712f;
  t4_n179: return 0.06102824956178665f;
  t4_n180: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t4_n190;
  t4_n181: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t4_n187;
  t4_n182: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t4_n184;
  t4_n183: return 0.03326258808374405f;
  t4_n184: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t4_n186;
  t4_n185: return 0.07453133910894394f;
  t4_n186: return 0.10729032009840012f;
  t4_n187: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t4_n189;
  t4_n188: return 0.07936863601207733f;
  t4_n189: return 0.13099399209022522f;
  t4_n190: return 0.1198098435997963f;
  t4_n191: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t4_n207;
  t4_n192: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t4_n202;
  t4_n193: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t4_n195;
  t4_n194: return 0.05169079452753067f;
  t4_n195: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t4_n201;
  t4_n196: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t4_n200;
  t4_n197: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t4_n199;
  t4_n198: return 0.10297778248786926f;
  t4_n199: return 0.11692527681589127f;
  t4_n200: return 0.08279073983430862f;
  t4_n201: return 0.12500230967998505f;
  t4_n202: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t4_n206;
  t4_n203: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t4_n205;
  t4_n204: return 0.1134251058101654f;
  t4_n205: return 0.12667934596538544f;
  t4_n206: return 0.13009746372699738f;
  t4_n207: return -0.13110211491584778f;
  t4_n208: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t4_n220;
  t4_n209: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t4_n217;
  t4_n210: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t4_n212;
  t4_n211: return -0.08033233880996704f;
  t4_n212: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t4_n214;
  t4_n213: return 0.019855936989188194f;
  t4_n214: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t4_n216;
  t4_n215: return 0.12961725890636444f;
  t4_n216: return -0.12008111923933029f;
  t4_n217: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t4_n219;
  t4_n218: return 0.09035993367433548f;
  t4_n219: return 0.12928181886672974f;
  t4_n220: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t4_n232;
  t4_n221: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t4_n225;
  t4_n222: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t4_n224;
  t4_n223: return 0.06944558024406433f;
  t4_n224: return 0.10598810017108917f;
  t4_n225: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t4_n231;
  t4_n226: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t4_n228;
  t4_n227: return -0.029426006600260735f;
  t4_n228: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t4_n230;
  t4_n229: return 0.09922802448272705f;
  t4_n230: return 0.12568232417106628f;
  t4_n231: return 0.12354519218206406f;
  t4_n232: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t4_n236;
  t4_n233: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t4_n235;
  t4_n234: return 0.12349254637956619f;
  t4_n235: return 0.11018656194210052f;
  t4_n236: return 0.1277197301387787f;
  t4_n237: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t4_n243;
  t4_n238: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t4_n240;
  t4_n239: return 0.11145352572202682f;
  t4_n240: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t4_n242;
  t4_n241: return 0.1320129930973053f;
  t4_n242: return 0.11011315137147903f;
  t4_n243: return 0.13273310661315918f;
  t4_n244: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t4_n246;
  t4_n245: return 0.01475172396749258f;
  t4_n246: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t4_n254;
  t4_n247: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t4_n251;
  t4_n248: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t4_n250;
  t4_n249: return 0.12964262068271637f;
  t4_n250: return -0.0848785787820816f;
  t4_n251: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t4_n253;
  t4_n252: return 0.130961611866951f;
  t4_n253: return 0.1300591379404068f;
  t4_n254: return 0.13218621909618378f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree5(const Example& E) {
  t5_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t5_n244;
  t5_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t5_n229;
  t5_n2: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t5_n86;
  t5_n3: if (E.getNumReferences() >= 3332525568 /*20775.0*/) goto t5_n71;
  t5_n4: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t5_n36;
  t5_n5: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t5_n17;
  t5_n6: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t5_n14;
  t5_n7: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t5_n9;
  t5_n8: return -0.03867683932185173f;
  t5_n9: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t5_n11;
  t5_n10: return 0.012622897513210773f;
  t5_n11: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t5_n13;
  t5_n12: return 0.09230829775333405f;
  t5_n13: return 0.03323188051581383f;
  t5_n14: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t5_n16;
  t5_n15: return 0.058409433811903f;
  t5_n16: return 0.09626113623380661f;
  t5_n17: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t5_n25;
  t5_n18: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t5_n20;
  t5_n19: return -0.12005627155303955f;
  t5_n20: if (E.getNumReferences() >= 3306559488 /*2401.5*/) goto t5_n24;
  t5_n21: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t5_n23;
  t5_n22: return -0.05616729333996773f;
  t5_n23: return 0.04615847393870354f;
  t5_n24: return 0.09073173999786377f;
  t5_n25: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t5_n35;
  t5_n26: if (E.getNumReferences() >= 3272835072 /*147.5*/) goto t5_n32;
  t5_n27: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t5_n29;
  t5_n28: return -0.053000837564468384f;
  t5_n29: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t5_n31;
  t5_n30: return 0.005759749095886946f;
  t5_n31: return 0.09917016327381134f;
  t5_n32: if (E.getFractionNameInContext() >= 3183996031 /*0.09761904925107956*/) goto t5_n34;
  t5_n33: return 0.053068507462739944f;
  t5_n34: return 0.10478129237890244f;
  t5_n35: return -0.09577184915542603f;
  t5_n36: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t5_n64;
  t5_n37: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t5_n45;
  t5_n38: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t5_n40;
  t5_n39: return -0.09242434799671173f;
  t5_n40: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t5_n42;
  t5_n41: return 0.0917908325791359f;
  t5_n42: if (E.getNumReferences() >= 3307290624 /*2580.0*/) goto t5_n44;
  t5_n43: return -0.005003747530281544f;
  t5_n44: return 0.09531768411397934f;
  t5_n45: if (E.getFractionNameInContext() >= 3177025848 /*0.05409356951713562*/) goto t5_n53;
  t5_n46: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t5_n52;
  t5_n47: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t5_n49;
  t5_n48: return 0.05712578445672989f;
  t5_n49: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t5_n51;
  t5_n50: return 0.015538726933300495f;
  t5_n51: return -0.07188466936349869f;
  t5_n52: return -0.13263936340808868f;
  t5_n53: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t5_n57;
  t5_n54: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t5_n56;
  t5_n55: return 0.10010846704244614f;
  t5_n56: return -0.11828798055648804f;
  t5_n57: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t5_n61;
  t5_n58: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t5_n60;
  t5_n59: return 0.06585148721933365f;
  t5_n60: return 0.007898946292698383f;
  t5_n61: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t5_n63;
  t5_n62: return -0.04686686396598816f;
  t5_n63: return 0.11538015305995941f;
  t5_n64: if (E.getContextKind() & (BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t5_n68;
  t5_n65: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t5_n67;
  t5_n66: return 0.06468965113162994f;
  t5_n67: return 0.13672983646392822f;
  t5_n68: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t5_n70;
  t5_n69: return 0.10344748944044113f;
  t5_n70: return 0.1247379332780838f;
  t5_n71: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t5_n81;
  t5_n72: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t5_n80;
  t5_n73: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t5_n77;
  t5_n74: if (E.getFractionNameInContext() >= 3179562052 /*0.06458333134651184*/) goto t5_n76;
  t5_n75: return -0.005176777485758066f;
  t5_n76: return 0.09518218040466309f;
  t5_n77: if (E.getNumReferences() >= 3344974336 /*57410.0*/) goto t5_n79;
  t5_n78: return 0.06327199935913086f;
  t5_n79: return 0.100596584379673f;
  t5_n80: return 0.1220708116889f;
  t5_n81: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t5_n83;
  t5_n82: return 0.10937154293060303f;
  t5_n83: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t5_n85;
  t5_n84: return 0.11830742657184601f;
  t5_n85: return 0.1310049146413803f;
  t5_n86: if (E.getFileProximityDistanceCost() >= 3256745984 /*39.5*/) goto t5_n158;
  t5_n87: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t5_n141;
  t5_n88: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t5_n120;
  t5_n89: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t5_n97;
  t5_n90: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t5_n94;
  t5_n91: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t5_n93;
  t5_n92: return 0.09966325014829636f;
  t5_n93: return 0.1128840520977974f;
  t5_n94: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t5_n96;
  t5_n95: return 0.1226276233792305f;
  t5_n96: return 0.11189378798007965f;
  t5_n97: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t5_n117;
  t5_n98: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t5_n104;
  t5_n99: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t5_n101;
  t5_n100: return 0.06253930181264877f;
  t5_n101: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t5_n103;
  t5_n102: return -0.197727233171463f;
  t5_n103: return 0.11849427968263626f;
  t5_n104: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t5_n112;
  t5_n105: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t5_n111;
  t5_n106: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t5_n110;
  t5_n107: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t5_n109;
  t5_n108: return 0.10919875651597977f;
  t5_n109: return 0.12216728180646896f;
  t5_n110: return 0.12197421491146088f;
  t5_n111: return 0.09808104485273361f;
  t5_n112: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t5_n116;
  t5_n113: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t5_n115;
  t5_n114: return 0.12112551927566528f;
  t5_n115: return 0.12514518201351166f;
  t5_n116: return 0.12131305038928986f;
  t5_n117: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t5_n119;
  t5_n118: return 0.10453781485557556f;
  t5_n119: return 0.11929851770401001f;
  t5_n120: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t5_n138;
  t5_n121: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t5_n137;
  t5_n122: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t5_n134;
  t5_n123: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t5_n131;
  t5_n124: if (E.getNumReferences() >= 3348072384 /*73487.5*/) goto t5_n130;
  t5_n125: if (E.getNumReferences() >= 3238526976 /*8.5*/) goto t5_n127;
  t5_n126: return 0.10889916121959686f;
  t5_n127: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t5_n129;
  t5_n128: return 0.10037854313850403f;
  t5_n129: return 0.11950811743736267f;
  t5_n130: return 0.1271876096725464f;
  t5_n131: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t5_n133;
  t5_n132: return 0.09116452932357788f;
  t5_n133: return 0.11597698926925659f;
  t5_n134: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t5_n136;
  t5_n135: return 0.12727753818035126f;
  t5_n136: return 0.12167051434516907f;
  t5_n137: return 0.12161250412464142f;
  t5_n138: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t5_n140;
  t5_n139: return 0.12598246335983276f;
  t5_n140: return 0.1206311360001564f;
  t5_n141: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t5_n157;
  t5_n142: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t5_n148;
  t5_n143: if (E.getSymbolScopeDistanceCost() >= 3239051264 /*9.0*/) goto t5_n147;
  t5_n144: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t5_n146;
  t5_n145: return 0.046348053961992264f;
  t5_n146: return 0.10321896523237228f;
  t5_n147: return 0.10691967606544495f;
  t5_n148: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t5_n156;
  t5_n149: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t5_n151;
  t5_n150: return 0.0658111572265625f;
  t5_n151: if (E.getNumReferences() >= 3358365376 /*176731.0*/) goto t5_n155;
  t5_n152: if (E.getNumReferences() >= 3318322176 /*6450.5*/) goto t5_n154;
  t5_n153: return 0.10296797752380371f;
  t5_n154: return 0.11768489331007004f;
  t5_n155: return -0.1219232901930809f;
  t5_n156: return 0.1219838336110115f;
  t5_n157: return 0.12637147307395935f;
  t5_n158: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t5_n200;
  t5_n159: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t5_n161;
  t5_n160: return -0.12311381846666336f;
  t5_n161: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t5_n185;
  t5_n162: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t5_n174;
  t5_n163: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t5_n173;
  t5_n164: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t5_n166;
  t5_n165: return -0.06090119853615761f;
  t5_n166: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t5_n170;
  t5_n167: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t5_n169;
  t5_n168: return 0.06055036187171936f;
  t5_n169: return -0.1448560357093811f;
  t5_n170: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t5_n172;
  t5_n171: return 0.052775271236896515f;
  t5_n172: return 0.16989587247371674f;
  t5_n173: return 0.05509134382009506f;
  t5_n174: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t5_n184;
  t5_n175: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t5_n181;
  t5_n176: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t5_n178;
  t5_n177: return 0.03006095066666603f;
  t5_n178: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t5_n180;
  t5_n179: return 0.06876885890960693f;
  t5_n180: return 0.09961062669754028f;
  t5_n181: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t5_n183;
  t5_n182: return 0.07118076831102371f;
  t5_n183: return 0.1242576539516449f;
  t5_n184: return 0.11258705705404282f;
  t5_n185: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t5_n199;
  t5_n186: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t5_n198;
  t5_n187: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t5_n191;
  t5_n188: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t5_n190;
  t5_n189: return 0.022949177771806717f;
  t5_n190: return 0.1128898486495018f;
  t5_n191: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t5_n197;
  t5_n192: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t5_n196;
  t5_n193: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t5_n195;
  t5_n194: return 0.09456247836351395f;
  t5_n195: return 0.10921084880828857f;
  t5_n196: return 0.07377047091722488f;
  t5_n197: return 0.11815059930086136f;
  t5_n198: return 0.11629904806613922f;
  t5_n199: return -0.12502261996269226f;
  t5_n200: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t5_n212;
  t5_n201: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t5_n209;
  t5_n202: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t5_n204;
  t5_n203: return -0.07612906396389008f;
  t5_n204: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t5_n206;
  t5_n205: return 0.019841529428958893f;
  t5_n206: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t5_n208;
  t5_n207: return 0.123448446393013f;
  t5_n208: return -0.11843422800302505f;
  t5_n209: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t5_n211;
  t5_n210: return 0.08187846094369888f;
  t5_n211: return 0.12301783263683319f;
  t5_n212: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t5_n224;
  t5_n213: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t5_n217;
  t5_n214: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t5_n216;
  t5_n215: return 0.061413273215293884f;
  t5_n216: return 0.09825242310762405f;
  t5_n217: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t5_n223;
  t5_n218: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t5_n220;
  t5_n219: return -0.02601718157529831f;
  t5_n220: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t5_n222;
  t5_n221: return 0.09026645869016647f;
  t5_n222: return 0.11904612928628922f;
  t5_n223: return 0.11661208420991898f;
  t5_n224: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t5_n228;
  t5_n225: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t5_n227;
  t5_n226: return 0.11664862185716629f;
  t5_n227: return 0.10152636468410492f;
  t5_n228: return 0.12133148312568665f;
  t5_n229: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t5_n237;
  t5_n230: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t5_n236;
  t5_n231: if (E.getNumReferences() >= 3364994640 /*298482.5*/) goto t5_n235;
  t5_n232: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t5_n234;
  t5_n233: return 0.1122320368885994f;
  t5_n234: return 0.1274237185716629f;
  t5_n235: return 0.041670821607112885f;
  t5_n236: return 0.12684358656406403f;
  t5_n237: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t5_n243;
  t5_n238: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t5_n240;
  t5_n239: return 0.10269111394882202f;
  t5_n240: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t5_n242;
  t5_n241: return 0.12587934732437134f;
  t5_n242: return 0.10176095366477966f;
  t5_n243: return 0.12677042186260223f;
  t5_n244: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t5_n246;
  t5_n245: return 0.013267513364553452f;
  t5_n246: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t5_n254;
  t5_n247: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t5_n251;
  t5_n248: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t5_n250;
  t5_n249: return 0.12337252497673035f;
  t5_n250: return -0.07567253708839417f;
  t5_n251: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t5_n253;
  t5_n252: return 0.12492799013853073f;
  t5_n253: return 0.12394796311855316f;
  t5_n254: return 0.12633147835731506f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree6(const Example& E) {
  t6_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t6_n246;
  t6_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t6_n231;
  t6_n2: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t6_n92;
  t6_n3: if (E.getNumReferences() >= 3332525568 /*20775.0*/) goto t6_n71;
  t6_n4: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t6_n48;
  t6_n5: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t6_n25;
  t6_n6: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t6_n14;
  t6_n7: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t6_n11;
  t6_n8: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t6_n10;
  t6_n9: return -0.05275452509522438f;
  t6_n10: return 0.06824968755245209f;
  t6_n11: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t6_n13;
  t6_n12: return -0.005396819673478603f;
  t6_n13: return 0.06953218579292297f;
  t6_n14: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t6_n20;
  t6_n15: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t6_n17;
  t6_n16: return -0.11611585319042206f;
  t6_n17: if (E.getNumReferences() >= 3306559488 /*2401.5*/) goto t6_n19;
  t6_n18: return -0.03576504439115524f;
  t6_n19: return 0.08532412350177765f;
  t6_n20: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t6_n24;
  t6_n21: if (E.getNumReferences() >= 3272835072 /*147.5*/) goto t6_n23;
  t6_n22: return -0.04978378117084503f;
  t6_n23: return 0.06300879269838333f;
  t6_n24: return -0.0918155387043953f;
  t6_n25: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t6_n31;
  t6_n26: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t6_n28;
  t6_n27: return -0.08499255031347275f;
  t6_n28: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t6_n30;
  t6_n29: return 0.08536478877067566f;
  t6_n30: return 0.0009990063263103366f;
  t6_n31: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t6_n39;
  t6_n32: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t6_n34;
  t6_n33: return -0.006745863705873489f;
  t6_n34: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t6_n36;
  t6_n35: return -0.015131774358451366f;
  t6_n36: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t6_n38;
  t6_n37: return 0.12490229308605194f;
  t6_n38: return 0.09432626515626907f;
  t6_n39: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t6_n43;
  t6_n40: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t6_n42;
  t6_n41: return 0.0940069928765297f;
  t6_n42: return -0.11254339665174484f;
  t6_n43: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t6_n45;
  t6_n44: return 0.029358793050050735f;
  t6_n45: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t6_n47;
  t6_n46: return -0.041714493185281754f;
  t6_n47: return 0.10808639228343964f;
  t6_n48: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t6_n64;
  t6_n49: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t6_n59;
  t6_n50: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t6_n56;
  t6_n51: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t6_n55;
  t6_n52: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t6_n54;
  t6_n53: return 0.0658392459154129f;
  t6_n54: return 0.1148306354880333f;
  t6_n55: return 0.010585331358015537f;
  t6_n56: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t6_n58;
  t6_n57: return 0.08605583012104034f;
  t6_n58: return 0.11804854869842529f;
  t6_n59: if (E.getNumReferences() >= 3293208576 /*809.5*/) goto t6_n63;
  t6_n60: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t6_n62;
  t6_n61: return -0.053400669246912f;
  t6_n62: return 0.08736086636781693f;
  t6_n63: return 0.11483436077833176f;
  t6_n64: if (E.getContextKind() & (BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement))) goto t6_n68;
  t6_n65: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t6_n67;
  t6_n66: return 0.0729563981294632f;
  t6_n67: return 0.13361084461212158f;
  t6_n68: if (E.getFileProximityDistanceCost() >= 3242721280 /*12.5*/) goto t6_n70;
  t6_n69: return 0.09484327584505081f;
  t6_n70: return 0.12096944451332092f;
  t6_n71: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t6_n87;
  t6_n72: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t6_n86;
  t6_n73: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t6_n77;
  t6_n74: if (E.getFractionNameInContext() >= 3179562052 /*0.06458333134651184*/) goto t6_n76;
  t6_n75: return -0.0013135613407939672f;
  t6_n76: return 0.09381265193223953f;
  t6_n77: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t6_n83;
  t6_n78: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t6_n82;
  t6_n79: if (E.getNumReferences() >= 3348072384 /*73487.5*/) goto t6_n81;
  t6_n80: return 0.0891069695353508f;
  t6_n81: return 0.10602197796106339f;
  t6_n82: return 0.03912288323044777f;
  t6_n83: if (E.getNumReferences() >= 3361959232 /*232885.0*/) goto t6_n85;
  t6_n84: return 0.11842267215251923f;
  t6_n85: return 0.06042105332016945f;
  t6_n86: return 0.11670512706041336f;
  t6_n87: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t6_n89;
  t6_n88: return 0.10246049612760544f;
  t6_n89: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t6_n91;
  t6_n90: return 0.11454898864030838f;
  t6_n91: return 0.13171100616455078f;
  t6_n92: if (E.getFileProximityDistanceCost() >= 3256745984 /*39.5*/) goto t6_n156;
  t6_n93: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t6_n141;
  t6_n94: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t6_n124;
  t6_n95: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t6_n103;
  t6_n96: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t6_n100;
  t6_n97: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t6_n99;
  t6_n98: return 0.09268879890441895f;
  t6_n99: return 0.10699354857206345f;
  t6_n100: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t6_n102;
  t6_n101: return 0.11477108299732208f;
  t6_n102: return 0.09493549913167953f;
  t6_n103: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t6_n121;
  t6_n104: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t6_n110;
  t6_n105: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t6_n107;
  t6_n106: return 0.05461925268173218f;
  t6_n107: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t6_n109;
  t6_n108: return -0.18433918058872223f;
  t6_n109: return 0.11318471282720566f;
  t6_n110: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t6_n118;
  t6_n111: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t6_n117;
  t6_n112: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t6_n116;
  t6_n113: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t6_n115;
  t6_n114: return 0.102376788854599f;
  t6_n115: return 0.11699502915143967f;
  t6_n116: return 0.11664564907550812f;
  t6_n117: return 0.09175629168748856f;
  t6_n118: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol))) goto t6_n120;
  t6_n119: return 0.10767804831266403f;
  t6_n120: return 0.12100794166326523f;
  t6_n121: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t6_n123;
  t6_n122: return 0.09821224957704544f;
  t6_n123: return 0.11392194777727127f;
  t6_n124: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t6_n138;
  t6_n125: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t6_n137;
  t6_n126: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t6_n134;
  t6_n127: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t6_n131;
  t6_n128: if (E.getNumReferences() >= 3348072384 /*73487.5*/) goto t6_n130;
  t6_n129: return 0.11085257679224014f;
  t6_n130: return 0.12212371081113815f;
  t6_n131: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t6_n133;
  t6_n132: return 0.08356772363185883f;
  t6_n133: return 0.1101066917181015f;
  t6_n134: if (E.getNumReferences() >= 3308503040 /*2876.0*/) goto t6_n136;
  t6_n135: return 0.1180632933974266f;
  t6_n136: return 0.11918322741985321f;
  t6_n137: return 0.11669336259365082f;
  t6_n138: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t6_n140;
  t6_n139: return 0.12129069864749908f;
  t6_n140: return 0.11526037752628326f;
  t6_n141: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t6_n155;
  t6_n142: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t6_n152;
  t6_n143: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t6_n147;
  t6_n144: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t6_n146;
  t6_n145: return 0.03734089434146881f;
  t6_n146: return 0.08507206290960312f;
  t6_n147: if (E.getNumReferences() >= 3352510912 /*108163.5*/) goto t6_n151;
  t6_n148: if (E.getNumReferences() >= 3236954112 /*7.5*/) goto t6_n150;
  t6_n149: return 0.09955451637506485f;
  t6_n150: return 0.11300400644540787f;
  t6_n151: return -0.1176115870475769f;
  t6_n152: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t6_n154;
  t6_n153: return 0.09763405472040176f;
  t6_n154: return 0.1164829358458519f;
  t6_n155: return 0.12192479521036148f;
  t6_n156: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t6_n202;
  t6_n157: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t6_n159;
  t6_n158: return -0.1185428723692894f;
  t6_n159: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t6_n179;
  t6_n160: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t6_n172;
  t6_n161: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t6_n171;
  t6_n162: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t6_n164;
  t6_n163: return -0.05446433648467064f;
  t6_n164: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t6_n168;
  t6_n165: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t6_n167;
  t6_n166: return 0.06412170082330704f;
  t6_n167: return -0.139354407787323f;
  t6_n168: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t6_n170;
  t6_n169: return 0.04789343848824501f;
  t6_n170: return 0.15410876274108887f;
  t6_n171: return 0.05050477012991905f;
  t6_n172: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t6_n178;
  t6_n173: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t6_n177;
  t6_n174: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t6_n176;
  t6_n175: return 0.023448312655091286f;
  t6_n176: return 0.08734987676143646f;
  t6_n177: return 0.10842875391244888f;
  t6_n178: return -0.1209210529923439f;
  t6_n179: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t6_n199;
  t6_n180: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t6_n198;
  t6_n181: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t6_n189;
  t6_n182: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t6_n186;
  t6_n183: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t6_n185;
  t6_n184: return 0.027010638266801834f;
  t6_n185: return 0.06716262549161911f;
  t6_n186: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t6_n188;
  t6_n187: return 0.06454640626907349f;
  t6_n188: return 0.11917995661497116f;
  t6_n189: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t6_n197;
  t6_n190: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t6_n196;
  t6_n191: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t6_n195;
  t6_n192: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t6_n194;
  t6_n193: return 0.054265812039375305f;
  t6_n194: return 0.09520072489976883f;
  t6_n195: return 0.11294608563184738f;
  t6_n196: return 0.11434587836265564f;
  t6_n197: return 0.048782337456941605f;
  t6_n198: return -0.11461447179317474f;
  t6_n199: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression))) goto t6_n201;
  t6_n200: return 0.10715899616479874f;
  t6_n201: return 0.11213543266057968f;
  t6_n202: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t6_n214;
  t6_n203: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t6_n211;
  t6_n204: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t6_n206;
  t6_n205: return -0.07179585844278336f;
  t6_n206: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t6_n208;
  t6_n207: return 0.0189349427819252f;
  t6_n208: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t6_n210;
  t6_n209: return 0.11877691000699997f;
  t6_n210: return -0.10939878225326538f;
  t6_n211: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t6_n213;
  t6_n212: return 0.07542522996664047f;
  t6_n213: return 0.11818340420722961f;
  t6_n214: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t6_n226;
  t6_n215: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t6_n219;
  t6_n216: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t6_n218;
  t6_n217: return 0.05498604476451874f;
  t6_n218: return 0.09124597162008286f;
  t6_n219: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t6_n225;
  t6_n220: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t6_n222;
  t6_n221: return -0.020818689838051796f;
  t6_n222: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t6_n224;
  t6_n223: return 0.08322066813707352f;
  t6_n224: return 0.11383268237113953f;
  t6_n225: return 0.11093156784772873f;
  t6_n226: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t6_n230;
  t6_n227: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t6_n229;
  t6_n228: return 0.11093226075172424f;
  t6_n229: return 0.09452306479215622f;
  t6_n230: return 0.11629190295934677f;
  t6_n231: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t6_n239;
  t6_n232: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t6_n238;
  t6_n233: if (E.getNumReferences() >= 3364994640 /*298482.5*/) goto t6_n237;
  t6_n234: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t6_n236;
  t6_n235: return 0.10691746324300766f;
  t6_n236: return 0.12213660776615143f;
  t6_n237: return 0.037479568272829056f;
  t6_n238: return 0.12231266498565674f;
  t6_n239: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t6_n245;
  t6_n240: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t6_n242;
  t6_n241: return 0.09548179060220718f;
  t6_n242: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t6_n244;
  t6_n243: return 0.12106719613075256f;
  t6_n244: return 0.09497188031673431f;
  t6_n245: return 0.12219524383544922f;
  t6_n246: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t6_n248;
  t6_n247: return 0.012289801612496376f;
  t6_n248: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t6_n254;
  t6_n249: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t6_n251;
  t6_n250: return 0.11853868514299393f;
  t6_n251: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t6_n253;
  t6_n252: return 0.12038695812225342f;
  t6_n253: return 0.11935454607009888f;
  t6_n254: return 0.12200726568698883f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree7(const Example& E) {
  t7_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t7_n244;
  t7_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t7_n231;
  t7_n2: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t7_n104;
  t7_n3: if (E.getNumReferences() >= 3332525568 /*20775.0*/) goto t7_n79;
  t7_n4: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t7_n54;
  t7_n5: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t7_n31;
  t7_n6: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t7_n16;
  t7_n7: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t7_n13;
  t7_n8: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t7_n10;
  t7_n9: return -0.048218775540590286f;
  t7_n10: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t7_n12;
  t7_n11: return 0.039144642651081085f;
  t7_n12: return 0.1184224858880043f;
  t7_n13: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t7_n15;
  t7_n14: return -0.004730020184069872f;
  t7_n15: return 0.06400088965892792f;
  t7_n16: if (E.getNumReferences() >= 3282321408 /*328.5*/) goto t7_n28;
  t7_n17: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t7_n21;
  t7_n18: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t7_n20;
  t7_n19: return -0.11559450626373291f;
  t7_n20: return -0.03226667270064354f;
  t7_n21: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t7_n27;
  t7_n22: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t7_n26;
  t7_n23: if (E.getNumReferences() >= 3248226304 /*19.5*/) goto t7_n25;
  t7_n24: return -0.04431630298495293f;
  t7_n25: return 0.03070029616355896f;
  t7_n26: return -0.08222733438014984f;
  t7_n27: return -0.1107359379529953f;
  t7_n28: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t7_n30;
  t7_n29: return -0.039909571409225464f;
  t7_n30: return 0.0674118921160698f;
  t7_n31: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t7_n37;
  t7_n32: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t7_n34;
  t7_n33: return -0.07826213538646698f;
  t7_n34: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t7_n36;
  t7_n35: return 0.07567574083805084f;
  t7_n36: return -0.003465155838057399f;
  t7_n37: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t7_n45;
  t7_n38: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t7_n44;
  t7_n39: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t7_n41;
  t7_n40: return 0.049766071140766144f;
  t7_n41: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t7_n43;
  t7_n42: return 0.011183121241629124f;
  t7_n43: return -0.06567926704883575f;
  t7_n44: return -0.12409932166337967f;
  t7_n45: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t7_n49;
  t7_n46: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t7_n48;
  t7_n47: return 0.08850919455289841f;
  t7_n48: return -0.10773701220750809f;
  t7_n49: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t7_n51;
  t7_n50: return 0.00837669800966978f;
  t7_n51: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t7_n53;
  t7_n52: return -0.01096459198743105f;
  t7_n53: return 0.06651464104652405f;
  t7_n54: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t7_n72;
  t7_n55: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t7_n65;
  t7_n56: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t7_n62;
  t7_n57: if (E.getFileProximityDistanceCost() >= 3230662656 /*4.5*/) goto t7_n61;
  t7_n58: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t7_n60;
  t7_n59: return 0.059674911201000214f;
  t7_n60: return 0.11096393316984177f;
  t7_n61: return 0.017550913617014885f;
  t7_n62: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t7_n64;
  t7_n63: return 0.0836709588766098f;
  t7_n64: return 0.11643993854522705f;
  t7_n65: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t7_n71;
  t7_n66: if (E.getNumReferences() >= 3292758016 /*782.0*/) goto t7_n70;
  t7_n67: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t7_n69;
  t7_n68: return -0.07261008769273758f;
  t7_n69: return 0.018843552097678185f;
  t7_n70: return 0.10434840619564056f;
  t7_n71: return 0.09103723615407944f;
  t7_n72: if (E.getContextKind() & (BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement))) goto t7_n76;
  t7_n73: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t7_n75;
  t7_n74: return 0.07183738052845001f;
  t7_n75: return 0.12662257254123688f;
  t7_n76: if (E.getFileProximityDistanceCost() >= 3242721280 /*12.5*/) goto t7_n78;
  t7_n77: return 0.0892573744058609f;
  t7_n78: return 0.11743985116481781f;
  t7_n79: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t7_n95;
  t7_n80: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t7_n94;
  t7_n81: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t7_n85;
  t7_n82: if (E.getFractionNameInContext() >= 3179562052 /*0.06458333134651184*/) goto t7_n84;
  t7_n83: return -7.469265983672813e-05f;
  t7_n84: return 0.08635824918746948f;
  t7_n85: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t7_n89;
  t7_n86: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t7_n88;
  t7_n87: return 0.08925529569387436f;
  t7_n88: return 0.03221891447901726f;
  t7_n89: if (E.getNumReferences() >= 3361959232 /*232885.0*/) goto t7_n93;
  t7_n90: if (E.getNumReferences() >= 3359831936 /*199646.0*/) goto t7_n92;
  t7_n91: return 0.12250697612762451f;
  t7_n92: return 0.10770054161548615f;
  t7_n93: return 0.05158914625644684f;
  t7_n94: return 0.11251743137836456f;
  t7_n95: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t7_n97;
  t7_n96: return 0.09561421722173691f;
  t7_n97: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel))) goto t7_n99;
  t7_n98: return 0.11031404882669449f;
  t7_n99: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t7_n103;
  t7_n100: if (E.getNumReferences() >= 3349178240 /*82127.0*/) goto t7_n102;
  t7_n101: return 0.11386752873659134f;
  t7_n102: return 0.13595525920391083f;
  t7_n103: return 0.023185523226857185f;
  t7_n104: if (E.getFileProximityDistanceCost() >= 3256745984 /*39.5*/) goto t7_n158;
  t7_n105: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t7_n141;
  t7_n106: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t7_n126;
  t7_n107: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t7_n113;
  t7_n108: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t7_n110;
  t7_n109: return 0.08810285478830338f;
  t7_n110: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t7_n112;
  t7_n111: return 0.11043140292167664f;
  t7_n112: return 0.08854340761899948f;
  t7_n113: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t7_n123;
  t7_n114: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t7_n118;
  t7_n115: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t7_n117;
  t7_n116: return 0.04769017547369003f;
  t7_n117: return 0.10808912664651871f;
  t7_n118: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t7_n120;
  t7_n119: return 0.10318810492753983f;
  t7_n120: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol))) goto t7_n122;
  t7_n121: return 0.10203713923692703f;
  t7_n122: return 0.11723780632019043f;
  t7_n123: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t7_n125;
  t7_n124: return 0.09205096960067749f;
  t7_n125: return 0.10961083322763443f;
  t7_n126: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t7_n140;
  t7_n127: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t7_n139;
  t7_n128: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t7_n136;
  t7_n129: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t7_n133;
  t7_n130: if (E.getNumReferences() >= 3348072384 /*73487.5*/) goto t7_n132;
  t7_n131: return 0.1060887798666954f;
  t7_n132: return 0.11826707422733307f;
  t7_n133: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t7_n135;
  t7_n134: return 0.0770397037267685f;
  t7_n135: return 0.1055036261677742f;
  t7_n136: if (E.getNumReferences() >= 3308503040 /*2876.0*/) goto t7_n138;
  t7_n137: return 0.11365600675344467f;
  t7_n138: return 0.11522064357995987f;
  t7_n139: return 0.11277537047863007f;
  t7_n140: return 0.1143830195069313f;
  t7_n141: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t7_n157;
  t7_n142: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t7_n154;
  t7_n143: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t7_n149;
  t7_n144: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t7_n148;
  t7_n145: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t7_n147;
  t7_n146: return 0.05284883454442024f;
  t7_n147: return 0.08966568112373352f;
  t7_n148: return 0.0009452869999222457f;
  t7_n149: if (E.getNumReferences() >= 3352510912 /*108163.5*/) goto t7_n153;
  t7_n150: if (E.getNumReferences() >= 3236954112 /*7.5*/) goto t7_n152;
  t7_n151: return 0.09368475526571274f;
  t7_n152: return 0.10851357877254486f;
  t7_n153: return -0.11405528336763382f;
  t7_n154: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t7_n156;
  t7_n155: return 0.09252406656742096f;
  t7_n156: return 0.11224037408828735f;
  t7_n157: return 0.11866112053394318f;
  t7_n158: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t7_n202;
  t7_n159: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t7_n161;
  t7_n160: return -0.11501043289899826f;
  t7_n161: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t7_n179;
  t7_n162: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t7_n172;
  t7_n163: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t7_n171;
  t7_n164: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t7_n166;
  t7_n165: return -0.05700121819972992f;
  t7_n166: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t7_n168;
  t7_n167: return -0.00970158725976944f;
  t7_n168: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t7_n170;
  t7_n169: return 0.010265559889376163f;
  t7_n170: return 0.14247189462184906f;
  t7_n171: return 0.04503646120429039f;
  t7_n172: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t7_n178;
  t7_n173: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t7_n177;
  t7_n174: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t7_n176;
  t7_n175: return 0.020855357870459557f;
  t7_n176: return 0.08062005788087845f;
  t7_n177: return 0.10316433757543564f;
  t7_n178: return -0.11739140003919601f;
  t7_n179: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t7_n199;
  t7_n180: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t7_n198;
  t7_n181: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t7_n189;
  t7_n182: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t7_n186;
  t7_n183: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t7_n185;
  t7_n184: return 0.024755064398050308f;
  t7_n185: return 0.06211823597550392f;
  t7_n186: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t7_n188;
  t7_n187: return 0.060432568192481995f;
  t7_n188: return 0.11497634649276733f;
  t7_n189: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t7_n197;
  t7_n190: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t7_n196;
  t7_n191: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t7_n195;
  t7_n192: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t7_n194;
  t7_n193: return 0.05089675635099411f;
  t7_n194: return 0.0896000862121582f;
  t7_n195: return 0.10853725671768188f;
  t7_n196: return 0.10984078794717789f;
  t7_n197: return 0.04241855442523956f;
  t7_n198: return -0.11038874834775925f;
  t7_n199: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression))) goto t7_n201;
  t7_n200: return 0.10171238332986832f;
  t7_n201: return 0.10743233561515808f;
  t7_n202: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t7_n214;
  t7_n203: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t7_n211;
  t7_n204: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t7_n206;
  t7_n205: return -0.06647530943155289f;
  t7_n206: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t7_n208;
  t7_n207: return 0.017961274832487106f;
  t7_n208: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t7_n210;
  t7_n209: return 0.11499027162790298f;
  t7_n210: return -0.1012706309556961f;
  t7_n211: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t7_n213;
  t7_n212: return 0.06798683851957321f;
  t7_n213: return 0.11436542123556137f;
  t7_n214: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t7_n226;
  t7_n215: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t7_n219;
  t7_n216: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t7_n218;
  t7_n217: return 0.04834944009780884f;
  t7_n218: return 0.08528122305870056f;
  t7_n219: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t7_n225;
  t7_n220: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t7_n222;
  t7_n221: return -0.01868138462305069f;
  t7_n222: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t7_n224;
  t7_n223: return 0.0769311785697937f;
  t7_n224: return 0.10946986824274063f;
  t7_n225: return 0.1060892716050148f;
  t7_n226: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t7_n230;
  t7_n227: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t7_n229;
  t7_n228: return 0.10621825605630875f;
  t7_n229: return 0.08815775066614151f;
  t7_n230: return 0.11219702661037445f;
  t7_n231: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t7_n239;
  t7_n232: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t7_n238;
  t7_n233: if (E.getNumReferences() >= 3364994640 /*298482.5*/) goto t7_n237;
  t7_n234: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t7_n236;
  t7_n235: return 0.10024236142635345f;
  t7_n236: return 0.11775520443916321f;
  t7_n237: return 0.032140545547008514f;
  t7_n238: return 0.11879107356071472f;
  t7_n239: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t7_n243;
  t7_n240: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t7_n242;
  t7_n241: return 0.08890262991189957f;
  t7_n242: return 0.11662090569734573f;
  t7_n243: return 0.11873926967382431f;
  t7_n244: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t7_n246;
  t7_n245: return 0.011305419728159904f;
  t7_n246: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t7_n254;
  t7_n247: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t7_n253;
  t7_n248: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t7_n250;
  t7_n249: return 0.11472802609205246f;
  t7_n250: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t7_n252;
  t7_n251: return 0.11689451336860657f;
  t7_n252: return 0.11583173274993896f;
  t7_n253: return -0.09141149371862411f;
  t7_n254: return 0.11875754594802856f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree8(const Example& E) {
  t8_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t8_n244;
  t8_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t8_n231;
  t8_n2: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t8_n82;
  t8_n3: if (E.getNumReferences() >= 3331404288 /*18585.0*/) goto t8_n63;
  t8_n4: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t8_n36;
  t8_n5: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t8_n21;
  t8_n6: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t8_n12;
  t8_n7: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t8_n9;
  t8_n8: return -0.02406221628189087f;
  t8_n9: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t8_n11;
  t8_n10: return 0.03608322516083717f;
  t8_n11: return 0.1155393049120903f;
  t8_n12: if (E.getNumReferences() >= 3282321408 /*328.5*/) goto t8_n18;
  t8_n13: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t8_n17;
  t8_n14: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t8_n16;
  t8_n15: return -0.1125863716006279f;
  t8_n16: return -0.029584020376205444f;
  t8_n17: return -0.07290451973676682f;
  t8_n18: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t8_n20;
  t8_n19: return -0.03490583598613739f;
  t8_n20: return 0.0627601370215416f;
  t8_n21: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t8_n25;
  t8_n22: if (E.getNumReferences() >= 3291488256 /*704.5*/) goto t8_n24;
  t8_n23: return -0.051254455000162125f;
  t8_n24: return 0.07630355656147003f;
  t8_n25: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t8_n27;
  t8_n26: return 0.00021914299577474594f;
  t8_n27: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t8_n31;
  t8_n28: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t8_n30;
  t8_n29: return 0.0834164023399353f;
  t8_n30: return -0.10392892360687256f;
  t8_n31: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t8_n33;
  t8_n32: return 0.02310517244040966f;
  t8_n33: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t8_n35;
  t8_n34: return -0.04150616005063057f;
  t8_n35: return 0.09861452132463455f;
  t8_n36: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t8_n56;
  t8_n37: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t8_n47;
  t8_n38: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t8_n44;
  t8_n39: if (E.getFileProximityDistanceCost() >= 3230662656 /*4.5*/) goto t8_n43;
  t8_n40: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t8_n42;
  t8_n41: return 0.05722584202885628f;
  t8_n42: return 0.10707052052021027f;
  t8_n43: return 0.01860024221241474f;
  t8_n44: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t8_n46;
  t8_n45: return 0.08262083679437637f;
  t8_n46: return 0.11385874450206757f;
  t8_n47: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t8_n55;
  t8_n48: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t8_n50;
  t8_n49: return -0.06372235715389252f;
  t8_n50: if (E.getNumReferences() >= 3293061120 /*800.5*/) goto t8_n54;
  t8_n51: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t8_n53;
  t8_n52: return -0.0026584379374980927f;
  t8_n53: return 0.07407286018133163f;
  t8_n54: return 0.10765106230974197f;
  t8_n55: return 0.0830330178141594f;
  t8_n56: if (E.getContextKind() & (BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement))) goto t8_n60;
  t8_n57: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t8_n59;
  t8_n58: return 0.07141368836164474f;
  t8_n59: return 0.11972648650407791f;
  t8_n60: if (E.getFileProximityDistanceCost() >= 3242721280 /*12.5*/) goto t8_n62;
  t8_n61: return 0.08380730450153351f;
  t8_n62: return 0.11368228495121002f;
  t8_n63: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t8_n73;
  t8_n64: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t8_n72;
  t8_n65: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t8_n69;
  t8_n66: if (E.getFractionNameInContext() >= 3179562052 /*0.06458333134651184*/) goto t8_n68;
  t8_n67: return -0.0011934232898056507f;
  t8_n68: return 0.0793924406170845f;
  t8_n69: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t8_n71;
  t8_n70: return 0.06925846636295319f;
  t8_n71: return 0.10912179201841354f;
  t8_n72: return 0.1090693548321724f;
  t8_n73: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t8_n75;
  t8_n74: return 0.08798039704561234f;
  t8_n75: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel))) goto t8_n77;
  t8_n76: return 0.10661464929580688f;
  t8_n77: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t8_n81;
  t8_n78: if (E.getNumReferences() >= 3349178240 /*82127.0*/) goto t8_n80;
  t8_n79: return 0.11109252274036407f;
  t8_n80: return 0.133000910282135f;
  t8_n81: return 0.016738926991820335f;
  t8_n82: if (E.getFileProximityDistanceCost() >= 3256745984 /*39.5*/) goto t8_n144;
  t8_n83: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t8_n129;
  t8_n84: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t8_n110;
  t8_n85: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t8_n99;
  t8_n86: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t8_n98;
  t8_n87: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t8_n89;
  t8_n88: return 0.08039990812540054f;
  t8_n89: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t8_n97;
  t8_n90: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t8_n96;
  t8_n91: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol))) goto t8_n93;
  t8_n92: return 0.04086792469024658f;
  t8_n93: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t8_n95;
  t8_n94: return 0.08607320487499237f;
  t8_n95: return 0.11825152486562729f;
  t8_n96: return 0.10292874276638031f;
  t8_n97: return 0.1031741127371788f;
  t8_n98: return 0.10252160578966141f;
  t8_n99: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t8_n105;
  t8_n100: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Namespace))) goto t8_n104;
  t8_n101: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t8_n103;
  t8_n102: return 0.045262016355991364f;
  t8_n103: return 0.1039481982588768f;
  t8_n104: return 0.10517904907464981f;
  t8_n105: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t8_n107;
  t8_n106: return 0.10349558293819427f;
  t8_n107: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t8_n109;
  t8_n108: return 0.11371488869190216f;
  t8_n109: return 0.09562668949365616f;
  t8_n110: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t8_n128;
  t8_n111: if (E.getNumReferences() >= 3343545472 /*51828.5*/) goto t8_n123;
  t8_n112: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t8_n122;
  t8_n113: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t8_n117;
  t8_n114: if (E.getNumReferences() >= 3238526976 /*8.5*/) goto t8_n116;
  t8_n115: return 0.09338921308517456f;
  t8_n116: return 0.10547604411840439f;
  t8_n117: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t8_n121;
  t8_n118: if (E.getFractionNameInContext() >= 3189238143 /*0.14835165441036224*/) goto t8_n120;
  t8_n119: return 0.05293648689985275f;
  t8_n120: return 0.10512237995862961f;
  t8_n121: return 0.10575203597545624f;
  t8_n122: return 0.10881774127483368f;
  t8_n123: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t8_n125;
  t8_n124: return 0.11282245069742203f;
  t8_n125: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Namespace))) goto t8_n127;
  t8_n126: return 0.06752335280179977f;
  t8_n127: return 0.11250010877847672f;
  t8_n128: return 0.11112851649522781f;
  t8_n129: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t8_n143;
  t8_n130: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t8_n140;
  t8_n131: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t8_n135;
  t8_n132: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t8_n134;
  t8_n133: return 0.02793951705098152f;
  t8_n134: return 0.07405000925064087f;
  t8_n135: if (E.getNumReferences() >= 3352510912 /*108163.5*/) goto t8_n139;
  t8_n136: if (E.getNumReferences() >= 3236954112 /*7.5*/) goto t8_n138;
  t8_n137: return 0.0880219116806984f;
  t8_n138: return 0.1046171560883522f;
  t8_n139: return -0.11154373735189438f;
  t8_n140: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t8_n142;
  t8_n141: return 0.0868542268872261f;
  t8_n142: return 0.1084330826997757f;
  t8_n143: return 0.1162441223859787f;
  t8_n144: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t8_n204;
  t8_n145: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t8_n147;
  t8_n146: return -0.1120966300368309f;
  t8_n147: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t8_n175;
  t8_n148: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t8_n168;
  t8_n149: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t8_n165;
  t8_n150: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t8_n152;
  t8_n151: return -0.06267209351062775f;
  t8_n152: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t8_n162;
  t8_n153: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t8_n157;
  t8_n154: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t8_n156;
  t8_n155: return -0.014679930172860622f;
  t8_n156: return 0.05581405386328697f;
  t8_n157: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_UnionTag))) goto t8_n159;
  t8_n158: return -0.015689874067902565f;
  t8_n159: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t8_n161;
  t8_n160: return 0.12675103545188904f;
  t8_n161: return -0.002790498547255993f;
  t8_n162: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t8_n164;
  t8_n163: return 0.059732913970947266f;
  t8_n164: return 0.13417595624923706f;
  t8_n165: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t8_n167;
  t8_n166: return -0.09906323999166489f;
  t8_n167: return 0.07240574806928635f;
  t8_n168: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t8_n174;
  t8_n169: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t8_n173;
  t8_n170: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t8_n172;
  t8_n171: return 0.018281370401382446f;
  t8_n172: return 0.07467237114906311f;
  t8_n173: return 0.09866443276405334f;
  t8_n174: return -0.1143074780702591f;
  t8_n175: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t8_n201;
  t8_n176: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t8_n192;
  t8_n177: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t8_n191;
  t8_n178: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t8_n186;
  t8_n179: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t8_n185;
  t8_n180: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t8_n182;
  t8_n181: return 0.017367146909236908f;
  t8_n182: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t8_n184;
  t8_n183: return 0.030954236164689064f;
  t8_n184: return 0.11229630559682846f;
  t8_n185: return 0.054676514118909836f;
  t8_n186: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t8_n190;
  t8_n187: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t8_n189;
  t8_n188: return -0.02728566899895668f;
  t8_n189: return 0.0905829519033432f;
  t8_n190: return 0.07921449095010757f;
  t8_n191: return -0.10598009079694748f;
  t8_n192: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t8_n200;
  t8_n193: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t8_n199;
  t8_n194: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t8_n196;
  t8_n195: return 0.06347216665744781f;
  t8_n196: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t8_n198;
  t8_n197: return 0.08440050482749939f;
  t8_n198: return 0.10836010426282883f;
  t8_n199: return 0.10489145666360855f;
  t8_n200: return -0.11123615503311157f;
  t8_n201: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression))) goto t8_n203;
  t8_n202: return 0.09722563624382019f;
  t8_n203: return 0.10322580486536026f;
  t8_n204: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t8_n216;
  t8_n205: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t8_n213;
  t8_n206: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t8_n208;
  t8_n207: return -0.06265988200902939f;
  t8_n208: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t8_n210;
  t8_n209: return 0.017924780026078224f;
  t8_n210: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t8_n212;
  t8_n211: return 0.11217091977596283f;
  t8_n212: return -0.0964498519897461f;
  t8_n213: if (E.getFractionNameInContext() >= 3180849535 /*0.07417582720518112*/) goto t8_n215;
  t8_n214: return 0.06159818172454834f;
  t8_n215: return 0.11158299446105957f;
  t8_n216: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t8_n228;
  t8_n217: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t8_n221;
  t8_n218: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t8_n220;
  t8_n219: return 0.04335322231054306f;
  t8_n220: return 0.07972396165132523f;
  t8_n221: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t8_n227;
  t8_n222: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t8_n224;
  t8_n223: return -0.01504459697753191f;
  t8_n224: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t8_n226;
  t8_n225: return 0.07079628854990005f;
  t8_n226: return 0.1062440276145935f;
  t8_n227: return 0.10175447165966034f;
  t8_n228: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t8_n230;
  t8_n229: return 0.09997715801000595f;
  t8_n230: return 0.10891495645046234f;
  t8_n231: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t8_n239;
  t8_n232: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t8_n238;
  t8_n233: if (E.getNumReferences() >= 3364994640 /*298482.5*/) goto t8_n237;
  t8_n234: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t8_n236;
  t8_n235: return 0.09358306229114532f;
  t8_n236: return 0.11413650959730148f;
  t8_n237: return 0.0283666905015707f;
  t8_n238: return 0.1160721406340599f;
  t8_n239: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t8_n243;
  t8_n240: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t8_n242;
  t8_n241: return 0.11309314519166946f;
  t8_n242: return 0.061868198215961456f;
  t8_n243: return 0.11610662937164307f;
  t8_n244: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t8_n246;
  t8_n245: return 0.009700912050902843f;
  t8_n246: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t8_n254;
  t8_n247: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t8_n253;
  t8_n248: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t8_n250;
  t8_n249: return 0.11154477298259735f;
  t8_n250: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t8_n252;
  t8_n251: return 0.11416026949882507f;
  t8_n252: return 0.11301549524068832f;
  t8_n253: return -0.08490672707557678f;
  t8_n254: return 0.11622261255979538f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree9(const Example& E) {
  t9_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t9_n244;
  t9_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t9_n231;
  t9_n2: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t9_n78;
  t9_n3: if (E.getNumReferences() >= 3331404288 /*18585.0*/) goto t9_n59;
  t9_n4: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t9_n36;
  t9_n5: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t9_n25;
  t9_n6: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t9_n16;
  t9_n7: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t9_n9;
  t9_n8: return -0.030893277376890182f;
  t9_n9: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t9_n15;
  t9_n10: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t9_n14;
  t9_n11: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t9_n13;
  t9_n12: return -0.004655881319195032f;
  t9_n13: return 0.060269929468631744f;
  t9_n14: return -0.029615288600325584f;
  t9_n15: return 0.11454739421606064f;
  t9_n16: if (E.getNumReferences() >= 3282321408 /*328.5*/) goto t9_n22;
  t9_n17: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t9_n21;
  t9_n18: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t9_n20;
  t9_n19: return -0.1101599857211113f;
  t9_n20: return -0.07365848869085312f;
  t9_n21: return -0.02609551139175892f;
  t9_n22: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t9_n24;
  t9_n23: return -0.0320189967751503f;
  t9_n24: return 0.05762016773223877f;
  t9_n25: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t9_n33;
  t9_n26: if (E.getNumReferences() >= 3252944896 /*28.5*/) goto t9_n30;
  t9_n27: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t9_n29;
  t9_n28: return -0.05365622043609619f;
  t9_n29: return 0.004898638930171728f;
  t9_n30: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t9_n32;
  t9_n31: return 0.102329783141613f;
  t9_n32: return 0.039892133325338364f;
  t9_n33: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t9_n35;
  t9_n34: return 0.014834370464086533f;
  t9_n35: return 0.04769543185830116f;
  t9_n36: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t9_n54;
  t9_n37: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t9_n47;
  t9_n38: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t9_n44;
  t9_n39: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t9_n43;
  t9_n40: if (E.getFileProximityDistanceCost() >= 3230662656 /*4.5*/) goto t9_n42;
  t9_n41: return 0.051889970898628235f;
  t9_n42: return 0.0118778757750988f;
  t9_n43: return 0.0949343666434288f;
  t9_n44: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t9_n46;
  t9_n45: return 0.07967337220907211f;
  t9_n46: return 0.10968664288520813f;
  t9_n47: if (E.getNumReferences() >= 3273687040 /*160.5*/) goto t9_n53;
  t9_n48: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t9_n52;
  t9_n49: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t9_n51;
  t9_n50: return -0.06096794828772545f;
  t9_n51: return 0.018718749284744263f;
  t9_n52: return 0.07365833222866058f;
  t9_n53: return 0.08917273581027985f;
  t9_n54: if (E.getContextKind() & (BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement))) goto t9_n58;
  t9_n55: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t9_n57;
  t9_n56: return 0.06824296712875366f;
  t9_n57: return 0.11313112080097198f;
  t9_n58: return 0.107003353536129f;
  t9_n59: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t9_n69;
  t9_n60: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t9_n68;
  t9_n61: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t9_n65;
  t9_n62: if (E.getFractionNameInContext() >= 3179562052 /*0.06458333134651184*/) goto t9_n64;
  t9_n63: return -0.0006972107803449035f;
  t9_n64: return 0.07372178137302399f;
  t9_n65: if (E.getFractionNameInContext() >= 3181648450 /*0.08012820780277252*/) goto t9_n67;
  t9_n66: return 0.0659128874540329f;
  t9_n67: return 0.1054917424917221f;
  t9_n68: return 0.10622762888669968f;
  t9_n69: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t9_n71;
  t9_n70: return 0.08347876369953156f;
  t9_n71: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel))) goto t9_n73;
  t9_n72: return 0.10328451544046402f;
  t9_n73: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t9_n77;
  t9_n74: if (E.getNumReferences() >= 3349178240 /*82127.0*/) goto t9_n76;
  t9_n75: return 0.10872294008731842f;
  t9_n76: return 0.1306021362543106f;
  t9_n77: return 0.013410818763077259f;
  t9_n78: if (E.getFileProximityDistanceCost() >= 3256745984 /*39.5*/) goto t9_n134;
  t9_n79: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t9_n119;
  t9_n80: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t9_n104;
  t9_n81: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t9_n95;
  t9_n82: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t9_n84;
  t9_n83: return 0.07429377734661102f;
  t9_n84: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Namespace))) goto t9_n94;
  t9_n85: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t9_n93;
  t9_n86: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t9_n88;
  t9_n87: return 0.001502872328273952f;
  t9_n88: if (E.getFileProximityDistanceCost() >= 3244818432 /*14.5*/) goto t9_n92;
  t9_n89: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression))) goto t9_n91;
  t9_n90: return 0.08672243356704712f;
  t9_n91: return 0.13770084083080292f;
  t9_n92: return 0.06668078154325485f;
  t9_n93: return 0.10183198750019073f;
  t9_n94: return 0.1008056253194809f;
  t9_n95: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t9_n101;
  t9_n96: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t9_n100;
  t9_n97: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t9_n99;
  t9_n98: return 0.09664366394281387f;
  t9_n99: return 0.10439250618219376f;
  t9_n100: return 0.08290252834558487f;
  t9_n101: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t9_n103;
  t9_n102: return 0.0803273543715477f;
  t9_n103: return 0.1090412512421608f;
  t9_n104: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t9_n116;
  t9_n105: if (E.getNumReferences() >= 3343545472 /*51828.5*/) goto t9_n115;
  t9_n106: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t9_n114;
  t9_n107: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t9_n111;
  t9_n108: if (E.getNumReferences() >= 3238526976 /*8.5*/) goto t9_n110;
  t9_n109: return 0.08890587091445923f;
  t9_n110: return 0.10156642645597458f;
  t9_n111: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t9_n113;
  t9_n112: return 0.0614229179918766f;
  t9_n113: return 0.10230270773172379f;
  t9_n114: return 0.1060125008225441f;
  t9_n115: return 0.10783354192972183f;
  t9_n116: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t9_n118;
  t9_n117: return 0.11123453080654144f;
  t9_n118: return 0.10043582320213318f;
  t9_n119: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t9_n125;
  t9_n120: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t9_n124;
  t9_n121: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t9_n123;
  t9_n122: return 0.02797657996416092f;
  t9_n123: return 0.08374501764774323f;
  t9_n124: return 0.08299500495195389f;
  t9_n125: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t9_n133;
  t9_n126: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t9_n132;
  t9_n127: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t9_n129;
  t9_n128: return 0.044679801911115646f;
  t9_n129: if (E.getNumReferences() >= 3358365376 /*176731.0*/) goto t9_n131;
  t9_n130: return 0.08984068781137466f;
  t9_n131: return -0.10945164412260056f;
  t9_n132: return 0.10749109834432602f;
  t9_n133: return 0.11450736224651337f;
  t9_n134: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t9_n196;
  t9_n135: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t9_n189;
  t9_n136: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t9_n138;
  t9_n137: return -0.10968128591775894f;
  t9_n138: if (E.getFractionNameInContext() >= 3180849535 /*0.07417582720518112*/) goto t9_n162;
  t9_n139: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t9_n153;
  t9_n140: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t9_n150;
  t9_n141: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t9_n143;
  t9_n142: return -0.0617765448987484f;
  t9_n143: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t9_n147;
  t9_n144: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t9_n146;
  t9_n145: return 0.02266213856637478f;
  t9_n146: return -0.04334687441587448f;
  t9_n147: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t9_n149;
  t9_n148: return 0.061460502445697784f;
  t9_n149: return 0.1272536963224411f;
  t9_n150: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t9_n152;
  t9_n151: return -0.11367207765579224f;
  t9_n152: return 0.06890672445297241f;
  t9_n153: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t9_n161;
  t9_n154: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t9_n160;
  t9_n155: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t9_n159;
  t9_n156: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t9_n158;
  t9_n157: return 0.05288698151707649f;
  t9_n158: return 0.09719330072402954f;
  t9_n159: return 0.08831929415464401f;
  t9_n160: return 0.0038880787324160337f;
  t9_n161: return -0.11208412051200867f;
  t9_n162: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t9_n180;
  t9_n163: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t9_n179;
  t9_n164: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t9_n178;
  t9_n165: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t9_n171;
  t9_n166: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t9_n168;
  t9_n167: return -0.050740569829940796f;
  t9_n168: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t9_n170;
  t9_n169: return 0.03452669829130173f;
  t9_n170: return 0.06578367203474045f;
  t9_n171: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t9_n175;
  t9_n172: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t9_n174;
  t9_n173: return 0.04058697447180748f;
  t9_n174: return 0.08950041234493256f;
  t9_n175: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t9_n177;
  t9_n176: return 0.0807945653796196f;
  t9_n177: return 0.1294819861650467f;
  t9_n178: return -0.09901988506317139f;
  t9_n179: return 0.006869764998555183f;
  t9_n180: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t9_n188;
  t9_n181: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t9_n187;
  t9_n182: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t9_n184;
  t9_n183: return 0.0626433864235878f;
  t9_n184: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t9_n186;
  t9_n185: return 0.07907576113939285f;
  t9_n186: return 0.10540197044610977f;
  t9_n187: return 0.10206498205661774f;
  t9_n188: return -0.10823880881071091f;
  t9_n189: if (E.getFractionNameInContext() >= 3180161239 /*0.06904762238264084*/) goto t9_n193;
  t9_n190: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t9_n192;
  t9_n191: return 0.04014963656663895f;
  t9_n192: return 0.09552031010389328f;
  t9_n193: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t9_n195;
  t9_n194: return 0.091588094830513f;
  t9_n195: return 0.10231655836105347f;
  t9_n196: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t9_n202;
  t9_n197: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t9_n199;
  t9_n198: return -0.11162908375263214f;
  t9_n199: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression))) goto t9_n201;
  t9_n200: return 0.01428006961941719f;
  t9_n201: return 0.10641128569841385f;
  t9_n202: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t9_n224;
  t9_n203: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t9_n215;
  t9_n204: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t9_n206;
  t9_n205: return 0.00621330551803112f;
  t9_n206: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t9_n214;
  t9_n207: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t9_n209;
  t9_n208: return 0.06925924122333527f;
  t9_n209: if (E.getScope() & (BIT(Scope_type::FunctionScope)|BIT(Scope_type::GlobalScope))) goto t9_n211;
  t9_n210: return -0.1357751488685608f;
  t9_n211: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t9_n213;
  t9_n212: return 0.014852204360067844f;
  t9_n213: return 0.08203447610139847f;
  t9_n214: return 0.1050766259431839f;
  t9_n215: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t9_n221;
  t9_n216: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t9_n220;
  t9_n217: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t9_n219;
  t9_n218: return 0.036798905581235886f;
  t9_n219: return 0.0685330182313919f;
  t9_n220: return 0.11675655096769333f;
  t9_n221: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t9_n223;
  t9_n222: return 0.09466202557086945f;
  t9_n223: return 0.10958206653594971f;
  t9_n224: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t9_n230;
  t9_n225: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t9_n229;
  t9_n226: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t9_n228;
  t9_n227: return 0.09952612221240997f;
  t9_n228: return 0.07675500959157944f;
  t9_n229: return -0.08924910426139832f;
  t9_n230: return 0.1060781478881836f;
  t9_n231: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t9_n239;
  t9_n232: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t9_n238;
  t9_n233: if (E.getNumReferences() >= 3364994640 /*298482.5*/) goto t9_n237;
  t9_n234: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t9_n236;
  t9_n235: return 0.08844324946403503f;
  t9_n236: return 0.11130587011575699f;
  t9_n237: return 0.026080220937728882f;
  t9_n238: return 0.11386457085609436f;
  t9_n239: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t9_n243;
  t9_n240: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t9_n242;
  t9_n241: return 0.11019829660654068f;
  t9_n242: return 0.05768797919154167f;
  t9_n243: return 0.11392705142498016f;
  t9_n244: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t9_n246;
  t9_n245: return 0.009753049351274967f;
  t9_n246: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t9_n254;
  t9_n247: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t9_n253;
  t9_n248: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t9_n250;
  t9_n249: return 0.10888456553220749f;
  t9_n250: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t9_n252;
  t9_n251: return 0.11190256476402283f;
  t9_n252: return 0.11065909266471863f;
  t9_n253: return -0.07946090400218964f;
  t9_n254: return 0.11430513858795166f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree10(const Example& E) {
  t10_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t10_n244;
  t10_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t10_n231;
  t10_n2: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t10_n92;
  t10_n3: if (E.getNumReferences() >= 3329785856 /*15904.0*/) goto t10_n65;
  t10_n4: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t10_n40;
  t10_n5: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t10_n31;
  t10_n6: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t10_n16;
  t10_n7: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t10_n9;
  t10_n8: return -0.02648966573178768f;
  t10_n9: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t10_n15;
  t10_n10: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t10_n14;
  t10_n11: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t10_n13;
  t10_n12: return 0.06134309247136116f;
  t10_n13: return 0.003277688752859831f;
  t10_n14: return -0.019568990916013718f;
  t10_n15: return 0.10875918716192245f;
  t10_n16: if (E.getNumReferences() >= 3282321408 /*328.5*/) goto t10_n24;
  t10_n17: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t10_n21;
  t10_n18: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t10_n20;
  t10_n19: return -0.10787810385227203f;
  t10_n20: return -0.06978398561477661f;
  t10_n21: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t10_n23;
  t10_n22: return -0.03514175862073898f;
  t10_n23: return 0.04454370215535164f;
  t10_n24: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t10_n30;
  t10_n25: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t10_n27;
  t10_n26: return -0.026969511061906815f;
  t10_n27: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t10_n29;
  t10_n28: return 0.07796205580234528f;
  t10_n29: return 0.025505777448415756f;
  t10_n30: return -0.044934190809726715f;
  t10_n31: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t10_n39;
  t10_n32: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t10_n34;
  t10_n33: return -0.04985201731324196f;
  t10_n34: if (E.getNumReferences() >= 3279519744 /*249.5*/) goto t10_n36;
  t10_n35: return 7.695138629060239e-05f;
  t10_n36: if (E.getFileProximityDistanceCost() >= 3236954112 /*7.5*/) goto t10_n38;
  t10_n37: return 0.11505196243524551f;
  t10_n38: return 0.06704962253570557f;
  t10_n39: return 0.026118911802768707f;
  t10_n40: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t10_n58;
  t10_n41: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t10_n51;
  t10_n42: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t10_n46;
  t10_n43: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t10_n45;
  t10_n44: return -0.012644424103200436f;
  t10_n45: return 0.06476689875125885f;
  t10_n46: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t10_n50;
  t10_n47: if (E.getFileProximityDistanceCost() >= 3236954112 /*7.5*/) goto t10_n49;
  t10_n48: return 0.06469162553548813f;
  t10_n49: return 0.03029419109225273f;
  t10_n50: return 0.10255438089370728f;
  t10_n51: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t10_n53;
  t10_n52: return 0.09568463265895844f;
  t10_n53: if (E.getNumReferences() >= 3273424896 /*156.5*/) goto t10_n57;
  t10_n54: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t10_n56;
  t10_n55: return 0.07436498254537582f;
  t10_n56: return -0.018085381016135216f;
  t10_n57: return 0.08927732706069946f;
  t10_n58: if (E.getContextKind() & (BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement))) goto t10_n62;
  t10_n59: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t10_n61;
  t10_n60: return 0.06403456628322601f;
  t10_n61: return 0.10893741250038147f;
  t10_n62: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t10_n64;
  t10_n63: return 0.07833915203809738f;
  t10_n64: return 0.10779207944869995f;
  t10_n65: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t10_n83;
  t10_n66: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t10_n82;
  t10_n67: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t10_n71;
  t10_n68: if (E.getFractionNameInContext() >= 3179562052 /*0.06458333134651184*/) goto t10_n70;
  t10_n69: return -0.0027607118245214224f;
  t10_n70: return 0.06615544855594635f;
  t10_n71: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t10_n79;
  t10_n72: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t10_n74;
  t10_n73: return 0.07193787395954132f;
  t10_n74: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t10_n76;
  t10_n75: return 0.00977353099733591f;
  t10_n76: if (E.getNumReferences() >= 3359911200 /*200884.5*/) goto t10_n78;
  t10_n77: return 0.1157560646533966f;
  t10_n78: return 0.06915208697319031f;
  t10_n79: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t10_n81;
  t10_n80: return 0.08591532707214355f;
  t10_n81: return 0.11120492219924927f;
  t10_n82: return 0.10261329263448715f;
  t10_n83: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t10_n85;
  t10_n84: return 0.07893253117799759f;
  t10_n85: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel))) goto t10_n87;
  t10_n86: return 0.10017193853855133f;
  t10_n87: if (E.getNumReferences() >= 3349178240 /*82127.0*/) goto t10_n89;
  t10_n88: return 0.10490443557500839f;
  t10_n89: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t10_n91;
  t10_n90: return 0.12820766866207123f;
  t10_n91: return -0.027602175250649452f;
  t10_n92: if (E.getFileProximityDistanceCost() >= 3256745984 /*39.5*/) goto t10_n144;
  t10_n93: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t10_n129;
  t10_n94: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t10_n114;
  t10_n95: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t10_n109;
  t10_n96: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t10_n98;
  t10_n97: return 0.06929711252450943f;
  t10_n98: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Namespace))) goto t10_n108;
  t10_n99: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t10_n107;
  t10_n100: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t10_n102;
  t10_n101: return -0.001991261262446642f;
  t10_n102: if (E.getFileProximityDistanceCost() >= 3244818432 /*14.5*/) goto t10_n106;
  t10_n103: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression))) goto t10_n105;
  t10_n104: return 0.08530456572771072f;
  t10_n105: return 0.1288270801305771f;
  t10_n106: return 0.060881201177835464f;
  t10_n107: return 0.09891026467084885f;
  t10_n108: return 0.09750732034444809f;
  t10_n109: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t10_n111;
  t10_n110: return 0.09277079254388809f;
  t10_n111: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t10_n113;
  t10_n112: return 0.07423285394906998f;
  t10_n113: return 0.1063150018453598f;
  t10_n114: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t10_n126;
  t10_n115: if (E.getNumReferences() >= 3343545472 /*51828.5*/) goto t10_n125;
  t10_n116: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t10_n124;
  t10_n117: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t10_n119;
  t10_n118: return 0.0955369621515274f;
  t10_n119: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t10_n123;
  t10_n120: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t10_n122;
  t10_n121: return 0.0949033722281456f;
  t10_n122: return 0.03150058165192604f;
  t10_n123: return 0.09929127246141434f;
  t10_n124: return 0.10364969819784164f;
  t10_n125: return 0.1052030399441719f;
  t10_n126: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t10_n128;
  t10_n127: return 0.10893315076828003f;
  t10_n128: return 0.09716806560754776f;
  t10_n129: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t10_n135;
  t10_n130: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t10_n134;
  t10_n131: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t10_n133;
  t10_n132: return 0.025403501465916634f;
  t10_n133: return 0.07872946560382843f;
  t10_n134: return 0.07977598905563354f;
  t10_n135: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t10_n143;
  t10_n136: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t10_n142;
  t10_n137: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t10_n139;
  t10_n138: return 0.043038249015808105f;
  t10_n139: if (E.getNumReferences() >= 3358365376 /*176731.0*/) goto t10_n141;
  t10_n140: return 0.08673278242349625f;
  t10_n141: return -0.10813603550195694f;
  t10_n142: return 0.10516422986984253f;
  t10_n143: return 0.11302406340837479f;
  t10_n144: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t10_n204;
  t10_n145: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t10_n195;
  t10_n146: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t10_n148;
  t10_n147: return -0.10772937536239624f;
  t10_n148: if (E.getFractionNameInContext() >= 3180849535 /*0.07417582720518112*/) goto t10_n172;
  t10_n149: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t10_n163;
  t10_n150: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t10_n160;
  t10_n151: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t10_n153;
  t10_n152: return -0.057586438953876495f;
  t10_n153: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t10_n157;
  t10_n154: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t10_n156;
  t10_n155: return 0.021838398650288582f;
  t10_n156: return -0.0397360622882843f;
  t10_n157: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t10_n159;
  t10_n158: return 0.06033444404602051f;
  t10_n159: return 0.12209545075893402f;
  t10_n160: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t10_n162;
  t10_n161: return -0.1277645379304886f;
  t10_n162: return 0.0269073024392128f;
  t10_n163: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t10_n171;
  t10_n164: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t10_n170;
  t10_n165: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t10_n169;
  t10_n166: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t10_n168;
  t10_n167: return 0.04757379740476608f;
  t10_n168: return 0.09363672137260437f;
  t10_n169: return 0.08357780426740646f;
  t10_n170: return 0.002292738063260913f;
  t10_n171: return -0.11023149639368057f;
  t10_n172: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t10_n188;
  t10_n173: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t10_n187;
  t10_n174: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t10_n186;
  t10_n175: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t10_n181;
  t10_n176: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t10_n178;
  t10_n177: return -0.05487443134188652f;
  t10_n178: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t10_n180;
  t10_n179: return 0.03098118305206299f;
  t10_n180: return 0.0613538883626461f;
  t10_n181: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t10_n183;
  t10_n182: return 0.0641285628080368f;
  t10_n183: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t10_n185;
  t10_n184: return 0.0945146456360817f;
  t10_n185: return 0.1422143131494522f;
  t10_n186: return -0.09546016901731491f;
  t10_n187: return 0.006409863941371441f;
  t10_n188: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t10_n194;
  t10_n189: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t10_n193;
  t10_n190: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t10_n192;
  t10_n191: return 0.05794383957982063f;
  t10_n192: return 0.08050299435853958f;
  t10_n193: return 0.09778542816638947f;
  t10_n194: return -0.10550480335950851f;
  t10_n195: if (E.getFractionNameInContext() >= 3180161239 /*0.06904762238264084*/) goto t10_n201;
  t10_n196: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression))) goto t10_n198;
  t10_n197: return 0.029872991144657135f;
  t10_n198: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t10_n200;
  t10_n199: return 0.010023502632975578f;
  t10_n200: return 0.09154534339904785f;
  t10_n201: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t10_n203;
  t10_n202: return 0.07931246608495712f;
  t10_n203: return 0.10385134071111679f;
  t10_n204: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t10_n210;
  t10_n205: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t10_n207;
  t10_n206: return -0.10566776245832443f;
  t10_n207: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression))) goto t10_n209;
  t10_n208: return 0.014873840846121311f;
  t10_n209: return 0.10341809689998627f;
  t10_n210: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t10_n224;
  t10_n211: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t10_n215;
  t10_n212: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t10_n214;
  t10_n213: return 0.0321175679564476f;
  t10_n214: return 0.07178671658039093f;
  t10_n215: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t10_n221;
  t10_n216: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t10_n218;
  t10_n217: return 0.028087567538022995f;
  t10_n218: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t10_n220;
  t10_n219: return 0.06044412776827812f;
  t10_n220: return 0.09975612908601761f;
  t10_n221: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t10_n223;
  t10_n222: return 0.09039555490016937f;
  t10_n223: return 0.10682743787765503f;
  t10_n224: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t10_n230;
  t10_n225: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t10_n229;
  t10_n226: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t10_n228;
  t10_n227: return 0.09221696108579636f;
  t10_n228: return 0.11143869906663895f;
  t10_n229: return -0.08478569984436035f;
  t10_n230: return 0.10340819507837296f;
  t10_n231: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t10_n239;
  t10_n232: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t10_n238;
  t10_n233: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t10_n237;
  t10_n234: if (E.getNumReferences() >= 3364994640 /*298482.5*/) goto t10_n236;
  t10_n235: return 0.08353859186172485f;
  t10_n236: return -0.0344865620136261f;
  t10_n237: return 0.10445360839366913f;
  t10_n238: return 0.11200720816850662f;
  t10_n239: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t10_n243;
  t10_n240: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t10_n242;
  t10_n241: return 0.07126577198505402f;
  t10_n242: return 0.10863076150417328f;
  t10_n243: return 0.11212217062711716f;
  t10_n244: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t10_n246;
  t10_n245: return 0.008864154107868671f;
  t10_n246: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t10_n254;
  t10_n247: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t10_n253;
  t10_n248: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t10_n250;
  t10_n249: return 0.10645624995231628f;
  t10_n250: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t10_n252;
  t10_n251: return 0.10999232530593872f;
  t10_n252: return 0.10868818312883377f;
  t10_n253: return -0.0717880055308342f;
  t10_n254: return 0.11272518336772919f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree11(const Example& E) {
  t11_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t11_n248;
  t11_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t11_n235;
  t11_n2: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t11_n94;
  t11_n3: if (E.getNumReferences() >= 3329785856 /*15904.0*/) goto t11_n69;
  t11_n4: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t11_n46;
  t11_n5: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t11_n31;
  t11_n6: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t11_n16;
  t11_n7: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t11_n9;
  t11_n8: return -0.02368917688727379f;
  t11_n9: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t11_n15;
  t11_n10: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t11_n14;
  t11_n11: if (E.getFractionNameInContext() >= 3179562052 /*0.06458333134651184*/) goto t11_n13;
  t11_n12: return 0.034899380058050156f;
  t11_n13: return 0.07802258431911469f;
  t11_n14: return -0.01683119311928749f;
  t11_n15: return 0.10161592811346054f;
  t11_n16: if (E.getNumReferences() >= 3279585280 /*250.5*/) goto t11_n22;
  t11_n17: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t11_n21;
  t11_n18: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t11_n20;
  t11_n19: return -0.1055774837732315f;
  t11_n20: return -0.06589969992637634f;
  t11_n21: return -0.019587771967053413f;
  t11_n22: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t11_n28;
  t11_n23: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t11_n25;
  t11_n24: return -0.02444872446358204f;
  t11_n25: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t11_n27;
  t11_n26: return 0.07097446918487549f;
  t11_n27: return 0.02139517106115818f;
  t11_n28: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t11_n30;
  t11_n29: return -0.049424003809690475f;
  t11_n30: return 0.05827069655060768f;
  t11_n31: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t11_n45;
  t11_n32: if (E.getNumReferences() >= 3252944896 /*28.5*/) goto t11_n42;
  t11_n33: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t11_n35;
  t11_n34: return -0.04614725708961487f;
  t11_n35: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t11_n41;
  t11_n36: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t11_n38;
  t11_n37: return 0.05528421327471733f;
  t11_n38: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t11_n40;
  t11_n39: return 0.009403818286955357f;
  t11_n40: return -0.05886528640985489f;
  t11_n41: return -0.11724168807268143f;
  t11_n42: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t11_n44;
  t11_n43: return 0.09655074775218964f;
  t11_n44: return 0.035531528294086456f;
  t11_n45: return 0.023836692795157433f;
  t11_n46: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t11_n62;
  t11_n47: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t11_n57;
  t11_n48: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t11_n52;
  t11_n49: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t11_n51;
  t11_n50: return -0.009774947538971901f;
  t11_n51: return 0.05862367898225784f;
  t11_n52: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t11_n54;
  t11_n53: return 0.0879574567079544f;
  t11_n54: if (E.getNumReferences() >= 3273424896 /*156.5*/) goto t11_n56;
  t11_n55: return 0.00437132827937603f;
  t11_n56: return 0.07622218132019043f;
  t11_n57: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t11_n61;
  t11_n58: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t11_n60;
  t11_n59: return 0.05524801090359688f;
  t11_n60: return 0.10013271123170853f;
  t11_n61: return 0.10294249653816223f;
  t11_n62: if (E.getContextKind() & (BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement))) goto t11_n66;
  t11_n63: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t11_n65;
  t11_n64: return 0.060833532363176346f;
  t11_n65: return 0.10428833961486816f;
  t11_n66: if (E.getFileProximityDistanceCost() >= 3242721280 /*12.5*/) goto t11_n68;
  t11_n67: return 0.07064104080200195f;
  t11_n68: return 0.10497681051492691f;
  t11_n69: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t11_n85;
  t11_n70: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t11_n84;
  t11_n71: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t11_n73;
  t11_n72: return 0.004285367205739021f;
  t11_n73: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t11_n81;
  t11_n74: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t11_n76;
  t11_n75: return 0.06755990535020828f;
  t11_n76: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t11_n78;
  t11_n77: return 0.010863068513572216f;
  t11_n78: if (E.getNumReferences() >= 3359911200 /*200884.5*/) goto t11_n80;
  t11_n79: return 0.11303015053272247f;
  t11_n80: return 0.06442137062549591f;
  t11_n81: if (E.getNumReferences() >= 3330296064 /*16420.5*/) goto t11_n83;
  t11_n82: return 0.142336905002594f;
  t11_n83: return 0.09601662307977676f;
  t11_n84: return 0.09947749227285385f;
  t11_n85: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t11_n87;
  t11_n86: return 0.07426085323095322f;
  t11_n87: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel))) goto t11_n89;
  t11_n88: return 0.09765138477087021f;
  t11_n89: if (E.getNumReferences() >= 3349178240 /*82127.0*/) goto t11_n91;
  t11_n90: return 0.10270489752292633f;
  t11_n91: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t11_n93;
  t11_n92: return 0.11512576043605804f;
  t11_n93: return 0.13655909895896912f;
  t11_n94: if (E.getFileProximityDistanceCost() >= 3256745984 /*39.5*/) goto t11_n134;
  t11_n95: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t11_n123;
  t11_n96: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t11_n108;
  t11_n97: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t11_n105;
  t11_n98: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t11_n100;
  t11_n99: return 0.06456999480724335f;
  t11_n100: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t11_n104;
  t11_n101: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t11_n103;
  t11_n102: return 0.03649178892374039f;
  t11_n103: return 0.09596733748912811f;
  t11_n104: return 0.0952289029955864f;
  t11_n105: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t11_n107;
  t11_n106: return 0.08887141197919846f;
  t11_n107: return 0.10093063116073608f;
  t11_n108: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t11_n120;
  t11_n109: if (E.getNumReferences() >= 3343545472 /*51828.5*/) goto t11_n119;
  t11_n110: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t11_n118;
  t11_n111: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t11_n113;
  t11_n112: return 0.09198067337274551f;
  t11_n113: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t11_n117;
  t11_n114: if (E.getFractionNameInContext() >= 3189238143 /*0.14835165441036224*/) goto t11_n116;
  t11_n115: return 0.035309065133333206f;
  t11_n116: return 0.09741976112127304f;
  t11_n117: return 0.09659988433122635f;
  t11_n118: return 0.1013430655002594f;
  t11_n119: return 0.102765753865242f;
  t11_n120: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t11_n122;
  t11_n121: return 0.10685274004936218f;
  t11_n122: return 0.09358696639537811f;
  t11_n123: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t11_n129;
  t11_n124: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t11_n128;
  t11_n125: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t11_n127;
  t11_n126: return 0.022222939878702164f;
  t11_n127: return 0.07425316423177719f;
  t11_n128: return 0.07514062523841858f;
  t11_n129: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t11_n133;
  t11_n130: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t11_n132;
  t11_n131: return 0.06979169696569443f;
  t11_n132: return 0.1023588627576828f;
  t11_n133: return 0.11179395020008087f;
  t11_n134: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t11_n200;
  t11_n135: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t11_n189;
  t11_n136: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t11_n138;
  t11_n137: return -0.10596225410699844f;
  t11_n138: if (E.getFractionNameInContext() >= 3181648450 /*0.08012820780277252*/) goto t11_n168;
  t11_n139: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t11_n161;
  t11_n140: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t11_n158;
  t11_n141: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t11_n145;
  t11_n142: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FunctionScope))) goto t11_n144;
  t11_n143: return -0.062219876796007156f;
  t11_n144: return 0.06333066523075104f;
  t11_n145: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t11_n155;
  t11_n146: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t11_n148;
  t11_n147: return 0.0005079416441731155f;
  t11_n148: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_UnionTag))) goto t11_n152;
  t11_n149: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t11_n151;
  t11_n150: return -0.009939918294548988f;
  t11_n151: return 0.14686870574951172f;
  t11_n152: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t11_n154;
  t11_n153: return 0.11052460968494415f;
  t11_n154: return -0.006499826908111572f;
  t11_n155: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t11_n157;
  t11_n156: return 0.06370719522237778f;
  t11_n157: return 0.11806726455688477f;
  t11_n158: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t11_n160;
  t11_n159: return -0.12119340151548386f;
  t11_n160: return 0.027118127793073654f;
  t11_n161: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t11_n167;
  t11_n162: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t11_n166;
  t11_n163: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t11_n165;
  t11_n164: return 0.05729557201266289f;
  t11_n165: return 0.08837217837572098f;
  t11_n166: return -0.02627704106271267f;
  t11_n167: return -0.10857166349887848f;
  t11_n168: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t11_n184;
  t11_n169: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t11_n183;
  t11_n170: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t11_n182;
  t11_n171: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t11_n177;
  t11_n172: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t11_n174;
  t11_n173: return -0.051800522953271866f;
  t11_n174: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t11_n176;
  t11_n175: return 0.02786341868340969f;
  t11_n176: return 0.05744291841983795f;
  t11_n177: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t11_n179;
  t11_n178: return 0.059250608086586f;
  t11_n179: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t11_n181;
  t11_n180: return 0.08944039046764374f;
  t11_n181: return 0.13422466814517975f;
  t11_n182: return -0.09150108695030212f;
  t11_n183: return 0.005437145009636879f;
  t11_n184: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t11_n188;
  t11_n185: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t11_n187;
  t11_n186: return 0.06641644984483719f;
  t11_n187: return 0.0938851609826088f;
  t11_n188: return -0.10257112234830856f;
  t11_n189: if (E.getFractionNameInContext() >= 3180161239 /*0.06904762238264084*/) goto t11_n197;
  t11_n190: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression))) goto t11_n194;
  t11_n191: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t11_n193;
  t11_n192: return 0.04741901159286499f;
  t11_n193: return -0.0735492929816246f;
  t11_n194: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t11_n196;
  t11_n195: return 0.007975660264492035f;
  t11_n196: return 0.08747051656246185f;
  t11_n197: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t11_n199;
  t11_n198: return 0.07277096062898636f;
  t11_n199: return 0.1001618504524231f;
  t11_n200: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t11_n204;
  t11_n201: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t11_n203;
  t11_n202: return -0.1293577402830124f;
  t11_n203: return 0.014565762132406235f;
  t11_n204: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t11_n228;
  t11_n205: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t11_n219;
  t11_n206: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t11_n210;
  t11_n207: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t11_n209;
  t11_n208: return -0.05082540214061737f;
  t11_n209: return 0.03311498835682869f;
  t11_n210: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t11_n218;
  t11_n211: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t11_n213;
  t11_n212: return 0.06078295037150383f;
  t11_n213: if (E.getScope() & (BIT(Scope_type::FunctionScope)|BIT(Scope_type::GlobalScope))) goto t11_n215;
  t11_n214: return -0.1234467402100563f;
  t11_n215: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t11_n217;
  t11_n216: return 0.005823640618473291f;
  t11_n217: return 0.07560564577579498f;
  t11_n218: return 0.10004030168056488f;
  t11_n219: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t11_n225;
  t11_n220: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t11_n224;
  t11_n221: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t11_n223;
  t11_n222: return 0.03659534081816673f;
  t11_n223: return 0.06718665361404419f;
  t11_n224: return 0.11222179234027863f;
  t11_n225: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t11_n227;
  t11_n226: return 0.08704851567745209f;
  t11_n227: return 0.10489346086978912f;
  t11_n228: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t11_n234;
  t11_n229: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t11_n233;
  t11_n230: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t11_n232;
  t11_n231: return 0.09286525100469589f;
  t11_n232: return 0.06717807799577713f;
  t11_n233: return -0.07979966700077057f;
  t11_n234: return 0.10135096311569214f;
  t11_n235: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t11_n243;
  t11_n236: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t11_n242;
  t11_n237: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t11_n241;
  t11_n238: if (E.getNumReferences() >= 3364994640 /*298482.5*/) goto t11_n240;
  t11_n239: return 0.07869399338960648f;
  t11_n240: return -0.03269942104816437f;
  t11_n241: return 0.1014917865395546f;
  t11_n242: return 0.11039459705352783f;
  t11_n243: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t11_n247;
  t11_n244: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t11_n246;
  t11_n245: return 0.10572925955057144f;
  t11_n246: return 0.043018776923418045f;
  t11_n247: return 0.11072034388780594f;
  t11_n248: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t11_n250;
  t11_n249: return 0.008406274020671844f;
  t11_n250: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t11_n254;
  t11_n251: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t11_n253;
  t11_n252: return 0.10650491714477539f;
  t11_n253: return -0.06472498923540115f;
  t11_n254: return 0.11138951778411865f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree12(const Example& E) {
  t12_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t12_n246;
  t12_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t12_n233;
  t12_n2: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t12_n94;
  t12_n3: if (E.getNumReferences() >= 3329785856 /*15904.0*/) goto t12_n71;
  t12_n4: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t12_n48;
  t12_n5: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t12_n27;
  t12_n6: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t12_n24;
  t12_n7: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t12_n21;
  t12_n8: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t12_n14;
  t12_n9: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t12_n11;
  t12_n10: return -0.05559629946947098f;
  t12_n11: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t12_n13;
  t12_n12: return 0.07537300884723663f;
  t12_n13: return 0.0015853744698688388f;
  t12_n14: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_UnionTag))) goto t12_n16;
  t12_n15: return -0.011718052439391613f;
  t12_n16: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t12_n20;
  t12_n17: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t12_n19;
  t12_n18: return 0.07121307402849197f;
  t12_n19: return 0.021258560940623283f;
  t12_n20: return 0.005377792753279209f;
  t12_n21: if (E.getFractionNameInContext() >= 3179562052 /*0.06458333134651184*/) goto t12_n23;
  t12_n22: return 0.02675715647637844f;
  t12_n23: return 0.07664120942354202f;
  t12_n24: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t12_n26;
  t12_n25: return 0.07987955212593079f;
  t12_n26: return 0.11176452785730362f;
  t12_n27: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t12_n35;
  t12_n28: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t12_n30;
  t12_n29: return -0.07848601043224335f;
  t12_n30: if (E.getNumReferences() >= 3303280640 /*1824.5*/) goto t12_n34;
  t12_n31: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t12_n33;
  t12_n32: return -0.059782493859529495f;
  t12_n33: return 0.042156048119068146f;
  t12_n34: return 0.06217409297823906f;
  t12_n35: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t12_n47;
  t12_n36: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t12_n46;
  t12_n37: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t12_n41;
  t12_n38: if (E.getNumReferences() >= 3278274560 /*230.5*/) goto t12_n40;
  t12_n39: return -0.03546789288520813f;
  t12_n40: return 0.051749009639024734f;
  t12_n41: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t12_n43;
  t12_n42: return 0.05278395116329193f;
  t12_n43: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t12_n45;
  t12_n44: return 0.00518062524497509f;
  t12_n45: return -0.06268112361431122f;
  t12_n46: return -0.11319289356470108f;
  t12_n47: return 0.019565405324101448f;
  t12_n48: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t12_n64;
  t12_n49: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t12_n59;
  t12_n50: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t12_n54;
  t12_n51: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t12_n53;
  t12_n52: return 0.027992937713861465f;
  t12_n53: return -0.02019602246582508f;
  t12_n54: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t12_n56;
  t12_n55: return 0.08644679933786392f;
  t12_n56: if (E.getNumReferences() >= 3276701696 /*206.5*/) goto t12_n58;
  t12_n57: return 0.01732068881392479f;
  t12_n58: return 0.07431712001562119f;
  t12_n59: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t12_n63;
  t12_n60: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t12_n62;
  t12_n61: return 0.05281434580683708f;
  t12_n62: return 0.09519091993570328f;
  t12_n63: return 0.1008511558175087f;
  t12_n64: if (E.getContextKind() & (BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement))) goto t12_n68;
  t12_n65: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t12_n67;
  t12_n66: return 0.059131499379873276f;
  t12_n67: return 0.09990186989307404f;
  t12_n68: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t12_n70;
  t12_n69: return 0.07008624821901321f;
  t12_n70: return 0.10248027741909027f;
  t12_n71: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t12_n83;
  t12_n72: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t12_n82;
  t12_n73: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t12_n77;
  t12_n74: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t12_n76;
  t12_n75: return 0.002299513667821884f;
  t12_n76: return 0.09741201996803284f;
  t12_n77: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t12_n79;
  t12_n78: return 0.050682444125413895f;
  t12_n79: if (E.getNumReferences() >= 3330296064 /*16420.5*/) goto t12_n81;
  t12_n80: return 0.1352178454399109f;
  t12_n81: return 0.09233834594488144f;
  t12_n82: return 0.0967678353190422f;
  t12_n83: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t12_n89;
  t12_n84: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t12_n86;
  t12_n85: return 0.0667901411652565f;
  t12_n86: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t12_n88;
  t12_n87: return 0.08878261595964432f;
  t12_n88: return 0.10673645883798599f;
  t12_n89: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t12_n91;
  t12_n90: return 0.11338748037815094f;
  t12_n91: if (E.getNumReferences() >= 3348232704 /*74740.0*/) goto t12_n93;
  t12_n92: return 0.10494104772806168f;
  t12_n93: return 0.13436424732208252f;
  t12_n94: if (E.getFileProximityDistanceCost() >= 3255435264 /*34.5*/) goto t12_n150;
  t12_n95: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t12_n135;
  t12_n96: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t12_n120;
  t12_n97: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t12_n115;
  t12_n98: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t12_n104;
  t12_n99: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t12_n101;
  t12_n100: return 0.047153957188129425f;
  t12_n101: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t12_n103;
  t12_n102: return 0.06536468118429184f;
  t12_n103: return 0.09178458154201508f;
  t12_n104: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t12_n114;
  t12_n105: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t12_n113;
  t12_n106: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t12_n108;
  t12_n107: return -0.01133006066083908f;
  t12_n108: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t12_n110;
  t12_n109: return 0.02885100431740284f;
  t12_n110: if (E.getFileProximityDistanceCost() >= 3244818432 /*14.5*/) goto t12_n112;
  t12_n111: return 0.1117219477891922f;
  t12_n112: return 0.08398330956697464f;
  t12_n113: return 0.09314404428005219f;
  t12_n114: return 0.09219783544540405f;
  t12_n115: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t12_n117;
  t12_n116: return 0.08485722541809082f;
  t12_n117: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t12_n119;
  t12_n118: return 0.061167389154434204f;
  t12_n119: return 0.10149285942316055f;
  t12_n120: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t12_n132;
  t12_n121: if (E.getNumReferences() >= 3343545472 /*51828.5*/) goto t12_n131;
  t12_n122: if (E.getFractionNameInContext() >= 3177025848 /*0.05409356951713562*/) goto t12_n128;
  t12_n123: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t12_n127;
  t12_n124: if (E.getNumReferences() >= 3318892544 /*6729.0*/) goto t12_n126;
  t12_n125: return 0.08826514333486557f;
  t12_n126: return -0.015111394226551056f;
  t12_n127: return 0.0839146301150322f;
  t12_n128: if (E.getNumReferences() >= 3260416000 /*53.5*/) goto t12_n130;
  t12_n129: return 0.08492014557123184f;
  t12_n130: return 0.09856394678354263f;
  t12_n131: return 0.10048643499612808f;
  t12_n132: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t12_n134;
  t12_n133: return 0.10489821434020996f;
  t12_n134: return 0.09038610011339188f;
  t12_n135: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t12_n145;
  t12_n136: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t12_n144;
  t12_n137: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t12_n143;
  t12_n138: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t12_n142;
  t12_n139: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t12_n141;
  t12_n140: return 0.062020882964134216f;
  t12_n141: return -0.009826294146478176f;
  t12_n142: return -0.04071251302957535f;
  t12_n143: return 0.06935008615255356f;
  t12_n144: return 0.07103943824768066f;
  t12_n145: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t12_n149;
  t12_n146: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t12_n148;
  t12_n147: return 0.06559499353170395f;
  t12_n148: return 0.10013443231582642f;
  t12_n149: return 0.11082863062620163f;
  t12_n150: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t12_n200;
  t12_n151: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t12_n193;
  t12_n152: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t12_n154;
  t12_n153: return -0.1042642593383789f;
  t12_n154: if (E.getFractionNameInContext() >= 3180849535 /*0.07417582720518112*/) goto t12_n176;
  t12_n155: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t12_n169;
  t12_n156: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t12_n166;
  t12_n157: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t12_n159;
  t12_n158: return -0.04899092763662338f;
  t12_n159: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t12_n163;
  t12_n160: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t12_n162;
  t12_n161: return 0.01907278783619404f;
  t12_n162: return -0.03642919659614563f;
  t12_n163: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t12_n165;
  t12_n164: return 0.06436183303594589f;
  t12_n165: return 0.11479420959949493f;
  t12_n166: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t12_n168;
  t12_n167: return -0.11545311659574509f;
  t12_n168: return 0.03223631531000137f;
  t12_n169: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t12_n175;
  t12_n170: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t12_n174;
  t12_n171: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t12_n173;
  t12_n172: return 0.05253491923213005f;
  t12_n173: return 0.08378932625055313f;
  t12_n174: return -0.026445893570780754f;
  t12_n175: return -0.10686219483613968f;
  t12_n176: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t12_n188;
  t12_n177: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t12_n187;
  t12_n178: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t12_n186;
  t12_n179: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t12_n185;
  t12_n180: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t12_n184;
  t12_n181: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t12_n183;
  t12_n182: return 0.026890954002738f;
  t12_n183: return -0.06177801266312599f;
  t12_n184: return 0.0491022951900959f;
  t12_n185: return 0.06423056870698929f;
  t12_n186: return -0.09437628090381622f;
  t12_n187: return -0.0020628604106605053f;
  t12_n188: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t12_n192;
  t12_n189: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t12_n191;
  t12_n190: return 0.06207434460520744f;
  t12_n191: return 0.09040419012308121f;
  t12_n192: return -0.10231799632310867f;
  t12_n193: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t12_n199;
  t12_n194: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t12_n198;
  t12_n195: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t12_n197;
  t12_n196: return 0.028677072376012802f;
  t12_n197: return 0.06302237510681152f;
  t12_n198: return 0.0872410386800766f;
  t12_n199: return 0.09671885520219803f;
  t12_n200: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t12_n204;
  t12_n201: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t12_n203;
  t12_n202: return -0.1258220672607422f;
  t12_n203: return 0.014546224847435951f;
  t12_n204: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t12_n226;
  t12_n205: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t12_n219;
  t12_n206: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t12_n210;
  t12_n207: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t12_n209;
  t12_n208: return -0.045668650418519974f;
  t12_n209: return 0.031128516420722008f;
  t12_n210: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t12_n218;
  t12_n211: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t12_n213;
  t12_n212: return 0.05558444932103157f;
  t12_n213: if (E.getScope() & (BIT(Scope_type::FunctionScope)|BIT(Scope_type::GlobalScope))) goto t12_n215;
  t12_n214: return -0.11540687084197998f;
  t12_n215: if (E.getFractionNameInContext() >= 3187950660 /*0.12916666269302368*/) goto t12_n217;
  t12_n216: return -0.010843856260180473f;
  t12_n217: return 0.06576400995254517f;
  t12_n218: return 0.09698328375816345f;
  t12_n219: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t12_n225;
  t12_n220: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t12_n224;
  t12_n221: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t12_n223;
  t12_n222: return 0.026429543271660805f;
  t12_n223: return 0.05687207356095314f;
  t12_n224: return 0.10937661677598953f;
  t12_n225: return 0.09075017273426056f;
  t12_n226: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t12_n232;
  t12_n227: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t12_n231;
  t12_n228: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t12_n230;
  t12_n229: return 0.08541548997163773f;
  t12_n230: return 0.10904605686664581f;
  t12_n231: return -0.07820446789264679f;
  t12_n232: return 0.09905092418193817f;
  t12_n233: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t12_n241;
  t12_n234: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t12_n240;
  t12_n235: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t12_n239;
  t12_n236: if (E.getNumReferences() >= 3364994640 /*298482.5*/) goto t12_n238;
  t12_n237: return 0.07429125159978867f;
  t12_n238: return -0.02978007309138775f;
  t12_n239: return 0.09862742573022842f;
  t12_n240: return 0.10901837795972824f;
  t12_n241: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t12_n245;
  t12_n242: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t12_n244;
  t12_n243: return 0.1037362664937973f;
  t12_n244: return 0.03973373398184776f;
  t12_n245: return 0.10949138551950455f;
  t12_n246: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t12_n248;
  t12_n247: return 0.007632675115019083f;
  t12_n248: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t12_n254;
  t12_n249: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t12_n251;
  t12_n250: return 0.10198338329792023f;
  t12_n251: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t12_n253;
  t12_n252: return 0.10679315030574799f;
  t12_n253: return 0.10522998124361038f;
  t12_n254: return 0.11027605086565018f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree13(const Example& E) {
  t13_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t13_n250;
  t13_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t13_n239;
  t13_n2: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t13_n106;
  t13_n3: if (E.getFractionNameInContext() >= 3190796208 /*0.1715686321258545*/) goto t13_n59;
  t13_n4: if (E.getNumReferences() >= 3328224256 /*14379.0*/) goto t13_n40;
  t13_n5: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t13_n11;
  t13_n6: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t13_n8;
  t13_n7: return -0.09262233972549438f;
  t13_n8: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t13_n10;
  t13_n9: return -0.013731924816966057f;
  t13_n10: return 0.05114782229065895f;
  t13_n11: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t13_n19;
  t13_n12: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t13_n16;
  t13_n13: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t13_n15;
  t13_n14: return 0.0059635229408741f;
  t13_n15: return 0.05250248685479164f;
  t13_n16: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t13_n18;
  t13_n17: return 0.08141354471445084f;
  t13_n18: return 0.11015407741069794f;
  t13_n19: if (E.getFractionNameInContext() >= 3174997342 /*0.04653679579496384*/) goto t13_n37;
  t13_n20: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t13_n32;
  t13_n21: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t13_n27;
  t13_n22: if (E.getNumReferences() >= 3279781888 /*253.5*/) goto t13_n24;
  t13_n23: return -0.06933102011680603f;
  t13_n24: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t13_n26;
  t13_n25: return -0.059248264878988266f;
  t13_n26: return 0.03997389227151871f;
  t13_n27: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t13_n31;
  t13_n28: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t13_n30;
  t13_n29: return 0.030864017084240913f;
  t13_n30: return -0.11218022555112839f;
  t13_n31: return -0.03209961578249931f;
  t13_n32: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t13_n36;
  t13_n33: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t13_n35;
  t13_n34: return 0.05410117283463478f;
  t13_n35: return -0.014553462155163288f;
  t13_n36: return 0.07547227293252945f;
  t13_n37: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t13_n39;
  t13_n38: return -0.01871749758720398f;
  t13_n39: return 0.017038024961948395f;
  t13_n40: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t13_n52;
  t13_n41: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t13_n51;
  t13_n42: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t13_n44;
  t13_n43: return 0.0013722338480874896f;
  t13_n44: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t13_n46;
  t13_n45: return 0.06315737217664719f;
  t13_n46: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t13_n48;
  t13_n47: return 0.011640964075922966f;
  t13_n48: if (E.getNumReferences() >= 3360215360 /*205637.0*/) goto t13_n50;
  t13_n49: return 0.10239474475383759f;
  t13_n50: return -0.10464171320199966f;
  t13_n51: return 0.09329398721456528f;
  t13_n52: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t13_n56;
  t13_n53: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t13_n55;
  t13_n54: return 0.04100467637181282f;
  t13_n55: return 0.093720942735672f;
  t13_n56: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t13_n58;
  t13_n57: return 0.09071315079927444f;
  t13_n58: return 0.10760438442230225f;
  t13_n59: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t13_n71;
  t13_n60: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t13_n68;
  t13_n61: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t13_n67;
  t13_n62: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t13_n66;
  t13_n63: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t13_n65;
  t13_n64: return 0.046716321259737015f;
  t13_n65: return 0.09881110489368439f;
  t13_n66: return 0.009823686443269253f;
  t13_n67: return 0.07751832902431488f;
  t13_n68: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel))) goto t13_n70;
  t13_n69: return 0.09719161689281464f;
  t13_n70: return 0.09814955294132233f;
  t13_n71: if (E.getNumReferences() >= 3326663680 /*12855.0*/) goto t13_n93;
  t13_n72: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t13_n86;
  t13_n73: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t13_n81;
  t13_n74: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t13_n80;
  t13_n75: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t13_n77;
  t13_n76: return -0.06395627558231354f;
  t13_n77: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t13_n79;
  t13_n78: return -0.01693691685795784f;
  t13_n79: return 0.048845790326595306f;
  t13_n80: return 0.05281538888812065f;
  t13_n81: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t13_n83;
  t13_n82: return 0.017344964668154716f;
  t13_n83: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t13_n85;
  t13_n84: return 0.03910089656710625f;
  t13_n85: return 0.08933230489492416f;
  t13_n86: if (E.getNumReferences() >= 3252420608 /*27.5*/) goto t13_n92;
  t13_n87: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t13_n89;
  t13_n88: return 0.05158054456114769f;
  t13_n89: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t13_n91;
  t13_n90: return 0.033883895725011826f;
  t13_n91: return 0.10468999296426773f;
  t13_n92: return 0.12411945313215256f;
  t13_n93: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t13_n97;
  t13_n94: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t13_n96;
  t13_n95: return 0.05460035800933838f;
  t13_n96: return 0.10375940054655075f;
  t13_n97: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type))) goto t13_n99;
  t13_n98: return 0.059352029114961624f;
  t13_n99: if (E.getNumReferences() >= 3348479616 /*76669.0*/) goto t13_n103;
  t13_n100: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t13_n102;
  t13_n101: return 0.09809787571430206f;
  t13_n102: return 0.12856654822826385f;
  t13_n103: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t13_n105;
  t13_n104: return 0.10479376465082169f;
  t13_n105: return 0.13152927160263062f;
  t13_n106: if (E.getFileProximityDistanceCost() >= 3255435264 /*34.5*/) goto t13_n148;
  t13_n107: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t13_n137;
  t13_n108: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t13_n124;
  t13_n109: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t13_n121;
  t13_n110: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t13_n116;
  t13_n111: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t13_n113;
  t13_n112: return 0.04216604307293892f;
  t13_n113: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t13_n115;
  t13_n114: return 0.06159448251128197f;
  t13_n115: return 0.08863931894302368f;
  t13_n116: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t13_n120;
  t13_n117: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t13_n119;
  t13_n118: return 0.02764124982059002f;
  t13_n119: return 0.09051144868135452f;
  t13_n120: return 0.08921173959970474f;
  t13_n121: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t13_n123;
  t13_n122: return 0.08121202886104584f;
  t13_n123: return 0.09560829401016235f;
  t13_n124: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t13_n134;
  t13_n125: if (E.getNumReferences() >= 3343545472 /*51828.5*/) goto t13_n133;
  t13_n126: if (E.getFractionNameInContext() >= 3177025848 /*0.05409356951713562*/) goto t13_n130;
  t13_n127: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t13_n129;
  t13_n128: return 0.035610854625701904f;
  t13_n129: return 0.08003649860620499f;
  t13_n130: if (E.getNumReferences() >= 3255173120 /*33.5*/) goto t13_n132;
  t13_n131: return 0.080368772149086f;
  t13_n132: return 0.09542851895093918f;
  t13_n133: return 0.0980902910232544f;
  t13_n134: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t13_n136;
  t13_n135: return 0.10326110571622849f;
  t13_n136: return 0.08743086457252502f;
  t13_n137: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t13_n143;
  t13_n138: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t13_n142;
  t13_n139: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t13_n141;
  t13_n140: return 0.04132414609193802f;
  t13_n141: return -0.008135493844747543f;
  t13_n142: return 0.06715595722198486f;
  t13_n143: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t13_n147;
  t13_n144: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t13_n146;
  t13_n145: return 0.06155102327466011f;
  t13_n146: return 0.09840735793113708f;
  t13_n147: return 0.11004095524549484f;
  t13_n148: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t13_n212;
  t13_n149: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t13_n203;
  t13_n150: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t13_n152;
  t13_n151: return -0.10278166085481644f;
  t13_n152: if (E.getFractionNameInContext() >= 3180849535 /*0.07417582720518112*/) goto t13_n178;
  t13_n153: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t13_n173;
  t13_n154: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t13_n170;
  t13_n155: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t13_n157;
  t13_n156: return -0.04392024502158165f;
  t13_n157: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t13_n167;
  t13_n158: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t13_n160;
  t13_n159: return -0.0009354445501230657f;
  t13_n160: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_UnionTag))) goto t13_n164;
  t13_n161: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t13_n163;
  t13_n162: return -0.024524129927158356f;
  t13_n163: return 0.13823598623275757f;
  t13_n164: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t13_n166;
  t13_n165: return 0.10239008814096451f;
  t13_n166: return -0.006537392269819975f;
  t13_n167: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t13_n169;
  t13_n168: return 0.0616023950278759f;
  t13_n169: return 0.11208570748567581f;
  t13_n170: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t13_n172;
  t13_n171: return -0.11070620268583298f;
  t13_n172: return 0.03137695789337158f;
  t13_n173: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t13_n177;
  t13_n174: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t13_n176;
  t13_n175: return 0.052884042263031006f;
  t13_n176: return -0.028905075043439865f;
  t13_n177: return -0.10558448731899261f;
  t13_n178: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t13_n198;
  t13_n179: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t13_n197;
  t13_n180: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t13_n196;
  t13_n181: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t13_n195;
  t13_n182: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t13_n188;
  t13_n183: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t13_n187;
  t13_n184: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t13_n186;
  t13_n185: return -0.09186765551567078f;
  t13_n186: return 0.09290814399719238f;
  t13_n187: return 0.023742061108350754f;
  t13_n188: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t13_n190;
  t13_n189: return 0.02316410467028618f;
  t13_n190: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t13_n194;
  t13_n191: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t13_n193;
  t13_n192: return 0.09037838131189346f;
  t13_n193: return -0.21891961991786957f;
  t13_n194: return 0.11824428290128708f;
  t13_n195: return 0.04981320723891258f;
  t13_n196: return -0.09690210223197937f;
  t13_n197: return -0.0047273277305066586f;
  t13_n198: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t13_n202;
  t13_n199: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t13_n201;
  t13_n200: return 0.05816428363323212f;
  t13_n201: return 0.08639510720968246f;
  t13_n202: return -0.10004466027021408f;
  t13_n203: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t13_n211;
  t13_n204: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t13_n210;
  t13_n205: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t13_n207;
  t13_n206: return 0.049999676644802094f;
  t13_n207: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t13_n209;
  t13_n208: return -0.056144893169403076f;
  t13_n209: return 0.07693495601415634f;
  t13_n210: return 0.08353525400161743f;
  t13_n211: return 0.09304194152355194f;
  t13_n212: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t13_n216;
  t13_n213: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t13_n215;
  t13_n214: return -0.12331246584653854f;
  t13_n215: return 0.014662949368357658f;
  t13_n216: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t13_n234;
  t13_n217: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t13_n233;
  t13_n218: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t13_n228;
  t13_n219: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t13_n221;
  t13_n220: return 0.0063010710291564465f;
  t13_n221: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t13_n227;
  t13_n222: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t13_n226;
  t13_n223: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t13_n225;
  t13_n224: return 0.044518955051898956f;
  t13_n225: return -0.021241430193185806f;
  t13_n226: return 0.0587582103908062f;
  t13_n227: return 0.09403622895479202f;
  t13_n228: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t13_n232;
  t13_n229: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t13_n231;
  t13_n230: return 0.03935341536998749f;
  t13_n231: return 0.10666700452566147f;
  t13_n232: return 0.08747990429401398f;
  t13_n233: return -0.137372687458992f;
  t13_n234: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t13_n238;
  t13_n235: if (E.getFractionNameInContext() >= 3175960628 /*0.05012531578540802*/) goto t13_n237;
  t13_n236: return 0.07309982180595398f;
  t13_n237: return 0.09031807631254196f;
  t13_n238: return 0.09669604152441025f;
  t13_n239: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t13_n245;
  t13_n240: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t13_n244;
  t13_n241: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t13_n243;
  t13_n242: return 0.03225594013929367f;
  t13_n243: return 0.09532467275857925f;
  t13_n244: return 0.10765745490789413f;
  t13_n245: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t13_n249;
  t13_n246: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t13_n248;
  t13_n247: return 0.0548374317586422f;
  t13_n248: return 0.10297077149152756f;
  t13_n249: return 0.10833121091127396f;
  t13_n250: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t13_n252;
  t13_n251: return 0.007940222509205341f;
  t13_n252: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t13_n254;
  t13_n253: return 0.1029914915561676f;
  t13_n254: return 0.10931379348039627f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree14(const Example& E) {
  t14_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t14_n248;
  t14_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t14_n237;
  t14_n2: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t14_n98;
  t14_n3: if (E.getFractionNameInContext() >= 3187177592 /*0.12132352590560913*/) goto t14_n43;
  t14_n4: if (E.getNumReferences() >= 3328224256 /*14379.0*/) goto t14_n32;
  t14_n5: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t14_n23;
  t14_n6: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t14_n12;
  t14_n7: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t14_n9;
  t14_n8: return -0.0337882861495018f;
  t14_n9: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t14_n11;
  t14_n10: return 0.026844382286071777f;
  t14_n11: return 0.09536668658256531f;
  t14_n12: if (E.getNumReferences() >= 3301085184 /*1556.5*/) goto t14_n22;
  t14_n13: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t14_n15;
  t14_n14: return -0.07278461754322052f;
  t14_n15: if (E.getNumReferences() >= 3259105280 /*48.5*/) goto t14_n17;
  t14_n16: return -0.10537638515233994f;
  t14_n17: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t14_n21;
  t14_n18: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t14_n20;
  t14_n19: return -0.05935904383659363f;
  t14_n20: return 0.03485177457332611f;
  t14_n21: return -0.08464941382408142f;
  t14_n22: return -0.009926775470376015f;
  t14_n23: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t14_n31;
  t14_n24: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t14_n26;
  t14_n25: return -0.022947324439883232f;
  t14_n26: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t14_n28;
  t14_n27: return 0.04634543135762215f;
  t14_n28: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t14_n30;
  t14_n29: return 0.00815068930387497f;
  t14_n30: return -0.043038949370384216f;
  t14_n31: return -0.1104554682970047f;
  t14_n32: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t14_n42;
  t14_n33: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t14_n37;
  t14_n34: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t14_n36;
  t14_n35: return 0.0008149142959155142f;
  t14_n36: return 0.0473465733230114f;
  t14_n37: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t14_n41;
  t14_n38: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t14_n40;
  t14_n39: return 0.037005748599767685f;
  t14_n40: return 0.09031926840543747f;
  t14_n41: return 0.09156546741724014f;
  t14_n42: return 0.09039755910634995f;
  t14_n43: if (E.getNumReferences() >= 3303284736 /*1825.0*/) goto t14_n87;
  t14_n44: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t14_n64;
  t14_n45: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t14_n61;
  t14_n46: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t14_n54;
  t14_n47: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t14_n53;
  t14_n48: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t14_n52;
  t14_n49: if (E.getFractionNameInContext() >= 3197638680 /*0.2970588207244873*/) goto t14_n51;
  t14_n50: return 0.02735799364745617f;
  t14_n51: return 0.058644942939281464f;
  t14_n52: return 0.09457922726869583f;
  t14_n53: return -0.003013188485056162f;
  t14_n54: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t14_n58;
  t14_n55: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t14_n57;
  t14_n56: return 0.060237590223550797f;
  t14_n57: return 0.09105715900659561f;
  t14_n58: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t14_n60;
  t14_n59: return -0.1768762320280075f;
  t14_n60: return 0.10029668360948563f;
  t14_n61: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel))) goto t14_n63;
  t14_n62: return 0.07979532331228256f;
  t14_n63: return 0.09093733131885529f;
  t14_n64: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t14_n80;
  t14_n65: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t14_n73;
  t14_n66: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t14_n72;
  t14_n67: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t14_n69;
  t14_n68: return -0.07094211876392365f;
  t14_n69: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t14_n71;
  t14_n70: return -0.029025427997112274f;
  t14_n71: return 0.03610840439796448f;
  t14_n72: return 0.04161053150892258f;
  t14_n73: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t14_n75;
  t14_n74: return 0.013189781457185745f;
  t14_n75: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t14_n79;
  t14_n76: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t14_n78;
  t14_n77: return 0.08243356645107269f;
  t14_n78: return 0.008293933235108852f;
  t14_n79: return 0.08574043959379196f;
  t14_n80: if (E.getNumReferences() >= 3252420608 /*27.5*/) goto t14_n86;
  t14_n81: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t14_n83;
  t14_n82: return 0.0484749898314476f;
  t14_n83: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t14_n85;
  t14_n84: return 0.03134290874004364f;
  t14_n85: return 0.10526005178689957f;
  t14_n86: return 0.12123949080705643f;
  t14_n87: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t14_n93;
  t14_n88: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t14_n90;
  t14_n89: return 0.056422773748636246f;
  t14_n90: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t14_n92;
  t14_n91: return 0.07199957221746445f;
  t14_n92: return 0.09739232808351517f;
  t14_n93: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t14_n95;
  t14_n94: return 0.0890495553612709f;
  t14_n95: if (E.getNumReferences() >= 3348641152 /*77931.0*/) goto t14_n97;
  t14_n96: return 0.10035528242588043f;
  t14_n97: return 0.12886305153369904f;
  t14_n98: if (E.getFileProximityDistanceCost() >= 3255435264 /*34.5*/) goto t14_n146;
  t14_n99: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t14_n127;
  t14_n100: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t14_n122;
  t14_n101: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t14_n113;
  t14_n102: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t14_n112;
  t14_n103: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t14_n107;
  t14_n104: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t14_n106;
  t14_n105: return 0.05449357628822327f;
  t14_n106: return -0.0015944893239066005f;
  t14_n107: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t14_n111;
  t14_n108: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t14_n110;
  t14_n109: return 0.09067186713218689f;
  t14_n110: return -0.04569403454661369f;
  t14_n111: return 0.0838189572095871f;
  t14_n112: return 0.08294099569320679f;
  t14_n113: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t14_n119;
  t14_n114: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t14_n118;
  t14_n115: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t14_n117;
  t14_n116: return 0.08595910668373108f;
  t14_n117: return 0.1081356331706047f;
  t14_n118: return -0.012317130342125893f;
  t14_n119: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t14_n121;
  t14_n120: return 0.0697946771979332f;
  t14_n121: return 0.08895917236804962f;
  t14_n122: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t14_n126;
  t14_n123: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t14_n125;
  t14_n124: return 0.014386285096406937f;
  t14_n125: return 0.06317558884620667f;
  t14_n126: return 0.06305764615535736f;
  t14_n127: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t14_n145;
  t14_n128: if (E.getNumReferences() >= 3359104096 /*188273.5*/) goto t14_n144;
  t14_n129: if (E.getFractionNameInContext() >= 3177025848 /*0.05409356951713562*/) goto t14_n139;
  t14_n130: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t14_n136;
  t14_n131: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t14_n135;
  t14_n132: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t14_n134;
  t14_n133: return 0.07399631291627884f;
  t14_n134: return 0.03227456286549568f;
  t14_n135: return 0.09150465577840805f;
  t14_n136: if (E.getNumReferences() >= 3352108224 /*105017.5*/) goto t14_n138;
  t14_n137: return 0.09529575705528259f;
  t14_n138: return -0.09803763031959534f;
  t14_n139: if (E.getNumReferences() >= 3332163840 /*20068.5*/) goto t14_n143;
  t14_n140: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t14_n142;
  t14_n141: return 0.06623811274766922f;
  t14_n142: return 0.08802172541618347f;
  t14_n143: return 0.1029152050614357f;
  t14_n144: return 0.10383038967847824f;
  t14_n145: return 0.09434624761343002f;
  t14_n146: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t14_n214;
  t14_n147: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t14_n205;
  t14_n148: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t14_n150;
  t14_n149: return -0.10120445489883423f;
  t14_n150: if (E.getFractionNameInContext() >= 3187950660 /*0.12916666269302368*/) goto t14_n186;
  t14_n151: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t14_n177;
  t14_n152: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t14_n176;
  t14_n153: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t14_n171;
  t14_n154: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t14_n158;
  t14_n155: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t14_n157;
  t14_n156: return -0.04695713520050049f;
  t14_n157: return 0.06361015886068344f;
  t14_n158: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t14_n164;
  t14_n159: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t14_n161;
  t14_n160: return -0.06782558560371399f;
  t14_n161: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t14_n163;
  t14_n162: return -0.11956846714019775f;
  t14_n163: return 0.025550849735736847f;
  t14_n164: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t14_n168;
  t14_n165: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t14_n167;
  t14_n166: return 0.03468400612473488f;
  t14_n167: return 0.13511237502098083f;
  t14_n168: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t14_n170;
  t14_n169: return 0.1254875808954239f;
  t14_n170: return 0.10935458540916443f;
  t14_n171: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t14_n175;
  t14_n172: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t14_n174;
  t14_n173: return 0.0298733152449131f;
  t14_n174: return 0.06930091232061386f;
  t14_n175: return -0.10294905304908752f;
  t14_n176: return -0.028260396793484688f;
  t14_n177: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t14_n179;
  t14_n178: return -0.10712731629610062f;
  t14_n179: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t14_n183;
  t14_n180: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel))) goto t14_n182;
  t14_n181: return -0.05711158365011215f;
  t14_n182: return 0.1213301494717598f;
  t14_n183: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t14_n185;
  t14_n184: return 0.03682245314121246f;
  t14_n185: return 0.07917479425668716f;
  t14_n186: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t14_n204;
  t14_n187: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t14_n195;
  t14_n188: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t14_n192;
  t14_n189: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t14_n191;
  t14_n190: return 0.03474780544638634f;
  t14_n191: return -0.12481459230184555f;
  t14_n192: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t14_n194;
  t14_n193: return 0.028782416135072708f;
  t14_n194: return 0.06257394701242447f;
  t14_n195: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t14_n201;
  t14_n196: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t14_n200;
  t14_n197: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t14_n199;
  t14_n198: return 0.047610461711883545f;
  t14_n199: return -0.24455896019935608f;
  t14_n200: return 0.0824362114071846f;
  t14_n201: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol))) goto t14_n203;
  t14_n202: return 0.07607262581586838f;
  t14_n203: return 0.11907033622264862f;
  t14_n204: return -0.09496340155601501f;
  t14_n205: if (E.getFractionNameInContext() >= 3180161239 /*0.06904762238264084*/) goto t14_n211;
  t14_n206: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol))) goto t14_n210;
  t14_n207: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t14_n209;
  t14_n208: return 0.0345756858587265f;
  t14_n209: return -0.06949637085199356f;
  t14_n210: return 0.06082748994231224f;
  t14_n211: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t14_n213;
  t14_n212: return 0.061605457216501236f;
  t14_n213: return 0.08910807222127914f;
  t14_n214: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t14_n218;
  t14_n215: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t14_n217;
  t14_n216: return -0.12100532650947571f;
  t14_n217: return 0.013620343990623951f;
  t14_n218: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t14_n232;
  t14_n219: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t14_n231;
  t14_n220: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t14_n230;
  t14_n221: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t14_n223;
  t14_n222: return 0.022218333557248116f;
  t14_n223: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t14_n229;
  t14_n224: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t14_n226;
  t14_n225: return 0.028450047597289085f;
  t14_n226: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t14_n228;
  t14_n227: return 0.046204887330532074f;
  t14_n228: return 0.0883917510509491f;
  t14_n229: return 0.08392440527677536f;
  t14_n230: return 0.06115452200174332f;
  t14_n231: return -0.129404217004776f;
  t14_n232: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t14_n236;
  t14_n233: if (E.getFractionNameInContext() >= 3175960628 /*0.05012531578540802*/) goto t14_n235;
  t14_n234: return 0.06735528260469437f;
  t14_n235: return 0.08810502290725708f;
  t14_n236: return 0.09451346844434738f;
  t14_n237: if (E.getNumReferences() >= 3376956888 /*820317.5*/) goto t14_n245;
  t14_n238: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t14_n242;
  t14_n239: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t14_n241;
  t14_n240: return 0.03711801767349243f;
  t14_n241: return 0.10502982884645462f;
  t14_n242: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t14_n244;
  t14_n243: return 0.09249448776245117f;
  t14_n244: return 0.10773327946662903f;
  t14_n245: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t14_n247;
  t14_n246: return 0.10247695446014404f;
  t14_n247: return 0.1091419905424118f;
  t14_n248: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t14_n250;
  t14_n249: return 0.0072029950097203255f;
  t14_n250: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t14_n254;
  t14_n251: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t14_n253;
  t14_n252: return 0.09782491624355316f;
  t14_n253: return 0.1032983735203743f;
  t14_n254: return 0.10852354764938354f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree15(const Example& E) {
  t15_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t15_n248;
  t15_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t15_n239;
  t15_n2: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t15_n104;
  t15_n3: if (E.getFractionNameInContext() >= 3184099116 /*0.09838709235191345*/) goto t15_n47;
  t15_n4: if (E.getNumReferences() >= 3328224256 /*14379.0*/) goto t15_n34;
  t15_n5: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t15_n11;
  t15_n6: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t15_n8;
  t15_n7: return -0.0911315530538559f;
  t15_n8: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t15_n10;
  t15_n9: return 0.03515787422657013f;
  t15_n10: return -0.016008706763386726f;
  t15_n11: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t15_n17;
  t15_n12: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t15_n16;
  t15_n13: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t15_n15;
  t15_n14: return 0.002784733660519123f;
  t15_n15: return 0.04697931930422783f;
  t15_n16: return 0.08893464505672455f;
  t15_n17: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t15_n19;
  t15_n18: return -0.06244746595621109f;
  t15_n19: if (E.getNumReferences() >= 3294044160 /*860.5*/) goto t15_n33;
  t15_n20: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t15_n26;
  t15_n21: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t15_n25;
  t15_n22: if (E.getFileProximityDistanceCost() >= 3253993472 /*30.5*/) goto t15_n24;
  t15_n23: return -0.013002175837755203f;
  t15_n24: return 0.03448950871825218f;
  t15_n25: return -0.12437527626752853f;
  t15_n26: if (E.getNumReferences() >= 3247702016 /*18.5*/) goto t15_n28;
  t15_n27: return -0.08890199661254883f;
  t15_n28: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t15_n30;
  t15_n29: return 0.025974851101636887f;
  t15_n30: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t15_n32;
  t15_n31: return 0.06979309022426605f;
  t15_n32: return -0.07731132954359055f;
  t15_n33: return 0.03164903074502945f;
  t15_n34: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t15_n46;
  t15_n35: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t15_n43;
  t15_n36: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t15_n42;
  t15_n37: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t15_n39;
  t15_n38: return 0.0409991517663002f;
  t15_n39: if (E.getNumReferences() >= 3361959232 /*232885.0*/) goto t15_n41;
  t15_n40: return 0.09662064909934998f;
  t15_n41: return 0.0435328483581543f;
  t15_n42: return 0.0016195903299376369f;
  t15_n43: if (E.getNumReferences() >= 3346297984 /*62580.5*/) goto t15_n45;
  t15_n44: return 0.05231987312436104f;
  t15_n45: return 0.08904615789651871f;
  t15_n46: return 0.0866396501660347f;
  t15_n47: if (E.getNumReferences() >= 3303280640 /*1824.5*/) goto t15_n93;
  t15_n48: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t15_n68;
  t15_n49: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t15_n63;
  t15_n50: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t15_n58;
  t15_n51: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t15_n55;
  t15_n52: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t15_n54;
  t15_n53: return 0.03572545573115349f;
  t15_n54: return 0.09131273627281189f;
  t15_n55: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t15_n57;
  t15_n56: return -0.011268144473433495f;
  t15_n57: return 0.05544014647603035f;
  t15_n58: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel))) goto t15_n60;
  t15_n59: return 0.06772947311401367f;
  t15_n60: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t15_n62;
  t15_n61: return 0.0733523815870285f;
  t15_n62: return 0.10387175530195236f;
  t15_n63: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t15_n67;
  t15_n64: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t15_n66;
  t15_n65: return 0.05829944461584091f;
  t15_n66: return 0.08731140196323395f;
  t15_n67: return 0.09294410794973373f;
  t15_n68: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t15_n86;
  t15_n69: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t15_n77;
  t15_n70: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t15_n76;
  t15_n71: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t15_n73;
  t15_n72: return -0.07100468873977661f;
  t15_n73: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t15_n75;
  t15_n74: return -0.028808599337935448f;
  t15_n75: return 0.034276243299245834f;
  t15_n76: return 0.03953590989112854f;
  t15_n77: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t15_n83;
  t15_n78: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t15_n82;
  t15_n79: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t15_n81;
  t15_n80: return 0.044608231633901596f;
  t15_n81: return 0.0974775180220604f;
  t15_n82: return 0.001525506959296763f;
  t15_n83: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t15_n85;
  t15_n84: return 0.03503930941224098f;
  t15_n85: return 0.08171176165342331f;
  t15_n86: if (E.getNumReferences() >= 3245867008 /*15.5*/) goto t15_n92;
  t15_n87: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t15_n89;
  t15_n88: return 0.045305829495191574f;
  t15_n89: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t15_n91;
  t15_n90: return 0.031257905066013336f;
  t15_n91: return 0.09844062477350235f;
  t15_n92: return 0.11242365092039108f;
  t15_n93: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t15_n99;
  t15_n94: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t15_n96;
  t15_n95: return 0.0552511066198349f;
  t15_n96: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t15_n98;
  t15_n97: return 0.07061053067445755f;
  t15_n98: return 0.09359394013881683f;
  t15_n99: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t15_n101;
  t15_n100: return 0.08555863052606583f;
  t15_n101: if (E.getNumReferences() >= 3348641152 /*77931.0*/) goto t15_n103;
  t15_n102: return 0.09798385947942734f;
  t15_n103: return 0.12616249918937683f;
  t15_n104: if (E.getFileProximityDistanceCost() >= 3255435264 /*34.5*/) goto t15_n148;
  t15_n105: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t15_n139;
  t15_n106: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t15_n130;
  t15_n107: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t15_n121;
  t15_n108: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t15_n120;
  t15_n109: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t15_n115;
  t15_n110: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t15_n114;
  t15_n111: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t15_n113;
  t15_n112: return 0.045023318380117416f;
  t15_n113: return 0.07593867182731628f;
  t15_n114: return -0.0029398594051599503f;
  t15_n115: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t15_n119;
  t15_n116: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t15_n118;
  t15_n117: return 0.08726586401462555f;
  t15_n118: return -0.04171106219291687f;
  t15_n119: return 0.08053300529718399f;
  t15_n120: return 0.07992244511842728f;
  t15_n121: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t15_n127;
  t15_n122: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t15_n126;
  t15_n123: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t15_n125;
  t15_n124: return 0.08214253187179565f;
  t15_n125: return 0.10651647299528122f;
  t15_n126: return -0.014508834108710289f;
  t15_n127: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t15_n129;
  t15_n128: return 0.06571376323699951f;
  t15_n129: return 0.08564937859773636f;
  t15_n130: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t15_n138;
  t15_n131: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t15_n137;
  t15_n132: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t15_n136;
  t15_n133: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t15_n135;
  t15_n134: return 0.05087350681424141f;
  t15_n135: return -0.018062081187963486f;
  t15_n136: return -0.05625011771917343f;
  t15_n137: return 0.060641098767519f;
  t15_n138: return 0.05848066136240959f;
  t15_n139: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t15_n147;
  t15_n140: if (E.getNumReferences() >= 3359104096 /*188273.5*/) goto t15_n146;
  t15_n141: if (E.getFractionNameInContext() >= 3177025848 /*0.05409356951713562*/) goto t15_n143;
  t15_n142: return 0.06722456216812134f;
  t15_n143: if (E.getNumReferences() >= 3332163840 /*20068.5*/) goto t15_n145;
  t15_n144: return 0.0806601271033287f;
  t15_n145: return 0.10265659540891647f;
  t15_n146: return 0.10232718288898468f;
  t15_n147: return 0.0926566943526268f;
  t15_n148: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t15_n214;
  t15_n149: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t15_n205;
  t15_n150: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t15_n152;
  t15_n151: return -0.09958402067422867f;
  t15_n152: if (E.getFractionNameInContext() >= 3187950660 /*0.12916666269302368*/) goto t15_n188;
  t15_n153: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t15_n179;
  t15_n154: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t15_n178;
  t15_n155: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t15_n173;
  t15_n156: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t15_n160;
  t15_n157: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t15_n159;
  t15_n158: return -0.04230114817619324f;
  t15_n159: return 0.05907713994383812f;
  t15_n160: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t15_n166;
  t15_n161: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t15_n163;
  t15_n162: return -0.06496978551149368f;
  t15_n163: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t15_n165;
  t15_n164: return -0.1123284250497818f;
  t15_n165: return 0.023184198886156082f;
  t15_n166: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t15_n170;
  t15_n167: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t15_n169;
  t15_n168: return 0.036197058856487274f;
  t15_n169: return 0.12934742867946625f;
  t15_n170: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t15_n172;
  t15_n171: return 0.11672291904687881f;
  t15_n172: return 0.1076982393860817f;
  t15_n173: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t15_n177;
  t15_n174: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t15_n176;
  t15_n175: return 0.0261534433811903f;
  t15_n176: return 0.06582117825746536f;
  t15_n177: return -0.10146594047546387f;
  t15_n178: return -0.026385655626654625f;
  t15_n179: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t15_n181;
  t15_n180: return -0.10274237394332886f;
  t15_n181: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t15_n185;
  t15_n182: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel))) goto t15_n184;
  t15_n183: return -0.0555889867246151f;
  t15_n184: return 0.11551547050476074f;
  t15_n185: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t15_n187;
  t15_n186: return 0.03358772024512291f;
  t15_n187: return 0.07377468049526215f;
  t15_n188: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t15_n204;
  t15_n189: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t15_n197;
  t15_n190: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t15_n194;
  t15_n191: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t15_n193;
  t15_n192: return 0.0307061318308115f;
  t15_n193: return -0.11306288838386536f;
  t15_n194: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t15_n196;
  t15_n195: return 0.027072608470916748f;
  t15_n196: return 0.05921868979930878f;
  t15_n197: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t15_n201;
  t15_n198: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t15_n200;
  t15_n199: return 0.04163969308137894f;
  t15_n200: return 0.08194580674171448f;
  t15_n201: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol))) goto t15_n203;
  t15_n202: return 0.07372362166643143f;
  t15_n203: return 0.11270631104707718f;
  t15_n204: return -0.09284079819917679f;
  t15_n205: if (E.getFractionNameInContext() >= 3180161239 /*0.06904762238264084*/) goto t15_n211;
  t15_n206: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol))) goto t15_n210;
  t15_n207: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t15_n209;
  t15_n208: return 0.03238915652036667f;
  t15_n209: return -0.07166169583797455f;
  t15_n210: return 0.05676628649234772f;
  t15_n211: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t15_n213;
  t15_n212: return 0.058037903159856796f;
  t15_n213: return 0.08564498275518417f;
  t15_n214: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t15_n216;
  t15_n215: return -0.03788677603006363f;
  t15_n216: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t15_n234;
  t15_n217: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t15_n229;
  t15_n218: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t15_n224;
  t15_n219: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t15_n221;
  t15_n220: return -0.02381359227001667f;
  t15_n221: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t15_n223;
  t15_n222: return 0.023788420483469963f;
  t15_n223: return 0.0937814861536026f;
  t15_n224: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t15_n228;
  t15_n225: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t15_n227;
  t15_n226: return 0.018626442179083824f;
  t15_n227: return 0.04711455851793289f;
  t15_n228: return 0.10346589982509613f;
  t15_n229: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t15_n233;
  t15_n230: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t15_n232;
  t15_n231: return -0.038424428552389145f;
  t15_n232: return 0.051702357828617096f;
  t15_n233: return 0.08116085082292557f;
  t15_n234: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t15_n238;
  t15_n235: if (E.getFractionNameInContext() >= 3175960628 /*0.05012531578540802*/) goto t15_n237;
  t15_n236: return 0.06374350190162659f;
  t15_n237: return 0.08540398627519608f;
  t15_n238: return 0.092014379799366f;
  t15_n239: if (E.getNumReferences() >= 3376956888 /*820317.5*/) goto t15_n247;
  t15_n240: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t15_n244;
  t15_n241: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t15_n243;
  t15_n242: return 0.03399127721786499f;
  t15_n243: return 0.10344266146421432f;
  t15_n244: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t15_n246;
  t15_n245: return 0.09022273123264313f;
  t15_n246: return 0.10644551366567612f;
  t15_n247: return 0.10491655021905899f;
  t15_n248: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_Type))) goto t15_n250;
  t15_n249: return 0.0007781512686051428f;
  t15_n250: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t15_n254;
  t15_n251: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t15_n253;
  t15_n252: return 0.09560608863830566f;
  t15_n253: return 0.10188520699739456f;
  t15_n254: return 0.10766410827636719f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree16(const Example& E) {
  t16_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t16_n248;
  t16_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t16_n241;
  t16_n2: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t16_n104;
  t16_n3: if (E.getFractionNameInContext() >= 3181648450 /*0.08012820780277252*/) goto t16_n59;
  t16_n4: if (E.getNumReferences() >= 3301085184 /*1556.5*/) goto t16_n46;
  t16_n5: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t16_n19;
  t16_n6: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t16_n12;
  t16_n7: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t16_n9;
  t16_n8: return -0.030070947483181953f;
  t16_n9: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t16_n11;
  t16_n10: return 0.028386536985635757f;
  t16_n11: return 0.09603055566549301f;
  t16_n12: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t16_n14;
  t16_n13: return -0.06722275912761688f;
  t16_n14: if (E.getNumReferences() >= 3259367424 /*49.5*/) goto t16_n16;
  t16_n15: return -0.10547428578138351f;
  t16_n16: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t16_n18;
  t16_n17: return 0.0013825841015204787f;
  t16_n18: return -0.08178726583719254f;
  t16_n19: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t16_n45;
  t16_n20: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t16_n36;
  t16_n21: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t16_n27;
  t16_n22: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t16_n24;
  t16_n23: return -0.007045823615044355f;
  t16_n24: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t16_n26;
  t16_n25: return 0.061797674745321274f;
  t16_n26: return 0.09994997829198837f;
  t16_n27: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t16_n29;
  t16_n28: return -0.025571385398507118f;
  t16_n29: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t16_n31;
  t16_n30: return 0.0424933023750782f;
  t16_n31: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t16_n35;
  t16_n32: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t16_n34;
  t16_n33: return -0.08138182759284973f;
  t16_n34: return 0.012796858325600624f;
  t16_n35: return -0.05747435986995697f;
  t16_n36: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel))) goto t16_n38;
  t16_n37: return -0.017809823155403137f;
  t16_n38: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t16_n40;
  t16_n39: return -0.18460504710674286f;
  t16_n40: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t16_n42;
  t16_n41: return -0.0012865957105532289f;
  t16_n42: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t16_n44;
  t16_n43: return 0.08325820416212082f;
  t16_n44: return 0.054554883390665054f;
  t16_n45: return -0.1077837273478508f;
  t16_n46: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t16_n54;
  t16_n47: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t16_n51;
  t16_n48: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t16_n50;
  t16_n49: return -0.013270474970340729f;
  t16_n50: return 0.057303622364997864f;
  t16_n51: if (E.getNumReferences() >= 3338664448 /*32765.0*/) goto t16_n53;
  t16_n52: return 0.04779139906167984f;
  t16_n53: return 0.08678412437438965f;
  t16_n54: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t16_n58;
  t16_n55: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t16_n57;
  t16_n56: return 0.03450498729944229f;
  t16_n57: return 0.08551628887653351f;
  t16_n58: return 0.08653297275304794f;
  t16_n59: if (E.getNumReferences() >= 3309346816 /*3082.0*/) goto t16_n93;
  t16_n60: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t16_n74;
  t16_n61: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t16_n69;
  t16_n62: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t16_n68;
  t16_n63: if (E.getFractionNameInContext() >= 3199184816 /*0.343137264251709*/) goto t16_n67;
  t16_n64: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t16_n66;
  t16_n65: return 0.010164092294871807f;
  t16_n66: return 0.07780852913856506f;
  t16_n67: return 0.05323250591754913f;
  t16_n68: return 0.07281036674976349f;
  t16_n69: if (E.getNumReferences() >= 3255173120 /*33.5*/) goto t16_n73;
  t16_n70: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t16_n72;
  t16_n71: return 0.06313673406839371f;
  t16_n72: return 0.09780406951904297f;
  t16_n73: return 0.09863559156656265f;
  t16_n74: if (E.getFileProximityDistanceCost() >= 3255173120 /*33.5*/) goto t16_n88;
  t16_n75: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t16_n85;
  t16_n76: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t16_n80;
  t16_n77: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t16_n79;
  t16_n78: return -0.07145851105451584f;
  t16_n79: return 0.03248584270477295f;
  t16_n80: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type))) goto t16_n82;
  t16_n81: return -0.004843064583837986f;
  t16_n82: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t16_n84;
  t16_n83: return 0.02618560753762722f;
  t16_n84: return 0.05786756053566933f;
  t16_n85: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t16_n87;
  t16_n86: return 0.041096899658441544f;
  t16_n87: return 0.08808881789445877f;
  t16_n88: if (E.getFractionNameInContext() >= 3193183554 /*0.20714285969734192*/) goto t16_n92;
  t16_n89: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t16_n91;
  t16_n90: return 0.01701187528669834f;
  t16_n91: return 0.07517288625240326f;
  t16_n92: return 0.09053497016429901f;
  t16_n93: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t16_n99;
  t16_n94: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t16_n96;
  t16_n95: return 0.053896088153123856f;
  t16_n96: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t16_n98;
  t16_n97: return 0.06847387552261353f;
  t16_n98: return 0.09343913197517395f;
  t16_n99: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t16_n101;
  t16_n100: return 0.08566107600927353f;
  t16_n101: if (E.getNumReferences() >= 3348641152 /*77931.0*/) goto t16_n103;
  t16_n102: return 0.09748547524213791f;
  t16_n103: return 0.1242254450917244f;
  t16_n104: if (E.getFileProximityDistanceCost() >= 3255435264 /*34.5*/) goto t16_n152;
  t16_n105: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t16_n141;
  t16_n106: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t16_n128;
  t16_n107: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t16_n119;
  t16_n108: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t16_n118;
  t16_n109: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t16_n113;
  t16_n110: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t16_n112;
  t16_n111: return 0.04376782104372978f;
  t16_n112: return -0.00594095466658473f;
  t16_n113: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t16_n117;
  t16_n114: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t16_n116;
  t16_n115: return 0.08432701975107193f;
  t16_n116: return -0.03770134225487709f;
  t16_n117: return 0.07714498043060303f;
  t16_n118: return 0.07673054188489914f;
  t16_n119: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t16_n127;
  t16_n120: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t16_n122;
  t16_n121: return 0.06182459369301796f;
  t16_n122: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t16_n126;
  t16_n123: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t16_n125;
  t16_n124: return 0.07572401314973831f;
  t16_n125: return 0.10476820170879364f;
  t16_n126: return 0.06255875527858734f;
  t16_n127: return 0.08897951245307922f;
  t16_n128: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t16_n138;
  t16_n129: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t16_n135;
  t16_n130: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t16_n132;
  t16_n131: return -0.031519822776317596f;
  t16_n132: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t16_n134;
  t16_n133: return -0.1677902489900589f;
  t16_n134: return 0.048004455864429474f;
  t16_n135: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function))) goto t16_n137;
  t16_n136: return 0.03745410963892937f;
  t16_n137: return 0.08606702834367752f;
  t16_n138: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t16_n140;
  t16_n139: return 0.05551770329475403f;
  t16_n140: return -0.08636679500341415f;
  t16_n141: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t16_n149;
  t16_n142: if (E.getNumReferences() >= 3359104096 /*188273.5*/) goto t16_n148;
  t16_n143: if (E.getFractionNameInContext() >= 3177025848 /*0.05409356951713562*/) goto t16_n145;
  t16_n144: return 0.06254161894321442f;
  t16_n145: if (E.getNumReferences() >= 3260416000 /*53.5*/) goto t16_n147;
  t16_n146: return 0.0691598579287529f;
  t16_n147: return 0.08890411257743835f;
  t16_n148: return 0.1008118987083435f;
  t16_n149: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t16_n151;
  t16_n150: return 0.1005592942237854f;
  t16_n151: return 0.0842849537730217f;
  t16_n152: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t16_n214;
  t16_n153: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t16_n205;
  t16_n154: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t16_n156;
  t16_n155: return -0.09785819053649902f;
  t16_n156: if (E.getFractionNameInContext() >= 3172203529 /*0.03612903133034706*/) goto t16_n178;
  t16_n157: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t16_n175;
  t16_n158: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t16_n174;
  t16_n159: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t16_n173;
  t16_n160: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t16_n164;
  t16_n161: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t16_n163;
  t16_n162: return -0.04560280218720436f;
  t16_n163: return 0.04565580561757088f;
  t16_n164: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t16_n168;
  t16_n165: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t16_n167;
  t16_n166: return -0.06183901056647301f;
  t16_n167: return 0.016799502074718475f;
  t16_n168: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t16_n172;
  t16_n169: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t16_n171;
  t16_n170: return 0.031966179609298706f;
  t16_n171: return 0.12959136068820953f;
  t16_n172: return 0.11515393108129501f;
  t16_n173: return 0.035079196095466614f;
  t16_n174: return -0.031169962137937546f;
  t16_n175: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t16_n177;
  t16_n176: return -0.09876450151205063f;
  t16_n177: return 0.03112604096531868f;
  t16_n178: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t16_n204;
  t16_n179: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t16_n197;
  t16_n180: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t16_n192;
  t16_n181: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t16_n183;
  t16_n182: return -0.038443900644779205f;
  t16_n183: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t16_n189;
  t16_n184: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t16_n186;
  t16_n185: return -0.06762784719467163f;
  t16_n186: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t16_n188;
  t16_n187: return 0.022398030385375023f;
  t16_n188: return 0.04340213164687157f;
  t16_n189: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t16_n191;
  t16_n190: return -0.0837133377790451f;
  t16_n191: return 0.05053173378109932f;
  t16_n192: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t16_n194;
  t16_n193: return 0.02572273276746273f;
  t16_n194: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t16_n196;
  t16_n195: return 0.06292790174484253f;
  t16_n196: return 0.10970078408718109f;
  t16_n197: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t16_n203;
  t16_n198: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t16_n202;
  t16_n199: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t16_n201;
  t16_n200: return 0.04629683867096901f;
  t16_n201: return -0.009459925815463066f;
  t16_n202: return 0.08325625211000443f;
  t16_n203: return 0.06546196341514587f;
  t16_n204: return -0.08932628482580185f;
  t16_n205: if (E.getFractionNameInContext() >= 3180161239 /*0.06904762238264084*/) goto t16_n211;
  t16_n206: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t16_n208;
  t16_n207: return 0.03805574029684067f;
  t16_n208: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t16_n210;
  t16_n209: return -0.07340645045042038f;
  t16_n210: return 0.06972993165254593f;
  t16_n211: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t16_n213;
  t16_n212: return 0.05477450415492058f;
  t16_n213: return 0.0824725478887558f;
  t16_n214: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t16_n218;
  t16_n215: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t16_n217;
  t16_n216: return -0.11831093579530716f;
  t16_n217: return 0.014257458969950676f;
  t16_n218: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t16_n236;
  t16_n219: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t16_n231;
  t16_n220: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t16_n228;
  t16_n221: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t16_n223;
  t16_n222: return -0.027682101354002953f;
  t16_n223: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t16_n227;
  t16_n224: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FunctionScope))) goto t16_n226;
  t16_n225: return -0.043397169560194016f;
  t16_n226: return 0.07010643184185028f;
  t16_n227: return 0.09153735637664795f;
  t16_n228: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t16_n230;
  t16_n229: return 0.029521768912672997f;
  t16_n230: return 0.10135728120803833f;
  t16_n231: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t16_n235;
  t16_n232: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t16_n234;
  t16_n233: return -0.03432818874716759f;
  t16_n234: return 0.04870620742440224f;
  t16_n235: return 0.07804930955171585f;
  t16_n236: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t16_n240;
  t16_n237: if (E.getFractionNameInContext() >= 3175960628 /*0.05012531578540802*/) goto t16_n239;
  t16_n238: return 0.05979437753558159f;
  t16_n239: return 0.08284495770931244f;
  t16_n240: return 0.08972368389368057f;
  t16_n241: if (E.getNumReferences() >= 3376956888 /*820317.5*/) goto t16_n247;
  t16_n242: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t16_n244;
  t16_n243: return 0.039618007838726044f;
  t16_n244: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t16_n246;
  t16_n245: return 0.08658834546804428f;
  t16_n246: return 0.10497349500656128f;
  t16_n247: return 0.10392142087221146f;
  t16_n248: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_Type))) goto t16_n250;
  t16_n249: return 0.0008542459108866751f;
  t16_n250: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t16_n254;
  t16_n251: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t16_n253;
  t16_n252: return 0.09347398579120636f;
  t16_n253: return 0.10036642104387283f;
  t16_n254: return 0.10697859525680542f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree17(const Example& E) {
  t17_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t17_n248;
  t17_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t17_n239;
  t17_n2: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t17_n112;
  t17_n3: if (E.getFractionNameInContext() >= 3181648450 /*0.08012820780277252*/) goto t17_n61;
  t17_n4: if (E.getNumReferences() >= 3326663680 /*12855.0*/) goto t17_n54;
  t17_n5: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t17_n13;
  t17_n6: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t17_n10;
  t17_n7: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t17_n9;
  t17_n8: return -0.1226615309715271f;
  t17_n9: return -0.08322560787200928f;
  t17_n10: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t17_n12;
  t17_n11: return 0.018006235361099243f;
  t17_n12: return -0.0465724878013134f;
  t17_n13: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t17_n19;
  t17_n14: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t17_n18;
  t17_n15: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t17_n17;
  t17_n16: return 0.0026393099687993526f;
  t17_n17: return 0.04339185729622841f;
  t17_n18: return 0.08146128058433533f;
  t17_n19: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t17_n25;
  t17_n20: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t17_n22;
  t17_n21: return -0.05984886735677719f;
  t17_n22: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t17_n24;
  t17_n23: return -0.0016724448651075363f;
  t17_n24: return 0.06404628604650497f;
  t17_n25: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t17_n53;
  t17_n26: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t17_n52;
  t17_n27: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t17_n51;
  t17_n28: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t17_n44;
  t17_n29: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t17_n33;
  t17_n30: if (E.getSymbolScopeDistanceCost() >= 3239051264 /*9.0*/) goto t17_n32;
  t17_n31: return -0.00153436535038054f;
  t17_n32: return -0.05664217844605446f;
  t17_n33: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t17_n41;
  t17_n34: if (E.getFractionNameInContext() >= 3177856917 /*0.057189542800188065*/) goto t17_n36;
  t17_n35: return -0.024636687710881233f;
  t17_n36: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t17_n38;
  t17_n37: return -0.04680269584059715f;
  t17_n38: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t17_n40;
  t17_n39: return 0.09517379105091095f;
  t17_n40: return 0.04054529592394829f;
  t17_n41: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t17_n43;
  t17_n42: return -0.005242961924523115f;
  t17_n43: return 0.05113357678055763f;
  t17_n44: if (E.getNumReferences() >= 3259105280 /*48.5*/) goto t17_n46;
  t17_n45: return -0.06729865819215775f;
  t17_n46: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t17_n50;
  t17_n47: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t17_n49;
  t17_n48: return 0.05984092131257057f;
  t17_n49: return 0.026130683720111847f;
  t17_n50: return -0.03836371377110481f;
  t17_n51: return -0.08655684441328049f;
  t17_n52: return 0.031095607206225395f;
  t17_n53: return -0.12292716652154922f;
  t17_n54: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t17_n58;
  t17_n55: if (E.getNumReferences() >= 3347876160 /*71954.5*/) goto t17_n57;
  t17_n56: return 0.037275463342666626f;
  t17_n57: return 0.07258249074220657f;
  t17_n58: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t17_n60;
  t17_n59: return 0.002953986171633005f;
  t17_n60: return 0.07656170427799225f;
  t17_n61: if (E.getNumReferences() >= 3309346816 /*3082.0*/) goto t17_n101;
  t17_n62: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t17_n74;
  t17_n63: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t17_n71;
  t17_n64: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t17_n70;
  t17_n65: if (E.getFractionNameInContext() >= 3199184816 /*0.343137264251709*/) goto t17_n69;
  t17_n66: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t17_n68;
  t17_n67: return 0.008692118339240551f;
  t17_n68: return 0.05480740964412689f;
  t17_n69: return 0.05119713768362999f;
  t17_n70: return 0.06859373301267624f;
  t17_n71: if (E.getNumReferences() >= 3255173120 /*33.5*/) goto t17_n73;
  t17_n72: return 0.06275281310081482f;
  t17_n73: return 0.09612111002206802f;
  t17_n74: if (E.getFileProximityDistanceCost() >= 3255173120 /*33.5*/) goto t17_n96;
  t17_n75: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t17_n89;
  t17_n76: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t17_n80;
  t17_n77: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t17_n79;
  t17_n78: return -0.06846483796834946f;
  t17_n79: return 0.030569203197956085f;
  t17_n80: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t17_n82;
  t17_n81: return -0.0049885110929608345f;
  t17_n82: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t17_n86;
  t17_n83: if (E.getNumReferences() >= 3269918720 /*115.5*/) goto t17_n85;
  t17_n84: return 0.0143196489661932f;
  t17_n85: return 0.07171657681465149f;
  t17_n86: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t17_n88;
  t17_n87: return 0.02163633145391941f;
  t17_n88: return 0.08570580929517746f;
  t17_n89: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t17_n95;
  t17_n90: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t17_n92;
  t17_n91: return 0.03374047949910164f;
  t17_n92: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t17_n94;
  t17_n93: return 0.011772441677749157f;
  t17_n94: return 0.09992841631174088f;
  t17_n95: return 0.08466055989265442f;
  t17_n96: if (E.getFractionNameInContext() >= 3193183554 /*0.20714285969734192*/) goto t17_n100;
  t17_n97: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t17_n99;
  t17_n98: return 0.018790749832987785f;
  t17_n99: return 0.07144811749458313f;
  t17_n100: return 0.08746077865362167f;
  t17_n101: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t17_n107;
  t17_n102: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t17_n104;
  t17_n103: return 0.05038420855998993f;
  t17_n104: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t17_n106;
  t17_n105: return 0.06616242229938507f;
  t17_n106: return 0.09092336893081665f;
  t17_n107: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t17_n109;
  t17_n108: return 0.08226369321346283f;
  t17_n109: if (E.getNumReferences() >= 3348641152 /*77931.0*/) goto t17_n111;
  t17_n110: return 0.09531722962856293f;
  t17_n111: return 0.12177357822656631f;
  t17_n112: if (E.getFileProximityDistanceCost() >= 3255435264 /*34.5*/) goto t17_n156;
  t17_n113: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t17_n139;
  t17_n114: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t17_n124;
  t17_n115: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t17_n121;
  t17_n116: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t17_n120;
  t17_n117: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t17_n119;
  t17_n118: return 0.014907168224453926f;
  t17_n119: return 0.05461858585476875f;
  t17_n120: return 0.07058615982532501f;
  t17_n121: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t17_n123;
  t17_n122: return 0.05139973759651184f;
  t17_n123: return -0.0782516822218895f;
  t17_n124: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t17_n132;
  t17_n125: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t17_n127;
  t17_n126: return 0.03720085322856903f;
  t17_n127: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t17_n131;
  t17_n128: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t17_n130;
  t17_n129: return 0.045197390019893646f;
  t17_n130: return 0.07720883935689926f;
  t17_n131: return 0.08425101637840271f;
  t17_n132: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t17_n138;
  t17_n133: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t17_n135;
  t17_n134: return 0.05906052514910698f;
  t17_n135: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t17_n137;
  t17_n136: return 0.08878657966852188f;
  t17_n137: return 0.05880400165915489f;
  t17_n138: return 0.08651160448789597f;
  t17_n139: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t17_n153;
  t17_n140: if (E.getFractionNameInContext() >= 3173545706 /*0.04112903028726578*/) goto t17_n144;
  t17_n141: if (E.getNumReferences() >= 3359104096 /*188273.5*/) goto t17_n143;
  t17_n142: return 0.058705661445856094f;
  t17_n143: return 0.0974545031785965f;
  t17_n144: if (E.getNumReferences() >= 3332163840 /*20068.5*/) goto t17_n152;
  t17_n145: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t17_n151;
  t17_n146: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t17_n150;
  t17_n147: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t17_n149;
  t17_n148: return -0.03806950896978378f;
  t17_n149: return 0.06076180934906006f;
  t17_n150: return 0.0904197245836258f;
  t17_n151: return 0.07894042134284973f;
  t17_n152: return 0.10041303187608719f;
  t17_n153: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t17_n155;
  t17_n154: return 0.09626863151788712f;
  t17_n155: return 0.0742807611823082f;
  t17_n156: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t17_n188;
  t17_n157: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t17_n179;
  t17_n158: if (E.getSymbolScopeDistanceCost() >= 3221225472 /*2.0*/) goto t17_n176;
  t17_n159: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t17_n161;
  t17_n160: return -0.09589508920907974f;
  t17_n161: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t17_n173;
  t17_n162: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t17_n166;
  t17_n163: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t17_n165;
  t17_n164: return 0.015276617370545864f;
  t17_n165: return -0.012827591970562935f;
  t17_n166: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t17_n168;
  t17_n167: return -0.0933203473687172f;
  t17_n168: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t17_n170;
  t17_n169: return -0.07782524824142456f;
  t17_n170: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t17_n172;
  t17_n171: return 0.03029704838991165f;
  t17_n172: return 0.06768301129341125f;
  t17_n173: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t17_n175;
  t17_n174: return 0.0446418821811676f;
  t17_n175: return 0.01946314051747322f;
  t17_n176: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t17_n178;
  t17_n177: return 0.0073483227752149105f;
  t17_n178: return -0.10805855691432953f;
  t17_n179: if (E.getFractionNameInContext() >= 3180161239 /*0.06904762238264084*/) goto t17_n185;
  t17_n180: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol))) goto t17_n184;
  t17_n181: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t17_n183;
  t17_n182: return 0.02554067224264145f;
  t17_n183: return -0.06783122569322586f;
  t17_n184: return 0.052094608545303345f;
  t17_n185: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t17_n187;
  t17_n186: return 0.05202171579003334f;
  t17_n187: return 0.08039624989032745f;
  t17_n188: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t17_n232;
  t17_n189: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t17_n201;
  t17_n190: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t17_n196;
  t17_n191: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown))) goto t17_n193;
  t17_n192: return -0.03944515436887741f;
  t17_n193: if (E.getFractionNameInContext() >= 3181648450 /*0.08012820780277252*/) goto t17_n195;
  t17_n194: return 0.023298248648643494f;
  t17_n195: return 0.06658948212862015f;
  t17_n196: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t17_n198;
  t17_n197: return 0.05201687663793564f;
  t17_n198: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t17_n200;
  t17_n199: return -0.015641018748283386f;
  t17_n200: return 0.08695971965789795f;
  t17_n201: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t17_n219;
  t17_n202: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t17_n206;
  t17_n203: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t17_n205;
  t17_n204: return -0.05488847941160202f;
  t17_n205: return 0.055185817182064056f;
  t17_n206: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t17_n214;
  t17_n207: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_UnionTag))) goto t17_n209;
  t17_n208: return 0.03365994989871979f;
  t17_n209: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t17_n213;
  t17_n210: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t17_n212;
  t17_n211: return 0.06000091880559921f;
  t17_n212: return -0.18807312846183777f;
  t17_n213: return 0.10088670253753662f;
  t17_n214: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t17_n218;
  t17_n215: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t17_n217;
  t17_n216: return 0.1141337975859642f;
  t17_n217: return 0.09379938989877701f;
  t17_n218: return -0.000959669123403728f;
  t17_n219: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t17_n231;
  t17_n220: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t17_n226;
  t17_n221: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t17_n223;
  t17_n222: return 0.04730633646249771f;
  t17_n223: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t17_n225;
  t17_n224: return 0.033188726752996445f;
  t17_n225: return 0.11371500045061111f;
  t17_n226: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t17_n230;
  t17_n227: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t17_n229;
  t17_n228: return 0.07704175263643265f;
  t17_n229: return -0.2138231098651886f;
  t17_n230: return 0.10114303976297379f;
  t17_n231: return -0.07287584990262985f;
  t17_n232: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol))) goto t17_n234;
  t17_n233: return 0.014156310819089413f;
  t17_n234: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t17_n238;
  t17_n235: if (E.getFractionNameInContext() >= 3175960628 /*0.05012531578540802*/) goto t17_n237;
  t17_n236: return 0.056297071278095245f;
  t17_n237: return 0.07991767674684525f;
  t17_n238: return 0.08726968616247177f;
  t17_n239: if (E.getNumReferences() >= 3376956888 /*820317.5*/) goto t17_n247;
  t17_n240: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t17_n244;
  t17_n241: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t17_n243;
  t17_n242: return 0.029828136786818504f;
  t17_n243: return 0.10077531635761261f;
  t17_n244: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t17_n246;
  t17_n245: return 0.08545621484518051f;
  t17_n246: return 0.1042909100651741f;
  t17_n247: return 0.10270808637142181f;
  t17_n248: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_Type))) goto t17_n250;
  t17_n249: return 0.0007001198828220367f;
  t17_n250: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t17_n254;
  t17_n251: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t17_n253;
  t17_n252: return 0.09120485186576843f;
  t17_n253: return 0.09890985488891602f;
  t17_n254: return 0.10619451105594635f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree18(const Example& E) {
  t18_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t18_n248;
  t18_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t18_n241;
  t18_n2: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t18_n128;
  t18_n3: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t18_n69;
  t18_n4: if (E.getNumReferences() >= 3301085184 /*1556.5*/) goto t18_n58;
  t18_n5: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t18_n11;
  t18_n6: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t18_n10;
  t18_n7: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t18_n9;
  t18_n8: return -0.1219959557056427f;
  t18_n9: return -0.08494135737419128f;
  t18_n10: return -0.001919018686749041f;
  t18_n11: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t18_n23;
  t18_n12: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t18_n20;
  t18_n13: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t18_n15;
  t18_n14: return -0.01566029153764248f;
  t18_n15: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t18_n19;
  t18_n16: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t18_n18;
  t18_n17: return 0.04712570086121559f;
  t18_n18: return 0.024693936109542847f;
  t18_n19: return 0.005919786635786295f;
  t18_n20: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t18_n22;
  t18_n21: return 0.05547989904880524f;
  t18_n22: return 0.09353113174438477f;
  t18_n23: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t18_n53;
  t18_n24: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t18_n30;
  t18_n25: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t18_n27;
  t18_n26: return -0.04875052347779274f;
  t18_n27: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t18_n29;
  t18_n28: return 0.00037049909587949514f;
  t18_n29: return 0.05796661227941513f;
  t18_n30: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t18_n40;
  t18_n31: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t18_n33;
  t18_n32: return -0.04051407799124718f;
  t18_n33: if (E.getFractionNameInContext() >= 3169944461 /*0.02948167361319065*/) goto t18_n35;
  t18_n34: return 0.005281738005578518f;
  t18_n35: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t18_n37;
  t18_n36: return -0.027800654992461205f;
  t18_n37: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t18_n39;
  t18_n38: return -0.013929623179137707f;
  t18_n39: return 0.07919907569885254f;
  t18_n40: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t18_n46;
  t18_n41: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t18_n45;
  t18_n42: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t18_n44;
  t18_n43: return 0.03135722130537033f;
  t18_n44: return -0.10378704965114594f;
  t18_n45: return -0.049095846712589264f;
  t18_n46: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t18_n52;
  t18_n47: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t18_n49;
  t18_n48: return -0.09459899365901947f;
  t18_n49: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Type))) goto t18_n51;
  t18_n50: return 0.07554405182600021f;
  t18_n51: return 0.11510644108057022f;
  t18_n52: return -0.1388096809387207f;
  t18_n53: if (E.getNumReferences() >= 3247702016 /*18.5*/) goto t18_n55;
  t18_n54: return -0.10354798287153244f;
  t18_n55: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t18_n57;
  t18_n56: return 0.017056234180927277f;
  t18_n57: return -0.07829947024583817f;
  t18_n58: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t18_n64;
  t18_n59: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t18_n63;
  t18_n60: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t18_n62;
  t18_n61: return -0.010785254649817944f;
  t18_n62: return 0.05185173824429512f;
  t18_n63: return 0.07250222563743591f;
  t18_n64: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t18_n68;
  t18_n65: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t18_n67;
  t18_n66: return 0.03168477490544319f;
  t18_n67: return 0.08109401911497116f;
  t18_n68: return 0.08134656399488449f;
  t18_n69: if (E.getFileProximityDistanceCost() >= 3254517760 /*31.5*/) goto t18_n93;
  t18_n70: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t18_n82;
  t18_n71: if (E.getSymbolScopeDistanceCost() >= 3239051264 /*9.0*/) goto t18_n79;
  t18_n72: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t18_n76;
  t18_n73: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t18_n75;
  t18_n74: return 0.04373518377542496f;
  t18_n75: return -0.0057802097871899605f;
  t18_n76: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t18_n78;
  t18_n77: return 0.06945833563804626f;
  t18_n78: return 0.009705744683742523f;
  t18_n79: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t18_n81;
  t18_n80: return -0.010627057403326035f;
  t18_n81: return 0.07780719548463821f;
  t18_n82: if (E.getNumReferences() >= 3348227392 /*74698.5*/) goto t18_n92;
  t18_n83: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t18_n87;
  t18_n84: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t18_n86;
  t18_n85: return -0.002222369657829404f;
  t18_n86: return 0.07766464352607727f;
  t18_n87: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t18_n91;
  t18_n88: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t18_n90;
  t18_n89: return 0.09434252977371216f;
  t18_n90: return -0.0223320871591568f;
  t18_n91: return 0.06133650243282318f;
  t18_n92: return 0.09888317435979843f;
  t18_n93: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t18_n103;
  t18_n94: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t18_n98;
  t18_n95: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t18_n97;
  t18_n96: return -0.02149050123989582f;
  t18_n97: return 0.03177015855908394f;
  t18_n98: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t18_n100;
  t18_n99: return -0.08893885463476181f;
  t18_n100: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t18_n102;
  t18_n101: return -0.06727046519517899f;
  t18_n102: return 0.04369499906897545f;
  t18_n103: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t18_n117;
  t18_n104: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t18_n112;
  t18_n105: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown))) goto t18_n111;
  t18_n106: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t18_n108;
  t18_n107: return -0.047959815710783005f;
  t18_n108: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t18_n110;
  t18_n109: return -0.021145159378647804f;
  t18_n110: return 0.05077805742621422f;
  t18_n111: return 0.018862247467041016f;
  t18_n112: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t18_n116;
  t18_n113: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t18_n115;
  t18_n114: return 0.04656370356678963f;
  t18_n115: return 0.08152807503938675f;
  t18_n116: return -0.04959354177117348f;
  t18_n117: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t18_n123;
  t18_n118: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t18_n122;
  t18_n119: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t18_n121;
  t18_n120: return 0.08077791333198547f;
  t18_n121: return -0.05068482831120491f;
  t18_n122: return 0.050685618072748184f;
  t18_n123: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t18_n125;
  t18_n124: return 0.04012814164161682f;
  t18_n125: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t18_n127;
  t18_n126: return 0.10557582974433899f;
  t18_n127: return -0.007807585876435041f;
  t18_n128: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t18_n176;
  t18_n129: if (E.getNumReferences() >= 3303280640 /*1824.5*/) goto t18_n165;
  t18_n130: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t18_n142;
  t18_n131: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t18_n139;
  t18_n132: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t18_n138;
  t18_n133: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t18_n137;
  t18_n134: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t18_n136;
  t18_n135: return 0.010496031492948532f;
  t18_n136: return 0.05428953468799591f;
  t18_n137: return 0.06236223503947258f;
  t18_n138: return 0.0539453960955143f;
  t18_n139: if (E.getNumReferences() >= 3255173120 /*33.5*/) goto t18_n141;
  t18_n140: return 0.06225244700908661f;
  t18_n141: return 0.09232728183269501f;
  t18_n142: if (E.getFileProximityDistanceCost() >= 3255173120 /*33.5*/) goto t18_n160;
  t18_n143: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t18_n157;
  t18_n144: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t18_n148;
  t18_n145: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t18_n147;
  t18_n146: return -0.06688377261161804f;
  t18_n147: return 0.029356295242905617f;
  t18_n148: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t18_n150;
  t18_n149: return -0.004293648060411215f;
  t18_n150: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t18_n154;
  t18_n151: if (E.getNumReferences() >= 3269918720 /*115.5*/) goto t18_n153;
  t18_n152: return 0.014663553796708584f;
  t18_n153: return 0.06835760176181793f;
  t18_n154: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t18_n156;
  t18_n155: return 0.020803578197956085f;
  t18_n156: return 0.08237989991903305f;
  t18_n157: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t18_n159;
  t18_n158: return 0.03721620887517929f;
  t18_n159: return 0.08055759221315384f;
  t18_n160: if (E.getFractionNameInContext() >= 3193183554 /*0.20714285969734192*/) goto t18_n164;
  t18_n161: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t18_n163;
  t18_n162: return 0.014592533931136131f;
  t18_n163: return 0.06785143166780472f;
  t18_n164: return 0.08402469009160995f;
  t18_n165: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t18_n169;
  t18_n166: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t18_n168;
  t18_n167: return 0.04529193788766861f;
  t18_n168: return 0.07574821263551712f;
  t18_n169: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t18_n171;
  t18_n170: return 0.07130883634090424f;
  t18_n171: if (E.getNumReferences() >= 3348232704 /*74740.0*/) goto t18_n173;
  t18_n172: return 0.09733043611049652f;
  t18_n173: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel))) goto t18_n175;
  t18_n174: return 0.11189819127321243f;
  t18_n175: return 0.12056370079517365f;
  t18_n176: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t18_n192;
  t18_n177: if (E.getNumReferences() >= 3239575552 /*9.5*/) goto t18_n189;
  t18_n178: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t18_n182;
  t18_n179: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t18_n181;
  t18_n180: return 0.02803107164800167f;
  t18_n181: return 0.06364888697862625f;
  t18_n182: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t18_n188;
  t18_n183: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t18_n187;
  t18_n184: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t18_n186;
  t18_n185: return 0.06080296263098717f;
  t18_n186: return 0.033169347792863846f;
  t18_n187: return 0.08713843673467636f;
  t18_n188: return 0.0775546208024025f;
  t18_n189: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t18_n191;
  t18_n190: return 0.08108855783939362f;
  t18_n191: return 0.09566812962293625f;
  t18_n192: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t18_n194;
  t18_n193: return -0.07493442296981812f;
  t18_n194: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t18_n232;
  t18_n195: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t18_n231;
  t18_n196: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t18_n222;
  t18_n197: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t18_n215;
  t18_n198: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t18_n212;
  t18_n199: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t18_n211;
  t18_n200: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t18_n210;
  t18_n201: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t18_n205;
  t18_n202: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t18_n204;
  t18_n203: return -0.0553092323243618f;
  t18_n204: return 0.015397938899695873f;
  t18_n205: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t18_n207;
  t18_n206: return 0.0176982618868351f;
  t18_n207: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t18_n209;
  t18_n208: return 0.046846356242895126f;
  t18_n209: return 0.09728778153657913f;
  t18_n210: return 0.033404089510440826f;
  t18_n211: return -0.08371195942163467f;
  t18_n212: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t18_n214;
  t18_n213: return -0.0801248848438263f;
  t18_n214: return 0.031051723286509514f;
  t18_n215: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Symbol))) goto t18_n219;
  t18_n216: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t18_n218;
  t18_n217: return -0.0863114446401596f;
  t18_n218: return 0.05628510192036629f;
  t18_n219: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t18_n221;
  t18_n220: return 0.04117821529507637f;
  t18_n221: return 0.07199114561080933f;
  t18_n222: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t18_n230;
  t18_n223: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t18_n227;
  t18_n224: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t18_n226;
  t18_n225: return 0.02880493365228176f;
  t18_n226: return 0.07182341068983078f;
  t18_n227: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t18_n229;
  t18_n228: return 0.057220082730054855f;
  t18_n229: return 0.0930497944355011f;
  t18_n230: return -0.07258857786655426f;
  t18_n231: return 0.07175608724355698f;
  t18_n232: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t18_n236;
  t18_n233: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t18_n235;
  t18_n234: return -0.045385248959064484f;
  t18_n235: return 0.07859831303358078f;
  t18_n236: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Symbol))) goto t18_n240;
  t18_n237: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t18_n239;
  t18_n238: return -0.11743790656328201f;
  t18_n239: return 0.06027140095829964f;
  t18_n240: return 0.08097516745328903f;
  t18_n241: if (E.getNumReferences() >= 3376956888 /*820317.5*/) goto t18_n247;
  t18_n242: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol))) goto t18_n244;
  t18_n243: return 0.04600481316447258f;
  t18_n244: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t18_n246;
  t18_n245: return 0.09790767729282379f;
  t18_n246: return 0.03755580633878708f;
  t18_n247: return 0.10164259374141693f;
  t18_n248: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_Type))) goto t18_n250;
  t18_n249: return 0.0007574164774268866f;
  t18_n250: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t18_n254;
  t18_n251: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t18_n253;
  t18_n252: return 0.08881326019763947f;
  t18_n253: return 0.09730231761932373f;
  t18_n254: return 0.10551128536462784f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree19(const Example& E) {
  t19_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t19_n248;
  t19_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t19_n241;
  t19_n2: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t19_n114;
  t19_n3: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t19_n63;
  t19_n4: if (E.getNumReferences() >= 3301085184 /*1556.5*/) goto t19_n52;
  t19_n5: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t19_n13;
  t19_n6: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t19_n8;
  t19_n7: return -0.08682798594236374f;
  t19_n8: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t19_n12;
  t19_n9: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t19_n11;
  t19_n10: return -0.048379138112068176f;
  t19_n11: return 0.02912013791501522f;
  t19_n12: return -0.04636610299348831f;
  t19_n13: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t19_n23;
  t19_n14: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t19_n20;
  t19_n15: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t19_n17;
  t19_n16: return -0.005774271674454212f;
  t19_n17: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t19_n19;
  t19_n18: return 0.04237106814980507f;
  t19_n19: return -0.028414275497198105f;
  t19_n20: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t19_n22;
  t19_n21: return 0.0515919104218483f;
  t19_n22: return 0.08911124616861343f;
  t19_n23: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t19_n47;
  t19_n24: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t19_n26;
  t19_n25: return -0.03908855840563774f;
  t19_n26: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t19_n36;
  t19_n27: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t19_n29;
  t19_n28: return -0.03799903765320778f;
  t19_n29: if (E.getFractionNameInContext() >= 3169944461 /*0.02948167361319065*/) goto t19_n31;
  t19_n30: return 0.004415302071720362f;
  t19_n31: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t19_n33;
  t19_n32: return -0.028351357206702232f;
  t19_n33: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t19_n35;
  t19_n34: return -0.012778478674590588f;
  t19_n35: return 0.07462165504693985f;
  t19_n36: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t19_n42;
  t19_n37: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t19_n41;
  t19_n38: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t19_n40;
  t19_n39: return 0.029577964916825294f;
  t19_n40: return -0.10257237404584885f;
  t19_n41: return -0.04561291262507439f;
  t19_n42: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t19_n46;
  t19_n43: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Type))) goto t19_n45;
  t19_n44: return 0.06294618546962738f;
  t19_n45: return 0.09882063418626785f;
  t19_n46: return -0.13384157419204712f;
  t19_n47: if (E.getNumReferences() >= 3247702016 /*18.5*/) goto t19_n49;
  t19_n48: return -0.10050737112760544f;
  t19_n49: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t19_n51;
  t19_n50: return 0.013645577244460583f;
  t19_n51: return -0.07545478641986847f;
  t19_n52: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t19_n56;
  t19_n53: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t19_n55;
  t19_n54: return -0.007627623155713081f;
  t19_n55: return 0.06900252401828766f;
  t19_n56: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t19_n60;
  t19_n57: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t19_n59;
  t19_n58: return 0.030377361923456192f;
  t19_n59: return 0.07750282436609268f;
  t19_n60: if (E.getNumReferences() >= 3317853184 /*6221.5*/) goto t19_n62;
  t19_n61: return 0.013637538999319077f;
  t19_n62: return 0.09247134625911713f;
  t19_n63: if (E.getFileProximityDistanceCost() >= 3254517760 /*31.5*/) goto t19_n87;
  t19_n64: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t19_n76;
  t19_n65: if (E.getSymbolScopeDistanceCost() >= 3239051264 /*9.0*/) goto t19_n73;
  t19_n66: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t19_n70;
  t19_n67: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t19_n69;
  t19_n68: return 0.04013225436210632f;
  t19_n69: return -0.0063885655254125595f;
  t19_n70: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t19_n72;
  t19_n71: return 0.06571948528289795f;
  t19_n72: return 0.0077853430993855f;
  t19_n73: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t19_n75;
  t19_n74: return -0.01385275274515152f;
  t19_n75: return 0.07478225231170654f;
  t19_n76: if (E.getNumReferences() >= 3348227392 /*74698.5*/) goto t19_n86;
  t19_n77: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t19_n81;
  t19_n78: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t19_n80;
  t19_n79: return -0.004803450778126717f;
  t19_n80: return 0.07400713115930557f;
  t19_n81: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t19_n85;
  t19_n82: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t19_n84;
  t19_n83: return 0.09184002131223679f;
  t19_n84: return -0.0219985693693161f;
  t19_n85: return 0.05722232908010483f;
  t19_n86: return 0.09793921560049057f;
  t19_n87: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t19_n113;
  t19_n88: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t19_n104;
  t19_n89: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t19_n101;
  t19_n90: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t19_n100;
  t19_n91: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t19_n93;
  t19_n92: return -0.06314115971326828f;
  t19_n93: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t19_n99;
  t19_n94: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t19_n96;
  t19_n95: return 0.005445700138807297f;
  t19_n96: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t19_n98;
  t19_n97: return 0.04121624678373337f;
  t19_n98: return 0.10404003411531448f;
  t19_n99: return -0.028338758274912834f;
  t19_n100: return 0.029162472113966942f;
  t19_n101: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t19_n103;
  t19_n102: return -0.08810549229383469f;
  t19_n103: return 0.01606176421046257f;
  t19_n104: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t19_n112;
  t19_n105: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t19_n111;
  t19_n106: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t19_n110;
  t19_n107: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t19_n109;
  t19_n108: return 0.0022376247216016054f;
  t19_n109: return 0.040294017642736435f;
  t19_n110: return -0.08077210187911987f;
  t19_n111: return 0.07044421881437302f;
  t19_n112: return 0.07291650027036667f;
  t19_n113: return 0.02459515631198883f;
  t19_n114: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t19_n186;
  t19_n115: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t19_n141;
  t19_n116: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t19_n132;
  t19_n117: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t19_n119;
  t19_n118: return -0.014167491346597672f;
  t19_n119: if (E.getFractionNameInContext() >= 3196720569 /*0.269696980714798*/) goto t19_n127;
  t19_n120: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t19_n124;
  t19_n121: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t19_n123;
  t19_n122: return 0.01799074560403824f;
  t19_n123: return 0.07024584710597992f;
  t19_n124: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t19_n126;
  t19_n125: return 0.03917007893323898f;
  t19_n126: return 0.07078143209218979f;
  t19_n127: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t19_n131;
  t19_n128: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t19_n130;
  t19_n129: return 0.04600479453802109f;
  t19_n130: return 0.0903640165925026f;
  t19_n131: return 0.0907847210764885f;
  t19_n132: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t19_n138;
  t19_n133: if (E.getNumReferences() >= 3256483840 /*38.5*/) goto t19_n135;
  t19_n134: return 0.04435529187321663f;
  t19_n135: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t19_n137;
  t19_n136: return 0.04929511249065399f;
  t19_n137: return 0.07743098586797714f;
  t19_n138: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t19_n140;
  t19_n139: return -0.15977664291858673f;
  t19_n140: return 0.08989333361387253f;
  t19_n141: if (E.getNumReferences() >= 3306285056 /*2334.5*/) goto t19_n177;
  t19_n142: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t19_n174;
  t19_n143: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t19_n163;
  t19_n144: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t19_n160;
  t19_n145: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t19_n147;
  t19_n146: return -0.060406964272260666f;
  t19_n147: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t19_n149;
  t19_n148: return -0.021124571561813354f;
  t19_n149: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t19_n151;
  t19_n150: return 0.02193238027393818f;
  t19_n151: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t19_n159;
  t19_n152: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t19_n154;
  t19_n153: return 0.009504484012722969f;
  t19_n154: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t19_n158;
  t19_n155: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t19_n157;
  t19_n156: return -0.05598604306578636f;
  t19_n157: return 0.1302400678396225f;
  t19_n158: return -0.05344446375966072f;
  t19_n159: return -0.07027741521596909f;
  t19_n160: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t19_n162;
  t19_n161: return -0.03616395220160484f;
  t19_n162: return 0.04844525083899498f;
  t19_n163: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t19_n169;
  t19_n164: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t19_n168;
  t19_n165: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t19_n167;
  t19_n166: return 0.03784359246492386f;
  t19_n167: return 0.09050175547599792f;
  t19_n168: return 0.002325026784092188f;
  t19_n169: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t19_n173;
  t19_n170: if (E.getFileProximityDistanceCost() >= 3242721280 /*12.5*/) goto t19_n172;
  t19_n171: return 0.06365711241960526f;
  t19_n172: return 0.0023474683985114098f;
  t19_n173: return 0.07130961865186691f;
  t19_n174: if (E.getNumReferences() >= 3260940288 /*55.5*/) goto t19_n176;
  t19_n175: return 0.04247064143419266f;
  t19_n176: return 0.10458920896053314f;
  t19_n177: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t19_n179;
  t19_n178: return 0.047326624393463135f;
  t19_n179: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t19_n181;
  t19_n180: return 0.06774117052555084f;
  t19_n181: if (E.getNumReferences() >= 3348232704 /*74740.0*/) goto t19_n183;
  t19_n182: return 0.09510940313339233f;
  t19_n183: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel))) goto t19_n185;
  t19_n184: return 0.11148997396230698f;
  t19_n185: return 0.1188788115978241f;
  t19_n186: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t19_n200;
  t19_n187: if (E.getNumReferences() >= 3238526976 /*8.5*/) goto t19_n197;
  t19_n188: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t19_n192;
  t19_n189: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t19_n191;
  t19_n190: return 0.026394285261631012f;
  t19_n191: return 0.06177189573645592f;
  t19_n192: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t19_n196;
  t19_n193: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t19_n195;
  t19_n194: return 0.05059698969125748f;
  t19_n195: return 0.08456900715827942f;
  t19_n196: return 0.07470441609621048f;
  t19_n197: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t19_n199;
  t19_n198: return 0.07849942147731781f;
  t19_n199: return 0.0956626608967781f;
  t19_n200: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t19_n202;
  t19_n201: return -0.07124411314725876f;
  t19_n202: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t19_n228;
  t19_n203: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t19_n227;
  t19_n204: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t19_n220;
  t19_n205: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t19_n217;
  t19_n206: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t19_n216;
  t19_n207: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t19_n215;
  t19_n208: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t19_n214;
  t19_n209: if (E.getFractionNameInContext() >= 3193536758 /*0.2124060094356537*/) goto t19_n213;
  t19_n210: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t19_n212;
  t19_n211: return 0.011244315654039383f;
  t19_n212: return -0.03444498032331467f;
  t19_n213: return 0.029098059982061386f;
  t19_n214: return 0.04340164363384247f;
  t19_n215: return -0.08445042371749878f;
  t19_n216: return -0.11181472986936569f;
  t19_n217: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t19_n219;
  t19_n218: return 0.06898421794176102f;
  t19_n219: return -0.0616443008184433f;
  t19_n220: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t19_n224;
  t19_n221: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t19_n223;
  t19_n222: return -0.05231807753443718f;
  t19_n223: return 0.038282256573438644f;
  t19_n224: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol))) goto t19_n226;
  t19_n225: return 0.06495742499828339f;
  t19_n226: return 0.09100478142499924f;
  t19_n227: return 0.06837449967861176f;
  t19_n228: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t19_n232;
  t19_n229: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t19_n231;
  t19_n230: return -0.03999538719654083f;
  t19_n231: return 0.07601036131381989f;
  t19_n232: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Symbol))) goto t19_n238;
  t19_n233: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t19_n235;
  t19_n234: return -0.10224807262420654f;
  t19_n235: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t19_n237;
  t19_n236: return 0.04375891014933586f;
  t19_n237: return 0.08155979961156845f;
  t19_n238: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t19_n240;
  t19_n239: return 0.06552579998970032f;
  t19_n240: return 0.09656500071287155f;
  t19_n241: if (E.getNumReferences() >= 3376956888 /*820317.5*/) goto t19_n247;
  t19_n242: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t19_n244;
  t19_n243: return 0.02664380520582199f;
  t19_n244: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t19_n246;
  t19_n245: return 0.07736501842737198f;
  t19_n246: return 0.10133399069309235f;
  t19_n247: return 0.1004239171743393f;
  t19_n248: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_Type))) goto t19_n250;
  t19_n249: return 0.0005538350087590516f;
  t19_n250: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t19_n254;
  t19_n251: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t19_n253;
  t19_n252: return 0.08641254156827927f;
  t19_n253: return 0.09575098752975464f;
  t19_n254: return 0.10472235828638077f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree20(const Example& E) {
  t20_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t20_n250;
  t20_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t20_n243;
  t20_n2: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t20_n130;
  t20_n3: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t20_n65;
  t20_n4: if (E.getNumReferences() >= 3294208000 /*870.5*/) goto t20_n48;
  t20_n5: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t20_n9;
  t20_n6: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t20_n8;
  t20_n7: return -0.08446692675352097f;
  t20_n8: return 0.00097454380011186f;
  t20_n9: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t20_n15;
  t20_n10: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t20_n14;
  t20_n11: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t20_n13;
  t20_n12: return -0.007407733239233494f;
  t20_n13: return 0.029866216704249382f;
  t20_n14: return 0.06931301951408386f;
  t20_n15: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t20_n43;
  t20_n16: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t20_n28;
  t20_n17: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t20_n19;
  t20_n18: return -0.04288862273097038f;
  t20_n19: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t20_n27;
  t20_n20: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t20_n22;
  t20_n21: return -0.05304865911602974f;
  t20_n22: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t20_n24;
  t20_n23: return -0.008867346681654453f;
  t20_n24: if (E.getFileProximityDistanceCost() >= 3247177728 /*17.5*/) goto t20_n26;
  t20_n25: return 0.09764218330383301f;
  t20_n26: return 0.11693631112575531f;
  t20_n27: return 0.0549137108027935f;
  t20_n28: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t20_n32;
  t20_n29: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t20_n31;
  t20_n30: return 0.00355226406827569f;
  t20_n31: return -0.036602653563022614f;
  t20_n32: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t20_n38;
  t20_n33: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t20_n37;
  t20_n34: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t20_n36;
  t20_n35: return 0.029248477891087532f;
  t20_n36: return -0.10091078281402588f;
  t20_n37: return -0.04293544590473175f;
  t20_n38: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t20_n42;
  t20_n39: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Type))) goto t20_n41;
  t20_n40: return 0.05772420018911362f;
  t20_n41: return 0.09015408903360367f;
  t20_n42: return -0.12972143292427063f;
  t20_n43: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t20_n47;
  t20_n44: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t20_n46;
  t20_n45: return -0.08221940696239471f;
  t20_n46: return 0.02045132964849472f;
  t20_n47: return -0.07184974104166031f;
  t20_n48: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t20_n56;
  t20_n49: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t20_n53;
  t20_n50: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t20_n52;
  t20_n51: return 0.018698906525969505f;
  t20_n52: return 0.04623384401202202f;
  t20_n53: if (E.getNumReferences() >= 3361959232 /*232885.0*/) goto t20_n55;
  t20_n54: return 0.09809751808643341f;
  t20_n55: return 0.052636682987213135f;
  t20_n56: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t20_n64;
  t20_n57: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t20_n59;
  t20_n58: return -0.051967985928058624f;
  t20_n59: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t20_n63;
  t20_n60: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t20_n62;
  t20_n61: return -0.002490680431947112f;
  t20_n62: return 0.05914066731929779f;
  t20_n63: return 0.05223003774881363f;
  t20_n64: return 0.06477952003479004f;
  t20_n65: if (E.getFileProximityDistanceCost() >= 3254517760 /*31.5*/) goto t20_n89;
  t20_n66: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t20_n78;
  t20_n67: if (E.getSymbolScopeDistanceCost() >= 3239051264 /*9.0*/) goto t20_n75;
  t20_n68: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t20_n72;
  t20_n69: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t20_n71;
  t20_n70: return 0.03656499460339546f;
  t20_n71: return -0.0066644735634326935f;
  t20_n72: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t20_n74;
  t20_n73: return 0.06139461323618889f;
  t20_n74: return 0.007321399170905352f;
  t20_n75: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t20_n77;
  t20_n76: return -0.014286796562373638f;
  t20_n77: return 0.07164452224969864f;
  t20_n78: if (E.getNumReferences() >= 3348227392 /*74698.5*/) goto t20_n88;
  t20_n79: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t20_n83;
  t20_n80: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t20_n82;
  t20_n81: return -0.005573098547756672f;
  t20_n82: return 0.08950471878051758f;
  t20_n83: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t20_n85;
  t20_n84: return 0.05239318311214447f;
  t20_n85: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t20_n87;
  t20_n86: return -0.02284478209912777f;
  t20_n87: return 0.07205484807491302f;
  t20_n88: return 0.0958346575498581f;
  t20_n89: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t20_n129;
  t20_n90: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t20_n120;
  t20_n91: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t20_n117;
  t20_n92: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t20_n94;
  t20_n93: return -0.05190487205982208f;
  t20_n94: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t20_n110;
  t20_n95: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t20_n107;
  t20_n96: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t20_n106;
  t20_n97: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t20_n99;
  t20_n98: return -0.051081329584121704f;
  t20_n99: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t20_n103;
  t20_n100: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t20_n102;
  t20_n101: return 0.012832926586270332f;
  t20_n102: return -0.1044711098074913f;
  t20_n103: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t20_n105;
  t20_n104: return -0.14434757828712463f;
  t20_n105: return 0.00934070535004139f;
  t20_n106: return 0.02930881641805172f;
  t20_n107: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t20_n109;
  t20_n108: return -0.038993336260318756f;
  t20_n109: return 0.060413748025894165f;
  t20_n110: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t20_n114;
  t20_n111: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t20_n113;
  t20_n112: return 0.021879035979509354f;
  t20_n113: return 0.12797299027442932f;
  t20_n114: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t20_n116;
  t20_n115: return 0.10001148283481598f;
  t20_n116: return 0.027437085285782814f;
  t20_n117: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t20_n119;
  t20_n118: return -0.0850173830986023f;
  t20_n119: return 0.01434915978461504f;
  t20_n120: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t20_n128;
  t20_n121: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t20_n127;
  t20_n122: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t20_n126;
  t20_n123: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t20_n125;
  t20_n124: return 0.0015232909936457872f;
  t20_n125: return 0.037290751934051514f;
  t20_n126: return -0.07696015387773514f;
  t20_n127: return 0.0696488693356514f;
  t20_n128: return 0.06982062011957169f;
  t20_n129: return 0.02321135252714157f;
  t20_n130: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t20_n190;
  t20_n131: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t20_n151;
  t20_n132: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t20_n144;
  t20_n133: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t20_n135;
  t20_n134: return -0.0126145975664258f;
  t20_n135: if (E.getFractionNameInContext() >= 3193057410 /*0.2052631676197052*/) goto t20_n137;
  t20_n136: return 0.024738823994994164f;
  t20_n137: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t20_n143;
  t20_n138: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t20_n142;
  t20_n139: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t20_n141;
  t20_n140: return 0.04791749268770218f;
  t20_n141: return 0.0048164064064621925f;
  t20_n142: return 0.08252574503421783f;
  t20_n143: return 0.08207780867815018f;
  t20_n144: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t20_n150;
  t20_n145: if (E.getNumReferences() >= 3256483840 /*38.5*/) goto t20_n147;
  t20_n146: return 0.04207991808652878f;
  t20_n147: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t20_n149;
  t20_n148: return 0.04851240664720535f;
  t20_n149: return 0.07518533617258072f;
  t20_n150: return 0.08282148092985153f;
  t20_n151: if (E.getNumReferences() >= 3306285056 /*2334.5*/) goto t20_n185;
  t20_n152: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t20_n172;
  t20_n153: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t20_n169;
  t20_n154: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t20_n168;
  t20_n155: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t20_n157;
  t20_n156: return -0.0652155727148056f;
  t20_n157: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t20_n159;
  t20_n158: return -0.014505937695503235f;
  t20_n159: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t20_n161;
  t20_n160: return 0.021951941773295403f;
  t20_n161: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t20_n163;
  t20_n162: return -0.039148781448602676f;
  t20_n163: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t20_n167;
  t20_n164: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t20_n166;
  t20_n165: return 0.12677302956581116f;
  t20_n166: return -0.07420652359724045f;
  t20_n167: return -0.15558141469955444f;
  t20_n168: return 0.029806705191731453f;
  t20_n169: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t20_n171;
  t20_n170: return 0.00819002278149128f;
  t20_n171: return 0.076438307762146f;
  t20_n172: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t20_n182;
  t20_n173: if (E.getNumReferences() >= 3251372032 /*25.5*/) goto t20_n177;
  t20_n174: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t20_n176;
  t20_n175: return 0.0050080013461411f;
  t20_n176: return 0.06769081950187683f;
  t20_n177: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t20_n179;
  t20_n178: return 0.11467179656028748f;
  t20_n179: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t20_n181;
  t20_n180: return 0.04071382060647011f;
  t20_n181: return 0.1094680204987526f;
  t20_n182: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t20_n184;
  t20_n183: return 0.04229774326086044f;
  t20_n184: return 0.0705614760518074f;
  t20_n185: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t20_n187;
  t20_n186: return 0.045066237449645996f;
  t20_n187: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t20_n189;
  t20_n188: return 0.06431018561124802f;
  t20_n189: return 0.10903210937976837f;
  t20_n190: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t20_n202;
  t20_n191: if (E.getNumReferences() >= 3241672704 /*11.5*/) goto t20_n201;
  t20_n192: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t20_n196;
  t20_n193: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t20_n195;
  t20_n194: return 0.023748906329274178f;
  t20_n195: return 0.059338998049497604f;
  t20_n196: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t20_n200;
  t20_n197: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t20_n199;
  t20_n198: return 0.04861718788743019f;
  t20_n199: return 0.08216684311628342f;
  t20_n200: return 0.07276076823472977f;
  t20_n201: return 0.07949776202440262f;
  t20_n202: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t20_n204;
  t20_n203: return -0.06702902913093567f;
  t20_n204: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t20_n232;
  t20_n205: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t20_n231;
  t20_n206: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t20_n218;
  t20_n207: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t20_n211;
  t20_n208: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t20_n210;
  t20_n209: return 0.03195973485708237f;
  t20_n210: return -0.10640867799520493f;
  t20_n211: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t20_n215;
  t20_n212: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t20_n214;
  t20_n213: return 0.015176868997514248f;
  t20_n214: return -0.10777612030506134f;
  t20_n215: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t20_n217;
  t20_n216: return 0.06208501756191254f;
  t20_n217: return 0.01857876218855381f;
  t20_n218: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t20_n228;
  t20_n219: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t20_n221;
  t20_n220: return 0.018400469794869423f;
  t20_n221: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t20_n223;
  t20_n222: return 0.030649183318018913f;
  t20_n223: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t20_n225;
  t20_n224: return 0.03667152300477028f;
  t20_n225: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t20_n227;
  t20_n226: return 0.09160792827606201f;
  t20_n227: return 0.0531383715569973f;
  t20_n228: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol))) goto t20_n230;
  t20_n229: return 0.06108298897743225f;
  t20_n230: return 0.08859045803546906f;
  t20_n231: return 0.06578335911035538f;
  t20_n232: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t20_n236;
  t20_n233: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t20_n235;
  t20_n234: return -0.04178015887737274f;
  t20_n235: return 0.0730225145816803f;
  t20_n236: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Symbol))) goto t20_n242;
  t20_n237: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t20_n239;
  t20_n238: return -0.09311359375715256f;
  t20_n239: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t20_n241;
  t20_n240: return 0.03755008429288864f;
  t20_n241: return 0.07981447875499725f;
  t20_n242: return 0.07642342150211334f;
  t20_n243: if (E.getNumReferences() >= 3376956888 /*820317.5*/) goto t20_n249;
  t20_n244: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol))) goto t20_n246;
  t20_n245: return 0.038466062396764755f;
  t20_n246: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t20_n248;
  t20_n247: return 0.09462285786867142f;
  t20_n248: return 0.0268978513777256f;
  t20_n249: return 0.09923490136861801f;
  t20_n250: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_Type))) goto t20_n252;
  t20_n251: return 0.000464608718175441f;
  t20_n252: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t20_n254;
  t20_n253: return 0.08772865682840347f;
  t20_n254: return 0.09641122817993164f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree21(const Example& E) {
  t21_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t21_n248;
  t21_n1: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t21_n241;
  t21_n2: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t21_n108;
  t21_n3: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t21_n61;
  t21_n4: if (E.getNumReferences() >= 3303288832 /*1825.5*/) goto t21_n50;
  t21_n5: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t21_n13;
  t21_n6: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t21_n10;
  t21_n7: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t21_n9;
  t21_n8: return -0.017660589888691902f;
  t21_n9: return 0.04810502380132675f;
  t21_n10: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t21_n12;
  t21_n11: return 0.03256858140230179f;
  t21_n12: return 0.0893988385796547f;
  t21_n13: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t21_n39;
  t21_n14: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t21_n34;
  t21_n15: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t21_n33;
  t21_n16: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t21_n32;
  t21_n17: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t21_n19;
  t21_n18: return -0.0852886214852333f;
  t21_n19: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t21_n21;
  t21_n20: return -0.04189859330654144f;
  t21_n21: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t21_n23;
  t21_n22: return -0.03138996288180351f;
  t21_n23: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t21_n29;
  t21_n24: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t21_n28;
  t21_n25: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t21_n27;
  t21_n26: return 0.04107252508401871f;
  t21_n27: return -0.13073670864105225f;
  t21_n28: return -0.09258755296468735f;
  t21_n29: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Type))) goto t21_n31;
  t21_n30: return 0.056583043187856674f;
  t21_n31: return 0.09075275808572769f;
  t21_n32: return 0.0037409812211990356f;
  t21_n33: return -0.13122060894966125f;
  t21_n34: if (E.getNumReferences() >= 3236954112 /*7.5*/) goto t21_n36;
  t21_n35: return -0.11074119806289673f;
  t21_n36: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t21_n38;
  t21_n37: return -0.003941063303500414f;
  t21_n38: return -0.08654595911502838f;
  t21_n39: if (E.getFractionNameInContext() >= 3169944461 /*0.02948167361319065*/) goto t21_n41;
  t21_n40: return -0.012079334817826748f;
  t21_n41: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t21_n43;
  t21_n42: return -0.13587448000907898f;
  t21_n43: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel))) goto t21_n45;
  t21_n44: return -0.017871158197522163f;
  t21_n45: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t21_n47;
  t21_n46: return -0.03711516037583351f;
  t21_n47: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t21_n49;
  t21_n48: return 0.06018409505486488f;
  t21_n49: return -0.10311909765005112f;
  t21_n50: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t21_n58;
  t21_n51: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t21_n53;
  t21_n52: return 0.0328422449529171f;
  t21_n53: if (E.getNumReferences() >= 3361959232 /*232885.0*/) goto t21_n57;
  t21_n54: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t21_n56;
  t21_n55: return 0.08798015117645264f;
  t21_n56: return 0.1320185661315918f;
  t21_n57: return 0.05107228457927704f;
  t21_n58: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t21_n60;
  t21_n59: return -0.004882383160293102f;
  t21_n60: return 0.0621512345969677f;
  t21_n61: if (E.getFileProximityDistanceCost() >= 3254517760 /*31.5*/) goto t21_n77;
  t21_n62: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t21_n70;
  t21_n63: if (E.getContextKind() & (BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_UnionTag))) goto t21_n67;
  t21_n64: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t21_n66;
  t21_n65: return 0.026404617354273796f;
  t21_n66: return -0.05003299191594124f;
  t21_n67: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t21_n69;
  t21_n68: return 0.0875263437628746f;
  t21_n69: return 0.03027326613664627f;
  t21_n70: if (E.getNumReferences() >= 3359831936 /*199646.0*/) goto t21_n74;
  t21_n71: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t21_n73;
  t21_n72: return 0.049134548753499985f;
  t21_n73: return 0.07478822022676468f;
  t21_n74: if (E.getNumReferences() >= 3360215360 /*205637.0*/) goto t21_n76;
  t21_n75: return 0.1207113042473793f;
  t21_n76: return 0.08426836133003235f;
  t21_n77: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t21_n95;
  t21_n78: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t21_n92;
  t21_n79: if (E.getSymbolScopeDistanceCost() >= 3221225472 /*2.0*/) goto t21_n91;
  t21_n80: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t21_n88;
  t21_n81: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t21_n85;
  t21_n82: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t21_n84;
  t21_n83: return -0.060715582221746445f;
  t21_n84: return 0.0038725873455405235f;
  t21_n85: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t21_n87;
  t21_n86: return -0.06607094407081604f;
  t21_n87: return 0.026456739753484726f;
  t21_n88: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t21_n90;
  t21_n89: return 0.002559500513598323f;
  t21_n90: return 0.06194464862346649f;
  t21_n91: return -0.05008108541369438f;
  t21_n92: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t21_n94;
  t21_n93: return 0.017606602981686592f;
  t21_n94: return 0.0705142691731453f;
  t21_n95: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t21_n103;
  t21_n96: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t21_n102;
  t21_n97: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t21_n99;
  t21_n98: return -0.019845962524414062f;
  t21_n99: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t21_n101;
  t21_n100: return 0.013994164764881134f;
  t21_n101: return 0.09776913374662399f;
  t21_n102: return 0.036195699125528336f;
  t21_n103: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t21_n107;
  t21_n104: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t21_n106;
  t21_n105: return 0.09925658255815506f;
  t21_n106: return 0.075357586145401f;
  t21_n107: return 0.024015840142965317f;
  t21_n108: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t21_n166;
  t21_n109: if (E.getNumReferences() >= 3303280640 /*1824.5*/) goto t21_n157;
  t21_n110: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t21_n124;
  t21_n111: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t21_n119;
  t21_n112: if (E.getFractionNameInContext() >= 3199184816 /*0.343137264251709*/) goto t21_n118;
  t21_n113: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t21_n117;
  t21_n114: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t21_n116;
  t21_n115: return 0.011326676234602928f;
  t21_n116: return 0.06660959124565125f;
  t21_n117: return 0.05186133459210396f;
  t21_n118: return 0.04757707938551903f;
  t21_n119: if (E.getNumReferences() >= 3255173120 /*33.5*/) goto t21_n123;
  t21_n120: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t21_n122;
  t21_n121: return 0.052768297493457794f;
  t21_n122: return 0.09037275612354279f;
  t21_n123: return 0.08538372069597244f;
  t21_n124: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t21_n146;
  t21_n125: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t21_n129;
  t21_n126: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t21_n128;
  t21_n127: return -0.0556110180914402f;
  t21_n128: return 0.027215968817472458f;
  t21_n129: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t21_n131;
  t21_n130: return -0.00507610896602273f;
  t21_n131: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t21_n135;
  t21_n132: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t21_n134;
  t21_n133: return 0.006369420327246189f;
  t21_n134: return 0.0593663789331913f;
  t21_n135: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t21_n145;
  t21_n136: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t21_n138;
  t21_n137: return 0.013723080977797508f;
  t21_n138: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t21_n144;
  t21_n139: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t21_n141;
  t21_n140: return -0.011388116516172886f;
  t21_n141: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t21_n143;
  t21_n142: return 0.1187608391046524f;
  t21_n143: return 0.027430858463048935f;
  t21_n144: return -0.06163299083709717f;
  t21_n145: return -0.06084693223237991f;
  t21_n146: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t21_n152;
  t21_n147: if (E.getFileProximityDistanceCost() >= 3250847744 /*24.5*/) goto t21_n149;
  t21_n148: return 0.006135711912065744f;
  t21_n149: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t21_n151;
  t21_n150: return 0.035351768136024475f;
  t21_n151: return 0.061584826558828354f;
  t21_n152: if (E.getContextKind() & (BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement))) goto t21_n156;
  t21_n153: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t21_n155;
  t21_n154: return 0.038981880992650986f;
  t21_n155: return 0.07669363170862198f;
  t21_n156: return 0.07439883053302765f;
  t21_n157: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t21_n163;
  t21_n158: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t21_n160;
  t21_n159: return 0.0382685512304306f;
  t21_n160: if (E.getNumReferences() >= 3340710656 /*40755.0*/) goto t21_n162;
  t21_n161: return 0.06035589054226875f;
  t21_n162: return 0.08764096349477768f;
  t21_n163: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t21_n165;
  t21_n164: return 0.06254567205905914f;
  t21_n165: return 0.10777954012155533f;
  t21_n166: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t21_n182;
  t21_n167: if (E.getNumReferences() >= 3239575552 /*9.5*/) goto t21_n179;
  t21_n168: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t21_n174;
  t21_n169: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t21_n173;
  t21_n170: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t21_n172;
  t21_n171: return -0.03798958286643028f;
  t21_n172: return 0.03351264074444771f;
  t21_n173: return 0.05793866887688637f;
  t21_n174: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t21_n178;
  t21_n175: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t21_n177;
  t21_n176: return 0.04589905962347984f;
  t21_n177: return 0.07961735129356384f;
  t21_n178: return 0.0695846751332283f;
  t21_n179: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t21_n181;
  t21_n180: return 0.07373574376106262f;
  t21_n181: return 0.09342595189809799f;
  t21_n182: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t21_n184;
  t21_n183: return -0.0630820021033287f;
  t21_n184: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t21_n226;
  t21_n185: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t21_n225;
  t21_n186: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t21_n210;
  t21_n187: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t21_n207;
  t21_n188: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t21_n198;
  t21_n189: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t21_n195;
  t21_n190: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t21_n194;
  t21_n191: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t21_n193;
  t21_n192: return 0.025784090161323547f;
  t21_n193: return -0.10833871364593506f;
  t21_n194: return 0.010522305965423584f;
  t21_n195: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t21_n197;
  t21_n196: return -0.08941081166267395f;
  t21_n197: return 0.019006893038749695f;
  t21_n198: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t21_n206;
  t21_n199: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t21_n201;
  t21_n200: return 0.005262511782348156f;
  t21_n201: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t21_n203;
  t21_n202: return 0.01171373575925827f;
  t21_n203: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t21_n205;
  t21_n204: return 0.03103834018111229f;
  t21_n205: return 0.0881718173623085f;
  t21_n206: return 0.0559178926050663f;
  t21_n207: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t21_n209;
  t21_n208: return 0.04902995377779007f;
  t21_n209: return -0.05985572561621666f;
  t21_n210: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t21_n216;
  t21_n211: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t21_n213;
  t21_n212: return 0.03487525135278702f;
  t21_n213: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t21_n215;
  t21_n214: return 0.04582371190190315f;
  t21_n215: return 0.08009430021047592f;
  t21_n216: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t21_n218;
  t21_n217: return -0.10312946140766144f;
  t21_n218: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t21_n220;
  t21_n219: return -0.0709339901804924f;
  t21_n220: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t21_n224;
  t21_n221: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t21_n223;
  t21_n222: return -0.031155699864029884f;
  t21_n223: return 0.07745353877544403f;
  t21_n224: return -0.0016023337375372648f;
  t21_n225: return 0.06224945932626724f;
  t21_n226: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t21_n230;
  t21_n227: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t21_n229;
  t21_n228: return -0.04016260802745819f;
  t21_n229: return 0.0707937628030777f;
  t21_n230: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Symbol))) goto t21_n236;
  t21_n231: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t21_n233;
  t21_n232: return -0.08701765537261963f;
  t21_n233: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t21_n235;
  t21_n234: return 0.037114132195711136f;
  t21_n235: return 0.07737923413515091f;
  t21_n236: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t21_n238;
  t21_n237: return 0.059987083077430725f;
  t21_n238: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t21_n240;
  t21_n239: return 0.09281321614980698f;
  t21_n240: return -0.10566782206296921f;
  t21_n241: if (E.getNumReferences() >= 3376956888 /*820317.5*/) goto t21_n247;
  t21_n242: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t21_n246;
  t21_n243: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t21_n245;
  t21_n244: return 0.09765352308750153f;
  t21_n245: return 0.023405618965625763f;
  t21_n246: return 0.09649825096130371f;
  t21_n247: return 0.09792269766330719f;
  t21_n248: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t21_n254;
  t21_n249: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_Type))) goto t21_n251;
  t21_n250: return -0.00020703079644590616f;
  t21_n251: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t21_n253;
  t21_n252: return 0.08144746720790863f;
  t21_n253: return 0.0923483818769455f;
  t21_n254: return 0.10317377001047134f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree22(const Example& E) {
  t22_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t22_n252;
  t22_n1: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t22_n111;
  t22_n2: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t22_n110;
  t22_n3: if (E.getNumReferences() >= 3338822784 /*33380.5*/) goto t22_n85;
  t22_n4: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t22_n44;
  t22_n5: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t22_n15;
  t22_n6: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t22_n12;
  t22_n7: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t22_n9;
  t22_n8: return -0.039822421967983246f;
  t22_n9: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t22_n11;
  t22_n10: return 0.025359272956848145f;
  t22_n11: return -0.011726466938853264f;
  t22_n12: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t22_n14;
  t22_n13: return 0.03598053753376007f;
  t22_n14: return 0.008059509098529816f;
  t22_n15: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t22_n41;
  t22_n16: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t22_n18;
  t22_n17: return -0.08492957055568695f;
  t22_n18: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t22_n38;
  t22_n19: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t22_n25;
  t22_n20: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t22_n22;
  t22_n21: return -0.06562621891498566f;
  t22_n22: if (E.getNumReferences() >= 3268608000 /*105.5*/) goto t22_n24;
  t22_n23: return -0.01498045027256012f;
  t22_n24: return 0.06268271058797836f;
  t22_n25: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t22_n27;
  t22_n26: return -0.07605123519897461f;
  t22_n27: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t22_n33;
  t22_n28: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t22_n32;
  t22_n29: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t22_n31;
  t22_n30: return 0.025273969396948814f;
  t22_n31: return -0.13237541913986206f;
  t22_n32: return -0.09356242418289185f;
  t22_n33: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t22_n37;
  t22_n34: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t22_n36;
  t22_n35: return 0.06796815246343613f;
  t22_n36: return -0.043968044221401215f;
  t22_n37: return -0.12704205513000488f;
  t22_n38: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t22_n40;
  t22_n39: return -0.08898263424634933f;
  t22_n40: return 0.03700250759720802f;
  t22_n41: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t22_n43;
  t22_n42: return 4.428053580340929e-05f;
  t22_n43: return -0.050931207835674286f;
  t22_n44: if (E.getFileProximityDistanceCost() >= 3254517760 /*31.5*/) goto t22_n62;
  t22_n45: if (E.getContextKind() & (BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_UnionTag))) goto t22_n59;
  t22_n46: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t22_n56;
  t22_n47: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t22_n55;
  t22_n48: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t22_n54;
  t22_n49: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t22_n51;
  t22_n50: return 0.04536445066332817f;
  t22_n51: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t22_n53;
  t22_n52: return -0.02131679654121399f;
  t22_n53: return 0.054524026811122894f;
  t22_n54: return -0.014721457846462727f;
  t22_n55: return 0.04267771914601326f;
  t22_n56: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t22_n58;
  t22_n57: return -0.023372258991003036f;
  t22_n58: return 0.06468883901834488f;
  t22_n59: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t22_n61;
  t22_n60: return 0.08837075531482697f;
  t22_n61: return 0.033792346715927124f;
  t22_n62: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t22_n64;
  t22_n63: return -0.018502069637179375f;
  t22_n64: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t22_n72;
  t22_n65: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t22_n67;
  t22_n66: return -0.015438049100339413f;
  t22_n67: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t22_n71;
  t22_n68: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t22_n70;
  t22_n69: return 0.03301067277789116f;
  t22_n70: return -0.047911666333675385f;
  t22_n71: return 0.08380847424268723f;
  t22_n72: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t22_n84;
  t22_n73: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t22_n77;
  t22_n74: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t22_n76;
  t22_n75: return -0.040663834661245346f;
  t22_n76: return 0.042868565768003464f;
  t22_n77: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t22_n79;
  t22_n78: return 0.02583738975226879f;
  t22_n79: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t22_n83;
  t22_n80: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t22_n82;
  t22_n81: return 0.09285453706979752f;
  t22_n82: return 0.07189871370792389f;
  t22_n83: return -0.0015539037995040417f;
  t22_n84: return 0.06820765882730484f;
  t22_n85: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t22_n93;
  t22_n86: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t22_n88;
  t22_n87: return 0.04412587732076645f;
  t22_n88: if (E.getNumReferences() >= 3361959232 /*232885.0*/) goto t22_n92;
  t22_n89: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t22_n91;
  t22_n90: return 0.09050342440605164f;
  t22_n91: return 0.13227252662181854f;
  t22_n92: return 0.07205983251333237f;
  t22_n93: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t22_n107;
  t22_n94: if (E.getNumReferences() >= 3362537216 /*241916.0*/) goto t22_n106;
  t22_n95: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t22_n97;
  t22_n96: return 0.009341474622488022f;
  t22_n97: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel))) goto t22_n103;
  t22_n98: if (E.getNumReferences() >= 3360215360 /*205637.0*/) goto t22_n102;
  t22_n99: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t22_n101;
  t22_n100: return -0.13732948899269104f;
  t22_n101: return 0.09972120821475983f;
  t22_n102: return 0.027830373495817184f;
  t22_n103: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t22_n105;
  t22_n104: return -0.16001495718955994f;
  t22_n105: return 0.12360203266143799f;
  t22_n106: return -0.04293643683195114f;
  t22_n107: if (E.getNumReferences() >= 3345992448 /*61387.0*/) goto t22_n109;
  t22_n108: return 0.019297409802675247f;
  t22_n109: return 0.08325894922018051f;
  t22_n110: return 0.090275339782238f;
  t22_n111: if (E.getNumReferences() >= 3326314496 /*12514.0*/) goto t22_n239;
  t22_n112: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t22_n172;
  t22_n113: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t22_n165;
  t22_n114: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t22_n130;
  t22_n115: if (E.getNumReferences() >= 3238526976 /*8.5*/) goto t22_n127;
  t22_n116: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t22_n122;
  t22_n117: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t22_n121;
  t22_n118: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t22_n120;
  t22_n119: return 0.024193083867430687f;
  t22_n120: return 0.07236923277378082f;
  t22_n121: return -0.005528525914996862f;
  t22_n122: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t22_n126;
  t22_n123: if (E.getFractionNameInContext() >= 3190975644 /*0.17424243688583374*/) goto t22_n125;
  t22_n124: return 0.01674993522465229f;
  t22_n125: return 0.07396739721298218f;
  t22_n126: return 0.0648023784160614f;
  t22_n127: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel))) goto t22_n129;
  t22_n128: return 0.05316375568509102f;
  t22_n129: return 0.08152072876691818f;
  t22_n130: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t22_n136;
  t22_n131: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t22_n133;
  t22_n132: return -0.050565704703330994f;
  t22_n133: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t22_n135;
  t22_n134: return -0.03524129092693329f;
  t22_n135: return 0.04407075420022011f;
  t22_n136: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type))) goto t22_n158;
  t22_n137: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t22_n153;
  t22_n138: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t22_n140;
  t22_n139: return -0.012651240453124046f;
  t22_n140: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t22_n152;
  t22_n141: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t22_n151;
  t22_n142: if (E.getSymbolScopeDistanceCost() >= 3246915584 /*17.0*/) goto t22_n144;
  t22_n143: return 0.011491547338664532f;
  t22_n144: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t22_n150;
  t22_n145: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t22_n147;
  t22_n146: return -0.09656865894794464f;
  t22_n147: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel))) goto t22_n149;
  t22_n148: return 0.11515773087739944f;
  t22_n149: return 0.11253242939710617f;
  t22_n150: return -0.033081088215112686f;
  t22_n151: return -0.14245766401290894f;
  t22_n152: return -0.08601906895637512f;
  t22_n153: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t22_n155;
  t22_n154: return 0.02104014903306961f;
  t22_n155: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t22_n157;
  t22_n156: return 0.0359388068318367f;
  t22_n157: return 0.0651618093252182f;
  t22_n158: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t22_n162;
  t22_n159: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t22_n161;
  t22_n160: return -0.029158124700188637f;
  t22_n161: return 0.042659319937229156f;
  t22_n162: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t22_n164;
  t22_n163: return -0.008541225455701351f;
  t22_n164: return 0.07240114361047745f;
  t22_n165: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t22_n171;
  t22_n166: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t22_n170;
  t22_n167: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t22_n169;
  t22_n168: return 0.03532523289322853f;
  t22_n169: return 0.07741449028253555f;
  t22_n170: return 0.07431796193122864f;
  t22_n171: return 0.07664944231510162f;
  t22_n172: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t22_n196;
  t22_n173: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t22_n191;
  t22_n174: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t22_n176;
  t22_n175: return -0.057857438921928406f;
  t22_n176: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t22_n186;
  t22_n177: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t22_n183;
  t22_n178: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t22_n182;
  t22_n179: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t22_n181;
  t22_n180: return 0.037165217101573944f;
  t22_n181: return -0.03865008428692818f;
  t22_n182: return -0.10390646755695343f;
  t22_n183: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t22_n185;
  t22_n184: return 0.013178643770515919f;
  t22_n185: return -0.09295402467250824f;
  t22_n186: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t22_n190;
  t22_n187: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Statement))) goto t22_n189;
  t22_n188: return 0.03755037486553192f;
  t22_n189: return 0.06751663982868195f;
  t22_n190: return 0.01613052375614643f;
  t22_n191: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t22_n195;
  t22_n192: if (E.getNumReferences() >= 3315746816 /*5193.0*/) goto t22_n194;
  t22_n193: return 0.04075400531291962f;
  t22_n194: return 0.1343366503715515f;
  t22_n195: return 0.06828513741493225f;
  t22_n196: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t22_n232;
  t22_n197: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t22_n209;
  t22_n198: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t22_n208;
  t22_n199: if (E.getFileProximityDistanceCost() >= 3255566336 /*35.0*/) goto t22_n201;
  t22_n200: return 0.04738261178135872f;
  t22_n201: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t22_n205;
  t22_n202: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t22_n204;
  t22_n203: return -0.013774477876722813f;
  t22_n204: return 0.04819831997156143f;
  t22_n205: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t22_n207;
  t22_n206: return 0.04972014203667641f;
  t22_n207: return 0.09827175736427307f;
  t22_n208: return 0.0583675391972065f;
  t22_n209: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t22_n231;
  t22_n210: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t22_n230;
  t22_n211: if (E.getNumReferences() >= 3261202432 /*56.5*/) goto t22_n229;
  t22_n212: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t22_n218;
  t22_n213: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t22_n217;
  t22_n214: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t22_n216;
  t22_n215: return 0.01655348762869835f;
  t22_n216: return 0.06383705139160156f;
  t22_n217: return 0.0766592025756836f;
  t22_n218: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t22_n226;
  t22_n219: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t22_n225;
  t22_n220: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t22_n222;
  t22_n221: return -0.0044402084313333035f;
  t22_n222: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t22_n224;
  t22_n223: return -0.0016367328353226185f;
  t22_n224: return 0.08321958035230637f;
  t22_n225: return 0.08889246731996536f;
  t22_n226: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t22_n228;
  t22_n227: return 0.06799590587615967f;
  t22_n228: return 0.08665550500154495f;
  t22_n229: return 0.08114530891180038f;
  t22_n230: return 0.08481054753065109f;
  t22_n231: return 0.06889069080352783f;
  t22_n232: if (E.getScope() & (BIT(Scope_type::FunctionScope)|BIT(Scope_type::GlobalScope))) goto t22_n234;
  t22_n233: return -0.08651486039161682f;
  t22_n234: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t22_n236;
  t22_n235: return -0.09247734397649765f;
  t22_n236: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t22_n238;
  t22_n237: return 0.029512256383895874f;
  t22_n238: return 0.0684371143579483f;
  t22_n239: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t22_n251;
  t22_n240: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t22_n250;
  t22_n241: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t22_n243;
  t22_n242: return 0.06811776757240295f;
  t22_n243: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t22_n245;
  t22_n244: return 0.08835053443908691f;
  t22_n245: if (E.getNumReferences() >= 3348641152 /*77931.0*/) goto t22_n247;
  t22_n246: return 0.09274859726428986f;
  t22_n247: if (E.getNumReferences() >= 3349544768 /*84990.5*/) goto t22_n249;
  t22_n248: return 0.11544239521026611f;
  t22_n249: return 0.10740295052528381f;
  t22_n250: return 0.01823018305003643f;
  t22_n251: return 0.09711265563964844f;
  t22_n252: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t22_n254;
  t22_n253: return 0.08272507786750793f;
  t22_n254: return 0.09312154352664948f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree23(const Example& E) {
  t23_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t23_n252;
  t23_n1: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t23_n131;
  t23_n2: if (E.getNumReferences() >= 3359104096 /*188273.5*/) goto t23_n94;
  t23_n3: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t23_n57;
  t23_n4: if (E.getNumReferences() >= 3289473024 /*581.5*/) goto t23_n50;
  t23_n5: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t23_n13;
  t23_n6: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t23_n10;
  t23_n7: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t23_n9;
  t23_n8: return -0.015163918025791645f;
  t23_n9: return 0.044111788272857666f;
  t23_n10: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t23_n12;
  t23_n11: return 0.029083790257573128f;
  t23_n12: return 0.08392807096242905f;
  t23_n13: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t23_n49;
  t23_n14: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t23_n18;
  t23_n15: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t23_n17;
  t23_n16: return -0.08171065151691437f;
  t23_n17: return 0.0014842142118141055f;
  t23_n18: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t23_n20;
  t23_n19: return -0.03167363256216049f;
  t23_n20: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t23_n26;
  t23_n21: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t23_n23;
  t23_n22: return -0.043290577828884125f;
  t23_n23: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t23_n25;
  t23_n24: return -0.017333853989839554f;
  t23_n25: return 0.01772993430495262f;
  t23_n26: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t23_n48;
  t23_n27: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t23_n29;
  t23_n28: return 0.03146202489733696f;
  t23_n29: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t23_n41;
  t23_n30: if (E.getFractionNameInContext() >= 3169944461 /*0.02948167361319065*/) goto t23_n32;
  t23_n31: return -0.022962380200624466f;
  t23_n32: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t23_n34;
  t23_n33: return -0.03708374500274658f;
  t23_n34: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t23_n36;
  t23_n35: return 0.08569660782814026f;
  t23_n36: if (E.getFileProximityDistanceCost() >= 3247177728 /*17.5*/) goto t23_n38;
  t23_n37: return -0.1997450739145279f;
  t23_n38: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t23_n40;
  t23_n39: return 0.08334456384181976f;
  t23_n40: return 0.03100009448826313f;
  t23_n41: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t23_n43;
  t23_n42: return 0.006435176823288202f;
  t23_n43: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t23_n45;
  t23_n44: return -0.08190710842609406f;
  t23_n45: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Type))) goto t23_n47;
  t23_n46: return 0.045556604862213135f;
  t23_n47: return 0.07606726884841919f;
  t23_n48: return -0.10938204824924469f;
  t23_n49: return -0.07592273503541946f;
  t23_n50: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t23_n54;
  t23_n51: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t23_n53;
  t23_n52: return -0.010733982548117638f;
  t23_n53: return 0.056104764342308044f;
  t23_n54: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t23_n56;
  t23_n55: return 0.02162468060851097f;
  t23_n56: return 0.06922274827957153f;
  t23_n57: if (E.getFileProximityDistanceCost() >= 3254517760 /*31.5*/) goto t23_n73;
  t23_n58: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t23_n68;
  t23_n59: if (E.getContextKind() & (BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_UnionTag))) goto t23_n65;
  t23_n60: if (E.getFileProximityDistanceCost() >= 3242721280 /*12.5*/) goto t23_n62;
  t23_n61: return 0.004607690032571554f;
  t23_n62: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t23_n64;
  t23_n63: return 0.019056949764490128f;
  t23_n64: return 0.06292029470205307f;
  t23_n65: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t23_n67;
  t23_n66: return 0.08231966942548752f;
  t23_n67: return 0.02403952367603779f;
  t23_n68: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t23_n70;
  t23_n69: return 0.03724489361047745f;
  t23_n70: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t23_n72;
  t23_n71: return 0.0695817619562149f;
  t23_n72: return 0.022720307111740112f;
  t23_n73: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t23_n93;
  t23_n74: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t23_n86;
  t23_n75: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t23_n85;
  t23_n76: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t23_n82;
  t23_n77: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t23_n79;
  t23_n78: return -0.013753273524343967f;
  t23_n79: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t23_n81;
  t23_n80: return -0.08316756039857864f;
  t23_n81: return 0.008341067470610142f;
  t23_n82: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t23_n84;
  t23_n83: return 0.005011792294681072f;
  t23_n84: return 0.05805373936891556f;
  t23_n85: return 0.03126411512494087f;
  t23_n86: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Symbol))) goto t23_n90;
  t23_n87: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t23_n89;
  t23_n88: return 0.020519107580184937f;
  t23_n89: return -0.046285390853881836f;
  t23_n90: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t23_n92;
  t23_n91: return -0.006130884867161512f;
  t23_n92: return 0.05735174939036369f;
  t23_n93: return 0.020877689123153687f;
  t23_n94: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t23_n110;
  t23_n95: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t23_n97;
  t23_n96: return -0.03093758411705494f;
  t23_n97: if (E.getNumReferences() >= 3363896688 /*264171.5*/) goto t23_n103;
  t23_n98: if (E.getNumReferences() >= 3360215360 /*205637.0*/) goto t23_n102;
  t23_n99: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t23_n101;
  t23_n100: return 0.015854839235544205f;
  t23_n101: return 0.09744954109191895f;
  t23_n102: return -0.061177629977464676f;
  t23_n103: if (E.getNumReferences() >= 3364180016 /*273025.5*/) goto t23_n109;
  t23_n104: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t23_n106;
  t23_n105: return 0.04856429994106293f;
  t23_n106: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t23_n108;
  t23_n107: return 0.08128876239061356f;
  t23_n108: return 0.11204017698764801f;
  t23_n109: return 0.08293403685092926f;
  t23_n110: if (E.getNumReferences() >= 3360630592 /*212125.0*/) goto t23_n120;
  t23_n111: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t23_n119;
  t23_n112: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t23_n116;
  t23_n113: if (E.getSymbolScopeDistanceCost() >= 3221225472 /*2.0*/) goto t23_n115;
  t23_n114: return 0.08814340829849243f;
  t23_n115: return -0.13570636510849f;
  t23_n116: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t23_n118;
  t23_n117: return 0.08932498842477798f;
  t23_n118: return 0.13540054857730865f;
  t23_n119: return 0.13015133142471313f;
  t23_n120: if (E.getNumReferences() >= 3370747520 /*478260.0*/) goto t23_n130;
  t23_n121: if (E.getNumReferences() >= 3362537216 /*241916.0*/) goto t23_n127;
  t23_n122: if (E.getNumReferences() >= 3362180128 /*236336.5*/) goto t23_n124;
  t23_n123: return -0.0023750122636556625f;
  t23_n124: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel))) goto t23_n126;
  t23_n125: return 0.09164793789386749f;
  t23_n126: return 0.12941700220108032f;
  t23_n127: if (E.getNumReferences() >= 3364597360 /*286067.5*/) goto t23_n129;
  t23_n128: return -0.11321079730987549f;
  t23_n129: return 0.0616714246571064f;
  t23_n130: return 0.09983295947313309f;
  t23_n131: if (E.getNumReferences() >= 3320626176 /*7575.5*/) goto t23_n237;
  t23_n132: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t23_n182;
  t23_n133: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t23_n147;
  t23_n134: if (E.getNumReferences() >= 3245867008 /*15.5*/) goto t23_n144;
  t23_n135: if (E.getFractionNameInContext() >= 3197638680 /*0.2970588207244873*/) goto t23_n143;
  t23_n136: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t23_n142;
  t23_n137: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t23_n139;
  t23_n138: return 0.013387382961809635f;
  t23_n139: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t23_n141;
  t23_n140: return 0.04259112477302551f;
  t23_n141: return 0.10189071297645569f;
  t23_n142: return 0.05100608617067337f;
  t23_n143: return 0.04301051050424576f;
  t23_n144: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t23_n146;
  t23_n145: return 0.06714751571416855f;
  t23_n146: return 0.08277486264705658f;
  t23_n147: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t23_n151;
  t23_n148: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t23_n150;
  t23_n149: return -0.0476553700864315f;
  t23_n150: return 0.025023505091667175f;
  t23_n151: if (E.getFileProximityDistanceCost() >= 3255173120 /*33.5*/) goto t23_n179;
  t23_n152: if (E.getFractionNameInContext() >= 3196339268 /*0.25833332538604736*/) goto t23_n176;
  t23_n153: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t23_n159;
  t23_n154: if (E.getNumReferences() >= 3278405632 /*232.5*/) goto t23_n156;
  t23_n155: return -0.007588032633066177f;
  t23_n156: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t23_n158;
  t23_n157: return 0.07571226358413696f;
  t23_n158: return 0.02212350070476532f;
  t23_n159: if (E.getSymbolScopeDistanceCost() >= 3246915584 /*17.0*/) goto t23_n161;
  t23_n160: return -0.014698009006679058f;
  t23_n161: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t23_n169;
  t23_n162: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t23_n168;
  t23_n163: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t23_n167;
  t23_n164: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t23_n166;
  t23_n165: return 0.08841720223426819f;
  t23_n166: return -0.04706868529319763f;
  t23_n167: return -0.1415119767189026f;
  t23_n168: return -0.04361078888177872f;
  t23_n169: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t23_n175;
  t23_n170: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t23_n174;
  t23_n171: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t23_n173;
  t23_n172: return -0.0792955830693245f;
  t23_n173: return 0.10404191166162491f;
  t23_n174: return -0.039785128086805344f;
  t23_n175: return -0.13794420659542084f;
  t23_n176: if (E.getNumReferences() >= 3284254720 /*387.5*/) goto t23_n178;
  t23_n177: return 0.03454116731882095f;
  t23_n178: return 0.08126267790794373f;
  t23_n179: if (E.getFractionNameInContext() >= 3190975644 /*0.17424243688583374*/) goto t23_n181;
  t23_n180: return 0.03493443876504898f;
  t23_n181: return 0.06922168284654617f;
  t23_n182: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t23_n204;
  t23_n183: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t23_n199;
  t23_n184: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t23_n186;
  t23_n185: return -0.053795844316482544f;
  t23_n186: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t23_n194;
  t23_n187: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t23_n191;
  t23_n188: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t23_n190;
  t23_n189: return 0.002416216768324375f;
  t23_n190: return -0.09857532382011414f;
  t23_n191: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t23_n193;
  t23_n192: return 0.012297623790800571f;
  t23_n193: return -0.08739450573921204f;
  t23_n194: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t23_n198;
  t23_n195: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Statement))) goto t23_n197;
  t23_n196: return 0.0369831807911396f;
  t23_n197: return 0.06341297924518585f;
  t23_n198: return 0.017075568437576294f;
  t23_n199: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t23_n203;
  t23_n200: if (E.getNumReferences() >= 3315746816 /*5193.0*/) goto t23_n202;
  t23_n201: return 0.037340447306632996f;
  t23_n202: return 0.1310865432024002f;
  t23_n203: return 0.06586812436580658f;
  t23_n204: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t23_n230;
  t23_n205: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t23_n229;
  t23_n206: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t23_n226;
  t23_n207: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t23_n209;
  t23_n208: return -0.11006338149309158f;
  t23_n209: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t23_n217;
  t23_n210: if (E.getNumReferences() >= 3250847744 /*24.5*/) goto t23_n216;
  t23_n211: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t23_n215;
  t23_n212: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t23_n214;
  t23_n213: return -0.009917452931404114f;
  t23_n214: return 0.03406090661883354f;
  t23_n215: return 0.04354720190167427f;
  t23_n216: return 0.07571464776992798f;
  t23_n217: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t23_n221;
  t23_n218: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t23_n220;
  t23_n219: return 0.032060544937849045f;
  t23_n220: return 0.07570477575063705f;
  t23_n221: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t23_n225;
  t23_n222: if (E.getFileProximityDistanceCost() >= 3252420608 /*27.5*/) goto t23_n224;
  t23_n223: return 0.06619442254304886f;
  t23_n224: return -0.037024322897195816f;
  t23_n225: return 0.08888519555330276f;
  t23_n226: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol))) goto t23_n228;
  t23_n227: return 0.04848765581846237f;
  t23_n228: return 0.0696754977107048f;
  t23_n229: return 0.06619539111852646f;
  t23_n230: if (E.getScope() & (BIT(Scope_type::FunctionScope)|BIT(Scope_type::GlobalScope))) goto t23_n232;
  t23_n231: return -0.08138225227594376f;
  t23_n232: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t23_n234;
  t23_n233: return -0.08989682793617249f;
  t23_n234: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t23_n236;
  t23_n235: return 0.026207393035292625f;
  t23_n236: return 0.06650588661432266f;
  t23_n237: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t23_n251;
  t23_n238: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t23_n248;
  t23_n239: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t23_n243;
  t23_n240: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t23_n242;
  t23_n241: return 0.05002440884709358f;
  t23_n242: return 0.08616528660058975f;
  t23_n243: if (E.getNumReferences() >= 3348085888 /*73593.0*/) goto t23_n245;
  t23_n244: return 0.06938593834638596f;
  t23_n245: if (E.getNumReferences() >= 3349544768 /*84990.5*/) goto t23_n247;
  t23_n246: return 0.11141793429851532f;
  t23_n247: return 0.0896790474653244f;
  t23_n248: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t23_n250;
  t23_n249: return 0.007308934349566698f;
  t23_n250: return 0.08896294236183167f;
  t23_n251: return 0.09479282051324844f;
  t23_n252: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t23_n254;
  t23_n253: return 0.08007028698921204f;
  t23_n254: return 0.09135644137859344f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree24(const Example& E) {
  t24_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t24_n250;
  t24_n1: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t24_n131;
  t24_n2: if (E.getNumReferences() >= 3347793152 /*71306.0*/) goto t24_n110;
  t24_n3: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t24_n63;
  t24_n4: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t24_n34;
  t24_n5: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t24_n25;
  t24_n6: if (E.getContextKind() & (BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t24_n16;
  t24_n7: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t24_n15;
  t24_n8: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t24_n14;
  t24_n9: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t24_n11;
  t24_n10: return -0.1274133175611496f;
  t24_n11: if (E.getNumReferences() >= 3308015616 /*2757.0*/) goto t24_n13;
  t24_n12: return -0.05180923268198967f;
  t24_n13: return 0.01934683695435524f;
  t24_n14: return 0.0025255673099309206f;
  t24_n15: return -0.07652298361063004f;
  t24_n16: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t24_n18;
  t24_n17: return -0.10098420083522797f;
  t24_n18: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t24_n20;
  t24_n19: return 0.004954515025019646f;
  t24_n20: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t24_n24;
  t24_n21: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t24_n23;
  t24_n22: return 0.0007864386425353587f;
  t24_n23: return 0.048143502324819565f;
  t24_n24: return 0.059236474335193634f;
  t24_n25: if (E.getNumReferences() >= 3317853184 /*6221.5*/) goto t24_n29;
  t24_n26: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t24_n28;
  t24_n27: return 0.017048699781298637f;
  t24_n28: return 0.06257680058479309f;
  t24_n29: if (E.getNumReferences() >= 3318227968 /*6404.5*/) goto t24_n31;
  t24_n30: return 0.13223616778850555f;
  t24_n31: if (E.getNumReferences() >= 3343006592 /*49723.5*/) goto t24_n33;
  t24_n32: return 0.08089102059602737f;
  t24_n33: return -0.13882485032081604f;
  t24_n34: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t24_n46;
  t24_n35: if (E.getNumReferences() >= 3259105280 /*48.5*/) goto t24_n43;
  t24_n36: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t24_n42;
  t24_n37: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t24_n41;
  t24_n38: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t24_n40;
  t24_n39: return -0.00470251077786088f;
  t24_n40: return -0.05716763809323311f;
  t24_n41: return 0.0093355318531394f;
  t24_n42: return -0.11906106770038605f;
  t24_n43: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t24_n45;
  t24_n44: return 0.03959982097148895f;
  t24_n45: return -0.01148206740617752f;
  t24_n46: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t24_n54;
  t24_n47: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t24_n49;
  t24_n48: return 0.027624404057860374f;
  t24_n49: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t24_n51;
  t24_n50: return 0.04586068168282509f;
  t24_n51: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t24_n53;
  t24_n52: return 0.09117156267166138f;
  t24_n53: return -0.17214460670948029f;
  t24_n54: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t24_n62;
  t24_n55: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t24_n61;
  t24_n56: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t24_n60;
  t24_n57: if (E.getNumReferences() >= 3270574080 /*120.5*/) goto t24_n59;
  t24_n58: return 0.015615345910191536f;
  t24_n59: return 0.06180159002542496f;
  t24_n60: return 0.029589621350169182f;
  t24_n61: return 0.09589429199695587f;
  t24_n62: return -0.10800918191671371f;
  t24_n63: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t24_n105;
  t24_n64: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace))) goto t24_n92;
  t24_n65: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t24_n89;
  t24_n66: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t24_n88;
  t24_n67: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t24_n87;
  t24_n68: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t24_n78;
  t24_n69: if (E.getNumReferences() >= 3295354880 /*940.5*/) goto t24_n77;
  t24_n70: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t24_n74;
  t24_n71: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t24_n73;
  t24_n72: return -0.024015512317419052f;
  t24_n73: return -0.07375454157590866f;
  t24_n74: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t24_n76;
  t24_n75: return -0.004346480593085289f;
  t24_n76: return -0.08970794081687927f;
  t24_n77: return 0.005134996492415667f;
  t24_n78: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t24_n80;
  t24_n79: return 0.0011257156729698181f;
  t24_n80: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t24_n82;
  t24_n81: return -0.04201535880565643f;
  t24_n82: if (E.getNumReferences() >= 3316109312 /*5370.0*/) goto t24_n86;
  t24_n83: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t24_n85;
  t24_n84: return 0.07281772792339325f;
  t24_n85: return 0.023397235199809074f;
  t24_n86: return -0.012499156408011913f;
  t24_n87: return -0.08928748965263367f;
  t24_n88: return -0.081760473549366f;
  t24_n89: if (E.getSymbolScopeDistanceCost() >= 3246915584 /*17.0*/) goto t24_n91;
  t24_n90: return -0.04138358682394028f;
  t24_n91: return 0.025786008685827255f;
  t24_n92: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t24_n98;
  t24_n93: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t24_n97;
  t24_n94: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t24_n96;
  t24_n95: return 0.07791799306869507f;
  t24_n96: return -0.03218597173690796f;
  t24_n97: return 0.046262115240097046f;
  t24_n98: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t24_n104;
  t24_n99: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t24_n103;
  t24_n100: if (E.getFileProximityDistanceCost() >= 3247177728 /*17.5*/) goto t24_n102;
  t24_n101: return 0.0905221700668335f;
  t24_n102: return 0.10901685059070587f;
  t24_n103: return 0.04626083746552467f;
  t24_n104: return 0.04501616954803467f;
  t24_n105: if (E.getFileProximityDistanceCost() >= 3236954112 /*7.5*/) goto t24_n109;
  t24_n106: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t24_n108;
  t24_n107: return -0.05682460218667984f;
  t24_n108: return 0.06129080057144165f;
  t24_n109: return 0.05544688180088997f;
  t24_n110: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t24_n116;
  t24_n111: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t24_n115;
  t24_n112: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t24_n114;
  t24_n113: return -0.003137121209874749f;
  t24_n114: return 0.08331993967294693f;
  t24_n115: return 0.08110979944467545f;
  t24_n116: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t24_n122;
  t24_n117: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t24_n121;
  t24_n118: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t24_n120;
  t24_n119: return 0.029967542737722397f;
  t24_n120: return -0.15728268027305603f;
  t24_n121: return 0.09351178258657455f;
  t24_n122: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t24_n130;
  t24_n123: if (E.getNumReferences() >= 3362537216 /*241916.0*/) goto t24_n127;
  t24_n124: if (E.getNumReferences() >= 3359752544 /*198405.5*/) goto t24_n126;
  t24_n125: return 0.08111914992332458f;
  t24_n126: return 0.10496819019317627f;
  t24_n127: if (E.getNumReferences() >= 3364597360 /*286067.5*/) goto t24_n129;
  t24_n128: return -0.10193636268377304f;
  t24_n129: return 0.08945541083812714f;
  t24_n130: return -0.015474632382392883f;
  t24_n131: if (E.getNumReferences() >= 3320626176 /*7575.5*/) goto t24_n239;
  t24_n132: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t24_n188;
  t24_n133: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t24_n179;
  t24_n134: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t24_n144;
  t24_n135: if (E.getNumReferences() >= 3241672704 /*11.5*/) goto t24_n141;
  t24_n136: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t24_n140;
  t24_n137: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t24_n139;
  t24_n138: return 0.013157844543457031f;
  t24_n139: return 0.0485570915043354f;
  t24_n140: return 0.04729313403367996f;
  t24_n141: if (E.getNumReferences() >= 3264151552 /*71.5*/) goto t24_n143;
  t24_n142: return 0.05778088793158531f;
  t24_n143: return 0.08511848002672195f;
  t24_n144: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t24_n170;
  t24_n145: if (E.getNumReferences() >= 3278405632 /*232.5*/) goto t24_n165;
  t24_n146: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t24_n160;
  t24_n147: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t24_n151;
  t24_n148: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t24_n150;
  t24_n149: return -0.04667884483933449f;
  t24_n150: return 0.024628279730677605f;
  t24_n151: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t24_n153;
  t24_n152: return 0.003667350159958005f;
  t24_n153: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t24_n155;
  t24_n154: return 0.03153389319777489f;
  t24_n155: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t24_n159;
  t24_n156: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t24_n158;
  t24_n157: return -0.009438318200409412f;
  t24_n158: return 0.09772106260061264f;
  t24_n159: return -0.04428441822528839f;
  t24_n160: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t24_n162;
  t24_n161: return -0.09723427146673203f;
  t24_n162: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t24_n164;
  t24_n163: return 0.042777229100465775f;
  t24_n164: return -0.052950672805309296f;
  t24_n165: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t24_n169;
  t24_n166: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t24_n168;
  t24_n167: return 0.0285759549587965f;
  t24_n168: return 0.06794261187314987f;
  t24_n169: return 0.020437201485037804f;
  t24_n170: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t24_n176;
  t24_n171: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t24_n173;
  t24_n172: return -0.01924499124288559f;
  t24_n173: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t24_n175;
  t24_n174: return 0.0462612584233284f;
  t24_n175: return 0.010783005505800247f;
  t24_n176: if (E.getContextKind() & (BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t24_n178;
  t24_n177: return 0.03550266847014427f;
  t24_n178: return 0.06686954945325851f;
  t24_n179: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t24_n185;
  t24_n180: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t24_n184;
  t24_n181: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t24_n183;
  t24_n182: return 0.03280389681458473f;
  t24_n183: return 0.07271486520767212f;
  t24_n184: return 0.06921873986721039f;
  t24_n185: if (E.getNumNameInContext() >= 3230662656 /*4.5*/) goto t24_n187;
  t24_n186: return 0.06994906067848206f;
  t24_n187: return 0.1162165030837059f;
  t24_n188: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t24_n204;
  t24_n189: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t24_n201;
  t24_n190: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t24_n192;
  t24_n191: return -0.03598126024007797f;
  t24_n192: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t24_n194;
  t24_n193: return -0.039104361087083817f;
  t24_n194: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t24_n198;
  t24_n195: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t24_n197;
  t24_n196: return 0.004919133614748716f;
  t24_n197: return 0.022040395066142082f;
  t24_n198: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t24_n200;
  t24_n199: return 0.056548845022916794f;
  t24_n200: return 0.020556598901748657f;
  t24_n201: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t24_n203;
  t24_n202: return 0.03681119903922081f;
  t24_n203: return 0.06319963186979294f;
  t24_n204: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t24_n236;
  t24_n205: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t24_n235;
  t24_n206: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t24_n230;
  t24_n207: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t24_n209;
  t24_n208: return -0.10918457806110382f;
  t24_n209: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t24_n221;
  t24_n210: if (E.getNumReferences() >= 3245867008 /*15.5*/) goto t24_n220;
  t24_n211: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t24_n219;
  t24_n212: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t24_n218;
  t24_n213: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t24_n217;
  t24_n214: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t24_n216;
  t24_n215: return 0.033598076552152634f;
  t24_n216: return -0.0018233559094369411f;
  t24_n217: return 0.05820286646485329f;
  t24_n218: return 0.04204033687710762f;
  t24_n219: return 0.053393542766571045f;
  t24_n220: return 0.06960007548332214f;
  t24_n221: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t24_n225;
  t24_n222: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t24_n224;
  t24_n223: return 0.02886701561510563f;
  t24_n224: return 0.07283500581979752f;
  t24_n225: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t24_n229;
  t24_n226: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t24_n228;
  t24_n227: return 0.06463898718357086f;
  t24_n228: return -0.044710878282785416f;
  t24_n229: return 0.08710283786058426f;
  t24_n230: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol))) goto t24_n234;
  t24_n231: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t24_n233;
  t24_n232: return 0.04861126467585564f;
  t24_n233: return 0.09342345595359802f;
  t24_n234: return 0.08036766201257706f;
  t24_n235: return 0.06343098729848862f;
  t24_n236: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t24_n238;
  t24_n237: return 0.0027830321341753006f;
  t24_n238: return 0.07563214004039764f;
  t24_n239: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t24_n243;
  t24_n240: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t24_n242;
  t24_n241: return 0.046058539301157f;
  t24_n242: return 0.09019778668880463f;
  t24_n243: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type))) goto t24_n249;
  t24_n244: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t24_n248;
  t24_n245: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t24_n247;
  t24_n246: return -0.17707450687885284f;
  t24_n247: return 0.06652458757162094f;
  t24_n248: return 0.09310548007488251f;
  t24_n249: return 0.09284372627735138f;
  t24_n250: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t24_n254;
  t24_n251: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t24_n253;
  t24_n252: return 0.07291499525308609f;
  t24_n253: return 0.08627073466777802f;
  t24_n254: return 0.10067874938249588f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree25(const Example& E) {
  t25_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t25_n252;
  t25_n1: if (E.getFractionNameInContext() >= 3187806340 /*0.1270161271095276*/) goto t25_n177;
  t25_n2: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t25_n176;
  t25_n3: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t25_n89;
  t25_n4: if (E.getNumReferences() >= 3289473024 /*581.5*/) goto t25_n62;
  t25_n5: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t25_n19;
  t25_n6: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t25_n16;
  t25_n7: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t25_n13;
  t25_n8: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t25_n12;
  t25_n9: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t25_n11;
  t25_n10: return -0.04457830637693405f;
  t25_n11: return 0.015509710647165775f;
  t25_n12: return -0.02502615936100483f;
  t25_n13: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t25_n15;
  t25_n14: return 0.032302066683769226f;
  t25_n15: return 0.08106954395771027f;
  t25_n16: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t25_n18;
  t25_n17: return 0.030924739316105843f;
  t25_n18: return 0.07979777455329895f;
  t25_n19: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t25_n57;
  t25_n20: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t25_n28;
  t25_n21: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t25_n23;
  t25_n22: return -0.07472296804189682f;
  t25_n23: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t25_n25;
  t25_n24: return -0.02660578489303589f;
  t25_n25: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t25_n27;
  t25_n26: return -0.08614985644817352f;
  t25_n27: return 0.039446283131837845f;
  t25_n28: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t25_n30;
  t25_n29: return -0.02687297761440277f;
  t25_n30: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t25_n40;
  t25_n31: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t25_n33;
  t25_n32: return -0.03862855210900307f;
  t25_n33: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t25_n37;
  t25_n34: if (E.getFileProximityDistanceCost() >= 3244818432 /*14.5*/) goto t25_n36;
  t25_n35: return -0.007625964470207691f;
  t25_n36: return -0.13782262802124023f;
  t25_n37: if (E.getFileProximityDistanceCost() >= 3244818432 /*14.5*/) goto t25_n39;
  t25_n38: return 0.009463856928050518f;
  t25_n39: return 0.046005502343177795f;
  t25_n40: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t25_n56;
  t25_n41: if (E.getFractionNameInContext() >= 3166899249 /*0.02380952425301075*/) goto t25_n55;
  t25_n42: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t25_n48;
  t25_n43: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t25_n47;
  t25_n44: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t25_n46;
  t25_n45: return -0.012954932637512684f;
  t25_n46: return 0.036466922610998154f;
  t25_n47: return -0.02071189135313034f;
  t25_n48: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t25_n50;
  t25_n49: return 0.009433649480342865f;
  t25_n50: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t25_n52;
  t25_n51: return 0.03299416974186897f;
  t25_n52: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t25_n54;
  t25_n53: return -0.08199266344308853f;
  t25_n54: return 0.0617600753903389f;
  t25_n55: return 0.0356283038854599f;
  t25_n56: return -0.1068122461438179f;
  t25_n57: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t25_n59;
  t25_n58: return -0.10662547498941422f;
  t25_n59: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t25_n61;
  t25_n60: return 0.007835101336240768f;
  t25_n61: return -0.08111248910427094f;
  t25_n62: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t25_n86;
  t25_n63: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t25_n83;
  t25_n64: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t25_n72;
  t25_n65: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t25_n69;
  t25_n66: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t25_n68;
  t25_n67: return -0.0563492551445961f;
  t25_n68: return 0.01070721261203289f;
  t25_n69: if (E.getNumReferences() >= 3338664448 /*32765.0*/) goto t25_n71;
  t25_n70: return -0.0013012569397687912f;
  t25_n71: return 0.06899567693471909f;
  t25_n72: if (E.getNumReferences() >= 3347793152 /*71306.0*/) goto t25_n74;
  t25_n73: return 0.026508890092372894f;
  t25_n74: if (E.getNumReferences() >= 3362537216 /*241916.0*/) goto t25_n82;
  t25_n75: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel))) goto t25_n77;
  t25_n76: return 0.05875775218009949f;
  t25_n77: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t25_n79;
  t25_n78: return -0.13516467809677124f;
  t25_n79: if (E.getNumReferences() >= 3359032704 /*187158.0*/) goto t25_n81;
  t25_n80: return 0.08303230255842209f;
  t25_n81: return 0.11304394900798798f;
  t25_n82: return -0.008844533003866673f;
  t25_n83: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t25_n85;
  t25_n84: return -0.13421818614006042f;
  t25_n85: return -0.00757240317761898f;
  t25_n86: if (E.getNumReferences() >= 3348712704 /*78490.0*/) goto t25_n88;
  t25_n87: return 0.03936528414487839f;
  t25_n88: return 0.09682779014110565f;
  t25_n89: if (E.getFileProximityDistanceCost() >= 3255173120 /*33.5*/) goto t25_n115;
  t25_n90: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t25_n106;
  t25_n91: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t25_n101;
  t25_n92: if (E.getContextKind() & (BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_UnionTag))) goto t25_n94;
  t25_n93: return 0.022219710052013397f;
  t25_n94: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t25_n98;
  t25_n95: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t25_n97;
  t25_n96: return 0.08101535588502884f;
  t25_n97: return -0.07509507983922958f;
  t25_n98: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t25_n100;
  t25_n99: return 0.028504744172096252f;
  t25_n100: return 0.0735241025686264f;
  t25_n101: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t25_n103;
  t25_n102: return -0.012877598404884338f;
  t25_n103: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t25_n105;
  t25_n104: return 0.01358069572597742f;
  t25_n105: return 0.07777697592973709f;
  t25_n106: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t25_n110;
  t25_n107: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t25_n109;
  t25_n108: return 0.0030367558356374502f;
  t25_n109: return 0.049544937908649445f;
  t25_n110: if (E.getNumReferences() >= 3332434432 /*20597.0*/) goto t25_n114;
  t25_n111: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t25_n113;
  t25_n112: return -0.011487503536045551f;
  t25_n113: return 0.06489517539739609f;
  t25_n114: return 0.08147579431533813f;
  t25_n115: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t25_n143;
  t25_n116: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t25_n138;
  t25_n117: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t25_n133;
  t25_n118: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t25_n120;
  t25_n119: return -0.09524787962436676f;
  t25_n120: if (E.getSymbolScopeDistanceCost() >= 3221225472 /*2.0*/) goto t25_n130;
  t25_n121: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t25_n129;
  t25_n122: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t25_n128;
  t25_n123: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t25_n125;
  t25_n124: return 0.009905827231705189f;
  t25_n125: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t25_n127;
  t25_n126: return 0.04435458406805992f;
  t25_n127: return 0.11598225682973862f;
  t25_n128: return -0.010364354588091373f;
  t25_n129: return -0.16902890801429749f;
  t25_n130: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t25_n132;
  t25_n131: return 0.018392672762274742f;
  t25_n132: return -0.08850383758544922f;
  t25_n133: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t25_n135;
  t25_n134: return -0.0753120556473732f;
  t25_n135: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t25_n137;
  t25_n136: return -0.07598181068897247f;
  t25_n137: return 0.03217291086912155f;
  t25_n138: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t25_n140;
  t25_n139: return 0.02620515413582325f;
  t25_n140: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t25_n142;
  t25_n141: return -0.049851033836603165f;
  t25_n142: return 0.057847291231155396f;
  t25_n143: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t25_n157;
  t25_n144: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t25_n154;
  t25_n145: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown))) goto t25_n151;
  t25_n146: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t25_n148;
  t25_n147: return -0.03554097190499306f;
  t25_n148: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t25_n150;
  t25_n149: return 0.028965743258595467f;
  t25_n150: return -0.031674522906541824f;
  t25_n151: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t25_n153;
  t25_n152: return 0.01435299776494503f;
  t25_n153: return 0.09575559198856354f;
  t25_n154: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t25_n156;
  t25_n155: return -0.013857407495379448f;
  t25_n156: return 0.055724211037158966f;
  t25_n157: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t25_n165;
  t25_n158: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t25_n162;
  t25_n159: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t25_n161;
  t25_n160: return -0.023274598643183708f;
  t25_n161: return 0.040045369416475296f;
  t25_n162: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t25_n164;
  t25_n163: return 0.09303568303585052f;
  t25_n164: return -0.09786032140254974f;
  t25_n165: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t25_n173;
  t25_n166: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t25_n172;
  t25_n167: if (E.getContextKind() & (BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_UnionTag))) goto t25_n169;
  t25_n168: return 0.02850550413131714f;
  t25_n169: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t25_n171;
  t25_n170: return 0.06606845557689667f;
  t25_n171: return -0.0035564282443374395f;
  t25_n172: return -0.19050925970077515f;
  t25_n173: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t25_n175;
  t25_n174: return 0.08227699995040894f;
  t25_n175: return 0.0056931376457214355f;
  t25_n176: return 0.08774168789386749f;
  t25_n177: if (E.getNumReferences() >= 3303129088 /*1806.0*/) goto t25_n247;
  t25_n178: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t25_n236;
  t25_n179: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t25_n225;
  t25_n180: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t25_n182;
  t25_n181: return -0.08098731189966202f;
  t25_n182: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t25_n208;
  t25_n183: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t25_n205;
  t25_n184: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t25_n188;
  t25_n185: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t25_n187;
  t25_n186: return 0.03340846300125122f;
  t25_n187: return 0.06654965877532959f;
  t25_n188: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t25_n196;
  t25_n189: if (E.getNumReferences() >= 3255435264 /*34.5*/) goto t25_n195;
  t25_n190: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t25_n194;
  t25_n191: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t25_n193;
  t25_n192: return 0.010025756433606148f;
  t25_n193: return 0.05797497555613518f;
  t25_n194: return 0.056078147143125534f;
  t25_n195: return 0.06761649250984192f;
  t25_n196: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t25_n200;
  t25_n197: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t25_n199;
  t25_n198: return -0.00725484499707818f;
  t25_n199: return 0.04099170118570328f;
  t25_n200: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t25_n204;
  t25_n201: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t25_n203;
  t25_n202: return 0.036195915192365646f;
  t25_n203: return 0.07510485500097275f;
  t25_n204: return -0.08625160157680511f;
  t25_n205: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t25_n207;
  t25_n206: return 0.040482331067323685f;
  t25_n207: return 0.06984925270080566f;
  t25_n208: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t25_n218;
  t25_n209: if (E.getNumReferences() >= 3255173120 /*33.5*/) goto t25_n215;
  t25_n210: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t25_n214;
  t25_n211: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t25_n213;
  t25_n212: return 0.021809836849570274f;
  t25_n213: return 0.07975336909294128f;
  t25_n214: return 0.035743337124586105f;
  t25_n215: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t25_n217;
  t25_n216: return 0.057269856333732605f;
  t25_n217: return 0.0789833813905716f;
  t25_n218: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t25_n224;
  t25_n219: if (E.getSymbolScopeDistanceCost() >= 3241148416 /*11.0*/) goto t25_n223;
  t25_n220: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t25_n222;
  t25_n221: return 0.04949215054512024f;
  t25_n222: return 0.07354723662137985f;
  t25_n223: return 0.043819598853588104f;
  t25_n224: return -0.0666096955537796f;
  t25_n225: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t25_n227;
  t25_n226: return -0.04329584911465645f;
  t25_n227: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t25_n233;
  t25_n228: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t25_n232;
  t25_n229: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t25_n231;
  t25_n230: return 0.033339258283376694f;
  t25_n231: return -0.05207139253616333f;
  t25_n232: return 0.04983522742986679f;
  t25_n233: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t25_n235;
  t25_n234: return 0.020032761618494987f;
  t25_n235: return -0.02814585715532303f;
  t25_n236: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t25_n242;
  t25_n237: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t25_n241;
  t25_n238: if (E.getNumReferences() >= 3241672704 /*11.5*/) goto t25_n240;
  t25_n239: return 0.045474469661712646f;
  t25_n240: return 0.09455171227455139f;
  t25_n241: return 0.009529179893434048f;
  t25_n242: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Symbol))) goto t25_n244;
  t25_n243: return 0.051557548344135284f;
  t25_n244: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t25_n246;
  t25_n245: return 0.05412360653281212f;
  t25_n246: return 0.09424003213644028f;
  t25_n247: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t25_n249;
  t25_n248: return 0.03760486841201782f;
  t25_n249: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t25_n251;
  t25_n250: return 0.06425967067480087f;
  t25_n251: return 0.08851215988397598f;
  t25_n252: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t25_n254;
  t25_n253: return 0.075346939265728f;
  t25_n254: return 0.08789907395839691f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree26(const Example& E) {
  t26_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t26_n250;
  t26_n1: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t26_n119;
  t26_n2: if (E.getNumReferences() >= 3359104096 /*188273.5*/) goto t26_n90;
  t26_n3: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t26_n51;
  t26_n4: if (E.getNumReferences() >= 3259367424 /*49.5*/) goto t26_n46;
  t26_n5: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t26_n19;
  t26_n6: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t26_n18;
  t26_n7: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type))) goto t26_n9;
  t26_n8: return -0.056688521057367325f;
  t26_n9: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t26_n17;
  t26_n10: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t26_n12;
  t26_n11: return -0.023729657754302025f;
  t26_n12: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t26_n16;
  t26_n13: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t26_n15;
  t26_n14: return 0.006781045347452164f;
  t26_n15: return -0.09365928918123245f;
  t26_n16: return -0.16892889142036438f;
  t26_n17: return -0.06345485895872116f;
  t26_n18: return 0.07908763736486435f;
  t26_n19: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t26_n21;
  t26_n20: return -0.09939649701118469f;
  t26_n21: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t26_n41;
  t26_n22: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t26_n40;
  t26_n23: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t26_n37;
  t26_n24: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t26_n30;
  t26_n25: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t26_n27;
  t26_n26: return 0.01960531249642372f;
  t26_n27: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t26_n29;
  t26_n28: return 0.021737249568104744f;
  t26_n29: return 0.08705512434244156f;
  t26_n30: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t26_n32;
  t26_n31: return -0.005929052364081144f;
  t26_n32: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t26_n36;
  t26_n33: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t26_n35;
  t26_n34: return 0.025309709832072258f;
  t26_n35: return 0.057003047317266464f;
  t26_n36: return -0.04394466429948807f;
  t26_n37: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel))) goto t26_n39;
  t26_n38: return 0.01698054000735283f;
  t26_n39: return 0.030693987384438515f;
  t26_n40: return -0.1082284152507782f;
  t26_n41: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t26_n45;
  t26_n42: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t26_n44;
  t26_n43: return 0.009102663956582546f;
  t26_n44: return 0.05209973081946373f;
  t26_n45: return 0.052531417459249496f;
  t26_n46: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t26_n50;
  t26_n47: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t26_n49;
  t26_n48: return 0.020128609612584114f;
  t26_n49: return 0.05985894054174423f;
  t26_n50: return 0.05462200567126274f;
  t26_n51: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t26_n85;
  t26_n52: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace))) goto t26_n70;
  t26_n53: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t26_n67;
  t26_n54: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t26_n60;
  t26_n55: if (E.getNumReferences() >= 3338715264 /*32960.5*/) goto t26_n57;
  t26_n56: return -0.02547462098300457f;
  t26_n57: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t26_n59;
  t26_n58: return 0.009552362374961376f;
  t26_n59: return 0.04664462432265282f;
  t26_n60: if (E.getNumReferences() >= 3355522464 /*132310.5*/) goto t26_n66;
  t26_n61: if (E.getNumReferences() >= 3354001600 /*119809.5*/) goto t26_n63;
  t26_n62: return -0.0770590528845787f;
  t26_n63: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t26_n65;
  t26_n64: return 0.12277239561080933f;
  t26_n65: return -0.10059624165296555f;
  t26_n66: return -0.15363211929798126f;
  t26_n67: if (E.getSymbolScopeDistanceCost() >= 3246915584 /*17.0*/) goto t26_n69;
  t26_n68: return -0.03874290734529495f;
  t26_n69: return 0.02340787649154663f;
  t26_n70: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t26_n78;
  t26_n71: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t26_n77;
  t26_n72: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t26_n74;
  t26_n73: return 0.036649495363235474f;
  t26_n74: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t26_n76;
  t26_n75: return -0.07359009236097336f;
  t26_n76: return -0.0145797124132514f;
  t26_n77: return 0.040203243494033813f;
  t26_n78: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t26_n84;
  t26_n79: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t26_n83;
  t26_n80: if (E.getFileProximityDistanceCost() >= 3247177728 /*17.5*/) goto t26_n82;
  t26_n81: return 0.08636943995952606f;
  t26_n82: return 0.10637534409761429f;
  t26_n83: return 0.04249753803014755f;
  t26_n84: return 0.04685540124773979f;
  t26_n85: if (E.getFileProximityDistanceCost() >= 3236954112 /*7.5*/) goto t26_n87;
  t26_n86: return -0.024783611297607422f;
  t26_n87: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t26_n89;
  t26_n88: return 0.05497560650110245f;
  t26_n89: return -0.1648312211036682f;
  t26_n90: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t26_n106;
  t26_n91: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t26_n93;
  t26_n92: return -0.031708575785160065f;
  t26_n93: if (E.getNumReferences() >= 3363896688 /*264171.5*/) goto t26_n99;
  t26_n94: if (E.getNumReferences() >= 3360215360 /*205637.0*/) goto t26_n98;
  t26_n95: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t26_n97;
  t26_n96: return 0.005990504752844572f;
  t26_n97: return 0.094392329454422f;
  t26_n98: return -0.0650925412774086f;
  t26_n99: if (E.getNumReferences() >= 3364180016 /*273025.5*/) goto t26_n105;
  t26_n100: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t26_n102;
  t26_n101: return 0.04257171228528023f;
  t26_n102: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t26_n104;
  t26_n103: return 0.004607091192156076f;
  t26_n104: return 0.1096184253692627f;
  t26_n105: return 0.07584714144468307f;
  t26_n106: if (E.getNumReferences() >= 3360334912 /*207505.0*/) goto t26_n116;
  t26_n107: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t26_n115;
  t26_n108: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t26_n112;
  t26_n109: if (E.getSymbolScopeDistanceCost() >= 3221225472 /*2.0*/) goto t26_n111;
  t26_n110: return 0.08579452335834503f;
  t26_n111: return -0.11999232321977615f;
  t26_n112: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel))) goto t26_n114;
  t26_n113: return 0.08615061640739441f;
  t26_n114: return 0.1256972849369049f;
  t26_n115: return 0.12398365885019302f;
  t26_n116: if (E.getNumReferences() >= 3376956888 /*820317.5*/) goto t26_n118;
  t26_n117: return 0.05438857153058052f;
  t26_n118: return 0.09871447831392288f;
  t26_n119: if (E.getNumReferences() >= 3320626176 /*7575.5*/) goto t26_n241;
  t26_n120: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t26_n182;
  t26_n121: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t26_n177;
  t26_n122: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t26_n172;
  t26_n123: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t26_n143;
  t26_n124: if (E.getNumReferences() >= 3240624128 /*10.5*/) goto t26_n136;
  t26_n125: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t26_n127;
  t26_n126: return 0.005012127570807934f;
  t26_n127: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t26_n129;
  t26_n128: return -0.1055876836180687f;
  t26_n129: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t26_n135;
  t26_n130: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type))) goto t26_n134;
  t26_n131: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t26_n133;
  t26_n132: return -0.015522364526987076f;
  t26_n133: return 0.08618791401386261f;
  t26_n134: return 0.03929045423865318f;
  t26_n135: return 0.05641775205731392f;
  t26_n136: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t26_n142;
  t26_n137: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t26_n139;
  t26_n138: return 0.023860899731516838f;
  t26_n139: if (E.getNumReferences() >= 3258843136 /*47.5*/) goto t26_n141;
  t26_n140: return 0.03104669786989689f;
  t26_n141: return 0.062197159975767136f;
  t26_n142: return 0.07944057136774063f;
  t26_n143: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t26_n147;
  t26_n144: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t26_n146;
  t26_n145: return -0.05640244483947754f;
  t26_n146: return -0.03367221727967262f;
  t26_n147: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t26_n169;
  t26_n148: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t26_n166;
  t26_n149: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t26_n153;
  t26_n150: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t26_n152;
  t26_n151: return 0.039818186312913895f;
  t26_n152: return -0.009758470579981804f;
  t26_n153: if (E.getSymbolScopeDistanceCost() >= 3246915584 /*17.0*/) goto t26_n155;
  t26_n154: return -0.015806525945663452f;
  t26_n155: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t26_n165;
  t26_n156: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t26_n164;
  t26_n157: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t26_n163;
  t26_n158: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t26_n160;
  t26_n159: return -0.045858778059482574f;
  t26_n160: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t26_n162;
  t26_n161: return 0.10030711442232132f;
  t26_n162: return 0.09123774617910385f;
  t26_n163: return -0.0469030886888504f;
  t26_n164: return -0.13580265641212463f;
  t26_n165: return -0.052153367549180984f;
  t26_n166: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t26_n168;
  t26_n167: return -0.5574522614479065f;
  t26_n168: return 0.06758418679237366f;
  t26_n169: if (E.getContextKind() & (BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t26_n171;
  t26_n170: return -0.013119873590767384f;
  t26_n171: return 0.07168685644865036f;
  t26_n172: if (E.getNumReferences() >= 3318137856 /*6360.5*/) goto t26_n176;
  t26_n173: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t26_n175;
  t26_n174: return 0.024543261155486107f;
  t26_n175: return 0.03901701793074608f;
  t26_n176: return 0.1193774864077568f;
  t26_n177: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t26_n181;
  t26_n178: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t26_n180;
  t26_n179: return 0.01607251539826393f;
  t26_n180: return 0.0669250413775444f;
  t26_n181: return 0.06157805025577545f;
  t26_n182: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t26_n184;
  t26_n183: return -0.04662651568651199f;
  t26_n184: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t26_n208;
  t26_n185: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t26_n203;
  t26_n186: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t26_n200;
  t26_n187: if (E.getNumReferences() >= 3259367424 /*49.5*/) goto t26_n197;
  t26_n188: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t26_n194;
  t26_n189: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t26_n193;
  t26_n190: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t26_n192;
  t26_n191: return 0.031680621206760406f;
  t26_n192: return -0.008399727754294872f;
  t26_n193: return 0.049269162118434906f;
  t26_n194: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t26_n196;
  t26_n195: return 0.017658470198512077f;
  t26_n196: return -0.0341850109398365f;
  t26_n197: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t26_n199;
  t26_n198: return 0.08074765652418137f;
  t26_n199: return 0.05413491651415825f;
  t26_n200: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t26_n202;
  t26_n201: return 0.05590153858065605f;
  t26_n202: return 0.08988682925701141f;
  t26_n203: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel))) goto t26_n205;
  t26_n204: return -0.03723074495792389f;
  t26_n205: if (E.getFractionNameInContext() >= 3194920923 /*0.23303167521953583*/) goto t26_n207;
  t26_n206: return 0.03928451985120773f;
  t26_n207: return 0.06419087201356888f;
  t26_n208: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t26_n240;
  t26_n209: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t26_n235;
  t26_n210: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t26_n232;
  t26_n211: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t26_n221;
  t26_n212: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t26_n218;
  t26_n213: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t26_n217;
  t26_n214: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t26_n216;
  t26_n215: return -0.016564732417464256f;
  t26_n216: return 0.031144898384809494f;
  t26_n217: return 0.04685072973370552f;
  t26_n218: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t26_n220;
  t26_n219: return 0.03022221103310585f;
  t26_n220: return 0.06411162763834f;
  t26_n221: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t26_n231;
  t26_n222: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t26_n226;
  t26_n223: if (E.getFileProximityDistanceCost() >= 3252944896 /*28.5*/) goto t26_n225;
  t26_n224: return 0.048363812267780304f;
  t26_n225: return -0.035306110978126526f;
  t26_n226: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t26_n228;
  t26_n227: return 0.04887983575463295f;
  t26_n228: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t26_n230;
  t26_n229: return 0.07032612711191177f;
  t26_n230: return 0.10641731321811676f;
  t26_n231: return -0.062209319323301315f;
  t26_n232: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t26_n234;
  t26_n233: return 0.041038207709789276f;
  t26_n234: return 0.08414869010448456f;
  t26_n235: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t26_n237;
  t26_n236: return -0.09231913834810257f;
  t26_n237: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t26_n239;
  t26_n238: return -0.048040490597486496f;
  t26_n239: return 0.04741872847080231f;
  t26_n240: return 0.06487281620502472f;
  t26_n241: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t26_n247;
  t26_n242: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t26_n246;
  t26_n243: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t26_n245;
  t26_n244: return 0.030162474140524864f;
  t26_n245: return 0.07643233984708786f;
  t26_n246: return 0.0873364731669426f;
  t26_n247: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type))) goto t26_n249;
  t26_n248: return 0.06968195736408234f;
  t26_n249: return 0.08998654037714005f;
  t26_n250: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t26_n254;
  t26_n251: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t26_n253;
  t26_n252: return 0.06736098229885101f;
  t26_n253: return 0.08197091519832611f;
  t26_n254: return 0.09872359037399292f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree27(const Example& E) {
  t27_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t27_n250;
  t27_n1: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t27_n155;
  t27_n2: if (E.getNumReferences() >= 3347793152 /*71306.0*/) goto t27_n138;
  t27_n3: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t27_n59;
  t27_n4: if (E.getNumReferences() >= 3251896320 /*26.5*/) goto t27_n54;
  t27_n5: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t27_n21;
  t27_n6: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t27_n20;
  t27_n7: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type))) goto t27_n9;
  t27_n8: return -0.054896578192710876f;
  t27_n9: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t27_n19;
  t27_n10: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t27_n18;
  t27_n11: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t27_n13;
  t27_n12: return -0.028897222131490707f;
  t27_n13: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t27_n17;
  t27_n14: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t27_n16;
  t27_n15: return 0.010109794326126575f;
  t27_n16: return -0.024139219895005226f;
  t27_n17: return -0.14115308225154877f;
  t27_n18: return 0.02221117913722992f;
  t27_n19: return -0.06101098656654358f;
  t27_n20: return 0.07650573551654816f;
  t27_n21: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t27_n23;
  t27_n22: return -0.09822528809309006f;
  t27_n23: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t27_n49;
  t27_n24: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t27_n48;
  t27_n25: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t27_n45;
  t27_n26: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t27_n32;
  t27_n27: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t27_n29;
  t27_n28: return 0.01842333935201168f;
  t27_n29: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t27_n31;
  t27_n30: return 0.019983593374490738f;
  t27_n31: return 0.08498378098011017f;
  t27_n32: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t27_n34;
  t27_n33: return -0.006136552896350622f;
  t27_n34: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t27_n44;
  t27_n35: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t27_n37;
  t27_n36: return 0.01393858902156353f;
  t27_n37: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t27_n41;
  t27_n38: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t27_n40;
  t27_n39: return -0.12956923246383667f;
  t27_n40: return 0.050061728805303574f;
  t27_n41: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t27_n43;
  t27_n42: return 0.061443161219358444f;
  t27_n43: return 0.017721718177199364f;
  t27_n44: return -0.04078193008899689f;
  t27_n45: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel))) goto t27_n47;
  t27_n46: return 0.01650068536400795f;
  t27_n47: return 0.02866552583873272f;
  t27_n48: return -0.10647056251764297f;
  t27_n49: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t27_n53;
  t27_n50: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t27_n52;
  t27_n51: return 0.008381363935768604f;
  t27_n52: return 0.04853443428874016f;
  t27_n53: return 0.04899131879210472f;
  t27_n54: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t27_n58;
  t27_n55: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t27_n57;
  t27_n56: return 0.01674993708729744f;
  t27_n57: return 0.051899079233407974f;
  t27_n58: return 0.0467047281563282f;
  t27_n59: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t27_n133;
  t27_n60: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace))) goto t27_n118;
  t27_n61: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t27_n117;
  t27_n62: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t27_n106;
  t27_n63: if (E.getSymbolScopeDistanceCost() >= 3252158464 /*27.0*/) goto t27_n75;
  t27_n64: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t27_n70;
  t27_n65: if (E.getFileProximityDistanceCost() >= 3242721280 /*12.5*/) goto t27_n69;
  t27_n66: if (E.getNumReferences() >= 3248226304 /*19.5*/) goto t27_n68;
  t27_n67: return -0.05032522976398468f;
  t27_n68: return 0.020904025062918663f;
  t27_n69: return -0.09601348638534546f;
  t27_n70: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t27_n72;
  t27_n71: return -0.13665585219860077f;
  t27_n72: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t27_n74;
  t27_n73: return 0.0068383910693228245f;
  t27_n74: return -0.043921686708927155f;
  t27_n75: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t27_n103;
  t27_n76: if (E.getNumReferences() >= 3290030080 /*615.5*/) goto t27_n100;
  t27_n77: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t27_n81;
  t27_n78: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t27_n80;
  t27_n79: return 0.044391948729753494f;
  t27_n80: return -0.06803583353757858f;
  t27_n81: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t27_n99;
  t27_n82: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t27_n84;
  t27_n83: return -0.060227613896131516f;
  t27_n84: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t27_n94;
  t27_n85: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t27_n93;
  t27_n86: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t27_n88;
  t27_n87: return -0.02556418627500534f;
  t27_n88: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t27_n90;
  t27_n89: return -0.06838186830282211f;
  t27_n90: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t27_n92;
  t27_n91: return 0.041117437183856964f;
  t27_n92: return -0.1068190485239029f;
  t27_n93: return -0.09131370484828949f;
  t27_n94: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t27_n98;
  t27_n95: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t27_n97;
  t27_n96: return 0.03580121695995331f;
  t27_n97: return 0.04931050166487694f;
  t27_n98: return -0.09011422097682953f;
  t27_n99: return -0.1297176033258438f;
  t27_n100: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t27_n102;
  t27_n101: return -0.0033012637868523598f;
  t27_n102: return 0.049270398914813995f;
  t27_n103: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t27_n105;
  t27_n104: return -0.05955085530877113f;
  t27_n105: return 0.029164733365178108f;
  t27_n106: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t27_n110;
  t27_n107: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t27_n109;
  t27_n108: return -0.026718884706497192f;
  t27_n109: return 0.042006563395261765f;
  t27_n110: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t27_n112;
  t27_n111: return -0.03709835931658745f;
  t27_n112: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t27_n114;
  t27_n113: return 0.02485499531030655f;
  t27_n114: if (E.getNumReferences() >= 3316109312 /*5370.0*/) goto t27_n116;
  t27_n115: return 0.061465781182050705f;
  t27_n116: return -0.018037322908639908f;
  t27_n117: return -0.09335577487945557f;
  t27_n118: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t27_n126;
  t27_n119: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t27_n125;
  t27_n120: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t27_n122;
  t27_n121: return 0.033681388944387436f;
  t27_n122: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t27_n124;
  t27_n123: return -0.06970115005970001f;
  t27_n124: return -0.014903333969414234f;
  t27_n125: return 0.03612849861383438f;
  t27_n126: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t27_n132;
  t27_n127: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t27_n131;
  t27_n128: if (E.getFileProximityDistanceCost() >= 3247177728 /*17.5*/) goto t27_n130;
  t27_n129: return 0.08181336522102356f;
  t27_n130: return 0.10313776880502701f;
  t27_n131: return 0.03824583441019058f;
  t27_n132: return 0.037565089762210846f;
  t27_n133: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t27_n137;
  t27_n134: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t27_n136;
  t27_n135: return -0.046401247382164f;
  t27_n136: return 0.05929142236709595f;
  t27_n137: return 0.04947618767619133f;
  t27_n138: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t27_n142;
  t27_n139: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t27_n141;
  t27_n140: return 0.000743978307582438f;
  t27_n141: return 0.07459289580583572f;
  t27_n142: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t27_n146;
  t27_n143: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t27_n145;
  t27_n144: return -0.006551298778504133f;
  t27_n145: return 0.08843601495027542f;
  t27_n146: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t27_n154;
  t27_n147: if (E.getNumReferences() >= 3362537216 /*241916.0*/) goto t27_n151;
  t27_n148: if (E.getNumReferences() >= 3359752544 /*198405.5*/) goto t27_n150;
  t27_n149: return 0.07586498558521271f;
  t27_n150: return 0.09589798748493195f;
  t27_n151: if (E.getNumReferences() >= 3364597360 /*286067.5*/) goto t27_n153;
  t27_n152: return -0.09076095372438431f;
  t27_n153: return 0.08527660369873047f;
  t27_n154: return -0.023993564769625664f;
  t27_n155: if (E.getNumReferences() >= 3309340672 /*3080.5*/) goto t27_n235;
  t27_n156: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t27_n200;
  t27_n157: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t27_n195;
  t27_n158: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t27_n194;
  t27_n159: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t27_n189;
  t27_n160: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t27_n164;
  t27_n161: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t27_n163;
  t27_n162: return 0.025141548365354538f;
  t27_n163: return 0.057466693222522736f;
  t27_n164: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t27_n176;
  t27_n165: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t27_n173;
  t27_n166: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t27_n172;
  t27_n167: if (E.getNumReferences() >= 3258843136 /*47.5*/) goto t27_n171;
  t27_n168: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t27_n170;
  t27_n169: return -0.00040069565875455737f;
  t27_n170: return 0.05645941197872162f;
  t27_n171: return 0.0642884150147438f;
  t27_n172: return -0.010735388845205307f;
  t27_n173: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t27_n175;
  t27_n174: return 0.020888676866889f;
  t27_n175: return 0.058669835329055786f;
  t27_n176: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t27_n178;
  t27_n177: return 0.0016626284923404455f;
  t27_n178: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t27_n188;
  t27_n179: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t27_n187;
  t27_n180: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t27_n182;
  t27_n181: return 0.030581381171941757f;
  t27_n182: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t27_n186;
  t27_n183: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t27_n185;
  t27_n184: return 0.023291969671845436f;
  t27_n185: return 0.06533820182085037f;
  t27_n186: return 0.08996883034706116f;
  t27_n187: return -0.029236869886517525f;
  t27_n188: return -0.10151847451925278f;
  t27_n189: if (E.getContextKind() & (BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t27_n191;
  t27_n190: return -0.042949531227350235f;
  t27_n191: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t27_n193;
  t27_n192: return 0.015112093649804592f;
  t27_n193: return -0.03528653085231781f;
  t27_n194: return 0.03181548789143562f;
  t27_n195: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t27_n199;
  t27_n196: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t27_n198;
  t27_n197: return 0.014889768324792385f;
  t27_n198: return 0.06327126175165176f;
  t27_n199: return 0.0584188736975193f;
  t27_n200: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t27_n202;
  t27_n201: return -0.04203947260975838f;
  t27_n202: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t27_n222;
  t27_n203: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t27_n219;
  t27_n204: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t27_n216;
  t27_n205: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t27_n211;
  t27_n206: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t27_n210;
  t27_n207: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t27_n209;
  t27_n208: return -0.006779302377253771f;
  t27_n209: return 0.02927275002002716f;
  t27_n210: return -0.01563681662082672f;
  t27_n211: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t27_n213;
  t27_n212: return 0.059307217597961426f;
  t27_n213: if (E.getNumReferences() >= 3270443008 /*119.5*/) goto t27_n215;
  t27_n214: return 0.02371937967836857f;
  t27_n215: return 0.05773753300309181f;
  t27_n216: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t27_n218;
  t27_n217: return 0.05526881292462349f;
  t27_n218: return 0.08832202851772308f;
  t27_n219: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel))) goto t27_n221;
  t27_n220: return -0.03433993458747864f;
  t27_n221: return 0.052609220147132874f;
  t27_n222: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t27_n234;
  t27_n223: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t27_n229;
  t27_n224: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t27_n226;
  t27_n225: return 0.031185993924736977f;
  t27_n226: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t27_n228;
  t27_n227: return 0.040069084614515305f;
  t27_n228: return 0.08449019491672516f;
  t27_n229: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t27_n231;
  t27_n230: return -0.08958901464939117f;
  t27_n231: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t27_n233;
  t27_n232: return -0.04513317719101906f;
  t27_n233: return 0.04506154730916023f;
  t27_n234: return 0.06201847270131111f;
  t27_n235: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t27_n249;
  t27_n236: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t27_n238;
  t27_n237: return 0.04058661311864853f;
  t27_n238: if (E.getNumReferences() >= 3344481024 /*55483.0*/) goto t27_n240;
  t27_n239: return 0.0579235665500164f;
  t27_n240: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t27_n246;
  t27_n241: if (E.getNumReferences() >= 3344616064 /*56010.5*/) goto t27_n245;
  t27_n242: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t27_n244;
  t27_n243: return 0.05048217251896858f;
  t27_n244: return 0.12794436514377594f;
  t27_n245: return 0.07343357801437378f;
  t27_n246: if (E.getNumReferences() >= 3348232704 /*74740.0*/) goto t27_n248;
  t27_n247: return 0.07897485047578812f;
  t27_n248: return 0.1088867336511612f;
  t27_n249: return 0.09491527825593948f;
  t27_n250: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t27_n254;
  t27_n251: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t27_n253;
  t27_n252: return 0.06483777612447739f;
  t27_n253: return 0.07989729195833206f;
  t27_n254: return 0.09731945395469666f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree28(const Example& E) {
  t28_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t28_n252;
  t28_n1: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t28_n155;
  t28_n2: if (E.getNumReferences() >= 3347793152 /*71306.0*/) goto t28_n112;
  t28_n3: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t28_n79;
  t28_n4: if (E.getNumReferences() >= 3251896320 /*26.5*/) goto t28_n68;
  t28_n5: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t28_n35;
  t28_n6: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t28_n34;
  t28_n7: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type))) goto t28_n9;
  t28_n8: return -0.05170422047376633f;
  t28_n9: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t28_n33;
  t28_n10: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t28_n32;
  t28_n11: if (E.getFileProximityDistanceCost() >= 3248750592 /*20.5*/) goto t28_n13;
  t28_n12: return -0.02584465965628624f;
  t28_n13: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t28_n31;
  t28_n14: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t28_n30;
  t28_n15: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t28_n29;
  t28_n16: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t28_n26;
  t28_n17: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t28_n25;
  t28_n18: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t28_n22;
  t28_n19: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t28_n21;
  t28_n20: return -0.1480434685945511f;
  t28_n21: return -0.02080627717077732f;
  t28_n22: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t28_n24;
  t28_n23: return -0.11473193764686584f;
  t28_n24: return 0.012380711734294891f;
  t28_n25: return 0.04241477698087692f;
  t28_n26: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t28_n28;
  t28_n27: return -0.0891285166144371f;
  t28_n28: return 0.09208983182907104f;
  t28_n29: return -0.017084330320358276f;
  t28_n30: return -0.14392858743667603f;
  t28_n31: return -0.09781856834888458f;
  t28_n32: return 0.02049054019153118f;
  t28_n33: return -0.05839083716273308f;
  t28_n34: return 0.0717950388789177f;
  t28_n35: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t28_n37;
  t28_n36: return -0.09693103283643723f;
  t28_n37: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t28_n63;
  t28_n38: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t28_n62;
  t28_n39: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t28_n59;
  t28_n40: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t28_n46;
  t28_n41: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t28_n43;
  t28_n42: return 0.016220683231949806f;
  t28_n43: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t28_n45;
  t28_n44: return 0.01872973144054413f;
  t28_n45: return 0.0823250338435173f;
  t28_n46: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t28_n48;
  t28_n47: return -0.005524680949747562f;
  t28_n48: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t28_n58;
  t28_n49: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t28_n51;
  t28_n50: return 0.012886445969343185f;
  t28_n51: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t28_n55;
  t28_n52: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t28_n54;
  t28_n53: return -0.11264675855636597f;
  t28_n54: return 0.0444624200463295f;
  t28_n55: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t28_n57;
  t28_n56: return 0.0588812418282032f;
  t28_n57: return 0.017069444060325623f;
  t28_n58: return -0.03809359669685364f;
  t28_n59: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel))) goto t28_n61;
  t28_n60: return 0.015391561202704906f;
  t28_n61: return 0.027166632935404778f;
  t28_n62: return -0.10535284131765366f;
  t28_n63: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t28_n67;
  t28_n64: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t28_n66;
  t28_n65: return 0.00874739047139883f;
  t28_n66: return 0.04615236073732376f;
  t28_n67: return 0.046604227274656296f;
  t28_n68: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t28_n78;
  t28_n69: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t28_n77;
  t28_n70: if (E.getNumReferences() >= 3317207040 /*5906.0*/) goto t28_n72;
  t28_n71: return 0.008270022459328175f;
  t28_n72: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t28_n74;
  t28_n73: return 0.027814514935016632f;
  t28_n74: if (E.getNumReferences() >= 3342947200 /*49491.5*/) goto t28_n76;
  t28_n75: return 0.08596788346767426f;
  t28_n76: return -0.12068384140729904f;
  t28_n77: return 0.050527047365903854f;
  t28_n78: return 0.053674109280109406f;
  t28_n79: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t28_n107;
  t28_n80: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t28_n106;
  t28_n81: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t28_n95;
  t28_n82: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace))) goto t28_n84;
  t28_n83: return -0.03569694980978966f;
  t28_n84: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t28_n92;
  t28_n85: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t28_n91;
  t28_n86: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t28_n88;
  t28_n87: return 0.030452914535999298f;
  t28_n88: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t28_n90;
  t28_n89: return -0.06569499522447586f;
  t28_n90: return -0.015425696037709713f;
  t28_n91: return 0.03260684758424759f;
  t28_n92: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace))) goto t28_n94;
  t28_n93: return 0.05018160492181778f;
  t28_n94: return 0.10281327366828918f;
  t28_n95: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t28_n105;
  t28_n96: if (E.getNumReferences() >= 3318942720 /*6753.5*/) goto t28_n104;
  t28_n97: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t28_n101;
  t28_n98: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t28_n100;
  t28_n99: return 0.001044596079736948f;
  t28_n100: return 0.04197731241583824f;
  t28_n101: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t28_n103;
  t28_n102: return -0.014195054769515991f;
  t28_n103: return 0.05808885768055916f;
  t28_n104: return -0.05140319839119911f;
  t28_n105: return -0.1030004620552063f;
  t28_n106: return -0.09096032381057739f;
  t28_n107: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t28_n111;
  t28_n108: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t28_n110;
  t28_n109: return -0.03565765172243118f;
  t28_n110: return 0.05696915090084076f;
  t28_n111: return 0.05106373876333237f;
  t28_n112: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t28_n118;
  t28_n113: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t28_n117;
  t28_n114: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t28_n116;
  t28_n115: return 0.05508884787559509f;
  t28_n116: return 0.106698177754879f;
  t28_n117: return 0.0956726148724556f;
  t28_n118: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t28_n154;
  t28_n119: if (E.getNumReferences() >= 3362537216 /*241916.0*/) goto t28_n149;
  t28_n120: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t28_n140;
  t28_n121: if (E.getNumReferences() >= 3355687776 /*134893.5*/) goto t28_n139;
  t28_n122: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t28_n124;
  t28_n123: return -0.008301276713609695f;
  t28_n124: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t28_n132;
  t28_n125: if (E.getNumReferences() >= 3353598912 /*116663.5*/) goto t28_n127;
  t28_n126: return -0.029141129925847054f;
  t28_n127: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t28_n129;
  t28_n128: return -0.15278786420822144f;
  t28_n129: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t28_n131;
  t28_n130: return 0.13182079792022705f;
  t28_n131: return 7.61427654651925e-05f;
  t28_n132: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t28_n134;
  t28_n133: return -0.15168526768684387f;
  t28_n134: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t28_n136;
  t28_n135: return -0.0038981360848993063f;
  t28_n136: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t28_n138;
  t28_n137: return -0.04383093863725662f;
  t28_n138: return 0.09349572658538818f;
  t28_n139: return -0.07351695746183395f;
  t28_n140: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t28_n146;
  t28_n141: if (E.getNumReferences() >= 3360215360 /*205637.0*/) goto t28_n145;
  t28_n142: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t28_n144;
  t28_n143: return -0.1464146226644516f;
  t28_n144: return 0.09135929495096207f;
  t28_n145: return 0.022298621013760567f;
  t28_n146: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t28_n148;
  t28_n147: return -0.1359197050333023f;
  t28_n148: return 0.101224385201931f;
  t28_n149: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t28_n151;
  t28_n150: return -0.04754885286092758f;
  t28_n151: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t28_n153;
  t28_n152: return -0.08591583371162415f;
  t28_n153: return 0.06578417867422104f;
  t28_n154: return 0.07604724168777466f;
  t28_n155: if (E.getNumReferences() >= 3309340672 /*3080.5*/) goto t28_n241;
  t28_n156: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t28_n202;
  t28_n157: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t28_n197;
  t28_n158: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t28_n194;
  t28_n159: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t28_n189;
  t28_n160: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t28_n164;
  t28_n161: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t28_n163;
  t28_n162: return 0.023507457226514816f;
  t28_n163: return 0.054460346698760986f;
  t28_n164: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t28_n176;
  t28_n165: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t28_n173;
  t28_n166: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t28_n172;
  t28_n167: if (E.getNumReferences() >= 3258843136 /*47.5*/) goto t28_n171;
  t28_n168: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t28_n170;
  t28_n169: return -0.0007008301909081638f;
  t28_n170: return 0.05376634746789932f;
  t28_n171: return 0.0613047257065773f;
  t28_n172: return -0.00954741332679987f;
  t28_n173: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t28_n175;
  t28_n174: return 0.019876891747117043f;
  t28_n175: return 0.05591952055692673f;
  t28_n176: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t28_n178;
  t28_n177: return 0.0015481149312108755f;
  t28_n178: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t28_n188;
  t28_n179: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t28_n187;
  t28_n180: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t28_n182;
  t28_n181: return 0.028315464034676552f;
  t28_n182: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t28_n186;
  t28_n183: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t28_n185;
  t28_n184: return 0.02231230027973652f;
  t28_n185: return 0.06319055706262589f;
  t28_n186: return 0.08556722849607468f;
  t28_n187: return -0.025079328566789627f;
  t28_n188: return -0.0947052389383316f;
  t28_n189: if (E.getContextKind() & (BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t28_n191;
  t28_n190: return -0.040689680725336075f;
  t28_n191: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t28_n193;
  t28_n192: return 0.01412515714764595f;
  t28_n193: return -0.03278148174285889f;
  t28_n194: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t28_n196;
  t28_n195: return 0.020780935883522034f;
  t28_n196: return 0.034839991480112076f;
  t28_n197: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t28_n201;
  t28_n198: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t28_n200;
  t28_n199: return 0.014263676479458809f;
  t28_n200: return 0.06001740321516991f;
  t28_n201: return 0.05514563247561455f;
  t28_n202: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t28_n204;
  t28_n203: return -0.03746871277689934f;
  t28_n204: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t28_n226;
  t28_n205: if (E.getFractionNameInContext() >= 3197638680 /*0.2970588207244873*/) goto t28_n217;
  t28_n206: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t28_n212;
  t28_n207: if (E.getNumReferences() >= 3245867008 /*15.5*/) goto t28_n209;
  t28_n208: return 0.007017638999968767f;
  t28_n209: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t28_n211;
  t28_n210: return 0.05579717457294464f;
  t28_n211: return 0.029081353917717934f;
  t28_n212: if (E.getContextKind() & (BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel))) goto t28_n214;
  t28_n213: return 0.0101176667958498f;
  t28_n214: if (E.getSymbolScopeDistanceCost() >= 3221225472 /*2.0*/) goto t28_n216;
  t28_n215: return 0.08755938708782196f;
  t28_n216: return 0.03385409712791443f;
  t28_n217: if (E.getNumReferences() >= 3259367424 /*49.5*/) goto t28_n225;
  t28_n218: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t28_n224;
  t28_n219: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t28_n223;
  t28_n220: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t28_n222;
  t28_n221: return 0.036695368587970734f;
  t28_n222: return 0.022527368739247322f;
  t28_n223: return 0.05962337926030159f;
  t28_n224: return 0.05748143047094345f;
  t28_n225: return 0.08031335473060608f;
  t28_n226: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t28_n238;
  t28_n227: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t28_n233;
  t28_n228: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t28_n230;
  t28_n229: return 0.030194353312253952f;
  t28_n230: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t28_n232;
  t28_n231: return 0.037732359021902084f;
  t28_n232: return 0.0800907164812088f;
  t28_n233: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t28_n235;
  t28_n234: return -0.08646124601364136f;
  t28_n235: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FunctionScope)|BIT(Scope_type::GlobalScope))) goto t28_n237;
  t28_n236: return -0.05672710761427879f;
  t28_n237: return 0.04210464656352997f;
  t28_n238: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t28_n240;
  t28_n239: return 0.027698509395122528f;
  t28_n240: return 0.06629891693592072f;
  t28_n241: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t28_n251;
  t28_n242: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t28_n248;
  t28_n243: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t28_n245;
  t28_n244: return 0.052835676819086075f;
  t28_n245: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t28_n247;
  t28_n246: return 0.05418791621923447f;
  t28_n247: return 0.10078409314155579f;
  t28_n248: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t28_n250;
  t28_n249: return 0.0037530993577092886f;
  t28_n250: return 0.07438463717699051f;
  t28_n251: return 0.08236880600452423f;
  t28_n252: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t28_n254;
  t28_n253: return 0.06793849170207977f;
  t28_n254: return 0.0819200873374939f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree29(const Example& E) {
  t29_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t29_n250;
  t29_n1: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t29_n111;
  t29_n2: if (E.getNumReferences() >= 3338822784 /*33380.5*/) goto t29_n74;
  t29_n3: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t29_n57;
  t29_n4: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t29_n34;
  t29_n5: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t29_n25;
  t29_n6: if (E.getContextKind() & (BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t29_n16;
  t29_n7: if (E.getNumReferences() >= 3308015616 /*2757.0*/) goto t29_n15;
  t29_n8: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t29_n12;
  t29_n9: if (E.getScope() & (BIT(Scope_type::FunctionScope)|BIT(Scope_type::GlobalScope))) goto t29_n11;
  t29_n10: return -0.11948397010564804f;
  t29_n11: return -0.04391788691282272f;
  t29_n12: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t29_n14;
  t29_n13: return 0.0011944841826334596f;
  t29_n14: return -0.05773455649614334f;
  t29_n15: return 0.02320624515414238f;
  t29_n16: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t29_n18;
  t29_n17: return -0.09492268413305283f;
  t29_n18: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t29_n22;
  t29_n19: if (E.getNumReferences() >= 3244818432 /*14.5*/) goto t29_n21;
  t29_n20: return -0.00041819503530859947f;
  t29_n21: return 0.08922731876373291f;
  t29_n22: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t29_n24;
  t29_n23: return 0.014613030478358269f;
  t29_n24: return 0.04488014802336693f;
  t29_n25: if (E.getNumReferences() >= 3317853184 /*6221.5*/) goto t29_n31;
  t29_n26: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t29_n28;
  t29_n27: return -0.0036310043651610613f;
  t29_n28: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t29_n30;
  t29_n29: return 0.023544035851955414f;
  t29_n30: return 0.05892447754740715f;
  t29_n31: if (E.getNumReferences() >= 3318227968 /*6404.5*/) goto t29_n33;
  t29_n32: return 0.13324998319149017f;
  t29_n33: return 0.07493004947900772f;
  t29_n34: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t29_n46;
  t29_n35: if (E.getNumReferences() >= 3273424896 /*156.5*/) goto t29_n41;
  t29_n36: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t29_n38;
  t29_n37: return -0.007110360078513622f;
  t29_n38: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol))) goto t29_n40;
  t29_n39: return 0.016654687002301216f;
  t29_n40: return 0.08329803496599197f;
  t29_n41: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t29_n45;
  t29_n42: if (E.getNumReferences() >= 3324926976 /*11159.0*/) goto t29_n44;
  t29_n43: return 0.032231204211711884f;
  t29_n44: return 0.06725713610649109f;
  t29_n45: return -0.013688432052731514f;
  t29_n46: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t29_n56;
  t29_n47: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t29_n51;
  t29_n48: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t29_n50;
  t29_n49: return 0.018271317705512047f;
  t29_n50: return 0.0505048893392086f;
  t29_n51: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t29_n55;
  t29_n52: if (E.getNumReferences() >= 3275784192 /*192.5*/) goto t29_n54;
  t29_n53: return 0.018821455538272858f;
  t29_n54: return 0.0565386563539505f;
  t29_n55: return -0.10009641200304031f;
  t29_n56: return 0.09512044489383698f;
  t29_n57: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t29_n71;
  t29_n58: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t29_n68;
  t29_n59: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t29_n67;
  t29_n60: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t29_n66;
  t29_n61: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t29_n65;
  t29_n62: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t29_n64;
  t29_n63: return 0.0022506634704768658f;
  t29_n64: return 0.05887269973754883f;
  t29_n65: return 0.04255631938576698f;
  t29_n66: return -0.021750079467892647f;
  t29_n67: return -0.07344096899032593f;
  t29_n68: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t29_n70;
  t29_n69: return -0.03035743348300457f;
  t29_n70: return 0.02006218023598194f;
  t29_n71: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t29_n73;
  t29_n72: return -0.024592354893684387f;
  t29_n73: return 0.03996999189257622f;
  t29_n74: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t29_n108;
  t29_n75: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t29_n81;
  t29_n76: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t29_n78;
  t29_n77: return 0.03150460869073868f;
  t29_n78: if (E.getNumReferences() >= 3360228064 /*205835.5*/) goto t29_n80;
  t29_n79: return 0.08677578717470169f;
  t29_n80: return 0.06805512309074402f;
  t29_n81: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Variable))) goto t29_n107;
  t29_n82: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t29_n84;
  t29_n83: return -0.05671990290284157f;
  t29_n84: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t29_n86;
  t29_n85: return -0.03932544216513634f;
  t29_n86: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t29_n104;
  t29_n87: if (E.getNumReferences() >= 3362537216 /*241916.0*/) goto t29_n95;
  t29_n88: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t29_n90;
  t29_n89: return 0.03527369350194931f;
  t29_n90: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t29_n94;
  t29_n91: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t29_n93;
  t29_n92: return -0.16222429275512695f;
  t29_n93: return 0.07080846279859543f;
  t29_n94: return 0.08109865337610245f;
  t29_n95: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t29_n99;
  t29_n96: if (E.getNumReferences() >= 3364597360 /*286067.5*/) goto t29_n98;
  t29_n97: return -0.1511598378419876f;
  t29_n98: return 0.04221218824386597f;
  t29_n99: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t29_n101;
  t29_n100: return -0.1697389781475067f;
  t29_n101: if (E.getNumReferences() >= 3363872672 /*263421.0*/) goto t29_n103;
  t29_n102: return -0.17863242328166962f;
  t29_n103: return 0.09741964936256409f;
  t29_n104: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t29_n106;
  t29_n105: return -0.10902635008096695f;
  t29_n106: return 0.022055240347981453f;
  t29_n107: return 0.05804700404405594f;
  t29_n108: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol))) goto t29_n110;
  t29_n109: return 0.05871719866991043f;
  t29_n110: return 0.088137686252594f;
  t29_n111: if (E.getNumReferences() >= 3309340672 /*3080.5*/) goto t29_n237;
  t29_n112: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t29_n170;
  t29_n113: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t29_n165;
  t29_n114: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t29_n130;
  t29_n115: if (E.getNumReferences() >= 3240624128 /*10.5*/) goto t29_n127;
  t29_n116: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t29_n126;
  t29_n117: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t29_n119;
  t29_n118: return 0.004673061426728964f;
  t29_n119: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t29_n121;
  t29_n120: return -0.10472628474235535f;
  t29_n121: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t29_n125;
  t29_n122: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type))) goto t29_n124;
  t29_n123: return -0.005279206205159426f;
  t29_n124: return 0.03410521149635315f;
  t29_n125: return 0.053005170077085495f;
  t29_n126: return 0.03136134892702103f;
  t29_n127: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t29_n129;
  t29_n128: return 0.04409226402640343f;
  t29_n129: return 0.07363655418157578f;
  t29_n130: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t29_n164;
  t29_n131: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t29_n161;
  t29_n132: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t29_n160;
  t29_n133: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t29_n157;
  t29_n134: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t29_n138;
  t29_n135: if (E.getNumReferences() >= 3241672704 /*11.5*/) goto t29_n137;
  t29_n136: return 0.015586393885314465f;
  t29_n137: return 0.07335933297872543f;
  t29_n138: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t29_n156;
  t29_n139: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t29_n141;
  t29_n140: return -0.008568771183490753f;
  t29_n141: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t29_n143;
  t29_n142: return -0.011811408214271069f;
  t29_n143: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t29_n155;
  t29_n144: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t29_n154;
  t29_n145: if (E.getSymbolScopeDistanceCost() >= 3246915584 /*17.0*/) goto t29_n147;
  t29_n146: return -0.08139266818761826f;
  t29_n147: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t29_n149;
  t29_n148: return -0.05085267871618271f;
  t29_n149: if (E.getFileProximityDistanceCost() >= 3248750592 /*20.5*/) goto t29_n153;
  t29_n150: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t29_n152;
  t29_n151: return 0.09153381735086441f;
  t29_n152: return -0.02692231722176075f;
  t29_n153: return 0.09592506289482117f;
  t29_n154: return -0.07798359543085098f;
  t29_n155: return -0.047748863697052f;
  t29_n156: return -0.05163893476128578f;
  t29_n157: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t29_n159;
  t29_n158: return 0.012837531976401806f;
  t29_n159: return 0.0652552992105484f;
  t29_n160: return -0.09455323964357376f;
  t29_n161: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t29_n163;
  t29_n162: return -0.03325660899281502f;
  t29_n163: return 0.0512549951672554f;
  t29_n164: return 0.046577177941799164f;
  t29_n165: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t29_n169;
  t29_n166: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t29_n168;
  t29_n167: return 0.012979437597095966f;
  t29_n168: return 0.04966020956635475f;
  t29_n169: return 0.06325966119766235f;
  t29_n170: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t29_n172;
  t29_n171: return -0.03365720435976982f;
  t29_n172: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t29_n198;
  t29_n173: if (E.getFractionNameInContext() >= 3197638680 /*0.2970588207244873*/) goto t29_n183;
  t29_n174: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t29_n178;
  t29_n175: if (E.getNumReferences() >= 3245867008 /*15.5*/) goto t29_n177;
  t29_n176: return 0.007564837113022804f;
  t29_n177: return 0.038253989070653915f;
  t29_n178: if (E.getContextKind() & (BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel))) goto t29_n180;
  t29_n179: return 0.009848499670624733f;
  t29_n180: if (E.getSymbolScopeDistanceCost() >= 3221225472 /*2.0*/) goto t29_n182;
  t29_n181: return 0.0853831022977829f;
  t29_n182: return 0.032702866941690445f;
  t29_n183: if (E.getNumReferences() >= 3259367424 /*49.5*/) goto t29_n197;
  t29_n184: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t29_n196;
  t29_n185: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t29_n195;
  t29_n186: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t29_n190;
  t29_n187: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t29_n189;
  t29_n188: return 0.028777752071619034f;
  t29_n189: return 0.06279182434082031f;
  t29_n190: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t29_n192;
  t29_n191: return -0.10883091390132904f;
  t29_n192: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t29_n194;
  t29_n193: return 0.0208722036331892f;
  t29_n194: return 0.05230061709880829f;
  t29_n195: return 0.0575391948223114f;
  t29_n196: return 0.0541723407804966f;
  t29_n197: return 0.07774142920970917f;
  t29_n198: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t29_n236;
  t29_n199: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t29_n231;
  t29_n200: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t29_n230;
  t29_n201: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t29_n217;
  t29_n202: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t29_n208;
  t29_n203: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t29_n205;
  t29_n204: return 0.007197953760623932f;
  t29_n205: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_ParenthesizedExpression))) goto t29_n207;
  t29_n206: return 0.012714296579360962f;
  t29_n207: return 0.04648563638329506f;
  t29_n208: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t29_n210;
  t29_n209: return 0.019863486289978027f;
  t29_n210: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t29_n214;
  t29_n211: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t29_n213;
  t29_n212: return -0.025589825585484505f;
  t29_n213: return 0.038998425006866455f;
  t29_n214: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t29_n216;
  t29_n215: return 0.05105379968881607f;
  t29_n216: return 0.06700385361909866f;
  t29_n217: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t29_n223;
  t29_n218: if (E.getFileProximityDistanceCost() >= 3252158464 /*27.0*/) goto t29_n222;
  t29_n219: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t29_n221;
  t29_n220: return 0.055803753435611725f;
  t29_n221: return -0.1089334785938263f;
  t29_n222: return -0.05485520511865616f;
  t29_n223: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t29_n225;
  t29_n224: return -0.06263580173254013f;
  t29_n225: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t29_n227;
  t29_n226: return 0.06254716962575912f;
  t29_n227: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t29_n229;
  t29_n228: return 0.0966532900929451f;
  t29_n229: return -0.2579922080039978f;
  t29_n230: return 0.04729384928941727f;
  t29_n231: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t29_n233;
  t29_n232: return -0.0831596851348877f;
  t29_n233: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FunctionScope)|BIT(Scope_type::GlobalScope))) goto t29_n235;
  t29_n234: return -0.05373558774590492f;
  t29_n235: return 0.040914759039878845f;
  t29_n236: return 0.05748714506626129f;
  t29_n237: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t29_n241;
  t29_n238: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t29_n240;
  t29_n239: return 0.0360809825360775f;
  t29_n240: return 0.08088003098964691f;
  t29_n241: if (E.getNumReferences() >= 3344481024 /*55483.0*/) goto t29_n243;
  t29_n242: return 0.05415734648704529f;
  t29_n243: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t29_n249;
  t29_n244: if (E.getNumReferences() >= 3344616064 /*56010.5*/) goto t29_n248;
  t29_n245: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t29_n247;
  t29_n246: return 0.05137704685330391f;
  t29_n247: return 0.12378296256065369f;
  t29_n248: return 0.08566766232252121f;
  t29_n249: return 0.10481078922748566f;
  t29_n250: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t29_n254;
  t29_n251: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t29_n253;
  t29_n252: return 0.059359967708587646f;
  t29_n253: return 0.07541389763355255f;
  t29_n254: return 0.09523913264274597f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree30(const Example& E) {
  t30_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t30_n252;
  t30_n1: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t30_n115;
  t30_n2: if (E.getNumReferences() >= 3338822784 /*33380.5*/) goto t30_n98;
  t30_n3: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t30_n43;
  t30_n4: if (E.getNumReferences() >= 3240624128 /*10.5*/) goto t30_n40;
  t30_n5: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t30_n19;
  t30_n6: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t30_n18;
  t30_n7: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type))) goto t30_n9;
  t30_n8: return -0.0488622710108757f;
  t30_n9: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t30_n17;
  t30_n10: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t30_n12;
  t30_n11: return -0.021522454917430878f;
  t30_n12: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t30_n16;
  t30_n13: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t30_n15;
  t30_n14: return 0.005322855897247791f;
  t30_n15: return -0.15789274871349335f;
  t30_n16: return -0.08782973140478134f;
  t30_n17: return -0.05377275124192238f;
  t30_n18: return 0.06687027961015701f;
  t30_n19: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t30_n21;
  t30_n20: return -0.09438060224056244f;
  t30_n21: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t30_n37;
  t30_n22: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t30_n36;
  t30_n23: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t30_n33;
  t30_n24: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t30_n32;
  t30_n25: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t30_n31;
  t30_n26: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t30_n28;
  t30_n27: return 0.01892719604074955f;
  t30_n28: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t30_n30;
  t30_n29: return 0.057284947484731674f;
  t30_n30: return -0.07780008763074875f;
  t30_n31: return 0.0065612285397946835f;
  t30_n32: return -0.01826765388250351f;
  t30_n33: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel))) goto t30_n35;
  t30_n34: return 0.015888450667262077f;
  t30_n35: return 0.024427957832813263f;
  t30_n36: return -0.10285010188817978f;
  t30_n37: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t30_n39;
  t30_n38: return 0.022345244884490967f;
  t30_n39: return 0.04307738319039345f;
  t30_n40: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t30_n42;
  t30_n41: return 0.017517006024718285f;
  t30_n42: return 0.04244013875722885f;
  t30_n43: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t30_n93;
  t30_n44: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t30_n90;
  t30_n45: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t30_n85;
  t30_n46: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t30_n52;
  t30_n47: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t30_n51;
  t30_n48: if (E.getNumReferences() >= 3247702016 /*18.5*/) goto t30_n50;
  t30_n49: return -0.03450384363532066f;
  t30_n50: return 0.04120306670665741f;
  t30_n51: return -0.08732997626066208f;
  t30_n52: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t30_n78;
  t30_n53: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t30_n55;
  t30_n54: return -0.05753720551729202f;
  t30_n55: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t30_n59;
  t30_n56: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t30_n58;
  t30_n57: return -0.0445745587348938f;
  t30_n58: return -0.08384106308221817f;
  t30_n59: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FunctionScope))) goto t30_n75;
  t30_n60: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel))) goto t30_n72;
  t30_n61: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t30_n71;
  t30_n62: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t30_n64;
  t30_n63: return -0.024512236937880516f;
  t30_n64: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t30_n70;
  t30_n65: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t30_n69;
  t30_n66: if (E.getFileProximityDistanceCost() >= 3254910976 /*32.5*/) goto t30_n68;
  t30_n67: return 0.03700254112482071f;
  t30_n68: return -0.16985902190208435f;
  t30_n69: return -0.06421791017055511f;
  t30_n70: return -0.12890276312828064f;
  t30_n71: return -0.08839187771081924f;
  t30_n72: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t30_n74;
  t30_n73: return 0.03209618851542473f;
  t30_n74: return -0.12238617241382599f;
  t30_n75: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t30_n77;
  t30_n76: return 0.06493328511714935f;
  t30_n77: return 0.005209289025515318f;
  t30_n78: if (E.getNumReferences() >= 3268608000 /*105.5*/) goto t30_n82;
  t30_n79: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t30_n81;
  t30_n80: return 0.06875486671924591f;
  t30_n81: return -0.009659246541559696f;
  t30_n82: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t30_n84;
  t30_n83: return -0.020121801644563675f;
  t30_n84: return 0.057003505527973175f;
  t30_n85: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t30_n89;
  t30_n86: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t30_n88;
  t30_n87: return 0.0005694928113371134f;
  t30_n88: return 0.029253382235765457f;
  t30_n89: return -0.03643738105893135f;
  t30_n90: if (E.getSymbolScopeDistanceCost() >= 3246915584 /*17.0*/) goto t30_n92;
  t30_n91: return -0.027217797935009003f;
  t30_n92: return 0.019154459238052368f;
  t30_n93: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t30_n97;
  t30_n94: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t30_n96;
  t30_n95: return -0.03396669775247574f;
  t30_n96: return 0.03614475205540657f;
  t30_n97: return 0.05774068459868431f;
  t30_n98: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t30_n112;
  t30_n99: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t30_n107;
  t30_n100: if (E.getNumReferences() >= 3358114336 /*172808.5*/) goto t30_n106;
  t30_n101: if (E.getNumReferences() >= 3347876160 /*71954.5*/) goto t30_n105;
  t30_n102: if (E.getNumReferences() >= 3342690432 /*48488.5*/) goto t30_n104;
  t30_n103: return 0.062447551637887955f;
  t30_n104: return -0.014186302199959755f;
  t30_n105: return 0.06274707615375519f;
  t30_n106: return -0.15338076651096344f;
  t30_n107: if (E.getNumReferences() >= 3360228064 /*205835.5*/) goto t30_n111;
  t30_n108: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t30_n110;
  t30_n109: return 0.08069968223571777f;
  t30_n110: return 0.11871843039989471f;
  t30_n111: return 0.080286405980587f;
  t30_n112: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t30_n114;
  t30_n113: return 0.005712434649467468f;
  t30_n114: return 0.06244051456451416f;
  t30_n115: if (E.getNumReferences() >= 3303280640 /*1824.5*/) goto t30_n235;
  t30_n116: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t30_n190;
  t30_n117: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t30_n185;
  t30_n118: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t30_n150;
  t30_n119: if (E.getNumReferences() >= 3238526976 /*8.5*/) goto t30_n147;
  t30_n120: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t30_n146;
  t30_n121: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t30_n135;
  t30_n122: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t30_n134;
  t30_n123: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t30_n133;
  t30_n124: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t30_n132;
  t30_n125: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t30_n129;
  t30_n126: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t30_n128;
  t30_n127: return -0.1882205605506897f;
  t30_n128: return -0.1101563423871994f;
  t30_n129: if (E.getFileProximityDistanceCost() >= 3255042048 /*33.0*/) goto t30_n131;
  t30_n130: return -0.012955175712704659f;
  t30_n131: return 0.049105238169431686f;
  t30_n132: return 0.008464979007840157f;
  t30_n133: return 0.08424864709377289f;
  t30_n134: return -0.08545787632465363f;
  t30_n135: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t30_n137;
  t30_n136: return -0.03904174268245697f;
  t30_n137: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t30_n143;
  t30_n138: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t30_n142;
  t30_n139: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t30_n141;
  t30_n140: return 0.026649633422493935f;
  t30_n141: return -0.0013432442210614681f;
  t30_n142: return -0.027742043137550354f;
  t30_n143: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t30_n145;
  t30_n144: return 0.018663667142391205f;
  t30_n145: return 0.05669742450118065f;
  t30_n146: return 0.029992137104272842f;
  t30_n147: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t30_n149;
  t30_n148: return 0.04232913628220558f;
  t30_n149: return 0.06652430444955826f;
  t30_n150: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t30_n184;
  t30_n151: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t30_n183;
  t30_n152: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t30_n182;
  t30_n153: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t30_n175;
  t30_n154: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t30_n156;
  t30_n155: return -0.02493319660425186f;
  t30_n156: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t30_n158;
  t30_n157: return 0.0034075237344950438f;
  t30_n158: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t30_n166;
  t30_n159: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t30_n165;
  t30_n160: if (E.getSymbolScopeDistanceCost() >= 3246915584 /*17.0*/) goto t30_n162;
  t30_n161: return 0.004257092718034983f;
  t30_n162: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t30_n164;
  t30_n163: return 0.07544683665037155f;
  t30_n164: return -0.01079794205725193f;
  t30_n165: return -0.12918312847614288f;
  t30_n166: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t30_n168;
  t30_n167: return 0.005628400016576052f;
  t30_n168: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t30_n174;
  t30_n169: if (E.getFileProximityDistanceCost() >= 3248750592 /*20.5*/) goto t30_n173;
  t30_n170: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t30_n172;
  t30_n171: return 0.0676712915301323f;
  t30_n172: return -0.02139037288725376f;
  t30_n173: return 0.08903664350509644f;
  t30_n174: return -0.1171005442738533f;
  t30_n175: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t30_n181;
  t30_n176: if (E.getNumReferences() >= 3256745984 /*39.5*/) goto t30_n178;
  t30_n177: return 0.005949538666754961f;
  t30_n178: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t30_n180;
  t30_n179: return 0.09309937059879303f;
  t30_n180: return 0.16495999693870544f;
  t30_n181: return -0.06646249443292618f;
  t30_n182: return 0.01722104847431183f;
  t30_n183: return -0.08822080492973328f;
  t30_n184: return 0.04177059978246689f;
  t30_n185: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t30_n189;
  t30_n186: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t30_n188;
  t30_n187: return 0.01230979710817337f;
  t30_n188: return 0.046972423791885376f;
  t30_n189: return 0.06093563511967659f;
  t30_n190: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t30_n192;
  t30_n191: return -0.029613470658659935f;
  t30_n192: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t30_n226;
  t30_n193: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t30_n221;
  t30_n194: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t30_n206;
  t30_n195: if (E.getNumReferences() >= 3255173120 /*33.5*/) goto t30_n205;
  t30_n196: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t30_n202;
  t30_n197: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t30_n201;
  t30_n198: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t30_n200;
  t30_n199: return 0.015508972108364105f;
  t30_n200: return 0.02468775399029255f;
  t30_n201: return -0.06396942585706711f;
  t30_n202: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol))) goto t30_n204;
  t30_n203: return 0.010766744613647461f;
  t30_n204: return 0.042043790221214294f;
  t30_n205: return 0.0569855198264122f;
  t30_n206: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t30_n220;
  t30_n207: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t30_n211;
  t30_n208: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t30_n210;
  t30_n209: return 0.05021703988313675f;
  t30_n210: return 0.07034517824649811f;
  t30_n211: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Variable))) goto t30_n217;
  t30_n212: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t30_n214;
  t30_n213: return 0.027568282559514046f;
  t30_n214: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_Type))) goto t30_n216;
  t30_n215: return 0.03677414357662201f;
  t30_n216: return 0.054188091307878494f;
  t30_n217: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t30_n219;
  t30_n218: return 0.05509111285209656f;
  t30_n219: return -0.11555109918117523f;
  t30_n220: return -0.06553547084331512f;
  t30_n221: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t30_n223;
  t30_n222: return -0.14799654483795166f;
  t30_n223: if (E.getFractionNameInContext() >= 3199184816 /*0.343137264251709*/) goto t30_n225;
  t30_n224: return 0.007183616980910301f;
  t30_n225: return 0.032969165593385696f;
  t30_n226: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Symbol))) goto t30_n234;
  t30_n227: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t30_n229;
  t30_n228: return 0.05526537820696831f;
  t30_n229: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t30_n233;
  t30_n230: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t30_n232;
  t30_n231: return -0.0036995471455156803f;
  t30_n232: return 0.1182938888669014f;
  t30_n233: return 0.06582283973693848f;
  t30_n234: return 0.06192893162369728f;
  t30_n235: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t30_n245;
  t30_n236: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t30_n238;
  t30_n237: return 0.025752494111657143f;
  t30_n238: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t30_n242;
  t30_n239: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t30_n241;
  t30_n240: return -0.06514526158571243f;
  t30_n241: return 0.04849109426140785f;
  t30_n242: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t30_n244;
  t30_n243: return 0.057397447526454926f;
  t30_n244: return 0.09401583671569824f;
  t30_n245: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t30_n251;
  t30_n246: if (E.getNumReferences() >= 3337910528 /*31292.5*/) goto t30_n248;
  t30_n247: return 0.0452331118285656f;
  t30_n248: if (E.getNumReferences() >= 3338286080 /*32026.0*/) goto t30_n250;
  t30_n249: return 0.1367819756269455f;
  t30_n250: return 0.09052231907844543f;
  t30_n251: return 0.11291104555130005f;
  t30_n252: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t30_n254;
  t30_n253: return 0.06283742934465408f;
  t30_n254: return 0.07781297713518143f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree31(const Example& E) {
  t31_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t31_n250;
  t31_n1: if (E.getFractionNameInContext() >= 3189477818 /*0.15192309021949768*/) goto t31_n163;
  t31_n2: if (E.getNumReferences() >= 3369019008 /*424244.0*/) goto t31_n162;
  t31_n3: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t31_n83;
  t31_n4: if (E.getNumReferences() >= 3317122048 /*5864.5*/) goto t31_n68;
  t31_n5: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t31_n57;
  t31_n6: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t31_n20;
  t31_n7: if (E.getContextKind() & (BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t31_n17;
  t31_n8: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t31_n16;
  t31_n9: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t31_n11;
  t31_n10: return -0.015871193259954453f;
  t31_n11: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t31_n13;
  t31_n12: return 0.03794604912400246f;
  t31_n13: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t31_n15;
  t31_n14: return 0.07060610502958298f;
  t31_n15: return 0.11146526038646698f;
  t31_n16: return -0.04300956428050995f;
  t31_n17: if (E.getNumReferences() >= 3236954112 /*7.5*/) goto t31_n19;
  t31_n18: return -0.004992357920855284f;
  t31_n19: return 0.07271485775709152f;
  t31_n20: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t31_n44;
  t31_n21: if (E.getNumReferences() >= 3257008128 /*40.5*/) goto t31_n41;
  t31_n22: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t31_n36;
  t31_n23: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t31_n35;
  t31_n24: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t31_n34;
  t31_n25: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t31_n29;
  t31_n26: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t31_n28;
  t31_n27: return 0.0043676006607711315f;
  t31_n28: return -0.15059080719947815f;
  t31_n29: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t31_n31;
  t31_n30: return -0.07946015894412994f;
  t31_n31: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t31_n33;
  t31_n32: return -0.04446970298886299f;
  t31_n33: return 0.012537873350083828f;
  t31_n34: return 0.03861755132675171f;
  t31_n35: return -0.11752240359783173f;
  t31_n36: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol))) goto t31_n40;
  t31_n37: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t31_n39;
  t31_n38: return 0.0119274090975523f;
  t31_n39: return 0.09675638377666473f;
  t31_n40: return 0.08080832660198212f;
  t31_n41: if (E.getFractionNameInContext() >= 3180849535 /*0.07417582720518112*/) goto t31_n43;
  t31_n42: return 0.018453532829880714f;
  t31_n43: return 0.053265154361724854f;
  t31_n44: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t31_n56;
  t31_n45: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t31_n55;
  t31_n46: if (E.getNumReferences() >= 3275784192 /*192.5*/) goto t31_n54;
  t31_n47: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t31_n53;
  t31_n48: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t31_n52;
  t31_n49: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t31_n51;
  t31_n50: return 0.019129851832985878f;
  t31_n51: return 0.047907087951898575f;
  t31_n52: return -0.1262829303741455f;
  t31_n53: return 0.01871340535581112f;
  t31_n54: return 0.05809534713625908f;
  t31_n55: return -0.09731214493513107f;
  t31_n56: return 0.0862656682729721f;
  t31_n57: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol))) goto t31_n63;
  t31_n58: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t31_n60;
  t31_n59: return -0.3265455961227417f;
  t31_n60: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t31_n62;
  t31_n61: return 0.016937721520662308f;
  t31_n62: return -0.04993107542395592f;
  t31_n63: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t31_n67;
  t31_n64: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t31_n66;
  t31_n65: return 0.05896938964724541f;
  t31_n66: return 0.02242685668170452f;
  t31_n67: return 0.05818074196577072f;
  t31_n68: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t31_n78;
  t31_n69: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t31_n73;
  t31_n70: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t31_n72;
  t31_n71: return 0.04437659680843353f;
  t31_n72: return 0.07439224421977997f;
  t31_n73: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t31_n75;
  t31_n74: return 0.014671692624688148f;
  t31_n75: if (E.getNumReferences() >= 3361141760 /*220112.0*/) goto t31_n77;
  t31_n76: return 0.08386264741420746f;
  t31_n77: return -0.08215655386447906f;
  t31_n78: if (E.getNumReferences() >= 3318227968 /*6404.5*/) goto t31_n82;
  t31_n79: if (E.getNumReferences() >= 3317853184 /*6221.5*/) goto t31_n81;
  t31_n80: return 0.023732542991638184f;
  t31_n81: return 0.13343532383441925f;
  t31_n82: return 0.08271971344947815f;
  t31_n83: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t31_n151;
  t31_n84: if (E.getNumReferences() >= 3292913664 /*791.5*/) goto t31_n124;
  t31_n85: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t31_n113;
  t31_n86: if (E.getFractionNameInContext() >= 3146676277 /*0.004347825888544321*/) goto t31_n100;
  t31_n87: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t31_n99;
  t31_n88: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t31_n94;
  t31_n89: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t31_n93;
  t31_n90: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t31_n92;
  t31_n91: return -0.08483614772558212f;
  t31_n92: return -0.02033904567360878f;
  t31_n93: return -0.12143848091363907f;
  t31_n94: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type))) goto t31_n98;
  t31_n95: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t31_n97;
  t31_n96: return -0.019721131771802902f;
  t31_n97: return 0.03308212757110596f;
  t31_n98: return 0.030078331008553505f;
  t31_n99: return -0.08336486667394638f;
  t31_n100: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t31_n104;
  t31_n101: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t31_n103;
  t31_n102: return -0.04365561902523041f;
  t31_n103: return 0.02177293412387371f;
  t31_n104: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t31_n112;
  t31_n105: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t31_n107;
  t31_n106: return -0.0021798715461045504f;
  t31_n107: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t31_n109;
  t31_n108: return 0.015940839424729347f;
  t31_n109: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t31_n111;
  t31_n110: return -0.06260258704423904f;
  t31_n111: return 0.03996725380420685f;
  t31_n112: return 0.06589046865701675f;
  t31_n113: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t31_n123;
  t31_n114: if (E.getNumReferences() >= 3255173120 /*33.5*/) goto t31_n116;
  t31_n115: return -0.01608338952064514f;
  t31_n116: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t31_n120;
  t31_n117: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t31_n119;
  t31_n118: return 0.04505482316017151f;
  t31_n119: return 0.11402006447315216f;
  t31_n120: if (E.getNumReferences() >= 3287793664 /*495.5*/) goto t31_n122;
  t31_n121: return 0.09573016315698624f;
  t31_n122: return 0.13804307579994202f;
  t31_n123: return -0.08380501717329025f;
  t31_n124: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t31_n144;
  t31_n125: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t31_n127;
  t31_n126: return -0.02841862291097641f;
  t31_n127: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t31_n143;
  t31_n128: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t31_n140;
  t31_n129: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t31_n131;
  t31_n130: return 0.009568772278726101f;
  t31_n131: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t31_n135;
  t31_n132: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t31_n134;
  t31_n133: return -0.14580246806144714f;
  t31_n134: return 0.051132939755916595f;
  t31_n135: if (E.getNumReferences() >= 3362537216 /*241916.0*/) goto t31_n139;
  t31_n136: if (E.getNumReferences() >= 3346303232 /*62601.0*/) goto t31_n138;
  t31_n137: return 0.03952091559767723f;
  t31_n138: return 0.07927732169628143f;
  t31_n139: return -0.039945363998413086f;
  t31_n140: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t31_n142;
  t31_n141: return -0.066285140812397f;
  t31_n142: return 0.005361567251384258f;
  t31_n143: return 0.05120770260691643f;
  t31_n144: if (E.getNumReferences() >= 3345992448 /*61387.0*/) goto t31_n150;
  t31_n145: if (E.getNumReferences() >= 3345564672 /*59716.0*/) goto t31_n149;
  t31_n146: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t31_n148;
  t31_n147: return 0.06675709784030914f;
  t31_n148: return 0.012902600690722466f;
  t31_n149: return -0.5112839341163635f;
  t31_n150: return 0.06158776581287384f;
  t31_n151: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t31_n155;
  t31_n152: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t31_n154;
  t31_n153: return -0.0303091611713171f;
  t31_n154: return 0.04935561493039131f;
  t31_n155: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t31_n161;
  t31_n156: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t31_n160;
  t31_n157: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t31_n159;
  t31_n158: return -0.10197562724351883f;
  t31_n159: return 0.04735410585999489f;
  t31_n160: return 0.059180181473493576f;
  t31_n161: return -0.129667267203331f;
  t31_n162: return 0.07850899547338486f;
  t31_n163: if (E.getNumReferences() >= 3278405632 /*232.5*/) goto t31_n241;
  t31_n164: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t31_n230;
  t31_n165: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t31_n175;
  t31_n166: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t31_n168;
  t31_n167: return -0.03968057408928871f;
  t31_n168: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function))) goto t31_n170;
  t31_n169: return -0.02287527173757553f;
  t31_n170: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t31_n172;
  t31_n171: return 0.009697560220956802f;
  t31_n172: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t31_n174;
  t31_n173: return 0.016153480857610703f;
  t31_n174: return 0.04505108669400215f;
  t31_n175: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t31_n209;
  t31_n176: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t31_n196;
  t31_n177: if (E.getFileProximityDistanceCost() >= 3254517760 /*31.5*/) goto t31_n195;
  t31_n178: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t31_n180;
  t31_n179: return -0.023675406351685524f;
  t31_n180: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t31_n186;
  t31_n181: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t31_n185;
  t31_n182: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t31_n184;
  t31_n183: return 0.008630923926830292f;
  t31_n184: return 0.06475615501403809f;
  t31_n185: return 0.042475562542676926f;
  t31_n186: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t31_n188;
  t31_n187: return 0.020342355594038963f;
  t31_n188: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t31_n190;
  t31_n189: return -0.0896872729063034f;
  t31_n190: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t31_n192;
  t31_n191: return 0.03805159032344818f;
  t31_n192: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t31_n194;
  t31_n193: return 0.059022389352321625f;
  t31_n194: return -0.026219729334115982f;
  t31_n195: return 0.04962872713804245f;
  t31_n196: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t31_n202;
  t31_n197: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t31_n201;
  t31_n198: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t31_n200;
  t31_n199: return 0.0281737819314003f;
  t31_n200: return 0.05755442753434181f;
  t31_n201: return 0.08649983257055283f;
  t31_n202: if (E.getNumNameInContext() >= 3230662656 /*4.5*/) goto t31_n204;
  t31_n203: return 0.06251999735832214f;
  t31_n204: if (E.getNumReferences() >= 3258843136 /*47.5*/) goto t31_n206;
  t31_n205: return 0.10993747413158417f;
  t31_n206: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t31_n208;
  t31_n207: return 0.09678182750940323f;
  t31_n208: return 0.13064809143543243f;
  t31_n209: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t31_n229;
  t31_n210: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t31_n222;
  t31_n211: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t31_n213;
  t31_n212: return 0.013315653428435326f;
  t31_n213: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t31_n217;
  t31_n214: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t31_n216;
  t31_n215: return -0.12063969671726227f;
  t31_n216: return 0.04155013710260391f;
  t31_n217: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t31_n221;
  t31_n218: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t31_n220;
  t31_n219: return 0.026346173137426376f;
  t31_n220: return 0.06716059148311615f;
  t31_n221: return 0.08126100152730942f;
  t31_n222: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t31_n228;
  t31_n223: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t31_n227;
  t31_n224: if (E.getFileProximityDistanceCost() >= 3255566336 /*35.0*/) goto t31_n226;
  t31_n225: return 0.04257833585143089f;
  t31_n226: return 0.024861782789230347f;
  t31_n227: return 0.05660329386591911f;
  t31_n228: return 0.05070158839225769f;
  t31_n229: return 0.0071503836661577225f;
  t31_n230: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t31_n236;
  t31_n231: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t31_n235;
  t31_n232: if (E.getNumReferences() >= 3242721280 /*12.5*/) goto t31_n234;
  t31_n233: return 0.039511919021606445f;
  t31_n234: return 0.08900243788957596f;
  t31_n235: return 0.0005142244626767933f;
  t31_n236: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Symbol))) goto t31_n238;
  t31_n237: return 0.042724400758743286f;
  t31_n238: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t31_n240;
  t31_n239: return 0.044405922293663025f;
  t31_n240: return 0.08095543831586838f;
  t31_n241: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t31_n247;
  t31_n242: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t31_n244;
  t31_n243: return 0.06755217909812927f;
  t31_n244: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t31_n246;
  t31_n245: return 0.02956334315240383f;
  t31_n246: return 0.08490217477083206f;
  t31_n247: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t31_n249;
  t31_n248: return 0.04284221678972244f;
  t31_n249: return 0.07675749063491821f;
  t31_n250: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t31_n254;
  t31_n251: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t31_n253;
  t31_n252: return 0.05431217700242996f;
  t31_n253: return 0.0709424614906311f;
  t31_n254: return 0.09287775307893753f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree32(const Example& E) {
  t32_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t32_n252;
  t32_n1: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t32_n127;
  t32_n2: if (E.getNumReferences() >= 3326663680 /*12855.0*/) goto t32_n112;
  t32_n3: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t32_n41;
  t32_n4: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t32_n16;
  t32_n5: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t32_n9;
  t32_n6: if (E.getContextKind() & (BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t32_n8;
  t32_n7: return -0.025433171540498734f;
  t32_n8: return -0.007574731949716806f;
  t32_n9: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t32_n11;
  t32_n10: return -0.002793812658637762f;
  t32_n11: if (E.getNumReferences() >= 3317853184 /*6221.5*/) goto t32_n13;
  t32_n12: return 0.0262871365994215f;
  t32_n13: if (E.getNumReferences() >= 3318227968 /*6404.5*/) goto t32_n15;
  t32_n14: return 0.1323920339345932f;
  t32_n15: return 0.06142183765769005f;
  t32_n16: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_UnionTag))) goto t32_n30;
  t32_n17: if (E.getNumReferences() >= 3257008128 /*40.5*/) goto t32_n23;
  t32_n18: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t32_n20;
  t32_n19: return -0.005967851262539625f;
  t32_n20: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_Type))) goto t32_n22;
  t32_n21: return 0.014607377350330353f;
  t32_n22: return 0.06884945183992386f;
  t32_n23: if (E.getNumReferences() >= 3324926976 /*11159.0*/) goto t32_n29;
  t32_n24: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t32_n28;
  t32_n25: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t32_n27;
  t32_n26: return 0.05138380080461502f;
  t32_n27: return 0.019728241488337517f;
  t32_n28: return -0.020006824284791946f;
  t32_n29: return 0.1063934788107872f;
  t32_n30: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t32_n40;
  t32_n31: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t32_n39;
  t32_n32: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t32_n38;
  t32_n33: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t32_n37;
  t32_n34: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t32_n36;
  t32_n35: return 0.025251390412449837f;
  t32_n36: return 0.06277299672365189f;
  t32_n37: return 0.02055121399462223f;
  t32_n38: return -0.10052908957004547f;
  t32_n39: return 0.08812910318374634f;
  t32_n40: return -0.09211175888776779f;
  t32_n41: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t32_n111;
  t32_n42: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t32_n110;
  t32_n43: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t32_n47;
  t32_n44: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t32_n46;
  t32_n45: return 0.003224417567253113f;
  t32_n46: return 0.05489467456936836f;
  t32_n47: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t32_n109;
  t32_n48: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t32_n106;
  t32_n49: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t32_n105;
  t32_n50: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t32_n68;
  t32_n51: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t32_n53;
  t32_n52: return -0.04693494737148285f;
  t32_n53: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t32_n61;
  t32_n54: if (E.getFileProximityDistanceCost() >= 3244818432 /*14.5*/) goto t32_n60;
  t32_n55: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t32_n57;
  t32_n56: return -0.030010119080543518f;
  t32_n57: if (E.getFractionNameInContext() >= 3169944461 /*0.02948167361319065*/) goto t32_n59;
  t32_n58: return 0.003950499929487705f;
  t32_n59: return 0.06728505343198776f;
  t32_n60: return -0.08490835875272751f;
  t32_n61: if (E.getFileProximityDistanceCost() >= 3244818432 /*14.5*/) goto t32_n63;
  t32_n62: return -0.0016225090948864818f;
  t32_n63: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t32_n65;
  t32_n64: return -0.005540388636291027f;
  t32_n65: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t32_n67;
  t32_n66: return 0.02479381673038006f;
  t32_n67: return 0.06375989317893982f;
  t32_n68: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t32_n90;
  t32_n69: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t32_n73;
  t32_n70: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t32_n72;
  t32_n71: return -0.1574506014585495f;
  t32_n72: return -0.02173517644405365f;
  t32_n73: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t32_n89;
  t32_n74: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FunctionScope))) goto t32_n86;
  t32_n75: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t32_n79;
  t32_n76: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t32_n78;
  t32_n77: return -0.0009745062561705709f;
  t32_n78: return -0.08526100963354111f;
  t32_n79: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t32_n81;
  t32_n80: return 0.002393584232777357f;
  t32_n81: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t32_n83;
  t32_n82: return 0.1318207085132599f;
  t32_n83: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol))) goto t32_n85;
  t32_n84: return 0.03713025152683258f;
  t32_n85: return 0.09563842415809631f;
  t32_n86: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t32_n88;
  t32_n87: return 0.016307257115840912f;
  t32_n88: return 0.04876011237502098f;
  t32_n89: return -0.0651320368051529f;
  t32_n90: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t32_n92;
  t32_n91: return -0.049697376787662506f;
  t32_n92: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t32_n104;
  t32_n93: if (E.getFractionNameInContext() >= 3169944461 /*0.02948167361319065*/) goto t32_n95;
  t32_n94: return -0.030485359951853752f;
  t32_n95: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t32_n99;
  t32_n96: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t32_n98;
  t32_n97: return -0.11572805047035217f;
  t32_n98: return 0.08790314942598343f;
  t32_n99: if (E.getFileProximityDistanceCost() >= 3247177728 /*17.5*/) goto t32_n101;
  t32_n100: return -0.18547776341438293f;
  t32_n101: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t32_n103;
  t32_n102: return 0.07626546919345856f;
  t32_n103: return 0.032237708568573f;
  t32_n104: return 0.03727389872074127f;
  t32_n105: return -0.12174712121486664f;
  t32_n106: if (E.getNumReferences() >= 3288997888 /*552.5*/) goto t32_n108;
  t32_n107: return -0.0704488530755043f;
  t32_n108: return 0.00013735098764300346f;
  t32_n109: return 0.035673242062330246f;
  t32_n110: return -0.06792878359556198f;
  t32_n111: return 0.005053394939750433f;
  t32_n112: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t32_n122;
  t32_n113: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t32_n117;
  t32_n114: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t32_n116;
  t32_n115: return 0.03069232404232025f;
  t32_n116: return 0.0676826685667038f;
  t32_n117: if (E.getNumReferences() >= 3360228064 /*205835.5*/) goto t32_n121;
  t32_n118: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t32_n120;
  t32_n119: return 0.07420697808265686f;
  t32_n120: return 0.11696656793355942f;
  t32_n121: return 0.0774284154176712f;
  t32_n122: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t32_n126;
  t32_n123: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t32_n125;
  t32_n124: return 0.0017446177080273628f;
  t32_n125: return 0.06838768720626831f;
  t32_n126: return 0.052662745118141174f;
  t32_n127: if (E.getNumReferences() >= 3302404096 /*1717.5*/) goto t32_n239;
  t32_n128: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t32_n176;
  t32_n129: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t32_n171;
  t32_n130: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t32_n168;
  t32_n131: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t32_n163;
  t32_n132: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t32_n136;
  t32_n133: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t32_n135;
  t32_n134: return 0.02116810716688633f;
  t32_n135: return 0.04782012850046158f;
  t32_n136: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t32_n140;
  t32_n137: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t32_n139;
  t32_n138: return 0.004547476302832365f;
  t32_n139: return -0.08342328667640686f;
  t32_n140: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t32_n142;
  t32_n141: return -0.10680737346410751f;
  t32_n142: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t32_n146;
  t32_n143: if (E.getNumReferences() >= 3260153856 /*52.5*/) goto t32_n145;
  t32_n144: return 0.030850153416395187f;
  t32_n145: return 0.075289785861969f;
  t32_n146: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t32_n162;
  t32_n147: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t32_n149;
  t32_n148: return -0.0023279651068150997f;
  t32_n149: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t32_n161;
  t32_n150: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t32_n152;
  t32_n151: return 0.007910139858722687f;
  t32_n152: if (E.getFileProximityDistanceCost() >= 3248750592 /*20.5*/) goto t32_n156;
  t32_n153: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion))) goto t32_n155;
  t32_n154: return 0.03544469550251961f;
  t32_n155: return 0.08271973580121994f;
  t32_n156: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t32_n160;
  t32_n157: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t32_n159;
  t32_n158: return -0.0013123888056725264f;
  t32_n159: return 0.08458434045314789f;
  t32_n160: return -0.09985116869211197f;
  t32_n161: return -0.0800049677491188f;
  t32_n162: return 0.0744016245007515f;
  t32_n163: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t32_n165;
  t32_n164: return -0.04602662846446037f;
  t32_n165: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t32_n167;
  t32_n166: return 0.022960321977734566f;
  t32_n167: return -0.012764731422066689f;
  t32_n168: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t32_n170;
  t32_n169: return 0.02633214369416237f;
  t32_n170: return -0.10444667190313339f;
  t32_n171: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t32_n175;
  t32_n172: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t32_n174;
  t32_n173: return 0.011815586127340794f;
  t32_n174: return 0.04415002837777138f;
  t32_n175: return 0.05819724500179291f;
  t32_n176: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t32_n178;
  t32_n177: return -0.022255809977650642f;
  t32_n178: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t32_n198;
  t32_n179: if (E.getFractionNameInContext() >= 3197638680 /*0.2970588207244873*/) goto t32_n187;
  t32_n180: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t32_n182;
  t32_n181: return 0.011223805136978626f;
  t32_n182: if (E.getContextKind() & (BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel))) goto t32_n184;
  t32_n183: return 0.004582082852721214f;
  t32_n184: if (E.getSymbolScopeDistanceCost() >= 3221225472 /*2.0*/) goto t32_n186;
  t32_n185: return 0.08025812357664108f;
  t32_n186: return 0.028621966019272804f;
  t32_n187: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t32_n195;
  t32_n188: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t32_n194;
  t32_n189: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t32_n193;
  t32_n190: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t32_n192;
  t32_n191: return 0.03200753033161163f;
  t32_n192: return -0.006367719732224941f;
  t32_n193: return 0.04678735136985779f;
  t32_n194: return 0.04996670410037041f;
  t32_n195: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t32_n197;
  t32_n196: return 0.05350644886493683f;
  t32_n197: return 0.08684835582971573f;
  t32_n198: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t32_n238;
  t32_n199: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t32_n233;
  t32_n200: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t32_n232;
  t32_n201: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t32_n231;
  t32_n202: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t32_n220;
  t32_n203: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t32_n209;
  t32_n204: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t32_n206;
  t32_n205: return 0.006248227320611477f;
  t32_n206: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_ParenthesizedExpression))) goto t32_n208;
  t32_n207: return 0.01640472374856472f;
  t32_n208: return 0.040019452571868896f;
  t32_n209: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t32_n219;
  t32_n210: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t32_n218;
  t32_n211: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t32_n213;
  t32_n212: return -0.02199694514274597f;
  t32_n213: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t32_n215;
  t32_n214: return -0.014408871531486511f;
  t32_n215: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t32_n217;
  t32_n216: return 0.046629346907138824f;
  t32_n217: return 0.08078368008136749f;
  t32_n218: return 0.03707560896873474f;
  t32_n219: return 0.05319524556398392f;
  t32_n220: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t32_n224;
  t32_n221: if (E.getFileProximityDistanceCost() >= 3252158464 /*27.0*/) goto t32_n223;
  t32_n222: return 0.042507730424404144f;
  t32_n223: return -0.050040796399116516f;
  t32_n224: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t32_n226;
  t32_n225: return -0.05597410351037979f;
  t32_n226: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t32_n228;
  t32_n227: return 0.04865969344973564f;
  t32_n228: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Symbol))) goto t32_n230;
  t32_n229: return 0.07758935540914536f;
  t32_n230: return 0.09569396078586578f;
  t32_n231: return 0.04438488185405731f;
  t32_n232: return -0.10627920925617218f;
  t32_n233: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t32_n235;
  t32_n234: return -0.07579398155212402f;
  t32_n235: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t32_n237;
  t32_n236: return -0.03778025135397911f;
  t32_n237: return 0.03919453173875809f;
  t32_n238: return 0.05950223654508591f;
  t32_n239: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t32_n249;
  t32_n240: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t32_n242;
  t32_n241: return 0.02255702018737793f;
  t32_n242: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t32_n246;
  t32_n243: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t32_n245;
  t32_n244: return -0.05873020738363266f;
  t32_n245: return 0.04534343630075455f;
  t32_n246: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t32_n248;
  t32_n247: return 0.0541410893201828f;
  t32_n248: return 0.09004807472229004f;
  t32_n249: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t32_n251;
  t32_n250: return 0.07162114977836609f;
  t32_n251: return 0.11082888394594193f;
  t32_n252: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t32_n254;
  t32_n253: return 0.06238105893135071f;
  t32_n254: return 0.0911487489938736f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree33(const Example& E) {
  t33_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t33_n252;
  t33_n1: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t33_n113;
  t33_n2: if (E.getNumReferences() >= 3326663680 /*12855.0*/) goto t33_n90;
  t33_n3: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t33_n67;
  t33_n4: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t33_n42;
  t33_n5: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t33_n35;
  t33_n6: if (E.getContextKind() & (BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t33_n24;
  t33_n7: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t33_n23;
  t33_n8: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t33_n18;
  t33_n9: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t33_n13;
  t33_n10: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t33_n12;
  t33_n11: return -0.12175574153661728f;
  t33_n12: return -0.04076904430985451f;
  t33_n13: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t33_n17;
  t33_n14: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t33_n16;
  t33_n15: return 0.005826680455356836f;
  t33_n16: return -0.15612958371639252f;
  t33_n17: return -0.04758225008845329f;
  t33_n18: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t33_n20;
  t33_n19: return 0.03595619648694992f;
  t33_n20: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol))) goto t33_n22;
  t33_n21: return 0.0579693429172039f;
  t33_n22: return 0.11195779591798782f;
  t33_n23: return -0.03634306415915489f;
  t33_n24: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t33_n26;
  t33_n25: return -0.0912558063864708f;
  t33_n26: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t33_n30;
  t33_n27: if (E.getNumReferences() >= 3244818432 /*14.5*/) goto t33_n29;
  t33_n28: return 2.6864781830227003e-06f;
  t33_n29: return 0.07785079628229141f;
  t33_n30: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t33_n34;
  t33_n31: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t33_n33;
  t33_n32: return -0.008677436038851738f;
  t33_n33: return 0.03165026754140854f;
  t33_n34: return 0.04124071076512337f;
  t33_n35: if (E.getNumReferences() >= 3317853184 /*6221.5*/) goto t33_n39;
  t33_n36: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t33_n38;
  t33_n37: return -0.002155431779101491f;
  t33_n38: return 0.02432139962911606f;
  t33_n39: if (E.getNumReferences() >= 3318227968 /*6404.5*/) goto t33_n41;
  t33_n40: return 0.13143736124038696f;
  t33_n41: return 0.062478289008140564f;
  t33_n42: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_UnionTag))) goto t33_n58;
  t33_n43: if (E.getNumReferences() >= 3324926976 /*11159.0*/) goto t33_n57;
  t33_n44: if (E.getNumReferences() >= 3250323456 /*23.5*/) goto t33_n54;
  t33_n45: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t33_n51;
  t33_n46: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t33_n50;
  t33_n47: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t33_n49;
  t33_n48: return -0.01202970091253519f;
  t33_n49: return 0.015089817345142365f;
  t33_n50: return -0.05465606227517128f;
  t33_n51: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t33_n53;
  t33_n52: return 0.009805376641452312f;
  t33_n53: return -0.11056502908468246f;
  t33_n54: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t33_n56;
  t33_n55: return 0.02547796443104744f;
  t33_n56: return -0.02018129825592041f;
  t33_n57: return 0.1046493649482727f;
  t33_n58: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t33_n66;
  t33_n59: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t33_n65;
  t33_n60: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t33_n64;
  t33_n61: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_UnionTag))) goto t33_n63;
  t33_n62: return 0.016295718029141426f;
  t33_n63: return 0.026506666094064713f;
  t33_n64: return -0.10100885480642319f;
  t33_n65: return -0.09039565175771713f;
  t33_n66: return 0.08224193006753922f;
  t33_n67: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t33_n83;
  t33_n68: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t33_n74;
  t33_n69: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t33_n71;
  t33_n70: return -0.09097080677747726f;
  t33_n71: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t33_n73;
  t33_n72: return -0.01818476989865303f;
  t33_n73: return -0.11667662858963013f;
  t33_n74: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t33_n80;
  t33_n75: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t33_n77;
  t33_n76: return -0.06181420758366585f;
  t33_n77: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_UnionTag))) goto t33_n79;
  t33_n78: return -0.0006392320501618087f;
  t33_n79: return 0.07585887610912323f;
  t33_n80: if (E.getNumReferences() >= 3293372416 /*819.5*/) goto t33_n82;
  t33_n81: return -0.0897437110543251f;
  t33_n82: return -0.012227202765643597f;
  t33_n83: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t33_n89;
  t33_n84: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t33_n88;
  t33_n85: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t33_n87;
  t33_n86: return 0.014405899681150913f;
  t33_n87: return -0.09925343841314316f;
  t33_n88: return -0.10219266265630722f;
  t33_n89: return -0.07968942075967789f;
  t33_n90: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t33_n106;
  t33_n91: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t33_n105;
  t33_n92: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t33_n104;
  t33_n93: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t33_n103;
  t33_n94: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t33_n100;
  t33_n95: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t33_n99;
  t33_n96: if (E.getNumReferences() >= 3329227264 /*15358.5*/) goto t33_n98;
  t33_n97: return 0.13145677745342255f;
  t33_n98: return 0.015942417085170746f;
  t33_n99: return 0.06519461423158646f;
  t33_n100: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t33_n102;
  t33_n101: return -0.11253321915864944f;
  t33_n102: return 0.0504574216902256f;
  t33_n103: return 0.012387664057314396f;
  t33_n104: return 0.07812011241912842f;
  t33_n105: return 0.08100694417953491f;
  t33_n106: if (E.getNumReferences() >= 3376956888 /*820317.5*/) goto t33_n112;
  t33_n107: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t33_n111;
  t33_n108: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t33_n110;
  t33_n109: return 3.11071053147316e-05f;
  t33_n110: return 0.04695973917841911f;
  t33_n111: return 0.06597568094730377f;
  t33_n112: return 0.06702791899442673f;
  t33_n113: if (E.getNumReferences() >= 3292798976 /*784.5*/) goto t33_n243;
  t33_n114: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t33_n192;
  t33_n115: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t33_n185;
  t33_n116: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t33_n154;
  t33_n117: if (E.getNumReferences() >= 3255173120 /*33.5*/) goto t33_n151;
  t33_n118: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t33_n148;
  t33_n119: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t33_n135;
  t33_n120: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t33_n134;
  t33_n121: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t33_n133;
  t33_n122: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t33_n130;
  t33_n123: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t33_n127;
  t33_n124: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t33_n126;
  t33_n125: return -0.17409683763980865f;
  t33_n126: return -0.10949891060590744f;
  t33_n127: if (E.getFileProximityDistanceCost() >= 3251896320 /*26.5*/) goto t33_n129;
  t33_n128: return -0.005879647098481655f;
  t33_n129: return 0.04265758395195007f;
  t33_n130: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t33_n132;
  t33_n131: return 0.008275886997580528f;
  t33_n132: return -0.08490685373544693f;
  t33_n133: return 0.07703462243080139f;
  t33_n134: return -0.08199869096279144f;
  t33_n135: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t33_n137;
  t33_n136: return -0.028339318931102753f;
  t33_n137: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t33_n145;
  t33_n138: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t33_n144;
  t33_n139: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t33_n141;
  t33_n140: return 0.01928507536649704f;
  t33_n141: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t33_n143;
  t33_n142: return 0.020267551764845848f;
  t33_n143: return 0.04688533768057823f;
  t33_n144: return -0.024786505848169327f;
  t33_n145: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t33_n147;
  t33_n146: return 0.01810513436794281f;
  t33_n147: return 0.05461912229657173f;
  t33_n148: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t33_n150;
  t33_n149: return 0.027314554899930954f;
  t33_n150: return -0.10234981030225754f;
  t33_n151: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t33_n153;
  t33_n152: return 0.03916846215724945f;
  t33_n153: return 0.05445679649710655f;
  t33_n154: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t33_n184;
  t33_n155: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t33_n183;
  t33_n156: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t33_n176;
  t33_n157: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t33_n175;
  t33_n158: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t33_n160;
  t33_n159: return -0.003240457270294428f;
  t33_n160: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t33_n162;
  t33_n161: return 0.0008328019175678492f;
  t33_n162: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t33_n174;
  t33_n163: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t33_n173;
  t33_n164: if (E.getSymbolScopeDistanceCost() >= 3246915584 /*17.0*/) goto t33_n166;
  t33_n165: return -0.07714113593101501f;
  t33_n166: if (E.getFileProximityDistanceCost() >= 3248750592 /*20.5*/) goto t33_n170;
  t33_n167: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t33_n169;
  t33_n168: return 0.07171369343996048f;
  t33_n169: return -0.03564215078949928f;
  t33_n170: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t33_n172;
  t33_n171: return 0.06983990222215652f;
  t33_n172: return 0.07971078157424927f;
  t33_n173: return -0.0732477605342865f;
  t33_n174: return -0.03878169134259224f;
  t33_n175: return 0.04654564708471298f;
  t33_n176: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t33_n182;
  t33_n177: if (E.getNumReferences() >= 3238526976 /*8.5*/) goto t33_n179;
  t33_n178: return -0.01975932903587818f;
  t33_n179: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t33_n181;
  t33_n180: return 0.06166255101561546f;
  t33_n181: return 0.1297113448381424f;
  t33_n182: return -0.06427007913589478f;
  t33_n183: return -0.0820629894733429f;
  t33_n184: return 0.03810277581214905f;
  t33_n185: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t33_n191;
  t33_n186: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t33_n190;
  t33_n187: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t33_n189;
  t33_n188: return 0.04763873666524887f;
  t33_n189: return -0.0022695926018059254f;
  t33_n190: return 0.040864668786525726f;
  t33_n191: return 0.05600574612617493f;
  t33_n192: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t33_n194;
  t33_n193: return -0.0191775131970644f;
  t33_n194: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t33_n230;
  t33_n195: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t33_n225;
  t33_n196: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t33_n204;
  t33_n197: if (E.getNumReferences() >= 3255173120 /*33.5*/) goto t33_n203;
  t33_n198: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t33_n200;
  t33_n199: return 0.017872275784611702f;
  t33_n200: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol))) goto t33_n202;
  t33_n201: return 0.009535695426166058f;
  t33_n202: return 0.03730694204568863f;
  t33_n203: return 0.05151539668440819f;
  t33_n204: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t33_n224;
  t33_n205: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t33_n209;
  t33_n206: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t33_n208;
  t33_n207: return 0.0451677180826664f;
  t33_n208: return 0.06493972986936569f;
  t33_n209: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Variable))) goto t33_n215;
  t33_n210: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t33_n212;
  t33_n211: return 0.024302620440721512f;
  t33_n212: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_Type))) goto t33_n214;
  t33_n213: return 0.03178567439317703f;
  t33_n214: return 0.0478428453207016f;
  t33_n215: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t33_n223;
  t33_n216: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t33_n218;
  t33_n217: return -0.020066142082214355f;
  t33_n218: if (E.getSymbolScopeDistanceCost() >= 3221225472 /*2.0*/) goto t33_n220;
  t33_n219: return 0.07011142373085022f;
  t33_n220: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t33_n222;
  t33_n221: return 0.01788417063653469f;
  t33_n222: return 0.048015691339969635f;
  t33_n223: return 0.07333295792341232f;
  t33_n224: return -0.059132251888513565f;
  t33_n225: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t33_n227;
  t33_n226: return -0.14348652958869934f;
  t33_n227: if (E.getFractionNameInContext() >= 3199184816 /*0.343137264251709*/) goto t33_n229;
  t33_n228: return 0.0054922266863286495f;
  t33_n229: return 0.03075670450925827f;
  t33_n230: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Symbol))) goto t33_n240;
  t33_n231: if (E.getFileProximityDistanceCost() >= 3244818432 /*14.5*/) goto t33_n233;
  t33_n232: return 0.05044933408498764f;
  t33_n233: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t33_n239;
  t33_n234: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t33_n238;
  t33_n235: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t33_n237;
  t33_n236: return -0.0338645875453949f;
  t33_n237: return 0.05384417995810509f;
  t33_n238: return 0.11450212448835373f;
  t33_n239: return 0.059937722980976105f;
  t33_n240: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t33_n242;
  t33_n241: return 0.04596750810742378f;
  t33_n242: return 0.07501328736543655f;
  t33_n243: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t33_n251;
  t33_n244: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t33_n246;
  t33_n245: return 0.022834522649645805f;
  t33_n246: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t33_n248;
  t33_n247: return 0.02454250305891037f;
  t33_n248: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t33_n250;
  t33_n249: return 0.051524706184864044f;
  t33_n250: return 0.08442248404026031f;
  t33_n251: return 0.07035399228334427f;
  t33_n252: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t33_n254;
  t33_n253: return 0.05507612228393555f;
  t33_n254: return 0.07183859497308731f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree34(const Example& E) {
  t34_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t34_n252;
  t34_n1: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t34_n117;
  t34_n2: if (E.getNumReferences() >= 3359104096 /*188273.5*/) goto t34_n98;
  t34_n3: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t34_n89;
  t34_n4: if (E.getNumReferences() >= 3308636160 /*2908.5*/) goto t34_n84;
  t34_n5: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t34_n33;
  t34_n6: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t34_n32;
  t34_n7: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t34_n23;
  t34_n8: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t34_n12;
  t34_n9: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t34_n11;
  t34_n10: return -0.13979223370552063f;
  t34_n11: return -0.10978157818317413f;
  t34_n12: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t34_n22;
  t34_n13: if (E.getNumReferences() >= 3240624128 /*10.5*/) goto t34_n19;
  t34_n14: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t34_n16;
  t34_n15: return -0.057705070823431015f;
  t34_n16: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t34_n18;
  t34_n17: return -0.022495103999972343f;
  t34_n18: return 0.0239657424390316f;
  t34_n19: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t34_n21;
  t34_n20: return 0.061083417385816574f;
  t34_n21: return 0.0008640990126878023f;
  t34_n22: return 0.04695865139365196f;
  t34_n23: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t34_n31;
  t34_n24: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t34_n30;
  t34_n25: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t34_n29;
  t34_n26: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t34_n28;
  t34_n27: return -0.11897297203540802f;
  t34_n28: return 0.11270076036453247f;
  t34_n29: return 0.008437794633209705f;
  t34_n30: return -0.1467464566230774f;
  t34_n31: return -0.0811101421713829f;
  t34_n32: return -0.05143105983734131f;
  t34_n33: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t34_n35;
  t34_n34: return -0.09050822257995605f;
  t34_n35: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t34_n75;
  t34_n36: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t34_n74;
  t34_n37: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t34_n69;
  t34_n38: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t34_n62;
  t34_n39: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t34_n41;
  t34_n40: return -0.026268677785992622f;
  t34_n41: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t34_n47;
  t34_n42: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t34_n44;
  t34_n43: return 0.018174001947045326f;
  t34_n44: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t34_n46;
  t34_n45: return 0.028556067496538162f;
  t34_n46: return 0.08816750347614288f;
  t34_n47: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t34_n53;
  t34_n48: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t34_n50;
  t34_n49: return 0.0047701275907456875f;
  t34_n50: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t34_n52;
  t34_n51: return 0.02348346635699272f;
  t34_n52: return 0.06210104003548622f;
  t34_n53: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t34_n61;
  t34_n54: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::GlobalScope))) goto t34_n56;
  t34_n55: return 0.001589955179952085f;
  t34_n56: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t34_n60;
  t34_n57: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t34_n59;
  t34_n58: return -0.09493313729763031f;
  t34_n59: return 0.04297884181141853f;
  t34_n60: return 0.058596547693014145f;
  t34_n61: return -0.0848858654499054f;
  t34_n62: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t34_n64;
  t34_n63: return -0.022209366783499718f;
  t34_n64: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t34_n68;
  t34_n65: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t34_n67;
  t34_n66: return -0.006056469865143299f;
  t34_n67: return 0.04985922574996948f;
  t34_n68: return 0.07092997431755066f;
  t34_n69: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t34_n71;
  t34_n70: return -0.08001022040843964f;
  t34_n71: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t34_n73;
  t34_n72: return 0.020191194489598274f;
  t34_n73: return 0.08829309791326523f;
  t34_n74: return -0.09762012958526611f;
  t34_n75: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t34_n79;
  t34_n76: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t34_n78;
  t34_n77: return 0.0028617980424314737f;
  t34_n78: return 0.03628191351890564f;
  t34_n79: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t34_n81;
  t34_n80: return 0.05009978264570236f;
  t34_n81: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t34_n83;
  t34_n82: return -0.02947591245174408f;
  t34_n83: return 0.04609984904527664f;
  t34_n84: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t34_n88;
  t34_n85: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t34_n87;
  t34_n86: return 0.04286125302314758f;
  t34_n87: return 0.015704365447163582f;
  t34_n88: return 0.06271465867757797f;
  t34_n89: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t34_n91;
  t34_n90: return -0.026277726516127586f;
  t34_n91: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t34_n97;
  t34_n92: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t34_n96;
  t34_n93: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t34_n95;
  t34_n94: return 0.013408105820417404f;
  t34_n95: return -0.08287939429283142f;
  t34_n96: return -0.09439411759376526f;
  t34_n97: return -0.07635243982076645f;
  t34_n98: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t34_n104;
  t34_n99: if (E.getNumReferences() >= 3360228064 /*205835.5*/) goto t34_n103;
  t34_n100: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t34_n102;
  t34_n101: return 0.07198544591665268f;
  t34_n102: return 0.11539303511381149f;
  t34_n103: return 0.07414313405752182f;
  t34_n104: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t34_n116;
  t34_n105: if (E.getNumReferences() >= 3362537216 /*241916.0*/) goto t34_n107;
  t34_n106: return 0.05622943118214607f;
  t34_n107: if (E.getNumReferences() >= 3363960080 /*266152.5*/) goto t34_n109;
  t34_n108: return -0.1549025923013687f;
  t34_n109: if (E.getNumReferences() >= 3364158064 /*272339.5*/) goto t34_n115;
  t34_n110: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t34_n112;
  t34_n111: return -0.14888006448745728f;
  t34_n112: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t34_n114;
  t34_n113: return 0.0723169595003128f;
  t34_n114: return 0.10509346425533295f;
  t34_n115: return -0.012238109484314919f;
  t34_n116: return 0.06720864027738571f;
  t34_n117: if (E.getNumReferences() >= 3292798976 /*784.5*/) goto t34_n243;
  t34_n118: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t34_n200;
  t34_n119: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t34_n195;
  t34_n120: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t34_n160;
  t34_n121: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t34_n159;
  t34_n122: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t34_n142;
  t34_n123: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t34_n141;
  t34_n124: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t34_n140;
  t34_n125: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t34_n133;
  t34_n126: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t34_n130;
  t34_n127: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t34_n129;
  t34_n128: return -0.18208061158657074f;
  t34_n129: return -0.10577019304037094f;
  t34_n130: if (E.getFileProximityDistanceCost() >= 3255042048 /*33.0*/) goto t34_n132;
  t34_n131: return -0.007594272959977388f;
  t34_n132: return 0.046160101890563965f;
  t34_n133: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t34_n139;
  t34_n134: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t34_n138;
  t34_n135: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t34_n137;
  t34_n136: return -0.11642000079154968f;
  t34_n137: return 0.09949857741594315f;
  t34_n138: return 0.011085662059485912f;
  t34_n139: return -0.0789208710193634f;
  t34_n140: return 0.07792055606842041f;
  t34_n141: return -0.0794069841504097f;
  t34_n142: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t34_n144;
  t34_n143: return -0.028236130252480507f;
  t34_n144: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t34_n156;
  t34_n145: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t34_n155;
  t34_n146: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t34_n154;
  t34_n147: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t34_n151;
  t34_n148: if (E.getFractionNameInContext() >= 3194381926 /*0.22499999403953552*/) goto t34_n150;
  t34_n149: return 0.017896903678774834f;
  t34_n150: return 0.03983793035149574f;
  t34_n151: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t34_n153;
  t34_n152: return 0.022466203197836876f;
  t34_n153: return 0.04899481311440468f;
  t34_n154: return -0.018794404342770576f;
  t34_n155: return -0.00839778408408165f;
  t34_n156: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t34_n158;
  t34_n157: return 0.020696556195616722f;
  t34_n158: return 0.05510292574763298f;
  t34_n159: return 0.03983599692583084f;
  t34_n160: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t34_n168;
  t34_n161: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t34_n165;
  t34_n162: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t34_n164;
  t34_n163: return -0.0444624163210392f;
  t34_n164: return -0.02159486711025238f;
  t34_n165: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t34_n167;
  t34_n166: return 0.020078329369425774f;
  t34_n167: return -0.23920340836048126f;
  t34_n168: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t34_n192;
  t34_n169: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t34_n189;
  t34_n170: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t34_n174;
  t34_n171: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t34_n173;
  t34_n172: return -0.013202021829783916f;
  t34_n173: return 0.012304096482694149f;
  t34_n174: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t34_n188;
  t34_n175: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t34_n177;
  t34_n176: return -0.0752284973859787f;
  t34_n177: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t34_n187;
  t34_n178: if (E.getSymbolScopeDistanceCost() >= 3246915584 /*17.0*/) goto t34_n180;
  t34_n179: return 0.008831041865050793f;
  t34_n180: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t34_n186;
  t34_n181: if (E.getFileProximityDistanceCost() >= 3248750592 /*20.5*/) goto t34_n185;
  t34_n182: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t34_n184;
  t34_n183: return 0.071070596575737f;
  t34_n184: return -0.03201868757605553f;
  t34_n185: return 0.07930006831884384f;
  t34_n186: return -0.007254859898239374f;
  t34_n187: return -0.08448418974876404f;
  t34_n188: return -0.08270088583230972f;
  t34_n189: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t34_n191;
  t34_n190: return -0.4506841003894806f;
  t34_n191: return 0.05737049877643585f;
  t34_n192: if (E.getContextKind() & (BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel))) goto t34_n194;
  t34_n193: return -0.008243480697274208f;
  t34_n194: return 0.05522102117538452f;
  t34_n195: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t34_n199;
  t34_n196: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t34_n198;
  t34_n197: return 0.01002114824950695f;
  t34_n198: return 0.039024803787469864f;
  t34_n199: return 0.05393816903233528f;
  t34_n200: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t34_n202;
  t34_n201: return -0.015002305619418621f;
  t34_n202: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t34_n232;
  t34_n203: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t34_n227;
  t34_n204: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t34_n218;
  t34_n205: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t34_n211;
  t34_n206: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t34_n208;
  t34_n207: return 0.011836130172014236f;
  t34_n208: if (E.getNumReferences() >= 3252420608 /*27.5*/) goto t34_n210;
  t34_n209: return 0.017811404541134834f;
  t34_n210: return 0.06709031760692596f;
  t34_n211: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t34_n217;
  t34_n212: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t34_n216;
  t34_n213: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t34_n215;
  t34_n214: return 0.024412008002400398f;
  t34_n215: return 0.06612809747457504f;
  t34_n216: return 0.05278582498431206f;
  t34_n217: return 0.04044632986187935f;
  t34_n218: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t34_n226;
  t34_n219: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t34_n221;
  t34_n220: return 0.04616950824856758f;
  t34_n221: if (E.getNumReferences() >= 3251896320 /*26.5*/) goto t34_n225;
  t34_n222: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t34_n224;
  t34_n223: return 0.030580587685108185f;
  t34_n224: return 0.07730386406183243f;
  t34_n225: return 0.068732351064682f;
  t34_n226: return -0.057809196412563324f;
  t34_n227: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t34_n229;
  t34_n228: return -0.14042073488235474f;
  t34_n229: if (E.getFractionNameInContext() >= 3199184816 /*0.343137264251709*/) goto t34_n231;
  t34_n230: return 0.005672418978065252f;
  t34_n231: return 0.030063925310969353f;
  t34_n232: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Symbol))) goto t34_n240;
  t34_n233: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t34_n235;
  t34_n234: return 0.048850830644369125f;
  t34_n235: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t34_n239;
  t34_n236: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t34_n238;
  t34_n237: return -0.0016680924454703927f;
  t34_n238: return 0.10931283235549927f;
  t34_n239: return 0.057586535811424255f;
  t34_n240: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t34_n242;
  t34_n241: return 0.04272296652197838f;
  t34_n242: return 0.07494264096021652f;
  t34_n243: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t34_n251;
  t34_n244: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t34_n246;
  t34_n245: return 0.021434186026453972f;
  t34_n246: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t34_n248;
  t34_n247: return 0.023309938609600067f;
  t34_n248: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t34_n250;
  t34_n249: return 0.04909480735659599f;
  t34_n250: return 0.08214148879051208f;
  t34_n251: return 0.06867145001888275f;
  t34_n252: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t34_n254;
  t34_n253: return 0.052966732531785965f;
  t34_n254: return 0.06974685937166214f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree35(const Example& E) {
  t35_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t35_n250;
  t35_n1: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t35_n109;
  t35_n2: if (E.getNumReferences() >= 3325353472 /*11575.5*/) goto t35_n94;
  t35_n3: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t35_n71;
  t35_n4: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t35_n24;
  t35_n5: if (E.getNumReferences() >= 3257008128 /*40.5*/) goto t35_n21;
  t35_n6: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type))) goto t35_n8;
  t35_n7: return -0.04010966420173645f;
  t35_n8: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t35_n20;
  t35_n9: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t35_n19;
  t35_n10: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t35_n18;
  t35_n11: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t35_n17;
  t35_n12: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t35_n16;
  t35_n13: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t35_n15;
  t35_n14: return -0.01916283182799816f;
  t35_n15: return 0.02767273783683777f;
  t35_n16: return 0.004888914525508881f;
  t35_n17: return -0.04320479556918144f;
  t35_n18: return -0.13595302402973175f;
  t35_n19: return -0.08454163372516632f;
  t35_n20: return 0.06486214697360992f;
  t35_n21: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t35_n23;
  t35_n22: return 0.06714434921741486f;
  t35_n23: return 0.012616646476089954f;
  t35_n24: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t35_n26;
  t35_n25: return -0.08887531608343124f;
  t35_n26: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t35_n60;
  t35_n27: if (E.getNumReferences() >= 3271098368 /*124.5*/) goto t35_n59;
  t35_n28: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t35_n58;
  t35_n29: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t35_n51;
  t35_n30: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t35_n50;
  t35_n31: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t35_n49;
  t35_n32: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t35_n42;
  t35_n33: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t35_n37;
  t35_n34: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t35_n36;
  t35_n35: return 0.01378543395549059f;
  t35_n36: return 0.04978173226118088f;
  t35_n37: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t35_n39;
  t35_n38: return -0.0003435408289078623f;
  t35_n39: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t35_n41;
  t35_n40: return 0.015557238832116127f;
  t35_n41: return 0.0596640408039093f;
  t35_n42: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t35_n44;
  t35_n43: return 0.0022975034080445766f;
  t35_n44: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t35_n48;
  t35_n45: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t35_n47;
  t35_n46: return -0.09560805559158325f;
  t35_n47: return 0.03957536444067955f;
  t35_n48: return 0.052630916237831116f;
  t35_n49: return -0.08436673134565353f;
  t35_n50: return -0.014264368452131748f;
  t35_n51: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t35_n53;
  t35_n52: return -0.06481462717056274f;
  t35_n53: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t35_n57;
  t35_n54: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t35_n56;
  t35_n55: return 0.01961001753807068f;
  t35_n56: return -0.07740701735019684f;
  t35_n57: return 0.08710569143295288f;
  t35_n58: return -0.09554161876440048f;
  t35_n59: return 0.038215138018131256f;
  t35_n60: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t35_n66;
  t35_n61: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t35_n65;
  t35_n62: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t35_n64;
  t35_n63: return -0.008571881800889969f;
  t35_n64: return 0.047986168414354324f;
  t35_n65: return 0.03434176370501518f;
  t35_n66: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t35_n68;
  t35_n67: return 0.04714515432715416f;
  t35_n68: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t35_n70;
  t35_n69: return -0.027877984568476677f;
  t35_n70: return 0.04307309538125992f;
  t35_n71: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t35_n83;
  t35_n72: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t35_n80;
  t35_n73: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t35_n77;
  t35_n74: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_UnionTag))) goto t35_n76;
  t35_n75: return 0.008847581222653389f;
  t35_n76: return 0.047878507524728775f;
  t35_n77: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t35_n79;
  t35_n78: return -0.016998395323753357f;
  t35_n79: return 0.03085201047360897f;
  t35_n80: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t35_n82;
  t35_n81: return -0.11212589591741562f;
  t35_n82: return -0.057734835892915726f;
  t35_n83: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t35_n85;
  t35_n84: return -0.023410527035593987f;
  t35_n85: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t35_n93;
  t35_n86: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t35_n92;
  t35_n87: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t35_n89;
  t35_n88: return -0.04774480313062668f;
  t35_n89: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t35_n91;
  t35_n90: return 0.0378069244325161f;
  t35_n91: return -0.04214123263955116f;
  t35_n92: return 0.033993568271398544f;
  t35_n93: return -0.15291865170001984f;
  t35_n94: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t35_n102;
  t35_n95: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t35_n101;
  t35_n96: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t35_n100;
  t35_n97: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t35_n99;
  t35_n98: return 0.043832309544086456f;
  t35_n99: return 0.014322961680591106f;
  t35_n100: return 0.07470240443944931f;
  t35_n101: return 0.0782558023929596f;
  t35_n102: if (E.getNumReferences() >= 3376956888 /*820317.5*/) goto t35_n108;
  t35_n103: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t35_n107;
  t35_n104: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Variable))) goto t35_n106;
  t35_n105: return -0.0012069129152223468f;
  t35_n106: return 0.04005962237715721f;
  t35_n107: return 0.0632399320602417f;
  t35_n108: return 0.06253102421760559f;
  t35_n109: if (E.getNumReferences() >= 3292798976 /*784.5*/) goto t35_n241;
  t35_n110: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t35_n182;
  t35_n111: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t35_n175;
  t35_n112: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t35_n168;
  t35_n113: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t35_n161;
  t35_n114: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t35_n122;
  t35_n115: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t35_n119;
  t35_n116: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t35_n118;
  t35_n117: return 0.02520519308745861f;
  t35_n118: return 0.046497661620378494f;
  t35_n119: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Variable))) goto t35_n121;
  t35_n120: return -0.023274756968021393f;
  t35_n121: return 0.08426450937986374f;
  t35_n122: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t35_n130;
  t35_n123: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t35_n127;
  t35_n124: if (E.getNumReferences() >= 3255173120 /*33.5*/) goto t35_n126;
  t35_n125: return 0.006289051845669746f;
  t35_n126: return 0.049158502370119095f;
  t35_n127: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t35_n129;
  t35_n128: return -0.016206473112106323f;
  t35_n129: return 0.046308208256959915f;
  t35_n130: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t35_n132;
  t35_n131: return -0.07154319435358047f;
  t35_n132: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t35_n146;
  t35_n133: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t35_n145;
  t35_n134: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t35_n144;
  t35_n135: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t35_n139;
  t35_n136: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t35_n138;
  t35_n137: return 0.012877125293016434f;
  t35_n138: return -0.02081962861120701f;
  t35_n139: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t35_n141;
  t35_n140: return -0.07754314690828323f;
  t35_n141: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t35_n143;
  t35_n142: return 0.01372556947171688f;
  t35_n143: return 0.07481469959020615f;
  t35_n144: return -0.12337859719991684f;
  t35_n145: return -0.08518067747354507f;
  t35_n146: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t35_n160;
  t35_n147: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t35_n159;
  t35_n148: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t35_n154;
  t35_n149: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t35_n151;
  t35_n150: return -0.02096167951822281f;
  t35_n151: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t35_n153;
  t35_n152: return 0.031088268384337425f;
  t35_n153: return 0.01123654842376709f;
  t35_n154: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t35_n158;
  t35_n155: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t35_n157;
  t35_n156: return 0.02657010778784752f;
  t35_n157: return 0.05572423338890076f;
  t35_n158: return 0.05288035050034523f;
  t35_n159: return -0.07837304472923279f;
  t35_n160: return -0.056444983929395676f;
  t35_n161: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t35_n163;
  t35_n162: return -0.11612223833799362f;
  t35_n163: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t35_n167;
  t35_n164: if (E.getNumReferences() >= 3245867008 /*15.5*/) goto t35_n166;
  t35_n165: return 0.013739049434661865f;
  t35_n166: return 0.07410223037004471f;
  t35_n167: return -0.015405667014420033f;
  t35_n168: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t35_n174;
  t35_n169: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t35_n173;
  t35_n170: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Symbol))) goto t35_n172;
  t35_n171: return 0.015111400745809078f;
  t35_n172: return 0.028132285922765732f;
  t35_n173: return 0.05159249156713486f;
  t35_n174: return -0.08315654844045639f;
  t35_n175: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t35_n181;
  t35_n176: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t35_n180;
  t35_n177: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t35_n179;
  t35_n178: return 0.0443236269056797f;
  t35_n179: return -0.002906846348196268f;
  t35_n180: return 0.03707905486226082f;
  t35_n181: return 0.051149580627679825f;
  t35_n182: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t35_n184;
  t35_n183: return -0.012929604388773441f;
  t35_n184: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t35_n228;
  t35_n185: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t35_n221;
  t35_n186: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t35_n212;
  t35_n187: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t35_n199;
  t35_n188: if (E.getNumReferences() >= 3263037440 /*63.5*/) goto t35_n198;
  t35_n189: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t35_n191;
  t35_n190: return 0.009634477086365223f;
  t35_n191: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t35_n195;
  t35_n192: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t35_n194;
  t35_n193: return 0.0028946406673640013f;
  t35_n194: return 0.06960751861333847f;
  t35_n195: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t35_n197;
  t35_n196: return 0.03190566599369049f;
  t35_n197: return -0.0016052030259743333f;
  t35_n198: return 0.051015160977840424f;
  t35_n199: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t35_n211;
  t35_n200: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t35_n210;
  t35_n201: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t35_n203;
  t35_n202: return 0.018675383180379868f;
  t35_n203: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t35_n205;
  t35_n204: return -0.06677711755037308f;
  t35_n205: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::GlobalScope))) goto t35_n209;
  t35_n206: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t35_n208;
  t35_n207: return 0.12572512030601501f;
  t35_n208: return 0.001336421468295157f;
  t35_n209: return 0.05506046861410141f;
  t35_n210: return 0.05081329867243767f;
  t35_n211: return 0.04043731093406677f;
  t35_n212: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t35_n220;
  t35_n213: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t35_n217;
  t35_n214: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t35_n216;
  t35_n215: return 0.042269375175237656f;
  t35_n216: return 0.06676039844751358f;
  t35_n217: if (E.getNumReferences() >= 3251896320 /*26.5*/) goto t35_n219;
  t35_n218: return 0.030898701399564743f;
  t35_n219: return 0.06587851792573929f;
  t35_n220: return -0.052271559834480286f;
  t35_n221: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t35_n225;
  t35_n222: if (E.getNumReferences() >= 3247177728 /*17.5*/) goto t35_n224;
  t35_n223: return -0.03171607851982117f;
  t35_n224: return 0.044511470943689346f;
  t35_n225: if (E.getFractionNameInContext() >= 3197638680 /*0.2970588207244873*/) goto t35_n227;
  t35_n226: return 0.005873534362763166f;
  t35_n227: return 0.02977369725704193f;
  t35_n228: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Symbol))) goto t35_n238;
  t35_n229: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t35_n231;
  t35_n230: return 0.04544701427221298f;
  t35_n231: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t35_n237;
  t35_n232: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t35_n236;
  t35_n233: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t35_n235;
  t35_n234: return -0.05589699745178223f;
  t35_n235: return 0.0992833822965622f;
  t35_n236: return 0.05365251004695892f;
  t35_n237: return 0.055192410945892334f;
  t35_n238: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t35_n240;
  t35_n239: return 0.040795039385557175f;
  t35_n240: return 0.07280713319778442f;
  t35_n241: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t35_n247;
  t35_n242: if (E.getNumReferences() >= 3344481024 /*55483.0*/) goto t35_n244;
  t35_n243: return 0.04617500305175781f;
  t35_n244: if (E.getNumReferences() >= 3344616064 /*56010.5*/) goto t35_n246;
  t35_n245: return 0.11261248588562012f;
  t35_n246: return 0.08506985008716583f;
  t35_n247: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t35_n249;
  t35_n248: return 0.025195058435201645f;
  t35_n249: return 0.0729842483997345f;
  t35_n250: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t35_n254;
  t35_n251: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t35_n253;
  t35_n252: return 0.04381062462925911f;
  t35_n253: return 0.06225614249706268f;
  t35_n254: return 0.08753515779972076f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree36(const Example& E) {
  t36_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t36_n252;
  t36_n1: if (E.getFractionNameInContext() >= 3180849535 /*0.07417582720518112*/) goto t36_n103;
  t36_n2: if (E.getNumReferences() >= 3303280640 /*1824.5*/) goto t36_n92;
  t36_n3: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t36_n75;
  t36_n4: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator))) goto t36_n54;
  t36_n5: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t36_n17;
  t36_n6: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t36_n12;
  t36_n7: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t36_n11;
  t36_n8: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t36_n10;
  t36_n9: return -0.04501238837838173f;
  t36_n10: return -0.011010309681296349f;
  t36_n11: return 0.033996839076280594f;
  t36_n12: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t36_n16;
  t36_n13: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t36_n15;
  t36_n14: return 0.014569074846804142f;
  t36_n15: return 0.04108286276459694f;
  t36_n16: return 0.07896331697702408f;
  t36_n17: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t36_n49;
  t36_n18: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t36_n48;
  t36_n19: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t36_n21;
  t36_n20: return -0.05346804857254028f;
  t36_n21: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t36_n45;
  t36_n22: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t36_n24;
  t36_n23: return -0.039143435657024384f;
  t36_n24: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t36_n44;
  t36_n25: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t36_n27;
  t36_n26: return -0.007715218234807253f;
  t36_n27: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t36_n31;
  t36_n28: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t36_n30;
  t36_n29: return -0.03454345837235451f;
  t36_n30: return 0.09975942969322205f;
  t36_n31: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t36_n43;
  t36_n32: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t36_n42;
  t36_n33: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t36_n37;
  t36_n34: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t36_n36;
  t36_n35: return 0.023310508579015732f;
  t36_n36: return -0.047776635736227036f;
  t36_n37: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t36_n39;
  t36_n38: return 0.03002280183136463f;
  t36_n39: if (E.getFractionNameInContext() >= 3177025848 /*0.05409356951713562*/) goto t36_n41;
  t36_n40: return 0.0498538576066494f;
  t36_n41: return 0.0011421693488955498f;
  t36_n42: return -0.1219191774725914f;
  t36_n43: return -0.12058460712432861f;
  t36_n44: return -0.06326289474964142f;
  t36_n45: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t36_n47;
  t36_n46: return 0.02508951723575592f;
  t36_n47: return -0.052073199301958084f;
  t36_n48: return -0.12421020120382309f;
  t36_n49: if (E.getNumReferences() >= 3240624128 /*10.5*/) goto t36_n51;
  t36_n50: return -0.09790179878473282f;
  t36_n51: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t36_n53;
  t36_n52: return 0.0042633493430912495f;
  t36_n53: return -0.06106987223029137f;
  t36_n54: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t36_n58;
  t36_n55: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t36_n57;
  t36_n56: return -0.15756341814994812f;
  t36_n57: return -0.0798916295170784f;
  t36_n58: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t36_n64;
  t36_n59: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t36_n63;
  t36_n60: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t36_n62;
  t36_n61: return -0.026333119720220566f;
  t36_n62: return 0.009144352748990059f;
  t36_n63: return 0.03428799659013748f;
  t36_n64: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel))) goto t36_n66;
  t36_n65: return -0.0033951217774301767f;
  t36_n66: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t36_n72;
  t36_n67: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t36_n71;
  t36_n68: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t36_n70;
  t36_n69: return 0.011525182984769344f;
  t36_n70: return 0.1250440925359726f;
  t36_n71: return -0.026287438347935677f;
  t36_n72: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t36_n74;
  t36_n73: return 0.052236296236515045f;
  t36_n74: return -0.08399802446365356f;
  t36_n75: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t36_n87;
  t36_n76: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t36_n84;
  t36_n77: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t36_n81;
  t36_n78: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t36_n80;
  t36_n79: return -0.0021084577310830355f;
  t36_n80: return 0.01358719076961279f;
  t36_n81: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t36_n83;
  t36_n82: return 0.019254444167017937f;
  t36_n83: return -0.087277352809906f;
  t36_n84: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t36_n86;
  t36_n85: return -0.035290297120809555f;
  t36_n86: return 0.04103948175907135f;
  t36_n87: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t36_n91;
  t36_n88: if (E.getFractionNameInContext() >= 3178314303 /*0.058893438428640366*/) goto t36_n90;
  t36_n89: return 0.024120446294546127f;
  t36_n90: return -0.007206630427390337f;
  t36_n91: return 0.06259796023368835f;
  t36_n92: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t36_n98;
  t36_n93: if (E.getNumReferences() >= 3347876160 /*71954.5*/) goto t36_n95;
  t36_n94: return 0.0312366783618927f;
  t36_n95: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t36_n97;
  t36_n96: return 0.05834106355905533f;
  t36_n97: return 0.10293307900428772f;
  t36_n98: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t36_n100;
  t36_n99: return -2.9740635000052862e-05f;
  t36_n100: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t36_n102;
  t36_n101: return 0.002971682930365205f;
  t36_n102: return 0.06333186477422714f;
  t36_n103: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t36_n177;
  t36_n104: if (E.getNumReferences() >= 3300708352 /*1510.5*/) goto t36_n170;
  t36_n105: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t36_n165;
  t36_n106: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t36_n136;
  t36_n107: if (E.getNumReferences() >= 3240624128 /*10.5*/) goto t36_n131;
  t36_n108: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t36_n124;
  t36_n109: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t36_n123;
  t36_n110: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t36_n122;
  t36_n111: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t36_n121;
  t36_n112: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t36_n116;
  t36_n113: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t36_n115;
  t36_n114: return -0.1712620109319687f;
  t36_n115: return -0.10805050283670425f;
  t36_n116: if (E.getFileProximityDistanceCost() >= 3255042048 /*33.0*/) goto t36_n118;
  t36_n117: return -0.0059481277130544186f;
  t36_n118: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t36_n120;
  t36_n119: return 0.03480498492717743f;
  t36_n120: return 0.11627006530761719f;
  t36_n121: return 0.00782120693475008f;
  t36_n122: return 0.07173950225114822f;
  t36_n123: return -0.07427900284528732f;
  t36_n124: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t36_n126;
  t36_n125: return -0.017099512740969658f;
  t36_n126: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t36_n128;
  t36_n127: return 0.016776634380221367f;
  t36_n128: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t36_n130;
  t36_n129: return 0.019525792449712753f;
  t36_n130: return 0.05264142155647278f;
  t36_n131: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t36_n133;
  t36_n132: return 0.024195579811930656f;
  t36_n133: if (E.getNumReferences() >= 3258843136 /*47.5*/) goto t36_n135;
  t36_n134: return 0.0304782222956419f;
  t36_n135: return 0.053811706602573395f;
  t36_n136: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t36_n142;
  t36_n137: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t36_n139;
  t36_n138: return -0.02341323532164097f;
  t36_n139: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t36_n141;
  t36_n140: return 0.01720242388546467f;
  t36_n141: return -0.21697553992271423f;
  t36_n142: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t36_n164;
  t36_n143: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t36_n161;
  t36_n144: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t36_n146;
  t36_n145: return -0.0062955026514828205f;
  t36_n146: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t36_n148;
  t36_n147: return 0.004527022130787373f;
  t36_n148: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t36_n150;
  t36_n149: return 0.0008886450086720288f;
  t36_n150: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion))) goto t36_n160;
  t36_n151: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t36_n159;
  t36_n152: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t36_n158;
  t36_n153: if (E.getFileProximityDistanceCost() >= 3248750592 /*20.5*/) goto t36_n155;
  t36_n154: return 0.0403033122420311f;
  t36_n155: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t36_n157;
  t36_n156: return 0.0674615278840065f;
  t36_n157: return -0.02585485950112343f;
  t36_n158: return -0.13168084621429443f;
  t36_n159: return -0.11867154389619827f;
  t36_n160: return 0.07246478646993637f;
  t36_n161: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t36_n163;
  t36_n162: return -0.44007933139801025f;
  t36_n163: return 0.05428774654865265f;
  t36_n164: return 0.04072977975010872f;
  t36_n165: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t36_n169;
  t36_n166: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t36_n168;
  t36_n167: return 0.010132981464266777f;
  t36_n168: return 0.03686661273241043f;
  t36_n169: return 0.048216186463832855f;
  t36_n170: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t36_n174;
  t36_n171: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t36_n173;
  t36_n172: return 0.018091129139065742f;
  t36_n173: return 0.0676976665854454f;
  t36_n174: if (E.getNumReferences() >= 3340710656 /*40755.0*/) goto t36_n176;
  t36_n175: return 0.04830782115459442f;
  t36_n176: return 0.08420298993587494f;
  t36_n177: if (E.getNumReferences() >= 3259367424 /*49.5*/) goto t36_n245;
  t36_n178: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t36_n180;
  t36_n179: return -0.010508334264159203f;
  t36_n180: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t36_n204;
  t36_n181: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t36_n195;
  t36_n182: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t36_n190;
  t36_n183: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t36_n189;
  t36_n184: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t36_n188;
  t36_n185: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t36_n187;
  t36_n186: return 0.02294936217367649f;
  t36_n187: return -0.01894136518239975f;
  t36_n188: return 0.037484075874090195f;
  t36_n189: return -0.00023479803348891437f;
  t36_n190: if (E.getContextKind() & (BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel))) goto t36_n192;
  t36_n191: return 0.014435481280088425f;
  t36_n192: if (E.getSymbolScopeDistanceCost() >= 3221225472 /*2.0*/) goto t36_n194;
  t36_n193: return 0.06925618648529053f;
  t36_n194: return 0.029947523027658463f;
  t36_n195: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t36_n203;
  t36_n196: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t36_n198;
  t36_n197: return 0.02677667886018753f;
  t36_n198: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t36_n200;
  t36_n199: return 0.012570898979902267f;
  t36_n200: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t36_n202;
  t36_n201: return 0.052517011761665344f;
  t36_n202: return 0.08033675700426102f;
  t36_n203: return 0.08181554824113846f;
  t36_n204: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t36_n222;
  t36_n205: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t36_n215;
  t36_n206: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t36_n208;
  t36_n207: return -0.03410341963171959f;
  t36_n208: if (E.getFileProximityDistanceCost() >= 3248750592 /*20.5*/) goto t36_n214;
  t36_n209: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t36_n213;
  t36_n210: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t36_n212;
  t36_n211: return 0.039171572774648666f;
  t36_n212: return -0.011363762430846691f;
  t36_n213: return 0.09241504967212677f;
  t36_n214: return 0.016225995495915413f;
  t36_n215: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t36_n221;
  t36_n216: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t36_n218;
  t36_n217: return 0.012164687737822533f;
  t36_n218: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t36_n220;
  t36_n219: return -0.017078857868909836f;
  t36_n220: return 0.04076504707336426f;
  t36_n221: return 0.057034846395254135f;
  t36_n222: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t36_n244;
  t36_n223: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t36_n227;
  t36_n224: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t36_n226;
  t36_n225: return 0.04048306867480278f;
  t36_n226: return -0.6174516081809998f;
  t36_n227: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t36_n237;
  t36_n228: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t36_n232;
  t36_n229: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t36_n231;
  t36_n230: return 0.029912736266851425f;
  t36_n231: return 0.061675213277339935f;
  t36_n232: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t36_n234;
  t36_n233: return -0.20576806366443634f;
  t36_n234: if (E.getFractionNameInContext() >= 3206335693 /*0.612500011920929*/) goto t36_n236;
  t36_n235: return -0.0015060023870319128f;
  t36_n236: return 0.10538676381111145f;
  t36_n237: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t36_n243;
  t36_n238: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t36_n242;
  t36_n239: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t36_n241;
  t36_n240: return 0.03264966234564781f;
  t36_n241: return 0.0690142959356308f;
  t36_n242: return 0.073092982172966f;
  t36_n243: return 0.09806692600250244f;
  t36_n244: return -0.06875789910554886f;
  t36_n245: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t36_n247;
  t36_n246: return 0.07266838103532791f;
  t36_n247: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t36_n251;
  t36_n248: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t36_n250;
  t36_n249: return 0.04226282611489296f;
  t36_n250: return 0.06363706290721893f;
  t36_n251: return 0.09786312282085419f;
  t36_n252: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t36_n254;
  t36_n253: return 0.05338817834854126f;
  t36_n254: return 0.08580446243286133f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree37(const Example& E) {
  t37_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t37_n252;
  t37_n1: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t37_n105;
  t37_n2: if (E.getNumReferences() >= 3303288832 /*1825.5*/) goto t37_n84;
  t37_n3: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t37_n63;
  t37_n4: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t37_n30;
  t37_n5: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t37_n29;
  t37_n6: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type))) goto t37_n10;
  t37_n7: if (E.getNumReferences() >= 3268739072 /*106.5*/) goto t37_n9;
  t37_n8: return -0.038498926907777786f;
  t37_n9: return 0.05295413359999657f;
  t37_n10: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t37_n28;
  t37_n11: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t37_n27;
  t37_n12: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t37_n16;
  t37_n13: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t37_n15;
  t37_n14: return -0.00869380496442318f;
  t37_n15: return -0.16136790812015533f;
  t37_n16: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t37_n22;
  t37_n17: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t37_n19;
  t37_n18: return -0.13522489368915558f;
  t37_n19: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t37_n21;
  t37_n20: return -0.12560275197029114f;
  t37_n21: return 0.00856646429747343f;
  t37_n22: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t37_n26;
  t37_n23: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t37_n25;
  t37_n24: return -0.008902688510715961f;
  t37_n25: return 0.05689748376607895f;
  t37_n26: return 0.045470334589481354f;
  t37_n27: return -0.03806084766983986f;
  t37_n28: return -0.13125889003276825f;
  t37_n29: return -0.08030454814434052f;
  t37_n30: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t37_n32;
  t37_n31: return -0.08671397715806961f;
  t37_n32: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t37_n56;
  t37_n33: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t37_n55;
  t37_n34: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t37_n50;
  t37_n35: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t37_n49;
  t37_n36: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t37_n42;
  t37_n37: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t37_n39;
  t37_n38: return -0.08459402620792389f;
  t37_n39: if (E.getNumReferences() >= 3238526976 /*8.5*/) goto t37_n41;
  t37_n40: return -0.002413123147562146f;
  t37_n41: return 0.09945756942033768f;
  t37_n42: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t37_n48;
  t37_n43: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t37_n45;
  t37_n44: return 0.015849880874156952f;
  t37_n45: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t37_n47;
  t37_n46: return 0.02363646775484085f;
  t37_n47: return 0.08405490964651108f;
  t37_n48: return 0.011819890700280666f;
  t37_n49: return -0.010178141295909882f;
  t37_n50: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t37_n52;
  t37_n51: return -0.07085960358381271f;
  t37_n52: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t37_n54;
  t37_n53: return 0.018612874671816826f;
  t37_n54: return 0.0837734043598175f;
  t37_n55: return -0.09308470785617828f;
  t37_n56: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t37_n60;
  t37_n57: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t37_n59;
  t37_n58: return 0.003569123102352023f;
  t37_n59: return 0.033059872686862946f;
  t37_n60: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t37_n62;
  t37_n61: return 0.04565304517745972f;
  t37_n62: return 0.01596042886376381f;
  t37_n63: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t37_n73;
  t37_n64: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t37_n66;
  t37_n65: return -0.05910969525575638f;
  t37_n66: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t37_n68;
  t37_n67: return -0.016004079952836037f;
  t37_n68: if (E.getSymbolScopeDistanceCost() >= 3241148416 /*11.0*/) goto t37_n70;
  t37_n69: return -0.035416379570961f;
  t37_n70: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t37_n72;
  t37_n71: return 0.03023000992834568f;
  t37_n72: return -0.14942173659801483f;
  t37_n73: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t37_n83;
  t37_n74: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t37_n76;
  t37_n75: return -0.04749844968318939f;
  t37_n76: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t37_n82;
  t37_n77: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_UnionTag))) goto t37_n81;
  t37_n78: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t37_n80;
  t37_n79: return 0.006286883261054754f;
  t37_n80: return 0.03360774740576744f;
  t37_n81: return 0.06583207845687866f;
  t37_n82: return 0.0710177943110466f;
  t37_n83: return -0.07143907994031906f;
  t37_n84: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t37_n98;
  t37_n85: if (E.getNumReferences() >= 3347876160 /*71954.5*/) goto t37_n95;
  t37_n86: if (E.getNumReferences() >= 3344648832 /*56138.5*/) goto t37_n94;
  t37_n87: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t37_n89;
  t37_n88: return 0.03132378309965134f;
  t37_n89: if (E.getNumReferences() >= 3317853184 /*6221.5*/) goto t37_n91;
  t37_n90: return 0.020219236612319946f;
  t37_n91: if (E.getNumReferences() >= 3318227968 /*6404.5*/) goto t37_n93;
  t37_n92: return 0.13302487134933472f;
  t37_n93: return 0.06329736858606339f;
  t37_n94: return -0.042654283344745636f;
  t37_n95: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t37_n97;
  t37_n96: return 0.05616361275315285f;
  t37_n97: return 0.10142152011394501f;
  t37_n98: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t37_n100;
  t37_n99: return -0.000894030905328691f;
  t37_n100: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t37_n104;
  t37_n101: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Type))) goto t37_n103;
  t37_n102: return -0.02166450023651123f;
  t37_n103: return 0.038476962596178055f;
  t37_n104: return 0.0601351298391819f;
  t37_n105: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t37_n217;
  t37_n106: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t37_n188;
  t37_n107: if (E.getNumReferences() >= 3292798976 /*784.5*/) goto t37_n181;
  t37_n108: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t37_n126;
  t37_n109: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t37_n121;
  t37_n110: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type))) goto t37_n118;
  t37_n111: if (E.getFractionNameInContext() >= 3196720569 /*0.269696980714798*/) goto t37_n115;
  t37_n112: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t37_n114;
  t37_n113: return 0.018618110567331314f;
  t37_n114: return -0.011358898133039474f;
  t37_n115: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t37_n117;
  t37_n116: return 0.028140418231487274f;
  t37_n117: return 0.06517250835895538f;
  t37_n118: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t37_n120;
  t37_n119: return 0.05345406383275986f;
  t37_n120: return 0.034162748605012894f;
  t37_n121: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t37_n125;
  t37_n122: if (E.getNumReferences() >= 3265724416 /*83.5*/) goto t37_n124;
  t37_n123: return 0.031701501458883286f;
  t37_n124: return 0.05832554027438164f;
  t37_n125: return 0.06130078807473183f;
  t37_n126: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t37_n168;
  t37_n127: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t37_n155;
  t37_n128: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t37_n154;
  t37_n129: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t37_n143;
  t37_n130: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t37_n140;
  t37_n131: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t37_n137;
  t37_n132: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t37_n134;
  t37_n133: return 0.0030599881429225206f;
  t37_n134: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol))) goto t37_n136;
  t37_n135: return -0.0015490028308704495f;
  t37_n136: return 0.07746588438749313f;
  t37_n137: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t37_n139;
  t37_n138: return -0.0668819397687912f;
  t37_n139: return 0.01321684755384922f;
  t37_n140: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t37_n142;
  t37_n141: return 0.020104117691516876f;
  t37_n142: return 0.03539818525314331f;
  t37_n143: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t37_n147;
  t37_n144: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t37_n146;
  t37_n145: return -0.35923004150390625f;
  t37_n146: return 0.04731789603829384f;
  t37_n147: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Type))) goto t37_n149;
  t37_n148: return 0.05317017808556557f;
  t37_n149: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t37_n153;
  t37_n150: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t37_n152;
  t37_n151: return 0.008725282736122608f;
  t37_n152: return 0.07000444829463959f;
  t37_n153: return 0.04590742662549019f;
  t37_n154: return -0.08343073725700378f;
  t37_n155: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t37_n157;
  t37_n156: return -0.13385847210884094f;
  t37_n157: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t37_n165;
  t37_n158: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t37_n162;
  t37_n159: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t37_n161;
  t37_n160: return 0.0098398607224226f;
  t37_n161: return 0.05190228670835495f;
  t37_n162: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t37_n164;
  t37_n163: return 0.04380863904953003f;
  t37_n164: return -0.04167594760656357f;
  t37_n165: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t37_n167;
  t37_n166: return 0.04871078208088875f;
  t37_n167: return -0.03510476276278496f;
  t37_n168: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t37_n178;
  t37_n169: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel))) goto t37_n171;
  t37_n170: return -0.02431558631360531f;
  t37_n171: if (E.getFractionNameInContext() >= 3193183554 /*0.20714285969734192*/) goto t37_n177;
  t37_n172: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t37_n176;
  t37_n173: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t37_n175;
  t37_n174: return 0.0013504633679986f;
  t37_n175: return 0.01765197142958641f;
  t37_n176: return 0.04275256022810936f;
  t37_n177: return 0.030633466318249702f;
  t37_n178: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol))) goto t37_n180;
  t37_n179: return 0.019410761073231697f;
  t37_n180: return 0.05487745255231857f;
  t37_n181: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t37_n183;
  t37_n182: return 0.06527573615312576f;
  t37_n183: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t37_n185;
  t37_n184: return 0.038043826818466187f;
  t37_n185: if (E.getNumReferences() >= 3325638144 /*11853.5*/) goto t37_n187;
  t37_n186: return 0.03752902150154114f;
  t37_n187: return 0.08570234477519989f;
  t37_n188: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t37_n190;
  t37_n189: return -0.12269246578216553f;
  t37_n190: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t37_n196;
  t37_n191: if (E.getNumReferences() >= 3245867008 /*15.5*/) goto t37_n195;
  t37_n192: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t37_n194;
  t37_n193: return 0.012603227980434895f;
  t37_n194: return 0.031360555440187454f;
  t37_n195: return 0.06459841877222061f;
  t37_n196: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t37_n214;
  t37_n197: if (E.getNumReferences() >= 3338822784 /*33380.5*/) goto t37_n211;
  t37_n198: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t37_n206;
  t37_n199: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t37_n205;
  t37_n200: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t37_n204;
  t37_n201: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t37_n203;
  t37_n202: return -0.00610036076977849f;
  t37_n203: return -0.07709122449159622f;
  t37_n204: return 0.010693681426346302f;
  t37_n205: return -0.07932504266500473f;
  t37_n206: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t37_n208;
  t37_n207: return 0.02873181365430355f;
  t37_n208: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t37_n210;
  t37_n209: return 0.03726251423358917f;
  t37_n210: return -0.01130911335349083f;
  t37_n211: if (E.getNumReferences() >= 3344720384 /*56418.0*/) goto t37_n213;
  t37_n212: return 0.10453484952449799f;
  t37_n213: return 0.03627874329686165f;
  t37_n214: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t37_n216;
  t37_n215: return -0.026800353080034256f;
  t37_n216: return -0.11981663852930069f;
  t37_n217: if (E.getNumReferences() >= 3316158464 /*5394.0*/) goto t37_n251;
  t37_n218: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t37_n240;
  t37_n219: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t37_n229;
  t37_n220: if (E.getNumReferences() >= 3248750592 /*20.5*/) goto t37_n228;
  t37_n221: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t37_n225;
  t37_n222: if (E.getNumNameInContext() >= 3232759808 /*5.5*/) goto t37_n224;
  t37_n223: return 0.035180870443582535f;
  t37_n224: return 0.14821581542491913f;
  t37_n225: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t37_n227;
  t37_n226: return -0.029572846367955208f;
  t37_n227: return 0.05043608695268631f;
  t37_n228: return 0.07605192065238953f;
  t37_n229: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t37_n233;
  t37_n230: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t37_n232;
  t37_n231: return 0.04933791235089302f;
  t37_n232: return 0.022320736199617386f;
  t37_n233: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t37_n237;
  t37_n234: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol))) goto t37_n236;
  t37_n235: return 0.04983368143439293f;
  t37_n236: return 0.08598984032869339f;
  t37_n237: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t37_n239;
  t37_n238: return -0.16354183852672577f;
  t37_n239: return 0.04094022884964943f;
  t37_n240: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t37_n248;
  t37_n241: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t37_n247;
  t37_n242: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression))) goto t37_n246;
  t37_n243: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t37_n245;
  t37_n244: return 0.01153060607612133f;
  t37_n245: return -0.07793349027633667f;
  t37_n246: return 0.03521772474050522f;
  t37_n247: return 0.05671711266040802f;
  t37_n248: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t37_n250;
  t37_n249: return -0.08133767545223236f;
  t37_n250: return 0.05934561416506767f;
  t37_n251: return 0.09552828967571259f;
  t37_n252: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t37_n254;
  t37_n253: return 0.046028994023799896f;
  t37_n254: return 0.06409329175949097f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree38(const Example& E) {
  t38_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t38_n250;
  t38_n1: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t38_n145;
  t38_n2: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t38_n84;
  t38_n3: if (E.getNumReferences() >= 3317122048 /*5864.5*/) goto t38_n69;
  t38_n4: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t38_n34;
  t38_n5: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t38_n31;
  t38_n6: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t38_n30;
  t38_n7: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type))) goto t38_n9;
  t38_n8: return -0.03884991258382797f;
  t38_n9: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t38_n29;
  t38_n10: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t38_n14;
  t38_n11: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t38_n13;
  t38_n12: return -0.01421373337507248f;
  t38_n13: return 0.019956080242991447f;
  t38_n14: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t38_n24;
  t38_n15: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t38_n17;
  t38_n16: return -0.13453985750675201f;
  t38_n17: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t38_n19;
  t38_n18: return -0.12506277859210968f;
  t38_n19: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t38_n23;
  t38_n20: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t38_n22;
  t38_n21: return 0.00805643666535616f;
  t38_n22: return -0.14688478410243988f;
  t38_n23: return -0.06543360650539398f;
  t38_n24: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t38_n28;
  t38_n25: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t38_n27;
  t38_n26: return -0.018623190000653267f;
  t38_n27: return 0.061966825276613235f;
  t38_n28: return 0.04302186518907547f;
  t38_n29: return -0.04073196277022362f;
  t38_n30: return -0.06423905491828918f;
  t38_n31: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t38_n33;
  t38_n32: return 0.047681279480457306f;
  t38_n33: return 0.00248690671287477f;
  t38_n34: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t38_n36;
  t38_n35: return -0.08481971174478531f;
  t38_n36: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t38_n64;
  t38_n37: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t38_n63;
  t38_n38: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t38_n60;
  t38_n39: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t38_n51;
  t38_n40: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t38_n50;
  t38_n41: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t38_n43;
  t38_n42: return 0.010956703685224056f;
  t38_n43: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t38_n45;
  t38_n44: return 0.0011003657709807158f;
  t38_n45: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t38_n49;
  t38_n46: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t38_n48;
  t38_n47: return -0.08988677710294724f;
  t38_n48: return 0.038092296570539474f;
  t38_n49: return 0.04996141418814659f;
  t38_n50: return -0.07749388366937637f;
  t38_n51: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t38_n53;
  t38_n52: return -0.01840163581073284f;
  t38_n53: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t38_n59;
  t38_n54: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t38_n58;
  t38_n55: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t38_n57;
  t38_n56: return -0.03539295494556427f;
  t38_n57: return 0.03569317236542702f;
  t38_n58: return 0.0485004298388958f;
  t38_n59: return 0.06714963912963867f;
  t38_n60: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t38_n62;
  t38_n61: return -0.06478123366832733f;
  t38_n62: return 0.018734056502580643f;
  t38_n63: return -0.09131789952516556f;
  t38_n64: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t38_n68;
  t38_n65: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t38_n67;
  t38_n66: return 0.0077520194463431835f;
  t38_n67: return 0.03377729654312134f;
  t38_n68: return 0.05871393904089928f;
  t38_n69: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t38_n83;
  t38_n70: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t38_n78;
  t38_n71: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t38_n75;
  t38_n72: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t38_n74;
  t38_n73: return 0.026577072218060493f;
  t38_n74: return 0.06496082246303558f;
  t38_n75: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t38_n77;
  t38_n76: return -0.06431648880243301f;
  t38_n77: return 0.053434453904628754f;
  t38_n78: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t38_n80;
  t38_n79: return 0.014023357070982456f;
  t38_n80: if (E.getNumReferences() >= 3361141760 /*220112.0*/) goto t38_n82;
  t38_n81: return 0.07400906085968018f;
  t38_n82: return -0.0773804560303688f;
  t38_n83: return 0.07590950280427933f;
  t38_n84: if (E.getNumReferences() >= 3376956888 /*820317.5*/) goto t38_n144;
  t38_n85: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t38_n137;
  t38_n86: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t38_n94;
  t38_n87: if (E.getSymbolScopeDistanceCost() >= 3246915584 /*17.0*/) goto t38_n89;
  t38_n88: return -0.0016964994138106704f;
  t38_n89: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t38_n91;
  t38_n90: return 0.006409105379134417f;
  t38_n91: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Namespace))) goto t38_n93;
  t38_n92: return 0.04249434545636177f;
  t38_n93: return 0.11286884546279907f;
  t38_n94: if (E.getNumReferences() >= 3285270528 /*418.5*/) goto t38_n104;
  t38_n95: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t38_n97;
  t38_n96: return -0.021395951509475708f;
  t38_n97: if (E.getNumReferences() >= 3236954112 /*7.5*/) goto t38_n99;
  t38_n98: return -0.10063536465167999f;
  t38_n99: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t38_n103;
  t38_n100: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t38_n102;
  t38_n101: return 0.005233341362327337f;
  t38_n102: return 0.0686052143573761f;
  t38_n103: return -0.06922652572393417f;
  t38_n104: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t38_n136;
  t38_n105: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t38_n135;
  t38_n106: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t38_n118;
  t38_n107: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t38_n117;
  t38_n108: if (E.getContextKind() & (BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel))) goto t38_n110;
  t38_n109: return -0.03608093410730362f;
  t38_n110: if (E.getNumReferences() >= 3353598912 /*116663.5*/) goto t38_n112;
  t38_n111: return 0.03441697731614113f;
  t38_n112: if (E.getNumReferences() >= 3355447552 /*131140.0*/) goto t38_n116;
  t38_n113: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t38_n115;
  t38_n114: return -0.1381109356880188f;
  t38_n115: return 0.13254736363887787f;
  t38_n116: return -0.03540786728262901f;
  t38_n117: return -0.06928054988384247f;
  t38_n118: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t38_n128;
  t38_n119: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t38_n127;
  t38_n120: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t38_n122;
  t38_n121: return -0.08337754756212234f;
  t38_n122: if (E.getNumReferences() >= 3363889440 /*263945.0*/) goto t38_n124;
  t38_n123: return 0.005749038886278868f;
  t38_n124: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t38_n126;
  t38_n125: return 0.00442351121455431f;
  t38_n126: return 0.09484084695577621f;
  t38_n127: return 0.013005226850509644f;
  t38_n128: if (E.getNumReferences() >= 3351450688 /*99880.5*/) goto t38_n134;
  t38_n129: if (E.getNumReferences() >= 3351221312 /*98088.5*/) goto t38_n133;
  t38_n130: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t38_n132;
  t38_n131: return 0.05725967884063721f;
  t38_n132: return 0.0005052855121903121f;
  t38_n133: return 0.15880252420902252f;
  t38_n134: return -0.08449260890483856f;
  t38_n135: return 0.040493473410606384f;
  t38_n136: return 0.04017328470945358f;
  t38_n137: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t38_n143;
  t38_n138: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t38_n142;
  t38_n139: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t38_n141;
  t38_n140: return 0.012566056102514267f;
  t38_n141: return -0.07502108067274094f;
  t38_n142: return -0.09376545250415802f;
  t38_n143: return -0.07367213070392609f;
  t38_n144: return 0.05621909350156784f;
  t38_n145: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t38_n203;
  t38_n146: if (E.getNumReferences() >= 3300708352 /*1510.5*/) goto t38_n196;
  t38_n147: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t38_n185;
  t38_n148: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t38_n182;
  t38_n149: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t38_n161;
  t38_n150: if (E.getNumReferences() >= 3255173120 /*33.5*/) goto t38_n158;
  t38_n151: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t38_n157;
  t38_n152: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t38_n156;
  t38_n153: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t38_n155;
  t38_n154: return 0.01382796373218298f;
  t38_n155: return 0.027203841134905815f;
  t38_n156: return -0.01917012594640255f;
  t38_n157: return 0.032489076256752014f;
  t38_n158: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t38_n160;
  t38_n159: return 0.04765276238322258f;
  t38_n160: return 0.07253538817167282f;
  t38_n161: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t38_n175;
  t38_n162: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t38_n172;
  t38_n163: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t38_n169;
  t38_n164: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t38_n166;
  t38_n165: return -0.013257583603262901f;
  t38_n166: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t38_n168;
  t38_n167: return 0.0054583800956606865f;
  t38_n168: return -0.07966621965169907f;
  t38_n169: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t38_n171;
  t38_n170: return 0.0064859893172979355f;
  t38_n171: return 0.06557302176952362f;
  t38_n172: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t38_n174;
  t38_n173: return -0.07426615804433823f;
  t38_n174: return 0.0004963764222338796f;
  t38_n175: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t38_n181;
  t38_n176: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t38_n180;
  t38_n177: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t38_n179;
  t38_n178: return 0.02392416261136532f;
  t38_n179: return 0.05837130919098854f;
  t38_n180: return 0.061356693506240845f;
  t38_n181: return -0.03213227167725563f;
  t38_n182: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t38_n184;
  t38_n183: return 0.020056985318660736f;
  t38_n184: return -0.07941450923681259f;
  t38_n185: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t38_n195;
  t38_n186: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t38_n188;
  t38_n187: return -0.011714396998286247f;
  t38_n188: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t38_n192;
  t38_n189: if (E.getFractionNameInContext() >= 3208642560 /*0.75*/) goto t38_n191;
  t38_n190: return 0.03460879251360893f;
  t38_n191: return 0.09154312312602997f;
  t38_n192: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t38_n194;
  t38_n193: return 0.06460341811180115f;
  t38_n194: return 0.008970405906438828f;
  t38_n195: return 0.036492228507995605f;
  t38_n196: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t38_n200;
  t38_n197: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t38_n199;
  t38_n198: return 0.015908170491456985f;
  t38_n199: return 0.06453903764486313f;
  t38_n200: if (E.getNumReferences() >= 3340710656 /*40755.0*/) goto t38_n202;
  t38_n201: return 0.04649034142494202f;
  t38_n202: return 0.08139998465776443f;
  t38_n203: if (E.getNumReferences() >= 3259367424 /*49.5*/) goto t38_n243;
  t38_n204: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t38_n206;
  t38_n205: return -0.006345563102513552f;
  t38_n206: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t38_n228;
  t38_n207: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t38_n223;
  t38_n208: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t38_n218;
  t38_n209: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t38_n211;
  t38_n210: return 0.013589619658887386f;
  t38_n211: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t38_n215;
  t38_n212: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t38_n214;
  t38_n213: return 0.015925699844956398f;
  t38_n214: return 0.04402054101228714f;
  t38_n215: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t38_n217;
  t38_n216: return -0.03767475113272667f;
  t38_n217: return 0.03590850904583931f;
  t38_n218: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t38_n222;
  t38_n219: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t38_n221;
  t38_n220: return 0.03947022184729576f;
  t38_n221: return 0.028909223154187202f;
  t38_n222: return -0.048969075083732605f;
  t38_n223: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t38_n225;
  t38_n224: return -0.024382688105106354f;
  t38_n225: if (E.getFractionNameInContext() >= 3197638680 /*0.2970588207244873*/) goto t38_n227;
  t38_n226: return 0.004447092767804861f;
  t38_n227: return 0.026364294812083244f;
  t38_n228: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Symbol))) goto t38_n240;
  t38_n229: if (E.getFileProximityDistanceCost() >= 3247177728 /*17.5*/) goto t38_n233;
  t38_n230: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t38_n232;
  t38_n231: return 0.030706441029906273f;
  t38_n232: return 0.06051429733633995f;
  t38_n233: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t38_n239;
  t38_n234: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t38_n238;
  t38_n235: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t38_n237;
  t38_n236: return -0.047823574393987656f;
  t38_n237: return 0.09255746752023697f;
  t38_n238: return 0.048624783754348755f;
  t38_n239: return 0.051367636770009995f;
  t38_n240: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t38_n242;
  t38_n241: return 0.04034016653895378f;
  t38_n242: return 0.09508908540010452f;
  t38_n243: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t38_n245;
  t38_n244: return 0.06925416737794876f;
  t38_n245: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t38_n249;
  t38_n246: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t38_n248;
  t38_n247: return 0.0399092435836792f;
  t38_n248: return 0.06090112775564194f;
  t38_n249: return 0.09495051205158234f;
  t38_n250: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t38_n254;
  t38_n251: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t38_n253;
  t38_n252: return 0.03720444068312645f;
  t38_n253: return 0.056517988443374634f;
  t38_n254: return 0.0836578980088234f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree39(const Example& E) {
  t39_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t39_n252;
  t39_n1: if (E.getFractionNameInContext() >= 3180849535 /*0.07417582720518112*/) goto t39_n141;
  t39_n2: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t39_n64;
  t39_n3: if (E.getNumReferences() >= 3308636160 /*2908.5*/) goto t39_n51;
  t39_n4: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t39_n28;
  t39_n5: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t39_n27;
  t39_n6: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t39_n24;
  t39_n7: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t39_n23;
  t39_n8: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Type))) goto t39_n10;
  t39_n9: return -0.03526604548096657f;
  t39_n10: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t39_n22;
  t39_n11: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t39_n13;
  t39_n12: return -0.010294876992702484f;
  t39_n13: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::GlobalScope))) goto t39_n17;
  t39_n14: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t39_n16;
  t39_n15: return -0.12812012434005737f;
  t39_n16: return 0.004592789337038994f;
  t39_n17: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t39_n21;
  t39_n18: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t39_n20;
  t39_n19: return -0.018118005245923996f;
  t39_n20: return 0.059398770332336426f;
  t39_n21: return 0.04036540538072586f;
  t39_n22: return -0.038427457213401794f;
  t39_n23: return -0.06054059788584709f;
  t39_n24: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t39_n26;
  t39_n25: return 0.04571901634335518f;
  t39_n26: return 1.2111920113966335e-05f;
  t39_n27: return -0.0898296907544136f;
  t39_n28: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t39_n30;
  t39_n29: return -0.08271756023168564f;
  t39_n30: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t39_n48;
  t39_n31: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t39_n47;
  t39_n32: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t39_n46;
  t39_n33: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t39_n45;
  t39_n34: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t39_n44;
  t39_n35: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t39_n37;
  t39_n36: return 0.010174395516514778f;
  t39_n37: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t39_n39;
  t39_n38: return 0.0029658018611371517f;
  t39_n39: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t39_n43;
  t39_n40: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t39_n42;
  t39_n41: return -0.08022761344909668f;
  t39_n42: return 0.03578754514455795f;
  t39_n43: return 0.046851422637701035f;
  t39_n44: return -0.07152987271547318f;
  t39_n45: return -0.0084593640640378f;
  t39_n46: return 0.016579121351242065f;
  t39_n47: return -0.08978376537561417f;
  t39_n48: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t39_n50;
  t39_n49: return 0.014360107481479645f;
  t39_n50: return 0.03421521931886673f;
  t39_n51: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t39_n59;
  t39_n52: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t39_n58;
  t39_n53: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t39_n55;
  t39_n54: return 0.02335548773407936f;
  t39_n55: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t39_n57;
  t39_n56: return 0.05117752030491829f;
  t39_n57: return -0.05622373893857002f;
  t39_n58: return 0.06309192627668381f;
  t39_n59: if (E.getNumReferences() >= 3309029376 /*3004.5*/) goto t39_n63;
  t39_n60: if (E.getNumReferences() >= 3308949504 /*2985.0*/) goto t39_n62;
  t39_n61: return 0.07466094940900803f;
  t39_n62: return 0.15750205516815186f;
  t39_n63: return 0.06731688976287842f;
  t39_n64: if (E.getNumReferences() >= 3376956888 /*820317.5*/) goto t39_n140;
  t39_n65: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t39_n135;
  t39_n66: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t39_n118;
  t39_n67: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t39_n113;
  t39_n68: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t39_n82;
  t39_n69: if (E.getFileProximityDistanceCost() >= 3242721280 /*12.5*/) goto t39_n81;
  t39_n70: if (E.getNumReferences() >= 3248226304 /*19.5*/) goto t39_n72;
  t39_n71: return -0.0271470807492733f;
  t39_n72: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t39_n74;
  t39_n73: return 0.0011697731679305434f;
  t39_n74: if (E.getNumReferences() >= 3353598912 /*116663.5*/) goto t39_n76;
  t39_n75: return 0.036753199994564056f;
  t39_n76: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t39_n80;
  t39_n77: if (E.getNumReferences() >= 3355438208 /*131033.0*/) goto t39_n79;
  t39_n78: return 0.12643268704414368f;
  t39_n79: return 0.06972407549619675f;
  t39_n80: return 0.02875063382089138f;
  t39_n81: return -0.07676992565393448f;
  t39_n82: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t39_n106;
  t39_n83: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t39_n85;
  t39_n84: return -0.035866137593984604f;
  t39_n85: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t39_n89;
  t39_n86: if (E.getNumReferences() >= 3363889440 /*263945.0*/) goto t39_n88;
  t39_n87: return -0.02971099317073822f;
  t39_n88: return 0.08394132554531097f;
  t39_n89: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t39_n105;
  t39_n90: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t39_n104;
  t39_n91: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t39_n103;
  t39_n92: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t39_n94;
  t39_n93: return 0.04393762722611427f;
  t39_n94: if (E.getFileProximityDistanceCost() >= 3248750592 /*20.5*/) goto t39_n96;
  t39_n95: return -0.05588605999946594f;
  t39_n96: if (E.getFileProximityDistanceCost() >= 3249274880 /*21.5*/) goto t39_n98;
  t39_n97: return 0.05272720381617546f;
  t39_n98: if (E.getFileProximityDistanceCost() >= 3249799168 /*22.5*/) goto t39_n100;
  t39_n99: return -0.07395267486572266f;
  t39_n100: if (E.getFileProximityDistanceCost() >= 3254910976 /*32.5*/) goto t39_n102;
  t39_n101: return 0.03665580227971077f;
  t39_n102: return -0.16934047639369965f;
  t39_n103: return -0.11760948598384857f;
  t39_n104: return 0.048723042011260986f;
  t39_n105: return -0.07347164303064346f;
  t39_n106: if (E.getNumReferences() >= 3256221696 /*37.5*/) goto t39_n110;
  t39_n107: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t39_n109;
  t39_n108: return 0.058998316526412964f;
  t39_n109: return -0.002007434843108058f;
  t39_n110: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t39_n112;
  t39_n111: return 0.044063229113817215f;
  t39_n112: return -0.011059951037168503f;
  t39_n113: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t39_n115;
  t39_n114: return -0.04486379399895668f;
  t39_n115: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t39_n117;
  t39_n116: return -0.08739254623651505f;
  t39_n117: return 0.0406353659927845f;
  t39_n118: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t39_n134;
  t39_n119: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t39_n125;
  t39_n120: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t39_n122;
  t39_n121: return -0.06077628955245018f;
  t39_n122: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t39_n124;
  t39_n123: return -0.01847780868411064f;
  t39_n124: return 0.03544619679450989f;
  t39_n125: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t39_n127;
  t39_n126: return 0.010149464942514896f;
  t39_n127: if (E.getFileProximityDistanceCost() >= 3236954112 /*7.5*/) goto t39_n129;
  t39_n128: return 0.05155903100967407f;
  t39_n129: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t39_n131;
  t39_n130: return -0.06859272718429565f;
  t39_n131: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t39_n133;
  t39_n132: return -0.012415091507136822f;
  t39_n133: return 0.0913599282503128f;
  t39_n134: return -0.031216898933053017f;
  t39_n135: if (E.getNumReferences() >= 3270705152 /*121.5*/) goto t39_n139;
  t39_n136: if (E.getSymbolScopeDistanceCost() >= 3241148416 /*11.0*/) goto t39_n138;
  t39_n137: return -0.0238693468272686f;
  t39_n138: return 0.018544064834713936f;
  t39_n139: return 0.0486990250647068f;
  t39_n140: return 0.054135192185640335f;
  t39_n141: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t39_n191;
  t39_n142: if (E.getNumReferences() >= 3282124800 /*322.5*/) goto t39_n182;
  t39_n143: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t39_n177;
  t39_n144: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t39_n172;
  t39_n145: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t39_n171;
  t39_n146: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t39_n162;
  t39_n147: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t39_n161;
  t39_n148: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t39_n160;
  t39_n149: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t39_n153;
  t39_n150: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t39_n152;
  t39_n151: return -0.1565038412809372f;
  t39_n152: return -0.10734419524669647f;
  t39_n153: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t39_n155;
  t39_n154: return -0.011349521577358246f;
  t39_n155: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t39_n159;
  t39_n156: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t39_n158;
  t39_n157: return -0.016877995803952217f;
  t39_n158: return 0.04358560964465141f;
  t39_n159: return 0.0808640569448471f;
  t39_n160: return 0.006598726846277714f;
  t39_n161: return -0.06340576708316803f;
  t39_n162: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t39_n164;
  t39_n163: return -0.01275179535150528f;
  t39_n164: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t39_n168;
  t39_n165: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_TopLevel))) goto t39_n167;
  t39_n166: return 0.011189262382686138f;
  t39_n167: return 0.03383777290582657f;
  t39_n168: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t39_n170;
  t39_n169: return 0.017992673441767693f;
  t39_n170: return 0.04886111244559288f;
  t39_n171: return 0.03268910199403763f;
  t39_n172: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t39_n176;
  t39_n173: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t39_n175;
  t39_n174: return -0.005921557080000639f;
  t39_n175: return 0.013937298208475113f;
  t39_n176: return -0.07227492332458496f;
  t39_n177: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t39_n181;
  t39_n178: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t39_n180;
  t39_n179: return -0.003170951269567013f;
  t39_n180: return 0.01930972747504711f;
  t39_n181: return 0.045413244515657425f;
  t39_n182: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t39_n188;
  t39_n183: if (E.getNumReferences() >= 3344481024 /*55483.0*/) goto t39_n185;
  t39_n184: return 0.04770907759666443f;
  t39_n185: if (E.getNumReferences() >= 3344616064 /*56010.5*/) goto t39_n187;
  t39_n186: return 0.10869460552930832f;
  t39_n187: return 0.08061840385198593f;
  t39_n188: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t39_n190;
  t39_n189: return 0.016347920522093773f;
  t39_n190: return 0.054645538330078125f;
  t39_n191: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t39_n245;
  t39_n192: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t39_n230;
  t39_n193: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t39_n199;
  t39_n194: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t39_n196;
  t39_n195: return -0.028782276436686516f;
  t39_n196: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t39_n198;
  t39_n197: return 0.016017325222492218f;
  t39_n198: return -0.08688339591026306f;
  t39_n199: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t39_n229;
  t39_n200: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t39_n228;
  t39_n201: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t39_n207;
  t39_n202: if (E.getFractionNameInContext() >= 3197638680 /*0.2970588207244873*/) goto t39_n206;
  t39_n203: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t39_n205;
  t39_n204: return 0.02485649287700653f;
  t39_n205: return -0.015349939465522766f;
  t39_n206: return 0.03624889627099037f;
  t39_n207: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t39_n227;
  t39_n208: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t39_n226;
  t39_n209: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t39_n211;
  t39_n210: return -0.01823943294584751f;
  t39_n211: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t39_n223;
  t39_n212: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t39_n216;
  t39_n213: if (E.getFileProximityDistanceCost() >= 3250847744 /*24.5*/) goto t39_n215;
  t39_n214: return 0.025144588202238083f;
  t39_n215: return -0.07287686318159103f;
  t39_n216: if (E.getFractionNameInContext() >= 3205886304 /*0.5857143402099609*/) goto t39_n218;
  t39_n217: return 0.021756896749138832f;
  t39_n218: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t39_n220;
  t39_n219: return 0.016382012516260147f;
  t39_n220: if (E.getNumNameInContext() >= 3230662656 /*4.5*/) goto t39_n222;
  t39_n221: return 0.1518246978521347f;
  t39_n222: return 0.0585801899433136f;
  t39_n223: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t39_n225;
  t39_n224: return 0.038906972855329514f;
  t39_n225: return 0.09546500444412231f;
  t39_n226: return 0.024029048159718513f;
  t39_n227: return -0.054661866277456284f;
  t39_n228: return 0.03246527537703514f;
  t39_n229: return 0.0470459908246994f;
  t39_n230: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Symbol))) goto t39_n242;
  t39_n231: if (E.getFileProximityDistanceCost() >= 3249799168 /*22.5*/) goto t39_n239;
  t39_n232: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t39_n234;
  t39_n233: return 0.02543589659035206f;
  t39_n234: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t39_n238;
  t39_n235: if (E.getNumNameInContext() >= 3232759808 /*5.5*/) goto t39_n237;
  t39_n236: return 0.0706193596124649f;
  t39_n237: return 0.14147700369358063f;
  t39_n238: return 0.02345248870551586f;
  t39_n239: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t39_n241;
  t39_n240: return -0.017506413161754608f;
  t39_n241: return 0.04783428832888603f;
  t39_n242: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t39_n244;
  t39_n243: return 0.0382075160741806f;
  t39_n244: return 0.09184388816356659f;
  t39_n245: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t39_n247;
  t39_n246: return 0.05079101398587227f;
  t39_n247: if (E.getNumReferences() >= 3271360512 /*126.5*/) goto t39_n249;
  t39_n248: return 0.02153118886053562f;
  t39_n249: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t39_n251;
  t39_n250: return 0.02528710849583149f;
  t39_n251: return 0.060351308435201645f;
  t39_n252: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t39_n254;
  t39_n253: return 0.042553916573524475f;
  t39_n254: return 0.060221780091524124f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree40(const Example& E) {
  t40_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t40_n252;
  t40_n1: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t40_n87;
  t40_n2: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t40_n70;
  t40_n3: if (E.getNumReferences() >= 3317122048 /*5864.5*/) goto t40_n57;
  t40_n4: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t40_n26;
  t40_n5: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t40_n23;
  t40_n6: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t40_n20;
  t40_n7: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t40_n9;
  t40_n8: return -0.11629708856344223f;
  t40_n9: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t40_n13;
  t40_n10: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t40_n12;
  t40_n11: return -0.021429024636745453f;
  t40_n12: return 0.016698410734534264f;
  t40_n13: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Namespace))) goto t40_n15;
  t40_n14: return 0.017982356250286102f;
  t40_n15: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t40_n17;
  t40_n16: return 0.020975932478904724f;
  t40_n17: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function))) goto t40_n19;
  t40_n18: return 0.019945969805121422f;
  t40_n19: return 0.10193752497434616f;
  t40_n20: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t40_n22;
  t40_n21: return 0.0033889024052768946f;
  t40_n22: return -0.03548935055732727f;
  t40_n23: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t40_n25;
  t40_n24: return 0.04186753183603287f;
  t40_n25: return 0.0014080532127991319f;
  t40_n26: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t40_n28;
  t40_n27: return -0.08058590441942215f;
  t40_n28: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t40_n54;
  t40_n29: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t40_n53;
  t40_n30: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t40_n50;
  t40_n31: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_UnionTag))) goto t40_n39;
  t40_n32: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t40_n38;
  t40_n33: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t40_n35;
  t40_n34: return -0.007863521575927734f;
  t40_n35: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t40_n37;
  t40_n36: return 0.0193842314183712f;
  t40_n37: return -0.020749235525727272f;
  t40_n38: return 0.020912908017635345f;
  t40_n39: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t40_n41;
  t40_n40: return -0.04704952985048294f;
  t40_n41: if (E.getFractionNameInContext() >= 3169944461 /*0.02948167361319065*/) goto t40_n49;
  t40_n42: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope))) goto t40_n46;
  t40_n43: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t40_n45;
  t40_n44: return -0.04969378188252449f;
  t40_n45: return 0.031721893697977066f;
  t40_n46: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t40_n48;
  t40_n47: return -0.05773472785949707f;
  t40_n48: return 0.06628631800413132f;
  t40_n49: return -0.011938164941966534f;
  t40_n50: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t40_n52;
  t40_n51: return -0.05967314541339874f;
  t40_n52: return 0.01745135709643364f;
  t40_n53: return -0.08582422882318497f;
  t40_n54: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t40_n56;
  t40_n55: return 0.013795590028166771f;
  t40_n56: return 0.03214019909501076f;
  t40_n57: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t40_n65;
  t40_n58: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t40_n64;
  t40_n59: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t40_n61;
  t40_n60: return 0.038307659327983856f;
  t40_n61: if (E.getNumReferences() >= 3352510912 /*108163.5*/) goto t40_n63;
  t40_n62: return 0.023317668586969376f;
  t40_n63: return -0.13696540892124176f;
  t40_n64: return 0.0633639469742775f;
  t40_n65: if (E.getNumReferences() >= 3360228064 /*205835.5*/) goto t40_n69;
  t40_n66: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t40_n68;
  t40_n67: return 0.06572314351797104f;
  t40_n68: return 0.11302852630615234f;
  t40_n69: return 0.06624189764261246f;
  t40_n70: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t40_n80;
  t40_n71: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t40_n79;
  t40_n72: if (E.getSymbolScopeDistanceCost() >= 3246915584 /*17.0*/) goto t40_n74;
  t40_n73: return -0.0010286795441061258f;
  t40_n74: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t40_n76;
  t40_n75: return 0.006141636520624161f;
  t40_n76: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Namespace))) goto t40_n78;
  t40_n77: return 0.03717099130153656f;
  t40_n78: return 0.10589969158172607f;
  t40_n79: return -0.022082403302192688f;
  t40_n80: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t40_n86;
  t40_n81: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t40_n85;
  t40_n82: if (E.getNumReferences() >= 3239575552 /*9.5*/) goto t40_n84;
  t40_n83: return 0.008071331307291985f;
  t40_n84: return 0.030522853136062622f;
  t40_n85: return -0.09456981718540192f;
  t40_n86: return -0.06982482969760895f;
  t40_n87: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t40_n169;
  t40_n88: if (E.getNumReferences() >= 3282124800 /*322.5*/) goto t40_n154;
  t40_n89: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t40_n147;
  t40_n90: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t40_n146;
  t40_n91: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t40_n97;
  t40_n92: if (E.getNumReferences() >= 3241672704 /*11.5*/) goto t40_n96;
  t40_n93: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t40_n95;
  t40_n94: return 0.01886199228465557f;
  t40_n95: return -0.008867981843650341f;
  t40_n96: return 0.03668927401304245f;
  t40_n97: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t40_n139;
  t40_n98: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t40_n136;
  t40_n99: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t40_n135;
  t40_n100: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t40_n134;
  t40_n101: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag))) goto t40_n133;
  t40_n102: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t40_n108;
  t40_n103: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t40_n107;
  t40_n104: if (E.getNumReferences() >= 3259629568 /*50.5*/) goto t40_n106;
  t40_n105: return 0.008436043746769428f;
  t40_n106: return 0.05241475999355316f;
  t40_n107: return -0.01803339459002018f;
  t40_n108: if (E.getSymbolScopeDistanceCost() >= 3246915584 /*17.0*/) goto t40_n110;
  t40_n109: return -1.533644535811618e-05f;
  t40_n110: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t40_n132;
  t40_n111: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t40_n131;
  t40_n112: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t40_n130;
  t40_n113: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t40_n127;
  t40_n114: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t40_n116;
  t40_n115: return 0.008227440528571606f;
  t40_n116: if (E.getFileProximityDistanceCost() >= 3248750592 /*20.5*/) goto t40_n124;
  t40_n117: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t40_n123;
  t40_n118: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t40_n122;
  t40_n119: if (E.getFileProximityDistanceCost() >= 3247177728 /*17.5*/) goto t40_n121;
  t40_n120: return 0.07503126561641693f;
  t40_n121: return 0.007305358070880175f;
  t40_n122: return 0.0612969845533371f;
  t40_n123: return -0.03825628384947777f;
  t40_n124: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Type))) goto t40_n126;
  t40_n125: return 0.059452105313539505f;
  t40_n126: return 0.08682917803525925f;
  t40_n127: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator))) goto t40_n129;
  t40_n128: return -0.0239487886428833f;
  t40_n129: return 0.1136905625462532f;
  t40_n130: return -0.044714413583278656f;
  t40_n131: return -0.06434720754623413f;
  t40_n132: return -0.13996392488479614f;
  t40_n133: return 0.03900574520230293f;
  t40_n134: return -0.016195230185985565f;
  t40_n135: return 0.03226340934634209f;
  t40_n136: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t40_n138;
  t40_n137: return -0.06691122055053711f;
  t40_n138: return 0.0007991707534529269f;
  t40_n139: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t40_n145;
  t40_n140: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t40_n144;
  t40_n141: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t40_n143;
  t40_n142: return 0.021413566544651985f;
  t40_n143: return 0.0543600395321846f;
  t40_n144: return 0.05757106468081474f;
  t40_n145: return -0.02920818328857422f;
  t40_n146: return 0.017608605325222015f;
  t40_n147: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t40_n153;
  t40_n148: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t40_n150;
  t40_n149: return -0.013582654297351837f;
  t40_n150: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t40_n152;
  t40_n151: return 0.032912831753492355f;
  t40_n152: return 0.009580472484230995f;
  t40_n153: return 0.032856494188308716f;
  t40_n154: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t40_n160;
  t40_n155: if (E.getNumReferences() >= 3344481024 /*55483.0*/) goto t40_n159;
  t40_n156: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t40_n158;
  t40_n157: return 0.0588628426194191f;
  t40_n158: return 0.037967268377542496f;
  t40_n159: return 0.08108053356409073f;
  t40_n160: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t40_n168;
  t40_n161: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t40_n165;
  t40_n162: if (E.getNumReferences() >= 3356314496 /*144686.0*/) goto t40_n164;
  t40_n163: return -0.03413311392068863f;
  t40_n164: return 0.05824405327439308f;
  t40_n165: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t40_n167;
  t40_n166: return 0.024874171242117882f;
  t40_n167: return 0.06945423781871796f;
  t40_n168: return 0.05264727398753166f;
  t40_n169: if (E.getNumReferences() >= 3245867008 /*15.5*/) goto t40_n241;
  t40_n170: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t40_n172;
  t40_n171: return -0.0002237919979961589f;
  t40_n172: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t40_n198;
  t40_n173: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t40_n185;
  t40_n174: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t40_n182;
  t40_n175: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t40_n179;
  t40_n176: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t40_n178;
  t40_n177: return -0.012690775096416473f;
  t40_n178: return 0.021571990102529526f;
  t40_n179: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t40_n181;
  t40_n180: return -0.03988223150372505f;
  t40_n181: return 0.01787077635526657f;
  t40_n182: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t40_n184;
  t40_n183: return -0.10879069566726685f;
  t40_n184: return 0.03198476508259773f;
  t40_n185: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t40_n191;
  t40_n186: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t40_n190;
  t40_n187: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t40_n189;
  t40_n188: return 0.0052154590375721455f;
  t40_n189: return -0.05339672416448593f;
  t40_n190: return 0.032727357000112534f;
  t40_n191: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t40_n197;
  t40_n192: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t40_n194;
  t40_n193: return 0.01908930577337742f;
  t40_n194: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t40_n196;
  t40_n195: return 0.030692407861351967f;
  t40_n196: return 0.05779999867081642f;
  t40_n197: return -0.0033603881020098925f;
  t40_n198: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t40_n236;
  t40_n199: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t40_n207;
  t40_n200: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type))) goto t40_n202;
  t40_n201: return 0.011276130564510822f;
  t40_n202: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t40_n204;
  t40_n203: return 0.04437137022614479f;
  t40_n204: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t40_n206;
  t40_n205: return 0.009570405818521976f;
  t40_n206: return 0.0555516816675663f;
  t40_n207: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t40_n211;
  t40_n208: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t40_n210;
  t40_n209: return -0.02591586299240589f;
  t40_n210: return 0.018404025584459305f;
  t40_n211: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t40_n227;
  t40_n212: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t40_n218;
  t40_n213: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t40_n215;
  t40_n214: return 0.014211038127541542f;
  t40_n215: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel))) goto t40_n217;
  t40_n216: return 0.032622575759887695f;
  t40_n217: return 0.09438423812389374f;
  t40_n218: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t40_n220;
  t40_n219: return 0.03757208585739136f;
  t40_n220: if (E.getFractionNameInContext() >= 3205986168 /*0.5916666984558105*/) goto t40_n222;
  t40_n221: return 0.061686765402555466f;
  t40_n222: if (E.getNumNameInContext() >= 3230662656 /*4.5*/) goto t40_n226;
  t40_n223: if (E.getFractionNameInContext() >= 3208362940 /*0.7333333492279053*/) goto t40_n225;
  t40_n224: return 0.11031480878591537f;
  t40_n225: return 0.14848968386650085f;
  t40_n226: return 0.0816197469830513f;
  t40_n227: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t40_n229;
  t40_n228: return 0.058607008308172226f;
  t40_n229: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t40_n231;
  t40_n230: return 0.081576868891716f;
  t40_n231: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t40_n233;
  t40_n232: return 0.09705815464258194f;
  t40_n233: if (E.getNumNameInContext() >= 3230662656 /*4.5*/) goto t40_n235;
  t40_n234: return 0.14058150351047516f;
  t40_n235: return 0.06317593157291412f;
  t40_n236: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t40_n238;
  t40_n237: return 0.014909236691892147f;
  t40_n238: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t40_n240;
  t40_n239: return 0.03355460241436958f;
  t40_n240: return 0.06140381097793579f;
  t40_n241: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t40_n243;
  t40_n242: return 0.054394517093896866f;
  t40_n243: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t40_n251;
  t40_n244: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t40_n250;
  t40_n245: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t40_n247;
  t40_n246: return 0.014223232865333557f;
  t40_n247: if (E.getNumReferences() >= 3273359360 /*155.5*/) goto t40_n249;
  t40_n248: return 0.027914749458432198f;
  t40_n249: return 0.053342465311288834f;
  t40_n250: return 0.0708228051662445f;
  t40_n251: return 0.09247854351997375f;
  t40_n252: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t40_n254;
  t40_n253: return 0.04527038708329201f;
  t40_n254: return 0.08088694512844086f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree41(const Example& E) {
  t41_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t41_n252;
  t41_n1: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t41_n131;
  t41_n2: if (E.getNumReferences() >= 3284844544 /*405.5*/) goto t41_n122;
  t41_n3: if (E.getFileProximityDistanceCost() >= 3257139200 /*41.0*/) goto t41_n109;
  t41_n4: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t41_n92;
  t41_n5: if (E.getFileProximityDistanceCost() >= 3232759808 /*5.5*/) goto t41_n9;
  t41_n6: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t41_n8;
  t41_n7: return 0.004293951205909252f;
  t41_n8: return 0.03974546492099762f;
  t41_n9: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t41_n83;
  t41_n10: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t41_n12;
  t41_n11: return -0.08404054492712021f;
  t41_n12: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t41_n82;
  t41_n13: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t41_n79;
  t41_n14: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t41_n78;
  t41_n15: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t41_n77;
  t41_n16: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t41_n38;
  t41_n17: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t41_n33;
  t41_n18: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t41_n22;
  t41_n19: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t41_n21;
  t41_n20: return -0.1223851889371872f;
  t41_n21: return -0.022835006937384605f;
  t41_n22: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t41_n28;
  t41_n23: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t41_n27;
  t41_n24: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t41_n26;
  t41_n25: return -0.006472584325820208f;
  t41_n26: return 0.019535329192876816f;
  t41_n27: return -0.007512901443988085f;
  t41_n28: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t41_n32;
  t41_n29: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t41_n31;
  t41_n30: return -0.08977425843477249f;
  t41_n31: return -0.07180455327033997f;
  t41_n32: return 0.020372774451971054f;
  t41_n33: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t41_n37;
  t41_n34: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t41_n36;
  t41_n35: return -0.07328976690769196f;
  t41_n36: return 0.012053352780640125f;
  t41_n37: return 0.05993553623557091f;
  t41_n38: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t41_n40;
  t41_n39: return -0.05327226221561432f;
  t41_n40: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t41_n54;
  t41_n41: if (E.getFileProximityDistanceCost() >= 3244818432 /*14.5*/) goto t41_n51;
  t41_n42: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t41_n46;
  t41_n43: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t41_n45;
  t41_n44: return 0.023206740617752075f;
  t41_n45: return -0.02330644801259041f;
  t41_n46: if (E.getFractionNameInContext() >= 3169944461 /*0.02948167361319065*/) goto t41_n48;
  t41_n47: return 0.01900104247033596f;
  t41_n48: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t41_n50;
  t41_n49: return 0.08372855186462402f;
  t41_n50: return 0.07760735601186752f;
  t41_n51: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t41_n53;
  t41_n52: return -0.1335676610469818f;
  t41_n53: return -0.02306448668241501f;
  t41_n54: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t41_n72;
  t41_n55: if (E.getFractionNameInContext() >= 3169944461 /*0.02948167361319065*/) goto t41_n59;
  t41_n56: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t41_n58;
  t41_n57: return 0.028493527323007584f;
  t41_n58: return -0.050133559852838516f;
  t41_n59: if (E.getFileProximityDistanceCost() >= 3246653440 /*16.5*/) goto t41_n63;
  t41_n60: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t41_n62;
  t41_n61: return -0.11593843996524811f;
  t41_n62: return 0.0862189456820488f;
  t41_n63: if (E.getFileProximityDistanceCost() >= 3247177728 /*17.5*/) goto t41_n65;
  t41_n64: return -0.18768759071826935f;
  t41_n65: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t41_n67;
  t41_n66: return 0.07334847748279572f;
  t41_n67: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t41_n69;
  t41_n68: return -0.15344323217868805f;
  t41_n69: if (E.getFileProximityDistanceCost() >= 3248750592 /*20.5*/) goto t41_n71;
  t41_n70: return 0.07697252929210663f;
  t41_n71: return 0.019401676952838898f;
  t41_n72: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Type))) goto t41_n74;
  t41_n73: return 0.025678280740976334f;
  t41_n74: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t41_n76;
  t41_n75: return 0.03785388544201851f;
  t41_n76: return 0.05834886059165001f;
  t41_n77: return -0.11316832900047302f;
  t41_n78: return -0.0499640554189682f;
  t41_n79: if (E.getSymbolScopeDistanceCost() >= 3241148416 /*11.0*/) goto t41_n81;
  t41_n80: return -0.010602391324937344f;
  t41_n81: return 0.029938040301203728f;
  t41_n82: return -0.11909741163253784f;
  t41_n83: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t41_n85;
  t41_n84: return -0.10010933130979538f;
  t41_n85: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t41_n91;
  t41_n86: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t41_n88;
  t41_n87: return 0.00549098988994956f;
  t41_n88: if (E.getNumReferences() >= 3283648512 /*369.0*/) goto t41_n90;
  t41_n89: return 0.06365174055099487f;
  t41_n90: return 0.141992449760437f;
  t41_n91: return -0.04935052618384361f;
  t41_n92: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t41_n102;
  t41_n93: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t41_n99;
  t41_n94: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t41_n96;
  t41_n95: return 0.016931844875216484f;
  t41_n96: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function))) goto t41_n98;
  t41_n97: return 0.03878118470311165f;
  t41_n98: return 0.07149403542280197f;
  t41_n99: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t41_n101;
  t41_n100: return -0.19812782108783722f;
  t41_n101: return -0.030021555721759796f;
  t41_n102: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t41_n106;
  t41_n103: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t41_n105;
  t41_n104: return -0.05302973464131355f;
  t41_n105: return 0.013508794829249382f;
  t41_n106: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t41_n108;
  t41_n107: return -0.14870744943618774f;
  t41_n108: return 0.024752601981163025f;
  t41_n109: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t41_n117;
  t41_n110: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_UnionTag))) goto t41_n116;
  t41_n111: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t41_n113;
  t41_n112: return -0.005724295508116484f;
  t41_n113: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t41_n115;
  t41_n114: return 0.006956339813768864f;
  t41_n115: return 0.04830893129110336f;
  t41_n116: return 0.058319319039583206f;
  t41_n117: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t41_n121;
  t41_n118: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t41_n120;
  t41_n119: return -0.07392647117376328f;
  t41_n120: return 0.015348617918789387f;
  t41_n121: return -0.08001692593097687f;
  t41_n122: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t41_n128;
  t41_n123: if (E.getNumReferences() >= 3347876160 /*71954.5*/) goto t41_n127;
  t41_n124: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t41_n126;
  t41_n125: return 0.022774750366806984f;
  t41_n126: return 0.053899794816970825f;
  t41_n127: return 0.055069807916879654f;
  t41_n128: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t41_n130;
  t41_n129: return -0.001491633476689458f;
  t41_n130: return 0.030158013105392456f;
  t41_n131: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t41_n185;
  t41_n132: if (E.getNumReferences() >= 3275718656 /*191.5*/) goto t41_n174;
  t41_n133: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t41_n169;
  t41_n134: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t41_n168;
  t41_n135: if (E.getFileProximityDistanceCost() >= 3234856960 /*6.5*/) goto t41_n141;
  t41_n136: if (E.getNumReferences() >= 3227516928 /*3.5*/) goto t41_n140;
  t41_n137: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t41_n139;
  t41_n138: return 0.018569378182291985f;
  t41_n139: return -0.012604273855686188f;
  t41_n140: return 0.029264051467180252f;
  t41_n141: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t41_n159;
  t41_n142: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t41_n156;
  t41_n143: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t41_n155;
  t41_n144: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t41_n148;
  t41_n145: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t41_n147;
  t41_n146: return 0.0061858962289988995f;
  t41_n147: return -0.010098634287714958f;
  t41_n148: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t41_n150;
  t41_n149: return -0.09675932675600052f;
  t41_n150: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t41_n152;
  t41_n151: return 0.03426700085401535f;
  t41_n152: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t41_n154;
  t41_n153: return 0.04701763391494751f;
  t41_n154: return -0.05271638184785843f;
  t41_n155: return 0.030747106298804283f;
  t41_n156: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t41_n158;
  t41_n157: return -0.06483130902051926f;
  t41_n158: return 0.0006218614289537072f;
  t41_n159: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t41_n167;
  t41_n160: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t41_n164;
  t41_n161: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t41_n163;
  t41_n162: return 0.016858655959367752f;
  t41_n163: return 0.05108210816979408f;
  t41_n164: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t41_n166;
  t41_n165: return -0.19395852088928223f;
  t41_n166: return 0.040911026298999786f;
  t41_n167: return -0.028432579711079597f;
  t41_n168: return 0.01672441139817238f;
  t41_n169: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t41_n173;
  t41_n170: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t41_n172;
  t41_n171: return -0.0038174453657120466f;
  t41_n172: return 0.01770881377160549f;
  t41_n173: return 0.041394416242837906f;
  t41_n174: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t41_n180;
  t41_n175: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t41_n179;
  t41_n176: if (E.getNumReferences() >= 3332112384 /*19968.0*/) goto t41_n178;
  t41_n177: return 0.02688945084810257f;
  t41_n178: return 0.06017206609249115f;
  t41_n179: return 0.06182088702917099f;
  t41_n180: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t41_n182;
  t41_n181: return 0.07545313984155655f;
  t41_n182: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t41_n184;
  t41_n183: return 0.012904117815196514f;
  t41_n184: return 0.06394483149051666f;
  t41_n185: if (E.getNumReferences() >= 3257532416 /*42.5*/) goto t41_n247;
  t41_n186: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t41_n188;
  t41_n187: return 0.0020503797568380833f;
  t41_n188: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t41_n200;
  t41_n189: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t41_n193;
  t41_n190: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t41_n192;
  t41_n191: return 0.009166265837848186f;
  t41_n192: return 0.02758074551820755f;
  t41_n193: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t41_n197;
  t41_n194: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t41_n196;
  t41_n195: return 0.0036075946409255266f;
  t41_n196: return 0.03203694522380829f;
  t41_n197: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t41_n199;
  t41_n198: return 0.03062661550939083f;
  t41_n199: return -0.0011833257740363479f;
  t41_n200: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t41_n242;
  t41_n201: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t41_n207;
  t41_n202: if (E.getNumReferences() >= 3223322624 /*2.5*/) goto t41_n206;
  t41_n203: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type))) goto t41_n205;
  t41_n204: return 0.002108566462993622f;
  t41_n205: return 0.03442618250846863f;
  t41_n206: return 0.04604951664805412f;
  t41_n207: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t41_n221;
  t41_n208: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope)|BIT(Scope_type::GlobalScope))) goto t41_n210;
  t41_n209: return -0.08435504138469696f;
  t41_n210: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t41_n212;
  t41_n211: return -0.001991087105125189f;
  t41_n212: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t41_n220;
  t41_n213: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t41_n219;
  t41_n214: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t41_n216;
  t41_n215: return -0.02703542448580265f;
  t41_n216: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t41_n218;
  t41_n217: return 0.07348038256168365f;
  t41_n218: return -0.04658140242099762f;
  t41_n219: return 0.10421523451805115f;
  t41_n220: return 0.034524306654930115f;
  t41_n221: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t41_n233;
  t41_n222: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t41_n228;
  t41_n223: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t41_n225;
  t41_n224: return 0.013923595659434795f;
  t41_n225: if (E.getContextKind() & (BIT(ContextKind_type::CCC_TopLevel))) goto t41_n227;
  t41_n226: return 0.03491311892867088f;
  t41_n227: return 0.0922655388712883f;
  t41_n228: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t41_n230;
  t41_n229: return 0.03559430316090584f;
  t41_n230: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Symbol))) goto t41_n232;
  t41_n231: return 0.0676032304763794f;
  t41_n232: return 0.1015326976776123f;
  t41_n233: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t41_n235;
  t41_n234: return 0.05624141916632652f;
  t41_n235: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t41_n237;
  t41_n236: return 0.08137117326259613f;
  t41_n237: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t41_n239;
  t41_n238: return 0.08897016197443008f;
  t41_n239: if (E.getFractionNameInContext() >= 3202753588 /*0.44949495792388916*/) goto t41_n241;
  t41_n240: return 0.13480313122272491f;
  t41_n241: return 0.10245257616043091f;
  t41_n242: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t41_n244;
  t41_n243: return 0.01641356758773327f;
  t41_n244: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t41_n246;
  t41_n245: return 0.031370192766189575f;
  t41_n246: return 0.05939238518476486f;
  t41_n247: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t41_n249;
  t41_n248: return 0.061280228197574615f;
  t41_n249: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t41_n251;
  t41_n250: return 0.03846067190170288f;
  t41_n251: return 0.09008751809597015f;
  t41_n252: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t41_n254;
  t41_n253: return 0.0383763462305069f;
  t41_n254: return 0.056582771241664886f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree42(const Example& E) {
  t42_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t42_n252;
  t42_n1: if (E.getNumNameInContext() >= 3204448256 /*0.5*/) goto t42_n119;
  t42_n2: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t42_n52;
  t42_n3: if (E.getNumReferences() >= 3308636160 /*2908.5*/) goto t42_n43;
  t42_n4: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t42_n22;
  t42_n5: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t42_n19;
  t42_n6: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t42_n18;
  t42_n7: if (E.getScope() & (BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t42_n17;
  t42_n8: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t42_n10;
  t42_n9: return -0.11440881341695786f;
  t42_n10: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t42_n16;
  t42_n11: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t42_n15;
  t42_n12: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t42_n14;
  t42_n13: return 0.0024396658409386873f;
  t42_n14: return -0.09061284363269806f;
  t42_n15: return -0.034083347767591476f;
  t42_n16: return -0.12529128789901733f;
  t42_n17: return 0.04578683525323868f;
  t42_n18: return -0.02737162448465824f;
  t42_n19: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t42_n21;
  t42_n20: return 0.01363146398216486f;
  t42_n21: return -0.02193453162908554f;
  t42_n22: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t42_n24;
  t42_n23: return -0.07799830287694931f;
  t42_n24: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t42_n42;
  t42_n25: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t42_n41;
  t42_n26: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_UnionTag))) goto t42_n32;
  t42_n27: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t42_n29;
  t42_n28: return 0.004220736678689718f;
  t42_n29: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t42_n31;
  t42_n30: return 0.00670249667018652f;
  t42_n31: return 0.03280336782336235f;
  t42_n32: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t42_n40;
  t42_n33: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t42_n35;
  t42_n34: return -0.01807071454823017f;
  t42_n35: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t42_n37;
  t42_n36: return 0.014596058055758476f;
  t42_n37: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t42_n39;
  t42_n38: return 0.11986848711967468f;
  t42_n39: return 0.038290102034807205f;
  t42_n40: return 0.029941553249955177f;
  t42_n41: return -0.04882432520389557f;
  t42_n42: return 0.028898194432258606f;
  t42_n43: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t42_n47;
  t42_n44: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t42_n46;
  t42_n45: return 0.028305046260356903f;
  t42_n46: return 0.059811633080244064f;
  t42_n47: if (E.getNumReferences() >= 3309029376 /*3004.5*/) goto t42_n51;
  t42_n48: if (E.getNumReferences() >= 3308949504 /*2985.0*/) goto t42_n50;
  t42_n49: return 0.06550242006778717f;
  t42_n50: return 0.15305960178375244f;
  t42_n51: return 0.06397901475429535f;
  t42_n52: if (E.getNumReferences() >= 3376956888 /*820317.5*/) goto t42_n118;
  t42_n53: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t42_n113;
  t42_n54: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t42_n110;
  t42_n55: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t42_n83;
  t42_n56: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t42_n70;
  t42_n57: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t42_n67;
  t42_n58: if (E.getNumReferences() >= 3362537216 /*241916.0*/) goto t42_n66;
  t42_n59: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t42_n65;
  t42_n60: if (E.getNumReferences() >= 3359032704 /*187158.0*/) goto t42_n62;
  t42_n61: return -0.017816107720136642f;
  t42_n62: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t42_n64;
  t42_n63: return 0.0009674985776655376f;
  t42_n64: return 0.09374208748340607f;
  t42_n65: return -0.07079055160284042f;
  t42_n66: return -0.06777811050415039f;
  t42_n67: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t42_n69;
  t42_n68: return -0.35184887051582336f;
  t42_n69: return 0.04439201205968857f;
  t42_n70: if (E.getNumReferences() >= 3363896688 /*264171.5*/) goto t42_n78;
  t42_n71: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t42_n77;
  t42_n72: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t42_n74;
  t42_n73: return -0.0004405655199661851f;
  t42_n74: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t42_n76;
  t42_n75: return -0.04995359107851982f;
  t42_n76: return -0.0023943136911839247f;
  t42_n77: return 0.01749139465391636f;
  t42_n78: if (E.getNumReferences() >= 3364180016 /*273025.5*/) goto t42_n82;
  t42_n79: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t42_n81;
  t42_n80: return -0.127621591091156f;
  t42_n81: return 0.09695468097925186f;
  t42_n82: return 0.06353171914815903f;
  t42_n83: if (E.getNumReferences() >= 3347793152 /*71306.0*/) goto t42_n95;
  t42_n84: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t42_n94;
  t42_n85: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t42_n87;
  t42_n86: return -0.04668719694018364f;
  t42_n87: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t42_n89;
  t42_n88: return -0.10596001148223877f;
  t42_n89: if (E.getFileProximityDistanceCost() >= 3248750592 /*20.5*/) goto t42_n91;
  t42_n90: return 0.09342598915100098f;
  t42_n91: if (E.getSymbolScopeDistanceCost() >= 3472883712 /*2147483648.0*/) goto t42_n93;
  t42_n92: return 0.03155611455440521f;
  t42_n93: return 0.14130692183971405f;
  t42_n94: return 0.007711453828960657f;
  t42_n95: if (E.getNumReferences() >= 3362537216 /*241916.0*/) goto t42_n109;
  t42_n96: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t42_n98;
  t42_n97: return -0.11020558327436447f;
  t42_n98: if (E.getNumReferences() >= 3359032704 /*187158.0*/) goto t42_n100;
  t42_n99: return 0.06103358417749405f;
  t42_n100: if (E.getNumReferences() >= 3360334912 /*207505.0*/) goto t42_n104;
  t42_n101: if (E.getFractionNameInContext() >= 3169944461 /*0.02948167361319065*/) goto t42_n103;
  t42_n102: return 0.10905906558036804f;
  t42_n103: return 0.1381366103887558f;
  t42_n104: if (E.getNumReferences() >= 3362084992 /*234850.0*/) goto t42_n108;
  t42_n105: if (E.getNumReferences() >= 3361394368 /*224059.0*/) goto t42_n107;
  t42_n106: return 0.06750861555337906f;
  t42_n107: return -0.2574765980243683f;
  t42_n108: return 0.11200857907533646f;
  t42_n109: return -0.01355533953756094f;
  t42_n110: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers))) goto t42_n112;
  t42_n111: return -0.11234042048454285f;
  t42_n112: return -0.04062904417514801f;
  t42_n113: if (E.getNumReferences() >= 3270705152 /*121.5*/) goto t42_n117;
  t42_n114: if (E.getSymbolScopeDistanceCost() >= 3241148416 /*11.0*/) goto t42_n116;
  t42_n115: return -0.021861586719751358f;
  t42_n116: return 0.015200980007648468f;
  t42_n117: return 0.04641721025109291f;
  t42_n118: return 0.049207307398319244f;
  t42_n119: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t42_n201;
  t42_n120: if (E.getNumReferences() >= 3275653120 /*190.5*/) goto t42_n182;
  t42_n121: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t42_n171;
  t42_n122: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t42_n166;
  t42_n123: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t42_n139;
  t42_n124: if (E.getNumReferences() >= 3251896320 /*26.5*/) goto t42_n138;
  t42_n125: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t42_n129;
  t42_n126: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t42_n128;
  t42_n127: return 0.0007710344507358968f;
  t42_n128: return -0.0530339851975441f;
  t42_n129: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t42_n131;
  t42_n130: return -0.007538147270679474f;
  t42_n131: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t42_n135;
  t42_n132: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_TopLevel))) goto t42_n134;
  t42_n133: return 0.010754481889307499f;
  t42_n134: return 0.029473554342985153f;
  t42_n135: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t42_n137;
  t42_n136: return 0.012968970462679863f;
  t42_n137: return 0.04501194879412651f;
  t42_n138: return 0.03956266865134239f;
  t42_n139: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t42_n141;
  t42_n140: return -0.01877599023282528f;
  t42_n141: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Type))) goto t42_n161;
  t42_n142: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::FileScope)|BIT(Scope_type::FunctionScope))) goto t42_n160;
  t42_n143: if (E.getFileProximityDistanceCost() >= 3256221696 /*37.5*/) goto t42_n159;
  t42_n144: if (E.getFileProximityDistanceCost() >= 3247702016 /*18.5*/) goto t42_n148;
  t42_n145: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t42_n147;
  t42_n146: return -0.00882644485682249f;
  t42_n147: return 0.039479129016399384f;
  t42_n148: if (E.getSymbolScopeDistanceCost() >= 3241148416 /*11.0*/) goto t42_n150;
  t42_n149: return -0.08299977332353592f;
  t42_n150: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t42_n158;
  t42_n151: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t42_n157;
  t42_n152: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t42_n156;
  t42_n153: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t42_n155;
  t42_n154: return -0.021077042445540428f;
  t42_n155: return 0.05656436085700989f;
  t42_n156: return -0.059632714837789536f;
  t42_n157: return -0.11760767549276352f;
  t42_n158: return -0.022641927003860474f;
  t42_n159: return -0.20077253878116608f;
  t42_n160: return 0.03287321329116821f;
  t42_n161: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t42_n165;
  t42_n162: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t42_n164;
  t42_n163: return 0.027070598676800728f;
  t42_n164: return 0.05584423989057541f;
  t42_n165: return -0.013477452099323273f;
  t42_n166: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t42_n170;
  t42_n167: if (E.getFileProximityDistanceCost() >= 3230662656 /*4.5*/) goto t42_n169;
  t42_n168: return 0.04357719048857689f;
  t42_n169: return 0.009565450251102448f;
  t42_n170: return 0.04588083177804947f;
  t42_n171: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t42_n177;
  t42_n172: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t42_n174;
  t42_n173: return -0.008417780511081219f;
  t42_n174: if (E.getSymbolScopeDistanceCost() >= 3231711232 /*5.0*/) goto t42_n176;
  t42_n175: return 0.03192295506596565f;
  t42_n176: return 0.008283640258014202f;
  t42_n177: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t42_n181;
  t42_n178: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t42_n180;
  t42_n179: return 0.02462034858763218f;
  t42_n180: return -0.0749669000506401f;
  t42_n181: return 0.05357442423701286f;
  t42_n182: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t42_n194;
  t42_n183: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t42_n193;
  t42_n184: if (E.getNumReferences() >= 3314739200 /*4701.0*/) goto t42_n188;
  t42_n185: if (E.getNumReferences() >= 3275784192 /*192.5*/) goto t42_n187;
  t42_n186: return 0.20917820930480957f;
  t42_n187: return 0.01375352218747139f;
  t42_n188: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t42_n192;
  t42_n189: if (E.getNumReferences() >= 3315203072 /*4927.5*/) goto t42_n191;
  t42_n190: return 0.13171693682670593f;
  t42_n191: return 0.0331350639462471f;
  t42_n192: return 0.10167955607175827f;
  t42_n193: return 0.059500742703676224f;
  t42_n194: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t42_n196;
  t42_n195: return 0.07163655757904053f;
  t42_n196: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t42_n200;
  t42_n197: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t42_n199;
  t42_n198: return 0.00955402385443449f;
  t42_n199: return 0.06298813968896866f;
  t42_n200: return 0.06167752668261528f;
  t42_n201: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t42_n247;
  t42_n202: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t42_n242;
  t42_n203: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t42_n209;
  t42_n204: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t42_n206;
  t42_n205: return -0.025320902466773987f;
  t42_n206: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t42_n208;
  t42_n207: return 0.014634810388088226f;
  t42_n208: return -0.08233275264501572f;
  t42_n209: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t42_n239;
  t42_n210: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t42_n238;
  t42_n211: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t42_n217;
  t42_n212: if (E.getFractionNameInContext() >= 3197638680 /*0.2970588207244873*/) goto t42_n216;
  t42_n213: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t42_n215;
  t42_n214: return 0.023588914424180984f;
  t42_n215: return -0.01361081749200821f;
  t42_n216: return 0.03327969089150429f;
  t42_n217: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t42_n237;
  t42_n218: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t42_n236;
  t42_n219: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t42_n221;
  t42_n220: return -0.015993401408195496f;
  t42_n221: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t42_n233;
  t42_n222: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t42_n226;
  t42_n223: if (E.getFileProximityDistanceCost() >= 3250847744 /*24.5*/) goto t42_n225;
  t42_n224: return 0.02184978872537613f;
  t42_n225: return -0.06821814924478531f;
  t42_n226: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t42_n228;
  t42_n227: return 0.002862169872969389f;
  t42_n228: if (E.getFractionNameInContext() >= 3206096018 /*0.5982142686843872*/) goto t42_n230;
  t42_n229: return 0.05058157071471214f;
  t42_n230: if (E.getFractionNameInContext() >= 3209761041 /*0.8166666626930237*/) goto t42_n232;
  t42_n231: return 0.12027976661920547f;
  t42_n232: return 0.056220170110464096f;
  t42_n233: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t42_n235;
  t42_n234: return 0.03546970337629318f;
  t42_n235: return 0.08491899818181992f;
  t42_n236: return 0.02195402793586254f;
  t42_n237: return -0.04927009344100952f;
  t42_n238: return 0.029972819611430168f;
  t42_n239: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t42_n241;
  t42_n240: return 0.03482617810368538f;
  t42_n241: return 0.07139187306165695f;
  t42_n242: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Symbol))) goto t42_n244;
  t42_n243: return 0.025290701538324356f;
  t42_n244: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t42_n246;
  t42_n245: return 0.04217825457453728f;
  t42_n246: return 0.09150570631027222f;
  t42_n247: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t42_n249;
  t42_n248: return 0.046156592667102814f;
  t42_n249: if (E.getNumReferences() >= 3278405632 /*232.5*/) goto t42_n251;
  t42_n250: return 0.021390579640865326f;
  t42_n251: return 0.044871728867292404f;
  t42_n252: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t42_n254;
  t42_n253: return 0.041573360562324524f;
  t42_n254: return 0.07842329144477844f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree43(const Example& E) {
  t43_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t43_n252;
  t43_n1: if (E.getIsNameInContext() >= 3204448256 /*0.5*/) goto t43_n115;
  t43_n2: if (E.getNumReferences() >= 3284844544 /*405.5*/) goto t43_n74;
  t43_n3: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t43_n49;
  t43_n4: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t43_n24;
  t43_n5: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t43_n9;
  t43_n6: if (E.getNumReferences() >= 3232759808 /*5.5*/) goto t43_n8;
  t43_n7: return -0.020184842869639397f;
  t43_n8: return 0.0046147010289132595f;
  t43_n9: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t43_n15;
  t43_n10: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t43_n14;
  t43_n11: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t43_n13;
  t43_n12: return -0.065738745033741f;
  t43_n13: return 0.0011773010483011603f;
  t43_n14: return -0.036426905542612076f;
  t43_n15: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t43_n23;
  t43_n16: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t43_n20;
  t43_n17: if (E.getFractionNameInContext() >= 3169944461 /*0.02948167361319065*/) goto t43_n19;
  t43_n18: return 0.014923159033060074f;
  t43_n19: return 0.06910571455955505f;
  t43_n20: if (E.getScope() & (BIT(Scope_type::FunctionScope)|BIT(Scope_type::GlobalScope))) goto t43_n22;
  t43_n21: return -0.05319187045097351f;
  t43_n22: return 0.0712495818734169f;
  t43_n23: return -0.08220823854207993f;
  t43_n24: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Variable))) goto t43_n32;
  t43_n25: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_UnionTag))) goto t43_n27;
  t43_n26: return -0.013038529083132744f;
  t43_n27: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t43_n31;
  t43_n28: if (E.getNumReferences() >= 3275784192 /*192.5*/) goto t43_n30;
  t43_n29: return 0.015722934156656265f;
  t43_n30: return 0.07379202544689178f;
  t43_n31: return 0.07379497587680817f;
  t43_n32: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t43_n48;
  t43_n33: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t43_n35;
  t43_n34: return 0.015206053853034973f;
  t43_n35: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t43_n39;
  t43_n36: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t43_n38;
  t43_n37: return -0.12360826879739761f;
  t43_n38: return 0.003715314669534564f;
  t43_n39: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t43_n47;
  t43_n40: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t43_n44;
  t43_n41: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t43_n43;
  t43_n42: return -0.006544902920722961f;
  t43_n43: return 0.04252394288778305f;
  t43_n44: if (E.getNumReferences() >= 3282141184 /*323.0*/) goto t43_n46;
  t43_n45: return 0.05761278048157692f;
  t43_n46: return 0.15599288046360016f;
  t43_n47: return 0.05216791853308678f;
  t43_n48: return -0.07899399846792221f;
  t43_n49: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t43_n61;
  t43_n50: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t43_n54;
  t43_n51: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t43_n53;
  t43_n52: return -0.014528091065585613f;
  t43_n53: return -0.11243508011102676f;
  t43_n54: if (E.getFileProximityDistanceCost() >= 3241672704 /*11.5*/) goto t43_n58;
  t43_n55: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t43_n57;
  t43_n56: return -0.0417327880859375f;
  t43_n57: return 0.03583855554461479f;
  t43_n58: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t43_n60;
  t43_n59: return -0.04495887830853462f;
  t43_n60: return 0.03670765459537506f;
  t43_n61: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t43_n73;
  t43_n62: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t43_n64;
  t43_n63: return -0.025302479043602943f;
  t43_n64: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t43_n68;
  t43_n65: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t43_n67;
  t43_n66: return 0.01702168397605419f;
  t43_n67: return 0.06261057406663895f;
  t43_n68: if (E.getFractionNameInContext() >= 3169944461 /*0.02948167361319065*/) goto t43_n70;
  t43_n69: return 0.05948223918676376f;
  t43_n70: if (E.getNumReferences() >= 3242721280 /*12.5*/) goto t43_n72;
  t43_n71: return 0.15799188613891602f;
  t43_n72: return 0.07200003415346146f;
  t43_n73: return -0.0712391659617424f;
  t43_n74: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t43_n80;
  t43_n75: if (E.getNumReferences() >= 3347876160 /*71954.5*/) goto t43_n77;
  t43_n76: return 0.02417183294892311f;
  t43_n77: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t43_n79;
  t43_n78: return 0.04801947623491287f;
  t43_n79: return 0.0972171425819397f;
  t43_n80: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t43_n114;
  t43_n81: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t43_n85;
  t43_n82: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown))) goto t43_n84;
  t43_n83: return -0.03568938001990318f;
  t43_n84: return 0.03681467846035957f;
  t43_n85: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t43_n103;
  t43_n86: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t43_n90;
  t43_n87: if (E.getNumReferences() >= 3344808448 /*56762.0*/) goto t43_n89;
  t43_n88: return -0.05170828476548195f;
  t43_n89: return -0.15655069053173065f;
  t43_n90: if (E.getNumReferences() >= 3359314816 /*191566.0*/) goto t43_n92;
  t43_n91: return 0.008970317430794239f;
  t43_n92: if (E.getNumReferences() >= 3361088608 /*219281.5*/) goto t43_n96;
  t43_n93: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t43_n95;
  t43_n94: return -0.24054081737995148f;
  t43_n95: return 0.09699857980012894f;
  t43_n96: if (E.getNumReferences() >= 3363889440 /*263945.0*/) goto t43_n98;
  t43_n97: return -0.061111148446798325f;
  t43_n98: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t43_n100;
  t43_n99: return -0.07268907874822617f;
  t43_n100: if (E.getNumReferences() >= 3364994640 /*298482.5*/) goto t43_n102;
  t43_n101: return 0.08979954570531845f;
  t43_n102: return -0.17751248180866241f;
  t43_n103: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t43_n105;
  t43_n104: return 0.005696565378457308f;
  t43_n105: if (E.getNumReferences() >= 3346546048 /*63549.5*/) goto t43_n109;
  t43_n106: if (E.getFractionNameInContext() >= 3169944461 /*0.02948167361319065*/) goto t43_n108;
  t43_n107: return 0.03943123668432236f;
  t43_n108: return -0.06436473876237869f;
  t43_n109: if (E.getNumReferences() >= 3362537216 /*241916.0*/) goto t43_n113;
  t43_n110: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t43_n112;
  t43_n111: return 0.010400199331343174f;
  t43_n112: return 0.08333856612443924f;
  t43_n113: return 0.0005596401751972735f;
  t43_n114: return 0.02773132547736168f;
  t43_n115: if (E.getNumNameInContext() >= 3217031168 /*1.5*/) goto t43_n177;
  t43_n116: if (E.getNumReferences() >= 3275653120 /*190.5*/) goto t43_n168;
  t43_n117: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t43_n163;
  t43_n118: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t43_n160;
  t43_n119: if (E.getFileProximityDistanceCost() >= 3239575552 /*9.5*/) goto t43_n133;
  t43_n120: if (E.getNumReferences() >= 3230662656 /*4.5*/) goto t43_n130;
  t43_n121: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t43_n125;
  t43_n122: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t43_n124;
  t43_n123: return 0.013100171461701393f;
  t43_n124: return 0.0256027989089489f;
  t43_n125: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t43_n127;
  t43_n126: return -0.07205265015363693f;
  t43_n127: if (E.getFileProximityDistanceCost() >= 3230662656 /*4.5*/) goto t43_n129;
  t43_n128: return 0.024108482524752617f;
  t43_n129: return -0.040832217782735825f;
  t43_n130: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type))) goto t43_n132;
  t43_n131: return 0.029482562094926834f;
  t43_n132: return 0.04861900210380554f;
  t43_n133: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t43_n159;
  t43_n134: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t43_n156;
  t43_n135: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag))) goto t43_n153;
  t43_n136: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t43_n138;
  t43_n137: return -0.0735803097486496f;
  t43_n138: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t43_n140;
  t43_n139: return -0.0046876175329089165f;
  t43_n140: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t43_n152;
  t43_n141: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t43_n145;
  t43_n142: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t43_n144;
  t43_n143: return 0.004417781252413988f;
  t43_n144: return -0.047685299068689346f;
  t43_n145: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t43_n151;
  t43_n146: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t43_n148;
  t43_n147: return 0.02754506655037403f;
  t43_n148: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t43_n150;
  t43_n149: return -0.012047077529132366f;
  t43_n150: return 0.0786629244685173f;
  t43_n151: return -0.024203669279813766f;
  t43_n152: return -0.11371316015720367f;
  t43_n153: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t43_n155;
  t43_n154: return -0.12653855979442596f;
  t43_n155: return 0.053060054779052734f;
  t43_n156: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t43_n158;
  t43_n157: return -0.04125671461224556f;
  t43_n158: return -0.00048645713832229376f;
  t43_n159: return -0.037620335817337036f;
  t43_n160: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t43_n162;
  t43_n161: return 0.012112072668969631f;
  t43_n162: return 0.04469988867640495f;
  t43_n163: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t43_n167;
  t43_n164: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t43_n166;
  t43_n165: return -0.00270156585611403f;
  t43_n166: return 0.016339482739567757f;
  t43_n167: return 0.03783193603157997f;
  t43_n168: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t43_n172;
  t43_n169: if (E.getNumReferences() >= 3344481024 /*55483.0*/) goto t43_n171;
  t43_n170: return 0.0424567349255085f;
  t43_n171: return 0.07781830430030823f;
  t43_n172: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t43_n174;
  t43_n173: return 0.06865949183702469f;
  t43_n174: if (E.getNumReferences() >= 3364464848 /*281926.5*/) goto t43_n176;
  t43_n175: return 0.011888988316059113f;
  t43_n176: return 0.05882170796394348f;
  t43_n177: if (E.getNumReferences() >= 3234856960 /*6.5*/) goto t43_n243;
  t43_n178: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t43_n226;
  t43_n179: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t43_n185;
  t43_n180: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t43_n182;
  t43_n181: return -0.022766271606087685f;
  t43_n182: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t43_n184;
  t43_n183: return 0.01395344827324152f;
  t43_n184: return -0.08237181603908539f;
  t43_n185: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t43_n223;
  t43_n186: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t43_n222;
  t43_n187: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t43_n199;
  t43_n188: if (E.getFractionNameInContext() >= 3202317816 /*0.4365079402923584*/) goto t43_n198;
  t43_n189: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t43_n197;
  t43_n190: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t43_n192;
  t43_n191: return -0.0067428844049572945f;
  t43_n192: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t43_n196;
  t43_n193: if (E.getSymbolScopeDistanceCost() >= 3212836864 /*1.0*/) goto t43_n195;
  t43_n194: return 0.03406781703233719f;
  t43_n195: return 0.013970296829938889f;
  t43_n196: return 0.03796696662902832f;
  t43_n197: return -0.0010246318997815251f;
  t43_n198: return 0.039972517639398575f;
  t43_n199: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t43_n221;
  t43_n200: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t43_n208;
  t43_n201: if (E.getSymbolScopeDistanceCost() >= 3235905536 /*7.0*/) goto t43_n203;
  t43_n202: return -0.014954203739762306f;
  t43_n203: if (E.getScope() & (BIT(Scope_type::ClassScope))) goto t43_n205;
  t43_n204: return 0.0018611741252243519f;
  t43_n205: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t43_n207;
  t43_n206: return 0.032550498843193054f;
  t43_n207: return 0.08356624841690063f;
  t43_n208: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t43_n220;
  t43_n209: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t43_n215;
  t43_n210: if (E.getScope() & (BIT(Scope_type::FileScope))) goto t43_n214;
  t43_n211: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t43_n213;
  t43_n212: return -0.015591593459248543f;
  t43_n213: return 0.024816883727908134f;
  t43_n214: return 0.07276642322540283f;
  t43_n215: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t43_n217;
  t43_n216: return -0.21058300137519836f;
  t43_n217: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::GlobalScope))) goto t43_n219;
  t43_n218: return 0.022947175428271294f;
  t43_n219: return 0.05346151813864708f;
  t43_n220: return 0.005785374902188778f;
  t43_n221: return -0.04506896808743477f;
  t43_n222: return 0.028497571125626564f;
  t43_n223: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement))) goto t43_n225;
  t43_n224: return 0.032930709421634674f;
  t43_n225: return 0.054128605872392654f;
  t43_n226: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_Symbol))) goto t43_n228;
  t43_n227: return 0.02448778599500656f;
  t43_n228: if (E.getNumNameInContext() >= 3223322624 /*2.5*/) goto t43_n230;
  t43_n229: return 0.03276113420724869f;
  t43_n230: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t43_n232;
  t43_n231: return 0.04890785366296768f;
  t43_n232: if (E.getFileProximityDistanceCost() >= 3248226304 /*19.5*/) goto t43_n234;
  t43_n233: return 0.023465260863304138f;
  t43_n234: if (E.getNumNameInContext() >= 3227516928 /*3.5*/) goto t43_n236;
  t43_n235: return 0.0767349973320961f;
  t43_n236: if (E.getFractionNameInContext() >= 3206335693 /*0.612500011920929*/) goto t43_n242;
  t43_n237: if (E.getFractionNameInContext() >= 3199763709 /*0.3603896200656891*/) goto t43_n239;
  t43_n238: return -0.20422066748142242f;
  t43_n239: if (E.getNumNameInContext() >= 3230662656 /*4.5*/) goto t43_n241;
  t43_n240: return 0.1392282098531723f;
  t43_n241: return 0.07145605236291885f;
  t43_n242: return 0.04755246266722679f;
  t43_n243: if (E.getFileProximityDistanceCost() >= 3240624128 /*10.5*/) goto t43_n245;
  t43_n244: return 0.04460899904370308f;
  t43_n245: if (E.getNumReferences() >= 3325673472 /*11888.0*/) goto t43_n251;
  t43_n246: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_Type))) goto t43_n250;
  t43_n247: if (E.getSemaFileProximityScore() >= 3197737370 /*0.30000001192092896*/) goto t43_n249;
  t43_n248: return 0.004659419413655996f;
  t43_n249: return 0.054664235562086105f;
  t43_n250: return 0.029625078663229942f;
  t43_n251: return 0.05948670953512192f;
  t43_n252: if (E.getFractionNameInContext() >= 3178807750 /*0.0607316717505455*/) goto t43_n254;
  t43_n253: return 0.03451225534081459f;
  t43_n254: return 0.05317814648151398f;
}

LLVM_ATTRIBUTE_NOINLINE float EvaluateTree44(const Example& E) {
  t44_n0: if (E.getScope() & (BIT(Scope_type::FunctionScope))) goto t44_n252;
  t44_n1: if (E.getFractionNameInContext() >= 3189477818 /*0.15192309021949768*/) goto t44_n181;
  t44_n2: if (E.getNumReferences() >= 3338822784 /*33380.5*/) goto t44_n174;
  t44_n3: if (E.getSymbolScopeDistanceCost() >= 3225419776 /*3.0*/) goto t44_n107;
  t44_n4: if (E.getNumReferences() >= 3260153856 /*52.5*/) goto t44_n94;
  t44_n5: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t44_n43;
  t44_n6: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t44_n8;
  t44_n7: return -0.016183285042643547f;
  t44_n8: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t44_n42;
  t44_n9: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Type))) goto t44_n39;
  t44_n10: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t44_n32;
  t44_n11: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t44_n23;
  t44_n12: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t44_n14;
  t44_n13: return -0.09685542434453964f;
  t44_n14: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t44_n18;
  t44_n15: if (E.getHadSymbolType() >= 3204448256 /*0.5*/) goto t44_n17;
  t44_n16: return 0.03007105551660061f;
  t44_n17: return -0.03145531937479973f;
  t44_n18: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t44_n20;
  t44_n19: return 0.020232701674103737f;
  t44_n20: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function))) goto t44_n22;
  t44_n21: return 0.017553487792611122f;
  t44_n22: return 0.09331438690423965f;
  t44_n23: if (E.getIsDeprecated() >= 3204448256 /*0.5*/) goto t44_n31;
  t44_n24: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Statement)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t44_n28;
  t44_n25: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t44_n27;
  t44_n26: return -0.11925447732210159f;
  t44_n27: return 0.11543954908847809f;
  t44_n28: if (E.getIsReservedName() >= 3204448256 /*0.5*/) goto t44_n30;
  t44_n29: return 0.005867535248398781f;
  t44_n30: return -0.14434584975242615f;
  t44_n31: return -0.056146908551454544f;
  t44_n32: if (E.getScope() & (BIT(Scope_type::GlobalScope))) goto t44_n36;
  t44_n33: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t44_n35;
  t44_n34: return -0.211867094039917f;
  t44_n35: return 0.014361249282956123f;
  t44_n36: if (E.getFileProximityDistanceCost() >= 3472883712 /*2147483648.0*/) goto t44_n38;
  t44_n37: return 0.059675607830286026f;
  t44_n38: return 0.11579413712024689f;
  t44_n39: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t44_n41;
  t44_n40: return 0.03687319904565811f;
  t44_n41: return -0.06618261337280273f;
  t44_n42: return -0.03950027376413345f;
  t44_n43: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Variable))) goto t44_n45;
  t44_n44: return -0.06458237767219543f;
  t44_n45: if (E.getIsInstanceMember() >= 3204448256 /*0.5*/) goto t44_n85;
  t44_n46: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t44_n78;
  t44_n47: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown))) goto t44_n55;
  t44_n48: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ArrowMemberAccess)|BIT(ContextKind_type::CCC_DotMemberAccess)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Other)|BIT(ContextKind_type::CCC_ParenthesizedExpression)|BIT(ContextKind_type::CCC_PreprocessorExpression)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_SymbolOrNewName)|BIT(ContextKind_type::CCC_TypeQualifiers)|BIT(ContextKind_type::CCC_UnionTag))) goto t44_n50;
  t44_n49: return -0.07183375954627991f;
  t44_n50: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t44_n52;
  t44_n51: return -0.01841561496257782f;
  t44_n52: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t44_n54;
  t44_n53: return 0.006771992892026901f;
  t44_n54: return 0.049639321863651276f;
  t44_n55: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t44_n59;
  t44_n56: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t44_n58;
  t44_n57: return 0.025262825191020966f;
  t44_n58: return -0.08730253577232361f;
  t44_n59: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t44_n65;
  t44_n60: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t44_n62;
  t44_n61: return -0.005390367936342955f;
  t44_n62: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t44_n64;
  t44_n63: return 0.07933919876813889f;
  t44_n64: return 0.012273700907826424f;
  t44_n65: if (E.getIsImplementationDetail() >= 3204448256 /*0.5*/) goto t44_n77;
  t44_n66: if (E.getScope() & (BIT(Scope_type::ClassScope)|BIT(Scope_type::GlobalScope))) goto t44_n70;
  t44_n67: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Namespace))) goto t44_n69;
  t44_n68: return 0.001407311880029738f;
  t44_n69: return 0.08570375293493271f;
  t44_n70: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t44_n72;
  t44_n71: return -0.06735393404960632f;
  t44_n72: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_EnumTag)|BIT(ContextKind_type::CCC_Expression)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type)|BIT(ContextKind_type::CCC_UnionTag))) goto t44_n76;
  t44_n73: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type)|BIT(SymbolCategory_type::Unknown)|BIT(SymbolCategory_type::Variable))) goto t44_n75;
  t44_n74: return -0.0654696673154831f;
  t44_n75: return 0.041306979954242706f;
  t44_n76: return 0.04526599124073982f;
  t44_n77: return -0.09400768578052521f;
  t44_n78: if (E.getNumReferences() >= 3217031168 /*1.5*/) goto t44_n80;
  t44_n79: return -0.09180091321468353f;
  t44_n80: if (E.getSemaSaysInScope() >= 3204448256 /*0.5*/) goto t44_n84;
  t44_n81: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t44_n83;
  t44_n82: return -0.003749942174181342f;
  t44_n83: return 0.0617092102766037f;
  t44_n84: return 0.03139190375804901f;
  t44_n85: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Variable))) goto t44_n89;
  t44_n86: if (E.getContextKind() & (BIT(ContextKind_type::CCC_Statement))) goto t44_n88;
  t44_n87: return -0.00264080916531384f;
  t44_n88: return 0.02538362704217434f;
  t44_n89: if (E.getIsInBaseClass() >= 3204448256 /*0.5*/) goto t44_n91;
  t44_n90: return 0.042187757790088654f;
  t44_n91: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t44_n93;
  t44_n92: return -0.023703856393694878f;
  t44_n93: return 0.03894994780421257f;
  t44_n94: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t44_n100;
  t44_n95: if (E.getFileProximityDistanceCost() >= 3243769856 /*13.5*/) goto t44_n99;
  t44_n96: if (E.getHadContextType() >= 3204448256 /*0.5*/) goto t44_n98;
  t44_n97: return 0.034543491899967194f;
  t44_n98: return 0.009715214371681213f;
  t44_n99: return 0.014787374064326286f;
  t44_n100: if (E.getNumReferences() >= 3317853184 /*6221.5*/) goto t44_n102;
  t44_n101: return 0.028725987300276756f;
  t44_n102: if (E.getNumReferences() >= 3318227968 /*6404.5*/) goto t44_n104;
  t44_n103: return 0.1365642249584198f;
  t44_n104: if (E.getNumReferences() >= 3338711808 /*32947.0*/) goto t44_n106;
  t44_n105: return 0.07121019810438156f;
  t44_n106: return -0.1618807017803192f;
  t44_n107: if (E.getSemaFileProximityScore() >= 3209481421 /*0.800000011920929*/) goto t44_n163;
  t44_n108: if (E.getFileProximityDistanceCost() >= 3238526976 /*8.5*/) goto t44_n120;
  t44_n109: if (E.getNumReferences() >= 3255173120 /*33.5*/) goto t44_n119;
  t44_n110: if (E.getContextKind() & (BIT(ContextKind_type::CCC_SymbolOrNewName))) goto t44_n114;
  t44_n111: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace))) goto t44_n113;
  t44_n112: return -0.011264830827713013f;
  t44_n113: return 0.01840541698038578f;
  t44_n114: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Constructor)|BIT(SymbolCategory_type::Destructor)|BIT(SymbolCategory_type::Function)|BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Operator)|BIT(SymbolCategory_type::Type))) goto t44_n116;
  t44_n115: return -0.06617020070552826f;
  t44_n116: if (E.getFileProximityDistanceCost() >= 3227516928 /*3.5*/) goto t44_n118;
  t44_n117: return 0.06355299055576324f;
  t44_n118: return 0.04291694611310959f;
  t44_n119: return 0.047771379351615906f;
  t44_n120: if (E.getTypeMatchesPreferred() >= 3204448256 /*0.5*/) goto t44_n152;
  t44_n121: if (E.getFractionNameInContext() >= 3171926904 /*0.035098522901535034*/) goto t44_n123;
  t44_n122: return -0.023120615631341934f;
  t44_n123: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Keyword)|BIT(SymbolCategory_type::Macro)|BIT(SymbolCategory_type::Namespace)|BIT(SymbolCategory_type::Type))) goto t44_n125;
  t44_n124: return -0.03514333814382553f;
  t44_n125: if (E.getFileProximityDistanceCost() >= 3245867008 /*15.5*/) goto t44_n127;
  t44_n126: return -0.00795077346265316f;
  t44_n127: if (E.getNumReferences() >= 3204448256 /*0.5*/) goto t44_n151;
  t44_n128: if (E.getContextKind() & (BIT(ContextKind_type::CCC_ClassOrStructTag)|BIT(ContextKind_type::CCC_ClassStructUnion)|BIT(ContextKind_type::CCC_Namespace)|BIT(ContextKind_type::CCC_Symbol)|BIT(ContextKind_type::CCC_TopLevel)|BIT(ContextKind_type::CCC_Type))) goto t44_n130;
  t44_n129: return 0.011910250410437584f;
  t44_n130: if (E.getSymbolCategory() & (BIT(SymbolCategory_type::Macro))) goto t44_n136;
  t44_n131: if (E.