// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/registry/module/v1beta1/upload_service.proto

package modulev1beta1connect

import (
	v1beta1 "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/module/v1beta1"
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// UploadServiceName is the fully-qualified name of the UploadService service.
	UploadServiceName = "buf.registry.module.v1beta1.UploadService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// UploadServiceUploadProcedure is the fully-qualified name of the UploadService's Upload RPC.
	UploadServiceUploadProcedure = "/buf.registry.module.v1beta1.UploadService/Upload"
)

// UploadServiceClient is a client for the buf.registry.module.v1beta1.UploadService service.
type UploadServiceClient interface {
	// Upload contents for given set of Modules.
	//
	// Content consists of the Files: .proto files, license files, and documentation files.
	Upload(context.Context, *connect.Request[v1beta1.UploadRequest]) (*connect.Response[v1beta1.UploadResponse], error)
}

// NewUploadServiceClient constructs a client for the buf.registry.module.v1beta1.UploadService
// service. By default, it uses the Connect protocol with the binary Protobuf Codec, asks for
// gzipped responses, and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply
// the connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewUploadServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) UploadServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	uploadServiceMethods := v1beta1.File_buf_registry_module_v1beta1_upload_service_proto.Services().ByName("UploadService").Methods()
	return &uploadServiceClient{
		upload: connect.NewClient[v1beta1.UploadRequest, v1beta1.UploadResponse](
			httpClient,
			baseURL+UploadServiceUploadProcedure,
			connect.WithSchema(uploadServiceMethods.ByName("Upload")),
			connect.WithClientOptions(opts...),
		),
	}
}

// uploadServiceClient implements UploadServiceClient.
type uploadServiceClient struct {
	upload *connect.Client[v1beta1.UploadRequest, v1beta1.UploadResponse]
}

// Upload calls buf.registry.module.v1beta1.UploadService.Upload.
func (c *uploadServiceClient) Upload(ctx context.Context, req *connect.Request[v1beta1.UploadRequest]) (*connect.Response[v1beta1.UploadResponse], error) {
	return c.upload.CallUnary(ctx, req)
}

// UploadServiceHandler is an implementation of the buf.registry.module.v1beta1.UploadService
// service.
type UploadServiceHandler interface {
	// Upload contents for given set of Modules.
	//
	// Content consists of the Files: .proto files, license files, and documentation files.
	Upload(context.Context, *connect.Request[v1beta1.UploadRequest]) (*connect.Response[v1beta1.UploadResponse], error)
}

// NewUploadServiceHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewUploadServiceHandler(svc UploadServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	uploadServiceMethods := v1beta1.File_buf_registry_module_v1beta1_upload_service_proto.Services().ByName("UploadService").Methods()
	uploadServiceUploadHandler := connect.NewUnaryHandler(
		UploadServiceUploadProcedure,
		svc.Upload,
		connect.WithSchema(uploadServiceMethods.ByName("Upload")),
		connect.WithHandlerOptions(opts...),
	)
	return "/buf.registry.module.v1beta1.UploadService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case UploadServiceUploadProcedure:
			uploadServiceUploadHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedUploadServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedUploadServiceHandler struct{}

func (UnimplementedUploadServiceHandler) Upload(context.Context, *connect.Request[v1beta1.UploadRequest]) (*connect.Response[v1beta1.UploadResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.module.v1beta1.UploadService.Upload is not implemented"))
}
