/* tabswitcher.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from tabswitcher.vala, do not modify */

/*
* This file is part of budgie-desktop
*
* Copyright © taaem <taaem@mailbox.org>
* Copyright © Budgie Desktop Developers
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdkx.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <libxfce4windowing/libxfce4windowing.h>
#include <gio/gdesktopappinfo.h>
#include "appsys.h"
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <stdio.h>

#define BUDGIE_SHOW_ALL_WINDOWS_KEY "show-all-windows-tabswitcher"
#define BUDGIE_SWITCHER_SIZE -1
#define BUDGIE_SWITCHER_MOD_EXPIRE_TIME 50
#define BUDGIE_SWITCHER_DBUS_NAME "org.budgie_desktop.TabSwitcher"
#define BUDGIE_SWITCHER_DBUS_OBJECT_PATH "/org/budgie_desktop/TabSwitcher"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_TAB_SWITCHER_WIDGET (budgie_tab_switcher_widget_get_type ())
#define BUDGIE_TAB_SWITCHER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_TAB_SWITCHER_WIDGET, BudgieTabSwitcherWidget))
#define BUDGIE_TAB_SWITCHER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_TAB_SWITCHER_WIDGET, BudgieTabSwitcherWidgetClass))
#define BUDGIE_IS_TAB_SWITCHER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_TAB_SWITCHER_WIDGET))
#define BUDGIE_IS_TAB_SWITCHER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_TAB_SWITCHER_WIDGET))
#define BUDGIE_TAB_SWITCHER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_TAB_SWITCHER_WIDGET, BudgieTabSwitcherWidgetClass))

typedef struct _BudgieTabSwitcherWidget BudgieTabSwitcherWidget;
typedef struct _BudgieTabSwitcherWidgetClass BudgieTabSwitcherWidgetClass;
typedef struct _BudgieTabSwitcherWidgetPrivate BudgieTabSwitcherWidgetPrivate;
enum  {
	BUDGIE_TAB_SWITCHER_WIDGET_0_PROPERTY,
	BUDGIE_TAB_SWITCHER_WIDGET_NUM_PROPERTIES
};
static GParamSpec* budgie_tab_switcher_widget_properties[BUDGIE_TAB_SWITCHER_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BUDGIE_TAB_SWITCHER_WIDGET_CLOSED_SIGNAL,
	BUDGIE_TAB_SWITCHER_WIDGET_WINDOW_ACTIVATED_SIGNAL,
	BUDGIE_TAB_SWITCHER_WIDGET_WORKSPACE_CHANGED_SIGNAL,
	BUDGIE_TAB_SWITCHER_WIDGET_NUM_SIGNALS
};
static guint budgie_tab_switcher_widget_signals[BUDGIE_TAB_SWITCHER_WIDGET_NUM_SIGNALS] = {0};

#define BUDGIE_TYPE_TAB_SWITCHER_WINDOW (budgie_tab_switcher_window_get_type ())
#define BUDGIE_TAB_SWITCHER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_TAB_SWITCHER_WINDOW, BudgieTabSwitcherWindow))
#define BUDGIE_TAB_SWITCHER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_TAB_SWITCHER_WINDOW, BudgieTabSwitcherWindowClass))
#define BUDGIE_IS_TAB_SWITCHER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_TAB_SWITCHER_WINDOW))
#define BUDGIE_IS_TAB_SWITCHER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_TAB_SWITCHER_WINDOW))
#define BUDGIE_TAB_SWITCHER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_TAB_SWITCHER_WINDOW, BudgieTabSwitcherWindowClass))

typedef struct _BudgieTabSwitcherWindow BudgieTabSwitcherWindow;
typedef struct _BudgieTabSwitcherWindowClass BudgieTabSwitcherWindowClass;
typedef struct _BudgieTabSwitcherWindowPrivate BudgieTabSwitcherWindowPrivate;
enum  {
	BUDGIE_TAB_SWITCHER_WINDOW_0_PROPERTY,
	BUDGIE_TAB_SWITCHER_WINDOW_NUM_PROPERTIES
};
static GParamSpec* budgie_tab_switcher_window_properties[BUDGIE_TAB_SWITCHER_WINDOW_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define BUDGIE_TYPE_TAB_SWITCHER (budgie_tab_switcher_get_type ())
#define BUDGIE_TAB_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_TAB_SWITCHER, BudgieTabSwitcher))
#define BUDGIE_TAB_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_TAB_SWITCHER, BudgieTabSwitcherClass))
#define BUDGIE_IS_TAB_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_TAB_SWITCHER))
#define BUDGIE_IS_TAB_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_TAB_SWITCHER))
#define BUDGIE_TAB_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_TAB_SWITCHER, BudgieTabSwitcherClass))

typedef struct _BudgieTabSwitcher BudgieTabSwitcher;
typedef struct _BudgieTabSwitcherClass BudgieTabSwitcherClass;
typedef struct _BudgieTabSwitcherPrivate BudgieTabSwitcherPrivate;
enum  {
	BUDGIE_TAB_SWITCHER_0_PROPERTY,
	BUDGIE_TAB_SWITCHER_NUM_PROPERTIES
};
static GParamSpec* budgie_tab_switcher_properties[BUDGIE_TAB_SWITCHER_NUM_PROPERTIES];

struct _BudgieTabSwitcherWidget {
	GtkFlowBoxChild parent_instance;
	BudgieTabSwitcherWidgetPrivate * priv;
	gchar* id;
	gchar* title;
	XfwWindow* window;
};

struct _BudgieTabSwitcherWidgetClass {
	GtkFlowBoxChildClass parent_class;
};

struct _BudgieTabSwitcherWidgetPrivate {
	GtkImage* image;
	guint64 activation_timestamp;
	XfwApplication* application;
	GDesktopAppInfo* info;
};

struct _BudgieTabSwitcherWindow {
	GtkWindow parent_instance;
	BudgieTabSwitcherWindowPrivate * priv;
};

struct _BudgieTabSwitcherWindowClass {
	GtkWindowClass parent_class;
};

struct _BudgieTabSwitcherWindowPrivate {
	GtkFlowBox* window_box;
	GtkLabel* window_title;
	XfwWorkspace* active_workspace;
	XfwWorkspaceGroup* workspace_group;
	GdkScreen* default_screen;
	XfwScreen* xfce_screen;
	XfwWorkspaceManager* workspace_manager;
	BudgieAppSystem* app_system;
	GdkMonitor* primary_monitor;
	GList* recency;
	GHashTable* ids;
	GSettings* settings;
	gboolean show_all_windows;
};

struct _BudgieTabSwitcher {
	GObject parent_instance;
	BudgieTabSwitcherPrivate * priv;
};

struct _BudgieTabSwitcherClass {
	GObjectClass parent_class;
};

struct _BudgieTabSwitcherPrivate {
	BudgieTabSwitcherWindow* switcher_window;
	guint32 mod_timeout;
};

static gint BudgieTabSwitcherWidget_private_offset;
static gpointer budgie_tab_switcher_widget_parent_class = NULL;
static gint BudgieTabSwitcherWindow_private_offset;
static gpointer budgie_tab_switcher_window_parent_class = NULL;
static gint BudgieTabSwitcher_private_offset;
static gpointer budgie_tab_switcher_parent_class = NULL;
VALA_EXTERN gboolean budgie_setup;

VALA_EXTERN guint64 budgie_get_time (void);
VALA_EXTERN GType budgie_tab_switcher_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieTabSwitcherWidget, g_object_unref)
VALA_EXTERN BudgieTabSwitcherWidget* budgie_tab_switcher_widget_new (BudgieAppSystem* app_system,
                                                         XfwWindow* win);
VALA_EXTERN BudgieTabSwitcherWidget* budgie_tab_switcher_widget_construct (GType object_type,
                                                               BudgieAppSystem* app_system,
                                                               XfwWindow* win);
static void budgie_tab_switcher_widget_set_title (BudgieTabSwitcherWidget* self);
static void budgie_tab_switcher_widget_set_icon (BudgieTabSwitcherWidget* self);
static void __lambda62_ (BudgieTabSwitcherWidget* self,
                  XfwWindowState changed_mask,
                  XfwWindowState new_state);
static void ___lambda62__libxfce4windowing_window_state_changed (XfwWindow* _sender,
                                                          XfwWindowState changed_mask,
                                                          XfwWindowState new_state,
                                                          gpointer self);
static void __lambda63_ (BudgieTabSwitcherWidget* self);
static void ___lambda63__libxfce4windowing_window_closed (XfwWindow* _sender,
                                                   gpointer self);
static void _budgie_tab_switcher_widget_set_icon_libxfce4windowing_application_icon_changed (XfwApplication* _sender,
                                                                                      gpointer self);
static void _budgie_tab_switcher_widget_set_icon_libxfce4windowing_window_icon_changed (XfwWindow* _sender,
                                                                                 gpointer self);
static void _budgie_tab_switcher_widget_set_title_libxfce4windowing_window_name_changed (XfwWindow* _sender,
                                                                                  gpointer self);
static void __lambda64_ (BudgieTabSwitcherWidget* self);
static void ___lambda64__libxfce4windowing_window_workspace_changed (XfwWindow* _sender,
                                                              gpointer self);
static void budgie_tab_switcher_widget_finalize (GObject * obj);
static GType budgie_tab_switcher_widget_get_type_once (void);
VALA_EXTERN GType budgie_tab_switcher_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieTabSwitcherWindow, g_object_unref)
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN BudgieTabSwitcherWindow* budgie_tab_switcher_window_new (void);
VALA_EXTERN BudgieTabSwitcherWindow* budgie_tab_switcher_window_construct (GType object_type);
static void budgie_tab_switcher_window_add_window (BudgieTabSwitcherWindow* self,
                                            XfwWindow* window);
static gint64 budgie_tab_switcher_window_get_position_in_recency (BudgieTabSwitcherWindow* self,
                                                           const gchar* id);
static void budgie_tab_switcher_window_set_window_as_activated (BudgieTabSwitcherWindow* self,
                                                         XfwWindow* window);
static void _budgie_tab_switcher_window_set_window_as_activated_budgie_tab_switcher_widget_window_activated (BudgieTabSwitcherWidget* _sender,
                                                                                                      XfwWindow* window,
                                                                                                      gpointer self);
static void budgie_tab_switcher_window_remove_window (BudgieTabSwitcherWindow* self,
                                               BudgieTabSwitcherWidget* widget);
static void _budgie_tab_switcher_window_remove_window_budgie_tab_switcher_widget_closed (BudgieTabSwitcherWidget* _sender,
                                                                                  BudgieTabSwitcherWidget* widget,
                                                                                  gpointer self);
static void __lambda65_ (BudgieTabSwitcherWindow* self);
static void ___lambda65__budgie_tab_switcher_widget_workspace_changed (BudgieTabSwitcherWidget* _sender,
                                                                gpointer self);
static void budgie_tab_switcher_window_update_sizing (BudgieTabSwitcherWindow* self);
static gboolean budgie_tab_switcher_window_flowbox_filter (BudgieTabSwitcherWindow* self,
                                                    GtkFlowBoxChild* box_child);
static gboolean budgie_tab_switcher_window_window_on_active_workspace (BudgieTabSwitcherWindow* self,
                                                                XfwWindow* window);
static gint budgie_tab_switcher_window_flowbox_sort (BudgieTabSwitcherWindow* self,
                                              GtkFlowBoxChild* child1,
                                              GtkFlowBoxChild* child2);
VALA_EXTERN guint budgie_tab_switcher_window_get_visible_children (BudgieTabSwitcherWindow* self);
static void budgie_tab_switcher_window_on_hide (BudgieTabSwitcherWindow* self);
static void budgie_tab_switcher_window_on_monitors_changed (BudgieTabSwitcherWindow* self);
VALA_EXTERN void budgie_tab_switcher_window_move_switcher (BudgieTabSwitcherWindow* self);
static void budgie_tab_switcher_window_on_workspace_changed (BudgieTabSwitcherWindow* self);
static void budgie_tab_switcher_window_update_show_all_windows (BudgieTabSwitcherWindow* self);
VALA_EXTERN void budgie_tab_switcher_window_focus_item (BudgieTabSwitcherWindow* self,
                                            gboolean backwards);
static GObject * budgie_tab_switcher_window_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void _budgie_tab_switcher_window_update_show_all_windows_g_settings_changed (GSettings* _sender,
                                                                             const gchar* key,
                                                                             gpointer self);
static void _budgie_tab_switcher_window_add_window_gfunc (gconstpointer data,
                                                   gpointer self);
static void _budgie_tab_switcher_window_add_window_libxfce4windowing_screen_window_opened (XfwScreen* _sender,
                                                                                    XfwWindow* window,
                                                                                    gpointer self);
static void _budgie_tab_switcher_window_on_workspace_changed_libxfce4windowing_workspace_group_active_workspace_changed (XfwWorkspaceGroup* _sender,
                                                                                                                  XfwWorkspace* previously_active_workspace,
                                                                                                                  gpointer self);
static gboolean _budgie_tab_switcher_window_flowbox_filter_gtk_flow_box_filter_func (GtkFlowBoxChild* child,
                                                                              gpointer self);
static gint _budgie_tab_switcher_window_flowbox_sort_gtk_flow_box_sort_func (GtkFlowBoxChild* child1,
                                                                      GtkFlowBoxChild* child2,
                                                                      gpointer self);
static void _budgie_tab_switcher_window_on_hide_gtk_widget_hide (GtkWidget* _sender,
                                                          gpointer self);
static void _budgie_tab_switcher_window_on_monitors_changed_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                                  gpointer self);
static void budgie_tab_switcher_window_finalize (GObject * obj);
static GType budgie_tab_switcher_window_get_type_once (void);
VALA_EXTERN GType budgie_tab_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieTabSwitcher, g_object_unref)
VALA_EXTERN guint budgie_tab_switcher_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
VALA_EXTERN BudgieTabSwitcher* budgie_tab_switcher_new (void);
VALA_EXTERN BudgieTabSwitcher* budgie_tab_switcher_construct (GType object_type);
VALA_EXTERN void budgie_tab_switcher_setup_dbus (BudgieTabSwitcher* self,
                                     gboolean replace);
static void budgie_tab_switcher_on_bus_acquired (BudgieTabSwitcher* self,
                                          GDBusConnection* conn);
static void _budgie_tab_switcher_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                  const gchar* name,
                                                                  gpointer self);
static void __lambda66_ (BudgieTabSwitcher* self);
static void ___lambda66__gbus_name_acquired_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               gpointer self);
VALA_EXTERN void budgie_DaemonNameLost (GDBusConnection* conn,
                            const gchar* name);
static void _budgie_DaemonNameLost_gbus_name_lost_callback (GDBusConnection* connection,
                                                     const gchar* name,
                                                     gpointer self);
VALA_EXTERN void budgie_tab_switcher_ShowSwitcher (BudgieTabSwitcher* self,
                                       gboolean backwards,
                                       GError** error);
static void budgie_tab_switcher_add_mod_key_watcher (BudgieTabSwitcher* self);
VALA_EXTERN void budgie_tab_switcher_StopSwitcher (BudgieTabSwitcher* self,
                                       GError** error);
static gboolean budgie_tab_switcher_check_mod_key (BudgieTabSwitcher* self);
static void budgie_tab_switcher_finalize (GObject * obj);
static GType budgie_tab_switcher_get_type_once (void);
static void _dbus_budgie_tab_switcher_ShowSwitcher (BudgieTabSwitcher* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_budgie_tab_switcher_StopSwitcher (BudgieTabSwitcher* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void budgie_tab_switcher_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* budgie_tab_switcher_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static gboolean budgie_tab_switcher_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _budgie_tab_switcher_unregister_object (gpointer user_data);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _budgie_tab_switcher_dbus_arg_info_ShowSwitcher_backwards = {-1, "backwards", "b", NULL};
static const GDBusArgInfo * const _budgie_tab_switcher_dbus_arg_info_ShowSwitcher_in[] = {&_budgie_tab_switcher_dbus_arg_info_ShowSwitcher_backwards, NULL};
static const GDBusArgInfo * const _budgie_tab_switcher_dbus_arg_info_ShowSwitcher_out[] = {NULL};
static const GDBusMethodInfo _budgie_tab_switcher_dbus_method_info_ShowSwitcher = {-1, "ShowSwitcher", (GDBusArgInfo **) (&_budgie_tab_switcher_dbus_arg_info_ShowSwitcher_in), (GDBusArgInfo **) (&_budgie_tab_switcher_dbus_arg_info_ShowSwitcher_out), NULL};
static const GDBusArgInfo * const _budgie_tab_switcher_dbus_arg_info_StopSwitcher_in[] = {NULL};
static const GDBusArgInfo * const _budgie_tab_switcher_dbus_arg_info_StopSwitcher_out[] = {NULL};
static const GDBusMethodInfo _budgie_tab_switcher_dbus_method_info_StopSwitcher = {-1, "StopSwitcher", (GDBusArgInfo **) (&_budgie_tab_switcher_dbus_arg_info_StopSwitcher_in), (GDBusArgInfo **) (&_budgie_tab_switcher_dbus_arg_info_StopSwitcher_out), NULL};
static const GDBusMethodInfo * const _budgie_tab_switcher_dbus_method_info[] = {&_budgie_tab_switcher_dbus_method_info_ShowSwitcher, &_budgie_tab_switcher_dbus_method_info_StopSwitcher, NULL};
static const GDBusSignalInfo * const _budgie_tab_switcher_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_tab_switcher_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_tab_switcher_dbus_interface_info = {-1, "org.budgie_desktop.TabSwitcher", (GDBusMethodInfo **) (&_budgie_tab_switcher_dbus_method_info), (GDBusSignalInfo **) (&_budgie_tab_switcher_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_tab_switcher_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_tab_switcher_dbus_interface_vtable = {budgie_tab_switcher_dbus_interface_method_call, budgie_tab_switcher_dbus_interface_get_property, budgie_tab_switcher_dbus_interface_set_property};

guint64
budgie_get_time (void)
{
	GdkWindow* _tmp0_;
	guint64 result;
	_tmp0_ = gdk_get_default_root_window ();
	result = (guint64) gdk_x11_get_server_time (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gdk_x11_window_get_type ()) ? ((GdkX11Window*) _tmp0_) : NULL);
	return result;
}

static inline gpointer
budgie_tab_switcher_widget_get_instance_private (BudgieTabSwitcherWidget* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieTabSwitcherWidget_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda62_ (BudgieTabSwitcherWidget* self,
             XfwWindowState changed_mask,
             XfwWindowState new_state)
{
	gboolean _tmp0_ = FALSE;
	if ((changed_mask & XFW_WINDOW_STATE_ACTIVE) == XFW_WINDOW_STATE_ACTIVE) {
		_tmp0_ = (new_state & XFW_WINDOW_STATE_ACTIVE) == XFW_WINDOW_STATE_ACTIVE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		XfwWindow* _tmp1_;
		self->priv->activation_timestamp = budgie_get_time ();
		_tmp1_ = self->window;
		g_signal_emit (self, budgie_tab_switcher_widget_signals[BUDGIE_TAB_SWITCHER_WIDGET_WINDOW_ACTIVATED_SIGNAL], 0, _tmp1_);
	}
}

static void
___lambda62__libxfce4windowing_window_state_changed (XfwWindow* _sender,
                                                     XfwWindowState changed_mask,
                                                     XfwWindowState new_state,
                                                     gpointer self)
{
	__lambda62_ ((BudgieTabSwitcherWidget*) self, changed_mask, new_state);
}

static void
__lambda63_ (BudgieTabSwitcherWidget* self)
{
	g_signal_emit (self, budgie_tab_switcher_widget_signals[BUDGIE_TAB_SWITCHER_WIDGET_CLOSED_SIGNAL], 0, self);
}

static void
___lambda63__libxfce4windowing_window_closed (XfwWindow* _sender,
                                              gpointer self)
{
	__lambda63_ ((BudgieTabSwitcherWidget*) self);
}

static void
_budgie_tab_switcher_widget_set_icon_libxfce4windowing_application_icon_changed (XfwApplication* _sender,
                                                                                 gpointer self)
{
	budgie_tab_switcher_widget_set_icon ((BudgieTabSwitcherWidget*) self);
}

static void
_budgie_tab_switcher_widget_set_icon_libxfce4windowing_window_icon_changed (XfwWindow* _sender,
                                                                            gpointer self)
{
	budgie_tab_switcher_widget_set_icon ((BudgieTabSwitcherWidget*) self);
}

static void
_budgie_tab_switcher_widget_set_title_libxfce4windowing_window_name_changed (XfwWindow* _sender,
                                                                             gpointer self)
{
	budgie_tab_switcher_widget_set_title ((BudgieTabSwitcherWidget*) self);
}

static void
__lambda64_ (BudgieTabSwitcherWidget* self)
{
	g_signal_emit (self, budgie_tab_switcher_widget_signals[BUDGIE_TAB_SWITCHER_WIDGET_WORKSPACE_CHANGED_SIGNAL], 0);
}

static void
___lambda64__libxfce4windowing_window_workspace_changed (XfwWindow* _sender,
                                                         gpointer self)
{
	__lambda64_ ((BudgieTabSwitcherWidget*) self);
}

BudgieTabSwitcherWidget*
budgie_tab_switcher_widget_construct (GType object_type,
                                      BudgieAppSystem* app_system,
                                      XfwWindow* win)
{
	BudgieTabSwitcherWidget * self = NULL;
	gulong uid = 0UL;
	XfwWindow* _tmp0_;
	gchar* _tmp1_;
	XfwApplication* _tmp2_;
	XfwApplication* _tmp3_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GValue _tmp7_ = {0};
	XfwWindow* _tmp8_;
	XfwWindow* _tmp9_;
	XfwApplication* _tmp10_;
	XfwWindow* _tmp11_;
	XfwWindow* _tmp12_;
	XfwWindow* _tmp13_;
	g_return_val_if_fail (app_system != NULL, NULL);
	self = (BudgieTabSwitcherWidget*) g_object_new (object_type, NULL);
	self->window = win;
	_tmp0_ = self->window;
	uid = (gulong) xfw_window_x11_get_xid (_tmp0_);
	_tmp1_ = g_strdup_printf ("%lu", uid);
	_g_free0 (self->id);
	self->id = _tmp1_;
	budgie_tab_switcher_widget_set_title (self);
	_tmp2_ = xfw_window_get_application (win);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->application);
	self->priv->application = _tmp3_;
	if (xfw_windowing_get () == XFW_WINDOWING_X11) {
		GDesktopAppInfo* _tmp4_;
		_tmp4_ = budgie_app_system_query_window_by_xid (app_system, (gulong) uid);
		_g_object_unref0 (self->priv->info);
		self->priv->info = _tmp4_;
	}
	_tmp5_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp5_;
	_tmp6_ = self->priv->image;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp6_);
	g_value_init (&_tmp7_, G_TYPE_INT);
	g_value_set_int (&_tmp7_, 10);
	g_object_set_property ((GObject*) self, "margin", &_tmp7_);
	G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
	budgie_tab_switcher_widget_set_icon (self);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	_tmp8_ = self->window;
	g_signal_connect_object (_tmp8_, "state-changed", (GCallback) ___lambda62__libxfce4windowing_window_state_changed, self, 0);
	_tmp9_ = self->window;
	g_signal_connect_object (_tmp9_, "closed", (GCallback) ___lambda63__libxfce4windowing_window_closed, self, 0);
	_tmp10_ = self->priv->application;
	g_signal_connect_object (_tmp10_, "icon-changed", (GCallback) _budgie_tab_switcher_widget_set_icon_libxfce4windowing_application_icon_changed, self, 0);
	_tmp11_ = self->window;
	g_signal_connect_object (_tmp11_, "icon-changed", (GCallback) _budgie_tab_switcher_widget_set_icon_libxfce4windowing_window_icon_changed, self, 0);
	_tmp12_ = self->window;
	g_signal_connect_object (_tmp12_, "name-changed", (GCallback) _budgie_tab_switcher_widget_set_title_libxfce4windowing_window_name_changed, self, 0);
	_tmp13_ = self->window;
	g_signal_connect_object (_tmp13_, "workspace-changed", (GCallback) ___lambda64__libxfce4windowing_window_workspace_changed, self, 0);
	return self;
}

BudgieTabSwitcherWidget*
budgie_tab_switcher_widget_new (BudgieAppSystem* app_system,
                                XfwWindow* win)
{
	return budgie_tab_switcher_widget_construct (BUDGIE_TYPE_TAB_SWITCHER_WIDGET, app_system, win);
}

static void
budgie_tab_switcher_widget_set_icon (BudgieTabSwitcherWidget* self)
{
	GIcon* _tmp0_ = NULL;
	GDesktopAppInfo* _tmp1_;
	GIcon* info_icon = NULL;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	GdkPixbuf* _tmp8_ = NULL;
	XfwApplication* _tmp9_;
	GdkPixbuf* windowing_app_icon = NULL;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* window_icon = NULL;
	XfwWindow* _tmp13_;
	GdkPixbuf* _tmp14_;
	GdkPixbuf* _tmp15_;
	GdkPixbuf* _tmp16_ = NULL;
	GdkPixbuf* _tmp17_;
	GtkImage* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->info;
	if (_tmp1_ != NULL) {
		GDesktopAppInfo* _tmp2_;
		GIcon* _tmp3_;
		_tmp2_ = self->priv->info;
		_tmp3_ = g_app_info_get_icon ((GAppInfo*) _tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp4_ = _g_object_ref0 (_tmp0_);
	info_icon = _tmp4_;
	_tmp5_ = info_icon;
	if (_tmp5_ != NULL) {
		GtkImage* _tmp6_;
		GIcon* _tmp7_;
		_tmp6_ = self->priv->image;
		_tmp7_ = info_icon;
		gtk_image_set_from_gicon (_tmp6_, _tmp7_, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
		_g_object_unref0 (info_icon);
		return;
	}
	_tmp9_ = self->priv->application;
	if (_tmp9_ != NULL) {
		XfwApplication* _tmp10_;
		GdkPixbuf* _tmp11_;
		_tmp10_ = self->priv->application;
		_tmp11_ = xfw_application_get_icon (_tmp10_, (gint) GTK_ICON_SIZE_DIALOG, (gint) GTK_ICON_SIZE_DIALOG);
		_tmp8_ = _tmp11_;
	} else {
		_tmp8_ = NULL;
	}
	_tmp12_ = _g_object_ref0 (_tmp8_);
	windowing_app_icon = _tmp12_;
	_tmp13_ = self->window;
	_tmp14_ = xfw_window_get_icon (_tmp13_, (gint) GTK_ICON_SIZE_DIALOG, (gint) GTK_ICON_SIZE_DIALOG);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	window_icon = _tmp15_;
	_tmp17_ = windowing_app_icon;
	_tmp16_ = _tmp17_;
	if (_tmp16_ == NULL) {
		GdkPixbuf* _tmp18_;
		_tmp18_ = window_icon;
		_tmp16_ = _tmp18_;
	}
	_tmp19_ = self->priv->image;
	gtk_image_set_from_pixbuf (_tmp19_, _tmp16_);
	_g_object_unref0 (window_icon);
	_g_object_unref0 (windowing_app_icon);
	_g_object_unref0 (info_icon);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
budgie_tab_switcher_widget_set_title (BudgieTabSwitcherWidget* self)
{
	const gchar* _tmp0_ = NULL;
	XfwWindow* _tmp1_;
	const gchar* _tmp2_;
	gchar* win_name = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->window;
	_tmp2_ = xfw_window_get_name (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	win_name = _tmp3_;
	_tmp4_ = string_strip (win_name);
	_g_free0 (self->title);
	self->title = _tmp4_;
	_g_free0 (win_name);
}

static void
budgie_tab_switcher_widget_class_init (BudgieTabSwitcherWidgetClass * klass,
                                       gpointer klass_data)
{
	budgie_tab_switcher_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieTabSwitcherWidget_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_tab_switcher_widget_finalize;
	budgie_tab_switcher_widget_signals[BUDGIE_TAB_SWITCHER_WIDGET_CLOSED_SIGNAL] = g_signal_new ("closed", BUDGIE_TYPE_TAB_SWITCHER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BUDGIE_TYPE_TAB_SWITCHER_WIDGET);
	budgie_tab_switcher_widget_signals[BUDGIE_TAB_SWITCHER_WIDGET_WINDOW_ACTIVATED_SIGNAL] = g_signal_new ("window-activated", BUDGIE_TYPE_TAB_SWITCHER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, xfw_window_get_type ());
	budgie_tab_switcher_widget_signals[BUDGIE_TAB_SWITCHER_WIDGET_WORKSPACE_CHANGED_SIGNAL] = g_signal_new ("workspace-changed", BUDGIE_TYPE_TAB_SWITCHER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
budgie_tab_switcher_widget_instance_init (BudgieTabSwitcherWidget * self,
                                          gpointer klass)
{
	self->priv = budgie_tab_switcher_widget_get_instance_private (self);
	self->window = NULL;
}

static void
budgie_tab_switcher_widget_finalize (GObject * obj)
{
	BudgieTabSwitcherWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_TAB_SWITCHER_WIDGET, BudgieTabSwitcherWidget);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->application);
	_g_object_unref0 (self->priv->info);
	_g_free0 (self->id);
	_g_free0 (self->title);
	G_OBJECT_CLASS (budgie_tab_switcher_widget_parent_class)->finalize (obj);
}

/**
* A TabSwitcherWidget is used for each icon in the display
*/
static GType
budgie_tab_switcher_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieTabSwitcherWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_tab_switcher_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieTabSwitcherWidget), 0, (GInstanceInitFunc) budgie_tab_switcher_widget_instance_init, NULL };
	GType budgie_tab_switcher_widget_type_id;
	budgie_tab_switcher_widget_type_id = g_type_register_static (gtk_flow_box_child_get_type (), "BudgieTabSwitcherWidget", &g_define_type_info, 0);
	BudgieTabSwitcherWidget_private_offset = g_type_add_instance_private (budgie_tab_switcher_widget_type_id, sizeof (BudgieTabSwitcherWidgetPrivate));
	return budgie_tab_switcher_widget_type_id;
}

GType
budgie_tab_switcher_widget_get_type (void)
{
	static volatile gsize budgie_tab_switcher_widget_type_id__once = 0;
	if (g_once_init_enter (&budgie_tab_switcher_widget_type_id__once)) {
		GType budgie_tab_switcher_widget_type_id;
		budgie_tab_switcher_widget_type_id = budgie_tab_switcher_widget_get_type_once ();
		g_once_init_leave (&budgie_tab_switcher_widget_type_id__once, budgie_tab_switcher_widget_type_id);
	}
	return budgie_tab_switcher_widget_type_id__once;
}

static inline gpointer
budgie_tab_switcher_window_get_instance_private (BudgieTabSwitcherWindow* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieTabSwitcherWindow_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

/**
* Construct a new TabSwitcherWindow
*/
BudgieTabSwitcherWindow*
budgie_tab_switcher_window_construct (GType object_type)
{
	BudgieTabSwitcherWindow * self = NULL;
	self = (BudgieTabSwitcherWindow*) g_object_new (object_type, "type", GTK_WINDOW_POPUP, "type-hint", GDK_WINDOW_TYPE_HINT_NOTIFICATION, NULL);
	return self;
}

BudgieTabSwitcherWindow*
budgie_tab_switcher_window_new (void)
{
	return budgie_tab_switcher_window_construct (BUDGIE_TYPE_TAB_SWITCHER_WINDOW);
}

static void
_budgie_tab_switcher_window_set_window_as_activated_budgie_tab_switcher_widget_window_activated (BudgieTabSwitcherWidget* _sender,
                                                                                                 XfwWindow* window,
                                                                                                 gpointer self)
{
	budgie_tab_switcher_window_set_window_as_activated ((BudgieTabSwitcherWindow*) self, window);
}

static void
_budgie_tab_switcher_window_remove_window_budgie_tab_switcher_widget_closed (BudgieTabSwitcherWidget* _sender,
                                                                             BudgieTabSwitcherWidget* widget,
                                                                             gpointer self)
{
	budgie_tab_switcher_window_remove_window ((BudgieTabSwitcherWindow*) self, widget);
}

static void
__lambda65_ (BudgieTabSwitcherWindow* self)
{
	GtkFlowBox* _tmp0_;
	_tmp0_ = self->priv->window_box;
	gtk_flow_box_invalidate_filter (_tmp0_);
}

static void
___lambda65__budgie_tab_switcher_widget_workspace_changed (BudgieTabSwitcherWidget* _sender,
                                                           gpointer self)
{
	__lambda65_ ((BudgieTabSwitcherWindow*) self);
}

static void
budgie_tab_switcher_window_add_window (BudgieTabSwitcherWindow* self,
                                       XfwWindow* window)
{
	gboolean _tmp0_ = FALSE;
	BudgieTabSwitcherWidget* window_widget = NULL;
	BudgieAppSystem* _tmp1_;
	BudgieTabSwitcherWidget* _tmp2_;
	gchar* id = NULL;
	BudgieTabSwitcherWidget* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GHashTable* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	BudgieTabSwitcherWidget* _tmp9_;
	BudgieTabSwitcherWidget* _tmp10_;
	const gchar* _tmp11_;
	GtkFlowBox* _tmp14_;
	BudgieTabSwitcherWidget* _tmp15_;
	BudgieTabSwitcherWidget* _tmp16_;
	BudgieTabSwitcherWidget* _tmp17_;
	BudgieTabSwitcherWidget* _tmp18_;
	GtkFlowBox* _tmp19_;
	GtkFlowBox* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (xfw_window_is_skip_pager (window)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = xfw_window_is_skip_tasklist (window);
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->app_system;
	_tmp2_ = budgie_tab_switcher_widget_new (_tmp1_, window);
	g_object_ref_sink (_tmp2_);
	window_widget = _tmp2_;
	_tmp3_ = window_widget;
	_tmp4_ = _tmp3_->id;
	_tmp5_ = g_strdup (_tmp4_);
	id = _tmp5_;
	_tmp6_ = self->priv->ids;
	_tmp7_ = id;
	_tmp8_ = g_strdup (_tmp7_);
	_tmp9_ = window_widget;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	g_hash_table_insert (_tmp6_, _tmp8_, _tmp10_);
	_tmp11_ = id;
	if (budgie_tab_switcher_window_get_position_in_recency (self, _tmp11_) == ((gint64) -1)) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = id;
		_tmp13_ = g_strdup (_tmp12_);
		self->priv->recency = g_list_append (self->priv->recency, _tmp13_);
	}
	_tmp14_ = self->priv->window_box;
	_tmp15_ = window_widget;
	gtk_flow_box_insert (_tmp14_, (GtkWidget*) _tmp15_, -1);
	_tmp16_ = window_widget;
	g_signal_connect_object (_tmp16_, "window-activated", (GCallback) _budgie_tab_switcher_window_set_window_as_activated_budgie_tab_switcher_widget_window_activated, self, 0);
	_tmp17_ = window_widget;
	g_signal_connect_object (_tmp17_, "closed", (GCallback) _budgie_tab_switcher_window_remove_window_budgie_tab_switcher_widget_closed, self, 0);
	_tmp18_ = window_widget;
	g_signal_connect_object (_tmp18_, "workspace-changed", (GCallback) ___lambda65__budgie_tab_switcher_widget_workspace_changed, self, 0);
	_tmp19_ = self->priv->window_box;
	gtk_flow_box_invalidate_filter (_tmp19_);
	_tmp20_ = self->priv->window_box;
	gtk_flow_box_invalidate_sort (_tmp20_);
	budgie_tab_switcher_window_update_sizing (self);
	_g_free0 (id);
	_g_object_unref0 (window_widget);
}

static gboolean
budgie_tab_switcher_window_flowbox_filter (BudgieTabSwitcherWindow* self,
                                           GtkFlowBoxChild* box_child)
{
	BudgieTabSwitcherWidget* tab = NULL;
	BudgieTabSwitcherWidget* _tmp0_;
	gboolean _tmp1_ = FALSE;
	BudgieTabSwitcherWidget* _tmp2_;
	gboolean _tmp5_ = FALSE;
	BudgieTabSwitcherWidget* _tmp6_;
	XfwWindow* _tmp7_;
	BudgieTabSwitcherWidget* _tmp10_;
	XfwWindow* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box_child != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (BUDGIE_IS_TAB_SWITCHER_WIDGET (box_child) ? ((BudgieTabSwitcherWidget*) box_child) : NULL);
	tab = _tmp0_;
	_tmp2_ = tab;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		BudgieTabSwitcherWidget* _tmp3_;
		XfwWindow* _tmp4_;
		_tmp3_ = tab;
		_tmp4_ = _tmp3_->window;
		_tmp1_ = _tmp4_ == NULL;
	}
	if (_tmp1_) {
		result = FALSE;
		_g_object_unref0 (tab);
		return result;
	}
	_tmp6_ = tab;
	_tmp7_ = _tmp6_->window;
	if (xfw_window_is_skip_pager (_tmp7_)) {
		_tmp5_ = TRUE;
	} else {
		BudgieTabSwitcherWidget* _tmp8_;
		XfwWindow* _tmp9_;
		_tmp8_ = tab;
		_tmp9_ = _tmp8_->window;
		_tmp5_ = xfw_window_is_skip_tasklist (_tmp9_);
	}
	if (_tmp5_) {
		result = FALSE;
		_g_object_unref0 (tab);
		return result;
	}
	if (self->priv->show_all_windows) {
		result = TRUE;
		_g_object_unref0 (tab);
		return result;
	}
	_tmp10_ = tab;
	_tmp11_ = _tmp10_->window;
	result = budgie_tab_switcher_window_window_on_active_workspace (self, _tmp11_);
	_g_object_unref0 (tab);
	return result;
}

static gint
budgie_tab_switcher_window_flowbox_sort (BudgieTabSwitcherWindow* self,
                                         GtkFlowBoxChild* child1,
                                         GtkFlowBoxChild* child2)
{
	BudgieTabSwitcherWidget* tab1 = NULL;
	BudgieTabSwitcherWidget* _tmp0_;
	BudgieTabSwitcherWidget* tab2 = NULL;
	BudgieTabSwitcherWidget* _tmp1_;
	gint64 pos1 = 0LL;
	BudgieTabSwitcherWidget* _tmp2_;
	const gchar* _tmp3_;
	gint64 pos2 = 0LL;
	BudgieTabSwitcherWidget* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (child1 != NULL, 0);
	g_return_val_if_fail (child2 != NULL, 0);
	_tmp0_ = _g_object_ref0 (BUDGIE_IS_TAB_SWITCHER_WIDGET (child1) ? ((BudgieTabSwitcherWidget*) child1) : NULL);
	tab1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (BUDGIE_IS_TAB_SWITCHER_WIDGET (child2) ? ((BudgieTabSwitcherWidget*) child2) : NULL);
	tab2 = _tmp1_;
	_tmp2_ = tab1;
	_tmp3_ = _tmp2_->id;
	pos1 = budgie_tab_switcher_window_get_position_in_recency (self, _tmp3_);
	_tmp4_ = tab2;
	_tmp5_ = _tmp4_->id;
	pos2 = budgie_tab_switcher_window_get_position_in_recency (self, _tmp5_);
	if (pos1 < pos2) {
		_tmp6_ = -1;
	} else {
		_tmp6_ = 1;
	}
	result = _tmp6_;
	_g_object_unref0 (tab2);
	_g_object_unref0 (tab1);
	return result;
}

guint
budgie_tab_switcher_window_get_visible_children (BudgieTabSwitcherWindow* self)
{
	guint visible_children = 0U;
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	visible_children = (guint) 0;
	_tmp0_ = self->priv->window_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				BudgieTabSwitcherWidget* tab = NULL;
				GtkWidget* _tmp2_;
				BudgieTabSwitcherWidget* _tmp3_;
				gboolean _tmp4_ = FALSE;
				_tmp2_ = child;
				_tmp3_ = _g_object_ref0 (BUDGIE_IS_TAB_SWITCHER_WIDGET (_tmp2_) ? ((BudgieTabSwitcherWidget*) _tmp2_) : NULL);
				tab = _tmp3_;
				if (self->priv->show_all_windows) {
					_tmp4_ = TRUE;
				} else {
					BudgieTabSwitcherWidget* _tmp5_;
					XfwWindow* _tmp6_;
					_tmp5_ = tab;
					_tmp6_ = _tmp5_->window;
					_tmp4_ = budgie_tab_switcher_window_window_on_active_workspace (self, _tmp6_);
				}
				if (_tmp4_) {
					guint _tmp7_;
					_tmp7_ = visible_children;
					visible_children = _tmp7_ + 1;
				}
				_g_object_unref0 (tab);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	result = visible_children;
	return result;
}

static gint64
budgie_tab_switcher_window_get_position_in_recency (BudgieTabSwitcherWindow* self,
                                                    const gchar* id)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (id != NULL, 0LL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GList* _tmp2_;
				gchar* val = NULL;
				GList* _tmp3_;
				gconstpointer _tmp4_;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->recency;
				if (!(((guint) i) < g_list_length (_tmp2_))) {
					break;
				}
				_tmp3_ = self->priv->recency;
				_tmp4_ = g_list_nth_data (_tmp3_, (guint) i);
				_tmp5_ = g_strdup ((const gchar*) _tmp4_);
				val = _tmp5_;
				_tmp6_ = val;
				if (g_strcmp0 (_tmp6_, id) == 0) {
					result = (gint64) i;
					_g_free0 (val);
					return result;
				}
				_g_free0 (val);
			}
		}
	}
	result = (gint64) -1;
	return result;
}

/**
* Make the current selection the active window
*/
static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

static void
budgie_tab_switcher_window_on_hide (BudgieTabSwitcherWindow* self)
{
	GList* selection = NULL;
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	GtkFlowBoxChild* current = NULL;
	gboolean _tmp2_ = FALSE;
	GList* _tmp3_;
	GtkFlowBoxChild* _tmp9_;
	BudgieTabSwitcherWidget* tab = NULL;
	GtkFlowBoxChild* _tmp10_;
	BudgieTabSwitcherWidget* _tmp11_;
	GtkFlowBox* _tmp12_;
	GtkFlowBoxChild* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window_box;
	_tmp1_ = gtk_flow_box_get_selected_children (_tmp0_);
	selection = _tmp1_;
	current = NULL;
	_tmp3_ = selection;
	if (_tmp3_ != NULL) {
		GList* _tmp4_;
		_tmp4_ = selection;
		_tmp2_ = !vala_g_list_is_empty (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GList* _tmp5_;
		gconstpointer _tmp6_;
		GtkFlowBoxChild* _tmp7_;
		GtkFlowBoxChild* _tmp8_;
		_tmp5_ = selection;
		_tmp6_ = g_list_nth_data (_tmp5_, (guint) 0);
		_tmp7_ = (GtkFlowBoxChild*) _tmp6_;
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_flow_box_child_get_type ()) ? ((GtkFlowBoxChild*) _tmp7_) : NULL);
		_g_object_unref0 (current);
		current = _tmp8_;
	}
	_tmp9_ = current;
	if (_tmp9_ == NULL) {
		_g_object_unref0 (current);
		(selection == NULL) ? NULL : (selection = (g_list_free (selection), NULL));
		return;
	}
	_tmp10_ = current;
	_tmp11_ = _g_object_ref0 (BUDGIE_IS_TAB_SWITCHER_WIDGET (_tmp10_) ? ((BudgieTabSwitcherWidget*) _tmp10_) : NULL);
	tab = _tmp11_;
	_tmp12_ = self->priv->window_box;
	_tmp13_ = current;
	gtk_flow_box_unselect_child (_tmp12_, _tmp13_);
	{
		BudgieTabSwitcherWidget* _tmp14_;
		XfwWindow* _tmp15_;
		_tmp14_ = tab;
		_tmp15_ = _tmp14_->window;
		xfw_window_activate (_tmp15_, NULL, budgie_get_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("tabswitcher.vala:300: Failed to activate window: %s\n", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (tab);
		_g_object_unref0 (current);
		(selection == NULL) ? NULL : (selection = (g_list_free (selection), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (tab);
	_g_object_unref0 (current);
	(selection == NULL) ? NULL : (selection = (g_list_free (selection), NULL));
}

static void
budgie_tab_switcher_window_on_monitors_changed (BudgieTabSwitcherWindow* self)
{
	GdkScreen* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkMonitor* _tmp2_;
	GdkMonitor* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->default_screen;
	_tmp1_ = gdk_screen_get_display (_tmp0_);
	_tmp2_ = gdk_display_get_primary_monitor (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->primary_monitor);
	self->priv->primary_monitor = _tmp3_;
	budgie_tab_switcher_window_move_switcher (self);
}

static void
budgie_tab_switcher_window_on_workspace_changed (BudgieTabSwitcherWindow* self)
{
	XfwWorkspaceGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->workspace_group;
	if (_tmp0_ != NULL) {
		XfwWorkspaceGroup* _tmp1_;
		XfwWorkspace* _tmp2_;
		XfwWorkspace* _tmp3_;
		_tmp1_ = self->priv->workspace_group;
		g_object_get (_tmp1_, "active-workspace", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (self->priv->active_workspace);
		self->priv->active_workspace = _tmp3_;
	}
	budgie_tab_switcher_window_update_show_all_windows (self);
}

void
budgie_tab_switcher_window_move_switcher (BudgieTabSwitcherWindow* self)
{
	GdkRectangle bounds = {0};
	GdkMonitor* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	GtkAllocation alloc = {0};
	GtkWidget* _tmp2_;
	GtkAllocation _tmp3_ = {0};
	gint x = 0;
	GdkRectangle _tmp4_;
	GdkRectangle _tmp5_;
	GtkAllocation _tmp6_;
	gint y = 0;
	GdkRectangle _tmp7_;
	GdkRectangle _tmp8_;
	GtkAllocation _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->primary_monitor;
	gdk_monitor_get_geometry (_tmp0_, &_tmp1_);
	bounds = _tmp1_;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) self);
	gtk_widget_get_allocation (_tmp2_, &_tmp3_);
	alloc = _tmp3_;
	_tmp4_ = bounds;
	_tmp5_ = bounds;
	_tmp6_ = alloc;
	x = _tmp4_.x + ((_tmp5_.width / 2) - (_tmp6_.width / 2));
	_tmp7_ = bounds;
	_tmp8_ = bounds;
	_tmp9_ = alloc;
	y = _tmp7_.y + ((_tmp8_.height / 2) - (_tmp9_.height / 2));
	gtk_window_move ((GtkWindow*) self, x, y);
}

static void
budgie_tab_switcher_window_remove_window (BudgieTabSwitcherWindow* self,
                                          BudgieTabSwitcherWidget* widget)
{
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	GtkFlowBox* _tmp2_;
	GList* entries = NULL;
	GList* _tmp3_;
	const gchar* _tmp4_;
	GCompareFunc _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	if (widget == NULL) {
		return;
	}
	_tmp0_ = self->priv->ids;
	_tmp1_ = widget->id;
	g_hash_table_remove (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->window_box;
	gtk_container_remove ((GtkContainer*) _tmp2_, (GtkWidget*) widget);
	_tmp3_ = self->priv->recency;
	_tmp4_ = widget->id;
	_tmp5_ = ((GCompareFunc) g_strcmp0);
	_tmp6_ = g_list_find_custom (_tmp3_, _tmp4_, _tmp5_);
	entries = _tmp6_;
	_tmp7_ = entries;
	self->priv->recency = g_list_remove_link (self->priv->recency, _tmp7_);
	budgie_tab_switcher_window_update_sizing (self);
}

static void
budgie_tab_switcher_window_set_window_as_activated (BudgieTabSwitcherWindow* self,
                                                    XfwWindow* window)
{
	gchar* id = NULL;
	gchar* _tmp0_;
	GList* entries = NULL;
	GList* _tmp1_;
	GCompareFunc _tmp2_;
	GList* _tmp3_;
	gchar* _tmp4_;
	GtkFlowBox* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = g_strdup_printf ("%lu", (gulong) xfw_window_x11_get_xid (window));
	id = _tmp0_;
	_tmp1_ = self->priv->recency;
	_tmp2_ = ((GCompareFunc) g_strcmp0);
	_tmp3_ = g_list_find_custom (_tmp1_, id, _tmp2_);
	entries = _tmp3_;
	self->priv->recency = g_list_remove_link (self->priv->recency, entries);
	_tmp4_ = g_strdup (id);
	self->priv->recency = g_list_prepend (self->priv->recency, _tmp4_);
	_tmp5_ = self->priv->window_box;
	gtk_flow_box_invalidate_sort (_tmp5_);
	_g_free0 (id);
}

static void
budgie_tab_switcher_window_update_show_all_windows (BudgieTabSwitcherWindow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkFlowBox* _tmp2_;
	GtkFlowBox* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->settings;
	self->priv->show_all_windows = g_settings_get_boolean (_tmp1_, BUDGIE_SHOW_ALL_WINDOWS_KEY);
	_tmp2_ = self->priv->window_box;
	gtk_flow_box_invalidate_sort (_tmp2_);
	_tmp3_ = self->priv->window_box;
	gtk_flow_box_invalidate_filter (_tmp3_);
	budgie_tab_switcher_window_update_sizing (self);
}

static void
budgie_tab_switcher_window_update_sizing (BudgieTabSwitcherWindow* self)
{
	GtkFlowBox* _tmp0_;
	GtkFlowBox* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window_box;
	gtk_flow_box_set_max_children_per_line (_tmp0_, CLAMP (budgie_tab_switcher_window_get_visible_children (self), (guint) 1, (guint) 8));
	_tmp1_ = self->priv->window_box;
	gtk_widget_queue_resize ((GtkWidget*) _tmp1_);
	gtk_widget_queue_resize ((GtkWidget*) self);
	budgie_tab_switcher_window_move_switcher (self);
}

static gboolean
budgie_tab_switcher_window_window_on_active_workspace (BudgieTabSwitcherWindow* self,
                                                       XfwWindow* window)
{
	XfwWorkspace* win_workspace = NULL;
	XfwWorkspace* _tmp0_;
	gboolean _tmp1_ = FALSE;
	XfwWorkspace* _tmp2_;
	XfwWorkspace* _tmp4_;
	const gchar* _tmp5_;
	XfwWorkspace* _tmp6_;
	const gchar* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	_tmp0_ = xfw_window_get_workspace (window);
	win_workspace = _tmp0_;
	_tmp2_ = self->priv->active_workspace;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		XfwWorkspace* _tmp3_;
		_tmp3_ = win_workspace;
		_tmp1_ = _tmp3_ == NULL;
	}
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = win_workspace;
	_tmp5_ = xfw_workspace_get_id (_tmp4_);
	_tmp6_ = self->priv->active_workspace;
	_tmp7_ = xfw_workspace_get_id (_tmp6_);
	result = g_strcmp0 (_tmp5_, _tmp7_) == 0;
	return result;
}

void
budgie_tab_switcher_window_focus_item (BudgieTabSwitcherWindow* self,
                                       gboolean backwards)
{
	XfwWindow* active_window = NULL;
	XfwScreen* _tmp0_;
	XfwWindow* _tmp1_;
	BudgieTabSwitcherWidget* _tmp2_ = NULL;
	XfwWindow* _tmp3_;
	BudgieTabSwitcherWidget* widget = NULL;
	BudgieTabSwitcherWidget* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GtkFlowBoxChild* new_child = NULL;
	BudgieTabSwitcherWidget* new_widget = NULL;
	guint len = 0U;
	GList* _tmp27_;
	gint64 _tmp28_ = 0LL;
	BudgieTabSwitcherWidget* _tmp29_;
	gint64 id_pos = 0LL;
	GtkFlowBoxChild* _tmp53_;
	BudgieTabSwitcherWidget* _tmp54_;
	GtkLabel* _tmp55_;
	BudgieTabSwitcherWidget* _tmp56_;
	const gchar* _tmp57_;
	GtkFlowBox* _tmp58_;
	GtkFlowBoxChild* _tmp59_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->xfce_screen;
	_tmp1_ = xfw_screen_get_active_window (_tmp0_);
	active_window = _tmp1_;
	_tmp3_ = active_window;
	if (_tmp3_ != NULL) {
		GHashTable* _tmp4_;
		XfwWindow* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gconstpointer _tmp8_;
		_tmp4_ = self->priv->ids;
		_tmp5_ = active_window;
		_tmp6_ = g_strdup_printf ("%lu", (gulong) xfw_window_x11_get_xid (_tmp5_));
		_tmp7_ = _tmp6_;
		_tmp8_ = g_hash_table_lookup (_tmp4_, _tmp7_);
		_tmp2_ = (BudgieTabSwitcherWidget*) _tmp8_;
		_g_free0 (_tmp7_);
	} else {
		_tmp2_ = NULL;
	}
	_tmp9_ = _g_object_ref0 (_tmp2_);
	widget = _tmp9_;
	_tmp10_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		GtkFlowBox* _tmp12_;
		GList* _tmp13_;
		GList* _tmp14_;
		gconstpointer _tmp15_;
		GtkFlowBoxChild* _tmp16_;
		BudgieTabSwitcherWidget* _tmp17_;
		BudgieTabSwitcherWidget* _tmp18_;
		_tmp12_ = self->priv->window_box;
		_tmp13_ = gtk_flow_box_get_selected_children (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_list_nth_data (_tmp14_, (guint) 0);
		_tmp16_ = (GtkFlowBoxChild*) _tmp15_;
		_tmp17_ = _g_object_ref0 (BUDGIE_IS_TAB_SWITCHER_WIDGET (_tmp16_) ? ((BudgieTabSwitcherWidget*) _tmp16_) : NULL);
		_g_object_unref0 (widget);
		widget = _tmp17_;
		(_tmp14_ == NULL) ? NULL : (_tmp14_ = (g_list_free (_tmp14_), NULL));
		_tmp18_ = widget;
		if (_tmp18_ != NULL) {
			BudgieTabSwitcherWidget* _tmp19_;
			XfwWindow* _tmp20_;
			_tmp19_ = widget;
			_tmp20_ = _tmp19_->window;
			active_window = _tmp20_;
		}
	} else {
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp22_ = gtk_widget_get_visible ((GtkWidget*) self);
		_tmp23_ = _tmp22_;
		if (!_tmp23_) {
			BudgieTabSwitcherWidget* _tmp24_;
			_tmp24_ = widget;
			_tmp21_ = _tmp24_ != NULL;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			GtkFlowBox* _tmp25_;
			BudgieTabSwitcherWidget* _tmp26_;
			_tmp25_ = self->priv->window_box;
			_tmp26_ = widget;
			gtk_flow_box_select_child (_tmp25_, (GtkFlowBoxChild*) _tmp26_);
		}
	}
	new_child = NULL;
	new_widget = NULL;
	_tmp27_ = self->priv->recency;
	len = g_list_length (_tmp27_);
	_tmp29_ = widget;
	if (_tmp29_ != NULL) {
		BudgieTabSwitcherWidget* _tmp30_;
		const gchar* _tmp31_;
		_tmp30_ = widget;
		_tmp31_ = _tmp30_->id;
		_tmp28_ = CLAMP (budgie_tab_switcher_window_get_position_in_recency (self, _tmp31_), (gint64) 0, (gint64) (len - 1));
	} else {
		_tmp28_ = (gint64) 0;
	}
	id_pos = _tmp28_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				guint64 new_id_pos = 0ULL;
				GtkFlowBoxChild* child_at_pos = NULL;
				GtkFlowBox* _tmp36_;
				GtkFlowBoxChild* _tmp37_;
				GtkFlowBoxChild* _tmp38_;
				GtkFlowBoxChild* _tmp39_;
				BudgieTabSwitcherWidget* widget_at_pos = NULL;
				GtkFlowBoxChild* _tmp40_;
				BudgieTabSwitcherWidget* _tmp41_;
				gboolean _tmp42_ = FALSE;
				BudgieTabSwitcherWidget* _tmp43_;
				gboolean _tmp46_ = FALSE;
				GtkFlowBoxChild* _tmp49_;
				GtkFlowBoxChild* _tmp50_;
				BudgieTabSwitcherWidget* _tmp51_;
				BudgieTabSwitcherWidget* _tmp52_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				if (!(((guint) i) < len)) {
					break;
				}
				new_id_pos = (guint64) 0;
				if (backwards) {
					gint64 _tmp34_ = 0LL;
					if (id_pos == ((gint64) 0)) {
						_tmp34_ = (gint64) len;
					} else {
						_tmp34_ = id_pos;
					}
					new_id_pos = (guint64) (_tmp34_ - (i + 1));
				} else {
					gint64 _tmp35_ = 0LL;
					if (id_pos == ((gint64) (len - 1))) {
						_tmp35_ = (gint64) 0;
					} else {
						_tmp35_ = id_pos + (i + 1);
					}
					new_id_pos = (guint64) _tmp35_;
				}
				_tmp36_ = self->priv->window_box;
				_tmp37_ = gtk_flow_box_get_child_at_index (_tmp36_, (gint) new_id_pos);
				_tmp38_ = _g_object_ref0 (_tmp37_);
				child_at_pos = _tmp38_;
				_tmp39_ = child_at_pos;
				if (_tmp39_ == NULL) {
					_g_object_unref0 (child_at_pos);
					continue;
				}
				_tmp40_ = child_at_pos;
				_tmp41_ = _g_object_ref0 (BUDGIE_IS_TAB_SWITCHER_WIDGET (_tmp40_) ? ((BudgieTabSwitcherWidget*) _tmp40_) : NULL);
				widget_at_pos = _tmp41_;
				_tmp43_ = widget_at_pos;
				if (_tmp43_ == NULL) {
					_tmp42_ = TRUE;
				} else {
					BudgieTabSwitcherWidget* _tmp44_;
					XfwWindow* _tmp45_;
					_tmp44_ = widget_at_pos;
					_tmp45_ = _tmp44_->window;
					_tmp42_ = _tmp45_ == NULL;
				}
				if (_tmp42_) {
					_g_object_unref0 (widget_at_pos);
					_g_object_unref0 (child_at_pos);
					continue;
				}
				if (!self->priv->show_all_windows) {
					BudgieTabSwitcherWidget* _tmp47_;
					XfwWindow* _tmp48_;
					_tmp47_ = widget_at_pos;
					_tmp48_ = _tmp47_->window;
					_tmp46_ = !budgie_tab_switcher_window_window_on_active_workspace (self, _tmp48_);
				} else {
					_tmp46_ = FALSE;
				}
				if (_tmp46_) {
					_g_object_unref0 (widget_at_pos);
					_g_object_unref0 (child_at_pos);
					continue;
				}
				_tmp49_ = child_at_pos;
				_tmp50_ = _g_object_ref0 (_tmp49_);
				_g_object_unref0 (new_child);
				new_child = _tmp50_;
				_tmp51_ = widget_at_pos;
				_tmp52_ = _g_object_ref0 (_tmp51_);
				_g_object_unref0 (new_widget);
				new_widget = _tmp52_;
				_g_object_unref0 (widget_at_pos);
				_g_object_unref0 (child_at_pos);
				break;
			}
		}
	}
	_tmp53_ = new_child;
	if (_tmp53_ == NULL) {
		_g_object_unref0 (new_widget);
		_g_object_unref0 (new_child);
		_g_object_unref0 (widget);
		return;
	}
	_tmp54_ = new_widget;
	if (_tmp54_ == NULL) {
		_g_object_unref0 (new_widget);
		_g_object_unref0 (new_child);
		_g_object_unref0 (widget);
		return;
	}
	_tmp55_ = self->priv->window_title;
	_tmp56_ = new_widget;
	_tmp57_ = _tmp56_->title;
	gtk_label_set_text (_tmp55_, _tmp57_);
	_tmp58_ = self->priv->window_box;
	_tmp59_ = new_child;
	gtk_flow_box_select_child (_tmp58_, _tmp59_);
	_g_object_unref0 (new_widget);
	_g_object_unref0 (new_child);
	_g_object_unref0 (widget);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_budgie_tab_switcher_window_update_show_all_windows_g_settings_changed (GSettings* _sender,
                                                                        const gchar* key,
                                                                        gpointer self)
{
	budgie_tab_switcher_window_update_show_all_windows ((BudgieTabSwitcherWindow*) self);
}

static void
_budgie_tab_switcher_window_add_window_gfunc (gconstpointer data,
                                              gpointer self)
{
	budgie_tab_switcher_window_add_window ((BudgieTabSwitcherWindow*) self, (XfwWindow*) data);
}

static void
_budgie_tab_switcher_window_add_window_libxfce4windowing_screen_window_opened (XfwScreen* _sender,
                                                                               XfwWindow* window,
                                                                               gpointer self)
{
	budgie_tab_switcher_window_add_window ((BudgieTabSwitcherWindow*) self, window);
}

static void
_budgie_tab_switcher_window_on_workspace_changed_libxfce4windowing_workspace_group_active_workspace_changed (XfwWorkspaceGroup* _sender,
                                                                                                             XfwWorkspace* previously_active_workspace,
                                                                                                             gpointer self)
{
	budgie_tab_switcher_window_on_workspace_changed ((BudgieTabSwitcherWindow*) self);
}

static gboolean
_budgie_tab_switcher_window_flowbox_filter_gtk_flow_box_filter_func (GtkFlowBoxChild* child,
                                                                     gpointer self)
{
	gboolean result;
	result = budgie_tab_switcher_window_flowbox_filter ((BudgieTabSwitcherWindow*) self, child);
	return result;
}

static gint
_budgie_tab_switcher_window_flowbox_sort_gtk_flow_box_sort_func (GtkFlowBoxChild* child1,
                                                                 GtkFlowBoxChild* child2,
                                                                 gpointer self)
{
	gint result;
	result = budgie_tab_switcher_window_flowbox_sort ((BudgieTabSwitcherWindow*) self, child1, child2);
	return result;
}

static void
_budgie_tab_switcher_window_on_hide_gtk_widget_hide (GtkWidget* _sender,
                                                     gpointer self)
{
	budgie_tab_switcher_window_on_hide ((BudgieTabSwitcherWindow*) self);
}

static void
_budgie_tab_switcher_window_on_monitors_changed_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                             gpointer self)
{
	budgie_tab_switcher_window_on_monitors_changed ((BudgieTabSwitcherWindow*) self);
}

static GObject *
budgie_tab_switcher_window_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieTabSwitcherWindow * self;
	BudgieAppSystem* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GtkFlowBox* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GdkScreen* _tmp10_;
	GdkScreen* _tmp11_;
	XfwScreen* _tmp12_;
	XfwScreen* _tmp13_;
	GList* _tmp14_;
	XfwScreen* _tmp15_;
	XfwScreen* _tmp16_;
	XfwWorkspaceManager* _tmp17_;
	GList* groups = NULL;
	XfwWorkspaceManager* _tmp18_;
	GList* _tmp19_;
	gboolean _tmp20_ = FALSE;
	GList* _tmp21_;
	GtkFlowBox* _tmp29_;
	GtkFlowBox* _tmp30_;
	GdkVisual* vis = NULL;
	GdkScreen* _tmp31_;
	GdkVisual* _tmp32_;
	GdkVisual* _tmp33_;
	GdkVisual* _tmp34_;
	GdkScreen* _tmp36_;
	GdkScreen* _tmp37_;
	GtkFlowBox* _tmp39_;
	parent_class = G_OBJECT_CLASS (budgie_tab_switcher_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_TAB_SWITCHER_WINDOW, BudgieTabSwitcherWindow);
	_tmp0_ = budgie_app_system_new ();
	_g_object_unref0 (self->priv->app_system);
	self->priv->app_system = _tmp0_;
	(self->priv->recency == NULL) ? NULL : (self->priv->recency = (_g_list_free__g_free0_ (self->priv->recency), NULL));
	self->priv->recency = NULL;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->ids);
	self->priv->ids = _tmp3_;
	_tmp4_ = self->priv->window_box;
	gtk_flow_box_set_selection_mode (_tmp4_, GTK_SELECTION_SINGLE);
	_tmp5_ = g_settings_new ("com.solus-project.budgie-wm");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp5_;
	_tmp6_ = self->priv->settings;
	self->priv->show_all_windows = g_settings_get_boolean (_tmp6_, BUDGIE_SHOW_ALL_WINDOWS_KEY);
	_tmp7_ = self->priv->settings;
	if (_tmp7_ != NULL) {
		GSettings* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->settings;
		_tmp9_ = g_strconcat ("changed::", BUDGIE_SHOW_ALL_WINDOWS_KEY, NULL);
		g_signal_connect_object (_tmp8_, _tmp9_, (GCallback) _budgie_tab_switcher_window_update_show_all_windows_g_settings_changed, self, 0);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = gdk_screen_get_default ();
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (self->priv->default_screen);
	self->priv->default_screen = _tmp11_;
	_tmp12_ = xfw_screen_get_default ();
	_g_object_unref0 (self->priv->xfce_screen);
	self->priv->xfce_screen = _tmp12_;
	_tmp13_ = self->priv->xfce_screen;
	_tmp14_ = xfw_screen_get_windows (_tmp13_);
	g_list_foreach (_tmp14_, _budgie_tab_switcher_window_add_window_gfunc, self);
	_tmp15_ = self->priv->xfce_screen;
	g_signal_connect_object (_tmp15_, "window-opened", (GCallback) _budgie_tab_switcher_window_add_window_libxfce4windowing_screen_window_opened, self, 0);
	_tmp16_ = self->priv->xfce_screen;
	_tmp17_ = xfw_screen_get_workspace_manager (_tmp16_);
	self->priv->workspace_manager = _tmp17_;
	_tmp18_ = self->priv->workspace_manager;
	_tmp19_ = xfw_workspace_manager_list_workspace_groups (_tmp18_);
	groups = _tmp19_;
	_tmp21_ = groups;
	if (_tmp21_ != NULL) {
		GList* _tmp22_;
		_tmp22_ = groups;
		_tmp20_ = g_list_length (_tmp22_) > ((guint) 0);
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		GList* _tmp23_;
		gconstpointer _tmp24_;
		XfwWorkspaceGroup* _tmp25_;
		XfwWorkspaceGroup* _tmp26_;
		XfwWorkspace* _tmp27_;
		XfwWorkspace* _tmp28_;
		_tmp23_ = groups;
		_tmp24_ = g_list_nth_data (_tmp23_, (guint) 0);
		self->priv->workspace_group = (XfwWorkspaceGroup*) _tmp24_;
		_tmp25_ = self->priv->workspace_group;
		g_signal_connect_object (_tmp25_, "active-workspace-changed", (GCallback) _budgie_tab_switcher_window_on_workspace_changed_libxfce4windowing_workspace_group_active_workspace_changed, self, 0);
		_tmp26_ = self->priv->workspace_group;
		g_object_get (_tmp26_, "active-workspace", &_tmp27_, NULL);
		_tmp28_ = _tmp27_;
		_g_object_unref0 (self->priv->active_workspace);
		self->priv->active_workspace = _tmp28_;
	}
	_tmp29_ = self->priv->window_box;
	gtk_flow_box_set_filter_func (_tmp29_, _budgie_tab_switcher_window_flowbox_filter_gtk_flow_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp30_ = self->priv->window_box;
	gtk_flow_box_set_sort_func (_tmp30_, _budgie_tab_switcher_window_flowbox_sort_gtk_flow_box_sort_func, g_object_ref (self), g_object_unref);
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER_ALWAYS);
	g_signal_connect_object ((GtkWidget*) self, "hide", (GCallback) _budgie_tab_switcher_window_on_hide_gtk_widget_hide, self, 0);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	gtk_window_stick ((GtkWindow*) self);
	_tmp31_ = self->priv->default_screen;
	_tmp32_ = gdk_screen_get_rgba_visual (_tmp31_);
	_tmp33_ = _g_object_ref0 (_tmp32_);
	vis = _tmp33_;
	_tmp34_ = vis;
	if (_tmp34_ != NULL) {
		GdkVisual* _tmp35_;
		_tmp35_ = vis;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp35_);
	}
	_tmp36_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		GdkScreen* _tmp38_;
		_tmp38_ = self->priv->default_screen;
		g_signal_connect_object (_tmp38_, "monitors-changed", (GCallback) _budgie_tab_switcher_window_on_monitors_changed_gdk_screen_monitors_changed, self, 0);
	}
	gtk_window_set_default_size ((GtkWindow*) self, BUDGIE_SWITCHER_SIZE, -1);
	gtk_widget_realize ((GtkWidget*) self);
	budgie_tab_switcher_window_on_monitors_changed (self);
	_tmp39_ = self->priv->window_box;
	gtk_flow_box_invalidate_filter (_tmp39_);
	_g_object_unref0 (vis);
	return obj;
}

static void
budgie_tab_switcher_window_class_init (BudgieTabSwitcherWindowClass * klass,
                                       gpointer klass_data)
{
	budgie_tab_switcher_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieTabSwitcherWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = budgie_tab_switcher_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_tab_switcher_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/budgie/daemon/tabswitcher.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "window_box", FALSE, BudgieTabSwitcherWindow_private_offset + G_STRUCT_OFFSET (BudgieTabSwitcherWindowPrivate, window_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "window_title", FALSE, BudgieTabSwitcherWindow_private_offset + G_STRUCT_OFFSET (BudgieTabSwitcherWindowPrivate, window_title));
}

static void
budgie_tab_switcher_window_instance_init (BudgieTabSwitcherWindow * self,
                                          gpointer klass)
{
	self->priv = budgie_tab_switcher_window_get_instance_private (self);
	self->priv->active_workspace = NULL;
	self->priv->workspace_group = NULL;
	self->priv->app_system = NULL;
	self->priv->recency = NULL;
	self->priv->ids = NULL;
	self->priv->settings = NULL;
	self->priv->show_all_windows = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
budgie_tab_switcher_window_finalize (GObject * obj)
{
	BudgieTabSwitcherWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_TAB_SWITCHER_WINDOW, BudgieTabSwitcherWindow);
	_g_object_unref0 (self->priv->active_workspace);
	_g_object_unref0 (self->priv->default_screen);
	_g_object_unref0 (self->priv->xfce_screen);
	_g_object_unref0 (self->priv->app_system);
	_g_object_unref0 (self->priv->primary_monitor);
	(self->priv->recency == NULL) ? NULL : (self->priv->recency = (_g_list_free__g_free0_ (self->priv->recency), NULL));
	_g_hash_table_unref0 (self->priv->ids);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (budgie_tab_switcher_window_parent_class)->finalize (obj);
}

/**
*
*/
static GType
budgie_tab_switcher_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieTabSwitcherWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_tab_switcher_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieTabSwitcherWindow), 0, (GInstanceInitFunc) budgie_tab_switcher_window_instance_init, NULL };
	GType budgie_tab_switcher_window_type_id;
	budgie_tab_switcher_window_type_id = g_type_register_static (gtk_window_get_type (), "BudgieTabSwitcherWindow", &g_define_type_info, 0);
	BudgieTabSwitcherWindow_private_offset = g_type_add_instance_private (budgie_tab_switcher_window_type_id, sizeof (BudgieTabSwitcherWindowPrivate));
	return budgie_tab_switcher_window_type_id;
}

GType
budgie_tab_switcher_window_get_type (void)
{
	static volatile gsize budgie_tab_switcher_window_type_id__once = 0;
	if (g_once_init_enter (&budgie_tab_switcher_window_type_id__once)) {
		GType budgie_tab_switcher_window_type_id;
		budgie_tab_switcher_window_type_id = budgie_tab_switcher_window_get_type_once ();
		g_once_init_leave (&budgie_tab_switcher_window_type_id__once, budgie_tab_switcher_window_type_id);
	}
	return budgie_tab_switcher_window_type_id__once;
}

static inline gpointer
budgie_tab_switcher_get_instance_private (BudgieTabSwitcher* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieTabSwitcher_private_offset);
}

BudgieTabSwitcher*
budgie_tab_switcher_construct (GType object_type)
{
	BudgieTabSwitcher * self = NULL;
	BudgieTabSwitcherWindow* _tmp0_;
	self = (BudgieTabSwitcher*) g_object_new (object_type, NULL);
	_tmp0_ = budgie_tab_switcher_window_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->switcher_window);
	self->priv->switcher_window = _tmp0_;
	return self;
}

BudgieTabSwitcher*
budgie_tab_switcher_new (void)
{
	return budgie_tab_switcher_construct (BUDGIE_TYPE_TAB_SWITCHER);
}

/**
* Own the SWITCHER_DBUS_NAME
*/
static void
_budgie_tab_switcher_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                             const gchar* name,
                                                             gpointer self)
{
	budgie_tab_switcher_on_bus_acquired ((BudgieTabSwitcher*) self, connection);
}

static void
__lambda66_ (BudgieTabSwitcher* self)
{
}

static void
___lambda66__gbus_name_acquired_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self)
{
	__lambda66_ ((BudgieTabSwitcher*) self);
}

static void
_budgie_DaemonNameLost_gbus_name_lost_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                gpointer self)
{
	budgie_DaemonNameLost (connection, name);
}

void
budgie_tab_switcher_setup_dbus (BudgieTabSwitcher* self,
                                gboolean replace)
{
	GBusNameOwnerFlags flags = 0U;
	g_return_if_fail (self != NULL);
	flags = G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT;
	if (replace) {
		flags |= G_BUS_NAME_OWNER_FLAGS_REPLACE;
	}
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_SWITCHER_DBUS_NAME, flags, (GClosure*) ((_budgie_tab_switcher_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_tab_switcher_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda66__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda66__gbus_name_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) g_cclosure_new ((GCallback) _budgie_DaemonNameLost_gbus_name_lost_callback, NULL, (GClosureNotify) NULL));
}

/**
* Acquired SWITCHER_DBUS_NAME, register ourselves on the bus
*/
static void
budgie_tab_switcher_on_bus_acquired (BudgieTabSwitcher* self,
                                     GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		budgie_tab_switcher_register_object (self, conn, BUDGIE_SWITCHER_DBUS_OBJECT_PATH, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = stderr;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		fprintf (_tmp0_, "Error registering TabSwitcher: %s\n", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	budgie_setup = TRUE;
}

void
budgie_tab_switcher_ShowSwitcher (BudgieTabSwitcher* self,
                                  gboolean backwards,
                                  GError** error)
{
	BudgieTabSwitcherWindow* _tmp0_;
	BudgieTabSwitcherWindow* _tmp1_;
	BudgieTabSwitcherWindow* _tmp2_;
	BudgieTabSwitcherWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->switcher_window;
	if (budgie_tab_switcher_window_get_visible_children (_tmp0_) == ((guint) 0)) {
		return;
	}
	budgie_tab_switcher_add_mod_key_watcher (self);
	_tmp1_ = self->priv->switcher_window;
	budgie_tab_switcher_window_move_switcher (_tmp1_);
	_tmp2_ = self->priv->switcher_window;
	budgie_tab_switcher_window_focus_item (_tmp2_, backwards);
	_tmp3_ = self->priv->switcher_window;
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
}

void
budgie_tab_switcher_StopSwitcher (BudgieTabSwitcher* self,
                                  GError** error)
{
	BudgieTabSwitcherWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->switcher_window;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

static void
budgie_tab_switcher_add_mod_key_watcher (BudgieTabSwitcher* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->mod_timeout != ((guint32) 0)) {
		g_source_remove ((guint) self->priv->mod_timeout);
		self->priv->mod_timeout = (guint32) 0;
	}
	self->priv->mod_timeout = (guint32) g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BUDGIE_SWITCHER_MOD_EXPIRE_TIME, (GSourceFunc) budgie_tab_switcher_check_mod_key, g_object_ref (self), g_object_unref);
}

static gboolean
budgie_tab_switcher_check_mod_key (BudgieTabSwitcher* self)
{
	GdkModifierType modifier = 0U;
	GdkDisplay* _tmp0_;
	GdkSeat* _tmp1_;
	GdkDevice* _tmp2_;
	GdkWindow* _tmp3_;
	GdkModifierType _tmp4_ = 0U;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->mod_timeout = (guint32) 0;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_display_get_default_seat (_tmp0_);
	_tmp2_ = gdk_seat_get_pointer (_tmp1_);
	_tmp3_ = gdk_get_default_root_window ();
	gdk_device_get_state (_tmp2_, _tmp3_, NULL, &_tmp4_);
	modifier = _tmp4_;
	if ((modifier & GDK_MOD1_MASK) == 0) {
		_tmp7_ = (modifier & GDK_MOD3_MASK) == 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = (modifier & GDK_MOD4_MASK) == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = (modifier & GDK_CONTROL_MASK) == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		BudgieTabSwitcherWindow* _tmp8_;
		_tmp8_ = self->priv->switcher_window;
		gtk_widget_hide ((GtkWidget*) _tmp8_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static void
budgie_tab_switcher_class_init (BudgieTabSwitcherClass * klass,
                                gpointer klass_data)
{
	budgie_tab_switcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieTabSwitcher_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_tab_switcher_finalize;
}

static void
budgie_tab_switcher_instance_init (BudgieTabSwitcher * self,
                                   gpointer klass)
{
	self->priv = budgie_tab_switcher_get_instance_private (self);
	self->priv->switcher_window = NULL;
	self->priv->mod_timeout = (guint32) 0;
}

static void
budgie_tab_switcher_finalize (GObject * obj)
{
	BudgieTabSwitcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_TAB_SWITCHER, BudgieTabSwitcher);
	_g_object_unref0 (self->priv->switcher_window);
	G_OBJECT_CLASS (budgie_tab_switcher_parent_class)->finalize (obj);
}

/**
* TabSwitcher is responsible for managing the BudgieSwitcher over d-bus, receiving
* requests, for example, from budgie-wm
*/
static GType
budgie_tab_switcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieTabSwitcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_tab_switcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieTabSwitcher), 0, (GInstanceInitFunc) budgie_tab_switcher_instance_init, NULL };
	GType budgie_tab_switcher_type_id;
	budgie_tab_switcher_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieTabSwitcher", &g_define_type_info, 0);
	g_type_set_qdata (budgie_tab_switcher_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_tab_switcher_register_object);
	BudgieTabSwitcher_private_offset = g_type_add_instance_private (budgie_tab_switcher_type_id, sizeof (BudgieTabSwitcherPrivate));
	return budgie_tab_switcher_type_id;
}

GType
budgie_tab_switcher_get_type (void)
{
	static volatile gsize budgie_tab_switcher_type_id__once = 0;
	if (g_once_init_enter (&budgie_tab_switcher_type_id__once)) {
		GType budgie_tab_switcher_type_id;
		budgie_tab_switcher_type_id = budgie_tab_switcher_get_type_once ();
		g_once_init_leave (&budgie_tab_switcher_type_id__once, budgie_tab_switcher_type_id);
	}
	return budgie_tab_switcher_type_id__once;
}

static void
_dbus_budgie_tab_switcher_ShowSwitcher (BudgieTabSwitcher* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean backwards = FALSE;
	GVariant* _tmp80_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp80_ = g_variant_iter_next_value (&_arguments_iter);
	backwards = g_variant_get_boolean (_tmp80_);
	g_variant_unref (_tmp80_);
	budgie_tab_switcher_ShowSwitcher (self, backwards, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_tab_switcher_StopSwitcher (BudgieTabSwitcher* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_tab_switcher_StopSwitcher (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_tab_switcher_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowSwitcher") == 0) {
		_dbus_budgie_tab_switcher_ShowSwitcher (object, parameters, invocation);
	} else if (strcmp (method_name, "StopSwitcher") == 0) {
		_dbus_budgie_tab_switcher_StopSwitcher (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_tab_switcher_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_tab_switcher_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_tab_switcher_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_tab_switcher_dbus_interface_info), &_budgie_tab_switcher_dbus_interface_vtable, data, _budgie_tab_switcher_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_tab_switcher_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

