/* BaseDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BaseDialog.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BASE_DIALOG (base_dialog_get_type ())
#define BASE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_DIALOG, BaseDialog))
#define BASE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_DIALOG, BaseDialogClass))
#define IS_BASE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_DIALOG))
#define IS_BASE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_DIALOG))
#define BASE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_DIALOG, BaseDialogClass))

typedef struct _BaseDialog BaseDialog;
typedef struct _BaseDialogClass BaseDialogClass;
typedef struct _BaseDialogPrivate BaseDialogPrivate;

#define BLUETOOTH_OBEX_TYPE_TRANSFER (bluetooth_obex_transfer_get_type ())
#define BLUETOOTH_OBEX_TRANSFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER, BluetoothObexTransfer))
#define BLUETOOTH_OBEX_IS_TRANSFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER))
#define BLUETOOTH_OBEX_TRANSFER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER, BluetoothObexTransferIface))

typedef struct _BluetoothObexTransfer BluetoothObexTransfer;
typedef struct _BluetoothObexTransferIface BluetoothObexTransferIface;

#define BLUETOOTH_OBEX_TYPE_TRANSFER_PROXY (bluetooth_obex_transfer_proxy_get_type ())

#define BLUETOOTH_TYPE_DEVICE (bluetooth_device_get_type ())
#define BLUETOOTH_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDevice))
#define BLUETOOTH_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_DEVICE))
#define BLUETOOTH_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDeviceIface))

typedef struct _BluetoothDevice BluetoothDevice;
typedef struct _BluetoothDeviceIface BluetoothDeviceIface;

#define BLUETOOTH_TYPE_DEVICE_PROXY (bluetooth_device_proxy_get_type ())
enum  {
	BASE_DIALOG_0_PROPERTY,
	BASE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* base_dialog_properties[BASE_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BluetoothObexTransferIface {
	GTypeInterface parent_iface;
	void (*cancel) (BluetoothObexTransfer* self, GError** error);
	void (*resume) (BluetoothObexTransfer* self, GError** error);
	void (*suspend) (BluetoothObexTransfer* self, GError** error);
	gchar* (*get_status) (BluetoothObexTransfer* self);
	char* (*get_session) (BluetoothObexTransfer* self);
	gchar* (*get_name) (BluetoothObexTransfer* self);
	gchar* (*get_Type) (BluetoothObexTransfer* self);
	guint64 (*get_time) (BluetoothObexTransfer* self);
	guint64 (*get_size) (BluetoothObexTransfer* self);
	guint64 (*get_transferred) (BluetoothObexTransfer* self);
	gchar* (*get_filename) (BluetoothObexTransfer* self);
};

struct _BluetoothDeviceIface {
	GTypeInterface parent_iface;
	void (*cancel_pairing) (BluetoothDevice* self, GError** error);
	void (*connect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*connect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*connect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*disconnect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*disconnect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*disconnect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*pair) (BluetoothDevice* self, GError** error);
	gchar** (*get_UUIDs) (BluetoothDevice* self, gint* result_length1);
	gboolean (*get_blocked) (BluetoothDevice* self);
	void (*set_blocked) (BluetoothDevice* self, gboolean value);
	gboolean (*get_connected) (BluetoothDevice* self);
	gboolean (*get_legacy_pairing) (BluetoothDevice* self);
	gboolean (*get_paired) (BluetoothDevice* self);
	gboolean (*get_trusted) (BluetoothDevice* self);
	void (*set_trusted) (BluetoothDevice* self, gboolean value);
	gint16 (*get_RSSI) (BluetoothDevice* self);
	char* (*get_adapter) (BluetoothDevice* self);
	gchar* (*get_address) (BluetoothDevice* self);
	gchar* (*get_alias) (BluetoothDevice* self);
	void (*set_alias) (BluetoothDevice* self, const gchar* value);
	gchar* (*get_icon) (BluetoothDevice* self);
	gchar* (*get_modalias) (BluetoothDevice* self);
	gchar* (*get_name) (BluetoothDevice* self);
	guint16 (*get_appearance) (BluetoothDevice* self);
	guint32 (*get_class) (BluetoothDevice* self);
};

struct _BaseDialog {
	GtkDialog parent_instance;
	BaseDialogPrivate * priv;
	BluetoothObexTransfer* transfer;
	BluetoothDevice* device;
	gint start_time;
	guint64 total_size;
	GtkProgressBar* progress_bar;
	GtkLabel* device_label;
	GtkLabel* directory_label;
	GtkLabel* progress_label;
	GtkLabel* filename_label;
	GtkLabel* rate_label;
	GtkImage* device_image;
};

struct _BaseDialogClass {
	GtkDialogClass parent_class;
};

static gpointer base_dialog_parent_class = NULL;

VALA_EXTERN GType base_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseDialog, g_object_unref)
VALA_EXTERN GType bluetooth_obex_transfer_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_obex_transfer_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
VALA_EXTERN GType bluetooth_obex_transfer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothObexTransfer, g_object_unref)
VALA_EXTERN GType bluetooth_device_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_device_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType bluetooth_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothDevice, g_object_unref)
static BaseDialog* base_dialog_construct (GType object_type,
                                   GtkApplication* application);
VALA_EXTERN void base_dialog_on_transfer_progress (BaseDialog* self,
                                       guint64 transferred);
VALA_EXTERN gchar* base_dialog_format_time (BaseDialog* self,
                                gint seconds);
static GObject * base_dialog_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void _base_dialog___lambda16_ (BaseDialog* self,
                               gint response_id);
VALA_EXTERN gchar* bluetooth_obex_transfer_get_status (BluetoothObexTransfer* self);
VALA_EXTERN void bluetooth_obex_transfer_cancel (BluetoothObexTransfer* self,
                                     GError** error);
static void __base_dialog___lambda16__gtk_dialog_response (GtkDialog* _sender,
                                                    gint response_id,
                                                    gpointer self);
static gboolean _base_dialog___lambda17_ (BaseDialog* self);
static gboolean __base_dialog___lambda17__gtk_widget_delete_event (GtkWidget* _sender,
                                                            GdkEventAny* event,
                                                            gpointer self);
static void base_dialog_finalize (GObject * obj);
static GType base_dialog_get_type_once (void);

static BaseDialog*
base_dialog_construct (GType object_type,
                       GtkApplication* application)
{
	BaseDialog * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	self = (BaseDialog*) g_object_new (object_type, "application", application, "resizable", FALSE, NULL);
	return self;
}

void
base_dialog_on_transfer_progress (BaseDialog* self,
                                  guint64 transferred)
{
	GtkProgressBar* _tmp0_;
	gint current_time = 0;
	gint elapsed_time = 0;
	guint64 transfer_rate = 0ULL;
	GtkLabel* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	guint64 remaining_time = 0ULL;
	GtkLabel* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->progress_bar;
	gtk_progress_bar_set_fraction (_tmp0_, ((gdouble) transferred) / ((gdouble) self->total_size));
	current_time = (gint) g_get_real_time ();
	elapsed_time = (current_time - self->start_time) / 1000000;
	if (current_time < (self->start_time + 1000000)) {
		return;
	}
	if (elapsed_time == 0) {
		return;
	}
	transfer_rate = transferred / elapsed_time;
	if (transfer_rate == ((guint64) 0)) {
		return;
	}
	_tmp1_ = self->rate_label;
	_tmp2_ = g_format_size_full (transfer_rate, G_FORMAT_SIZE_DEFAULT);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_markup_printf_escaped (_ ("<b>Transfer rate:</b> %s / s"), _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp1_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	remaining_time = (self->total_size - transferred) / transfer_rate;
	_tmp6_ = self->progress_label;
	_tmp7_ = g_format_size_full (transferred, G_FORMAT_SIZE_DEFAULT);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_format_size_full (self->total_size, G_FORMAT_SIZE_DEFAULT);
	_tmp10_ = _tmp9_;
	_tmp11_ = base_dialog_format_time (self, (gint) remaining_time);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf (_ ("%s / %s: Time remaining: %s"), _tmp8_, _tmp10_, _tmp12_);
	_tmp14_ = _tmp13_;
	gtk_label_set_label (_tmp6_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
}

gchar*
base_dialog_format_time (BaseDialog* self,
                         gint seconds)
{
	gint hours = 0;
	gint minutes = 0;
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (seconds < 0) {
		seconds = 0;
	}
	hours = seconds / 3600;
	minutes = (seconds - (hours * 3600)) / 60;
	seconds = (seconds - (hours * 3600)) - (minutes * 60);
	if (hours > 0) {
		gchar* h = NULL;
		gchar* _tmp0_;
		gchar* m = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = g_strdup_printf (ngettext ("%u hour", "%u hours", (gulong) hours), (guint) hours);
		h = _tmp0_;
		_tmp1_ = g_strdup_printf (ngettext ("%u minute", "%u minutes", (gulong) minutes), (guint) minutes);
		m = _tmp1_;
		_tmp2_ = h;
		_tmp3_ = m;
		_tmp4_ = g_strdup_printf ("%s, %s", _tmp2_, _tmp3_);
		result = _tmp4_;
		_g_free0 (m);
		_g_free0 (h);
		return result;
	}
	if (minutes > 0) {
		gchar* m = NULL;
		gchar* _tmp5_;
		gchar* s = NULL;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = g_strdup_printf (ngettext ("%u minute", "%u minutes", (gulong) minutes), (guint) minutes);
		m = _tmp5_;
		_tmp6_ = g_strdup_printf (ngettext ("%u second", "%u seconds", (gulong) seconds), (guint) seconds);
		s = _tmp6_;
		_tmp7_ = m;
		_tmp8_ = s;
		_tmp9_ = g_strdup_printf ("%s, %s", _tmp7_, _tmp8_);
		result = _tmp9_;
		_g_free0 (s);
		_g_free0 (m);
		return result;
	}
	_tmp10_ = g_strdup_printf (ngettext ("%d second", "%d seconds", (gulong) seconds), seconds);
	result = _tmp10_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_base_dialog___lambda16_ (BaseDialog* self,
                          gint response_id)
{
	GError* _inner_error0_ = NULL;
	if (response_id == ((gint) GTK_RESPONSE_CANCEL)) {
		gboolean _tmp0_ = FALSE;
		BluetoothObexTransfer* _tmp1_;
		_tmp1_ = self->transfer;
		if (_tmp1_ != NULL) {
			BluetoothObexTransfer* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp2_ = self->transfer;
			_tmp3_ = bluetooth_obex_transfer_get_status (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp0_ = g_strcmp0 (_tmp5_, "active") == 0;
			_g_free0 (_tmp5_);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			{
				BluetoothObexTransfer* _tmp6_;
				_tmp6_ = self->transfer;
				bluetooth_obex_transfer_cancel (_tmp6_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp7_;
				const gchar* _tmp8_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp7_ = e;
				_tmp8_ = _tmp7_->message;
				g_warning ("BaseDialog.vala:120: Error cancelling Bluetooth transfer: %s", _tmp8_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		gtk_widget_destroy ((GtkWidget*) self);
	} else {
		BluetoothObexTransfer* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = self->transfer;
		_tmp10_ = bluetooth_obex_transfer_get_status (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp12_, "active") == 0;
		_g_free0 (_tmp12_);
		if (_tmp13_) {
			gtk_widget_hide_on_delete ((GtkWidget*) self);
		} else {
			gtk_widget_destroy ((GtkWidget*) self);
		}
	}
}

static void
__base_dialog___lambda16__gtk_dialog_response (GtkDialog* _sender,
                                               gint response_id,
                                               gpointer self)
{
	_base_dialog___lambda16_ ((BaseDialog*) self, response_id);
}

static gboolean
_base_dialog___lambda17_ (BaseDialog* self)
{
	BluetoothObexTransfer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	_tmp0_ = self->transfer;
	_tmp1_ = bluetooth_obex_transfer_get_status (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "active") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		result = gtk_widget_hide_on_delete ((GtkWidget*) self);
		return result;
	} else {
		gtk_widget_destroy ((GtkWidget*) self);
	}
}

static gboolean
__base_dialog___lambda17__gtk_widget_delete_event (GtkWidget* _sender,
                                                   GdkEventAny* event,
                                                   gpointer self)
{
	gboolean result;
	result = _base_dialog___lambda17_ ((BaseDialog*) self);
	return result;
}

static GObject *
base_dialog_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BaseDialog * self;
	GtkImage* icon_image = NULL;
	GtkImage* _tmp0_ = NULL;
	GtkImage* _tmp1_ = NULL;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp2_ = NULL;
	GtkOverlay* _tmp3_;
	GtkImage* _tmp4_;
	GtkOverlay* _tmp5_;
	GtkImage* _tmp6_;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkLabel* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GtkLabel* _tmp14_ = NULL;
	GtkProgressBar* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkGrid* message_grid = NULL;
	GtkGrid* _tmp17_ = NULL;
	GtkGrid* _tmp18_;
	GtkOverlay* _tmp19_;
	GtkGrid* _tmp20_;
	GtkLabel* _tmp21_;
	GtkGrid* _tmp22_;
	GtkLabel* _tmp23_;
	GtkGrid* _tmp24_;
	GtkLabel* _tmp25_;
	GtkGrid* _tmp26_;
	GtkLabel* _tmp27_;
	GtkGrid* _tmp28_;
	GtkProgressBar* _tmp29_;
	GtkGrid* _tmp30_;
	GtkLabel* _tmp31_;
	GtkBox* _tmp32_;
	GtkGrid* _tmp33_;
	GtkWidget* reject_transfer = NULL;
	GtkWidget* _tmp34_;
	GtkWidget* _tmp35_;
	GtkWidget* _tmp36_;
	GtkStyleContext* _tmp37_;
	parent_class = G_OBJECT_CLASS (base_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BASE_DIALOG, BaseDialog);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("bluetooth-active", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	gtk_widget_set_valign ((GtkWidget*) _tmp0_, GTK_ALIGN_END);
	gtk_widget_set_halign ((GtkWidget*) _tmp0_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp0_);
	icon_image = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_END);
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->device_image);
	self->device_image = _tmp1_;
	_tmp2_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_widget_set_margin_right ((GtkWidget*) _tmp2_, 12);
	g_object_ref_sink (_tmp2_);
	overlay = _tmp2_;
	_tmp3_ = overlay;
	_tmp4_ = icon_image;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = overlay;
	_tmp6_ = self->device_image;
	gtk_overlay_add_overlay (_tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_max_width_chars (_tmp7_, 45);
	g_object_set (_tmp7_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp7_, (gfloat) 0);
	gtk_label_set_use_markup (_tmp7_, TRUE);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->directory_label);
	self->directory_label = _tmp7_;
	_tmp8_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_max_width_chars (_tmp8_, 45);
	g_object_set (_tmp8_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp8_, (gfloat) 0);
	gtk_label_set_use_markup (_tmp8_, TRUE);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->device_label);
	self->device_label = _tmp8_;
	_tmp9_ = g_markup_printf_escaped ("<b>%s</b>:", _ ("File name"));
	_tmp10_ = _tmp9_;
	_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
	gtk_label_set_max_width_chars (_tmp11_, 45);
	g_object_set (_tmp11_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp11_, (gfloat) 0);
	gtk_label_set_use_markup (_tmp11_, TRUE);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->filename_label);
	self->filename_label = _tmp11_;
	_g_free0 (_tmp10_);
	_tmp12_ = g_markup_printf_escaped ("<b>%s</b>:", _ ("Transfer rate"));
	_tmp13_ = _tmp12_;
	_tmp14_ = (GtkLabel*) gtk_label_new (_tmp13_);
	gtk_label_set_max_width_chars (_tmp14_, 45);
	g_object_set (_tmp14_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp14_, (gfloat) 0);
	gtk_label_set_use_markup (_tmp14_, TRUE);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->rate_label);
	self->rate_label = _tmp14_;
	_g_free0 (_tmp13_);
	_tmp15_ = (GtkProgressBar*) gtk_progress_bar_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp15_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, 4);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp15_, 4);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->progress_bar);
	self->progress_bar = _tmp15_;
	_tmp16_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_max_width_chars (_tmp16_, 45);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp16_, FALSE);
	g_object_set (_tmp16_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp16_, (gfloat) 0);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp16_, 4);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->progress_label);
	self->progress_label = _tmp16_;
	_tmp17_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp17_, 0);
	gtk_grid_set_row_spacing (_tmp17_, 4);
	g_object_set ((GtkWidget*) _tmp17_, "width-request", 450, NULL);
	g_object_set ((GtkWidget*) _tmp17_, "margin", 10, NULL);
	g_object_ref_sink (_tmp17_);
	message_grid = _tmp17_;
	_tmp18_ = message_grid;
	_tmp19_ = overlay;
	gtk_grid_attach (_tmp18_, (GtkWidget*) _tmp19_, 0, 0, 1, 3);
	_tmp20_ = message_grid;
	_tmp21_ = self->directory_label;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 1, 0, 1, 1);
	_tmp22_ = message_grid;
	_tmp23_ = self->device_label;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 1, 1, 1, 1);
	_tmp24_ = message_grid;
	_tmp25_ = self->filename_label;
	gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 1, 2, 1, 1);
	_tmp26_ = message_grid;
	_tmp27_ = self->rate_label;
	gtk_grid_attach (_tmp26_, (GtkWidget*) _tmp27_, 1, 3, 1, 1);
	_tmp28_ = message_grid;
	_tmp29_ = self->progress_bar;
	gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 1, 4, 1, 1);
	_tmp30_ = message_grid;
	_tmp31_ = self->progress_label;
	gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 1, 5, 1, 1);
	_tmp32_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp33_ = message_grid;
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
	gtk_dialog_add_button ((GtkDialog*) self, _ ("Close"), (gint) GTK_RESPONSE_CLOSE);
	_tmp34_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp35_ = _g_object_ref0 (_tmp34_);
	reject_transfer = _tmp35_;
	_tmp36_ = reject_transfer;
	_tmp37_ = gtk_widget_get_style_context (_tmp36_);
	gtk_style_context_add_class (_tmp37_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) __base_dialog___lambda16__gtk_dialog_response, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) __base_dialog___lambda17__gtk_widget_delete_event, self, 0);
	_g_object_unref0 (reject_transfer);
	_g_object_unref0 (message_grid);
	_g_object_unref0 (overlay);
	_g_object_unref0 (icon_image);
	return obj;
}

static void
base_dialog_class_init (BaseDialogClass * klass,
                        gpointer klass_data)
{
	base_dialog_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = base_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = base_dialog_finalize;
}

static void
base_dialog_instance_init (BaseDialog * self,
                           gpointer klass)
{
	self->start_time = 0;
	self->total_size = (guint64) 0;
}

static void
base_dialog_finalize (GObject * obj)
{
	BaseDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BASE_DIALOG, BaseDialog);
	_g_object_unref0 (self->transfer);
	_g_object_unref0 (self->device);
	_g_object_unref0 (self->progress_bar);
	_g_object_unref0 (self->device_label);
	_g_object_unref0 (self->directory_label);
	_g_object_unref0 (self->progress_label);
	_g_object_unref0 (self->filename_label);
	_g_object_unref0 (self->rate_label);
	_g_object_unref0 (self->device_image);
	G_OBJECT_CLASS (base_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
base_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaseDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) base_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaseDialog), 0, (GInstanceInitFunc) base_dialog_instance_init, NULL };
	GType base_dialog_type_id;
	base_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "BaseDialog", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return base_dialog_type_id;
}

GType
base_dialog_get_type (void)
{
	static volatile gsize base_dialog_type_id__once = 0;
	if (g_once_init_enter (&base_dialog_type_id__once)) {
		GType base_dialog_type_id;
		base_dialog_type_id = base_dialog_get_type_once ();
		g_once_init_leave (&base_dialog_type_id__once, base_dialog_type_id);
	}
	return base_dialog_type_id__once;
}

