/* src/bazaar.p/bz-root-curated-config.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-root-curated-config.h"



struct _BzRootCuratedConfig
{
  GObject parent_instance;

  char *css;
  GListModel *templates;
  GListModel *rows;
};

G_DEFINE_FINAL_TYPE (BzRootCuratedConfig, bz_root_curated_config, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_CSS,
  PROP_TEMPLATES,
  PROP_ROWS,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_root_curated_config_dispose (GObject *object)
{
  BzRootCuratedConfig *self = BZ_ROOT_CURATED_CONFIG (object);

  g_clear_pointer (&self->css, g_free);
  g_clear_pointer (&self->templates, g_object_unref);
  g_clear_pointer (&self->rows, g_object_unref);

  G_OBJECT_CLASS (bz_root_curated_config_parent_class)->dispose (object);
}

static void
bz_root_curated_config_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzRootCuratedConfig *self = BZ_ROOT_CURATED_CONFIG (object);

  switch (prop_id)
    {
    case PROP_CSS:
      g_value_set_string (value, bz_root_curated_config_get_css (self));
      break;
    case PROP_TEMPLATES:
      g_value_set_object (value, bz_root_curated_config_get_templates (self));
      break;
    case PROP_ROWS:
      g_value_set_object (value, bz_root_curated_config_get_rows (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_root_curated_config_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzRootCuratedConfig *self = BZ_ROOT_CURATED_CONFIG (object);

  switch (prop_id)
    {
    case PROP_CSS:
      bz_root_curated_config_set_css (self, g_value_get_string (value));
      break;
    case PROP_TEMPLATES:
      bz_root_curated_config_set_templates (self, g_value_get_object (value));
      break;
    case PROP_ROWS:
      bz_root_curated_config_set_rows (self, g_value_get_object (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_root_curated_config_class_init (BzRootCuratedConfigClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_root_curated_config_set_property;
  object_class->get_property = bz_root_curated_config_get_property;
  object_class->dispose      = bz_root_curated_config_dispose;

  props[PROP_CSS] =
      g_param_spec_string (
          "css",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_TEMPLATES] =
      g_param_spec_object (
          "templates",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_ROWS] =
      g_param_spec_object (
          "rows",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_root_curated_config_init (BzRootCuratedConfig *self)
{
}

BzRootCuratedConfig *
bz_root_curated_config_new (void){
  return g_object_new (BZ_TYPE_ROOT_CURATED_CONFIG, NULL);
}

const char *
bz_root_curated_config_get_css (BzRootCuratedConfig *self){
  g_return_val_if_fail (BZ_IS_ROOT_CURATED_CONFIG (self), NULL);
  return self->css;
}

GListModel *
bz_root_curated_config_get_templates (BzRootCuratedConfig *self){
  g_return_val_if_fail (BZ_IS_ROOT_CURATED_CONFIG (self), NULL);
  return self->templates;
}

GListModel *
bz_root_curated_config_get_rows (BzRootCuratedConfig *self){
  g_return_val_if_fail (BZ_IS_ROOT_CURATED_CONFIG (self), NULL);
  return self->rows;
}

void
bz_root_curated_config_set_css (BzRootCuratedConfig *self,
    const char *css){
  g_return_if_fail (BZ_IS_ROOT_CURATED_CONFIG (self));

  if (css == self->css || (css != NULL && self->css != NULL && g_strcmp0(css, self->css) == 0))
    return;

  g_clear_pointer (&self->css, g_free);
  if (css != NULL)
    self->css = g_strdup (css);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_CSS]);
}

void
bz_root_curated_config_set_templates (BzRootCuratedConfig *self,
    GListModel *templates){
  g_return_if_fail (BZ_IS_ROOT_CURATED_CONFIG (self));

  if (templates == self->templates)
    return;

  g_clear_pointer (&self->templates, g_object_unref);
  if (templates != NULL)
    self->templates = g_object_ref (templates);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_TEMPLATES]);
}

void
bz_root_curated_config_set_rows (BzRootCuratedConfig *self,
    GListModel *rows){
  g_return_if_fail (BZ_IS_ROOT_CURATED_CONFIG (self));

  if (rows == self->rows)
    return;

  g_clear_pointer (&self->rows, g_object_unref);
  if (rows != NULL)
    self->rows = g_object_ref (rows);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ROWS]);
}

/* End of src/bazaar.p/bz-root-curated-config.c */
