/* baobab-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from baobab-window.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "baobab.h"
#include <gtk/gtk.h>
#include <adwaita.h>
#include <glib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BAOBAB_WINDOW_0_PROPERTY,
	BAOBAB_WINDOW_NUM_PROPERTIES
};
static GParamSpec* baobab_window_properties[BAOBAB_WINDOW_NUM_PROPERTIES];
#define _baobab_location_unref0(var) ((var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block6Data Block6Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block9Data Block9Data;

struct _BaobabWindowPrivate {
	GtkEventControllerFocus* focus_controller;
	GtkDropTarget* drop_target;
	BaobabPathbar* pathbar;
	AdwNavigationView* nav_view;
	GtkWidget* home_page;
	GtkWidget* result_page;
	AdwToastOverlay* toast_overlay;
	AdwBanner* banner;
	BaobabLocationList* location_list;
	BaobabFolderDisplay* folder_display;
	GtkColumnView* columnview;
	GtkSingleSelection* columnview_selection;
	GtkSortListModel* columnview_sort_model;
	GtkPopoverMenu* treeview_popover_menu;
	AdwViewStack* chart_stack;
	GtkStack* spinner_stack;
	AdwViewSwitcher* chart_stack_switcher;
	BaobabChart* rings_chart;
	BaobabChart* treemap_chart;
	AdwSpinner* spinner;
	BaobabLocation* active_location;
	gboolean is_busy;
	gulong scan_completed_handler;
	guint scanning_progress_id;
	BaobabScannerResults* popover_item;
};

struct _Block6Data {
	int _ref_count_;
	BaobabWindow* self;
	GSettings* ui_settings;
};

struct _Block7Data {
	int _ref_count_;
	BaobabWindow* self;
	GtkFileChooserNative* file_chooser;
};

struct _Block8Data {
	int _ref_count_;
	BaobabWindow* self;
	BaobabLocation* location;
};

struct _Block9Data {
	int _ref_count_;
	BaobabWindow* self;
	BaobabLocation* location;
};

static gint BaobabWindow_private_offset;
static gpointer baobab_window_parent_class = NULL;
static GdkCursor* baobab_window_busy_cursor;
static GdkCursor* baobab_window_busy_cursor = NULL;

static void baobab_window_on_show_primary_menu_activate (BaobabWindow* self,
                                                  GSimpleAction* action);
static void _baobab_window_on_show_primary_menu_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void baobab_window_on_scan_folder_activate (BaobabWindow* self);
static void _baobab_window_on_scan_folder_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void baobab_window_on_reload_activate (BaobabWindow* self);
static void _baobab_window_on_reload_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void baobab_window_on_clear_recent (BaobabWindow* self);
static void _baobab_window_on_clear_recent_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void baobab_window_on_show_preferences (BaobabWindow* self);
static void _baobab_window_on_show_preferences_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void baobab_window_on_help_activate (BaobabWindow* self);
static void _baobab_window_on_help_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void baobab_window_on_about_activate (BaobabWindow* self);
static void _baobab_window_on_about_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void baobab_window_on_show_treeview_popover (BaobabWindow* self);
static void _baobab_window_on_show_treeview_popover_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void baobab_window_on_treeview_expand_row (BaobabWindow* self);
static void _baobab_window_on_treeview_expand_row_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void baobab_window_on_treeview_collapse_row (BaobabWindow* self);
static void _baobab_window_on_treeview_collapse_row_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void baobab_window_go_up_treeview (BaobabWindow* self);
static void _baobab_window_go_up_treeview_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void baobab_window_on_treeview_open_folder (BaobabWindow* self);
static void _baobab_window_on_treeview_open_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void baobab_window_on_treeview_copy (BaobabWindow* self);
static void _baobab_window_on_treeview_copy_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void baobab_window_on_treeview_trash (BaobabWindow* self);
static void _baobab_window_on_treeview_trash_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void baobab_window_location_activated (BaobabWindow* self,
                                       BaobabLocation* location);
static void _baobab_window_location_activated_baobab_location_list_location_activated (BaobabLocationList* _sender,
                                                                                BaobabLocation* location,
                                                                                gpointer self);
static void baobab_window_hide_columnview_header (BaobabWindow* self);
static void __lambda24_ (BaobabWindow* self);
static void ___lambda24__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
static void baobab_window_on_chart_item_activated (BaobabWindow* self,
                                            BaobabChart* chart,
                                            BaobabScannerResults* item);
static void _baobab_window_on_chart_item_activated_baobab_chart_item_activated (BaobabChart* _sender,
                                                                         BaobabScannerResults* item,
                                                                         gpointer self);
static void baobab_window_on_pathbar_item_activated (BaobabWindow* self,
                                              BaobabPathbar* pathbar,
                                              BaobabScannerResults* path);
static void _baobab_window_on_pathbar_item_activated_baobab_pathbar_item_activated (BaobabPathbar* _sender,
                                                                             BaobabScannerResults* path,
                                                                             gpointer self);
static void baobab_window_on_folder_display_activated (BaobabWindow* self);
static void _baobab_window_on_folder_display_activated_baobab_folder_display_activated (BaobabFolderDisplay* _sender,
                                                                                 gpointer self);
static gboolean baobab_window_on_drop (BaobabWindow* self,
                                GtkDropTarget* target,
                                GValue* value,
                                gdouble x,
                                gdouble y);
static gboolean _baobab_window_on_drop_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                      GValue* value,
                                                      gdouble x,
                                                      gdouble y,
                                                      gpointer self);
static gboolean baobab_window_on_drop_target_accept (BaobabWindow* self,
                                              GtkDropTarget* target,
                                              GdkDrop* drop);
static gboolean _baobab_window_on_drop_target_accept_gtk_drop_target_accept (GtkDropTarget* _sender,
                                                                      GdkDrop* drop,
                                                                      gpointer self);
static gboolean __lambda25_ (Block6Data* _data6_);
static gboolean ___lambda25__gtk_window_close_request (GtkWindow* _sender,
                                                gpointer self);
static void baobab_window_set_ui_state (BaobabWindow* self,
                                 GtkWidget* child,
                                 gboolean busy);
static void __lambda26_ (BaobabWindow* self);
static void ___lambda26__gtk_event_controller_focus_enter (GtkEventControllerFocus* _sender,
                                                    gpointer self);
static void baobab_window_results_hidden (BaobabWindow* self);
static void baobab_window_cancel_scan (BaobabWindow* self);
static void _baobab_window_results_hidden_adw_navigation_page_hidden (AdwNavigationPage* _sender,
                                                               gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda17_ (Block7Data* _data7_,
                  gint response);
static void ___lambda17__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void baobab_window_set_busy (BaobabWindow* self,
                             gboolean busy);
static void __lambda23_ (Block8Data* _data8_,
                  GObject* location_,
                  GAsyncResult* res);
static void baobab_window_scan_location (BaobabWindow* self,
                                  BaobabLocation* location,
                                  gboolean force);
static void baobab_window_toast (BaobabWindow* self,
                          const gchar* title);
static void ___lambda23__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void baobab_window_reroot_treeview (BaobabWindow* self,
                                    BaobabScannerResults* path,
                                    gboolean select_first);
static gboolean baobab_window_show_treeview_popover (BaobabWindow* self,
                                              GtkPopoverMenu* popover,
                                              gint x,
                                              gint y);
static BaobabScannerResults* baobab_window_get_selected_item (BaobabWindow* self);
static gboolean baobab_window_columnview_selection_find (BaobabWindow* self,
                                                  GObject* item,
                                                  gboolean passthrough,
                                                  guint* position);
static void baobab_window_treeview_left_click_gesture_released (BaobabWindow* self,
                                                         gint n_press,
                                                         gdouble x,
                                                         gdouble y);
static guint* baobab_window_get_columnview_position_at_coords (BaobabWindow* self,
                                                        gdouble x,
                                                        gdouble y);
static void _baobab_window_treeview_left_click_gesture_released_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                                     gint n_press,
                                                                                     gdouble x,
                                                                                     gdouble y,
                                                                                     gpointer self);
static void baobab_window_treeview_right_click_gesture_pressed (BaobabWindow* self,
                                                         gint n_press,
                                                         gdouble x,
                                                         gdouble y);
static void _baobab_window_treeview_right_click_gesture_pressed_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                                    gint n_press,
                                                                                    gdouble x,
                                                                                    gdouble y,
                                                                                    gpointer self);
static void baobab_window_columnview_activate (BaobabWindow* self,
                                        guint position);
static void _baobab_window_columnview_activate_gtk_column_view_activate (GtkColumnView* _sender,
                                                                  guint position,
                                                                  gpointer self);
static void baobab_window_set_chart_location (BaobabWindow* self,
                                       BaobabLocation* location);
static void baobab_window_scanner_completed (BaobabWindow* self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void _baobab_window_scanner_completed_baobab_scanner_completed (BaobabScanner* _sender,
                                                                gpointer self);
static gboolean __lambda18_ (Block9Data* _data9_);
static gboolean ___lambda18__gsource_func (gpointer self);
static guint* _uint_dup (guint* self);
static void baobab_window_folder_cell_setup (BaobabWindow* self,
                                      GObject* object);
static void _baobab_window_folder_cell_setup_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                          GObject* object,
                                                                          gpointer self);
static void baobab_window_folder_cell_bind (BaobabWindow* self,
                                     GObject* object);
static void _baobab_window_folder_cell_bind_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                        GObject* object,
                                                                        gpointer self);
static void baobab_window_folder_cell_unbind (BaobabWindow* self,
                                       GObject* object);
static void _baobab_window_folder_cell_unbind_gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                                            GObject* object,
                                                                            gpointer self);
static void baobab_window_folder_cell_teardown (BaobabWindow* self,
                                         GObject* object);
static void _baobab_window_folder_cell_teardown_gtk_signal_list_item_factory_teardown (GtkSignalListItemFactory* _sender,
                                                                                GObject* object,
                                                                                gpointer self);
static void baobab_window_size_cell_setup (BaobabWindow* self,
                                    GObject* object);
static void _baobab_window_size_cell_setup_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                        GObject* object,
                                                                        gpointer self);
static void baobab_window_size_cell_bind (BaobabWindow* self,
                                   GObject* object);
static void _baobab_window_size_cell_bind_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                      GObject* object,
                                                                      gpointer self);
static void baobab_window_size_cell_unbind (BaobabWindow* self,
                                     GObject* object);
static void _baobab_window_size_cell_unbind_gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                                          GObject* object,
                                                                          gpointer self);
static void baobab_window_size_cell_teardown (BaobabWindow* self,
                                       GObject* object);
static void _baobab_window_size_cell_teardown_gtk_signal_list_item_factory_teardown (GtkSignalListItemFactory* _sender,
                                                                              GObject* object,
                                                                              gpointer self);
static void baobab_window_contents_cell_setup (BaobabWindow* self,
                                        GObject* object);
static void _baobab_window_contents_cell_setup_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                            GObject* object,
                                                                            gpointer self);
static void baobab_window_contents_cell_bind (BaobabWindow* self,
                                       GObject* object);
static void _baobab_window_contents_cell_bind_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                          GObject* object,
                                                                          gpointer self);
static void baobab_window_contents_cell_unbind (BaobabWindow* self,
                                         GObject* object);
static void _baobab_window_contents_cell_unbind_gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                                              GObject* object,
                                                                              gpointer self);
static void baobab_window_contents_cell_teardown (BaobabWindow* self,
                                           GObject* object);
static void _baobab_window_contents_cell_teardown_gtk_signal_list_item_factory_teardown (GtkSignalListItemFactory* _sender,
                                                                                  GObject* object,
                                                                                  gpointer self);
static void baobab_window_time_modified_cell_setup (BaobabWindow* self,
                                             GObject* object);
static void _baobab_window_time_modified_cell_setup_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                                 GObject* object,
                                                                                 gpointer self);
static void baobab_window_time_modified_cell_bind (BaobabWindow* self,
                                            GObject* object);
static void _baobab_window_time_modified_cell_bind_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                               GObject* object,
                                                                               gpointer self);
static void baobab_window_time_modified_cell_unbind (BaobabWindow* self,
                                              GObject* object);
static void _baobab_window_time_modified_cell_unbind_gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                                                   GObject* object,
                                                                                   gpointer self);
static void baobab_window_time_modified_cell_teardown (BaobabWindow* self,
                                                GObject* object);
static void _baobab_window_time_modified_cell_teardown_gtk_signal_list_item_factory_teardown (GtkSignalListItemFactory* _sender,
                                                                                       GObject* object,
                                                                                       gpointer self);
static void baobab_window_finalize (GObject * obj);
static GType baobab_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry BAOBAB_WINDOW_action_entries[14] = {{"show-primary-menu", _baobab_window_on_show_primary_menu_activate_gsimple_action_activate_callback, NULL, "false", NULL}, {"scan-folder", _baobab_window_on_scan_folder_activate_gsimple_action_activate_callback}, {"reload", _baobab_window_on_reload_activate_gsimple_action_activate_callback}, {"clear-recent", _baobab_window_on_clear_recent_gsimple_action_activate_callback}, {"show-preferences", _baobab_window_on_show_preferences_gsimple_action_activate_callback}, {"help", _baobab_window_on_help_activate_gsimple_action_activate_callback}, {"about", _baobab_window_on_about_activate_gsimple_action_activate_callback}, {"show-treeview-popover", _baobab_window_on_show_treeview_popover_gsimple_action_activate_callback}, {"treeview-expand-row", _baobab_window_on_treeview_expand_row_gsimple_action_activate_callback}, {"treeview-collapse-row", _baobab_window_on_treeview_collapse_row_gsimple_action_activate_callback}, {"treeview-go-up", _baobab_window_go_up_treeview_gsimple_action_activate_callback}, {"treeview-open-folder", _baobab_window_on_treeview_open_folder_gsimple_action_activate_callback}, {"treeview-copy", _baobab_window_on_treeview_copy_gsimple_action_activate_callback}, {"treeview-trash", _baobab_window_on_treeview_trash_gsimple_action_activate_callback}};
static const BaobabWindowActionState BAOBAB_WINDOW_actions_while_scanning[1] = {{"scan-folder", FALSE}};

static inline gpointer
baobab_window_get_instance_private (BaobabWindow* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabWindow_private_offset);
}

static void
_baobab_window_on_show_primary_menu_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	baobab_window_on_show_primary_menu_activate ((BaobabWindow*) self, action);
}

static void
_baobab_window_on_scan_folder_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	baobab_window_on_scan_folder_activate ((BaobabWindow*) self);
}

static void
_baobab_window_on_reload_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	baobab_window_on_reload_activate ((BaobabWindow*) self);
}

static void
_baobab_window_on_clear_recent_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	baobab_window_on_clear_recent ((BaobabWindow*) self);
}

static void
_baobab_window_on_show_preferences_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	baobab_window_on_show_preferences ((BaobabWindow*) self);
}

static void
_baobab_window_on_help_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	baobab_window_on_help_activate ((BaobabWindow*) self);
}

static void
_baobab_window_on_about_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	baobab_window_on_about_activate ((BaobabWindow*) self);
}

static void
_baobab_window_on_show_treeview_popover_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	baobab_window_on_show_treeview_popover ((BaobabWindow*) self);
}

static void
_baobab_window_on_treeview_expand_row_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	baobab_window_on_treeview_expand_row ((BaobabWindow*) self);
}

static void
_baobab_window_on_treeview_collapse_row_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	baobab_window_on_treeview_collapse_row ((BaobabWindow*) self);
}

static void
_baobab_window_go_up_treeview_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	baobab_window_go_up_treeview ((BaobabWindow*) self);
}

static void
_baobab_window_on_treeview_open_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	baobab_window_on_treeview_open_folder ((BaobabWindow*) self);
}

static void
_baobab_window_on_treeview_copy_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	baobab_window_on_treeview_copy ((BaobabWindow*) self);
}

static void
_baobab_window_on_treeview_trash_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	baobab_window_on_treeview_trash ((BaobabWindow*) self);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		BaobabWindow* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->ui_settings);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
_baobab_window_location_activated_baobab_location_list_location_activated (BaobabLocationList* _sender,
                                                                           BaobabLocation* location,
                                                                           gpointer self)
{
	baobab_window_location_activated ((BaobabWindow*) self, location);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda24_ (BaobabWindow* self)
{
	AdwViewStack* _tmp0_;
	_tmp0_ = self->priv->chart_stack;
	g_settings_unbind ((GObject*) _tmp0_, "visible-child-name");
}

static void
___lambda24__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda24_ ((BaobabWindow*) self);
}

static void
_baobab_window_on_chart_item_activated_baobab_chart_item_activated (BaobabChart* _sender,
                                                                    BaobabScannerResults* item,
                                                                    gpointer self)
{
	baobab_window_on_chart_item_activated ((BaobabWindow*) self, _sender, item);
}

static void
_baobab_window_on_pathbar_item_activated_baobab_pathbar_item_activated (BaobabPathbar* _sender,
                                                                        BaobabScannerResults* path,
                                                                        gpointer self)
{
	baobab_window_on_pathbar_item_activated ((BaobabWindow*) self, _sender, path);
}

static void
_baobab_window_on_folder_display_activated_baobab_folder_display_activated (BaobabFolderDisplay* _sender,
                                                                            gpointer self)
{
	baobab_window_on_folder_display_activated ((BaobabWindow*) self);
}

static gboolean
_baobab_window_on_drop_gtk_drop_target_drop (GtkDropTarget* _sender,
                                             GValue* value,
                                             gdouble x,
                                             gdouble y,
                                             gpointer self)
{
	gboolean result;
	result = baobab_window_on_drop ((BaobabWindow*) self, _sender, value, x, y);
	return result;
}

static gboolean
_baobab_window_on_drop_target_accept_gtk_drop_target_accept (GtkDropTarget* _sender,
                                                             GdkDrop* drop,
                                                             gpointer self)
{
	gboolean result;
	result = baobab_window_on_drop_target_accept ((BaobabWindow*) self, _sender, drop);
	return result;
}

static gboolean
__lambda25_ (Block6Data* _data6_)
{
	BaobabWindow* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GSettings* _tmp5_;
	gboolean result;
	self = _data6_->self;
	g_object_get ((GtkWindow*) self, "maximized", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		gint win_width = 0;
		gint win_height = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		GSettings* _tmp4_;
		gtk_window_get_default_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
		win_width = _tmp2_;
		win_height = _tmp3_;
		_tmp4_ = _data6_->ui_settings;
		g_settings_set (_tmp4_, "window-size", "(ii)", win_width, win_height);
	}
	_tmp5_ = _data6_->ui_settings;
	g_settings_apply (_tmp5_);
	result = FALSE;
	return result;
}

static gboolean
___lambda25__gtk_window_close_request (GtkWindow* _sender,
                                       gpointer self)
{
	gboolean result;
	result = __lambda25_ (self);
	return result;
}

static void
__lambda26_ (BaobabWindow* self)
{
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	g_application_withdraw_notification ((GApplication*) _tmp1_, "scan-completed");
}

static void
___lambda26__gtk_event_controller_focus_enter (GtkEventControllerFocus* _sender,
                                               gpointer self)
{
	__lambda26_ ((BaobabWindow*) self);
}

BaobabWindow*
baobab_window_construct (GType object_type,
                         BaobabApplication* app)
{
	BaobabWindow * self = NULL;
	Block6Data* _data6_;
	GdkCursor* _tmp0_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GAction* action = NULL;
	GSettings* _tmp4_;
	GAction* _tmp5_;
	GAction* _tmp6_;
	BaobabLocationList* _tmp7_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp8_;
	GMenuModel* treeview_menu = NULL;
	GtkBuilder* _tmp9_;
	GObject* _tmp10_;
	GMenuModel* _tmp11_;
	GtkPopoverMenu* _tmp12_;
	GMenuModel* _tmp13_;
	GSettings* _tmp14_;
	AdwViewStack* _tmp15_;
	AdwViewStack* _tmp16_;
	BaobabChart* _tmp17_;
	BaobabChart* _tmp18_;
	BaobabPathbar* _tmp19_;
	BaobabFolderDisplay* _tmp20_;
	GtkDropTarget* _tmp21_;
	GType* _tmp22_;
	GType* _tmp23_;
	gint _tmp23__length1;
	GtkDropTarget* _tmp24_;
	GtkDropTarget* _tmp25_;
	GSettings* _tmp26_;
	gint width = 0;
	gint height = 0;
	GSettings* _tmp27_;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	GSettings* _tmp30_;
	GtkWidget* _tmp31_;
	GtkEventControllerFocus* _tmp32_;
	g_return_val_if_fail (app != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	self = (BaobabWindow*) g_object_new (object_type, "application", app, NULL);
	_data6_->self = g_object_ref (self);
	_tmp0_ = baobab_window_busy_cursor;
	if (_tmp0_ == NULL) {
		GdkCursor* _tmp1_;
		_tmp1_ = gdk_cursor_new_from_name ("wait", NULL);
		_g_object_unref0 (baobab_window_busy_cursor);
		baobab_window_busy_cursor = _tmp1_;
	}
	_tmp2_ = g_settings_new ("org.gnome.baobab.ui");
	_data6_->ui_settings = _tmp2_;
	_tmp3_ = _data6_->ui_settings;
	g_settings_delay (_tmp3_);
	g_action_map_add_action_entries ((GActionMap*) self, BAOBAB_WINDOW_action_entries, (gint) G_N_ELEMENTS (BAOBAB_WINDOW_action_entries), self);
	_tmp4_ = _data6_->ui_settings;
	_tmp5_ = g_settings_create_action (_tmp4_, "active-chart");
	action = _tmp5_;
	_tmp6_ = action;
	g_action_map_add_action ((GActionMap*) self, _tmp6_);
	_tmp7_ = self->priv->location_list;
	g_signal_connect_object (_tmp7_, "location-activated", (GCallback) _baobab_window_location_activated_baobab_location_list_location_activated, self, 0);
	_tmp8_ = gtk_builder_new_from_resource ("/org/gnome/baobab/ui/baobab-treeview-menu.ui");
	builder = _tmp8_;
	_tmp9_ = builder;
	_tmp10_ = gtk_builder_get_object (_tmp9_, "treeview_menu");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_menu_model_get_type (), GMenuModel));
	treeview_menu = _tmp11_;
	baobab_window_hide_columnview_header (self);
	_tmp12_ = self->priv->treeview_popover_menu;
	_tmp13_ = treeview_menu;
	gtk_popover_menu_set_menu_model (_tmp12_, _tmp13_);
	_tmp14_ = _data6_->ui_settings;
	_tmp15_ = self->priv->chart_stack;
	g_settings_bind (_tmp14_, "active-chart", (GObject*) _tmp15_, "visible-child-name", G_SETTINGS_BIND_DEFAULT);
	_tmp16_ = self->priv->chart_stack;
	g_signal_connect_object ((GtkWidget*) _tmp16_, "destroy", (GCallback) ___lambda24__gtk_widget_destroy, self, 0);
	_tmp17_ = self->priv->rings_chart;
	g_signal_connect_object (_tmp17_, "item-activated", (GCallback) _baobab_window_on_chart_item_activated_baobab_chart_item_activated, self, 0);
	_tmp18_ = self->priv->treemap_chart;
	g_signal_connect_object (_tmp18_, "item-activated", (GCallback) _baobab_window_on_chart_item_activated_baobab_chart_item_activated, self, 0);
	_tmp19_ = self->priv->pathbar;
	g_signal_connect_object (_tmp19_, "item-activated", (GCallback) _baobab_window_on_pathbar_item_activated_baobab_pathbar_item_activated, self, 0);
	_tmp20_ = self->priv->folder_display;
	g_signal_connect_object (_tmp20_, "activated", (GCallback) _baobab_window_on_folder_display_activated_baobab_folder_display_activated, self, 0);
	_tmp21_ = self->priv->drop_target;
	_tmp22_ = g_new0 (GType, 1);
	_tmp22_[0] = gdk_file_list_get_type ();
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 1;
	gtk_drop_target_set_gtypes (_tmp21_, _tmp23_, (gsize) 1);
	_tmp23_ = (g_free (_tmp23_), NULL);
	_tmp24_ = self->priv->drop_target;
	g_signal_connect_object (_tmp24_, "drop", (GCallback) _baobab_window_on_drop_gtk_drop_target_drop, self, 0);
	_tmp25_ = self->priv->drop_target;
	g_signal_connect_object (_tmp25_, "accept", (GCallback) _baobab_window_on_drop_target_accept_gtk_drop_target_accept, self, 0);
	_tmp26_ = _data6_->ui_settings;
	if (g_settings_get_boolean (_tmp26_, "is-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp27_ = _data6_->ui_settings;
	g_settings_get (_tmp27_, "window-size", "(ii)", &_tmp28_, &_tmp29_);
	width = _tmp28_;
	height = _tmp29_;
	gtk_window_set_default_size ((GtkWindow*) self, width, height);
	_tmp30_ = _data6_->ui_settings;
	g_settings_bind (_tmp30_, "is-maximized", (GObject*) self, "maximized", G_SETTINGS_BIND_SET);
	g_signal_connect_data ((GtkWindow*) self, "close-request", (GCallback) ___lambda25__gtk_window_close_request, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp31_ = self->priv->home_page;
	baobab_window_set_ui_state (self, _tmp31_, FALSE);
	_tmp32_ = self->priv->focus_controller;
	g_signal_connect_object (_tmp32_, "enter", (GCallback) ___lambda26__gtk_event_controller_focus_enter, self, 0);
	gtk_window_present ((GtkWindow*) self);
	_g_object_unref0 (treeview_menu);
	_g_object_unref0 (builder);
	_g_object_unref0 (action);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return self;
}

BaobabWindow*
baobab_window_new (BaobabApplication* app)
{
	return baobab_window_construct (BAOBAB_TYPE_WINDOW, app);
}

static void
baobab_window_on_show_primary_menu_activate (BaobabWindow* self,
                                             GSimpleAction* action)
{
	gboolean state = FALSE;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	gboolean _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_action_get_state ((GAction*) action);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_get_boolean (_tmp1_);
	_g_variant_unref0 (_tmp1_);
	state = _tmp2_;
	_tmp3_ = g_variant_new_boolean (!state);
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	g_simple_action_set_state (action, _tmp4_);
	_g_variant_unref0 (_tmp4_);
}

static void
baobab_window_results_hidden (BaobabWindow* self)
{
	AdwBanner* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	baobab_window_cancel_scan (self);
	_tmp0_ = self->priv->banner;
	adw_banner_set_revealed (_tmp0_, FALSE);
	_tmp1_ = self->priv->home_page;
	baobab_window_set_ui_state (self, _tmp1_, FALSE);
}

static void
_baobab_window_results_hidden_adw_navigation_page_hidden (AdwNavigationPage* _sender,
                                                          gpointer self)
{
	baobab_window_results_hidden ((BaobabWindow*) self);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		BaobabWindow* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->file_chooser);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
__lambda17_ (Block7Data* _data7_,
             gint response)
{
	BaobabWindow* self;
	self = _data7_->self;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		gboolean recurse = FALSE;
		const gchar* _tmp0_;
		BaobabScanFlags _tmp1_ = 0U;
		BaobabScanFlags flags = 0U;
		GFile* _tmp2_;
		GFile* _tmp3_;
		_tmp0_ = gtk_file_chooser_get_choice ((GtkFileChooser*) _data7_->file_chooser, "recurse");
		recurse = bool_parse (_tmp0_);
		if (recurse) {
			_tmp1_ = BAOBAB_SCAN_FLAGS_NONE;
		} else {
			_tmp1_ = BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS;
		}
		flags = _tmp1_;
		_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _data7_->file_chooser);
		_tmp3_ = _tmp2_;
		baobab_window_scan_directory (self, _tmp3_, flags);
		_g_object_unref0 (_tmp3_);
	}
	gtk_native_dialog_destroy ((GtkNativeDialog*) _data7_->file_chooser);
}

static void
___lambda17__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	__lambda17_ (self, response_id);
}

static void
baobab_window_on_scan_folder_activate (BaobabWindow* self)
{
	Block7Data* _data7_;
	GtkFileChooserNative* _tmp0_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = gtk_file_chooser_native_new (_ ("Select Folder"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, NULL, NULL);
	_data7_->file_chooser = _tmp0_;
	gtk_native_dialog_set_modal ((GtkNativeDialog*) _data7_->file_chooser, TRUE);
	gtk_file_chooser_add_choice ((GtkFileChooser*) _data7_->file_chooser, "recurse", _ ("Recursively analyze mount points"), NULL, NULL);
	g_signal_connect_data ((GtkNativeDialog*) _data7_->file_chooser, "response", (GCallback) ___lambda17__gtk_native_dialog_response, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	gtk_native_dialog_show ((GtkNativeDialog*) _data7_->file_chooser);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static gpointer
_baobab_location_ref0 (gpointer self)
{
	return self ? baobab_location_ref (self) : NULL;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		BaobabWindow* self;
		self = _data8_->self;
		_baobab_location_unref0 (_data8_->location);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda23_ (Block8Data* _data8_,
             GObject* location_,
             GAsyncResult* res)
{
	BaobabWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data8_->self;
	g_return_if_fail (res != NULL);
	{
		baobab_location_mount_volume_finish (_data8_->location, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		baobab_window_scan_location (self, _data8_->location, FALSE);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		baobab_window_set_busy (self, FALSE);
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("baobab-window.vala:210: Could not analyze volume: %s\n", _tmp1_);
		baobab_window_toast (self, _ ("Could not analyze volume"));
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda23__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda23_ (self, source_object, res);
	block8_data_unref (self);
}

static void
baobab_window_location_activated (BaobabWindow* self,
                                  BaobabLocation* location)
{
	Block8Data* _data8_;
	BaobabLocation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = _baobab_location_ref0 (location);
	_baobab_location_unref0 (_data8_->location);
	_data8_->location = _tmp0_;
	baobab_window_set_busy (self, TRUE);
	baobab_location_mount_volume (_data8_->location, ___lambda23__gasync_ready_callback, block8_data_ref (_data8_));
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
baobab_window_on_reload_activate (BaobabWindow* self)
{
	BaobabLocation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_location;
	baobab_window_scan_location (self, _tmp0_, TRUE);
}

static void
baobab_window_cancel_scan (BaobabWindow* self)
{
	gboolean _tmp0_ = FALSE;
	BaobabLocation* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->active_location;
	if (_tmp1_ != NULL) {
		BaobabLocation* _tmp2_;
		BaobabScanner* _tmp3_;
		BaobabScanner* _tmp4_;
		_tmp2_ = self->priv->active_location;
		_tmp3_ = baobab_location_get_scanner (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BaobabLocation* _tmp5_;
		BaobabScanner* _tmp6_;
		BaobabScanner* _tmp7_;
		_tmp5_ = self->priv->active_location;
		_tmp6_ = baobab_location_get_scanner (_tmp5_);
		_tmp7_ = _tmp6_;
		baobab_scanner_cancel (_tmp7_);
	}
	if (self->priv->scan_completed_handler > ((gulong) 0)) {
		BaobabLocation* _tmp8_;
		BaobabScanner* _tmp9_;
		BaobabScanner* _tmp10_;
		_tmp8_ = self->priv->active_location;
		_tmp9_ = baobab_location_get_scanner (_tmp8_);
		_tmp10_ = _tmp9_;
		g_signal_handler_disconnect ((GObject*) _tmp10_, self->priv->scan_completed_handler);
		self->priv->scan_completed_handler = (gulong) 0;
	}
	_baobab_location_unref0 (self->priv->active_location);
	self->priv->active_location = NULL;
}

static void
baobab_window_on_clear_recent (BaobabWindow* self)
{
	BaobabLocationList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->location_list;
	baobab_location_list_clear_recent (_tmp0_, TRUE);
}

static void
baobab_window_on_show_preferences (BaobabWindow* self)
{
	BaobabPreferencesDialog* dialog = NULL;
	BaobabPreferencesDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_preferences_dialog_new ();
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	adw_dialog_present ((AdwDialog*) dialog, (GtkWidget*) self);
	_g_object_unref0 (dialog);
}

static void
baobab_window_on_help_activate (BaobabWindow* self)
{
	g_return_if_fail (self != NULL);
	gtk_show_uri ((GtkWindow*) self, "help:baobab", (guint32) GDK_CURRENT_TIME);
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
baobab_window_on_about_activate (BaobabWindow* self)
{
	static const gchar* developers[7] = {"Ryan Lortie <desrt@desrt.ca>", "Fabio Marzocca <thesaltydog@gmail.com>", "Paolo Borelli <pborelli@gnome.com>", "Stefano Facchini <stefano.facchini@gmail.com>", "Benoît Dejean <benoit@placenet.org>", "Igalia (rings-chart and treemap widget) <www.igalia.com>", NULL};
	static const char copyright[] = "Copyright \xc2\xa9 2005-2011 Fabio Marzocca, Paolo Borelli, Benoît Dej" \
"ean, Igalia\n" "Copyright \xc2\xa9 2011-2012 Ryan Lortie, Paolo Borelli, Stefano Facch" \
"ini\n";
	AdwAboutDialog* about = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	AdwAboutDialog* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("Disk Usage Analyzer"));
	_tmp1_ = g_strdup ("org.gnome.baobab");
	_tmp2_ = g_strdup (_ ("The GNOME Project"));
	_tmp3_ = g_strdup (VERSION);
	_tmp4_ = g_strdup ("https://apps.gnome.org/Baobab/");
	_tmp5_ = g_strdup ("https://gitlab.gnome.org/GNOME/baobab/-/issues/new");
	_tmp6_ = g_strdup (copyright);
	_tmp7_ = _vala_array_dup2 (developers, G_N_ELEMENTS (developers));
	_tmp7__length1 = G_N_ELEMENTS (developers);
	_tmp8_ = g_strdup (_ ("translator-credits"));
	_tmp9_ = (AdwAboutDialog*) adw_about_dialog_new ();
	adw_about_dialog_set_application_name (_tmp9_, _tmp0_);
	_g_free0 (_tmp0_);
	adw_about_dialog_set_application_icon (_tmp9_, _tmp1_);
	_g_free0 (_tmp1_);
	adw_about_dialog_set_developer_name (_tmp9_, _tmp2_);
	_g_free0 (_tmp2_);
	adw_about_dialog_set_version (_tmp9_, _tmp3_);
	_g_free0 (_tmp3_);
	adw_about_dialog_set_website (_tmp9_, _tmp4_);
	_g_free0 (_tmp4_);
	adw_about_dialog_set_issue_url (_tmp9_, _tmp5_);
	_g_free0 (_tmp5_);
	adw_about_dialog_set_copyright (_tmp9_, _tmp6_);
	_g_free0 (_tmp6_);
	adw_about_dialog_set_license_type (_tmp9_, GTK_LICENSE_GPL_2_0);
	adw_about_dialog_set_developers (_tmp9_, _tmp7_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	adw_about_dialog_set_translator_credits (_tmp9_, _tmp8_);
	_g_free0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	about = _tmp9_;
	adw_dialog_present ((AdwDialog*) about, (GtkWidget*) self);
	_g_object_unref0 (about);
}

static void
baobab_window_on_chart_item_activated (BaobabWindow* self,
                                       BaobabChart* chart,
                                       BaobabScannerResults* item)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (chart != NULL);
	g_return_if_fail (item != NULL);
	baobab_window_reroot_treeview (self, item, FALSE);
}

static void
baobab_window_on_pathbar_item_activated (BaobabWindow* self,
                                         BaobabPathbar* pathbar,
                                         BaobabScannerResults* path)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (pathbar != NULL);
	g_return_if_fail (path != NULL);
	baobab_window_reroot_treeview (self, path, FALSE);
}

static void
baobab_window_on_folder_display_activated (BaobabWindow* self)
{
	g_return_if_fail (self != NULL);
	baobab_window_go_up_treeview (self);
}

static void
baobab_window_go_up_treeview (BaobabWindow* self)
{
	BaobabScannerResults* path = NULL;
	BaobabFolderDisplay* _tmp0_;
	BaobabScannerResults* _tmp1_;
	BaobabScannerResults* _tmp2_;
	BaobabScannerResults* _tmp3_;
	gboolean _tmp4_ = FALSE;
	BaobabScannerResults* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->folder_display;
	_tmp1_ = baobab_folder_display_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	path = _tmp3_;
	_tmp5_ = path;
	if (_tmp5_ != NULL) {
		BaobabScannerResults* _tmp6_;
		_tmp6_ = path;
		_tmp4_ = baobab_scanner_results_get_depth (_tmp6_) > 1;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		BaobabScannerResults* _tmp7_;
		BaobabScannerResults* _tmp8_;
		BaobabScannerResults* _tmp9_;
		_tmp7_ = path;
		_tmp8_ = baobab_scanner_results_get_parent (_tmp7_);
		_tmp9_ = _tmp8_;
		baobab_window_reroot_treeview (self, _tmp9_, FALSE);
	}
	_g_object_unref0 (path);
}

static gboolean
baobab_window_on_drop_target_accept (BaobabWindow* self,
                                     GtkDropTarget* target,
                                     GdkDrop* drop)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (target != NULL, FALSE);
	g_return_val_if_fail (drop != NULL, FALSE);
	result = !self->priv->is_busy;
	return result;
}

static gboolean
baobab_window_on_drop (BaobabWindow* self,
                       GtkDropTarget* target,
                       GValue* value,
                       gdouble x,
                       gdouble y)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (target != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	if (G_VALUE_TYPE (value) == gdk_file_list_get_type ()) {
		GSList* files = NULL;
		void* _tmp0_;
		GFile* dir = NULL;
		gboolean _tmp1_ = FALSE;
		GSList* _tmp2_;
		GFile* _tmp8_;
		_tmp0_ = g_value_get_boxed (value);
		files = (GSList*) _tmp0_;
		dir = NULL;
		_tmp2_ = files;
		if (_tmp2_ != NULL) {
			GSList* _tmp3_;
			_tmp3_ = files;
			_tmp1_ = g_slist_length (_tmp3_) == ((guint) 1);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			GSList* _tmp4_;
			GSList* _tmp5_;
			gconstpointer _tmp6_;
			GFile* _tmp7_;
			_tmp4_ = files;
			_tmp5_ = g_slist_nth (_tmp4_, (guint) 0);
			_tmp6_ = _tmp5_->data;
			_tmp7_ = _g_object_ref0 ((GFile*) _tmp6_);
			_g_object_unref0 (dir);
			dir = _tmp7_;
		}
		_tmp8_ = dir;
		if (_tmp8_ != NULL) {
			GFile* _tmp9_;
			_tmp9_ = dir;
			baobab_window_scan_directory (self, _tmp9_, BAOBAB_SCAN_FLAGS_NONE);
		}
		result = TRUE;
		_g_object_unref0 (dir);
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
baobab_window_show_treeview_popover (BaobabWindow* self,
                                     GtkPopoverMenu* popover,
                                     gint x,
                                     gint y)
{
	BaobabScannerResults* _tmp0_;
	BaobabScannerResults* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (popover != NULL, FALSE);
	_tmp0_ = baobab_window_get_selected_item (self);
	_g_object_unref0 (self->priv->popover_item);
	self->priv->popover_item = _tmp0_;
	_tmp1_ = self->priv->popover_item;
	if (_tmp1_ != NULL) {
		GdkRectangle rect = {0};
		GdkRectangle _tmp2_ = {0};
		GdkRectangle _tmp3_;
		_tmp2_.x = x;
		_tmp2_.y = y;
		_tmp2_.width = 0;
		_tmp2_.height = 0;
		rect = _tmp2_;
		_tmp3_ = rect;
		gtk_popover_set_pointing_to ((GtkPopover*) popover, &_tmp3_);
		gtk_popover_popup ((GtkPopover*) popover);
		result = GDK_EVENT_STOP;
		return result;
	} else {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
}

void
baobab_window_open_item (BaobabWindow* self,
                         BaobabScannerResults* results)
{
	GFile* file = NULL;
	BaobabLocation* _tmp0_;
	BaobabScanner* _tmp1_;
	BaobabScanner* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = baobab_scanner_get_file (_tmp2_, results);
	file = _tmp3_;
	{
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_file_get_uri (file);
		_tmp5_ = _tmp4_;
		g_app_info_launch_default_for_uri (_tmp5_, NULL, &_inner_error0_);
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("baobab-window.vala:334: Failed to open file: %s\n", _tmp7_);
		baobab_window_toast (self, _ ("Failed to open file"));
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

void
baobab_window_copy_path (BaobabWindow* self,
                         BaobabScannerResults* results)
{
	gchar* parse_name = NULL;
	BaobabLocation* _tmp0_;
	BaobabScanner* _tmp1_;
	BaobabScanner* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GdkClipboard* clipboard = NULL;
	GdkClipboard* _tmp7_;
	GdkClipboard* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = baobab_scanner_get_file (_tmp2_, results);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_parse_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	parse_name = _tmp6_;
	_tmp7_ = gtk_widget_get_clipboard ((GtkWidget*) self);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	clipboard = _tmp8_;
	gdk_clipboard_set_text (clipboard, parse_name);
	_g_object_unref0 (clipboard);
	_g_free0 (parse_name);
}

void
baobab_window_trash_file (BaobabWindow* self,
                          BaobabScannerResults* results)
{
	GFile* file = NULL;
	BaobabLocation* _tmp0_;
	BaobabScanner* _tmp1_;
	BaobabScanner* _tmp2_;
	GFile* _tmp3_;
	BaobabScannerResults* parent = NULL;
	BaobabScannerResults* _tmp7_;
	BaobabScannerResults* _tmp8_;
	BaobabScannerResults* _tmp9_;
	guint position = 0U;
	BaobabScannerResults* _tmp10_;
	BaobabScannerResults* _tmp11_;
	GListStore* _tmp12_;
	GListStore* _tmp13_;
	guint _tmp14_ = 0U;
	gboolean _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = baobab_scanner_get_file (_tmp2_, results);
	file = _tmp3_;
	{
		g_file_trash (file, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		if (!g_error_matches (_tmp4_, g_io_error_quark (), G_IO_ERROR_NOT_FOUND)) {
			GError* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_warning ("baobab-window.vala:351: Failed to move to file to the trash: %s", _tmp6_);
			baobab_window_toast (self, _ ("Failed to trash file"));
			_g_error_free0 (e);
			_g_object_unref0 (file);
			return;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = baobab_scanner_results_get_parent (results);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	parent = _tmp9_;
	position = (guint) 0;
	_tmp10_ = baobab_scanner_results_get_parent (results);
	_tmp11_ = _tmp10_;
	_tmp12_ = baobab_scanner_results_get_children_list_store (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp15_ = g_list_store_find (_tmp13_, (GObject*) results, &_tmp14_);
	position = _tmp14_;
	if (_tmp15_) {
		BaobabScannerResults* _tmp16_;
		BaobabScannerResults* _tmp17_;
		GListStore* _tmp18_;
		GListStore* _tmp19_;
		_tmp16_ = baobab_scanner_results_get_parent (results);
		_tmp17_ = _tmp16_;
		_tmp18_ = baobab_scanner_results_get_children_list_store (_tmp17_);
		_tmp19_ = _tmp18_;
		g_list_store_remove (_tmp19_, position);
	}
	_g_object_unref0 (parent);
	_g_object_unref0 (file);
}

static gboolean
baobab_window_columnview_selection_find (BaobabWindow* self,
                                         GObject* item,
                                         gboolean passthrough,
                                         guint* position)
{
	guint _vala_position = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (item == NULL) {
		result = FALSE;
		if (position) {
			*position = _vala_position;
		}
		return result;
	}
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				GtkSingleSelection* _tmp3_;
				guint _tmp4_;
				guint _tmp5_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = self->priv->columnview_selection;
				g_object_get (_tmp3_, "n-items", &_tmp4_, NULL);
				_tmp5_ = _tmp4_;
				if (i < _tmp5_) {
					_tmp2_ = i < G_MAXUINT;
				} else {
					_tmp2_ = FALSE;
				}
				if (!_tmp2_) {
					break;
				}
				if (passthrough) {
					GtkTreeListRow* row = NULL;
					GtkSingleSelection* _tmp6_;
					GObject* _tmp7_;
					GtkTreeListRow* _tmp8_;
					GtkTreeListRow* _tmp9_;
					GObject* _tmp10_;
					GObject* _tmp11_;
					GObject* _tmp12_;
					gboolean _tmp13_;
					_tmp6_ = self->priv->columnview_selection;
					_tmp7_ = g_list_model_get_item ((GListModel*) _tmp6_, i);
					_tmp8_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_tree_list_row_get_type ()) ? ((GtkTreeListRow*) _tmp7_) : NULL;
					if (_tmp8_ == NULL) {
						_g_object_unref0 (_tmp7_);
					}
					row = _tmp8_;
					_tmp9_ = row;
					_tmp10_ = gtk_tree_list_row_get_item (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = _tmp11_;
					_tmp13_ = _tmp12_ == item;
					_g_object_unref0 (_tmp12_);
					if (_tmp13_) {
						_vala_position = i;
						result = TRUE;
						_g_object_unref0 (row);
						if (position) {
							*position = _vala_position;
						}
						return result;
					}
					_g_object_unref0 (row);
				} else {
					GtkSingleSelection* _tmp14_;
					GObject* _tmp15_;
					GObject* _tmp16_;
					gboolean _tmp17_;
					_tmp14_ = self->priv->columnview_selection;
					_tmp15_ = g_list_model_get_item ((GListModel*) _tmp14_, i);
					_tmp16_ = _tmp15_;
					_tmp17_ = _tmp16_ == item;
					_g_object_unref0 (_tmp16_);
					if (_tmp17_) {
						_vala_position = i;
						result = TRUE;
						if (position) {
							*position = _vala_position;
						}
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	if (position) {
		*position = _vala_position;
	}
	return result;
}

static BaobabScannerResults*
baobab_window_get_selected_item (BaobabWindow* self)
{
	GtkSingleSelection* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GtkTreeListRow* row = NULL;
	GtkSingleSelection* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	GtkTreeListRow* _tmp6_;
	GtkTreeListRow* _tmp7_;
	GObject* _tmp8_;
	GObject* _tmp9_;
	BaobabScannerResults* _tmp10_;
	BaobabScannerResults* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->columnview_selection;
	_tmp1_ = gtk_single_selection_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_tree_list_row_get_type ())) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->columnview_selection;
	_tmp4_ = gtk_single_selection_get_selected_item (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_tree_list_row_get_type ()) ? ((GtkTreeListRow*) _tmp5_) : NULL);
	row = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = gtk_tree_list_row_get_item (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = BAOBAB_SCANNER_IS_RESULTS (_tmp9_) ? ((BaobabScannerResults*) _tmp9_) : NULL;
	if (_tmp10_ == NULL) {
		_g_object_unref0 (_tmp9_);
	}
	result = _tmp10_;
	_g_object_unref0 (row);
	return result;
}

static void
baobab_window_on_show_treeview_popover (BaobabWindow* self)
{
	GtkPopoverMenu* _tmp0_;
	GtkColumnView* _tmp1_;
	GtkColumnView* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->treeview_popover_menu;
	_tmp1_ = self->priv->columnview;
	_tmp2_ = self->priv->columnview;
	baobab_window_show_treeview_popover (self, _tmp0_, gtk_widget_get_allocated_width ((GtkWidget*) _tmp1_) / 2, gtk_widget_get_allocated_height ((GtkWidget*) _tmp2_) / 2);
}

static void
baobab_window_on_treeview_expand_row (BaobabWindow* self)
{
	GObject* selected_item = NULL;
	GtkSingleSelection* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GObject* _tmp3_;
	GObject* _tmp4_;
	GtkTreeListRow* selected_row = NULL;
	GObject* _tmp5_;
	GtkTreeListRow* _tmp6_;
	GtkTreeListRow* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->columnview_selection;
	_tmp1_ = gtk_single_selection_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	selected_item = _tmp3_;
	_tmp4_ = selected_item;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_tree_list_row_get_type ())) {
		_g_object_unref0 (selected_item);
		return;
	}
	_tmp5_ = selected_item;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_tree_list_row_get_type ()) ? ((GtkTreeListRow*) _tmp5_) : NULL);
	selected_row = _tmp6_;
	_tmp7_ = selected_row;
	gtk_tree_list_row_set_expanded (_tmp7_, TRUE);
	_g_object_unref0 (selected_row);
	_g_object_unref0 (selected_item);
}

static void
baobab_window_on_treeview_collapse_row (BaobabWindow* self)
{
	GObject* selected_item = NULL;
	GtkSingleSelection* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GObject* _tmp3_;
	GObject* _tmp4_;
	GtkTreeListRow* selected_row = NULL;
	GObject* _tmp5_;
	GtkTreeListRow* _tmp6_;
	GtkTreeListRow* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->columnview_selection;
	_tmp1_ = gtk_single_selection_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	selected_item = _tmp3_;
	_tmp4_ = selected_item;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_tree_list_row_get_type ())) {
		_g_object_unref0 (selected_item);
		return;
	}
	_tmp5_ = selected_item;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_tree_list_row_get_type ()) ? ((GtkTreeListRow*) _tmp5_) : NULL);
	selected_row = _tmp6_;
	_tmp7_ = selected_row;
	_tmp8_ = gtk_tree_list_row_get_expanded (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		GtkTreeListRow* _tmp10_;
		_tmp10_ = selected_row;
		gtk_tree_list_row_set_expanded (_tmp10_, FALSE);
	} else {
		GtkTreeListRow* _tmp11_;
		guint _tmp12_;
		guint _tmp13_;
		_tmp11_ = selected_row;
		_tmp12_ = gtk_tree_list_row_get_depth (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ > ((guint) 0)) {
			guint position = 0U;
			GtkTreeListRow* _tmp14_;
			GtkTreeListRow* _tmp15_;
			GtkTreeListRow* _tmp16_;
			guint _tmp17_ = 0U;
			gboolean _tmp18_;
			gboolean _tmp19_;
			position = (guint) 0;
			_tmp14_ = selected_row;
			_tmp15_ = gtk_tree_list_row_get_parent (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp18_ = baobab_window_columnview_selection_find (self, (GObject*) _tmp16_, FALSE, &_tmp17_);
			position = _tmp17_;
			_tmp19_ = _tmp18_;
			_g_object_unref0 (_tmp16_);
			if (_tmp19_) {
				GtkColumnView* _tmp20_;
				_tmp20_ = self->priv->columnview;
				gtk_column_view_scroll_to (_tmp20_, position, NULL, GTK_LIST_SCROLL_FOCUS | GTK_LIST_SCROLL_SELECT, NULL);
			}
		}
	}
	_g_object_unref0 (selected_row);
	_g_object_unref0 (selected_item);
}

static void
baobab_window_on_treeview_open_folder (BaobabWindow* self)
{
	BaobabScannerResults* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover_item;
	if (_tmp0_ != NULL) {
		BaobabScannerResults* _tmp1_;
		_tmp1_ = self->priv->popover_item;
		baobab_window_open_item (self, _tmp1_);
	}
}

static void
baobab_window_on_treeview_copy (BaobabWindow* self)
{
	BaobabScannerResults* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover_item;
	if (_tmp0_ != NULL) {
		BaobabScannerResults* _tmp1_;
		_tmp1_ = self->priv->popover_item;
		baobab_window_copy_path (self, _tmp1_);
	}
}

static void
baobab_window_on_treeview_trash (BaobabWindow* self)
{
	BaobabScannerResults* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover_item;
	if (_tmp0_ != NULL) {
		BaobabScannerResults* _tmp1_;
		_tmp1_ = self->priv->popover_item;
		baobab_window_trash_file (self, _tmp1_);
	}
}

static void
baobab_window_hide_columnview_header (BaobabWindow* self)
{
	GType row_type = 0UL;
	g_return_if_fail (self != NULL);
	row_type = g_type_from_name ("GtkColumnViewRowWidget");
	{
		GtkWidget* child = NULL;
		GtkColumnView* _tmp0_;
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp0_ = self->priv->columnview;
		_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		child = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GtkWidget* _tmp7_;
				GtkWidget* _tmp8_;
				GtkWidget* _tmp9_;
				if (!_tmp3_) {
					GtkWidget* _tmp4_;
					GtkWidget* _tmp5_;
					GtkWidget* _tmp6_;
					_tmp4_ = child;
					_tmp5_ = gtk_widget_get_next_sibling (_tmp4_);
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_g_object_unref0 (child);
					child = _tmp6_;
				}
				_tmp3_ = FALSE;
				_tmp7_ = child;
				if (!(_tmp7_ != NULL)) {
					break;
				}
				_tmp8_ = child;
				if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp8_) != row_type) {
					continue;
				}
				_tmp9_ = child;
				gtk_widget_set_visible (_tmp9_, FALSE);
			}
		}
		_g_object_unref0 (child);
	}
}

static void
baobab_window_treeview_left_click_gesture_released (BaobabWindow* self,
                                                    gint n_press,
                                                    gdouble x,
                                                    gdouble y)
{
	guint* position = NULL;
	guint* _tmp0_;
	guint* _tmp1_;
	GtkTreeListRow* row = NULL;
	GtkColumnView* _tmp2_;
	GtkSelectionModel* _tmp3_;
	GtkSelectionModel* _tmp4_;
	guint* _tmp5_;
	GObject* _tmp6_;
	GtkTreeListRow* _tmp7_;
	BaobabScannerResults* path = NULL;
	GtkTreeListRow* _tmp8_;
	GObject* _tmp9_;
	GObject* _tmp10_;
	BaobabScannerResults* _tmp11_;
	BaobabScannerResults* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_window_get_columnview_position_at_coords (self, x, y);
	position = _tmp0_;
	_tmp1_ = position;
	if (_tmp1_ == NULL) {
		_g_free0 (position);
		return;
	}
	_tmp2_ = self->priv->columnview;
	_tmp3_ = gtk_column_view_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = position;
	_tmp6_ = g_list_model_get_object ((GListModel*) _tmp4_, *_tmp5_);
	_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_tree_list_row_get_type ()) ? ((GtkTreeListRow*) _tmp6_) : NULL;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (_tmp6_);
	}
	row = _tmp7_;
	_tmp8_ = row;
	_tmp9_ = gtk_tree_list_row_get_item (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = BAOBAB_SCANNER_IS_RESULTS (_tmp10_) ? ((BaobabScannerResults*) _tmp10_) : NULL;
	if (_tmp11_ == NULL) {
		_g_object_unref0 (_tmp10_);
	}
	path = _tmp11_;
	_tmp12_ = path;
	baobab_window_reroot_treeview (self, _tmp12_, TRUE);
	_g_object_unref0 (path);
	_g_object_unref0 (row);
	_g_free0 (position);
}

static void
_baobab_window_treeview_left_click_gesture_released_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                                gint n_press,
                                                                                gdouble x,
                                                                                gdouble y,
                                                                                gpointer self)
{
	baobab_window_treeview_left_click_gesture_released ((BaobabWindow*) self, n_press, x, y);
}

static void
baobab_window_treeview_right_click_gesture_pressed (BaobabWindow* self,
                                                    gint n_press,
                                                    gdouble x,
                                                    gdouble y)
{
	guint* position = NULL;
	guint* _tmp0_;
	guint* _tmp1_;
	GtkColumnView* _tmp2_;
	guint* _tmp3_;
	GtkPopoverMenu* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_window_get_columnview_position_at_coords (self, x, y);
	position = _tmp0_;
	_tmp1_ = position;
	if (_tmp1_ == NULL) {
		_g_free0 (position);
		return;
	}
	_tmp2_ = self->priv->columnview;
	_tmp3_ = position;
	gtk_column_view_scroll_to (_tmp2_, *_tmp3_, NULL, GTK_LIST_SCROLL_FOCUS | GTK_LIST_SCROLL_SELECT, NULL);
	_tmp4_ = self->priv->treeview_popover_menu;
	baobab_window_show_treeview_popover (self, _tmp4_, (gint) x, (gint) y);
	_g_free0 (position);
}

static void
_baobab_window_treeview_right_click_gesture_pressed_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                               gint n_press,
                                                                               gdouble x,
                                                                               gdouble y,
                                                                               gpointer self)
{
	baobab_window_treeview_right_click_gesture_pressed ((BaobabWindow*) self, n_press, x, y);
}

static void
baobab_window_columnview_activate (BaobabWindow* self,
                                   guint position)
{
	GtkTreeListRow* row = NULL;
	GtkColumnView* _tmp0_;
	GtkSelectionModel* _tmp1_;
	GtkSelectionModel* _tmp2_;
	GObject* _tmp3_;
	GtkTreeListRow* _tmp4_;
	BaobabScannerResults* path = NULL;
	GObject* _tmp5_;
	GObject* _tmp6_;
	BaobabScannerResults* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->columnview;
	_tmp1_ = gtk_column_view_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_model_get_object ((GListModel*) _tmp2_, position);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_tree_list_row_get_type ()) ? ((GtkTreeListRow*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	row = _tmp4_;
	_tmp5_ = gtk_tree_list_row_get_item (row);
	_tmp6_ = _tmp5_;
	_tmp7_ = BAOBAB_SCANNER_IS_RESULTS (_tmp6_) ? ((BaobabScannerResults*) _tmp6_) : NULL;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (_tmp6_);
	}
	path = _tmp7_;
	baobab_window_reroot_treeview (self, path, TRUE);
	_g_object_unref0 (path);
	_g_object_unref0 (row);
}

static void
_baobab_window_columnview_activate_gtk_column_view_activate (GtkColumnView* _sender,
                                                             guint position,
                                                             gpointer self)
{
	baobab_window_columnview_activate ((BaobabWindow*) self, position);
}

static void
baobab_window_reroot_treeview (BaobabWindow* self,
                               BaobabScannerResults* path,
                               gboolean select_first)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	BaobabFolderDisplay* _tmp2_;
	BaobabChart* _tmp3_;
	BaobabChart* _tmp4_;
	BaobabPathbar* _tmp5_;
	GtkSortListModel* _tmp6_;
	GtkTreeListModel* _tmp7_;
	GtkTreeListModel* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = baobab_scanner_results_get_is_empty (path);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->folder_display;
	baobab_folder_display_set_path (_tmp2_, path);
	_tmp3_ = self->priv->rings_chart;
	baobab_chart_set_tree_root (_tmp3_, path);
	_tmp4_ = self->priv->treemap_chart;
	baobab_chart_set_tree_root (_tmp4_, path);
	_tmp5_ = self->priv->pathbar;
	baobab_pathbar_set_path (_tmp5_, path);
	_tmp6_ = self->priv->columnview_sort_model;
	_tmp7_ = baobab_scanner_results_create_tree_model (path);
	_tmp8_ = _tmp7_;
	gtk_sort_list_model_set_model (_tmp6_, (GListModel*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	if (select_first) {
		GtkSingleSelection* _tmp9_;
		_tmp9_ = self->priv->columnview_selection;
		gtk_single_selection_set_selected (_tmp9_, (guint) 0);
	}
}

static void
baobab_window_toast (BaobabWindow* self,
                     const gchar* title)
{
	AdwToast* toast = NULL;
	AdwToast* _tmp0_;
	AdwToastOverlay* _tmp1_;
	AdwToast* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = adw_toast_new (title);
	toast = _tmp0_;
	_tmp1_ = self->priv->toast_overlay;
	_tmp2_ = _g_object_ref0 (toast);
	adw_toast_overlay_add_toast (_tmp1_, _tmp2_);
	_g_object_unref0 (toast);
}

static void
baobab_window_set_busy (BaobabWindow* self,
                        gboolean busy)
{
	GdkCursor* new_cursor = NULL;
	GdkCursor* _tmp10_;
	g_return_if_fail (self != NULL);
	new_cursor = NULL;
	self->priv->is_busy = busy;
	if (busy) {
		GdkCursor* _tmp0_;
		GdkCursor* _tmp1_;
		AdwViewSwitcher* _tmp2_;
		GtkStack* _tmp3_;
		AdwSpinner* _tmp4_;
		BaobabPathbar* _tmp5_;
		_tmp0_ = baobab_window_busy_cursor;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (new_cursor);
		new_cursor = _tmp1_;
		_tmp2_ = self->priv->chart_stack_switcher;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
		_tmp3_ = self->priv->spinner_stack;
		_tmp4_ = self->priv->spinner;
		gtk_stack_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
		_tmp5_ = self->priv->pathbar;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
	} else {
		GtkStack* _tmp6_;
		AdwViewStack* _tmp7_;
		AdwViewSwitcher* _tmp8_;
		BaobabPathbar* _tmp9_;
		_tmp6_ = self->priv->spinner_stack;
		_tmp7_ = self->priv->chart_stack;
		gtk_stack_set_visible_child (_tmp6_, (GtkWidget*) _tmp7_);
		_tmp8_ = self->priv->chart_stack_switcher;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, TRUE);
		_tmp9_ = self->priv->pathbar;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, TRUE);
	}
	_tmp10_ = new_cursor;
	gtk_widget_set_cursor ((GtkWidget*) self, _tmp10_);
	{
		BaobabWindowActionState* action_state_collection = NULL;
		gint action_state_collection_length1 = 0;
		gint _action_state_collection_size_ = 0;
		gint action_state_it = 0;
		action_state_collection = BAOBAB_WINDOW_actions_while_scanning;
		action_state_collection_length1 = G_N_ELEMENTS (BAOBAB_WINDOW_actions_while_scanning);
		for (action_state_it = 0; action_state_it < action_state_collection_length1; action_state_it = action_state_it + 1) {
			BaobabWindowActionState _tmp11_;
			BaobabWindowActionState _tmp12_ = {0};
			BaobabWindowActionState action_state = {0};
			_tmp11_ = action_state_collection[action_state_it];
			baobab_window_action_state_copy (&_tmp11_, &_tmp12_);
			action_state = _tmp12_;
			{
				GSimpleAction* action = NULL;
				BaobabWindowActionState _tmp13_;
				const gchar* _tmp14_;
				GAction* _tmp15_;
				GSimpleAction* _tmp16_;
				GSimpleAction* _tmp17_;
				BaobabWindowActionState _tmp18_;
				_tmp13_ = action_state;
				_tmp14_ = _tmp13_.name;
				_tmp15_ = g_action_map_lookup_action ((GActionMap*) self, _tmp14_);
				_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp15_) : NULL);
				action = _tmp16_;
				_tmp17_ = action;
				_tmp18_ = action_state;
				g_simple_action_set_enabled (_tmp17_, busy == _tmp18_.enable);
				_g_object_unref0 (action);
				baobab_window_action_state_destroy (&action_state);
			}
		}
	}
	_g_object_unref0 (new_cursor);
}

static void
baobab_window_set_ui_state (BaobabWindow* self,
                            GtkWidget* child,
                            gboolean busy)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	baobab_window_set_busy (self, busy);
	_tmp0_ = self->priv->home_page;
	if (child == _tmp0_) {
		GSimpleAction* action = NULL;
		GAction* _tmp1_;
		GSimpleAction* _tmp2_;
		GSimpleAction* _tmp3_;
		AdwNavigationView* _tmp4_;
		_tmp1_ = g_action_map_lookup_action ((GActionMap*) self, "reload");
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp1_) : NULL);
		action = _tmp2_;
		_tmp3_ = action;
		g_simple_action_set_enabled (_tmp3_, FALSE);
		gtk_window_set_title ((GtkWindow*) self, _ ("Devices & Locations"));
		_tmp4_ = self->priv->nav_view;
		adw_navigation_view_pop (_tmp4_);
		_g_object_unref0 (action);
	} else {
		GSimpleAction* action = NULL;
		GAction* _tmp5_;
		GSimpleAction* _tmp6_;
		GSimpleAction* _tmp7_;
		BaobabLocation* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		AdwNavigationView* _tmp11_;
		AdwNavigationPage* _tmp12_;
		AdwNavigationPage* _tmp13_;
		GtkWidget* _tmp14_;
		_tmp5_ = g_action_map_lookup_action ((GActionMap*) self, "reload");
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp5_) : NULL);
		action = _tmp6_;
		_tmp7_ = action;
		g_simple_action_set_enabled (_tmp7_, TRUE);
		_tmp8_ = self->priv->active_location;
		_tmp9_ = baobab_location_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		gtk_window_set_title ((GtkWindow*) self, _tmp10_);
		_tmp11_ = self->priv->nav_view;
		_tmp12_ = adw_navigation_view_get_visible_page (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->result_page;
		if (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget) != _tmp14_) {
			AdwNavigationView* _tmp15_;
			_tmp15_ = self->priv->nav_view;
			adw_navigation_view_push_by_tag (_tmp15_, "results");
		}
		_g_object_unref0 (action);
	}
}

static void
baobab_window_set_chart_location (BaobabWindow* self,
                                  BaobabLocation* location)
{
	BaobabChart* _tmp0_;
	BaobabChart* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = self->priv->rings_chart;
	baobab_chart_set_location (_tmp0_, location);
	_tmp1_ = self->priv->treemap_chart;
	baobab_chart_set_location (_tmp1_, location);
}

static void
baobab_window_scanner_completed (BaobabWindow* self)
{
	BaobabScanner* scanner = NULL;
	BaobabLocation* _tmp0_;
	BaobabScanner* _tmp1_;
	BaobabScanner* _tmp2_;
	BaobabScanner* _tmp3_;
	BaobabScanner* _tmp14_;
	BaobabScannerResults* _tmp15_;
	BaobabScannerResults* _tmp16_;
	BaobabLocation* _tmp17_;
	GtkWidget* _tmp18_;
	BaobabFolderDisplay* _tmp19_;
	BaobabScanner* _tmp20_;
	BaobabScannerResults* _tmp21_;
	BaobabScannerResults* _tmp22_;
	AdwBanner* _tmp23_;
	BaobabScanner* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_location;
	_tmp1_ = baobab_location_get_scanner (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	scanner = _tmp3_;
	if (self->priv->scan_completed_handler > ((gulong) 0)) {
		BaobabScanner* _tmp4_;
		_tmp4_ = scanner;
		g_signal_handler_disconnect ((GObject*) _tmp4_, self->priv->scan_completed_handler);
		self->priv->scan_completed_handler = (gulong) 0;
	}
	if (self->priv->scanning_progress_id > ((guint) 0)) {
		g_source_remove (self->priv->scanning_progress_id);
		self->priv->scanning_progress_id = (guint) 0;
	}
	{
		BaobabScanner* _tmp5_;
		_tmp5_ = scanner;
		baobab_scanner_finish (_tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (scanner);
		return;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		BaobabScanner* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		GtkWidget* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = scanner;
		_tmp7_ = baobab_scanner_get_directory (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_file_get_parse_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("baobab-window.vala:620: Could not scan folder %s: %s", _tmp10_, _tmp12_);
		_g_free0 (_tmp10_);
		baobab_window_toast (self, _ ("Could not scan folder"));
		_tmp13_ = self->priv->home_page;
		baobab_window_set_ui_state (self, _tmp13_, FALSE);
		_g_error_free0 (e);
		_g_object_unref0 (scanner);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (scanner);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp14_ = scanner;
	_tmp15_ = baobab_scanner_get_root (_tmp14_);
	_tmp16_ = _tmp15_;
	baobab_window_reroot_treeview (self, _tmp16_, FALSE);
	_tmp17_ = self->priv->active_location;
	baobab_window_set_chart_location (self, _tmp17_);
	_tmp18_ = self->priv->result_page;
	baobab_window_set_ui_state (self, _tmp18_, FALSE);
	_tmp19_ = self->priv->folder_display;
	_tmp20_ = scanner;
	_tmp21_ = baobab_scanner_get_root (_tmp20_);
	_tmp22_ = _tmp21_;
	baobab_folder_display_set_path (_tmp19_, _tmp22_);
	_tmp23_ = self->priv->banner;
	_tmp24_ = scanner;
	_tmp25_ = baobab_scanner_get_show_allocated_size (_tmp24_);
	_tmp26_ = _tmp25_;
	adw_banner_set_revealed (_tmp23_, !_tmp26_);
	g_object_get ((GtkWindow*) self, "is-active", &_tmp27_, NULL);
	_tmp28_ = _tmp27_;
	if (!_tmp28_) {
		GNotification* notification = NULL;
		GNotification* _tmp29_;
		GNotification* _tmp30_;
		BaobabScanner* _tmp31_;
		GFile* _tmp32_;
		GFile* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		GtkApplication* _tmp38_;
		GNotification* _tmp39_;
		_tmp29_ = g_notification_new (_ ("Scan completed"));
		notification = _tmp29_;
		_tmp30_ = notification;
		_tmp31_ = scanner;
		_tmp32_ = baobab_scanner_get_directory (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_file_get_parse_name (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup_printf (_ ("Completed scan of “%s”"), _tmp35_);
		_tmp37_ = _tmp36_;
		g_notification_set_body (_tmp30_, _tmp37_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		_tmp38_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp39_ = notification;
		g_application_send_notification ((GApplication*) _tmp38_, "scan-completed", _tmp39_);
		_g_object_unref0 (notification);
	}
	_g_object_unref0 (scanner);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		BaobabWindow* self;
		self = _data9_->self;
		_baobab_location_unref0 (_data9_->location);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
_baobab_window_scanner_completed_baobab_scanner_completed (BaobabScanner* _sender,
                                                           gpointer self)
{
	baobab_window_scanner_completed ((BaobabWindow*) self);
}

static gboolean
__lambda18_ (Block9Data* _data9_)
{
	BaobabWindow* self;
	gboolean result;
	self = _data9_->self;
	g_signal_emit_by_name (_data9_->location, "progress");
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
___lambda18__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda18_ (self);
	return result;
}

static void
baobab_window_scan_location (BaobabWindow* self,
                             BaobabLocation* location,
                             gboolean force)
{
	Block9Data* _data9_;
	BaobabLocation* _tmp0_;
	BaobabLocation* _tmp1_;
	BaobabPathbar* _tmp2_;
	BaobabFolderDisplay* _tmp3_;
	BaobabLocationList* _tmp4_;
	GtkSortListModel* _tmp5_;
	BaobabScanner* scanner = NULL;
	BaobabScanner* _tmp6_;
	BaobabScanner* _tmp7_;
	BaobabScanner* _tmp8_;
	gulong _tmp9_;
	AdwBanner* _tmp10_;
	GtkWidget* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = _baobab_location_ref0 (location);
	_baobab_location_unref0 (_data9_->location);
	_data9_->location = _tmp0_;
	baobab_window_cancel_scan (self);
	_tmp1_ = _baobab_location_ref0 (_data9_->location);
	_baobab_location_unref0 (self->priv->active_location);
	self->priv->active_location = _tmp1_;
	_tmp2_ = self->priv->pathbar;
	baobab_pathbar_set_location (_tmp2_, _data9_->location);
	_tmp3_ = self->priv->folder_display;
	baobab_folder_display_set_location (_tmp3_, _data9_->location);
	_tmp4_ = self->priv->location_list;
	baobab_location_list_add_location (_tmp4_, _data9_->location);
	_tmp5_ = self->priv->columnview_sort_model;
	gtk_sort_list_model_set_model (_tmp5_, NULL);
	_tmp6_ = baobab_location_get_scanner (_data9_->location);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	scanner = _tmp8_;
	_tmp9_ = g_signal_connect_object (scanner, "completed", (GCallback) _baobab_window_scanner_completed_baobab_scanner_completed, self, 0);
	self->priv->scan_completed_handler = _tmp9_;
	_tmp10_ = self->priv->banner;
	adw_banner_set_revealed (_tmp10_, FALSE);
	self->priv->scanning_progress_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda18__gsource_func, block9_data_ref (_data9_), block9_data_unref);
	_tmp11_ = self->priv->result_page;
	baobab_window_set_ui_state (self, _tmp11_, TRUE);
	baobab_scanner_scan (scanner, force);
	_g_object_unref0 (scanner);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

void
baobab_window_scan_directory (BaobabWindow* self,
                              GFile* directory,
                              BaobabScanFlags flags)
{
	GFileInfo* info = NULL;
	gboolean _tmp3_ = FALSE;
	GFileInfo* _tmp4_;
	BaobabLocation* location = NULL;
	BaobabLocation* _tmp10_;
	BaobabLocation* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	info = NULL;
	{
		GFileInfo* _tmp0_ = NULL;
		GFileInfo* _tmp1_;
		GFileInfo* _tmp2_;
		_tmp1_ = g_file_query_info (directory, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (info);
		info = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = info;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GFileInfo* _tmp5_;
		_tmp5_ = info;
		_tmp3_ = g_file_info_get_file_type (_tmp5_) != G_FILE_TYPE_DIRECTORY;
	}
	if (_tmp3_) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = g_file_get_parse_name (directory);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf (_ ("“%s” is not a valid folder"), _tmp7_);
		_tmp9_ = _tmp8_;
		baobab_window_toast (self, _tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_object_unref0 (info);
		return;
	}
	_tmp10_ = baobab_location_new_for_file (directory, flags);
	location = _tmp10_;
	_tmp11_ = location;
	baobab_window_scan_location (self, _tmp11_, FALSE);
	_baobab_location_unref0 (location);
	_g_object_unref0 (info);
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}

static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}

static guint*
baobab_window_get_columnview_position_at_coords (BaobabWindow* self,
                                                 gdouble x,
                                                 gdouble y)
{
	GtkWidget* child = NULL;
	GtkColumnView* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* row = NULL;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	guint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->columnview;
	_tmp1_ = gtk_widget_pick ((GtkWidget*) _tmp0_, x, y, GTK_PICK_INSENSITIVE | GTK_PICK_NON_TARGETABLE);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	child = _tmp2_;
	_tmp3_ = child;
	_tmp4_ = gtk_widget_get_ancestor (_tmp3_, g_type_from_name ("GtkColumnViewRowWidget"));
	_tmp5_ = _g_object_ref0 (_tmp4_);
	row = _tmp5_;
	_tmp6_ = row;
	if (_tmp6_ == NULL) {
		result = NULL;
		_g_object_unref0 (row);
		_g_object_unref0 (child);
		return result;
	}
	{
		GtkWidget* cell = NULL;
		GtkWidget* _tmp7_;
		GtkWidget* _tmp8_;
		GtkWidget* _tmp9_;
		_tmp7_ = row;
		_tmp8_ = gtk_widget_get_first_child (_tmp7_);
		_tmp9_ = _g_object_ref0 (_tmp8_);
		cell = _tmp9_;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				GtkWidget* _tmp14_;
				GtkWidget* cell_content = NULL;
				GtkWidget* _tmp15_;
				GtkWidget* _tmp16_;
				GtkWidget* _tmp17_;
				gboolean _tmp18_ = FALSE;
				GtkWidget* _tmp19_;
				BaobabFileCell* file_cell = NULL;
				GtkWidget* _tmp21_;
				BaobabFileCell* _tmp22_;
				guint position = 0U;
				BaobabFileCell* _tmp23_;
				BaobabScannerResults* _tmp24_;
				BaobabScannerResults* _tmp25_;
				guint _tmp26_ = 0U;
				gboolean _tmp27_;
				if (!_tmp10_) {
					GtkWidget* _tmp11_;
					GtkWidget* _tmp12_;
					GtkWidget* _tmp13_;
					_tmp11_ = cell;
					_tmp12_ = gtk_widget_get_next_sibling (_tmp11_);
					_tmp13_ = _g_object_ref0 (_tmp12_);
					_g_object_unref0 (cell);
					cell = _tmp13_;
				}
				_tmp10_ = FALSE;
				_tmp14_ = cell;
				if (!(_tmp14_ != NULL)) {
					break;
				}
				_tmp15_ = cell;
				_tmp16_ = gtk_widget_get_first_child (_tmp15_);
				_tmp17_ = _g_object_ref0 (_tmp16_);
				cell_content = _tmp17_;
				_tmp19_ = cell_content;
				if (_tmp19_ == NULL) {
					_tmp18_ = TRUE;
				} else {
					GtkWidget* _tmp20_;
					_tmp20_ = cell_content;
					_tmp18_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp20_) != BAOBAB_TYPE_FILE_CELL;
				}
				if (_tmp18_) {
					_g_object_unref0 (cell_content);
					continue;
				}
				_tmp21_ = cell_content;
				_tmp22_ = _g_object_ref0 (BAOBAB_IS_FILE_CELL (_tmp21_) ? ((BaobabFileCell*) _tmp21_) : NULL);
				file_cell = _tmp22_;
				position = (guint) 0;
				_tmp23_ = file_cell;
				_tmp24_ = baobab_file_cell_get_item (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp27_ = baobab_window_columnview_selection_find (self, (GObject*) _tmp25_, TRUE, &_tmp26_);
				position = _tmp26_;
				if (_tmp27_) {
					guint* _tmp28_;
					_tmp28_ = __uint_dup0 (&position);
					result = _tmp28_;
					_g_object_unref0 (file_cell);
					_g_object_unref0 (cell_content);
					_g_object_unref0 (cell);
					_g_object_unref0 (row);
					_g_object_unref0 (child);
					return result;
				}
				_g_object_unref0 (file_cell);
				_g_object_unref0 (cell_content);
				break;
			}
		}
		_g_object_unref0 (cell);
	}
	result = NULL;
	_g_object_unref0 (row);
	_g_object_unref0 (child);
	return result;
}

static void
baobab_window_folder_cell_setup (BaobabWindow* self,
                                 GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	BaobabFileCell* child = NULL;
	BaobabFileCell* _tmp1_;
	BaobabFolderDisplay* _tmp2_;
	GtkSizeGroup* _tmp3_;
	GtkSizeGroup* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = baobab_file_cell_new ();
	g_object_ref_sink (_tmp1_);
	child = _tmp1_;
	gtk_column_view_cell_set_child (item, (GtkWidget*) child);
	_tmp2_ = self->priv->folder_display;
	_tmp3_ = baobab_folder_display_get_folder_size_group (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_column_view_cell_get_child (item);
	_tmp6_ = _tmp5_;
	gtk_size_group_add_widget (_tmp4_, _tmp6_);
	_g_object_unref0 (child);
	_g_object_unref0 (item);
}

static void
_baobab_window_folder_cell_setup_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                     GObject* object,
                                                                     gpointer self)
{
	baobab_window_folder_cell_setup ((BaobabWindow*) self, object);
}

static void
baobab_window_folder_cell_bind (BaobabWindow* self,
                                GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	GtkTreeListRow* row = NULL;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GtkTreeListRow* _tmp3_;
	BaobabScannerResults* results = NULL;
	GObject* _tmp4_;
	GObject* _tmp5_;
	BaobabScannerResults* _tmp6_;
	BaobabFileCell* child = NULL;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	BaobabFileCell* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = gtk_column_view_cell_get_item (item);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_tree_list_row_get_type ()) ? ((GtkTreeListRow*) _tmp2_) : NULL);
	row = _tmp3_;
	_tmp4_ = gtk_tree_list_row_get_item (row);
	_tmp5_ = _tmp4_;
	_tmp6_ = BAOBAB_SCANNER_IS_RESULTS (_tmp5_) ? ((BaobabScannerResults*) _tmp5_) : NULL;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (_tmp5_);
	}
	results = _tmp6_;
	_tmp7_ = gtk_column_view_cell_get_child (item);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (BAOBAB_IS_FILE_CELL (_tmp8_) ? ((BaobabFileCell*) _tmp8_) : NULL);
	child = _tmp9_;
	baobab_file_cell_set_item (child, results);
	baobab_file_cell_set_list_row (child, row);
	_g_object_unref0 (child);
	_g_object_unref0 (results);
	_g_object_unref0 (row);
	_g_object_unref0 (item);
}

static void
_baobab_window_folder_cell_bind_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                   GObject* object,
                                                                   gpointer self)
{
	baobab_window_folder_cell_bind ((BaobabWindow*) self, object);
}

static void
baobab_window_folder_cell_unbind (BaobabWindow* self,
                                  GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	BaobabFileCell* child = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	BaobabFileCell* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = gtk_column_view_cell_get_child (item);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (BAOBAB_IS_FILE_CELL (_tmp2_) ? ((BaobabFileCell*) _tmp2_) : NULL);
	child = _tmp3_;
	baobab_file_cell_set_item (child, NULL);
	_g_object_unref0 (child);
	_g_object_unref0 (item);
}

static void
_baobab_window_folder_cell_unbind_gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                                       GObject* object,
                                                                       gpointer self)
{
	baobab_window_folder_cell_unbind ((BaobabWindow*) self, object);
}

static void
baobab_window_folder_cell_teardown (BaobabWindow* self,
                                    GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	BaobabFolderDisplay* _tmp1_;
	GtkSizeGroup* _tmp2_;
	GtkSizeGroup* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = self->priv->folder_display;
	_tmp2_ = baobab_folder_display_get_folder_size_group (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_column_view_cell_get_child (item);
	_tmp5_ = _tmp4_;
	gtk_size_group_remove_widget (_tmp3_, _tmp5_);
	_g_object_unref0 (item);
}

static void
_baobab_window_folder_cell_teardown_gtk_signal_list_item_factory_teardown (GtkSignalListItemFactory* _sender,
                                                                           GObject* object,
                                                                           gpointer self)
{
	baobab_window_folder_cell_teardown ((BaobabWindow*) self, object);
}

static void
baobab_window_size_cell_setup (BaobabWindow* self,
                               GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	BaobabSizeCell* child = NULL;
	BaobabSizeCell* _tmp1_;
	BaobabFolderDisplay* _tmp2_;
	GtkSizeGroup* _tmp3_;
	GtkSizeGroup* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = baobab_size_cell_new ();
	g_object_ref_sink (_tmp1_);
	child = _tmp1_;
	gtk_column_view_cell_set_child (item, (GtkWidget*) child);
	_tmp2_ = self->priv->folder_display;
	_tmp3_ = baobab_folder_display_get_size_size_group (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_column_view_cell_get_child (item);
	_tmp6_ = _tmp5_;
	gtk_size_group_add_widget (_tmp4_, _tmp6_);
	_g_object_unref0 (child);
	_g_object_unref0 (item);
}

static void
_baobab_window_size_cell_setup_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                   GObject* object,
                                                                   gpointer self)
{
	baobab_window_size_cell_setup ((BaobabWindow*) self, object);
}

static void
baobab_window_size_cell_bind (BaobabWindow* self,
                              GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	GtkTreeListRow* row = NULL;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GtkTreeListRow* _tmp3_;
	BaobabScannerResults* results = NULL;
	GObject* _tmp4_;
	GObject* _tmp5_;
	BaobabScannerResults* _tmp6_;
	BaobabSizeCell* child = NULL;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	BaobabSizeCell* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = gtk_column_view_cell_get_item (item);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_tree_list_row_get_type ()) ? ((GtkTreeListRow*) _tmp2_) : NULL);
	row = _tmp3_;
	_tmp4_ = gtk_tree_list_row_get_item (row);
	_tmp5_ = _tmp4_;
	_tmp6_ = BAOBAB_SCANNER_IS_RESULTS (_tmp5_) ? ((BaobabScannerResults*) _tmp5_) : NULL;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (_tmp5_);
	}
	results = _tmp6_;
	_tmp7_ = gtk_column_view_cell_get_child (item);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (BAOBAB_IS_SIZE_CELL (_tmp8_) ? ((BaobabSizeCell*) _tmp8_) : NULL);
	child = _tmp9_;
	baobab_size_cell_set_item (child, results);
	_g_object_unref0 (child);
	_g_object_unref0 (results);
	_g_object_unref0 (row);
	_g_object_unref0 (item);
}

static void
_baobab_window_size_cell_bind_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                 GObject* object,
                                                                 gpointer self)
{
	baobab_window_size_cell_bind ((BaobabWindow*) self, object);
}

static void
baobab_window_size_cell_unbind (BaobabWindow* self,
                                GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	BaobabSizeCell* child = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	BaobabSizeCell* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = gtk_column_view_cell_get_child (item);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (BAOBAB_IS_SIZE_CELL (_tmp2_) ? ((BaobabSizeCell*) _tmp2_) : NULL);
	child = _tmp3_;
	baobab_size_cell_set_item (child, NULL);
	_g_object_unref0 (child);
	_g_object_unref0 (item);
}

static void
_baobab_window_size_cell_unbind_gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                                     GObject* object,
                                                                     gpointer self)
{
	baobab_window_size_cell_unbind ((BaobabWindow*) self, object);
}

static void
baobab_window_size_cell_teardown (BaobabWindow* self,
                                  GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	BaobabFolderDisplay* _tmp1_;
	GtkSizeGroup* _tmp2_;
	GtkSizeGroup* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = self->priv->folder_display;
	_tmp2_ = baobab_folder_display_get_size_size_group (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_column_view_cell_get_child (item);
	_tmp5_ = _tmp4_;
	gtk_size_group_remove_widget (_tmp3_, _tmp5_);
	_g_object_unref0 (item);
}

static void
_baobab_window_size_cell_teardown_gtk_signal_list_item_factory_teardown (GtkSignalListItemFactory* _sender,
                                                                         GObject* object,
                                                                         gpointer self)
{
	baobab_window_size_cell_teardown ((BaobabWindow*) self, object);
}

static void
baobab_window_contents_cell_setup (BaobabWindow* self,
                                   GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	BaobabContentsCell* child = NULL;
	BaobabContentsCell* _tmp1_;
	BaobabFolderDisplay* _tmp2_;
	GtkSizeGroup* _tmp3_;
	GtkSizeGroup* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = baobab_contents_cell_new ();
	g_object_ref_sink (_tmp1_);
	child = _tmp1_;
	gtk_column_view_cell_set_child (item, (GtkWidget*) child);
	_tmp2_ = self->priv->folder_display;
	_tmp3_ = baobab_folder_display_get_contents_size_group (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_column_view_cell_get_child (item);
	_tmp6_ = _tmp5_;
	gtk_size_group_add_widget (_tmp4_, _tmp6_);
	_g_object_unref0 (child);
	_g_object_unref0 (item);
}

static void
_baobab_window_contents_cell_setup_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                       GObject* object,
                                                                       gpointer self)
{
	baobab_window_contents_cell_setup ((BaobabWindow*) self, object);
}

static void
baobab_window_contents_cell_bind (BaobabWindow* self,
                                  GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	GtkTreeListRow* row = NULL;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GtkTreeListRow* _tmp3_;
	BaobabScannerResults* results = NULL;
	GObject* _tmp4_;
	GObject* _tmp5_;
	BaobabScannerResults* _tmp6_;
	BaobabContentsCell* child = NULL;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	BaobabContentsCell* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = gtk_column_view_cell_get_item (item);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_tree_list_row_get_type ()) ? ((GtkTreeListRow*) _tmp2_) : NULL);
	row = _tmp3_;
	_tmp4_ = gtk_tree_list_row_get_item (row);
	_tmp5_ = _tmp4_;
	_tmp6_ = BAOBAB_SCANNER_IS_RESULTS (_tmp5_) ? ((BaobabScannerResults*) _tmp5_) : NULL;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (_tmp5_);
	}
	results = _tmp6_;
	_tmp7_ = gtk_column_view_cell_get_child (item);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (BAOBAB_IS_CONTENTS_CELL (_tmp8_) ? ((BaobabContentsCell*) _tmp8_) : NULL);
	child = _tmp9_;
	baobab_contents_cell_set_item (child, results);
	_g_object_unref0 (child);
	_g_object_unref0 (results);
	_g_object_unref0 (row);
	_g_object_unref0 (item);
}

static void
_baobab_window_contents_cell_bind_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                     GObject* object,
                                                                     gpointer self)
{
	baobab_window_contents_cell_bind ((BaobabWindow*) self, object);
}

static void
baobab_window_contents_cell_unbind (BaobabWindow* self,
                                    GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	BaobabContentsCell* child = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	BaobabContentsCell* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = gtk_column_view_cell_get_child (item);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (BAOBAB_IS_CONTENTS_CELL (_tmp2_) ? ((BaobabContentsCell*) _tmp2_) : NULL);
	child = _tmp3_;
	baobab_contents_cell_set_item (child, NULL);
	_g_object_unref0 (child);
	_g_object_unref0 (item);
}

static void
_baobab_window_contents_cell_unbind_gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                                         GObject* object,
                                                                         gpointer self)
{
	baobab_window_contents_cell_unbind ((BaobabWindow*) self, object);
}

static void
baobab_window_contents_cell_teardown (BaobabWindow* self,
                                      GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	BaobabFolderDisplay* _tmp1_;
	GtkSizeGroup* _tmp2_;
	GtkSizeGroup* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = self->priv->folder_display;
	_tmp2_ = baobab_folder_display_get_contents_size_group (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_column_view_cell_get_child (item);
	_tmp5_ = _tmp4_;
	gtk_size_group_remove_widget (_tmp3_, _tmp5_);
	_g_object_unref0 (item);
}

static void
_baobab_window_contents_cell_teardown_gtk_signal_list_item_factory_teardown (GtkSignalListItemFactory* _sender,
                                                                             GObject* object,
                                                                             gpointer self)
{
	baobab_window_contents_cell_teardown ((BaobabWindow*) self, object);
}

static void
baobab_window_time_modified_cell_setup (BaobabWindow* self,
                                        GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	BaobabTimeModifiedCell* child = NULL;
	BaobabTimeModifiedCell* _tmp1_;
	BaobabFolderDisplay* _tmp2_;
	GtkSizeGroup* _tmp3_;
	GtkSizeGroup* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = baobab_time_modified_cell_new ();
	g_object_ref_sink (_tmp1_);
	child = _tmp1_;
	gtk_column_view_cell_set_child (item, (GtkWidget*) child);
	_tmp2_ = self->priv->folder_display;
	_tmp3_ = baobab_folder_display_get_time_modified_size_group (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_column_view_cell_get_child (item);
	_tmp6_ = _tmp5_;
	gtk_size_group_add_widget (_tmp4_, _tmp6_);
	_g_object_unref0 (child);
	_g_object_unref0 (item);
}

static void
_baobab_window_time_modified_cell_setup_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                            GObject* object,
                                                                            gpointer self)
{
	baobab_window_time_modified_cell_setup ((BaobabWindow*) self, object);
}

static void
baobab_window_time_modified_cell_bind (BaobabWindow* self,
                                       GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	GtkTreeListRow* row = NULL;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GtkTreeListRow* _tmp3_;
	BaobabScannerResults* results = NULL;
	GObject* _tmp4_;
	GObject* _tmp5_;
	BaobabScannerResults* _tmp6_;
	BaobabTimeModifiedCell* child = NULL;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	BaobabTimeModifiedCell* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = gtk_column_view_cell_get_item (item);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_tree_list_row_get_type ()) ? ((GtkTreeListRow*) _tmp2_) : NULL);
	row = _tmp3_;
	_tmp4_ = gtk_tree_list_row_get_item (row);
	_tmp5_ = _tmp4_;
	_tmp6_ = BAOBAB_SCANNER_IS_RESULTS (_tmp5_) ? ((BaobabScannerResults*) _tmp5_) : NULL;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (_tmp5_);
	}
	results = _tmp6_;
	_tmp7_ = gtk_column_view_cell_get_child (item);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (BAOBAB_IS_TIME_MODIFIED_CELL (_tmp8_) ? ((BaobabTimeModifiedCell*) _tmp8_) : NULL);
	child = _tmp9_;
	baobab_time_modified_cell_set_item (child, results);
	_g_object_unref0 (child);
	_g_object_unref0 (results);
	_g_object_unref0 (row);
	_g_object_unref0 (item);
}

static void
_baobab_window_time_modified_cell_bind_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                          GObject* object,
                                                                          gpointer self)
{
	baobab_window_time_modified_cell_bind ((BaobabWindow*) self, object);
}

static void
baobab_window_time_modified_cell_unbind (BaobabWindow* self,
                                         GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	BaobabTimeModifiedCell* child = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	BaobabTimeModifiedCell* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = gtk_column_view_cell_get_child (item);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (BAOBAB_IS_TIME_MODIFIED_CELL (_tmp2_) ? ((BaobabTimeModifiedCell*) _tmp2_) : NULL);
	child = _tmp3_;
	baobab_time_modified_cell_set_item (child, NULL);
	_g_object_unref0 (child);
	_g_object_unref0 (item);
}

static void
_baobab_window_time_modified_cell_unbind_gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                                              GObject* object,
                                                                              gpointer self)
{
	baobab_window_time_modified_cell_unbind ((BaobabWindow*) self, object);
}

static void
baobab_window_time_modified_cell_teardown (BaobabWindow* self,
                                           GObject* object)
{
	GtkColumnViewCell* item = NULL;
	GtkColumnViewCell* _tmp0_;
	BaobabFolderDisplay* _tmp1_;
	GtkSizeGroup* _tmp2_;
	GtkSizeGroup* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_column_view_cell_get_type ()) ? ((GtkColumnViewCell*) object) : NULL);
	item = _tmp0_;
	_tmp1_ = self->priv->folder_display;
	_tmp2_ = baobab_folder_display_get_time_modified_size_group (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_column_view_cell_get_child (item);
	_tmp5_ = _tmp4_;
	gtk_size_group_remove_widget (_tmp3_, _tmp5_);
	_g_object_unref0 (item);
}

static void
_baobab_window_time_modified_cell_teardown_gtk_signal_list_item_factory_teardown (GtkSignalListItemFactory* _sender,
                                                                                  GObject* object,
                                                                                  gpointer self)
{
	baobab_window_time_modified_cell_teardown ((BaobabWindow*) self, object);
}

void
baobab_window_action_state_copy (const BaobabWindowActionState* self,
                                 BaobabWindowActionState* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	(*dest).enable = (*self).enable;
}

void
baobab_window_action_state_destroy (BaobabWindowActionState* self)
{
	_g_free0 ((*self).name);
}

BaobabWindowActionState*
baobab_window_action_state_dup (const BaobabWindowActionState* self)
{
	BaobabWindowActionState* dup;
	dup = g_new0 (BaobabWindowActionState, 1);
	baobab_window_action_state_copy (self, dup);
	return dup;
}

void
baobab_window_action_state_free (BaobabWindowActionState* self)
{
	baobab_window_action_state_destroy (self);
	g_free (self);
}

static GType
baobab_window_action_state_get_type_once (void)
{
	GType baobab_window_action_state_type_id;
	baobab_window_action_state_type_id = g_boxed_type_register_static ("BaobabWindowActionState", (GBoxedCopyFunc) baobab_window_action_state_dup, (GBoxedFreeFunc) baobab_window_action_state_free);
	return baobab_window_action_state_type_id;
}

GType
baobab_window_action_state_get_type (void)
{
	static volatile gsize baobab_window_action_state_type_id__once = 0;
	if (g_once_init_enter (&baobab_window_action_state_type_id__once)) {
		GType baobab_window_action_state_type_id;
		baobab_window_action_state_type_id = baobab_window_action_state_get_type_once ();
		g_once_init_leave (&baobab_window_action_state_type_id__once, baobab_window_action_state_type_id);
	}
	return baobab_window_action_state_type_id__once;
}

static void
baobab_window_class_init (BaobabWindowClass * klass,
                          gpointer klass_data)
{
	baobab_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = baobab_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/baobab/ui/baobab-main-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "focus_controller", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, focus_controller));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "drop_target", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, drop_target));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pathbar", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, pathbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "nav_view", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, nav_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "home_page", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, home_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "result_page", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, result_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toast_overlay", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, toast_overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "banner", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, banner));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "location_list", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, location_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "folder_display", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, folder_display));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "columnview", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, columnview));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "columnview_selection", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, columnview_selection));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "columnview_sort_model", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, columnview_sort_model));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_popover_menu", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, treeview_popover_menu));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "chart_stack", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, chart_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinner_stack", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, spinner_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "chart_stack_switcher", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, chart_stack_switcher));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rings_chart", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, rings_chart));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treemap_chart", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, treemap_chart));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinner", FALSE, BaobabWindow_private_offset + G_STRUCT_OFFSET (BaobabWindowPrivate, spinner));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "results_hidden", G_CALLBACK(_baobab_window_results_hidden_adw_navigation_page_hidden));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "treeview_left_click_gesture_released", G_CALLBACK(_baobab_window_treeview_left_click_gesture_released_gtk_gesture_click_released));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "treeview_right_click_gesture_pressed", G_CALLBACK(_baobab_window_treeview_right_click_gesture_pressed_gtk_gesture_click_pressed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "columnview_activate", G_CALLBACK(_baobab_window_columnview_activate_gtk_column_view_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "folder_cell_setup", G_CALLBACK(_baobab_window_folder_cell_setup_gtk_signal_list_item_factory_setup));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "folder_cell_bind", G_CALLBACK(_baobab_window_folder_cell_bind_gtk_signal_list_item_factory_bind));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "folder_cell_unbind", G_CALLBACK(_baobab_window_folder_cell_unbind_gtk_signal_list_item_factory_unbind));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "folder_cell_teardown", G_CALLBACK(_baobab_window_folder_cell_teardown_gtk_signal_list_item_factory_teardown));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "size_cell_setup", G_CALLBACK(_baobab_window_size_cell_setup_gtk_signal_list_item_factory_setup));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "size_cell_bind", G_CALLBACK(_baobab_window_size_cell_bind_gtk_signal_list_item_factory_bind));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "size_cell_unbind", G_CALLBACK(_baobab_window_size_cell_unbind_gtk_signal_list_item_factory_unbind));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "size_cell_teardown", G_CALLBACK(_baobab_window_size_cell_teardown_gtk_signal_list_item_factory_teardown));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "contents_cell_setup", G_CALLBACK(_baobab_window_contents_cell_setup_gtk_signal_list_item_factory_setup));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "contents_cell_bind", G_CALLBACK(_baobab_window_contents_cell_bind_gtk_signal_list_item_factory_bind));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "contents_cell_unbind", G_CALLBACK(_baobab_window_contents_cell_unbind_gtk_signal_list_item_factory_unbind));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "contents_cell_teardown", G_CALLBACK(_baobab_window_contents_cell_teardown_gtk_signal_list_item_factory_teardown));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "time_modified_cell_setup", G_CALLBACK(_baobab_window_time_modified_cell_setup_gtk_signal_list_item_factory_setup));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "time_modified_cell_bind", G_CALLBACK(_baobab_window_time_modified_cell_bind_gtk_signal_list_item_factory_bind));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "time_modified_cell_unbind", G_CALLBACK(_baobab_window_time_modified_cell_unbind_gtk_signal_list_item_factory_unbind));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "time_modified_cell_teardown", G_CALLBACK(_baobab_window_time_modified_cell_teardown_gtk_signal_list_item_factory_teardown));
}

static void
baobab_window_instance_init (BaobabWindow * self,
                             gpointer klass)
{
	self->priv = baobab_window_get_instance_private (self);
	self->priv->active_location = NULL;
	self->priv->is_busy = FALSE;
	self->priv->scan_completed_handler = (gulong) 0;
	self->priv->scanning_progress_id = (guint) 0;
	self->priv->popover_item = NULL;
	g_type_ensure (BAOBAB_TYPE_PATHBAR);
	g_type_ensure (BAOBAB_TYPE_LOCATION_LIST);
	g_type_ensure (BAOBAB_TYPE_FOLDER_DISPLAY);
	g_type_ensure (BAOBAB_TYPE_CHART);
	g_type_ensure (BAOBAB_TYPE_CHART);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
baobab_window_finalize (GObject * obj)
{
	BaobabWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_WINDOW, BaobabWindow);
	_baobab_location_unref0 (self->priv->active_location);
	_g_object_unref0 (self->priv->popover_item);
	G_OBJECT_CLASS (baobab_window_parent_class)->finalize (obj);
}

static GType
baobab_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabWindow), 0, (GInstanceInitFunc) baobab_window_instance_init, NULL };
	GType baobab_window_type_id;
	baobab_window_type_id = g_type_register_static (adw_application_window_get_type (), "BaobabWindow", &g_define_type_info, 0);
	BaobabWindow_private_offset = g_type_add_instance_private (baobab_window_type_id, sizeof (BaobabWindowPrivate));
	return baobab_window_type_id;
}

GType
baobab_window_get_type (void)
{
	static volatile gsize baobab_window_type_id__once = 0;
	if (g_once_init_enter (&baobab_window_type_id__once)) {
		GType baobab_window_type_id;
		baobab_window_type_id = baobab_window_get_type_once ();
		g_once_init_leave (&baobab_window_type_id__once, baobab_window_type_id);
	}
	return baobab_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

