# MacroCreateLibtoolFile.cmake
# http://www.cmake.org/Wiki/CMakeMacroLibtoolFile

macro(GET_TARGET_PROPERTY_WITH_DEFAULT _variable _target _property _default_value)
  get_target_property (${_variable} ${_target} ${_property})
  if (${_variable} MATCHES NOTFOUND)
    set (${_variable} ${_default_value})
  endif ()
endmacro (GET_TARGET_PROPERTY_WITH_DEFAULT)

macro(CREATE_LIBTOOL_FILE _target _install_DIR)
  get_target_property(_target_location ${_target} LOCATION)
  get_target_property_with_default(_target_static_lib ${_target} STATIC_LIB "")
  get_target_property_with_default(_target_dependency_libs ${_target} LT_DEPENDENCY_LIBS "")
  get_target_property_with_default(_target_current ${_target} LT_VERSION_CURRENT 0)
  get_target_property_with_default(_target_age ${_target} LT_VERSION_AGE 0)
  get_target_property_with_default(_target_revision ${_target} LT_VERSION_REVISION 0)
  get_target_property_with_default(_target_installed ${_target} LT_INSTALLED yes)
  get_target_property_with_default(_target_shouldnotlink ${_target} LT_SHOULDNOTLINK yes)
  get_target_property_with_default(_target_dlopen ${_target} LT_DLOPEN "")
  get_target_property_with_default(_target_dlpreopen ${_target} LT_DLPREOPEN "")
  get_filename_component(_laname ${_target_location} NAME_WE)
  get_filename_component(_soname ${_target_location} NAME)
  set(_laname ${PROJECT_BINARY_DIR}/${_laname}.la)
  file(WRITE ${_laname} "# ${_laname} - a libtool library file\n")
  file(WRITE ${_laname} "# Generated by CMake ${CMAKE_VERSION} (like GNU libtool)\n")
  file(WRITE ${_laname} "\n# Please DO NOT delete this file!\n# It is necessary for linking the library with libtool.\n\n" )
  file(APPEND ${_laname} "# The name that we can dlopen(3).\n")
  file(APPEND ${_laname} "dlname='${_soname}'\n\n")
  file(APPEND ${_laname} "# Names of this library.\n")
  file(APPEND ${_laname} "library_names='${_soname}.${_target_current}.${_target_age}.${_target_revision} ${_soname}.${_target_current} ${_soname}'\n\n")
  file(APPEND ${_laname} "# The name of the static archive.\n")
  file(APPEND ${_laname} "old_library='${_target_static_lib}'\n\n")
  file(APPEND ${_laname} "# Libraries that this one depends upon.\n")
  file(APPEND ${_laname} "dependency_libs='${_target_dependency_libs}'\n\n")
  file(APPEND ${_laname} "# Names of additional weak libraries provided by this library\n")
  file(APPEND ${_laname} "weak_library_names=''\n\n")
  file(APPEND ${_laname} "# Version information for ${_laname}.\n")
  file(APPEND ${_laname} "current=${_target_current}\n")
  file(APPEND ${_laname} "age=${_target_age}\n")
  file(APPEND ${_laname} "revision=${_target_revision}\n\n")
  file(APPEND ${_laname} "# Is this an already installed library?\n")
  file(APPEND ${_laname} "installed=${_target_installed}\n\n")
  file(APPEND ${_laname} "# Should we warn about portability when linking against -modules?\n")
  file(APPEND ${_laname} "shouldnotlink=${_target_shouldnotlink}\n\n")
  file(APPEND ${_laname} "# Files to dlopen/dlpreopen\n")
  file(APPEND ${_laname} "dlopen='${_target_dlopen}'\n")
  file(APPEND ${_laname} "dlpreopen='${_target_dlpreopen}'\n\n")
  file(APPEND ${_laname} "# Directory that this library needs to be installed in:\n")
  file(APPEND ${_laname} "libdir='${CMAKE_INSTALL_PREFIX}${_install_DIR}'\n")
#  INSTALL( FILES ${_laname} ${_soname}  DESTINATION ${CMAKE_INSTALL_PREFIX}${_install_DIR})
  install( FILES ${_laname} DESTINATION ${CMAKE_INSTALL_PREFIX}${_install_DIR})
endmacro(CREATE_LIBTOOL_FILE)
