#!/usr/bin/perl

package eBay::API::XML::Call::SetPromotionalSaleListings;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetPromotionalSaleListings.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetPromotionalSaleListings

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetPromotionalSaleListings inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::SetPromotionalSaleListings::SetPromotionalSaleListingsRequestType;
use eBay::API::XML::Call::SetPromotionalSaleListings::SetPromotionalSaleListingsResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'SetPromotionalSaleListings';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::SetPromotionalSaleListings::SetPromotionalSaleListingsRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::SetPromotionalSaleListings::SetPromotionalSaleListingsResponseType';
}

#
# input properties
#

=head2 setAction()

You must specify either Add or Delete.
This field determines whether you are adding listings to,
or deleting listings from,
the promotional sale you specify in the PromotionalSaleID field.
If you specify Delete, you must specify
PromotionalSaleItemIDArray. Delete is applicable only in 
cases where you specify PromotionalSaleItemIDArray.
Auction or auction/BIN format listings cannot be added to or deleted 
from a promotional sale if the item has bids.

  RequiredInput: Yes
  OnlyTheseValues: Add, Delete
#    Argument: 'ns:ModifyActionCodeType'

=cut
       
sub setAction {
   my $self   = shift;
   my $sAction = shift;
   $self->getRequestDataType()->setAction($sAction);
}

=head2 setAllAuctionItems()

Adds to the promotional sale all the seller's item listings 
that are auction items. Auction and auction/BIN format listings
can be added to free shipping sales only. 
Requires that you specify Add in the Action field.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setAllAuctionItems {
   my $self   = shift;
   my $sAllAuctionItems = shift;
   $self->getRequestDataType()->setAllAuctionItems($sAllAuctionItems);
}

=head2 setAllFixedPriceItems()

Adds to the promotional sale all the seller's item listings 
that are fixed price items.
Requires that you specify Add in the Action field.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setAllFixedPriceItems {
   my $self   = shift;
   my $sAllFixedPriceItems = shift;
   $self->getRequestDataType()->setAllFixedPriceItems($sAllFixedPriceItems);
}

=head2 setAllStoreInventoryItems()

Adds to the promotional sale all the seller's item listings 
that are store inventory items.
Requires that you specify Add in the Action field.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setAllStoreInventoryItems {
   my $self   = shift;
   my $sAllStoreInventoryItems = shift;
   $self->getRequestDataType()->setAllStoreInventoryItems($sAllStoreInventoryItems);
}

=head2 setCategoryID()

Adds to the promotional sale all the seller's item listings with
the CategoryID specified in this field. 
Requires that you specify Add in the Action field.

  RequiredInput: No
#    Argument: 'xs:long'

=cut
       
sub setCategoryID {
   my $self   = shift;
   my $sCategoryID = shift;
   $self->getRequestDataType()->setCategoryID($sCategoryID);
}

=head2 setPromotionalSaleID()

The ID of the promotional sale that you want to add listings to or
delete listings from.

  RequiredInput: Yes
#    Argument: 'xs:long'

=cut
       
sub setPromotionalSaleID {
   my $self   = shift;
   my $sPromotionalSaleID = shift;
   $self->getRequestDataType()->setPromotionalSaleID($sPromotionalSaleID);
}

=head2 setPromotionalSaleItemIDArray()

The IDs of the item listings to be affected
by the action you specify in the Action field.

  RequiredInput: Conditionally
#    Argument: 'ns:ItemIDArrayType'

=cut
       
sub setPromotionalSaleItemIDArray {
   my $self   = shift;
   my $pPromotionalSaleItemIDArray = shift;
   $self->getRequestDataType()->setPromotionalSaleItemIDArray($pPromotionalSaleItemIDArray);
}

=head2 setStoreCategoryID()

Adds to the promotional sale all the seller's item listings with
the StoreCategoryID specified in this field.
Requires that you specify Add in the Action field.

  RequiredInput: No
#    Argument: 'xs:long'

=cut
       
sub setStoreCategoryID {
   my $self   = shift;
   my $sStoreCategoryID = shift;
   $self->getRequestDataType()->setStoreCategoryID($sStoreCategoryID);
}



#
# output properties
#

=head2 getStatus()

Contains the status of a promotional sale.

  Returned: Always
#    Returns: 'ns:PromotionalSaleStatusCodeType'

=cut
       
sub getStatus {
   my $self = shift;
   return $self->getResponseDataType()->getStatus();
}





1;   
