## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::dns::record::mx;

our $DATE = '2024-06-26'; # DATE
our $VERSION = '0.003'; # VERSION

our $rschema = do{my$var={base=>"hash",clsets_after_base=>[{keys=>{name=>["str",{req=>1}],ttl=>["uint",{}],type=>["str",{match=>"\\A(?:[A-Z]([A-Z0-9]+|[A-Z0-9-]*[A-Z0-9])?|\\*)\\z",req=>1}]},"keys.restrict"=>0,req_keys=>["name","type"],summary=>"DNS record structure"},{"keys.restrict"=>1,"merge.add.req_keys"=>["host","prio"],"merge.normal.keys"=>{host=>["net::hostname",{req=>1}],name=>["dns::record_field::name::disallow_underscore"],priority=>["uint",{req=>1}],type=>["str",{is=>"MX",req=>1}]},summary=>"DNS MX record"}],clsets_after_type=>['$var->{clsets_after_base}[0]','$var->{clsets_after_base}[1]'],"clsets_after_type.alt.merge.merged"=>[{keys=>{host=>'$var->{clsets_after_base}[1]{"merge.normal.keys"}{host}',name=>["dns::record_field::name::disallow_underscore",'$var->{clsets_after_base}[0]{keys}{name}[1]'],priority=>'$var->{clsets_after_base}[1]{"merge.normal.keys"}{priority}',ttl=>'$var->{clsets_after_base}[0]{keys}{ttl}',type=>["str",{is=>"MX",match=>"\\A(?:[A-Z]([A-Z0-9]+|[A-Z0-9-]*[A-Z0-9])?|\\*)\\z",req=>1}]},"keys.restrict"=>1,req_keys=>["name","type","host","prio"],summary=>"DNS MX record"}],resolve_path=>["hash","dns::record"],type=>"hash",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{clsets_after_type}[1]=$var->{clsets_after_base}[1];$var->{"clsets_after_type.alt.merge.merged"}[0]{keys}{host}=$var->{clsets_after_base}[1]{"merge.normal.keys"}{host};$var->{"clsets_after_type.alt.merge.merged"}[0]{keys}{name}[1]=$var->{clsets_after_base}[0]{keys}{name}[1];$var->{"clsets_after_type.alt.merge.merged"}[0]{keys}{priority}=$var->{clsets_after_base}[1]{"merge.normal.keys"}{priority};$var->{"clsets_after_type.alt.merge.merged"}[0]{keys}{ttl}=$var->{clsets_after_base}[0]{keys}{ttl};$var};

1;
# ABSTRACT: DNS MX record

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::dns::record::mx - DNS MX record

=head1 VERSION

This document describes version 0.003 of Sah::SchemaR::dns::record::mx (from Perl distribution Sah-SchemaBundle-DNS), released on 2024-06-26.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::SchemaBundle during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-SchemaBundle-DNS>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-SchemaBundle-DNS>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2019 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-SchemaBundle-DNS>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
