# NAME

Log::Any::Adapter::MacOS::OSLog - log to macOS' unified logging system

# VERSION

version 0.0.6

# SYNOPSIS

    use Log::Any::Adapter ('MacOS::OSLog',
      subsystem => 'com.example.foo',
    );

    # or

    use Log::Any::Adapter;
    Log::Any::Adapter->set('MacOS::OSLog',
      subsystem => 'org.example.bar',
    );

    # You can override defaults:
    Log::Any::Adapter->set('MacOS::OSLog',
      subsystem   => 'net.example.baz',
      os_category => 'secret',
      private     => 1,
    );

# DESCRIPTION

This [Log::Any](https://metacpan.org/pod/Log%3A%3AAny) adapter lets Perl applications log directly to macOS'
[unified logging system](https://developer.apple.com/documentation/os/logging)
using FFI and C wrappers--no Swift required.

To send log entries easily from the command line, a `maclog` utility
script is also included in this distribution.

# METHODS

## init

This method is not called directly, but rather is passed named arguments
as a hash when setting a [Log::Any::Adapter](https://metacpan.org/pod/Log%3A%3AAny%3A%3AAdapter).

Note that you can override the adapter and its parameters at runtime
using ["set" in Log::Any::Adapter](https://metacpan.org/pod/Log%3A%3AAny%3A%3AAdapter#set). This is useful if you want to change
the `subsystem`, `os_category`, or other options after the environment
has already selected the adapter, such as by using the
`LOG_ANY_DEFAULT_ADAPTER` environment variable.

- subsystem

    This must be a reversed fully-qualified domain name (FQDN), as required
    by macOS unified logging. If not provided, it defaults to
    `com.example.perl` to ensure a valid identifier is always
    present. You **should** set a meaningful name unique to your project,
    (e.g., `com.mydomain.myapp`) so that your log messages may be easily
    identified and filtered in Console.app or with `log show`.

- log\_level, min\_level, level

    These are all synonymous and strings that set the minimum logging level
    for the adapter. Whatever level is set, messages for that level and
    above will be logged.

    Defaults to `trace` and is affected by various
    [environment variables](#configuration-and-environment).

- os\_category

    Not to be confused with [Log::Any categories](https://metacpan.org/pod/Log%3A%3AAny#CATEGORIES),
    this value is used to categorize log entries within the macOS unified
    log. If not provided, it defaults to the same category name that
    [Log::Any](https://metacpan.org/pod/Log%3A%3AAny) uses for the current logger.

    You may override this to further distinguish different components of
    your application, but in most cases the default will be sufficient.

- private

    Optional, defaults to false. A Boolean value indicating whether logged
    messages should be redacted in the macOS unified logging system.

## [Log::Any](https://metacpan.org/pod/Log%3A%3AAny) methods

The following [Log::Any](https://metacpan.org/pod/Log%3A%3AAny) methods are mapped to macOS [os\_log(3)](http://man.he.net/man3/os_log)
functions as follows:

- trace: [os\_log\_debug(3)](http://man.he.net/man3/os_log_debug)
- debug: [os\_log\_debug(3)](http://man.he.net/man3/os_log_debug)
- info (or inform): [os\_log\_info(3)](http://man.he.net/man3/os_log_info)
- notice: [os\_log\_info(3)](http://man.he.net/man3/os_log_info)
- warning: [os\_log\_fault(3)](http://man.he.net/man3/os_log_fault)
- error (or err): [os\_log\_error(3)](http://man.he.net/man3/os_log_error)
- critical (or crit or fatal): [os\_log(3)](http://man.he.net/man3/os_log)
- alert: [os\_log(3)](http://man.he.net/man3/os_log)
- emergency: [os\_log(3)](http://man.he.net/man3/os_log)

Formatted methods like `infof`, `errorf`, etc., are supported via
[Log::Any](https://metacpan.org/pod/Log%3A%3AAny)'s standard interface.

# DIAGNOSTICS

Using this adapter without specifying a properly-formatted `subsystem`
argument will throw an exception.

# CONFIGURATION AND ENVIRONMENT

Configure the same as [Log::Any](https://metacpan.org/pod/Log%3A%3AAny).

The following environment variables can set the logging level if no
level is set on the adapter itself:

- `TRACE` sets the minimum level to **trace**
- `DEBUG` sets the minimum level to **debug**
- `VERBOSE` sets the minimum level to **info**
- `QUIET` sets the minimum level to **error**

In addition, the `LOG_LEVEL` environment variable may be set to a
string indicating the desired logging level.

# DEPENDENCIES

- [Log::Any::Adapter::Base](https://metacpan.org/pod/Log%3A%3AAny%3A%3AAdapter%3A%3ABase)
- [Log::Any::Adapter::Util](https://metacpan.org/pod/Log%3A%3AAny%3A%3AAdapter%3A%3AUtil)
- [FFI::Platypus](https://metacpan.org/pod/FFI%3A%3APlatypus) 2.00 or greater
- [namespace::autoclean](https://metacpan.org/pod/namespace%3A%3Aautoclean)

# INCOMPATIBILITIES

Because this module relies on the macOS unified logging system
introduced in macOS Sierra version 10.12, it is incompatible with
earlier versions of OS X, Mac OS X, the classic Mac OS, and all other
non-Apple platforms (Microsoft Windows, Linux, other Unixes, etc.).

It could conceivably be built and run on Apple iOS, iPadOS, tvOS, and
watchOS, but you'd have to build and deploy a native version of Perl
itself on those systems.

# BUGS AND LIMITATIONS

Undoubtedly. Open an issue in the tracker.

# SEE ALSO

- `maclog`, a utility script included in this distribution,
        used to send log entries easily from the command line or other
        scripts
- For a full write-up on the rationale, implementation, and
        integration details, see
        [the blog post](https://phoenixtrap.com/2025/08/10/perl-macos-oslog).
- Apple's [unified logging system developer documentation](https://developer.apple.com/documentation/os/logging)
- Apple's [OSLog developer documentation](https://developer.apple.com/documentation/OSLog)
- The Eclectic Light Company's
        [explainer on macOS logs](https://eclecticlight.co/2021/09/27/explainer-logs/)
- The Eclectic Light Company's
        [explainer on macOS subsystem identifiers](https://eclecticlight.co/2022/08/27/explainer-subsystems/)

# SUPPORT

## Perldoc

You can find documentation for this module with the perldoc command.

    perldoc Log::Any::Adapter::MacOS::OSLog

## Websites

The following websites have more information about this module, and may be of help to you. As always,
in addition to those websites please use your favorite search engine to discover more resources.

- MetaCPAN

    A modern, open-source CPAN search engine, useful to view POD in HTML format.

    [https://metacpan.org/release/Log-Any-Adapter-MacOS-OSLog](https://metacpan.org/release/Log-Any-Adapter-MacOS-OSLog)

- RT: CPAN's Bug Tracker

    The RT ( Request Tracker ) website is the default bug/issue tracking system for CPAN.

    [https://rt.cpan.org/Public/Dist/Display.html?Name=Log-Any-Adapter-MacOS-OSLog](https://rt.cpan.org/Public/Dist/Display.html?Name=Log-Any-Adapter-MacOS-OSLog)

- CPANTS

    The CPANTS is a website that analyzes the Kwalitee ( code metrics ) of a distribution.

    [http://cpants.cpanauthors.org/dist/Log-Any-Adapter-MacOS-OSLog](http://cpants.cpanauthors.org/dist/Log-Any-Adapter-MacOS-OSLog)

- CPAN Testers

    The CPAN Testers is a network of smoke testers who run automated tests on uploaded CPAN distributions.

    [http://www.cpantesters.org/distro/L/Log-Any-Adapter-MacOS-OSLog](http://www.cpantesters.org/distro/L/Log-Any-Adapter-MacOS-OSLog)

- CPAN Testers Matrix

    The CPAN Testers Matrix is a website that provides a visual overview of the test results for a distribution on various Perls/platforms.

    [http://matrix.cpantesters.org/?dist=Log-Any-Adapter-MacOS-OSLog](http://matrix.cpantesters.org/?dist=Log-Any-Adapter-MacOS-OSLog)

- CPAN Testers Dependencies

    The CPAN Testers Dependencies is a website that shows a chart of the test results of all dependencies for a distribution.

    [http://deps.cpantesters.org/?module=Log::Any::Adapter::MacOS::OSLog](http://deps.cpantesters.org/?module=Log::Any::Adapter::MacOS::OSLog)

## Bugs / Feature Requests

Please report any bugs or feature requests through the web interface at [https://codeberg.org/mjgardner/perl-Log-Any-Adapter-MacOS-OSLog/issues](https://codeberg.org/mjgardner/perl-Log-Any-Adapter-MacOS-OSLog/issues).

## Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

[https://codeberg.org/mjgardner/perl-Log-Any-Adapter-MacOS-OSLog](https://codeberg.org/mjgardner/perl-Log-Any-Adapter-MacOS-OSLog)

    git clone https://codeberg.org/mjgardner/perl-Log-Any-Adapter-MacOS-OSLog.git

# AUTHOR

Mark Gardner <mjgardner@cpan.org>

# COPYRIGHT AND LICENSE

This software is copyright (c) 2025 by Mark Gardner.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.
