package IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService;
# ABSTRACT: APIService represents a server for a particular GroupVersion. Name must be "version.group".
our $VERSION = '1.006';
use IO::K8s::APIObject;


k8s spec => 'KubeAggregator::V1::APIServiceSpec';


k8s status => 'KubeAggregator::V1::APIServiceStatus';


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService - APIService represents a server for a particular GroupVersion. Name must be "version.group".

=head1 VERSION

version 1.006

=head1 DESCRIPTION

APIService represents a server for a particular GroupVersion. Name must be "version.group".

This is a Kubernetes API object. See L<IO::K8s::Role::APIObject> for
C<metadata>, C<api_version()>, and C<kind()>.

=head2 spec

Spec contains information for locating and communicating with a server

=head2 status

Status contains derived information about an API server

=head1 SUPPORT

=head2 Issues

Please report bugs and feature requests on GitHub at
L<https://github.com/pplu/io-k8s-p5/issues>.

=head2 IRC

Join C<#kubernetes> on C<irc.perl.org> or message Getty directly.

=head1 CONTRIBUTING

Contributions are welcome! Please fork the repository and submit a pull request.

=head1 AUTHORS

=over 4

=item *

Torsten Raudssus <torsten@raudssus.de>

=item *

Jose Luis Martinez <jlmartin@cpan.org> (original author, inactive)

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Jose Luis Martinez.

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut
